package com.phonepe.intent.sdk.contracts;

import com.phonepe.intent.sdk.models.UrlConfig;

/**
 * @author TheEternalWitness
 * @since 31/03/18.
 */
public interface iBridgeCallback {
    /**
     * Interface contract to class which establishes bridge to Javascript
     *
     * @param callback Javascript callback name
     * @param error    Error body if any
     * @param response
     * @param context
     * @param body
     */
    void onBridgeCallBack(String callback, String error, String response, String context, String body);

    void onComplete(String val);

    void onJSLoadStateChanged(String context, String isJSLoaded, String callback);

    void showLoader(String context, String showLoader, String callback);

    //*********************************************************************
    // Related to saving and restoring instance states
    //*********************************************************************

    void keepUrl(UrlConfig urlConfig);

}
