package com.phonepe.intent.sdk.bridges;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.webkit.JavascriptInterface;

import com.phonepe.intent.sdk.contracts.iBridgeCallback;
import com.phonepe.intent.sdk.contracts.iPermissionsReceived;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.models.Body;
import com.phonepe.intent.sdk.models.PermissionData;
import com.phonepe.intent.sdk.models.PermissionsBody;
import com.phonepe.intent.sdk.models.PermissionsObject;
import com.phonepe.intent.sdk.ui.BaseWebActivity;
import com.phonepe.intent.sdk.utils.Constants;

import java.util.List;

/**
 * @author Suman PPE
 * @since 09/06/17.
 */
public class PermissionsHandler implements iPermissionsReceived, ObjectFactoryInitializationStrategy {

    public static final String TAG = "PermissionManager";
    public static final int JS_PERMISSIONS = 1011;
    public static final String PERMISSION_NOT_GRANTED = "PERMISSION_NOT_GRANTED";
    private Activity activity;
    private iBridgeCallback bridgeCallback;
    private String jsContext;
    private String jsCallback;
    private ObjectFactory objectFactory;

    @JavascriptInterface
    public void seekPermissions(String context, String data, String callback) {
        this.jsContext = context;
        this.jsCallback = callback;
        PermissionData permissionData = PermissionData.fromJsonString(data, this.objectFactory, PermissionData.class);
        List<String> permissionsList = permissionData.getPermissions();
        ActivityCompat.requestPermissions(this.activity,
                permissionsList.toArray(new String[permissionsList.size()]), JS_PERMISSIONS);

    }

    @JavascriptInterface
    public void seekPermission(String context, String data, String callback) {
        this.jsContext = context;
        this.jsCallback = callback;
        PermissionData permissionData = PermissionData.fromJsonString(data, this.objectFactory, PermissionData.class);
        List<String> permissionsList = permissionData.getPermission();
        ActivityCompat.requestPermissions(this.activity,
                permissionsList.toArray(new String[permissionsList.size()]), JS_PERMISSIONS);

    }

    @JavascriptInterface
    public void openSettingsPageForPermission(String context, String data, String callback) {
        Intent intent = new Intent();
        intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);

        Uri uri = Uri.fromParts("package", this.activity.getPackageName(), null);
        intent.setData(uri);
        this.activity.startActivity(intent);
    }

    @Override
    public void onPermissionReceived(String[] permission, int[] isPermissionReceived) {
        List<PermissionsObject> permissionsObjects = this.objectFactory.<PermissionsObject>getArrayList();
        for (int i = 0; i < isPermissionReceived.length; i++) {
            PermissionsObject singlePermission = this.objectFactory.<PermissionsObject>get(PermissionsObject.class);
            singlePermission.setPermissionType(permission[i]);
            singlePermission.setPermissionGranted((isPermissionReceived[i] == PackageManager.PERMISSION_GRANTED));
            singlePermission.setShouldShowRationale(ActivityCompat.shouldShowRequestPermissionRationale(this.activity, permission[i]));
            permissionsObjects.add(singlePermission);
        }
        Body<PermissionsBody> body = this.objectFactory.<Body>get(Body.class);
        PermissionsBody permissionsBody = this.objectFactory.<PermissionsBody>get(PermissionsBody.class);
        permissionsBody.setPermissions(permissionsObjects);
        body.setData(permissionsBody);
        this.bridgeCallback.onBridgeCallBack(this.jsCallback,
                null,
                this.objectFactory.getResponse(Constants.GenericConstants.SUCCESS).toJsonString(),
                this.jsContext,
                body.toJsonString());
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        this.activity = initializationBundle.<Activity>get(BaseWebActivity.ACTIVITY, null);
        this.bridgeCallback = initializationBundle.<iBridgeCallback>get(BaseWebActivity.BRIDGE_CALLBACK, null);
        this.objectFactory = objectFactory;
    }

    @Override
    public boolean isCachingAllowed() {
        return false;
    }
}
