package com.phonepe.intent.sdk.bridges;

import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import com.phonepe.intent.sdk.contracts.iNativeCardCallback;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.models.JusPayData;
import com.phonepe.intent.sdk.ui.BaseWebActivity;
import com.phonepe.intent.sdk.utils.GenericJSONUtils;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONException;
import org.json.JSONObject;

//import in.juspay.godel.analytics.GodelTracker;
//import in.juspay.juspaysafe.BrowserCallback;
//import in.juspay.juspaysafe.BrowserParams;

/**
 * @author Prasad Pai
 * @since 02/05/18.
 */
public class NativeCardHandler implements ObjectFactoryInitializationStrategy {

    public static final String TAG = "NativeCardHandler";
    private static final String USER_CANCELED = "USER_CANCELED";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String KEY_URL = "url";
    private iNativeCardCallback nativeCardCallback;
    private ObjectFactory objectFactory;

    @JavascriptInterface
    public void onCardTransaction(String context, final String mJsData, String callback) {
//        if (mJsData != null && mJsData.length() > 0 && this.nativeCardCallback != null) {
//            final JusPayData jusPayData;
//            try {
//                jusPayData = JusPayData.fromJson(mJsData);
//                if (jusPayData != null) {
//                    BrowserCallback callBack = new BrowserCallback() {
//                        @Override
//                        public void onTransactionAborted(JSONObject paymentDetails) {
//                            GodelTracker.getInstance().trackPaymentStatus(jusPayData.getTransactionId(), GodelTracker.CANCELLED);
//                            NativeCardHandler.this.nativeCardCallback.onJusPayTransactionCompleted(jusPayData.getTransactionId(), USER_CANCELED, false);
//                        }
//
//                        @Override
//                        public void endUrlReached(final WebView view, final JSONObject paymentDetails) {
//                            if (Looper.myLooper() != Looper.getMainLooper()) {
//                                new Handler(Looper.getMainLooper()).post(new Runnable() {
//                                    @Override
//                                    public void run() {
//                                        String status;
//                                        boolean isSuccess;
//                                        if (paymentDetails.has(KEY_URL)) {
//                                            try {
//                                                String url = paymentDetails.getString(KEY_URL);
//                                                String[] urlParts = url.split("/");
//                                                status = urlParts[urlParts.length - 1];
//                                                isSuccess = true;
//                                            } catch (JSONException e) {
//                                                SdkLogger.e(TAG, String.format("JsonException caught in endUrlReached. exception message = {%s}.", e.getMessage()), e);
//                                                status = UNKNOWN;
//                                                isSuccess = false;
//                                            }
//                                        } else {
//                                            status = UNKNOWN;
//                                            isSuccess = false;
//                                        }
//                                        GodelTracker.getInstance().trackPaymentStatus(jusPayData.getTransactionId(), status.matches(GodelTracker.SUCCESS) ?
//                                                GodelTracker.SUCCESS : GodelTracker.FAILURE);
//                                        NativeCardHandler.this.nativeCardCallback.onJusPayTransactionCompleted(jusPayData.getTransactionId(), status, isSuccess);
//                                    }
//                                });
//                            }
//                        }
//                    };
//                    BrowserParams browserParams = new BrowserParams();
//                    browserParams.setMerchantId(jusPayData.getJustPayMerchantId());
//                    browserParams.setClientId(jusPayData.getJustPayClientId());
//                    browserParams.setTransactionId(jusPayData.getTransactionId());
//                    browserParams.setUrl(jusPayData.getRedirectURL());
//                    browserParams.setAmount(jusPayData.getAmount());
//                    this.nativeCardCallback.startJustPay(browserParams, callBack, jusPayData.getEndUrls());
//                }
//            } catch (JSONException e) {
//                SdkLogger.e(TAG, String.format("json exception caught, exception message = {%s}.", e.getMessage()), e);
//                try {
//                    JSONObject jsonObject = new JSONObject(mJsData);
//                    String url = GenericJSONUtils.readString(jsonObject, JusPayData.KEY_REDIRECT_URL, true, true);
//                    this.nativeCardCallback.openUrlInWebView((url));
//                } catch (JSONException e1) {
//                    SdkLogger.e(TAG, String.format("json exception caught, exception message = {%s}.", e1.getMessage()), e1);
//                }
//
//
//            }
//        }
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

        this.objectFactory = objectFactory;
        this.nativeCardCallback = initializationBundle.<iNativeCardCallback>get(BaseWebActivity.NATIVE_CARD_CALL_BACK, null);
    }

    @Override
    public boolean isCachingAllowed() {
        return false;
    }
}
