package com.phonepe.intent.sdk.authandcapture.network.response;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;

public class AuthResponse extends DefaultJsonImpl {

    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";

    public Boolean getSuccess() {
        return get(KEY_SUCCESS);
    }

    public void setSuccess(@NonNull Boolean success) {
        put(KEY_SUCCESS, success);
    }

    public String getCode() {
        return get(KEY_CODE);
    }

    public void setCode(@NonNull String code) {
        put(KEY_CODE, code);
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }

    // TODO: find a better way of doing this
    public AuthResponseData getData() throws PhonePeInitException {
        return fromJsonString(get(KEY_DATA).toString(), PhonePe.getObjectFactory(), AuthResponseData.class);
    }

    public void setData(@NonNull JSONObject data){
        put(KEY_DATA, data);
    }

    public static class AuthResponseData extends DefaultJsonImpl{
        private static final String KEY_AMOUNT = "amount";
        private static final String KEY_TRANSACTION_ID = "transactionId";
        private static final String KEY_AUTH_TYPE = "authType";
        private static final String KEY_AUTH_STATE = "authState";

        public AuthType getAuthType() {
            return AuthType.valueOf(get(KEY_AUTH_TYPE).toString());
        }

        public void setAuthType(String authType) {
            put(KEY_AUTH_TYPE, authType);
        }

        public String getTransactionId() {
            return get(KEY_TRANSACTION_ID);
        }

        public void setTransactionId(@NonNull String transactionId) {
            put(KEY_TRANSACTION_ID, transactionId);
        }

        public Long getAmount() {
            return get(KEY_AMOUNT);
        }

        public void setAmount(Long amount) {
            put(KEY_AMOUNT, amount);
        }

        public AuthState getAuthState() {
            return AuthState.valueOf(get(KEY_AUTH_STATE).toString());
        }

        public void setAuthState(@NonNull String authState) {
            put(KEY_AUTH_STATE, authState);
        }

    }

}
