package com.phonepe.intent.sdk.authandcapture.network;

import android.util.Base64;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.authandcapture.network.request.AuthRequest;
import com.phonepe.intent.sdk.authandcapture.network.request.InstrumentScope;
import com.phonepe.intent.sdk.authandcapture.network.response.AuthResponse;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.networking.APIManager;
import com.phonepe.intent.sdk.networking.INetworkResponseListener;
import com.phonepe.intent.sdk.utils.CryptLib;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.UUID;

public class AuthCall {
    public static final String TAG = "AuthCall";
    ObjectFactory objectFactory;

    public void makeAuthCall() {
        //TODO: add builder
        try {
            objectFactory = PhonePe.getObjectFactory();
            AuthRequest authRequest = objectFactory.<AuthRequest>get(AuthRequest.class);
            authRequest.setAmount(200L);
            authRequest.setInstrumentScope(InstrumentScope.WALLET);
            authRequest.setTransactionId("auth149000");
            authRequest.setMerchantId("DREAM11ONLINE");
            authRequest.setMerchantOrderId("auth141100");
            authRequest.setUserAuthToken("DREAM11ONLINE62f0c2391d5c4e868a81fbb075c04db0");
            authRequest.setMessage("test");
            int keyIndex = 1;
            String key = "6ab539dc-6ace-48c5-b957-75cb408e4f29";
            String endPoint = "https://mercury-stg.phonepe.com/v3/auth/authorize";
            final APIManager apiManager = objectFactory.<APIManager>get(APIManager.class);
            final Map<String, String> headers = objectFactory.getHashMap();
            String payload = authRequest.toJsonString();
            String base64Payload = Base64.encodeToString(payload.getBytes("UTF-8"), Base64.NO_WRAP);
            String path = "/v3/auth/authorize";
            String checksum = getCheckSum(base64Payload, path, key);
            String sChecksumLimiter = "###";
            headers.put("X-VERIFY", checksum + sChecksumLimiter + keyIndex);
            headers.put("Content-Type","application/json");
            final JSONObject finalPayload = new JSONObject();
            finalPayload.put("request", base64Payload);
            SdkLogger.d(TAG, "payload  -> " + payload + "\n" + "base64Payload  -> " + finalPayload.toString() + "\n" + "X-VERIFY  -> " + checksum + sChecksumLimiter + keyIndex + "\n");
            apiManager.asyncPostRequest(endPoint, headers, finalPayload.toString(), new INetworkResponseListener() {
                @Override
                public void onSuccess(String response) {
                    AuthResponse authResponse = AuthResponse.fromJsonString(response, objectFactory, AuthResponse.class);
                    SdkLogger.d(TAG, String.format("AuthResponse status : {%s}", authResponse.getSuccess()));
                    // TODO: check authState and handle
                }

                @Override
                public void onFailure(int responseCode, String response) {
                    SdkLogger.e(TAG, String.format("AuthResponse ,responseCode = {%d}, response = {%s}", responseCode, response));
                }
            }, false);
        } catch (UnsupportedEncodingException | PhonePeInitException | JSONException e) {
            SdkLogger.e(TAG, "exception");
            e.printStackTrace();
        }
    }

    private String getCheckSum(String body, String endPoint, String salt) {
        try {
            CryptLib cryptLib = new CryptLib();
            byte[] hash = cryptLib.SHA256(body + endPoint + salt);
            StringBuffer hashtext = new StringBuffer();

            for (int i = 0; i < hash.length; i++) {
                String hex = Integer.toHexString(0xff & hash[i]);
                if (hex.length() == 1) hashtext.append('0');
                hashtext.append(hex);
            }
            // Uncomment this when you want to debug Checksum logic
            SdkLogger.d(TAG, "Body: "+body+"\nEndPoint: "+endPoint+"\nSalt: "+salt+"\nHashText:"+hashtext);
            return hashtext.toString();
        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
            return null;
        }
    }
}
