(ns pallet.executors-test
  (:require
   [clojure.test :refer [deftest is]]
   [pallet.api :refer [group-spec lift plan-fn]]
   [pallet.actions :refer [exec-script plan-when plan-when-not remote-file]]
   [pallet.executors :refer :all]
   [pallet.test-utils :refer [make-localhost-compute]]))


(defn run-plan-fn [f]
  (let [compute (make-localhost-compute :group-name "local")
        op (lift (group-spec "local")
                 :phase f
                 :compute compute
                 :environment {:algorithms
                               {:executor action-plan-printer}})]
    (-> @op :results first :result)))

(deftest print-action-plan-test
  (is (= '((pallet.actions-impl/remote-file-action
            "f"
            {:content "xxx",
             :install-new-files true,
             :overwrite-changes nil}))
         (run-plan-fn (plan-fn (remote-file "f" :content "xxx")))))
  (is (= '((pallet.actions-impl/if-action
            true
            (pallet.actions/exec-script* "f")
            nil))
         (run-plan-fn (plan-fn
                        (plan-when (= 1 1)
                          (exec-script "f"))))))
  (is (= '((pallet.actions-impl/if-action
            true
            nil
            (pallet.actions/exec-script* "g")))
         (run-plan-fn (plan-fn
                        (plan-when-not (= 1 1)
                          (exec-script "g")))))))
