(ns com.palletops.leaven
  "A component composition library."
       
           
                                                 
                                                    
                            
        
  (:require-macros
   [com.palletops.api-builder.api :refer [defn-api]])
        
  (:require
   [com.palletops.leaven.protocols :as protocols]
   [schema.core :as schema]))

(defn-api start
  "Start a component."
  {:sig [[schema/Any :- schema/Any]]}
  [component]
  (if (protocols/lifecycle? component)
    (protocols/start component)
    component))

(defn-api stop
  "Stop a component."
  {:sig [[schema/Any :- schema/Any]]}
  [component]
  (if (protocols/lifecycle? component)
    (protocols/stop component)
    component))

(defn-api status
  "Ask a component for its status."
  {:sig [[schema/Any :- schema/Any]]}
  [component]
  (if (protocols/status? component)
    (protocols/status component)))

(defn-api lifecycle?
  "Predicate for testing whether `x` satisfies the ILifecycle protocol."
  {:sig [[schema/Any :- schema/Any]]}
  [x]
  (protocols/lifecycle? x))

(defn-api status?
  "Predicate for testing whether `x` satisfies the IStatus protocol."
  {:sig [[schema/Any :- schema/Any]]}
  [x]
  (protocols/status? x))

(defn ^:internal apply-components
  "Execute a function on a sequence of components from a record.
  Exceptions are caught and propagate with a `:system` data element
  that contains the partially updated system component, a `:component`
  key that is the keyword for the component that caused the exception,
  and `:incomplete` which is a sequence of keywords for the components
  where the operation was not completed."
  [f rec sub-components operation-name]
  (loop [rec rec cs sub-components]
    (if-let [c (first cs)]
      (let [res (try
                  (update-in rec [c] f)
                  (catch        js/Error                 e
                         (throw
                          (ex-info
                           (str "Exception while " operation-name
                                " " c
                                " system sub-component.")
                           {:system rec
                            :component c
                            :sub-components sub-components
                            :completed (subvec sub-components
                                               0 (- (count sub-components)
                                                    (count cs)))
                            :uncompleted cs}
                           e))))]
        (recur res (rest cs)))
      rec)))

     
                         
                                                                    
                                                               
                                                                     
                                                                      
                                                                     
                        
                          
                                               
                            
                                                
                           
                            
                                                                    
                           
                                                                    
                        
                             
                                                                                

;;;;;;;;;;;; This file autogenerated from src/com/palletops/leaven.cljx
