(ns pallet.crate.git
  "Crate to install git."
  (:use
   [clojure.java.io :only [file]]
   [pallet.api :only [server-spec plan-fn]]
   [pallet.actions :only [exec-checked-script packages]]
   [pallet.crate :only [defplan]])
  (:require
   [clojure.string :as string]))

(defplan install-git
  "Install git"
  []
  (packages
   :yum ["git" "git-email"]
   :aptitude ["git-core" "git-email"]
   :apt ["git-core" "git-email"]
   :pacman ["git"]))

(defplan clone
  [repo & args]
  (let [repo-name
        (-> (java.net.URL. (string/replace repo "git:" "http:"))
            .getPath
            file
            .getName
            (string/replace #"\.git$" ""))]
    (exec-checked-script
     (str "Clone " repo "into" repo-name)
     (if (not (file-exists? ~(str repo-name "/.git/config")))
       ("git" clone ~@(or (seq args) [""]) ~repo)))))

(defn git
  [_]
  (server-spec
   :phases {:configure (plan-fn (install-git))}))
