(ns
 com.palletops.fleet.v1-alpha
 (:require
  [cheshire.core :as json]
  [clojure.java.io :as io]
  [com.palletops.api-builder.api :refer [defn-api]]
  [com.palletops.discovery.runtime :as runtime]
  [schema.core]))


(def Connection {:endpoint schema.core/Str})


(com.palletops.api-builder.api/defn-api
 connect
 "Return a connection map for the given endpoint"
 {:sig [[schema.core/Str :- Connection]]}
 [endpoint]
 {:endpoint endpoint})


(def
 Machine
 {(schema.core/optional-key :metadata) {schema.core/Keyword schema.core/Str},
  (schema.core/optional-key :primaryIP) schema.core/Str,
  :id schema.core/Str})


(def
 Machine-clj
 {(schema.core/optional-key :metadata) {schema.core/Keyword schema.core/Str},
  (schema.core/optional-key :primary-ip) schema.core/Str,
  :id schema.core/Str})


(def
 MachinePage
 {(schema.core/optional-key :nextPageToken) schema.core/Str,
  :machines [Machine]})


(def
 MachinePage-clj
 {(schema.core/optional-key :next-page-token) schema.core/Str,
  :machines [Machine]})


(def
 UnitOption
 {(schema.core/optional-key :value) schema.core/Str,
  :name schema.core/Str,
  :section schema.core/Str})


(def
 UnitOption-clj
 {(schema.core/optional-key :value) schema.core/Str,
  :name schema.core/Str,
  :section schema.core/Str})


(def
 Unit
 {:machineID schema.core/Str,
  :currentState schema.core/Str,
  :desiredState schema.core/Str,
  (schema.core/optional-key :options) [UnitOption],
  :name schema.core/Str})


(def
 Unit-clj
 {:machine-id schema.core/Str,
  :current-state schema.core/Str,
  :desired-state schema.core/Str,
  (schema.core/optional-key :options) [UnitOption],
  :name schema.core/Str})


(def
 UnitPage
 {(schema.core/optional-key :nextPageToken) schema.core/Str,
  :units [Unit]})


(def
 UnitPage-clj
 {(schema.core/optional-key :next-page-token) schema.core/Str,
  :units [Unit]})


(def
 UnitState
 {(schema.core/optional-key :systemdSubState) schema.core/Str,
  (schema.core/optional-key :systemdActiveState) schema.core/Str,
  (schema.core/optional-key :systemdLoadState) schema.core/Str,
  :machineID schema.core/Str,
  :hash schema.core/Str,
  :name schema.core/Str})


(def
 UnitState-clj
 {(schema.core/optional-key :systemd-sub-state) schema.core/Str,
  (schema.core/optional-key :systemd-active-state) schema.core/Str,
  (schema.core/optional-key :systemd-load-state) schema.core/Str,
  :machine-id schema.core/Str,
  :hash schema.core/Str,
  :name schema.core/Str})


(def
 UnitStatePage
 {(schema.core/optional-key :nextPageToken) schema.core/Str,
  :states [UnitState]})


(def
 UnitStatePage-clj
 {(schema.core/optional-key :next-page-token) schema.core/Str,
  :states [UnitState]})


(defn-api
 machine-list
 "Retrieve a page of Machine objects."
 {:sig [[Connection
         {(schema.core/optional-key :next-page-token) schema.core/Str}
         :-
         clojure.lang.IDeref]
        [Connection
         {(schema.core/optional-key :next-page-token) schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]
        [Connection
         {(schema.core/optional-key :next-page-token) schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         (schema.core/=>
          schema.core/Any
          {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]]}
 ([connection
   {:keys [:next-page-token], :as options}
   http-options
   callback]
  (runtime/request
   (clojure.core/merge
    http-options
    (clojure.core/merge
     {:method :get,
      :as :stream,
      :url (clojure.core/str
            (:endpoint connection)
            "/v1-alpha/"
            (clojure.core/-> "machines")),
      :query-params (clojure.core/let
                     [o__3953__auto__
                      (clojure.core/select-keys
                       options
                       [:next-page-token])]
                     (clojure.core/zipmap
                      (clojure.core/map
                       com.palletops.discovery.utils/kw->camel-kw
                       (clojure.core/keys o__3953__auto__))
                      (clojure.core/vals o__3953__auto__)))}
     nil))
   callback
   MachinePage))
 ([connection {:keys [:next-page-token], :as options} http-options]
  (machine-list connection options http-options clojure.core/identity))
 ([connection {:keys [:next-page-token], :as options}]
  (machine-list connection options nil clojure.core/identity)))


(defn-api
 unit-list
 "Retrieve a page of Unit objects."
 {:sig [[Connection
         {(schema.core/optional-key :next-page-token) schema.core/Str}
         :-
         clojure.lang.IDeref]
        [Connection
         {(schema.core/optional-key :next-page-token) schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]
        [Connection
         {(schema.core/optional-key :next-page-token) schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         (schema.core/=>
          schema.core/Any
          {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]]}
 ([connection
   {:keys [:next-page-token], :as options}
   http-options
   callback]
  (runtime/request
   (clojure.core/merge
    http-options
    (clojure.core/merge
     {:method :get,
      :as :stream,
      :url (clojure.core/str
            (:endpoint connection)
            "/v1-alpha/"
            (clojure.core/-> "units")),
      :query-params (clojure.core/let
                     [o__3953__auto__
                      (clojure.core/select-keys
                       options
                       [:next-page-token])]
                     (clojure.core/zipmap
                      (clojure.core/map
                       com.palletops.discovery.utils/kw->camel-kw
                       (clojure.core/keys o__3953__auto__))
                      (clojure.core/vals o__3953__auto__)))}
     nil))
   callback
   UnitPage))
 ([connection {:keys [:next-page-token], :as options} http-options]
  (unit-list connection options http-options clojure.core/identity))
 ([connection {:keys [:next-page-token], :as options}]
  (unit-list connection options nil clojure.core/identity)))


(defn-api
 unit-get
 "Retrieve a single Unit object."
 {:sig [[Connection
         {:unit-name schema.core/Str}
         :-
         clojure.lang.IDeref]
        [Connection
         {:unit-name schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]
        [Connection
         {:unit-name schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         (schema.core/=>
          schema.core/Any
          {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]]}
 ([connection {:keys [:unit-name], :as options} http-options callback]
  (runtime/request
   (clojure.core/merge
    http-options
    (clojure.core/merge
     {:method :get,
      :as :stream,
      :url (clojure.core/str
            (:endpoint connection)
            "/v1-alpha/"
            (clojure.core/->
             "units/{unitName}"
             (clojure.string/replace "{unitName}" unit-name))),
      :query-params (clojure.core/let
                     [o__3953__auto__
                      (clojure.core/select-keys options [])]
                     (clojure.core/zipmap
                      (clojure.core/map
                       com.palletops.discovery.utils/kw->camel-kw
                       (clojure.core/keys o__3953__auto__))
                      (clojure.core/vals o__3953__auto__)))}
     nil))
   callback
   Unit))
 ([connection {:keys [:unit-name], :as options} http-options]
  (unit-get connection options http-options clojure.core/identity))
 ([connection {:keys [:unit-name], :as options}]
  (unit-get connection options nil clojure.core/identity)))


(defn-api
 unit-delete
 "Delete the referenced Unit object."
 {:sig [[Connection
         {:unit-name schema.core/Str}
         :-
         clojure.lang.IDeref]
        [Connection
         {:unit-name schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]
        [Connection
         {:unit-name schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         (schema.core/=>
          schema.core/Any
          {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]]}
 ([connection {:keys [:unit-name], :as options} http-options callback]
  (runtime/request
   (clojure.core/merge
    http-options
    (clojure.core/merge
     {:method :delete,
      :as :stream,
      :url (clojure.core/str
            (:endpoint connection)
            "/v1-alpha/"
            (clojure.core/->
             "units/{unitName}"
             (clojure.string/replace "{unitName}" unit-name))),
      :query-params (clojure.core/let
                     [o__3953__auto__
                      (clojure.core/select-keys options [])]
                     (clojure.core/zipmap
                      (clojure.core/map
                       com.palletops.discovery.utils/kw->camel-kw
                       (clojure.core/keys o__3953__auto__))
                      (clojure.core/vals o__3953__auto__)))}
     nil))
   callback
   (schema.core/eq nil)))
 ([connection {:keys [:unit-name], :as options} http-options]
  (unit-delete connection options http-options clojure.core/identity))
 ([connection {:keys [:unit-name], :as options}]
  (unit-delete connection options nil clojure.core/identity)))


(defn-api
 unit-set
 "Create or update a Unit."
 {:sig [[Connection
         {:body Unit-clj, :unit-name schema.core/Str}
         :-
         clojure.lang.IDeref]
        [Connection
         {:body Unit-clj, :unit-name schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]
        [Connection
         {:body Unit-clj, :unit-name schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         (schema.core/=>
          schema.core/Any
          {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]]}
 ([connection
   {:keys [:unit-name :body], :as options}
   http-options
   callback]
  (runtime/request
   (clojure.core/merge
    http-options
    (clojure.core/merge
     {:method :put,
      :as :stream,
      :url (clojure.core/str
            (:endpoint connection)
            "/v1-alpha/"
            (clojure.core/->
             "units/{unitName}"
             (clojure.string/replace "{unitName}" unit-name))),
      :query-params (clojure.core/let
                     [o__3953__auto__
                      (clojure.core/select-keys options [])]
                     (clojure.core/zipmap
                      (clojure.core/map
                       com.palletops.discovery.utils/kw->camel-kw
                       (clojure.core/keys o__3953__auto__))
                      (clojure.core/vals o__3953__auto__)))}
     {:body ((runtime/key->camel-kw Unit-clj) (:body options))}))
   callback
   (schema.core/eq nil)))
 ([connection {:keys [:unit-name :body], :as options} http-options]
  (unit-set connection options http-options clojure.core/identity))
 ([connection {:keys [:unit-name :body], :as options}]
  (unit-set connection options nil clojure.core/identity)))


(defn-api
 unit-state-list
 "Retrieve a page of UnitState objects."
 {:sig [[Connection
         {(schema.core/optional-key :machine-id) schema.core/Str,
          (schema.core/optional-key :unit-name) schema.core/Str,
          (schema.core/optional-key :next-page-token) schema.core/Str}
         :-
         clojure.lang.IDeref]
        [Connection
         {(schema.core/optional-key :machine-id) schema.core/Str,
          (schema.core/optional-key :unit-name) schema.core/Str,
          (schema.core/optional-key :next-page-token) schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]
        [Connection
         {(schema.core/optional-key :machine-id) schema.core/Str,
          (schema.core/optional-key :unit-name) schema.core/Str,
          (schema.core/optional-key :next-page-token) schema.core/Str}
         (schema.core/maybe {schema.core/Keyword schema.core/Any})
         (schema.core/=>
          schema.core/Any
          {schema.core/Keyword schema.core/Any})
         :-
         clojure.lang.IDeref]]}
 ([connection
   {:keys [:next-page-token :unit-name :machine-id], :as options}
   http-options
   callback]
  (runtime/request
   (clojure.core/merge
    http-options
    (clojure.core/merge
     {:method :get,
      :as :stream,
      :url (clojure.core/str
            (:endpoint connection)
            "/v1-alpha/"
            (clojure.core/-> "state")),
      :query-params (clojure.core/let
                     [o__3953__auto__
                      (clojure.core/select-keys
                       options
                       [:next-page-token :unit-name :machine-id])]
                     (clojure.core/zipmap
                      (clojure.core/map
                       com.palletops.discovery.utils/kw->camel-kw
                       (clojure.core/keys o__3953__auto__))
                      (clojure.core/vals o__3953__auto__)))}
     nil))
   callback
   UnitStatePage))
 ([connection
   {:keys [:next-page-token :unit-name :machine-id], :as options}
   http-options]
  (unit-state-list
   connection
   options
   http-options
   clojure.core/identity))
 ([connection
   {:keys [:next-page-token :unit-name :machine-id], :as options}]
  (unit-state-list connection options nil clojure.core/identity)))


