// Compiled by ClojureScript 0.0-2277
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('schema.utils');
goog.require('schema.core');
goog.require('schema.core');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__14005__14006__auto__){var G__36231 = p1__14005__14006__auto__;if(G__36231)
{var bit__4191__auto__ = null;if(cljs.core.truth_((function (){var or__3541__auto__ = bit__4191__auto__;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return G__36231.schema$core$Schema$;
}
})()))
{return true;
} else
{if((!G__36231.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,G__36231);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,G__36231);
}
})], null));
plumbing.fnk.schema.InputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.MapOutputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
* Like (assert (distinct? things)) but with a more helpful error message.
*/
plumbing.fnk.schema.assert_distinct = (function assert_distinct(things){var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__36232_SHARP_){return (cljs.core.val.call(null,p1__36232_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));if(cljs.core.empty_QMARK_.call(null,repeated_things))
{return null;
} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
* Like (get m k), but throws if k is not present in m.
*/
plumbing.fnk.schema.safe_get = (function safe_get(m,k,key_path){if(cljs.core.map_QMARK_.call(null,m))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}
var vec__36234 = cljs.core.find.call(null,m,k);var _ = cljs.core.nth.call(null,vec__36234,(0),null);var v = cljs.core.nth.call(null,vec__36234,(1),null);var p = vec__36234;if(cljs.core.truth_(p))
{} else
{throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}
return v;
});
plumbing.fnk.schema.non_map_union = (function non_map_union(s1,s2){if(cljs.core._EQ_.call(null,s1,s2))
{return s1;
} else
{if(cljs.core._EQ_.call(null,s1,schema.core.Any))
{return s2;
} else
{if(cljs.core._EQ_.call(null,s2,schema.core.Any))
{return s1;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return schema.core.both.call(null,s1,s2);
} else
{return null;
}
}
}
}
});
/**
* Return a difference of schmas s1 and s2, where one is not a map.
* Punt for now, assuming s2 always satisfies s1.
*/
plumbing.fnk.schema.non_map_diff = (function non_map_diff(s1,s2){return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function map_schema_QMARK_(m){return ((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap));
});
var ufv___36240 = schema.utils.use_fn_validation;var output_schema36235_36241 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));var input_schema36236_36242 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"k","k",-505765866,null))], null);var input_checker36237_36243 = schema.core.checker.call(null,input_schema36236_36242);var output_checker36238_36244 = schema.core.checker.call(null,output_schema36235_36241);/**
* Inputs: [k]
* Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
* 
* Given a possibly-unevaluated schema map key form, unpack an explicit keyword
* and optional? flag, or return nil for a non-explicit key
*/
plumbing.fnk.schema.unwrap_schema_form_key = ((function (ufv___36240,output_schema36235_36241,input_schema36236_36242,input_checker36237_36243,output_checker36238_36244){
return (function unwrap_schema_form_key(G__36239){var validate__13975__auto__ = ufv___36240.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36245 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36239], null);var temp__4126__auto___36246 = input_checker36237_36243.call(null,args__13976__auto___36245);if(cljs.core.truth_(temp__4126__auto___36246))
{var error__13977__auto___36247 = temp__4126__auto___36246;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),cljs.core.pr_str.call(null,error__13977__auto___36247)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36236_36242,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36245,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36247], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var k = G__36239;while(true){
if(schema.core.specific_key_QMARK_.call(null,k))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else
{if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null))))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else
{return null;
}
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36248 = output_checker36238_36244.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36248))
{var error__13977__auto___36249 = temp__4126__auto___36248;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),cljs.core.pr_str.call(null,error__13977__auto___36249)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36235_36241,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36249], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36240,output_schema36235_36241,input_schema36236_36242,input_checker36237_36243,output_checker36238_36244))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema36235_36241,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36236_36242], null)));
var ufv___36255 = schema.utils.use_fn_validation;var output_schema36250_36256 = schema.core.Any;var input_schema36251_36257 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"s","s",-948495851,null))], null);var input_checker36252_36258 = schema.core.checker.call(null,input_schema36251_36257);var output_checker36253_36259 = schema.core.checker.call(null,output_schema36250_36256);/**
* Inputs: [s]
* 
* Given a possibly-unevaluated map schema, return a map from bare keyword to true
* (for required) or false (for optional)
*/
plumbing.fnk.schema.explicit_schema_key_map = ((function (ufv___36255,output_schema36250_36256,input_schema36251_36257,input_checker36252_36258,output_checker36253_36259){
return (function explicit_schema_key_map(G__36254){var validate__13975__auto__ = ufv___36255.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36260 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36254], null);var temp__4126__auto___36261 = input_checker36252_36258.call(null,args__13976__auto___36260);if(cljs.core.truth_(temp__4126__auto___36261))
{var error__13977__auto___36262 = temp__4126__auto___36261;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),cljs.core.pr_str.call(null,error__13977__auto___36262)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36251_36257,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36260,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36262], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var s = G__36254;while(true){
new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36263 = output_checker36253_36259.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36263))
{var error__13977__auto___36264 = temp__4126__auto___36263;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),cljs.core.pr_str.call(null,error__13977__auto___36264)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36250_36256,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36264], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36255,output_schema36250_36256,input_schema36251_36257,input_checker36252_36258,output_checker36253_36259))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema36250_36256,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36251_36257], null)));
var ufv___36270 = schema.utils.use_fn_validation;var output_schema36265_36271 = schema.core.Any;var input_schema36266_36272 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false),new cljs.core.Symbol(null,"s","s",-948495851,null))], null);var input_checker36267_36273 = schema.core.checker.call(null,input_schema36266_36272);var output_checker36268_36274 = schema.core.checker.call(null,output_schema36265_36271);/**
* Inputs: [s :- {s/Keyword s/Bool}]
* 
* Given output of explicit-schema-key-map, split into seq [req opt].
*/
plumbing.fnk.schema.split_schema_keys = ((function (ufv___36270,output_schema36265_36271,input_schema36266_36272,input_checker36267_36273,output_checker36268_36274){
return (function split_schema_keys(G__36269){var validate__13975__auto__ = ufv___36270.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36275 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36269], null);var temp__4126__auto___36276 = input_checker36267_36273.call(null,args__13976__auto___36275);if(cljs.core.truth_(temp__4126__auto___36276))
{var error__13977__auto___36277 = temp__4126__auto___36276;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),cljs.core.pr_str.call(null,error__13977__auto___36277)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36266_36272,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36275,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36277], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var s = G__36269;while(true){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36278 = output_checker36268_36274.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36278))
{var error__13977__auto___36279 = temp__4126__auto___36278;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),cljs.core.pr_str.call(null,error__13977__auto___36279)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36265_36271,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36279], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36270,output_schema36265_36271,input_schema36266_36272,input_checker36267_36273,output_checker36268_36274))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema36265_36271,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36266_36272], null)));
/**
* Like merge-with, but also projects keys to a smaller space and merges them similar to the
* values.
* @param {...*} var_args
*/
plumbing.fnk.schema.merge_on_with = (function() { 
var merge_on_with__delegate = function (key_project,key_combine,val_combine,maps){return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__36283){var vec__36284 = p__36283;var k = cljs.core.nth.call(null,vec__36284,(0),null);var v = cljs.core.nth.call(null,vec__36284,(1),null);var pk = key_project.call(null,k);var temp__4124__auto__ = cljs.core.get.call(null,m,pk);if(cljs.core.truth_(temp__4124__auto__))
{var vec__36285 = temp__4124__auto__;var ok = cljs.core.nth.call(null,vec__36285,(0),null);var ov = cljs.core.nth.call(null,vec__36285,(1),null);return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else
{return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
};
var merge_on_with = function (key_project,key_combine,val_combine,var_args){
var maps = null;if (arguments.length > 3) {
  maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return merge_on_with__delegate.call(this,key_project,key_combine,val_combine,maps);};
merge_on_with.cljs$lang$maxFixedArity = 3;
merge_on_with.cljs$lang$applyTo = (function (arglist__36286){
var key_project = cljs.core.first(arglist__36286);
arglist__36286 = cljs.core.next(arglist__36286);
var key_combine = cljs.core.first(arglist__36286);
arglist__36286 = cljs.core.next(arglist__36286);
var val_combine = cljs.core.first(arglist__36286);
var maps = cljs.core.rest(arglist__36286);
return merge_on_with__delegate(key_project,key_combine,val_combine,maps);
});
merge_on_with.cljs$core$IFn$_invoke$arity$variadic = merge_on_with__delegate;
return merge_on_with;
})()
;
var ufv___36294 = schema.utils.use_fn_validation;var output_schema36288_36295 = plumbing.fnk.schema.InputSchema;var input_schema36289_36296 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"i1","i1",-572470430,null)),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"i2","i2",850408895,null))], null);var input_checker36290_36297 = schema.core.checker.call(null,input_schema36289_36296);var output_checker36291_36298 = schema.core.checker.call(null,output_schema36288_36295);/**
* Inputs: [i1 :- InputSchema i2 :- InputSchema]
* Returns: InputSchema
* 
* Returns a minimal input schema schema that entails satisfaction of both s1 and s2
*/
plumbing.fnk.schema.union_input_schemata = ((function (ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298){
return (function union_input_schemata(G__36292,G__36293){var validate__13975__auto__ = ufv___36294.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36299 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36292,G__36293], null);var temp__4126__auto___36300 = input_checker36290_36297.call(null,args__13976__auto___36299);if(cljs.core.truth_(temp__4126__auto___36300))
{var error__13977__auto___36301 = temp__4126__auto___36300;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),cljs.core.pr_str.call(null,error__13977__auto___36301)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36289_36296,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36299,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36301], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var i1 = G__36292;var i2 = G__36293;while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__13975__auto__,ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298){
return (function (p1__36287_SHARP_){if(schema.core.specific_key_QMARK_.call(null,p1__36287_SHARP_))
{return schema.core.explicit_schema_key.call(null,p1__36287_SHARP_);
} else
{return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__13975__auto__,ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298))
,((function (validate__13975__auto__,ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298){
return (function (k1,k2){if(schema.core.required_key_QMARK_.call(null,k1))
{return k1;
} else
{if(schema.core.required_key_QMARK_.call(null,k2))
{return k2;
} else
{if(schema.core.optional_key_QMARK_.call(null,k1))
{if(cljs.core._EQ_.call(null,k1,k2))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"k1","k1",-1701777341,null),new cljs.core.Symbol(null,"k2","k2",-1225133949,null)))))));
}
return k1;
} else
{if(cljs.core._EQ_.call(null,k1,k2))
{return k1;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{if(false)
{return null;
} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));
}
} else
{return null;
}
}
}
}
}
});})(validate__13975__auto__,ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298))
,((function (validate__13975__auto__,ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298){
return (function (s1,s2){if((plumbing.fnk.schema.map_schema_QMARK_.call(null,s1)) && (plumbing.fnk.schema.map_schema_QMARK_.call(null,s2)))
{return union_input_schemata.call(null,s1,s2);
} else
{return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__13975__auto__,ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298))
,i1,i2);
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36302 = output_checker36291_36298.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36302))
{var error__13977__auto___36303 = temp__4126__auto___36302;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),cljs.core.pr_str.call(null,error__13977__auto___36303)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36288_36295,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36303], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36294,output_schema36288_36295,input_schema36289_36296,input_checker36290_36297,output_checker36291_36298))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema36288_36295,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36289_36296], null)));
var ufv___36309 = schema.utils.use_fn_validation;var output_schema36304_36310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);var input_schema36305_36311 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null))], null);var input_checker36306_36312 = schema.core.checker.call(null,input_schema36305_36311);var output_checker36307_36313 = schema.core.checker.call(null,output_schema36304_36310);/**
* Inputs: [input-schema :- InputSchema]
* Returns: [s/Keyword]
* 
* Which top-level keys are required (i.e., non-false) by this input schema.
*/
plumbing.fnk.schema.required_toplevel_keys = ((function (ufv___36309,output_schema36304_36310,input_schema36305_36311,input_checker36306_36312,output_checker36307_36313){
return (function required_toplevel_keys(G__36308){var validate__13975__auto__ = ufv___36309.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36314 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36308], null);var temp__4126__auto___36315 = input_checker36306_36312.call(null,args__13976__auto___36314);if(cljs.core.truth_(temp__4126__auto___36315))
{var error__13977__auto___36316 = temp__4126__auto___36315;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),cljs.core.pr_str.call(null,error__13977__auto___36316)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36305_36311,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36314,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36316], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var input_schema = G__36308;while(true){
return cljs.core.keep.call(null,((function (validate__13975__auto__,ufv___36309,output_schema36304_36310,input_schema36305_36311,input_checker36306_36312,output_checker36307_36313){
return (function (k){if(schema.core.required_key_QMARK_.call(null,k))
{return schema.core.explicit_schema_key.call(null,k);
} else
{return null;
}
});})(validate__13975__auto__,ufv___36309,output_schema36304_36310,input_schema36305_36311,input_checker36306_36312,output_checker36307_36313))
,cljs.core.keys.call(null,input_schema));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36317 = output_checker36307_36313.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36317))
{var error__13977__auto___36318 = temp__4126__auto___36317;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),cljs.core.pr_str.call(null,error__13977__auto___36318)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36304_36310,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36318], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36309,output_schema36304_36310,input_schema36305_36311,input_checker36306_36312,output_checker36307_36313))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema36304_36310,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36305_36311], null)));
/**
* Guess an output schema for an expr.  Currently just looks for literal map structure and
* all keyword keys.
*/
plumbing.fnk.schema.guess_expr_output_schema = (function guess_expr_output_schema(expr){if((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr))))
{return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = (function iter__36327(s__36328){return (new cljs.core.LazySeq(null,(function (){var s__36328__$1 = s__36328;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36328__$1);if(temp__4126__auto__)
{var s__36328__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36328__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36328__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36330 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36329 = (0);while(true){
if((i__36329 < size__4265__auto__))
{var vec__36333 = cljs.core._nth.call(null,c__4264__auto__,i__36329);var k = cljs.core.nth.call(null,vec__36333,(0),null);var v = cljs.core.nth.call(null,vec__36333,(1),null);cljs.core.chunk_append.call(null,b__36330,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,guess_expr_output_schema.call(null,v)], null));
{
var G__36335 = (i__36329 + (1));
i__36329 = G__36335;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36330),iter__36327.call(null,cljs.core.chunk_rest.call(null,s__36328__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36330),null);
}
} else
{var vec__36334 = cljs.core.first.call(null,s__36328__$2);var k = cljs.core.nth.call(null,vec__36334,(0),null);var v = cljs.core.nth.call(null,vec__36334,(1),null);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,guess_expr_output_schema.call(null,v)], null),iter__36327.call(null,cljs.core.rest.call(null,s__36328__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,expr);
})());
} else
{return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
* Subtract output-schema from input-schema, returning nil if it's possible that an object
* satisfying the output-schema satisfies the input-schema, or otherwise a description
* of the part(s) of input-schema not met by output-schema.  Strict about the map structure
* of output-schema matching input-schema, but loose about everything else (only looks at
* required keys of output-schema.
*/
plumbing.fnk.schema.schema_diff = (function schema_diff(input_schema,output_schema){if(!(plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema)))
{return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else
{if(!(plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema)))
{return schema.utils.error.call(null,schema.utils.__GT_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,output_schema)),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
}),null)),null));
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = (function iter__36344(s__36345){return (new cljs.core.LazySeq(null,(function (){var s__36345__$1 = s__36345;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36345__$1);if(temp__4126__auto__)
{var s__36345__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36345__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36345__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36347 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36346 = (0);while(true){
if((i__36346 < size__4265__auto__))
{var vec__36350 = cljs.core._nth.call(null,c__4264__auto__,i__36346);var k = cljs.core.nth.call(null,vec__36350,(0),null);var v = cljs.core.nth.call(null,vec__36350,(1),null);if(schema.core.specific_key_QMARK_.call(null,k))
{var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);var raw_k = schema.core.explicit_schema_key.call(null,k);var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);if((required_QMARK_) || (present_QMARK_))
{var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));if(cljs.core.truth_(fail))
{cljs.core.chunk_append.call(null,b__36347,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));
{
var G__36352 = (i__36346 + (1));
i__36346 = G__36352;
continue;
}
} else
{{
var G__36353 = (i__36346 + (1));
i__36346 = G__36353;
continue;
}
}
} else
{{
var G__36354 = (i__36346 + (1));
i__36346 = G__36354;
continue;
}
}
} else
{{
var G__36355 = (i__36346 + (1));
i__36346 = G__36355;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36347),iter__36344.call(null,cljs.core.chunk_rest.call(null,s__36345__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36347),null);
}
} else
{var vec__36351 = cljs.core.first.call(null,s__36345__$2);var k = cljs.core.nth.call(null,vec__36351,(0),null);var v = cljs.core.nth.call(null,vec__36351,(1),null);if(schema.core.specific_key_QMARK_.call(null,k))
{var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);var raw_k = schema.core.explicit_schema_key.call(null,k);var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);if((required_QMARK_) || (present_QMARK_))
{var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));if(cljs.core.truth_(fail))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),iter__36344.call(null,cljs.core.rest.call(null,s__36345__$2)));
} else
{{
var G__36356 = cljs.core.rest.call(null,s__36345__$2);
s__36345__$1 = G__36356;
continue;
}
}
} else
{{
var G__36357 = cljs.core.rest.call(null,s__36345__$2);
s__36345__$1 = G__36357;
continue;
}
}
} else
{{
var G__36358 = cljs.core.rest.call(null,s__36345__$2);
s__36345__$1 = G__36358;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,input_schema);
})()));
} else
{return null;
}
}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function assert_satisfies_schema(input_schema,output_schema){var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);if(cljs.core.truth_(fails))
{throw cljs.core.ex_info.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(fails)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else
{return null;
}
});
var ufv___36381 = schema.utils.use_fn_validation;var output_schema36359_36382 = schema.core.Any;var input_schema36360_36383 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);var input_checker36361_36384 = schema.core.checker.call(null,input_schema36360_36383);var output_checker36362_36385 = schema.core.checker.call(null,output_schema36359_36382);/**
* Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
* 
* Given pairs of input and output schemata for fnks f1 and f2,
* return a pair of input and output schemata for #(f2 (merge % (f1 %))).
* f1's output schema must not contain any optional keys.
*/
plumbing.fnk.schema.compose_schemata = ((function (ufv___36381,output_schema36359_36382,input_schema36360_36383,input_checker36361_36384,output_checker36362_36385){
return (function compose_schemata(G__36363,G__36364){var validate__13975__auto__ = true;if(validate__13975__auto__)
{var args__13976__auto___36386 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36363,G__36364], null);var temp__4126__auto___36387 = input_checker36361_36384.call(null,args__13976__auto___36386);if(cljs.core.truth_(temp__4126__auto___36387))
{var error__13977__auto___36388 = temp__4126__auto___36387;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),cljs.core.pr_str.call(null,error__13977__auto___36388)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36360_36383,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36386,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36388], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__36375 = G__36363;var vec__36377 = G__36375;var i2 = cljs.core.nth.call(null,vec__36377,(0),null);var o2 = cljs.core.nth.call(null,vec__36377,(1),null);var G__36376 = G__36364;var vec__36378 = G__36376;var i1 = cljs.core.nth.call(null,vec__36378,(0),null);var o1 = cljs.core.nth.call(null,vec__36378,(1),null);var G__36375__$1 = G__36375;var G__36376__$1 = G__36376;while(true){
var vec__36379 = G__36375__$1;var i2__$1 = cljs.core.nth.call(null,vec__36379,(0),null);var o2__$1 = cljs.core.nth.call(null,vec__36379,(1),null);var vec__36380 = G__36376__$1;var i1__$1 = cljs.core.nth.call(null,vec__36380,(0),null);var o1__$1 = cljs.core.nth.call(null,vec__36380,(1),null);plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();if(validate__13975__auto__)
{var temp__4126__auto___36389 = output_checker36362_36385.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36389))
{var error__13977__auto___36390 = temp__4126__auto___36389;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),cljs.core.pr_str.call(null,error__13977__auto___36390)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36359_36382,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36390], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36381,output_schema36359_36382,input_schema36360_36383,input_checker36361_36384,output_checker36362_36385))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema36359_36382,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36360_36383], null)));
plumbing.fnk.schema.schema_key = (function schema_key(m,k){if(cljs.core.contains_QMARK_.call(null,m,k))
{return k;
} else
{if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k)))
{return schema.core.optional_key.call(null,k);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return null;
} else
{return null;
}
}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function possibly_contains_QMARK_(m,k){return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___36469 = schema.utils.use_fn_validation;var output_schema36391_36470 = schema.core.Any;var input_schema36392_36471 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"s","s",-948495851,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"ks","ks",-754231827,null))], null);var input_checker36393_36472 = schema.core.checker.call(null,input_schema36392_36471);var output_checker36394_36473 = schema.core.checker.call(null,output_schema36391_36470);/**
* Inputs: [s :- InputSchema ks :- [s/Keyword]]
* 
* Return a pair [ks-part non-ks-part], with any extra schema removed.
*/
plumbing.fnk.schema.split_schema = ((function (ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function split_schema(G__36395,G__36396){var validate__13975__auto__ = ufv___36469.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36474 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36395,G__36396], null);var temp__4126__auto___36475 = input_checker36393_36472.call(null,args__13976__auto___36474);if(cljs.core.truth_(temp__4126__auto___36475))
{var error__13977__auto___36476 = temp__4126__auto___36475;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),cljs.core.pr_str.call(null,error__13977__auto___36476)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36392_36471,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36474,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36476], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var s = G__36395;var ks = G__36396;while(true){
var ks__$1 = cljs.core.set.call(null,ks);var iter__4266__auto__ = ((function (ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function iter__36433(s__36434){return (new cljs.core.LazySeq(null,((function (ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function (){var s__36434__$1 = s__36434;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36434__$1);if(temp__4126__auto__)
{var s__36434__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36434__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36434__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36436 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36435 = (0);while(true){
if((i__36435 < size__4265__auto__))
{var in_QMARK_ = cljs.core._nth.call(null,c__4264__auto__,i__36435);cljs.core.chunk_append.call(null,b__36436,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = ((function (i__36435,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36436,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function iter__36453(s__36454){return (new cljs.core.LazySeq(null,((function (i__36435,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36436,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function (){var s__36454__$1 = s__36454;while(true){
var temp__4126__auto____$1 = cljs.core.seq.call(null,s__36454__$1);if(temp__4126__auto____$1)
{var s__36454__$2 = temp__4126__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__36454__$2))
{var c__4264__auto____$1 = cljs.core.chunk_first.call(null,s__36454__$2);var size__4265__auto____$1 = cljs.core.count.call(null,c__4264__auto____$1);var b__36456 = cljs.core.chunk_buffer.call(null,size__4265__auto____$1);if((function (){var i__36455 = (0);while(true){
if((i__36455 < size__4265__auto____$1))
{var vec__36459 = cljs.core._nth.call(null,c__4264__auto____$1,i__36455);var k = cljs.core.nth.call(null,vec__36459,(0),null);var v = cljs.core.nth.call(null,vec__36459,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{cljs.core.chunk_append.call(null,b__36456,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36477 = (i__36455 + (1));
i__36455 = G__36477;
continue;
}
} else
{{
var G__36478 = (i__36455 + (1));
i__36455 = G__36478;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36456),iter__36453.call(null,cljs.core.chunk_rest.call(null,s__36454__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36456),null);
}
} else
{var vec__36460 = cljs.core.first.call(null,s__36454__$2);var k = cljs.core.nth.call(null,vec__36460,(0),null);var v = cljs.core.nth.call(null,vec__36460,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36453.call(null,cljs.core.rest.call(null,s__36454__$2)));
} else
{{
var G__36479 = cljs.core.rest.call(null,s__36454__$2);
s__36454__$1 = G__36479;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(i__36435,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36436,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
,null,null));
});})(i__36435,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36436,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
;return iter__4266__auto__.call(null,s);
})()));
{
var G__36480 = (i__36435 + (1));
i__36435 = G__36480;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36436),iter__36433.call(null,cljs.core.chunk_rest.call(null,s__36434__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36436),null);
}
} else
{var in_QMARK_ = cljs.core.first.call(null,s__36434__$2);return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = ((function (in_QMARK_,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function iter__36461(s__36462){return (new cljs.core.LazySeq(null,((function (in_QMARK_,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473){
return (function (){var s__36462__$1 = s__36462;while(true){
var temp__4126__auto____$1 = cljs.core.seq.call(null,s__36462__$1);if(temp__4126__auto____$1)
{var s__36462__$2 = temp__4126__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__36462__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36462__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36464 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36463 = (0);while(true){
if((i__36463 < size__4265__auto__))
{var vec__36467 = cljs.core._nth.call(null,c__4264__auto__,i__36463);var k = cljs.core.nth.call(null,vec__36467,(0),null);var v = cljs.core.nth.call(null,vec__36467,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{cljs.core.chunk_append.call(null,b__36464,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36481 = (i__36463 + (1));
i__36463 = G__36481;
continue;
}
} else
{{
var G__36482 = (i__36463 + (1));
i__36463 = G__36482;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36464),iter__36461.call(null,cljs.core.chunk_rest.call(null,s__36462__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36464),null);
}
} else
{var vec__36468 = cljs.core.first.call(null,s__36462__$2);var k = cljs.core.nth.call(null,vec__36468,(0),null);var v = cljs.core.nth.call(null,vec__36468,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36461.call(null,cljs.core.rest.call(null,s__36462__$2)));
} else
{{
var G__36483 = cljs.core.rest.call(null,s__36462__$2);
s__36462__$1 = G__36483;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(in_QMARK_,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
,null,null));
});})(in_QMARK_,s__36434__$2,temp__4126__auto__,ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
;return iter__4266__auto__.call(null,s);
})()),iter__36433.call(null,cljs.core.rest.call(null,s__36434__$2)));
}
} else
{return null;
}
break;
}
});})(ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
,null,null));
});})(ks__$1,validate__13975__auto__,ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
;return iter__4266__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36484 = output_checker36394_36473.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36484))
{var error__13977__auto___36485 = temp__4126__auto___36484;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),cljs.core.pr_str.call(null,error__13977__auto___36485)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36391_36470,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36485], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36469,output_schema36391_36470,input_schema36392_36471,input_checker36393_36472,output_checker36394_36473))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema36391_36470,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36392_36471], null)));
var ufv___36516 = schema.utils.use_fn_validation;var output_schema36486_36517 = plumbing.fnk.schema.GraphIOSchemata;var input_schema36487_36518 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);var input_checker36488_36519 = schema.core.checker.call(null,input_schema36487_36518);var output_checker36489_36520 = schema.core.checker.call(null,output_schema36486_36517);/**
* Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
* Returns: GraphIOSchemata
* 
* Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
* return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
*/
plumbing.fnk.schema.sequence_schemata = ((function (ufv___36516,output_schema36486_36517,input_schema36487_36518,input_checker36488_36519,output_checker36489_36520){
return (function sequence_schemata(G__36490,G__36491){var validate__13975__auto__ = ufv___36516.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36521 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36490,G__36491], null);var temp__4126__auto___36522 = input_checker36488_36519.call(null,args__13976__auto___36521);if(cljs.core.truth_(temp__4126__auto___36522))
{var error__13977__auto___36523 = temp__4126__auto___36522;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),cljs.core.pr_str.call(null,error__13977__auto___36523)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36487_36518,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36521,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36523], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__36507 = G__36490;var vec__36509 = G__36507;var i1 = cljs.core.nth.call(null,vec__36509,(0),null);var o1 = cljs.core.nth.call(null,vec__36509,(1),null);var G__36508 = G__36491;var vec__36510 = G__36508;var k = cljs.core.nth.call(null,vec__36510,(0),null);var vec__36511 = cljs.core.nth.call(null,vec__36510,(1),null);var i2 = cljs.core.nth.call(null,vec__36511,(0),null);var o2 = cljs.core.nth.call(null,vec__36511,(1),null);var G__36507__$1 = G__36507;var G__36508__$1 = G__36508;while(true){
var vec__36512 = G__36507__$1;var i1__$1 = cljs.core.nth.call(null,vec__36512,(0),null);var o1__$1 = cljs.core.nth.call(null,vec__36512,(1),null);var vec__36513 = G__36508__$1;var k__$1 = cljs.core.nth.call(null,vec__36513,(0),null);var vec__36514 = cljs.core.nth.call(null,vec__36513,(1),null);var i2__$1 = cljs.core.nth.call(null,vec__36514,(0),null);var o2__$1 = cljs.core.nth.call(null,vec__36514,(1),null);if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}
if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}
if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}
var vec__36515 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));var used = cljs.core.nth.call(null,vec__36515,(0),null);var unused = cljs.core.nth.call(null,vec__36515,(1),null);plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36524 = output_checker36489_36520.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36524))
{var error__13977__auto___36525 = temp__4126__auto___36524;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),cljs.core.pr_str.call(null,error__13977__auto___36525)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36486_36517,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36525], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36516,output_schema36486_36517,input_schema36487_36518,input_checker36488_36519,output_checker36489_36520))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema36486_36517,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36487_36518], null)));

//# sourceMappingURL=schema.js.map