// Compiled by ClojureScript 0.0-2277
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('plumbing.fnk.schema');
goog.require('plumbing.fnk.schema');
goog.require('schema.utils');
goog.require('schema.utils');
/**
* A sentinel value representing missing portions of the input data.
*/
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
* Updates the value in map m at k with the function f.
* 
* Like update-in, but for updating a single top-level key.
* Any additional args will be passed to f after the value.
* @param {...*} var_args
*/
plumbing.core.update = (function() {
var update = null;
var update__3 = (function (m,k,f){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
});
var update__4 = (function (m,k,f,x1){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
});
var update__5 = (function (m,k,f,x1,x2){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
});
var update__6 = (function() { 
var G__36526__delegate = function (m,k,f,x1,x2,xs){return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
};
var G__36526 = function (m,k,f,x1,x2,var_args){
var xs = null;if (arguments.length > 5) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);} 
return G__36526__delegate.call(this,m,k,f,x1,x2,xs);};
G__36526.cljs$lang$maxFixedArity = 5;
G__36526.cljs$lang$applyTo = (function (arglist__36527){
var m = cljs.core.first(arglist__36527);
arglist__36527 = cljs.core.next(arglist__36527);
var k = cljs.core.first(arglist__36527);
arglist__36527 = cljs.core.next(arglist__36527);
var f = cljs.core.first(arglist__36527);
arglist__36527 = cljs.core.next(arglist__36527);
var x1 = cljs.core.first(arglist__36527);
arglist__36527 = cljs.core.next(arglist__36527);
var x2 = cljs.core.first(arglist__36527);
var xs = cljs.core.rest(arglist__36527);
return G__36526__delegate(m,k,f,x1,x2,xs);
});
G__36526.cljs$core$IFn$_invoke$arity$variadic = G__36526__delegate;
return G__36526;
})()
;
update = function(m,k,f,x1,x2,var_args){
var xs = var_args;
switch(arguments.length){
case 3:
return update__3.call(this,m,k,f);
case 4:
return update__4.call(this,m,k,f,x1);
case 5:
return update__5.call(this,m,k,f,x1,x2);
default:
return update__6.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x1,x2, cljs.core.array_seq(arguments, 5));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update.cljs$lang$maxFixedArity = 5;
update.cljs$lang$applyTo = update__6.cljs$lang$applyTo;
update.cljs$core$IFn$_invoke$arity$3 = update__3;
update.cljs$core$IFn$_invoke$arity$4 = update__4;
update.cljs$core$IFn$_invoke$arity$5 = update__5;
update.cljs$core$IFn$_invoke$arity$variadic = update__6.cljs$core$IFn$_invoke$arity$variadic;
return update;
})()
;
/**
* Build map k -> (f v) for [k v] in map, preserving the initial type
*/
plumbing.core.map_vals = (function map_vals(f,m){if(cljs.core.sorted_QMARK_.call(null,m))
{return cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else
{if(cljs.core.map_QMARK_.call(null,m))
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{var m_atom__16242__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36536_36542 = cljs.core.seq.call(null,m);var chunk__36537_36543 = null;var count__36538_36544 = (0);var i__36539_36545 = (0);while(true){
if((i__36539_36545 < count__36538_36544))
{var vec__36540_36546 = cljs.core._nth.call(null,chunk__36537_36543,i__36539_36545);var k_36547 = cljs.core.nth.call(null,vec__36540_36546,(0),null);var v_36548 = cljs.core.nth.call(null,vec__36540_36546,(1),null);var m36535_36549 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36535_36549,k_36547,f.call(null,v_36548)));
{
var G__36550 = seq__36536_36542;
var G__36551 = chunk__36537_36543;
var G__36552 = count__36538_36544;
var G__36553 = (i__36539_36545 + (1));
seq__36536_36542 = G__36550;
chunk__36537_36543 = G__36551;
count__36538_36544 = G__36552;
i__36539_36545 = G__36553;
continue;
}
} else
{var temp__4126__auto___36554 = cljs.core.seq.call(null,seq__36536_36542);if(temp__4126__auto___36554)
{var seq__36536_36555__$1 = temp__4126__auto___36554;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36536_36555__$1))
{var c__4297__auto___36556 = cljs.core.chunk_first.call(null,seq__36536_36555__$1);{
var G__36557 = cljs.core.chunk_rest.call(null,seq__36536_36555__$1);
var G__36558 = c__4297__auto___36556;
var G__36559 = cljs.core.count.call(null,c__4297__auto___36556);
var G__36560 = (0);
seq__36536_36542 = G__36557;
chunk__36537_36543 = G__36558;
count__36538_36544 = G__36559;
i__36539_36545 = G__36560;
continue;
}
} else
{var vec__36541_36561 = cljs.core.first.call(null,seq__36536_36555__$1);var k_36562 = cljs.core.nth.call(null,vec__36541_36561,(0),null);var v_36563 = cljs.core.nth.call(null,vec__36541_36561,(1),null);var m36535_36564 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36535_36564,k_36562,f.call(null,v_36563)));
{
var G__36565 = cljs.core.next.call(null,seq__36536_36555__$1);
var G__36566 = null;
var G__36567 = (0);
var G__36568 = (0);
seq__36536_36542 = G__36565;
chunk__36537_36543 = G__36566;
count__36538_36544 = G__36567;
i__36539_36545 = G__36568;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16242__auto__));
} else
{return null;
}
}
}
});
/**
* Build map (f k) -> v for [k v] in map m
*/
plumbing.core.map_keys = (function map_keys(f,m){if(cljs.core.map_QMARK_.call(null,m))
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else
{var m_atom__16242__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36577_36583 = cljs.core.seq.call(null,m);var chunk__36578_36584 = null;var count__36579_36585 = (0);var i__36580_36586 = (0);while(true){
if((i__36580_36586 < count__36579_36585))
{var vec__36581_36587 = cljs.core._nth.call(null,chunk__36578_36584,i__36580_36586);var k_36588 = cljs.core.nth.call(null,vec__36581_36587,(0),null);var v_36589 = cljs.core.nth.call(null,vec__36581_36587,(1),null);var m36576_36590 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36576_36590,f.call(null,k_36588),v_36589));
{
var G__36591 = seq__36577_36583;
var G__36592 = chunk__36578_36584;
var G__36593 = count__36579_36585;
var G__36594 = (i__36580_36586 + (1));
seq__36577_36583 = G__36591;
chunk__36578_36584 = G__36592;
count__36579_36585 = G__36593;
i__36580_36586 = G__36594;
continue;
}
} else
{var temp__4126__auto___36595 = cljs.core.seq.call(null,seq__36577_36583);if(temp__4126__auto___36595)
{var seq__36577_36596__$1 = temp__4126__auto___36595;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36577_36596__$1))
{var c__4297__auto___36597 = cljs.core.chunk_first.call(null,seq__36577_36596__$1);{
var G__36598 = cljs.core.chunk_rest.call(null,seq__36577_36596__$1);
var G__36599 = c__4297__auto___36597;
var G__36600 = cljs.core.count.call(null,c__4297__auto___36597);
var G__36601 = (0);
seq__36577_36583 = G__36598;
chunk__36578_36584 = G__36599;
count__36579_36585 = G__36600;
i__36580_36586 = G__36601;
continue;
}
} else
{var vec__36582_36602 = cljs.core.first.call(null,seq__36577_36596__$1);var k_36603 = cljs.core.nth.call(null,vec__36582_36602,(0),null);var v_36604 = cljs.core.nth.call(null,vec__36582_36602,(1),null);var m36576_36605 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36576_36605,f.call(null,k_36603),v_36604));
{
var G__36606 = cljs.core.next.call(null,seq__36577_36596__$1);
var G__36607 = null;
var G__36608 = (0);
var G__36609 = (0);
seq__36577_36583 = G__36606;
chunk__36578_36584 = G__36607;
count__36579_36585 = G__36608;
i__36580_36586 = G__36609;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16242__auto__));
}
});
/**
* Build map k -> (f k) for keys in ks
*/
plumbing.core.map_from_keys = (function map_from_keys(f,ks){var m_atom__16242__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36616_36620 = cljs.core.seq.call(null,ks);var chunk__36617_36621 = null;var count__36618_36622 = (0);var i__36619_36623 = (0);while(true){
if((i__36619_36623 < count__36618_36622))
{var k_36624 = cljs.core._nth.call(null,chunk__36617_36621,i__36619_36623);var m36615_36625 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36615_36625,k_36624,f.call(null,k_36624)));
{
var G__36626 = seq__36616_36620;
var G__36627 = chunk__36617_36621;
var G__36628 = count__36618_36622;
var G__36629 = (i__36619_36623 + (1));
seq__36616_36620 = G__36626;
chunk__36617_36621 = G__36627;
count__36618_36622 = G__36628;
i__36619_36623 = G__36629;
continue;
}
} else
{var temp__4126__auto___36630 = cljs.core.seq.call(null,seq__36616_36620);if(temp__4126__auto___36630)
{var seq__36616_36631__$1 = temp__4126__auto___36630;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36616_36631__$1))
{var c__4297__auto___36632 = cljs.core.chunk_first.call(null,seq__36616_36631__$1);{
var G__36633 = cljs.core.chunk_rest.call(null,seq__36616_36631__$1);
var G__36634 = c__4297__auto___36632;
var G__36635 = cljs.core.count.call(null,c__4297__auto___36632);
var G__36636 = (0);
seq__36616_36620 = G__36633;
chunk__36617_36621 = G__36634;
count__36618_36622 = G__36635;
i__36619_36623 = G__36636;
continue;
}
} else
{var k_36637 = cljs.core.first.call(null,seq__36616_36631__$1);var m36615_36638 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36615_36638,k_36637,f.call(null,k_36637)));
{
var G__36639 = cljs.core.next.call(null,seq__36616_36631__$1);
var G__36640 = null;
var G__36641 = (0);
var G__36642 = (0);
seq__36616_36620 = G__36639;
chunk__36617_36621 = G__36640;
count__36618_36622 = G__36641;
i__36619_36623 = G__36642;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16242__auto__));
});
/**
* Build map (f v) -> v for vals in vs
*/
plumbing.core.map_from_vals = (function map_from_vals(f,vs){var m_atom__16242__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36649_36653 = cljs.core.seq.call(null,vs);var chunk__36650_36654 = null;var count__36651_36655 = (0);var i__36652_36656 = (0);while(true){
if((i__36652_36656 < count__36651_36655))
{var v_36657 = cljs.core._nth.call(null,chunk__36650_36654,i__36652_36656);var m36648_36658 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36648_36658,f.call(null,v_36657),v_36657));
{
var G__36659 = seq__36649_36653;
var G__36660 = chunk__36650_36654;
var G__36661 = count__36651_36655;
var G__36662 = (i__36652_36656 + (1));
seq__36649_36653 = G__36659;
chunk__36650_36654 = G__36660;
count__36651_36655 = G__36661;
i__36652_36656 = G__36662;
continue;
}
} else
{var temp__4126__auto___36663 = cljs.core.seq.call(null,seq__36649_36653);if(temp__4126__auto___36663)
{var seq__36649_36664__$1 = temp__4126__auto___36663;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36649_36664__$1))
{var c__4297__auto___36665 = cljs.core.chunk_first.call(null,seq__36649_36664__$1);{
var G__36666 = cljs.core.chunk_rest.call(null,seq__36649_36664__$1);
var G__36667 = c__4297__auto___36665;
var G__36668 = cljs.core.count.call(null,c__4297__auto___36665);
var G__36669 = (0);
seq__36649_36653 = G__36666;
chunk__36650_36654 = G__36667;
count__36651_36655 = G__36668;
i__36652_36656 = G__36669;
continue;
}
} else
{var v_36670 = cljs.core.first.call(null,seq__36649_36664__$1);var m36648_36671 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36648_36671,f.call(null,v_36670),v_36670));
{
var G__36672 = cljs.core.next.call(null,seq__36649_36664__$1);
var G__36673 = null;
var G__36674 = (0);
var G__36675 = (0);
seq__36649_36653 = G__36672;
chunk__36650_36654 = G__36673;
count__36651_36655 = G__36674;
i__36652_36656 = G__36675;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16242__auto__));
});
/**
* Dissociate this keyseq from m, removing any empty maps created as a result
* (including at the top-level).
*/
plumbing.core.dissoc_in = (function dissoc_in(m,p__36676){var vec__36678 = p__36676;var k = cljs.core.nth.call(null,vec__36678,(0),null);var ks = cljs.core.nthnext.call(null,vec__36678,(1));if(cljs.core.truth_(m))
{var temp__4124__auto__ = (function (){var and__3529__auto__ = ks;if(and__3529__auto__)
{return dissoc_in.call(null,m.call(null,k),ks);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4124__auto__))
{var res = temp__4124__auto__;return cljs.core.assoc.call(null,m,k,res);
} else
{var res = cljs.core.dissoc.call(null,m,k);if(cljs.core.empty_QMARK_.call(null,res))
{return null;
} else
{return res;
}
}
} else
{return null;
}
});
/**
* Recursively convert maps in m (including itself)
* to have keyword keys instead of string
*/
plumbing.core.keywordize_map = (function keywordize_map(x){if(cljs.core.map_QMARK_.call(null,x))
{var m_atom__16242__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36687_36693 = cljs.core.seq.call(null,x);var chunk__36688_36694 = null;var count__36689_36695 = (0);var i__36690_36696 = (0);while(true){
if((i__36690_36696 < count__36689_36695))
{var vec__36691_36697 = cljs.core._nth.call(null,chunk__36688_36694,i__36690_36696);var k_36698 = cljs.core.nth.call(null,vec__36691_36697,(0),null);var v_36699 = cljs.core.nth.call(null,vec__36691_36697,(1),null);var m36686_36700 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36686_36700,((typeof k_36698 === 'string')?cljs.core.keyword.call(null,k_36698):k_36698),keywordize_map.call(null,v_36699)));
{
var G__36701 = seq__36687_36693;
var G__36702 = chunk__36688_36694;
var G__36703 = count__36689_36695;
var G__36704 = (i__36690_36696 + (1));
seq__36687_36693 = G__36701;
chunk__36688_36694 = G__36702;
count__36689_36695 = G__36703;
i__36690_36696 = G__36704;
continue;
}
} else
{var temp__4126__auto___36705 = cljs.core.seq.call(null,seq__36687_36693);if(temp__4126__auto___36705)
{var seq__36687_36706__$1 = temp__4126__auto___36705;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36687_36706__$1))
{var c__4297__auto___36707 = cljs.core.chunk_first.call(null,seq__36687_36706__$1);{
var G__36708 = cljs.core.chunk_rest.call(null,seq__36687_36706__$1);
var G__36709 = c__4297__auto___36707;
var G__36710 = cljs.core.count.call(null,c__4297__auto___36707);
var G__36711 = (0);
seq__36687_36693 = G__36708;
chunk__36688_36694 = G__36709;
count__36689_36695 = G__36710;
i__36690_36696 = G__36711;
continue;
}
} else
{var vec__36692_36712 = cljs.core.first.call(null,seq__36687_36706__$1);var k_36713 = cljs.core.nth.call(null,vec__36692_36712,(0),null);var v_36714 = cljs.core.nth.call(null,vec__36692_36712,(1),null);var m36686_36715 = cljs.core.deref.call(null,m_atom__16242__auto__);cljs.core.reset_BANG_.call(null,m_atom__16242__auto__,cljs.core.assoc_BANG_.call(null,m36686_36715,((typeof k_36713 === 'string')?cljs.core.keyword.call(null,k_36713):k_36713),keywordize_map.call(null,v_36714)));
{
var G__36716 = cljs.core.next.call(null,seq__36687_36706__$1);
var G__36717 = null;
var G__36718 = (0);
var G__36719 = (0);
seq__36687_36693 = G__36716;
chunk__36688_36694 = G__36717;
count__36689_36695 = G__36718;
i__36690_36696 = G__36719;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16242__auto__));
} else
{if(cljs.core.seq_QMARK_.call(null,x))
{return cljs.core.map.call(null,keywordize_map,x);
} else
{if(cljs.core.vector_QMARK_.call(null,x))
{return cljs.core.mapv.call(null,keywordize_map,x);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return x;
} else
{return null;
}
}
}
}
});
/**
* Like get but throw an exception if not found
*/
plumbing.core.safe_get = (function safe_get(m,k){var temp__4124__auto__ = cljs.core.find.call(null,m,k);if(cljs.core.truth_(temp__4124__auto__))
{var pair__16311__auto__ = temp__4124__auto__;return cljs.core.val.call(null,pair__16311__auto__);
} else
{var e = schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m));throw (new Error(e));
}
});
/**
* Like get-in but throws exception if not found
*/
plumbing.core.safe_get_in = (function safe_get_in(m,ks){while(true){
if(cljs.core.seq.call(null,ks))
{{
var G__36720 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__36721 = cljs.core.next.call(null,ks);
m = G__36720;
ks = G__36721;
continue;
}
} else
{return m;
}
break;
}
});
/**
* Like assoc but only assocs when value is truthy
* @param {...*} var_args
*/
plumbing.core.assoc_when = (function() { 
var assoc_when__delegate = function (m,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
return cljs.core.into.call(null,(function (){var or__3541__auto__ = m;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__4266__auto__ = (function iter__36730(s__36731){return (new cljs.core.LazySeq(null,(function (){var s__36731__$1 = s__36731;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36731__$1);if(temp__4126__auto__)
{var s__36731__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36731__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36731__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36733 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36732 = (0);while(true){
if((i__36732 < size__4265__auto__))
{var vec__36736 = cljs.core._nth.call(null,c__4264__auto__,i__36732);var k = cljs.core.nth.call(null,vec__36736,(0),null);var v = cljs.core.nth.call(null,vec__36736,(1),null);if(cljs.core.truth_(v))
{cljs.core.chunk_append.call(null,b__36733,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36738 = (i__36732 + (1));
i__36732 = G__36738;
continue;
}
} else
{{
var G__36739 = (i__36732 + (1));
i__36732 = G__36739;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36733),iter__36730.call(null,cljs.core.chunk_rest.call(null,s__36731__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36733),null);
}
} else
{var vec__36737 = cljs.core.first.call(null,s__36731__$2);var k = cljs.core.nth.call(null,vec__36737,(0),null);var v = cljs.core.nth.call(null,vec__36737,(1),null);if(cljs.core.truth_(v))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36730.call(null,cljs.core.rest.call(null,s__36731__$2)));
} else
{{
var G__36740 = cljs.core.rest.call(null,s__36731__$2);
s__36731__$1 = G__36740;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
};
var assoc_when = function (m,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return assoc_when__delegate.call(this,m,kvs);};
assoc_when.cljs$lang$maxFixedArity = 1;
assoc_when.cljs$lang$applyTo = (function (arglist__36741){
var m = cljs.core.first(arglist__36741);
var kvs = cljs.core.rest(arglist__36741);
return assoc_when__delegate(m,kvs);
});
assoc_when.cljs$core$IFn$_invoke$arity$variadic = assoc_when__delegate;
return assoc_when;
})()
;
/**
* Like update-in but returns m unchanged if key-seq is not present.
* @param {...*} var_args
*/
plumbing.core.update_in_when = (function() { 
var update_in_when__delegate = function (m,key_seq,f,args){var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);if(!((plumbing.core._PLUS_none_PLUS_ === found)))
{return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else
{return m;
}
};
var update_in_when = function (m,key_seq,f,var_args){
var args = null;if (arguments.length > 3) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return update_in_when__delegate.call(this,m,key_seq,f,args);};
update_in_when.cljs$lang$maxFixedArity = 3;
update_in_when.cljs$lang$applyTo = (function (arglist__36742){
var m = cljs.core.first(arglist__36742);
arglist__36742 = cljs.core.next(arglist__36742);
var key_seq = cljs.core.first(arglist__36742);
arglist__36742 = cljs.core.next(arglist__36742);
var f = cljs.core.first(arglist__36742);
var args = cljs.core.rest(arglist__36742);
return update_in_when__delegate(m,key_seq,f,args);
});
update_in_when.cljs$core$IFn$_invoke$arity$variadic = update_in_when__delegate;
return update_in_when;
})()
;
/**
* Like group-by, but accepts a map-fn that is applied to values before
* collected.
*/
plumbing.core.grouped_map = (function grouped_map(key_fn,map_fn,coll){return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){var k = key_fn.call(null,x);return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Like (apply concat s) but lazier (and shorter)
*/
plumbing.core.aconcat = (function aconcat(s){return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){var temp__4126__auto__ = cljs.core.next.call(null,s);if(temp__4126__auto__)
{var n = temp__4126__auto__;return aconcat.call(null,n);
} else
{return null;
}
}),null,null)));
});
/**
* Takes a seqable and returns a lazy sequence that
* is maximally lazy and doesn't realize elements due to either
* chunking or apply.
* 
* Useful when you don't want chunking, for instance,
* (first awesome-website? (map slurp +a-bunch-of-urls+))
* may slurp up to 31 unneed webpages, wherease
* (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
* is guaranteed to stop slurping after the first awesome website.
* 
* Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
*/
plumbing.core.unchunk = (function unchunk(s){if(cljs.core.seq.call(null,s))
{return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){return unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else
{return null;
}
});
/**
* Return sum of (f x) for each x in xs
*/
plumbing.core.sum = (function() {
var sum = null;
var sum__1 = (function (xs){return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
});
var sum__2 = (function (f,xs){return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
});
sum = function(f,xs){
switch(arguments.length){
case 1:
return sum__1.call(this,f);
case 2:
return sum__2.call(this,f,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sum.cljs$core$IFn$_invoke$arity$1 = sum__1;
sum.cljs$core$IFn$_invoke$arity$2 = sum__2;
return sum;
})()
;
/**
* returns (first xs) when xs has only 1 element
*/
plumbing.core.singleton = (function singleton(xs){var temp__4126__auto__ = cljs.core.seq.call(null,xs);if(temp__4126__auto__)
{var xs__$1 = temp__4126__auto__;if(cljs.core.next.call(null,xs__$1))
{return null;
} else
{return cljs.core.first.call(null,xs__$1);
}
} else
{return null;
}
});
/**
* Returns [idx x] for x in seqable s
*/
plumbing.core.indexed = (function indexed(s){return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
* Returns indices idx of sequence s where (f (nth s idx))
*/
plumbing.core.positions = (function positions(f,s){return cljs.core.keep_indexed.call(null,(function (i,x){if(cljs.core.truth_(f.call(null,x)))
{return i;
} else
{return null;
}
}),s);
});
/**
* Returns elements of xs which return unique
* values according to f. If multiple elements of xs return the same
* value under f, the first is returned
*/
plumbing.core.distinct_by = (function distinct_by(f,xs){var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);var iter__4266__auto__ = ((function (s){
return (function iter__36747(s__36748){return (new cljs.core.LazySeq(null,((function (s){
return (function (){var s__36748__$1 = s__36748;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36748__$1);if(temp__4126__auto__)
{var s__36748__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36748__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36748__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36750 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36749 = (0);while(true){
if((i__36749 < size__4265__auto__))
{var x = cljs.core._nth.call(null,c__4264__auto__,i__36749);var id = f.call(null,x);if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))
{cljs.core.chunk_append.call(null,b__36750,(function (){cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);
return x;
})());
{
var G__36751 = (i__36749 + (1));
i__36749 = G__36751;
continue;
}
} else
{{
var G__36752 = (i__36749 + (1));
i__36749 = G__36752;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36750),iter__36747.call(null,cljs.core.chunk_rest.call(null,s__36748__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36750),null);
}
} else
{var x = cljs.core.first.call(null,s__36748__$2);var id = f.call(null,x);if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))
{return cljs.core.cons.call(null,(function (){cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);
return x;
})(),iter__36747.call(null,cljs.core.rest.call(null,s__36748__$2)));
} else
{{
var G__36753 = cljs.core.rest.call(null,s__36748__$2);
s__36748__$1 = G__36753;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(s))
,null,null));
});})(s))
;return iter__4266__auto__.call(null,xs);
});
/**
* Analogy: partition:partition-all :: interleave:interleave-all
* @param {...*} var_args
*/
plumbing.core.interleave_all = (function() { 
var interleave_all__delegate = function (colls){return (new cljs.core.LazySeq(null,(function (){return (function helper(seqs){if(cljs.core.seq.call(null,seqs))
{return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){return helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else
{return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
};
var interleave_all = function (var_args){
var colls = null;if (arguments.length > 0) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return interleave_all__delegate.call(this,colls);};
interleave_all.cljs$lang$maxFixedArity = 0;
interleave_all.cljs$lang$applyTo = (function (arglist__36754){
var colls = cljs.core.seq(arglist__36754);
return interleave_all__delegate(colls);
});
interleave_all.cljs$core$IFn$_invoke$arity$variadic = interleave_all__delegate;
return interleave_all;
})()
;
/**
* Returns # of elements of xs where pred holds
*/
plumbing.core.count_when = (function count_when(pred,xs){return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
* Like conj but ignores non-truthy values
* @param {...*} var_args
*/
plumbing.core.conj_when = (function() {
var conj_when = null;
var conj_when__2 = (function (coll,x){if(cljs.core.truth_(x))
{return cljs.core.conj.call(null,coll,x);
} else
{return coll;
}
});
var conj_when__3 = (function() { 
var G__36755__delegate = function (coll,x,xs){while(true){
if(cljs.core.truth_(xs))
{{
var G__36756 = conj_when.call(null,coll,x);
var G__36757 = cljs.core.first.call(null,xs);
var G__36758 = cljs.core.next.call(null,xs);
coll = G__36756;
x = G__36757;
xs = G__36758;
continue;
}
} else
{return conj_when.call(null,coll,x);
}
break;
}
};
var G__36755 = function (coll,x,var_args){
var xs = null;if (arguments.length > 2) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36755__delegate.call(this,coll,x,xs);};
G__36755.cljs$lang$maxFixedArity = 2;
G__36755.cljs$lang$applyTo = (function (arglist__36759){
var coll = cljs.core.first(arglist__36759);
arglist__36759 = cljs.core.next(arglist__36759);
var x = cljs.core.first(arglist__36759);
var xs = cljs.core.rest(arglist__36759);
return G__36755__delegate(coll,x,xs);
});
G__36755.cljs$core$IFn$_invoke$arity$variadic = G__36755__delegate;
return G__36755;
})()
;
conj_when = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 2:
return conj_when__2.call(this,coll,x);
default:
return conj_when__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj_when.cljs$lang$maxFixedArity = 2;
conj_when.cljs$lang$applyTo = conj_when__3.cljs$lang$applyTo;
conj_when.cljs$core$IFn$_invoke$arity$2 = conj_when__2;
conj_when.cljs$core$IFn$_invoke$arity$variadic = conj_when__3.cljs$core$IFn$_invoke$arity$variadic;
return conj_when;
})()
;
/**
* Like cons but does nothing if x is non-truthy.
*/
plumbing.core.cons_when = (function cons_when(x,s){if(cljs.core.truth_(x))
{return cljs.core.cons.call(null,x,s);
} else
{return s;
}
});
/**
* Like sort-by, but prefers higher values rather than lower ones.
*/
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
* Like swap! but returns a pair [old-val new-val]
* @param {...*} var_args
*/
plumbing.core.swap_pair_BANG_ = (function() {
var swap_pair_BANG_ = null;
var swap_pair_BANG___2 = (function (a,f){while(true){
var old_val = cljs.core.deref.call(null,a);var new_val = f.call(null,old_val);if(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else
{{
continue;
}
}
break;
}
});
var swap_pair_BANG___3 = (function() { 
var G__36761__delegate = function (a,f,args){return swap_pair_BANG_.call(null,a,(function (p1__36760_SHARP_){return cljs.core.apply.call(null,f,p1__36760_SHARP_,args);
}));
};
var G__36761 = function (a,f,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36761__delegate.call(this,a,f,args);};
G__36761.cljs$lang$maxFixedArity = 2;
G__36761.cljs$lang$applyTo = (function (arglist__36762){
var a = cljs.core.first(arglist__36762);
arglist__36762 = cljs.core.next(arglist__36762);
var f = cljs.core.first(arglist__36762);
var args = cljs.core.rest(arglist__36762);
return G__36761__delegate(a,f,args);
});
G__36761.cljs$core$IFn$_invoke$arity$variadic = G__36761__delegate;
return G__36761;
})()
;
swap_pair_BANG_ = function(a,f,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return swap_pair_BANG___2.call(this,a,f);
default:
return swap_pair_BANG___3.cljs$core$IFn$_invoke$arity$variadic(a,f, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
swap_pair_BANG_.cljs$lang$maxFixedArity = 2;
swap_pair_BANG_.cljs$lang$applyTo = swap_pair_BANG___3.cljs$lang$applyTo;
swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = swap_pair_BANG___2;
swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_pair_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return swap_pair_BANG_;
})()
;
/**
* Like reset! but returns old-val
*/
plumbing.core.get_and_set_BANG_ = (function get_and_set_BANG_(a,new_val){return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function millis(){return (new Date()).getTime();
});
/**
* Like apply, but applies a map to a function with positional map
* arguments. Can take optional initial args just like apply.
* @param {...*} var_args
*/
plumbing.core.mapply = (function() {
var mapply = null;
var mapply__2 = (function (f,m){return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
});
var mapply__3 = (function() { 
var G__36763__delegate = function (f,arg,args){return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
};
var G__36763 = function (f,arg,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36763__delegate.call(this,f,arg,args);};
G__36763.cljs$lang$maxFixedArity = 2;
G__36763.cljs$lang$applyTo = (function (arglist__36764){
var f = cljs.core.first(arglist__36764);
arglist__36764 = cljs.core.next(arglist__36764);
var arg = cljs.core.first(arglist__36764);
var args = cljs.core.rest(arglist__36764);
return G__36763__delegate(f,arg,args);
});
G__36763.cljs$core$IFn$_invoke$arity$variadic = G__36763__delegate;
return G__36763;
})()
;
mapply = function(f,arg,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return mapply__2.call(this,f,arg);
default:
return mapply__3.cljs$core$IFn$_invoke$arity$variadic(f,arg, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapply.cljs$lang$maxFixedArity = 2;
mapply.cljs$lang$applyTo = mapply__3.cljs$lang$applyTo;
mapply.cljs$core$IFn$_invoke$arity$2 = mapply__2;
mapply.cljs$core$IFn$_invoke$arity$variadic = mapply__3.cljs$core$IFn$_invoke$arity$variadic;
return mapply;
})()
;

//# sourceMappingURL=core.js.map