// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.util');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.core');
goog.require('om.core');
goog.require('om.core');
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping(s)
* from the latter (left-to-right) will be combined with the mapping in
* the result by looking up the proper merge function and in the
* supplied map of key -> merge-fn and using that for the big merge. If
* a key doesn't have a merge function, the right value wins (as with
* merge).
*/
om_bootstrap.util.merge_with_fns = (function merge_with_fns(k__GT_fn,maps){var merge_entry = (function merge_entry(m,e){var k = cljs.core.key.call(null,e);var v = cljs.core.val.call(null,e);var temp__4124__auto__ = (function (){var and__3529__auto__ = cljs.core.contains_QMARK_.call(null,m,k);if(and__3529__auto__)
{return k__GT_fn.call(null,k);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4124__auto__))
{var f = temp__4124__auto__;return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),v));
} else
{return cljs.core.assoc.call(null,m,k,v);
}
});
var merge = (function merge(m1,m2){return cljs.core.reduce.call(null,merge_entry,(function (){var or__3541__auto__ = m1;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq.call(null,m2));
});
return cljs.core.reduce.call(null,merge,cljs.core.PersistentArrayMap.EMPTY,maps);
});
var ufv___36095 = schema.utils.use_fn_validation;var output_schema36090_36096 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null);var input_schema36091_36097 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"x","x",-555367584,null))], null);var input_checker36092_36098 = schema.core.checker.call(null,input_schema36091_36097);var output_checker36093_36099 = schema.core.checker.call(null,output_schema36090_36096);/**
* Inputs: [x :- s/Any]
* Returns: [s/Any]
*/
om_bootstrap.util.collectify = ((function (ufv___36095,output_schema36090_36096,input_schema36091_36097,input_checker36092_36098,output_checker36093_36099){
return (function collectify(G__36094){var validate__13975__auto__ = ufv___36095.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36100 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36094], null);var temp__4126__auto___36101 = input_checker36092_36098.call(null,args__13976__auto___36100);if(cljs.core.truth_(temp__4126__auto___36101))
{var error__13977__auto___36102 = temp__4126__auto___36101;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"collectify","collectify",-1779603030,null),cljs.core.pr_str.call(null,error__13977__auto___36102)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36091_36097,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36100,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36102], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var x = G__36094;while(true){
if(cljs.core.sequential_QMARK_.call(null,x))
{return x;
} else
{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36103 = output_checker36093_36099.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36103))
{var error__13977__auto___36104 = temp__4126__auto___36103;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"collectify","collectify",-1779603030,null),cljs.core.pr_str.call(null,error__13977__auto___36104)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36090_36096,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36104], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36095,output_schema36090_36096,input_schema36091_36097,input_checker36092_36098,output_checker36093_36099))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.collectify),schema.core.make_fn_schema.call(null,output_schema36090_36096,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36091_36097], null)));
var ufv___36110 = schema.utils.use_fn_validation;var output_schema36105_36111 = schema.core.Bool;var input_schema36106_36112 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker36107_36113 = schema.core.checker.call(null,input_schema36106_36112);var output_checker36108_36114 = schema.core.checker.call(null,output_schema36105_36111);/**
* Inputs: [child]
* Returns: s/Bool
* 
* TODO: Once Om updates its externs to include this file, we can
* remove the janky aget call.
*/
om_bootstrap.util.strict_valid_component_QMARK_ = ((function (ufv___36110,output_schema36105_36111,input_schema36106_36112,input_checker36107_36113,output_checker36108_36114){
return (function strict_valid_component_QMARK_(G__36109){var validate__13975__auto__ = ufv___36110.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36115 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36109], null);var temp__4126__auto___36116 = input_checker36107_36113.call(null,args__13976__auto___36115);if(cljs.core.truth_(temp__4126__auto___36116))
{var error__13977__auto___36117 = temp__4126__auto___36116;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"strict-valid-component?","strict-valid-component?",130165335,null),cljs.core.pr_str.call(null,error__13977__auto___36117)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36106_36112,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36115,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36117], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var child = G__36109;while(true){
return (React["isValidComponent"]).call(null,child);
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36118 = output_checker36108_36114.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36118))
{var error__13977__auto___36119 = temp__4126__auto___36118;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"strict-valid-component?","strict-valid-component?",130165335,null),cljs.core.pr_str.call(null,error__13977__auto___36119)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36105_36111,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36119], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36110,output_schema36105_36111,input_schema36106_36112,input_checker36107_36113,output_checker36108_36114))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.strict_valid_component_QMARK_),schema.core.make_fn_schema.call(null,output_schema36105_36111,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36106_36112], null)));
var ufv___36125 = schema.utils.use_fn_validation;var output_schema36120_36126 = schema.core.Bool;var input_schema36121_36127 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker36122_36128 = schema.core.checker.call(null,input_schema36121_36127);var output_checker36123_36129 = schema.core.checker.call(null,output_schema36120_36126);/**
* Inputs: [child]
* Returns: s/Bool
* 
* Returns true if the supplied argument is a valid React component,
* false otherwise.
*/
om_bootstrap.util.valid_component_QMARK_ = ((function (ufv___36125,output_schema36120_36126,input_schema36121_36127,input_checker36122_36128,output_checker36123_36129){
return (function valid_component_QMARK_(G__36124){var validate__13975__auto__ = ufv___36125.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36130 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36124], null);var temp__4126__auto___36131 = input_checker36122_36128.call(null,args__13976__auto___36130);if(cljs.core.truth_(temp__4126__auto___36131))
{var error__13977__auto___36132 = temp__4126__auto___36131;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"valid-component?","valid-component?",-519675438,null),cljs.core.pr_str.call(null,error__13977__auto___36132)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36121_36127,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36130,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36132], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var child = G__36124;while(true){
var or__3541__auto__ = typeof child === 'string';if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = typeof child === 'number';if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{return om_bootstrap.util.strict_valid_component_QMARK_.call(null,child);
}
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36133 = output_checker36123_36129.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36133))
{var error__13977__auto___36134 = temp__4126__auto___36133;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"valid-component?","valid-component?",-519675438,null),cljs.core.pr_str.call(null,error__13977__auto___36134)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36120_36126,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36134], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36125,output_schema36120_36126,input_schema36121_36127,input_checker36122_36128,output_checker36123_36129))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.valid_component_QMARK_),schema.core.make_fn_schema.call(null,output_schema36120_36126,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36121_36127], null)));
var ufv___36140 = schema.utils.use_fn_validation;var output_schema36135_36141 = schema.core.Bool;var input_schema36136_36142 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker36137_36143 = schema.core.checker.call(null,input_schema36136_36142);var output_checker36138_36144 = schema.core.checker.call(null,output_schema36135_36141);/**
* Inputs: [children]
* Returns: s/Bool
* 
* Returns true if the supplied sequence contains some valid React component,
* false otherwise.
*/
om_bootstrap.util.some_valid_component_QMARK_ = ((function (ufv___36140,output_schema36135_36141,input_schema36136_36142,input_checker36137_36143,output_checker36138_36144){
return (function some_valid_component_QMARK_(G__36139){var validate__13975__auto__ = ufv___36140.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36145 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36139], null);var temp__4126__auto___36146 = input_checker36137_36143.call(null,args__13976__auto___36145);if(cljs.core.truth_(temp__4126__auto___36146))
{var error__13977__auto___36147 = temp__4126__auto___36146;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"some-valid-component?","some-valid-component?",-171767082,null),cljs.core.pr_str.call(null,error__13977__auto___36147)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36136_36142,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36145,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36147], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var children = G__36139;while(true){
return cljs.core.boolean$.call(null,cljs.core.some.call(null,om_bootstrap.util.valid_component_QMARK_,children));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36148 = output_checker36138_36144.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36148))
{var error__13977__auto___36149 = temp__4126__auto___36148;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"some-valid-component?","some-valid-component?",-171767082,null),cljs.core.pr_str.call(null,error__13977__auto___36149)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36135_36141,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36149], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36140,output_schema36135_36141,input_schema36136_36142,input_checker36137_36143,output_checker36138_36144))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.some_valid_component_QMARK_),schema.core.make_fn_schema.call(null,output_schema36135_36141,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36136_36142], null)));
/**
* Generates a new function that calls each supplied side-effecting
* function.
*/
om_bootstrap.util.chain_fns = (function chain_fns(l,r){if(cljs.core.truth_((function (){var and__3529__auto__ = l;if(cljs.core.truth_(and__3529__auto__))
{return r;
} else
{return and__3529__auto__;
}
})()))
{return (function() { 
var G__36150__delegate = function (args){cljs.core.apply.call(null,l,args);
return cljs.core.apply.call(null,r,args);
};
var G__36150 = function (var_args){
var args = null;if (arguments.length > 0) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return G__36150__delegate.call(this,args);};
G__36150.cljs$lang$maxFixedArity = 0;
G__36150.cljs$lang$applyTo = (function (arglist__36151){
var args = cljs.core.seq(arglist__36151);
return G__36150__delegate(args);
});
G__36150.cljs$core$IFn$_invoke$arity$variadic = G__36150__delegate;
return G__36150;
})()
;
} else
{var or__3541__auto__ = l;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return r;
}
}
});
/**
* Map of React keyword to a custom function for its merge. Tries to
* do a decent job with event handlers as well; currently only
* handles :on-select :on-click, :on-blur, kebab-cased as om-tools
* prefers.
*/
om_bootstrap.util.react_merges = (function (){var merge_class = (function (l,r){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(l)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(r));
});var empty_fn = ((function (merge_class){
return (function (_,___$1){return null;
});})(merge_class))
;return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"className","className",-1983287057),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"on-select","on-select",-192407950),new cljs.core.Keyword(null,"class","class",-2030961996)],[empty_fn,empty_fn,empty_fn,om_bootstrap.util.chain_fns,om_bootstrap.util.chain_fns,merge_class,cljs.core.merge,om_bootstrap.util.chain_fns,merge_class]);
})();
/**
* Merges two maps that represent React properties. Merges occur
* according to the functions defined in `react-merges`.
* @param {...*} var_args
*/
om_bootstrap.util.merge_props = (function() { 
var merge_props__delegate = function (prop_maps){var react_merge = (function react_merge(xs){return om_bootstrap.util.merge_with_fns.call(null,om_bootstrap.util.react_merges,xs);
});
var normalize_class = (function normalize_class(m){if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"class","class",-2030961996)))
{return react_merge.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.dissoc.call(null,m,new cljs.core.Keyword(null,"class","class",-2030961996)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(m)], null)], null));
} else
{return m;
}
});
return react_merge.call(null,cljs.core.map.call(null,normalize_class,prop_maps));
};
var merge_props = function (var_args){
var prop_maps = null;if (arguments.length > 0) {
  prop_maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return merge_props__delegate.call(this,prop_maps);};
merge_props.cljs$lang$maxFixedArity = 0;
merge_props.cljs$lang$applyTo = (function (arglist__36152){
var prop_maps = cljs.core.seq(arglist__36152);
return merge_props__delegate(prop_maps);
});
merge_props.cljs$core$IFn$_invoke$arity$variadic = merge_props__delegate;
return merge_props;
})()
;
/**
* Returns a basic, shallow copy of the supplied JS object.
*/
om_bootstrap.util.copy_js = (function copy_js(arr){var ret = (function (){var obj36160 = {};return obj36160;
})();var seq__36161_36165 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,arr));var chunk__36162_36166 = null;var count__36163_36167 = (0);var i__36164_36168 = (0);while(true){
if((i__36164_36168 < count__36163_36167))
{var k_36169 = cljs.core._nth.call(null,chunk__36162_36166,i__36164_36168);if(cljs.core.truth_(arr.hasOwnProperty(k_36169)))
{(ret[k_36169] = (arr[k_36169]));
} else
{}
{
var G__36170 = seq__36161_36165;
var G__36171 = chunk__36162_36166;
var G__36172 = count__36163_36167;
var G__36173 = (i__36164_36168 + (1));
seq__36161_36165 = G__36170;
chunk__36162_36166 = G__36171;
count__36163_36167 = G__36172;
i__36164_36168 = G__36173;
continue;
}
} else
{var temp__4126__auto___36174 = cljs.core.seq.call(null,seq__36161_36165);if(temp__4126__auto___36174)
{var seq__36161_36175__$1 = temp__4126__auto___36174;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36161_36175__$1))
{var c__4297__auto___36176 = cljs.core.chunk_first.call(null,seq__36161_36175__$1);{
var G__36177 = cljs.core.chunk_rest.call(null,seq__36161_36175__$1);
var G__36178 = c__4297__auto___36176;
var G__36179 = cljs.core.count.call(null,c__4297__auto___36176);
var G__36180 = (0);
seq__36161_36165 = G__36177;
chunk__36162_36166 = G__36178;
count__36163_36167 = G__36179;
i__36164_36168 = G__36180;
continue;
}
} else
{var k_36181 = cljs.core.first.call(null,seq__36161_36175__$1);if(cljs.core.truth_(arr.hasOwnProperty(k_36181)))
{(ret[k_36181] = (arr[k_36181]));
} else
{}
{
var G__36182 = cljs.core.next.call(null,seq__36161_36175__$1);
var G__36183 = null;
var G__36184 = (0);
var G__36185 = (0);
seq__36161_36165 = G__36182;
chunk__36162_36166 = G__36183;
count__36163_36167 = G__36184;
i__36164_36168 = G__36185;
continue;
}
}
} else
{}
}
break;
}
return ret;
});
/**
* Merges the supplied extra properties into the underlying Om cursor
* and calls the constructor to clone the React component.
* 
* Requires that the supplied child has an Om cursor attached to it!
*/
om_bootstrap.util.clone_om = (function clone_om(child,extra_props){var om_props = om.core.get_props.call(null,child);return child.constructor((function (){var G__36187 = om_bootstrap.util.copy_js.call(null,child.props);(G__36187["__om_cursor"] = ((cljs.core.fn_QMARK_.call(null,extra_props))?extra_props.call(null,om_props):om_bootstrap.util.merge_props.call(null,om_props,extra_props)));
return G__36187;
})());
});
/**
* This function is called if the React component child was NOT
* generated by Om. Merges the supplied properties into the -props
* field of the supplied React component and creates a shallow copy.
*/
om_bootstrap.util.clone_basic_react = (function clone_basic_react(child,extra_props){var props = cljs.core.js__GT_clj.call(null,child.props,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);var new_props = cljs.core.merge.call(null,((cljs.core.fn_QMARK_.call(null,extra_props))?extra_props.call(null,props):om_bootstrap.util.merge_props.call(null,props,extra_props)),(function (){var temp__4126__auto__ = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(props);if(cljs.core.truth_(temp__4126__auto__))
{var children = temp__4126__auto__;return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"children","children",-940561982),children], null);
} else
{return null;
}
})());return child.constructor(cljs.core.clj__GT_js.call(null,new_props));
});
/**
* Returns a shallow copy of the supplied component (child); the copy
* will have any props provided by extra-props merged in. Props are
* merged in the same manner as merge-props, so props like :class will
* be merged intelligently.
* 
* extra-props can be a function of the old props that returns new
* props, OR it can be a map of props.
* 
* If the supplied child is an Om component, any supplied extra
* properties will be merged into the underlying cursor and accessible
* in the Om constructor.
*/
om_bootstrap.util.clone_with_props = (function() {
var clone_with_props = null;
var clone_with_props__1 = (function (child){return clone_with_props.call(null,child,cljs.core.PersistentArrayMap.EMPTY);
});
var clone_with_props__2 = (function (child,extra_props){if(cljs.core.not.call(null,om_bootstrap.util.strict_valid_component_QMARK_.call(null,child)))
{return child;
} else
{if((cljs.core.map_QMARK_.call(null,extra_props)) && (cljs.core.empty_QMARK_.call(null,extra_props)))
{return child.constructor(child.props);
} else
{if(cljs.core.truth_(om.core.get_props.call(null,child)))
{return om_bootstrap.util.clone_om.call(null,child,extra_props);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return om_bootstrap.util.clone_basic_react.call(null,child,extra_props);
} else
{return null;
}
}
}
}
});
clone_with_props = function(child,extra_props){
switch(arguments.length){
case 1:
return clone_with_props__1.call(this,child);
case 2:
return clone_with_props__2.call(this,child,extra_props);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clone_with_props.cljs$core$IFn$_invoke$arity$1 = clone_with_props__1;
clone_with_props.cljs$core$IFn$_invoke$arity$2 = clone_with_props__2;
return clone_with_props;
})()
;

//# sourceMappingURL=util.js.map