// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.mixins');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('schema.core');
goog.require('schema.core');
goog.require('om_tools.mixin');
goog.require('om.core');
goog.require('om.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
var ufv___36195 = schema.utils.use_fn_validation;var output_schema36188_36196 = schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));var input_schema36189_36197 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"target","target",1893533248,null)),schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"event-type","event-type",1960254340,null)),schema.core.one.call(null,schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null)),new cljs.core.Symbol(null,"callback","callback",935395299,null))], null);var input_checker36190_36198 = schema.core.checker.call(null,input_schema36189_36197);var output_checker36191_36199 = schema.core.checker.call(null,output_schema36188_36196);/**
* Inputs: [target :- s/Any event-type :- s/Str callback :- (sm/=> s/Any s/Any)]
* Returns: (sm/=> s/Any)
* 
* Registers the callback on the supplied target for events of type
* `event-type`. Returns a function of no arguments that, when called,
* unregisters the callback.
*/
om_bootstrap.mixins.event_listener = ((function (ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199){
return (function event_listener(G__36192,G__36193,G__36194){var validate__13975__auto__ = ufv___36195.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___36200 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36192,G__36193,G__36194], null);var temp__4126__auto___36201 = input_checker36190_36198.call(null,args__13976__auto___36200);if(cljs.core.truth_(temp__4126__auto___36201))
{var error__13977__auto___36202 = temp__4126__auto___36201;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"event-listener","event-listener",809979412,null),cljs.core.pr_str.call(null,error__13977__auto___36202)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36189_36197,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___36200,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36202], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var target = G__36192;var event_type = G__36193;var callback = G__36194;while(true){
if(cljs.core.truth_(target.addEventListener))
{target.addEventListener(event_type,callback,false);
return ((function (validate__13975__auto__,ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199){
return (function (){return target.removeEventListener(event_type,callback,false);
});
;})(validate__13975__auto__,ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199))
} else
{if(cljs.core.truth_(target.attachEvent))
{var event_type__$1 = ("on"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type));target.attachEvent(event_type__$1,callback);
return ((function (event_type__$1,validate__13975__auto__,ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199){
return (function (){return target.detachEvent(event_type__$1,callback);
});
;})(event_type__$1,validate__13975__auto__,ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199))
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return ((function (validate__13975__auto__,ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199){
return (function (){return null;
});
;})(validate__13975__auto__,ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199))
} else
{return null;
}
}
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___36203 = output_checker36191_36199.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___36203))
{var error__13977__auto___36204 = temp__4126__auto___36203;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"event-listener","event-listener",809979412,null),cljs.core.pr_str.call(null,error__13977__auto___36204)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36188_36196,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___36204], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___36195,output_schema36188_36196,input_schema36189_36197,input_checker36190_36198,output_checker36191_36199))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.mixins.event_listener),schema.core.make_fn_schema.call(null,output_schema36188_36196,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36189_36197], null)));
/**
* Handles a sequence of listeners for the component, and removes them
* from the document when the component is unmounted.
*/
om_bootstrap.mixins.set_listener_mixin = {"set_listener": (function (target36209,event_type36210,callback36211){var this36208 = this;return ((function (this36208){
return (function (owner,target,event_type,callback){var remove_fn = om_bootstrap.mixins.event_listener.call(null,target,event_type,callback);return owner.listeners.push(remove_fn);
});})(this36208))
.call(null,this36208,target36209,event_type36210,callback36211);
}), "componentWillUnmount": (function (){var this36207 = this;return ((function (this36207){
return (function (owner){return owner.listeners.map(((function (this36207){
return (function (p1__36205_SHARP_){return p1__36205_SHARP_.call(null);
});})(this36207))
);
});})(this36207))
.call(null,this36207);
}), "componentWillMount": (function (){var this36206 = this;return ((function (this36206){
return (function (owner){return owner.listeners = [];
});})(this36206))
.call(null,this36206);
})};
/**
* Handles a sequence of timeouts for the component, and removes them
* from the document when the component is unmounted.
*/
om_bootstrap.mixins.set_timeout_mixin = {"set_timeout": (function (f36216,timeout36217){var this36215 = this;return ((function (this36215){
return (function (owner,f,timeout){var timeout__$1 = setTimeout(f,timeout);return owner.timeouts.push(timeout__$1);
});})(this36215))
.call(null,this36215,f36216,timeout36217);
}), "componentWillUnmount": (function (){var this36214 = this;return ((function (this36214){
return (function (owner){return owner.timeouts.map(((function (this36214){
return (function (p1__36212_SHARP_){return clearTimeout(p1__36212_SHARP_);
});})(this36214))
);
});})(this36214))
.call(null,this36214);
}), "componentWillMount": (function (){var this36213 = this;return ((function (this36213){
return (function (owner){return owner.timeouts = [];
});})(this36213))
.call(null,this36213);
})};
/**
* Accepts two DOM elements; returns true if the supplied node is
* nested inside the supplied root, false otherwise.
*/
om_bootstrap.mixins.in_root_QMARK_ = (function in_root_QMARK_(node,root){var node__$1 = node;while(true){
if((node__$1 == null))
{return false;
} else
{if(cljs.core._EQ_.call(null,root,node__$1))
{return true;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{{
var G__36218 = node__$1.parentNode;
node__$1 = G__36218;
continue;
}
} else
{return null;
}
}
}
break;
}
});
om_bootstrap.mixins.ESCAPE_KEY = (27);
/**
* For dropdowns, binds a handler for that sets the dropdown-mixin's
* `:open?` state to false if the user clicks outside the owning
* component OR hits the escape key.
*/
om_bootstrap.mixins.bind_root_close_handlers_BANG_ = (function bind_root_close_handlers_BANG_(owner){var set_state = (owner["setDropdownState"]);return owner.dropdownListeners = [om_bootstrap.mixins.event_listener.call(null,document,"click",((function (set_state){
return (function (e){if(om_bootstrap.mixins.in_root_QMARK_.call(null,e.target,om.core.get_node.call(null,owner)))
{return null;
} else
{return set_state.call(null,false);
}
});})(set_state))
),om_bootstrap.mixins.event_listener.call(null,document,"keyup",((function (set_state){
return (function (e){if(cljs.core._EQ_.call(null,om_bootstrap.mixins.ESCAPE_KEY,e.keyCode))
{return set_state.call(null,false);
} else
{return null;
}
});})(set_state))
)];
});
/**
* If they're present on the owning object, removes the listeners
* registered by the dropdown mixin.
*/
om_bootstrap.mixins.unbind_root_close_handlers_BANG_ = (function unbind_root_close_handlers_BANG_(owner){var temp__4126__auto__ = owner.dropdownListeners;if(cljs.core.truth_(temp__4126__auto__))
{var listeners = temp__4126__auto__;cljs.core.map.call(null,((function (listeners,temp__4126__auto__){
return (function (p1__36219_SHARP_){return p1__36219_SHARP_.call(null);
});})(listeners,temp__4126__auto__))
,listeners);
return owner.dropdownListeners = null;
} else
{return null;
}
});
/**
* Mixin that manages a single piece of state - :open?. If a user
* clicks outside the component's owning dom element OR hits the escape
* key, the state will jump back to false.
* 
* Down the road this may need to register a callback when the state
* changes.
*/
om_bootstrap.mixins.dropdown_mixin = {"setDropdownState": (function (open_QMARK_36224){var this36223 = this;return ((function (this36223){
return (function (owner,open_QMARK_){if(cljs.core.truth_(open_QMARK_))
{om_bootstrap.mixins.bind_root_close_handlers_BANG_.call(null,owner);
} else
{om_bootstrap.mixins.unbind_root_close_handlers_BANG_.call(null,owner);
}
return om.core.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"open?","open?",1238443125)], null),open_QMARK_);
});})(this36223))
.call(null,this36223,open_QMARK_36224);
}), "isDropdownOpen": (function (){var this36222 = this;return ((function (this36222){
return (function (owner){return om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"open?","open?",1238443125));
});})(this36222))
.call(null,this36222);
}), "componentWillUnmount": (function (){var this36221 = this;return ((function (this36221){
return (function (owner){return om_bootstrap.mixins.unbind_root_close_handlers_BANG_.call(null,owner);
});})(this36221))
.call(null,this36221);
}), "getInitialState": (function (){var this36220 = this;return ((function (this36220){
return (function (_){return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null);
});})(this36220))
.call(null,this36220);
})};

//# sourceMappingURL=mixins.js.map