// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.input');
goog.require('cljs.core');
goog.require('om_bootstrap.types');
goog.require('schema.core');
goog.require('om_bootstrap.util');
goog.require('om_tools.dom');
goog.require('schema.core');
goog.require('clojure.string');
goog.require('om_bootstrap.util');
goog.require('om.core');
goog.require('om.core');
goog.require('clojure.string');
goog.require('om_bootstrap.types');
goog.require('om_tools.dom');
om_bootstrap.input.Addons = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384)),schema.core.either.call(null,schema.core.Str,om_bootstrap.types.Component),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"addon-after","addon-after",634985306)),schema.core.either.call(null,schema.core.Str,om_bootstrap.types.Component)], true, false);
/**
* Helps render feedback icons.
*/
om_bootstrap.input.FeedbackIcons = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)),schema.core.enum$.call(null,"success","warning","error"),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821)),schema.core.Bool], true, false);
/**
* Input fields that match these bad dawgs:
* https://github.com/react-bootstrap/react-bootstrap/blob/master/src/Input.jsx
*/
om_bootstrap.input.Input = cljs.core.merge.call(null,om_bootstrap.input.Addons,om_bootstrap.input.FeedbackIcons,new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"type","type",1174270348)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label","label",1718410804)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"skip-form-group?","skip-form-group?",210862261)),schema.core.named.call(null,schema.core.Bool,"DON'T render a wrapping form group?"),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"help","help",-439233446)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212)),schema.core.Str], true, false));
om_bootstrap.input.Radio = om_bootstrap.types.bootstrap.call(null,new cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"label","label",1718410804),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"checked?","checked?",2024809091)),schema.core.Bool,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791)),schema.core.Bool], true, false));
var ufv___37252 = schema.utils.use_fn_validation;var output_schema37243_37253 = schema.core.Str;var input_schema37244_37254 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.Str,schema.core.Keyword),schema.core.Bool], true, false),new cljs.core.Symbol(null,"klasses","klasses",-380235757,null))], null);var input_checker37245_37255 = schema.core.checker.call(null,input_schema37244_37254);var output_checker37246_37256 = schema.core.checker.call(null,output_schema37243_37253);/**
* Inputs: [klasses :- {(s/either s/Str s/Keyword) s/Bool}]
* Returns: s/Str
* 
* Mimics the class-set behavior from React. Pass in a map of
* potential class to Boolean; you'll get back a class string that
* represents the final class to apply.
* 
* TODO: Use class-set from om-tools.
*/
om_bootstrap.input.class_set = ((function (ufv___37252,output_schema37243_37253,input_schema37244_37254,input_checker37245_37255,output_checker37246_37256){
return (function class_set(G__37247){var validate__13975__auto__ = ufv___37252.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37257 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37247], null);var temp__4126__auto___37258 = input_checker37245_37255.call(null,args__13976__auto___37257);if(cljs.core.truth_(temp__4126__auto___37258))
{var error__13977__auto___37259 = temp__4126__auto___37258;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"class-set","class-set",-355600496,null),cljs.core.pr_str.call(null,error__13977__auto___37259)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37244_37254,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37257,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37259], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var klasses = G__37247;while(true){
return clojure.string.join.call(null," ",cljs.core.mapcat.call(null,((function (validate__13975__auto__,ufv___37252,output_schema37243_37253,input_schema37244_37254,input_checker37245_37255,output_checker37246_37256){
return (function (p__37250){var vec__37251 = p__37250;var k = cljs.core.nth.call(null,vec__37251,(0),null);var keep_QMARK_ = cljs.core.nth.call(null,vec__37251,(1),null);if(cljs.core.truth_(keep_QMARK_))
{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.name.call(null,k)], null);
} else
{return null;
}
});})(validate__13975__auto__,ufv___37252,output_schema37243_37253,input_schema37244_37254,input_checker37245_37255,output_checker37246_37256))
,klasses));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37260 = output_checker37246_37256.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37260))
{var error__13977__auto___37261 = temp__4126__auto___37260;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"class-set","class-set",-355600496,null),cljs.core.pr_str.call(null,error__13977__auto___37261)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37243_37253,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37261], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37252,output_schema37243_37253,input_schema37244_37254,input_checker37245_37255,output_checker37246_37256))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.class_set),schema.core.make_fn_schema.call(null,output_schema37243_37253,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37244_37254], null)));
var ufv___37267 = schema.utils.use_fn_validation;var output_schema37262_37268 = om_bootstrap.types.Component;var input_schema37263_37269 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"glyph-name","glyph-name",350405338,null))], null);var input_checker37264_37270 = schema.core.checker.call(null,input_schema37263_37269);var output_checker37265_37271 = schema.core.checker.call(null,output_schema37262_37268);/**
* Inputs: [glyph-name :- s/Str]
* Returns: t/Component
* 
* To be used with :addon-before or :addon-after.
*/
om_bootstrap.input.glyph = ((function (ufv___37267,output_schema37262_37268,input_schema37263_37269,input_checker37264_37270,output_checker37265_37271){
return (function glyph(G__37266){var validate__13975__auto__ = ufv___37267.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37272 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37266], null);var temp__4126__auto___37273 = input_checker37264_37270.call(null,args__13976__auto___37272);if(cljs.core.truth_(temp__4126__auto___37273))
{var error__13977__auto___37274 = temp__4126__auto___37273;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"glyph","glyph",-534987652,null),cljs.core.pr_str.call(null,error__13977__auto___37274)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37263_37269,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37272,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37274], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var glyph_name = G__37266;while(true){
return React.DOM.span({"className": om_tools.dom.format_opts.call(null,("glyphicon glyphicon-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(glyph_name)))});
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37275 = output_checker37265_37271.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37275))
{var error__13977__auto___37276 = temp__4126__auto___37275;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"glyph","glyph",-534987652,null),cljs.core.pr_str.call(null,error__13977__auto___37276)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37262_37268,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37276], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37267,output_schema37262_37268,input_schema37263_37269,input_checker37264_37270,output_checker37265_37271))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.glyph),schema.core.make_fn_schema.call(null,output_schema37262_37268,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37263_37269], null)));
var ufv___37290 = schema.utils.use_fn_validation;var output_schema37277_37291 = om_bootstrap.types.Component;var input_schema37278_37292 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.FeedbackIcons,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker37279_37293 = schema.core.checker.call(null,input_schema37278_37292);var output_checker37280_37294 = schema.core.checker.call(null,output_schema37277_37291);/**
* Inputs: [{:keys [feedback? bs-style]} :- FeedbackIcons]
* Returns: t/Component
*/
om_bootstrap.input.render_icon = ((function (ufv___37290,output_schema37277_37291,input_schema37278_37292,input_checker37279_37293,output_checker37280_37294){
return (function render_icon(G__37281){var validate__13975__auto__ = ufv___37290.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37295 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37281], null);var temp__4126__auto___37296 = input_checker37279_37293.call(null,args__13976__auto___37295);if(cljs.core.truth_(temp__4126__auto___37296))
{var error__13977__auto___37297 = temp__4126__auto___37296;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-icon","render-icon",511977669,null),cljs.core.pr_str.call(null,error__13977__auto___37297)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37278_37292,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37295,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37297], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37287 = G__37281;var map__37288 = G__37287;var map__37288__$1 = ((cljs.core.seq_QMARK_.call(null,map__37288))?cljs.core.apply.call(null,cljs.core.hash_map,map__37288):map__37288);var bs_style = cljs.core.get.call(null,map__37288__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var feedback_QMARK_ = cljs.core.get.call(null,map__37288__$1,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821));var G__37287__$1 = G__37287;while(true){
var map__37289 = G__37287__$1;var map__37289__$1 = ((cljs.core.seq_QMARK_.call(null,map__37289))?cljs.core.apply.call(null,cljs.core.hash_map,map__37289):map__37289);var bs_style__$1 = cljs.core.get.call(null,map__37289__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var feedback_QMARK___$1 = cljs.core.get.call(null,map__37289__$1,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821));if(cljs.core.truth_(feedback_QMARK___$1))
{var klasses = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"glyphicon","glyphicon",-2083132161),true,new cljs.core.Keyword(null,"form-control-feedback","form-control-feedback",-26248681),true,new cljs.core.Keyword(null,"glyphicon-ok","glyphicon-ok",-980475854),cljs.core._EQ_.call(null,"success",bs_style__$1),new cljs.core.Keyword(null,"glyphicon-warning-sign","glyphicon-warning-sign",-715964093),cljs.core._EQ_.call(null,"warning",bs_style__$1),new cljs.core.Keyword(null,"glyphicon-remove","glyphicon-remove",16420020),cljs.core._EQ_.call(null,"error",bs_style__$1)], null);return React.DOM.span({"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,klasses))});
} else
{return null;
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37298 = output_checker37280_37294.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37298))
{var error__13977__auto___37299 = temp__4126__auto___37298;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-icon","render-icon",511977669,null),cljs.core.pr_str.call(null,error__13977__auto___37299)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37277_37291,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37299], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37290,output_schema37277_37291,input_schema37278_37292,input_checker37279_37293,output_checker37280_37294))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_icon),schema.core.make_fn_schema.call(null,output_schema37277_37291,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37278_37292], null)));
var ufv___37305 = schema.utils.use_fn_validation;var output_schema37300_37306 = schema.core.Any;var input_schema37301_37307 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.maybe.call(null,schema.core.Str),new cljs.core.Symbol(null,"help","help",1201298081,null))], null);var input_checker37302_37308 = schema.core.checker.call(null,input_schema37301_37307);var output_checker37303_37309 = schema.core.checker.call(null,output_schema37300_37306);/**
* Inputs: [help :- (s/maybe s/Str)]
*/
om_bootstrap.input.render_help = ((function (ufv___37305,output_schema37300_37306,input_schema37301_37307,input_checker37302_37308,output_checker37303_37309){
return (function render_help(G__37304){var validate__13975__auto__ = ufv___37305.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37304], null);var temp__4126__auto___37311 = input_checker37302_37308.call(null,args__13976__auto___37310);if(cljs.core.truth_(temp__4126__auto___37311))
{var error__13977__auto___37312 = temp__4126__auto___37311;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-help","render-help",-1879333594,null),cljs.core.pr_str.call(null,error__13977__auto___37312)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37301_37307,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37310,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37312], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var help = G__37304;while(true){
if(cljs.core.truth_(help))
{return cljs.core.apply.call(null,React.DOM.span,{"className": "help-block"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[help],null))));
} else
{return null;
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37313 = output_checker37303_37309.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37313))
{var error__13977__auto___37314 = temp__4126__auto___37313;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-help","render-help",-1879333594,null),cljs.core.pr_str.call(null,error__13977__auto___37314)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37300_37306,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37314], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37305,output_schema37300_37306,input_schema37301_37307,input_checker37302_37308,output_checker37303_37309))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_help),schema.core.make_fn_schema.call(null,output_schema37300_37306,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37301_37307], null)));
var ufv___37329 = schema.utils.use_fn_validation;var output_schema37315_37330 = schema.core.Any;var input_schema37316_37331 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Addons,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"items","items",-1622480831,null))], null);var input_checker37317_37332 = schema.core.checker.call(null,input_schema37316_37331);var output_checker37318_37333 = schema.core.checker.call(null,output_schema37315_37330);/**
* Inputs: [{:keys [addon-before addon-after]} :- Addons items :- s/Any]
* 
* Items is a vector of render instances.
*/
om_bootstrap.input.render_input_group = ((function (ufv___37329,output_schema37315_37330,input_schema37316_37331,input_checker37317_37332,output_checker37318_37333){
return (function render_input_group(G__37319,G__37320){var validate__13975__auto__ = ufv___37329.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37334 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37319,G__37320], null);var temp__4126__auto___37335 = input_checker37317_37332.call(null,args__13976__auto___37334);if(cljs.core.truth_(temp__4126__auto___37335))
{var error__13977__auto___37336 = temp__4126__auto___37335;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-input-group","render-input-group",361721583,null),cljs.core.pr_str.call(null,error__13977__auto___37336)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37316_37331,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37334,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37336], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37326 = G__37319;var map__37327 = G__37326;var map__37327__$1 = ((cljs.core.seq_QMARK_.call(null,map__37327))?cljs.core.apply.call(null,cljs.core.hash_map,map__37327):map__37327);var addon_after = cljs.core.get.call(null,map__37327__$1,new cljs.core.Keyword(null,"addon-after","addon-after",634985306));var addon_before = cljs.core.get.call(null,map__37327__$1,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384));var items = G__37320;var G__37326__$1 = G__37326;var items__$1 = items;while(true){
var map__37328 = G__37326__$1;var map__37328__$1 = ((cljs.core.seq_QMARK_.call(null,map__37328))?cljs.core.apply.call(null,cljs.core.hash_map,map__37328):map__37328);var addon_after__$1 = cljs.core.get.call(null,map__37328__$1,new cljs.core.Keyword(null,"addon-after","addon-after",634985306));var addon_before__$1 = cljs.core.get.call(null,map__37328__$1,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384));var items__$2 = items__$1;if(cljs.core.truth_((function (){var or__3541__auto__ = addon_before__$1;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return addon_after__$1;
}
})()))
{return cljs.core.apply.call(null,React.DOM.div,{"className": "input-group"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(cljs.core.truth_(addon_before__$1)?cljs.core.apply.call(null,React.DOM.span,{"className": "input-group-addon"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[addon_before__$1],null)))):null),items__$2,(cljs.core.truth_(addon_after__$1)?cljs.core.apply.call(null,React.DOM.span,{"className": "input-group-addon"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[addon_after__$1],null)))):null)],null))));
} else
{return items__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37337 = output_checker37318_37333.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37337))
{var error__13977__auto___37338 = temp__4126__auto___37337;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-input-group","render-input-group",361721583,null),cljs.core.pr_str.call(null,error__13977__auto___37338)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37315_37330,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37338], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37329,output_schema37315_37330,input_schema37316_37331,input_checker37317_37332,output_checker37318_37333))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_input_group),schema.core.make_fn_schema.call(null,output_schema37315_37330,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37316_37331], null)));
var ufv___37352 = schema.utils.use_fn_validation;var output_schema37339_37353 = schema.core.Bool;var input_schema37340_37354 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker37341_37355 = schema.core.checker.call(null,input_schema37340_37354);var output_checker37342_37356 = schema.core.checker.call(null,output_schema37339_37353);/**
* Inputs: [{type :type} :- Input]
* Returns: s/Bool
* 
* Returns true if the supplied input is of type checkbox or radio,
* false otherwise.
*/
om_bootstrap.input.checkbox_or_radio_QMARK_ = ((function (ufv___37352,output_schema37339_37353,input_schema37340_37354,input_checker37341_37355,output_checker37342_37356){
return (function checkbox_or_radio_QMARK_(G__37343){var validate__13975__auto__ = ufv___37352.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37357 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37343], null);var temp__4126__auto___37358 = input_checker37341_37355.call(null,args__13976__auto___37357);if(cljs.core.truth_(temp__4126__auto___37358))
{var error__13977__auto___37359 = temp__4126__auto___37358;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio?","checkbox-or-radio?",-1047589288,null),cljs.core.pr_str.call(null,error__13977__auto___37359)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37340_37354,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37357,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37359], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37349 = G__37343;var map__37350 = G__37349;var map__37350__$1 = ((cljs.core.seq_QMARK_.call(null,map__37350))?cljs.core.apply.call(null,cljs.core.hash_map,map__37350):map__37350);var type = cljs.core.get.call(null,map__37350__$1,new cljs.core.Keyword(null,"type","type",1174270348));var G__37349__$1 = G__37349;while(true){
var map__37351 = G__37349__$1;var map__37351__$1 = ((cljs.core.seq_QMARK_.call(null,map__37351))?cljs.core.apply.call(null,cljs.core.hash_map,map__37351):map__37351);var type__$1 = cljs.core.get.call(null,map__37351__$1,new cljs.core.Keyword(null,"type","type",1174270348));return (cljs.core._EQ_.call(null,type__$1,"checkbox")) || (cljs.core._EQ_.call(null,type__$1,"radio"));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37360 = output_checker37342_37356.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37360))
{var error__13977__auto___37361 = temp__4126__auto___37360;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio?","checkbox-or-radio?",-1047589288,null),cljs.core.pr_str.call(null,error__13977__auto___37361)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37339_37353,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37361], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37352,output_schema37339_37353,input_schema37340_37354,input_checker37341_37355,output_checker37342_37356))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.checkbox_or_radio_QMARK_),schema.core.make_fn_schema.call(null,output_schema37339_37353,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37340_37354], null)));
var ufv___37376 = schema.utils.use_fn_validation;var output_schema37362_37377 = om_bootstrap.types.Component;var input_schema37363_37378 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37364_37379 = schema.core.checker.call(null,input_schema37363_37378);var output_checker37365_37380 = schema.core.checker.call(null,output_schema37362_37377);/**
* Inputs: [{type :type} :- Input children]
* Returns: t/Component
* 
* Wraps this business in a div.
*/
om_bootstrap.input.checkbox_or_radio_wrapper = ((function (ufv___37376,output_schema37362_37377,input_schema37363_37378,input_checker37364_37379,output_checker37365_37380){
return (function checkbox_or_radio_wrapper(G__37366,G__37367){var validate__13975__auto__ = ufv___37376.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37381 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37366,G__37367], null);var temp__4126__auto___37382 = input_checker37364_37379.call(null,args__13976__auto___37381);if(cljs.core.truth_(temp__4126__auto___37382))
{var error__13977__auto___37383 = temp__4126__auto___37382;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio-wrapper","checkbox-or-radio-wrapper",-964759132,null),cljs.core.pr_str.call(null,error__13977__auto___37383)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37363_37378,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37381,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37383], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37373 = G__37366;var map__37374 = G__37373;var map__37374__$1 = ((cljs.core.seq_QMARK_.call(null,map__37374))?cljs.core.apply.call(null,cljs.core.hash_map,map__37374):map__37374);var type = cljs.core.get.call(null,map__37374__$1,new cljs.core.Keyword(null,"type","type",1174270348));var children = G__37367;var G__37373__$1 = G__37373;var children__$1 = children;while(true){
var map__37375 = G__37373__$1;var map__37375__$1 = ((cljs.core.seq_QMARK_.call(null,map__37375))?cljs.core.apply.call(null,cljs.core.hash_map,map__37375):map__37375);var type__$1 = cljs.core.get.call(null,map__37375__$1,new cljs.core.Keyword(null,"type","type",1174270348));var children__$2 = children__$1;var klasses = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"checkbox","checkbox",1612615655),cljs.core._EQ_.call(null,"checkbox",type__$1),new cljs.core.Keyword(null,"radio","radio",1323726374),cljs.core._EQ_.call(null,"radio",type__$1)], null);return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,klasses))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children__$2],null))));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37384 = output_checker37365_37380.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37384))
{var error__13977__auto___37385 = temp__4126__auto___37384;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio-wrapper","checkbox-or-radio-wrapper",-964759132,null),cljs.core.pr_str.call(null,error__13977__auto___37385)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37362_37377,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37385], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37376,output_schema37362_37377,input_schema37363_37378,input_checker37364_37379,output_checker37365_37380))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.checkbox_or_radio_wrapper),schema.core.make_fn_schema.call(null,output_schema37362_37377,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37363_37378], null)));
var ufv___37404 = schema.utils.use_fn_validation;var output_schema37386_37405 = schema.core.Any;var input_schema37387_37406 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"input","input",-2097503808,null))], null);var input_schema37391_37407 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker37388_37408 = schema.core.checker.call(null,input_schema37387_37406);var output_checker37389_37409 = schema.core.checker.call(null,output_schema37386_37405);var input_checker37392_37410 = schema.core.checker.call(null,input_schema37391_37407);var output_checker37393_37411 = schema.core.checker.call(null,output_schema37386_37405);/**
* Inputs: ([input :- Input] [{lc :label-classname, label :label, :as input} :- Input child])
* 
* This doesn't handle any control group stuff.
*/
om_bootstrap.input.render_label = ((function (ufv___37404,output_schema37386_37405,input_schema37387_37406,input_schema37391_37407,input_checker37388_37408,output_checker37389_37409,input_checker37392_37410,output_checker37393_37411){
return (function() {
var render_label = null;
var render_label__1 = (function (G__37390){var validate__13975__auto__ = ufv___37404.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37412 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37390], null);var temp__4126__auto___37413 = input_checker37388_37408.call(null,args__13976__auto___37412);if(cljs.core.truth_(temp__4126__auto___37413))
{var error__13977__auto___37414 = temp__4126__auto___37413;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13977__auto___37414)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37387_37406,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37412,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37414], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var input = G__37390;while(true){
return render_label.call(null,input,null);
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37415 = output_checker37389_37409.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37415))
{var error__13977__auto___37416 = temp__4126__auto___37415;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13977__auto___37416)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37386_37405,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37416], null));
} else
{}
} else
{}
return o__13978__auto__;
});
var render_label__2 = (function (G__37394,G__37395){var validate__13975__auto__ = ufv___37404.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37417 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37394,G__37395], null);var temp__4126__auto___37418 = input_checker37392_37410.call(null,args__13976__auto___37417);if(cljs.core.truth_(temp__4126__auto___37418))
{var error__13977__auto___37419 = temp__4126__auto___37418;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13977__auto___37419)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37391_37407,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37417,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37419], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37401 = G__37394;var map__37402 = G__37401;var map__37402__$1 = ((cljs.core.seq_QMARK_.call(null,map__37402))?cljs.core.apply.call(null,cljs.core.hash_map,map__37402):map__37402);var input = map__37402__$1;var lc = cljs.core.get.call(null,map__37402__$1,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212));var label = cljs.core.get.call(null,map__37402__$1,new cljs.core.Keyword(null,"label","label",1718410804));var child = G__37395;var G__37401__$1 = G__37401;var child__$1 = child;while(true){
var map__37403 = G__37401__$1;var map__37403__$1 = ((cljs.core.seq_QMARK_.call(null,map__37403))?cljs.core.apply.call(null,cljs.core.hash_map,map__37403):map__37403);var input__$1 = map__37403__$1;var lc__$1 = cljs.core.get.call(null,map__37403__$1,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212));var label__$1 = cljs.core.get.call(null,map__37403__$1,new cljs.core.Keyword(null,"label","label",1718410804));var child__$2 = child__$1;var classes = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"control-label","control-label",1226436372),!(om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input__$1))], null),(cljs.core.truth_(lc__$1)?new cljs.core.PersistentArrayMap.fromArray([lc__$1,cljs.core.boolean$.call(null,lc__$1)], true, false):null));if(cljs.core.truth_(label__$1))
{return cljs.core.apply.call(null,React.DOM.label,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,classes))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[child__$2,label__$1],null))));
} else
{return child__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37420 = output_checker37393_37411.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37420))
{var error__13977__auto___37421 = temp__4126__auto___37420;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13977__auto___37421)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37386_37405,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37421], null));
} else
{}
} else
{}
return o__13978__auto__;
});
render_label = function(G__37394,G__37395){
switch(arguments.length){
case 1:
return render_label__1.call(this,G__37394);
case 2:
return render_label__2.call(this,G__37394,G__37395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
render_label.cljs$core$IFn$_invoke$arity$1 = render_label__1;
render_label.cljs$core$IFn$_invoke$arity$2 = render_label__2;
return render_label;
})()
;})(ufv___37404,output_schema37386_37405,input_schema37387_37406,input_schema37391_37407,input_checker37388_37408,output_checker37389_37409,input_checker37392_37410,output_checker37393_37411))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_label),schema.core.make_fn_schema.call(null,output_schema37386_37405,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37387_37406,input_schema37391_37407], null)));
var ufv___37436 = schema.utils.use_fn_validation;var output_schema37422_37437 = schema.core.Any;var input_schema37423_37438 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker37424_37439 = schema.core.checker.call(null,input_schema37423_37438);var output_checker37425_37440 = schema.core.checker.call(null,output_schema37422_37437);/**
* Inputs: [{wc :wrapper-classname} :- Input child]
*/
om_bootstrap.input.render_wrapper = ((function (ufv___37436,output_schema37422_37437,input_schema37423_37438,input_checker37424_37439,output_checker37425_37440){
return (function render_wrapper(G__37426,G__37427){var validate__13975__auto__ = ufv___37436.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37441 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37426,G__37427], null);var temp__4126__auto___37442 = input_checker37424_37439.call(null,args__13976__auto___37441);if(cljs.core.truth_(temp__4126__auto___37442))
{var error__13977__auto___37443 = temp__4126__auto___37442;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-wrapper","render-wrapper",79817165,null),cljs.core.pr_str.call(null,error__13977__auto___37443)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37423_37438,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37441,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37443], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37433 = G__37426;var map__37434 = G__37433;var map__37434__$1 = ((cljs.core.seq_QMARK_.call(null,map__37434))?cljs.core.apply.call(null,cljs.core.hash_map,map__37434):map__37434);var wc = cljs.core.get.call(null,map__37434__$1,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866));var child = G__37427;var G__37433__$1 = G__37433;var child__$1 = child;while(true){
var map__37435 = G__37433__$1;var map__37435__$1 = ((cljs.core.seq_QMARK_.call(null,map__37435))?cljs.core.apply.call(null,cljs.core.hash_map,map__37435):map__37435);var wc__$1 = cljs.core.get.call(null,map__37435__$1,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866));var child__$2 = child__$1;if(cljs.core.truth_(wc__$1))
{return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,wc__$1)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[child__$2],null))));
} else
{return child__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37444 = output_checker37425_37440.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37444))
{var error__13977__auto___37445 = temp__4126__auto___37444;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-wrapper","render-wrapper",79817165,null),cljs.core.pr_str.call(null,error__13977__auto___37445)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37422_37437,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37445], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37436,output_schema37422_37437,input_schema37423_37438,input_checker37424_37439,output_checker37425_37440))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_wrapper),schema.core.make_fn_schema.call(null,output_schema37422_37437,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37423_37438], null)));
var ufv___37460 = schema.utils.use_fn_validation;var output_schema37446_37461 = om_bootstrap.types.Component;var input_schema37447_37462 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37448_37463 = schema.core.checker.call(null,input_schema37447_37462);var output_checker37449_37464 = schema.core.checker.call(null,output_schema37446_37461);/**
* Inputs: [{bs-style :bs-style, cn :group-classname, :as input} :- Input children]
* Returns: t/Component
* 
* Wraps the entire form group.
*/
om_bootstrap.input.render_form_group = ((function (ufv___37460,output_schema37446_37461,input_schema37447_37462,input_checker37448_37463,output_checker37449_37464){
return (function render_form_group(G__37450,G__37451){var validate__13975__auto__ = ufv___37460.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37465 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37450,G__37451], null);var temp__4126__auto___37466 = input_checker37448_37463.call(null,args__13976__auto___37465);if(cljs.core.truth_(temp__4126__auto___37466))
{var error__13977__auto___37467 = temp__4126__auto___37466;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-form-group","render-form-group",2039718866,null),cljs.core.pr_str.call(null,error__13977__auto___37467)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37447_37462,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37465,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37467], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var G__37457 = G__37450;var map__37458 = G__37457;var map__37458__$1 = ((cljs.core.seq_QMARK_.call(null,map__37458))?cljs.core.apply.call(null,cljs.core.hash_map,map__37458):map__37458);var input = map__37458__$1;var bs_style = cljs.core.get.call(null,map__37458__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var cn = cljs.core.get.call(null,map__37458__$1,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816));var children = G__37451;var G__37457__$1 = G__37457;var children__$1 = children;while(true){
var map__37459 = G__37457__$1;var map__37459__$1 = ((cljs.core.seq_QMARK_.call(null,map__37459))?cljs.core.apply.call(null,cljs.core.hash_map,map__37459):map__37459);var input__$1 = map__37459__$1;var bs_style__$1 = cljs.core.get.call(null,map__37459__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var cn__$1 = cljs.core.get.call(null,map__37459__$1,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816));var children__$2 = children__$1;var classes = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"form-group","form-group",-267875328),cljs.core.not.call(null,new cljs.core.Keyword(null,"skip-form-group?","skip-form-group?",210862261).cljs$core$IFn$_invoke$arity$1(input__$1)),new cljs.core.Keyword(null,"has-feedback","has-feedback",1328001802),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821).cljs$core$IFn$_invoke$arity$1(input__$1)),new cljs.core.Keyword(null,"has-success","has-success",685004255),cljs.core._EQ_.call(null,"success",bs_style__$1),new cljs.core.Keyword(null,"has-warning","has-warning",1993894136),cljs.core._EQ_.call(null,"warning",bs_style__$1),new cljs.core.Keyword(null,"has-error","has-error",-786302929),cljs.core._EQ_.call(null,"error",bs_style__$1)], null),(cljs.core.truth_(cn__$1)?new cljs.core.PersistentArrayMap.fromArray([cn__$1,cljs.core.boolean$.call(null,cn__$1)], true, false):null));return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,classes))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children__$2],null))));
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37468 = output_checker37449_37464.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37468))
{var error__13977__auto___37469 = temp__4126__auto___37468;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-form-group","render-form-group",2039718866,null),cljs.core.pr_str.call(null,error__13977__auto___37469)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37446_37461,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37469], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37460,output_schema37446_37461,input_schema37447_37462,input_checker37448_37463,output_checker37449_37464))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_form_group),schema.core.make_fn_schema.call(null,output_schema37446_37461,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37447_37462], null)));
var ufv___37479 = schema.utils.use_fn_validation;var output_schema37470_37480 = om_bootstrap.types.Component;var input_schema37471_37481 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"attrs","attrs",-450137186,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37472_37482 = schema.core.checker.call(null,input_schema37471_37481);var output_checker37473_37483 = schema.core.checker.call(null,output_schema37470_37480);/**
* Inputs: [input :- Input attrs children]
* Returns: t/Component
*/
om_bootstrap.input.render_input = ((function (ufv___37479,output_schema37470_37480,input_schema37471_37481,input_checker37472_37482,output_checker37473_37483){
return (function render_input(G__37474,G__37475,G__37476){var validate__13975__auto__ = ufv___37479.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37484 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37474,G__37475,G__37476], null);var temp__4126__auto___37485 = input_checker37472_37482.call(null,args__13976__auto___37484);if(cljs.core.truth_(temp__4126__auto___37485))
{var error__13977__auto___37486 = temp__4126__auto___37485;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-input","render-input",243083212,null),cljs.core.pr_str.call(null,error__13977__auto___37486)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37471_37481,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37484,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37486], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var input = G__37474;var attrs = G__37475;var children = G__37476;while(true){
var props = ((function (validate__13975__auto__,ufv___37479,output_schema37470_37480,input_schema37471_37481,input_checker37472_37482,output_checker37473_37483){
return (function (klass){return om_bootstrap.util.merge_props.call(null,attrs,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),klass,new cljs.core.Keyword(null,"ref","ref",1289896967),"input",new cljs.core.Keyword(null,"key","key",-1516042587),"input"], null));
});})(validate__13975__auto__,ufv___37479,output_schema37470_37480,input_schema37471_37481,input_checker37472_37482,output_checker37473_37483))
;if(cljs.core.not.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input)))
{return children;
} else
{var G__37478 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input);switch (G__37478) {
case "select":
return om_tools.dom.element.call(null,React.DOM.select,props.call(null,"form-control"),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children],null)));

break;
case "textarea":
return om_tools.dom.element.call(null,om.dom.textarea,props.call(null,"form-control"),cljs.core.PersistentVector.EMPTY);

break;
case "static":
return om_tools.dom.element.call(null,React.DOM.p,props.call(null,"form-control-static"),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs)],null)));

break;
default:
return om_tools.dom.element.call(null,om.dom.input,cljs.core.assoc.call(null,props.call(null,((om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input))?"":"form-control")),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input)),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children],null)));

}
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37488 = output_checker37473_37483.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37488))
{var error__13977__auto___37489 = temp__4126__auto___37488;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-input","render-input",243083212,null),cljs.core.pr_str.call(null,error__13977__auto___37489)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37470_37480,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37489], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37479,output_schema37470_37480,input_schema37471_37481,input_checker37472_37482,output_checker37473_37483))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_input),schema.core.make_fn_schema.call(null,output_schema37470_37480,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37471_37481], null)));
var ufv___37498 = schema.utils.use_fn_validation;var output_schema37490_37499 = om_bootstrap.types.Component;var input_schema37491_37500 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"opts","opts",1795607228,null)),schema.core.Any], null);var input_checker37492_37501 = schema.core.checker.call(null,input_schema37491_37500);var output_checker37493_37502 = schema.core.checker.call(null,output_schema37490_37499);/**
* Inputs: [opts :- Input & children]
* Returns: t/Component
* 
* Returns an input component. This currently does NOT handle any of
* the default values or validation messages that we'll need to make
* this work, though.
* @param {...*} var_args
*/
om_bootstrap.input.input = ((function (ufv___37498,output_schema37490_37499,input_schema37491_37500,input_checker37492_37501,output_checker37493_37502){
return (function() { 
var input__delegate = function (G__37494,rest37495){var validate__13975__auto__ = ufv___37498.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37503 = cljs.core.list_STAR_.call(null,G__37494,rest37495);var temp__4126__auto___37504 = input_checker37492_37501.call(null,args__13976__auto___37503);if(cljs.core.truth_(temp__4126__auto___37504))
{var error__13977__auto___37505 = temp__4126__auto___37504;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"input","input",-2097503808,null),cljs.core.pr_str.call(null,error__13977__auto___37505)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37491_37500,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37503,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37505], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var opts = G__37494;var children = rest37495;while(true){
var vec__37497 = om_bootstrap.types.separate.call(null,om_bootstrap.input.Input,opts);var input__$1 = cljs.core.nth.call(null,vec__37497,(0),null);var attrs = cljs.core.nth.call(null,vec__37497,(1),null);if(om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input__$1))
{return om_bootstrap.input.render_form_group.call(null,input__$1,om_bootstrap.input.render_wrapper.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.checkbox_or_radio_wrapper.call(null,input__$1,om_bootstrap.input.render_label.call(null,input__$1,om_bootstrap.input.render_input.call(null,input__$1,attrs,children))),om_bootstrap.input.render_help.call(null,new cljs.core.Keyword(null,"help","help",-439233446).cljs$core$IFn$_invoke$arity$1(input__$1))], null)));
} else
{return om_bootstrap.input.render_form_group.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.render_label.call(null,input__$1),om_bootstrap.input.render_wrapper.call(null,input__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.render_input_group.call(null,cljs.core.select_keys.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"addon-before","addon-before",-500360384),new cljs.core.Keyword(null,"addon-after","addon-after",634985306)], null)),om_bootstrap.input.render_input.call(null,input__$1,attrs,children)),om_bootstrap.input.render_icon.call(null,cljs.core.select_keys.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821),new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)], null))),om_bootstrap.input.render_help.call(null,new cljs.core.Keyword(null,"help","help",-439233446).cljs$core$IFn$_invoke$arity$1(input__$1))], null))], null));
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37506 = output_checker37493_37502.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37506))
{var error__13977__auto___37507 = temp__4126__auto___37506;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"input","input",-2097503808,null),cljs.core.pr_str.call(null,error__13977__auto___37507)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37490_37499,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37507], null));
} else
{}
} else
{}
return o__13978__auto__;
};
var input = function (G__37494,var_args){
var rest37495 = null;if (arguments.length > 1) {
  rest37495 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return input__delegate.call(this,G__37494,rest37495);};
input.cljs$lang$maxFixedArity = 1;
input.cljs$lang$applyTo = (function (arglist__37508){
var G__37494 = cljs.core.first(arglist__37508);
var rest37495 = cljs.core.rest(arglist__37508);
return input__delegate(G__37494,rest37495);
});
input.cljs$core$IFn$_invoke$arity$variadic = input__delegate;
return input;
})()
;})(ufv___37498,output_schema37490_37499,input_schema37491_37500,input_checker37492_37501,output_checker37493_37502))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.input),schema.core.make_fn_schema.call(null,output_schema37490_37499,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37491_37500], null)));
var ufv___37518 = schema.utils.use_fn_validation;var output_schema37509_37519 = om_bootstrap.types.Component;var input_schema37510_37520 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Radio,new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_checker37511_37521 = schema.core.checker.call(null,input_schema37510_37520);var output_checker37512_37522 = schema.core.checker.call(null,output_schema37509_37519);/**
* Inputs: [opts :- Radio]
* Returns: t/Component
* 
* Generates a radio button entry, to place into a radio button
* grouping.
*/
om_bootstrap.input.radio_option = ((function (ufv___37518,output_schema37509_37519,input_schema37510_37520,input_checker37511_37521,output_checker37512_37522){
return (function radio_option(G__37513){var validate__13975__auto__ = ufv___37518.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37523 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37513], null);var temp__4126__auto___37524 = input_checker37511_37521.call(null,args__13976__auto___37523);if(cljs.core.truth_(temp__4126__auto___37524))
{var error__13977__auto___37525 = temp__4126__auto___37524;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"radio-option","radio-option",726779012,null),cljs.core.pr_str.call(null,error__13977__auto___37525)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37510_37520,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37523,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37525], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var opts = G__37513;while(true){
var vec__37516 = om_bootstrap.types.separate.call(null,om_bootstrap.input.Radio,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ref","ref",1289896967),"input",new cljs.core.Keyword(null,"key","key",-1516042587),"input",new cljs.core.Keyword(null,"type","type",1174270348),"radio"], null));var bs = cljs.core.nth.call(null,vec__37516,(0),null);var props = cljs.core.nth.call(null,vec__37516,(1),null);var map__37517 = bs;var map__37517__$1 = ((cljs.core.seq_QMARK_.call(null,map__37517))?cljs.core.apply.call(null,cljs.core.hash_map,map__37517):map__37517);var inline_QMARK_ = cljs.core.get.call(null,map__37517__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));var checked_QMARK_ = cljs.core.get.call(null,map__37517__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));var label = cljs.core.get.call(null,map__37517__$1,new cljs.core.Keyword(null,"label","label",1718410804));var core = om_tools.dom.element.call(null,om.dom.input,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_),cljs.core.PersistentVector.EMPTY);if(cljs.core.truth_(inline_QMARK_))
{return cljs.core.apply.call(null,React.DOM.label,{"className": "radio-inline"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[core,label],null))));
} else
{return cljs.core.apply.call(null,React.DOM.div,{"className": "radio"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.call(null,React.DOM.label,{},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[core,label],null))))],null))));
}
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37526 = output_checker37512_37522.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37526))
{var error__13977__auto___37527 = temp__4126__auto___37526;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"radio-option","radio-option",726779012,null),cljs.core.pr_str.call(null,error__13977__auto___37527)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37509_37519,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37527], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37518,output_schema37509_37519,input_schema37510_37520,input_checker37511_37521,output_checker37512_37522))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.radio_option),schema.core.make_fn_schema.call(null,output_schema37509_37519,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37510_37520], null)));
var ufv___37550 = schema.utils.use_fn_validation;var output_schema37528_37551 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.types.Component], null);var input_schema37529_37552 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"header","header",1759972661,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.pair.call(null,schema.core.Str,"option value",schema.core.Str,"option label")], null),new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_checker37530_37553 = schema.core.checker.call(null,input_schema37529_37552);var output_checker37531_37554 = schema.core.checker.call(null,output_schema37528_37551);/**
* Inputs: [header :- s/Str opts :- [(s/pair s/Str "option value" s/Str "option label")]]
* Returns: [t/Component]
* 
* Returns a sequence of options for use as the children of a select
* input.
*/
om_bootstrap.input.options = ((function (ufv___37550,output_schema37528_37551,input_schema37529_37552,input_checker37530_37553,output_checker37531_37554){
return (function options(G__37532,G__37533){var validate__13975__auto__ = ufv___37550.get_cell();if(cljs.core.truth_(validate__13975__auto__))
{var args__13976__auto___37555 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37532,G__37533], null);var temp__4126__auto___37556 = input_checker37530_37553.call(null,args__13976__auto___37555);if(cljs.core.truth_(temp__4126__auto___37556))
{var error__13977__auto___37557 = temp__4126__auto___37556;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"options","options",1740170016,null),cljs.core.pr_str.call(null,error__13977__auto___37557)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37529_37552,new cljs.core.Keyword(null,"value","value",305978217),args__13976__auto___37555,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37557], null));
} else
{}
} else
{}
var o__13978__auto__ = (function (){var header = G__37532;var opts = G__37533;while(true){
return cljs.core.cons.call(null,cljs.core.apply.call(null,om.dom.option,{"value": ""},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[header],null)))),(function (){var iter__4266__auto__ = ((function (validate__13975__auto__,ufv___37550,output_schema37528_37551,input_schema37529_37552,input_checker37530_37553,output_checker37531_37554){
return (function iter__37542(s__37543){return (new cljs.core.LazySeq(null,((function (validate__13975__auto__,ufv___37550,output_schema37528_37551,input_schema37529_37552,input_checker37530_37553,output_checker37531_37554){
return (function (){var s__37543__$1 = s__37543;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__37543__$1);if(temp__4126__auto__)
{var s__37543__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__37543__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__37543__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__37545 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__37544 = (0);while(true){
if((i__37544 < size__4265__auto__))
{var vec__37548 = cljs.core._nth.call(null,c__4264__auto__,i__37544);var v = cljs.core.nth.call(null,vec__37548,(0),null);var label = cljs.core.nth.call(null,vec__37548,(1),null);cljs.core.chunk_append.call(null,b__37545,cljs.core.apply.call(null,om.dom.option,{"value": om_tools.dom.format_opts.call(null,v)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[label],null)))));
{
var G__37558 = (i__37544 + (1));
i__37544 = G__37558;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37545),iter__37542.call(null,cljs.core.chunk_rest.call(null,s__37543__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37545),null);
}
} else
{var vec__37549 = cljs.core.first.call(null,s__37543__$2);var v = cljs.core.nth.call(null,vec__37549,(0),null);var label = cljs.core.nth.call(null,vec__37549,(1),null);return cljs.core.cons.call(null,cljs.core.apply.call(null,om.dom.option,{"value": om_tools.dom.format_opts.call(null,v)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[label],null)))),iter__37542.call(null,cljs.core.rest.call(null,s__37543__$2)));
}
} else
{return null;
}
break;
}
});})(validate__13975__auto__,ufv___37550,output_schema37528_37551,input_schema37529_37552,input_checker37530_37553,output_checker37531_37554))
,null,null));
});})(validate__13975__auto__,ufv___37550,output_schema37528_37551,input_schema37529_37552,input_checker37530_37553,output_checker37531_37554))
;return iter__4266__auto__.call(null,opts);
})());
break;
}
})();if(cljs.core.truth_(validate__13975__auto__))
{var temp__4126__auto___37559 = output_checker37531_37554.call(null,o__13978__auto__);if(cljs.core.truth_(temp__4126__auto___37559))
{var error__13977__auto___37560 = temp__4126__auto___37559;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"options","options",1740170016,null),cljs.core.pr_str.call(null,error__13977__auto___37560)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37528_37551,new cljs.core.Keyword(null,"value","value",305978217),o__13978__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13977__auto___37560], null));
} else
{}
} else
{}
return o__13978__auto__;
});})(ufv___37550,output_schema37528_37551,input_schema37529_37552,input_checker37530_37553,output_checker37531_37554))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.options),schema.core.make_fn_schema.call(null,output_schema37528_37551,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37529_37552], null)));

//# sourceMappingURL=input.js.map