// Compiled by ClojureScript 0.0-2277
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t31620 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31620 = (function (f,fn_handler,meta31621){
this.f = f;
this.fn_handler = fn_handler;
this.meta31621 = meta31621;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31620.cljs$lang$type = true;
cljs.core.async.t31620.cljs$lang$ctorStr = "cljs.core.async/t31620";
cljs.core.async.t31620.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31620");
});
cljs.core.async.t31620.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31620.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t31620.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t31620.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31622){var self__ = this;
var _31622__$1 = this;return self__.meta31621;
});
cljs.core.async.t31620.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31622,meta31621__$1){var self__ = this;
var _31622__$1 = this;return (new cljs.core.async.t31620(self__.f,self__.fn_handler,meta31621__$1));
});
cljs.core.async.__GT_t31620 = (function __GT_t31620(f__$1,fn_handler__$1,meta31621){return (new cljs.core.async.t31620(f__$1,fn_handler__$1,meta31621));
});
}
return (new cljs.core.async.t31620(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__31624 = buff;if(G__31624)
{var bit__4191__auto__ = null;if(cljs.core.truth_((function (){var or__3541__auto__ = bit__4191__auto__;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return G__31624.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__31624.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__31624);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__31624);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error(("Assert failed: <! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_31625 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_31625);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_31625,ret){
return (function (){return fn1.call(null,val_31625);
});})(val_31625,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error(("Assert failed: >! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4397__auto___31626 = n;var x_31627 = (0);while(true){
if((x_31627 < n__4397__auto___31626))
{(a[x_31627] = (0));
{
var G__31628 = (x_31627 + (1));
x_31627 = G__31628;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__31629 = (i + (1));
i = G__31629;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t31633 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31633 = (function (flag,alt_flag,meta31634){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta31634 = meta31634;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31633.cljs$lang$type = true;
cljs.core.async.t31633.cljs$lang$ctorStr = "cljs.core.async/t31633";
cljs.core.async.t31633.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31633");
});})(flag))
;
cljs.core.async.t31633.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31633.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t31633.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t31633.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31635){var self__ = this;
var _31635__$1 = this;return self__.meta31634;
});})(flag))
;
cljs.core.async.t31633.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31635,meta31634__$1){var self__ = this;
var _31635__$1 = this;return (new cljs.core.async.t31633(self__.flag,self__.alt_flag,meta31634__$1));
});})(flag))
;
cljs.core.async.__GT_t31633 = ((function (flag){
return (function __GT_t31633(flag__$1,alt_flag__$1,meta31634){return (new cljs.core.async.t31633(flag__$1,alt_flag__$1,meta31634));
});})(flag))
;
}
return (new cljs.core.async.t31633(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t31639 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31639 = (function (cb,flag,alt_handler,meta31640){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta31640 = meta31640;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31639.cljs$lang$type = true;
cljs.core.async.t31639.cljs$lang$ctorStr = "cljs.core.async/t31639";
cljs.core.async.t31639.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31639");
});
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t31639.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31641){var self__ = this;
var _31641__$1 = this;return self__.meta31640;
});
cljs.core.async.t31639.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31641,meta31640__$1){var self__ = this;
var _31641__$1 = this;return (new cljs.core.async.t31639(self__.cb,self__.flag,self__.alt_handler,meta31640__$1));
});
cljs.core.async.__GT_t31639 = (function __GT_t31639(cb__$1,flag__$1,alt_handler__$1,meta31640){return (new cljs.core.async.t31639(cb__$1,flag__$1,alt_handler__$1,meta31640));
});
}
return (new cljs.core.async.t31639(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31642_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31642_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31643_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31643_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3541__auto__ = wport;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__31644 = (i + (1));
i = G__31644;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3541__auto__ = ret;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__3529__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3529__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__31645){var map__31647 = p__31645;var map__31647__$1 = ((cljs.core.seq_QMARK_.call(null,map__31647))?cljs.core.apply.call(null,cljs.core.hash_map,map__31647):map__31647);var opts = map__31647__$1;if(null)
{return null;
} else
{throw (new Error(("Assert failed: alts! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
};
var alts_BANG_ = function (ports,var_args){
var p__31645 = null;if (arguments.length > 1) {
  p__31645 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__31645);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__31648){
var ports = cljs.core.first(arglist__31648);
var p__31645 = cljs.core.rest(arglist__31648);
return alts_BANG___delegate(ports,p__31645);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t31656 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31656 = (function (ch,f,map_LT_,meta31657){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta31657 = meta31657;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31656.cljs$lang$type = true;
cljs.core.async.t31656.cljs$lang$ctorStr = "cljs.core.async/t31656";
cljs.core.async.t31656.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31656");
});
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t31659 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31659 = (function (fn1,_,meta31657,ch,f,map_LT_,meta31660){
this.fn1 = fn1;
this._ = _;
this.meta31657 = meta31657;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta31660 = meta31660;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31659.cljs$lang$type = true;
cljs.core.async.t31659.cljs$lang$ctorStr = "cljs.core.async/t31659";
cljs.core.async.t31659.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31659");
});})(___$1))
;
cljs.core.async.t31659.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31659.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t31659.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t31659.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__31649_SHARP_){return f1.call(null,(((p1__31649_SHARP_ == null))?null:self__.f.call(null,p1__31649_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t31659.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31661){var self__ = this;
var _31661__$1 = this;return self__.meta31660;
});})(___$1))
;
cljs.core.async.t31659.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31661,meta31660__$1){var self__ = this;
var _31661__$1 = this;return (new cljs.core.async.t31659(self__.fn1,self__._,self__.meta31657,self__.ch,self__.f,self__.map_LT_,meta31660__$1));
});})(___$1))
;
cljs.core.async.__GT_t31659 = ((function (___$1){
return (function __GT_t31659(fn1__$1,___$2,meta31657__$1,ch__$2,f__$2,map_LT___$2,meta31660){return (new cljs.core.async.t31659(fn1__$1,___$2,meta31657__$1,ch__$2,f__$2,map_LT___$2,meta31660));
});})(___$1))
;
}
return (new cljs.core.async.t31659(fn1,___$1,self__.meta31657,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3529__auto__ = ret;if(cljs.core.truth_(and__3529__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3529__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31656.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t31656.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31658){var self__ = this;
var _31658__$1 = this;return self__.meta31657;
});
cljs.core.async.t31656.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31658,meta31657__$1){var self__ = this;
var _31658__$1 = this;return (new cljs.core.async.t31656(self__.ch,self__.f,self__.map_LT_,meta31657__$1));
});
cljs.core.async.__GT_t31656 = (function __GT_t31656(ch__$1,f__$1,map_LT___$1,meta31657){return (new cljs.core.async.t31656(ch__$1,f__$1,map_LT___$1,meta31657));
});
}
return (new cljs.core.async.t31656(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t31665 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31665 = (function (ch,f,map_GT_,meta31666){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta31666 = meta31666;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31665.cljs$lang$type = true;
cljs.core.async.t31665.cljs$lang$ctorStr = "cljs.core.async/t31665";
cljs.core.async.t31665.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31665");
});
cljs.core.async.t31665.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31665.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t31665.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31665.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t31665.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31665.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31667){var self__ = this;
var _31667__$1 = this;return self__.meta31666;
});
cljs.core.async.t31665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31667,meta31666__$1){var self__ = this;
var _31667__$1 = this;return (new cljs.core.async.t31665(self__.ch,self__.f,self__.map_GT_,meta31666__$1));
});
cljs.core.async.__GT_t31665 = (function __GT_t31665(ch__$1,f__$1,map_GT___$1,meta31666){return (new cljs.core.async.t31665(ch__$1,f__$1,map_GT___$1,meta31666));
});
}
return (new cljs.core.async.t31665(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t31671 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31671 = (function (ch,p,filter_GT_,meta31672){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta31672 = meta31672;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31671.cljs$lang$type = true;
cljs.core.async.t31671.cljs$lang$ctorStr = "cljs.core.async/t31671";
cljs.core.async.t31671.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31671");
});
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31671.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t31671.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31673){var self__ = this;
var _31673__$1 = this;return self__.meta31672;
});
cljs.core.async.t31671.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31673,meta31672__$1){var self__ = this;
var _31673__$1 = this;return (new cljs.core.async.t31671(self__.ch,self__.p,self__.filter_GT_,meta31672__$1));
});
cljs.core.async.__GT_t31671 = (function __GT_t31671(ch__$1,p__$1,filter_GT___$1,meta31672){return (new cljs.core.async.t31671(ch__$1,p__$1,filter_GT___$1,meta31672));
});
}
return (new cljs.core.async.t31671(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___31756 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___31756,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___31756,out){
return (function (state_31735){var state_val_31736 = (state_31735[(1)]);if((state_val_31736 === (7)))
{var inst_31731 = (state_31735[(2)]);var state_31735__$1 = state_31735;var statearr_31737_31757 = state_31735__$1;(statearr_31737_31757[(2)] = inst_31731);
(statearr_31737_31757[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (1)))
{var state_31735__$1 = state_31735;var statearr_31738_31758 = state_31735__$1;(statearr_31738_31758[(2)] = null);
(statearr_31738_31758[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (4)))
{var inst_31717 = (state_31735[(7)]);var inst_31717__$1 = (state_31735[(2)]);var inst_31718 = (inst_31717__$1 == null);var state_31735__$1 = (function (){var statearr_31739 = state_31735;(statearr_31739[(7)] = inst_31717__$1);
return statearr_31739;
})();if(cljs.core.truth_(inst_31718))
{var statearr_31740_31759 = state_31735__$1;(statearr_31740_31759[(1)] = (5));
} else
{var statearr_31741_31760 = state_31735__$1;(statearr_31741_31760[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (6)))
{var inst_31717 = (state_31735[(7)]);var inst_31722 = p.call(null,inst_31717);var state_31735__$1 = state_31735;if(cljs.core.truth_(inst_31722))
{var statearr_31742_31761 = state_31735__$1;(statearr_31742_31761[(1)] = (8));
} else
{var statearr_31743_31762 = state_31735__$1;(statearr_31743_31762[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (3)))
{var inst_31733 = (state_31735[(2)]);var state_31735__$1 = state_31735;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31735__$1,inst_31733);
} else
{if((state_val_31736 === (2)))
{var state_31735__$1 = state_31735;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31735__$1,(4),ch);
} else
{if((state_val_31736 === (11)))
{var inst_31725 = (state_31735[(2)]);var state_31735__$1 = state_31735;var statearr_31744_31763 = state_31735__$1;(statearr_31744_31763[(2)] = inst_31725);
(statearr_31744_31763[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (9)))
{var state_31735__$1 = state_31735;var statearr_31745_31764 = state_31735__$1;(statearr_31745_31764[(2)] = null);
(statearr_31745_31764[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (5)))
{var inst_31720 = cljs.core.async.close_BANG_.call(null,out);var state_31735__$1 = state_31735;var statearr_31746_31765 = state_31735__$1;(statearr_31746_31765[(2)] = inst_31720);
(statearr_31746_31765[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (10)))
{var inst_31728 = (state_31735[(2)]);var state_31735__$1 = (function (){var statearr_31747 = state_31735;(statearr_31747[(8)] = inst_31728);
return statearr_31747;
})();var statearr_31748_31766 = state_31735__$1;(statearr_31748_31766[(2)] = null);
(statearr_31748_31766[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31736 === (8)))
{var inst_31717 = (state_31735[(7)]);var state_31735__$1 = state_31735;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31735__$1,(11),out,inst_31717);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___31756,out))
;return ((function (switch__7350__auto__,c__7365__auto___31756,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_31752 = [null,null,null,null,null,null,null,null,null];(statearr_31752[(0)] = state_machine__7351__auto__);
(statearr_31752[(1)] = (1));
return statearr_31752;
});
var state_machine__7351__auto____1 = (function (state_31735){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_31735);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e31753){if((e31753 instanceof Object))
{var ex__7354__auto__ = e31753;var statearr_31754_31767 = state_31735;(statearr_31754_31767[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31735);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e31753;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__31768 = state_31735;
state_31735 = G__31768;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_31735){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_31735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___31756,out))
})();var state__7367__auto__ = (function (){var statearr_31755 = f__7366__auto__.call(null);(statearr_31755[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___31756);
return statearr_31755;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___31756,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_31934){var state_val_31935 = (state_31934[(1)]);if((state_val_31935 === (7)))
{var inst_31930 = (state_31934[(2)]);var state_31934__$1 = state_31934;var statearr_31936_31977 = state_31934__$1;(statearr_31936_31977[(2)] = inst_31930);
(statearr_31936_31977[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (20)))
{var inst_31900 = (state_31934[(7)]);var inst_31911 = (state_31934[(2)]);var inst_31912 = cljs.core.next.call(null,inst_31900);var inst_31886 = inst_31912;var inst_31887 = null;var inst_31888 = (0);var inst_31889 = (0);var state_31934__$1 = (function (){var statearr_31937 = state_31934;(statearr_31937[(8)] = inst_31889);
(statearr_31937[(9)] = inst_31886);
(statearr_31937[(10)] = inst_31888);
(statearr_31937[(11)] = inst_31911);
(statearr_31937[(12)] = inst_31887);
return statearr_31937;
})();var statearr_31938_31978 = state_31934__$1;(statearr_31938_31978[(2)] = null);
(statearr_31938_31978[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (1)))
{var state_31934__$1 = state_31934;var statearr_31939_31979 = state_31934__$1;(statearr_31939_31979[(2)] = null);
(statearr_31939_31979[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (4)))
{var inst_31875 = (state_31934[(13)]);var inst_31875__$1 = (state_31934[(2)]);var inst_31876 = (inst_31875__$1 == null);var state_31934__$1 = (function (){var statearr_31940 = state_31934;(statearr_31940[(13)] = inst_31875__$1);
return statearr_31940;
})();if(cljs.core.truth_(inst_31876))
{var statearr_31941_31980 = state_31934__$1;(statearr_31941_31980[(1)] = (5));
} else
{var statearr_31942_31981 = state_31934__$1;(statearr_31942_31981[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (15)))
{var state_31934__$1 = state_31934;var statearr_31946_31982 = state_31934__$1;(statearr_31946_31982[(2)] = null);
(statearr_31946_31982[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (21)))
{var state_31934__$1 = state_31934;var statearr_31947_31983 = state_31934__$1;(statearr_31947_31983[(2)] = null);
(statearr_31947_31983[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (13)))
{var inst_31889 = (state_31934[(8)]);var inst_31886 = (state_31934[(9)]);var inst_31888 = (state_31934[(10)]);var inst_31887 = (state_31934[(12)]);var inst_31896 = (state_31934[(2)]);var inst_31897 = (inst_31889 + (1));var tmp31943 = inst_31886;var tmp31944 = inst_31888;var tmp31945 = inst_31887;var inst_31886__$1 = tmp31943;var inst_31887__$1 = tmp31945;var inst_31888__$1 = tmp31944;var inst_31889__$1 = inst_31897;var state_31934__$1 = (function (){var statearr_31948 = state_31934;(statearr_31948[(8)] = inst_31889__$1);
(statearr_31948[(9)] = inst_31886__$1);
(statearr_31948[(10)] = inst_31888__$1);
(statearr_31948[(14)] = inst_31896);
(statearr_31948[(12)] = inst_31887__$1);
return statearr_31948;
})();var statearr_31949_31984 = state_31934__$1;(statearr_31949_31984[(2)] = null);
(statearr_31949_31984[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (22)))
{var state_31934__$1 = state_31934;var statearr_31950_31985 = state_31934__$1;(statearr_31950_31985[(2)] = null);
(statearr_31950_31985[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (6)))
{var inst_31875 = (state_31934[(13)]);var inst_31884 = f.call(null,inst_31875);var inst_31885 = cljs.core.seq.call(null,inst_31884);var inst_31886 = inst_31885;var inst_31887 = null;var inst_31888 = (0);var inst_31889 = (0);var state_31934__$1 = (function (){var statearr_31951 = state_31934;(statearr_31951[(8)] = inst_31889);
(statearr_31951[(9)] = inst_31886);
(statearr_31951[(10)] = inst_31888);
(statearr_31951[(12)] = inst_31887);
return statearr_31951;
})();var statearr_31952_31986 = state_31934__$1;(statearr_31952_31986[(2)] = null);
(statearr_31952_31986[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (17)))
{var inst_31900 = (state_31934[(7)]);var inst_31904 = cljs.core.chunk_first.call(null,inst_31900);var inst_31905 = cljs.core.chunk_rest.call(null,inst_31900);var inst_31906 = cljs.core.count.call(null,inst_31904);var inst_31886 = inst_31905;var inst_31887 = inst_31904;var inst_31888 = inst_31906;var inst_31889 = (0);var state_31934__$1 = (function (){var statearr_31953 = state_31934;(statearr_31953[(8)] = inst_31889);
(statearr_31953[(9)] = inst_31886);
(statearr_31953[(10)] = inst_31888);
(statearr_31953[(12)] = inst_31887);
return statearr_31953;
})();var statearr_31954_31987 = state_31934__$1;(statearr_31954_31987[(2)] = null);
(statearr_31954_31987[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (3)))
{var inst_31932 = (state_31934[(2)]);var state_31934__$1 = state_31934;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31934__$1,inst_31932);
} else
{if((state_val_31935 === (12)))
{var inst_31920 = (state_31934[(2)]);var state_31934__$1 = state_31934;var statearr_31955_31988 = state_31934__$1;(statearr_31955_31988[(2)] = inst_31920);
(statearr_31955_31988[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (2)))
{var state_31934__$1 = state_31934;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31934__$1,(4),in$);
} else
{if((state_val_31935 === (23)))
{var inst_31928 = (state_31934[(2)]);var state_31934__$1 = state_31934;var statearr_31956_31989 = state_31934__$1;(statearr_31956_31989[(2)] = inst_31928);
(statearr_31956_31989[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (19)))
{var inst_31915 = (state_31934[(2)]);var state_31934__$1 = state_31934;var statearr_31957_31990 = state_31934__$1;(statearr_31957_31990[(2)] = inst_31915);
(statearr_31957_31990[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (11)))
{var inst_31900 = (state_31934[(7)]);var inst_31886 = (state_31934[(9)]);var inst_31900__$1 = cljs.core.seq.call(null,inst_31886);var state_31934__$1 = (function (){var statearr_31958 = state_31934;(statearr_31958[(7)] = inst_31900__$1);
return statearr_31958;
})();if(inst_31900__$1)
{var statearr_31959_31991 = state_31934__$1;(statearr_31959_31991[(1)] = (14));
} else
{var statearr_31960_31992 = state_31934__$1;(statearr_31960_31992[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (9)))
{var inst_31922 = (state_31934[(2)]);var inst_31923 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_31934__$1 = (function (){var statearr_31961 = state_31934;(statearr_31961[(15)] = inst_31922);
return statearr_31961;
})();if(cljs.core.truth_(inst_31923))
{var statearr_31962_31993 = state_31934__$1;(statearr_31962_31993[(1)] = (21));
} else
{var statearr_31963_31994 = state_31934__$1;(statearr_31963_31994[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (5)))
{var inst_31878 = cljs.core.async.close_BANG_.call(null,out);var state_31934__$1 = state_31934;var statearr_31964_31995 = state_31934__$1;(statearr_31964_31995[(2)] = inst_31878);
(statearr_31964_31995[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (14)))
{var inst_31900 = (state_31934[(7)]);var inst_31902 = cljs.core.chunked_seq_QMARK_.call(null,inst_31900);var state_31934__$1 = state_31934;if(inst_31902)
{var statearr_31965_31996 = state_31934__$1;(statearr_31965_31996[(1)] = (17));
} else
{var statearr_31966_31997 = state_31934__$1;(statearr_31966_31997[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (16)))
{var inst_31918 = (state_31934[(2)]);var state_31934__$1 = state_31934;var statearr_31967_31998 = state_31934__$1;(statearr_31967_31998[(2)] = inst_31918);
(statearr_31967_31998[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31935 === (10)))
{var inst_31889 = (state_31934[(8)]);var inst_31887 = (state_31934[(12)]);var inst_31894 = cljs.core._nth.call(null,inst_31887,inst_31889);var state_31934__$1 = state_31934;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31934__$1,(13),out,inst_31894);
} else
{if((state_val_31935 === (18)))
{var inst_31900 = (state_31934[(7)]);var inst_31909 = cljs.core.first.call(null,inst_31900);var state_31934__$1 = state_31934;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31934__$1,(20),out,inst_31909);
} else
{if((state_val_31935 === (8)))
{var inst_31889 = (state_31934[(8)]);var inst_31888 = (state_31934[(10)]);var inst_31891 = (inst_31889 < inst_31888);var inst_31892 = inst_31891;var state_31934__$1 = state_31934;if(cljs.core.truth_(inst_31892))
{var statearr_31968_31999 = state_31934__$1;(statearr_31968_31999[(1)] = (10));
} else
{var statearr_31969_32000 = state_31934__$1;(statearr_31969_32000[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_31973 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_31973[(0)] = state_machine__7351__auto__);
(statearr_31973[(1)] = (1));
return statearr_31973;
});
var state_machine__7351__auto____1 = (function (state_31934){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_31934);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e31974){if((e31974 instanceof Object))
{var ex__7354__auto__ = e31974;var statearr_31975_32001 = state_31934;(statearr_31975_32001[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31934);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e31974;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32002 = state_31934;
state_31934 = G__32002;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_31934){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_31934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_31976 = f__7366__auto__.call(null);(statearr_31976[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_31976;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__7365__auto___32097 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32097){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32097){
return (function (state_32073){var state_val_32074 = (state_32073[(1)]);if((state_val_32074 === (7)))
{var inst_32069 = (state_32073[(2)]);var state_32073__$1 = state_32073;var statearr_32075_32098 = state_32073__$1;(statearr_32075_32098[(2)] = inst_32069);
(statearr_32075_32098[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (1)))
{var state_32073__$1 = state_32073;var statearr_32076_32099 = state_32073__$1;(statearr_32076_32099[(2)] = null);
(statearr_32076_32099[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (4)))
{var inst_32052 = (state_32073[(7)]);var inst_32052__$1 = (state_32073[(2)]);var inst_32053 = (inst_32052__$1 == null);var state_32073__$1 = (function (){var statearr_32077 = state_32073;(statearr_32077[(7)] = inst_32052__$1);
return statearr_32077;
})();if(cljs.core.truth_(inst_32053))
{var statearr_32078_32100 = state_32073__$1;(statearr_32078_32100[(1)] = (5));
} else
{var statearr_32079_32101 = state_32073__$1;(statearr_32079_32101[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (13)))
{var state_32073__$1 = state_32073;var statearr_32080_32102 = state_32073__$1;(statearr_32080_32102[(2)] = null);
(statearr_32080_32102[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (6)))
{var inst_32052 = (state_32073[(7)]);var state_32073__$1 = state_32073;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32073__$1,(11),to,inst_32052);
} else
{if((state_val_32074 === (3)))
{var inst_32071 = (state_32073[(2)]);var state_32073__$1 = state_32073;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32073__$1,inst_32071);
} else
{if((state_val_32074 === (12)))
{var state_32073__$1 = state_32073;var statearr_32081_32103 = state_32073__$1;(statearr_32081_32103[(2)] = null);
(statearr_32081_32103[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (2)))
{var state_32073__$1 = state_32073;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32073__$1,(4),from);
} else
{if((state_val_32074 === (11)))
{var inst_32062 = (state_32073[(2)]);var state_32073__$1 = state_32073;if(cljs.core.truth_(inst_32062))
{var statearr_32082_32104 = state_32073__$1;(statearr_32082_32104[(1)] = (12));
} else
{var statearr_32083_32105 = state_32073__$1;(statearr_32083_32105[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (9)))
{var state_32073__$1 = state_32073;var statearr_32084_32106 = state_32073__$1;(statearr_32084_32106[(2)] = null);
(statearr_32084_32106[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (5)))
{var state_32073__$1 = state_32073;if(cljs.core.truth_(close_QMARK_))
{var statearr_32085_32107 = state_32073__$1;(statearr_32085_32107[(1)] = (8));
} else
{var statearr_32086_32108 = state_32073__$1;(statearr_32086_32108[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (14)))
{var inst_32067 = (state_32073[(2)]);var state_32073__$1 = state_32073;var statearr_32087_32109 = state_32073__$1;(statearr_32087_32109[(2)] = inst_32067);
(statearr_32087_32109[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (10)))
{var inst_32059 = (state_32073[(2)]);var state_32073__$1 = state_32073;var statearr_32088_32110 = state_32073__$1;(statearr_32088_32110[(2)] = inst_32059);
(statearr_32088_32110[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32074 === (8)))
{var inst_32056 = cljs.core.async.close_BANG_.call(null,to);var state_32073__$1 = state_32073;var statearr_32089_32111 = state_32073__$1;(statearr_32089_32111[(2)] = inst_32056);
(statearr_32089_32111[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32097))
;return ((function (switch__7350__auto__,c__7365__auto___32097){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32093 = [null,null,null,null,null,null,null,null];(statearr_32093[(0)] = state_machine__7351__auto__);
(statearr_32093[(1)] = (1));
return statearr_32093;
});
var state_machine__7351__auto____1 = (function (state_32073){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32073);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32094){if((e32094 instanceof Object))
{var ex__7354__auto__ = e32094;var statearr_32095_32112 = state_32073;(statearr_32095_32112[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32073);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32094;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32113 = state_32073;
state_32073 = G__32113;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32073){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32097))
})();var state__7367__auto__ = (function (){var statearr_32096 = f__7366__auto__.call(null);(statearr_32096[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32097);
return statearr_32096;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32097))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__7365__auto___32214 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32214,tc,fc){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32214,tc,fc){
return (function (state_32189){var state_val_32190 = (state_32189[(1)]);if((state_val_32190 === (7)))
{var inst_32185 = (state_32189[(2)]);var state_32189__$1 = state_32189;var statearr_32191_32215 = state_32189__$1;(statearr_32191_32215[(2)] = inst_32185);
(statearr_32191_32215[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (1)))
{var state_32189__$1 = state_32189;var statearr_32192_32216 = state_32189__$1;(statearr_32192_32216[(2)] = null);
(statearr_32192_32216[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (4)))
{var inst_32166 = (state_32189[(7)]);var inst_32166__$1 = (state_32189[(2)]);var inst_32167 = (inst_32166__$1 == null);var state_32189__$1 = (function (){var statearr_32193 = state_32189;(statearr_32193[(7)] = inst_32166__$1);
return statearr_32193;
})();if(cljs.core.truth_(inst_32167))
{var statearr_32194_32217 = state_32189__$1;(statearr_32194_32217[(1)] = (5));
} else
{var statearr_32195_32218 = state_32189__$1;(statearr_32195_32218[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (13)))
{var state_32189__$1 = state_32189;var statearr_32196_32219 = state_32189__$1;(statearr_32196_32219[(2)] = null);
(statearr_32196_32219[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (6)))
{var inst_32166 = (state_32189[(7)]);var inst_32172 = p.call(null,inst_32166);var state_32189__$1 = state_32189;if(cljs.core.truth_(inst_32172))
{var statearr_32197_32220 = state_32189__$1;(statearr_32197_32220[(1)] = (9));
} else
{var statearr_32198_32221 = state_32189__$1;(statearr_32198_32221[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (3)))
{var inst_32187 = (state_32189[(2)]);var state_32189__$1 = state_32189;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32189__$1,inst_32187);
} else
{if((state_val_32190 === (12)))
{var state_32189__$1 = state_32189;var statearr_32199_32222 = state_32189__$1;(statearr_32199_32222[(2)] = null);
(statearr_32199_32222[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (2)))
{var state_32189__$1 = state_32189;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32189__$1,(4),ch);
} else
{if((state_val_32190 === (11)))
{var inst_32166 = (state_32189[(7)]);var inst_32176 = (state_32189[(2)]);var state_32189__$1 = state_32189;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32189__$1,(8),inst_32176,inst_32166);
} else
{if((state_val_32190 === (9)))
{var state_32189__$1 = state_32189;var statearr_32200_32223 = state_32189__$1;(statearr_32200_32223[(2)] = tc);
(statearr_32200_32223[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (5)))
{var inst_32169 = cljs.core.async.close_BANG_.call(null,tc);var inst_32170 = cljs.core.async.close_BANG_.call(null,fc);var state_32189__$1 = (function (){var statearr_32201 = state_32189;(statearr_32201[(8)] = inst_32169);
return statearr_32201;
})();var statearr_32202_32224 = state_32189__$1;(statearr_32202_32224[(2)] = inst_32170);
(statearr_32202_32224[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (14)))
{var inst_32183 = (state_32189[(2)]);var state_32189__$1 = state_32189;var statearr_32203_32225 = state_32189__$1;(statearr_32203_32225[(2)] = inst_32183);
(statearr_32203_32225[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (10)))
{var state_32189__$1 = state_32189;var statearr_32204_32226 = state_32189__$1;(statearr_32204_32226[(2)] = fc);
(statearr_32204_32226[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32190 === (8)))
{var inst_32178 = (state_32189[(2)]);var state_32189__$1 = state_32189;if(cljs.core.truth_(inst_32178))
{var statearr_32205_32227 = state_32189__$1;(statearr_32205_32227[(1)] = (12));
} else
{var statearr_32206_32228 = state_32189__$1;(statearr_32206_32228[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32214,tc,fc))
;return ((function (switch__7350__auto__,c__7365__auto___32214,tc,fc){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32210 = [null,null,null,null,null,null,null,null,null];(statearr_32210[(0)] = state_machine__7351__auto__);
(statearr_32210[(1)] = (1));
return statearr_32210;
});
var state_machine__7351__auto____1 = (function (state_32189){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32189);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32211){if((e32211 instanceof Object))
{var ex__7354__auto__ = e32211;var statearr_32212_32229 = state_32189;(statearr_32212_32229[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32189);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32211;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32230 = state_32189;
state_32189 = G__32230;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32189){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32214,tc,fc))
})();var state__7367__auto__ = (function (){var statearr_32213 = f__7366__auto__.call(null);(statearr_32213[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32214);
return statearr_32213;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32214,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_32277){var state_val_32278 = (state_32277[(1)]);if((state_val_32278 === (7)))
{var inst_32273 = (state_32277[(2)]);var state_32277__$1 = state_32277;var statearr_32279_32295 = state_32277__$1;(statearr_32279_32295[(2)] = inst_32273);
(statearr_32279_32295[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32278 === (6)))
{var inst_32266 = (state_32277[(7)]);var inst_32263 = (state_32277[(8)]);var inst_32270 = f.call(null,inst_32263,inst_32266);var inst_32263__$1 = inst_32270;var state_32277__$1 = (function (){var statearr_32280 = state_32277;(statearr_32280[(8)] = inst_32263__$1);
return statearr_32280;
})();var statearr_32281_32296 = state_32277__$1;(statearr_32281_32296[(2)] = null);
(statearr_32281_32296[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32278 === (5)))
{var inst_32263 = (state_32277[(8)]);var state_32277__$1 = state_32277;var statearr_32282_32297 = state_32277__$1;(statearr_32282_32297[(2)] = inst_32263);
(statearr_32282_32297[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32278 === (4)))
{var inst_32266 = (state_32277[(7)]);var inst_32266__$1 = (state_32277[(2)]);var inst_32267 = (inst_32266__$1 == null);var state_32277__$1 = (function (){var statearr_32283 = state_32277;(statearr_32283[(7)] = inst_32266__$1);
return statearr_32283;
})();if(cljs.core.truth_(inst_32267))
{var statearr_32284_32298 = state_32277__$1;(statearr_32284_32298[(1)] = (5));
} else
{var statearr_32285_32299 = state_32277__$1;(statearr_32285_32299[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32278 === (3)))
{var inst_32275 = (state_32277[(2)]);var state_32277__$1 = state_32277;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32277__$1,inst_32275);
} else
{if((state_val_32278 === (2)))
{var state_32277__$1 = state_32277;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32277__$1,(4),ch);
} else
{if((state_val_32278 === (1)))
{var inst_32263 = init;var state_32277__$1 = (function (){var statearr_32286 = state_32277;(statearr_32286[(8)] = inst_32263);
return statearr_32286;
})();var statearr_32287_32300 = state_32277__$1;(statearr_32287_32300[(2)] = null);
(statearr_32287_32300[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32291 = [null,null,null,null,null,null,null,null,null];(statearr_32291[(0)] = state_machine__7351__auto__);
(statearr_32291[(1)] = (1));
return statearr_32291;
});
var state_machine__7351__auto____1 = (function (state_32277){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32277);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32292){if((e32292 instanceof Object))
{var ex__7354__auto__ = e32292;var statearr_32293_32301 = state_32277;(statearr_32293_32301[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32277);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32292;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32302 = state_32277;
state_32277 = G__32302;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32277){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_32294 = f__7366__auto__.call(null);(statearr_32294[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_32294;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_32376){var state_val_32377 = (state_32376[(1)]);if((state_val_32377 === (7)))
{var inst_32358 = (state_32376[(2)]);var state_32376__$1 = state_32376;var statearr_32378_32401 = state_32376__$1;(statearr_32378_32401[(2)] = inst_32358);
(statearr_32378_32401[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (1)))
{var inst_32352 = cljs.core.seq.call(null,coll);var inst_32353 = inst_32352;var state_32376__$1 = (function (){var statearr_32379 = state_32376;(statearr_32379[(7)] = inst_32353);
return statearr_32379;
})();var statearr_32380_32402 = state_32376__$1;(statearr_32380_32402[(2)] = null);
(statearr_32380_32402[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (4)))
{var inst_32353 = (state_32376[(7)]);var inst_32356 = cljs.core.first.call(null,inst_32353);var state_32376__$1 = state_32376;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32376__$1,(7),ch,inst_32356);
} else
{if((state_val_32377 === (13)))
{var inst_32370 = (state_32376[(2)]);var state_32376__$1 = state_32376;var statearr_32381_32403 = state_32376__$1;(statearr_32381_32403[(2)] = inst_32370);
(statearr_32381_32403[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (6)))
{var inst_32361 = (state_32376[(2)]);var state_32376__$1 = state_32376;if(cljs.core.truth_(inst_32361))
{var statearr_32382_32404 = state_32376__$1;(statearr_32382_32404[(1)] = (8));
} else
{var statearr_32383_32405 = state_32376__$1;(statearr_32383_32405[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (3)))
{var inst_32374 = (state_32376[(2)]);var state_32376__$1 = state_32376;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32376__$1,inst_32374);
} else
{if((state_val_32377 === (12)))
{var state_32376__$1 = state_32376;var statearr_32384_32406 = state_32376__$1;(statearr_32384_32406[(2)] = null);
(statearr_32384_32406[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (2)))
{var inst_32353 = (state_32376[(7)]);var state_32376__$1 = state_32376;if(cljs.core.truth_(inst_32353))
{var statearr_32385_32407 = state_32376__$1;(statearr_32385_32407[(1)] = (4));
} else
{var statearr_32386_32408 = state_32376__$1;(statearr_32386_32408[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (11)))
{var inst_32367 = cljs.core.async.close_BANG_.call(null,ch);var state_32376__$1 = state_32376;var statearr_32387_32409 = state_32376__$1;(statearr_32387_32409[(2)] = inst_32367);
(statearr_32387_32409[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (9)))
{var state_32376__$1 = state_32376;if(cljs.core.truth_(close_QMARK_))
{var statearr_32388_32410 = state_32376__$1;(statearr_32388_32410[(1)] = (11));
} else
{var statearr_32389_32411 = state_32376__$1;(statearr_32389_32411[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (5)))
{var inst_32353 = (state_32376[(7)]);var state_32376__$1 = state_32376;var statearr_32390_32412 = state_32376__$1;(statearr_32390_32412[(2)] = inst_32353);
(statearr_32390_32412[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (10)))
{var inst_32372 = (state_32376[(2)]);var state_32376__$1 = state_32376;var statearr_32391_32413 = state_32376__$1;(statearr_32391_32413[(2)] = inst_32372);
(statearr_32391_32413[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32377 === (8)))
{var inst_32353 = (state_32376[(7)]);var inst_32363 = cljs.core.next.call(null,inst_32353);var inst_32353__$1 = inst_32363;var state_32376__$1 = (function (){var statearr_32392 = state_32376;(statearr_32392[(7)] = inst_32353__$1);
return statearr_32392;
})();var statearr_32393_32414 = state_32376__$1;(statearr_32393_32414[(2)] = null);
(statearr_32393_32414[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32397 = [null,null,null,null,null,null,null,null];(statearr_32397[(0)] = state_machine__7351__auto__);
(statearr_32397[(1)] = (1));
return statearr_32397;
});
var state_machine__7351__auto____1 = (function (state_32376){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32376);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32398){if((e32398 instanceof Object))
{var ex__7354__auto__ = e32398;var statearr_32399_32415 = state_32376;(statearr_32399_32415[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32376);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32398;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32416 = state_32376;
state_32376 = G__32416;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32376){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_32400 = f__7366__auto__.call(null);(statearr_32400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_32400;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj32418 = {};return obj32418;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3529__auto__ = _;if(and__3529__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4168__auto__ = (((_ == null))?null:_);return (function (){var or__3541__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj32420 = {};return obj32420;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t32642 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t32642 = (function (cs,ch,mult,meta32643){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta32643 = meta32643;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32642.cljs$lang$type = true;
cljs.core.async.t32642.cljs$lang$ctorStr = "cljs.core.async/t32642";
cljs.core.async.t32642.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t32642");
});})(cs))
;
cljs.core.async.t32642.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t32642.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t32642.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t32642.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t32642.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t32642.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t32642.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32644){var self__ = this;
var _32644__$1 = this;return self__.meta32643;
});})(cs))
;
cljs.core.async.t32642.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32644,meta32643__$1){var self__ = this;
var _32644__$1 = this;return (new cljs.core.async.t32642(self__.cs,self__.ch,self__.mult,meta32643__$1));
});})(cs))
;
cljs.core.async.__GT_t32642 = ((function (cs){
return (function __GT_t32642(cs__$1,ch__$1,mult__$1,meta32643){return (new cljs.core.async.t32642(cs__$1,ch__$1,mult__$1,meta32643));
});})(cs))
;
}
return (new cljs.core.async.t32642(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__7365__auto___32863 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32863,cs,m,dchan,dctr,done){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32863,cs,m,dchan,dctr,done){
return (function (state_32775){var state_val_32776 = (state_32775[(1)]);if((state_val_32776 === (7)))
{var inst_32771 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32777_32864 = state_32775__$1;(statearr_32777_32864[(2)] = inst_32771);
(statearr_32777_32864[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (20)))
{var inst_32676 = (state_32775[(7)]);var inst_32686 = cljs.core.first.call(null,inst_32676);var inst_32687 = cljs.core.nth.call(null,inst_32686,(0),null);var inst_32688 = cljs.core.nth.call(null,inst_32686,(1),null);var state_32775__$1 = (function (){var statearr_32778 = state_32775;(statearr_32778[(8)] = inst_32687);
return statearr_32778;
})();if(cljs.core.truth_(inst_32688))
{var statearr_32779_32865 = state_32775__$1;(statearr_32779_32865[(1)] = (22));
} else
{var statearr_32780_32866 = state_32775__$1;(statearr_32780_32866[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (27)))
{var inst_32647 = (state_32775[(9)]);var inst_32716 = (state_32775[(10)]);var inst_32718 = (state_32775[(11)]);var inst_32723 = (state_32775[(12)]);var inst_32723__$1 = cljs.core._nth.call(null,inst_32716,inst_32718);var inst_32724 = cljs.core.async.put_BANG_.call(null,inst_32723__$1,inst_32647,done);var state_32775__$1 = (function (){var statearr_32781 = state_32775;(statearr_32781[(12)] = inst_32723__$1);
return statearr_32781;
})();if(cljs.core.truth_(inst_32724))
{var statearr_32782_32867 = state_32775__$1;(statearr_32782_32867[(1)] = (30));
} else
{var statearr_32783_32868 = state_32775__$1;(statearr_32783_32868[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (1)))
{var state_32775__$1 = state_32775;var statearr_32784_32869 = state_32775__$1;(statearr_32784_32869[(2)] = null);
(statearr_32784_32869[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (24)))
{var inst_32676 = (state_32775[(7)]);var inst_32693 = (state_32775[(2)]);var inst_32694 = cljs.core.next.call(null,inst_32676);var inst_32656 = inst_32694;var inst_32657 = null;var inst_32658 = (0);var inst_32659 = (0);var state_32775__$1 = (function (){var statearr_32785 = state_32775;(statearr_32785[(13)] = inst_32693);
(statearr_32785[(14)] = inst_32657);
(statearr_32785[(15)] = inst_32659);
(statearr_32785[(16)] = inst_32656);
(statearr_32785[(17)] = inst_32658);
return statearr_32785;
})();var statearr_32786_32870 = state_32775__$1;(statearr_32786_32870[(2)] = null);
(statearr_32786_32870[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (39)))
{var state_32775__$1 = state_32775;var statearr_32790_32871 = state_32775__$1;(statearr_32790_32871[(2)] = null);
(statearr_32790_32871[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (4)))
{var inst_32647 = (state_32775[(9)]);var inst_32647__$1 = (state_32775[(2)]);var inst_32648 = (inst_32647__$1 == null);var state_32775__$1 = (function (){var statearr_32791 = state_32775;(statearr_32791[(9)] = inst_32647__$1);
return statearr_32791;
})();if(cljs.core.truth_(inst_32648))
{var statearr_32792_32872 = state_32775__$1;(statearr_32792_32872[(1)] = (5));
} else
{var statearr_32793_32873 = state_32775__$1;(statearr_32793_32873[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (15)))
{var inst_32657 = (state_32775[(14)]);var inst_32659 = (state_32775[(15)]);var inst_32656 = (state_32775[(16)]);var inst_32658 = (state_32775[(17)]);var inst_32672 = (state_32775[(2)]);var inst_32673 = (inst_32659 + (1));var tmp32787 = inst_32657;var tmp32788 = inst_32656;var tmp32789 = inst_32658;var inst_32656__$1 = tmp32788;var inst_32657__$1 = tmp32787;var inst_32658__$1 = tmp32789;var inst_32659__$1 = inst_32673;var state_32775__$1 = (function (){var statearr_32794 = state_32775;(statearr_32794[(14)] = inst_32657__$1);
(statearr_32794[(15)] = inst_32659__$1);
(statearr_32794[(16)] = inst_32656__$1);
(statearr_32794[(17)] = inst_32658__$1);
(statearr_32794[(18)] = inst_32672);
return statearr_32794;
})();var statearr_32795_32874 = state_32775__$1;(statearr_32795_32874[(2)] = null);
(statearr_32795_32874[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (21)))
{var inst_32697 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32799_32875 = state_32775__$1;(statearr_32799_32875[(2)] = inst_32697);
(statearr_32799_32875[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (31)))
{var inst_32723 = (state_32775[(12)]);var inst_32727 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_32728 = cljs.core.async.untap_STAR_.call(null,m,inst_32723);var state_32775__$1 = (function (){var statearr_32800 = state_32775;(statearr_32800[(19)] = inst_32727);
return statearr_32800;
})();var statearr_32801_32876 = state_32775__$1;(statearr_32801_32876[(2)] = inst_32728);
(statearr_32801_32876[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (32)))
{var inst_32716 = (state_32775[(10)]);var inst_32715 = (state_32775[(20)]);var inst_32718 = (state_32775[(11)]);var inst_32717 = (state_32775[(21)]);var inst_32730 = (state_32775[(2)]);var inst_32731 = (inst_32718 + (1));var tmp32796 = inst_32716;var tmp32797 = inst_32715;var tmp32798 = inst_32717;var inst_32715__$1 = tmp32797;var inst_32716__$1 = tmp32796;var inst_32717__$1 = tmp32798;var inst_32718__$1 = inst_32731;var state_32775__$1 = (function (){var statearr_32802 = state_32775;(statearr_32802[(10)] = inst_32716__$1);
(statearr_32802[(20)] = inst_32715__$1);
(statearr_32802[(11)] = inst_32718__$1);
(statearr_32802[(22)] = inst_32730);
(statearr_32802[(21)] = inst_32717__$1);
return statearr_32802;
})();var statearr_32803_32877 = state_32775__$1;(statearr_32803_32877[(2)] = null);
(statearr_32803_32877[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (40)))
{var inst_32743 = (state_32775[(23)]);var inst_32747 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_32748 = cljs.core.async.untap_STAR_.call(null,m,inst_32743);var state_32775__$1 = (function (){var statearr_32804 = state_32775;(statearr_32804[(24)] = inst_32747);
return statearr_32804;
})();var statearr_32805_32878 = state_32775__$1;(statearr_32805_32878[(2)] = inst_32748);
(statearr_32805_32878[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (33)))
{var inst_32734 = (state_32775[(25)]);var inst_32736 = cljs.core.chunked_seq_QMARK_.call(null,inst_32734);var state_32775__$1 = state_32775;if(inst_32736)
{var statearr_32806_32879 = state_32775__$1;(statearr_32806_32879[(1)] = (36));
} else
{var statearr_32807_32880 = state_32775__$1;(statearr_32807_32880[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (13)))
{var inst_32666 = (state_32775[(26)]);var inst_32669 = cljs.core.async.close_BANG_.call(null,inst_32666);var state_32775__$1 = state_32775;var statearr_32808_32881 = state_32775__$1;(statearr_32808_32881[(2)] = inst_32669);
(statearr_32808_32881[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (22)))
{var inst_32687 = (state_32775[(8)]);var inst_32690 = cljs.core.async.close_BANG_.call(null,inst_32687);var state_32775__$1 = state_32775;var statearr_32809_32882 = state_32775__$1;(statearr_32809_32882[(2)] = inst_32690);
(statearr_32809_32882[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (36)))
{var inst_32734 = (state_32775[(25)]);var inst_32738 = cljs.core.chunk_first.call(null,inst_32734);var inst_32739 = cljs.core.chunk_rest.call(null,inst_32734);var inst_32740 = cljs.core.count.call(null,inst_32738);var inst_32715 = inst_32739;var inst_32716 = inst_32738;var inst_32717 = inst_32740;var inst_32718 = (0);var state_32775__$1 = (function (){var statearr_32810 = state_32775;(statearr_32810[(10)] = inst_32716);
(statearr_32810[(20)] = inst_32715);
(statearr_32810[(11)] = inst_32718);
(statearr_32810[(21)] = inst_32717);
return statearr_32810;
})();var statearr_32811_32883 = state_32775__$1;(statearr_32811_32883[(2)] = null);
(statearr_32811_32883[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (41)))
{var inst_32734 = (state_32775[(25)]);var inst_32750 = (state_32775[(2)]);var inst_32751 = cljs.core.next.call(null,inst_32734);var inst_32715 = inst_32751;var inst_32716 = null;var inst_32717 = (0);var inst_32718 = (0);var state_32775__$1 = (function (){var statearr_32812 = state_32775;(statearr_32812[(27)] = inst_32750);
(statearr_32812[(10)] = inst_32716);
(statearr_32812[(20)] = inst_32715);
(statearr_32812[(11)] = inst_32718);
(statearr_32812[(21)] = inst_32717);
return statearr_32812;
})();var statearr_32813_32884 = state_32775__$1;(statearr_32813_32884[(2)] = null);
(statearr_32813_32884[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (43)))
{var state_32775__$1 = state_32775;var statearr_32814_32885 = state_32775__$1;(statearr_32814_32885[(2)] = null);
(statearr_32814_32885[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (29)))
{var inst_32759 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32815_32886 = state_32775__$1;(statearr_32815_32886[(2)] = inst_32759);
(statearr_32815_32886[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (44)))
{var inst_32768 = (state_32775[(2)]);var state_32775__$1 = (function (){var statearr_32816 = state_32775;(statearr_32816[(28)] = inst_32768);
return statearr_32816;
})();var statearr_32817_32887 = state_32775__$1;(statearr_32817_32887[(2)] = null);
(statearr_32817_32887[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (6)))
{var inst_32707 = (state_32775[(29)]);var inst_32706 = cljs.core.deref.call(null,cs);var inst_32707__$1 = cljs.core.keys.call(null,inst_32706);var inst_32708 = cljs.core.count.call(null,inst_32707__$1);var inst_32709 = cljs.core.reset_BANG_.call(null,dctr,inst_32708);var inst_32714 = cljs.core.seq.call(null,inst_32707__$1);var inst_32715 = inst_32714;var inst_32716 = null;var inst_32717 = (0);var inst_32718 = (0);var state_32775__$1 = (function (){var statearr_32818 = state_32775;(statearr_32818[(29)] = inst_32707__$1);
(statearr_32818[(10)] = inst_32716);
(statearr_32818[(20)] = inst_32715);
(statearr_32818[(30)] = inst_32709);
(statearr_32818[(11)] = inst_32718);
(statearr_32818[(21)] = inst_32717);
return statearr_32818;
})();var statearr_32819_32888 = state_32775__$1;(statearr_32819_32888[(2)] = null);
(statearr_32819_32888[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (28)))
{var inst_32715 = (state_32775[(20)]);var inst_32734 = (state_32775[(25)]);var inst_32734__$1 = cljs.core.seq.call(null,inst_32715);var state_32775__$1 = (function (){var statearr_32820 = state_32775;(statearr_32820[(25)] = inst_32734__$1);
return statearr_32820;
})();if(inst_32734__$1)
{var statearr_32821_32889 = state_32775__$1;(statearr_32821_32889[(1)] = (33));
} else
{var statearr_32822_32890 = state_32775__$1;(statearr_32822_32890[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (25)))
{var inst_32718 = (state_32775[(11)]);var inst_32717 = (state_32775[(21)]);var inst_32720 = (inst_32718 < inst_32717);var inst_32721 = inst_32720;var state_32775__$1 = state_32775;if(cljs.core.truth_(inst_32721))
{var statearr_32823_32891 = state_32775__$1;(statearr_32823_32891[(1)] = (27));
} else
{var statearr_32824_32892 = state_32775__$1;(statearr_32824_32892[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (34)))
{var state_32775__$1 = state_32775;var statearr_32825_32893 = state_32775__$1;(statearr_32825_32893[(2)] = null);
(statearr_32825_32893[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (17)))
{var state_32775__$1 = state_32775;var statearr_32826_32894 = state_32775__$1;(statearr_32826_32894[(2)] = null);
(statearr_32826_32894[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (3)))
{var inst_32773 = (state_32775[(2)]);var state_32775__$1 = state_32775;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32775__$1,inst_32773);
} else
{if((state_val_32776 === (12)))
{var inst_32702 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32827_32895 = state_32775__$1;(statearr_32827_32895[(2)] = inst_32702);
(statearr_32827_32895[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (2)))
{var state_32775__$1 = state_32775;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32775__$1,(4),ch);
} else
{if((state_val_32776 === (23)))
{var state_32775__$1 = state_32775;var statearr_32828_32896 = state_32775__$1;(statearr_32828_32896[(2)] = null);
(statearr_32828_32896[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (35)))
{var inst_32757 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32829_32897 = state_32775__$1;(statearr_32829_32897[(2)] = inst_32757);
(statearr_32829_32897[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (19)))
{var inst_32676 = (state_32775[(7)]);var inst_32680 = cljs.core.chunk_first.call(null,inst_32676);var inst_32681 = cljs.core.chunk_rest.call(null,inst_32676);var inst_32682 = cljs.core.count.call(null,inst_32680);var inst_32656 = inst_32681;var inst_32657 = inst_32680;var inst_32658 = inst_32682;var inst_32659 = (0);var state_32775__$1 = (function (){var statearr_32830 = state_32775;(statearr_32830[(14)] = inst_32657);
(statearr_32830[(15)] = inst_32659);
(statearr_32830[(16)] = inst_32656);
(statearr_32830[(17)] = inst_32658);
return statearr_32830;
})();var statearr_32831_32898 = state_32775__$1;(statearr_32831_32898[(2)] = null);
(statearr_32831_32898[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (11)))
{var inst_32676 = (state_32775[(7)]);var inst_32656 = (state_32775[(16)]);var inst_32676__$1 = cljs.core.seq.call(null,inst_32656);var state_32775__$1 = (function (){var statearr_32832 = state_32775;(statearr_32832[(7)] = inst_32676__$1);
return statearr_32832;
})();if(inst_32676__$1)
{var statearr_32833_32899 = state_32775__$1;(statearr_32833_32899[(1)] = (16));
} else
{var statearr_32834_32900 = state_32775__$1;(statearr_32834_32900[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (9)))
{var inst_32704 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32835_32901 = state_32775__$1;(statearr_32835_32901[(2)] = inst_32704);
(statearr_32835_32901[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (5)))
{var inst_32654 = cljs.core.deref.call(null,cs);var inst_32655 = cljs.core.seq.call(null,inst_32654);var inst_32656 = inst_32655;var inst_32657 = null;var inst_32658 = (0);var inst_32659 = (0);var state_32775__$1 = (function (){var statearr_32836 = state_32775;(statearr_32836[(14)] = inst_32657);
(statearr_32836[(15)] = inst_32659);
(statearr_32836[(16)] = inst_32656);
(statearr_32836[(17)] = inst_32658);
return statearr_32836;
})();var statearr_32837_32902 = state_32775__$1;(statearr_32837_32902[(2)] = null);
(statearr_32837_32902[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (14)))
{var state_32775__$1 = state_32775;var statearr_32838_32903 = state_32775__$1;(statearr_32838_32903[(2)] = null);
(statearr_32838_32903[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (45)))
{var inst_32765 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32839_32904 = state_32775__$1;(statearr_32839_32904[(2)] = inst_32765);
(statearr_32839_32904[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (26)))
{var inst_32707 = (state_32775[(29)]);var inst_32761 = (state_32775[(2)]);var inst_32762 = cljs.core.seq.call(null,inst_32707);var state_32775__$1 = (function (){var statearr_32840 = state_32775;(statearr_32840[(31)] = inst_32761);
return statearr_32840;
})();if(inst_32762)
{var statearr_32841_32905 = state_32775__$1;(statearr_32841_32905[(1)] = (42));
} else
{var statearr_32842_32906 = state_32775__$1;(statearr_32842_32906[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (16)))
{var inst_32676 = (state_32775[(7)]);var inst_32678 = cljs.core.chunked_seq_QMARK_.call(null,inst_32676);var state_32775__$1 = state_32775;if(inst_32678)
{var statearr_32843_32907 = state_32775__$1;(statearr_32843_32907[(1)] = (19));
} else
{var statearr_32844_32908 = state_32775__$1;(statearr_32844_32908[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (38)))
{var inst_32754 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32845_32909 = state_32775__$1;(statearr_32845_32909[(2)] = inst_32754);
(statearr_32845_32909[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (30)))
{var state_32775__$1 = state_32775;var statearr_32846_32910 = state_32775__$1;(statearr_32846_32910[(2)] = null);
(statearr_32846_32910[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (10)))
{var inst_32657 = (state_32775[(14)]);var inst_32659 = (state_32775[(15)]);var inst_32665 = cljs.core._nth.call(null,inst_32657,inst_32659);var inst_32666 = cljs.core.nth.call(null,inst_32665,(0),null);var inst_32667 = cljs.core.nth.call(null,inst_32665,(1),null);var state_32775__$1 = (function (){var statearr_32847 = state_32775;(statearr_32847[(26)] = inst_32666);
return statearr_32847;
})();if(cljs.core.truth_(inst_32667))
{var statearr_32848_32911 = state_32775__$1;(statearr_32848_32911[(1)] = (13));
} else
{var statearr_32849_32912 = state_32775__$1;(statearr_32849_32912[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (18)))
{var inst_32700 = (state_32775[(2)]);var state_32775__$1 = state_32775;var statearr_32850_32913 = state_32775__$1;(statearr_32850_32913[(2)] = inst_32700);
(statearr_32850_32913[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (42)))
{var state_32775__$1 = state_32775;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32775__$1,(45),dchan);
} else
{if((state_val_32776 === (37)))
{var inst_32647 = (state_32775[(9)]);var inst_32743 = (state_32775[(23)]);var inst_32734 = (state_32775[(25)]);var inst_32743__$1 = cljs.core.first.call(null,inst_32734);var inst_32744 = cljs.core.async.put_BANG_.call(null,inst_32743__$1,inst_32647,done);var state_32775__$1 = (function (){var statearr_32851 = state_32775;(statearr_32851[(23)] = inst_32743__$1);
return statearr_32851;
})();if(cljs.core.truth_(inst_32744))
{var statearr_32852_32914 = state_32775__$1;(statearr_32852_32914[(1)] = (39));
} else
{var statearr_32853_32915 = state_32775__$1;(statearr_32853_32915[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32776 === (8)))
{var inst_32659 = (state_32775[(15)]);var inst_32658 = (state_32775[(17)]);var inst_32661 = (inst_32659 < inst_32658);var inst_32662 = inst_32661;var state_32775__$1 = state_32775;if(cljs.core.truth_(inst_32662))
{var statearr_32854_32916 = state_32775__$1;(statearr_32854_32916[(1)] = (10));
} else
{var statearr_32855_32917 = state_32775__$1;(statearr_32855_32917[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32863,cs,m,dchan,dctr,done))
;return ((function (switch__7350__auto__,c__7365__auto___32863,cs,m,dchan,dctr,done){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32859 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_32859[(0)] = state_machine__7351__auto__);
(statearr_32859[(1)] = (1));
return statearr_32859;
});
var state_machine__7351__auto____1 = (function (state_32775){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32775);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32860){if((e32860 instanceof Object))
{var ex__7354__auto__ = e32860;var statearr_32861_32918 = state_32775;(statearr_32861_32918[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32775);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32860;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32919 = state_32775;
state_32775 = G__32919;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32775){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32863,cs,m,dchan,dctr,done))
})();var state__7367__auto__ = (function (){var statearr_32862 = f__7366__auto__.call(null);(statearr_32862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32863);
return statearr_32862;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32863,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj32921 = {};return obj32921;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t33041 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t33041 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta33042){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta33042 = meta33042;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33041.cljs$lang$type = true;
cljs.core.async.t33041.cljs$lang$ctorStr = "cljs.core.async/t33041";
cljs.core.async.t33041.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t33041");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t33041.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t33041.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33043){var self__ = this;
var _33043__$1 = this;return self__.meta33042;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33041.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33043,meta33042__$1){var self__ = this;
var _33043__$1 = this;return (new cljs.core.async.t33041(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta33042__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t33041 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t33041(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta33042){return (new cljs.core.async.t33041(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta33042));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t33041(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__7365__auto___33160 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33113){var state_val_33114 = (state_33113[(1)]);if((state_val_33114 === (7)))
{var inst_33057 = (state_33113[(7)]);var inst_33062 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33057);var state_33113__$1 = state_33113;var statearr_33115_33161 = state_33113__$1;(statearr_33115_33161[(2)] = inst_33062);
(statearr_33115_33161[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (20)))
{var inst_33072 = (state_33113[(8)]);var state_33113__$1 = state_33113;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33113__$1,(23),out,inst_33072);
} else
{if((state_val_33114 === (1)))
{var inst_33047 = (state_33113[(9)]);var inst_33047__$1 = calc_state.call(null);var inst_33048 = cljs.core.seq_QMARK_.call(null,inst_33047__$1);var state_33113__$1 = (function (){var statearr_33116 = state_33113;(statearr_33116[(9)] = inst_33047__$1);
return statearr_33116;
})();if(inst_33048)
{var statearr_33117_33162 = state_33113__$1;(statearr_33117_33162[(1)] = (2));
} else
{var statearr_33118_33163 = state_33113__$1;(statearr_33118_33163[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (24)))
{var inst_33065 = (state_33113[(10)]);var inst_33057 = inst_33065;var state_33113__$1 = (function (){var statearr_33119 = state_33113;(statearr_33119[(7)] = inst_33057);
return statearr_33119;
})();var statearr_33120_33164 = state_33113__$1;(statearr_33120_33164[(2)] = null);
(statearr_33120_33164[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (4)))
{var inst_33047 = (state_33113[(9)]);var inst_33053 = (state_33113[(2)]);var inst_33054 = cljs.core.get.call(null,inst_33053,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_33055 = cljs.core.get.call(null,inst_33053,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_33056 = cljs.core.get.call(null,inst_33053,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_33057 = inst_33047;var state_33113__$1 = (function (){var statearr_33121 = state_33113;(statearr_33121[(11)] = inst_33055);
(statearr_33121[(12)] = inst_33054);
(statearr_33121[(13)] = inst_33056);
(statearr_33121[(7)] = inst_33057);
return statearr_33121;
})();var statearr_33122_33165 = state_33113__$1;(statearr_33122_33165[(2)] = null);
(statearr_33122_33165[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (15)))
{var state_33113__$1 = state_33113;var statearr_33123_33166 = state_33113__$1;(statearr_33123_33166[(2)] = null);
(statearr_33123_33166[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (21)))
{var inst_33065 = (state_33113[(10)]);var inst_33057 = inst_33065;var state_33113__$1 = (function (){var statearr_33124 = state_33113;(statearr_33124[(7)] = inst_33057);
return statearr_33124;
})();var statearr_33125_33167 = state_33113__$1;(statearr_33125_33167[(2)] = null);
(statearr_33125_33167[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (13)))
{var inst_33109 = (state_33113[(2)]);var state_33113__$1 = state_33113;var statearr_33126_33168 = state_33113__$1;(statearr_33126_33168[(2)] = inst_33109);
(statearr_33126_33168[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (22)))
{var inst_33107 = (state_33113[(2)]);var state_33113__$1 = state_33113;var statearr_33127_33169 = state_33113__$1;(statearr_33127_33169[(2)] = inst_33107);
(statearr_33127_33169[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (6)))
{var inst_33111 = (state_33113[(2)]);var state_33113__$1 = state_33113;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33113__$1,inst_33111);
} else
{if((state_val_33114 === (25)))
{var state_33113__$1 = state_33113;var statearr_33128_33170 = state_33113__$1;(statearr_33128_33170[(2)] = null);
(statearr_33128_33170[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (17)))
{var inst_33087 = (state_33113[(14)]);var state_33113__$1 = state_33113;var statearr_33129_33171 = state_33113__$1;(statearr_33129_33171[(2)] = inst_33087);
(statearr_33129_33171[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (3)))
{var inst_33047 = (state_33113[(9)]);var state_33113__$1 = state_33113;var statearr_33130_33172 = state_33113__$1;(statearr_33130_33172[(2)] = inst_33047);
(statearr_33130_33172[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (12)))
{var inst_33073 = (state_33113[(15)]);var inst_33068 = (state_33113[(16)]);var inst_33087 = (state_33113[(14)]);var inst_33087__$1 = inst_33068.call(null,inst_33073);var state_33113__$1 = (function (){var statearr_33131 = state_33113;(statearr_33131[(14)] = inst_33087__$1);
return statearr_33131;
})();if(cljs.core.truth_(inst_33087__$1))
{var statearr_33132_33173 = state_33113__$1;(statearr_33132_33173[(1)] = (17));
} else
{var statearr_33133_33174 = state_33113__$1;(statearr_33133_33174[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (2)))
{var inst_33047 = (state_33113[(9)]);var inst_33050 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33047);var state_33113__$1 = state_33113;var statearr_33134_33175 = state_33113__$1;(statearr_33134_33175[(2)] = inst_33050);
(statearr_33134_33175[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (23)))
{var inst_33098 = (state_33113[(2)]);var state_33113__$1 = state_33113;if(cljs.core.truth_(inst_33098))
{var statearr_33135_33176 = state_33113__$1;(statearr_33135_33176[(1)] = (24));
} else
{var statearr_33136_33177 = state_33113__$1;(statearr_33136_33177[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (19)))
{var inst_33095 = (state_33113[(2)]);var state_33113__$1 = state_33113;if(cljs.core.truth_(inst_33095))
{var statearr_33137_33178 = state_33113__$1;(statearr_33137_33178[(1)] = (20));
} else
{var statearr_33138_33179 = state_33113__$1;(statearr_33138_33179[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (11)))
{var inst_33072 = (state_33113[(8)]);var inst_33078 = (inst_33072 == null);var state_33113__$1 = state_33113;if(cljs.core.truth_(inst_33078))
{var statearr_33139_33180 = state_33113__$1;(statearr_33139_33180[(1)] = (14));
} else
{var statearr_33140_33181 = state_33113__$1;(statearr_33140_33181[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (9)))
{var inst_33065 = (state_33113[(10)]);var inst_33065__$1 = (state_33113[(2)]);var inst_33066 = cljs.core.get.call(null,inst_33065__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_33067 = cljs.core.get.call(null,inst_33065__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_33068 = cljs.core.get.call(null,inst_33065__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_33113__$1 = (function (){var statearr_33141 = state_33113;(statearr_33141[(10)] = inst_33065__$1);
(statearr_33141[(17)] = inst_33067);
(statearr_33141[(16)] = inst_33068);
return statearr_33141;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_33113__$1,(10),inst_33066);
} else
{if((state_val_33114 === (5)))
{var inst_33057 = (state_33113[(7)]);var inst_33060 = cljs.core.seq_QMARK_.call(null,inst_33057);var state_33113__$1 = state_33113;if(inst_33060)
{var statearr_33142_33182 = state_33113__$1;(statearr_33142_33182[(1)] = (7));
} else
{var statearr_33143_33183 = state_33113__$1;(statearr_33143_33183[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (14)))
{var inst_33073 = (state_33113[(15)]);var inst_33080 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_33073);var state_33113__$1 = state_33113;var statearr_33144_33184 = state_33113__$1;(statearr_33144_33184[(2)] = inst_33080);
(statearr_33144_33184[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (26)))
{var inst_33103 = (state_33113[(2)]);var state_33113__$1 = state_33113;var statearr_33145_33185 = state_33113__$1;(statearr_33145_33185[(2)] = inst_33103);
(statearr_33145_33185[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (16)))
{var inst_33083 = (state_33113[(2)]);var inst_33084 = calc_state.call(null);var inst_33057 = inst_33084;var state_33113__$1 = (function (){var statearr_33146 = state_33113;(statearr_33146[(18)] = inst_33083);
(statearr_33146[(7)] = inst_33057);
return statearr_33146;
})();var statearr_33147_33186 = state_33113__$1;(statearr_33147_33186[(2)] = null);
(statearr_33147_33186[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (10)))
{var inst_33073 = (state_33113[(15)]);var inst_33072 = (state_33113[(8)]);var inst_33071 = (state_33113[(2)]);var inst_33072__$1 = cljs.core.nth.call(null,inst_33071,(0),null);var inst_33073__$1 = cljs.core.nth.call(null,inst_33071,(1),null);var inst_33074 = (inst_33072__$1 == null);var inst_33075 = cljs.core._EQ_.call(null,inst_33073__$1,change);var inst_33076 = (inst_33074) || (inst_33075);var state_33113__$1 = (function (){var statearr_33148 = state_33113;(statearr_33148[(15)] = inst_33073__$1);
(statearr_33148[(8)] = inst_33072__$1);
return statearr_33148;
})();if(cljs.core.truth_(inst_33076))
{var statearr_33149_33187 = state_33113__$1;(statearr_33149_33187[(1)] = (11));
} else
{var statearr_33150_33188 = state_33113__$1;(statearr_33150_33188[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (18)))
{var inst_33073 = (state_33113[(15)]);var inst_33067 = (state_33113[(17)]);var inst_33068 = (state_33113[(16)]);var inst_33090 = cljs.core.empty_QMARK_.call(null,inst_33068);var inst_33091 = inst_33067.call(null,inst_33073);var inst_33092 = cljs.core.not.call(null,inst_33091);var inst_33093 = (inst_33090) && (inst_33092);var state_33113__$1 = state_33113;var statearr_33151_33189 = state_33113__$1;(statearr_33151_33189[(2)] = inst_33093);
(statearr_33151_33189[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33114 === (8)))
{var inst_33057 = (state_33113[(7)]);var state_33113__$1 = state_33113;var statearr_33152_33190 = state_33113__$1;(statearr_33152_33190[(2)] = inst_33057);
(statearr_33152_33190[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__7350__auto__,c__7365__auto___33160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33156[(0)] = state_machine__7351__auto__);
(statearr_33156[(1)] = (1));
return statearr_33156;
});
var state_machine__7351__auto____1 = (function (state_33113){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33113);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33157){if((e33157 instanceof Object))
{var ex__7354__auto__ = e33157;var statearr_33158_33191 = state_33113;(statearr_33158_33191[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33113);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33157;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33192 = state_33113;
state_33113 = G__33192;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33113){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__7367__auto__ = (function (){var statearr_33159 = f__7366__auto__.call(null);(statearr_33159[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33160);
return statearr_33159;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj33194 = {};return obj33194;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3541__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3541__auto__,mults){
return (function (p1__33195_SHARP_){if(cljs.core.truth_(p1__33195_SHARP_.call(null,topic)))
{return p1__33195_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__33195_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3541__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t33318 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t33318 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta33319){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta33319 = meta33319;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33318.cljs$lang$type = true;
cljs.core.async.t33318.cljs$lang$ctorStr = "cljs.core.async/t33318";
cljs.core.async.t33318.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t33318");
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t33318.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t33318.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33320){var self__ = this;
var _33320__$1 = this;return self__.meta33319;
});})(mults,ensure_mult))
;
cljs.core.async.t33318.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33320,meta33319__$1){var self__ = this;
var _33320__$1 = this;return (new cljs.core.async.t33318(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta33319__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t33318 = ((function (mults,ensure_mult){
return (function __GT_t33318(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta33319){return (new cljs.core.async.t33318(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta33319));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t33318(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__7365__auto___33440 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33440,mults,ensure_mult,p){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33440,mults,ensure_mult,p){
return (function (state_33392){var state_val_33393 = (state_33392[(1)]);if((state_val_33393 === (7)))
{var inst_33388 = (state_33392[(2)]);var state_33392__$1 = state_33392;var statearr_33394_33441 = state_33392__$1;(statearr_33394_33441[(2)] = inst_33388);
(statearr_33394_33441[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (20)))
{var state_33392__$1 = state_33392;var statearr_33395_33442 = state_33392__$1;(statearr_33395_33442[(2)] = null);
(statearr_33395_33442[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (1)))
{var state_33392__$1 = state_33392;var statearr_33396_33443 = state_33392__$1;(statearr_33396_33443[(2)] = null);
(statearr_33396_33443[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (24)))
{var inst_33371 = (state_33392[(7)]);var inst_33380 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_33371);var state_33392__$1 = state_33392;var statearr_33397_33444 = state_33392__$1;(statearr_33397_33444[(2)] = inst_33380);
(statearr_33397_33444[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (4)))
{var inst_33323 = (state_33392[(8)]);var inst_33323__$1 = (state_33392[(2)]);var inst_33324 = (inst_33323__$1 == null);var state_33392__$1 = (function (){var statearr_33398 = state_33392;(statearr_33398[(8)] = inst_33323__$1);
return statearr_33398;
})();if(cljs.core.truth_(inst_33324))
{var statearr_33399_33445 = state_33392__$1;(statearr_33399_33445[(1)] = (5));
} else
{var statearr_33400_33446 = state_33392__$1;(statearr_33400_33446[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (15)))
{var inst_33365 = (state_33392[(2)]);var state_33392__$1 = state_33392;var statearr_33401_33447 = state_33392__$1;(statearr_33401_33447[(2)] = inst_33365);
(statearr_33401_33447[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (21)))
{var inst_33385 = (state_33392[(2)]);var state_33392__$1 = (function (){var statearr_33402 = state_33392;(statearr_33402[(9)] = inst_33385);
return statearr_33402;
})();var statearr_33403_33448 = state_33392__$1;(statearr_33403_33448[(2)] = null);
(statearr_33403_33448[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (13)))
{var inst_33347 = (state_33392[(10)]);var inst_33349 = cljs.core.chunked_seq_QMARK_.call(null,inst_33347);var state_33392__$1 = state_33392;if(inst_33349)
{var statearr_33404_33449 = state_33392__$1;(statearr_33404_33449[(1)] = (16));
} else
{var statearr_33405_33450 = state_33392__$1;(statearr_33405_33450[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (22)))
{var inst_33377 = (state_33392[(2)]);var state_33392__$1 = state_33392;if(cljs.core.truth_(inst_33377))
{var statearr_33406_33451 = state_33392__$1;(statearr_33406_33451[(1)] = (23));
} else
{var statearr_33407_33452 = state_33392__$1;(statearr_33407_33452[(1)] = (24));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (6)))
{var inst_33371 = (state_33392[(7)]);var inst_33373 = (state_33392[(11)]);var inst_33323 = (state_33392[(8)]);var inst_33371__$1 = topic_fn.call(null,inst_33323);var inst_33372 = cljs.core.deref.call(null,mults);var inst_33373__$1 = cljs.core.get.call(null,inst_33372,inst_33371__$1);var state_33392__$1 = (function (){var statearr_33408 = state_33392;(statearr_33408[(7)] = inst_33371__$1);
(statearr_33408[(11)] = inst_33373__$1);
return statearr_33408;
})();if(cljs.core.truth_(inst_33373__$1))
{var statearr_33409_33453 = state_33392__$1;(statearr_33409_33453[(1)] = (19));
} else
{var statearr_33410_33454 = state_33392__$1;(statearr_33410_33454[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (25)))
{var inst_33382 = (state_33392[(2)]);var state_33392__$1 = state_33392;var statearr_33411_33455 = state_33392__$1;(statearr_33411_33455[(2)] = inst_33382);
(statearr_33411_33455[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (17)))
{var inst_33347 = (state_33392[(10)]);var inst_33356 = cljs.core.first.call(null,inst_33347);var inst_33357 = cljs.core.async.muxch_STAR_.call(null,inst_33356);var inst_33358 = cljs.core.async.close_BANG_.call(null,inst_33357);var inst_33359 = cljs.core.next.call(null,inst_33347);var inst_33333 = inst_33359;var inst_33334 = null;var inst_33335 = (0);var inst_33336 = (0);var state_33392__$1 = (function (){var statearr_33412 = state_33392;(statearr_33412[(12)] = inst_33334);
(statearr_33412[(13)] = inst_33335);
(statearr_33412[(14)] = inst_33336);
(statearr_33412[(15)] = inst_33358);
(statearr_33412[(16)] = inst_33333);
return statearr_33412;
})();var statearr_33413_33456 = state_33392__$1;(statearr_33413_33456[(2)] = null);
(statearr_33413_33456[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (3)))
{var inst_33390 = (state_33392[(2)]);var state_33392__$1 = state_33392;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33392__$1,inst_33390);
} else
{if((state_val_33393 === (12)))
{var inst_33367 = (state_33392[(2)]);var state_33392__$1 = state_33392;var statearr_33414_33457 = state_33392__$1;(statearr_33414_33457[(2)] = inst_33367);
(statearr_33414_33457[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (2)))
{var state_33392__$1 = state_33392;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33392__$1,(4),ch);
} else
{if((state_val_33393 === (23)))
{var state_33392__$1 = state_33392;var statearr_33415_33458 = state_33392__$1;(statearr_33415_33458[(2)] = null);
(statearr_33415_33458[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (19)))
{var inst_33373 = (state_33392[(11)]);var inst_33323 = (state_33392[(8)]);var inst_33375 = cljs.core.async.muxch_STAR_.call(null,inst_33373);var state_33392__$1 = state_33392;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33392__$1,(22),inst_33375,inst_33323);
} else
{if((state_val_33393 === (11)))
{var inst_33347 = (state_33392[(10)]);var inst_33333 = (state_33392[(16)]);var inst_33347__$1 = cljs.core.seq.call(null,inst_33333);var state_33392__$1 = (function (){var statearr_33416 = state_33392;(statearr_33416[(10)] = inst_33347__$1);
return statearr_33416;
})();if(inst_33347__$1)
{var statearr_33417_33459 = state_33392__$1;(statearr_33417_33459[(1)] = (13));
} else
{var statearr_33418_33460 = state_33392__$1;(statearr_33418_33460[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (9)))
{var inst_33369 = (state_33392[(2)]);var state_33392__$1 = state_33392;var statearr_33419_33461 = state_33392__$1;(statearr_33419_33461[(2)] = inst_33369);
(statearr_33419_33461[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (5)))
{var inst_33330 = cljs.core.deref.call(null,mults);var inst_33331 = cljs.core.vals.call(null,inst_33330);var inst_33332 = cljs.core.seq.call(null,inst_33331);var inst_33333 = inst_33332;var inst_33334 = null;var inst_33335 = (0);var inst_33336 = (0);var state_33392__$1 = (function (){var statearr_33420 = state_33392;(statearr_33420[(12)] = inst_33334);
(statearr_33420[(13)] = inst_33335);
(statearr_33420[(14)] = inst_33336);
(statearr_33420[(16)] = inst_33333);
return statearr_33420;
})();var statearr_33421_33462 = state_33392__$1;(statearr_33421_33462[(2)] = null);
(statearr_33421_33462[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (14)))
{var state_33392__$1 = state_33392;var statearr_33425_33463 = state_33392__$1;(statearr_33425_33463[(2)] = null);
(statearr_33425_33463[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (16)))
{var inst_33347 = (state_33392[(10)]);var inst_33351 = cljs.core.chunk_first.call(null,inst_33347);var inst_33352 = cljs.core.chunk_rest.call(null,inst_33347);var inst_33353 = cljs.core.count.call(null,inst_33351);var inst_33333 = inst_33352;var inst_33334 = inst_33351;var inst_33335 = inst_33353;var inst_33336 = (0);var state_33392__$1 = (function (){var statearr_33426 = state_33392;(statearr_33426[(12)] = inst_33334);
(statearr_33426[(13)] = inst_33335);
(statearr_33426[(14)] = inst_33336);
(statearr_33426[(16)] = inst_33333);
return statearr_33426;
})();var statearr_33427_33464 = state_33392__$1;(statearr_33427_33464[(2)] = null);
(statearr_33427_33464[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (10)))
{var inst_33334 = (state_33392[(12)]);var inst_33335 = (state_33392[(13)]);var inst_33336 = (state_33392[(14)]);var inst_33333 = (state_33392[(16)]);var inst_33341 = cljs.core._nth.call(null,inst_33334,inst_33336);var inst_33342 = cljs.core.async.muxch_STAR_.call(null,inst_33341);var inst_33343 = cljs.core.async.close_BANG_.call(null,inst_33342);var inst_33344 = (inst_33336 + (1));var tmp33422 = inst_33334;var tmp33423 = inst_33335;var tmp33424 = inst_33333;var inst_33333__$1 = tmp33424;var inst_33334__$1 = tmp33422;var inst_33335__$1 = tmp33423;var inst_33336__$1 = inst_33344;var state_33392__$1 = (function (){var statearr_33428 = state_33392;(statearr_33428[(12)] = inst_33334__$1);
(statearr_33428[(13)] = inst_33335__$1);
(statearr_33428[(14)] = inst_33336__$1);
(statearr_33428[(17)] = inst_33343);
(statearr_33428[(16)] = inst_33333__$1);
return statearr_33428;
})();var statearr_33429_33465 = state_33392__$1;(statearr_33429_33465[(2)] = null);
(statearr_33429_33465[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (18)))
{var inst_33362 = (state_33392[(2)]);var state_33392__$1 = state_33392;var statearr_33430_33466 = state_33392__$1;(statearr_33430_33466[(2)] = inst_33362);
(statearr_33430_33466[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33393 === (8)))
{var inst_33335 = (state_33392[(13)]);var inst_33336 = (state_33392[(14)]);var inst_33338 = (inst_33336 < inst_33335);var inst_33339 = inst_33338;var state_33392__$1 = state_33392;if(cljs.core.truth_(inst_33339))
{var statearr_33431_33467 = state_33392__$1;(statearr_33431_33467[(1)] = (10));
} else
{var statearr_33432_33468 = state_33392__$1;(statearr_33432_33468[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33440,mults,ensure_mult,p))
;return ((function (switch__7350__auto__,c__7365__auto___33440,mults,ensure_mult,p){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33436 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33436[(0)] = state_machine__7351__auto__);
(statearr_33436[(1)] = (1));
return statearr_33436;
});
var state_machine__7351__auto____1 = (function (state_33392){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33392);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33437){if((e33437 instanceof Object))
{var ex__7354__auto__ = e33437;var statearr_33438_33469 = state_33392;(statearr_33438_33469[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33392);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33437;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33470 = state_33392;
state_33392 = G__33470;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33392){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33440,mults,ensure_mult,p))
})();var state__7367__auto__ = (function (){var statearr_33439 = f__7366__auto__.call(null);(statearr_33439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33440);
return statearr_33439;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33440,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__7365__auto___33607 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33607,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33607,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33577){var state_val_33578 = (state_33577[(1)]);if((state_val_33578 === (7)))
{var state_33577__$1 = state_33577;var statearr_33579_33608 = state_33577__$1;(statearr_33579_33608[(2)] = null);
(statearr_33579_33608[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (1)))
{var state_33577__$1 = state_33577;var statearr_33580_33609 = state_33577__$1;(statearr_33580_33609[(2)] = null);
(statearr_33580_33609[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (4)))
{var inst_33541 = (state_33577[(7)]);var inst_33543 = (inst_33541 < cnt);var state_33577__$1 = state_33577;if(cljs.core.truth_(inst_33543))
{var statearr_33581_33610 = state_33577__$1;(statearr_33581_33610[(1)] = (6));
} else
{var statearr_33582_33611 = state_33577__$1;(statearr_33582_33611[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (15)))
{var inst_33573 = (state_33577[(2)]);var state_33577__$1 = state_33577;var statearr_33583_33612 = state_33577__$1;(statearr_33583_33612[(2)] = inst_33573);
(statearr_33583_33612[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (13)))
{var inst_33566 = cljs.core.async.close_BANG_.call(null,out);var state_33577__$1 = state_33577;var statearr_33584_33613 = state_33577__$1;(statearr_33584_33613[(2)] = inst_33566);
(statearr_33584_33613[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (6)))
{var state_33577__$1 = state_33577;var statearr_33585_33614 = state_33577__$1;(statearr_33585_33614[(2)] = null);
(statearr_33585_33614[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (3)))
{var inst_33575 = (state_33577[(2)]);var state_33577__$1 = state_33577;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33577__$1,inst_33575);
} else
{if((state_val_33578 === (12)))
{var inst_33563 = (state_33577[(8)]);var inst_33563__$1 = (state_33577[(2)]);var inst_33564 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_33563__$1);var state_33577__$1 = (function (){var statearr_33586 = state_33577;(statearr_33586[(8)] = inst_33563__$1);
return statearr_33586;
})();if(cljs.core.truth_(inst_33564))
{var statearr_33587_33615 = state_33577__$1;(statearr_33587_33615[(1)] = (13));
} else
{var statearr_33588_33616 = state_33577__$1;(statearr_33588_33616[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (2)))
{var inst_33540 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_33541 = (0);var state_33577__$1 = (function (){var statearr_33589 = state_33577;(statearr_33589[(9)] = inst_33540);
(statearr_33589[(7)] = inst_33541);
return statearr_33589;
})();var statearr_33590_33617 = state_33577__$1;(statearr_33590_33617[(2)] = null);
(statearr_33590_33617[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (11)))
{var inst_33541 = (state_33577[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33577,(10),Object,null,(9));var inst_33550 = chs__$1.call(null,inst_33541);var inst_33551 = done.call(null,inst_33541);var inst_33552 = cljs.core.async.take_BANG_.call(null,inst_33550,inst_33551);var state_33577__$1 = state_33577;var statearr_33591_33618 = state_33577__$1;(statearr_33591_33618[(2)] = inst_33552);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33577__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (9)))
{var inst_33541 = (state_33577[(7)]);var inst_33554 = (state_33577[(2)]);var inst_33555 = (inst_33541 + (1));var inst_33541__$1 = inst_33555;var state_33577__$1 = (function (){var statearr_33592 = state_33577;(statearr_33592[(7)] = inst_33541__$1);
(statearr_33592[(10)] = inst_33554);
return statearr_33592;
})();var statearr_33593_33619 = state_33577__$1;(statearr_33593_33619[(2)] = null);
(statearr_33593_33619[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (5)))
{var inst_33561 = (state_33577[(2)]);var state_33577__$1 = (function (){var statearr_33594 = state_33577;(statearr_33594[(11)] = inst_33561);
return statearr_33594;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33577__$1,(12),dchan);
} else
{if((state_val_33578 === (14)))
{var inst_33563 = (state_33577[(8)]);var inst_33568 = cljs.core.apply.call(null,f,inst_33563);var state_33577__$1 = state_33577;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33577__$1,(16),out,inst_33568);
} else
{if((state_val_33578 === (16)))
{var inst_33570 = (state_33577[(2)]);var state_33577__$1 = (function (){var statearr_33595 = state_33577;(statearr_33595[(12)] = inst_33570);
return statearr_33595;
})();var statearr_33596_33620 = state_33577__$1;(statearr_33596_33620[(2)] = null);
(statearr_33596_33620[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (10)))
{var inst_33545 = (state_33577[(2)]);var inst_33546 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_33577__$1 = (function (){var statearr_33597 = state_33577;(statearr_33597[(13)] = inst_33545);
return statearr_33597;
})();var statearr_33598_33621 = state_33577__$1;(statearr_33598_33621[(2)] = inst_33546);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33577__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33578 === (8)))
{var inst_33559 = (state_33577[(2)]);var state_33577__$1 = state_33577;var statearr_33599_33622 = state_33577__$1;(statearr_33599_33622[(2)] = inst_33559);
(statearr_33599_33622[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33607,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__7350__auto__,c__7365__auto___33607,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33603[(0)] = state_machine__7351__auto__);
(statearr_33603[(1)] = (1));
return statearr_33603;
});
var state_machine__7351__auto____1 = (function (state_33577){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33577);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33604){if((e33604 instanceof Object))
{var ex__7354__auto__ = e33604;var statearr_33605_33623 = state_33577;(statearr_33605_33623[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33577);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33604;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33624 = state_33577;
state_33577 = G__33624;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33577){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33607,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__7367__auto__ = (function (){var statearr_33606 = f__7366__auto__.call(null);(statearr_33606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33607);
return statearr_33606;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33607,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33732 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33732,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33732,out){
return (function (state_33708){var state_val_33709 = (state_33708[(1)]);if((state_val_33709 === (7)))
{var inst_33687 = (state_33708[(7)]);var inst_33688 = (state_33708[(8)]);var inst_33687__$1 = (state_33708[(2)]);var inst_33688__$1 = cljs.core.nth.call(null,inst_33687__$1,(0),null);var inst_33689 = cljs.core.nth.call(null,inst_33687__$1,(1),null);var inst_33690 = (inst_33688__$1 == null);var state_33708__$1 = (function (){var statearr_33710 = state_33708;(statearr_33710[(7)] = inst_33687__$1);
(statearr_33710[(8)] = inst_33688__$1);
(statearr_33710[(9)] = inst_33689);
return statearr_33710;
})();if(cljs.core.truth_(inst_33690))
{var statearr_33711_33733 = state_33708__$1;(statearr_33711_33733[(1)] = (8));
} else
{var statearr_33712_33734 = state_33708__$1;(statearr_33712_33734[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (1)))
{var inst_33679 = cljs.core.vec.call(null,chs);var inst_33680 = inst_33679;var state_33708__$1 = (function (){var statearr_33713 = state_33708;(statearr_33713[(10)] = inst_33680);
return statearr_33713;
})();var statearr_33714_33735 = state_33708__$1;(statearr_33714_33735[(2)] = null);
(statearr_33714_33735[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (4)))
{var inst_33680 = (state_33708[(10)]);var state_33708__$1 = state_33708;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_33708__$1,(7),inst_33680);
} else
{if((state_val_33709 === (6)))
{var inst_33704 = (state_33708[(2)]);var state_33708__$1 = state_33708;var statearr_33715_33736 = state_33708__$1;(statearr_33715_33736[(2)] = inst_33704);
(statearr_33715_33736[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (3)))
{var inst_33706 = (state_33708[(2)]);var state_33708__$1 = state_33708;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33708__$1,inst_33706);
} else
{if((state_val_33709 === (2)))
{var inst_33680 = (state_33708[(10)]);var inst_33682 = cljs.core.count.call(null,inst_33680);var inst_33683 = (inst_33682 > (0));var state_33708__$1 = state_33708;if(cljs.core.truth_(inst_33683))
{var statearr_33717_33737 = state_33708__$1;(statearr_33717_33737[(1)] = (4));
} else
{var statearr_33718_33738 = state_33708__$1;(statearr_33718_33738[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (11)))
{var inst_33680 = (state_33708[(10)]);var inst_33697 = (state_33708[(2)]);var tmp33716 = inst_33680;var inst_33680__$1 = tmp33716;var state_33708__$1 = (function (){var statearr_33719 = state_33708;(statearr_33719[(10)] = inst_33680__$1);
(statearr_33719[(11)] = inst_33697);
return statearr_33719;
})();var statearr_33720_33739 = state_33708__$1;(statearr_33720_33739[(2)] = null);
(statearr_33720_33739[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (9)))
{var inst_33688 = (state_33708[(8)]);var state_33708__$1 = state_33708;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33708__$1,(11),out,inst_33688);
} else
{if((state_val_33709 === (5)))
{var inst_33702 = cljs.core.async.close_BANG_.call(null,out);var state_33708__$1 = state_33708;var statearr_33721_33740 = state_33708__$1;(statearr_33721_33740[(2)] = inst_33702);
(statearr_33721_33740[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (10)))
{var inst_33700 = (state_33708[(2)]);var state_33708__$1 = state_33708;var statearr_33722_33741 = state_33708__$1;(statearr_33722_33741[(2)] = inst_33700);
(statearr_33722_33741[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33709 === (8)))
{var inst_33687 = (state_33708[(7)]);var inst_33688 = (state_33708[(8)]);var inst_33689 = (state_33708[(9)]);var inst_33680 = (state_33708[(10)]);var inst_33692 = (function (){var c = inst_33689;var v = inst_33688;var vec__33685 = inst_33687;var cs = inst_33680;return ((function (c,v,vec__33685,cs,inst_33687,inst_33688,inst_33689,inst_33680,state_val_33709,c__7365__auto___33732,out){
return (function (p1__33625_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__33625_SHARP_);
});
;})(c,v,vec__33685,cs,inst_33687,inst_33688,inst_33689,inst_33680,state_val_33709,c__7365__auto___33732,out))
})();var inst_33693 = cljs.core.filterv.call(null,inst_33692,inst_33680);var inst_33680__$1 = inst_33693;var state_33708__$1 = (function (){var statearr_33723 = state_33708;(statearr_33723[(10)] = inst_33680__$1);
return statearr_33723;
})();var statearr_33724_33742 = state_33708__$1;(statearr_33724_33742[(2)] = null);
(statearr_33724_33742[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33732,out))
;return ((function (switch__7350__auto__,c__7365__auto___33732,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33728 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33728[(0)] = state_machine__7351__auto__);
(statearr_33728[(1)] = (1));
return statearr_33728;
});
var state_machine__7351__auto____1 = (function (state_33708){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33708);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33729){if((e33729 instanceof Object))
{var ex__7354__auto__ = e33729;var statearr_33730_33743 = state_33708;(statearr_33730_33743[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33708);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33729;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33744 = state_33708;
state_33708 = G__33744;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33708){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33732,out))
})();var state__7367__auto__ = (function (){var statearr_33731 = f__7366__auto__.call(null);(statearr_33731[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33732);
return statearr_33731;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33732,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33837 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33837,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33837,out){
return (function (state_33814){var state_val_33815 = (state_33814[(1)]);if((state_val_33815 === (7)))
{var inst_33796 = (state_33814[(7)]);var inst_33796__$1 = (state_33814[(2)]);var inst_33797 = (inst_33796__$1 == null);var inst_33798 = cljs.core.not.call(null,inst_33797);var state_33814__$1 = (function (){var statearr_33816 = state_33814;(statearr_33816[(7)] = inst_33796__$1);
return statearr_33816;
})();if(inst_33798)
{var statearr_33817_33838 = state_33814__$1;(statearr_33817_33838[(1)] = (8));
} else
{var statearr_33818_33839 = state_33814__$1;(statearr_33818_33839[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (1)))
{var inst_33791 = (0);var state_33814__$1 = (function (){var statearr_33819 = state_33814;(statearr_33819[(8)] = inst_33791);
return statearr_33819;
})();var statearr_33820_33840 = state_33814__$1;(statearr_33820_33840[(2)] = null);
(statearr_33820_33840[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (4)))
{var state_33814__$1 = state_33814;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33814__$1,(7),ch);
} else
{if((state_val_33815 === (6)))
{var inst_33809 = (state_33814[(2)]);var state_33814__$1 = state_33814;var statearr_33821_33841 = state_33814__$1;(statearr_33821_33841[(2)] = inst_33809);
(statearr_33821_33841[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (3)))
{var inst_33811 = (state_33814[(2)]);var inst_33812 = cljs.core.async.close_BANG_.call(null,out);var state_33814__$1 = (function (){var statearr_33822 = state_33814;(statearr_33822[(9)] = inst_33811);
return statearr_33822;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33814__$1,inst_33812);
} else
{if((state_val_33815 === (2)))
{var inst_33791 = (state_33814[(8)]);var inst_33793 = (inst_33791 < n);var state_33814__$1 = state_33814;if(cljs.core.truth_(inst_33793))
{var statearr_33823_33842 = state_33814__$1;(statearr_33823_33842[(1)] = (4));
} else
{var statearr_33824_33843 = state_33814__$1;(statearr_33824_33843[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (11)))
{var inst_33791 = (state_33814[(8)]);var inst_33801 = (state_33814[(2)]);var inst_33802 = (inst_33791 + (1));var inst_33791__$1 = inst_33802;var state_33814__$1 = (function (){var statearr_33825 = state_33814;(statearr_33825[(8)] = inst_33791__$1);
(statearr_33825[(10)] = inst_33801);
return statearr_33825;
})();var statearr_33826_33844 = state_33814__$1;(statearr_33826_33844[(2)] = null);
(statearr_33826_33844[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (9)))
{var state_33814__$1 = state_33814;var statearr_33827_33845 = state_33814__$1;(statearr_33827_33845[(2)] = null);
(statearr_33827_33845[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (5)))
{var state_33814__$1 = state_33814;var statearr_33828_33846 = state_33814__$1;(statearr_33828_33846[(2)] = null);
(statearr_33828_33846[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (10)))
{var inst_33806 = (state_33814[(2)]);var state_33814__$1 = state_33814;var statearr_33829_33847 = state_33814__$1;(statearr_33829_33847[(2)] = inst_33806);
(statearr_33829_33847[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33815 === (8)))
{var inst_33796 = (state_33814[(7)]);var state_33814__$1 = state_33814;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33814__$1,(11),out,inst_33796);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33837,out))
;return ((function (switch__7350__auto__,c__7365__auto___33837,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33833 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_33833[(0)] = state_machine__7351__auto__);
(statearr_33833[(1)] = (1));
return statearr_33833;
});
var state_machine__7351__auto____1 = (function (state_33814){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33814);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33834){if((e33834 instanceof Object))
{var ex__7354__auto__ = e33834;var statearr_33835_33848 = state_33814;(statearr_33835_33848[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33814);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33834;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33849 = state_33814;
state_33814 = G__33849;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33814){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33837,out))
})();var state__7367__auto__ = (function (){var statearr_33836 = f__7366__auto__.call(null);(statearr_33836[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33837);
return statearr_33836;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33837,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33946 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33946,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33946,out){
return (function (state_33921){var state_val_33922 = (state_33921[(1)]);if((state_val_33922 === (7)))
{var inst_33916 = (state_33921[(2)]);var state_33921__$1 = state_33921;var statearr_33923_33947 = state_33921__$1;(statearr_33923_33947[(2)] = inst_33916);
(statearr_33923_33947[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (1)))
{var inst_33898 = null;var state_33921__$1 = (function (){var statearr_33924 = state_33921;(statearr_33924[(7)] = inst_33898);
return statearr_33924;
})();var statearr_33925_33948 = state_33921__$1;(statearr_33925_33948[(2)] = null);
(statearr_33925_33948[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (4)))
{var inst_33901 = (state_33921[(8)]);var inst_33901__$1 = (state_33921[(2)]);var inst_33902 = (inst_33901__$1 == null);var inst_33903 = cljs.core.not.call(null,inst_33902);var state_33921__$1 = (function (){var statearr_33926 = state_33921;(statearr_33926[(8)] = inst_33901__$1);
return statearr_33926;
})();if(inst_33903)
{var statearr_33927_33949 = state_33921__$1;(statearr_33927_33949[(1)] = (5));
} else
{var statearr_33928_33950 = state_33921__$1;(statearr_33928_33950[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (6)))
{var state_33921__$1 = state_33921;var statearr_33929_33951 = state_33921__$1;(statearr_33929_33951[(2)] = null);
(statearr_33929_33951[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (3)))
{var inst_33918 = (state_33921[(2)]);var inst_33919 = cljs.core.async.close_BANG_.call(null,out);var state_33921__$1 = (function (){var statearr_33930 = state_33921;(statearr_33930[(9)] = inst_33918);
return statearr_33930;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33921__$1,inst_33919);
} else
{if((state_val_33922 === (2)))
{var state_33921__$1 = state_33921;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33921__$1,(4),ch);
} else
{if((state_val_33922 === (11)))
{var inst_33901 = (state_33921[(8)]);var inst_33910 = (state_33921[(2)]);var inst_33898 = inst_33901;var state_33921__$1 = (function (){var statearr_33931 = state_33921;(statearr_33931[(7)] = inst_33898);
(statearr_33931[(10)] = inst_33910);
return statearr_33931;
})();var statearr_33932_33952 = state_33921__$1;(statearr_33932_33952[(2)] = null);
(statearr_33932_33952[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (9)))
{var inst_33901 = (state_33921[(8)]);var state_33921__$1 = state_33921;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33921__$1,(11),out,inst_33901);
} else
{if((state_val_33922 === (5)))
{var inst_33898 = (state_33921[(7)]);var inst_33901 = (state_33921[(8)]);var inst_33905 = cljs.core._EQ_.call(null,inst_33901,inst_33898);var state_33921__$1 = state_33921;if(inst_33905)
{var statearr_33934_33953 = state_33921__$1;(statearr_33934_33953[(1)] = (8));
} else
{var statearr_33935_33954 = state_33921__$1;(statearr_33935_33954[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (10)))
{var inst_33913 = (state_33921[(2)]);var state_33921__$1 = state_33921;var statearr_33936_33955 = state_33921__$1;(statearr_33936_33955[(2)] = inst_33913);
(statearr_33936_33955[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33922 === (8)))
{var inst_33898 = (state_33921[(7)]);var tmp33933 = inst_33898;var inst_33898__$1 = tmp33933;var state_33921__$1 = (function (){var statearr_33937 = state_33921;(statearr_33937[(7)] = inst_33898__$1);
return statearr_33937;
})();var statearr_33938_33956 = state_33921__$1;(statearr_33938_33956[(2)] = null);
(statearr_33938_33956[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33946,out))
;return ((function (switch__7350__auto__,c__7365__auto___33946,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33942 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_33942[(0)] = state_machine__7351__auto__);
(statearr_33942[(1)] = (1));
return statearr_33942;
});
var state_machine__7351__auto____1 = (function (state_33921){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33921);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33943){if((e33943 instanceof Object))
{var ex__7354__auto__ = e33943;var statearr_33944_33957 = state_33921;(statearr_33944_33957[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33921);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33943;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33958 = state_33921;
state_33921 = G__33958;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33921){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33946,out))
})();var state__7367__auto__ = (function (){var statearr_33945 = f__7366__auto__.call(null);(statearr_33945[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33946);
return statearr_33945;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33946,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___34093 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___34093,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___34093,out){
return (function (state_34063){var state_val_34064 = (state_34063[(1)]);if((state_val_34064 === (7)))
{var inst_34059 = (state_34063[(2)]);var state_34063__$1 = state_34063;var statearr_34065_34094 = state_34063__$1;(statearr_34065_34094[(2)] = inst_34059);
(statearr_34065_34094[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (1)))
{var inst_34026 = (new Array(n));var inst_34027 = inst_34026;var inst_34028 = (0);var state_34063__$1 = (function (){var statearr_34066 = state_34063;(statearr_34066[(7)] = inst_34028);
(statearr_34066[(8)] = inst_34027);
return statearr_34066;
})();var statearr_34067_34095 = state_34063__$1;(statearr_34067_34095[(2)] = null);
(statearr_34067_34095[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (4)))
{var inst_34031 = (state_34063[(9)]);var inst_34031__$1 = (state_34063[(2)]);var inst_34032 = (inst_34031__$1 == null);var inst_34033 = cljs.core.not.call(null,inst_34032);var state_34063__$1 = (function (){var statearr_34068 = state_34063;(statearr_34068[(9)] = inst_34031__$1);
return statearr_34068;
})();if(inst_34033)
{var statearr_34069_34096 = state_34063__$1;(statearr_34069_34096[(1)] = (5));
} else
{var statearr_34070_34097 = state_34063__$1;(statearr_34070_34097[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (15)))
{var inst_34053 = (state_34063[(2)]);var state_34063__$1 = state_34063;var statearr_34071_34098 = state_34063__$1;(statearr_34071_34098[(2)] = inst_34053);
(statearr_34071_34098[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (13)))
{var state_34063__$1 = state_34063;var statearr_34072_34099 = state_34063__$1;(statearr_34072_34099[(2)] = null);
(statearr_34072_34099[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (6)))
{var inst_34028 = (state_34063[(7)]);var inst_34049 = (inst_34028 > (0));var state_34063__$1 = state_34063;if(cljs.core.truth_(inst_34049))
{var statearr_34073_34100 = state_34063__$1;(statearr_34073_34100[(1)] = (12));
} else
{var statearr_34074_34101 = state_34063__$1;(statearr_34074_34101[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (3)))
{var inst_34061 = (state_34063[(2)]);var state_34063__$1 = state_34063;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34063__$1,inst_34061);
} else
{if((state_val_34064 === (12)))
{var inst_34027 = (state_34063[(8)]);var inst_34051 = cljs.core.vec.call(null,inst_34027);var state_34063__$1 = state_34063;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34063__$1,(15),out,inst_34051);
} else
{if((state_val_34064 === (2)))
{var state_34063__$1 = state_34063;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34063__$1,(4),ch);
} else
{if((state_val_34064 === (11)))
{var inst_34043 = (state_34063[(2)]);var inst_34044 = (new Array(n));var inst_34027 = inst_34044;var inst_34028 = (0);var state_34063__$1 = (function (){var statearr_34075 = state_34063;(statearr_34075[(10)] = inst_34043);
(statearr_34075[(7)] = inst_34028);
(statearr_34075[(8)] = inst_34027);
return statearr_34075;
})();var statearr_34076_34102 = state_34063__$1;(statearr_34076_34102[(2)] = null);
(statearr_34076_34102[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (9)))
{var inst_34027 = (state_34063[(8)]);var inst_34041 = cljs.core.vec.call(null,inst_34027);var state_34063__$1 = state_34063;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34063__$1,(11),out,inst_34041);
} else
{if((state_val_34064 === (5)))
{var inst_34028 = (state_34063[(7)]);var inst_34036 = (state_34063[(11)]);var inst_34027 = (state_34063[(8)]);var inst_34031 = (state_34063[(9)]);var inst_34035 = (inst_34027[inst_34028] = inst_34031);var inst_34036__$1 = (inst_34028 + (1));var inst_34037 = (inst_34036__$1 < n);var state_34063__$1 = (function (){var statearr_34077 = state_34063;(statearr_34077[(12)] = inst_34035);
(statearr_34077[(11)] = inst_34036__$1);
return statearr_34077;
})();if(cljs.core.truth_(inst_34037))
{var statearr_34078_34103 = state_34063__$1;(statearr_34078_34103[(1)] = (8));
} else
{var statearr_34079_34104 = state_34063__$1;(statearr_34079_34104[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (14)))
{var inst_34056 = (state_34063[(2)]);var inst_34057 = cljs.core.async.close_BANG_.call(null,out);var state_34063__$1 = (function (){var statearr_34081 = state_34063;(statearr_34081[(13)] = inst_34056);
return statearr_34081;
})();var statearr_34082_34105 = state_34063__$1;(statearr_34082_34105[(2)] = inst_34057);
(statearr_34082_34105[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (10)))
{var inst_34047 = (state_34063[(2)]);var state_34063__$1 = state_34063;var statearr_34083_34106 = state_34063__$1;(statearr_34083_34106[(2)] = inst_34047);
(statearr_34083_34106[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34064 === (8)))
{var inst_34036 = (state_34063[(11)]);var inst_34027 = (state_34063[(8)]);var tmp34080 = inst_34027;var inst_34027__$1 = tmp34080;var inst_34028 = inst_34036;var state_34063__$1 = (function (){var statearr_34084 = state_34063;(statearr_34084[(7)] = inst_34028);
(statearr_34084[(8)] = inst_34027__$1);
return statearr_34084;
})();var statearr_34085_34107 = state_34063__$1;(statearr_34085_34107[(2)] = null);
(statearr_34085_34107[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___34093,out))
;return ((function (switch__7350__auto__,c__7365__auto___34093,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_34089 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_34089[(0)] = state_machine__7351__auto__);
(statearr_34089[(1)] = (1));
return statearr_34089;
});
var state_machine__7351__auto____1 = (function (state_34063){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_34063);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e34090){if((e34090 instanceof Object))
{var ex__7354__auto__ = e34090;var statearr_34091_34108 = state_34063;(statearr_34091_34108[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34063);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e34090;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__34109 = state_34063;
state_34063 = G__34109;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_34063){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_34063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___34093,out))
})();var state__7367__auto__ = (function (){var statearr_34092 = f__7366__auto__.call(null);(statearr_34092[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___34093);
return statearr_34092;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___34093,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___34252 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___34252,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___34252,out){
return (function (state_34222){var state_val_34223 = (state_34222[(1)]);if((state_val_34223 === (7)))
{var inst_34218 = (state_34222[(2)]);var state_34222__$1 = state_34222;var statearr_34224_34253 = state_34222__$1;(statearr_34224_34253[(2)] = inst_34218);
(statearr_34224_34253[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (1)))
{var inst_34181 = [];var inst_34182 = inst_34181;var inst_34183 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_34222__$1 = (function (){var statearr_34225 = state_34222;(statearr_34225[(7)] = inst_34183);
(statearr_34225[(8)] = inst_34182);
return statearr_34225;
})();var statearr_34226_34254 = state_34222__$1;(statearr_34226_34254[(2)] = null);
(statearr_34226_34254[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (4)))
{var inst_34186 = (state_34222[(9)]);var inst_34186__$1 = (state_34222[(2)]);var inst_34187 = (inst_34186__$1 == null);var inst_34188 = cljs.core.not.call(null,inst_34187);var state_34222__$1 = (function (){var statearr_34227 = state_34222;(statearr_34227[(9)] = inst_34186__$1);
return statearr_34227;
})();if(inst_34188)
{var statearr_34228_34255 = state_34222__$1;(statearr_34228_34255[(1)] = (5));
} else
{var statearr_34229_34256 = state_34222__$1;(statearr_34229_34256[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (15)))
{var inst_34212 = (state_34222[(2)]);var state_34222__$1 = state_34222;var statearr_34230_34257 = state_34222__$1;(statearr_34230_34257[(2)] = inst_34212);
(statearr_34230_34257[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (13)))
{var state_34222__$1 = state_34222;var statearr_34231_34258 = state_34222__$1;(statearr_34231_34258[(2)] = null);
(statearr_34231_34258[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (6)))
{var inst_34182 = (state_34222[(8)]);var inst_34207 = inst_34182.length;var inst_34208 = (inst_34207 > (0));var state_34222__$1 = state_34222;if(cljs.core.truth_(inst_34208))
{var statearr_34232_34259 = state_34222__$1;(statearr_34232_34259[(1)] = (12));
} else
{var statearr_34233_34260 = state_34222__$1;(statearr_34233_34260[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (3)))
{var inst_34220 = (state_34222[(2)]);var state_34222__$1 = state_34222;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34222__$1,inst_34220);
} else
{if((state_val_34223 === (12)))
{var inst_34182 = (state_34222[(8)]);var inst_34210 = cljs.core.vec.call(null,inst_34182);var state_34222__$1 = state_34222;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34222__$1,(15),out,inst_34210);
} else
{if((state_val_34223 === (2)))
{var state_34222__$1 = state_34222;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34222__$1,(4),ch);
} else
{if((state_val_34223 === (11)))
{var inst_34190 = (state_34222[(10)]);var inst_34186 = (state_34222[(9)]);var inst_34200 = (state_34222[(2)]);var inst_34201 = [];var inst_34202 = inst_34201.push(inst_34186);var inst_34182 = inst_34201;var inst_34183 = inst_34190;var state_34222__$1 = (function (){var statearr_34234 = state_34222;(statearr_34234[(7)] = inst_34183);
(statearr_34234[(11)] = inst_34200);
(statearr_34234[(12)] = inst_34202);
(statearr_34234[(8)] = inst_34182);
return statearr_34234;
})();var statearr_34235_34261 = state_34222__$1;(statearr_34235_34261[(2)] = null);
(statearr_34235_34261[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (9)))
{var inst_34182 = (state_34222[(8)]);var inst_34198 = cljs.core.vec.call(null,inst_34182);var state_34222__$1 = state_34222;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34222__$1,(11),out,inst_34198);
} else
{if((state_val_34223 === (5)))
{var inst_34183 = (state_34222[(7)]);var inst_34190 = (state_34222[(10)]);var inst_34186 = (state_34222[(9)]);var inst_34190__$1 = f.call(null,inst_34186);var inst_34191 = cljs.core._EQ_.call(null,inst_34190__$1,inst_34183);var inst_34192 = cljs.core.keyword_identical_QMARK_.call(null,inst_34183,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_34193 = (inst_34191) || (inst_34192);var state_34222__$1 = (function (){var statearr_34236 = state_34222;(statearr_34236[(10)] = inst_34190__$1);
return statearr_34236;
})();if(cljs.core.truth_(inst_34193))
{var statearr_34237_34262 = state_34222__$1;(statearr_34237_34262[(1)] = (8));
} else
{var statearr_34238_34263 = state_34222__$1;(statearr_34238_34263[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (14)))
{var inst_34215 = (state_34222[(2)]);var inst_34216 = cljs.core.async.close_BANG_.call(null,out);var state_34222__$1 = (function (){var statearr_34240 = state_34222;(statearr_34240[(13)] = inst_34215);
return statearr_34240;
})();var statearr_34241_34264 = state_34222__$1;(statearr_34241_34264[(2)] = inst_34216);
(statearr_34241_34264[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (10)))
{var inst_34205 = (state_34222[(2)]);var state_34222__$1 = state_34222;var statearr_34242_34265 = state_34222__$1;(statearr_34242_34265[(2)] = inst_34205);
(statearr_34242_34265[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34223 === (8)))
{var inst_34190 = (state_34222[(10)]);var inst_34186 = (state_34222[(9)]);var inst_34182 = (state_34222[(8)]);var inst_34195 = inst_34182.push(inst_34186);var tmp34239 = inst_34182;var inst_34182__$1 = tmp34239;var inst_34183 = inst_34190;var state_34222__$1 = (function (){var statearr_34243 = state_34222;(statearr_34243[(7)] = inst_34183);
(statearr_34243[(8)] = inst_34182__$1);
(statearr_34243[(14)] = inst_34195);
return statearr_34243;
})();var statearr_34244_34266 = state_34222__$1;(statearr_34244_34266[(2)] = null);
(statearr_34244_34266[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___34252,out))
;return ((function (switch__7350__auto__,c__7365__auto___34252,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_34248 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_34248[(0)] = state_machine__7351__auto__);
(statearr_34248[(1)] = (1));
return statearr_34248;
});
var state_machine__7351__auto____1 = (function (state_34222){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_34222);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e34249){if((e34249 instanceof Object))
{var ex__7354__auto__ = e34249;var statearr_34250_34267 = state_34222;(statearr_34250_34267[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34222);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e34249;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__34268 = state_34222;
state_34222 = G__34268;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_34222){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_34222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___34252,out))
})();var state__7367__auto__ = (function (){var statearr_34251 = f__7366__auto__.call(null);(statearr_34251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___34252);
return statearr_34251;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___34252,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map