// Compiled by ClojureScript 0.0-2277
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('schema.utils');
goog.require('schema.core');
goog.require('schema.core');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__13991__13992__auto__){var G__36207 = p1__13991__13992__auto__;if(G__36207)
{var bit__4191__auto__ = null;if(cljs.core.truth_((function (){var or__3541__auto__ = bit__4191__auto__;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return G__36207.schema$core$Schema$;
}
})()))
{return true;
} else
{if((!G__36207.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,G__36207);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,G__36207);
}
})], null));
plumbing.fnk.schema.InputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.MapOutputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
* Like (assert (distinct? things)) but with a more helpful error message.
*/
plumbing.fnk.schema.assert_distinct = (function assert_distinct(things){var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__36208_SHARP_){return (cljs.core.val.call(null,p1__36208_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));if(cljs.core.empty_QMARK_.call(null,repeated_things))
{return null;
} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
* Like (get m k), but throws if k is not present in m.
*/
plumbing.fnk.schema.safe_get = (function safe_get(m,k,key_path){if(cljs.core.map_QMARK_.call(null,m))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}
var vec__36210 = cljs.core.find.call(null,m,k);var _ = cljs.core.nth.call(null,vec__36210,(0),null);var v = cljs.core.nth.call(null,vec__36210,(1),null);var p = vec__36210;if(cljs.core.truth_(p))
{} else
{throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}
return v;
});
plumbing.fnk.schema.non_map_union = (function non_map_union(s1,s2){if(cljs.core._EQ_.call(null,s1,s2))
{return s1;
} else
{if(cljs.core._EQ_.call(null,s1,schema.core.Any))
{return s2;
} else
{if(cljs.core._EQ_.call(null,s2,schema.core.Any))
{return s1;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return schema.core.both.call(null,s1,s2);
} else
{return null;
}
}
}
}
});
/**
* Return a difference of schmas s1 and s2, where one is not a map.
* Punt for now, assuming s2 always satisfies s1.
*/
plumbing.fnk.schema.non_map_diff = (function non_map_diff(s1,s2){return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function map_schema_QMARK_(m){return ((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap));
});
var ufv___36216 = schema.utils.use_fn_validation;var output_schema36211_36217 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));var input_schema36212_36218 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"k","k",-505765866,null))], null);var input_checker36213_36219 = schema.core.checker.call(null,input_schema36212_36218);var output_checker36214_36220 = schema.core.checker.call(null,output_schema36211_36217);/**
* Inputs: [k]
* Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
* 
* Given a possibly-unevaluated schema map key form, unpack an explicit keyword
* and optional? flag, or return nil for a non-explicit key
*/
plumbing.fnk.schema.unwrap_schema_form_key = ((function (ufv___36216,output_schema36211_36217,input_schema36212_36218,input_checker36213_36219,output_checker36214_36220){
return (function unwrap_schema_form_key(G__36215){var validate__13961__auto__ = ufv___36216.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36221 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36215], null);var temp__4126__auto___36222 = input_checker36213_36219.call(null,args__13962__auto___36221);if(cljs.core.truth_(temp__4126__auto___36222))
{var error__13963__auto___36223 = temp__4126__auto___36222;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),cljs.core.pr_str.call(null,error__13963__auto___36223)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36212_36218,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36221,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36223], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var k = G__36215;while(true){
if(schema.core.specific_key_QMARK_.call(null,k))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else
{if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null))))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else
{return null;
}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36224 = output_checker36214_36220.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36224))
{var error__13963__auto___36225 = temp__4126__auto___36224;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),cljs.core.pr_str.call(null,error__13963__auto___36225)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36211_36217,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36225], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36216,output_schema36211_36217,input_schema36212_36218,input_checker36213_36219,output_checker36214_36220))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema36211_36217,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36212_36218], null)));
var ufv___36231 = schema.utils.use_fn_validation;var output_schema36226_36232 = schema.core.Any;var input_schema36227_36233 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"s","s",-948495851,null))], null);var input_checker36228_36234 = schema.core.checker.call(null,input_schema36227_36233);var output_checker36229_36235 = schema.core.checker.call(null,output_schema36226_36232);/**
* Inputs: [s]
* 
* Given a possibly-unevaluated map schema, return a map from bare keyword to true
* (for required) or false (for optional)
*/
plumbing.fnk.schema.explicit_schema_key_map = ((function (ufv___36231,output_schema36226_36232,input_schema36227_36233,input_checker36228_36234,output_checker36229_36235){
return (function explicit_schema_key_map(G__36230){var validate__13961__auto__ = ufv___36231.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36236 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36230], null);var temp__4126__auto___36237 = input_checker36228_36234.call(null,args__13962__auto___36236);if(cljs.core.truth_(temp__4126__auto___36237))
{var error__13963__auto___36238 = temp__4126__auto___36237;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),cljs.core.pr_str.call(null,error__13963__auto___36238)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36227_36233,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36236,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36238], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var s = G__36230;while(true){
new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36239 = output_checker36229_36235.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36239))
{var error__13963__auto___36240 = temp__4126__auto___36239;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),cljs.core.pr_str.call(null,error__13963__auto___36240)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36226_36232,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36240], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36231,output_schema36226_36232,input_schema36227_36233,input_checker36228_36234,output_checker36229_36235))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema36226_36232,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36227_36233], null)));
var ufv___36246 = schema.utils.use_fn_validation;var output_schema36241_36247 = schema.core.Any;var input_schema36242_36248 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false),new cljs.core.Symbol(null,"s","s",-948495851,null))], null);var input_checker36243_36249 = schema.core.checker.call(null,input_schema36242_36248);var output_checker36244_36250 = schema.core.checker.call(null,output_schema36241_36247);/**
* Inputs: [s :- {s/Keyword s/Bool}]
* 
* Given output of explicit-schema-key-map, split into seq [req opt].
*/
plumbing.fnk.schema.split_schema_keys = ((function (ufv___36246,output_schema36241_36247,input_schema36242_36248,input_checker36243_36249,output_checker36244_36250){
return (function split_schema_keys(G__36245){var validate__13961__auto__ = ufv___36246.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36251 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36245], null);var temp__4126__auto___36252 = input_checker36243_36249.call(null,args__13962__auto___36251);if(cljs.core.truth_(temp__4126__auto___36252))
{var error__13963__auto___36253 = temp__4126__auto___36252;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),cljs.core.pr_str.call(null,error__13963__auto___36253)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36242_36248,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36251,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36253], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var s = G__36245;while(true){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36254 = output_checker36244_36250.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36254))
{var error__13963__auto___36255 = temp__4126__auto___36254;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),cljs.core.pr_str.call(null,error__13963__auto___36255)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36241_36247,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36255], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36246,output_schema36241_36247,input_schema36242_36248,input_checker36243_36249,output_checker36244_36250))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema36241_36247,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36242_36248], null)));
/**
* Like merge-with, but also projects keys to a smaller space and merges them similar to the
* values.
* @param {...*} var_args
*/
plumbing.fnk.schema.merge_on_with = (function() { 
var merge_on_with__delegate = function (key_project,key_combine,val_combine,maps){return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__36259){var vec__36260 = p__36259;var k = cljs.core.nth.call(null,vec__36260,(0),null);var v = cljs.core.nth.call(null,vec__36260,(1),null);var pk = key_project.call(null,k);var temp__4124__auto__ = cljs.core.get.call(null,m,pk);if(cljs.core.truth_(temp__4124__auto__))
{var vec__36261 = temp__4124__auto__;var ok = cljs.core.nth.call(null,vec__36261,(0),null);var ov = cljs.core.nth.call(null,vec__36261,(1),null);return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else
{return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
};
var merge_on_with = function (key_project,key_combine,val_combine,var_args){
var maps = null;if (arguments.length > 3) {
  maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return merge_on_with__delegate.call(this,key_project,key_combine,val_combine,maps);};
merge_on_with.cljs$lang$maxFixedArity = 3;
merge_on_with.cljs$lang$applyTo = (function (arglist__36262){
var key_project = cljs.core.first(arglist__36262);
arglist__36262 = cljs.core.next(arglist__36262);
var key_combine = cljs.core.first(arglist__36262);
arglist__36262 = cljs.core.next(arglist__36262);
var val_combine = cljs.core.first(arglist__36262);
var maps = cljs.core.rest(arglist__36262);
return merge_on_with__delegate(key_project,key_combine,val_combine,maps);
});
merge_on_with.cljs$core$IFn$_invoke$arity$variadic = merge_on_with__delegate;
return merge_on_with;
})()
;
var ufv___36270 = schema.utils.use_fn_validation;var output_schema36264_36271 = plumbing.fnk.schema.InputSchema;var input_schema36265_36272 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"i1","i1",-572470430,null)),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"i2","i2",850408895,null))], null);var input_checker36266_36273 = schema.core.checker.call(null,input_schema36265_36272);var output_checker36267_36274 = schema.core.checker.call(null,output_schema36264_36271);/**
* Inputs: [i1 :- InputSchema i2 :- InputSchema]
* Returns: InputSchema
* 
* Returns a minimal input schema schema that entails satisfaction of both s1 and s2
*/
plumbing.fnk.schema.union_input_schemata = ((function (ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274){
return (function union_input_schemata(G__36268,G__36269){var validate__13961__auto__ = ufv___36270.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36275 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36268,G__36269], null);var temp__4126__auto___36276 = input_checker36266_36273.call(null,args__13962__auto___36275);if(cljs.core.truth_(temp__4126__auto___36276))
{var error__13963__auto___36277 = temp__4126__auto___36276;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),cljs.core.pr_str.call(null,error__13963__auto___36277)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36265_36272,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36275,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36277], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var i1 = G__36268;var i2 = G__36269;while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__13961__auto__,ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274){
return (function (p1__36263_SHARP_){if(schema.core.specific_key_QMARK_.call(null,p1__36263_SHARP_))
{return schema.core.explicit_schema_key.call(null,p1__36263_SHARP_);
} else
{return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__13961__auto__,ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274))
,((function (validate__13961__auto__,ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274){
return (function (k1,k2){if(schema.core.required_key_QMARK_.call(null,k1))
{return k1;
} else
{if(schema.core.required_key_QMARK_.call(null,k2))
{return k2;
} else
{if(schema.core.optional_key_QMARK_.call(null,k1))
{if(cljs.core._EQ_.call(null,k1,k2))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"k1","k1",-1701777341,null),new cljs.core.Symbol(null,"k2","k2",-1225133949,null)))))));
}
return k1;
} else
{if(cljs.core._EQ_.call(null,k1,k2))
{return k1;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{if(false)
{return null;
} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));
}
} else
{return null;
}
}
}
}
}
});})(validate__13961__auto__,ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274))
,((function (validate__13961__auto__,ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274){
return (function (s1,s2){if((plumbing.fnk.schema.map_schema_QMARK_.call(null,s1)) && (plumbing.fnk.schema.map_schema_QMARK_.call(null,s2)))
{return union_input_schemata.call(null,s1,s2);
} else
{return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__13961__auto__,ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274))
,i1,i2);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36278 = output_checker36267_36274.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36278))
{var error__13963__auto___36279 = temp__4126__auto___36278;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),cljs.core.pr_str.call(null,error__13963__auto___36279)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36264_36271,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36279], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36270,output_schema36264_36271,input_schema36265_36272,input_checker36266_36273,output_checker36267_36274))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema36264_36271,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36265_36272], null)));
var ufv___36285 = schema.utils.use_fn_validation;var output_schema36280_36286 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);var input_schema36281_36287 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null))], null);var input_checker36282_36288 = schema.core.checker.call(null,input_schema36281_36287);var output_checker36283_36289 = schema.core.checker.call(null,output_schema36280_36286);/**
* Inputs: [input-schema :- InputSchema]
* Returns: [s/Keyword]
* 
* Which top-level keys are required (i.e., non-false) by this input schema.
*/
plumbing.fnk.schema.required_toplevel_keys = ((function (ufv___36285,output_schema36280_36286,input_schema36281_36287,input_checker36282_36288,output_checker36283_36289){
return (function required_toplevel_keys(G__36284){var validate__13961__auto__ = ufv___36285.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36290 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36284], null);var temp__4126__auto___36291 = input_checker36282_36288.call(null,args__13962__auto___36290);if(cljs.core.truth_(temp__4126__auto___36291))
{var error__13963__auto___36292 = temp__4126__auto___36291;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),cljs.core.pr_str.call(null,error__13963__auto___36292)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36281_36287,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36290,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36292], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var input_schema = G__36284;while(true){
return cljs.core.keep.call(null,((function (validate__13961__auto__,ufv___36285,output_schema36280_36286,input_schema36281_36287,input_checker36282_36288,output_checker36283_36289){
return (function (k){if(schema.core.required_key_QMARK_.call(null,k))
{return schema.core.explicit_schema_key.call(null,k);
} else
{return null;
}
});})(validate__13961__auto__,ufv___36285,output_schema36280_36286,input_schema36281_36287,input_checker36282_36288,output_checker36283_36289))
,cljs.core.keys.call(null,input_schema));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36293 = output_checker36283_36289.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36293))
{var error__13963__auto___36294 = temp__4126__auto___36293;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),cljs.core.pr_str.call(null,error__13963__auto___36294)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36280_36286,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36294], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36285,output_schema36280_36286,input_schema36281_36287,input_checker36282_36288,output_checker36283_36289))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema36280_36286,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36281_36287], null)));
/**
* Guess an output schema for an expr.  Currently just looks for literal map structure and
* all keyword keys.
*/
plumbing.fnk.schema.guess_expr_output_schema = (function guess_expr_output_schema(expr){if((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr))))
{return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = (function iter__36303(s__36304){return (new cljs.core.LazySeq(null,(function (){var s__36304__$1 = s__36304;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36304__$1);if(temp__4126__auto__)
{var s__36304__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36304__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36304__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36306 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36305 = (0);while(true){
if((i__36305 < size__4265__auto__))
{var vec__36309 = cljs.core._nth.call(null,c__4264__auto__,i__36305);var k = cljs.core.nth.call(null,vec__36309,(0),null);var v = cljs.core.nth.call(null,vec__36309,(1),null);cljs.core.chunk_append.call(null,b__36306,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,guess_expr_output_schema.call(null,v)], null));
{
var G__36311 = (i__36305 + (1));
i__36305 = G__36311;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36306),iter__36303.call(null,cljs.core.chunk_rest.call(null,s__36304__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36306),null);
}
} else
{var vec__36310 = cljs.core.first.call(null,s__36304__$2);var k = cljs.core.nth.call(null,vec__36310,(0),null);var v = cljs.core.nth.call(null,vec__36310,(1),null);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,guess_expr_output_schema.call(null,v)], null),iter__36303.call(null,cljs.core.rest.call(null,s__36304__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,expr);
})());
} else
{return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
* Subtract output-schema from input-schema, returning nil if it's possible that an object
* satisfying the output-schema satisfies the input-schema, or otherwise a description
* of the part(s) of input-schema not met by output-schema.  Strict about the map structure
* of output-schema matching input-schema, but loose about everything else (only looks at
* required keys of output-schema.
*/
plumbing.fnk.schema.schema_diff = (function schema_diff(input_schema,output_schema){if(!(plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema)))
{return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else
{if(!(plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema)))
{return schema.utils.error.call(null,schema.utils.__GT_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,output_schema)),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
}),null)),null));
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = (function iter__36320(s__36321){return (new cljs.core.LazySeq(null,(function (){var s__36321__$1 = s__36321;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36321__$1);if(temp__4126__auto__)
{var s__36321__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36321__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36321__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36323 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36322 = (0);while(true){
if((i__36322 < size__4265__auto__))
{var vec__36326 = cljs.core._nth.call(null,c__4264__auto__,i__36322);var k = cljs.core.nth.call(null,vec__36326,(0),null);var v = cljs.core.nth.call(null,vec__36326,(1),null);if(schema.core.specific_key_QMARK_.call(null,k))
{var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);var raw_k = schema.core.explicit_schema_key.call(null,k);var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);if((required_QMARK_) || (present_QMARK_))
{var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));if(cljs.core.truth_(fail))
{cljs.core.chunk_append.call(null,b__36323,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));
{
var G__36328 = (i__36322 + (1));
i__36322 = G__36328;
continue;
}
} else
{{
var G__36329 = (i__36322 + (1));
i__36322 = G__36329;
continue;
}
}
} else
{{
var G__36330 = (i__36322 + (1));
i__36322 = G__36330;
continue;
}
}
} else
{{
var G__36331 = (i__36322 + (1));
i__36322 = G__36331;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36323),iter__36320.call(null,cljs.core.chunk_rest.call(null,s__36321__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36323),null);
}
} else
{var vec__36327 = cljs.core.first.call(null,s__36321__$2);var k = cljs.core.nth.call(null,vec__36327,(0),null);var v = cljs.core.nth.call(null,vec__36327,(1),null);if(schema.core.specific_key_QMARK_.call(null,k))
{var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);var raw_k = schema.core.explicit_schema_key.call(null,k);var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);if((required_QMARK_) || (present_QMARK_))
{var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));if(cljs.core.truth_(fail))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),iter__36320.call(null,cljs.core.rest.call(null,s__36321__$2)));
} else
{{
var G__36332 = cljs.core.rest.call(null,s__36321__$2);
s__36321__$1 = G__36332;
continue;
}
}
} else
{{
var G__36333 = cljs.core.rest.call(null,s__36321__$2);
s__36321__$1 = G__36333;
continue;
}
}
} else
{{
var G__36334 = cljs.core.rest.call(null,s__36321__$2);
s__36321__$1 = G__36334;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,input_schema);
})()));
} else
{return null;
}
}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function assert_satisfies_schema(input_schema,output_schema){var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);if(cljs.core.truth_(fails))
{throw cljs.core.ex_info.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(fails)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else
{return null;
}
});
var ufv___36357 = schema.utils.use_fn_validation;var output_schema36335_36358 = schema.core.Any;var input_schema36336_36359 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);var input_checker36337_36360 = schema.core.checker.call(null,input_schema36336_36359);var output_checker36338_36361 = schema.core.checker.call(null,output_schema36335_36358);/**
* Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
* 
* Given pairs of input and output schemata for fnks f1 and f2,
* return a pair of input and output schemata for #(f2 (merge % (f1 %))).
* f1's output schema must not contain any optional keys.
*/
plumbing.fnk.schema.compose_schemata = ((function (ufv___36357,output_schema36335_36358,input_schema36336_36359,input_checker36337_36360,output_checker36338_36361){
return (function compose_schemata(G__36339,G__36340){var validate__13961__auto__ = true;if(validate__13961__auto__)
{var args__13962__auto___36362 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36339,G__36340], null);var temp__4126__auto___36363 = input_checker36337_36360.call(null,args__13962__auto___36362);if(cljs.core.truth_(temp__4126__auto___36363))
{var error__13963__auto___36364 = temp__4126__auto___36363;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),cljs.core.pr_str.call(null,error__13963__auto___36364)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36336_36359,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36362,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36364], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__36351 = G__36339;var vec__36353 = G__36351;var i2 = cljs.core.nth.call(null,vec__36353,(0),null);var o2 = cljs.core.nth.call(null,vec__36353,(1),null);var G__36352 = G__36340;var vec__36354 = G__36352;var i1 = cljs.core.nth.call(null,vec__36354,(0),null);var o1 = cljs.core.nth.call(null,vec__36354,(1),null);var G__36351__$1 = G__36351;var G__36352__$1 = G__36352;while(true){
var vec__36355 = G__36351__$1;var i2__$1 = cljs.core.nth.call(null,vec__36355,(0),null);var o2__$1 = cljs.core.nth.call(null,vec__36355,(1),null);var vec__36356 = G__36352__$1;var i1__$1 = cljs.core.nth.call(null,vec__36356,(0),null);var o1__$1 = cljs.core.nth.call(null,vec__36356,(1),null);plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();if(validate__13961__auto__)
{var temp__4126__auto___36365 = output_checker36338_36361.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36365))
{var error__13963__auto___36366 = temp__4126__auto___36365;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),cljs.core.pr_str.call(null,error__13963__auto___36366)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36335_36358,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36366], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36357,output_schema36335_36358,input_schema36336_36359,input_checker36337_36360,output_checker36338_36361))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema36335_36358,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36336_36359], null)));
plumbing.fnk.schema.schema_key = (function schema_key(m,k){if(cljs.core.contains_QMARK_.call(null,m,k))
{return k;
} else
{if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k)))
{return schema.core.optional_key.call(null,k);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return null;
} else
{return null;
}
}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function possibly_contains_QMARK_(m,k){return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___36445 = schema.utils.use_fn_validation;var output_schema36367_36446 = schema.core.Any;var input_schema36368_36447 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"s","s",-948495851,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"ks","ks",-754231827,null))], null);var input_checker36369_36448 = schema.core.checker.call(null,input_schema36368_36447);var output_checker36370_36449 = schema.core.checker.call(null,output_schema36367_36446);/**
* Inputs: [s :- InputSchema ks :- [s/Keyword]]
* 
* Return a pair [ks-part non-ks-part], with any extra schema removed.
*/
plumbing.fnk.schema.split_schema = ((function (ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function split_schema(G__36371,G__36372){var validate__13961__auto__ = ufv___36445.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36450 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36371,G__36372], null);var temp__4126__auto___36451 = input_checker36369_36448.call(null,args__13962__auto___36450);if(cljs.core.truth_(temp__4126__auto___36451))
{var error__13963__auto___36452 = temp__4126__auto___36451;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),cljs.core.pr_str.call(null,error__13963__auto___36452)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36368_36447,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36450,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36452], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var s = G__36371;var ks = G__36372;while(true){
var ks__$1 = cljs.core.set.call(null,ks);var iter__4266__auto__ = ((function (ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function iter__36409(s__36410){return (new cljs.core.LazySeq(null,((function (ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function (){var s__36410__$1 = s__36410;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36410__$1);if(temp__4126__auto__)
{var s__36410__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36410__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36410__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36412 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36411 = (0);while(true){
if((i__36411 < size__4265__auto__))
{var in_QMARK_ = cljs.core._nth.call(null,c__4264__auto__,i__36411);cljs.core.chunk_append.call(null,b__36412,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = ((function (i__36411,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36412,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function iter__36429(s__36430){return (new cljs.core.LazySeq(null,((function (i__36411,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36412,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function (){var s__36430__$1 = s__36430;while(true){
var temp__4126__auto____$1 = cljs.core.seq.call(null,s__36430__$1);if(temp__4126__auto____$1)
{var s__36430__$2 = temp__4126__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__36430__$2))
{var c__4264__auto____$1 = cljs.core.chunk_first.call(null,s__36430__$2);var size__4265__auto____$1 = cljs.core.count.call(null,c__4264__auto____$1);var b__36432 = cljs.core.chunk_buffer.call(null,size__4265__auto____$1);if((function (){var i__36431 = (0);while(true){
if((i__36431 < size__4265__auto____$1))
{var vec__36435 = cljs.core._nth.call(null,c__4264__auto____$1,i__36431);var k = cljs.core.nth.call(null,vec__36435,(0),null);var v = cljs.core.nth.call(null,vec__36435,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{cljs.core.chunk_append.call(null,b__36432,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36453 = (i__36431 + (1));
i__36431 = G__36453;
continue;
}
} else
{{
var G__36454 = (i__36431 + (1));
i__36431 = G__36454;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36432),iter__36429.call(null,cljs.core.chunk_rest.call(null,s__36430__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36432),null);
}
} else
{var vec__36436 = cljs.core.first.call(null,s__36430__$2);var k = cljs.core.nth.call(null,vec__36436,(0),null);var v = cljs.core.nth.call(null,vec__36436,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36429.call(null,cljs.core.rest.call(null,s__36430__$2)));
} else
{{
var G__36455 = cljs.core.rest.call(null,s__36430__$2);
s__36430__$1 = G__36455;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(i__36411,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36412,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
,null,null));
});})(i__36411,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36412,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
;return iter__4266__auto__.call(null,s);
})()));
{
var G__36456 = (i__36411 + (1));
i__36411 = G__36456;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36412),iter__36409.call(null,cljs.core.chunk_rest.call(null,s__36410__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36412),null);
}
} else
{var in_QMARK_ = cljs.core.first.call(null,s__36410__$2);return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = ((function (in_QMARK_,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function iter__36437(s__36438){return (new cljs.core.LazySeq(null,((function (in_QMARK_,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449){
return (function (){var s__36438__$1 = s__36438;while(true){
var temp__4126__auto____$1 = cljs.core.seq.call(null,s__36438__$1);if(temp__4126__auto____$1)
{var s__36438__$2 = temp__4126__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__36438__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36438__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36440 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36439 = (0);while(true){
if((i__36439 < size__4265__auto__))
{var vec__36443 = cljs.core._nth.call(null,c__4264__auto__,i__36439);var k = cljs.core.nth.call(null,vec__36443,(0),null);var v = cljs.core.nth.call(null,vec__36443,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{cljs.core.chunk_append.call(null,b__36440,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36457 = (i__36439 + (1));
i__36439 = G__36457;
continue;
}
} else
{{
var G__36458 = (i__36439 + (1));
i__36439 = G__36458;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36440),iter__36437.call(null,cljs.core.chunk_rest.call(null,s__36438__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36440),null);
}
} else
{var vec__36444 = cljs.core.first.call(null,s__36438__$2);var k = cljs.core.nth.call(null,vec__36444,(0),null);var v = cljs.core.nth.call(null,vec__36444,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36437.call(null,cljs.core.rest.call(null,s__36438__$2)));
} else
{{
var G__36459 = cljs.core.rest.call(null,s__36438__$2);
s__36438__$1 = G__36459;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(in_QMARK_,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
,null,null));
});})(in_QMARK_,s__36410__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
;return iter__4266__auto__.call(null,s);
})()),iter__36409.call(null,cljs.core.rest.call(null,s__36410__$2)));
}
} else
{return null;
}
break;
}
});})(ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
,null,null));
});})(ks__$1,validate__13961__auto__,ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
;return iter__4266__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36460 = output_checker36370_36449.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36460))
{var error__13963__auto___36461 = temp__4126__auto___36460;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),cljs.core.pr_str.call(null,error__13963__auto___36461)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36367_36446,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36461], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36445,output_schema36367_36446,input_schema36368_36447,input_checker36369_36448,output_checker36370_36449))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema36367_36446,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36368_36447], null)));
var ufv___36492 = schema.utils.use_fn_validation;var output_schema36462_36493 = plumbing.fnk.schema.GraphIOSchemata;var input_schema36463_36494 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);var input_checker36464_36495 = schema.core.checker.call(null,input_schema36463_36494);var output_checker36465_36496 = schema.core.checker.call(null,output_schema36462_36493);/**
* Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
* Returns: GraphIOSchemata
* 
* Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
* return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
*/
plumbing.fnk.schema.sequence_schemata = ((function (ufv___36492,output_schema36462_36493,input_schema36463_36494,input_checker36464_36495,output_checker36465_36496){
return (function sequence_schemata(G__36466,G__36467){var validate__13961__auto__ = ufv___36492.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36497 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36466,G__36467], null);var temp__4126__auto___36498 = input_checker36464_36495.call(null,args__13962__auto___36497);if(cljs.core.truth_(temp__4126__auto___36498))
{var error__13963__auto___36499 = temp__4126__auto___36498;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),cljs.core.pr_str.call(null,error__13963__auto___36499)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36463_36494,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36497,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36499], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__36483 = G__36466;var vec__36485 = G__36483;var i1 = cljs.core.nth.call(null,vec__36485,(0),null);var o1 = cljs.core.nth.call(null,vec__36485,(1),null);var G__36484 = G__36467;var vec__36486 = G__36484;var k = cljs.core.nth.call(null,vec__36486,(0),null);var vec__36487 = cljs.core.nth.call(null,vec__36486,(1),null);var i2 = cljs.core.nth.call(null,vec__36487,(0),null);var o2 = cljs.core.nth.call(null,vec__36487,(1),null);var G__36483__$1 = G__36483;var G__36484__$1 = G__36484;while(true){
var vec__36488 = G__36483__$1;var i1__$1 = cljs.core.nth.call(null,vec__36488,(0),null);var o1__$1 = cljs.core.nth.call(null,vec__36488,(1),null);var vec__36489 = G__36484__$1;var k__$1 = cljs.core.nth.call(null,vec__36489,(0),null);var vec__36490 = cljs.core.nth.call(null,vec__36489,(1),null);var i2__$1 = cljs.core.nth.call(null,vec__36490,(0),null);var o2__$1 = cljs.core.nth.call(null,vec__36490,(1),null);if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}
if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}
if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}
var vec__36491 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));var used = cljs.core.nth.call(null,vec__36491,(0),null);var unused = cljs.core.nth.call(null,vec__36491,(1),null);plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36500 = output_checker36465_36496.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36500))
{var error__13963__auto___36501 = temp__4126__auto___36500;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),cljs.core.pr_str.call(null,error__13963__auto___36501)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36462_36493,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36501], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36492,output_schema36462_36493,input_schema36463_36494,input_checker36464_36495,output_checker36465_36496))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema36462_36493,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36463_36494], null)));

//# sourceMappingURL=schema.js.map