// Compiled by ClojureScript 0.0-2277
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('plumbing.fnk.schema');
goog.require('plumbing.fnk.schema');
goog.require('schema.utils');
goog.require('schema.utils');
/**
* A sentinel value representing missing portions of the input data.
*/
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
* Updates the value in map m at k with the function f.
* 
* Like update-in, but for updating a single top-level key.
* Any additional args will be passed to f after the value.
* @param {...*} var_args
*/
plumbing.core.update = (function() {
var update = null;
var update__3 = (function (m,k,f){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
});
var update__4 = (function (m,k,f,x1){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
});
var update__5 = (function (m,k,f,x1,x2){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
});
var update__6 = (function() { 
var G__36502__delegate = function (m,k,f,x1,x2,xs){return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
};
var G__36502 = function (m,k,f,x1,x2,var_args){
var xs = null;if (arguments.length > 5) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);} 
return G__36502__delegate.call(this,m,k,f,x1,x2,xs);};
G__36502.cljs$lang$maxFixedArity = 5;
G__36502.cljs$lang$applyTo = (function (arglist__36503){
var m = cljs.core.first(arglist__36503);
arglist__36503 = cljs.core.next(arglist__36503);
var k = cljs.core.first(arglist__36503);
arglist__36503 = cljs.core.next(arglist__36503);
var f = cljs.core.first(arglist__36503);
arglist__36503 = cljs.core.next(arglist__36503);
var x1 = cljs.core.first(arglist__36503);
arglist__36503 = cljs.core.next(arglist__36503);
var x2 = cljs.core.first(arglist__36503);
var xs = cljs.core.rest(arglist__36503);
return G__36502__delegate(m,k,f,x1,x2,xs);
});
G__36502.cljs$core$IFn$_invoke$arity$variadic = G__36502__delegate;
return G__36502;
})()
;
update = function(m,k,f,x1,x2,var_args){
var xs = var_args;
switch(arguments.length){
case 3:
return update__3.call(this,m,k,f);
case 4:
return update__4.call(this,m,k,f,x1);
case 5:
return update__5.call(this,m,k,f,x1,x2);
default:
return update__6.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x1,x2, cljs.core.array_seq(arguments, 5));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update.cljs$lang$maxFixedArity = 5;
update.cljs$lang$applyTo = update__6.cljs$lang$applyTo;
update.cljs$core$IFn$_invoke$arity$3 = update__3;
update.cljs$core$IFn$_invoke$arity$4 = update__4;
update.cljs$core$IFn$_invoke$arity$5 = update__5;
update.cljs$core$IFn$_invoke$arity$variadic = update__6.cljs$core$IFn$_invoke$arity$variadic;
return update;
})()
;
/**
* Build map k -> (f v) for [k v] in map, preserving the initial type
*/
plumbing.core.map_vals = (function map_vals(f,m){if(cljs.core.sorted_QMARK_.call(null,m))
{return cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else
{if(cljs.core.map_QMARK_.call(null,m))
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36512_36518 = cljs.core.seq.call(null,m);var chunk__36513_36519 = null;var count__36514_36520 = (0);var i__36515_36521 = (0);while(true){
if((i__36515_36521 < count__36514_36520))
{var vec__36516_36522 = cljs.core._nth.call(null,chunk__36513_36519,i__36515_36521);var k_36523 = cljs.core.nth.call(null,vec__36516_36522,(0),null);var v_36524 = cljs.core.nth.call(null,vec__36516_36522,(1),null);var m36511_36525 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36511_36525,k_36523,f.call(null,v_36524)));
{
var G__36526 = seq__36512_36518;
var G__36527 = chunk__36513_36519;
var G__36528 = count__36514_36520;
var G__36529 = (i__36515_36521 + (1));
seq__36512_36518 = G__36526;
chunk__36513_36519 = G__36527;
count__36514_36520 = G__36528;
i__36515_36521 = G__36529;
continue;
}
} else
{var temp__4126__auto___36530 = cljs.core.seq.call(null,seq__36512_36518);if(temp__4126__auto___36530)
{var seq__36512_36531__$1 = temp__4126__auto___36530;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36512_36531__$1))
{var c__4297__auto___36532 = cljs.core.chunk_first.call(null,seq__36512_36531__$1);{
var G__36533 = cljs.core.chunk_rest.call(null,seq__36512_36531__$1);
var G__36534 = c__4297__auto___36532;
var G__36535 = cljs.core.count.call(null,c__4297__auto___36532);
var G__36536 = (0);
seq__36512_36518 = G__36533;
chunk__36513_36519 = G__36534;
count__36514_36520 = G__36535;
i__36515_36521 = G__36536;
continue;
}
} else
{var vec__36517_36537 = cljs.core.first.call(null,seq__36512_36531__$1);var k_36538 = cljs.core.nth.call(null,vec__36517_36537,(0),null);var v_36539 = cljs.core.nth.call(null,vec__36517_36537,(1),null);var m36511_36540 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36511_36540,k_36538,f.call(null,v_36539)));
{
var G__36541 = cljs.core.next.call(null,seq__36512_36531__$1);
var G__36542 = null;
var G__36543 = (0);
var G__36544 = (0);
seq__36512_36518 = G__36541;
chunk__36513_36519 = G__36542;
count__36514_36520 = G__36543;
i__36515_36521 = G__36544;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
} else
{return null;
}
}
}
});
/**
* Build map (f k) -> v for [k v] in map m
*/
plumbing.core.map_keys = (function map_keys(f,m){if(cljs.core.map_QMARK_.call(null,m))
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else
{var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36553_36559 = cljs.core.seq.call(null,m);var chunk__36554_36560 = null;var count__36555_36561 = (0);var i__36556_36562 = (0);while(true){
if((i__36556_36562 < count__36555_36561))
{var vec__36557_36563 = cljs.core._nth.call(null,chunk__36554_36560,i__36556_36562);var k_36564 = cljs.core.nth.call(null,vec__36557_36563,(0),null);var v_36565 = cljs.core.nth.call(null,vec__36557_36563,(1),null);var m36552_36566 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36552_36566,f.call(null,k_36564),v_36565));
{
var G__36567 = seq__36553_36559;
var G__36568 = chunk__36554_36560;
var G__36569 = count__36555_36561;
var G__36570 = (i__36556_36562 + (1));
seq__36553_36559 = G__36567;
chunk__36554_36560 = G__36568;
count__36555_36561 = G__36569;
i__36556_36562 = G__36570;
continue;
}
} else
{var temp__4126__auto___36571 = cljs.core.seq.call(null,seq__36553_36559);if(temp__4126__auto___36571)
{var seq__36553_36572__$1 = temp__4126__auto___36571;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36553_36572__$1))
{var c__4297__auto___36573 = cljs.core.chunk_first.call(null,seq__36553_36572__$1);{
var G__36574 = cljs.core.chunk_rest.call(null,seq__36553_36572__$1);
var G__36575 = c__4297__auto___36573;
var G__36576 = cljs.core.count.call(null,c__4297__auto___36573);
var G__36577 = (0);
seq__36553_36559 = G__36574;
chunk__36554_36560 = G__36575;
count__36555_36561 = G__36576;
i__36556_36562 = G__36577;
continue;
}
} else
{var vec__36558_36578 = cljs.core.first.call(null,seq__36553_36572__$1);var k_36579 = cljs.core.nth.call(null,vec__36558_36578,(0),null);var v_36580 = cljs.core.nth.call(null,vec__36558_36578,(1),null);var m36552_36581 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36552_36581,f.call(null,k_36579),v_36580));
{
var G__36582 = cljs.core.next.call(null,seq__36553_36572__$1);
var G__36583 = null;
var G__36584 = (0);
var G__36585 = (0);
seq__36553_36559 = G__36582;
chunk__36554_36560 = G__36583;
count__36555_36561 = G__36584;
i__36556_36562 = G__36585;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
}
});
/**
* Build map k -> (f k) for keys in ks
*/
plumbing.core.map_from_keys = (function map_from_keys(f,ks){var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36592_36596 = cljs.core.seq.call(null,ks);var chunk__36593_36597 = null;var count__36594_36598 = (0);var i__36595_36599 = (0);while(true){
if((i__36595_36599 < count__36594_36598))
{var k_36600 = cljs.core._nth.call(null,chunk__36593_36597,i__36595_36599);var m36591_36601 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36591_36601,k_36600,f.call(null,k_36600)));
{
var G__36602 = seq__36592_36596;
var G__36603 = chunk__36593_36597;
var G__36604 = count__36594_36598;
var G__36605 = (i__36595_36599 + (1));
seq__36592_36596 = G__36602;
chunk__36593_36597 = G__36603;
count__36594_36598 = G__36604;
i__36595_36599 = G__36605;
continue;
}
} else
{var temp__4126__auto___36606 = cljs.core.seq.call(null,seq__36592_36596);if(temp__4126__auto___36606)
{var seq__36592_36607__$1 = temp__4126__auto___36606;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36592_36607__$1))
{var c__4297__auto___36608 = cljs.core.chunk_first.call(null,seq__36592_36607__$1);{
var G__36609 = cljs.core.chunk_rest.call(null,seq__36592_36607__$1);
var G__36610 = c__4297__auto___36608;
var G__36611 = cljs.core.count.call(null,c__4297__auto___36608);
var G__36612 = (0);
seq__36592_36596 = G__36609;
chunk__36593_36597 = G__36610;
count__36594_36598 = G__36611;
i__36595_36599 = G__36612;
continue;
}
} else
{var k_36613 = cljs.core.first.call(null,seq__36592_36607__$1);var m36591_36614 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36591_36614,k_36613,f.call(null,k_36613)));
{
var G__36615 = cljs.core.next.call(null,seq__36592_36607__$1);
var G__36616 = null;
var G__36617 = (0);
var G__36618 = (0);
seq__36592_36596 = G__36615;
chunk__36593_36597 = G__36616;
count__36594_36598 = G__36617;
i__36595_36599 = G__36618;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
});
/**
* Build map (f v) -> v for vals in vs
*/
plumbing.core.map_from_vals = (function map_from_vals(f,vs){var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36625_36629 = cljs.core.seq.call(null,vs);var chunk__36626_36630 = null;var count__36627_36631 = (0);var i__36628_36632 = (0);while(true){
if((i__36628_36632 < count__36627_36631))
{var v_36633 = cljs.core._nth.call(null,chunk__36626_36630,i__36628_36632);var m36624_36634 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36624_36634,f.call(null,v_36633),v_36633));
{
var G__36635 = seq__36625_36629;
var G__36636 = chunk__36626_36630;
var G__36637 = count__36627_36631;
var G__36638 = (i__36628_36632 + (1));
seq__36625_36629 = G__36635;
chunk__36626_36630 = G__36636;
count__36627_36631 = G__36637;
i__36628_36632 = G__36638;
continue;
}
} else
{var temp__4126__auto___36639 = cljs.core.seq.call(null,seq__36625_36629);if(temp__4126__auto___36639)
{var seq__36625_36640__$1 = temp__4126__auto___36639;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36625_36640__$1))
{var c__4297__auto___36641 = cljs.core.chunk_first.call(null,seq__36625_36640__$1);{
var G__36642 = cljs.core.chunk_rest.call(null,seq__36625_36640__$1);
var G__36643 = c__4297__auto___36641;
var G__36644 = cljs.core.count.call(null,c__4297__auto___36641);
var G__36645 = (0);
seq__36625_36629 = G__36642;
chunk__36626_36630 = G__36643;
count__36627_36631 = G__36644;
i__36628_36632 = G__36645;
continue;
}
} else
{var v_36646 = cljs.core.first.call(null,seq__36625_36640__$1);var m36624_36647 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36624_36647,f.call(null,v_36646),v_36646));
{
var G__36648 = cljs.core.next.call(null,seq__36625_36640__$1);
var G__36649 = null;
var G__36650 = (0);
var G__36651 = (0);
seq__36625_36629 = G__36648;
chunk__36626_36630 = G__36649;
count__36627_36631 = G__36650;
i__36628_36632 = G__36651;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
});
/**
* Dissociate this keyseq from m, removing any empty maps created as a result
* (including at the top-level).
*/
plumbing.core.dissoc_in = (function dissoc_in(m,p__36652){var vec__36654 = p__36652;var k = cljs.core.nth.call(null,vec__36654,(0),null);var ks = cljs.core.nthnext.call(null,vec__36654,(1));if(cljs.core.truth_(m))
{var temp__4124__auto__ = (function (){var and__3529__auto__ = ks;if(and__3529__auto__)
{return dissoc_in.call(null,m.call(null,k),ks);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4124__auto__))
{var res = temp__4124__auto__;return cljs.core.assoc.call(null,m,k,res);
} else
{var res = cljs.core.dissoc.call(null,m,k);if(cljs.core.empty_QMARK_.call(null,res))
{return null;
} else
{return res;
}
}
} else
{return null;
}
});
/**
* Recursively convert maps in m (including itself)
* to have keyword keys instead of string
*/
plumbing.core.keywordize_map = (function keywordize_map(x){if(cljs.core.map_QMARK_.call(null,x))
{var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36663_36669 = cljs.core.seq.call(null,x);var chunk__36664_36670 = null;var count__36665_36671 = (0);var i__36666_36672 = (0);while(true){
if((i__36666_36672 < count__36665_36671))
{var vec__36667_36673 = cljs.core._nth.call(null,chunk__36664_36670,i__36666_36672);var k_36674 = cljs.core.nth.call(null,vec__36667_36673,(0),null);var v_36675 = cljs.core.nth.call(null,vec__36667_36673,(1),null);var m36662_36676 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36662_36676,((typeof k_36674 === 'string')?cljs.core.keyword.call(null,k_36674):k_36674),keywordize_map.call(null,v_36675)));
{
var G__36677 = seq__36663_36669;
var G__36678 = chunk__36664_36670;
var G__36679 = count__36665_36671;
var G__36680 = (i__36666_36672 + (1));
seq__36663_36669 = G__36677;
chunk__36664_36670 = G__36678;
count__36665_36671 = G__36679;
i__36666_36672 = G__36680;
continue;
}
} else
{var temp__4126__auto___36681 = cljs.core.seq.call(null,seq__36663_36669);if(temp__4126__auto___36681)
{var seq__36663_36682__$1 = temp__4126__auto___36681;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36663_36682__$1))
{var c__4297__auto___36683 = cljs.core.chunk_first.call(null,seq__36663_36682__$1);{
var G__36684 = cljs.core.chunk_rest.call(null,seq__36663_36682__$1);
var G__36685 = c__4297__auto___36683;
var G__36686 = cljs.core.count.call(null,c__4297__auto___36683);
var G__36687 = (0);
seq__36663_36669 = G__36684;
chunk__36664_36670 = G__36685;
count__36665_36671 = G__36686;
i__36666_36672 = G__36687;
continue;
}
} else
{var vec__36668_36688 = cljs.core.first.call(null,seq__36663_36682__$1);var k_36689 = cljs.core.nth.call(null,vec__36668_36688,(0),null);var v_36690 = cljs.core.nth.call(null,vec__36668_36688,(1),null);var m36662_36691 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36662_36691,((typeof k_36689 === 'string')?cljs.core.keyword.call(null,k_36689):k_36689),keywordize_map.call(null,v_36690)));
{
var G__36692 = cljs.core.next.call(null,seq__36663_36682__$1);
var G__36693 = null;
var G__36694 = (0);
var G__36695 = (0);
seq__36663_36669 = G__36692;
chunk__36664_36670 = G__36693;
count__36665_36671 = G__36694;
i__36666_36672 = G__36695;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
} else
{if(cljs.core.seq_QMARK_.call(null,x))
{return cljs.core.map.call(null,keywordize_map,x);
} else
{if(cljs.core.vector_QMARK_.call(null,x))
{return cljs.core.mapv.call(null,keywordize_map,x);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return x;
} else
{return null;
}
}
}
}
});
/**
* Like get but throw an exception if not found
*/
plumbing.core.safe_get = (function safe_get(m,k){var temp__4124__auto__ = cljs.core.find.call(null,m,k);if(cljs.core.truth_(temp__4124__auto__))
{var pair__16291__auto__ = temp__4124__auto__;return cljs.core.val.call(null,pair__16291__auto__);
} else
{var e = schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m));throw (new Error(e));
}
});
/**
* Like get-in but throws exception if not found
*/
plumbing.core.safe_get_in = (function safe_get_in(m,ks){while(true){
if(cljs.core.seq.call(null,ks))
{{
var G__36696 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__36697 = cljs.core.next.call(null,ks);
m = G__36696;
ks = G__36697;
continue;
}
} else
{return m;
}
break;
}
});
/**
* Like assoc but only assocs when value is truthy
* @param {...*} var_args
*/
plumbing.core.assoc_when = (function() { 
var assoc_when__delegate = function (m,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
return cljs.core.into.call(null,(function (){var or__3541__auto__ = m;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__4266__auto__ = (function iter__36706(s__36707){return (new cljs.core.LazySeq(null,(function (){var s__36707__$1 = s__36707;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36707__$1);if(temp__4126__auto__)
{var s__36707__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36707__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36707__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36709 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36708 = (0);while(true){
if((i__36708 < size__4265__auto__))
{var vec__36712 = cljs.core._nth.call(null,c__4264__auto__,i__36708);var k = cljs.core.nth.call(null,vec__36712,(0),null);var v = cljs.core.nth.call(null,vec__36712,(1),null);if(cljs.core.truth_(v))
{cljs.core.chunk_append.call(null,b__36709,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36714 = (i__36708 + (1));
i__36708 = G__36714;
continue;
}
} else
{{
var G__36715 = (i__36708 + (1));
i__36708 = G__36715;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36709),iter__36706.call(null,cljs.core.chunk_rest.call(null,s__36707__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36709),null);
}
} else
{var vec__36713 = cljs.core.first.call(null,s__36707__$2);var k = cljs.core.nth.call(null,vec__36713,(0),null);var v = cljs.core.nth.call(null,vec__36713,(1),null);if(cljs.core.truth_(v))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36706.call(null,cljs.core.rest.call(null,s__36707__$2)));
} else
{{
var G__36716 = cljs.core.rest.call(null,s__36707__$2);
s__36707__$1 = G__36716;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
};
var assoc_when = function (m,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return assoc_when__delegate.call(this,m,kvs);};
assoc_when.cljs$lang$maxFixedArity = 1;
assoc_when.cljs$lang$applyTo = (function (arglist__36717){
var m = cljs.core.first(arglist__36717);
var kvs = cljs.core.rest(arglist__36717);
return assoc_when__delegate(m,kvs);
});
assoc_when.cljs$core$IFn$_invoke$arity$variadic = assoc_when__delegate;
return assoc_when;
})()
;
/**
* Like update-in but returns m unchanged if key-seq is not present.
* @param {...*} var_args
*/
plumbing.core.update_in_when = (function() { 
var update_in_when__delegate = function (m,key_seq,f,args){var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);if(!((plumbing.core._PLUS_none_PLUS_ === found)))
{return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else
{return m;
}
};
var update_in_when = function (m,key_seq,f,var_args){
var args = null;if (arguments.length > 3) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return update_in_when__delegate.call(this,m,key_seq,f,args);};
update_in_when.cljs$lang$maxFixedArity = 3;
update_in_when.cljs$lang$applyTo = (function (arglist__36718){
var m = cljs.core.first(arglist__36718);
arglist__36718 = cljs.core.next(arglist__36718);
var key_seq = cljs.core.first(arglist__36718);
arglist__36718 = cljs.core.next(arglist__36718);
var f = cljs.core.first(arglist__36718);
var args = cljs.core.rest(arglist__36718);
return update_in_when__delegate(m,key_seq,f,args);
});
update_in_when.cljs$core$IFn$_invoke$arity$variadic = update_in_when__delegate;
return update_in_when;
})()
;
/**
* Like group-by, but accepts a map-fn that is applied to values before
* collected.
*/
plumbing.core.grouped_map = (function grouped_map(key_fn,map_fn,coll){return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){var k = key_fn.call(null,x);return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Like (apply concat s) but lazier (and shorter)
*/
plumbing.core.aconcat = (function aconcat(s){return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){var temp__4126__auto__ = cljs.core.next.call(null,s);if(temp__4126__auto__)
{var n = temp__4126__auto__;return aconcat.call(null,n);
} else
{return null;
}
}),null,null)));
});
/**
* Takes a seqable and returns a lazy sequence that
* is maximally lazy and doesn't realize elements due to either
* chunking or apply.
* 
* Useful when you don't want chunking, for instance,
* (first awesome-website? (map slurp +a-bunch-of-urls+))
* may slurp up to 31 unneed webpages, wherease
* (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
* is guaranteed to stop slurping after the first awesome website.
* 
* Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
*/
plumbing.core.unchunk = (function unchunk(s){if(cljs.core.seq.call(null,s))
{return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){return unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else
{return null;
}
});
/**
* Return sum of (f x) for each x in xs
*/
plumbing.core.sum = (function() {
var sum = null;
var sum__1 = (function (xs){return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
});
var sum__2 = (function (f,xs){return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
});
sum = function(f,xs){
switch(arguments.length){
case 1:
return sum__1.call(this,f);
case 2:
return sum__2.call(this,f,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sum.cljs$core$IFn$_invoke$arity$1 = sum__1;
sum.cljs$core$IFn$_invoke$arity$2 = sum__2;
return sum;
})()
;
/**
* returns (first xs) when xs has only 1 element
*/
plumbing.core.singleton = (function singleton(xs){var temp__4126__auto__ = cljs.core.seq.call(null,xs);if(temp__4126__auto__)
{var xs__$1 = temp__4126__auto__;if(cljs.core.next.call(null,xs__$1))
{return null;
} else
{return cljs.core.first.call(null,xs__$1);
}
} else
{return null;
}
});
/**
* Returns [idx x] for x in seqable s
*/
plumbing.core.indexed = (function indexed(s){return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
* Returns indices idx of sequence s where (f (nth s idx))
*/
plumbing.core.positions = (function positions(f,s){return cljs.core.keep_indexed.call(null,(function (i,x){if(cljs.core.truth_(f.call(null,x)))
{return i;
} else
{return null;
}
}),s);
});
/**
* Returns elements of xs which return unique
* values according to f. If multiple elements of xs return the same
* value under f, the first is returned
*/
plumbing.core.distinct_by = (function distinct_by(f,xs){var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);var iter__4266__auto__ = ((function (s){
return (function iter__36723(s__36724){return (new cljs.core.LazySeq(null,((function (s){
return (function (){var s__36724__$1 = s__36724;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36724__$1);if(temp__4126__auto__)
{var s__36724__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36724__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36724__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36726 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36725 = (0);while(true){
if((i__36725 < size__4265__auto__))
{var x = cljs.core._nth.call(null,c__4264__auto__,i__36725);var id = f.call(null,x);if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))
{cljs.core.chunk_append.call(null,b__36726,(function (){cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);
return x;
})());
{
var G__36727 = (i__36725 + (1));
i__36725 = G__36727;
continue;
}
} else
{{
var G__36728 = (i__36725 + (1));
i__36725 = G__36728;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36726),iter__36723.call(null,cljs.core.chunk_rest.call(null,s__36724__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36726),null);
}
} else
{var x = cljs.core.first.call(null,s__36724__$2);var id = f.call(null,x);if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))
{return cljs.core.cons.call(null,(function (){cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);
return x;
})(),iter__36723.call(null,cljs.core.rest.call(null,s__36724__$2)));
} else
{{
var G__36729 = cljs.core.rest.call(null,s__36724__$2);
s__36724__$1 = G__36729;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(s))
,null,null));
});})(s))
;return iter__4266__auto__.call(null,xs);
});
/**
* Analogy: partition:partition-all :: interleave:interleave-all
* @param {...*} var_args
*/
plumbing.core.interleave_all = (function() { 
var interleave_all__delegate = function (colls){return (new cljs.core.LazySeq(null,(function (){return (function helper(seqs){if(cljs.core.seq.call(null,seqs))
{return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){return helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else
{return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
};
var interleave_all = function (var_args){
var colls = null;if (arguments.length > 0) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return interleave_all__delegate.call(this,colls);};
interleave_all.cljs$lang$maxFixedArity = 0;
interleave_all.cljs$lang$applyTo = (function (arglist__36730){
var colls = cljs.core.seq(arglist__36730);
return interleave_all__delegate(colls);
});
interleave_all.cljs$core$IFn$_invoke$arity$variadic = interleave_all__delegate;
return interleave_all;
})()
;
/**
* Returns # of elements of xs where pred holds
*/
plumbing.core.count_when = (function count_when(pred,xs){return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
* Like conj but ignores non-truthy values
* @param {...*} var_args
*/
plumbing.core.conj_when = (function() {
var conj_when = null;
var conj_when__2 = (function (coll,x){if(cljs.core.truth_(x))
{return cljs.core.conj.call(null,coll,x);
} else
{return coll;
}
});
var conj_when__3 = (function() { 
var G__36731__delegate = function (coll,x,xs){while(true){
if(cljs.core.truth_(xs))
{{
var G__36732 = conj_when.call(null,coll,x);
var G__36733 = cljs.core.first.call(null,xs);
var G__36734 = cljs.core.next.call(null,xs);
coll = G__36732;
x = G__36733;
xs = G__36734;
continue;
}
} else
{return conj_when.call(null,coll,x);
}
break;
}
};
var G__36731 = function (coll,x,var_args){
var xs = null;if (arguments.length > 2) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36731__delegate.call(this,coll,x,xs);};
G__36731.cljs$lang$maxFixedArity = 2;
G__36731.cljs$lang$applyTo = (function (arglist__36735){
var coll = cljs.core.first(arglist__36735);
arglist__36735 = cljs.core.next(arglist__36735);
var x = cljs.core.first(arglist__36735);
var xs = cljs.core.rest(arglist__36735);
return G__36731__delegate(coll,x,xs);
});
G__36731.cljs$core$IFn$_invoke$arity$variadic = G__36731__delegate;
return G__36731;
})()
;
conj_when = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 2:
return conj_when__2.call(this,coll,x);
default:
return conj_when__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj_when.cljs$lang$maxFixedArity = 2;
conj_when.cljs$lang$applyTo = conj_when__3.cljs$lang$applyTo;
conj_when.cljs$core$IFn$_invoke$arity$2 = conj_when__2;
conj_when.cljs$core$IFn$_invoke$arity$variadic = conj_when__3.cljs$core$IFn$_invoke$arity$variadic;
return conj_when;
})()
;
/**
* Like cons but does nothing if x is non-truthy.
*/
plumbing.core.cons_when = (function cons_when(x,s){if(cljs.core.truth_(x))
{return cljs.core.cons.call(null,x,s);
} else
{return s;
}
});
/**
* Like sort-by, but prefers higher values rather than lower ones.
*/
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
* Like swap! but returns a pair [old-val new-val]
* @param {...*} var_args
*/
plumbing.core.swap_pair_BANG_ = (function() {
var swap_pair_BANG_ = null;
var swap_pair_BANG___2 = (function (a,f){while(true){
var old_val = cljs.core.deref.call(null,a);var new_val = f.call(null,old_val);if(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else
{{
continue;
}
}
break;
}
});
var swap_pair_BANG___3 = (function() { 
var G__36737__delegate = function (a,f,args){return swap_pair_BANG_.call(null,a,(function (p1__36736_SHARP_){return cljs.core.apply.call(null,f,p1__36736_SHARP_,args);
}));
};
var G__36737 = function (a,f,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36737__delegate.call(this,a,f,args);};
G__36737.cljs$lang$maxFixedArity = 2;
G__36737.cljs$lang$applyTo = (function (arglist__36738){
var a = cljs.core.first(arglist__36738);
arglist__36738 = cljs.core.next(arglist__36738);
var f = cljs.core.first(arglist__36738);
var args = cljs.core.rest(arglist__36738);
return G__36737__delegate(a,f,args);
});
G__36737.cljs$core$IFn$_invoke$arity$variadic = G__36737__delegate;
return G__36737;
})()
;
swap_pair_BANG_ = function(a,f,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return swap_pair_BANG___2.call(this,a,f);
default:
return swap_pair_BANG___3.cljs$core$IFn$_invoke$arity$variadic(a,f, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
swap_pair_BANG_.cljs$lang$maxFixedArity = 2;
swap_pair_BANG_.cljs$lang$applyTo = swap_pair_BANG___3.cljs$lang$applyTo;
swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = swap_pair_BANG___2;
swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_pair_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return swap_pair_BANG_;
})()
;
/**
* Like reset! but returns old-val
*/
plumbing.core.get_and_set_BANG_ = (function get_and_set_BANG_(a,new_val){return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function millis(){return (new Date()).getTime();
});
/**
* Like apply, but applies a map to a function with positional map
* arguments. Can take optional initial args just like apply.
* @param {...*} var_args
*/
plumbing.core.mapply = (function() {
var mapply = null;
var mapply__2 = (function (f,m){return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
});
var mapply__3 = (function() { 
var G__36739__delegate = function (f,arg,args){return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
};
var G__36739 = function (f,arg,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36739__delegate.call(this,f,arg,args);};
G__36739.cljs$lang$maxFixedArity = 2;
G__36739.cljs$lang$applyTo = (function (arglist__36740){
var f = cljs.core.first(arglist__36740);
arglist__36740 = cljs.core.next(arglist__36740);
var arg = cljs.core.first(arglist__36740);
var args = cljs.core.rest(arglist__36740);
return G__36739__delegate(f,arg,args);
});
G__36739.cljs$core$IFn$_invoke$arity$variadic = G__36739__delegate;
return G__36739;
})()
;
mapply = function(f,arg,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return mapply__2.call(this,f,arg);
default:
return mapply__3.cljs$core$IFn$_invoke$arity$variadic(f,arg, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapply.cljs$lang$maxFixedArity = 2;
mapply.cljs$lang$applyTo = mapply__3.cljs$lang$applyTo;
mapply.cljs$core$IFn$_invoke$arity$2 = mapply__2;
mapply.cljs$core$IFn$_invoke$arity$variadic = mapply__3.cljs$core$IFn$_invoke$arity$variadic;
return mapply;
})()
;

//# sourceMappingURL=core.js.map