// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.util');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.core');
goog.require('om.core');
goog.require('om.core');
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping(s)
* from the latter (left-to-right) will be combined with the mapping in
* the result by looking up the proper merge function and in the
* supplied map of key -> merge-fn and using that for the big merge. If
* a key doesn't have a merge function, the right value wins (as with
* merge).
*/
om_bootstrap.util.merge_with_fns = (function merge_with_fns(k__GT_fn,maps){var merge_entry = (function merge_entry(m,e){var k = cljs.core.key.call(null,e);var v = cljs.core.val.call(null,e);var temp__4124__auto__ = (function (){var and__3529__auto__ = cljs.core.contains_QMARK_.call(null,m,k);if(and__3529__auto__)
{return k__GT_fn.call(null,k);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4124__auto__))
{var f = temp__4124__auto__;return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),v));
} else
{return cljs.core.assoc.call(null,m,k,v);
}
});
var merge = (function merge(m1,m2){return cljs.core.reduce.call(null,merge_entry,(function (){var or__3541__auto__ = m1;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq.call(null,m2));
});
return cljs.core.reduce.call(null,merge,cljs.core.PersistentArrayMap.EMPTY,maps);
});
var ufv___36071 = schema.utils.use_fn_validation;var output_schema36066_36072 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null);var input_schema36067_36073 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"x","x",-555367584,null))], null);var input_checker36068_36074 = schema.core.checker.call(null,input_schema36067_36073);var output_checker36069_36075 = schema.core.checker.call(null,output_schema36066_36072);/**
* Inputs: [x :- s/Any]
* Returns: [s/Any]
*/
om_bootstrap.util.collectify = ((function (ufv___36071,output_schema36066_36072,input_schema36067_36073,input_checker36068_36074,output_checker36069_36075){
return (function collectify(G__36070){var validate__13961__auto__ = ufv___36071.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36076 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36070], null);var temp__4126__auto___36077 = input_checker36068_36074.call(null,args__13962__auto___36076);if(cljs.core.truth_(temp__4126__auto___36077))
{var error__13963__auto___36078 = temp__4126__auto___36077;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"collectify","collectify",-1779603030,null),cljs.core.pr_str.call(null,error__13963__auto___36078)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36067_36073,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36076,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36078], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var x = G__36070;while(true){
if(cljs.core.sequential_QMARK_.call(null,x))
{return x;
} else
{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36079 = output_checker36069_36075.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36079))
{var error__13963__auto___36080 = temp__4126__auto___36079;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"collectify","collectify",-1779603030,null),cljs.core.pr_str.call(null,error__13963__auto___36080)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36066_36072,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36080], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36071,output_schema36066_36072,input_schema36067_36073,input_checker36068_36074,output_checker36069_36075))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.collectify),schema.core.make_fn_schema.call(null,output_schema36066_36072,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36067_36073], null)));
var ufv___36086 = schema.utils.use_fn_validation;var output_schema36081_36087 = schema.core.Bool;var input_schema36082_36088 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker36083_36089 = schema.core.checker.call(null,input_schema36082_36088);var output_checker36084_36090 = schema.core.checker.call(null,output_schema36081_36087);/**
* Inputs: [child]
* Returns: s/Bool
* 
* TODO: Once Om updates its externs to include this file, we can
* remove the janky aget call.
*/
om_bootstrap.util.strict_valid_component_QMARK_ = ((function (ufv___36086,output_schema36081_36087,input_schema36082_36088,input_checker36083_36089,output_checker36084_36090){
return (function strict_valid_component_QMARK_(G__36085){var validate__13961__auto__ = ufv___36086.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36091 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36085], null);var temp__4126__auto___36092 = input_checker36083_36089.call(null,args__13962__auto___36091);if(cljs.core.truth_(temp__4126__auto___36092))
{var error__13963__auto___36093 = temp__4126__auto___36092;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"strict-valid-component?","strict-valid-component?",130165335,null),cljs.core.pr_str.call(null,error__13963__auto___36093)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36082_36088,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36091,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36093], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var child = G__36085;while(true){
return (React["isValidComponent"]).call(null,child);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36094 = output_checker36084_36090.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36094))
{var error__13963__auto___36095 = temp__4126__auto___36094;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"strict-valid-component?","strict-valid-component?",130165335,null),cljs.core.pr_str.call(null,error__13963__auto___36095)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36081_36087,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36095], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36086,output_schema36081_36087,input_schema36082_36088,input_checker36083_36089,output_checker36084_36090))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.strict_valid_component_QMARK_),schema.core.make_fn_schema.call(null,output_schema36081_36087,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36082_36088], null)));
var ufv___36101 = schema.utils.use_fn_validation;var output_schema36096_36102 = schema.core.Bool;var input_schema36097_36103 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker36098_36104 = schema.core.checker.call(null,input_schema36097_36103);var output_checker36099_36105 = schema.core.checker.call(null,output_schema36096_36102);/**
* Inputs: [child]
* Returns: s/Bool
* 
* Returns true if the supplied argument is a valid React component,
* false otherwise.
*/
om_bootstrap.util.valid_component_QMARK_ = ((function (ufv___36101,output_schema36096_36102,input_schema36097_36103,input_checker36098_36104,output_checker36099_36105){
return (function valid_component_QMARK_(G__36100){var validate__13961__auto__ = ufv___36101.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36106 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36100], null);var temp__4126__auto___36107 = input_checker36098_36104.call(null,args__13962__auto___36106);if(cljs.core.truth_(temp__4126__auto___36107))
{var error__13963__auto___36108 = temp__4126__auto___36107;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"valid-component?","valid-component?",-519675438,null),cljs.core.pr_str.call(null,error__13963__auto___36108)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36097_36103,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36106,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36108], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var child = G__36100;while(true){
var or__3541__auto__ = typeof child === 'string';if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = typeof child === 'number';if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{return om_bootstrap.util.strict_valid_component_QMARK_.call(null,child);
}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36109 = output_checker36099_36105.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36109))
{var error__13963__auto___36110 = temp__4126__auto___36109;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"valid-component?","valid-component?",-519675438,null),cljs.core.pr_str.call(null,error__13963__auto___36110)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36096_36102,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36110], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36101,output_schema36096_36102,input_schema36097_36103,input_checker36098_36104,output_checker36099_36105))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.valid_component_QMARK_),schema.core.make_fn_schema.call(null,output_schema36096_36102,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36097_36103], null)));
var ufv___36116 = schema.utils.use_fn_validation;var output_schema36111_36117 = schema.core.Bool;var input_schema36112_36118 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker36113_36119 = schema.core.checker.call(null,input_schema36112_36118);var output_checker36114_36120 = schema.core.checker.call(null,output_schema36111_36117);/**
* Inputs: [children]
* Returns: s/Bool
* 
* Returns true if the supplied sequence contains some valid React component,
* false otherwise.
*/
om_bootstrap.util.some_valid_component_QMARK_ = ((function (ufv___36116,output_schema36111_36117,input_schema36112_36118,input_checker36113_36119,output_checker36114_36120){
return (function some_valid_component_QMARK_(G__36115){var validate__13961__auto__ = ufv___36116.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36121 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36115], null);var temp__4126__auto___36122 = input_checker36113_36119.call(null,args__13962__auto___36121);if(cljs.core.truth_(temp__4126__auto___36122))
{var error__13963__auto___36123 = temp__4126__auto___36122;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"some-valid-component?","some-valid-component?",-171767082,null),cljs.core.pr_str.call(null,error__13963__auto___36123)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36112_36118,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36121,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36123], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var children = G__36115;while(true){
return cljs.core.boolean$.call(null,cljs.core.some.call(null,om_bootstrap.util.valid_component_QMARK_,children));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36124 = output_checker36114_36120.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36124))
{var error__13963__auto___36125 = temp__4126__auto___36124;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"some-valid-component?","some-valid-component?",-171767082,null),cljs.core.pr_str.call(null,error__13963__auto___36125)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36111_36117,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36125], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36116,output_schema36111_36117,input_schema36112_36118,input_checker36113_36119,output_checker36114_36120))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.util.some_valid_component_QMARK_),schema.core.make_fn_schema.call(null,output_schema36111_36117,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36112_36118], null)));
/**
* Generates a new function that calls each supplied side-effecting
* function.
*/
om_bootstrap.util.chain_fns = (function chain_fns(l,r){if(cljs.core.truth_((function (){var and__3529__auto__ = l;if(cljs.core.truth_(and__3529__auto__))
{return r;
} else
{return and__3529__auto__;
}
})()))
{return (function() { 
var G__36126__delegate = function (args){cljs.core.apply.call(null,l,args);
return cljs.core.apply.call(null,r,args);
};
var G__36126 = function (var_args){
var args = null;if (arguments.length > 0) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return G__36126__delegate.call(this,args);};
G__36126.cljs$lang$maxFixedArity = 0;
G__36126.cljs$lang$applyTo = (function (arglist__36127){
var args = cljs.core.seq(arglist__36127);
return G__36126__delegate(args);
});
G__36126.cljs$core$IFn$_invoke$arity$variadic = G__36126__delegate;
return G__36126;
})()
;
} else
{var or__3541__auto__ = l;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return r;
}
}
});
/**
* Map of React keyword to a custom function for its merge. Tries to
* do a decent job with event handlers as well; currently only
* handles :on-select :on-click, :on-blur, kebab-cased as om-tools
* prefers.
*/
om_bootstrap.util.react_merges = (function (){var merge_class = (function (l,r){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(l)+" "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(r));
});var empty_fn = ((function (merge_class){
return (function (_,___$1){return null;
});})(merge_class))
;return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"className","className",-1983287057),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"on-select","on-select",-192407950),new cljs.core.Keyword(null,"class","class",-2030961996)],[empty_fn,empty_fn,empty_fn,om_bootstrap.util.chain_fns,om_bootstrap.util.chain_fns,merge_class,cljs.core.merge,om_bootstrap.util.chain_fns,merge_class]);
})();
/**
* Merges two maps that represent React properties. Merges occur
* according to the functions defined in `react-merges`.
* @param {...*} var_args
*/
om_bootstrap.util.merge_props = (function() { 
var merge_props__delegate = function (prop_maps){var react_merge = (function react_merge(xs){return om_bootstrap.util.merge_with_fns.call(null,om_bootstrap.util.react_merges,xs);
});
var normalize_class = (function normalize_class(m){if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"class","class",-2030961996)))
{return react_merge.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.dissoc.call(null,m,new cljs.core.Keyword(null,"class","class",-2030961996)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(m)], null)], null));
} else
{return m;
}
});
return react_merge.call(null,cljs.core.map.call(null,normalize_class,prop_maps));
};
var merge_props = function (var_args){
var prop_maps = null;if (arguments.length > 0) {
  prop_maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return merge_props__delegate.call(this,prop_maps);};
merge_props.cljs$lang$maxFixedArity = 0;
merge_props.cljs$lang$applyTo = (function (arglist__36128){
var prop_maps = cljs.core.seq(arglist__36128);
return merge_props__delegate(prop_maps);
});
merge_props.cljs$core$IFn$_invoke$arity$variadic = merge_props__delegate;
return merge_props;
})()
;
/**
* Returns a basic, shallow copy of the supplied JS object.
*/
om_bootstrap.util.copy_js = (function copy_js(arr){var ret = (function (){var obj36136 = {};return obj36136;
})();var seq__36137_36141 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,arr));var chunk__36138_36142 = null;var count__36139_36143 = (0);var i__36140_36144 = (0);while(true){
if((i__36140_36144 < count__36139_36143))
{var k_36145 = cljs.core._nth.call(null,chunk__36138_36142,i__36140_36144);if(cljs.core.truth_(arr.hasOwnProperty(k_36145)))
{(ret[k_36145] = (arr[k_36145]));
} else
{}
{
var G__36146 = seq__36137_36141;
var G__36147 = chunk__36138_36142;
var G__36148 = count__36139_36143;
var G__36149 = (i__36140_36144 + (1));
seq__36137_36141 = G__36146;
chunk__36138_36142 = G__36147;
count__36139_36143 = G__36148;
i__36140_36144 = G__36149;
continue;
}
} else
{var temp__4126__auto___36150 = cljs.core.seq.call(null,seq__36137_36141);if(temp__4126__auto___36150)
{var seq__36137_36151__$1 = temp__4126__auto___36150;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36137_36151__$1))
{var c__4297__auto___36152 = cljs.core.chunk_first.call(null,seq__36137_36151__$1);{
var G__36153 = cljs.core.chunk_rest.call(null,seq__36137_36151__$1);
var G__36154 = c__4297__auto___36152;
var G__36155 = cljs.core.count.call(null,c__4297__auto___36152);
var G__36156 = (0);
seq__36137_36141 = G__36153;
chunk__36138_36142 = G__36154;
count__36139_36143 = G__36155;
i__36140_36144 = G__36156;
continue;
}
} else
{var k_36157 = cljs.core.first.call(null,seq__36137_36151__$1);if(cljs.core.truth_(arr.hasOwnProperty(k_36157)))
{(ret[k_36157] = (arr[k_36157]));
} else
{}
{
var G__36158 = cljs.core.next.call(null,seq__36137_36151__$1);
var G__36159 = null;
var G__36160 = (0);
var G__36161 = (0);
seq__36137_36141 = G__36158;
chunk__36138_36142 = G__36159;
count__36139_36143 = G__36160;
i__36140_36144 = G__36161;
continue;
}
}
} else
{}
}
break;
}
return ret;
});
/**
* Merges the supplied extra properties into the underlying Om cursor
* and calls the constructor to clone the React component.
* 
* Requires that the supplied child has an Om cursor attached to it!
*/
om_bootstrap.util.clone_om = (function clone_om(child,extra_props){var om_props = om.core.get_props.call(null,child);return child.constructor((function (){var G__36163 = om_bootstrap.util.copy_js.call(null,child.props);(G__36163["__om_cursor"] = ((cljs.core.fn_QMARK_.call(null,extra_props))?extra_props.call(null,om_props):om_bootstrap.util.merge_props.call(null,om_props,extra_props)));
return G__36163;
})());
});
/**
* This function is called if the React component child was NOT
* generated by Om. Merges the supplied properties into the -props
* field of the supplied React component and creates a shallow copy.
*/
om_bootstrap.util.clone_basic_react = (function clone_basic_react(child,extra_props){var props = cljs.core.js__GT_clj.call(null,child.props,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);var new_props = cljs.core.merge.call(null,((cljs.core.fn_QMARK_.call(null,extra_props))?extra_props.call(null,props):om_bootstrap.util.merge_props.call(null,props,extra_props)),(function (){var temp__4126__auto__ = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(props);if(cljs.core.truth_(temp__4126__auto__))
{var children = temp__4126__auto__;return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"children","children",-940561982),children], null);
} else
{return null;
}
})());return child.constructor(cljs.core.clj__GT_js.call(null,new_props));
});
/**
* Returns a shallow copy of the supplied component (child); the copy
* will have any props provided by extra-props merged in. Props are
* merged in the same manner as merge-props, so props like :class will
* be merged intelligently.
* 
* extra-props can be a function of the old props that returns new
* props, OR it can be a map of props.
* 
* If the supplied child is an Om component, any supplied extra
* properties will be merged into the underlying cursor and accessible
* in the Om constructor.
*/
om_bootstrap.util.clone_with_props = (function() {
var clone_with_props = null;
var clone_with_props__1 = (function (child){return clone_with_props.call(null,child,cljs.core.PersistentArrayMap.EMPTY);
});
var clone_with_props__2 = (function (child,extra_props){if(cljs.core.not.call(null,om_bootstrap.util.strict_valid_component_QMARK_.call(null,child)))
{return child;
} else
{if((cljs.core.map_QMARK_.call(null,extra_props)) && (cljs.core.empty_QMARK_.call(null,extra_props)))
{return child.constructor(child.props);
} else
{if(cljs.core.truth_(om.core.get_props.call(null,child)))
{return om_bootstrap.util.clone_om.call(null,child,extra_props);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return om_bootstrap.util.clone_basic_react.call(null,child,extra_props);
} else
{return null;
}
}
}
}
});
clone_with_props = function(child,extra_props){
switch(arguments.length){
case 1:
return clone_with_props__1.call(this,child);
case 2:
return clone_with_props__2.call(this,child,extra_props);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clone_with_props.cljs$core$IFn$_invoke$arity$1 = clone_with_props__1;
clone_with_props.cljs$core$IFn$_invoke$arity$2 = clone_with_props__2;
return clone_with_props;
})()
;

//# sourceMappingURL=util.js.map