// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.types');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.core');
om_bootstrap.types.Component = schema.core.named.call(null,schema.core.Any,"Alias for an om component, since I don't know what type to put here.");
om_bootstrap.types.Renderable = schema.core.named.call(null,schema.core.Any,"Anything that can get rendered.");
/**
* Map of keyword to the proper bootstrap class name.
*/
om_bootstrap.types.class_map = cljs.core.PersistentHashMap.fromArrays(["alert","label","form","progress-bar","modal","navbar","button-toolbar","panel-group","nav","column","row","input-group","panel","well","button-group","button","glyphicon"],["alert","label","form","progress-bar","modal","navbar","btn-toolbar","panel-group","nav","col","row","input-group","panel","well","btn-group","btn","glyphicon"]);
/**
* Map of style keywords -> styles.
*/
om_bootstrap.types.style_map = cljs.core.PersistentHashMap.fromArrays(["success","warning","inline","pills","info","tabs","primary","danger","link","default"],["success","warning","inline","pills","info","tabs","primary","danger","link","default"]);
om_bootstrap.types.size_map = new cljs.core.PersistentArrayMap(null, 4, ["large","lg","medium","md","small","sm","xsmall","xs"], null);
om_bootstrap.types.BSClass = cljs.core.apply.call(null,schema.core.enum$,cljs.core.keys.call(null,om_bootstrap.types.class_map));
om_bootstrap.types.BSStyle = cljs.core.apply.call(null,schema.core.enum$,cljs.core.keys.call(null,om_bootstrap.types.style_map));
om_bootstrap.types.BSSize = cljs.core.apply.call(null,schema.core.enum$,cljs.core.keys.call(null,om_bootstrap.types.size_map));
om_bootstrap.types.BootstrapClass = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-class","bs-class",1438130590)),om_bootstrap.types.BSClass,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)),om_bootstrap.types.BSStyle,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-size","bs-size",1567732754)),om_bootstrap.types.BSSize], true, false);
/**
* Applies all default bootstrap options to the supplied schema. If
* the incoming schema has one of the the keys from BootstrapClass,
* that wins (even if it's required).
*/
om_bootstrap.types.bootstrap = (function bootstrap(schema__$1){var bootstrap_schema = cljs.core.apply.call(null,cljs.core.dissoc,om_bootstrap.types.BootstrapClass,cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,cljs.core.select_keys.call(null,schema__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bs-class","bs-class",1438130590),new cljs.core.Keyword(null,"bs-style","bs-style",1424423998),new cljs.core.Keyword(null,"bs-size","bs-size",1567732754)], null)))));return cljs.core.assoc.call(null,cljs.core.merge.call(null,bootstrap_schema,schema__$1),schema.core.Any,schema.core.Any);
});
var ufv___35988 = schema.utils.use_fn_validation;var output_schema35983_35989 = schema.core.Any;var input_schema35984_35990 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,schema.core.Any], true, false),new cljs.core.Symbol(null,"schema","schema",58529736,null))], null);var input_checker35985_35991 = schema.core.checker.call(null,input_schema35984_35990);var output_checker35986_35992 = schema.core.checker.call(null,output_schema35983_35989);/**
* Inputs: [schema :- {s/Any s/Any}]
* 
* Returns all keys from a schema.
*/
om_bootstrap.types.schema_keys = ((function (ufv___35988,output_schema35983_35989,input_schema35984_35990,input_checker35985_35991,output_checker35986_35992){
return (function schema_keys(G__35987){var validate__13961__auto__ = ufv___35988.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___35993 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__35987], null);var temp__4126__auto___35994 = input_checker35985_35991.call(null,args__13962__auto___35993);if(cljs.core.truth_(temp__4126__auto___35994))
{var error__13963__auto___35995 = temp__4126__auto___35994;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"schema-keys","schema-keys",947810359,null),cljs.core.pr_str.call(null,error__13963__auto___35995)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema35984_35990,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___35993,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___35995], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__35987;while(true){
return cljs.core.map.call(null,((function (validate__13961__auto__,ufv___35988,output_schema35983_35989,input_schema35984_35990,input_checker35985_35991,output_checker35986_35992){
return (function (k){if(schema.core.optional_key_QMARK_.call(null,k))
{return new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(k);
} else
{return k;
}
});})(validate__13961__auto__,ufv___35988,output_schema35983_35989,input_schema35984_35990,input_checker35985_35991,output_checker35986_35992))
,cljs.core.keys.call(null,schema__$1));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___35996 = output_checker35986_35992.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___35996))
{var error__13963__auto___35997 = temp__4126__auto___35996;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"schema-keys","schema-keys",947810359,null),cljs.core.pr_str.call(null,error__13963__auto___35997)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema35983_35989,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___35997], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___35988,output_schema35983_35989,input_schema35984_35990,input_checker35985_35991,output_checker35986_35992))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.schema_keys),schema.core.make_fn_schema.call(null,output_schema35983_35989,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema35984_35990], null)));
var ufv___36003 = schema.utils.use_fn_validation;var output_schema35998_36004 = schema.core.Any;var input_schema35999_36005 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"schema","schema",58529736,null))], null);var input_checker36000_36006 = schema.core.checker.call(null,input_schema35999_36005);var output_checker36001_36007 = schema.core.checker.call(null,output_schema35998_36004);/**
* Inputs: [schema]
* 
* Returns a map schema that accepts the supplied map schema, plus any
* other optional keys that show up in the map. Such a schema can only
* enforce that required keys are missing.
*/
om_bootstrap.types.at_least = ((function (ufv___36003,output_schema35998_36004,input_schema35999_36005,input_checker36000_36006,output_checker36001_36007){
return (function at_least(G__36002){var validate__13961__auto__ = ufv___36003.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36008 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36002], null);var temp__4126__auto___36009 = input_checker36000_36006.call(null,args__13962__auto___36008);if(cljs.core.truth_(temp__4126__auto___36009))
{var error__13963__auto___36010 = temp__4126__auto___36009;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"at-least","at-least",1907728373,null),cljs.core.pr_str.call(null,error__13963__auto___36010)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema35999_36005,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36008,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36010], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__36002;while(true){
return cljs.core.assoc.call(null,schema__$1,schema.core.Any,schema.core.Any);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36011 = output_checker36001_36007.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36011))
{var error__13963__auto___36012 = temp__4126__auto___36011;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"at-least","at-least",1907728373,null),cljs.core.pr_str.call(null,error__13963__auto___36012)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema35998_36004,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36012], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36003,output_schema35998_36004,input_schema35999_36005,input_checker36000_36006,output_checker36001_36007))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.at_least),schema.core.make_fn_schema.call(null,output_schema35998_36004,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema35999_36005], null)));
var ufv___36025 = schema.utils.use_fn_validation;var output_schema36013_36026 = schema.core.pair.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,schema.core.Any], true, false),"om-bootstrap options.",new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,schema.core.Any], true, false),"all other props.");var input_schema36014_36027 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"schema","schema",58529736,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_schema36019_36028 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"schema","schema",58529736,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"opts","opts",1795607228,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"defaults","defaults",-1678408555,null))], null);var input_checker36015_36029 = schema.core.checker.call(null,input_schema36014_36027);var output_checker36016_36030 = schema.core.checker.call(null,output_schema36013_36026);var input_checker36020_36031 = schema.core.checker.call(null,input_schema36019_36028);var output_checker36021_36032 = schema.core.checker.call(null,output_schema36013_36026);/**
* Inputs: ([schema opts] [schema opts defaults])
* Returns: (s/pair {s/Any s/Any} "om-bootstrap options." {s/Any s/Any} "all other props.")
* 
* Returns two maps; the first is all of the schema options, the
* second is the REST of the options.
*/
om_bootstrap.types.separate = ((function (ufv___36025,output_schema36013_36026,input_schema36014_36027,input_schema36019_36028,input_checker36015_36029,output_checker36016_36030,input_checker36020_36031,output_checker36021_36032){
return (function() {
var separate = null;
var separate__2 = (function (G__36017,G__36018){var validate__13961__auto__ = ufv___36025.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36033 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36017,G__36018], null);var temp__4126__auto___36034 = input_checker36015_36029.call(null,args__13962__auto___36033);if(cljs.core.truth_(temp__4126__auto___36034))
{var error__13963__auto___36035 = temp__4126__auto___36034;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36035)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36014_36027,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36033,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36035], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__36017;var opts = G__36018;while(true){
return separate.call(null,schema__$1,opts,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36036 = output_checker36016_36030.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36036))
{var error__13963__auto___36037 = temp__4126__auto___36036;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36037)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36013_36026,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36037], null));
} else
{}
} else
{}
return o__13964__auto__;
});
var separate__3 = (function (G__36022,G__36023,G__36024){var validate__13961__auto__ = ufv___36025.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36038 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36022,G__36023,G__36024], null);var temp__4126__auto___36039 = input_checker36020_36031.call(null,args__13962__auto___36038);if(cljs.core.truth_(temp__4126__auto___36039))
{var error__13963__auto___36040 = temp__4126__auto___36039;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36040)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36019_36028,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36038,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36040], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__36022;var opts = G__36023;var defaults = G__36024;while(true){
var ks = cljs.core.set.call(null,om_bootstrap.types.schema_keys.call(null,om_bootstrap.types.bootstrap.call(null,schema__$1)));var opts__$1 = cljs.core.merge.call(null,defaults,opts);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,cljs.core.comp.call(null,ks,cljs.core.key),opts__$1)),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.call(null,cljs.core.comp.call(null,ks,cljs.core.key),opts__$1))], null);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36041 = output_checker36021_36032.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36041))
{var error__13963__auto___36042 = temp__4126__auto___36041;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36042)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36013_36026,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36042], null));
} else
{}
} else
{}
return o__13964__auto__;
});
separate = function(G__36022,G__36023,G__36024){
switch(arguments.length){
case 2:
return separate__2.call(this,G__36022,G__36023);
case 3:
return separate__3.call(this,G__36022,G__36023,G__36024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
separate.cljs$core$IFn$_invoke$arity$2 = separate__2;
separate.cljs$core$IFn$_invoke$arity$3 = separate__3;
return separate;
})()
;})(ufv___36025,output_schema36013_36026,input_schema36014_36027,input_schema36019_36028,input_checker36015_36029,output_checker36016_36030,input_checker36020_36031,output_checker36021_36032))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.separate),schema.core.make_fn_schema.call(null,output_schema36013_36026,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36014_36027,input_schema36019_36028], null)));
var ufv___36056 = schema.utils.use_fn_validation;var output_schema36043_36057 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Str,schema.core.Bool], true, false);var input_schema36044_36058 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.types.at_least.call(null,om_bootstrap.types.BootstrapClass),new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker36045_36059 = schema.core.checker.call(null,input_schema36044_36058);var output_checker36046_36060 = schema.core.checker.call(null,output_schema36043_36057);/**
* Inputs: [{:keys [bs-class bs-style bs-size]} :- (at-least BootstrapClass)]
* Returns: {s/Str s/Bool}
* 
* Returns input for class-set.
*/
om_bootstrap.types.bs_class_set = ((function (ufv___36056,output_schema36043_36057,input_schema36044_36058,input_checker36045_36059,output_checker36046_36060){
return (function bs_class_set(G__36047){var validate__13961__auto__ = ufv___36056.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36061 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36047], null);var temp__4126__auto___36062 = input_checker36045_36059.call(null,args__13962__auto___36061);if(cljs.core.truth_(temp__4126__auto___36062))
{var error__13963__auto___36063 = temp__4126__auto___36062;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"bs-class-set","bs-class-set",1457832630,null),cljs.core.pr_str.call(null,error__13963__auto___36063)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36044_36058,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36061,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36063], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__36053 = G__36047;var map__36054 = G__36053;var map__36054__$1 = ((cljs.core.seq_QMARK_.call(null,map__36054))?cljs.core.apply.call(null,cljs.core.hash_map,map__36054):map__36054);var bs_size = cljs.core.get.call(null,map__36054__$1,new cljs.core.Keyword(null,"bs-size","bs-size",1567732754));var bs_style = cljs.core.get.call(null,map__36054__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var bs_class = cljs.core.get.call(null,map__36054__$1,new cljs.core.Keyword(null,"bs-class","bs-class",1438130590));var G__36053__$1 = G__36053;while(true){
var map__36055 = G__36053__$1;var map__36055__$1 = ((cljs.core.seq_QMARK_.call(null,map__36055))?cljs.core.apply.call(null,cljs.core.hash_map,map__36055):map__36055);var bs_size__$1 = cljs.core.get.call(null,map__36055__$1,new cljs.core.Keyword(null,"bs-size","bs-size",1567732754));var bs_style__$1 = cljs.core.get.call(null,map__36055__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var bs_class__$1 = cljs.core.get.call(null,map__36055__$1,new cljs.core.Keyword(null,"bs-class","bs-class",1438130590));var temp__4124__auto__ = om_bootstrap.types.class_map.call(null,bs_class__$1);if(cljs.core.truth_(temp__4124__auto__))
{var klass = temp__4124__auto__;var prefix = (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,klass))+"-");return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap.fromArray([klass,true], true, false),(function (){var temp__4126__auto__ = om_bootstrap.types.size_map.call(null,bs_size__$1);if(cljs.core.truth_(temp__4126__auto__))
{var size = temp__4126__auto__;return new cljs.core.PersistentArrayMap.fromArray([(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))),true], true, false);
} else
{return null;
}
})(),(function (){var temp__4126__auto__ = om_bootstrap.types.style_map.call(null,bs_style__$1);if(cljs.core.truth_(temp__4126__auto__))
{var style = temp__4126__auto__;return new cljs.core.PersistentArrayMap.fromArray([(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,style))),true], true, false);
} else
{return null;
}
})());
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36064 = output_checker36046_36060.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36064))
{var error__13963__auto___36065 = temp__4126__auto___36064;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"bs-class-set","bs-class-set",1457832630,null),cljs.core.pr_str.call(null,error__13963__auto___36065)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36043_36057,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36065], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36056,output_schema36043_36057,input_schema36044_36058,input_checker36045_36059,output_checker36046_36060))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.bs_class_set),schema.core.make_fn_schema.call(null,output_schema36043_36057,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36044_36058], null)));

//# sourceMappingURL=types.js.map