// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.mixins');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('schema.core');
goog.require('schema.core');
goog.require('om_tools.mixin');
goog.require('om.core');
goog.require('om.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
var ufv___36171 = schema.utils.use_fn_validation;var output_schema36164_36172 = schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));var input_schema36165_36173 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"target","target",1893533248,null)),schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"event-type","event-type",1960254340,null)),schema.core.one.call(null,schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null)),new cljs.core.Symbol(null,"callback","callback",935395299,null))], null);var input_checker36166_36174 = schema.core.checker.call(null,input_schema36165_36173);var output_checker36167_36175 = schema.core.checker.call(null,output_schema36164_36172);/**
* Inputs: [target :- s/Any event-type :- s/Str callback :- (sm/=> s/Any s/Any)]
* Returns: (sm/=> s/Any)
* 
* Registers the callback on the supplied target for events of type
* `event-type`. Returns a function of no arguments that, when called,
* unregisters the callback.
*/
om_bootstrap.mixins.event_listener = ((function (ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175){
return (function event_listener(G__36168,G__36169,G__36170){var validate__13961__auto__ = ufv___36171.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36176 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36168,G__36169,G__36170], null);var temp__4126__auto___36177 = input_checker36166_36174.call(null,args__13962__auto___36176);if(cljs.core.truth_(temp__4126__auto___36177))
{var error__13963__auto___36178 = temp__4126__auto___36177;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"event-listener","event-listener",809979412,null),cljs.core.pr_str.call(null,error__13963__auto___36178)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36165_36173,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36176,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36178], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var target = G__36168;var event_type = G__36169;var callback = G__36170;while(true){
if(cljs.core.truth_(target.addEventListener))
{target.addEventListener(event_type,callback,false);
return ((function (validate__13961__auto__,ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175){
return (function (){return target.removeEventListener(event_type,callback,false);
});
;})(validate__13961__auto__,ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175))
} else
{if(cljs.core.truth_(target.attachEvent))
{var event_type__$1 = ("on"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type));target.attachEvent(event_type__$1,callback);
return ((function (event_type__$1,validate__13961__auto__,ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175){
return (function (){return target.detachEvent(event_type__$1,callback);
});
;})(event_type__$1,validate__13961__auto__,ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175))
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return ((function (validate__13961__auto__,ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175){
return (function (){return null;
});
;})(validate__13961__auto__,ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175))
} else
{return null;
}
}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36179 = output_checker36167_36175.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36179))
{var error__13963__auto___36180 = temp__4126__auto___36179;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"event-listener","event-listener",809979412,null),cljs.core.pr_str.call(null,error__13963__auto___36180)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36164_36172,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36180], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36171,output_schema36164_36172,input_schema36165_36173,input_checker36166_36174,output_checker36167_36175))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.mixins.event_listener),schema.core.make_fn_schema.call(null,output_schema36164_36172,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36165_36173], null)));
/**
* Handles a sequence of listeners for the component, and removes them
* from the document when the component is unmounted.
*/
om_bootstrap.mixins.set_listener_mixin = {"set_listener": (function (target36185,event_type36186,callback36187){var this36184 = this;return ((function (this36184){
return (function (owner,target,event_type,callback){var remove_fn = om_bootstrap.mixins.event_listener.call(null,target,event_type,callback);return owner.listeners.push(remove_fn);
});})(this36184))
.call(null,this36184,target36185,event_type36186,callback36187);
}), "componentWillUnmount": (function (){var this36183 = this;return ((function (this36183){
return (function (owner){return owner.listeners.map(((function (this36183){
return (function (p1__36181_SHARP_){return p1__36181_SHARP_.call(null);
});})(this36183))
);
});})(this36183))
.call(null,this36183);
}), "componentWillMount": (function (){var this36182 = this;return ((function (this36182){
return (function (owner){return owner.listeners = [];
});})(this36182))
.call(null,this36182);
})};
/**
* Handles a sequence of timeouts for the component, and removes them
* from the document when the component is unmounted.
*/
om_bootstrap.mixins.set_timeout_mixin = {"set_timeout": (function (f36192,timeout36193){var this36191 = this;return ((function (this36191){
return (function (owner,f,timeout){var timeout__$1 = setTimeout(f,timeout);return owner.timeouts.push(timeout__$1);
});})(this36191))
.call(null,this36191,f36192,timeout36193);
}), "componentWillUnmount": (function (){var this36190 = this;return ((function (this36190){
return (function (owner){return owner.timeouts.map(((function (this36190){
return (function (p1__36188_SHARP_){return clearTimeout(p1__36188_SHARP_);
});})(this36190))
);
});})(this36190))
.call(null,this36190);
}), "componentWillMount": (function (){var this36189 = this;return ((function (this36189){
return (function (owner){return owner.timeouts = [];
});})(this36189))
.call(null,this36189);
})};
/**
* Accepts two DOM elements; returns true if the supplied node is
* nested inside the supplied root, false otherwise.
*/
om_bootstrap.mixins.in_root_QMARK_ = (function in_root_QMARK_(node,root){var node__$1 = node;while(true){
if((node__$1 == null))
{return false;
} else
{if(cljs.core._EQ_.call(null,root,node__$1))
{return true;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{{
var G__36194 = node__$1.parentNode;
node__$1 = G__36194;
continue;
}
} else
{return null;
}
}
}
break;
}
});
om_bootstrap.mixins.ESCAPE_KEY = (27);
/**
* For dropdowns, binds a handler for that sets the dropdown-mixin's
* `:open?` state to false if the user clicks outside the owning
* component OR hits the escape key.
*/
om_bootstrap.mixins.bind_root_close_handlers_BANG_ = (function bind_root_close_handlers_BANG_(owner){var set_state = (owner["setDropdownState"]);return owner.dropdownListeners = [om_bootstrap.mixins.event_listener.call(null,document,"click",((function (set_state){
return (function (e){if(om_bootstrap.mixins.in_root_QMARK_.call(null,e.target,om.core.get_node.call(null,owner)))
{return null;
} else
{return set_state.call(null,false);
}
});})(set_state))
),om_bootstrap.mixins.event_listener.call(null,document,"keyup",((function (set_state){
return (function (e){if(cljs.core._EQ_.call(null,om_bootstrap.mixins.ESCAPE_KEY,e.keyCode))
{return set_state.call(null,false);
} else
{return null;
}
});})(set_state))
)];
});
/**
* If they're present on the owning object, removes the listeners
* registered by the dropdown mixin.
*/
om_bootstrap.mixins.unbind_root_close_handlers_BANG_ = (function unbind_root_close_handlers_BANG_(owner){var temp__4126__auto__ = owner.dropdownListeners;if(cljs.core.truth_(temp__4126__auto__))
{var listeners = temp__4126__auto__;cljs.core.map.call(null,((function (listeners,temp__4126__auto__){
return (function (p1__36195_SHARP_){return p1__36195_SHARP_.call(null);
});})(listeners,temp__4126__auto__))
,listeners);
return owner.dropdownListeners = null;
} else
{return null;
}
});
/**
* Mixin that manages a single piece of state - :open?. If a user
* clicks outside the component's owning dom element OR hits the escape
* key, the state will jump back to false.
* 
* Down the road this may need to register a callback when the state
* changes.
*/
om_bootstrap.mixins.dropdown_mixin = {"setDropdownState": (function (open_QMARK_36200){var this36199 = this;return ((function (this36199){
return (function (owner,open_QMARK_){if(cljs.core.truth_(open_QMARK_))
{om_bootstrap.mixins.bind_root_close_handlers_BANG_.call(null,owner);
} else
{om_bootstrap.mixins.unbind_root_close_handlers_BANG_.call(null,owner);
}
return om.core.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"open?","open?",1238443125)], null),open_QMARK_);
});})(this36199))
.call(null,this36199,open_QMARK_36200);
}), "isDropdownOpen": (function (){var this36198 = this;return ((function (this36198){
return (function (owner){return om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"open?","open?",1238443125));
});})(this36198))
.call(null,this36198);
}), "componentWillUnmount": (function (){var this36197 = this;return ((function (this36197){
return (function (owner){return om_bootstrap.mixins.unbind_root_close_handlers_BANG_.call(null,owner);
});})(this36197))
.call(null,this36197);
}), "getInitialState": (function (){var this36196 = this;return ((function (this36196){
return (function (_){return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null);
});})(this36196))
.call(null,this36196);
})};

//# sourceMappingURL=mixins.js.map