// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.input');
goog.require('cljs.core');
goog.require('om_bootstrap.types');
goog.require('schema.core');
goog.require('om_bootstrap.util');
goog.require('om_tools.dom');
goog.require('schema.core');
goog.require('clojure.string');
goog.require('om_bootstrap.util');
goog.require('om.core');
goog.require('om.core');
goog.require('clojure.string');
goog.require('om_bootstrap.types');
goog.require('om_tools.dom');
om_bootstrap.input.Addons = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384)),schema.core.either.call(null,schema.core.Str,om_bootstrap.types.Component),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"addon-after","addon-after",634985306)),schema.core.either.call(null,schema.core.Str,om_bootstrap.types.Component)], true, false);
/**
* Helps render feedback icons.
*/
om_bootstrap.input.FeedbackIcons = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)),schema.core.enum$.call(null,"success","warning","error"),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821)),schema.core.Bool], true, false);
/**
* Input fields that match these bad dawgs:
* https://github.com/react-bootstrap/react-bootstrap/blob/master/src/Input.jsx
*/
om_bootstrap.input.Input = cljs.core.merge.call(null,om_bootstrap.input.Addons,om_bootstrap.input.FeedbackIcons,new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"type","type",1174270348)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label","label",1718410804)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"skip-form-group?","skip-form-group?",210862261)),schema.core.named.call(null,schema.core.Bool,"DON'T render a wrapping form group?"),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"help","help",-439233446)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212)),schema.core.Str], true, false));
om_bootstrap.input.Radio = om_bootstrap.types.bootstrap.call(null,new cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"label","label",1718410804),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"checked?","checked?",2024809091)),schema.core.Bool,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791)),schema.core.Bool], true, false));
var ufv___37228 = schema.utils.use_fn_validation;var output_schema37219_37229 = schema.core.Str;var input_schema37220_37230 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.Str,schema.core.Keyword),schema.core.Bool], true, false),new cljs.core.Symbol(null,"klasses","klasses",-380235757,null))], null);var input_checker37221_37231 = schema.core.checker.call(null,input_schema37220_37230);var output_checker37222_37232 = schema.core.checker.call(null,output_schema37219_37229);/**
* Inputs: [klasses :- {(s/either s/Str s/Keyword) s/Bool}]
* Returns: s/Str
* 
* Mimics the class-set behavior from React. Pass in a map of
* potential class to Boolean; you'll get back a class string that
* represents the final class to apply.
* 
* TODO: Use class-set from om-tools.
*/
om_bootstrap.input.class_set = ((function (ufv___37228,output_schema37219_37229,input_schema37220_37230,input_checker37221_37231,output_checker37222_37232){
return (function class_set(G__37223){var validate__13961__auto__ = ufv___37228.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37233 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37223], null);var temp__4126__auto___37234 = input_checker37221_37231.call(null,args__13962__auto___37233);if(cljs.core.truth_(temp__4126__auto___37234))
{var error__13963__auto___37235 = temp__4126__auto___37234;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"class-set","class-set",-355600496,null),cljs.core.pr_str.call(null,error__13963__auto___37235)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37220_37230,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37233,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37235], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var klasses = G__37223;while(true){
return clojure.string.join.call(null," ",cljs.core.mapcat.call(null,((function (validate__13961__auto__,ufv___37228,output_schema37219_37229,input_schema37220_37230,input_checker37221_37231,output_checker37222_37232){
return (function (p__37226){var vec__37227 = p__37226;var k = cljs.core.nth.call(null,vec__37227,(0),null);var keep_QMARK_ = cljs.core.nth.call(null,vec__37227,(1),null);if(cljs.core.truth_(keep_QMARK_))
{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.name.call(null,k)], null);
} else
{return null;
}
});})(validate__13961__auto__,ufv___37228,output_schema37219_37229,input_schema37220_37230,input_checker37221_37231,output_checker37222_37232))
,klasses));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37236 = output_checker37222_37232.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37236))
{var error__13963__auto___37237 = temp__4126__auto___37236;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"class-set","class-set",-355600496,null),cljs.core.pr_str.call(null,error__13963__auto___37237)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37219_37229,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37237], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37228,output_schema37219_37229,input_schema37220_37230,input_checker37221_37231,output_checker37222_37232))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.class_set),schema.core.make_fn_schema.call(null,output_schema37219_37229,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37220_37230], null)));
var ufv___37243 = schema.utils.use_fn_validation;var output_schema37238_37244 = om_bootstrap.types.Component;var input_schema37239_37245 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"glyph-name","glyph-name",350405338,null))], null);var input_checker37240_37246 = schema.core.checker.call(null,input_schema37239_37245);var output_checker37241_37247 = schema.core.checker.call(null,output_schema37238_37244);/**
* Inputs: [glyph-name :- s/Str]
* Returns: t/Component
* 
* To be used with :addon-before or :addon-after.
*/
om_bootstrap.input.glyph = ((function (ufv___37243,output_schema37238_37244,input_schema37239_37245,input_checker37240_37246,output_checker37241_37247){
return (function glyph(G__37242){var validate__13961__auto__ = ufv___37243.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37248 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37242], null);var temp__4126__auto___37249 = input_checker37240_37246.call(null,args__13962__auto___37248);if(cljs.core.truth_(temp__4126__auto___37249))
{var error__13963__auto___37250 = temp__4126__auto___37249;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"glyph","glyph",-534987652,null),cljs.core.pr_str.call(null,error__13963__auto___37250)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37239_37245,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37248,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37250], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var glyph_name = G__37242;while(true){
return React.DOM.span({"className": om_tools.dom.format_opts.call(null,("glyphicon glyphicon-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(glyph_name)))});
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37251 = output_checker37241_37247.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37251))
{var error__13963__auto___37252 = temp__4126__auto___37251;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"glyph","glyph",-534987652,null),cljs.core.pr_str.call(null,error__13963__auto___37252)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37238_37244,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37252], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37243,output_schema37238_37244,input_schema37239_37245,input_checker37240_37246,output_checker37241_37247))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.glyph),schema.core.make_fn_schema.call(null,output_schema37238_37244,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37239_37245], null)));
var ufv___37266 = schema.utils.use_fn_validation;var output_schema37253_37267 = om_bootstrap.types.Component;var input_schema37254_37268 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.FeedbackIcons,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker37255_37269 = schema.core.checker.call(null,input_schema37254_37268);var output_checker37256_37270 = schema.core.checker.call(null,output_schema37253_37267);/**
* Inputs: [{:keys [feedback? bs-style]} :- FeedbackIcons]
* Returns: t/Component
*/
om_bootstrap.input.render_icon = ((function (ufv___37266,output_schema37253_37267,input_schema37254_37268,input_checker37255_37269,output_checker37256_37270){
return (function render_icon(G__37257){var validate__13961__auto__ = ufv___37266.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37271 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37257], null);var temp__4126__auto___37272 = input_checker37255_37269.call(null,args__13962__auto___37271);if(cljs.core.truth_(temp__4126__auto___37272))
{var error__13963__auto___37273 = temp__4126__auto___37272;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-icon","render-icon",511977669,null),cljs.core.pr_str.call(null,error__13963__auto___37273)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37254_37268,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37271,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37273], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37263 = G__37257;var map__37264 = G__37263;var map__37264__$1 = ((cljs.core.seq_QMARK_.call(null,map__37264))?cljs.core.apply.call(null,cljs.core.hash_map,map__37264):map__37264);var bs_style = cljs.core.get.call(null,map__37264__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var feedback_QMARK_ = cljs.core.get.call(null,map__37264__$1,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821));var G__37263__$1 = G__37263;while(true){
var map__37265 = G__37263__$1;var map__37265__$1 = ((cljs.core.seq_QMARK_.call(null,map__37265))?cljs.core.apply.call(null,cljs.core.hash_map,map__37265):map__37265);var bs_style__$1 = cljs.core.get.call(null,map__37265__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var feedback_QMARK___$1 = cljs.core.get.call(null,map__37265__$1,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821));if(cljs.core.truth_(feedback_QMARK___$1))
{var klasses = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"glyphicon","glyphicon",-2083132161),true,new cljs.core.Keyword(null,"form-control-feedback","form-control-feedback",-26248681),true,new cljs.core.Keyword(null,"glyphicon-ok","glyphicon-ok",-980475854),cljs.core._EQ_.call(null,"success",bs_style__$1),new cljs.core.Keyword(null,"glyphicon-warning-sign","glyphicon-warning-sign",-715964093),cljs.core._EQ_.call(null,"warning",bs_style__$1),new cljs.core.Keyword(null,"glyphicon-remove","glyphicon-remove",16420020),cljs.core._EQ_.call(null,"error",bs_style__$1)], null);return React.DOM.span({"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,klasses))});
} else
{return null;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37274 = output_checker37256_37270.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37274))
{var error__13963__auto___37275 = temp__4126__auto___37274;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-icon","render-icon",511977669,null),cljs.core.pr_str.call(null,error__13963__auto___37275)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37253_37267,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37275], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37266,output_schema37253_37267,input_schema37254_37268,input_checker37255_37269,output_checker37256_37270))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_icon),schema.core.make_fn_schema.call(null,output_schema37253_37267,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37254_37268], null)));
var ufv___37281 = schema.utils.use_fn_validation;var output_schema37276_37282 = schema.core.Any;var input_schema37277_37283 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.maybe.call(null,schema.core.Str),new cljs.core.Symbol(null,"help","help",1201298081,null))], null);var input_checker37278_37284 = schema.core.checker.call(null,input_schema37277_37283);var output_checker37279_37285 = schema.core.checker.call(null,output_schema37276_37282);/**
* Inputs: [help :- (s/maybe s/Str)]
*/
om_bootstrap.input.render_help = ((function (ufv___37281,output_schema37276_37282,input_schema37277_37283,input_checker37278_37284,output_checker37279_37285){
return (function render_help(G__37280){var validate__13961__auto__ = ufv___37281.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37286 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37280], null);var temp__4126__auto___37287 = input_checker37278_37284.call(null,args__13962__auto___37286);if(cljs.core.truth_(temp__4126__auto___37287))
{var error__13963__auto___37288 = temp__4126__auto___37287;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-help","render-help",-1879333594,null),cljs.core.pr_str.call(null,error__13963__auto___37288)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37277_37283,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37286,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37288], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var help = G__37280;while(true){
if(cljs.core.truth_(help))
{return cljs.core.apply.call(null,React.DOM.span,{"className": "help-block"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[help],null))));
} else
{return null;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37289 = output_checker37279_37285.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37289))
{var error__13963__auto___37290 = temp__4126__auto___37289;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-help","render-help",-1879333594,null),cljs.core.pr_str.call(null,error__13963__auto___37290)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37276_37282,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37290], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37281,output_schema37276_37282,input_schema37277_37283,input_checker37278_37284,output_checker37279_37285))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_help),schema.core.make_fn_schema.call(null,output_schema37276_37282,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37277_37283], null)));
var ufv___37305 = schema.utils.use_fn_validation;var output_schema37291_37306 = schema.core.Any;var input_schema37292_37307 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Addons,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"items","items",-1622480831,null))], null);var input_checker37293_37308 = schema.core.checker.call(null,input_schema37292_37307);var output_checker37294_37309 = schema.core.checker.call(null,output_schema37291_37306);/**
* Inputs: [{:keys [addon-before addon-after]} :- Addons items :- s/Any]
* 
* Items is a vector of render instances.
*/
om_bootstrap.input.render_input_group = ((function (ufv___37305,output_schema37291_37306,input_schema37292_37307,input_checker37293_37308,output_checker37294_37309){
return (function render_input_group(G__37295,G__37296){var validate__13961__auto__ = ufv___37305.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37310 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37295,G__37296], null);var temp__4126__auto___37311 = input_checker37293_37308.call(null,args__13962__auto___37310);if(cljs.core.truth_(temp__4126__auto___37311))
{var error__13963__auto___37312 = temp__4126__auto___37311;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-input-group","render-input-group",361721583,null),cljs.core.pr_str.call(null,error__13963__auto___37312)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37292_37307,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37310,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37312], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37302 = G__37295;var map__37303 = G__37302;var map__37303__$1 = ((cljs.core.seq_QMARK_.call(null,map__37303))?cljs.core.apply.call(null,cljs.core.hash_map,map__37303):map__37303);var addon_after = cljs.core.get.call(null,map__37303__$1,new cljs.core.Keyword(null,"addon-after","addon-after",634985306));var addon_before = cljs.core.get.call(null,map__37303__$1,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384));var items = G__37296;var G__37302__$1 = G__37302;var items__$1 = items;while(true){
var map__37304 = G__37302__$1;var map__37304__$1 = ((cljs.core.seq_QMARK_.call(null,map__37304))?cljs.core.apply.call(null,cljs.core.hash_map,map__37304):map__37304);var addon_after__$1 = cljs.core.get.call(null,map__37304__$1,new cljs.core.Keyword(null,"addon-after","addon-after",634985306));var addon_before__$1 = cljs.core.get.call(null,map__37304__$1,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384));var items__$2 = items__$1;if(cljs.core.truth_((function (){var or__3541__auto__ = addon_before__$1;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return addon_after__$1;
}
})()))
{return cljs.core.apply.call(null,React.DOM.div,{"className": "input-group"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(cljs.core.truth_(addon_before__$1)?cljs.core.apply.call(null,React.DOM.span,{"className": "input-group-addon"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[addon_before__$1],null)))):null),items__$2,(cljs.core.truth_(addon_after__$1)?cljs.core.apply.call(null,React.DOM.span,{"className": "input-group-addon"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[addon_after__$1],null)))):null)],null))));
} else
{return items__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37313 = output_checker37294_37309.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37313))
{var error__13963__auto___37314 = temp__4126__auto___37313;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-input-group","render-input-group",361721583,null),cljs.core.pr_str.call(null,error__13963__auto___37314)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37291_37306,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37314], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37305,output_schema37291_37306,input_schema37292_37307,input_checker37293_37308,output_checker37294_37309))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_input_group),schema.core.make_fn_schema.call(null,output_schema37291_37306,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37292_37307], null)));
var ufv___37328 = schema.utils.use_fn_validation;var output_schema37315_37329 = schema.core.Bool;var input_schema37316_37330 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker37317_37331 = schema.core.checker.call(null,input_schema37316_37330);var output_checker37318_37332 = schema.core.checker.call(null,output_schema37315_37329);/**
* Inputs: [{type :type} :- Input]
* Returns: s/Bool
* 
* Returns true if the supplied input is of type checkbox or radio,
* false otherwise.
*/
om_bootstrap.input.checkbox_or_radio_QMARK_ = ((function (ufv___37328,output_schema37315_37329,input_schema37316_37330,input_checker37317_37331,output_checker37318_37332){
return (function checkbox_or_radio_QMARK_(G__37319){var validate__13961__auto__ = ufv___37328.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37333 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37319], null);var temp__4126__auto___37334 = input_checker37317_37331.call(null,args__13962__auto___37333);if(cljs.core.truth_(temp__4126__auto___37334))
{var error__13963__auto___37335 = temp__4126__auto___37334;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio?","checkbox-or-radio?",-1047589288,null),cljs.core.pr_str.call(null,error__13963__auto___37335)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37316_37330,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37333,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37335], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37325 = G__37319;var map__37326 = G__37325;var map__37326__$1 = ((cljs.core.seq_QMARK_.call(null,map__37326))?cljs.core.apply.call(null,cljs.core.hash_map,map__37326):map__37326);var type = cljs.core.get.call(null,map__37326__$1,new cljs.core.Keyword(null,"type","type",1174270348));var G__37325__$1 = G__37325;while(true){
var map__37327 = G__37325__$1;var map__37327__$1 = ((cljs.core.seq_QMARK_.call(null,map__37327))?cljs.core.apply.call(null,cljs.core.hash_map,map__37327):map__37327);var type__$1 = cljs.core.get.call(null,map__37327__$1,new cljs.core.Keyword(null,"type","type",1174270348));return (cljs.core._EQ_.call(null,type__$1,"checkbox")) || (cljs.core._EQ_.call(null,type__$1,"radio"));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37336 = output_checker37318_37332.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37336))
{var error__13963__auto___37337 = temp__4126__auto___37336;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio?","checkbox-or-radio?",-1047589288,null),cljs.core.pr_str.call(null,error__13963__auto___37337)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37315_37329,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37337], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37328,output_schema37315_37329,input_schema37316_37330,input_checker37317_37331,output_checker37318_37332))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.checkbox_or_radio_QMARK_),schema.core.make_fn_schema.call(null,output_schema37315_37329,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37316_37330], null)));
var ufv___37352 = schema.utils.use_fn_validation;var output_schema37338_37353 = om_bootstrap.types.Component;var input_schema37339_37354 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37340_37355 = schema.core.checker.call(null,input_schema37339_37354);var output_checker37341_37356 = schema.core.checker.call(null,output_schema37338_37353);/**
* Inputs: [{type :type} :- Input children]
* Returns: t/Component
* 
* Wraps this business in a div.
*/
om_bootstrap.input.checkbox_or_radio_wrapper = ((function (ufv___37352,output_schema37338_37353,input_schema37339_37354,input_checker37340_37355,output_checker37341_37356){
return (function checkbox_or_radio_wrapper(G__37342,G__37343){var validate__13961__auto__ = ufv___37352.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37357 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37342,G__37343], null);var temp__4126__auto___37358 = input_checker37340_37355.call(null,args__13962__auto___37357);if(cljs.core.truth_(temp__4126__auto___37358))
{var error__13963__auto___37359 = temp__4126__auto___37358;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio-wrapper","checkbox-or-radio-wrapper",-964759132,null),cljs.core.pr_str.call(null,error__13963__auto___37359)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37339_37354,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37357,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37359], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37349 = G__37342;var map__37350 = G__37349;var map__37350__$1 = ((cljs.core.seq_QMARK_.call(null,map__37350))?cljs.core.apply.call(null,cljs.core.hash_map,map__37350):map__37350);var type = cljs.core.get.call(null,map__37350__$1,new cljs.core.Keyword(null,"type","type",1174270348));var children = G__37343;var G__37349__$1 = G__37349;var children__$1 = children;while(true){
var map__37351 = G__37349__$1;var map__37351__$1 = ((cljs.core.seq_QMARK_.call(null,map__37351))?cljs.core.apply.call(null,cljs.core.hash_map,map__37351):map__37351);var type__$1 = cljs.core.get.call(null,map__37351__$1,new cljs.core.Keyword(null,"type","type",1174270348));var children__$2 = children__$1;var klasses = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"checkbox","checkbox",1612615655),cljs.core._EQ_.call(null,"checkbox",type__$1),new cljs.core.Keyword(null,"radio","radio",1323726374),cljs.core._EQ_.call(null,"radio",type__$1)], null);return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,klasses))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children__$2],null))));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37360 = output_checker37341_37356.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37360))
{var error__13963__auto___37361 = temp__4126__auto___37360;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio-wrapper","checkbox-or-radio-wrapper",-964759132,null),cljs.core.pr_str.call(null,error__13963__auto___37361)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37338_37353,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37361], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37352,output_schema37338_37353,input_schema37339_37354,input_checker37340_37355,output_checker37341_37356))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.checkbox_or_radio_wrapper),schema.core.make_fn_schema.call(null,output_schema37338_37353,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37339_37354], null)));
var ufv___37380 = schema.utils.use_fn_validation;var output_schema37362_37381 = schema.core.Any;var input_schema37363_37382 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"input","input",-2097503808,null))], null);var input_schema37367_37383 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker37364_37384 = schema.core.checker.call(null,input_schema37363_37382);var output_checker37365_37385 = schema.core.checker.call(null,output_schema37362_37381);var input_checker37368_37386 = schema.core.checker.call(null,input_schema37367_37383);var output_checker37369_37387 = schema.core.checker.call(null,output_schema37362_37381);/**
* Inputs: ([input :- Input] [{lc :label-classname, label :label, :as input} :- Input child])
* 
* This doesn't handle any control group stuff.
*/
om_bootstrap.input.render_label = ((function (ufv___37380,output_schema37362_37381,input_schema37363_37382,input_schema37367_37383,input_checker37364_37384,output_checker37365_37385,input_checker37368_37386,output_checker37369_37387){
return (function() {
var render_label = null;
var render_label__1 = (function (G__37366){var validate__13961__auto__ = ufv___37380.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37388 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37366], null);var temp__4126__auto___37389 = input_checker37364_37384.call(null,args__13962__auto___37388);if(cljs.core.truth_(temp__4126__auto___37389))
{var error__13963__auto___37390 = temp__4126__auto___37389;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37390)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37363_37382,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37388,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37390], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var input = G__37366;while(true){
return render_label.call(null,input,null);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37391 = output_checker37365_37385.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37391))
{var error__13963__auto___37392 = temp__4126__auto___37391;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37392)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37362_37381,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37392], null));
} else
{}
} else
{}
return o__13964__auto__;
});
var render_label__2 = (function (G__37370,G__37371){var validate__13961__auto__ = ufv___37380.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37393 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37370,G__37371], null);var temp__4126__auto___37394 = input_checker37368_37386.call(null,args__13962__auto___37393);if(cljs.core.truth_(temp__4126__auto___37394))
{var error__13963__auto___37395 = temp__4126__auto___37394;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37395)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37367_37383,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37393,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37395], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37377 = G__37370;var map__37378 = G__37377;var map__37378__$1 = ((cljs.core.seq_QMARK_.call(null,map__37378))?cljs.core.apply.call(null,cljs.core.hash_map,map__37378):map__37378);var input = map__37378__$1;var lc = cljs.core.get.call(null,map__37378__$1,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212));var label = cljs.core.get.call(null,map__37378__$1,new cljs.core.Keyword(null,"label","label",1718410804));var child = G__37371;var G__37377__$1 = G__37377;var child__$1 = child;while(true){
var map__37379 = G__37377__$1;var map__37379__$1 = ((cljs.core.seq_QMARK_.call(null,map__37379))?cljs.core.apply.call(null,cljs.core.hash_map,map__37379):map__37379);var input__$1 = map__37379__$1;var lc__$1 = cljs.core.get.call(null,map__37379__$1,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212));var label__$1 = cljs.core.get.call(null,map__37379__$1,new cljs.core.Keyword(null,"label","label",1718410804));var child__$2 = child__$1;var classes = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"control-label","control-label",1226436372),!(om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input__$1))], null),(cljs.core.truth_(lc__$1)?new cljs.core.PersistentArrayMap.fromArray([lc__$1,cljs.core.boolean$.call(null,lc__$1)], true, false):null));if(cljs.core.truth_(label__$1))
{return cljs.core.apply.call(null,React.DOM.label,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,classes))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[child__$2,label__$1],null))));
} else
{return child__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37396 = output_checker37369_37387.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37396))
{var error__13963__auto___37397 = temp__4126__auto___37396;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37397)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37362_37381,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37397], null));
} else
{}
} else
{}
return o__13964__auto__;
});
render_label = function(G__37370,G__37371){
switch(arguments.length){
case 1:
return render_label__1.call(this,G__37370);
case 2:
return render_label__2.call(this,G__37370,G__37371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
render_label.cljs$core$IFn$_invoke$arity$1 = render_label__1;
render_label.cljs$core$IFn$_invoke$arity$2 = render_label__2;
return render_label;
})()
;})(ufv___37380,output_schema37362_37381,input_schema37363_37382,input_schema37367_37383,input_checker37364_37384,output_checker37365_37385,input_checker37368_37386,output_checker37369_37387))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_label),schema.core.make_fn_schema.call(null,output_schema37362_37381,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37363_37382,input_schema37367_37383], null)));
var ufv___37412 = schema.utils.use_fn_validation;var output_schema37398_37413 = schema.core.Any;var input_schema37399_37414 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker37400_37415 = schema.core.checker.call(null,input_schema37399_37414);var output_checker37401_37416 = schema.core.checker.call(null,output_schema37398_37413);/**
* Inputs: [{wc :wrapper-classname} :- Input child]
*/
om_bootstrap.input.render_wrapper = ((function (ufv___37412,output_schema37398_37413,input_schema37399_37414,input_checker37400_37415,output_checker37401_37416){
return (function render_wrapper(G__37402,G__37403){var validate__13961__auto__ = ufv___37412.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37417 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37402,G__37403], null);var temp__4126__auto___37418 = input_checker37400_37415.call(null,args__13962__auto___37417);if(cljs.core.truth_(temp__4126__auto___37418))
{var error__13963__auto___37419 = temp__4126__auto___37418;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-wrapper","render-wrapper",79817165,null),cljs.core.pr_str.call(null,error__13963__auto___37419)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37399_37414,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37417,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37419], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37409 = G__37402;var map__37410 = G__37409;var map__37410__$1 = ((cljs.core.seq_QMARK_.call(null,map__37410))?cljs.core.apply.call(null,cljs.core.hash_map,map__37410):map__37410);var wc = cljs.core.get.call(null,map__37410__$1,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866));var child = G__37403;var G__37409__$1 = G__37409;var child__$1 = child;while(true){
var map__37411 = G__37409__$1;var map__37411__$1 = ((cljs.core.seq_QMARK_.call(null,map__37411))?cljs.core.apply.call(null,cljs.core.hash_map,map__37411):map__37411);var wc__$1 = cljs.core.get.call(null,map__37411__$1,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866));var child__$2 = child__$1;if(cljs.core.truth_(wc__$1))
{return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,wc__$1)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[child__$2],null))));
} else
{return child__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37420 = output_checker37401_37416.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37420))
{var error__13963__auto___37421 = temp__4126__auto___37420;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-wrapper","render-wrapper",79817165,null),cljs.core.pr_str.call(null,error__13963__auto___37421)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37398_37413,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37421], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37412,output_schema37398_37413,input_schema37399_37414,input_checker37400_37415,output_checker37401_37416))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_wrapper),schema.core.make_fn_schema.call(null,output_schema37398_37413,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37399_37414], null)));
var ufv___37436 = schema.utils.use_fn_validation;var output_schema37422_37437 = om_bootstrap.types.Component;var input_schema37423_37438 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37424_37439 = schema.core.checker.call(null,input_schema37423_37438);var output_checker37425_37440 = schema.core.checker.call(null,output_schema37422_37437);/**
* Inputs: [{bs-style :bs-style, cn :group-classname, :as input} :- Input children]
* Returns: t/Component
* 
* Wraps the entire form group.
*/
om_bootstrap.input.render_form_group = ((function (ufv___37436,output_schema37422_37437,input_schema37423_37438,input_checker37424_37439,output_checker37425_37440){
return (function render_form_group(G__37426,G__37427){var validate__13961__auto__ = ufv___37436.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37441 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37426,G__37427], null);var temp__4126__auto___37442 = input_checker37424_37439.call(null,args__13962__auto___37441);if(cljs.core.truth_(temp__4126__auto___37442))
{var error__13963__auto___37443 = temp__4126__auto___37442;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-form-group","render-form-group",2039718866,null),cljs.core.pr_str.call(null,error__13963__auto___37443)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37423_37438,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37441,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37443], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37433 = G__37426;var map__37434 = G__37433;var map__37434__$1 = ((cljs.core.seq_QMARK_.call(null,map__37434))?cljs.core.apply.call(null,cljs.core.hash_map,map__37434):map__37434);var input = map__37434__$1;var bs_style = cljs.core.get.call(null,map__37434__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var cn = cljs.core.get.call(null,map__37434__$1,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816));var children = G__37427;var G__37433__$1 = G__37433;var children__$1 = children;while(true){
var map__37435 = G__37433__$1;var map__37435__$1 = ((cljs.core.seq_QMARK_.call(null,map__37435))?cljs.core.apply.call(null,cljs.core.hash_map,map__37435):map__37435);var input__$1 = map__37435__$1;var bs_style__$1 = cljs.core.get.call(null,map__37435__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var cn__$1 = cljs.core.get.call(null,map__37435__$1,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816));var children__$2 = children__$1;var classes = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"form-group","form-group",-267875328),cljs.core.not.call(null,new cljs.core.Keyword(null,"skip-form-group?","skip-form-group?",210862261).cljs$core$IFn$_invoke$arity$1(input__$1)),new cljs.core.Keyword(null,"has-feedback","has-feedback",1328001802),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821).cljs$core$IFn$_invoke$arity$1(input__$1)),new cljs.core.Keyword(null,"has-success","has-success",685004255),cljs.core._EQ_.call(null,"success",bs_style__$1),new cljs.core.Keyword(null,"has-warning","has-warning",1993894136),cljs.core._EQ_.call(null,"warning",bs_style__$1),new cljs.core.Keyword(null,"has-error","has-error",-786302929),cljs.core._EQ_.call(null,"error",bs_style__$1)], null),(cljs.core.truth_(cn__$1)?new cljs.core.PersistentArrayMap.fromArray([cn__$1,cljs.core.boolean$.call(null,cn__$1)], true, false):null));return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,classes))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children__$2],null))));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37444 = output_checker37425_37440.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37444))
{var error__13963__auto___37445 = temp__4126__auto___37444;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-form-group","render-form-group",2039718866,null),cljs.core.pr_str.call(null,error__13963__auto___37445)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37422_37437,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37445], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37436,output_schema37422_37437,input_schema37423_37438,input_checker37424_37439,output_checker37425_37440))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_form_group),schema.core.make_fn_schema.call(null,output_schema37422_37437,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37423_37438], null)));
var ufv___37455 = schema.utils.use_fn_validation;var output_schema37446_37456 = om_bootstrap.types.Component;var input_schema37447_37457 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"attrs","attrs",-450137186,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37448_37458 = schema.core.checker.call(null,input_schema37447_37457);var output_checker37449_37459 = schema.core.checker.call(null,output_schema37446_37456);/**
* Inputs: [input :- Input attrs children]
* Returns: t/Component
*/
om_bootstrap.input.render_input = ((function (ufv___37455,output_schema37446_37456,input_schema37447_37457,input_checker37448_37458,output_checker37449_37459){
return (function render_input(G__37450,G__37451,G__37452){var validate__13961__auto__ = ufv___37455.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37460 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37450,G__37451,G__37452], null);var temp__4126__auto___37461 = input_checker37448_37458.call(null,args__13962__auto___37460);if(cljs.core.truth_(temp__4126__auto___37461))
{var error__13963__auto___37462 = temp__4126__auto___37461;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-input","render-input",243083212,null),cljs.core.pr_str.call(null,error__13963__auto___37462)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37447_37457,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37460,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37462], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var input = G__37450;var attrs = G__37451;var children = G__37452;while(true){
var props = ((function (validate__13961__auto__,ufv___37455,output_schema37446_37456,input_schema37447_37457,input_checker37448_37458,output_checker37449_37459){
return (function (klass){return om_bootstrap.util.merge_props.call(null,attrs,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),klass,new cljs.core.Keyword(null,"ref","ref",1289896967),"input",new cljs.core.Keyword(null,"key","key",-1516042587),"input"], null));
});})(validate__13961__auto__,ufv___37455,output_schema37446_37456,input_schema37447_37457,input_checker37448_37458,output_checker37449_37459))
;if(cljs.core.not.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input)))
{return children;
} else
{var G__37454 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input);switch (G__37454) {
case "select":
return om_tools.dom.element.call(null,React.DOM.select,props.call(null,"form-control"),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children],null)));

break;
case "textarea":
return om_tools.dom.element.call(null,om.dom.textarea,props.call(null,"form-control"),cljs.core.PersistentVector.EMPTY);

break;
case "static":
return om_tools.dom.element.call(null,React.DOM.p,props.call(null,"form-control-static"),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs)],null)));

break;
default:
return om_tools.dom.element.call(null,om.dom.input,cljs.core.assoc.call(null,props.call(null,((om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input))?"":"form-control")),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input)),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children],null)));

}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37464 = output_checker37449_37459.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37464))
{var error__13963__auto___37465 = temp__4126__auto___37464;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-input","render-input",243083212,null),cljs.core.pr_str.call(null,error__13963__auto___37465)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37446_37456,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37465], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37455,output_schema37446_37456,input_schema37447_37457,input_checker37448_37458,output_checker37449_37459))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_input),schema.core.make_fn_schema.call(null,output_schema37446_37456,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37447_37457], null)));
var ufv___37474 = schema.utils.use_fn_validation;var output_schema37466_37475 = om_bootstrap.types.Component;var input_schema37467_37476 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"opts","opts",1795607228,null)),schema.core.Any], null);var input_checker37468_37477 = schema.core.checker.call(null,input_schema37467_37476);var output_checker37469_37478 = schema.core.checker.call(null,output_schema37466_37475);/**
* Inputs: [opts :- Input & children]
* Returns: t/Component
* 
* Returns an input component. This currently does NOT handle any of
* the default values or validation messages that we'll need to make
* this work, though.
* @param {...*} var_args
*/
om_bootstrap.input.input = ((function (ufv___37474,output_schema37466_37475,input_schema37467_37476,input_checker37468_37477,output_checker37469_37478){
return (function() { 
var input__delegate = function (G__37470,rest37471){var validate__13961__auto__ = ufv___37474.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37479 = cljs.core.list_STAR_.call(null,G__37470,rest37471);var temp__4126__auto___37480 = input_checker37468_37477.call(null,args__13962__auto___37479);if(cljs.core.truth_(temp__4126__auto___37480))
{var error__13963__auto___37481 = temp__4126__auto___37480;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"input","input",-2097503808,null),cljs.core.pr_str.call(null,error__13963__auto___37481)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37467_37476,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37479,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37481], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var opts = G__37470;var children = rest37471;while(true){
var vec__37473 = om_bootstrap.types.separate.call(null,om_bootstrap.input.Input,opts);var input__$1 = cljs.core.nth.call(null,vec__37473,(0),null);var attrs = cljs.core.nth.call(null,vec__37473,(1),null);if(om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input__$1))
{return om_bootstrap.input.render_form_group.call(null,input__$1,om_bootstrap.input.render_wrapper.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.checkbox_or_radio_wrapper.call(null,input__$1,om_bootstrap.input.render_label.call(null,input__$1,om_bootstrap.input.render_input.call(null,input__$1,attrs,children))),om_bootstrap.input.render_help.call(null,new cljs.core.Keyword(null,"help","help",-439233446).cljs$core$IFn$_invoke$arity$1(input__$1))], null)));
} else
{return om_bootstrap.input.render_form_group.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.render_label.call(null,input__$1),om_bootstrap.input.render_wrapper.call(null,input__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.render_input_group.call(null,cljs.core.select_keys.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"addon-before","addon-before",-500360384),new cljs.core.Keyword(null,"addon-after","addon-after",634985306)], null)),om_bootstrap.input.render_input.call(null,input__$1,attrs,children)),om_bootstrap.input.render_icon.call(null,cljs.core.select_keys.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821),new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)], null))),om_bootstrap.input.render_help.call(null,new cljs.core.Keyword(null,"help","help",-439233446).cljs$core$IFn$_invoke$arity$1(input__$1))], null))], null));
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37482 = output_checker37469_37478.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37482))
{var error__13963__auto___37483 = temp__4126__auto___37482;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"input","input",-2097503808,null),cljs.core.pr_str.call(null,error__13963__auto___37483)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37466_37475,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37483], null));
} else
{}
} else
{}
return o__13964__auto__;
};
var input = function (G__37470,var_args){
var rest37471 = null;if (arguments.length > 1) {
  rest37471 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return input__delegate.call(this,G__37470,rest37471);};
input.cljs$lang$maxFixedArity = 1;
input.cljs$lang$applyTo = (function (arglist__37484){
var G__37470 = cljs.core.first(arglist__37484);
var rest37471 = cljs.core.rest(arglist__37484);
return input__delegate(G__37470,rest37471);
});
input.cljs$core$IFn$_invoke$arity$variadic = input__delegate;
return input;
})()
;})(ufv___37474,output_schema37466_37475,input_schema37467_37476,input_checker37468_37477,output_checker37469_37478))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.input),schema.core.make_fn_schema.call(null,output_schema37466_37475,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37467_37476], null)));
var ufv___37494 = schema.utils.use_fn_validation;var output_schema37485_37495 = om_bootstrap.types.Component;var input_schema37486_37496 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Radio,new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_checker37487_37497 = schema.core.checker.call(null,input_schema37486_37496);var output_checker37488_37498 = schema.core.checker.call(null,output_schema37485_37495);/**
* Inputs: [opts :- Radio]
* Returns: t/Component
* 
* Generates a radio button entry, to place into a radio button
* grouping.
*/
om_bootstrap.input.radio_option = ((function (ufv___37494,output_schema37485_37495,input_schema37486_37496,input_checker37487_37497,output_checker37488_37498){
return (function radio_option(G__37489){var validate__13961__auto__ = ufv___37494.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37499 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37489], null);var temp__4126__auto___37500 = input_checker37487_37497.call(null,args__13962__auto___37499);if(cljs.core.truth_(temp__4126__auto___37500))
{var error__13963__auto___37501 = temp__4126__auto___37500;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"radio-option","radio-option",726779012,null),cljs.core.pr_str.call(null,error__13963__auto___37501)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37486_37496,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37499,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37501], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var opts = G__37489;while(true){
var vec__37492 = om_bootstrap.types.separate.call(null,om_bootstrap.input.Radio,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ref","ref",1289896967),"input",new cljs.core.Keyword(null,"key","key",-1516042587),"input",new cljs.core.Keyword(null,"type","type",1174270348),"radio"], null));var bs = cljs.core.nth.call(null,vec__37492,(0),null);var props = cljs.core.nth.call(null,vec__37492,(1),null);var map__37493 = bs;var map__37493__$1 = ((cljs.core.seq_QMARK_.call(null,map__37493))?cljs.core.apply.call(null,cljs.core.hash_map,map__37493):map__37493);var inline_QMARK_ = cljs.core.get.call(null,map__37493__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));var checked_QMARK_ = cljs.core.get.call(null,map__37493__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));var label = cljs.core.get.call(null,map__37493__$1,new cljs.core.Keyword(null,"label","label",1718410804));var core = om_tools.dom.element.call(null,om.dom.input,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_),cljs.core.PersistentVector.EMPTY);if(cljs.core.truth_(inline_QMARK_))
{return cljs.core.apply.call(null,React.DOM.label,{"className": "radio-inline"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[core,label],null))));
} else
{return cljs.core.apply.call(null,React.DOM.div,{"className": "radio"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.call(null,React.DOM.label,{},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[core,label],null))))],null))));
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37502 = output_checker37488_37498.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37502))
{var error__13963__auto___37503 = temp__4126__auto___37502;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"radio-option","radio-option",726779012,null),cljs.core.pr_str.call(null,error__13963__auto___37503)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37485_37495,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37503], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37494,output_schema37485_37495,input_schema37486_37496,input_checker37487_37497,output_checker37488_37498))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.radio_option),schema.core.make_fn_schema.call(null,output_schema37485_37495,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37486_37496], null)));
var ufv___37526 = schema.utils.use_fn_validation;var output_schema37504_37527 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.types.Component], null);var input_schema37505_37528 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"header","header",1759972661,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.pair.call(null,schema.core.Str,"option value",schema.core.Str,"option label")], null),new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_checker37506_37529 = schema.core.checker.call(null,input_schema37505_37528);var output_checker37507_37530 = schema.core.checker.call(null,output_schema37504_37527);/**
* Inputs: [header :- s/Str opts :- [(s/pair s/Str "option value" s/Str "option label")]]
* Returns: [t/Component]
* 
* Returns a sequence of options for use as the children of a select
* input.
*/
om_bootstrap.input.options = ((function (ufv___37526,output_schema37504_37527,input_schema37505_37528,input_checker37506_37529,output_checker37507_37530){
return (function options(G__37508,G__37509){var validate__13961__auto__ = ufv___37526.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37531 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37508,G__37509], null);var temp__4126__auto___37532 = input_checker37506_37529.call(null,args__13962__auto___37531);if(cljs.core.truth_(temp__4126__auto___37532))
{var error__13963__auto___37533 = temp__4126__auto___37532;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"options","options",1740170016,null),cljs.core.pr_str.call(null,error__13963__auto___37533)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37505_37528,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37531,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37533], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var header = G__37508;var opts = G__37509;while(true){
return cljs.core.cons.call(null,cljs.core.apply.call(null,om.dom.option,{"value": ""},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[header],null)))),(function (){var iter__4266__auto__ = ((function (validate__13961__auto__,ufv___37526,output_schema37504_37527,input_schema37505_37528,input_checker37506_37529,output_checker37507_37530){
return (function iter__37518(s__37519){return (new cljs.core.LazySeq(null,((function (validate__13961__auto__,ufv___37526,output_schema37504_37527,input_schema37505_37528,input_checker37506_37529,output_checker37507_37530){
return (function (){var s__37519__$1 = s__37519;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__37519__$1);if(temp__4126__auto__)
{var s__37519__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__37519__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__37519__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__37521 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__37520 = (0);while(true){
if((i__37520 < size__4265__auto__))
{var vec__37524 = cljs.core._nth.call(null,c__4264__auto__,i__37520);var v = cljs.core.nth.call(null,vec__37524,(0),null);var label = cljs.core.nth.call(null,vec__37524,(1),null);cljs.core.chunk_append.call(null,b__37521,cljs.core.apply.call(null,om.dom.option,{"value": om_tools.dom.format_opts.call(null,v)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[label],null)))));
{
var G__37534 = (i__37520 + (1));
i__37520 = G__37534;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37521),iter__37518.call(null,cljs.core.chunk_rest.call(null,s__37519__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37521),null);
}
} else
{var vec__37525 = cljs.core.first.call(null,s__37519__$2);var v = cljs.core.nth.call(null,vec__37525,(0),null);var label = cljs.core.nth.call(null,vec__37525,(1),null);return cljs.core.cons.call(null,cljs.core.apply.call(null,om.dom.option,{"value": om_tools.dom.format_opts.call(null,v)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[label],null)))),iter__37518.call(null,cljs.core.rest.call(null,s__37519__$2)));
}
} else
{return null;
}
break;
}
});})(validate__13961__auto__,ufv___37526,output_schema37504_37527,input_schema37505_37528,input_checker37506_37529,output_checker37507_37530))
,null,null));
});})(validate__13961__auto__,ufv___37526,output_schema37504_37527,input_schema37505_37528,input_checker37506_37529,output_checker37507_37530))
;return iter__4266__auto__.call(null,opts);
})());
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37535 = output_checker37507_37530.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37535))
{var error__13963__auto___37536 = temp__4126__auto___37535;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"options","options",1740170016,null),cljs.core.pr_str.call(null,error__13963__auto___37536)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37504_37527,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37536], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37526,output_schema37504_37527,input_schema37505_37528,input_checker37506_37529,output_checker37507_37530))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.options),schema.core.make_fn_schema.call(null,output_schema37504_37527,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37505_37528], null)));

//# sourceMappingURL=input.js.map