// Compiled by ClojureScript 0.0-2277
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t31600 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31600 = (function (f,fn_handler,meta31601){
this.f = f;
this.fn_handler = fn_handler;
this.meta31601 = meta31601;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31600.cljs$lang$type = true;
cljs.core.async.t31600.cljs$lang$ctorStr = "cljs.core.async/t31600";
cljs.core.async.t31600.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31600");
});
cljs.core.async.t31600.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31600.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t31600.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t31600.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31602){var self__ = this;
var _31602__$1 = this;return self__.meta31601;
});
cljs.core.async.t31600.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31602,meta31601__$1){var self__ = this;
var _31602__$1 = this;return (new cljs.core.async.t31600(self__.f,self__.fn_handler,meta31601__$1));
});
cljs.core.async.__GT_t31600 = (function __GT_t31600(f__$1,fn_handler__$1,meta31601){return (new cljs.core.async.t31600(f__$1,fn_handler__$1,meta31601));
});
}
return (new cljs.core.async.t31600(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__31604 = buff;if(G__31604)
{var bit__4191__auto__ = null;if(cljs.core.truth_((function (){var or__3541__auto__ = bit__4191__auto__;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return G__31604.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__31604.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__31604);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__31604);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error(("Assert failed: <! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_31605 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_31605);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_31605,ret){
return (function (){return fn1.call(null,val_31605);
});})(val_31605,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error(("Assert failed: >! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4397__auto___31606 = n;var x_31607 = (0);while(true){
if((x_31607 < n__4397__auto___31606))
{(a[x_31607] = (0));
{
var G__31608 = (x_31607 + (1));
x_31607 = G__31608;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__31609 = (i + (1));
i = G__31609;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t31613 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31613 = (function (flag,alt_flag,meta31614){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta31614 = meta31614;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31613.cljs$lang$type = true;
cljs.core.async.t31613.cljs$lang$ctorStr = "cljs.core.async/t31613";
cljs.core.async.t31613.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31613");
});})(flag))
;
cljs.core.async.t31613.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31613.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t31613.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t31613.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31615){var self__ = this;
var _31615__$1 = this;return self__.meta31614;
});})(flag))
;
cljs.core.async.t31613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31615,meta31614__$1){var self__ = this;
var _31615__$1 = this;return (new cljs.core.async.t31613(self__.flag,self__.alt_flag,meta31614__$1));
});})(flag))
;
cljs.core.async.__GT_t31613 = ((function (flag){
return (function __GT_t31613(flag__$1,alt_flag__$1,meta31614){return (new cljs.core.async.t31613(flag__$1,alt_flag__$1,meta31614));
});})(flag))
;
}
return (new cljs.core.async.t31613(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t31619 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31619 = (function (cb,flag,alt_handler,meta31620){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta31620 = meta31620;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31619.cljs$lang$type = true;
cljs.core.async.t31619.cljs$lang$ctorStr = "cljs.core.async/t31619";
cljs.core.async.t31619.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31619");
});
cljs.core.async.t31619.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31619.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t31619.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t31619.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31621){var self__ = this;
var _31621__$1 = this;return self__.meta31620;
});
cljs.core.async.t31619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31621,meta31620__$1){var self__ = this;
var _31621__$1 = this;return (new cljs.core.async.t31619(self__.cb,self__.flag,self__.alt_handler,meta31620__$1));
});
cljs.core.async.__GT_t31619 = (function __GT_t31619(cb__$1,flag__$1,alt_handler__$1,meta31620){return (new cljs.core.async.t31619(cb__$1,flag__$1,alt_handler__$1,meta31620));
});
}
return (new cljs.core.async.t31619(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31622_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31622_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31623_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31623_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3541__auto__ = wport;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__31624 = (i + (1));
i = G__31624;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3541__auto__ = ret;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__3529__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3529__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__31625){var map__31627 = p__31625;var map__31627__$1 = ((cljs.core.seq_QMARK_.call(null,map__31627))?cljs.core.apply.call(null,cljs.core.hash_map,map__31627):map__31627);var opts = map__31627__$1;if(null)
{return null;
} else
{throw (new Error(("Assert failed: alts! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
};
var alts_BANG_ = function (ports,var_args){
var p__31625 = null;if (arguments.length > 1) {
  p__31625 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__31625);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__31628){
var ports = cljs.core.first(arglist__31628);
var p__31625 = cljs.core.rest(arglist__31628);
return alts_BANG___delegate(ports,p__31625);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t31636 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31636 = (function (ch,f,map_LT_,meta31637){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta31637 = meta31637;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31636.cljs$lang$type = true;
cljs.core.async.t31636.cljs$lang$ctorStr = "cljs.core.async/t31636";
cljs.core.async.t31636.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31636");
});
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t31639 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31639 = (function (fn1,_,meta31637,ch,f,map_LT_,meta31640){
this.fn1 = fn1;
this._ = _;
this.meta31637 = meta31637;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta31640 = meta31640;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31639.cljs$lang$type = true;
cljs.core.async.t31639.cljs$lang$ctorStr = "cljs.core.async/t31639";
cljs.core.async.t31639.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31639");
});})(___$1))
;
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t31639.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__31629_SHARP_){return f1.call(null,(((p1__31629_SHARP_ == null))?null:self__.f.call(null,p1__31629_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t31639.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31641){var self__ = this;
var _31641__$1 = this;return self__.meta31640;
});})(___$1))
;
cljs.core.async.t31639.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31641,meta31640__$1){var self__ = this;
var _31641__$1 = this;return (new cljs.core.async.t31639(self__.fn1,self__._,self__.meta31637,self__.ch,self__.f,self__.map_LT_,meta31640__$1));
});})(___$1))
;
cljs.core.async.__GT_t31639 = ((function (___$1){
return (function __GT_t31639(fn1__$1,___$2,meta31637__$1,ch__$2,f__$2,map_LT___$2,meta31640){return (new cljs.core.async.t31639(fn1__$1,___$2,meta31637__$1,ch__$2,f__$2,map_LT___$2,meta31640));
});})(___$1))
;
}
return (new cljs.core.async.t31639(fn1,___$1,self__.meta31637,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3529__auto__ = ret;if(cljs.core.truth_(and__3529__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3529__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31636.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t31636.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31638){var self__ = this;
var _31638__$1 = this;return self__.meta31637;
});
cljs.core.async.t31636.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31638,meta31637__$1){var self__ = this;
var _31638__$1 = this;return (new cljs.core.async.t31636(self__.ch,self__.f,self__.map_LT_,meta31637__$1));
});
cljs.core.async.__GT_t31636 = (function __GT_t31636(ch__$1,f__$1,map_LT___$1,meta31637){return (new cljs.core.async.t31636(ch__$1,f__$1,map_LT___$1,meta31637));
});
}
return (new cljs.core.async.t31636(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t31645 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31645 = (function (ch,f,map_GT_,meta31646){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta31646 = meta31646;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31645.cljs$lang$type = true;
cljs.core.async.t31645.cljs$lang$ctorStr = "cljs.core.async/t31645";
cljs.core.async.t31645.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31645");
});
cljs.core.async.t31645.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31645.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t31645.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31645.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t31645.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31645.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31645.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31647){var self__ = this;
var _31647__$1 = this;return self__.meta31646;
});
cljs.core.async.t31645.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31647,meta31646__$1){var self__ = this;
var _31647__$1 = this;return (new cljs.core.async.t31645(self__.ch,self__.f,self__.map_GT_,meta31646__$1));
});
cljs.core.async.__GT_t31645 = (function __GT_t31645(ch__$1,f__$1,map_GT___$1,meta31646){return (new cljs.core.async.t31645(ch__$1,f__$1,map_GT___$1,meta31646));
});
}
return (new cljs.core.async.t31645(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t31651 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31651 = (function (ch,p,filter_GT_,meta31652){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta31652 = meta31652;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31651.cljs$lang$type = true;
cljs.core.async.t31651.cljs$lang$ctorStr = "cljs.core.async/t31651";
cljs.core.async.t31651.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31651");
});
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31651.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t31651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31653){var self__ = this;
var _31653__$1 = this;return self__.meta31652;
});
cljs.core.async.t31651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31653,meta31652__$1){var self__ = this;
var _31653__$1 = this;return (new cljs.core.async.t31651(self__.ch,self__.p,self__.filter_GT_,meta31652__$1));
});
cljs.core.async.__GT_t31651 = (function __GT_t31651(ch__$1,p__$1,filter_GT___$1,meta31652){return (new cljs.core.async.t31651(ch__$1,p__$1,filter_GT___$1,meta31652));
});
}
return (new cljs.core.async.t31651(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___31736 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___31736,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___31736,out){
return (function (state_31715){var state_val_31716 = (state_31715[(1)]);if((state_val_31716 === (7)))
{var inst_31711 = (state_31715[(2)]);var state_31715__$1 = state_31715;var statearr_31717_31737 = state_31715__$1;(statearr_31717_31737[(2)] = inst_31711);
(statearr_31717_31737[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (1)))
{var state_31715__$1 = state_31715;var statearr_31718_31738 = state_31715__$1;(statearr_31718_31738[(2)] = null);
(statearr_31718_31738[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (4)))
{var inst_31697 = (state_31715[(7)]);var inst_31697__$1 = (state_31715[(2)]);var inst_31698 = (inst_31697__$1 == null);var state_31715__$1 = (function (){var statearr_31719 = state_31715;(statearr_31719[(7)] = inst_31697__$1);
return statearr_31719;
})();if(cljs.core.truth_(inst_31698))
{var statearr_31720_31739 = state_31715__$1;(statearr_31720_31739[(1)] = (5));
} else
{var statearr_31721_31740 = state_31715__$1;(statearr_31721_31740[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (6)))
{var inst_31697 = (state_31715[(7)]);var inst_31702 = p.call(null,inst_31697);var state_31715__$1 = state_31715;if(cljs.core.truth_(inst_31702))
{var statearr_31722_31741 = state_31715__$1;(statearr_31722_31741[(1)] = (8));
} else
{var statearr_31723_31742 = state_31715__$1;(statearr_31723_31742[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (3)))
{var inst_31713 = (state_31715[(2)]);var state_31715__$1 = state_31715;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31715__$1,inst_31713);
} else
{if((state_val_31716 === (2)))
{var state_31715__$1 = state_31715;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31715__$1,(4),ch);
} else
{if((state_val_31716 === (11)))
{var inst_31705 = (state_31715[(2)]);var state_31715__$1 = state_31715;var statearr_31724_31743 = state_31715__$1;(statearr_31724_31743[(2)] = inst_31705);
(statearr_31724_31743[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (9)))
{var state_31715__$1 = state_31715;var statearr_31725_31744 = state_31715__$1;(statearr_31725_31744[(2)] = null);
(statearr_31725_31744[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (5)))
{var inst_31700 = cljs.core.async.close_BANG_.call(null,out);var state_31715__$1 = state_31715;var statearr_31726_31745 = state_31715__$1;(statearr_31726_31745[(2)] = inst_31700);
(statearr_31726_31745[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (10)))
{var inst_31708 = (state_31715[(2)]);var state_31715__$1 = (function (){var statearr_31727 = state_31715;(statearr_31727[(8)] = inst_31708);
return statearr_31727;
})();var statearr_31728_31746 = state_31715__$1;(statearr_31728_31746[(2)] = null);
(statearr_31728_31746[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31716 === (8)))
{var inst_31697 = (state_31715[(7)]);var state_31715__$1 = state_31715;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31715__$1,(11),out,inst_31697);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___31736,out))
;return ((function (switch__7350__auto__,c__7365__auto___31736,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_31732 = [null,null,null,null,null,null,null,null,null];(statearr_31732[(0)] = state_machine__7351__auto__);
(statearr_31732[(1)] = (1));
return statearr_31732;
});
var state_machine__7351__auto____1 = (function (state_31715){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_31715);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e31733){if((e31733 instanceof Object))
{var ex__7354__auto__ = e31733;var statearr_31734_31747 = state_31715;(statearr_31734_31747[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31715);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e31733;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__31748 = state_31715;
state_31715 = G__31748;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_31715){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_31715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___31736,out))
})();var state__7367__auto__ = (function (){var statearr_31735 = f__7366__auto__.call(null);(statearr_31735[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___31736);
return statearr_31735;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___31736,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_31914){var state_val_31915 = (state_31914[(1)]);if((state_val_31915 === (7)))
{var inst_31910 = (state_31914[(2)]);var state_31914__$1 = state_31914;var statearr_31916_31957 = state_31914__$1;(statearr_31916_31957[(2)] = inst_31910);
(statearr_31916_31957[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (20)))
{var inst_31880 = (state_31914[(7)]);var inst_31891 = (state_31914[(2)]);var inst_31892 = cljs.core.next.call(null,inst_31880);var inst_31866 = inst_31892;var inst_31867 = null;var inst_31868 = (0);var inst_31869 = (0);var state_31914__$1 = (function (){var statearr_31917 = state_31914;(statearr_31917[(8)] = inst_31866);
(statearr_31917[(9)] = inst_31869);
(statearr_31917[(10)] = inst_31867);
(statearr_31917[(11)] = inst_31891);
(statearr_31917[(12)] = inst_31868);
return statearr_31917;
})();var statearr_31918_31958 = state_31914__$1;(statearr_31918_31958[(2)] = null);
(statearr_31918_31958[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (1)))
{var state_31914__$1 = state_31914;var statearr_31919_31959 = state_31914__$1;(statearr_31919_31959[(2)] = null);
(statearr_31919_31959[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (4)))
{var inst_31855 = (state_31914[(13)]);var inst_31855__$1 = (state_31914[(2)]);var inst_31856 = (inst_31855__$1 == null);var state_31914__$1 = (function (){var statearr_31920 = state_31914;(statearr_31920[(13)] = inst_31855__$1);
return statearr_31920;
})();if(cljs.core.truth_(inst_31856))
{var statearr_31921_31960 = state_31914__$1;(statearr_31921_31960[(1)] = (5));
} else
{var statearr_31922_31961 = state_31914__$1;(statearr_31922_31961[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (15)))
{var state_31914__$1 = state_31914;var statearr_31926_31962 = state_31914__$1;(statearr_31926_31962[(2)] = null);
(statearr_31926_31962[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (21)))
{var state_31914__$1 = state_31914;var statearr_31927_31963 = state_31914__$1;(statearr_31927_31963[(2)] = null);
(statearr_31927_31963[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (13)))
{var inst_31866 = (state_31914[(8)]);var inst_31869 = (state_31914[(9)]);var inst_31867 = (state_31914[(10)]);var inst_31868 = (state_31914[(12)]);var inst_31876 = (state_31914[(2)]);var inst_31877 = (inst_31869 + (1));var tmp31923 = inst_31866;var tmp31924 = inst_31867;var tmp31925 = inst_31868;var inst_31866__$1 = tmp31923;var inst_31867__$1 = tmp31924;var inst_31868__$1 = tmp31925;var inst_31869__$1 = inst_31877;var state_31914__$1 = (function (){var statearr_31928 = state_31914;(statearr_31928[(8)] = inst_31866__$1);
(statearr_31928[(9)] = inst_31869__$1);
(statearr_31928[(10)] = inst_31867__$1);
(statearr_31928[(14)] = inst_31876);
(statearr_31928[(12)] = inst_31868__$1);
return statearr_31928;
})();var statearr_31929_31964 = state_31914__$1;(statearr_31929_31964[(2)] = null);
(statearr_31929_31964[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (22)))
{var state_31914__$1 = state_31914;var statearr_31930_31965 = state_31914__$1;(statearr_31930_31965[(2)] = null);
(statearr_31930_31965[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (6)))
{var inst_31855 = (state_31914[(13)]);var inst_31864 = f.call(null,inst_31855);var inst_31865 = cljs.core.seq.call(null,inst_31864);var inst_31866 = inst_31865;var inst_31867 = null;var inst_31868 = (0);var inst_31869 = (0);var state_31914__$1 = (function (){var statearr_31931 = state_31914;(statearr_31931[(8)] = inst_31866);
(statearr_31931[(9)] = inst_31869);
(statearr_31931[(10)] = inst_31867);
(statearr_31931[(12)] = inst_31868);
return statearr_31931;
})();var statearr_31932_31966 = state_31914__$1;(statearr_31932_31966[(2)] = null);
(statearr_31932_31966[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (17)))
{var inst_31880 = (state_31914[(7)]);var inst_31884 = cljs.core.chunk_first.call(null,inst_31880);var inst_31885 = cljs.core.chunk_rest.call(null,inst_31880);var inst_31886 = cljs.core.count.call(null,inst_31884);var inst_31866 = inst_31885;var inst_31867 = inst_31884;var inst_31868 = inst_31886;var inst_31869 = (0);var state_31914__$1 = (function (){var statearr_31933 = state_31914;(statearr_31933[(8)] = inst_31866);
(statearr_31933[(9)] = inst_31869);
(statearr_31933[(10)] = inst_31867);
(statearr_31933[(12)] = inst_31868);
return statearr_31933;
})();var statearr_31934_31967 = state_31914__$1;(statearr_31934_31967[(2)] = null);
(statearr_31934_31967[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (3)))
{var inst_31912 = (state_31914[(2)]);var state_31914__$1 = state_31914;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31914__$1,inst_31912);
} else
{if((state_val_31915 === (12)))
{var inst_31900 = (state_31914[(2)]);var state_31914__$1 = state_31914;var statearr_31935_31968 = state_31914__$1;(statearr_31935_31968[(2)] = inst_31900);
(statearr_31935_31968[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (2)))
{var state_31914__$1 = state_31914;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31914__$1,(4),in$);
} else
{if((state_val_31915 === (23)))
{var inst_31908 = (state_31914[(2)]);var state_31914__$1 = state_31914;var statearr_31936_31969 = state_31914__$1;(statearr_31936_31969[(2)] = inst_31908);
(statearr_31936_31969[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (19)))
{var inst_31895 = (state_31914[(2)]);var state_31914__$1 = state_31914;var statearr_31937_31970 = state_31914__$1;(statearr_31937_31970[(2)] = inst_31895);
(statearr_31937_31970[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (11)))
{var inst_31880 = (state_31914[(7)]);var inst_31866 = (state_31914[(8)]);var inst_31880__$1 = cljs.core.seq.call(null,inst_31866);var state_31914__$1 = (function (){var statearr_31938 = state_31914;(statearr_31938[(7)] = inst_31880__$1);
return statearr_31938;
})();if(inst_31880__$1)
{var statearr_31939_31971 = state_31914__$1;(statearr_31939_31971[(1)] = (14));
} else
{var statearr_31940_31972 = state_31914__$1;(statearr_31940_31972[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (9)))
{var inst_31902 = (state_31914[(2)]);var inst_31903 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_31914__$1 = (function (){var statearr_31941 = state_31914;(statearr_31941[(15)] = inst_31902);
return statearr_31941;
})();if(cljs.core.truth_(inst_31903))
{var statearr_31942_31973 = state_31914__$1;(statearr_31942_31973[(1)] = (21));
} else
{var statearr_31943_31974 = state_31914__$1;(statearr_31943_31974[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (5)))
{var inst_31858 = cljs.core.async.close_BANG_.call(null,out);var state_31914__$1 = state_31914;var statearr_31944_31975 = state_31914__$1;(statearr_31944_31975[(2)] = inst_31858);
(statearr_31944_31975[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (14)))
{var inst_31880 = (state_31914[(7)]);var inst_31882 = cljs.core.chunked_seq_QMARK_.call(null,inst_31880);var state_31914__$1 = state_31914;if(inst_31882)
{var statearr_31945_31976 = state_31914__$1;(statearr_31945_31976[(1)] = (17));
} else
{var statearr_31946_31977 = state_31914__$1;(statearr_31946_31977[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (16)))
{var inst_31898 = (state_31914[(2)]);var state_31914__$1 = state_31914;var statearr_31947_31978 = state_31914__$1;(statearr_31947_31978[(2)] = inst_31898);
(statearr_31947_31978[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31915 === (10)))
{var inst_31869 = (state_31914[(9)]);var inst_31867 = (state_31914[(10)]);var inst_31874 = cljs.core._nth.call(null,inst_31867,inst_31869);var state_31914__$1 = state_31914;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31914__$1,(13),out,inst_31874);
} else
{if((state_val_31915 === (18)))
{var inst_31880 = (state_31914[(7)]);var inst_31889 = cljs.core.first.call(null,inst_31880);var state_31914__$1 = state_31914;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31914__$1,(20),out,inst_31889);
} else
{if((state_val_31915 === (8)))
{var inst_31869 = (state_31914[(9)]);var inst_31868 = (state_31914[(12)]);var inst_31871 = (inst_31869 < inst_31868);var inst_31872 = inst_31871;var state_31914__$1 = state_31914;if(cljs.core.truth_(inst_31872))
{var statearr_31948_31979 = state_31914__$1;(statearr_31948_31979[(1)] = (10));
} else
{var statearr_31949_31980 = state_31914__$1;(statearr_31949_31980[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_31953 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_31953[(0)] = state_machine__7351__auto__);
(statearr_31953[(1)] = (1));
return statearr_31953;
});
var state_machine__7351__auto____1 = (function (state_31914){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_31914);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e31954){if((e31954 instanceof Object))
{var ex__7354__auto__ = e31954;var statearr_31955_31981 = state_31914;(statearr_31955_31981[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31914);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e31954;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__31982 = state_31914;
state_31914 = G__31982;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_31914){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_31914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_31956 = f__7366__auto__.call(null);(statearr_31956[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_31956;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__7365__auto___32077 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32077){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32077){
return (function (state_32053){var state_val_32054 = (state_32053[(1)]);if((state_val_32054 === (7)))
{var inst_32049 = (state_32053[(2)]);var state_32053__$1 = state_32053;var statearr_32055_32078 = state_32053__$1;(statearr_32055_32078[(2)] = inst_32049);
(statearr_32055_32078[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (1)))
{var state_32053__$1 = state_32053;var statearr_32056_32079 = state_32053__$1;(statearr_32056_32079[(2)] = null);
(statearr_32056_32079[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (4)))
{var inst_32032 = (state_32053[(7)]);var inst_32032__$1 = (state_32053[(2)]);var inst_32033 = (inst_32032__$1 == null);var state_32053__$1 = (function (){var statearr_32057 = state_32053;(statearr_32057[(7)] = inst_32032__$1);
return statearr_32057;
})();if(cljs.core.truth_(inst_32033))
{var statearr_32058_32080 = state_32053__$1;(statearr_32058_32080[(1)] = (5));
} else
{var statearr_32059_32081 = state_32053__$1;(statearr_32059_32081[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (13)))
{var state_32053__$1 = state_32053;var statearr_32060_32082 = state_32053__$1;(statearr_32060_32082[(2)] = null);
(statearr_32060_32082[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (6)))
{var inst_32032 = (state_32053[(7)]);var state_32053__$1 = state_32053;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32053__$1,(11),to,inst_32032);
} else
{if((state_val_32054 === (3)))
{var inst_32051 = (state_32053[(2)]);var state_32053__$1 = state_32053;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32053__$1,inst_32051);
} else
{if((state_val_32054 === (12)))
{var state_32053__$1 = state_32053;var statearr_32061_32083 = state_32053__$1;(statearr_32061_32083[(2)] = null);
(statearr_32061_32083[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (2)))
{var state_32053__$1 = state_32053;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32053__$1,(4),from);
} else
{if((state_val_32054 === (11)))
{var inst_32042 = (state_32053[(2)]);var state_32053__$1 = state_32053;if(cljs.core.truth_(inst_32042))
{var statearr_32062_32084 = state_32053__$1;(statearr_32062_32084[(1)] = (12));
} else
{var statearr_32063_32085 = state_32053__$1;(statearr_32063_32085[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (9)))
{var state_32053__$1 = state_32053;var statearr_32064_32086 = state_32053__$1;(statearr_32064_32086[(2)] = null);
(statearr_32064_32086[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (5)))
{var state_32053__$1 = state_32053;if(cljs.core.truth_(close_QMARK_))
{var statearr_32065_32087 = state_32053__$1;(statearr_32065_32087[(1)] = (8));
} else
{var statearr_32066_32088 = state_32053__$1;(statearr_32066_32088[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (14)))
{var inst_32047 = (state_32053[(2)]);var state_32053__$1 = state_32053;var statearr_32067_32089 = state_32053__$1;(statearr_32067_32089[(2)] = inst_32047);
(statearr_32067_32089[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (10)))
{var inst_32039 = (state_32053[(2)]);var state_32053__$1 = state_32053;var statearr_32068_32090 = state_32053__$1;(statearr_32068_32090[(2)] = inst_32039);
(statearr_32068_32090[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32054 === (8)))
{var inst_32036 = cljs.core.async.close_BANG_.call(null,to);var state_32053__$1 = state_32053;var statearr_32069_32091 = state_32053__$1;(statearr_32069_32091[(2)] = inst_32036);
(statearr_32069_32091[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32077))
;return ((function (switch__7350__auto__,c__7365__auto___32077){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32073 = [null,null,null,null,null,null,null,null];(statearr_32073[(0)] = state_machine__7351__auto__);
(statearr_32073[(1)] = (1));
return statearr_32073;
});
var state_machine__7351__auto____1 = (function (state_32053){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32053);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32074){if((e32074 instanceof Object))
{var ex__7354__auto__ = e32074;var statearr_32075_32092 = state_32053;(statearr_32075_32092[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32053);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32074;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32093 = state_32053;
state_32053 = G__32093;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32053){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32077))
})();var state__7367__auto__ = (function (){var statearr_32076 = f__7366__auto__.call(null);(statearr_32076[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32077);
return statearr_32076;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32077))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__7365__auto___32194 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32194,tc,fc){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32194,tc,fc){
return (function (state_32169){var state_val_32170 = (state_32169[(1)]);if((state_val_32170 === (7)))
{var inst_32165 = (state_32169[(2)]);var state_32169__$1 = state_32169;var statearr_32171_32195 = state_32169__$1;(statearr_32171_32195[(2)] = inst_32165);
(statearr_32171_32195[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (1)))
{var state_32169__$1 = state_32169;var statearr_32172_32196 = state_32169__$1;(statearr_32172_32196[(2)] = null);
(statearr_32172_32196[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (4)))
{var inst_32146 = (state_32169[(7)]);var inst_32146__$1 = (state_32169[(2)]);var inst_32147 = (inst_32146__$1 == null);var state_32169__$1 = (function (){var statearr_32173 = state_32169;(statearr_32173[(7)] = inst_32146__$1);
return statearr_32173;
})();if(cljs.core.truth_(inst_32147))
{var statearr_32174_32197 = state_32169__$1;(statearr_32174_32197[(1)] = (5));
} else
{var statearr_32175_32198 = state_32169__$1;(statearr_32175_32198[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (13)))
{var state_32169__$1 = state_32169;var statearr_32176_32199 = state_32169__$1;(statearr_32176_32199[(2)] = null);
(statearr_32176_32199[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (6)))
{var inst_32146 = (state_32169[(7)]);var inst_32152 = p.call(null,inst_32146);var state_32169__$1 = state_32169;if(cljs.core.truth_(inst_32152))
{var statearr_32177_32200 = state_32169__$1;(statearr_32177_32200[(1)] = (9));
} else
{var statearr_32178_32201 = state_32169__$1;(statearr_32178_32201[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (3)))
{var inst_32167 = (state_32169[(2)]);var state_32169__$1 = state_32169;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32169__$1,inst_32167);
} else
{if((state_val_32170 === (12)))
{var state_32169__$1 = state_32169;var statearr_32179_32202 = state_32169__$1;(statearr_32179_32202[(2)] = null);
(statearr_32179_32202[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (2)))
{var state_32169__$1 = state_32169;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32169__$1,(4),ch);
} else
{if((state_val_32170 === (11)))
{var inst_32146 = (state_32169[(7)]);var inst_32156 = (state_32169[(2)]);var state_32169__$1 = state_32169;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32169__$1,(8),inst_32156,inst_32146);
} else
{if((state_val_32170 === (9)))
{var state_32169__$1 = state_32169;var statearr_32180_32203 = state_32169__$1;(statearr_32180_32203[(2)] = tc);
(statearr_32180_32203[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (5)))
{var inst_32149 = cljs.core.async.close_BANG_.call(null,tc);var inst_32150 = cljs.core.async.close_BANG_.call(null,fc);var state_32169__$1 = (function (){var statearr_32181 = state_32169;(statearr_32181[(8)] = inst_32149);
return statearr_32181;
})();var statearr_32182_32204 = state_32169__$1;(statearr_32182_32204[(2)] = inst_32150);
(statearr_32182_32204[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (14)))
{var inst_32163 = (state_32169[(2)]);var state_32169__$1 = state_32169;var statearr_32183_32205 = state_32169__$1;(statearr_32183_32205[(2)] = inst_32163);
(statearr_32183_32205[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (10)))
{var state_32169__$1 = state_32169;var statearr_32184_32206 = state_32169__$1;(statearr_32184_32206[(2)] = fc);
(statearr_32184_32206[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32170 === (8)))
{var inst_32158 = (state_32169[(2)]);var state_32169__$1 = state_32169;if(cljs.core.truth_(inst_32158))
{var statearr_32185_32207 = state_32169__$1;(statearr_32185_32207[(1)] = (12));
} else
{var statearr_32186_32208 = state_32169__$1;(statearr_32186_32208[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32194,tc,fc))
;return ((function (switch__7350__auto__,c__7365__auto___32194,tc,fc){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32190 = [null,null,null,null,null,null,null,null,null];(statearr_32190[(0)] = state_machine__7351__auto__);
(statearr_32190[(1)] = (1));
return statearr_32190;
});
var state_machine__7351__auto____1 = (function (state_32169){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32169);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32191){if((e32191 instanceof Object))
{var ex__7354__auto__ = e32191;var statearr_32192_32209 = state_32169;(statearr_32192_32209[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32169);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32191;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32210 = state_32169;
state_32169 = G__32210;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32169){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32194,tc,fc))
})();var state__7367__auto__ = (function (){var statearr_32193 = f__7366__auto__.call(null);(statearr_32193[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32194);
return statearr_32193;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32194,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_32257){var state_val_32258 = (state_32257[(1)]);if((state_val_32258 === (7)))
{var inst_32253 = (state_32257[(2)]);var state_32257__$1 = state_32257;var statearr_32259_32275 = state_32257__$1;(statearr_32259_32275[(2)] = inst_32253);
(statearr_32259_32275[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32258 === (6)))
{var inst_32246 = (state_32257[(7)]);var inst_32243 = (state_32257[(8)]);var inst_32250 = f.call(null,inst_32243,inst_32246);var inst_32243__$1 = inst_32250;var state_32257__$1 = (function (){var statearr_32260 = state_32257;(statearr_32260[(8)] = inst_32243__$1);
return statearr_32260;
})();var statearr_32261_32276 = state_32257__$1;(statearr_32261_32276[(2)] = null);
(statearr_32261_32276[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32258 === (5)))
{var inst_32243 = (state_32257[(8)]);var state_32257__$1 = state_32257;var statearr_32262_32277 = state_32257__$1;(statearr_32262_32277[(2)] = inst_32243);
(statearr_32262_32277[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32258 === (4)))
{var inst_32246 = (state_32257[(7)]);var inst_32246__$1 = (state_32257[(2)]);var inst_32247 = (inst_32246__$1 == null);var state_32257__$1 = (function (){var statearr_32263 = state_32257;(statearr_32263[(7)] = inst_32246__$1);
return statearr_32263;
})();if(cljs.core.truth_(inst_32247))
{var statearr_32264_32278 = state_32257__$1;(statearr_32264_32278[(1)] = (5));
} else
{var statearr_32265_32279 = state_32257__$1;(statearr_32265_32279[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32258 === (3)))
{var inst_32255 = (state_32257[(2)]);var state_32257__$1 = state_32257;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32257__$1,inst_32255);
} else
{if((state_val_32258 === (2)))
{var state_32257__$1 = state_32257;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32257__$1,(4),ch);
} else
{if((state_val_32258 === (1)))
{var inst_32243 = init;var state_32257__$1 = (function (){var statearr_32266 = state_32257;(statearr_32266[(8)] = inst_32243);
return statearr_32266;
})();var statearr_32267_32280 = state_32257__$1;(statearr_32267_32280[(2)] = null);
(statearr_32267_32280[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32271 = [null,null,null,null,null,null,null,null,null];(statearr_32271[(0)] = state_machine__7351__auto__);
(statearr_32271[(1)] = (1));
return statearr_32271;
});
var state_machine__7351__auto____1 = (function (state_32257){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32257);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32272){if((e32272 instanceof Object))
{var ex__7354__auto__ = e32272;var statearr_32273_32281 = state_32257;(statearr_32273_32281[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32257);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32272;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32282 = state_32257;
state_32257 = G__32282;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32257){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_32274 = f__7366__auto__.call(null);(statearr_32274[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_32274;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_32356){var state_val_32357 = (state_32356[(1)]);if((state_val_32357 === (7)))
{var inst_32338 = (state_32356[(2)]);var state_32356__$1 = state_32356;var statearr_32358_32381 = state_32356__$1;(statearr_32358_32381[(2)] = inst_32338);
(statearr_32358_32381[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (1)))
{var inst_32332 = cljs.core.seq.call(null,coll);var inst_32333 = inst_32332;var state_32356__$1 = (function (){var statearr_32359 = state_32356;(statearr_32359[(7)] = inst_32333);
return statearr_32359;
})();var statearr_32360_32382 = state_32356__$1;(statearr_32360_32382[(2)] = null);
(statearr_32360_32382[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (4)))
{var inst_32333 = (state_32356[(7)]);var inst_32336 = cljs.core.first.call(null,inst_32333);var state_32356__$1 = state_32356;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32356__$1,(7),ch,inst_32336);
} else
{if((state_val_32357 === (13)))
{var inst_32350 = (state_32356[(2)]);var state_32356__$1 = state_32356;var statearr_32361_32383 = state_32356__$1;(statearr_32361_32383[(2)] = inst_32350);
(statearr_32361_32383[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (6)))
{var inst_32341 = (state_32356[(2)]);var state_32356__$1 = state_32356;if(cljs.core.truth_(inst_32341))
{var statearr_32362_32384 = state_32356__$1;(statearr_32362_32384[(1)] = (8));
} else
{var statearr_32363_32385 = state_32356__$1;(statearr_32363_32385[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (3)))
{var inst_32354 = (state_32356[(2)]);var state_32356__$1 = state_32356;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32356__$1,inst_32354);
} else
{if((state_val_32357 === (12)))
{var state_32356__$1 = state_32356;var statearr_32364_32386 = state_32356__$1;(statearr_32364_32386[(2)] = null);
(statearr_32364_32386[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (2)))
{var inst_32333 = (state_32356[(7)]);var state_32356__$1 = state_32356;if(cljs.core.truth_(inst_32333))
{var statearr_32365_32387 = state_32356__$1;(statearr_32365_32387[(1)] = (4));
} else
{var statearr_32366_32388 = state_32356__$1;(statearr_32366_32388[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (11)))
{var inst_32347 = cljs.core.async.close_BANG_.call(null,ch);var state_32356__$1 = state_32356;var statearr_32367_32389 = state_32356__$1;(statearr_32367_32389[(2)] = inst_32347);
(statearr_32367_32389[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (9)))
{var state_32356__$1 = state_32356;if(cljs.core.truth_(close_QMARK_))
{var statearr_32368_32390 = state_32356__$1;(statearr_32368_32390[(1)] = (11));
} else
{var statearr_32369_32391 = state_32356__$1;(statearr_32369_32391[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (5)))
{var inst_32333 = (state_32356[(7)]);var state_32356__$1 = state_32356;var statearr_32370_32392 = state_32356__$1;(statearr_32370_32392[(2)] = inst_32333);
(statearr_32370_32392[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (10)))
{var inst_32352 = (state_32356[(2)]);var state_32356__$1 = state_32356;var statearr_32371_32393 = state_32356__$1;(statearr_32371_32393[(2)] = inst_32352);
(statearr_32371_32393[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32357 === (8)))
{var inst_32333 = (state_32356[(7)]);var inst_32343 = cljs.core.next.call(null,inst_32333);var inst_32333__$1 = inst_32343;var state_32356__$1 = (function (){var statearr_32372 = state_32356;(statearr_32372[(7)] = inst_32333__$1);
return statearr_32372;
})();var statearr_32373_32394 = state_32356__$1;(statearr_32373_32394[(2)] = null);
(statearr_32373_32394[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32377 = [null,null,null,null,null,null,null,null];(statearr_32377[(0)] = state_machine__7351__auto__);
(statearr_32377[(1)] = (1));
return statearr_32377;
});
var state_machine__7351__auto____1 = (function (state_32356){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32356);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32378){if((e32378 instanceof Object))
{var ex__7354__auto__ = e32378;var statearr_32379_32395 = state_32356;(statearr_32379_32395[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32356);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32378;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32396 = state_32356;
state_32356 = G__32396;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32356){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_32380 = f__7366__auto__.call(null);(statearr_32380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_32380;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj32398 = {};return obj32398;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3529__auto__ = _;if(and__3529__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4168__auto__ = (((_ == null))?null:_);return (function (){var or__3541__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj32400 = {};return obj32400;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t32622 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t32622 = (function (cs,ch,mult,meta32623){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta32623 = meta32623;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32622.cljs$lang$type = true;
cljs.core.async.t32622.cljs$lang$ctorStr = "cljs.core.async/t32622";
cljs.core.async.t32622.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t32622");
});})(cs))
;
cljs.core.async.t32622.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t32622.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t32622.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t32622.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t32622.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t32622.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t32622.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32624){var self__ = this;
var _32624__$1 = this;return self__.meta32623;
});})(cs))
;
cljs.core.async.t32622.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32624,meta32623__$1){var self__ = this;
var _32624__$1 = this;return (new cljs.core.async.t32622(self__.cs,self__.ch,self__.mult,meta32623__$1));
});})(cs))
;
cljs.core.async.__GT_t32622 = ((function (cs){
return (function __GT_t32622(cs__$1,ch__$1,mult__$1,meta32623){return (new cljs.core.async.t32622(cs__$1,ch__$1,mult__$1,meta32623));
});})(cs))
;
}
return (new cljs.core.async.t32622(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__7365__auto___32843 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32843,cs,m,dchan,dctr,done){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32843,cs,m,dchan,dctr,done){
return (function (state_32755){var state_val_32756 = (state_32755[(1)]);if((state_val_32756 === (7)))
{var inst_32751 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32757_32844 = state_32755__$1;(statearr_32757_32844[(2)] = inst_32751);
(statearr_32757_32844[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (20)))
{var inst_32656 = (state_32755[(7)]);var inst_32666 = cljs.core.first.call(null,inst_32656);var inst_32667 = cljs.core.nth.call(null,inst_32666,(0),null);var inst_32668 = cljs.core.nth.call(null,inst_32666,(1),null);var state_32755__$1 = (function (){var statearr_32758 = state_32755;(statearr_32758[(8)] = inst_32667);
return statearr_32758;
})();if(cljs.core.truth_(inst_32668))
{var statearr_32759_32845 = state_32755__$1;(statearr_32759_32845[(1)] = (22));
} else
{var statearr_32760_32846 = state_32755__$1;(statearr_32760_32846[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (27)))
{var inst_32627 = (state_32755[(9)]);var inst_32703 = (state_32755[(10)]);var inst_32696 = (state_32755[(11)]);var inst_32698 = (state_32755[(12)]);var inst_32703__$1 = cljs.core._nth.call(null,inst_32696,inst_32698);var inst_32704 = cljs.core.async.put_BANG_.call(null,inst_32703__$1,inst_32627,done);var state_32755__$1 = (function (){var statearr_32761 = state_32755;(statearr_32761[(10)] = inst_32703__$1);
return statearr_32761;
})();if(cljs.core.truth_(inst_32704))
{var statearr_32762_32847 = state_32755__$1;(statearr_32762_32847[(1)] = (30));
} else
{var statearr_32763_32848 = state_32755__$1;(statearr_32763_32848[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (1)))
{var state_32755__$1 = state_32755;var statearr_32764_32849 = state_32755__$1;(statearr_32764_32849[(2)] = null);
(statearr_32764_32849[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (24)))
{var inst_32656 = (state_32755[(7)]);var inst_32673 = (state_32755[(2)]);var inst_32674 = cljs.core.next.call(null,inst_32656);var inst_32636 = inst_32674;var inst_32637 = null;var inst_32638 = (0);var inst_32639 = (0);var state_32755__$1 = (function (){var statearr_32765 = state_32755;(statearr_32765[(13)] = inst_32639);
(statearr_32765[(14)] = inst_32638);
(statearr_32765[(15)] = inst_32636);
(statearr_32765[(16)] = inst_32637);
(statearr_32765[(17)] = inst_32673);
return statearr_32765;
})();var statearr_32766_32850 = state_32755__$1;(statearr_32766_32850[(2)] = null);
(statearr_32766_32850[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (39)))
{var state_32755__$1 = state_32755;var statearr_32770_32851 = state_32755__$1;(statearr_32770_32851[(2)] = null);
(statearr_32770_32851[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (4)))
{var inst_32627 = (state_32755[(9)]);var inst_32627__$1 = (state_32755[(2)]);var inst_32628 = (inst_32627__$1 == null);var state_32755__$1 = (function (){var statearr_32771 = state_32755;(statearr_32771[(9)] = inst_32627__$1);
return statearr_32771;
})();if(cljs.core.truth_(inst_32628))
{var statearr_32772_32852 = state_32755__$1;(statearr_32772_32852[(1)] = (5));
} else
{var statearr_32773_32853 = state_32755__$1;(statearr_32773_32853[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (15)))
{var inst_32639 = (state_32755[(13)]);var inst_32638 = (state_32755[(14)]);var inst_32636 = (state_32755[(15)]);var inst_32637 = (state_32755[(16)]);var inst_32652 = (state_32755[(2)]);var inst_32653 = (inst_32639 + (1));var tmp32767 = inst_32638;var tmp32768 = inst_32636;var tmp32769 = inst_32637;var inst_32636__$1 = tmp32768;var inst_32637__$1 = tmp32769;var inst_32638__$1 = tmp32767;var inst_32639__$1 = inst_32653;var state_32755__$1 = (function (){var statearr_32774 = state_32755;(statearr_32774[(13)] = inst_32639__$1);
(statearr_32774[(14)] = inst_32638__$1);
(statearr_32774[(18)] = inst_32652);
(statearr_32774[(15)] = inst_32636__$1);
(statearr_32774[(16)] = inst_32637__$1);
return statearr_32774;
})();var statearr_32775_32854 = state_32755__$1;(statearr_32775_32854[(2)] = null);
(statearr_32775_32854[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (21)))
{var inst_32677 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32779_32855 = state_32755__$1;(statearr_32779_32855[(2)] = inst_32677);
(statearr_32779_32855[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (31)))
{var inst_32703 = (state_32755[(10)]);var inst_32707 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_32708 = cljs.core.async.untap_STAR_.call(null,m,inst_32703);var state_32755__$1 = (function (){var statearr_32780 = state_32755;(statearr_32780[(19)] = inst_32707);
return statearr_32780;
})();var statearr_32781_32856 = state_32755__$1;(statearr_32781_32856[(2)] = inst_32708);
(statearr_32781_32856[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (32)))
{var inst_32695 = (state_32755[(20)]);var inst_32697 = (state_32755[(21)]);var inst_32696 = (state_32755[(11)]);var inst_32698 = (state_32755[(12)]);var inst_32710 = (state_32755[(2)]);var inst_32711 = (inst_32698 + (1));var tmp32776 = inst_32695;var tmp32777 = inst_32697;var tmp32778 = inst_32696;var inst_32695__$1 = tmp32776;var inst_32696__$1 = tmp32778;var inst_32697__$1 = tmp32777;var inst_32698__$1 = inst_32711;var state_32755__$1 = (function (){var statearr_32782 = state_32755;(statearr_32782[(20)] = inst_32695__$1);
(statearr_32782[(21)] = inst_32697__$1);
(statearr_32782[(11)] = inst_32696__$1);
(statearr_32782[(12)] = inst_32698__$1);
(statearr_32782[(22)] = inst_32710);
return statearr_32782;
})();var statearr_32783_32857 = state_32755__$1;(statearr_32783_32857[(2)] = null);
(statearr_32783_32857[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (40)))
{var inst_32723 = (state_32755[(23)]);var inst_32727 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_32728 = cljs.core.async.untap_STAR_.call(null,m,inst_32723);var state_32755__$1 = (function (){var statearr_32784 = state_32755;(statearr_32784[(24)] = inst_32727);
return statearr_32784;
})();var statearr_32785_32858 = state_32755__$1;(statearr_32785_32858[(2)] = inst_32728);
(statearr_32785_32858[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (33)))
{var inst_32714 = (state_32755[(25)]);var inst_32716 = cljs.core.chunked_seq_QMARK_.call(null,inst_32714);var state_32755__$1 = state_32755;if(inst_32716)
{var statearr_32786_32859 = state_32755__$1;(statearr_32786_32859[(1)] = (36));
} else
{var statearr_32787_32860 = state_32755__$1;(statearr_32787_32860[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (13)))
{var inst_32646 = (state_32755[(26)]);var inst_32649 = cljs.core.async.close_BANG_.call(null,inst_32646);var state_32755__$1 = state_32755;var statearr_32788_32861 = state_32755__$1;(statearr_32788_32861[(2)] = inst_32649);
(statearr_32788_32861[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (22)))
{var inst_32667 = (state_32755[(8)]);var inst_32670 = cljs.core.async.close_BANG_.call(null,inst_32667);var state_32755__$1 = state_32755;var statearr_32789_32862 = state_32755__$1;(statearr_32789_32862[(2)] = inst_32670);
(statearr_32789_32862[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (36)))
{var inst_32714 = (state_32755[(25)]);var inst_32718 = cljs.core.chunk_first.call(null,inst_32714);var inst_32719 = cljs.core.chunk_rest.call(null,inst_32714);var inst_32720 = cljs.core.count.call(null,inst_32718);var inst_32695 = inst_32719;var inst_32696 = inst_32718;var inst_32697 = inst_32720;var inst_32698 = (0);var state_32755__$1 = (function (){var statearr_32790 = state_32755;(statearr_32790[(20)] = inst_32695);
(statearr_32790[(21)] = inst_32697);
(statearr_32790[(11)] = inst_32696);
(statearr_32790[(12)] = inst_32698);
return statearr_32790;
})();var statearr_32791_32863 = state_32755__$1;(statearr_32791_32863[(2)] = null);
(statearr_32791_32863[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (41)))
{var inst_32714 = (state_32755[(25)]);var inst_32730 = (state_32755[(2)]);var inst_32731 = cljs.core.next.call(null,inst_32714);var inst_32695 = inst_32731;var inst_32696 = null;var inst_32697 = (0);var inst_32698 = (0);var state_32755__$1 = (function (){var statearr_32792 = state_32755;(statearr_32792[(20)] = inst_32695);
(statearr_32792[(21)] = inst_32697);
(statearr_32792[(11)] = inst_32696);
(statearr_32792[(12)] = inst_32698);
(statearr_32792[(27)] = inst_32730);
return statearr_32792;
})();var statearr_32793_32864 = state_32755__$1;(statearr_32793_32864[(2)] = null);
(statearr_32793_32864[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (43)))
{var state_32755__$1 = state_32755;var statearr_32794_32865 = state_32755__$1;(statearr_32794_32865[(2)] = null);
(statearr_32794_32865[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (29)))
{var inst_32739 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32795_32866 = state_32755__$1;(statearr_32795_32866[(2)] = inst_32739);
(statearr_32795_32866[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (44)))
{var inst_32748 = (state_32755[(2)]);var state_32755__$1 = (function (){var statearr_32796 = state_32755;(statearr_32796[(28)] = inst_32748);
return statearr_32796;
})();var statearr_32797_32867 = state_32755__$1;(statearr_32797_32867[(2)] = null);
(statearr_32797_32867[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (6)))
{var inst_32687 = (state_32755[(29)]);var inst_32686 = cljs.core.deref.call(null,cs);var inst_32687__$1 = cljs.core.keys.call(null,inst_32686);var inst_32688 = cljs.core.count.call(null,inst_32687__$1);var inst_32689 = cljs.core.reset_BANG_.call(null,dctr,inst_32688);var inst_32694 = cljs.core.seq.call(null,inst_32687__$1);var inst_32695 = inst_32694;var inst_32696 = null;var inst_32697 = (0);var inst_32698 = (0);var state_32755__$1 = (function (){var statearr_32798 = state_32755;(statearr_32798[(30)] = inst_32689);
(statearr_32798[(20)] = inst_32695);
(statearr_32798[(21)] = inst_32697);
(statearr_32798[(11)] = inst_32696);
(statearr_32798[(29)] = inst_32687__$1);
(statearr_32798[(12)] = inst_32698);
return statearr_32798;
})();var statearr_32799_32868 = state_32755__$1;(statearr_32799_32868[(2)] = null);
(statearr_32799_32868[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (28)))
{var inst_32714 = (state_32755[(25)]);var inst_32695 = (state_32755[(20)]);var inst_32714__$1 = cljs.core.seq.call(null,inst_32695);var state_32755__$1 = (function (){var statearr_32800 = state_32755;(statearr_32800[(25)] = inst_32714__$1);
return statearr_32800;
})();if(inst_32714__$1)
{var statearr_32801_32869 = state_32755__$1;(statearr_32801_32869[(1)] = (33));
} else
{var statearr_32802_32870 = state_32755__$1;(statearr_32802_32870[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (25)))
{var inst_32697 = (state_32755[(21)]);var inst_32698 = (state_32755[(12)]);var inst_32700 = (inst_32698 < inst_32697);var inst_32701 = inst_32700;var state_32755__$1 = state_32755;if(cljs.core.truth_(inst_32701))
{var statearr_32803_32871 = state_32755__$1;(statearr_32803_32871[(1)] = (27));
} else
{var statearr_32804_32872 = state_32755__$1;(statearr_32804_32872[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (34)))
{var state_32755__$1 = state_32755;var statearr_32805_32873 = state_32755__$1;(statearr_32805_32873[(2)] = null);
(statearr_32805_32873[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (17)))
{var state_32755__$1 = state_32755;var statearr_32806_32874 = state_32755__$1;(statearr_32806_32874[(2)] = null);
(statearr_32806_32874[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (3)))
{var inst_32753 = (state_32755[(2)]);var state_32755__$1 = state_32755;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32755__$1,inst_32753);
} else
{if((state_val_32756 === (12)))
{var inst_32682 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32807_32875 = state_32755__$1;(statearr_32807_32875[(2)] = inst_32682);
(statearr_32807_32875[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (2)))
{var state_32755__$1 = state_32755;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32755__$1,(4),ch);
} else
{if((state_val_32756 === (23)))
{var state_32755__$1 = state_32755;var statearr_32808_32876 = state_32755__$1;(statearr_32808_32876[(2)] = null);
(statearr_32808_32876[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (35)))
{var inst_32737 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32809_32877 = state_32755__$1;(statearr_32809_32877[(2)] = inst_32737);
(statearr_32809_32877[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (19)))
{var inst_32656 = (state_32755[(7)]);var inst_32660 = cljs.core.chunk_first.call(null,inst_32656);var inst_32661 = cljs.core.chunk_rest.call(null,inst_32656);var inst_32662 = cljs.core.count.call(null,inst_32660);var inst_32636 = inst_32661;var inst_32637 = inst_32660;var inst_32638 = inst_32662;var inst_32639 = (0);var state_32755__$1 = (function (){var statearr_32810 = state_32755;(statearr_32810[(13)] = inst_32639);
(statearr_32810[(14)] = inst_32638);
(statearr_32810[(15)] = inst_32636);
(statearr_32810[(16)] = inst_32637);
return statearr_32810;
})();var statearr_32811_32878 = state_32755__$1;(statearr_32811_32878[(2)] = null);
(statearr_32811_32878[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (11)))
{var inst_32656 = (state_32755[(7)]);var inst_32636 = (state_32755[(15)]);var inst_32656__$1 = cljs.core.seq.call(null,inst_32636);var state_32755__$1 = (function (){var statearr_32812 = state_32755;(statearr_32812[(7)] = inst_32656__$1);
return statearr_32812;
})();if(inst_32656__$1)
{var statearr_32813_32879 = state_32755__$1;(statearr_32813_32879[(1)] = (16));
} else
{var statearr_32814_32880 = state_32755__$1;(statearr_32814_32880[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (9)))
{var inst_32684 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32815_32881 = state_32755__$1;(statearr_32815_32881[(2)] = inst_32684);
(statearr_32815_32881[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (5)))
{var inst_32634 = cljs.core.deref.call(null,cs);var inst_32635 = cljs.core.seq.call(null,inst_32634);var inst_32636 = inst_32635;var inst_32637 = null;var inst_32638 = (0);var inst_32639 = (0);var state_32755__$1 = (function (){var statearr_32816 = state_32755;(statearr_32816[(13)] = inst_32639);
(statearr_32816[(14)] = inst_32638);
(statearr_32816[(15)] = inst_32636);
(statearr_32816[(16)] = inst_32637);
return statearr_32816;
})();var statearr_32817_32882 = state_32755__$1;(statearr_32817_32882[(2)] = null);
(statearr_32817_32882[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (14)))
{var state_32755__$1 = state_32755;var statearr_32818_32883 = state_32755__$1;(statearr_32818_32883[(2)] = null);
(statearr_32818_32883[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (45)))
{var inst_32745 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32819_32884 = state_32755__$1;(statearr_32819_32884[(2)] = inst_32745);
(statearr_32819_32884[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (26)))
{var inst_32687 = (state_32755[(29)]);var inst_32741 = (state_32755[(2)]);var inst_32742 = cljs.core.seq.call(null,inst_32687);var state_32755__$1 = (function (){var statearr_32820 = state_32755;(statearr_32820[(31)] = inst_32741);
return statearr_32820;
})();if(inst_32742)
{var statearr_32821_32885 = state_32755__$1;(statearr_32821_32885[(1)] = (42));
} else
{var statearr_32822_32886 = state_32755__$1;(statearr_32822_32886[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (16)))
{var inst_32656 = (state_32755[(7)]);var inst_32658 = cljs.core.chunked_seq_QMARK_.call(null,inst_32656);var state_32755__$1 = state_32755;if(inst_32658)
{var statearr_32823_32887 = state_32755__$1;(statearr_32823_32887[(1)] = (19));
} else
{var statearr_32824_32888 = state_32755__$1;(statearr_32824_32888[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (38)))
{var inst_32734 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32825_32889 = state_32755__$1;(statearr_32825_32889[(2)] = inst_32734);
(statearr_32825_32889[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (30)))
{var state_32755__$1 = state_32755;var statearr_32826_32890 = state_32755__$1;(statearr_32826_32890[(2)] = null);
(statearr_32826_32890[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (10)))
{var inst_32639 = (state_32755[(13)]);var inst_32637 = (state_32755[(16)]);var inst_32645 = cljs.core._nth.call(null,inst_32637,inst_32639);var inst_32646 = cljs.core.nth.call(null,inst_32645,(0),null);var inst_32647 = cljs.core.nth.call(null,inst_32645,(1),null);var state_32755__$1 = (function (){var statearr_32827 = state_32755;(statearr_32827[(26)] = inst_32646);
return statearr_32827;
})();if(cljs.core.truth_(inst_32647))
{var statearr_32828_32891 = state_32755__$1;(statearr_32828_32891[(1)] = (13));
} else
{var statearr_32829_32892 = state_32755__$1;(statearr_32829_32892[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (18)))
{var inst_32680 = (state_32755[(2)]);var state_32755__$1 = state_32755;var statearr_32830_32893 = state_32755__$1;(statearr_32830_32893[(2)] = inst_32680);
(statearr_32830_32893[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (42)))
{var state_32755__$1 = state_32755;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32755__$1,(45),dchan);
} else
{if((state_val_32756 === (37)))
{var inst_32627 = (state_32755[(9)]);var inst_32714 = (state_32755[(25)]);var inst_32723 = (state_32755[(23)]);var inst_32723__$1 = cljs.core.first.call(null,inst_32714);var inst_32724 = cljs.core.async.put_BANG_.call(null,inst_32723__$1,inst_32627,done);var state_32755__$1 = (function (){var statearr_32831 = state_32755;(statearr_32831[(23)] = inst_32723__$1);
return statearr_32831;
})();if(cljs.core.truth_(inst_32724))
{var statearr_32832_32894 = state_32755__$1;(statearr_32832_32894[(1)] = (39));
} else
{var statearr_32833_32895 = state_32755__$1;(statearr_32833_32895[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32756 === (8)))
{var inst_32639 = (state_32755[(13)]);var inst_32638 = (state_32755[(14)]);var inst_32641 = (inst_32639 < inst_32638);var inst_32642 = inst_32641;var state_32755__$1 = state_32755;if(cljs.core.truth_(inst_32642))
{var statearr_32834_32896 = state_32755__$1;(statearr_32834_32896[(1)] = (10));
} else
{var statearr_32835_32897 = state_32755__$1;(statearr_32835_32897[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32843,cs,m,dchan,dctr,done))
;return ((function (switch__7350__auto__,c__7365__auto___32843,cs,m,dchan,dctr,done){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32839 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_32839[(0)] = state_machine__7351__auto__);
(statearr_32839[(1)] = (1));
return statearr_32839;
});
var state_machine__7351__auto____1 = (function (state_32755){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32755);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32840){if((e32840 instanceof Object))
{var ex__7354__auto__ = e32840;var statearr_32841_32898 = state_32755;(statearr_32841_32898[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32755);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32840;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32899 = state_32755;
state_32755 = G__32899;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32755){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32843,cs,m,dchan,dctr,done))
})();var state__7367__auto__ = (function (){var statearr_32842 = f__7366__auto__.call(null);(statearr_32842[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32843);
return statearr_32842;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32843,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj32901 = {};return obj32901;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t33021 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t33021 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta33022){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta33022 = meta33022;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33021.cljs$lang$type = true;
cljs.core.async.t33021.cljs$lang$ctorStr = "cljs.core.async/t33021";
cljs.core.async.t33021.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t33021");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t33021.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t33021.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33023){var self__ = this;
var _33023__$1 = this;return self__.meta33022;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33021.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33023,meta33022__$1){var self__ = this;
var _33023__$1 = this;return (new cljs.core.async.t33021(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta33022__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t33021 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t33021(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta33022){return (new cljs.core.async.t33021(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta33022));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t33021(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__7365__auto___33140 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33140,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33140,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33093){var state_val_33094 = (state_33093[(1)]);if((state_val_33094 === (7)))
{var inst_33037 = (state_33093[(7)]);var inst_33042 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33037);var state_33093__$1 = state_33093;var statearr_33095_33141 = state_33093__$1;(statearr_33095_33141[(2)] = inst_33042);
(statearr_33095_33141[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (20)))
{var inst_33052 = (state_33093[(8)]);var state_33093__$1 = state_33093;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33093__$1,(23),out,inst_33052);
} else
{if((state_val_33094 === (1)))
{var inst_33027 = (state_33093[(9)]);var inst_33027__$1 = calc_state.call(null);var inst_33028 = cljs.core.seq_QMARK_.call(null,inst_33027__$1);var state_33093__$1 = (function (){var statearr_33096 = state_33093;(statearr_33096[(9)] = inst_33027__$1);
return statearr_33096;
})();if(inst_33028)
{var statearr_33097_33142 = state_33093__$1;(statearr_33097_33142[(1)] = (2));
} else
{var statearr_33098_33143 = state_33093__$1;(statearr_33098_33143[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (24)))
{var inst_33045 = (state_33093[(10)]);var inst_33037 = inst_33045;var state_33093__$1 = (function (){var statearr_33099 = state_33093;(statearr_33099[(7)] = inst_33037);
return statearr_33099;
})();var statearr_33100_33144 = state_33093__$1;(statearr_33100_33144[(2)] = null);
(statearr_33100_33144[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (4)))
{var inst_33027 = (state_33093[(9)]);var inst_33033 = (state_33093[(2)]);var inst_33034 = cljs.core.get.call(null,inst_33033,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_33035 = cljs.core.get.call(null,inst_33033,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_33036 = cljs.core.get.call(null,inst_33033,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_33037 = inst_33027;var state_33093__$1 = (function (){var statearr_33101 = state_33093;(statearr_33101[(11)] = inst_33036);
(statearr_33101[(12)] = inst_33035);
(statearr_33101[(7)] = inst_33037);
(statearr_33101[(13)] = inst_33034);
return statearr_33101;
})();var statearr_33102_33145 = state_33093__$1;(statearr_33102_33145[(2)] = null);
(statearr_33102_33145[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (15)))
{var state_33093__$1 = state_33093;var statearr_33103_33146 = state_33093__$1;(statearr_33103_33146[(2)] = null);
(statearr_33103_33146[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (21)))
{var inst_33045 = (state_33093[(10)]);var inst_33037 = inst_33045;var state_33093__$1 = (function (){var statearr_33104 = state_33093;(statearr_33104[(7)] = inst_33037);
return statearr_33104;
})();var statearr_33105_33147 = state_33093__$1;(statearr_33105_33147[(2)] = null);
(statearr_33105_33147[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (13)))
{var inst_33089 = (state_33093[(2)]);var state_33093__$1 = state_33093;var statearr_33106_33148 = state_33093__$1;(statearr_33106_33148[(2)] = inst_33089);
(statearr_33106_33148[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (22)))
{var inst_33087 = (state_33093[(2)]);var state_33093__$1 = state_33093;var statearr_33107_33149 = state_33093__$1;(statearr_33107_33149[(2)] = inst_33087);
(statearr_33107_33149[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (6)))
{var inst_33091 = (state_33093[(2)]);var state_33093__$1 = state_33093;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33093__$1,inst_33091);
} else
{if((state_val_33094 === (25)))
{var state_33093__$1 = state_33093;var statearr_33108_33150 = state_33093__$1;(statearr_33108_33150[(2)] = null);
(statearr_33108_33150[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (17)))
{var inst_33067 = (state_33093[(14)]);var state_33093__$1 = state_33093;var statearr_33109_33151 = state_33093__$1;(statearr_33109_33151[(2)] = inst_33067);
(statearr_33109_33151[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (3)))
{var inst_33027 = (state_33093[(9)]);var state_33093__$1 = state_33093;var statearr_33110_33152 = state_33093__$1;(statearr_33110_33152[(2)] = inst_33027);
(statearr_33110_33152[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (12)))
{var inst_33048 = (state_33093[(15)]);var inst_33067 = (state_33093[(14)]);var inst_33053 = (state_33093[(16)]);var inst_33067__$1 = inst_33048.call(null,inst_33053);var state_33093__$1 = (function (){var statearr_33111 = state_33093;(statearr_33111[(14)] = inst_33067__$1);
return statearr_33111;
})();if(cljs.core.truth_(inst_33067__$1))
{var statearr_33112_33153 = state_33093__$1;(statearr_33112_33153[(1)] = (17));
} else
{var statearr_33113_33154 = state_33093__$1;(statearr_33113_33154[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (2)))
{var inst_33027 = (state_33093[(9)]);var inst_33030 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33027);var state_33093__$1 = state_33093;var statearr_33114_33155 = state_33093__$1;(statearr_33114_33155[(2)] = inst_33030);
(statearr_33114_33155[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (23)))
{var inst_33078 = (state_33093[(2)]);var state_33093__$1 = state_33093;if(cljs.core.truth_(inst_33078))
{var statearr_33115_33156 = state_33093__$1;(statearr_33115_33156[(1)] = (24));
} else
{var statearr_33116_33157 = state_33093__$1;(statearr_33116_33157[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (19)))
{var inst_33075 = (state_33093[(2)]);var state_33093__$1 = state_33093;if(cljs.core.truth_(inst_33075))
{var statearr_33117_33158 = state_33093__$1;(statearr_33117_33158[(1)] = (20));
} else
{var statearr_33118_33159 = state_33093__$1;(statearr_33118_33159[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (11)))
{var inst_33052 = (state_33093[(8)]);var inst_33058 = (inst_33052 == null);var state_33093__$1 = state_33093;if(cljs.core.truth_(inst_33058))
{var statearr_33119_33160 = state_33093__$1;(statearr_33119_33160[(1)] = (14));
} else
{var statearr_33120_33161 = state_33093__$1;(statearr_33120_33161[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (9)))
{var inst_33045 = (state_33093[(10)]);var inst_33045__$1 = (state_33093[(2)]);var inst_33046 = cljs.core.get.call(null,inst_33045__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_33047 = cljs.core.get.call(null,inst_33045__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_33048 = cljs.core.get.call(null,inst_33045__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_33093__$1 = (function (){var statearr_33121 = state_33093;(statearr_33121[(15)] = inst_33048);
(statearr_33121[(10)] = inst_33045__$1);
(statearr_33121[(17)] = inst_33047);
return statearr_33121;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_33093__$1,(10),inst_33046);
} else
{if((state_val_33094 === (5)))
{var inst_33037 = (state_33093[(7)]);var inst_33040 = cljs.core.seq_QMARK_.call(null,inst_33037);var state_33093__$1 = state_33093;if(inst_33040)
{var statearr_33122_33162 = state_33093__$1;(statearr_33122_33162[(1)] = (7));
} else
{var statearr_33123_33163 = state_33093__$1;(statearr_33123_33163[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (14)))
{var inst_33053 = (state_33093[(16)]);var inst_33060 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_33053);var state_33093__$1 = state_33093;var statearr_33124_33164 = state_33093__$1;(statearr_33124_33164[(2)] = inst_33060);
(statearr_33124_33164[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (26)))
{var inst_33083 = (state_33093[(2)]);var state_33093__$1 = state_33093;var statearr_33125_33165 = state_33093__$1;(statearr_33125_33165[(2)] = inst_33083);
(statearr_33125_33165[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (16)))
{var inst_33063 = (state_33093[(2)]);var inst_33064 = calc_state.call(null);var inst_33037 = inst_33064;var state_33093__$1 = (function (){var statearr_33126 = state_33093;(statearr_33126[(18)] = inst_33063);
(statearr_33126[(7)] = inst_33037);
return statearr_33126;
})();var statearr_33127_33166 = state_33093__$1;(statearr_33127_33166[(2)] = null);
(statearr_33127_33166[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (10)))
{var inst_33053 = (state_33093[(16)]);var inst_33052 = (state_33093[(8)]);var inst_33051 = (state_33093[(2)]);var inst_33052__$1 = cljs.core.nth.call(null,inst_33051,(0),null);var inst_33053__$1 = cljs.core.nth.call(null,inst_33051,(1),null);var inst_33054 = (inst_33052__$1 == null);var inst_33055 = cljs.core._EQ_.call(null,inst_33053__$1,change);var inst_33056 = (inst_33054) || (inst_33055);var state_33093__$1 = (function (){var statearr_33128 = state_33093;(statearr_33128[(16)] = inst_33053__$1);
(statearr_33128[(8)] = inst_33052__$1);
return statearr_33128;
})();if(cljs.core.truth_(inst_33056))
{var statearr_33129_33167 = state_33093__$1;(statearr_33129_33167[(1)] = (11));
} else
{var statearr_33130_33168 = state_33093__$1;(statearr_33130_33168[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (18)))
{var inst_33048 = (state_33093[(15)]);var inst_33053 = (state_33093[(16)]);var inst_33047 = (state_33093[(17)]);var inst_33070 = cljs.core.empty_QMARK_.call(null,inst_33048);var inst_33071 = inst_33047.call(null,inst_33053);var inst_33072 = cljs.core.not.call(null,inst_33071);var inst_33073 = (inst_33070) && (inst_33072);var state_33093__$1 = state_33093;var statearr_33131_33169 = state_33093__$1;(statearr_33131_33169[(2)] = inst_33073);
(statearr_33131_33169[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33094 === (8)))
{var inst_33037 = (state_33093[(7)]);var state_33093__$1 = state_33093;var statearr_33132_33170 = state_33093__$1;(statearr_33132_33170[(2)] = inst_33037);
(statearr_33132_33170[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33140,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__7350__auto__,c__7365__auto___33140,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33136 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33136[(0)] = state_machine__7351__auto__);
(statearr_33136[(1)] = (1));
return statearr_33136;
});
var state_machine__7351__auto____1 = (function (state_33093){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33093);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33137){if((e33137 instanceof Object))
{var ex__7354__auto__ = e33137;var statearr_33138_33171 = state_33093;(statearr_33138_33171[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33093);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33137;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33172 = state_33093;
state_33093 = G__33172;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33093){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33140,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__7367__auto__ = (function (){var statearr_33139 = f__7366__auto__.call(null);(statearr_33139[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33140);
return statearr_33139;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33140,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj33174 = {};return obj33174;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3541__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3541__auto__,mults){
return (function (p1__33175_SHARP_){if(cljs.core.truth_(p1__33175_SHARP_.call(null,topic)))
{return p1__33175_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__33175_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3541__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t33298 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t33298 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta33299){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta33299 = meta33299;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33298.cljs$lang$type = true;
cljs.core.async.t33298.cljs$lang$ctorStr = "cljs.core.async/t33298";
cljs.core.async.t33298.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t33298");
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t33298.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t33298.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33300){var self__ = this;
var _33300__$1 = this;return self__.meta33299;
});})(mults,ensure_mult))
;
cljs.core.async.t33298.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33300,meta33299__$1){var self__ = this;
var _33300__$1 = this;return (new cljs.core.async.t33298(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta33299__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t33298 = ((function (mults,ensure_mult){
return (function __GT_t33298(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta33299){return (new cljs.core.async.t33298(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta33299));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t33298(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__7365__auto___33420 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33420,mults,ensure_mult,p){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33420,mults,ensure_mult,p){
return (function (state_33372){var state_val_33373 = (state_33372[(1)]);if((state_val_33373 === (7)))
{var inst_33368 = (state_33372[(2)]);var state_33372__$1 = state_33372;var statearr_33374_33421 = state_33372__$1;(statearr_33374_33421[(2)] = inst_33368);
(statearr_33374_33421[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (20)))
{var state_33372__$1 = state_33372;var statearr_33375_33422 = state_33372__$1;(statearr_33375_33422[(2)] = null);
(statearr_33375_33422[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (1)))
{var state_33372__$1 = state_33372;var statearr_33376_33423 = state_33372__$1;(statearr_33376_33423[(2)] = null);
(statearr_33376_33423[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (24)))
{var inst_33351 = (state_33372[(7)]);var inst_33360 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_33351);var state_33372__$1 = state_33372;var statearr_33377_33424 = state_33372__$1;(statearr_33377_33424[(2)] = inst_33360);
(statearr_33377_33424[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (4)))
{var inst_33303 = (state_33372[(8)]);var inst_33303__$1 = (state_33372[(2)]);var inst_33304 = (inst_33303__$1 == null);var state_33372__$1 = (function (){var statearr_33378 = state_33372;(statearr_33378[(8)] = inst_33303__$1);
return statearr_33378;
})();if(cljs.core.truth_(inst_33304))
{var statearr_33379_33425 = state_33372__$1;(statearr_33379_33425[(1)] = (5));
} else
{var statearr_33380_33426 = state_33372__$1;(statearr_33380_33426[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (15)))
{var inst_33345 = (state_33372[(2)]);var state_33372__$1 = state_33372;var statearr_33381_33427 = state_33372__$1;(statearr_33381_33427[(2)] = inst_33345);
(statearr_33381_33427[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (21)))
{var inst_33365 = (state_33372[(2)]);var state_33372__$1 = (function (){var statearr_33382 = state_33372;(statearr_33382[(9)] = inst_33365);
return statearr_33382;
})();var statearr_33383_33428 = state_33372__$1;(statearr_33383_33428[(2)] = null);
(statearr_33383_33428[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (13)))
{var inst_33327 = (state_33372[(10)]);var inst_33329 = cljs.core.chunked_seq_QMARK_.call(null,inst_33327);var state_33372__$1 = state_33372;if(inst_33329)
{var statearr_33384_33429 = state_33372__$1;(statearr_33384_33429[(1)] = (16));
} else
{var statearr_33385_33430 = state_33372__$1;(statearr_33385_33430[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (22)))
{var inst_33357 = (state_33372[(2)]);var state_33372__$1 = state_33372;if(cljs.core.truth_(inst_33357))
{var statearr_33386_33431 = state_33372__$1;(statearr_33386_33431[(1)] = (23));
} else
{var statearr_33387_33432 = state_33372__$1;(statearr_33387_33432[(1)] = (24));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (6)))
{var inst_33353 = (state_33372[(11)]);var inst_33351 = (state_33372[(7)]);var inst_33303 = (state_33372[(8)]);var inst_33351__$1 = topic_fn.call(null,inst_33303);var inst_33352 = cljs.core.deref.call(null,mults);var inst_33353__$1 = cljs.core.get.call(null,inst_33352,inst_33351__$1);var state_33372__$1 = (function (){var statearr_33388 = state_33372;(statearr_33388[(11)] = inst_33353__$1);
(statearr_33388[(7)] = inst_33351__$1);
return statearr_33388;
})();if(cljs.core.truth_(inst_33353__$1))
{var statearr_33389_33433 = state_33372__$1;(statearr_33389_33433[(1)] = (19));
} else
{var statearr_33390_33434 = state_33372__$1;(statearr_33390_33434[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (25)))
{var inst_33362 = (state_33372[(2)]);var state_33372__$1 = state_33372;var statearr_33391_33435 = state_33372__$1;(statearr_33391_33435[(2)] = inst_33362);
(statearr_33391_33435[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (17)))
{var inst_33327 = (state_33372[(10)]);var inst_33336 = cljs.core.first.call(null,inst_33327);var inst_33337 = cljs.core.async.muxch_STAR_.call(null,inst_33336);var inst_33338 = cljs.core.async.close_BANG_.call(null,inst_33337);var inst_33339 = cljs.core.next.call(null,inst_33327);var inst_33313 = inst_33339;var inst_33314 = null;var inst_33315 = (0);var inst_33316 = (0);var state_33372__$1 = (function (){var statearr_33392 = state_33372;(statearr_33392[(12)] = inst_33313);
(statearr_33392[(13)] = inst_33315);
(statearr_33392[(14)] = inst_33338);
(statearr_33392[(15)] = inst_33316);
(statearr_33392[(16)] = inst_33314);
return statearr_33392;
})();var statearr_33393_33436 = state_33372__$1;(statearr_33393_33436[(2)] = null);
(statearr_33393_33436[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (3)))
{var inst_33370 = (state_33372[(2)]);var state_33372__$1 = state_33372;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33372__$1,inst_33370);
} else
{if((state_val_33373 === (12)))
{var inst_33347 = (state_33372[(2)]);var state_33372__$1 = state_33372;var statearr_33394_33437 = state_33372__$1;(statearr_33394_33437[(2)] = inst_33347);
(statearr_33394_33437[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (2)))
{var state_33372__$1 = state_33372;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33372__$1,(4),ch);
} else
{if((state_val_33373 === (23)))
{var state_33372__$1 = state_33372;var statearr_33395_33438 = state_33372__$1;(statearr_33395_33438[(2)] = null);
(statearr_33395_33438[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (19)))
{var inst_33353 = (state_33372[(11)]);var inst_33303 = (state_33372[(8)]);var inst_33355 = cljs.core.async.muxch_STAR_.call(null,inst_33353);var state_33372__$1 = state_33372;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33372__$1,(22),inst_33355,inst_33303);
} else
{if((state_val_33373 === (11)))
{var inst_33313 = (state_33372[(12)]);var inst_33327 = (state_33372[(10)]);var inst_33327__$1 = cljs.core.seq.call(null,inst_33313);var state_33372__$1 = (function (){var statearr_33396 = state_33372;(statearr_33396[(10)] = inst_33327__$1);
return statearr_33396;
})();if(inst_33327__$1)
{var statearr_33397_33439 = state_33372__$1;(statearr_33397_33439[(1)] = (13));
} else
{var statearr_33398_33440 = state_33372__$1;(statearr_33398_33440[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (9)))
{var inst_33349 = (state_33372[(2)]);var state_33372__$1 = state_33372;var statearr_33399_33441 = state_33372__$1;(statearr_33399_33441[(2)] = inst_33349);
(statearr_33399_33441[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (5)))
{var inst_33310 = cljs.core.deref.call(null,mults);var inst_33311 = cljs.core.vals.call(null,inst_33310);var inst_33312 = cljs.core.seq.call(null,inst_33311);var inst_33313 = inst_33312;var inst_33314 = null;var inst_33315 = (0);var inst_33316 = (0);var state_33372__$1 = (function (){var statearr_33400 = state_33372;(statearr_33400[(12)] = inst_33313);
(statearr_33400[(13)] = inst_33315);
(statearr_33400[(15)] = inst_33316);
(statearr_33400[(16)] = inst_33314);
return statearr_33400;
})();var statearr_33401_33442 = state_33372__$1;(statearr_33401_33442[(2)] = null);
(statearr_33401_33442[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (14)))
{var state_33372__$1 = state_33372;var statearr_33405_33443 = state_33372__$1;(statearr_33405_33443[(2)] = null);
(statearr_33405_33443[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (16)))
{var inst_33327 = (state_33372[(10)]);var inst_33331 = cljs.core.chunk_first.call(null,inst_33327);var inst_33332 = cljs.core.chunk_rest.call(null,inst_33327);var inst_33333 = cljs.core.count.call(null,inst_33331);var inst_33313 = inst_33332;var inst_33314 = inst_33331;var inst_33315 = inst_33333;var inst_33316 = (0);var state_33372__$1 = (function (){var statearr_33406 = state_33372;(statearr_33406[(12)] = inst_33313);
(statearr_33406[(13)] = inst_33315);
(statearr_33406[(15)] = inst_33316);
(statearr_33406[(16)] = inst_33314);
return statearr_33406;
})();var statearr_33407_33444 = state_33372__$1;(statearr_33407_33444[(2)] = null);
(statearr_33407_33444[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (10)))
{var inst_33313 = (state_33372[(12)]);var inst_33315 = (state_33372[(13)]);var inst_33316 = (state_33372[(15)]);var inst_33314 = (state_33372[(16)]);var inst_33321 = cljs.core._nth.call(null,inst_33314,inst_33316);var inst_33322 = cljs.core.async.muxch_STAR_.call(null,inst_33321);var inst_33323 = cljs.core.async.close_BANG_.call(null,inst_33322);var inst_33324 = (inst_33316 + (1));var tmp33402 = inst_33313;var tmp33403 = inst_33315;var tmp33404 = inst_33314;var inst_33313__$1 = tmp33402;var inst_33314__$1 = tmp33404;var inst_33315__$1 = tmp33403;var inst_33316__$1 = inst_33324;var state_33372__$1 = (function (){var statearr_33408 = state_33372;(statearr_33408[(12)] = inst_33313__$1);
(statearr_33408[(17)] = inst_33323);
(statearr_33408[(13)] = inst_33315__$1);
(statearr_33408[(15)] = inst_33316__$1);
(statearr_33408[(16)] = inst_33314__$1);
return statearr_33408;
})();var statearr_33409_33445 = state_33372__$1;(statearr_33409_33445[(2)] = null);
(statearr_33409_33445[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (18)))
{var inst_33342 = (state_33372[(2)]);var state_33372__$1 = state_33372;var statearr_33410_33446 = state_33372__$1;(statearr_33410_33446[(2)] = inst_33342);
(statearr_33410_33446[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33373 === (8)))
{var inst_33315 = (state_33372[(13)]);var inst_33316 = (state_33372[(15)]);var inst_33318 = (inst_33316 < inst_33315);var inst_33319 = inst_33318;var state_33372__$1 = state_33372;if(cljs.core.truth_(inst_33319))
{var statearr_33411_33447 = state_33372__$1;(statearr_33411_33447[(1)] = (10));
} else
{var statearr_33412_33448 = state_33372__$1;(statearr_33412_33448[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33420,mults,ensure_mult,p))
;return ((function (switch__7350__auto__,c__7365__auto___33420,mults,ensure_mult,p){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33416[(0)] = state_machine__7351__auto__);
(statearr_33416[(1)] = (1));
return statearr_33416;
});
var state_machine__7351__auto____1 = (function (state_33372){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33372);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33417){if((e33417 instanceof Object))
{var ex__7354__auto__ = e33417;var statearr_33418_33449 = state_33372;(statearr_33418_33449[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33372);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33417;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33450 = state_33372;
state_33372 = G__33450;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33372){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33420,mults,ensure_mult,p))
})();var state__7367__auto__ = (function (){var statearr_33419 = f__7366__auto__.call(null);(statearr_33419[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33420);
return statearr_33419;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33420,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__7365__auto___33587 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33587,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33587,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33557){var state_val_33558 = (state_33557[(1)]);if((state_val_33558 === (7)))
{var state_33557__$1 = state_33557;var statearr_33559_33588 = state_33557__$1;(statearr_33559_33588[(2)] = null);
(statearr_33559_33588[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (1)))
{var state_33557__$1 = state_33557;var statearr_33560_33589 = state_33557__$1;(statearr_33560_33589[(2)] = null);
(statearr_33560_33589[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (4)))
{var inst_33521 = (state_33557[(7)]);var inst_33523 = (inst_33521 < cnt);var state_33557__$1 = state_33557;if(cljs.core.truth_(inst_33523))
{var statearr_33561_33590 = state_33557__$1;(statearr_33561_33590[(1)] = (6));
} else
{var statearr_33562_33591 = state_33557__$1;(statearr_33562_33591[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (15)))
{var inst_33553 = (state_33557[(2)]);var state_33557__$1 = state_33557;var statearr_33563_33592 = state_33557__$1;(statearr_33563_33592[(2)] = inst_33553);
(statearr_33563_33592[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (13)))
{var inst_33546 = cljs.core.async.close_BANG_.call(null,out);var state_33557__$1 = state_33557;var statearr_33564_33593 = state_33557__$1;(statearr_33564_33593[(2)] = inst_33546);
(statearr_33564_33593[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (6)))
{var state_33557__$1 = state_33557;var statearr_33565_33594 = state_33557__$1;(statearr_33565_33594[(2)] = null);
(statearr_33565_33594[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (3)))
{var inst_33555 = (state_33557[(2)]);var state_33557__$1 = state_33557;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33557__$1,inst_33555);
} else
{if((state_val_33558 === (12)))
{var inst_33543 = (state_33557[(8)]);var inst_33543__$1 = (state_33557[(2)]);var inst_33544 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_33543__$1);var state_33557__$1 = (function (){var statearr_33566 = state_33557;(statearr_33566[(8)] = inst_33543__$1);
return statearr_33566;
})();if(cljs.core.truth_(inst_33544))
{var statearr_33567_33595 = state_33557__$1;(statearr_33567_33595[(1)] = (13));
} else
{var statearr_33568_33596 = state_33557__$1;(statearr_33568_33596[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (2)))
{var inst_33520 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_33521 = (0);var state_33557__$1 = (function (){var statearr_33569 = state_33557;(statearr_33569[(7)] = inst_33521);
(statearr_33569[(9)] = inst_33520);
return statearr_33569;
})();var statearr_33570_33597 = state_33557__$1;(statearr_33570_33597[(2)] = null);
(statearr_33570_33597[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (11)))
{var inst_33521 = (state_33557[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33557,(10),Object,null,(9));var inst_33530 = chs__$1.call(null,inst_33521);var inst_33531 = done.call(null,inst_33521);var inst_33532 = cljs.core.async.take_BANG_.call(null,inst_33530,inst_33531);var state_33557__$1 = state_33557;var statearr_33571_33598 = state_33557__$1;(statearr_33571_33598[(2)] = inst_33532);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33557__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (9)))
{var inst_33521 = (state_33557[(7)]);var inst_33534 = (state_33557[(2)]);var inst_33535 = (inst_33521 + (1));var inst_33521__$1 = inst_33535;var state_33557__$1 = (function (){var statearr_33572 = state_33557;(statearr_33572[(10)] = inst_33534);
(statearr_33572[(7)] = inst_33521__$1);
return statearr_33572;
})();var statearr_33573_33599 = state_33557__$1;(statearr_33573_33599[(2)] = null);
(statearr_33573_33599[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (5)))
{var inst_33541 = (state_33557[(2)]);var state_33557__$1 = (function (){var statearr_33574 = state_33557;(statearr_33574[(11)] = inst_33541);
return statearr_33574;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33557__$1,(12),dchan);
} else
{if((state_val_33558 === (14)))
{var inst_33543 = (state_33557[(8)]);var inst_33548 = cljs.core.apply.call(null,f,inst_33543);var state_33557__$1 = state_33557;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33557__$1,(16),out,inst_33548);
} else
{if((state_val_33558 === (16)))
{var inst_33550 = (state_33557[(2)]);var state_33557__$1 = (function (){var statearr_33575 = state_33557;(statearr_33575[(12)] = inst_33550);
return statearr_33575;
})();var statearr_33576_33600 = state_33557__$1;(statearr_33576_33600[(2)] = null);
(statearr_33576_33600[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (10)))
{var inst_33525 = (state_33557[(2)]);var inst_33526 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_33557__$1 = (function (){var statearr_33577 = state_33557;(statearr_33577[(13)] = inst_33525);
return statearr_33577;
})();var statearr_33578_33601 = state_33557__$1;(statearr_33578_33601[(2)] = inst_33526);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33557__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33558 === (8)))
{var inst_33539 = (state_33557[(2)]);var state_33557__$1 = state_33557;var statearr_33579_33602 = state_33557__$1;(statearr_33579_33602[(2)] = inst_33539);
(statearr_33579_33602[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33587,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__7350__auto__,c__7365__auto___33587,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33583[(0)] = state_machine__7351__auto__);
(statearr_33583[(1)] = (1));
return statearr_33583;
});
var state_machine__7351__auto____1 = (function (state_33557){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33557);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33584){if((e33584 instanceof Object))
{var ex__7354__auto__ = e33584;var statearr_33585_33603 = state_33557;(statearr_33585_33603[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33557);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33584;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33604 = state_33557;
state_33557 = G__33604;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33557){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33587,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__7367__auto__ = (function (){var statearr_33586 = f__7366__auto__.call(null);(statearr_33586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33587);
return statearr_33586;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33587,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33712 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33712,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33712,out){
return (function (state_33688){var state_val_33689 = (state_33688[(1)]);if((state_val_33689 === (7)))
{var inst_33667 = (state_33688[(7)]);var inst_33668 = (state_33688[(8)]);var inst_33667__$1 = (state_33688[(2)]);var inst_33668__$1 = cljs.core.nth.call(null,inst_33667__$1,(0),null);var inst_33669 = cljs.core.nth.call(null,inst_33667__$1,(1),null);var inst_33670 = (inst_33668__$1 == null);var state_33688__$1 = (function (){var statearr_33690 = state_33688;(statearr_33690[(7)] = inst_33667__$1);
(statearr_33690[(9)] = inst_33669);
(statearr_33690[(8)] = inst_33668__$1);
return statearr_33690;
})();if(cljs.core.truth_(inst_33670))
{var statearr_33691_33713 = state_33688__$1;(statearr_33691_33713[(1)] = (8));
} else
{var statearr_33692_33714 = state_33688__$1;(statearr_33692_33714[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (1)))
{var inst_33659 = cljs.core.vec.call(null,chs);var inst_33660 = inst_33659;var state_33688__$1 = (function (){var statearr_33693 = state_33688;(statearr_33693[(10)] = inst_33660);
return statearr_33693;
})();var statearr_33694_33715 = state_33688__$1;(statearr_33694_33715[(2)] = null);
(statearr_33694_33715[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (4)))
{var inst_33660 = (state_33688[(10)]);var state_33688__$1 = state_33688;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_33688__$1,(7),inst_33660);
} else
{if((state_val_33689 === (6)))
{var inst_33684 = (state_33688[(2)]);var state_33688__$1 = state_33688;var statearr_33695_33716 = state_33688__$1;(statearr_33695_33716[(2)] = inst_33684);
(statearr_33695_33716[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (3)))
{var inst_33686 = (state_33688[(2)]);var state_33688__$1 = state_33688;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33688__$1,inst_33686);
} else
{if((state_val_33689 === (2)))
{var inst_33660 = (state_33688[(10)]);var inst_33662 = cljs.core.count.call(null,inst_33660);var inst_33663 = (inst_33662 > (0));var state_33688__$1 = state_33688;if(cljs.core.truth_(inst_33663))
{var statearr_33697_33717 = state_33688__$1;(statearr_33697_33717[(1)] = (4));
} else
{var statearr_33698_33718 = state_33688__$1;(statearr_33698_33718[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (11)))
{var inst_33660 = (state_33688[(10)]);var inst_33677 = (state_33688[(2)]);var tmp33696 = inst_33660;var inst_33660__$1 = tmp33696;var state_33688__$1 = (function (){var statearr_33699 = state_33688;(statearr_33699[(10)] = inst_33660__$1);
(statearr_33699[(11)] = inst_33677);
return statearr_33699;
})();var statearr_33700_33719 = state_33688__$1;(statearr_33700_33719[(2)] = null);
(statearr_33700_33719[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (9)))
{var inst_33668 = (state_33688[(8)]);var state_33688__$1 = state_33688;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33688__$1,(11),out,inst_33668);
} else
{if((state_val_33689 === (5)))
{var inst_33682 = cljs.core.async.close_BANG_.call(null,out);var state_33688__$1 = state_33688;var statearr_33701_33720 = state_33688__$1;(statearr_33701_33720[(2)] = inst_33682);
(statearr_33701_33720[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (10)))
{var inst_33680 = (state_33688[(2)]);var state_33688__$1 = state_33688;var statearr_33702_33721 = state_33688__$1;(statearr_33702_33721[(2)] = inst_33680);
(statearr_33702_33721[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33689 === (8)))
{var inst_33667 = (state_33688[(7)]);var inst_33660 = (state_33688[(10)]);var inst_33669 = (state_33688[(9)]);var inst_33668 = (state_33688[(8)]);var inst_33672 = (function (){var c = inst_33669;var v = inst_33668;var vec__33665 = inst_33667;var cs = inst_33660;return ((function (c,v,vec__33665,cs,inst_33667,inst_33660,inst_33669,inst_33668,state_val_33689,c__7365__auto___33712,out){
return (function (p1__33605_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__33605_SHARP_);
});
;})(c,v,vec__33665,cs,inst_33667,inst_33660,inst_33669,inst_33668,state_val_33689,c__7365__auto___33712,out))
})();var inst_33673 = cljs.core.filterv.call(null,inst_33672,inst_33660);var inst_33660__$1 = inst_33673;var state_33688__$1 = (function (){var statearr_33703 = state_33688;(statearr_33703[(10)] = inst_33660__$1);
return statearr_33703;
})();var statearr_33704_33722 = state_33688__$1;(statearr_33704_33722[(2)] = null);
(statearr_33704_33722[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33712,out))
;return ((function (switch__7350__auto__,c__7365__auto___33712,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33708 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33708[(0)] = state_machine__7351__auto__);
(statearr_33708[(1)] = (1));
return statearr_33708;
});
var state_machine__7351__auto____1 = (function (state_33688){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33688);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33709){if((e33709 instanceof Object))
{var ex__7354__auto__ = e33709;var statearr_33710_33723 = state_33688;(statearr_33710_33723[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33688);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33709;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33724 = state_33688;
state_33688 = G__33724;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33688){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33712,out))
})();var state__7367__auto__ = (function (){var statearr_33711 = f__7366__auto__.call(null);(statearr_33711[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33712);
return statearr_33711;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33712,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33817 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33817,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33817,out){
return (function (state_33794){var state_val_33795 = (state_33794[(1)]);if((state_val_33795 === (7)))
{var inst_33776 = (state_33794[(7)]);var inst_33776__$1 = (state_33794[(2)]);var inst_33777 = (inst_33776__$1 == null);var inst_33778 = cljs.core.not.call(null,inst_33777);var state_33794__$1 = (function (){var statearr_33796 = state_33794;(statearr_33796[(7)] = inst_33776__$1);
return statearr_33796;
})();if(inst_33778)
{var statearr_33797_33818 = state_33794__$1;(statearr_33797_33818[(1)] = (8));
} else
{var statearr_33798_33819 = state_33794__$1;(statearr_33798_33819[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (1)))
{var inst_33771 = (0);var state_33794__$1 = (function (){var statearr_33799 = state_33794;(statearr_33799[(8)] = inst_33771);
return statearr_33799;
})();var statearr_33800_33820 = state_33794__$1;(statearr_33800_33820[(2)] = null);
(statearr_33800_33820[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (4)))
{var state_33794__$1 = state_33794;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33794__$1,(7),ch);
} else
{if((state_val_33795 === (6)))
{var inst_33789 = (state_33794[(2)]);var state_33794__$1 = state_33794;var statearr_33801_33821 = state_33794__$1;(statearr_33801_33821[(2)] = inst_33789);
(statearr_33801_33821[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (3)))
{var inst_33791 = (state_33794[(2)]);var inst_33792 = cljs.core.async.close_BANG_.call(null,out);var state_33794__$1 = (function (){var statearr_33802 = state_33794;(statearr_33802[(9)] = inst_33791);
return statearr_33802;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33794__$1,inst_33792);
} else
{if((state_val_33795 === (2)))
{var inst_33771 = (state_33794[(8)]);var inst_33773 = (inst_33771 < n);var state_33794__$1 = state_33794;if(cljs.core.truth_(inst_33773))
{var statearr_33803_33822 = state_33794__$1;(statearr_33803_33822[(1)] = (4));
} else
{var statearr_33804_33823 = state_33794__$1;(statearr_33804_33823[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (11)))
{var inst_33771 = (state_33794[(8)]);var inst_33781 = (state_33794[(2)]);var inst_33782 = (inst_33771 + (1));var inst_33771__$1 = inst_33782;var state_33794__$1 = (function (){var statearr_33805 = state_33794;(statearr_33805[(10)] = inst_33781);
(statearr_33805[(8)] = inst_33771__$1);
return statearr_33805;
})();var statearr_33806_33824 = state_33794__$1;(statearr_33806_33824[(2)] = null);
(statearr_33806_33824[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (9)))
{var state_33794__$1 = state_33794;var statearr_33807_33825 = state_33794__$1;(statearr_33807_33825[(2)] = null);
(statearr_33807_33825[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (5)))
{var state_33794__$1 = state_33794;var statearr_33808_33826 = state_33794__$1;(statearr_33808_33826[(2)] = null);
(statearr_33808_33826[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (10)))
{var inst_33786 = (state_33794[(2)]);var state_33794__$1 = state_33794;var statearr_33809_33827 = state_33794__$1;(statearr_33809_33827[(2)] = inst_33786);
(statearr_33809_33827[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33795 === (8)))
{var inst_33776 = (state_33794[(7)]);var state_33794__$1 = state_33794;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33794__$1,(11),out,inst_33776);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33817,out))
;return ((function (switch__7350__auto__,c__7365__auto___33817,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33813 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_33813[(0)] = state_machine__7351__auto__);
(statearr_33813[(1)] = (1));
return statearr_33813;
});
var state_machine__7351__auto____1 = (function (state_33794){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33794);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33814){if((e33814 instanceof Object))
{var ex__7354__auto__ = e33814;var statearr_33815_33828 = state_33794;(statearr_33815_33828[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33794);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33814;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33829 = state_33794;
state_33794 = G__33829;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33794){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33817,out))
})();var state__7367__auto__ = (function (){var statearr_33816 = f__7366__auto__.call(null);(statearr_33816[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33817);
return statearr_33816;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33817,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33926 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33926,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33926,out){
return (function (state_33901){var state_val_33902 = (state_33901[(1)]);if((state_val_33902 === (7)))
{var inst_33896 = (state_33901[(2)]);var state_33901__$1 = state_33901;var statearr_33903_33927 = state_33901__$1;(statearr_33903_33927[(2)] = inst_33896);
(statearr_33903_33927[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (1)))
{var inst_33878 = null;var state_33901__$1 = (function (){var statearr_33904 = state_33901;(statearr_33904[(7)] = inst_33878);
return statearr_33904;
})();var statearr_33905_33928 = state_33901__$1;(statearr_33905_33928[(2)] = null);
(statearr_33905_33928[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (4)))
{var inst_33881 = (state_33901[(8)]);var inst_33881__$1 = (state_33901[(2)]);var inst_33882 = (inst_33881__$1 == null);var inst_33883 = cljs.core.not.call(null,inst_33882);var state_33901__$1 = (function (){var statearr_33906 = state_33901;(statearr_33906[(8)] = inst_33881__$1);
return statearr_33906;
})();if(inst_33883)
{var statearr_33907_33929 = state_33901__$1;(statearr_33907_33929[(1)] = (5));
} else
{var statearr_33908_33930 = state_33901__$1;(statearr_33908_33930[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (6)))
{var state_33901__$1 = state_33901;var statearr_33909_33931 = state_33901__$1;(statearr_33909_33931[(2)] = null);
(statearr_33909_33931[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (3)))
{var inst_33898 = (state_33901[(2)]);var inst_33899 = cljs.core.async.close_BANG_.call(null,out);var state_33901__$1 = (function (){var statearr_33910 = state_33901;(statearr_33910[(9)] = inst_33898);
return statearr_33910;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33901__$1,inst_33899);
} else
{if((state_val_33902 === (2)))
{var state_33901__$1 = state_33901;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33901__$1,(4),ch);
} else
{if((state_val_33902 === (11)))
{var inst_33881 = (state_33901[(8)]);var inst_33890 = (state_33901[(2)]);var inst_33878 = inst_33881;var state_33901__$1 = (function (){var statearr_33911 = state_33901;(statearr_33911[(10)] = inst_33890);
(statearr_33911[(7)] = inst_33878);
return statearr_33911;
})();var statearr_33912_33932 = state_33901__$1;(statearr_33912_33932[(2)] = null);
(statearr_33912_33932[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (9)))
{var inst_33881 = (state_33901[(8)]);var state_33901__$1 = state_33901;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33901__$1,(11),out,inst_33881);
} else
{if((state_val_33902 === (5)))
{var inst_33881 = (state_33901[(8)]);var inst_33878 = (state_33901[(7)]);var inst_33885 = cljs.core._EQ_.call(null,inst_33881,inst_33878);var state_33901__$1 = state_33901;if(inst_33885)
{var statearr_33914_33933 = state_33901__$1;(statearr_33914_33933[(1)] = (8));
} else
{var statearr_33915_33934 = state_33901__$1;(statearr_33915_33934[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (10)))
{var inst_33893 = (state_33901[(2)]);var state_33901__$1 = state_33901;var statearr_33916_33935 = state_33901__$1;(statearr_33916_33935[(2)] = inst_33893);
(statearr_33916_33935[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33902 === (8)))
{var inst_33878 = (state_33901[(7)]);var tmp33913 = inst_33878;var inst_33878__$1 = tmp33913;var state_33901__$1 = (function (){var statearr_33917 = state_33901;(statearr_33917[(7)] = inst_33878__$1);
return statearr_33917;
})();var statearr_33918_33936 = state_33901__$1;(statearr_33918_33936[(2)] = null);
(statearr_33918_33936[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33926,out))
;return ((function (switch__7350__auto__,c__7365__auto___33926,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33922 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_33922[(0)] = state_machine__7351__auto__);
(statearr_33922[(1)] = (1));
return statearr_33922;
});
var state_machine__7351__auto____1 = (function (state_33901){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33901);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33923){if((e33923 instanceof Object))
{var ex__7354__auto__ = e33923;var statearr_33924_33937 = state_33901;(statearr_33924_33937[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33901);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33923;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33938 = state_33901;
state_33901 = G__33938;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33901){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33926,out))
})();var state__7367__auto__ = (function (){var statearr_33925 = f__7366__auto__.call(null);(statearr_33925[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33926);
return statearr_33925;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33926,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___34073 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___34073,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___34073,out){
return (function (state_34043){var state_val_34044 = (state_34043[(1)]);if((state_val_34044 === (7)))
{var inst_34039 = (state_34043[(2)]);var state_34043__$1 = state_34043;var statearr_34045_34074 = state_34043__$1;(statearr_34045_34074[(2)] = inst_34039);
(statearr_34045_34074[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (1)))
{var inst_34006 = (new Array(n));var inst_34007 = inst_34006;var inst_34008 = (0);var state_34043__$1 = (function (){var statearr_34046 = state_34043;(statearr_34046[(7)] = inst_34007);
(statearr_34046[(8)] = inst_34008);
return statearr_34046;
})();var statearr_34047_34075 = state_34043__$1;(statearr_34047_34075[(2)] = null);
(statearr_34047_34075[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (4)))
{var inst_34011 = (state_34043[(9)]);var inst_34011__$1 = (state_34043[(2)]);var inst_34012 = (inst_34011__$1 == null);var inst_34013 = cljs.core.not.call(null,inst_34012);var state_34043__$1 = (function (){var statearr_34048 = state_34043;(statearr_34048[(9)] = inst_34011__$1);
return statearr_34048;
})();if(inst_34013)
{var statearr_34049_34076 = state_34043__$1;(statearr_34049_34076[(1)] = (5));
} else
{var statearr_34050_34077 = state_34043__$1;(statearr_34050_34077[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (15)))
{var inst_34033 = (state_34043[(2)]);var state_34043__$1 = state_34043;var statearr_34051_34078 = state_34043__$1;(statearr_34051_34078[(2)] = inst_34033);
(statearr_34051_34078[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (13)))
{var state_34043__$1 = state_34043;var statearr_34052_34079 = state_34043__$1;(statearr_34052_34079[(2)] = null);
(statearr_34052_34079[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (6)))
{var inst_34008 = (state_34043[(8)]);var inst_34029 = (inst_34008 > (0));var state_34043__$1 = state_34043;if(cljs.core.truth_(inst_34029))
{var statearr_34053_34080 = state_34043__$1;(statearr_34053_34080[(1)] = (12));
} else
{var statearr_34054_34081 = state_34043__$1;(statearr_34054_34081[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (3)))
{var inst_34041 = (state_34043[(2)]);var state_34043__$1 = state_34043;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34043__$1,inst_34041);
} else
{if((state_val_34044 === (12)))
{var inst_34007 = (state_34043[(7)]);var inst_34031 = cljs.core.vec.call(null,inst_34007);var state_34043__$1 = state_34043;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34043__$1,(15),out,inst_34031);
} else
{if((state_val_34044 === (2)))
{var state_34043__$1 = state_34043;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34043__$1,(4),ch);
} else
{if((state_val_34044 === (11)))
{var inst_34023 = (state_34043[(2)]);var inst_34024 = (new Array(n));var inst_34007 = inst_34024;var inst_34008 = (0);var state_34043__$1 = (function (){var statearr_34055 = state_34043;(statearr_34055[(7)] = inst_34007);
(statearr_34055[(10)] = inst_34023);
(statearr_34055[(8)] = inst_34008);
return statearr_34055;
})();var statearr_34056_34082 = state_34043__$1;(statearr_34056_34082[(2)] = null);
(statearr_34056_34082[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (9)))
{var inst_34007 = (state_34043[(7)]);var inst_34021 = cljs.core.vec.call(null,inst_34007);var state_34043__$1 = state_34043;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34043__$1,(11),out,inst_34021);
} else
{if((state_val_34044 === (5)))
{var inst_34007 = (state_34043[(7)]);var inst_34016 = (state_34043[(11)]);var inst_34011 = (state_34043[(9)]);var inst_34008 = (state_34043[(8)]);var inst_34015 = (inst_34007[inst_34008] = inst_34011);var inst_34016__$1 = (inst_34008 + (1));var inst_34017 = (inst_34016__$1 < n);var state_34043__$1 = (function (){var statearr_34057 = state_34043;(statearr_34057[(12)] = inst_34015);
(statearr_34057[(11)] = inst_34016__$1);
return statearr_34057;
})();if(cljs.core.truth_(inst_34017))
{var statearr_34058_34083 = state_34043__$1;(statearr_34058_34083[(1)] = (8));
} else
{var statearr_34059_34084 = state_34043__$1;(statearr_34059_34084[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (14)))
{var inst_34036 = (state_34043[(2)]);var inst_34037 = cljs.core.async.close_BANG_.call(null,out);var state_34043__$1 = (function (){var statearr_34061 = state_34043;(statearr_34061[(13)] = inst_34036);
return statearr_34061;
})();var statearr_34062_34085 = state_34043__$1;(statearr_34062_34085[(2)] = inst_34037);
(statearr_34062_34085[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (10)))
{var inst_34027 = (state_34043[(2)]);var state_34043__$1 = state_34043;var statearr_34063_34086 = state_34043__$1;(statearr_34063_34086[(2)] = inst_34027);
(statearr_34063_34086[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34044 === (8)))
{var inst_34007 = (state_34043[(7)]);var inst_34016 = (state_34043[(11)]);var tmp34060 = inst_34007;var inst_34007__$1 = tmp34060;var inst_34008 = inst_34016;var state_34043__$1 = (function (){var statearr_34064 = state_34043;(statearr_34064[(7)] = inst_34007__$1);
(statearr_34064[(8)] = inst_34008);
return statearr_34064;
})();var statearr_34065_34087 = state_34043__$1;(statearr_34065_34087[(2)] = null);
(statearr_34065_34087[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___34073,out))
;return ((function (switch__7350__auto__,c__7365__auto___34073,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_34069 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_34069[(0)] = state_machine__7351__auto__);
(statearr_34069[(1)] = (1));
return statearr_34069;
});
var state_machine__7351__auto____1 = (function (state_34043){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_34043);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e34070){if((e34070 instanceof Object))
{var ex__7354__auto__ = e34070;var statearr_34071_34088 = state_34043;(statearr_34071_34088[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34043);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e34070;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__34089 = state_34043;
state_34043 = G__34089;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_34043){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_34043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___34073,out))
})();var state__7367__auto__ = (function (){var statearr_34072 = f__7366__auto__.call(null);(statearr_34072[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___34073);
return statearr_34072;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___34073,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___34232 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___34232,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___34232,out){
return (function (state_34202){var state_val_34203 = (state_34202[(1)]);if((state_val_34203 === (7)))
{var inst_34198 = (state_34202[(2)]);var state_34202__$1 = state_34202;var statearr_34204_34233 = state_34202__$1;(statearr_34204_34233[(2)] = inst_34198);
(statearr_34204_34233[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (1)))
{var inst_34161 = [];var inst_34162 = inst_34161;var inst_34163 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_34202__$1 = (function (){var statearr_34205 = state_34202;(statearr_34205[(7)] = inst_34162);
(statearr_34205[(8)] = inst_34163);
return statearr_34205;
})();var statearr_34206_34234 = state_34202__$1;(statearr_34206_34234[(2)] = null);
(statearr_34206_34234[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (4)))
{var inst_34166 = (state_34202[(9)]);var inst_34166__$1 = (state_34202[(2)]);var inst_34167 = (inst_34166__$1 == null);var inst_34168 = cljs.core.not.call(null,inst_34167);var state_34202__$1 = (function (){var statearr_34207 = state_34202;(statearr_34207[(9)] = inst_34166__$1);
return statearr_34207;
})();if(inst_34168)
{var statearr_34208_34235 = state_34202__$1;(statearr_34208_34235[(1)] = (5));
} else
{var statearr_34209_34236 = state_34202__$1;(statearr_34209_34236[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (15)))
{var inst_34192 = (state_34202[(2)]);var state_34202__$1 = state_34202;var statearr_34210_34237 = state_34202__$1;(statearr_34210_34237[(2)] = inst_34192);
(statearr_34210_34237[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (13)))
{var state_34202__$1 = state_34202;var statearr_34211_34238 = state_34202__$1;(statearr_34211_34238[(2)] = null);
(statearr_34211_34238[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (6)))
{var inst_34162 = (state_34202[(7)]);var inst_34187 = inst_34162.length;var inst_34188 = (inst_34187 > (0));var state_34202__$1 = state_34202;if(cljs.core.truth_(inst_34188))
{var statearr_34212_34239 = state_34202__$1;(statearr_34212_34239[(1)] = (12));
} else
{var statearr_34213_34240 = state_34202__$1;(statearr_34213_34240[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (3)))
{var inst_34200 = (state_34202[(2)]);var state_34202__$1 = state_34202;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34202__$1,inst_34200);
} else
{if((state_val_34203 === (12)))
{var inst_34162 = (state_34202[(7)]);var inst_34190 = cljs.core.vec.call(null,inst_34162);var state_34202__$1 = state_34202;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34202__$1,(15),out,inst_34190);
} else
{if((state_val_34203 === (2)))
{var state_34202__$1 = state_34202;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34202__$1,(4),ch);
} else
{if((state_val_34203 === (11)))
{var inst_34170 = (state_34202[(10)]);var inst_34166 = (state_34202[(9)]);var inst_34180 = (state_34202[(2)]);var inst_34181 = [];var inst_34182 = inst_34181.push(inst_34166);var inst_34162 = inst_34181;var inst_34163 = inst_34170;var state_34202__$1 = (function (){var statearr_34214 = state_34202;(statearr_34214[(11)] = inst_34180);
(statearr_34214[(12)] = inst_34182);
(statearr_34214[(7)] = inst_34162);
(statearr_34214[(8)] = inst_34163);
return statearr_34214;
})();var statearr_34215_34241 = state_34202__$1;(statearr_34215_34241[(2)] = null);
(statearr_34215_34241[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (9)))
{var inst_34162 = (state_34202[(7)]);var inst_34178 = cljs.core.vec.call(null,inst_34162);var state_34202__$1 = state_34202;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34202__$1,(11),out,inst_34178);
} else
{if((state_val_34203 === (5)))
{var inst_34170 = (state_34202[(10)]);var inst_34166 = (state_34202[(9)]);var inst_34163 = (state_34202[(8)]);var inst_34170__$1 = f.call(null,inst_34166);var inst_34171 = cljs.core._EQ_.call(null,inst_34170__$1,inst_34163);var inst_34172 = cljs.core.keyword_identical_QMARK_.call(null,inst_34163,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_34173 = (inst_34171) || (inst_34172);var state_34202__$1 = (function (){var statearr_34216 = state_34202;(statearr_34216[(10)] = inst_34170__$1);
return statearr_34216;
})();if(cljs.core.truth_(inst_34173))
{var statearr_34217_34242 = state_34202__$1;(statearr_34217_34242[(1)] = (8));
} else
{var statearr_34218_34243 = state_34202__$1;(statearr_34218_34243[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (14)))
{var inst_34195 = (state_34202[(2)]);var inst_34196 = cljs.core.async.close_BANG_.call(null,out);var state_34202__$1 = (function (){var statearr_34220 = state_34202;(statearr_34220[(13)] = inst_34195);
return statearr_34220;
})();var statearr_34221_34244 = state_34202__$1;(statearr_34221_34244[(2)] = inst_34196);
(statearr_34221_34244[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (10)))
{var inst_34185 = (state_34202[(2)]);var state_34202__$1 = state_34202;var statearr_34222_34245 = state_34202__$1;(statearr_34222_34245[(2)] = inst_34185);
(statearr_34222_34245[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34203 === (8)))
{var inst_34170 = (state_34202[(10)]);var inst_34166 = (state_34202[(9)]);var inst_34162 = (state_34202[(7)]);var inst_34175 = inst_34162.push(inst_34166);var tmp34219 = inst_34162;var inst_34162__$1 = tmp34219;var inst_34163 = inst_34170;var state_34202__$1 = (function (){var statearr_34223 = state_34202;(statearr_34223[(14)] = inst_34175);
(statearr_34223[(7)] = inst_34162__$1);
(statearr_34223[(8)] = inst_34163);
return statearr_34223;
})();var statearr_34224_34246 = state_34202__$1;(statearr_34224_34246[(2)] = null);
(statearr_34224_34246[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___34232,out))
;return ((function (switch__7350__auto__,c__7365__auto___34232,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_34228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_34228[(0)] = state_machine__7351__auto__);
(statearr_34228[(1)] = (1));
return statearr_34228;
});
var state_machine__7351__auto____1 = (function (state_34202){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_34202);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e34229){if((e34229 instanceof Object))
{var ex__7354__auto__ = e34229;var statearr_34230_34247 = state_34202;(statearr_34230_34247[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34202);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e34229;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__34248 = state_34202;
state_34202 = G__34248;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_34202){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_34202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___34232,out))
})();var state__7367__auto__ = (function (){var statearr_34231 = f__7366__auto__.call(null);(statearr_34231[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___34232);
return statearr_34231;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___34232,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map