// Compiled by ClojureScript 0.0-2277
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('schema.utils');
goog.require('schema.core');
goog.require('schema.core');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__13991__13992__auto__){var G__36203 = p1__13991__13992__auto__;if(G__36203)
{var bit__4191__auto__ = null;if(cljs.core.truth_((function (){var or__3541__auto__ = bit__4191__auto__;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return G__36203.schema$core$Schema$;
}
})()))
{return true;
} else
{if((!G__36203.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,G__36203);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,G__36203);
}
})], null));
plumbing.fnk.schema.InputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.MapOutputSchema = new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
* Like (assert (distinct? things)) but with a more helpful error message.
*/
plumbing.fnk.schema.assert_distinct = (function assert_distinct(things){var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__36204_SHARP_){return (cljs.core.val.call(null,p1__36204_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));if(cljs.core.empty_QMARK_.call(null,repeated_things))
{return null;
} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
* Like (get m k), but throws if k is not present in m.
*/
plumbing.fnk.schema.safe_get = (function safe_get(m,k,key_path){if(cljs.core.map_QMARK_.call(null,m))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}
var vec__36206 = cljs.core.find.call(null,m,k);var _ = cljs.core.nth.call(null,vec__36206,(0),null);var v = cljs.core.nth.call(null,vec__36206,(1),null);var p = vec__36206;if(cljs.core.truth_(p))
{} else
{throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}
return v;
});
plumbing.fnk.schema.non_map_union = (function non_map_union(s1,s2){if(cljs.core._EQ_.call(null,s1,s2))
{return s1;
} else
{if(cljs.core._EQ_.call(null,s1,schema.core.Any))
{return s2;
} else
{if(cljs.core._EQ_.call(null,s2,schema.core.Any))
{return s1;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return schema.core.both.call(null,s1,s2);
} else
{return null;
}
}
}
}
});
/**
* Return a difference of schmas s1 and s2, where one is not a map.
* Punt for now, assuming s2 always satisfies s1.
*/
plumbing.fnk.schema.non_map_diff = (function non_map_diff(s1,s2){return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function map_schema_QMARK_(m){return ((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap));
});
var ufv___36212 = schema.utils.use_fn_validation;var output_schema36207_36213 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));var input_schema36208_36214 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"k","k",-505765866,null))], null);var input_checker36209_36215 = schema.core.checker.call(null,input_schema36208_36214);var output_checker36210_36216 = schema.core.checker.call(null,output_schema36207_36213);/**
* Inputs: [k]
* Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
* 
* Given a possibly-unevaluated schema map key form, unpack an explicit keyword
* and optional? flag, or return nil for a non-explicit key
*/
plumbing.fnk.schema.unwrap_schema_form_key = ((function (ufv___36212,output_schema36207_36213,input_schema36208_36214,input_checker36209_36215,output_checker36210_36216){
return (function unwrap_schema_form_key(G__36211){var validate__13961__auto__ = ufv___36212.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36217 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36211], null);var temp__4126__auto___36218 = input_checker36209_36215.call(null,args__13962__auto___36217);if(cljs.core.truth_(temp__4126__auto___36218))
{var error__13963__auto___36219 = temp__4126__auto___36218;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),cljs.core.pr_str.call(null,error__13963__auto___36219)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36208_36214,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36217,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36219], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var k = G__36211;while(true){
if(schema.core.specific_key_QMARK_.call(null,k))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else
{if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null))))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else
{return null;
}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36220 = output_checker36210_36216.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36220))
{var error__13963__auto___36221 = temp__4126__auto___36220;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),cljs.core.pr_str.call(null,error__13963__auto___36221)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36207_36213,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36221], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36212,output_schema36207_36213,input_schema36208_36214,input_checker36209_36215,output_checker36210_36216))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema36207_36213,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36208_36214], null)));
var ufv___36227 = schema.utils.use_fn_validation;var output_schema36222_36228 = schema.core.Any;var input_schema36223_36229 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"s","s",-948495851,null))], null);var input_checker36224_36230 = schema.core.checker.call(null,input_schema36223_36229);var output_checker36225_36231 = schema.core.checker.call(null,output_schema36222_36228);/**
* Inputs: [s]
* 
* Given a possibly-unevaluated map schema, return a map from bare keyword to true
* (for required) or false (for optional)
*/
plumbing.fnk.schema.explicit_schema_key_map = ((function (ufv___36227,output_schema36222_36228,input_schema36223_36229,input_checker36224_36230,output_checker36225_36231){
return (function explicit_schema_key_map(G__36226){var validate__13961__auto__ = ufv___36227.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36232 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36226], null);var temp__4126__auto___36233 = input_checker36224_36230.call(null,args__13962__auto___36232);if(cljs.core.truth_(temp__4126__auto___36233))
{var error__13963__auto___36234 = temp__4126__auto___36233;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),cljs.core.pr_str.call(null,error__13963__auto___36234)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36223_36229,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36232,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36234], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var s = G__36226;while(true){
new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36235 = output_checker36225_36231.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36235))
{var error__13963__auto___36236 = temp__4126__auto___36235;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),cljs.core.pr_str.call(null,error__13963__auto___36236)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36222_36228,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36236], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36227,output_schema36222_36228,input_schema36223_36229,input_checker36224_36230,output_checker36225_36231))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema36222_36228,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36223_36229], null)));
var ufv___36242 = schema.utils.use_fn_validation;var output_schema36237_36243 = schema.core.Any;var input_schema36238_36244 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false),new cljs.core.Symbol(null,"s","s",-948495851,null))], null);var input_checker36239_36245 = schema.core.checker.call(null,input_schema36238_36244);var output_checker36240_36246 = schema.core.checker.call(null,output_schema36237_36243);/**
* Inputs: [s :- {s/Keyword s/Bool}]
* 
* Given output of explicit-schema-key-map, split into seq [req opt].
*/
plumbing.fnk.schema.split_schema_keys = ((function (ufv___36242,output_schema36237_36243,input_schema36238_36244,input_checker36239_36245,output_checker36240_36246){
return (function split_schema_keys(G__36241){var validate__13961__auto__ = ufv___36242.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36247 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36241], null);var temp__4126__auto___36248 = input_checker36239_36245.call(null,args__13962__auto___36247);if(cljs.core.truth_(temp__4126__auto___36248))
{var error__13963__auto___36249 = temp__4126__auto___36248;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),cljs.core.pr_str.call(null,error__13963__auto___36249)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36238_36244,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36247,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36249], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var s = G__36241;while(true){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36250 = output_checker36240_36246.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36250))
{var error__13963__auto___36251 = temp__4126__auto___36250;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),cljs.core.pr_str.call(null,error__13963__auto___36251)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36237_36243,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36251], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36242,output_schema36237_36243,input_schema36238_36244,input_checker36239_36245,output_checker36240_36246))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema36237_36243,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36238_36244], null)));
/**
* Like merge-with, but also projects keys to a smaller space and merges them similar to the
* values.
* @param {...*} var_args
*/
plumbing.fnk.schema.merge_on_with = (function() { 
var merge_on_with__delegate = function (key_project,key_combine,val_combine,maps){return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__36255){var vec__36256 = p__36255;var k = cljs.core.nth.call(null,vec__36256,(0),null);var v = cljs.core.nth.call(null,vec__36256,(1),null);var pk = key_project.call(null,k);var temp__4124__auto__ = cljs.core.get.call(null,m,pk);if(cljs.core.truth_(temp__4124__auto__))
{var vec__36257 = temp__4124__auto__;var ok = cljs.core.nth.call(null,vec__36257,(0),null);var ov = cljs.core.nth.call(null,vec__36257,(1),null);return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else
{return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
};
var merge_on_with = function (key_project,key_combine,val_combine,var_args){
var maps = null;if (arguments.length > 3) {
  maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return merge_on_with__delegate.call(this,key_project,key_combine,val_combine,maps);};
merge_on_with.cljs$lang$maxFixedArity = 3;
merge_on_with.cljs$lang$applyTo = (function (arglist__36258){
var key_project = cljs.core.first(arglist__36258);
arglist__36258 = cljs.core.next(arglist__36258);
var key_combine = cljs.core.first(arglist__36258);
arglist__36258 = cljs.core.next(arglist__36258);
var val_combine = cljs.core.first(arglist__36258);
var maps = cljs.core.rest(arglist__36258);
return merge_on_with__delegate(key_project,key_combine,val_combine,maps);
});
merge_on_with.cljs$core$IFn$_invoke$arity$variadic = merge_on_with__delegate;
return merge_on_with;
})()
;
var ufv___36266 = schema.utils.use_fn_validation;var output_schema36260_36267 = plumbing.fnk.schema.InputSchema;var input_schema36261_36268 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"i1","i1",-572470430,null)),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"i2","i2",850408895,null))], null);var input_checker36262_36269 = schema.core.checker.call(null,input_schema36261_36268);var output_checker36263_36270 = schema.core.checker.call(null,output_schema36260_36267);/**
* Inputs: [i1 :- InputSchema i2 :- InputSchema]
* Returns: InputSchema
* 
* Returns a minimal input schema schema that entails satisfaction of both s1 and s2
*/
plumbing.fnk.schema.union_input_schemata = ((function (ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270){
return (function union_input_schemata(G__36264,G__36265){var validate__13961__auto__ = ufv___36266.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36271 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36264,G__36265], null);var temp__4126__auto___36272 = input_checker36262_36269.call(null,args__13962__auto___36271);if(cljs.core.truth_(temp__4126__auto___36272))
{var error__13963__auto___36273 = temp__4126__auto___36272;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),cljs.core.pr_str.call(null,error__13963__auto___36273)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36261_36268,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36271,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36273], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var i1 = G__36264;var i2 = G__36265;while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__13961__auto__,ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270){
return (function (p1__36259_SHARP_){if(schema.core.specific_key_QMARK_.call(null,p1__36259_SHARP_))
{return schema.core.explicit_schema_key.call(null,p1__36259_SHARP_);
} else
{return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__13961__auto__,ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270))
,((function (validate__13961__auto__,ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270){
return (function (k1,k2){if(schema.core.required_key_QMARK_.call(null,k1))
{return k1;
} else
{if(schema.core.required_key_QMARK_.call(null,k2))
{return k2;
} else
{if(schema.core.optional_key_QMARK_.call(null,k1))
{if(cljs.core._EQ_.call(null,k1,k2))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"k1","k1",-1701777341,null),new cljs.core.Symbol(null,"k2","k2",-1225133949,null)))))));
}
return k1;
} else
{if(cljs.core._EQ_.call(null,k1,k2))
{return k1;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{if(false)
{return null;
} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));
}
} else
{return null;
}
}
}
}
}
});})(validate__13961__auto__,ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270))
,((function (validate__13961__auto__,ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270){
return (function (s1,s2){if((plumbing.fnk.schema.map_schema_QMARK_.call(null,s1)) && (plumbing.fnk.schema.map_schema_QMARK_.call(null,s2)))
{return union_input_schemata.call(null,s1,s2);
} else
{return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__13961__auto__,ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270))
,i1,i2);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36274 = output_checker36263_36270.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36274))
{var error__13963__auto___36275 = temp__4126__auto___36274;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),cljs.core.pr_str.call(null,error__13963__auto___36275)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36260_36267,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36275], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36266,output_schema36260_36267,input_schema36261_36268,input_checker36262_36269,output_checker36263_36270))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema36260_36267,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36261_36268], null)));
var ufv___36281 = schema.utils.use_fn_validation;var output_schema36276_36282 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);var input_schema36277_36283 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null))], null);var input_checker36278_36284 = schema.core.checker.call(null,input_schema36277_36283);var output_checker36279_36285 = schema.core.checker.call(null,output_schema36276_36282);/**
* Inputs: [input-schema :- InputSchema]
* Returns: [s/Keyword]
* 
* Which top-level keys are required (i.e., non-false) by this input schema.
*/
plumbing.fnk.schema.required_toplevel_keys = ((function (ufv___36281,output_schema36276_36282,input_schema36277_36283,input_checker36278_36284,output_checker36279_36285){
return (function required_toplevel_keys(G__36280){var validate__13961__auto__ = ufv___36281.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36286 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36280], null);var temp__4126__auto___36287 = input_checker36278_36284.call(null,args__13962__auto___36286);if(cljs.core.truth_(temp__4126__auto___36287))
{var error__13963__auto___36288 = temp__4126__auto___36287;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),cljs.core.pr_str.call(null,error__13963__auto___36288)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36277_36283,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36286,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36288], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var input_schema = G__36280;while(true){
return cljs.core.keep.call(null,((function (validate__13961__auto__,ufv___36281,output_schema36276_36282,input_schema36277_36283,input_checker36278_36284,output_checker36279_36285){
return (function (k){if(schema.core.required_key_QMARK_.call(null,k))
{return schema.core.explicit_schema_key.call(null,k);
} else
{return null;
}
});})(validate__13961__auto__,ufv___36281,output_schema36276_36282,input_schema36277_36283,input_checker36278_36284,output_checker36279_36285))
,cljs.core.keys.call(null,input_schema));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36289 = output_checker36279_36285.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36289))
{var error__13963__auto___36290 = temp__4126__auto___36289;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),cljs.core.pr_str.call(null,error__13963__auto___36290)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36276_36282,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36290], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36281,output_schema36276_36282,input_schema36277_36283,input_checker36278_36284,output_checker36279_36285))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema36276_36282,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36277_36283], null)));
/**
* Guess an output schema for an expr.  Currently just looks for literal map structure and
* all keyword keys.
*/
plumbing.fnk.schema.guess_expr_output_schema = (function guess_expr_output_schema(expr){if((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr))))
{return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = (function iter__36299(s__36300){return (new cljs.core.LazySeq(null,(function (){var s__36300__$1 = s__36300;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36300__$1);if(temp__4126__auto__)
{var s__36300__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36300__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36300__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36302 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36301 = (0);while(true){
if((i__36301 < size__4265__auto__))
{var vec__36305 = cljs.core._nth.call(null,c__4264__auto__,i__36301);var k = cljs.core.nth.call(null,vec__36305,(0),null);var v = cljs.core.nth.call(null,vec__36305,(1),null);cljs.core.chunk_append.call(null,b__36302,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,guess_expr_output_schema.call(null,v)], null));
{
var G__36307 = (i__36301 + (1));
i__36301 = G__36307;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36302),iter__36299.call(null,cljs.core.chunk_rest.call(null,s__36300__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36302),null);
}
} else
{var vec__36306 = cljs.core.first.call(null,s__36300__$2);var k = cljs.core.nth.call(null,vec__36306,(0),null);var v = cljs.core.nth.call(null,vec__36306,(1),null);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,guess_expr_output_schema.call(null,v)], null),iter__36299.call(null,cljs.core.rest.call(null,s__36300__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,expr);
})());
} else
{return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
* Subtract output-schema from input-schema, returning nil if it's possible that an object
* satisfying the output-schema satisfies the input-schema, or otherwise a description
* of the part(s) of input-schema not met by output-schema.  Strict about the map structure
* of output-schema matching input-schema, but loose about everything else (only looks at
* required keys of output-schema.
*/
plumbing.fnk.schema.schema_diff = (function schema_diff(input_schema,output_schema){if(!(plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema)))
{return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else
{if(!(plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema)))
{return schema.utils.error.call(null,schema.utils.__GT_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,output_schema)),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
}),null)),null));
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = (function iter__36316(s__36317){return (new cljs.core.LazySeq(null,(function (){var s__36317__$1 = s__36317;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36317__$1);if(temp__4126__auto__)
{var s__36317__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36317__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36317__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36319 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36318 = (0);while(true){
if((i__36318 < size__4265__auto__))
{var vec__36322 = cljs.core._nth.call(null,c__4264__auto__,i__36318);var k = cljs.core.nth.call(null,vec__36322,(0),null);var v = cljs.core.nth.call(null,vec__36322,(1),null);if(schema.core.specific_key_QMARK_.call(null,k))
{var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);var raw_k = schema.core.explicit_schema_key.call(null,k);var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);if((required_QMARK_) || (present_QMARK_))
{var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));if(cljs.core.truth_(fail))
{cljs.core.chunk_append.call(null,b__36319,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));
{
var G__36324 = (i__36318 + (1));
i__36318 = G__36324;
continue;
}
} else
{{
var G__36325 = (i__36318 + (1));
i__36318 = G__36325;
continue;
}
}
} else
{{
var G__36326 = (i__36318 + (1));
i__36318 = G__36326;
continue;
}
}
} else
{{
var G__36327 = (i__36318 + (1));
i__36318 = G__36327;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36319),iter__36316.call(null,cljs.core.chunk_rest.call(null,s__36317__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36319),null);
}
} else
{var vec__36323 = cljs.core.first.call(null,s__36317__$2);var k = cljs.core.nth.call(null,vec__36323,(0),null);var v = cljs.core.nth.call(null,vec__36323,(1),null);if(schema.core.specific_key_QMARK_.call(null,k))
{var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);var raw_k = schema.core.explicit_schema_key.call(null,k);var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);if((required_QMARK_) || (present_QMARK_))
{var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));if(cljs.core.truth_(fail))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),iter__36316.call(null,cljs.core.rest.call(null,s__36317__$2)));
} else
{{
var G__36328 = cljs.core.rest.call(null,s__36317__$2);
s__36317__$1 = G__36328;
continue;
}
}
} else
{{
var G__36329 = cljs.core.rest.call(null,s__36317__$2);
s__36317__$1 = G__36329;
continue;
}
}
} else
{{
var G__36330 = cljs.core.rest.call(null,s__36317__$2);
s__36317__$1 = G__36330;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,input_schema);
})()));
} else
{return null;
}
}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function assert_satisfies_schema(input_schema,output_schema){var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);if(cljs.core.truth_(fails))
{throw cljs.core.ex_info.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(fails)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else
{return null;
}
});
var ufv___36353 = schema.utils.use_fn_validation;var output_schema36331_36354 = schema.core.Any;var input_schema36332_36355 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);var input_checker36333_36356 = schema.core.checker.call(null,input_schema36332_36355);var output_checker36334_36357 = schema.core.checker.call(null,output_schema36331_36354);/**
* Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
* 
* Given pairs of input and output schemata for fnks f1 and f2,
* return a pair of input and output schemata for #(f2 (merge % (f1 %))).
* f1's output schema must not contain any optional keys.
*/
plumbing.fnk.schema.compose_schemata = ((function (ufv___36353,output_schema36331_36354,input_schema36332_36355,input_checker36333_36356,output_checker36334_36357){
return (function compose_schemata(G__36335,G__36336){var validate__13961__auto__ = true;if(validate__13961__auto__)
{var args__13962__auto___36358 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36335,G__36336], null);var temp__4126__auto___36359 = input_checker36333_36356.call(null,args__13962__auto___36358);if(cljs.core.truth_(temp__4126__auto___36359))
{var error__13963__auto___36360 = temp__4126__auto___36359;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),cljs.core.pr_str.call(null,error__13963__auto___36360)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36332_36355,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36358,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36360], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__36347 = G__36335;var vec__36349 = G__36347;var i2 = cljs.core.nth.call(null,vec__36349,(0),null);var o2 = cljs.core.nth.call(null,vec__36349,(1),null);var G__36348 = G__36336;var vec__36350 = G__36348;var i1 = cljs.core.nth.call(null,vec__36350,(0),null);var o1 = cljs.core.nth.call(null,vec__36350,(1),null);var G__36347__$1 = G__36347;var G__36348__$1 = G__36348;while(true){
var vec__36351 = G__36347__$1;var i2__$1 = cljs.core.nth.call(null,vec__36351,(0),null);var o2__$1 = cljs.core.nth.call(null,vec__36351,(1),null);var vec__36352 = G__36348__$1;var i1__$1 = cljs.core.nth.call(null,vec__36352,(0),null);var o1__$1 = cljs.core.nth.call(null,vec__36352,(1),null);plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();if(validate__13961__auto__)
{var temp__4126__auto___36361 = output_checker36334_36357.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36361))
{var error__13963__auto___36362 = temp__4126__auto___36361;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),cljs.core.pr_str.call(null,error__13963__auto___36362)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36331_36354,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36362], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36353,output_schema36331_36354,input_schema36332_36355,input_checker36333_36356,output_checker36334_36357))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema36331_36354,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36332_36355], null)));
plumbing.fnk.schema.schema_key = (function schema_key(m,k){if(cljs.core.contains_QMARK_.call(null,m,k))
{return k;
} else
{if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k)))
{return schema.core.optional_key.call(null,k);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return null;
} else
{return null;
}
}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function possibly_contains_QMARK_(m,k){return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___36441 = schema.utils.use_fn_validation;var output_schema36363_36442 = schema.core.Any;var input_schema36364_36443 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"s","s",-948495851,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"ks","ks",-754231827,null))], null);var input_checker36365_36444 = schema.core.checker.call(null,input_schema36364_36443);var output_checker36366_36445 = schema.core.checker.call(null,output_schema36363_36442);/**
* Inputs: [s :- InputSchema ks :- [s/Keyword]]
* 
* Return a pair [ks-part non-ks-part], with any extra schema removed.
*/
plumbing.fnk.schema.split_schema = ((function (ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function split_schema(G__36367,G__36368){var validate__13961__auto__ = ufv___36441.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36446 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36367,G__36368], null);var temp__4126__auto___36447 = input_checker36365_36444.call(null,args__13962__auto___36446);if(cljs.core.truth_(temp__4126__auto___36447))
{var error__13963__auto___36448 = temp__4126__auto___36447;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),cljs.core.pr_str.call(null,error__13963__auto___36448)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36364_36443,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36446,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36448], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var s = G__36367;var ks = G__36368;while(true){
var ks__$1 = cljs.core.set.call(null,ks);var iter__4266__auto__ = ((function (ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function iter__36405(s__36406){return (new cljs.core.LazySeq(null,((function (ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function (){var s__36406__$1 = s__36406;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36406__$1);if(temp__4126__auto__)
{var s__36406__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36406__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36406__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36408 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36407 = (0);while(true){
if((i__36407 < size__4265__auto__))
{var in_QMARK_ = cljs.core._nth.call(null,c__4264__auto__,i__36407);cljs.core.chunk_append.call(null,b__36408,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = ((function (i__36407,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36408,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function iter__36425(s__36426){return (new cljs.core.LazySeq(null,((function (i__36407,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36408,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function (){var s__36426__$1 = s__36426;while(true){
var temp__4126__auto____$1 = cljs.core.seq.call(null,s__36426__$1);if(temp__4126__auto____$1)
{var s__36426__$2 = temp__4126__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__36426__$2))
{var c__4264__auto____$1 = cljs.core.chunk_first.call(null,s__36426__$2);var size__4265__auto____$1 = cljs.core.count.call(null,c__4264__auto____$1);var b__36428 = cljs.core.chunk_buffer.call(null,size__4265__auto____$1);if((function (){var i__36427 = (0);while(true){
if((i__36427 < size__4265__auto____$1))
{var vec__36431 = cljs.core._nth.call(null,c__4264__auto____$1,i__36427);var k = cljs.core.nth.call(null,vec__36431,(0),null);var v = cljs.core.nth.call(null,vec__36431,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{cljs.core.chunk_append.call(null,b__36428,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36449 = (i__36427 + (1));
i__36427 = G__36449;
continue;
}
} else
{{
var G__36450 = (i__36427 + (1));
i__36427 = G__36450;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36428),iter__36425.call(null,cljs.core.chunk_rest.call(null,s__36426__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36428),null);
}
} else
{var vec__36432 = cljs.core.first.call(null,s__36426__$2);var k = cljs.core.nth.call(null,vec__36432,(0),null);var v = cljs.core.nth.call(null,vec__36432,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36425.call(null,cljs.core.rest.call(null,s__36426__$2)));
} else
{{
var G__36451 = cljs.core.rest.call(null,s__36426__$2);
s__36426__$1 = G__36451;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(i__36407,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36408,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
,null,null));
});})(i__36407,in_QMARK_,c__4264__auto__,size__4265__auto__,b__36408,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
;return iter__4266__auto__.call(null,s);
})()));
{
var G__36452 = (i__36407 + (1));
i__36407 = G__36452;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36408),iter__36405.call(null,cljs.core.chunk_rest.call(null,s__36406__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36408),null);
}
} else
{var in_QMARK_ = cljs.core.first.call(null,s__36406__$2);return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4266__auto__ = ((function (in_QMARK_,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function iter__36433(s__36434){return (new cljs.core.LazySeq(null,((function (in_QMARK_,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445){
return (function (){var s__36434__$1 = s__36434;while(true){
var temp__4126__auto____$1 = cljs.core.seq.call(null,s__36434__$1);if(temp__4126__auto____$1)
{var s__36434__$2 = temp__4126__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__36434__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36434__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36436 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36435 = (0);while(true){
if((i__36435 < size__4265__auto__))
{var vec__36439 = cljs.core._nth.call(null,c__4264__auto__,i__36435);var k = cljs.core.nth.call(null,vec__36439,(0),null);var v = cljs.core.nth.call(null,vec__36439,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{cljs.core.chunk_append.call(null,b__36436,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36453 = (i__36435 + (1));
i__36435 = G__36453;
continue;
}
} else
{{
var G__36454 = (i__36435 + (1));
i__36435 = G__36454;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36436),iter__36433.call(null,cljs.core.chunk_rest.call(null,s__36434__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36436),null);
}
} else
{var vec__36440 = cljs.core.first.call(null,s__36434__$2);var k = cljs.core.nth.call(null,vec__36440,(0),null);var v = cljs.core.nth.call(null,vec__36440,(1),null);if((schema.core.specific_key_QMARK_.call(null,k)) && (cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)))))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36433.call(null,cljs.core.rest.call(null,s__36434__$2)));
} else
{{
var G__36455 = cljs.core.rest.call(null,s__36434__$2);
s__36434__$1 = G__36455;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(in_QMARK_,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
,null,null));
});})(in_QMARK_,s__36406__$2,temp__4126__auto__,ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
;return iter__4266__auto__.call(null,s);
})()),iter__36405.call(null,cljs.core.rest.call(null,s__36406__$2)));
}
} else
{return null;
}
break;
}
});})(ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
,null,null));
});})(ks__$1,validate__13961__auto__,ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
;return iter__4266__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36456 = output_checker36366_36445.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36456))
{var error__13963__auto___36457 = temp__4126__auto___36456;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),cljs.core.pr_str.call(null,error__13963__auto___36457)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36363_36442,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36457], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36441,output_schema36363_36442,input_schema36364_36443,input_checker36365_36444,output_checker36366_36445))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema36363_36442,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36364_36443], null)));
var ufv___36488 = schema.utils.use_fn_validation;var output_schema36458_36489 = plumbing.fnk.schema.GraphIOSchemata;var input_schema36459_36490 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);var input_checker36460_36491 = schema.core.checker.call(null,input_schema36459_36490);var output_checker36461_36492 = schema.core.checker.call(null,output_schema36458_36489);/**
* Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
* Returns: GraphIOSchemata
* 
* Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
* return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
*/
plumbing.fnk.schema.sequence_schemata = ((function (ufv___36488,output_schema36458_36489,input_schema36459_36490,input_checker36460_36491,output_checker36461_36492){
return (function sequence_schemata(G__36462,G__36463){var validate__13961__auto__ = ufv___36488.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36493 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36462,G__36463], null);var temp__4126__auto___36494 = input_checker36460_36491.call(null,args__13962__auto___36493);if(cljs.core.truth_(temp__4126__auto___36494))
{var error__13963__auto___36495 = temp__4126__auto___36494;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),cljs.core.pr_str.call(null,error__13963__auto___36495)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36459_36490,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36493,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36495], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__36479 = G__36462;var vec__36481 = G__36479;var i1 = cljs.core.nth.call(null,vec__36481,(0),null);var o1 = cljs.core.nth.call(null,vec__36481,(1),null);var G__36480 = G__36463;var vec__36482 = G__36480;var k = cljs.core.nth.call(null,vec__36482,(0),null);var vec__36483 = cljs.core.nth.call(null,vec__36482,(1),null);var i2 = cljs.core.nth.call(null,vec__36483,(0),null);var o2 = cljs.core.nth.call(null,vec__36483,(1),null);var G__36479__$1 = G__36479;var G__36480__$1 = G__36480;while(true){
var vec__36484 = G__36479__$1;var i1__$1 = cljs.core.nth.call(null,vec__36484,(0),null);var o1__$1 = cljs.core.nth.call(null,vec__36484,(1),null);var vec__36485 = G__36480__$1;var k__$1 = cljs.core.nth.call(null,vec__36485,(0),null);var vec__36486 = cljs.core.nth.call(null,vec__36485,(1),null);var i2__$1 = cljs.core.nth.call(null,vec__36486,(0),null);var o2__$1 = cljs.core.nth.call(null,vec__36486,(1),null);if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}
if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}
if(!(plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1)))
{} else
{throw (new java.lang.IllegalArgumentException(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}
var vec__36487 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));var used = cljs.core.nth.call(null,vec__36487,(0),null);var unused = cljs.core.nth.call(null,vec__36487,(1),null);plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36496 = output_checker36461_36492.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36496))
{var error__13963__auto___36497 = temp__4126__auto___36496;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),cljs.core.pr_str.call(null,error__13963__auto___36497)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36458_36489,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36497], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36488,output_schema36458_36489,input_schema36459_36490,input_checker36460_36491,output_checker36461_36492))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema36458_36489,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36459_36490], null)));

//# sourceMappingURL=schema.js.map