// Compiled by ClojureScript 0.0-2277
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('plumbing.fnk.schema');
goog.require('plumbing.fnk.schema');
goog.require('schema.utils');
goog.require('schema.utils');
/**
* A sentinel value representing missing portions of the input data.
*/
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
* Updates the value in map m at k with the function f.
* 
* Like update-in, but for updating a single top-level key.
* Any additional args will be passed to f after the value.
* @param {...*} var_args
*/
plumbing.core.update = (function() {
var update = null;
var update__3 = (function (m,k,f){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
});
var update__4 = (function (m,k,f,x1){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
});
var update__5 = (function (m,k,f,x1,x2){return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
});
var update__6 = (function() { 
var G__36498__delegate = function (m,k,f,x1,x2,xs){return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
};
var G__36498 = function (m,k,f,x1,x2,var_args){
var xs = null;if (arguments.length > 5) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);} 
return G__36498__delegate.call(this,m,k,f,x1,x2,xs);};
G__36498.cljs$lang$maxFixedArity = 5;
G__36498.cljs$lang$applyTo = (function (arglist__36499){
var m = cljs.core.first(arglist__36499);
arglist__36499 = cljs.core.next(arglist__36499);
var k = cljs.core.first(arglist__36499);
arglist__36499 = cljs.core.next(arglist__36499);
var f = cljs.core.first(arglist__36499);
arglist__36499 = cljs.core.next(arglist__36499);
var x1 = cljs.core.first(arglist__36499);
arglist__36499 = cljs.core.next(arglist__36499);
var x2 = cljs.core.first(arglist__36499);
var xs = cljs.core.rest(arglist__36499);
return G__36498__delegate(m,k,f,x1,x2,xs);
});
G__36498.cljs$core$IFn$_invoke$arity$variadic = G__36498__delegate;
return G__36498;
})()
;
update = function(m,k,f,x1,x2,var_args){
var xs = var_args;
switch(arguments.length){
case 3:
return update__3.call(this,m,k,f);
case 4:
return update__4.call(this,m,k,f,x1);
case 5:
return update__5.call(this,m,k,f,x1,x2);
default:
return update__6.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x1,x2, cljs.core.array_seq(arguments, 5));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update.cljs$lang$maxFixedArity = 5;
update.cljs$lang$applyTo = update__6.cljs$lang$applyTo;
update.cljs$core$IFn$_invoke$arity$3 = update__3;
update.cljs$core$IFn$_invoke$arity$4 = update__4;
update.cljs$core$IFn$_invoke$arity$5 = update__5;
update.cljs$core$IFn$_invoke$arity$variadic = update__6.cljs$core$IFn$_invoke$arity$variadic;
return update;
})()
;
/**
* Build map k -> (f v) for [k v] in map, preserving the initial type
*/
plumbing.core.map_vals = (function map_vals(f,m){if(cljs.core.sorted_QMARK_.call(null,m))
{return cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else
{if(cljs.core.map_QMARK_.call(null,m))
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36508_36514 = cljs.core.seq.call(null,m);var chunk__36509_36515 = null;var count__36510_36516 = (0);var i__36511_36517 = (0);while(true){
if((i__36511_36517 < count__36510_36516))
{var vec__36512_36518 = cljs.core._nth.call(null,chunk__36509_36515,i__36511_36517);var k_36519 = cljs.core.nth.call(null,vec__36512_36518,(0),null);var v_36520 = cljs.core.nth.call(null,vec__36512_36518,(1),null);var m36507_36521 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36507_36521,k_36519,f.call(null,v_36520)));
{
var G__36522 = seq__36508_36514;
var G__36523 = chunk__36509_36515;
var G__36524 = count__36510_36516;
var G__36525 = (i__36511_36517 + (1));
seq__36508_36514 = G__36522;
chunk__36509_36515 = G__36523;
count__36510_36516 = G__36524;
i__36511_36517 = G__36525;
continue;
}
} else
{var temp__4126__auto___36526 = cljs.core.seq.call(null,seq__36508_36514);if(temp__4126__auto___36526)
{var seq__36508_36527__$1 = temp__4126__auto___36526;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36508_36527__$1))
{var c__4297__auto___36528 = cljs.core.chunk_first.call(null,seq__36508_36527__$1);{
var G__36529 = cljs.core.chunk_rest.call(null,seq__36508_36527__$1);
var G__36530 = c__4297__auto___36528;
var G__36531 = cljs.core.count.call(null,c__4297__auto___36528);
var G__36532 = (0);
seq__36508_36514 = G__36529;
chunk__36509_36515 = G__36530;
count__36510_36516 = G__36531;
i__36511_36517 = G__36532;
continue;
}
} else
{var vec__36513_36533 = cljs.core.first.call(null,seq__36508_36527__$1);var k_36534 = cljs.core.nth.call(null,vec__36513_36533,(0),null);var v_36535 = cljs.core.nth.call(null,vec__36513_36533,(1),null);var m36507_36536 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36507_36536,k_36534,f.call(null,v_36535)));
{
var G__36537 = cljs.core.next.call(null,seq__36508_36527__$1);
var G__36538 = null;
var G__36539 = (0);
var G__36540 = (0);
seq__36508_36514 = G__36537;
chunk__36509_36515 = G__36538;
count__36510_36516 = G__36539;
i__36511_36517 = G__36540;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
} else
{return null;
}
}
}
});
/**
* Build map (f k) -> v for [k v] in map m
*/
plumbing.core.map_keys = (function map_keys(f,m){if(cljs.core.map_QMARK_.call(null,m))
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else
{var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36549_36555 = cljs.core.seq.call(null,m);var chunk__36550_36556 = null;var count__36551_36557 = (0);var i__36552_36558 = (0);while(true){
if((i__36552_36558 < count__36551_36557))
{var vec__36553_36559 = cljs.core._nth.call(null,chunk__36550_36556,i__36552_36558);var k_36560 = cljs.core.nth.call(null,vec__36553_36559,(0),null);var v_36561 = cljs.core.nth.call(null,vec__36553_36559,(1),null);var m36548_36562 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36548_36562,f.call(null,k_36560),v_36561));
{
var G__36563 = seq__36549_36555;
var G__36564 = chunk__36550_36556;
var G__36565 = count__36551_36557;
var G__36566 = (i__36552_36558 + (1));
seq__36549_36555 = G__36563;
chunk__36550_36556 = G__36564;
count__36551_36557 = G__36565;
i__36552_36558 = G__36566;
continue;
}
} else
{var temp__4126__auto___36567 = cljs.core.seq.call(null,seq__36549_36555);if(temp__4126__auto___36567)
{var seq__36549_36568__$1 = temp__4126__auto___36567;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36549_36568__$1))
{var c__4297__auto___36569 = cljs.core.chunk_first.call(null,seq__36549_36568__$1);{
var G__36570 = cljs.core.chunk_rest.call(null,seq__36549_36568__$1);
var G__36571 = c__4297__auto___36569;
var G__36572 = cljs.core.count.call(null,c__4297__auto___36569);
var G__36573 = (0);
seq__36549_36555 = G__36570;
chunk__36550_36556 = G__36571;
count__36551_36557 = G__36572;
i__36552_36558 = G__36573;
continue;
}
} else
{var vec__36554_36574 = cljs.core.first.call(null,seq__36549_36568__$1);var k_36575 = cljs.core.nth.call(null,vec__36554_36574,(0),null);var v_36576 = cljs.core.nth.call(null,vec__36554_36574,(1),null);var m36548_36577 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36548_36577,f.call(null,k_36575),v_36576));
{
var G__36578 = cljs.core.next.call(null,seq__36549_36568__$1);
var G__36579 = null;
var G__36580 = (0);
var G__36581 = (0);
seq__36549_36555 = G__36578;
chunk__36550_36556 = G__36579;
count__36551_36557 = G__36580;
i__36552_36558 = G__36581;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
}
});
/**
* Build map k -> (f k) for keys in ks
*/
plumbing.core.map_from_keys = (function map_from_keys(f,ks){var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36588_36592 = cljs.core.seq.call(null,ks);var chunk__36589_36593 = null;var count__36590_36594 = (0);var i__36591_36595 = (0);while(true){
if((i__36591_36595 < count__36590_36594))
{var k_36596 = cljs.core._nth.call(null,chunk__36589_36593,i__36591_36595);var m36587_36597 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36587_36597,k_36596,f.call(null,k_36596)));
{
var G__36598 = seq__36588_36592;
var G__36599 = chunk__36589_36593;
var G__36600 = count__36590_36594;
var G__36601 = (i__36591_36595 + (1));
seq__36588_36592 = G__36598;
chunk__36589_36593 = G__36599;
count__36590_36594 = G__36600;
i__36591_36595 = G__36601;
continue;
}
} else
{var temp__4126__auto___36602 = cljs.core.seq.call(null,seq__36588_36592);if(temp__4126__auto___36602)
{var seq__36588_36603__$1 = temp__4126__auto___36602;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36588_36603__$1))
{var c__4297__auto___36604 = cljs.core.chunk_first.call(null,seq__36588_36603__$1);{
var G__36605 = cljs.core.chunk_rest.call(null,seq__36588_36603__$1);
var G__36606 = c__4297__auto___36604;
var G__36607 = cljs.core.count.call(null,c__4297__auto___36604);
var G__36608 = (0);
seq__36588_36592 = G__36605;
chunk__36589_36593 = G__36606;
count__36590_36594 = G__36607;
i__36591_36595 = G__36608;
continue;
}
} else
{var k_36609 = cljs.core.first.call(null,seq__36588_36603__$1);var m36587_36610 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36587_36610,k_36609,f.call(null,k_36609)));
{
var G__36611 = cljs.core.next.call(null,seq__36588_36603__$1);
var G__36612 = null;
var G__36613 = (0);
var G__36614 = (0);
seq__36588_36592 = G__36611;
chunk__36589_36593 = G__36612;
count__36590_36594 = G__36613;
i__36591_36595 = G__36614;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
});
/**
* Build map (f v) -> v for vals in vs
*/
plumbing.core.map_from_vals = (function map_from_vals(f,vs){var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36621_36625 = cljs.core.seq.call(null,vs);var chunk__36622_36626 = null;var count__36623_36627 = (0);var i__36624_36628 = (0);while(true){
if((i__36624_36628 < count__36623_36627))
{var v_36629 = cljs.core._nth.call(null,chunk__36622_36626,i__36624_36628);var m36620_36630 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36620_36630,f.call(null,v_36629),v_36629));
{
var G__36631 = seq__36621_36625;
var G__36632 = chunk__36622_36626;
var G__36633 = count__36623_36627;
var G__36634 = (i__36624_36628 + (1));
seq__36621_36625 = G__36631;
chunk__36622_36626 = G__36632;
count__36623_36627 = G__36633;
i__36624_36628 = G__36634;
continue;
}
} else
{var temp__4126__auto___36635 = cljs.core.seq.call(null,seq__36621_36625);if(temp__4126__auto___36635)
{var seq__36621_36636__$1 = temp__4126__auto___36635;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36621_36636__$1))
{var c__4297__auto___36637 = cljs.core.chunk_first.call(null,seq__36621_36636__$1);{
var G__36638 = cljs.core.chunk_rest.call(null,seq__36621_36636__$1);
var G__36639 = c__4297__auto___36637;
var G__36640 = cljs.core.count.call(null,c__4297__auto___36637);
var G__36641 = (0);
seq__36621_36625 = G__36638;
chunk__36622_36626 = G__36639;
count__36623_36627 = G__36640;
i__36624_36628 = G__36641;
continue;
}
} else
{var v_36642 = cljs.core.first.call(null,seq__36621_36636__$1);var m36620_36643 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36620_36643,f.call(null,v_36642),v_36642));
{
var G__36644 = cljs.core.next.call(null,seq__36621_36636__$1);
var G__36645 = null;
var G__36646 = (0);
var G__36647 = (0);
seq__36621_36625 = G__36644;
chunk__36622_36626 = G__36645;
count__36623_36627 = G__36646;
i__36624_36628 = G__36647;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
});
/**
* Dissociate this keyseq from m, removing any empty maps created as a result
* (including at the top-level).
*/
plumbing.core.dissoc_in = (function dissoc_in(m,p__36648){var vec__36650 = p__36648;var k = cljs.core.nth.call(null,vec__36650,(0),null);var ks = cljs.core.nthnext.call(null,vec__36650,(1));if(cljs.core.truth_(m))
{var temp__4124__auto__ = (function (){var and__3529__auto__ = ks;if(and__3529__auto__)
{return dissoc_in.call(null,m.call(null,k),ks);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4124__auto__))
{var res = temp__4124__auto__;return cljs.core.assoc.call(null,m,k,res);
} else
{var res = cljs.core.dissoc.call(null,m,k);if(cljs.core.empty_QMARK_.call(null,res))
{return null;
} else
{return res;
}
}
} else
{return null;
}
});
/**
* Recursively convert maps in m (including itself)
* to have keyword keys instead of string
*/
plumbing.core.keywordize_map = (function keywordize_map(x){if(cljs.core.map_QMARK_.call(null,x))
{var m_atom__16222__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__36659_36665 = cljs.core.seq.call(null,x);var chunk__36660_36666 = null;var count__36661_36667 = (0);var i__36662_36668 = (0);while(true){
if((i__36662_36668 < count__36661_36667))
{var vec__36663_36669 = cljs.core._nth.call(null,chunk__36660_36666,i__36662_36668);var k_36670 = cljs.core.nth.call(null,vec__36663_36669,(0),null);var v_36671 = cljs.core.nth.call(null,vec__36663_36669,(1),null);var m36658_36672 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36658_36672,((typeof k_36670 === 'string')?cljs.core.keyword.call(null,k_36670):k_36670),keywordize_map.call(null,v_36671)));
{
var G__36673 = seq__36659_36665;
var G__36674 = chunk__36660_36666;
var G__36675 = count__36661_36667;
var G__36676 = (i__36662_36668 + (1));
seq__36659_36665 = G__36673;
chunk__36660_36666 = G__36674;
count__36661_36667 = G__36675;
i__36662_36668 = G__36676;
continue;
}
} else
{var temp__4126__auto___36677 = cljs.core.seq.call(null,seq__36659_36665);if(temp__4126__auto___36677)
{var seq__36659_36678__$1 = temp__4126__auto___36677;if(cljs.core.chunked_seq_QMARK_.call(null,seq__36659_36678__$1))
{var c__4297__auto___36679 = cljs.core.chunk_first.call(null,seq__36659_36678__$1);{
var G__36680 = cljs.core.chunk_rest.call(null,seq__36659_36678__$1);
var G__36681 = c__4297__auto___36679;
var G__36682 = cljs.core.count.call(null,c__4297__auto___36679);
var G__36683 = (0);
seq__36659_36665 = G__36680;
chunk__36660_36666 = G__36681;
count__36661_36667 = G__36682;
i__36662_36668 = G__36683;
continue;
}
} else
{var vec__36664_36684 = cljs.core.first.call(null,seq__36659_36678__$1);var k_36685 = cljs.core.nth.call(null,vec__36664_36684,(0),null);var v_36686 = cljs.core.nth.call(null,vec__36664_36684,(1),null);var m36658_36687 = cljs.core.deref.call(null,m_atom__16222__auto__);cljs.core.reset_BANG_.call(null,m_atom__16222__auto__,cljs.core.assoc_BANG_.call(null,m36658_36687,((typeof k_36685 === 'string')?cljs.core.keyword.call(null,k_36685):k_36685),keywordize_map.call(null,v_36686)));
{
var G__36688 = cljs.core.next.call(null,seq__36659_36678__$1);
var G__36689 = null;
var G__36690 = (0);
var G__36691 = (0);
seq__36659_36665 = G__36688;
chunk__36660_36666 = G__36689;
count__36661_36667 = G__36690;
i__36662_36668 = G__36691;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16222__auto__));
} else
{if(cljs.core.seq_QMARK_.call(null,x))
{return cljs.core.map.call(null,keywordize_map,x);
} else
{if(cljs.core.vector_QMARK_.call(null,x))
{return cljs.core.mapv.call(null,keywordize_map,x);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return x;
} else
{return null;
}
}
}
}
});
/**
* Like get but throw an exception if not found
*/
plumbing.core.safe_get = (function safe_get(m,k){var temp__4124__auto__ = cljs.core.find.call(null,m,k);if(cljs.core.truth_(temp__4124__auto__))
{var pair__16291__auto__ = temp__4124__auto__;return cljs.core.val.call(null,pair__16291__auto__);
} else
{var e = schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m));throw (new Error(e));
}
});
/**
* Like get-in but throws exception if not found
*/
plumbing.core.safe_get_in = (function safe_get_in(m,ks){while(true){
if(cljs.core.seq.call(null,ks))
{{
var G__36692 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__36693 = cljs.core.next.call(null,ks);
m = G__36692;
ks = G__36693;
continue;
}
} else
{return m;
}
break;
}
});
/**
* Like assoc but only assocs when value is truthy
* @param {...*} var_args
*/
plumbing.core.assoc_when = (function() { 
var assoc_when__delegate = function (m,kvs){if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null))))))));
}
return cljs.core.into.call(null,(function (){var or__3541__auto__ = m;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__4266__auto__ = (function iter__36702(s__36703){return (new cljs.core.LazySeq(null,(function (){var s__36703__$1 = s__36703;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36703__$1);if(temp__4126__auto__)
{var s__36703__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36703__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36703__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36705 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36704 = (0);while(true){
if((i__36704 < size__4265__auto__))
{var vec__36708 = cljs.core._nth.call(null,c__4264__auto__,i__36704);var k = cljs.core.nth.call(null,vec__36708,(0),null);var v = cljs.core.nth.call(null,vec__36708,(1),null);if(cljs.core.truth_(v))
{cljs.core.chunk_append.call(null,b__36705,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
{
var G__36710 = (i__36704 + (1));
i__36704 = G__36710;
continue;
}
} else
{{
var G__36711 = (i__36704 + (1));
i__36704 = G__36711;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36705),iter__36702.call(null,cljs.core.chunk_rest.call(null,s__36703__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36705),null);
}
} else
{var vec__36709 = cljs.core.first.call(null,s__36703__$2);var k = cljs.core.nth.call(null,vec__36709,(0),null);var v = cljs.core.nth.call(null,vec__36709,(1),null);if(cljs.core.truth_(v))
{return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),iter__36702.call(null,cljs.core.rest.call(null,s__36703__$2)));
} else
{{
var G__36712 = cljs.core.rest.call(null,s__36703__$2);
s__36703__$1 = G__36712;
continue;
}
}
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4266__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
};
var assoc_when = function (m,var_args){
var kvs = null;if (arguments.length > 1) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return assoc_when__delegate.call(this,m,kvs);};
assoc_when.cljs$lang$maxFixedArity = 1;
assoc_when.cljs$lang$applyTo = (function (arglist__36713){
var m = cljs.core.first(arglist__36713);
var kvs = cljs.core.rest(arglist__36713);
return assoc_when__delegate(m,kvs);
});
assoc_when.cljs$core$IFn$_invoke$arity$variadic = assoc_when__delegate;
return assoc_when;
})()
;
/**
* Like update-in but returns m unchanged if key-seq is not present.
* @param {...*} var_args
*/
plumbing.core.update_in_when = (function() { 
var update_in_when__delegate = function (m,key_seq,f,args){var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);if(!((plumbing.core._PLUS_none_PLUS_ === found)))
{return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else
{return m;
}
};
var update_in_when = function (m,key_seq,f,var_args){
var args = null;if (arguments.length > 3) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return update_in_when__delegate.call(this,m,key_seq,f,args);};
update_in_when.cljs$lang$maxFixedArity = 3;
update_in_when.cljs$lang$applyTo = (function (arglist__36714){
var m = cljs.core.first(arglist__36714);
arglist__36714 = cljs.core.next(arglist__36714);
var key_seq = cljs.core.first(arglist__36714);
arglist__36714 = cljs.core.next(arglist__36714);
var f = cljs.core.first(arglist__36714);
var args = cljs.core.rest(arglist__36714);
return update_in_when__delegate(m,key_seq,f,args);
});
update_in_when.cljs$core$IFn$_invoke$arity$variadic = update_in_when__delegate;
return update_in_when;
})()
;
/**
* Like group-by, but accepts a map-fn that is applied to values before
* collected.
*/
plumbing.core.grouped_map = (function grouped_map(key_fn,map_fn,coll){return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){var k = key_fn.call(null,x);return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Like (apply concat s) but lazier (and shorter)
*/
plumbing.core.aconcat = (function aconcat(s){return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){var temp__4126__auto__ = cljs.core.next.call(null,s);if(temp__4126__auto__)
{var n = temp__4126__auto__;return aconcat.call(null,n);
} else
{return null;
}
}),null,null)));
});
/**
* Takes a seqable and returns a lazy sequence that
* is maximally lazy and doesn't realize elements due to either
* chunking or apply.
* 
* Useful when you don't want chunking, for instance,
* (first awesome-website? (map slurp +a-bunch-of-urls+))
* may slurp up to 31 unneed webpages, wherease
* (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
* is guaranteed to stop slurping after the first awesome website.
* 
* Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
*/
plumbing.core.unchunk = (function unchunk(s){if(cljs.core.seq.call(null,s))
{return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){return unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else
{return null;
}
});
/**
* Return sum of (f x) for each x in xs
*/
plumbing.core.sum = (function() {
var sum = null;
var sum__1 = (function (xs){return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
});
var sum__2 = (function (f,xs){return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
});
sum = function(f,xs){
switch(arguments.length){
case 1:
return sum__1.call(this,f);
case 2:
return sum__2.call(this,f,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sum.cljs$core$IFn$_invoke$arity$1 = sum__1;
sum.cljs$core$IFn$_invoke$arity$2 = sum__2;
return sum;
})()
;
/**
* returns (first xs) when xs has only 1 element
*/
plumbing.core.singleton = (function singleton(xs){var temp__4126__auto__ = cljs.core.seq.call(null,xs);if(temp__4126__auto__)
{var xs__$1 = temp__4126__auto__;if(cljs.core.next.call(null,xs__$1))
{return null;
} else
{return cljs.core.first.call(null,xs__$1);
}
} else
{return null;
}
});
/**
* Returns [idx x] for x in seqable s
*/
plumbing.core.indexed = (function indexed(s){return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
* Returns indices idx of sequence s where (f (nth s idx))
*/
plumbing.core.positions = (function positions(f,s){return cljs.core.keep_indexed.call(null,(function (i,x){if(cljs.core.truth_(f.call(null,x)))
{return i;
} else
{return null;
}
}),s);
});
/**
* Returns elements of xs which return unique
* values according to f. If multiple elements of xs return the same
* value under f, the first is returned
*/
plumbing.core.distinct_by = (function distinct_by(f,xs){var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);var iter__4266__auto__ = ((function (s){
return (function iter__36719(s__36720){return (new cljs.core.LazySeq(null,((function (s){
return (function (){var s__36720__$1 = s__36720;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__36720__$1);if(temp__4126__auto__)
{var s__36720__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__36720__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__36720__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__36722 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__36721 = (0);while(true){
if((i__36721 < size__4265__auto__))
{var x = cljs.core._nth.call(null,c__4264__auto__,i__36721);var id = f.call(null,x);if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))
{cljs.core.chunk_append.call(null,b__36722,(function (){cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);
return x;
})());
{
var G__36723 = (i__36721 + (1));
i__36721 = G__36723;
continue;
}
} else
{{
var G__36724 = (i__36721 + (1));
i__36721 = G__36724;
continue;
}
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36722),iter__36719.call(null,cljs.core.chunk_rest.call(null,s__36720__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36722),null);
}
} else
{var x = cljs.core.first.call(null,s__36720__$2);var id = f.call(null,x);if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id)))
{return cljs.core.cons.call(null,(function (){cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);
return x;
})(),iter__36719.call(null,cljs.core.rest.call(null,s__36720__$2)));
} else
{{
var G__36725 = cljs.core.rest.call(null,s__36720__$2);
s__36720__$1 = G__36725;
continue;
}
}
}
} else
{return null;
}
break;
}
});})(s))
,null,null));
});})(s))
;return iter__4266__auto__.call(null,xs);
});
/**
* Analogy: partition:partition-all :: interleave:interleave-all
* @param {...*} var_args
*/
plumbing.core.interleave_all = (function() { 
var interleave_all__delegate = function (colls){return (new cljs.core.LazySeq(null,(function (){return (function helper(seqs){if(cljs.core.seq.call(null,seqs))
{return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){return helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else
{return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
};
var interleave_all = function (var_args){
var colls = null;if (arguments.length > 0) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return interleave_all__delegate.call(this,colls);};
interleave_all.cljs$lang$maxFixedArity = 0;
interleave_all.cljs$lang$applyTo = (function (arglist__36726){
var colls = cljs.core.seq(arglist__36726);
return interleave_all__delegate(colls);
});
interleave_all.cljs$core$IFn$_invoke$arity$variadic = interleave_all__delegate;
return interleave_all;
})()
;
/**
* Returns # of elements of xs where pred holds
*/
plumbing.core.count_when = (function count_when(pred,xs){return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
* Like conj but ignores non-truthy values
* @param {...*} var_args
*/
plumbing.core.conj_when = (function() {
var conj_when = null;
var conj_when__2 = (function (coll,x){if(cljs.core.truth_(x))
{return cljs.core.conj.call(null,coll,x);
} else
{return coll;
}
});
var conj_when__3 = (function() { 
var G__36727__delegate = function (coll,x,xs){while(true){
if(cljs.core.truth_(xs))
{{
var G__36728 = conj_when.call(null,coll,x);
var G__36729 = cljs.core.first.call(null,xs);
var G__36730 = cljs.core.next.call(null,xs);
coll = G__36728;
x = G__36729;
xs = G__36730;
continue;
}
} else
{return conj_when.call(null,coll,x);
}
break;
}
};
var G__36727 = function (coll,x,var_args){
var xs = null;if (arguments.length > 2) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36727__delegate.call(this,coll,x,xs);};
G__36727.cljs$lang$maxFixedArity = 2;
G__36727.cljs$lang$applyTo = (function (arglist__36731){
var coll = cljs.core.first(arglist__36731);
arglist__36731 = cljs.core.next(arglist__36731);
var x = cljs.core.first(arglist__36731);
var xs = cljs.core.rest(arglist__36731);
return G__36727__delegate(coll,x,xs);
});
G__36727.cljs$core$IFn$_invoke$arity$variadic = G__36727__delegate;
return G__36727;
})()
;
conj_when = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 2:
return conj_when__2.call(this,coll,x);
default:
return conj_when__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj_when.cljs$lang$maxFixedArity = 2;
conj_when.cljs$lang$applyTo = conj_when__3.cljs$lang$applyTo;
conj_when.cljs$core$IFn$_invoke$arity$2 = conj_when__2;
conj_when.cljs$core$IFn$_invoke$arity$variadic = conj_when__3.cljs$core$IFn$_invoke$arity$variadic;
return conj_when;
})()
;
/**
* Like cons but does nothing if x is non-truthy.
*/
plumbing.core.cons_when = (function cons_when(x,s){if(cljs.core.truth_(x))
{return cljs.core.cons.call(null,x,s);
} else
{return s;
}
});
/**
* Like sort-by, but prefers higher values rather than lower ones.
*/
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
* Like swap! but returns a pair [old-val new-val]
* @param {...*} var_args
*/
plumbing.core.swap_pair_BANG_ = (function() {
var swap_pair_BANG_ = null;
var swap_pair_BANG___2 = (function (a,f){while(true){
var old_val = cljs.core.deref.call(null,a);var new_val = f.call(null,old_val);if(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val))
{return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else
{{
continue;
}
}
break;
}
});
var swap_pair_BANG___3 = (function() { 
var G__36733__delegate = function (a,f,args){return swap_pair_BANG_.call(null,a,(function (p1__36732_SHARP_){return cljs.core.apply.call(null,f,p1__36732_SHARP_,args);
}));
};
var G__36733 = function (a,f,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36733__delegate.call(this,a,f,args);};
G__36733.cljs$lang$maxFixedArity = 2;
G__36733.cljs$lang$applyTo = (function (arglist__36734){
var a = cljs.core.first(arglist__36734);
arglist__36734 = cljs.core.next(arglist__36734);
var f = cljs.core.first(arglist__36734);
var args = cljs.core.rest(arglist__36734);
return G__36733__delegate(a,f,args);
});
G__36733.cljs$core$IFn$_invoke$arity$variadic = G__36733__delegate;
return G__36733;
})()
;
swap_pair_BANG_ = function(a,f,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return swap_pair_BANG___2.call(this,a,f);
default:
return swap_pair_BANG___3.cljs$core$IFn$_invoke$arity$variadic(a,f, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
swap_pair_BANG_.cljs$lang$maxFixedArity = 2;
swap_pair_BANG_.cljs$lang$applyTo = swap_pair_BANG___3.cljs$lang$applyTo;
swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = swap_pair_BANG___2;
swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_pair_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return swap_pair_BANG_;
})()
;
/**
* Like reset! but returns old-val
*/
plumbing.core.get_and_set_BANG_ = (function get_and_set_BANG_(a,new_val){return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function millis(){return (new Date()).getTime();
});
/**
* Like apply, but applies a map to a function with positional map
* arguments. Can take optional initial args just like apply.
* @param {...*} var_args
*/
plumbing.core.mapply = (function() {
var mapply = null;
var mapply__2 = (function (f,m){return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
});
var mapply__3 = (function() { 
var G__36735__delegate = function (f,arg,args){return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
};
var G__36735 = function (f,arg,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return G__36735__delegate.call(this,f,arg,args);};
G__36735.cljs$lang$maxFixedArity = 2;
G__36735.cljs$lang$applyTo = (function (arglist__36736){
var f = cljs.core.first(arglist__36736);
arglist__36736 = cljs.core.next(arglist__36736);
var arg = cljs.core.first(arglist__36736);
var args = cljs.core.rest(arglist__36736);
return G__36735__delegate(f,arg,args);
});
G__36735.cljs$core$IFn$_invoke$arity$variadic = G__36735__delegate;
return G__36735;
})()
;
mapply = function(f,arg,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return mapply__2.call(this,f,arg);
default:
return mapply__3.cljs$core$IFn$_invoke$arity$variadic(f,arg, cljs.core.array_seq(arguments, 2));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapply.cljs$lang$maxFixedArity = 2;
mapply.cljs$lang$applyTo = mapply__3.cljs$lang$applyTo;
mapply.cljs$core$IFn$_invoke$arity$2 = mapply__2;
mapply.cljs$core$IFn$_invoke$arity$variadic = mapply__3.cljs$core$IFn$_invoke$arity$variadic;
return mapply;
})()
;

//# sourceMappingURL=core.js.map