// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.types');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.core');
om_bootstrap.types.Component = schema.core.named.call(null,schema.core.Any,"Alias for an om component, since I don't know what type to put here.");
om_bootstrap.types.Renderable = schema.core.named.call(null,schema.core.Any,"Anything that can get rendered.");
/**
* Map of keyword to the proper bootstrap class name.
*/
om_bootstrap.types.class_map = cljs.core.PersistentHashMap.fromArrays(["alert","label","form","progress-bar","modal","navbar","button-toolbar","panel-group","nav","column","row","input-group","panel","well","button-group","button","glyphicon"],["alert","label","form","progress-bar","modal","navbar","btn-toolbar","panel-group","nav","col","row","input-group","panel","well","btn-group","btn","glyphicon"]);
/**
* Map of style keywords -> styles.
*/
om_bootstrap.types.style_map = cljs.core.PersistentHashMap.fromArrays(["success","warning","inline","pills","info","tabs","primary","danger","link","default"],["success","warning","inline","pills","info","tabs","primary","danger","link","default"]);
om_bootstrap.types.size_map = new cljs.core.PersistentArrayMap(null, 4, ["large","lg","medium","md","small","sm","xsmall","xs"], null);
om_bootstrap.types.BSClass = cljs.core.apply.call(null,schema.core.enum$,cljs.core.keys.call(null,om_bootstrap.types.class_map));
om_bootstrap.types.BSStyle = cljs.core.apply.call(null,schema.core.enum$,cljs.core.keys.call(null,om_bootstrap.types.style_map));
om_bootstrap.types.BSSize = cljs.core.apply.call(null,schema.core.enum$,cljs.core.keys.call(null,om_bootstrap.types.size_map));
om_bootstrap.types.BootstrapClass = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-class","bs-class",1438130590)),om_bootstrap.types.BSClass,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)),om_bootstrap.types.BSStyle,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-size","bs-size",1567732754)),om_bootstrap.types.BSSize], true, false);
/**
* Applies all default bootstrap options to the supplied schema. If
* the incoming schema has one of the the keys from BootstrapClass,
* that wins (even if it's required).
*/
om_bootstrap.types.bootstrap = (function bootstrap(schema__$1){var bootstrap_schema = cljs.core.apply.call(null,cljs.core.dissoc,om_bootstrap.types.BootstrapClass,cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,cljs.core.select_keys.call(null,schema__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bs-class","bs-class",1438130590),new cljs.core.Keyword(null,"bs-style","bs-style",1424423998),new cljs.core.Keyword(null,"bs-size","bs-size",1567732754)], null)))));return cljs.core.assoc.call(null,cljs.core.merge.call(null,bootstrap_schema,schema__$1),schema.core.Any,schema.core.Any);
});
var ufv___35984 = schema.utils.use_fn_validation;var output_schema35979_35985 = schema.core.Any;var input_schema35980_35986 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,schema.core.Any], true, false),new cljs.core.Symbol(null,"schema","schema",58529736,null))], null);var input_checker35981_35987 = schema.core.checker.call(null,input_schema35980_35986);var output_checker35982_35988 = schema.core.checker.call(null,output_schema35979_35985);/**
* Inputs: [schema :- {s/Any s/Any}]
* 
* Returns all keys from a schema.
*/
om_bootstrap.types.schema_keys = ((function (ufv___35984,output_schema35979_35985,input_schema35980_35986,input_checker35981_35987,output_checker35982_35988){
return (function schema_keys(G__35983){var validate__13961__auto__ = ufv___35984.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___35989 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__35983], null);var temp__4126__auto___35990 = input_checker35981_35987.call(null,args__13962__auto___35989);if(cljs.core.truth_(temp__4126__auto___35990))
{var error__13963__auto___35991 = temp__4126__auto___35990;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"schema-keys","schema-keys",947810359,null),cljs.core.pr_str.call(null,error__13963__auto___35991)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema35980_35986,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___35989,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___35991], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__35983;while(true){
return cljs.core.map.call(null,((function (validate__13961__auto__,ufv___35984,output_schema35979_35985,input_schema35980_35986,input_checker35981_35987,output_checker35982_35988){
return (function (k){if(schema.core.optional_key_QMARK_.call(null,k))
{return new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(k);
} else
{return k;
}
});})(validate__13961__auto__,ufv___35984,output_schema35979_35985,input_schema35980_35986,input_checker35981_35987,output_checker35982_35988))
,cljs.core.keys.call(null,schema__$1));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___35992 = output_checker35982_35988.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___35992))
{var error__13963__auto___35993 = temp__4126__auto___35992;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"schema-keys","schema-keys",947810359,null),cljs.core.pr_str.call(null,error__13963__auto___35993)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema35979_35985,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___35993], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___35984,output_schema35979_35985,input_schema35980_35986,input_checker35981_35987,output_checker35982_35988))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.schema_keys),schema.core.make_fn_schema.call(null,output_schema35979_35985,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema35980_35986], null)));
var ufv___35999 = schema.utils.use_fn_validation;var output_schema35994_36000 = schema.core.Any;var input_schema35995_36001 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"schema","schema",58529736,null))], null);var input_checker35996_36002 = schema.core.checker.call(null,input_schema35995_36001);var output_checker35997_36003 = schema.core.checker.call(null,output_schema35994_36000);/**
* Inputs: [schema]
* 
* Returns a map schema that accepts the supplied map schema, plus any
* other optional keys that show up in the map. Such a schema can only
* enforce that required keys are missing.
*/
om_bootstrap.types.at_least = ((function (ufv___35999,output_schema35994_36000,input_schema35995_36001,input_checker35996_36002,output_checker35997_36003){
return (function at_least(G__35998){var validate__13961__auto__ = ufv___35999.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36004 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__35998], null);var temp__4126__auto___36005 = input_checker35996_36002.call(null,args__13962__auto___36004);if(cljs.core.truth_(temp__4126__auto___36005))
{var error__13963__auto___36006 = temp__4126__auto___36005;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"at-least","at-least",1907728373,null),cljs.core.pr_str.call(null,error__13963__auto___36006)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema35995_36001,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36004,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36006], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__35998;while(true){
return cljs.core.assoc.call(null,schema__$1,schema.core.Any,schema.core.Any);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36007 = output_checker35997_36003.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36007))
{var error__13963__auto___36008 = temp__4126__auto___36007;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"at-least","at-least",1907728373,null),cljs.core.pr_str.call(null,error__13963__auto___36008)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema35994_36000,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36008], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___35999,output_schema35994_36000,input_schema35995_36001,input_checker35996_36002,output_checker35997_36003))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.at_least),schema.core.make_fn_schema.call(null,output_schema35994_36000,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema35995_36001], null)));
var ufv___36021 = schema.utils.use_fn_validation;var output_schema36009_36022 = schema.core.pair.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,schema.core.Any], true, false),"om-bootstrap options.",new cljs.core.PersistentArrayMap.fromArray([schema.core.Any,schema.core.Any], true, false),"all other props.");var input_schema36010_36023 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"schema","schema",58529736,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_schema36015_36024 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"schema","schema",58529736,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"opts","opts",1795607228,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"defaults","defaults",-1678408555,null))], null);var input_checker36011_36025 = schema.core.checker.call(null,input_schema36010_36023);var output_checker36012_36026 = schema.core.checker.call(null,output_schema36009_36022);var input_checker36016_36027 = schema.core.checker.call(null,input_schema36015_36024);var output_checker36017_36028 = schema.core.checker.call(null,output_schema36009_36022);/**
* Inputs: ([schema opts] [schema opts defaults])
* Returns: (s/pair {s/Any s/Any} "om-bootstrap options." {s/Any s/Any} "all other props.")
* 
* Returns two maps; the first is all of the schema options, the
* second is the REST of the options.
*/
om_bootstrap.types.separate = ((function (ufv___36021,output_schema36009_36022,input_schema36010_36023,input_schema36015_36024,input_checker36011_36025,output_checker36012_36026,input_checker36016_36027,output_checker36017_36028){
return (function() {
var separate = null;
var separate__2 = (function (G__36013,G__36014){var validate__13961__auto__ = ufv___36021.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36029 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36013,G__36014], null);var temp__4126__auto___36030 = input_checker36011_36025.call(null,args__13962__auto___36029);if(cljs.core.truth_(temp__4126__auto___36030))
{var error__13963__auto___36031 = temp__4126__auto___36030;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36031)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36010_36023,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36029,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36031], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__36013;var opts = G__36014;while(true){
return separate.call(null,schema__$1,opts,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36032 = output_checker36012_36026.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36032))
{var error__13963__auto___36033 = temp__4126__auto___36032;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36033)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36009_36022,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36033], null));
} else
{}
} else
{}
return o__13964__auto__;
});
var separate__3 = (function (G__36018,G__36019,G__36020){var validate__13961__auto__ = ufv___36021.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36034 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36018,G__36019,G__36020], null);var temp__4126__auto___36035 = input_checker36016_36027.call(null,args__13962__auto___36034);if(cljs.core.truth_(temp__4126__auto___36035))
{var error__13963__auto___36036 = temp__4126__auto___36035;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36036)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36015_36024,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36034,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36036], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var schema__$1 = G__36018;var opts = G__36019;var defaults = G__36020;while(true){
var ks = cljs.core.set.call(null,om_bootstrap.types.schema_keys.call(null,om_bootstrap.types.bootstrap.call(null,schema__$1)));var opts__$1 = cljs.core.merge.call(null,defaults,opts);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,cljs.core.comp.call(null,ks,cljs.core.key),opts__$1)),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.call(null,cljs.core.comp.call(null,ks,cljs.core.key),opts__$1))], null);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36037 = output_checker36017_36028.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36037))
{var error__13963__auto___36038 = temp__4126__auto___36037;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"separate","separate",15703118,null),cljs.core.pr_str.call(null,error__13963__auto___36038)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36009_36022,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36038], null));
} else
{}
} else
{}
return o__13964__auto__;
});
separate = function(G__36018,G__36019,G__36020){
switch(arguments.length){
case 2:
return separate__2.call(this,G__36018,G__36019);
case 3:
return separate__3.call(this,G__36018,G__36019,G__36020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
separate.cljs$core$IFn$_invoke$arity$2 = separate__2;
separate.cljs$core$IFn$_invoke$arity$3 = separate__3;
return separate;
})()
;})(ufv___36021,output_schema36009_36022,input_schema36010_36023,input_schema36015_36024,input_checker36011_36025,output_checker36012_36026,input_checker36016_36027,output_checker36017_36028))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.separate),schema.core.make_fn_schema.call(null,output_schema36009_36022,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36010_36023,input_schema36015_36024], null)));
var ufv___36052 = schema.utils.use_fn_validation;var output_schema36039_36053 = new cljs.core.PersistentArrayMap.fromArray([schema.core.Str,schema.core.Bool], true, false);var input_schema36040_36054 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.types.at_least.call(null,om_bootstrap.types.BootstrapClass),new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker36041_36055 = schema.core.checker.call(null,input_schema36040_36054);var output_checker36042_36056 = schema.core.checker.call(null,output_schema36039_36053);/**
* Inputs: [{:keys [bs-class bs-style bs-size]} :- (at-least BootstrapClass)]
* Returns: {s/Str s/Bool}
* 
* Returns input for class-set.
*/
om_bootstrap.types.bs_class_set = ((function (ufv___36052,output_schema36039_36053,input_schema36040_36054,input_checker36041_36055,output_checker36042_36056){
return (function bs_class_set(G__36043){var validate__13961__auto__ = ufv___36052.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36057 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36043], null);var temp__4126__auto___36058 = input_checker36041_36055.call(null,args__13962__auto___36057);if(cljs.core.truth_(temp__4126__auto___36058))
{var error__13963__auto___36059 = temp__4126__auto___36058;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"bs-class-set","bs-class-set",1457832630,null),cljs.core.pr_str.call(null,error__13963__auto___36059)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36040_36054,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36057,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36059], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__36049 = G__36043;var map__36050 = G__36049;var map__36050__$1 = ((cljs.core.seq_QMARK_.call(null,map__36050))?cljs.core.apply.call(null,cljs.core.hash_map,map__36050):map__36050);var bs_size = cljs.core.get.call(null,map__36050__$1,new cljs.core.Keyword(null,"bs-size","bs-size",1567732754));var bs_style = cljs.core.get.call(null,map__36050__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var bs_class = cljs.core.get.call(null,map__36050__$1,new cljs.core.Keyword(null,"bs-class","bs-class",1438130590));var G__36049__$1 = G__36049;while(true){
var map__36051 = G__36049__$1;var map__36051__$1 = ((cljs.core.seq_QMARK_.call(null,map__36051))?cljs.core.apply.call(null,cljs.core.hash_map,map__36051):map__36051);var bs_size__$1 = cljs.core.get.call(null,map__36051__$1,new cljs.core.Keyword(null,"bs-size","bs-size",1567732754));var bs_style__$1 = cljs.core.get.call(null,map__36051__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var bs_class__$1 = cljs.core.get.call(null,map__36051__$1,new cljs.core.Keyword(null,"bs-class","bs-class",1438130590));var temp__4124__auto__ = om_bootstrap.types.class_map.call(null,bs_class__$1);if(cljs.core.truth_(temp__4124__auto__))
{var klass = temp__4124__auto__;var prefix = (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,klass))+"-");return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap.fromArray([klass,true], true, false),(function (){var temp__4126__auto__ = om_bootstrap.types.size_map.call(null,bs_size__$1);if(cljs.core.truth_(temp__4126__auto__))
{var size = temp__4126__auto__;return new cljs.core.PersistentArrayMap.fromArray([(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))),true], true, false);
} else
{return null;
}
})(),(function (){var temp__4126__auto__ = om_bootstrap.types.style_map.call(null,bs_style__$1);if(cljs.core.truth_(temp__4126__auto__))
{var style = temp__4126__auto__;return new cljs.core.PersistentArrayMap.fromArray([(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,style))),true], true, false);
} else
{return null;
}
})());
} else
{return cljs.core.PersistentArrayMap.EMPTY;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36060 = output_checker36042_36056.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36060))
{var error__13963__auto___36061 = temp__4126__auto___36060;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"bs-class-set","bs-class-set",1457832630,null),cljs.core.pr_str.call(null,error__13963__auto___36061)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36039_36053,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36061], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36052,output_schema36039_36053,input_schema36040_36054,input_checker36041_36055,output_checker36042_36056))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.types.bs_class_set),schema.core.make_fn_schema.call(null,output_schema36039_36053,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36040_36054], null)));

//# sourceMappingURL=types.js.map