// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.mixins');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('schema.core');
goog.require('schema.core');
goog.require('om_tools.mixin');
goog.require('om.core');
goog.require('om.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
var ufv___36167 = schema.utils.use_fn_validation;var output_schema36160_36168 = schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));var input_schema36161_36169 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"target","target",1893533248,null)),schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"event-type","event-type",1960254340,null)),schema.core.one.call(null,schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null)),new cljs.core.Symbol(null,"callback","callback",935395299,null))], null);var input_checker36162_36170 = schema.core.checker.call(null,input_schema36161_36169);var output_checker36163_36171 = schema.core.checker.call(null,output_schema36160_36168);/**
* Inputs: [target :- s/Any event-type :- s/Str callback :- (sm/=> s/Any s/Any)]
* Returns: (sm/=> s/Any)
* 
* Registers the callback on the supplied target for events of type
* `event-type`. Returns a function of no arguments that, when called,
* unregisters the callback.
*/
om_bootstrap.mixins.event_listener = ((function (ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171){
return (function event_listener(G__36164,G__36165,G__36166){var validate__13961__auto__ = ufv___36167.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___36172 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36164,G__36165,G__36166], null);var temp__4126__auto___36173 = input_checker36162_36170.call(null,args__13962__auto___36172);if(cljs.core.truth_(temp__4126__auto___36173))
{var error__13963__auto___36174 = temp__4126__auto___36173;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"event-listener","event-listener",809979412,null),cljs.core.pr_str.call(null,error__13963__auto___36174)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36161_36169,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___36172,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36174], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var target = G__36164;var event_type = G__36165;var callback = G__36166;while(true){
if(cljs.core.truth_(target.addEventListener))
{target.addEventListener(event_type,callback,false);
return ((function (validate__13961__auto__,ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171){
return (function (){return target.removeEventListener(event_type,callback,false);
});
;})(validate__13961__auto__,ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171))
} else
{if(cljs.core.truth_(target.attachEvent))
{var event_type__$1 = ("on"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type));target.attachEvent(event_type__$1,callback);
return ((function (event_type__$1,validate__13961__auto__,ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171){
return (function (){return target.detachEvent(event_type__$1,callback);
});
;})(event_type__$1,validate__13961__auto__,ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171))
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{return ((function (validate__13961__auto__,ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171){
return (function (){return null;
});
;})(validate__13961__auto__,ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171))
} else
{return null;
}
}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___36175 = output_checker36163_36171.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___36175))
{var error__13963__auto___36176 = temp__4126__auto___36175;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"event-listener","event-listener",809979412,null),cljs.core.pr_str.call(null,error__13963__auto___36176)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36160_36168,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___36176], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___36167,output_schema36160_36168,input_schema36161_36169,input_checker36162_36170,output_checker36163_36171))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.mixins.event_listener),schema.core.make_fn_schema.call(null,output_schema36160_36168,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36161_36169], null)));
/**
* Handles a sequence of listeners for the component, and removes them
* from the document when the component is unmounted.
*/
om_bootstrap.mixins.set_listener_mixin = {"set_listener": (function (target36181,event_type36182,callback36183){var this36180 = this;return ((function (this36180){
return (function (owner,target,event_type,callback){var remove_fn = om_bootstrap.mixins.event_listener.call(null,target,event_type,callback);return owner.listeners.push(remove_fn);
});})(this36180))
.call(null,this36180,target36181,event_type36182,callback36183);
}), "componentWillUnmount": (function (){var this36179 = this;return ((function (this36179){
return (function (owner){return owner.listeners.map(((function (this36179){
return (function (p1__36177_SHARP_){return p1__36177_SHARP_.call(null);
});})(this36179))
);
});})(this36179))
.call(null,this36179);
}), "componentWillMount": (function (){var this36178 = this;return ((function (this36178){
return (function (owner){return owner.listeners = [];
});})(this36178))
.call(null,this36178);
})};
/**
* Handles a sequence of timeouts for the component, and removes them
* from the document when the component is unmounted.
*/
om_bootstrap.mixins.set_timeout_mixin = {"set_timeout": (function (f36188,timeout36189){var this36187 = this;return ((function (this36187){
return (function (owner,f,timeout){var timeout__$1 = setTimeout(f,timeout);return owner.timeouts.push(timeout__$1);
});})(this36187))
.call(null,this36187,f36188,timeout36189);
}), "componentWillUnmount": (function (){var this36186 = this;return ((function (this36186){
return (function (owner){return owner.timeouts.map(((function (this36186){
return (function (p1__36184_SHARP_){return clearTimeout(p1__36184_SHARP_);
});})(this36186))
);
});})(this36186))
.call(null,this36186);
}), "componentWillMount": (function (){var this36185 = this;return ((function (this36185){
return (function (owner){return owner.timeouts = [];
});})(this36185))
.call(null,this36185);
})};
/**
* Accepts two DOM elements; returns true if the supplied node is
* nested inside the supplied root, false otherwise.
*/
om_bootstrap.mixins.in_root_QMARK_ = (function in_root_QMARK_(node,root){var node__$1 = node;while(true){
if((node__$1 == null))
{return false;
} else
{if(cljs.core._EQ_.call(null,root,node__$1))
{return true;
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{{
var G__36190 = node__$1.parentNode;
node__$1 = G__36190;
continue;
}
} else
{return null;
}
}
}
break;
}
});
om_bootstrap.mixins.ESCAPE_KEY = (27);
/**
* For dropdowns, binds a handler for that sets the dropdown-mixin's
* `:open?` state to false if the user clicks outside the owning
* component OR hits the escape key.
*/
om_bootstrap.mixins.bind_root_close_handlers_BANG_ = (function bind_root_close_handlers_BANG_(owner){var set_state = (owner["setDropdownState"]);return owner.dropdownListeners = [om_bootstrap.mixins.event_listener.call(null,document,"click",((function (set_state){
return (function (e){if(om_bootstrap.mixins.in_root_QMARK_.call(null,e.target,om.core.get_node.call(null,owner)))
{return null;
} else
{return set_state.call(null,false);
}
});})(set_state))
),om_bootstrap.mixins.event_listener.call(null,document,"keyup",((function (set_state){
return (function (e){if(cljs.core._EQ_.call(null,om_bootstrap.mixins.ESCAPE_KEY,e.keyCode))
{return set_state.call(null,false);
} else
{return null;
}
});})(set_state))
)];
});
/**
* If they're present on the owning object, removes the listeners
* registered by the dropdown mixin.
*/
om_bootstrap.mixins.unbind_root_close_handlers_BANG_ = (function unbind_root_close_handlers_BANG_(owner){var temp__4126__auto__ = owner.dropdownListeners;if(cljs.core.truth_(temp__4126__auto__))
{var listeners = temp__4126__auto__;cljs.core.map.call(null,((function (listeners,temp__4126__auto__){
return (function (p1__36191_SHARP_){return p1__36191_SHARP_.call(null);
});})(listeners,temp__4126__auto__))
,listeners);
return owner.dropdownListeners = null;
} else
{return null;
}
});
/**
* Mixin that manages a single piece of state - :open?. If a user
* clicks outside the component's owning dom element OR hits the escape
* key, the state will jump back to false.
* 
* Down the road this may need to register a callback when the state
* changes.
*/
om_bootstrap.mixins.dropdown_mixin = {"setDropdownState": (function (open_QMARK_36196){var this36195 = this;return ((function (this36195){
return (function (owner,open_QMARK_){if(cljs.core.truth_(open_QMARK_))
{om_bootstrap.mixins.bind_root_close_handlers_BANG_.call(null,owner);
} else
{om_bootstrap.mixins.unbind_root_close_handlers_BANG_.call(null,owner);
}
return om.core.set_state_BANG_.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"open?","open?",1238443125)], null),open_QMARK_);
});})(this36195))
.call(null,this36195,open_QMARK_36196);
}), "isDropdownOpen": (function (){var this36194 = this;return ((function (this36194){
return (function (owner){return om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"open?","open?",1238443125));
});})(this36194))
.call(null,this36194);
}), "componentWillUnmount": (function (){var this36193 = this;return ((function (this36193){
return (function (owner){return om_bootstrap.mixins.unbind_root_close_handlers_BANG_.call(null,owner);
});})(this36193))
.call(null,this36193);
}), "getInitialState": (function (){var this36192 = this;return ((function (this36192){
return (function (_){return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null);
});})(this36192))
.call(null,this36192);
})};

//# sourceMappingURL=mixins.js.map