// Compiled by ClojureScript 0.0-2277
goog.provide('om_bootstrap.input');
goog.require('cljs.core');
goog.require('om_bootstrap.types');
goog.require('schema.core');
goog.require('om_bootstrap.util');
goog.require('om_tools.dom');
goog.require('schema.core');
goog.require('clojure.string');
goog.require('om_bootstrap.util');
goog.require('om.core');
goog.require('om.core');
goog.require('clojure.string');
goog.require('om_bootstrap.types');
goog.require('om_tools.dom');
om_bootstrap.input.Addons = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384)),schema.core.either.call(null,schema.core.Str,om_bootstrap.types.Component),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"addon-after","addon-after",634985306)),schema.core.either.call(null,schema.core.Str,om_bootstrap.types.Component)], true, false);
/**
* Helps render feedback icons.
*/
om_bootstrap.input.FeedbackIcons = new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)),schema.core.enum$.call(null,"success","warning","error"),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821)),schema.core.Bool], true, false);
/**
* Input fields that match these bad dawgs:
* https://github.com/react-bootstrap/react-bootstrap/blob/master/src/Input.jsx
*/
om_bootstrap.input.Input = cljs.core.merge.call(null,om_bootstrap.input.Addons,om_bootstrap.input.FeedbackIcons,new cljs.core.PersistentArrayMap.fromArray([schema.core.optional_key.call(null,new cljs.core.Keyword(null,"type","type",1174270348)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label","label",1718410804)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"skip-form-group?","skip-form-group?",210862261)),schema.core.named.call(null,schema.core.Bool,"DON'T render a wrapping form group?"),schema.core.optional_key.call(null,new cljs.core.Keyword(null,"help","help",-439233446)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866)),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212)),schema.core.Str], true, false));
om_bootstrap.input.Radio = om_bootstrap.types.bootstrap.call(null,new cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"label","label",1718410804),schema.core.Str,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"checked?","checked?",2024809091)),schema.core.Bool,schema.core.optional_key.call(null,new cljs.core.Keyword(null,"inline?","inline?",-1674483791)),schema.core.Bool], true, false));
var ufv___37224 = schema.utils.use_fn_validation;var output_schema37215_37225 = schema.core.Str;var input_schema37216_37226 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.Str,schema.core.Keyword),schema.core.Bool], true, false),new cljs.core.Symbol(null,"klasses","klasses",-380235757,null))], null);var input_checker37217_37227 = schema.core.checker.call(null,input_schema37216_37226);var output_checker37218_37228 = schema.core.checker.call(null,output_schema37215_37225);/**
* Inputs: [klasses :- {(s/either s/Str s/Keyword) s/Bool}]
* Returns: s/Str
* 
* Mimics the class-set behavior from React. Pass in a map of
* potential class to Boolean; you'll get back a class string that
* represents the final class to apply.
* 
* TODO: Use class-set from om-tools.
*/
om_bootstrap.input.class_set = ((function (ufv___37224,output_schema37215_37225,input_schema37216_37226,input_checker37217_37227,output_checker37218_37228){
return (function class_set(G__37219){var validate__13961__auto__ = ufv___37224.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37229 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37219], null);var temp__4126__auto___37230 = input_checker37217_37227.call(null,args__13962__auto___37229);if(cljs.core.truth_(temp__4126__auto___37230))
{var error__13963__auto___37231 = temp__4126__auto___37230;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"class-set","class-set",-355600496,null),cljs.core.pr_str.call(null,error__13963__auto___37231)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37216_37226,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37229,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37231], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var klasses = G__37219;while(true){
return clojure.string.join.call(null," ",cljs.core.mapcat.call(null,((function (validate__13961__auto__,ufv___37224,output_schema37215_37225,input_schema37216_37226,input_checker37217_37227,output_checker37218_37228){
return (function (p__37222){var vec__37223 = p__37222;var k = cljs.core.nth.call(null,vec__37223,(0),null);var keep_QMARK_ = cljs.core.nth.call(null,vec__37223,(1),null);if(cljs.core.truth_(keep_QMARK_))
{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.name.call(null,k)], null);
} else
{return null;
}
});})(validate__13961__auto__,ufv___37224,output_schema37215_37225,input_schema37216_37226,input_checker37217_37227,output_checker37218_37228))
,klasses));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37232 = output_checker37218_37228.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37232))
{var error__13963__auto___37233 = temp__4126__auto___37232;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"class-set","class-set",-355600496,null),cljs.core.pr_str.call(null,error__13963__auto___37233)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37215_37225,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37233], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37224,output_schema37215_37225,input_schema37216_37226,input_checker37217_37227,output_checker37218_37228))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.class_set),schema.core.make_fn_schema.call(null,output_schema37215_37225,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37216_37226], null)));
var ufv___37239 = schema.utils.use_fn_validation;var output_schema37234_37240 = om_bootstrap.types.Component;var input_schema37235_37241 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"glyph-name","glyph-name",350405338,null))], null);var input_checker37236_37242 = schema.core.checker.call(null,input_schema37235_37241);var output_checker37237_37243 = schema.core.checker.call(null,output_schema37234_37240);/**
* Inputs: [glyph-name :- s/Str]
* Returns: t/Component
* 
* To be used with :addon-before or :addon-after.
*/
om_bootstrap.input.glyph = ((function (ufv___37239,output_schema37234_37240,input_schema37235_37241,input_checker37236_37242,output_checker37237_37243){
return (function glyph(G__37238){var validate__13961__auto__ = ufv___37239.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37244 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37238], null);var temp__4126__auto___37245 = input_checker37236_37242.call(null,args__13962__auto___37244);if(cljs.core.truth_(temp__4126__auto___37245))
{var error__13963__auto___37246 = temp__4126__auto___37245;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"glyph","glyph",-534987652,null),cljs.core.pr_str.call(null,error__13963__auto___37246)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37235_37241,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37244,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37246], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var glyph_name = G__37238;while(true){
return React.DOM.span({"className": om_tools.dom.format_opts.call(null,("glyphicon glyphicon-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(glyph_name)))});
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37247 = output_checker37237_37243.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37247))
{var error__13963__auto___37248 = temp__4126__auto___37247;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"glyph","glyph",-534987652,null),cljs.core.pr_str.call(null,error__13963__auto___37248)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37234_37240,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37248], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37239,output_schema37234_37240,input_schema37235_37241,input_checker37236_37242,output_checker37237_37243))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.glyph),schema.core.make_fn_schema.call(null,output_schema37234_37240,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37235_37241], null)));
var ufv___37262 = schema.utils.use_fn_validation;var output_schema37249_37263 = om_bootstrap.types.Component;var input_schema37250_37264 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.FeedbackIcons,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker37251_37265 = schema.core.checker.call(null,input_schema37250_37264);var output_checker37252_37266 = schema.core.checker.call(null,output_schema37249_37263);/**
* Inputs: [{:keys [feedback? bs-style]} :- FeedbackIcons]
* Returns: t/Component
*/
om_bootstrap.input.render_icon = ((function (ufv___37262,output_schema37249_37263,input_schema37250_37264,input_checker37251_37265,output_checker37252_37266){
return (function render_icon(G__37253){var validate__13961__auto__ = ufv___37262.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37267 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37253], null);var temp__4126__auto___37268 = input_checker37251_37265.call(null,args__13962__auto___37267);if(cljs.core.truth_(temp__4126__auto___37268))
{var error__13963__auto___37269 = temp__4126__auto___37268;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-icon","render-icon",511977669,null),cljs.core.pr_str.call(null,error__13963__auto___37269)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37250_37264,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37267,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37269], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37259 = G__37253;var map__37260 = G__37259;var map__37260__$1 = ((cljs.core.seq_QMARK_.call(null,map__37260))?cljs.core.apply.call(null,cljs.core.hash_map,map__37260):map__37260);var bs_style = cljs.core.get.call(null,map__37260__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var feedback_QMARK_ = cljs.core.get.call(null,map__37260__$1,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821));var G__37259__$1 = G__37259;while(true){
var map__37261 = G__37259__$1;var map__37261__$1 = ((cljs.core.seq_QMARK_.call(null,map__37261))?cljs.core.apply.call(null,cljs.core.hash_map,map__37261):map__37261);var bs_style__$1 = cljs.core.get.call(null,map__37261__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var feedback_QMARK___$1 = cljs.core.get.call(null,map__37261__$1,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821));if(cljs.core.truth_(feedback_QMARK___$1))
{var klasses = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"glyphicon","glyphicon",-2083132161),true,new cljs.core.Keyword(null,"form-control-feedback","form-control-feedback",-26248681),true,new cljs.core.Keyword(null,"glyphicon-ok","glyphicon-ok",-980475854),cljs.core._EQ_.call(null,"success",bs_style__$1),new cljs.core.Keyword(null,"glyphicon-warning-sign","glyphicon-warning-sign",-715964093),cljs.core._EQ_.call(null,"warning",bs_style__$1),new cljs.core.Keyword(null,"glyphicon-remove","glyphicon-remove",16420020),cljs.core._EQ_.call(null,"error",bs_style__$1)], null);return React.DOM.span({"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,klasses))});
} else
{return null;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37270 = output_checker37252_37266.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37270))
{var error__13963__auto___37271 = temp__4126__auto___37270;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-icon","render-icon",511977669,null),cljs.core.pr_str.call(null,error__13963__auto___37271)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37249_37263,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37271], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37262,output_schema37249_37263,input_schema37250_37264,input_checker37251_37265,output_checker37252_37266))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_icon),schema.core.make_fn_schema.call(null,output_schema37249_37263,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37250_37264], null)));
var ufv___37277 = schema.utils.use_fn_validation;var output_schema37272_37278 = schema.core.Any;var input_schema37273_37279 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.maybe.call(null,schema.core.Str),new cljs.core.Symbol(null,"help","help",1201298081,null))], null);var input_checker37274_37280 = schema.core.checker.call(null,input_schema37273_37279);var output_checker37275_37281 = schema.core.checker.call(null,output_schema37272_37278);/**
* Inputs: [help :- (s/maybe s/Str)]
*/
om_bootstrap.input.render_help = ((function (ufv___37277,output_schema37272_37278,input_schema37273_37279,input_checker37274_37280,output_checker37275_37281){
return (function render_help(G__37276){var validate__13961__auto__ = ufv___37277.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37282 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37276], null);var temp__4126__auto___37283 = input_checker37274_37280.call(null,args__13962__auto___37282);if(cljs.core.truth_(temp__4126__auto___37283))
{var error__13963__auto___37284 = temp__4126__auto___37283;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-help","render-help",-1879333594,null),cljs.core.pr_str.call(null,error__13963__auto___37284)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37273_37279,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37282,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37284], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var help = G__37276;while(true){
if(cljs.core.truth_(help))
{return cljs.core.apply.call(null,React.DOM.span,{"className": "help-block"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[help],null))));
} else
{return null;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37285 = output_checker37275_37281.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37285))
{var error__13963__auto___37286 = temp__4126__auto___37285;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-help","render-help",-1879333594,null),cljs.core.pr_str.call(null,error__13963__auto___37286)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37272_37278,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37286], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37277,output_schema37272_37278,input_schema37273_37279,input_checker37274_37280,output_checker37275_37281))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_help),schema.core.make_fn_schema.call(null,output_schema37272_37278,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37273_37279], null)));
var ufv___37301 = schema.utils.use_fn_validation;var output_schema37287_37302 = schema.core.Any;var input_schema37288_37303 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Addons,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"items","items",-1622480831,null))], null);var input_checker37289_37304 = schema.core.checker.call(null,input_schema37288_37303);var output_checker37290_37305 = schema.core.checker.call(null,output_schema37287_37302);/**
* Inputs: [{:keys [addon-before addon-after]} :- Addons items :- s/Any]
* 
* Items is a vector of render instances.
*/
om_bootstrap.input.render_input_group = ((function (ufv___37301,output_schema37287_37302,input_schema37288_37303,input_checker37289_37304,output_checker37290_37305){
return (function render_input_group(G__37291,G__37292){var validate__13961__auto__ = ufv___37301.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37306 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37291,G__37292], null);var temp__4126__auto___37307 = input_checker37289_37304.call(null,args__13962__auto___37306);if(cljs.core.truth_(temp__4126__auto___37307))
{var error__13963__auto___37308 = temp__4126__auto___37307;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-input-group","render-input-group",361721583,null),cljs.core.pr_str.call(null,error__13963__auto___37308)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37288_37303,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37306,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37308], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37298 = G__37291;var map__37299 = G__37298;var map__37299__$1 = ((cljs.core.seq_QMARK_.call(null,map__37299))?cljs.core.apply.call(null,cljs.core.hash_map,map__37299):map__37299);var addon_after = cljs.core.get.call(null,map__37299__$1,new cljs.core.Keyword(null,"addon-after","addon-after",634985306));var addon_before = cljs.core.get.call(null,map__37299__$1,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384));var items = G__37292;var G__37298__$1 = G__37298;var items__$1 = items;while(true){
var map__37300 = G__37298__$1;var map__37300__$1 = ((cljs.core.seq_QMARK_.call(null,map__37300))?cljs.core.apply.call(null,cljs.core.hash_map,map__37300):map__37300);var addon_after__$1 = cljs.core.get.call(null,map__37300__$1,new cljs.core.Keyword(null,"addon-after","addon-after",634985306));var addon_before__$1 = cljs.core.get.call(null,map__37300__$1,new cljs.core.Keyword(null,"addon-before","addon-before",-500360384));var items__$2 = items__$1;if(cljs.core.truth_((function (){var or__3541__auto__ = addon_before__$1;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return addon_after__$1;
}
})()))
{return cljs.core.apply.call(null,React.DOM.div,{"className": "input-group"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(cljs.core.truth_(addon_before__$1)?cljs.core.apply.call(null,React.DOM.span,{"className": "input-group-addon"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[addon_before__$1],null)))):null),items__$2,(cljs.core.truth_(addon_after__$1)?cljs.core.apply.call(null,React.DOM.span,{"className": "input-group-addon"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[addon_after__$1],null)))):null)],null))));
} else
{return items__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37309 = output_checker37290_37305.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37309))
{var error__13963__auto___37310 = temp__4126__auto___37309;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-input-group","render-input-group",361721583,null),cljs.core.pr_str.call(null,error__13963__auto___37310)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37287_37302,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37310], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37301,output_schema37287_37302,input_schema37288_37303,input_checker37289_37304,output_checker37290_37305))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_input_group),schema.core.make_fn_schema.call(null,output_schema37287_37302,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37288_37303], null)));
var ufv___37324 = schema.utils.use_fn_validation;var output_schema37311_37325 = schema.core.Bool;var input_schema37312_37326 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null);var input_checker37313_37327 = schema.core.checker.call(null,input_schema37312_37326);var output_checker37314_37328 = schema.core.checker.call(null,output_schema37311_37325);/**
* Inputs: [{type :type} :- Input]
* Returns: s/Bool
* 
* Returns true if the supplied input is of type checkbox or radio,
* false otherwise.
*/
om_bootstrap.input.checkbox_or_radio_QMARK_ = ((function (ufv___37324,output_schema37311_37325,input_schema37312_37326,input_checker37313_37327,output_checker37314_37328){
return (function checkbox_or_radio_QMARK_(G__37315){var validate__13961__auto__ = ufv___37324.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37329 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37315], null);var temp__4126__auto___37330 = input_checker37313_37327.call(null,args__13962__auto___37329);if(cljs.core.truth_(temp__4126__auto___37330))
{var error__13963__auto___37331 = temp__4126__auto___37330;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio?","checkbox-or-radio?",-1047589288,null),cljs.core.pr_str.call(null,error__13963__auto___37331)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37312_37326,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37329,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37331], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37321 = G__37315;var map__37322 = G__37321;var map__37322__$1 = ((cljs.core.seq_QMARK_.call(null,map__37322))?cljs.core.apply.call(null,cljs.core.hash_map,map__37322):map__37322);var type = cljs.core.get.call(null,map__37322__$1,new cljs.core.Keyword(null,"type","type",1174270348));var G__37321__$1 = G__37321;while(true){
var map__37323 = G__37321__$1;var map__37323__$1 = ((cljs.core.seq_QMARK_.call(null,map__37323))?cljs.core.apply.call(null,cljs.core.hash_map,map__37323):map__37323);var type__$1 = cljs.core.get.call(null,map__37323__$1,new cljs.core.Keyword(null,"type","type",1174270348));return (cljs.core._EQ_.call(null,type__$1,"checkbox")) || (cljs.core._EQ_.call(null,type__$1,"radio"));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37332 = output_checker37314_37328.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37332))
{var error__13963__auto___37333 = temp__4126__auto___37332;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio?","checkbox-or-radio?",-1047589288,null),cljs.core.pr_str.call(null,error__13963__auto___37333)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37311_37325,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37333], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37324,output_schema37311_37325,input_schema37312_37326,input_checker37313_37327,output_checker37314_37328))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.checkbox_or_radio_QMARK_),schema.core.make_fn_schema.call(null,output_schema37311_37325,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37312_37326], null)));
var ufv___37348 = schema.utils.use_fn_validation;var output_schema37334_37349 = om_bootstrap.types.Component;var input_schema37335_37350 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37336_37351 = schema.core.checker.call(null,input_schema37335_37350);var output_checker37337_37352 = schema.core.checker.call(null,output_schema37334_37349);/**
* Inputs: [{type :type} :- Input children]
* Returns: t/Component
* 
* Wraps this business in a div.
*/
om_bootstrap.input.checkbox_or_radio_wrapper = ((function (ufv___37348,output_schema37334_37349,input_schema37335_37350,input_checker37336_37351,output_checker37337_37352){
return (function checkbox_or_radio_wrapper(G__37338,G__37339){var validate__13961__auto__ = ufv___37348.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37353 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37338,G__37339], null);var temp__4126__auto___37354 = input_checker37336_37351.call(null,args__13962__auto___37353);if(cljs.core.truth_(temp__4126__auto___37354))
{var error__13963__auto___37355 = temp__4126__auto___37354;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio-wrapper","checkbox-or-radio-wrapper",-964759132,null),cljs.core.pr_str.call(null,error__13963__auto___37355)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37335_37350,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37353,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37355], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37345 = G__37338;var map__37346 = G__37345;var map__37346__$1 = ((cljs.core.seq_QMARK_.call(null,map__37346))?cljs.core.apply.call(null,cljs.core.hash_map,map__37346):map__37346);var type = cljs.core.get.call(null,map__37346__$1,new cljs.core.Keyword(null,"type","type",1174270348));var children = G__37339;var G__37345__$1 = G__37345;var children__$1 = children;while(true){
var map__37347 = G__37345__$1;var map__37347__$1 = ((cljs.core.seq_QMARK_.call(null,map__37347))?cljs.core.apply.call(null,cljs.core.hash_map,map__37347):map__37347);var type__$1 = cljs.core.get.call(null,map__37347__$1,new cljs.core.Keyword(null,"type","type",1174270348));var children__$2 = children__$1;var klasses = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"checkbox","checkbox",1612615655),cljs.core._EQ_.call(null,"checkbox",type__$1),new cljs.core.Keyword(null,"radio","radio",1323726374),cljs.core._EQ_.call(null,"radio",type__$1)], null);return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,klasses))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children__$2],null))));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37356 = output_checker37337_37352.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37356))
{var error__13963__auto___37357 = temp__4126__auto___37356;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"checkbox-or-radio-wrapper","checkbox-or-radio-wrapper",-964759132,null),cljs.core.pr_str.call(null,error__13963__auto___37357)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37334_37349,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37357], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37348,output_schema37334_37349,input_schema37335_37350,input_checker37336_37351,output_checker37337_37352))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.checkbox_or_radio_wrapper),schema.core.make_fn_schema.call(null,output_schema37334_37349,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37335_37350], null)));
var ufv___37376 = schema.utils.use_fn_validation;var output_schema37358_37377 = schema.core.Any;var input_schema37359_37378 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"input","input",-2097503808,null))], null);var input_schema37363_37379 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker37360_37380 = schema.core.checker.call(null,input_schema37359_37378);var output_checker37361_37381 = schema.core.checker.call(null,output_schema37358_37377);var input_checker37364_37382 = schema.core.checker.call(null,input_schema37363_37379);var output_checker37365_37383 = schema.core.checker.call(null,output_schema37358_37377);/**
* Inputs: ([input :- Input] [{lc :label-classname, label :label, :as input} :- Input child])
* 
* This doesn't handle any control group stuff.
*/
om_bootstrap.input.render_label = ((function (ufv___37376,output_schema37358_37377,input_schema37359_37378,input_schema37363_37379,input_checker37360_37380,output_checker37361_37381,input_checker37364_37382,output_checker37365_37383){
return (function() {
var render_label = null;
var render_label__1 = (function (G__37362){var validate__13961__auto__ = ufv___37376.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37384 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37362], null);var temp__4126__auto___37385 = input_checker37360_37380.call(null,args__13962__auto___37384);if(cljs.core.truth_(temp__4126__auto___37385))
{var error__13963__auto___37386 = temp__4126__auto___37385;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37386)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37359_37378,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37384,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37386], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var input = G__37362;while(true){
return render_label.call(null,input,null);
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37387 = output_checker37361_37381.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37387))
{var error__13963__auto___37388 = temp__4126__auto___37387;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37388)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37358_37377,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37388], null));
} else
{}
} else
{}
return o__13964__auto__;
});
var render_label__2 = (function (G__37366,G__37367){var validate__13961__auto__ = ufv___37376.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37389 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37366,G__37367], null);var temp__4126__auto___37390 = input_checker37364_37382.call(null,args__13962__auto___37389);if(cljs.core.truth_(temp__4126__auto___37390))
{var error__13963__auto___37391 = temp__4126__auto___37390;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37391)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37363_37379,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37389,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37391], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37373 = G__37366;var map__37374 = G__37373;var map__37374__$1 = ((cljs.core.seq_QMARK_.call(null,map__37374))?cljs.core.apply.call(null,cljs.core.hash_map,map__37374):map__37374);var input = map__37374__$1;var lc = cljs.core.get.call(null,map__37374__$1,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212));var label = cljs.core.get.call(null,map__37374__$1,new cljs.core.Keyword(null,"label","label",1718410804));var child = G__37367;var G__37373__$1 = G__37373;var child__$1 = child;while(true){
var map__37375 = G__37373__$1;var map__37375__$1 = ((cljs.core.seq_QMARK_.call(null,map__37375))?cljs.core.apply.call(null,cljs.core.hash_map,map__37375):map__37375);var input__$1 = map__37375__$1;var lc__$1 = cljs.core.get.call(null,map__37375__$1,new cljs.core.Keyword(null,"label-classname","label-classname",-1752600212));var label__$1 = cljs.core.get.call(null,map__37375__$1,new cljs.core.Keyword(null,"label","label",1718410804));var child__$2 = child__$1;var classes = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"control-label","control-label",1226436372),!(om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input__$1))], null),(cljs.core.truth_(lc__$1)?new cljs.core.PersistentArrayMap.fromArray([lc__$1,cljs.core.boolean$.call(null,lc__$1)], true, false):null));if(cljs.core.truth_(label__$1))
{return cljs.core.apply.call(null,React.DOM.label,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,classes))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[child__$2,label__$1],null))));
} else
{return child__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37392 = output_checker37365_37383.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37392))
{var error__13963__auto___37393 = temp__4126__auto___37392;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-label","render-label",-2019535210,null),cljs.core.pr_str.call(null,error__13963__auto___37393)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37358_37377,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37393], null));
} else
{}
} else
{}
return o__13964__auto__;
});
render_label = function(G__37366,G__37367){
switch(arguments.length){
case 1:
return render_label__1.call(this,G__37366);
case 2:
return render_label__2.call(this,G__37366,G__37367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
render_label.cljs$core$IFn$_invoke$arity$1 = render_label__1;
render_label.cljs$core$IFn$_invoke$arity$2 = render_label__2;
return render_label;
})()
;})(ufv___37376,output_schema37358_37377,input_schema37359_37378,input_schema37363_37379,input_checker37360_37380,output_checker37361_37381,input_checker37364_37382,output_checker37365_37383))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_label),schema.core.make_fn_schema.call(null,output_schema37358_37377,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37359_37378,input_schema37363_37379], null)));
var ufv___37408 = schema.utils.use_fn_validation;var output_schema37394_37409 = schema.core.Any;var input_schema37395_37410 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"child","child",-2030468224,null))], null);var input_checker37396_37411 = schema.core.checker.call(null,input_schema37395_37410);var output_checker37397_37412 = schema.core.checker.call(null,output_schema37394_37409);/**
* Inputs: [{wc :wrapper-classname} :- Input child]
*/
om_bootstrap.input.render_wrapper = ((function (ufv___37408,output_schema37394_37409,input_schema37395_37410,input_checker37396_37411,output_checker37397_37412){
return (function render_wrapper(G__37398,G__37399){var validate__13961__auto__ = ufv___37408.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37413 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37398,G__37399], null);var temp__4126__auto___37414 = input_checker37396_37411.call(null,args__13962__auto___37413);if(cljs.core.truth_(temp__4126__auto___37414))
{var error__13963__auto___37415 = temp__4126__auto___37414;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-wrapper","render-wrapper",79817165,null),cljs.core.pr_str.call(null,error__13963__auto___37415)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37395_37410,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37413,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37415], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37405 = G__37398;var map__37406 = G__37405;var map__37406__$1 = ((cljs.core.seq_QMARK_.call(null,map__37406))?cljs.core.apply.call(null,cljs.core.hash_map,map__37406):map__37406);var wc = cljs.core.get.call(null,map__37406__$1,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866));var child = G__37399;var G__37405__$1 = G__37405;var child__$1 = child;while(true){
var map__37407 = G__37405__$1;var map__37407__$1 = ((cljs.core.seq_QMARK_.call(null,map__37407))?cljs.core.apply.call(null,cljs.core.hash_map,map__37407):map__37407);var wc__$1 = cljs.core.get.call(null,map__37407__$1,new cljs.core.Keyword(null,"wrapper-classname","wrapper-classname",1629533866));var child__$2 = child__$1;if(cljs.core.truth_(wc__$1))
{return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,wc__$1)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[child__$2],null))));
} else
{return child__$2;
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37416 = output_checker37397_37412.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37416))
{var error__13963__auto___37417 = temp__4126__auto___37416;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-wrapper","render-wrapper",79817165,null),cljs.core.pr_str.call(null,error__13963__auto___37417)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37394_37409,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37417], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37408,output_schema37394_37409,input_schema37395_37410,input_checker37396_37411,output_checker37397_37412))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_wrapper),schema.core.make_fn_schema.call(null,output_schema37394_37409,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37395_37410], null)));
var ufv___37432 = schema.utils.use_fn_validation;var output_schema37418_37433 = om_bootstrap.types.Component;var input_schema37419_37434 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37420_37435 = schema.core.checker.call(null,input_schema37419_37434);var output_checker37421_37436 = schema.core.checker.call(null,output_schema37418_37433);/**
* Inputs: [{bs-style :bs-style, cn :group-classname, :as input} :- Input children]
* Returns: t/Component
* 
* Wraps the entire form group.
*/
om_bootstrap.input.render_form_group = ((function (ufv___37432,output_schema37418_37433,input_schema37419_37434,input_checker37420_37435,output_checker37421_37436){
return (function render_form_group(G__37422,G__37423){var validate__13961__auto__ = ufv___37432.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37437 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37422,G__37423], null);var temp__4126__auto___37438 = input_checker37420_37435.call(null,args__13962__auto___37437);if(cljs.core.truth_(temp__4126__auto___37438))
{var error__13963__auto___37439 = temp__4126__auto___37438;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-form-group","render-form-group",2039718866,null),cljs.core.pr_str.call(null,error__13963__auto___37439)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37419_37434,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37437,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37439], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var G__37429 = G__37422;var map__37430 = G__37429;var map__37430__$1 = ((cljs.core.seq_QMARK_.call(null,map__37430))?cljs.core.apply.call(null,cljs.core.hash_map,map__37430):map__37430);var input = map__37430__$1;var bs_style = cljs.core.get.call(null,map__37430__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var cn = cljs.core.get.call(null,map__37430__$1,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816));var children = G__37423;var G__37429__$1 = G__37429;var children__$1 = children;while(true){
var map__37431 = G__37429__$1;var map__37431__$1 = ((cljs.core.seq_QMARK_.call(null,map__37431))?cljs.core.apply.call(null,cljs.core.hash_map,map__37431):map__37431);var input__$1 = map__37431__$1;var bs_style__$1 = cljs.core.get.call(null,map__37431__$1,new cljs.core.Keyword(null,"bs-style","bs-style",1424423998));var cn__$1 = cljs.core.get.call(null,map__37431__$1,new cljs.core.Keyword(null,"group-classname","group-classname",-610987816));var children__$2 = children__$1;var classes = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"form-group","form-group",-267875328),cljs.core.not.call(null,new cljs.core.Keyword(null,"skip-form-group?","skip-form-group?",210862261).cljs$core$IFn$_invoke$arity$1(input__$1)),new cljs.core.Keyword(null,"has-feedback","has-feedback",1328001802),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821).cljs$core$IFn$_invoke$arity$1(input__$1)),new cljs.core.Keyword(null,"has-success","has-success",685004255),cljs.core._EQ_.call(null,"success",bs_style__$1),new cljs.core.Keyword(null,"has-warning","has-warning",1993894136),cljs.core._EQ_.call(null,"warning",bs_style__$1),new cljs.core.Keyword(null,"has-error","has-error",-786302929),cljs.core._EQ_.call(null,"error",bs_style__$1)], null),(cljs.core.truth_(cn__$1)?new cljs.core.PersistentArrayMap.fromArray([cn__$1,cljs.core.boolean$.call(null,cn__$1)], true, false):null));return cljs.core.apply.call(null,React.DOM.div,{"className": om_tools.dom.format_opts.call(null,om_bootstrap.input.class_set.call(null,classes))},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children__$2],null))));
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37440 = output_checker37421_37436.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37440))
{var error__13963__auto___37441 = temp__4126__auto___37440;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-form-group","render-form-group",2039718866,null),cljs.core.pr_str.call(null,error__13963__auto___37441)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37418_37433,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37441], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37432,output_schema37418_37433,input_schema37419_37434,input_checker37420_37435,output_checker37421_37436))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_form_group),schema.core.make_fn_schema.call(null,output_schema37418_37433,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37419_37434], null)));
var ufv___37451 = schema.utils.use_fn_validation;var output_schema37442_37452 = om_bootstrap.types.Component;var input_schema37443_37453 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"attrs","attrs",-450137186,null)),schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"children","children",699969545,null))], null);var input_checker37444_37454 = schema.core.checker.call(null,input_schema37443_37453);var output_checker37445_37455 = schema.core.checker.call(null,output_schema37442_37452);/**
* Inputs: [input :- Input attrs children]
* Returns: t/Component
*/
om_bootstrap.input.render_input = ((function (ufv___37451,output_schema37442_37452,input_schema37443_37453,input_checker37444_37454,output_checker37445_37455){
return (function render_input(G__37446,G__37447,G__37448){var validate__13961__auto__ = ufv___37451.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37456 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37446,G__37447,G__37448], null);var temp__4126__auto___37457 = input_checker37444_37454.call(null,args__13962__auto___37456);if(cljs.core.truth_(temp__4126__auto___37457))
{var error__13963__auto___37458 = temp__4126__auto___37457;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"render-input","render-input",243083212,null),cljs.core.pr_str.call(null,error__13963__auto___37458)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37443_37453,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37456,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37458], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var input = G__37446;var attrs = G__37447;var children = G__37448;while(true){
var props = ((function (validate__13961__auto__,ufv___37451,output_schema37442_37452,input_schema37443_37453,input_checker37444_37454,output_checker37445_37455){
return (function (klass){return om_bootstrap.util.merge_props.call(null,attrs,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),klass,new cljs.core.Keyword(null,"ref","ref",1289896967),"input",new cljs.core.Keyword(null,"key","key",-1516042587),"input"], null));
});})(validate__13961__auto__,ufv___37451,output_schema37442_37452,input_schema37443_37453,input_checker37444_37454,output_checker37445_37455))
;if(cljs.core.not.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input)))
{return children;
} else
{var G__37450 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input);switch (G__37450) {
case "select":
return om_tools.dom.element.call(null,React.DOM.select,props.call(null,"form-control"),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children],null)));

break;
case "textarea":
return om_tools.dom.element.call(null,om.dom.textarea,props.call(null,"form-control"),cljs.core.PersistentVector.EMPTY);

break;
case "static":
return om_tools.dom.element.call(null,React.DOM.p,props.call(null,"form-control-static"),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(attrs)],null)));

break;
default:
return om_tools.dom.element.call(null,om.dom.input,cljs.core.assoc.call(null,props.call(null,((om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input))?"":"form-control")),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(input)),(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[children],null)));

}
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37460 = output_checker37445_37455.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37460))
{var error__13963__auto___37461 = temp__4126__auto___37460;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"render-input","render-input",243083212,null),cljs.core.pr_str.call(null,error__13963__auto___37461)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37442_37452,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37461], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37451,output_schema37442_37452,input_schema37443_37453,input_checker37444_37454,output_checker37445_37455))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.render_input),schema.core.make_fn_schema.call(null,output_schema37442_37452,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37443_37453], null)));
var ufv___37470 = schema.utils.use_fn_validation;var output_schema37462_37471 = om_bootstrap.types.Component;var input_schema37463_37472 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Input,new cljs.core.Symbol(null,"opts","opts",1795607228,null)),schema.core.Any], null);var input_checker37464_37473 = schema.core.checker.call(null,input_schema37463_37472);var output_checker37465_37474 = schema.core.checker.call(null,output_schema37462_37471);/**
* Inputs: [opts :- Input & children]
* Returns: t/Component
* 
* Returns an input component. This currently does NOT handle any of
* the default values or validation messages that we'll need to make
* this work, though.
* @param {...*} var_args
*/
om_bootstrap.input.input = ((function (ufv___37470,output_schema37462_37471,input_schema37463_37472,input_checker37464_37473,output_checker37465_37474){
return (function() { 
var input__delegate = function (G__37466,rest37467){var validate__13961__auto__ = ufv___37470.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37475 = cljs.core.list_STAR_.call(null,G__37466,rest37467);var temp__4126__auto___37476 = input_checker37464_37473.call(null,args__13962__auto___37475);if(cljs.core.truth_(temp__4126__auto___37476))
{var error__13963__auto___37477 = temp__4126__auto___37476;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"input","input",-2097503808,null),cljs.core.pr_str.call(null,error__13963__auto___37477)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37463_37472,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37475,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37477], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var opts = G__37466;var children = rest37467;while(true){
var vec__37469 = om_bootstrap.types.separate.call(null,om_bootstrap.input.Input,opts);var input__$1 = cljs.core.nth.call(null,vec__37469,(0),null);var attrs = cljs.core.nth.call(null,vec__37469,(1),null);if(om_bootstrap.input.checkbox_or_radio_QMARK_.call(null,input__$1))
{return om_bootstrap.input.render_form_group.call(null,input__$1,om_bootstrap.input.render_wrapper.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.checkbox_or_radio_wrapper.call(null,input__$1,om_bootstrap.input.render_label.call(null,input__$1,om_bootstrap.input.render_input.call(null,input__$1,attrs,children))),om_bootstrap.input.render_help.call(null,new cljs.core.Keyword(null,"help","help",-439233446).cljs$core$IFn$_invoke$arity$1(input__$1))], null)));
} else
{return om_bootstrap.input.render_form_group.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.render_label.call(null,input__$1),om_bootstrap.input.render_wrapper.call(null,input__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.input.render_input_group.call(null,cljs.core.select_keys.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"addon-before","addon-before",-500360384),new cljs.core.Keyword(null,"addon-after","addon-after",634985306)], null)),om_bootstrap.input.render_input.call(null,input__$1,attrs,children)),om_bootstrap.input.render_icon.call(null,cljs.core.select_keys.call(null,input__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"feedback?","feedback?",-1945951821),new cljs.core.Keyword(null,"bs-style","bs-style",1424423998)], null))),om_bootstrap.input.render_help.call(null,new cljs.core.Keyword(null,"help","help",-439233446).cljs$core$IFn$_invoke$arity$1(input__$1))], null))], null));
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37478 = output_checker37465_37474.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37478))
{var error__13963__auto___37479 = temp__4126__auto___37478;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"input","input",-2097503808,null),cljs.core.pr_str.call(null,error__13963__auto___37479)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37462_37471,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37479], null));
} else
{}
} else
{}
return o__13964__auto__;
};
var input = function (G__37466,var_args){
var rest37467 = null;if (arguments.length > 1) {
  rest37467 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return input__delegate.call(this,G__37466,rest37467);};
input.cljs$lang$maxFixedArity = 1;
input.cljs$lang$applyTo = (function (arglist__37480){
var G__37466 = cljs.core.first(arglist__37480);
var rest37467 = cljs.core.rest(arglist__37480);
return input__delegate(G__37466,rest37467);
});
input.cljs$core$IFn$_invoke$arity$variadic = input__delegate;
return input;
})()
;})(ufv___37470,output_schema37462_37471,input_schema37463_37472,input_checker37464_37473,output_checker37465_37474))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.input),schema.core.make_fn_schema.call(null,output_schema37462_37471,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37463_37472], null)));
var ufv___37490 = schema.utils.use_fn_validation;var output_schema37481_37491 = om_bootstrap.types.Component;var input_schema37482_37492 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,om_bootstrap.input.Radio,new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_checker37483_37493 = schema.core.checker.call(null,input_schema37482_37492);var output_checker37484_37494 = schema.core.checker.call(null,output_schema37481_37491);/**
* Inputs: [opts :- Radio]
* Returns: t/Component
* 
* Generates a radio button entry, to place into a radio button
* grouping.
*/
om_bootstrap.input.radio_option = ((function (ufv___37490,output_schema37481_37491,input_schema37482_37492,input_checker37483_37493,output_checker37484_37494){
return (function radio_option(G__37485){var validate__13961__auto__ = ufv___37490.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37495 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37485], null);var temp__4126__auto___37496 = input_checker37483_37493.call(null,args__13962__auto___37495);if(cljs.core.truth_(temp__4126__auto___37496))
{var error__13963__auto___37497 = temp__4126__auto___37496;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"radio-option","radio-option",726779012,null),cljs.core.pr_str.call(null,error__13963__auto___37497)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37482_37492,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37495,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37497], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var opts = G__37485;while(true){
var vec__37488 = om_bootstrap.types.separate.call(null,om_bootstrap.input.Radio,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ref","ref",1289896967),"input",new cljs.core.Keyword(null,"key","key",-1516042587),"input",new cljs.core.Keyword(null,"type","type",1174270348),"radio"], null));var bs = cljs.core.nth.call(null,vec__37488,(0),null);var props = cljs.core.nth.call(null,vec__37488,(1),null);var map__37489 = bs;var map__37489__$1 = ((cljs.core.seq_QMARK_.call(null,map__37489))?cljs.core.apply.call(null,cljs.core.hash_map,map__37489):map__37489);var inline_QMARK_ = cljs.core.get.call(null,map__37489__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));var checked_QMARK_ = cljs.core.get.call(null,map__37489__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));var label = cljs.core.get.call(null,map__37489__$1,new cljs.core.Keyword(null,"label","label",1718410804));var core = om_tools.dom.element.call(null,om.dom.input,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_),cljs.core.PersistentVector.EMPTY);if(cljs.core.truth_(inline_QMARK_))
{return cljs.core.apply.call(null,React.DOM.label,{"className": "radio-inline"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[core,label],null))));
} else
{return cljs.core.apply.call(null,React.DOM.div,{"className": "radio"},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.call(null,React.DOM.label,{},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[core,label],null))))],null))));
}
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37498 = output_checker37484_37494.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37498))
{var error__13963__auto___37499 = temp__4126__auto___37498;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"radio-option","radio-option",726779012,null),cljs.core.pr_str.call(null,error__13963__auto___37499)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37481_37491,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37499], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37490,output_schema37481_37491,input_schema37482_37492,input_checker37483_37493,output_checker37484_37494))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.radio_option),schema.core.make_fn_schema.call(null,output_schema37481_37491,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37482_37492], null)));
var ufv___37522 = schema.utils.use_fn_validation;var output_schema37500_37523 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_bootstrap.types.Component], null);var input_schema37501_37524 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Str,new cljs.core.Symbol(null,"header","header",1759972661,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.pair.call(null,schema.core.Str,"option value",schema.core.Str,"option label")], null),new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null);var input_checker37502_37525 = schema.core.checker.call(null,input_schema37501_37524);var output_checker37503_37526 = schema.core.checker.call(null,output_schema37500_37523);/**
* Inputs: [header :- s/Str opts :- [(s/pair s/Str "option value" s/Str "option label")]]
* Returns: [t/Component]
* 
* Returns a sequence of options for use as the children of a select
* input.
*/
om_bootstrap.input.options = ((function (ufv___37522,output_schema37500_37523,input_schema37501_37524,input_checker37502_37525,output_checker37503_37526){
return (function options(G__37504,G__37505){var validate__13961__auto__ = ufv___37522.get_cell();if(cljs.core.truth_(validate__13961__auto__))
{var args__13962__auto___37527 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__37504,G__37505], null);var temp__4126__auto___37528 = input_checker37502_37525.call(null,args__13962__auto___37527);if(cljs.core.truth_(temp__4126__auto___37528))
{var error__13963__auto___37529 = temp__4126__auto___37528;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",new cljs.core.Symbol(null,"options","options",1740170016,null),cljs.core.pr_str.call(null,error__13963__auto___37529)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema37501_37524,new cljs.core.Keyword(null,"value","value",305978217),args__13962__auto___37527,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37529], null));
} else
{}
} else
{}
var o__13964__auto__ = (function (){var header = G__37504;var opts = G__37505;while(true){
return cljs.core.cons.call(null,cljs.core.apply.call(null,om.dom.option,{"value": ""},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[header],null)))),(function (){var iter__4266__auto__ = ((function (validate__13961__auto__,ufv___37522,output_schema37500_37523,input_schema37501_37524,input_checker37502_37525,output_checker37503_37526){
return (function iter__37514(s__37515){return (new cljs.core.LazySeq(null,((function (validate__13961__auto__,ufv___37522,output_schema37500_37523,input_schema37501_37524,input_checker37502_37525,output_checker37503_37526){
return (function (){var s__37515__$1 = s__37515;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__37515__$1);if(temp__4126__auto__)
{var s__37515__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__37515__$2))
{var c__4264__auto__ = cljs.core.chunk_first.call(null,s__37515__$2);var size__4265__auto__ = cljs.core.count.call(null,c__4264__auto__);var b__37517 = cljs.core.chunk_buffer.call(null,size__4265__auto__);if((function (){var i__37516 = (0);while(true){
if((i__37516 < size__4265__auto__))
{var vec__37520 = cljs.core._nth.call(null,c__4264__auto__,i__37516);var v = cljs.core.nth.call(null,vec__37520,(0),null);var label = cljs.core.nth.call(null,vec__37520,(1),null);cljs.core.chunk_append.call(null,b__37517,cljs.core.apply.call(null,om.dom.option,{"value": om_tools.dom.format_opts.call(null,v)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[label],null)))));
{
var G__37530 = (i__37516 + (1));
i__37516 = G__37530;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37517),iter__37514.call(null,cljs.core.chunk_rest.call(null,s__37515__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37517),null);
}
} else
{var vec__37521 = cljs.core.first.call(null,s__37515__$2);var v = cljs.core.nth.call(null,vec__37521,(0),null);var label = cljs.core.nth.call(null,vec__37521,(1),null);return cljs.core.cons.call(null,cljs.core.apply.call(null,om.dom.option,{"value": om_tools.dom.format_opts.call(null,v)},cljs.core.flatten.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[label],null)))),iter__37514.call(null,cljs.core.rest.call(null,s__37515__$2)));
}
} else
{return null;
}
break;
}
});})(validate__13961__auto__,ufv___37522,output_schema37500_37523,input_schema37501_37524,input_checker37502_37525,output_checker37503_37526))
,null,null));
});})(validate__13961__auto__,ufv___37522,output_schema37500_37523,input_schema37501_37524,input_checker37502_37525,output_checker37503_37526))
;return iter__4266__auto__.call(null,opts);
})());
break;
}
})();if(cljs.core.truth_(validate__13961__auto__))
{var temp__4126__auto___37531 = output_checker37503_37526.call(null,o__13964__auto__);if(cljs.core.truth_(temp__4126__auto___37531))
{var error__13963__auto___37532 = temp__4126__auto___37531;throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",new cljs.core.Symbol(null,"options","options",1740170016,null),cljs.core.pr_str.call(null,error__13963__auto___37532)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema37500_37523,new cljs.core.Keyword(null,"value","value",305978217),o__13964__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__13963__auto___37532], null));
} else
{}
} else
{}
return o__13964__auto__;
});})(ufv___37522,output_schema37500_37523,input_schema37501_37524,input_checker37502_37525,output_checker37503_37526))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,om_bootstrap.input.options),schema.core.make_fn_schema.call(null,output_schema37500_37523,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema37501_37524], null)));

//# sourceMappingURL=input.js.map