// Compiled by ClojureScript 0.0-2277
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t31598 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31598 = (function (f,fn_handler,meta31599){
this.f = f;
this.fn_handler = fn_handler;
this.meta31599 = meta31599;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31598.cljs$lang$type = true;
cljs.core.async.t31598.cljs$lang$ctorStr = "cljs.core.async/t31598";
cljs.core.async.t31598.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31598");
});
cljs.core.async.t31598.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31598.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t31598.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t31598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31600){var self__ = this;
var _31600__$1 = this;return self__.meta31599;
});
cljs.core.async.t31598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31600,meta31599__$1){var self__ = this;
var _31600__$1 = this;return (new cljs.core.async.t31598(self__.f,self__.fn_handler,meta31599__$1));
});
cljs.core.async.__GT_t31598 = (function __GT_t31598(f__$1,fn_handler__$1,meta31599){return (new cljs.core.async.t31598(f__$1,fn_handler__$1,meta31599));
});
}
return (new cljs.core.async.t31598(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__31602 = buff;if(G__31602)
{var bit__4191__auto__ = null;if(cljs.core.truth_((function (){var or__3541__auto__ = bit__4191__auto__;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return G__31602.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__31602.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__31602);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__31602);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error(("Assert failed: <! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_31603 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_31603);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_31603,ret){
return (function (){return fn1.call(null,val_31603);
});})(val_31603,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error(("Assert failed: >! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__4397__auto___31604 = n;var x_31605 = (0);while(true){
if((x_31605 < n__4397__auto___31604))
{(a[x_31605] = (0));
{
var G__31606 = (x_31605 + (1));
x_31605 = G__31606;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__31607 = (i + (1));
i = G__31607;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t31611 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31611 = (function (flag,alt_flag,meta31612){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta31612 = meta31612;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31611.cljs$lang$type = true;
cljs.core.async.t31611.cljs$lang$ctorStr = "cljs.core.async/t31611";
cljs.core.async.t31611.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31611");
});})(flag))
;
cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t31611.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31613){var self__ = this;
var _31613__$1 = this;return self__.meta31612;
});})(flag))
;
cljs.core.async.t31611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31613,meta31612__$1){var self__ = this;
var _31613__$1 = this;return (new cljs.core.async.t31611(self__.flag,self__.alt_flag,meta31612__$1));
});})(flag))
;
cljs.core.async.__GT_t31611 = ((function (flag){
return (function __GT_t31611(flag__$1,alt_flag__$1,meta31612){return (new cljs.core.async.t31611(flag__$1,alt_flag__$1,meta31612));
});})(flag))
;
}
return (new cljs.core.async.t31611(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t31617 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31617 = (function (cb,flag,alt_handler,meta31618){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta31618 = meta31618;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31617.cljs$lang$type = true;
cljs.core.async.t31617.cljs$lang$ctorStr = "cljs.core.async/t31617";
cljs.core.async.t31617.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31617");
});
cljs.core.async.t31617.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31617.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t31617.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t31617.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31619){var self__ = this;
var _31619__$1 = this;return self__.meta31618;
});
cljs.core.async.t31617.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31619,meta31618__$1){var self__ = this;
var _31619__$1 = this;return (new cljs.core.async.t31617(self__.cb,self__.flag,self__.alt_handler,meta31618__$1));
});
cljs.core.async.__GT_t31617 = (function __GT_t31617(cb__$1,flag__$1,alt_handler__$1,meta31618){return (new cljs.core.async.t31617(cb__$1,flag__$1,alt_handler__$1,meta31618));
});
}
return (new cljs.core.async.t31617(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31620_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31620_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31621_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31621_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3541__auto__ = wport;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__31622 = (i + (1));
i = G__31622;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__3541__auto__ = ret;if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__3529__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__3529__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__3529__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__31623){var map__31625 = p__31623;var map__31625__$1 = ((cljs.core.seq_QMARK_.call(null,map__31625))?cljs.core.apply.call(null,cljs.core.hash_map,map__31625):map__31625);var opts = map__31625__$1;if(null)
{return null;
} else
{throw (new Error(("Assert failed: alts! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
};
var alts_BANG_ = function (ports,var_args){
var p__31623 = null;if (arguments.length > 1) {
  p__31623 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__31623);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__31626){
var ports = cljs.core.first(arglist__31626);
var p__31623 = cljs.core.rest(arglist__31626);
return alts_BANG___delegate(ports,p__31623);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t31634 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31634 = (function (ch,f,map_LT_,meta31635){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta31635 = meta31635;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31634.cljs$lang$type = true;
cljs.core.async.t31634.cljs$lang$ctorStr = "cljs.core.async/t31634";
cljs.core.async.t31634.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31634");
});
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t31637 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31637 = (function (fn1,_,meta31635,ch,f,map_LT_,meta31638){
this.fn1 = fn1;
this._ = _;
this.meta31635 = meta31635;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta31638 = meta31638;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31637.cljs$lang$type = true;
cljs.core.async.t31637.cljs$lang$ctorStr = "cljs.core.async/t31637";
cljs.core.async.t31637.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31637");
});})(___$1))
;
cljs.core.async.t31637.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t31637.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t31637.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t31637.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__31627_SHARP_){return f1.call(null,(((p1__31627_SHARP_ == null))?null:self__.f.call(null,p1__31627_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t31637.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31639){var self__ = this;
var _31639__$1 = this;return self__.meta31638;
});})(___$1))
;
cljs.core.async.t31637.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31639,meta31638__$1){var self__ = this;
var _31639__$1 = this;return (new cljs.core.async.t31637(self__.fn1,self__._,self__.meta31635,self__.ch,self__.f,self__.map_LT_,meta31638__$1));
});})(___$1))
;
cljs.core.async.__GT_t31637 = ((function (___$1){
return (function __GT_t31637(fn1__$1,___$2,meta31635__$1,ch__$2,f__$2,map_LT___$2,meta31638){return (new cljs.core.async.t31637(fn1__$1,___$2,meta31635__$1,ch__$2,f__$2,map_LT___$2,meta31638));
});})(___$1))
;
}
return (new cljs.core.async.t31637(fn1,___$1,self__.meta31635,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__3529__auto__ = ret;if(cljs.core.truth_(and__3529__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__3529__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31634.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t31634.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31636){var self__ = this;
var _31636__$1 = this;return self__.meta31635;
});
cljs.core.async.t31634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31636,meta31635__$1){var self__ = this;
var _31636__$1 = this;return (new cljs.core.async.t31634(self__.ch,self__.f,self__.map_LT_,meta31635__$1));
});
cljs.core.async.__GT_t31634 = (function __GT_t31634(ch__$1,f__$1,map_LT___$1,meta31635){return (new cljs.core.async.t31634(ch__$1,f__$1,map_LT___$1,meta31635));
});
}
return (new cljs.core.async.t31634(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t31643 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31643 = (function (ch,f,map_GT_,meta31644){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta31644 = meta31644;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31643.cljs$lang$type = true;
cljs.core.async.t31643.cljs$lang$ctorStr = "cljs.core.async/t31643";
cljs.core.async.t31643.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31643");
});
cljs.core.async.t31643.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31643.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t31643.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31643.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t31643.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31643.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31643.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31645){var self__ = this;
var _31645__$1 = this;return self__.meta31644;
});
cljs.core.async.t31643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31645,meta31644__$1){var self__ = this;
var _31645__$1 = this;return (new cljs.core.async.t31643(self__.ch,self__.f,self__.map_GT_,meta31644__$1));
});
cljs.core.async.__GT_t31643 = (function __GT_t31643(ch__$1,f__$1,map_GT___$1,meta31644){return (new cljs.core.async.t31643(ch__$1,f__$1,map_GT___$1,meta31644));
});
}
return (new cljs.core.async.t31643(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t31649 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t31649 = (function (ch,p,filter_GT_,meta31650){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta31650 = meta31650;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31649.cljs$lang$type = true;
cljs.core.async.t31649.cljs$lang$ctorStr = "cljs.core.async/t31649";
cljs.core.async.t31649.cljs$lang$ctorPrWriter = (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t31649");
});
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t31649.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t31649.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31651){var self__ = this;
var _31651__$1 = this;return self__.meta31650;
});
cljs.core.async.t31649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31651,meta31650__$1){var self__ = this;
var _31651__$1 = this;return (new cljs.core.async.t31649(self__.ch,self__.p,self__.filter_GT_,meta31650__$1));
});
cljs.core.async.__GT_t31649 = (function __GT_t31649(ch__$1,p__$1,filter_GT___$1,meta31650){return (new cljs.core.async.t31649(ch__$1,p__$1,filter_GT___$1,meta31650));
});
}
return (new cljs.core.async.t31649(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___31734 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___31734,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___31734,out){
return (function (state_31713){var state_val_31714 = (state_31713[(1)]);if((state_val_31714 === (7)))
{var inst_31709 = (state_31713[(2)]);var state_31713__$1 = state_31713;var statearr_31715_31735 = state_31713__$1;(statearr_31715_31735[(2)] = inst_31709);
(statearr_31715_31735[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (1)))
{var state_31713__$1 = state_31713;var statearr_31716_31736 = state_31713__$1;(statearr_31716_31736[(2)] = null);
(statearr_31716_31736[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (4)))
{var inst_31695 = (state_31713[(7)]);var inst_31695__$1 = (state_31713[(2)]);var inst_31696 = (inst_31695__$1 == null);var state_31713__$1 = (function (){var statearr_31717 = state_31713;(statearr_31717[(7)] = inst_31695__$1);
return statearr_31717;
})();if(cljs.core.truth_(inst_31696))
{var statearr_31718_31737 = state_31713__$1;(statearr_31718_31737[(1)] = (5));
} else
{var statearr_31719_31738 = state_31713__$1;(statearr_31719_31738[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (6)))
{var inst_31695 = (state_31713[(7)]);var inst_31700 = p.call(null,inst_31695);var state_31713__$1 = state_31713;if(cljs.core.truth_(inst_31700))
{var statearr_31720_31739 = state_31713__$1;(statearr_31720_31739[(1)] = (8));
} else
{var statearr_31721_31740 = state_31713__$1;(statearr_31721_31740[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (3)))
{var inst_31711 = (state_31713[(2)]);var state_31713__$1 = state_31713;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31713__$1,inst_31711);
} else
{if((state_val_31714 === (2)))
{var state_31713__$1 = state_31713;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31713__$1,(4),ch);
} else
{if((state_val_31714 === (11)))
{var inst_31703 = (state_31713[(2)]);var state_31713__$1 = state_31713;var statearr_31722_31741 = state_31713__$1;(statearr_31722_31741[(2)] = inst_31703);
(statearr_31722_31741[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (9)))
{var state_31713__$1 = state_31713;var statearr_31723_31742 = state_31713__$1;(statearr_31723_31742[(2)] = null);
(statearr_31723_31742[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (5)))
{var inst_31698 = cljs.core.async.close_BANG_.call(null,out);var state_31713__$1 = state_31713;var statearr_31724_31743 = state_31713__$1;(statearr_31724_31743[(2)] = inst_31698);
(statearr_31724_31743[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (10)))
{var inst_31706 = (state_31713[(2)]);var state_31713__$1 = (function (){var statearr_31725 = state_31713;(statearr_31725[(8)] = inst_31706);
return statearr_31725;
})();var statearr_31726_31744 = state_31713__$1;(statearr_31726_31744[(2)] = null);
(statearr_31726_31744[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31714 === (8)))
{var inst_31695 = (state_31713[(7)]);var state_31713__$1 = state_31713;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31713__$1,(11),out,inst_31695);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___31734,out))
;return ((function (switch__7350__auto__,c__7365__auto___31734,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_31730 = [null,null,null,null,null,null,null,null,null];(statearr_31730[(0)] = state_machine__7351__auto__);
(statearr_31730[(1)] = (1));
return statearr_31730;
});
var state_machine__7351__auto____1 = (function (state_31713){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_31713);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e31731){if((e31731 instanceof Object))
{var ex__7354__auto__ = e31731;var statearr_31732_31745 = state_31713;(statearr_31732_31745[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31713);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e31731;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__31746 = state_31713;
state_31713 = G__31746;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_31713){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_31713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___31734,out))
})();var state__7367__auto__ = (function (){var statearr_31733 = f__7366__auto__.call(null);(statearr_31733[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___31734);
return statearr_31733;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___31734,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_31912){var state_val_31913 = (state_31912[(1)]);if((state_val_31913 === (7)))
{var inst_31908 = (state_31912[(2)]);var state_31912__$1 = state_31912;var statearr_31914_31955 = state_31912__$1;(statearr_31914_31955[(2)] = inst_31908);
(statearr_31914_31955[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (20)))
{var inst_31878 = (state_31912[(7)]);var inst_31889 = (state_31912[(2)]);var inst_31890 = cljs.core.next.call(null,inst_31878);var inst_31864 = inst_31890;var inst_31865 = null;var inst_31866 = (0);var inst_31867 = (0);var state_31912__$1 = (function (){var statearr_31915 = state_31912;(statearr_31915[(8)] = inst_31889);
(statearr_31915[(9)] = inst_31864);
(statearr_31915[(10)] = inst_31866);
(statearr_31915[(11)] = inst_31867);
(statearr_31915[(12)] = inst_31865);
return statearr_31915;
})();var statearr_31916_31956 = state_31912__$1;(statearr_31916_31956[(2)] = null);
(statearr_31916_31956[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (1)))
{var state_31912__$1 = state_31912;var statearr_31917_31957 = state_31912__$1;(statearr_31917_31957[(2)] = null);
(statearr_31917_31957[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (4)))
{var inst_31853 = (state_31912[(13)]);var inst_31853__$1 = (state_31912[(2)]);var inst_31854 = (inst_31853__$1 == null);var state_31912__$1 = (function (){var statearr_31918 = state_31912;(statearr_31918[(13)] = inst_31853__$1);
return statearr_31918;
})();if(cljs.core.truth_(inst_31854))
{var statearr_31919_31958 = state_31912__$1;(statearr_31919_31958[(1)] = (5));
} else
{var statearr_31920_31959 = state_31912__$1;(statearr_31920_31959[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (15)))
{var state_31912__$1 = state_31912;var statearr_31924_31960 = state_31912__$1;(statearr_31924_31960[(2)] = null);
(statearr_31924_31960[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (21)))
{var state_31912__$1 = state_31912;var statearr_31925_31961 = state_31912__$1;(statearr_31925_31961[(2)] = null);
(statearr_31925_31961[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (13)))
{var inst_31864 = (state_31912[(9)]);var inst_31866 = (state_31912[(10)]);var inst_31867 = (state_31912[(11)]);var inst_31865 = (state_31912[(12)]);var inst_31874 = (state_31912[(2)]);var inst_31875 = (inst_31867 + (1));var tmp31921 = inst_31864;var tmp31922 = inst_31866;var tmp31923 = inst_31865;var inst_31864__$1 = tmp31921;var inst_31865__$1 = tmp31923;var inst_31866__$1 = tmp31922;var inst_31867__$1 = inst_31875;var state_31912__$1 = (function (){var statearr_31926 = state_31912;(statearr_31926[(9)] = inst_31864__$1);
(statearr_31926[(10)] = inst_31866__$1);
(statearr_31926[(11)] = inst_31867__$1);
(statearr_31926[(14)] = inst_31874);
(statearr_31926[(12)] = inst_31865__$1);
return statearr_31926;
})();var statearr_31927_31962 = state_31912__$1;(statearr_31927_31962[(2)] = null);
(statearr_31927_31962[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (22)))
{var state_31912__$1 = state_31912;var statearr_31928_31963 = state_31912__$1;(statearr_31928_31963[(2)] = null);
(statearr_31928_31963[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (6)))
{var inst_31853 = (state_31912[(13)]);var inst_31862 = f.call(null,inst_31853);var inst_31863 = cljs.core.seq.call(null,inst_31862);var inst_31864 = inst_31863;var inst_31865 = null;var inst_31866 = (0);var inst_31867 = (0);var state_31912__$1 = (function (){var statearr_31929 = state_31912;(statearr_31929[(9)] = inst_31864);
(statearr_31929[(10)] = inst_31866);
(statearr_31929[(11)] = inst_31867);
(statearr_31929[(12)] = inst_31865);
return statearr_31929;
})();var statearr_31930_31964 = state_31912__$1;(statearr_31930_31964[(2)] = null);
(statearr_31930_31964[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (17)))
{var inst_31878 = (state_31912[(7)]);var inst_31882 = cljs.core.chunk_first.call(null,inst_31878);var inst_31883 = cljs.core.chunk_rest.call(null,inst_31878);var inst_31884 = cljs.core.count.call(null,inst_31882);var inst_31864 = inst_31883;var inst_31865 = inst_31882;var inst_31866 = inst_31884;var inst_31867 = (0);var state_31912__$1 = (function (){var statearr_31931 = state_31912;(statearr_31931[(9)] = inst_31864);
(statearr_31931[(10)] = inst_31866);
(statearr_31931[(11)] = inst_31867);
(statearr_31931[(12)] = inst_31865);
return statearr_31931;
})();var statearr_31932_31965 = state_31912__$1;(statearr_31932_31965[(2)] = null);
(statearr_31932_31965[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (3)))
{var inst_31910 = (state_31912[(2)]);var state_31912__$1 = state_31912;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31912__$1,inst_31910);
} else
{if((state_val_31913 === (12)))
{var inst_31898 = (state_31912[(2)]);var state_31912__$1 = state_31912;var statearr_31933_31966 = state_31912__$1;(statearr_31933_31966[(2)] = inst_31898);
(statearr_31933_31966[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (2)))
{var state_31912__$1 = state_31912;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31912__$1,(4),in$);
} else
{if((state_val_31913 === (23)))
{var inst_31906 = (state_31912[(2)]);var state_31912__$1 = state_31912;var statearr_31934_31967 = state_31912__$1;(statearr_31934_31967[(2)] = inst_31906);
(statearr_31934_31967[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (19)))
{var inst_31893 = (state_31912[(2)]);var state_31912__$1 = state_31912;var statearr_31935_31968 = state_31912__$1;(statearr_31935_31968[(2)] = inst_31893);
(statearr_31935_31968[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (11)))
{var inst_31864 = (state_31912[(9)]);var inst_31878 = (state_31912[(7)]);var inst_31878__$1 = cljs.core.seq.call(null,inst_31864);var state_31912__$1 = (function (){var statearr_31936 = state_31912;(statearr_31936[(7)] = inst_31878__$1);
return statearr_31936;
})();if(inst_31878__$1)
{var statearr_31937_31969 = state_31912__$1;(statearr_31937_31969[(1)] = (14));
} else
{var statearr_31938_31970 = state_31912__$1;(statearr_31938_31970[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (9)))
{var inst_31900 = (state_31912[(2)]);var inst_31901 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_31912__$1 = (function (){var statearr_31939 = state_31912;(statearr_31939[(15)] = inst_31900);
return statearr_31939;
})();if(cljs.core.truth_(inst_31901))
{var statearr_31940_31971 = state_31912__$1;(statearr_31940_31971[(1)] = (21));
} else
{var statearr_31941_31972 = state_31912__$1;(statearr_31941_31972[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (5)))
{var inst_31856 = cljs.core.async.close_BANG_.call(null,out);var state_31912__$1 = state_31912;var statearr_31942_31973 = state_31912__$1;(statearr_31942_31973[(2)] = inst_31856);
(statearr_31942_31973[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (14)))
{var inst_31878 = (state_31912[(7)]);var inst_31880 = cljs.core.chunked_seq_QMARK_.call(null,inst_31878);var state_31912__$1 = state_31912;if(inst_31880)
{var statearr_31943_31974 = state_31912__$1;(statearr_31943_31974[(1)] = (17));
} else
{var statearr_31944_31975 = state_31912__$1;(statearr_31944_31975[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (16)))
{var inst_31896 = (state_31912[(2)]);var state_31912__$1 = state_31912;var statearr_31945_31976 = state_31912__$1;(statearr_31945_31976[(2)] = inst_31896);
(statearr_31945_31976[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_31913 === (10)))
{var inst_31867 = (state_31912[(11)]);var inst_31865 = (state_31912[(12)]);var inst_31872 = cljs.core._nth.call(null,inst_31865,inst_31867);var state_31912__$1 = state_31912;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31912__$1,(13),out,inst_31872);
} else
{if((state_val_31913 === (18)))
{var inst_31878 = (state_31912[(7)]);var inst_31887 = cljs.core.first.call(null,inst_31878);var state_31912__$1 = state_31912;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31912__$1,(20),out,inst_31887);
} else
{if((state_val_31913 === (8)))
{var inst_31866 = (state_31912[(10)]);var inst_31867 = (state_31912[(11)]);var inst_31869 = (inst_31867 < inst_31866);var inst_31870 = inst_31869;var state_31912__$1 = state_31912;if(cljs.core.truth_(inst_31870))
{var statearr_31946_31977 = state_31912__$1;(statearr_31946_31977[(1)] = (10));
} else
{var statearr_31947_31978 = state_31912__$1;(statearr_31947_31978[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_31951 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_31951[(0)] = state_machine__7351__auto__);
(statearr_31951[(1)] = (1));
return statearr_31951;
});
var state_machine__7351__auto____1 = (function (state_31912){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_31912);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e31952){if((e31952 instanceof Object))
{var ex__7354__auto__ = e31952;var statearr_31953_31979 = state_31912;(statearr_31953_31979[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31912);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e31952;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__31980 = state_31912;
state_31912 = G__31980;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_31912){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_31912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_31954 = f__7366__auto__.call(null);(statearr_31954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_31954;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__7365__auto___32075 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32075){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32075){
return (function (state_32051){var state_val_32052 = (state_32051[(1)]);if((state_val_32052 === (7)))
{var inst_32047 = (state_32051[(2)]);var state_32051__$1 = state_32051;var statearr_32053_32076 = state_32051__$1;(statearr_32053_32076[(2)] = inst_32047);
(statearr_32053_32076[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (1)))
{var state_32051__$1 = state_32051;var statearr_32054_32077 = state_32051__$1;(statearr_32054_32077[(2)] = null);
(statearr_32054_32077[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (4)))
{var inst_32030 = (state_32051[(7)]);var inst_32030__$1 = (state_32051[(2)]);var inst_32031 = (inst_32030__$1 == null);var state_32051__$1 = (function (){var statearr_32055 = state_32051;(statearr_32055[(7)] = inst_32030__$1);
return statearr_32055;
})();if(cljs.core.truth_(inst_32031))
{var statearr_32056_32078 = state_32051__$1;(statearr_32056_32078[(1)] = (5));
} else
{var statearr_32057_32079 = state_32051__$1;(statearr_32057_32079[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (13)))
{var state_32051__$1 = state_32051;var statearr_32058_32080 = state_32051__$1;(statearr_32058_32080[(2)] = null);
(statearr_32058_32080[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (6)))
{var inst_32030 = (state_32051[(7)]);var state_32051__$1 = state_32051;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32051__$1,(11),to,inst_32030);
} else
{if((state_val_32052 === (3)))
{var inst_32049 = (state_32051[(2)]);var state_32051__$1 = state_32051;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32051__$1,inst_32049);
} else
{if((state_val_32052 === (12)))
{var state_32051__$1 = state_32051;var statearr_32059_32081 = state_32051__$1;(statearr_32059_32081[(2)] = null);
(statearr_32059_32081[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (2)))
{var state_32051__$1 = state_32051;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32051__$1,(4),from);
} else
{if((state_val_32052 === (11)))
{var inst_32040 = (state_32051[(2)]);var state_32051__$1 = state_32051;if(cljs.core.truth_(inst_32040))
{var statearr_32060_32082 = state_32051__$1;(statearr_32060_32082[(1)] = (12));
} else
{var statearr_32061_32083 = state_32051__$1;(statearr_32061_32083[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (9)))
{var state_32051__$1 = state_32051;var statearr_32062_32084 = state_32051__$1;(statearr_32062_32084[(2)] = null);
(statearr_32062_32084[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (5)))
{var state_32051__$1 = state_32051;if(cljs.core.truth_(close_QMARK_))
{var statearr_32063_32085 = state_32051__$1;(statearr_32063_32085[(1)] = (8));
} else
{var statearr_32064_32086 = state_32051__$1;(statearr_32064_32086[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (14)))
{var inst_32045 = (state_32051[(2)]);var state_32051__$1 = state_32051;var statearr_32065_32087 = state_32051__$1;(statearr_32065_32087[(2)] = inst_32045);
(statearr_32065_32087[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (10)))
{var inst_32037 = (state_32051[(2)]);var state_32051__$1 = state_32051;var statearr_32066_32088 = state_32051__$1;(statearr_32066_32088[(2)] = inst_32037);
(statearr_32066_32088[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32052 === (8)))
{var inst_32034 = cljs.core.async.close_BANG_.call(null,to);var state_32051__$1 = state_32051;var statearr_32067_32089 = state_32051__$1;(statearr_32067_32089[(2)] = inst_32034);
(statearr_32067_32089[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32075))
;return ((function (switch__7350__auto__,c__7365__auto___32075){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32071 = [null,null,null,null,null,null,null,null];(statearr_32071[(0)] = state_machine__7351__auto__);
(statearr_32071[(1)] = (1));
return statearr_32071;
});
var state_machine__7351__auto____1 = (function (state_32051){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32051);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32072){if((e32072 instanceof Object))
{var ex__7354__auto__ = e32072;var statearr_32073_32090 = state_32051;(statearr_32073_32090[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32051);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32072;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32091 = state_32051;
state_32051 = G__32091;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32051){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32075))
})();var state__7367__auto__ = (function (){var statearr_32074 = f__7366__auto__.call(null);(statearr_32074[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32075);
return statearr_32074;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32075))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__7365__auto___32192 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32192,tc,fc){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32192,tc,fc){
return (function (state_32167){var state_val_32168 = (state_32167[(1)]);if((state_val_32168 === (7)))
{var inst_32163 = (state_32167[(2)]);var state_32167__$1 = state_32167;var statearr_32169_32193 = state_32167__$1;(statearr_32169_32193[(2)] = inst_32163);
(statearr_32169_32193[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (1)))
{var state_32167__$1 = state_32167;var statearr_32170_32194 = state_32167__$1;(statearr_32170_32194[(2)] = null);
(statearr_32170_32194[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (4)))
{var inst_32144 = (state_32167[(7)]);var inst_32144__$1 = (state_32167[(2)]);var inst_32145 = (inst_32144__$1 == null);var state_32167__$1 = (function (){var statearr_32171 = state_32167;(statearr_32171[(7)] = inst_32144__$1);
return statearr_32171;
})();if(cljs.core.truth_(inst_32145))
{var statearr_32172_32195 = state_32167__$1;(statearr_32172_32195[(1)] = (5));
} else
{var statearr_32173_32196 = state_32167__$1;(statearr_32173_32196[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (13)))
{var state_32167__$1 = state_32167;var statearr_32174_32197 = state_32167__$1;(statearr_32174_32197[(2)] = null);
(statearr_32174_32197[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (6)))
{var inst_32144 = (state_32167[(7)]);var inst_32150 = p.call(null,inst_32144);var state_32167__$1 = state_32167;if(cljs.core.truth_(inst_32150))
{var statearr_32175_32198 = state_32167__$1;(statearr_32175_32198[(1)] = (9));
} else
{var statearr_32176_32199 = state_32167__$1;(statearr_32176_32199[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (3)))
{var inst_32165 = (state_32167[(2)]);var state_32167__$1 = state_32167;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32167__$1,inst_32165);
} else
{if((state_val_32168 === (12)))
{var state_32167__$1 = state_32167;var statearr_32177_32200 = state_32167__$1;(statearr_32177_32200[(2)] = null);
(statearr_32177_32200[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (2)))
{var state_32167__$1 = state_32167;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32167__$1,(4),ch);
} else
{if((state_val_32168 === (11)))
{var inst_32144 = (state_32167[(7)]);var inst_32154 = (state_32167[(2)]);var state_32167__$1 = state_32167;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32167__$1,(8),inst_32154,inst_32144);
} else
{if((state_val_32168 === (9)))
{var state_32167__$1 = state_32167;var statearr_32178_32201 = state_32167__$1;(statearr_32178_32201[(2)] = tc);
(statearr_32178_32201[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (5)))
{var inst_32147 = cljs.core.async.close_BANG_.call(null,tc);var inst_32148 = cljs.core.async.close_BANG_.call(null,fc);var state_32167__$1 = (function (){var statearr_32179 = state_32167;(statearr_32179[(8)] = inst_32147);
return statearr_32179;
})();var statearr_32180_32202 = state_32167__$1;(statearr_32180_32202[(2)] = inst_32148);
(statearr_32180_32202[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (14)))
{var inst_32161 = (state_32167[(2)]);var state_32167__$1 = state_32167;var statearr_32181_32203 = state_32167__$1;(statearr_32181_32203[(2)] = inst_32161);
(statearr_32181_32203[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (10)))
{var state_32167__$1 = state_32167;var statearr_32182_32204 = state_32167__$1;(statearr_32182_32204[(2)] = fc);
(statearr_32182_32204[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32168 === (8)))
{var inst_32156 = (state_32167[(2)]);var state_32167__$1 = state_32167;if(cljs.core.truth_(inst_32156))
{var statearr_32183_32205 = state_32167__$1;(statearr_32183_32205[(1)] = (12));
} else
{var statearr_32184_32206 = state_32167__$1;(statearr_32184_32206[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32192,tc,fc))
;return ((function (switch__7350__auto__,c__7365__auto___32192,tc,fc){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32188 = [null,null,null,null,null,null,null,null,null];(statearr_32188[(0)] = state_machine__7351__auto__);
(statearr_32188[(1)] = (1));
return statearr_32188;
});
var state_machine__7351__auto____1 = (function (state_32167){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32167);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32189){if((e32189 instanceof Object))
{var ex__7354__auto__ = e32189;var statearr_32190_32207 = state_32167;(statearr_32190_32207[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32167);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32189;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32208 = state_32167;
state_32167 = G__32208;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32167){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32192,tc,fc))
})();var state__7367__auto__ = (function (){var statearr_32191 = f__7366__auto__.call(null);(statearr_32191[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32192);
return statearr_32191;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32192,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_32255){var state_val_32256 = (state_32255[(1)]);if((state_val_32256 === (7)))
{var inst_32251 = (state_32255[(2)]);var state_32255__$1 = state_32255;var statearr_32257_32273 = state_32255__$1;(statearr_32257_32273[(2)] = inst_32251);
(statearr_32257_32273[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32256 === (6)))
{var inst_32244 = (state_32255[(7)]);var inst_32241 = (state_32255[(8)]);var inst_32248 = f.call(null,inst_32241,inst_32244);var inst_32241__$1 = inst_32248;var state_32255__$1 = (function (){var statearr_32258 = state_32255;(statearr_32258[(8)] = inst_32241__$1);
return statearr_32258;
})();var statearr_32259_32274 = state_32255__$1;(statearr_32259_32274[(2)] = null);
(statearr_32259_32274[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32256 === (5)))
{var inst_32241 = (state_32255[(8)]);var state_32255__$1 = state_32255;var statearr_32260_32275 = state_32255__$1;(statearr_32260_32275[(2)] = inst_32241);
(statearr_32260_32275[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32256 === (4)))
{var inst_32244 = (state_32255[(7)]);var inst_32244__$1 = (state_32255[(2)]);var inst_32245 = (inst_32244__$1 == null);var state_32255__$1 = (function (){var statearr_32261 = state_32255;(statearr_32261[(7)] = inst_32244__$1);
return statearr_32261;
})();if(cljs.core.truth_(inst_32245))
{var statearr_32262_32276 = state_32255__$1;(statearr_32262_32276[(1)] = (5));
} else
{var statearr_32263_32277 = state_32255__$1;(statearr_32263_32277[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32256 === (3)))
{var inst_32253 = (state_32255[(2)]);var state_32255__$1 = state_32255;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32255__$1,inst_32253);
} else
{if((state_val_32256 === (2)))
{var state_32255__$1 = state_32255;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32255__$1,(4),ch);
} else
{if((state_val_32256 === (1)))
{var inst_32241 = init;var state_32255__$1 = (function (){var statearr_32264 = state_32255;(statearr_32264[(8)] = inst_32241);
return statearr_32264;
})();var statearr_32265_32278 = state_32255__$1;(statearr_32265_32278[(2)] = null);
(statearr_32265_32278[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32269 = [null,null,null,null,null,null,null,null,null];(statearr_32269[(0)] = state_machine__7351__auto__);
(statearr_32269[(1)] = (1));
return statearr_32269;
});
var state_machine__7351__auto____1 = (function (state_32255){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32255);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32270){if((e32270 instanceof Object))
{var ex__7354__auto__ = e32270;var statearr_32271_32279 = state_32255;(statearr_32271_32279[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32255);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32270;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32280 = state_32255;
state_32255 = G__32280;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32255){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_32272 = f__7366__auto__.call(null);(statearr_32272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_32272;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__7365__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto__){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto__){
return (function (state_32354){var state_val_32355 = (state_32354[(1)]);if((state_val_32355 === (7)))
{var inst_32336 = (state_32354[(2)]);var state_32354__$1 = state_32354;var statearr_32356_32379 = state_32354__$1;(statearr_32356_32379[(2)] = inst_32336);
(statearr_32356_32379[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (1)))
{var inst_32330 = cljs.core.seq.call(null,coll);var inst_32331 = inst_32330;var state_32354__$1 = (function (){var statearr_32357 = state_32354;(statearr_32357[(7)] = inst_32331);
return statearr_32357;
})();var statearr_32358_32380 = state_32354__$1;(statearr_32358_32380[(2)] = null);
(statearr_32358_32380[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (4)))
{var inst_32331 = (state_32354[(7)]);var inst_32334 = cljs.core.first.call(null,inst_32331);var state_32354__$1 = state_32354;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32354__$1,(7),ch,inst_32334);
} else
{if((state_val_32355 === (13)))
{var inst_32348 = (state_32354[(2)]);var state_32354__$1 = state_32354;var statearr_32359_32381 = state_32354__$1;(statearr_32359_32381[(2)] = inst_32348);
(statearr_32359_32381[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (6)))
{var inst_32339 = (state_32354[(2)]);var state_32354__$1 = state_32354;if(cljs.core.truth_(inst_32339))
{var statearr_32360_32382 = state_32354__$1;(statearr_32360_32382[(1)] = (8));
} else
{var statearr_32361_32383 = state_32354__$1;(statearr_32361_32383[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (3)))
{var inst_32352 = (state_32354[(2)]);var state_32354__$1 = state_32354;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32354__$1,inst_32352);
} else
{if((state_val_32355 === (12)))
{var state_32354__$1 = state_32354;var statearr_32362_32384 = state_32354__$1;(statearr_32362_32384[(2)] = null);
(statearr_32362_32384[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (2)))
{var inst_32331 = (state_32354[(7)]);var state_32354__$1 = state_32354;if(cljs.core.truth_(inst_32331))
{var statearr_32363_32385 = state_32354__$1;(statearr_32363_32385[(1)] = (4));
} else
{var statearr_32364_32386 = state_32354__$1;(statearr_32364_32386[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (11)))
{var inst_32345 = cljs.core.async.close_BANG_.call(null,ch);var state_32354__$1 = state_32354;var statearr_32365_32387 = state_32354__$1;(statearr_32365_32387[(2)] = inst_32345);
(statearr_32365_32387[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (9)))
{var state_32354__$1 = state_32354;if(cljs.core.truth_(close_QMARK_))
{var statearr_32366_32388 = state_32354__$1;(statearr_32366_32388[(1)] = (11));
} else
{var statearr_32367_32389 = state_32354__$1;(statearr_32367_32389[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (5)))
{var inst_32331 = (state_32354[(7)]);var state_32354__$1 = state_32354;var statearr_32368_32390 = state_32354__$1;(statearr_32368_32390[(2)] = inst_32331);
(statearr_32368_32390[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (10)))
{var inst_32350 = (state_32354[(2)]);var state_32354__$1 = state_32354;var statearr_32369_32391 = state_32354__$1;(statearr_32369_32391[(2)] = inst_32350);
(statearr_32369_32391[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32355 === (8)))
{var inst_32331 = (state_32354[(7)]);var inst_32341 = cljs.core.next.call(null,inst_32331);var inst_32331__$1 = inst_32341;var state_32354__$1 = (function (){var statearr_32370 = state_32354;(statearr_32370[(7)] = inst_32331__$1);
return statearr_32370;
})();var statearr_32371_32392 = state_32354__$1;(statearr_32371_32392[(2)] = null);
(statearr_32371_32392[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto__))
;return ((function (switch__7350__auto__,c__7365__auto__){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32375 = [null,null,null,null,null,null,null,null];(statearr_32375[(0)] = state_machine__7351__auto__);
(statearr_32375[(1)] = (1));
return statearr_32375;
});
var state_machine__7351__auto____1 = (function (state_32354){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32354);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32376){if((e32376 instanceof Object))
{var ex__7354__auto__ = e32376;var statearr_32377_32393 = state_32354;(statearr_32377_32393[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32354);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32376;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32394 = state_32354;
state_32354 = G__32394;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32354){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto__))
})();var state__7367__auto__ = (function (){var statearr_32378 = f__7366__auto__.call(null);(statearr_32378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto__);
return statearr_32378;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto__))
);
return c__7365__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj32396 = {};return obj32396;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__3529__auto__ = _;if(and__3529__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__4168__auto__ = (((_ == null))?null:_);return (function (){var or__3541__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj32398 = {};return obj32398;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t32620 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t32620 = (function (cs,ch,mult,meta32621){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta32621 = meta32621;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32620.cljs$lang$type = true;
cljs.core.async.t32620.cljs$lang$ctorStr = "cljs.core.async/t32620";
cljs.core.async.t32620.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t32620");
});})(cs))
;
cljs.core.async.t32620.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t32620.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t32620.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t32620.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t32620.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t32620.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t32620.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32622){var self__ = this;
var _32622__$1 = this;return self__.meta32621;
});})(cs))
;
cljs.core.async.t32620.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32622,meta32621__$1){var self__ = this;
var _32622__$1 = this;return (new cljs.core.async.t32620(self__.cs,self__.ch,self__.mult,meta32621__$1));
});})(cs))
;
cljs.core.async.__GT_t32620 = ((function (cs){
return (function __GT_t32620(cs__$1,ch__$1,mult__$1,meta32621){return (new cljs.core.async.t32620(cs__$1,ch__$1,mult__$1,meta32621));
});})(cs))
;
}
return (new cljs.core.async.t32620(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__7365__auto___32841 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___32841,cs,m,dchan,dctr,done){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___32841,cs,m,dchan,dctr,done){
return (function (state_32753){var state_val_32754 = (state_32753[(1)]);if((state_val_32754 === (7)))
{var inst_32749 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32755_32842 = state_32753__$1;(statearr_32755_32842[(2)] = inst_32749);
(statearr_32755_32842[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (20)))
{var inst_32654 = (state_32753[(7)]);var inst_32664 = cljs.core.first.call(null,inst_32654);var inst_32665 = cljs.core.nth.call(null,inst_32664,(0),null);var inst_32666 = cljs.core.nth.call(null,inst_32664,(1),null);var state_32753__$1 = (function (){var statearr_32756 = state_32753;(statearr_32756[(8)] = inst_32665);
return statearr_32756;
})();if(cljs.core.truth_(inst_32666))
{var statearr_32757_32843 = state_32753__$1;(statearr_32757_32843[(1)] = (22));
} else
{var statearr_32758_32844 = state_32753__$1;(statearr_32758_32844[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (27)))
{var inst_32701 = (state_32753[(9)]);var inst_32694 = (state_32753[(10)]);var inst_32625 = (state_32753[(11)]);var inst_32696 = (state_32753[(12)]);var inst_32701__$1 = cljs.core._nth.call(null,inst_32694,inst_32696);var inst_32702 = cljs.core.async.put_BANG_.call(null,inst_32701__$1,inst_32625,done);var state_32753__$1 = (function (){var statearr_32759 = state_32753;(statearr_32759[(9)] = inst_32701__$1);
return statearr_32759;
})();if(cljs.core.truth_(inst_32702))
{var statearr_32760_32845 = state_32753__$1;(statearr_32760_32845[(1)] = (30));
} else
{var statearr_32761_32846 = state_32753__$1;(statearr_32761_32846[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (1)))
{var state_32753__$1 = state_32753;var statearr_32762_32847 = state_32753__$1;(statearr_32762_32847[(2)] = null);
(statearr_32762_32847[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (24)))
{var inst_32654 = (state_32753[(7)]);var inst_32671 = (state_32753[(2)]);var inst_32672 = cljs.core.next.call(null,inst_32654);var inst_32634 = inst_32672;var inst_32635 = null;var inst_32636 = (0);var inst_32637 = (0);var state_32753__$1 = (function (){var statearr_32763 = state_32753;(statearr_32763[(13)] = inst_32671);
(statearr_32763[(14)] = inst_32635);
(statearr_32763[(15)] = inst_32634);
(statearr_32763[(16)] = inst_32636);
(statearr_32763[(17)] = inst_32637);
return statearr_32763;
})();var statearr_32764_32848 = state_32753__$1;(statearr_32764_32848[(2)] = null);
(statearr_32764_32848[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (39)))
{var state_32753__$1 = state_32753;var statearr_32768_32849 = state_32753__$1;(statearr_32768_32849[(2)] = null);
(statearr_32768_32849[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (4)))
{var inst_32625 = (state_32753[(11)]);var inst_32625__$1 = (state_32753[(2)]);var inst_32626 = (inst_32625__$1 == null);var state_32753__$1 = (function (){var statearr_32769 = state_32753;(statearr_32769[(11)] = inst_32625__$1);
return statearr_32769;
})();if(cljs.core.truth_(inst_32626))
{var statearr_32770_32850 = state_32753__$1;(statearr_32770_32850[(1)] = (5));
} else
{var statearr_32771_32851 = state_32753__$1;(statearr_32771_32851[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (15)))
{var inst_32635 = (state_32753[(14)]);var inst_32634 = (state_32753[(15)]);var inst_32636 = (state_32753[(16)]);var inst_32637 = (state_32753[(17)]);var inst_32650 = (state_32753[(2)]);var inst_32651 = (inst_32637 + (1));var tmp32765 = inst_32635;var tmp32766 = inst_32634;var tmp32767 = inst_32636;var inst_32634__$1 = tmp32766;var inst_32635__$1 = tmp32765;var inst_32636__$1 = tmp32767;var inst_32637__$1 = inst_32651;var state_32753__$1 = (function (){var statearr_32772 = state_32753;(statearr_32772[(14)] = inst_32635__$1);
(statearr_32772[(15)] = inst_32634__$1);
(statearr_32772[(18)] = inst_32650);
(statearr_32772[(16)] = inst_32636__$1);
(statearr_32772[(17)] = inst_32637__$1);
return statearr_32772;
})();var statearr_32773_32852 = state_32753__$1;(statearr_32773_32852[(2)] = null);
(statearr_32773_32852[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (21)))
{var inst_32675 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32777_32853 = state_32753__$1;(statearr_32777_32853[(2)] = inst_32675);
(statearr_32777_32853[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (31)))
{var inst_32701 = (state_32753[(9)]);var inst_32705 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_32706 = cljs.core.async.untap_STAR_.call(null,m,inst_32701);var state_32753__$1 = (function (){var statearr_32778 = state_32753;(statearr_32778[(19)] = inst_32705);
return statearr_32778;
})();var statearr_32779_32854 = state_32753__$1;(statearr_32779_32854[(2)] = inst_32706);
(statearr_32779_32854[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (32)))
{var inst_32693 = (state_32753[(20)]);var inst_32694 = (state_32753[(10)]);var inst_32695 = (state_32753[(21)]);var inst_32696 = (state_32753[(12)]);var inst_32708 = (state_32753[(2)]);var inst_32709 = (inst_32696 + (1));var tmp32774 = inst_32693;var tmp32775 = inst_32694;var tmp32776 = inst_32695;var inst_32693__$1 = tmp32774;var inst_32694__$1 = tmp32775;var inst_32695__$1 = tmp32776;var inst_32696__$1 = inst_32709;var state_32753__$1 = (function (){var statearr_32780 = state_32753;(statearr_32780[(22)] = inst_32708);
(statearr_32780[(20)] = inst_32693__$1);
(statearr_32780[(10)] = inst_32694__$1);
(statearr_32780[(21)] = inst_32695__$1);
(statearr_32780[(12)] = inst_32696__$1);
return statearr_32780;
})();var statearr_32781_32855 = state_32753__$1;(statearr_32781_32855[(2)] = null);
(statearr_32781_32855[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (40)))
{var inst_32721 = (state_32753[(23)]);var inst_32725 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_32726 = cljs.core.async.untap_STAR_.call(null,m,inst_32721);var state_32753__$1 = (function (){var statearr_32782 = state_32753;(statearr_32782[(24)] = inst_32725);
return statearr_32782;
})();var statearr_32783_32856 = state_32753__$1;(statearr_32783_32856[(2)] = inst_32726);
(statearr_32783_32856[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (33)))
{var inst_32712 = (state_32753[(25)]);var inst_32714 = cljs.core.chunked_seq_QMARK_.call(null,inst_32712);var state_32753__$1 = state_32753;if(inst_32714)
{var statearr_32784_32857 = state_32753__$1;(statearr_32784_32857[(1)] = (36));
} else
{var statearr_32785_32858 = state_32753__$1;(statearr_32785_32858[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (13)))
{var inst_32644 = (state_32753[(26)]);var inst_32647 = cljs.core.async.close_BANG_.call(null,inst_32644);var state_32753__$1 = state_32753;var statearr_32786_32859 = state_32753__$1;(statearr_32786_32859[(2)] = inst_32647);
(statearr_32786_32859[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (22)))
{var inst_32665 = (state_32753[(8)]);var inst_32668 = cljs.core.async.close_BANG_.call(null,inst_32665);var state_32753__$1 = state_32753;var statearr_32787_32860 = state_32753__$1;(statearr_32787_32860[(2)] = inst_32668);
(statearr_32787_32860[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (36)))
{var inst_32712 = (state_32753[(25)]);var inst_32716 = cljs.core.chunk_first.call(null,inst_32712);var inst_32717 = cljs.core.chunk_rest.call(null,inst_32712);var inst_32718 = cljs.core.count.call(null,inst_32716);var inst_32693 = inst_32717;var inst_32694 = inst_32716;var inst_32695 = inst_32718;var inst_32696 = (0);var state_32753__$1 = (function (){var statearr_32788 = state_32753;(statearr_32788[(20)] = inst_32693);
(statearr_32788[(10)] = inst_32694);
(statearr_32788[(21)] = inst_32695);
(statearr_32788[(12)] = inst_32696);
return statearr_32788;
})();var statearr_32789_32861 = state_32753__$1;(statearr_32789_32861[(2)] = null);
(statearr_32789_32861[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (41)))
{var inst_32712 = (state_32753[(25)]);var inst_32728 = (state_32753[(2)]);var inst_32729 = cljs.core.next.call(null,inst_32712);var inst_32693 = inst_32729;var inst_32694 = null;var inst_32695 = (0);var inst_32696 = (0);var state_32753__$1 = (function (){var statearr_32790 = state_32753;(statearr_32790[(20)] = inst_32693);
(statearr_32790[(10)] = inst_32694);
(statearr_32790[(21)] = inst_32695);
(statearr_32790[(27)] = inst_32728);
(statearr_32790[(12)] = inst_32696);
return statearr_32790;
})();var statearr_32791_32862 = state_32753__$1;(statearr_32791_32862[(2)] = null);
(statearr_32791_32862[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (43)))
{var state_32753__$1 = state_32753;var statearr_32792_32863 = state_32753__$1;(statearr_32792_32863[(2)] = null);
(statearr_32792_32863[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (29)))
{var inst_32737 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32793_32864 = state_32753__$1;(statearr_32793_32864[(2)] = inst_32737);
(statearr_32793_32864[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (44)))
{var inst_32746 = (state_32753[(2)]);var state_32753__$1 = (function (){var statearr_32794 = state_32753;(statearr_32794[(28)] = inst_32746);
return statearr_32794;
})();var statearr_32795_32865 = state_32753__$1;(statearr_32795_32865[(2)] = null);
(statearr_32795_32865[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (6)))
{var inst_32685 = (state_32753[(29)]);var inst_32684 = cljs.core.deref.call(null,cs);var inst_32685__$1 = cljs.core.keys.call(null,inst_32684);var inst_32686 = cljs.core.count.call(null,inst_32685__$1);var inst_32687 = cljs.core.reset_BANG_.call(null,dctr,inst_32686);var inst_32692 = cljs.core.seq.call(null,inst_32685__$1);var inst_32693 = inst_32692;var inst_32694 = null;var inst_32695 = (0);var inst_32696 = (0);var state_32753__$1 = (function (){var statearr_32796 = state_32753;(statearr_32796[(20)] = inst_32693);
(statearr_32796[(10)] = inst_32694);
(statearr_32796[(21)] = inst_32695);
(statearr_32796[(12)] = inst_32696);
(statearr_32796[(30)] = inst_32687);
(statearr_32796[(29)] = inst_32685__$1);
return statearr_32796;
})();var statearr_32797_32866 = state_32753__$1;(statearr_32797_32866[(2)] = null);
(statearr_32797_32866[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (28)))
{var inst_32693 = (state_32753[(20)]);var inst_32712 = (state_32753[(25)]);var inst_32712__$1 = cljs.core.seq.call(null,inst_32693);var state_32753__$1 = (function (){var statearr_32798 = state_32753;(statearr_32798[(25)] = inst_32712__$1);
return statearr_32798;
})();if(inst_32712__$1)
{var statearr_32799_32867 = state_32753__$1;(statearr_32799_32867[(1)] = (33));
} else
{var statearr_32800_32868 = state_32753__$1;(statearr_32800_32868[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (25)))
{var inst_32695 = (state_32753[(21)]);var inst_32696 = (state_32753[(12)]);var inst_32698 = (inst_32696 < inst_32695);var inst_32699 = inst_32698;var state_32753__$1 = state_32753;if(cljs.core.truth_(inst_32699))
{var statearr_32801_32869 = state_32753__$1;(statearr_32801_32869[(1)] = (27));
} else
{var statearr_32802_32870 = state_32753__$1;(statearr_32802_32870[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (34)))
{var state_32753__$1 = state_32753;var statearr_32803_32871 = state_32753__$1;(statearr_32803_32871[(2)] = null);
(statearr_32803_32871[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (17)))
{var state_32753__$1 = state_32753;var statearr_32804_32872 = state_32753__$1;(statearr_32804_32872[(2)] = null);
(statearr_32804_32872[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (3)))
{var inst_32751 = (state_32753[(2)]);var state_32753__$1 = state_32753;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32753__$1,inst_32751);
} else
{if((state_val_32754 === (12)))
{var inst_32680 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32805_32873 = state_32753__$1;(statearr_32805_32873[(2)] = inst_32680);
(statearr_32805_32873[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (2)))
{var state_32753__$1 = state_32753;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32753__$1,(4),ch);
} else
{if((state_val_32754 === (23)))
{var state_32753__$1 = state_32753;var statearr_32806_32874 = state_32753__$1;(statearr_32806_32874[(2)] = null);
(statearr_32806_32874[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (35)))
{var inst_32735 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32807_32875 = state_32753__$1;(statearr_32807_32875[(2)] = inst_32735);
(statearr_32807_32875[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (19)))
{var inst_32654 = (state_32753[(7)]);var inst_32658 = cljs.core.chunk_first.call(null,inst_32654);var inst_32659 = cljs.core.chunk_rest.call(null,inst_32654);var inst_32660 = cljs.core.count.call(null,inst_32658);var inst_32634 = inst_32659;var inst_32635 = inst_32658;var inst_32636 = inst_32660;var inst_32637 = (0);var state_32753__$1 = (function (){var statearr_32808 = state_32753;(statearr_32808[(14)] = inst_32635);
(statearr_32808[(15)] = inst_32634);
(statearr_32808[(16)] = inst_32636);
(statearr_32808[(17)] = inst_32637);
return statearr_32808;
})();var statearr_32809_32876 = state_32753__$1;(statearr_32809_32876[(2)] = null);
(statearr_32809_32876[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (11)))
{var inst_32654 = (state_32753[(7)]);var inst_32634 = (state_32753[(15)]);var inst_32654__$1 = cljs.core.seq.call(null,inst_32634);var state_32753__$1 = (function (){var statearr_32810 = state_32753;(statearr_32810[(7)] = inst_32654__$1);
return statearr_32810;
})();if(inst_32654__$1)
{var statearr_32811_32877 = state_32753__$1;(statearr_32811_32877[(1)] = (16));
} else
{var statearr_32812_32878 = state_32753__$1;(statearr_32812_32878[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (9)))
{var inst_32682 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32813_32879 = state_32753__$1;(statearr_32813_32879[(2)] = inst_32682);
(statearr_32813_32879[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (5)))
{var inst_32632 = cljs.core.deref.call(null,cs);var inst_32633 = cljs.core.seq.call(null,inst_32632);var inst_32634 = inst_32633;var inst_32635 = null;var inst_32636 = (0);var inst_32637 = (0);var state_32753__$1 = (function (){var statearr_32814 = state_32753;(statearr_32814[(14)] = inst_32635);
(statearr_32814[(15)] = inst_32634);
(statearr_32814[(16)] = inst_32636);
(statearr_32814[(17)] = inst_32637);
return statearr_32814;
})();var statearr_32815_32880 = state_32753__$1;(statearr_32815_32880[(2)] = null);
(statearr_32815_32880[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (14)))
{var state_32753__$1 = state_32753;var statearr_32816_32881 = state_32753__$1;(statearr_32816_32881[(2)] = null);
(statearr_32816_32881[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (45)))
{var inst_32743 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32817_32882 = state_32753__$1;(statearr_32817_32882[(2)] = inst_32743);
(statearr_32817_32882[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (26)))
{var inst_32685 = (state_32753[(29)]);var inst_32739 = (state_32753[(2)]);var inst_32740 = cljs.core.seq.call(null,inst_32685);var state_32753__$1 = (function (){var statearr_32818 = state_32753;(statearr_32818[(31)] = inst_32739);
return statearr_32818;
})();if(inst_32740)
{var statearr_32819_32883 = state_32753__$1;(statearr_32819_32883[(1)] = (42));
} else
{var statearr_32820_32884 = state_32753__$1;(statearr_32820_32884[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (16)))
{var inst_32654 = (state_32753[(7)]);var inst_32656 = cljs.core.chunked_seq_QMARK_.call(null,inst_32654);var state_32753__$1 = state_32753;if(inst_32656)
{var statearr_32821_32885 = state_32753__$1;(statearr_32821_32885[(1)] = (19));
} else
{var statearr_32822_32886 = state_32753__$1;(statearr_32822_32886[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (38)))
{var inst_32732 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32823_32887 = state_32753__$1;(statearr_32823_32887[(2)] = inst_32732);
(statearr_32823_32887[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (30)))
{var state_32753__$1 = state_32753;var statearr_32824_32888 = state_32753__$1;(statearr_32824_32888[(2)] = null);
(statearr_32824_32888[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (10)))
{var inst_32635 = (state_32753[(14)]);var inst_32637 = (state_32753[(17)]);var inst_32643 = cljs.core._nth.call(null,inst_32635,inst_32637);var inst_32644 = cljs.core.nth.call(null,inst_32643,(0),null);var inst_32645 = cljs.core.nth.call(null,inst_32643,(1),null);var state_32753__$1 = (function (){var statearr_32825 = state_32753;(statearr_32825[(26)] = inst_32644);
return statearr_32825;
})();if(cljs.core.truth_(inst_32645))
{var statearr_32826_32889 = state_32753__$1;(statearr_32826_32889[(1)] = (13));
} else
{var statearr_32827_32890 = state_32753__$1;(statearr_32827_32890[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (18)))
{var inst_32678 = (state_32753[(2)]);var state_32753__$1 = state_32753;var statearr_32828_32891 = state_32753__$1;(statearr_32828_32891[(2)] = inst_32678);
(statearr_32828_32891[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (42)))
{var state_32753__$1 = state_32753;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32753__$1,(45),dchan);
} else
{if((state_val_32754 === (37)))
{var inst_32625 = (state_32753[(11)]);var inst_32721 = (state_32753[(23)]);var inst_32712 = (state_32753[(25)]);var inst_32721__$1 = cljs.core.first.call(null,inst_32712);var inst_32722 = cljs.core.async.put_BANG_.call(null,inst_32721__$1,inst_32625,done);var state_32753__$1 = (function (){var statearr_32829 = state_32753;(statearr_32829[(23)] = inst_32721__$1);
return statearr_32829;
})();if(cljs.core.truth_(inst_32722))
{var statearr_32830_32892 = state_32753__$1;(statearr_32830_32892[(1)] = (39));
} else
{var statearr_32831_32893 = state_32753__$1;(statearr_32831_32893[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_32754 === (8)))
{var inst_32636 = (state_32753[(16)]);var inst_32637 = (state_32753[(17)]);var inst_32639 = (inst_32637 < inst_32636);var inst_32640 = inst_32639;var state_32753__$1 = state_32753;if(cljs.core.truth_(inst_32640))
{var statearr_32832_32894 = state_32753__$1;(statearr_32832_32894[(1)] = (10));
} else
{var statearr_32833_32895 = state_32753__$1;(statearr_32833_32895[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___32841,cs,m,dchan,dctr,done))
;return ((function (switch__7350__auto__,c__7365__auto___32841,cs,m,dchan,dctr,done){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_32837 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_32837[(0)] = state_machine__7351__auto__);
(statearr_32837[(1)] = (1));
return statearr_32837;
});
var state_machine__7351__auto____1 = (function (state_32753){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_32753);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e32838){if((e32838 instanceof Object))
{var ex__7354__auto__ = e32838;var statearr_32839_32896 = state_32753;(statearr_32839_32896[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32753);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e32838;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__32897 = state_32753;
state_32753 = G__32897;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_32753){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_32753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___32841,cs,m,dchan,dctr,done))
})();var state__7367__auto__ = (function (){var statearr_32840 = f__7366__auto__.call(null);(statearr_32840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___32841);
return statearr_32840;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___32841,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj32899 = {};return obj32899;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__3529__auto__ = m;if(and__3529__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__4168__auto__ = (((m == null))?null:m);return (function (){var or__3541__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t33019 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t33019 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta33020){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta33020 = meta33020;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33019.cljs$lang$type = true;
cljs.core.async.t33019.cljs$lang$ctorStr = "cljs.core.async/t33019";
cljs.core.async.t33019.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t33019");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t33019.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t33019.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33021){var self__ = this;
var _33021__$1 = this;return self__.meta33020;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t33019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33021,meta33020__$1){var self__ = this;
var _33021__$1 = this;return (new cljs.core.async.t33019(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta33020__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t33019 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t33019(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta33020){return (new cljs.core.async.t33019(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta33020));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t33019(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__7365__auto___33138 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33091){var state_val_33092 = (state_33091[(1)]);if((state_val_33092 === (7)))
{var inst_33035 = (state_33091[(7)]);var inst_33040 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33035);var state_33091__$1 = state_33091;var statearr_33093_33139 = state_33091__$1;(statearr_33093_33139[(2)] = inst_33040);
(statearr_33093_33139[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (20)))
{var inst_33050 = (state_33091[(8)]);var state_33091__$1 = state_33091;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33091__$1,(23),out,inst_33050);
} else
{if((state_val_33092 === (1)))
{var inst_33025 = (state_33091[(9)]);var inst_33025__$1 = calc_state.call(null);var inst_33026 = cljs.core.seq_QMARK_.call(null,inst_33025__$1);var state_33091__$1 = (function (){var statearr_33094 = state_33091;(statearr_33094[(9)] = inst_33025__$1);
return statearr_33094;
})();if(inst_33026)
{var statearr_33095_33140 = state_33091__$1;(statearr_33095_33140[(1)] = (2));
} else
{var statearr_33096_33141 = state_33091__$1;(statearr_33096_33141[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (24)))
{var inst_33043 = (state_33091[(10)]);var inst_33035 = inst_33043;var state_33091__$1 = (function (){var statearr_33097 = state_33091;(statearr_33097[(7)] = inst_33035);
return statearr_33097;
})();var statearr_33098_33142 = state_33091__$1;(statearr_33098_33142[(2)] = null);
(statearr_33098_33142[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (4)))
{var inst_33025 = (state_33091[(9)]);var inst_33031 = (state_33091[(2)]);var inst_33032 = cljs.core.get.call(null,inst_33031,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_33033 = cljs.core.get.call(null,inst_33031,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_33034 = cljs.core.get.call(null,inst_33031,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_33035 = inst_33025;var state_33091__$1 = (function (){var statearr_33099 = state_33091;(statearr_33099[(11)] = inst_33032);
(statearr_33099[(7)] = inst_33035);
(statearr_33099[(12)] = inst_33033);
(statearr_33099[(13)] = inst_33034);
return statearr_33099;
})();var statearr_33100_33143 = state_33091__$1;(statearr_33100_33143[(2)] = null);
(statearr_33100_33143[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (15)))
{var state_33091__$1 = state_33091;var statearr_33101_33144 = state_33091__$1;(statearr_33101_33144[(2)] = null);
(statearr_33101_33144[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (21)))
{var inst_33043 = (state_33091[(10)]);var inst_33035 = inst_33043;var state_33091__$1 = (function (){var statearr_33102 = state_33091;(statearr_33102[(7)] = inst_33035);
return statearr_33102;
})();var statearr_33103_33145 = state_33091__$1;(statearr_33103_33145[(2)] = null);
(statearr_33103_33145[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (13)))
{var inst_33087 = (state_33091[(2)]);var state_33091__$1 = state_33091;var statearr_33104_33146 = state_33091__$1;(statearr_33104_33146[(2)] = inst_33087);
(statearr_33104_33146[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (22)))
{var inst_33085 = (state_33091[(2)]);var state_33091__$1 = state_33091;var statearr_33105_33147 = state_33091__$1;(statearr_33105_33147[(2)] = inst_33085);
(statearr_33105_33147[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (6)))
{var inst_33089 = (state_33091[(2)]);var state_33091__$1 = state_33091;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33091__$1,inst_33089);
} else
{if((state_val_33092 === (25)))
{var state_33091__$1 = state_33091;var statearr_33106_33148 = state_33091__$1;(statearr_33106_33148[(2)] = null);
(statearr_33106_33148[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (17)))
{var inst_33065 = (state_33091[(14)]);var state_33091__$1 = state_33091;var statearr_33107_33149 = state_33091__$1;(statearr_33107_33149[(2)] = inst_33065);
(statearr_33107_33149[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (3)))
{var inst_33025 = (state_33091[(9)]);var state_33091__$1 = state_33091;var statearr_33108_33150 = state_33091__$1;(statearr_33108_33150[(2)] = inst_33025);
(statearr_33108_33150[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (12)))
{var inst_33065 = (state_33091[(14)]);var inst_33046 = (state_33091[(15)]);var inst_33051 = (state_33091[(16)]);var inst_33065__$1 = inst_33046.call(null,inst_33051);var state_33091__$1 = (function (){var statearr_33109 = state_33091;(statearr_33109[(14)] = inst_33065__$1);
return statearr_33109;
})();if(cljs.core.truth_(inst_33065__$1))
{var statearr_33110_33151 = state_33091__$1;(statearr_33110_33151[(1)] = (17));
} else
{var statearr_33111_33152 = state_33091__$1;(statearr_33111_33152[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (2)))
{var inst_33025 = (state_33091[(9)]);var inst_33028 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33025);var state_33091__$1 = state_33091;var statearr_33112_33153 = state_33091__$1;(statearr_33112_33153[(2)] = inst_33028);
(statearr_33112_33153[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (23)))
{var inst_33076 = (state_33091[(2)]);var state_33091__$1 = state_33091;if(cljs.core.truth_(inst_33076))
{var statearr_33113_33154 = state_33091__$1;(statearr_33113_33154[(1)] = (24));
} else
{var statearr_33114_33155 = state_33091__$1;(statearr_33114_33155[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (19)))
{var inst_33073 = (state_33091[(2)]);var state_33091__$1 = state_33091;if(cljs.core.truth_(inst_33073))
{var statearr_33115_33156 = state_33091__$1;(statearr_33115_33156[(1)] = (20));
} else
{var statearr_33116_33157 = state_33091__$1;(statearr_33116_33157[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (11)))
{var inst_33050 = (state_33091[(8)]);var inst_33056 = (inst_33050 == null);var state_33091__$1 = state_33091;if(cljs.core.truth_(inst_33056))
{var statearr_33117_33158 = state_33091__$1;(statearr_33117_33158[(1)] = (14));
} else
{var statearr_33118_33159 = state_33091__$1;(statearr_33118_33159[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (9)))
{var inst_33043 = (state_33091[(10)]);var inst_33043__$1 = (state_33091[(2)]);var inst_33044 = cljs.core.get.call(null,inst_33043__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_33045 = cljs.core.get.call(null,inst_33043__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_33046 = cljs.core.get.call(null,inst_33043__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_33091__$1 = (function (){var statearr_33119 = state_33091;(statearr_33119[(15)] = inst_33046);
(statearr_33119[(10)] = inst_33043__$1);
(statearr_33119[(17)] = inst_33045);
return statearr_33119;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_33091__$1,(10),inst_33044);
} else
{if((state_val_33092 === (5)))
{var inst_33035 = (state_33091[(7)]);var inst_33038 = cljs.core.seq_QMARK_.call(null,inst_33035);var state_33091__$1 = state_33091;if(inst_33038)
{var statearr_33120_33160 = state_33091__$1;(statearr_33120_33160[(1)] = (7));
} else
{var statearr_33121_33161 = state_33091__$1;(statearr_33121_33161[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (14)))
{var inst_33051 = (state_33091[(16)]);var inst_33058 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_33051);var state_33091__$1 = state_33091;var statearr_33122_33162 = state_33091__$1;(statearr_33122_33162[(2)] = inst_33058);
(statearr_33122_33162[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (26)))
{var inst_33081 = (state_33091[(2)]);var state_33091__$1 = state_33091;var statearr_33123_33163 = state_33091__$1;(statearr_33123_33163[(2)] = inst_33081);
(statearr_33123_33163[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (16)))
{var inst_33061 = (state_33091[(2)]);var inst_33062 = calc_state.call(null);var inst_33035 = inst_33062;var state_33091__$1 = (function (){var statearr_33124 = state_33091;(statearr_33124[(7)] = inst_33035);
(statearr_33124[(18)] = inst_33061);
return statearr_33124;
})();var statearr_33125_33164 = state_33091__$1;(statearr_33125_33164[(2)] = null);
(statearr_33125_33164[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (10)))
{var inst_33050 = (state_33091[(8)]);var inst_33051 = (state_33091[(16)]);var inst_33049 = (state_33091[(2)]);var inst_33050__$1 = cljs.core.nth.call(null,inst_33049,(0),null);var inst_33051__$1 = cljs.core.nth.call(null,inst_33049,(1),null);var inst_33052 = (inst_33050__$1 == null);var inst_33053 = cljs.core._EQ_.call(null,inst_33051__$1,change);var inst_33054 = (inst_33052) || (inst_33053);var state_33091__$1 = (function (){var statearr_33126 = state_33091;(statearr_33126[(8)] = inst_33050__$1);
(statearr_33126[(16)] = inst_33051__$1);
return statearr_33126;
})();if(cljs.core.truth_(inst_33054))
{var statearr_33127_33165 = state_33091__$1;(statearr_33127_33165[(1)] = (11));
} else
{var statearr_33128_33166 = state_33091__$1;(statearr_33128_33166[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (18)))
{var inst_33046 = (state_33091[(15)]);var inst_33051 = (state_33091[(16)]);var inst_33045 = (state_33091[(17)]);var inst_33068 = cljs.core.empty_QMARK_.call(null,inst_33046);var inst_33069 = inst_33045.call(null,inst_33051);var inst_33070 = cljs.core.not.call(null,inst_33069);var inst_33071 = (inst_33068) && (inst_33070);var state_33091__$1 = state_33091;var statearr_33129_33167 = state_33091__$1;(statearr_33129_33167[(2)] = inst_33071);
(statearr_33129_33167[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33092 === (8)))
{var inst_33035 = (state_33091[(7)]);var state_33091__$1 = state_33091;var statearr_33130_33168 = state_33091__$1;(statearr_33130_33168[(2)] = inst_33035);
(statearr_33130_33168[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__7350__auto__,c__7365__auto___33138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33134 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33134[(0)] = state_machine__7351__auto__);
(statearr_33134[(1)] = (1));
return statearr_33134;
});
var state_machine__7351__auto____1 = (function (state_33091){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33091);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33135){if((e33135 instanceof Object))
{var ex__7354__auto__ = e33135;var statearr_33136_33169 = state_33091;(statearr_33136_33169[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33091);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33135;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33170 = state_33091;
state_33091 = G__33170;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33091){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__7367__auto__ = (function (){var statearr_33137 = f__7366__auto__.call(null);(statearr_33137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33138);
return statearr_33137;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj33172 = {};return obj33172;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__3529__auto__ = p;if(and__3529__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__3529__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__4168__auto__ = (((p == null))?null:p);return (function (){var or__3541__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4168__auto__)]);if(or__3541__auto__)
{return or__3541__auto__;
} else
{var or__3541__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__3541__auto____$1)
{return or__3541__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__3541__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__3541__auto__))
{return or__3541__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3541__auto__,mults){
return (function (p1__33173_SHARP_){if(cljs.core.truth_(p1__33173_SHARP_.call(null,topic)))
{return p1__33173_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__33173_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3541__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t33296 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t33296 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta33297){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta33297 = meta33297;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33296.cljs$lang$type = true;
cljs.core.async.t33296.cljs$lang$ctorStr = "cljs.core.async/t33296";
cljs.core.async.t33296.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4108__auto__,writer__4109__auto__,opt__4110__auto__){return cljs.core._write.call(null,writer__4109__auto__,"cljs.core.async/t33296");
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t33296.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t33296.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33298){var self__ = this;
var _33298__$1 = this;return self__.meta33297;
});})(mults,ensure_mult))
;
cljs.core.async.t33296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33298,meta33297__$1){var self__ = this;
var _33298__$1 = this;return (new cljs.core.async.t33296(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta33297__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t33296 = ((function (mults,ensure_mult){
return (function __GT_t33296(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta33297){return (new cljs.core.async.t33296(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta33297));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t33296(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__7365__auto___33418 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33418,mults,ensure_mult,p){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33418,mults,ensure_mult,p){
return (function (state_33370){var state_val_33371 = (state_33370[(1)]);if((state_val_33371 === (7)))
{var inst_33366 = (state_33370[(2)]);var state_33370__$1 = state_33370;var statearr_33372_33419 = state_33370__$1;(statearr_33372_33419[(2)] = inst_33366);
(statearr_33372_33419[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (20)))
{var state_33370__$1 = state_33370;var statearr_33373_33420 = state_33370__$1;(statearr_33373_33420[(2)] = null);
(statearr_33373_33420[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (1)))
{var state_33370__$1 = state_33370;var statearr_33374_33421 = state_33370__$1;(statearr_33374_33421[(2)] = null);
(statearr_33374_33421[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (24)))
{var inst_33349 = (state_33370[(7)]);var inst_33358 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_33349);var state_33370__$1 = state_33370;var statearr_33375_33422 = state_33370__$1;(statearr_33375_33422[(2)] = inst_33358);
(statearr_33375_33422[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (4)))
{var inst_33301 = (state_33370[(8)]);var inst_33301__$1 = (state_33370[(2)]);var inst_33302 = (inst_33301__$1 == null);var state_33370__$1 = (function (){var statearr_33376 = state_33370;(statearr_33376[(8)] = inst_33301__$1);
return statearr_33376;
})();if(cljs.core.truth_(inst_33302))
{var statearr_33377_33423 = state_33370__$1;(statearr_33377_33423[(1)] = (5));
} else
{var statearr_33378_33424 = state_33370__$1;(statearr_33378_33424[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (15)))
{var inst_33343 = (state_33370[(2)]);var state_33370__$1 = state_33370;var statearr_33379_33425 = state_33370__$1;(statearr_33379_33425[(2)] = inst_33343);
(statearr_33379_33425[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (21)))
{var inst_33363 = (state_33370[(2)]);var state_33370__$1 = (function (){var statearr_33380 = state_33370;(statearr_33380[(9)] = inst_33363);
return statearr_33380;
})();var statearr_33381_33426 = state_33370__$1;(statearr_33381_33426[(2)] = null);
(statearr_33381_33426[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (13)))
{var inst_33325 = (state_33370[(10)]);var inst_33327 = cljs.core.chunked_seq_QMARK_.call(null,inst_33325);var state_33370__$1 = state_33370;if(inst_33327)
{var statearr_33382_33427 = state_33370__$1;(statearr_33382_33427[(1)] = (16));
} else
{var statearr_33383_33428 = state_33370__$1;(statearr_33383_33428[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (22)))
{var inst_33355 = (state_33370[(2)]);var state_33370__$1 = state_33370;if(cljs.core.truth_(inst_33355))
{var statearr_33384_33429 = state_33370__$1;(statearr_33384_33429[(1)] = (23));
} else
{var statearr_33385_33430 = state_33370__$1;(statearr_33385_33430[(1)] = (24));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (6)))
{var inst_33351 = (state_33370[(11)]);var inst_33349 = (state_33370[(7)]);var inst_33301 = (state_33370[(8)]);var inst_33349__$1 = topic_fn.call(null,inst_33301);var inst_33350 = cljs.core.deref.call(null,mults);var inst_33351__$1 = cljs.core.get.call(null,inst_33350,inst_33349__$1);var state_33370__$1 = (function (){var statearr_33386 = state_33370;(statearr_33386[(11)] = inst_33351__$1);
(statearr_33386[(7)] = inst_33349__$1);
return statearr_33386;
})();if(cljs.core.truth_(inst_33351__$1))
{var statearr_33387_33431 = state_33370__$1;(statearr_33387_33431[(1)] = (19));
} else
{var statearr_33388_33432 = state_33370__$1;(statearr_33388_33432[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (25)))
{var inst_33360 = (state_33370[(2)]);var state_33370__$1 = state_33370;var statearr_33389_33433 = state_33370__$1;(statearr_33389_33433[(2)] = inst_33360);
(statearr_33389_33433[(1)] = (21));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (17)))
{var inst_33325 = (state_33370[(10)]);var inst_33334 = cljs.core.first.call(null,inst_33325);var inst_33335 = cljs.core.async.muxch_STAR_.call(null,inst_33334);var inst_33336 = cljs.core.async.close_BANG_.call(null,inst_33335);var inst_33337 = cljs.core.next.call(null,inst_33325);var inst_33311 = inst_33337;var inst_33312 = null;var inst_33313 = (0);var inst_33314 = (0);var state_33370__$1 = (function (){var statearr_33390 = state_33370;(statearr_33390[(12)] = inst_33313);
(statearr_33390[(13)] = inst_33336);
(statearr_33390[(14)] = inst_33312);
(statearr_33390[(15)] = inst_33311);
(statearr_33390[(16)] = inst_33314);
return statearr_33390;
})();var statearr_33391_33434 = state_33370__$1;(statearr_33391_33434[(2)] = null);
(statearr_33391_33434[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (3)))
{var inst_33368 = (state_33370[(2)]);var state_33370__$1 = state_33370;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33370__$1,inst_33368);
} else
{if((state_val_33371 === (12)))
{var inst_33345 = (state_33370[(2)]);var state_33370__$1 = state_33370;var statearr_33392_33435 = state_33370__$1;(statearr_33392_33435[(2)] = inst_33345);
(statearr_33392_33435[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (2)))
{var state_33370__$1 = state_33370;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33370__$1,(4),ch);
} else
{if((state_val_33371 === (23)))
{var state_33370__$1 = state_33370;var statearr_33393_33436 = state_33370__$1;(statearr_33393_33436[(2)] = null);
(statearr_33393_33436[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (19)))
{var inst_33351 = (state_33370[(11)]);var inst_33301 = (state_33370[(8)]);var inst_33353 = cljs.core.async.muxch_STAR_.call(null,inst_33351);var state_33370__$1 = state_33370;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33370__$1,(22),inst_33353,inst_33301);
} else
{if((state_val_33371 === (11)))
{var inst_33325 = (state_33370[(10)]);var inst_33311 = (state_33370[(15)]);var inst_33325__$1 = cljs.core.seq.call(null,inst_33311);var state_33370__$1 = (function (){var statearr_33394 = state_33370;(statearr_33394[(10)] = inst_33325__$1);
return statearr_33394;
})();if(inst_33325__$1)
{var statearr_33395_33437 = state_33370__$1;(statearr_33395_33437[(1)] = (13));
} else
{var statearr_33396_33438 = state_33370__$1;(statearr_33396_33438[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (9)))
{var inst_33347 = (state_33370[(2)]);var state_33370__$1 = state_33370;var statearr_33397_33439 = state_33370__$1;(statearr_33397_33439[(2)] = inst_33347);
(statearr_33397_33439[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (5)))
{var inst_33308 = cljs.core.deref.call(null,mults);var inst_33309 = cljs.core.vals.call(null,inst_33308);var inst_33310 = cljs.core.seq.call(null,inst_33309);var inst_33311 = inst_33310;var inst_33312 = null;var inst_33313 = (0);var inst_33314 = (0);var state_33370__$1 = (function (){var statearr_33398 = state_33370;(statearr_33398[(12)] = inst_33313);
(statearr_33398[(14)] = inst_33312);
(statearr_33398[(15)] = inst_33311);
(statearr_33398[(16)] = inst_33314);
return statearr_33398;
})();var statearr_33399_33440 = state_33370__$1;(statearr_33399_33440[(2)] = null);
(statearr_33399_33440[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (14)))
{var state_33370__$1 = state_33370;var statearr_33403_33441 = state_33370__$1;(statearr_33403_33441[(2)] = null);
(statearr_33403_33441[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (16)))
{var inst_33325 = (state_33370[(10)]);var inst_33329 = cljs.core.chunk_first.call(null,inst_33325);var inst_33330 = cljs.core.chunk_rest.call(null,inst_33325);var inst_33331 = cljs.core.count.call(null,inst_33329);var inst_33311 = inst_33330;var inst_33312 = inst_33329;var inst_33313 = inst_33331;var inst_33314 = (0);var state_33370__$1 = (function (){var statearr_33404 = state_33370;(statearr_33404[(12)] = inst_33313);
(statearr_33404[(14)] = inst_33312);
(statearr_33404[(15)] = inst_33311);
(statearr_33404[(16)] = inst_33314);
return statearr_33404;
})();var statearr_33405_33442 = state_33370__$1;(statearr_33405_33442[(2)] = null);
(statearr_33405_33442[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (10)))
{var inst_33313 = (state_33370[(12)]);var inst_33312 = (state_33370[(14)]);var inst_33311 = (state_33370[(15)]);var inst_33314 = (state_33370[(16)]);var inst_33319 = cljs.core._nth.call(null,inst_33312,inst_33314);var inst_33320 = cljs.core.async.muxch_STAR_.call(null,inst_33319);var inst_33321 = cljs.core.async.close_BANG_.call(null,inst_33320);var inst_33322 = (inst_33314 + (1));var tmp33400 = inst_33313;var tmp33401 = inst_33312;var tmp33402 = inst_33311;var inst_33311__$1 = tmp33402;var inst_33312__$1 = tmp33401;var inst_33313__$1 = tmp33400;var inst_33314__$1 = inst_33322;var state_33370__$1 = (function (){var statearr_33406 = state_33370;(statearr_33406[(12)] = inst_33313__$1);
(statearr_33406[(14)] = inst_33312__$1);
(statearr_33406[(15)] = inst_33311__$1);
(statearr_33406[(17)] = inst_33321);
(statearr_33406[(16)] = inst_33314__$1);
return statearr_33406;
})();var statearr_33407_33443 = state_33370__$1;(statearr_33407_33443[(2)] = null);
(statearr_33407_33443[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (18)))
{var inst_33340 = (state_33370[(2)]);var state_33370__$1 = state_33370;var statearr_33408_33444 = state_33370__$1;(statearr_33408_33444[(2)] = inst_33340);
(statearr_33408_33444[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33371 === (8)))
{var inst_33313 = (state_33370[(12)]);var inst_33314 = (state_33370[(16)]);var inst_33316 = (inst_33314 < inst_33313);var inst_33317 = inst_33316;var state_33370__$1 = state_33370;if(cljs.core.truth_(inst_33317))
{var statearr_33409_33445 = state_33370__$1;(statearr_33409_33445[(1)] = (10));
} else
{var statearr_33410_33446 = state_33370__$1;(statearr_33410_33446[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33418,mults,ensure_mult,p))
;return ((function (switch__7350__auto__,c__7365__auto___33418,mults,ensure_mult,p){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33414[(0)] = state_machine__7351__auto__);
(statearr_33414[(1)] = (1));
return statearr_33414;
});
var state_machine__7351__auto____1 = (function (state_33370){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33370);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33415){if((e33415 instanceof Object))
{var ex__7354__auto__ = e33415;var statearr_33416_33447 = state_33370;(statearr_33416_33447[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33370);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33415;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33448 = state_33370;
state_33370 = G__33448;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33370){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33418,mults,ensure_mult,p))
})();var state__7367__auto__ = (function (){var statearr_33417 = f__7366__auto__.call(null);(statearr_33417[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33418);
return statearr_33417;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33418,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__7365__auto___33585 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33585,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33585,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33555){var state_val_33556 = (state_33555[(1)]);if((state_val_33556 === (7)))
{var state_33555__$1 = state_33555;var statearr_33557_33586 = state_33555__$1;(statearr_33557_33586[(2)] = null);
(statearr_33557_33586[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (1)))
{var state_33555__$1 = state_33555;var statearr_33558_33587 = state_33555__$1;(statearr_33558_33587[(2)] = null);
(statearr_33558_33587[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (4)))
{var inst_33519 = (state_33555[(7)]);var inst_33521 = (inst_33519 < cnt);var state_33555__$1 = state_33555;if(cljs.core.truth_(inst_33521))
{var statearr_33559_33588 = state_33555__$1;(statearr_33559_33588[(1)] = (6));
} else
{var statearr_33560_33589 = state_33555__$1;(statearr_33560_33589[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (15)))
{var inst_33551 = (state_33555[(2)]);var state_33555__$1 = state_33555;var statearr_33561_33590 = state_33555__$1;(statearr_33561_33590[(2)] = inst_33551);
(statearr_33561_33590[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (13)))
{var inst_33544 = cljs.core.async.close_BANG_.call(null,out);var state_33555__$1 = state_33555;var statearr_33562_33591 = state_33555__$1;(statearr_33562_33591[(2)] = inst_33544);
(statearr_33562_33591[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (6)))
{var state_33555__$1 = state_33555;var statearr_33563_33592 = state_33555__$1;(statearr_33563_33592[(2)] = null);
(statearr_33563_33592[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (3)))
{var inst_33553 = (state_33555[(2)]);var state_33555__$1 = state_33555;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33555__$1,inst_33553);
} else
{if((state_val_33556 === (12)))
{var inst_33541 = (state_33555[(8)]);var inst_33541__$1 = (state_33555[(2)]);var inst_33542 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_33541__$1);var state_33555__$1 = (function (){var statearr_33564 = state_33555;(statearr_33564[(8)] = inst_33541__$1);
return statearr_33564;
})();if(cljs.core.truth_(inst_33542))
{var statearr_33565_33593 = state_33555__$1;(statearr_33565_33593[(1)] = (13));
} else
{var statearr_33566_33594 = state_33555__$1;(statearr_33566_33594[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (2)))
{var inst_33518 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_33519 = (0);var state_33555__$1 = (function (){var statearr_33567 = state_33555;(statearr_33567[(9)] = inst_33518);
(statearr_33567[(7)] = inst_33519);
return statearr_33567;
})();var statearr_33568_33595 = state_33555__$1;(statearr_33568_33595[(2)] = null);
(statearr_33568_33595[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (11)))
{var inst_33519 = (state_33555[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33555,(10),Object,null,(9));var inst_33528 = chs__$1.call(null,inst_33519);var inst_33529 = done.call(null,inst_33519);var inst_33530 = cljs.core.async.take_BANG_.call(null,inst_33528,inst_33529);var state_33555__$1 = state_33555;var statearr_33569_33596 = state_33555__$1;(statearr_33569_33596[(2)] = inst_33530);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33555__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (9)))
{var inst_33519 = (state_33555[(7)]);var inst_33532 = (state_33555[(2)]);var inst_33533 = (inst_33519 + (1));var inst_33519__$1 = inst_33533;var state_33555__$1 = (function (){var statearr_33570 = state_33555;(statearr_33570[(7)] = inst_33519__$1);
(statearr_33570[(10)] = inst_33532);
return statearr_33570;
})();var statearr_33571_33597 = state_33555__$1;(statearr_33571_33597[(2)] = null);
(statearr_33571_33597[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (5)))
{var inst_33539 = (state_33555[(2)]);var state_33555__$1 = (function (){var statearr_33572 = state_33555;(statearr_33572[(11)] = inst_33539);
return statearr_33572;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33555__$1,(12),dchan);
} else
{if((state_val_33556 === (14)))
{var inst_33541 = (state_33555[(8)]);var inst_33546 = cljs.core.apply.call(null,f,inst_33541);var state_33555__$1 = state_33555;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33555__$1,(16),out,inst_33546);
} else
{if((state_val_33556 === (16)))
{var inst_33548 = (state_33555[(2)]);var state_33555__$1 = (function (){var statearr_33573 = state_33555;(statearr_33573[(12)] = inst_33548);
return statearr_33573;
})();var statearr_33574_33598 = state_33555__$1;(statearr_33574_33598[(2)] = null);
(statearr_33574_33598[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (10)))
{var inst_33523 = (state_33555[(2)]);var inst_33524 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_33555__$1 = (function (){var statearr_33575 = state_33555;(statearr_33575[(13)] = inst_33523);
return statearr_33575;
})();var statearr_33576_33599 = state_33555__$1;(statearr_33576_33599[(2)] = inst_33524);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33555__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33556 === (8)))
{var inst_33537 = (state_33555[(2)]);var state_33555__$1 = state_33555;var statearr_33577_33600 = state_33555__$1;(statearr_33577_33600[(2)] = inst_33537);
(statearr_33577_33600[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33585,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__7350__auto__,c__7365__auto___33585,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33581 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33581[(0)] = state_machine__7351__auto__);
(statearr_33581[(1)] = (1));
return statearr_33581;
});
var state_machine__7351__auto____1 = (function (state_33555){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33555);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33582){if((e33582 instanceof Object))
{var ex__7354__auto__ = e33582;var statearr_33583_33601 = state_33555;(statearr_33583_33601[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33555);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33582;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33602 = state_33555;
state_33555 = G__33602;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33555){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33585,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__7367__auto__ = (function (){var statearr_33584 = f__7366__auto__.call(null);(statearr_33584[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33585);
return statearr_33584;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33585,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33710 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33710,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33710,out){
return (function (state_33686){var state_val_33687 = (state_33686[(1)]);if((state_val_33687 === (7)))
{var inst_33665 = (state_33686[(7)]);var inst_33666 = (state_33686[(8)]);var inst_33665__$1 = (state_33686[(2)]);var inst_33666__$1 = cljs.core.nth.call(null,inst_33665__$1,(0),null);var inst_33667 = cljs.core.nth.call(null,inst_33665__$1,(1),null);var inst_33668 = (inst_33666__$1 == null);var state_33686__$1 = (function (){var statearr_33688 = state_33686;(statearr_33688[(9)] = inst_33667);
(statearr_33688[(7)] = inst_33665__$1);
(statearr_33688[(8)] = inst_33666__$1);
return statearr_33688;
})();if(cljs.core.truth_(inst_33668))
{var statearr_33689_33711 = state_33686__$1;(statearr_33689_33711[(1)] = (8));
} else
{var statearr_33690_33712 = state_33686__$1;(statearr_33690_33712[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (1)))
{var inst_33657 = cljs.core.vec.call(null,chs);var inst_33658 = inst_33657;var state_33686__$1 = (function (){var statearr_33691 = state_33686;(statearr_33691[(10)] = inst_33658);
return statearr_33691;
})();var statearr_33692_33713 = state_33686__$1;(statearr_33692_33713[(2)] = null);
(statearr_33692_33713[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (4)))
{var inst_33658 = (state_33686[(10)]);var state_33686__$1 = state_33686;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_33686__$1,(7),inst_33658);
} else
{if((state_val_33687 === (6)))
{var inst_33682 = (state_33686[(2)]);var state_33686__$1 = state_33686;var statearr_33693_33714 = state_33686__$1;(statearr_33693_33714[(2)] = inst_33682);
(statearr_33693_33714[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (3)))
{var inst_33684 = (state_33686[(2)]);var state_33686__$1 = state_33686;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33686__$1,inst_33684);
} else
{if((state_val_33687 === (2)))
{var inst_33658 = (state_33686[(10)]);var inst_33660 = cljs.core.count.call(null,inst_33658);var inst_33661 = (inst_33660 > (0));var state_33686__$1 = state_33686;if(cljs.core.truth_(inst_33661))
{var statearr_33695_33715 = state_33686__$1;(statearr_33695_33715[(1)] = (4));
} else
{var statearr_33696_33716 = state_33686__$1;(statearr_33696_33716[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (11)))
{var inst_33658 = (state_33686[(10)]);var inst_33675 = (state_33686[(2)]);var tmp33694 = inst_33658;var inst_33658__$1 = tmp33694;var state_33686__$1 = (function (){var statearr_33697 = state_33686;(statearr_33697[(10)] = inst_33658__$1);
(statearr_33697[(11)] = inst_33675);
return statearr_33697;
})();var statearr_33698_33717 = state_33686__$1;(statearr_33698_33717[(2)] = null);
(statearr_33698_33717[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (9)))
{var inst_33666 = (state_33686[(8)]);var state_33686__$1 = state_33686;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33686__$1,(11),out,inst_33666);
} else
{if((state_val_33687 === (5)))
{var inst_33680 = cljs.core.async.close_BANG_.call(null,out);var state_33686__$1 = state_33686;var statearr_33699_33718 = state_33686__$1;(statearr_33699_33718[(2)] = inst_33680);
(statearr_33699_33718[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (10)))
{var inst_33678 = (state_33686[(2)]);var state_33686__$1 = state_33686;var statearr_33700_33719 = state_33686__$1;(statearr_33700_33719[(2)] = inst_33678);
(statearr_33700_33719[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33687 === (8)))
{var inst_33667 = (state_33686[(9)]);var inst_33665 = (state_33686[(7)]);var inst_33666 = (state_33686[(8)]);var inst_33658 = (state_33686[(10)]);var inst_33670 = (function (){var c = inst_33667;var v = inst_33666;var vec__33663 = inst_33665;var cs = inst_33658;return ((function (c,v,vec__33663,cs,inst_33667,inst_33665,inst_33666,inst_33658,state_val_33687,c__7365__auto___33710,out){
return (function (p1__33603_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__33603_SHARP_);
});
;})(c,v,vec__33663,cs,inst_33667,inst_33665,inst_33666,inst_33658,state_val_33687,c__7365__auto___33710,out))
})();var inst_33671 = cljs.core.filterv.call(null,inst_33670,inst_33658);var inst_33658__$1 = inst_33671;var state_33686__$1 = (function (){var statearr_33701 = state_33686;(statearr_33701[(10)] = inst_33658__$1);
return statearr_33701;
})();var statearr_33702_33720 = state_33686__$1;(statearr_33702_33720[(2)] = null);
(statearr_33702_33720[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33710,out))
;return ((function (switch__7350__auto__,c__7365__auto___33710,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33706 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_33706[(0)] = state_machine__7351__auto__);
(statearr_33706[(1)] = (1));
return statearr_33706;
});
var state_machine__7351__auto____1 = (function (state_33686){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33686);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33707){if((e33707 instanceof Object))
{var ex__7354__auto__ = e33707;var statearr_33708_33721 = state_33686;(statearr_33708_33721[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33686);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33707;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33722 = state_33686;
state_33686 = G__33722;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33686){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33710,out))
})();var state__7367__auto__ = (function (){var statearr_33709 = f__7366__auto__.call(null);(statearr_33709[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33710);
return statearr_33709;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33710,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33815 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33815,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33815,out){
return (function (state_33792){var state_val_33793 = (state_33792[(1)]);if((state_val_33793 === (7)))
{var inst_33774 = (state_33792[(7)]);var inst_33774__$1 = (state_33792[(2)]);var inst_33775 = (inst_33774__$1 == null);var inst_33776 = cljs.core.not.call(null,inst_33775);var state_33792__$1 = (function (){var statearr_33794 = state_33792;(statearr_33794[(7)] = inst_33774__$1);
return statearr_33794;
})();if(inst_33776)
{var statearr_33795_33816 = state_33792__$1;(statearr_33795_33816[(1)] = (8));
} else
{var statearr_33796_33817 = state_33792__$1;(statearr_33796_33817[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (1)))
{var inst_33769 = (0);var state_33792__$1 = (function (){var statearr_33797 = state_33792;(statearr_33797[(8)] = inst_33769);
return statearr_33797;
})();var statearr_33798_33818 = state_33792__$1;(statearr_33798_33818[(2)] = null);
(statearr_33798_33818[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (4)))
{var state_33792__$1 = state_33792;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33792__$1,(7),ch);
} else
{if((state_val_33793 === (6)))
{var inst_33787 = (state_33792[(2)]);var state_33792__$1 = state_33792;var statearr_33799_33819 = state_33792__$1;(statearr_33799_33819[(2)] = inst_33787);
(statearr_33799_33819[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (3)))
{var inst_33789 = (state_33792[(2)]);var inst_33790 = cljs.core.async.close_BANG_.call(null,out);var state_33792__$1 = (function (){var statearr_33800 = state_33792;(statearr_33800[(9)] = inst_33789);
return statearr_33800;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33792__$1,inst_33790);
} else
{if((state_val_33793 === (2)))
{var inst_33769 = (state_33792[(8)]);var inst_33771 = (inst_33769 < n);var state_33792__$1 = state_33792;if(cljs.core.truth_(inst_33771))
{var statearr_33801_33820 = state_33792__$1;(statearr_33801_33820[(1)] = (4));
} else
{var statearr_33802_33821 = state_33792__$1;(statearr_33802_33821[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (11)))
{var inst_33769 = (state_33792[(8)]);var inst_33779 = (state_33792[(2)]);var inst_33780 = (inst_33769 + (1));var inst_33769__$1 = inst_33780;var state_33792__$1 = (function (){var statearr_33803 = state_33792;(statearr_33803[(10)] = inst_33779);
(statearr_33803[(8)] = inst_33769__$1);
return statearr_33803;
})();var statearr_33804_33822 = state_33792__$1;(statearr_33804_33822[(2)] = null);
(statearr_33804_33822[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (9)))
{var state_33792__$1 = state_33792;var statearr_33805_33823 = state_33792__$1;(statearr_33805_33823[(2)] = null);
(statearr_33805_33823[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (5)))
{var state_33792__$1 = state_33792;var statearr_33806_33824 = state_33792__$1;(statearr_33806_33824[(2)] = null);
(statearr_33806_33824[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (10)))
{var inst_33784 = (state_33792[(2)]);var state_33792__$1 = state_33792;var statearr_33807_33825 = state_33792__$1;(statearr_33807_33825[(2)] = inst_33784);
(statearr_33807_33825[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33793 === (8)))
{var inst_33774 = (state_33792[(7)]);var state_33792__$1 = state_33792;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33792__$1,(11),out,inst_33774);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33815,out))
;return ((function (switch__7350__auto__,c__7365__auto___33815,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33811 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_33811[(0)] = state_machine__7351__auto__);
(statearr_33811[(1)] = (1));
return statearr_33811;
});
var state_machine__7351__auto____1 = (function (state_33792){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33792);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33812){if((e33812 instanceof Object))
{var ex__7354__auto__ = e33812;var statearr_33813_33826 = state_33792;(statearr_33813_33826[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33792);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33812;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33827 = state_33792;
state_33792 = G__33827;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33792){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33815,out))
})();var state__7367__auto__ = (function (){var statearr_33814 = f__7366__auto__.call(null);(statearr_33814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33815);
return statearr_33814;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33815,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___33924 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___33924,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___33924,out){
return (function (state_33899){var state_val_33900 = (state_33899[(1)]);if((state_val_33900 === (7)))
{var inst_33894 = (state_33899[(2)]);var state_33899__$1 = state_33899;var statearr_33901_33925 = state_33899__$1;(statearr_33901_33925[(2)] = inst_33894);
(statearr_33901_33925[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (1)))
{var inst_33876 = null;var state_33899__$1 = (function (){var statearr_33902 = state_33899;(statearr_33902[(7)] = inst_33876);
return statearr_33902;
})();var statearr_33903_33926 = state_33899__$1;(statearr_33903_33926[(2)] = null);
(statearr_33903_33926[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (4)))
{var inst_33879 = (state_33899[(8)]);var inst_33879__$1 = (state_33899[(2)]);var inst_33880 = (inst_33879__$1 == null);var inst_33881 = cljs.core.not.call(null,inst_33880);var state_33899__$1 = (function (){var statearr_33904 = state_33899;(statearr_33904[(8)] = inst_33879__$1);
return statearr_33904;
})();if(inst_33881)
{var statearr_33905_33927 = state_33899__$1;(statearr_33905_33927[(1)] = (5));
} else
{var statearr_33906_33928 = state_33899__$1;(statearr_33906_33928[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (6)))
{var state_33899__$1 = state_33899;var statearr_33907_33929 = state_33899__$1;(statearr_33907_33929[(2)] = null);
(statearr_33907_33929[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (3)))
{var inst_33896 = (state_33899[(2)]);var inst_33897 = cljs.core.async.close_BANG_.call(null,out);var state_33899__$1 = (function (){var statearr_33908 = state_33899;(statearr_33908[(9)] = inst_33896);
return statearr_33908;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33899__$1,inst_33897);
} else
{if((state_val_33900 === (2)))
{var state_33899__$1 = state_33899;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33899__$1,(4),ch);
} else
{if((state_val_33900 === (11)))
{var inst_33879 = (state_33899[(8)]);var inst_33888 = (state_33899[(2)]);var inst_33876 = inst_33879;var state_33899__$1 = (function (){var statearr_33909 = state_33899;(statearr_33909[(10)] = inst_33888);
(statearr_33909[(7)] = inst_33876);
return statearr_33909;
})();var statearr_33910_33930 = state_33899__$1;(statearr_33910_33930[(2)] = null);
(statearr_33910_33930[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (9)))
{var inst_33879 = (state_33899[(8)]);var state_33899__$1 = state_33899;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33899__$1,(11),out,inst_33879);
} else
{if((state_val_33900 === (5)))
{var inst_33876 = (state_33899[(7)]);var inst_33879 = (state_33899[(8)]);var inst_33883 = cljs.core._EQ_.call(null,inst_33879,inst_33876);var state_33899__$1 = state_33899;if(inst_33883)
{var statearr_33912_33931 = state_33899__$1;(statearr_33912_33931[(1)] = (8));
} else
{var statearr_33913_33932 = state_33899__$1;(statearr_33913_33932[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (10)))
{var inst_33891 = (state_33899[(2)]);var state_33899__$1 = state_33899;var statearr_33914_33933 = state_33899__$1;(statearr_33914_33933[(2)] = inst_33891);
(statearr_33914_33933[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_33900 === (8)))
{var inst_33876 = (state_33899[(7)]);var tmp33911 = inst_33876;var inst_33876__$1 = tmp33911;var state_33899__$1 = (function (){var statearr_33915 = state_33899;(statearr_33915[(7)] = inst_33876__$1);
return statearr_33915;
})();var statearr_33916_33934 = state_33899__$1;(statearr_33916_33934[(2)] = null);
(statearr_33916_33934[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___33924,out))
;return ((function (switch__7350__auto__,c__7365__auto___33924,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_33920 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_33920[(0)] = state_machine__7351__auto__);
(statearr_33920[(1)] = (1));
return statearr_33920;
});
var state_machine__7351__auto____1 = (function (state_33899){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_33899);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e33921){if((e33921 instanceof Object))
{var ex__7354__auto__ = e33921;var statearr_33922_33935 = state_33899;(statearr_33922_33935[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33899);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e33921;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__33936 = state_33899;
state_33899 = G__33936;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_33899){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_33899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___33924,out))
})();var state__7367__auto__ = (function (){var statearr_33923 = f__7366__auto__.call(null);(statearr_33923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___33924);
return statearr_33923;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___33924,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___34071 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___34071,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___34071,out){
return (function (state_34041){var state_val_34042 = (state_34041[(1)]);if((state_val_34042 === (7)))
{var inst_34037 = (state_34041[(2)]);var state_34041__$1 = state_34041;var statearr_34043_34072 = state_34041__$1;(statearr_34043_34072[(2)] = inst_34037);
(statearr_34043_34072[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (1)))
{var inst_34004 = (new Array(n));var inst_34005 = inst_34004;var inst_34006 = (0);var state_34041__$1 = (function (){var statearr_34044 = state_34041;(statearr_34044[(7)] = inst_34006);
(statearr_34044[(8)] = inst_34005);
return statearr_34044;
})();var statearr_34045_34073 = state_34041__$1;(statearr_34045_34073[(2)] = null);
(statearr_34045_34073[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (4)))
{var inst_34009 = (state_34041[(9)]);var inst_34009__$1 = (state_34041[(2)]);var inst_34010 = (inst_34009__$1 == null);var inst_34011 = cljs.core.not.call(null,inst_34010);var state_34041__$1 = (function (){var statearr_34046 = state_34041;(statearr_34046[(9)] = inst_34009__$1);
return statearr_34046;
})();if(inst_34011)
{var statearr_34047_34074 = state_34041__$1;(statearr_34047_34074[(1)] = (5));
} else
{var statearr_34048_34075 = state_34041__$1;(statearr_34048_34075[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (15)))
{var inst_34031 = (state_34041[(2)]);var state_34041__$1 = state_34041;var statearr_34049_34076 = state_34041__$1;(statearr_34049_34076[(2)] = inst_34031);
(statearr_34049_34076[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (13)))
{var state_34041__$1 = state_34041;var statearr_34050_34077 = state_34041__$1;(statearr_34050_34077[(2)] = null);
(statearr_34050_34077[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (6)))
{var inst_34006 = (state_34041[(7)]);var inst_34027 = (inst_34006 > (0));var state_34041__$1 = state_34041;if(cljs.core.truth_(inst_34027))
{var statearr_34051_34078 = state_34041__$1;(statearr_34051_34078[(1)] = (12));
} else
{var statearr_34052_34079 = state_34041__$1;(statearr_34052_34079[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (3)))
{var inst_34039 = (state_34041[(2)]);var state_34041__$1 = state_34041;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34041__$1,inst_34039);
} else
{if((state_val_34042 === (12)))
{var inst_34005 = (state_34041[(8)]);var inst_34029 = cljs.core.vec.call(null,inst_34005);var state_34041__$1 = state_34041;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34041__$1,(15),out,inst_34029);
} else
{if((state_val_34042 === (2)))
{var state_34041__$1 = state_34041;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34041__$1,(4),ch);
} else
{if((state_val_34042 === (11)))
{var inst_34021 = (state_34041[(2)]);var inst_34022 = (new Array(n));var inst_34005 = inst_34022;var inst_34006 = (0);var state_34041__$1 = (function (){var statearr_34053 = state_34041;(statearr_34053[(7)] = inst_34006);
(statearr_34053[(8)] = inst_34005);
(statearr_34053[(10)] = inst_34021);
return statearr_34053;
})();var statearr_34054_34080 = state_34041__$1;(statearr_34054_34080[(2)] = null);
(statearr_34054_34080[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (9)))
{var inst_34005 = (state_34041[(8)]);var inst_34019 = cljs.core.vec.call(null,inst_34005);var state_34041__$1 = state_34041;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34041__$1,(11),out,inst_34019);
} else
{if((state_val_34042 === (5)))
{var inst_34006 = (state_34041[(7)]);var inst_34005 = (state_34041[(8)]);var inst_34014 = (state_34041[(11)]);var inst_34009 = (state_34041[(9)]);var inst_34013 = (inst_34005[inst_34006] = inst_34009);var inst_34014__$1 = (inst_34006 + (1));var inst_34015 = (inst_34014__$1 < n);var state_34041__$1 = (function (){var statearr_34055 = state_34041;(statearr_34055[(11)] = inst_34014__$1);
(statearr_34055[(12)] = inst_34013);
return statearr_34055;
})();if(cljs.core.truth_(inst_34015))
{var statearr_34056_34081 = state_34041__$1;(statearr_34056_34081[(1)] = (8));
} else
{var statearr_34057_34082 = state_34041__$1;(statearr_34057_34082[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (14)))
{var inst_34034 = (state_34041[(2)]);var inst_34035 = cljs.core.async.close_BANG_.call(null,out);var state_34041__$1 = (function (){var statearr_34059 = state_34041;(statearr_34059[(13)] = inst_34034);
return statearr_34059;
})();var statearr_34060_34083 = state_34041__$1;(statearr_34060_34083[(2)] = inst_34035);
(statearr_34060_34083[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (10)))
{var inst_34025 = (state_34041[(2)]);var state_34041__$1 = state_34041;var statearr_34061_34084 = state_34041__$1;(statearr_34061_34084[(2)] = inst_34025);
(statearr_34061_34084[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34042 === (8)))
{var inst_34005 = (state_34041[(8)]);var inst_34014 = (state_34041[(11)]);var tmp34058 = inst_34005;var inst_34005__$1 = tmp34058;var inst_34006 = inst_34014;var state_34041__$1 = (function (){var statearr_34062 = state_34041;(statearr_34062[(7)] = inst_34006);
(statearr_34062[(8)] = inst_34005__$1);
return statearr_34062;
})();var statearr_34063_34085 = state_34041__$1;(statearr_34063_34085[(2)] = null);
(statearr_34063_34085[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___34071,out))
;return ((function (switch__7350__auto__,c__7365__auto___34071,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_34067 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_34067[(0)] = state_machine__7351__auto__);
(statearr_34067[(1)] = (1));
return statearr_34067;
});
var state_machine__7351__auto____1 = (function (state_34041){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_34041);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e34068){if((e34068 instanceof Object))
{var ex__7354__auto__ = e34068;var statearr_34069_34086 = state_34041;(statearr_34069_34086[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34041);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e34068;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__34087 = state_34041;
state_34041 = G__34087;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_34041){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_34041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___34071,out))
})();var state__7367__auto__ = (function (){var statearr_34070 = f__7366__auto__.call(null);(statearr_34070[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___34071);
return statearr_34070;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___34071,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__7365__auto___34230 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__7365__auto___34230,out){
return (function (){var f__7366__auto__ = (function (){var switch__7350__auto__ = ((function (c__7365__auto___34230,out){
return (function (state_34200){var state_val_34201 = (state_34200[(1)]);if((state_val_34201 === (7)))
{var inst_34196 = (state_34200[(2)]);var state_34200__$1 = state_34200;var statearr_34202_34231 = state_34200__$1;(statearr_34202_34231[(2)] = inst_34196);
(statearr_34202_34231[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (1)))
{var inst_34159 = [];var inst_34160 = inst_34159;var inst_34161 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_34200__$1 = (function (){var statearr_34203 = state_34200;(statearr_34203[(7)] = inst_34160);
(statearr_34203[(8)] = inst_34161);
return statearr_34203;
})();var statearr_34204_34232 = state_34200__$1;(statearr_34204_34232[(2)] = null);
(statearr_34204_34232[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (4)))
{var inst_34164 = (state_34200[(9)]);var inst_34164__$1 = (state_34200[(2)]);var inst_34165 = (inst_34164__$1 == null);var inst_34166 = cljs.core.not.call(null,inst_34165);var state_34200__$1 = (function (){var statearr_34205 = state_34200;(statearr_34205[(9)] = inst_34164__$1);
return statearr_34205;
})();if(inst_34166)
{var statearr_34206_34233 = state_34200__$1;(statearr_34206_34233[(1)] = (5));
} else
{var statearr_34207_34234 = state_34200__$1;(statearr_34207_34234[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (15)))
{var inst_34190 = (state_34200[(2)]);var state_34200__$1 = state_34200;var statearr_34208_34235 = state_34200__$1;(statearr_34208_34235[(2)] = inst_34190);
(statearr_34208_34235[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (13)))
{var state_34200__$1 = state_34200;var statearr_34209_34236 = state_34200__$1;(statearr_34209_34236[(2)] = null);
(statearr_34209_34236[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (6)))
{var inst_34160 = (state_34200[(7)]);var inst_34185 = inst_34160.length;var inst_34186 = (inst_34185 > (0));var state_34200__$1 = state_34200;if(cljs.core.truth_(inst_34186))
{var statearr_34210_34237 = state_34200__$1;(statearr_34210_34237[(1)] = (12));
} else
{var statearr_34211_34238 = state_34200__$1;(statearr_34211_34238[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (3)))
{var inst_34198 = (state_34200[(2)]);var state_34200__$1 = state_34200;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34200__$1,inst_34198);
} else
{if((state_val_34201 === (12)))
{var inst_34160 = (state_34200[(7)]);var inst_34188 = cljs.core.vec.call(null,inst_34160);var state_34200__$1 = state_34200;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34200__$1,(15),out,inst_34188);
} else
{if((state_val_34201 === (2)))
{var state_34200__$1 = state_34200;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34200__$1,(4),ch);
} else
{if((state_val_34201 === (11)))
{var inst_34164 = (state_34200[(9)]);var inst_34168 = (state_34200[(10)]);var inst_34178 = (state_34200[(2)]);var inst_34179 = [];var inst_34180 = inst_34179.push(inst_34164);var inst_34160 = inst_34179;var inst_34161 = inst_34168;var state_34200__$1 = (function (){var statearr_34212 = state_34200;(statearr_34212[(7)] = inst_34160);
(statearr_34212[(8)] = inst_34161);
(statearr_34212[(11)] = inst_34180);
(statearr_34212[(12)] = inst_34178);
return statearr_34212;
})();var statearr_34213_34239 = state_34200__$1;(statearr_34213_34239[(2)] = null);
(statearr_34213_34239[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (9)))
{var inst_34160 = (state_34200[(7)]);var inst_34176 = cljs.core.vec.call(null,inst_34160);var state_34200__$1 = state_34200;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34200__$1,(11),out,inst_34176);
} else
{if((state_val_34201 === (5)))
{var inst_34164 = (state_34200[(9)]);var inst_34161 = (state_34200[(8)]);var inst_34168 = (state_34200[(10)]);var inst_34168__$1 = f.call(null,inst_34164);var inst_34169 = cljs.core._EQ_.call(null,inst_34168__$1,inst_34161);var inst_34170 = cljs.core.keyword_identical_QMARK_.call(null,inst_34161,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_34171 = (inst_34169) || (inst_34170);var state_34200__$1 = (function (){var statearr_34214 = state_34200;(statearr_34214[(10)] = inst_34168__$1);
return statearr_34214;
})();if(cljs.core.truth_(inst_34171))
{var statearr_34215_34240 = state_34200__$1;(statearr_34215_34240[(1)] = (8));
} else
{var statearr_34216_34241 = state_34200__$1;(statearr_34216_34241[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (14)))
{var inst_34193 = (state_34200[(2)]);var inst_34194 = cljs.core.async.close_BANG_.call(null,out);var state_34200__$1 = (function (){var statearr_34218 = state_34200;(statearr_34218[(13)] = inst_34193);
return statearr_34218;
})();var statearr_34219_34242 = state_34200__$1;(statearr_34219_34242[(2)] = inst_34194);
(statearr_34219_34242[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (10)))
{var inst_34183 = (state_34200[(2)]);var state_34200__$1 = state_34200;var statearr_34220_34243 = state_34200__$1;(statearr_34220_34243[(2)] = inst_34183);
(statearr_34220_34243[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_34201 === (8)))
{var inst_34164 = (state_34200[(9)]);var inst_34160 = (state_34200[(7)]);var inst_34168 = (state_34200[(10)]);var inst_34173 = inst_34160.push(inst_34164);var tmp34217 = inst_34160;var inst_34160__$1 = tmp34217;var inst_34161 = inst_34168;var state_34200__$1 = (function (){var statearr_34221 = state_34200;(statearr_34221[(7)] = inst_34160__$1);
(statearr_34221[(8)] = inst_34161);
(statearr_34221[(14)] = inst_34173);
return statearr_34221;
})();var statearr_34222_34244 = state_34200__$1;(statearr_34222_34244[(2)] = null);
(statearr_34222_34244[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7365__auto___34230,out))
;return ((function (switch__7350__auto__,c__7365__auto___34230,out){
return (function() {
var state_machine__7351__auto__ = null;
var state_machine__7351__auto____0 = (function (){var statearr_34226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_34226[(0)] = state_machine__7351__auto__);
(statearr_34226[(1)] = (1));
return statearr_34226;
});
var state_machine__7351__auto____1 = (function (state_34200){while(true){
var ret_value__7352__auto__ = (function (){try{while(true){
var result__7353__auto__ = switch__7350__auto__.call(null,state_34200);if(cljs.core.keyword_identical_QMARK_.call(null,result__7353__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__7353__auto__;
}
break;
}
}catch (e34227){if((e34227 instanceof Object))
{var ex__7354__auto__ = e34227;var statearr_34228_34245 = state_34200;(statearr_34228_34245[(5)] = ex__7354__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34200);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e34227;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__34246 = state_34200;
state_34200 = G__34246;
continue;
}
} else
{return ret_value__7352__auto__;
}
break;
}
});
state_machine__7351__auto__ = function(state_34200){
switch(arguments.length){
case 0:
return state_machine__7351__auto____0.call(this);
case 1:
return state_machine__7351__auto____1.call(this,state_34200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__7351__auto____0;
state_machine__7351__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__7351__auto____1;
return state_machine__7351__auto__;
})()
;})(switch__7350__auto__,c__7365__auto___34230,out))
})();var state__7367__auto__ = (function (){var statearr_34229 = f__7366__auto__.call(null);(statearr_34229[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7365__auto___34230);
return statearr_34229;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7367__auto__);
});})(c__7365__auto___34230,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map