(ns com.palletops.bakery.om-root
  "A component for an Om root element."
  (:require-macros
   [com.palletops.api-builder.api :refer [defn-api]])
  (:require
   [com.palletops.leaven.protocols :refer [Startable Stoppable]]
   [om.core :as om :include-macros true]
   [schema.core :as schema]))

(defrecord OmRoot [f value options options-component]
  Startable
  (start [_]
    (om/root f value (merge options (:value options-component))))
  Stoppable
  (stop [_]
    (om/detach-root (:target options))))

(def OmRootFun (schema/make-fn-schema schema/Any [[schema/Any schema/Any]]))

(def OmRootOptions
  {:f OmRootFun
   :value schema/Any
   :options {schema/Keyword schema/Any}
   :options-component schema/Any})

(defn-api om-root
  "Return an om-root component"
  {:sig [[OmRootOptions :- OmRoot]
         [OmRootFun schema/Any {schema/Keyword schema/Any} :- OmRoot]
         [OmRootFun schema/Any {schema/Keyword schema/Any} schema/Any
          :- OmRoot]]}
  ([f value options]
   (->OmRoot f value options nil))
  ([f value options options-component]
   (->OmRoot f value options options-component))
  ([{:keys [f value options options-component] :as args}]
   (map->OmRoot args)))
