(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.Tag}
tag
  [m6955]
  (clojure.core/let
   [bean6954 (new com.amazonaws.services.storagegateway.model.Tag)]
   (clojure.core/let
    [v6956 (:value m6955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6956 :com.palletops.awaze.client-builder/undef)
     (. bean6954 setValue (clojure.core/str v6956))))
   (clojure.core/let
    [v6956 (:key m6955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6956 :com.palletops.awaze.client-builder/undef)
     (. bean6954 setKey (clojure.core/str v6956))))
   bean6954))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m6958]
  (clojure.core/let
   [bean6957
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/let
    [v6959
     (:secret-to-authenticate-initiator
      m6958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6959 :com.palletops.awaze.client-builder/undef)
     (.
      bean6957
      setSecretToAuthenticateInitiator
      (clojure.core/str v6959))))
   (clojure.core/let
    [v6959
     (:secret-to-authenticate-target
      m6958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6959 :com.palletops.awaze.client-builder/undef)
     (.
      bean6957
      setSecretToAuthenticateTarget
      (clojure.core/str v6959))))
   (clojure.core/let
    [v6959
     (:initiator-name m6958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6959 :com.palletops.awaze.client-builder/undef)
     (. bean6957 setInitiatorName (clojure.core/str v6959))))
   (clojure.core/let
    [v6959
     (:target-arn m6958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6959 :com.palletops.awaze.client-builder/undef)
     (. bean6957 setTargetARN (clojure.core/str v6959))))
   bean6957))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m6961]
  (clojure.core/let
   [bean6960
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/let
    [v6962
     (:gateway-arn m6961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6962 :com.palletops.awaze.client-builder/undef)
     (. bean6960 setGatewayARN (clojure.core/str v6962))))
   (clojure.core/let
    [v6962
     (:disk-ids m6961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6962 :com.palletops.awaze.client-builder/undef)
     (.
      bean6960
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7122] (clojure.core/str arg7122))
 v6962))))
   bean6960))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m6964]
  (clojure.core/let
   [bean6963
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/let
    [v6965
     (:gateway-arn m6964 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6965 :com.palletops.awaze.client-builder/undef)
     (. bean6963 setGatewayARN (clojure.core/str v6965))))
   bean6963))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m6967]
  (clojure.core/let
   [bean6966
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/let
    [v6968
     (:gateway-arn m6967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6968 :com.palletops.awaze.client-builder/undef)
     (. bean6966 setGatewayARN (clojure.core/str v6968))))
   (clojure.core/let
    [v6968
     (:tape-arn m6967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6968 :com.palletops.awaze.client-builder/undef)
     (. bean6966 setTapeARN (clojure.core/str v6968))))
   bean6966))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m6970]
  (clojure.core/let
   [bean6969
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/let
    [v6971
     (:volume-arn m6970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6971 :com.palletops.awaze.client-builder/undef)
     (. bean6969 setVolumeARN (clojure.core/str v6971))))
   bean6969))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m6973]
  (clojure.core/let
   [bean6972
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/let
    [v6974
     (:client-token m6973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6974 :com.palletops.awaze.client-builder/undef)
     (. bean6972 setClientToken (clojure.core/str v6974))))
   (clojure.core/let
    [v6974
     (:gateway-arn m6973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6974 :com.palletops.awaze.client-builder/undef)
     (. bean6972 setGatewayARN (clojure.core/str v6974))))
   (clojure.core/let
    [v6974
     (:num-tapes-to-create
      m6973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6974 :com.palletops.awaze.client-builder/undef)
     (. bean6972 setNumTapesToCreate (clojure.core/int v6974))))
   (clojure.core/let
    [v6974
     (:tape-size-in-bytes
      m6973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6974 :com.palletops.awaze.client-builder/undef)
     (. bean6972 setTapeSizeInBytes (clojure.core/long v6974))))
   (clojure.core/let
    [v6974
     (:tape-barcode-prefix
      m6973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6974 :com.palletops.awaze.client-builder/undef)
     (. bean6972 setTapeBarcodePrefix (clojure.core/str v6974))))
   bean6972))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m6976]
  (clojure.core/let
   [bean6975
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/let
    [v6977
     (:initiator-name m6976 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6977 :com.palletops.awaze.client-builder/undef)
     (. bean6975 setInitiatorName (clojure.core/str v6977))))
   (clojure.core/let
    [v6977
     (:target-arn m6976 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6977 :com.palletops.awaze.client-builder/undef)
     (. bean6975 setTargetARN (clojure.core/str v6977))))
   bean6975))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m6979]
  (clojure.core/let
   [bean6978
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/let
    [v6980
     (:gateway-arn m6979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6980 :com.palletops.awaze.client-builder/undef)
     (. bean6978 setGatewayARN (clojure.core/str v6980))))
   (clojure.core/let
    [v6980
     (:tape-arn m6979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6980 :com.palletops.awaze.client-builder/undef)
     (. bean6978 setTapeARN (clojure.core/str v6980))))
   bean6978))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m6982]
  (clojure.core/let
   [bean6981
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/let
    [v6983
     (:gateway-arn m6982 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6983 :com.palletops.awaze.client-builder/undef)
     (. bean6981 setGatewayARN (clojure.core/str v6983))))
   (clojure.core/let
    [v6983
     (:tape-arn m6982 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6983 :com.palletops.awaze.client-builder/undef)
     (. bean6981 setTapeARN (clojure.core/str v6983))))
   bean6981))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m6985]
  (clojure.core/let
   [bean6984
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v6986
     (:volume-arn m6985 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6986 :com.palletops.awaze.client-builder/undef)
     (. bean6984 setVolumeARN (clojure.core/str v6986))))
   bean6984))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m6988]
  (clojure.core/let
   [bean6987
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/let
    [v6989
     (:volume-arns m6988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6989 :com.palletops.awaze.client-builder/undef)
     (.
      bean6987
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7123] (clojure.core/str arg7123))
 v6989))))
   bean6987))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m6991]
  (clojure.core/let
   [bean6990
    (new
     com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v6992 (:tags m6991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6992 :com.palletops.awaze.client-builder/undef)
     (.
      bean6990
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7124] (storagegateway/tag arg7124))
 v6992))))
   (clojure.core/let
    [v6992
     (:resource-arn m6991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6992 :com.palletops.awaze.client-builder/undef)
     (. bean6990 setResourceARN (clojure.core/str v6992))))
   bean6990))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m6994]
  (clojure.core/let
   [bean6993
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/let
    [v6995
     (:client-token m6994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6995 :com.palletops.awaze.client-builder/undef)
     (. bean6993 setClientToken (clojure.core/str v6995))))
   (clojure.core/let
    [v6995
     (:network-interface-id
      m6994
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6995 :com.palletops.awaze.client-builder/undef)
     (. bean6993 setNetworkInterfaceId (clojure.core/str v6995))))
   (clojure.core/let
    [v6995
     (:snapshot-id m6994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6995 :com.palletops.awaze.client-builder/undef)
     (. bean6993 setSnapshotId (clojure.core/str v6995))))
   (clojure.core/let
    [v6995
     (:gateway-arn m6994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6995 :com.palletops.awaze.client-builder/undef)
     (. bean6993 setGatewayARN (clojure.core/str v6995))))
   (clojure.core/let
    [v6995
     (:target-name m6994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6995 :com.palletops.awaze.client-builder/undef)
     (. bean6993 setTargetName (clojure.core/str v6995))))
   (clojure.core/let
    [v6995
     (:volume-size-in-bytes
      m6994
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6995 :com.palletops.awaze.client-builder/undef)
     (. bean6993 setVolumeSizeInBytes (clojure.core/long v6995))))
   bean6993))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m6997]
  (clojure.core/let
   [bean6996
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/let
    [v6998
     (:gateway-arn m6997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6998 :com.palletops.awaze.client-builder/undef)
     (. bean6996 setGatewayARN (clojure.core/str v6998))))
   (clojure.core/let
    [v6998
     (:tape-arn m6997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6998 :com.palletops.awaze.client-builder/undef)
     (. bean6996 setTapeARN (clojure.core/str v6998))))
   bean6996))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m7000]
  (clojure.core/let
   [bean6999
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/let
    [v7001
     (:gateway-arn m7000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7001 :com.palletops.awaze.client-builder/undef)
     (. bean6999 setGatewayARN (clojure.core/str v7001))))
   (clojure.core/let
    [v7001
     (:disk-ids m7000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7001 :com.palletops.awaze.client-builder/undef)
     (.
      bean6999
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7125] (clojure.core/str arg7125))
 v7001))))
   bean6999))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m7003]
  (clojure.core/let
   [bean7002
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/let
    [v7004 (:marker m7003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7004 :com.palletops.awaze.client-builder/undef)
     (. bean7002 setMarker (clojure.core/str v7004))))
   (clojure.core/let
    [v7004 (:limit m7003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7004 :com.palletops.awaze.client-builder/undef)
     (. bean7002 setLimit (clojure.core/int v7004))))
   (clojure.core/let
    [v7004
     (:gateway-arn m7003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7004 :com.palletops.awaze.client-builder/undef)
     (. bean7002 setGatewayARN (clojure.core/str v7004))))
   bean7002))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m7006]
  (clojure.core/let
   [bean7005
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/let
    [v7007 (:marker m7006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7007 :com.palletops.awaze.client-builder/undef)
     (. bean7005 setMarker (clojure.core/str v7007))))
   (clojure.core/let
    [v7007 (:limit m7006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7007 :com.palletops.awaze.client-builder/undef)
     (. bean7005 setLimit (clojure.core/int v7007))))
   (clojure.core/let
    [v7007
     (:tape-arns m7006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7007 :com.palletops.awaze.client-builder/undef)
     (.
      bean7005
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7126] (clojure.core/str arg7126))
 v7007))))
   bean7005))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m7009]
  (clojure.core/let
   [bean7008
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/let
    [v7010
     (:gateway-arn m7009 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7010 :com.palletops.awaze.client-builder/undef)
     (. bean7008 setGatewayARN (clojure.core/str v7010))))
   bean7008))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m7012]
  (clojure.core/let
   [bean7011
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/let
    [v7013
     (:gateway-arn m7012 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7013 :com.palletops.awaze.client-builder/undef)
     (. bean7011 setGatewayARN (clojure.core/str v7013))))
   bean7011))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest}
update-vtldevice-type-request
  [m7015]
  (clojure.core/let
   [bean7014
    (new
     com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest)]
   (clojure.core/let
    [v7016
     (:vtldevice-arn m7015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7016 :com.palletops.awaze.client-builder/undef)
     (. bean7014 setVTLDeviceARN (clojure.core/str v7016))))
   (clojure.core/let
    [v7016
     (:device-type m7015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7016 :com.palletops.awaze.client-builder/undef)
     (. bean7014 setDeviceType (clojure.core/str v7016))))
   bean7014))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m7018]
  (clojure.core/let
   [bean7017
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/let
    [v7019 (:marker m7018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7019 :com.palletops.awaze.client-builder/undef)
     (. bean7017 setMarker (clojure.core/str v7019))))
   (clojure.core/let
    [v7019 (:limit m7018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7019 :com.palletops.awaze.client-builder/undef)
     (. bean7017 setLimit (clojure.core/int v7019))))
   (clojure.core/let
    [v7019
     (:gateway-arn m7018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7019 :com.palletops.awaze.client-builder/undef)
     (. bean7017 setGatewayARN (clojure.core/str v7019))))
   bean7017))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m7021]
  (clojure.core/let
   [bean7020
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/let
    [v7022
     (:tape-arn m7021 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7022 :com.palletops.awaze.client-builder/undef)
     (. bean7020 setTapeARN (clojure.core/str v7022))))
   bean7020))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m7024]
  (clojure.core/let
   [bean7023
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7025
     (:gateway-arn m7024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7025 :com.palletops.awaze.client-builder/undef)
     (. bean7023 setGatewayARN (clojure.core/str v7025))))
   (clojure.core/let
    [v7025
     (:bandwidth-type m7024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7025 :com.palletops.awaze.client-builder/undef)
     (. bean7023 setBandwidthType (clojure.core/str v7025))))
   bean7023))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m7027]
  (clojure.core/let
   [bean7026
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/let
    [v7028
     (:gateway-arn m7027 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7028 :com.palletops.awaze.client-builder/undef)
     (. bean7026 setGatewayARN (clojure.core/str v7028))))
   bean7026))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m7030]
  (clojure.core/let
   [bean7029
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/let
    [v7031
     (:gateway-arn m7030 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7031 :com.palletops.awaze.client-builder/undef)
     (. bean7029 setGatewayARN (clojure.core/str v7031))))
   bean7029))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m7033]
  (clojure.core/let
   [bean7032
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/let
    [v7034
     (:activation-key m7033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setActivationKey (clojure.core/str v7034))))
   (clojure.core/let
    [v7034
     (:gateway-name m7033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setGatewayName (clojure.core/str v7034))))
   (clojure.core/let
    [v7034
     (:gateway-timezone
      m7033
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setGatewayTimezone (clojure.core/str v7034))))
   (clojure.core/let
    [v7034
     (:gateway-region m7033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setGatewayRegion (clojure.core/str v7034))))
   (clojure.core/let
    [v7034
     (:gateway-type m7033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setGatewayType (clojure.core/str v7034))))
   (clojure.core/let
    [v7034
     (:tape-drive-type
      m7033
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setTapeDriveType (clojure.core/str v7034))))
   (clojure.core/let
    [v7034
     (:medium-changer-type
      m7033
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7034 :com.palletops.awaze.client-builder/undef)
     (. bean7032 setMediumChangerType (clojure.core/str v7034))))
   bean7032))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m7036]
  (clojure.core/let
   [bean7035
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7037
     (:gateway-arn m7036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7037 :com.palletops.awaze.client-builder/undef)
     (. bean7035 setGatewayARN (clojure.core/str v7037))))
   bean7035))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m7039]
  (clojure.core/let
   [bean7038
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7040
     (:gateway-arn m7039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7040 :com.palletops.awaze.client-builder/undef)
     (. bean7038 setGatewayARN (clojure.core/str v7040))))
   bean7038))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m7042]
  (clojure.core/let
   [bean7041
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/let
    [v7043 (:marker m7042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7043 :com.palletops.awaze.client-builder/undef)
     (. bean7041 setMarker (clojure.core/str v7043))))
   (clojure.core/let
    [v7043 (:limit m7042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7043 :com.palletops.awaze.client-builder/undef)
     (. bean7041 setLimit (clojure.core/int v7043))))
   (clojure.core/let
    [v7043
     (:gateway-arn m7042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7043 :com.palletops.awaze.client-builder/undef)
     (. bean7041 setGatewayARN (clojure.core/str v7043))))
   (clojure.core/let
    [v7043
     (:tape-arns m7042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7043 :com.palletops.awaze.client-builder/undef)
     (.
      bean7041
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7127] (clojure.core/str arg7127))
 v7043))))
   bean7041))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m7045]
  (clojure.core/let
   [bean7044
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/let
    [v7046
     (:gateway-arn m7045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7046 :com.palletops.awaze.client-builder/undef)
     (. bean7044 setGatewayARN (clojure.core/str v7046))))
   bean7044))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m7048]
  (clojure.core/let
   [bean7047
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/let
    [v7049
     (:recurrence-in-hours
      m7048
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7049 :com.palletops.awaze.client-builder/undef)
     (. bean7047 setRecurrenceInHours (clojure.core/int v7049))))
   (clojure.core/let
    [v7049
     (:start-at m7048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7049 :com.palletops.awaze.client-builder/undef)
     (. bean7047 setStartAt (clojure.core/int v7049))))
   (clojure.core/let
    [v7049
     (:description m7048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7049 :com.palletops.awaze.client-builder/undef)
     (. bean7047 setDescription (clojure.core/str v7049))))
   (clojure.core/let
    [v7049
     (:volume-arn m7048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7049 :com.palletops.awaze.client-builder/undef)
     (. bean7047 setVolumeARN (clojure.core/str v7049))))
   bean7047))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m7051]
  (clojure.core/let
   [bean7050
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7052
     (:average-upload-rate-limit-in-bits-per-sec
      m7051
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7052 :com.palletops.awaze.client-builder/undef)
     (.
      bean7050
      setAverageUploadRateLimitInBitsPerSec
      (clojure.core/long v7052))))
   (clojure.core/let
    [v7052
     (:average-download-rate-limit-in-bits-per-sec
      m7051
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7052 :com.palletops.awaze.client-builder/undef)
     (.
      bean7050
      setAverageDownloadRateLimitInBitsPerSec
      (clojure.core/long v7052))))
   (clojure.core/let
    [v7052
     (:gateway-arn m7051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7052 :com.palletops.awaze.client-builder/undef)
     (. bean7050 setGatewayARN (clojure.core/str v7052))))
   bean7050))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m7054]
  (clojure.core/let
   [bean7053
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/let
    [v7055
     (:gateway-arn m7054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7055 :com.palletops.awaze.client-builder/undef)
     (. bean7053 setGatewayARN (clojure.core/str v7055))))
   bean7053))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m7057]
  (clojure.core/let
   [bean7056
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/let
    [v7058
     (:network-interface-id
      m7057
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7058 :com.palletops.awaze.client-builder/undef)
     (. bean7056 setNetworkInterfaceId (clojure.core/str v7058))))
   (clojure.core/let
    [v7058
     (:snapshot-id m7057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7058 :com.palletops.awaze.client-builder/undef)
     (. bean7056 setSnapshotId (clojure.core/str v7058))))
   (clojure.core/let
    [v7058
     (:gateway-arn m7057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7058 :com.palletops.awaze.client-builder/undef)
     (. bean7056 setGatewayARN (clojure.core/str v7058))))
   (clojure.core/let
    [v7058
     (:target-name m7057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7058 :com.palletops.awaze.client-builder/undef)
     (. bean7056 setTargetName (clojure.core/str v7058))))
   (clojure.core/let
    [v7058
     (:preserve-existing-data
      m7057
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7058 :com.palletops.awaze.client-builder/undef)
     (. bean7056 setPreserveExistingData (clojure.core/boolean v7058))))
   (clojure.core/let
    [v7058 (:disk-id m7057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7058 :com.palletops.awaze.client-builder/undef)
     (. bean7056 setDiskId (clojure.core/str v7058))))
   bean7056))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m7060]
  (clojure.core/let
   [bean7059
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/let
    [v7061
     (:gateway-arn m7060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7061 :com.palletops.awaze.client-builder/undef)
     (. bean7059 setGatewayARN (clojure.core/str v7061))))
   (clojure.core/let
    [v7061
     (:gateway-name m7060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7061 :com.palletops.awaze.client-builder/undef)
     (. bean7059 setGatewayName (clojure.core/str v7061))))
   (clojure.core/let
    [v7061
     (:gateway-timezone
      m7060
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7061 :com.palletops.awaze.client-builder/undef)
     (. bean7059 setGatewayTimezone (clojure.core/str v7061))))
   bean7059))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m7063]
  (clojure.core/let
   [bean7062
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/let
    [v7064
     (:volume-arn m7063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7064 :com.palletops.awaze.client-builder/undef)
     (. bean7062 setVolumeARN (clojure.core/str v7064))))
   bean7062))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m7066]
  (clojure.core/let
   [bean7065
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/let
    [v7067
     (:gateway-arn m7066 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7067 :com.palletops.awaze.client-builder/undef)
     (. bean7065 setGatewayARN (clojure.core/str v7067))))
   bean7065))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m7069]
  (clojure.core/let
   [bean7068
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/let
    [v7070
     (:target-arn m7069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7070 :com.palletops.awaze.client-builder/undef)
     (. bean7068 setTargetARN (clojure.core/str v7070))))
   bean7068))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m7072]
  (clojure.core/let
   [bean7071
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/let
    [v7073
     (:gateway-arn m7072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7073 :com.palletops.awaze.client-builder/undef)
     (. bean7071 setGatewayARN (clojure.core/str v7073))))
   bean7071))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m7075]
  (clojure.core/let
   [bean7074
    (new
     com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v7076
     (:tag-keys m7075 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7076 :com.palletops.awaze.client-builder/undef)
     (.
      bean7074
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7128] (clojure.core/str arg7128))
 v7076))))
   (clojure.core/let
    [v7076
     (:resource-arn m7075 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7076 :com.palletops.awaze.client-builder/undef)
     (. bean7074 setResourceARN (clojure.core/str v7076))))
   bean7074))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest}
create-tape-with-barcode-request
  [m7078]
  (clojure.core/let
   [bean7077
    (new
     com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest)]
   (clojure.core/let
    [v7079
     (:gateway-arn m7078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7079 :com.palletops.awaze.client-builder/undef)
     (. bean7077 setGatewayARN (clojure.core/str v7079))))
   (clojure.core/let
    [v7079
     (:tape-barcode m7078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7079 :com.palletops.awaze.client-builder/undef)
     (. bean7077 setTapeBarcode (clojure.core/str v7079))))
   (clojure.core/let
    [v7079
     (:tape-size-in-bytes
      m7078
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7079 :com.palletops.awaze.client-builder/undef)
     (. bean7077 setTapeSizeInBytes (clojure.core/long v7079))))
   bean7077))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m7081]
  (clojure.core/let
   [bean7080
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/let
    [v7082
     (:gateway-arn m7081 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7082 :com.palletops.awaze.client-builder/undef)
     (. bean7080 setGatewayARN (clojure.core/str v7082))))
   (clojure.core/let
    [v7082
     (:disk-ids m7081 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7082 :com.palletops.awaze.client-builder/undef)
     (.
      bean7080
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7129] (clojure.core/str arg7129))
 v7082))))
   bean7080))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m7084]
  (clojure.core/let
   [bean7083
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/let
    [v7085 (:marker m7084 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7085 :com.palletops.awaze.client-builder/undef)
     (. bean7083 setMarker (clojure.core/str v7085))))
   (clojure.core/let
    [v7085 (:limit m7084 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7085 :com.palletops.awaze.client-builder/undef)
     (. bean7083 setLimit (clojure.core/int v7085))))
   bean7083))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m7087]
  (clojure.core/let
   [bean7086
    (new
     com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v7088 (:marker m7087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7088 :com.palletops.awaze.client-builder/undef)
     (. bean7086 setMarker (clojure.core/str v7088))))
   (clojure.core/let
    [v7088 (:limit m7087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7088 :com.palletops.awaze.client-builder/undef)
     (. bean7086 setLimit (clojure.core/int v7088))))
   (clojure.core/let
    [v7088
     (:resource-arn m7087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7088 :com.palletops.awaze.client-builder/undef)
     (. bean7086 setResourceARN (clojure.core/str v7088))))
   bean7086))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m7090]
  (clojure.core/let
   [bean7089
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/let
    [v7091
     (:gateway-arn m7090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7091 :com.palletops.awaze.client-builder/undef)
     (. bean7089 setGatewayARN (clojure.core/str v7091))))
   (clojure.core/let
    [v7091
     (:tape-arn m7090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7091 :com.palletops.awaze.client-builder/undef)
     (. bean7089 setTapeARN (clojure.core/str v7091))))
   bean7089))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m7093]
  (clojure.core/let
   [bean7092
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7094
     (:hour-of-day m7093 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7094 :com.palletops.awaze.client-builder/undef)
     (. bean7092 setHourOfDay (clojure.core/int v7094))))
   (clojure.core/let
    [v7094
     (:minute-of-hour m7093 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7094 :com.palletops.awaze.client-builder/undef)
     (. bean7092 setMinuteOfHour (clojure.core/int v7094))))
   (clojure.core/let
    [v7094
     (:day-of-week m7093 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7094 :com.palletops.awaze.client-builder/undef)
     (. bean7092 setDayOfWeek (clojure.core/int v7094))))
   (clojure.core/let
    [v7094
     (:gateway-arn m7093 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7094 :com.palletops.awaze.client-builder/undef)
     (. bean7092 setGatewayARN (clojure.core/str v7094))))
   bean7092))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ResetCacheRequest}
reset-cache-request
  [m7096]
  (clojure.core/let
   [bean7095
    (new
     com.amazonaws.services.storagegateway.model.ResetCacheRequest)]
   (clojure.core/let
    [v7097
     (:gateway-arn m7096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7097 :com.palletops.awaze.client-builder/undef)
     (. bean7095 setGatewayARN (clojure.core/str v7097))))
   bean7095))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m7099]
  (clojure.core/let
   [bean7098
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/let
    [v7100 (:marker m7099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7100 :com.palletops.awaze.client-builder/undef)
     (. bean7098 setMarker (clojure.core/str v7100))))
   (clojure.core/let
    [v7100 (:limit m7099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7100 :com.palletops.awaze.client-builder/undef)
     (. bean7098 setLimit (clojure.core/int v7100))))
   (clojure.core/let
    [v7100
     (:gateway-arn m7099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7100 :com.palletops.awaze.client-builder/undef)
     (. bean7098 setGatewayARN (clojure.core/str v7100))))
   (clojure.core/let
    [v7100
     (:vtldevice-arns m7099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7100 :com.palletops.awaze.client-builder/undef)
     (.
      bean7098
      setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7178] (clojure.core/str arg7178))
 v7100))))
   bean7098))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m7102]
  (clojure.core/let
   [bean7101
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/let
    [v7103
     (:volume-arns m7102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7103 :com.palletops.awaze.client-builder/undef)
     (.
      bean7101
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7179] (clojure.core/str arg7179))
 v7103))))
   bean7101))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest}
set-local-console-password-request
  [m7105]
  (clojure.core/let
   [bean7104
    (new
     com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest)]
   (clojure.core/let
    [v7106
     (:local-console-password
      m7105
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7106 :com.palletops.awaze.client-builder/undef)
     (. bean7104 setLocalConsolePassword (clojure.core/str v7106))))
   (clojure.core/let
    [v7106
     (:gateway-arn m7105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7106 :com.palletops.awaze.client-builder/undef)
     (. bean7104 setGatewayARN (clojure.core/str v7106))))
   bean7104))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m7108]
  (clojure.core/let
   [bean7107
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/let
    [v7109
     (:volume-arn m7108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7109 :com.palletops.awaze.client-builder/undef)
     (. bean7107 setVolumeARN (clojure.core/str v7109))))
   (clojure.core/let
    [v7109
     (:snapshot-description
      m7108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7109 :com.palletops.awaze.client-builder/undef)
     (. bean7107 setSnapshotDescription (clojure.core/str v7109))))
   bean7107))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m7111]
  (clojure.core/let
   [bean7110
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v7112
     (:volume-arn m7111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7112 :com.palletops.awaze.client-builder/undef)
     (. bean7110 setVolumeARN (clojure.core/str v7112))))
   (clojure.core/let
    [v7112
     (:snapshot-description
      m7111
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7112 :com.palletops.awaze.client-builder/undef)
     (. bean7110 setSnapshotDescription (clojure.core/str v7112))))
   bean7110))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m7114]
  (clojure.core/let
   [bean7113
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/let
    [v7115
     (:gateway-arn m7114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7115 :com.palletops.awaze.client-builder/undef)
     (. bean7113 setGatewayARN (clojure.core/str v7115))))
   bean7113))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest}
list-volume-initiators-request
  [m7117]
  (clojure.core/let
   [bean7116
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest)]
   (clojure.core/let
    [v7118
     (:volume-arn m7117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7118 :com.palletops.awaze.client-builder/undef)
     (. bean7116 setVolumeARN (clojure.core/str v7118))))
   bean7116))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m7120]
  (clojure.core/let
   [bean7119
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/let
    [v7121
     (:gateway-arn m7120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7121 :com.palletops.awaze.client-builder/undef)
     (. bean7119 setGatewayARN (clojure.core/str v7121))))
   bean7119))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m7130]
   (clojure.core/let
    [credentials7131 (:credentials m7130) args7132 (:args m7130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7133
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7131)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7133
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args7132 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-chap-credentials,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Call updateChapCredentials"}
   [credentials7135 & args7136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7137
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7135)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7137
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args7136 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m7138]
   (clojure.core/let
    [credentials7139 (:credentials m7138) args7140 (:args m7138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7141
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7139)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7141
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args7140 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-working-storage,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addWorkingStorage"}
   [credentials7143 & args7144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7145
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7143)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7145
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args7144 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m7146]
   (clojure.core/let
    [credentials7147 (:credentials m7146) args7148 (:args m7146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7149
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7147)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7149
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args7148 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-gateway-information,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials7151 & args7152]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7153
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7151)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7153
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args7152 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m7154]
   (clojure.core/let
    [credentials7155 (:credentials m7154) args7156 (:args m7154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7157
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7155)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7157
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args7156 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-tape,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteTape"}
   [credentials7159 & args7160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7161
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7159)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7161
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args7160 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m7162]
   (clojure.core/let
    [credentials7163 (:credentials m7162) args7164 (:args m7162)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7165
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7163)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7165
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args7164 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-snapshot-schedule,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials7167 & args7168]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7169
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7167)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7169
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args7168 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m7170]
   (clojure.core/let
    [credentials7171 (:credentials m7170) args7172 (:args m7170)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7173
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7171)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7173
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args7172 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-tapes,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Call createTapes"}
   [credentials7175 & args7176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7177
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7175)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7177
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args7176 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m7180]
   (clojure.core/let
    [credentials7181 (:credentials m7180) args7182 (:args m7180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7183
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7181)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7183
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args7182 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-chap-credentials,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials7185 & args7186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7187
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7185)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7187
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args7186 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m7188]
   (clojure.core/let
    [credentials7189 (:credentials m7188) args7190 (:args m7188)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7191
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7189)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7191
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args7190 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-archival,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelArchival"}
   [credentials7193 & args7194]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7195
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7193)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7195
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args7194 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m7196]
   (clojure.core/let
    [credentials7197 (:credentials m7196) args7198 (:args m7196)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7199
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7197)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7199
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args7198 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-retrieval,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelRetrieval"}
   [credentials7201 & args7202]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7203
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7201)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7203
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args7202 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m7204]
   (clojure.core/let
    [credentials7205 (:credentials m7204) args7206 (:args m7204)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7207
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7205)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7207
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args7206 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials7209 & args7210]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7211
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7209)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7211
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args7210 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m7212]
   (clojure.core/let
    [credentials7213 (:credentials m7212) args7214 (:args m7212)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7215
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7213)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7215
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args7214 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials7217 & args7218]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7219
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7217)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7219
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args7218 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-tags-to-resource
   [m7220]
   (clojure.core/let
    [credentials7221 (:credentials m7220) args7222 (:args m7220)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7223
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7221)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7223
       addTagsToResource
       (storagegateway/add-tags-to-resource-request
        (clojure.core/nth args7222 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials7225 & args7226]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7227
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7225)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7227
      addTagsToResource
      (storagegateway/add-tags-to-resource-request
       (clojure.core/nth args7226 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m7228]
   (clojure.core/let
    [credentials7229 (:credentials m7228) args7230 (:args m7228)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7231
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7229)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7231
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args7230 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials7233 & args7234]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7235
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7233)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7235
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args7234 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m7236]
   (clojure.core/let
    [credentials7237 (:credentials m7236) args7238 (:args m7236)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7239
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7237)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7239
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args7238 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :retrieve-tape-archive,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials7241 & args7242]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7243
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7241)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7243
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args7242 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m7244]
   (clojure.core/let
    [credentials7245 (:credentials m7244) args7246 (:args m7244)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7247
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7245)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7247
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args7246 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-upload-buffer,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addUploadBuffer"}
   [credentials7249 & args7250]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7251
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7249)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7251
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args7250 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m7252]
   (clojure.core/let
    [credentials7253 (:credentials m7252) args7254 (:args m7252)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7255
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7253)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7255
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args7254 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-volumes,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumes"}
   [credentials7257 & args7258]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7259
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7257)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7259
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args7258 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m7260]
   (clojure.core/let
    [credentials7261 (:credentials m7260) args7262 (:args m7260)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7263
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7261)]
     (clojure.core/case
      (clojure.core/count args7262)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7263
        describeTapeArchives))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7263
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args7262 0))))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-tape-archives,
     :credentials credentials__1784__auto__,
     :client :storagegateway})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tape-archives,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials7265 & args7266]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7267
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7265)]
    (clojure.core/case
     (clojure.core/count args7266)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7267
       describeTapeArchives))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7267
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args7266 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m7268]
   (clojure.core/let
    [credentials7269 (:credentials m7268) args7270 (:args m7268)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7271
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7269)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7271
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args7270 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-upload-buffer,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials7273 & args7274]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7275
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7273)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7275
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args7274 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m7276]
   (clojure.core/let
    [credentials7277 (:credentials m7276) args7278 (:args m7276)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7279
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7277)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7279
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args7278 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-local-disks,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listLocalDisks"}
   [credentials7281 & args7282]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7283
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7281)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7283
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args7282 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-vtldevice-type
   [m7284]
   (clojure.core/let
    [credentials7285 (:credentials m7284) args7286 (:args m7284)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7287
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7285)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7287
       updateVTLDeviceType
       (storagegateway/update-vtldevice-type-request
        (clojure.core/nth args7286 0)))))))
  (clojure.core/defn
   update-vtldevice-type-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateVTLDeviceType"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-vtldevice-type,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-vtldevice-type
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateVTLDeviceType"}
   [credentials7289 & args7290]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7291
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7289)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7291
      updateVTLDeviceType
      (storagegateway/update-vtldevice-type-request
       (clojure.core/nth args7290 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m7292]
   (clojure.core/let
    [credentials7293 (:credentials m7292) args7294 (:args m7292)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7295
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7293)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7295
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args7294 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tape-recovery-points,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials7297 & args7298]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7299
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7297)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7299
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args7298 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m7300]
   (clojure.core/let
    [credentials7301 (:credentials m7300) args7302 (:args m7300)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7303
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7301)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7303
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args7302 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-tape-archive,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials7305 & args7306]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7307
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7305)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7307
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args7306 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m7308]
   (clojure.core/let
    [credentials7309 (:credentials m7308) args7310 (:args m7308)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7311
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7309)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7311
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args7310 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials7313 & args7314]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7315
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7313)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7315
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args7314 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m7316]
   (clojure.core/let
    [credentials7317 (:credentials m7316) args7318 (:args m7316)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7319
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7317)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7319
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args7318 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-gateway,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call disableGateway"}
   [credentials7321 & args7322]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7323
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7321)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7323
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args7322 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m7324]
   (clojure.core/let
    [credentials7325 (:credentials m7324) args7326 (:args m7324)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7327
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7325)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7327
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args7326 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-gateway,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteGateway"}
   [credentials7329 & args7330]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7331
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7329)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7331
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args7330 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m7332]
   (clojure.core/let
    [credentials7333 (:credentials m7332) args7334 (:args m7332)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7335
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7333)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7335
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args7334 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :activate-gateway,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call activateGateway"}
   [credentials7337 & args7338]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7339
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7337)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7339
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args7338 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m7340]
   (clojure.core/let
    [credentials7341 (:credentials m7340) args7342 (:args m7340)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7343
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7341)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7343
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args7342 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-maintenance-start-time,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials7345 & args7346]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7347
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7345)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7347
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args7346 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m7348]
   (clojure.core/let
    [credentials7349 (:credentials m7348) args7350 (:args m7348)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7351
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7349)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7351
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args7350 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials7353 & args7354]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7355
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7353)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7355
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args7354 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m7356]
   (clojure.core/let
    [credentials7357 (:credentials m7356) args7358 (:args m7356)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7359
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7357)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7359
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args7358 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tapes,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapes"}
   [credentials7361 & args7362]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7363
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7361)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7363
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args7362 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m7364]
   (clojure.core/let
    [credentials7365 (:credentials m7364) args7366 (:args m7364)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7367
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7365)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7367
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args7366 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :start-gateway,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call startGateway"}
   [credentials7369 & args7370]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7371
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7369)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7371
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args7370 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m7372]
   (clojure.core/let
    [credentials7373 (:credentials m7372) args7374 (:args m7372)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7375
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7373)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7375
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args7374 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-snapshot-schedule,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials7377 & args7378]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7379
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7377)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7379
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args7378 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m7380]
   (clojure.core/let
    [credentials7381 (:credentials m7380) args7382 (:args m7380)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7383
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7381)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7383
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args7382 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials7385 & args7386]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7387
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7385)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7387
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args7386 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m7388]
   (clojure.core/let
    [credentials7389 (:credentials m7388) args7390 (:args m7388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7391
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7389)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7391
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args7390 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-gateway-software-now,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials7393 & args7394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7395
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7393)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7395
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args7394 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m7396]
   (clojure.core/let
    [credentials7397 (:credentials m7396) args7398 (:args m7396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7399
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7397)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7399
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args7398 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-storedi-scsivolume,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials7401 & args7402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7403
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7401)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7403
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args7402 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m7404]
   (clojure.core/let
    [credentials7405 (:credentials m7404) args7406 (:args m7404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7407
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7407
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args7406 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-gateway-information,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials7409 & args7410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7411
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7411
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args7410 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m7412]
   (clojure.core/let
    [credentials7413 (:credentials m7412) args7414 (:args m7412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7415
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7413)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7415
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args7414 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-snapshot-schedule,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials7417 & args7418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7419
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7417)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7419
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args7418 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m7420]
   (clojure.core/let
    [credentials7421 (:credentials m7420) args7422 (:args m7420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7423
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7423
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args7422 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeCache"}
   [credentials7425 & args7426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7427
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7427
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args7426 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m7428]
   (clojure.core/let
    [credentials7429 (:credentials m7428) args7430 (:args m7428)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7431
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7429)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7431
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args7430 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-chap-credentials,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call describeChapCredentials"}
   [credentials7433 & args7434]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7435
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7433)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7435
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args7434 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m7436]
   (clojure.core/let
    [credentials7437 (:credentials m7436) args7438 (:args m7436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7439
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7439
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args7438 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-volume-recovery-points,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials7441 & args7442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7443
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7443
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args7442 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :remove-tags-from-resource
   [m7444]
   (clojure.core/let
    [credentials7445 (:credentials m7444) args7446 (:args m7444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7447
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7445)]
     (clojure.core/case
      (clojure.core/count args7446)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7447
        removeTagsFromResource
        (storagegateway/remove-tags-from-resource-request
         (clojure.core/nth args7446 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7447
        removeTagsFromResource))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for removeTagsFromResource, removeTagsFromResource"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :remove-tags-from-resource,
     :credentials credentials__1784__auto__,
     :client :storagegateway})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call removeTagsFromResource, removeTagsFromResource"}
   [credentials7449 & args7450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7451
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7449)]
    (clojure.core/case
     (clojure.core/count args7450)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7451
       removeTagsFromResource
       (storagegateway/remove-tags-from-resource-request
        (clojure.core/nth args7450 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7451
       removeTagsFromResource))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tape-with-barcode
   [m7452]
   (clojure.core/let
    [credentials7453 (:credentials m7452) args7454 (:args m7452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7455
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7455
       createTapeWithBarcode
       (storagegateway/create-tape-with-barcode-request
        (clojure.core/nth args7454 0)))))))
  (clojure.core/defn
   create-tape-with-barcode-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for createTapeWithBarcode"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-tape-with-barcode,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tape-with-barcode
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Call createTapeWithBarcode"}
   [credentials7457 & args7458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7459
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7459
      createTapeWithBarcode
      (storagegateway/create-tape-with-barcode-request
       (clojure.core/nth args7458 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m7460]
   (clojure.core/let
    [credentials7461 (:credentials m7460) args7462 (:args m7460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7463
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7461)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7463
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args7462 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-cache,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addCache"}
   [credentials7465 & args7466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7467
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7465)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7467
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args7466 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m7468]
   (clojure.core/let
    [credentials7469 (:credentials m7468) args7470 (:args m7468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7471
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7469)]
     (clojure.core/case
      (clojure.core/count args7470)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7471
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args7470 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7471
        listGateways))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-gateways,
     :credentials credentials__1784__auto__,
     :client :storagegateway})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-gateways,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGateways, listGateways"}
   [credentials7473 & args7474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7475
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7473)]
    (clojure.core/case
     (clojure.core/count args7474)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7475
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args7474 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7475
       listGateways))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-tags-for-resource
   [m7476]
   (clojure.core/let
    [credentials7477 (:credentials m7476) args7478 (:args m7476)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7479
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7477)]
     (clojure.core/case
      (clojure.core/count args7478)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7479
        listTagsForResource
        (storagegateway/list-tags-for-resource-request
         (clojure.core/nth args7478 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7479
        listTagsForResource))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTagsForResource, listTagsForResource"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-tags-for-resource,
     :credentials credentials__1784__auto__,
     :client :storagegateway})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTagsForResource, listTagsForResource"}
   [credentials7481 & args7482]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7483
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7481)]
    (clojure.core/case
     (clojure.core/count args7482)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7483
       listTagsForResource
       (storagegateway/list-tags-for-resource-request
        (clojure.core/nth args7482 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7483
       listTagsForResource))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m7484]
   (clojure.core/let
    [credentials7485 (:credentials m7484) args7486 (:args m7484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7487
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7485)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7487
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args7486 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials7489 & args7490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7491
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7489)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7491
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args7490 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m7492]
   (clojure.core/let
    [credentials7493 (:credentials m7492) args7494 (:args m7492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7495
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7495
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args7494 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-maintenance-start-time,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials7497 & args7498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7499
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7499
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args7498 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :reset-cache
   [m7500]
   (clojure.core/let
    [credentials7501 (:credentials m7500) args7502 (:args m7500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7503
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7501)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7503
       resetCache
       (storagegateway/reset-cache-request
        (clojure.core/nth args7502 0)))))))
  (clojure.core/defn
   reset-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for resetCache"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-cache,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   reset-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call resetCache"}
   [credentials7505 & args7506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7507
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7505)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7507
      resetCache
      (storagegateway/reset-cache-request
       (clojure.core/nth args7506 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m7508]
   (clojure.core/let
    [credentials7509 (:credentials m7508) args7510 (:args m7508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7511
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7511
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args7510 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vtldevices,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeVTLDevices"}
   [credentials7513 & args7514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7515
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7515
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args7514 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m7516]
   (clojure.core/let
    [credentials7517 (:credentials m7516) args7518 (:args m7516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7519
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7517)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7519
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args7518 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials7521 & args7522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7523
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7521)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7523
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args7522 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :set-local-console-password
   [m7524]
   (clojure.core/let
    [credentials7525 (:credentials m7524) args7526 (:args m7524)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7527
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7525)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7527
       setLocalConsolePassword
       (storagegateway/set-local-console-password-request
        (clojure.core/nth args7526 0)))))))
  (clojure.core/defn
   set-local-console-password-map
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for setLocalConsolePassword"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-local-console-password,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   set-local-console-password
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call setLocalConsolePassword"}
   [credentials7529 & args7530]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7531
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7529)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7531
      setLocalConsolePassword
      (storagegateway/set-local-console-password-request
       (clojure.core/nth args7530 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m7532]
   (clojure.core/let
    [credentials7533 (:credentials m7532) args7534 (:args m7532)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7535
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7533)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7535
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args7534 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials7537 & args7538]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7539
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7537)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7539
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args7538 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m7540]
   (clojure.core/let
    [credentials7541 (:credentials m7540) args7542 (:args m7540)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7543
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7541)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7543
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args7542 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials7545 & args7546]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7547
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7545)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7547
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args7546 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m7548]
   (clojure.core/let
    [credentials7549 (:credentials m7548) args7550 (:args m7548)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7551
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7549)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7551
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args7550 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-working-storage,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials7553 & args7554]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7555
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7553)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7555
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args7554 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-initiators
   [m7556]
   (clojure.core/let
    [credentials7557 (:credentials m7556) args7558 (:args m7556)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7559
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7557)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7559
       listVolumeInitiators
       (storagegateway/list-volume-initiators-request
        (clojure.core/nth args7558 0)))))))
  (clojure.core/defn
   list-volume-initiators-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVolumeInitiators"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-volume-initiators,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-initiators
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVolumeInitiators"}
   [credentials7561 & args7562]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7563
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7561)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7563
      listVolumeInitiators
      (storagegateway/list-volume-initiators-request
       (clojure.core/nth args7562 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m7564]
   (clojure.core/let
    [credentials7565 (:credentials m7564) args7566 (:args m7564)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7567
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7565)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7567
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args7566 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :shutdown-gateway,
     :credentials credentials__1784__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call shutdownGateway"}
   [credentials7569 & args7570]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7571
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7569)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7571
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args7570 0))))))))
