(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8440]
  (clojure.core/let
   [bean8439
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/let
    [v8441
     (:string-list-values
      m8440
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8441 :com.palletops.awaze.client-builder/undef)
     (.
      bean8439
      setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8502] (clojure.core/str arg8502))
 v8441))))
   (clojure.core/let
    [v8441
     (:binary-list-values
      m8440
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8441 :com.palletops.awaze.client-builder/undef)
     (.
      bean8439
      setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8503] (clojure.core/identity arg8503))
 v8441))))
   (clojure.core/let
    [v8441
     (:data-type m8440 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8441 :com.palletops.awaze.client-builder/undef)
     (. bean8439 setDataType (clojure.core/str v8441))))
   (clojure.core/let
    [v8441
     (:string-value m8440 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8441 :com.palletops.awaze.client-builder/undef)
     (. bean8439 setStringValue (clojure.core/str v8441))))
   (clojure.core/let
    [v8441
     (:binary-value m8440 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8441 :com.palletops.awaze.client-builder/undef)
     (. bean8439 setBinaryValue (clojure.core/identity v8441))))
   bean8439))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8443]
  (clojure.core/let
   [bean8442
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/let
    [v8444
     (:receipt-handle m8443 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8444 :com.palletops.awaze.client-builder/undef)
     (. bean8442 setReceiptHandle (clojure.core/str v8444))))
   (clojure.core/let
    [v8444
     (:visibility-timeout
      m8443
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8444 :com.palletops.awaze.client-builder/undef)
     (. bean8442 setVisibilityTimeout (clojure.core/int v8444))))
   (clojure.core/let
    [v8444 (:id m8443 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8444 :com.palletops.awaze.client-builder/undef)
     (. bean8442 setId (clojure.core/str v8444))))
   bean8442))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8446]
  (clojure.core/let
   [bean8445
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/let
    [v8447
     (:receipt-handle m8446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8447 :com.palletops.awaze.client-builder/undef)
     (. bean8445 setReceiptHandle (clojure.core/str v8447))))
   (clojure.core/let
    [v8447 (:id m8446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8447 :com.palletops.awaze.client-builder/undef)
     (. bean8445 setId (clojure.core/str v8447))))
   bean8445))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8449]
  (clojure.core/let
   [bean8448
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/let
    [v8450
     (:message-body m8449 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8450 :com.palletops.awaze.client-builder/undef)
     (. bean8448 setMessageBody (clojure.core/str v8450))))
   (clojure.core/let
    [v8450
     (:delay-seconds m8449 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8450 :com.palletops.awaze.client-builder/undef)
     (. bean8448 setDelaySeconds (clojure.core/int v8450))))
   (clojure.core/let
    [v8450 (:id m8449 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8450 :com.palletops.awaze.client-builder/undef)
     (. bean8448 setId (clojure.core/str v8450))))
   (clojure.core/let
    [v8450
     (:message-attributes
      m8449
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8450 :com.palletops.awaze.client-builder/undef)
     (.
      bean8448
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8504] (clojure.core/str arg8504))
  (clojure.core/keys v8450))
 (clojure.core/map
  (clojure.core/fn [arg8504] (sqs/message-attribute-value arg8504))
  (clojure.core/vals v8450))))))
   bean8448))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8452]
  (clojure.core/let
   [bean8451
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/let
    [v8453
     (:queue-name m8452 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8453 :com.palletops.awaze.client-builder/undef)
     (. bean8451 setQueueName (clojure.core/str v8453))))
   (clojure.core/let
    [v8453
     (:queue-owner-awsaccount-id
      m8452
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8453 :com.palletops.awaze.client-builder/undef)
     (. bean8451 setQueueOwnerAWSAccountId (clojure.core/str v8453))))
   bean8451))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8455]
  (clojure.core/let
   [bean8454
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/let
    [v8456
     (:queue-name m8455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8456 :com.palletops.awaze.client-builder/undef)
     (. bean8454 setQueueName (clojure.core/str v8456))))
   (clojure.core/let
    [v8456
     (:attributes m8455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8456 :com.palletops.awaze.client-builder/undef)
     (.
      bean8454
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8505] (clojure.core/str arg8505))
  (clojure.core/keys v8456))
 (clojure.core/map
  (clojure.core/fn [arg8505] (clojure.core/str arg8505))
  (clojure.core/vals v8456))))))
   bean8454))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8458]
  (clojure.core/let
   [bean8457
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/let
    [v8459
     (:queue-url m8458 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8459 :com.palletops.awaze.client-builder/undef)
     (. bean8457 setQueueUrl (clojure.core/str v8459))))
   bean8457))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8461]
  (clojure.core/let
   [bean8460
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/let
    [v8462
     (:queue-url m8461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8462 :com.palletops.awaze.client-builder/undef)
     (. bean8460 setQueueUrl (clojure.core/str v8462))))
   (clojure.core/let
    [v8462 (:label m8461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8462 :com.palletops.awaze.client-builder/undef)
     (. bean8460 setLabel (clojure.core/str v8462))))
   bean8460))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8464]
  (clojure.core/let
   [bean8463
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/let
    [v8465
     (:queue-url m8464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8465 :com.palletops.awaze.client-builder/undef)
     (. bean8463 setQueueUrl (clojure.core/str v8465))))
   (clojure.core/let
    [v8465
     (:attributes m8464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8465 :com.palletops.awaze.client-builder/undef)
     (.
      bean8463
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8506] (clojure.core/str arg8506))
  (clojure.core/keys v8465))
 (clojure.core/map
  (clojure.core/fn [arg8506] (clojure.core/str arg8506))
  (clojure.core/vals v8465))))))
   bean8463))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8467]
  (clojure.core/let
   [bean8466
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/let
    [v8468
     (:visibility-timeout
      m8467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8468 :com.palletops.awaze.client-builder/undef)
     (. bean8466 setVisibilityTimeout (clojure.core/int v8468))))
   (clojure.core/let
    [v8468
     (:queue-url m8467 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8468 :com.palletops.awaze.client-builder/undef)
     (. bean8466 setQueueUrl (clojure.core/str v8468))))
   (clojure.core/let
    [v8468
     (:message-attribute-names
      m8467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8468 :com.palletops.awaze.client-builder/undef)
     (.
      bean8466
      setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8507] (clojure.core/str arg8507))
 v8468))))
   (clojure.core/let
    [v8468
     (:max-number-of-messages
      m8467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8468 :com.palletops.awaze.client-builder/undef)
     (. bean8466 setMaxNumberOfMessages (clojure.core/int v8468))))
   (clojure.core/let
    [v8468
     (:wait-time-seconds
      m8467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8468 :com.palletops.awaze.client-builder/undef)
     (. bean8466 setWaitTimeSeconds (clojure.core/int v8468))))
   (clojure.core/let
    [v8468
     (:attribute-names
      m8467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8468 :com.palletops.awaze.client-builder/undef)
     (.
      bean8466
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8508] (clojure.core/str arg8508))
 v8468))))
   bean8466))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8470]
  (clojure.core/let
   [bean8469
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/let
    [v8471
     (:receipt-handle m8470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8471 :com.palletops.awaze.client-builder/undef)
     (. bean8469 setReceiptHandle (clojure.core/str v8471))))
   (clojure.core/let
    [v8471
     (:queue-url m8470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8471 :com.palletops.awaze.client-builder/undef)
     (. bean8469 setQueueUrl (clojure.core/str v8471))))
   bean8469))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8473]
  (clojure.core/let
   [bean8472
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/let
    [v8474
     (:queue-url m8473 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8474 :com.palletops.awaze.client-builder/undef)
     (. bean8472 setQueueUrl (clojure.core/str v8474))))
   (clojure.core/let
    [v8474
     (:message-body m8473 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8474 :com.palletops.awaze.client-builder/undef)
     (. bean8472 setMessageBody (clojure.core/str v8474))))
   (clojure.core/let
    [v8474
     (:delay-seconds m8473 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8474 :com.palletops.awaze.client-builder/undef)
     (. bean8472 setDelaySeconds (clojure.core/int v8474))))
   (clojure.core/let
    [v8474
     (:message-attributes
      m8473
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8474 :com.palletops.awaze.client-builder/undef)
     (.
      bean8472
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8509] (clojure.core/str arg8509))
  (clojure.core/keys v8474))
 (clojure.core/map
  (clojure.core/fn [arg8509] (sqs/message-attribute-value arg8509))
  (clojure.core/vals v8474))))))
   bean8472))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8476]
  (clojure.core/let
   [bean8475
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/let
    [v8477
     (:queue-url m8476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8477 :com.palletops.awaze.client-builder/undef)
     (. bean8475 setQueueUrl (clojure.core/str v8477))))
   (clojure.core/let
    [v8477 (:entries m8476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8477 :com.palletops.awaze.client-builder/undef)
     (.
      bean8475
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8510]
  (sqs/change-message-visibility-batch-request-entry arg8510))
 v8477))))
   bean8475))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8479]
  (clojure.core/let
   [bean8478
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/let
    [v8480
     (:receipt-handle m8479 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8480 :com.palletops.awaze.client-builder/undef)
     (. bean8478 setReceiptHandle (clojure.core/str v8480))))
   (clojure.core/let
    [v8480
     (:visibility-timeout
      m8479
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8480 :com.palletops.awaze.client-builder/undef)
     (. bean8478 setVisibilityTimeout (clojure.core/int v8480))))
   (clojure.core/let
    [v8480
     (:queue-url m8479 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8480 :com.palletops.awaze.client-builder/undef)
     (. bean8478 setQueueUrl (clojure.core/str v8480))))
   bean8478))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8482]
  (clojure.core/let
   [bean8481 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/let
    [v8483
     (:queue-name-prefix
      m8482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8483 :com.palletops.awaze.client-builder/undef)
     (. bean8481 setQueueNamePrefix (clojure.core/str v8483))))
   bean8481))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8485]
  (clojure.core/let
   [bean8484
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/let
    [v8486
     (:queue-url m8485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8486 :com.palletops.awaze.client-builder/undef)
     (. bean8484 setQueueUrl (clojure.core/str v8486))))
   (clojure.core/let
    [v8486 (:entries m8485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8486 :com.palletops.awaze.client-builder/undef)
     (.
      bean8484
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8583]
  (sqs/delete-message-batch-request-entry arg8583))
 v8486))))
   bean8484))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8488]
  (clojure.core/let
   [bean8487
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/let
    [v8489
     (:queue-url m8488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8489 :com.palletops.awaze.client-builder/undef)
     (. bean8487 setQueueUrl (clojure.core/str v8489))))
   bean8487))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8491]
  (clojure.core/let
   [bean8490
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/let
    [v8492 (:actions m8491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8492 :com.palletops.awaze.client-builder/undef)
     (.
      bean8490
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8584] (clojure.core/str arg8584))
 v8492))))
   (clojure.core/let
    [v8492
     (:queue-url m8491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8492 :com.palletops.awaze.client-builder/undef)
     (. bean8490 setQueueUrl (clojure.core/str v8492))))
   (clojure.core/let
    [v8492 (:label m8491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8492 :com.palletops.awaze.client-builder/undef)
     (. bean8490 setLabel (clojure.core/str v8492))))
   (clojure.core/let
    [v8492
     (:awsaccount-ids m8491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8492 :com.palletops.awaze.client-builder/undef)
     (.
      bean8490
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8585] (clojure.core/str arg8585))
 v8492))))
   bean8490))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.PurgeQueueRequest}
purge-queue-request
  [m8494]
  (clojure.core/let
   [bean8493 (new com.amazonaws.services.sqs.model.PurgeQueueRequest)]
   (clojure.core/let
    [v8495
     (:queue-url m8494 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8495 :com.palletops.awaze.client-builder/undef)
     (. bean8493 setQueueUrl (clojure.core/str v8495))))
   bean8493))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8497]
  (clojure.core/let
   [bean8496
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/let
    [v8498
     (:queue-url m8497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8498 :com.palletops.awaze.client-builder/undef)
     (. bean8496 setQueueUrl (clojure.core/str v8498))))
   (clojure.core/let
    [v8498
     (:attribute-names
      m8497
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8498 :com.palletops.awaze.client-builder/undef)
     (.
      bean8496
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8586] (clojure.core/str arg8586))
 v8498))))
   bean8496))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8500]
  (clojure.core/let
   [bean8499
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/let
    [v8501
     (:queue-url m8500 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8501 :com.palletops.awaze.client-builder/undef)
     (. bean8499 setQueueUrl (clojure.core/str v8501))))
   (clojure.core/let
    [v8501 (:entries m8500 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8501 :com.palletops.awaze.client-builder/undef)
     (.
      bean8499
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8587]
  (sqs/send-message-batch-request-entry arg8587))
 v8501))))
   bean8499))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8511]
   (clojure.core/let
    [credentials8512 (:credentials m8511) args8513 (:args m8511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8514
      (com.palletops.awaze.common/aws-client :sqs credentials8512)]
     (clojure.core/case
      (clojure.core/count args8513)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8513 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8514
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.GetQueueUrlRequest
               (clojure.core/nth args8513 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8514
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8513}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-queue-url,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8516 & args8517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8518
     (com.palletops.awaze.common/aws-client :sqs credentials8516)]
    (clojure.core/case
     (clojure.core/count args8517)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8517 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8518
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.GetQueueUrlRequest
              (clojure.core/nth args8517 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8518
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8517}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8519]
   (clojure.core/let
    [credentials8520 (:credentials m8519) args8521 (:args m8519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8522
      (com.palletops.awaze.common/aws-client :sqs credentials8520)]
     (clojure.core/case
      (clojure.core/count args8521)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8521 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8522
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.CreateQueueRequest
               (clojure.core/nth args8521 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8522
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8521}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-queue,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]]),
    :doc "Call createQueue, createQueue"}
   [credentials8524 & args8525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8526
     (com.palletops.awaze.common/aws-client :sqs credentials8524)]
    (clojure.core/case
     (clojure.core/count args8525)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8525 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8526
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.CreateQueueRequest
              (clojure.core/nth args8525 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8526
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8525}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8527]
   (clojure.core/let
    [credentials8528 (:credentials m8527) args8529 (:args m8527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8530
      (com.palletops.awaze.common/aws-client :sqs credentials8528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8530
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8529 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8532 & args8533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8534
     (com.palletops.awaze.common/aws-client :sqs credentials8532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8534
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8533 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8535]
   (clojure.core/let
    [credentials8536 (:credentials m8535) args8537 (:args m8535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8538
      (com.palletops.awaze.common/aws-client :sqs credentials8536)]
     (clojure.core/case
      (clojure.core/count args8537)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8538
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8537 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8538
        removePermission
        (clojure.core/str (clojure.core/nth args8537 0))
        (clojure.core/str (clojure.core/nth args8537 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials8540 & args8541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8542
     (com.palletops.awaze.common/aws-client :sqs credentials8540)]
    (clojure.core/case
     (clojure.core/count args8541)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8542
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8541 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8542
       removePermission
       (clojure.core/str (clojure.core/nth args8541 0))
       (clojure.core/str (clojure.core/nth args8541 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8543]
   (clojure.core/let
    [credentials8544 (:credentials m8543) args8545 (:args m8543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8546
      (com.palletops.awaze.common/aws-client :sqs credentials8544)]
     (clojure.core/case
      (clojure.core/count args8545)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8546
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8545 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8546
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8545 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8588] (clojure.core/str arg8588))
  (clojure.core/keys (clojure.core/nth args8545 1)))
 (clojure.core/map
  (clojure.core/fn [arg8588] (clojure.core/str arg8588))
  (clojure.core/vals (clojure.core/nth args8545 1))))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]
                [credentials string-0 map-1]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-queue-attributes,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-queue-attributes,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]
                [credentials string-0 map-1]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8548 & args8549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8550
     (com.palletops.awaze.common/aws-client :sqs credentials8548)]
    (clojure.core/case
     (clojure.core/count args8549)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8550
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8549 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8550
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8549 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8589] (clojure.core/str arg8589))
  (clojure.core/keys (clojure.core/nth args8549 1)))
 (clojure.core/map
  (clojure.core/fn [arg8589] (clojure.core/str arg8589))
  (clojure.core/vals (clojure.core/nth args8549 1))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8551]
   (clojure.core/let
    [credentials8552 (:credentials m8551) args8553 (:args m8551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8554
      (com.palletops.awaze.common/aws-client :sqs credentials8552)]
     (clojure.core/case
      (clojure.core/count args8553)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8553 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8554
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ReceiveMessageRequest
               (clojure.core/nth args8553 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8554
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8553}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :receive-message,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8556 & args8557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8558
     (com.palletops.awaze.common/aws-client :sqs credentials8556)]
    (clojure.core/case
     (clojure.core/count args8557)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8557 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8558
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ReceiveMessageRequest
              (clojure.core/nth args8557 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8558
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8557}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8559]
   (clojure.core/let
    [credentials8560 (:credentials m8559) args8561 (:args m8559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8562
      (com.palletops.awaze.common/aws-client :sqs credentials8560)]
     (clojure.core/case
      (clojure.core/count args8561)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8562
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8561 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8562
        deleteMessage
        (clojure.core/str (clojure.core/nth args8561 0))
        (clojure.core/str (clojure.core/nth args8561 1))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-message,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :delete-message,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8564 & args8565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8566
     (com.palletops.awaze.common/aws-client :sqs credentials8564)]
    (clojure.core/case
     (clojure.core/count args8565)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8566
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8565 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8566
       deleteMessage
       (clojure.core/str (clojure.core/nth args8565 0))
       (clojure.core/str (clojure.core/nth args8565 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8567]
   (clojure.core/let
    [credentials8568 (:credentials m8567) args8569 (:args m8567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8570
      (com.palletops.awaze.common/aws-client :sqs credentials8568)]
     (clojure.core/case
      (clojure.core/count args8569)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8570
        sendMessage
        (clojure.core/str (clojure.core/nth args8569 0))
        (clojure.core/str (clojure.core/nth args8569 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8570
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8569 0))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :send-message,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :send-message,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8572 & args8573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8574
     (com.palletops.awaze.common/aws-client :sqs credentials8572)]
    (clojure.core/case
     (clojure.core/count args8573)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8574
       sendMessage
       (clojure.core/str (clojure.core/nth args8573 0))
       (clojure.core/str (clojure.core/nth args8573 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8574
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8573 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8575]
   (clojure.core/let
    [credentials8576 (:credentials m8575) args8577 (:args m8575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8578
      (com.palletops.awaze.common/aws-client :sqs credentials8576)]
     (clojure.core/case
      (clojure.core/count args8577)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8578
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8577 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8654]
  (sqs/change-message-visibility-batch-request-entry arg8654))
 (clojure.core/nth args8577 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8578
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8577 0))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :change-message-visibility-batch,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :change-message-visibility-batch,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8580 & args8581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8582
     (com.palletops.awaze.common/aws-client :sqs credentials8580)]
    (clojure.core/case
     (clojure.core/count args8581)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8582
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8581 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8655]
  (sqs/change-message-visibility-batch-request-entry arg8655))
 (clojure.core/nth args8581 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8582
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8581 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8590]
   (clojure.core/let
    [credentials8591 (:credentials m8590) args8592 (:args m8590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8593
      (com.palletops.awaze.common/aws-client :sqs credentials8591)]
     (clojure.core/case
      (clojure.core/count args8592)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8593
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8592 0))
        (clojure.core/str (clojure.core/nth args8592 1))
        (clojure.core/int (clojure.core/nth args8592 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8593
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8592 0))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials string-0 string-1 integer-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :change-message-visibility,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :change-message-visibility,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials string-0 string-1 integer-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8595 & args8596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8597
     (com.palletops.awaze.common/aws-client :sqs credentials8595)]
    (clojure.core/case
     (clojure.core/count args8596)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8597
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8596 0))
       (clojure.core/str (clojure.core/nth args8596 1))
       (clojure.core/int (clojure.core/nth args8596 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8597
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8596 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8598]
   (clojure.core/let
    [credentials8599 (:credentials m8598) args8600 (:args m8598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8601
      (com.palletops.awaze.common/aws-client :sqs credentials8599)]
     (clojure.core/case
      (clojure.core/count args8600)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ListQueuesRequest
           (clojure.core/nth args8600 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8601
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8600 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8601
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8600}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8601
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]
                [credentials]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-queues,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-queues,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]
                [credentials]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8603 & args8604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8605
     (com.palletops.awaze.common/aws-client :sqs credentials8603)]
    (clojure.core/case
     (clojure.core/count args8604)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ListQueuesRequest
          (clojure.core/nth args8604 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8605
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8604 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8605
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8604}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8605
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8606]
   (clojure.core/let
    [credentials8607 (:credentials m8606) args8608 (:args m8606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8609
      (com.palletops.awaze.common/aws-client :sqs credentials8607)]
     (clojure.core/case
      (clojure.core/count args8608)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8609
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8608 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8656]
  (sqs/delete-message-batch-request-entry arg8656))
 (clojure.core/nth args8608 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8609
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8608 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-message-batch,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :delete-message-batch,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8611 & args8612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8613
     (com.palletops.awaze.common/aws-client :sqs credentials8611)]
    (clojure.core/case
     (clojure.core/count args8612)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8613
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8612 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8657]
  (sqs/delete-message-batch-request-entry arg8657))
 (clojure.core/nth args8612 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8613
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8612 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8614]
   (clojure.core/let
    [credentials8615 (:credentials m8614) args8616 (:args m8614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8617
      (com.palletops.awaze.common/aws-client :sqs credentials8615)]
     (clojure.core/case
      (clojure.core/count args8616)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.DeleteQueueRequest
           (clojure.core/nth args8616 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8617
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8616 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8617
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8616}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-queue,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8619 & args8620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8621
     (com.palletops.awaze.common/aws-client :sqs credentials8619)]
    (clojure.core/case
     (clojure.core/count args8620)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.DeleteQueueRequest
          (clojure.core/nth args8620 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8621
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8620 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8621
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8620}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8622]
   (clojure.core/let
    [credentials8623 (:credentials m8622) args8624 (:args m8622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8625
      (com.palletops.awaze.common/aws-client :sqs credentials8623)]
     (clojure.core/case
      (clojure.core/count args8624)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8625
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8624 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8625
        addPermission
        (clojure.core/str (clojure.core/nth args8624 0))
        (clojure.core/str (clojure.core/nth args8624 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8658] (clojure.core/str arg8658))
 (clojure.core/nth args8624 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8659] (clojure.core/str arg8659))
 (clojure.core/nth args8624 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials8627 & args8628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8629
     (com.palletops.awaze.common/aws-client :sqs credentials8627)]
    (clojure.core/case
     (clojure.core/count args8628)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8629
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8628 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8629
       addPermission
       (clojure.core/str (clojure.core/nth args8628 0))
       (clojure.core/str (clojure.core/nth args8628 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8660] (clojure.core/str arg8660))
 (clojure.core/nth args8628 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8661] (clojure.core/str arg8661))
 (clojure.core/nth args8628 3))))))))
 (do
  (clojure.core/defmethod
   sqs
   :purge-queue
   [m8630]
   (clojure.core/let
    [credentials8631 (:credentials m8630) args8632 (:args m8630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8633
      (com.palletops.awaze.common/aws-client :sqs credentials8631)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8633
       purgeQueue
       (sqs/purge-queue-request (clojure.core/nth args8632 0)))))))
  (clojure.core/defn
   purge-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for purgeQueue"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :purge-queue,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   purge-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call purgeQueue"}
   [credentials8635 & args8636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8637
     (com.palletops.awaze.common/aws-client :sqs credentials8635)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8637
      purgeQueue
      (sqs/purge-queue-request (clojure.core/nth args8636 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8638]
   (clojure.core/let
    [credentials8639 (:credentials m8638) args8640 (:args m8638)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8641
      (com.palletops.awaze.common/aws-client :sqs credentials8639)]
     (clojure.core/case
      (clojure.core/count args8640)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8641
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8640 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8641
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8640 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8662] (clojure.core/str arg8662))
 (clojure.core/nth args8640 1))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-queue-attributes,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :get-queue-attributes,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8643 & args8644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8645
     (com.palletops.awaze.common/aws-client :sqs credentials8643)]
    (clojure.core/case
     (clojure.core/count args8644)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8645
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8644 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8645
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8644 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8663] (clojure.core/str arg8663))
 (clojure.core/nth args8644 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8646]
   (clojure.core/let
    [credentials8647 (:credentials m8646) args8648 (:args m8646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8649
      (com.palletops.awaze.common/aws-client :sqs credentials8647)]
     (clojure.core/case
      (clojure.core/count args8648)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8649
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8648 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8664]
  (sqs/send-message-batch-request-entry arg8664))
 (clojure.core/nth args8648 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8649
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8648 0))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :send-message-batch,
     :credentials credentials__1784__auto__,
     :client :sqs})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :send-message-batch,
     :credentials credentials__1784__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8651 & args8652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8653
     (com.palletops.awaze.common/aws-client :sqs credentials8651)]
    (clojure.core/case
     (clojure.core/count args8652)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8653
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8652 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8665]
  (sqs/send-message-batch-request-entry arg8665))
 (clojure.core/nth args8652 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8653
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8652 0)))))))))
