(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m6074]
  (clojure.core/let
   [bean6073
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/let
    [v6075
     (:data-type m6074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6075 :com.palletops.awaze.client-builder/undef)
     (. bean6073 setDataType (clojure.core/str v6075))))
   (clojure.core/let
    [v6075
     (:string-value m6074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6075 :com.palletops.awaze.client-builder/undef)
     (. bean6073 setStringValue (clojure.core/str v6075))))
   (clojure.core/let
    [v6075
     (:binary-value m6074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6075 :com.palletops.awaze.client-builder/undef)
     (. bean6073 setBinaryValue (clojure.core/identity v6075))))
   bean6073))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m6077]
  (clojure.core/let
   [bean6076 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/let
    [v6078
     (:next-token m6077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6078 :com.palletops.awaze.client-builder/undef)
     (. bean6076 setNextToken (clojure.core/str v6078))))
   bean6076))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m6080]
  (clojure.core/let
   [bean6079
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/let
    [v6081
     (:attribute-name m6080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6081 :com.palletops.awaze.client-builder/undef)
     (. bean6079 setAttributeName (clojure.core/str v6081))))
   (clojure.core/let
    [v6081
     (:attribute-value
      m6080
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6081 :com.palletops.awaze.client-builder/undef)
     (. bean6079 setAttributeValue (clojure.core/str v6081))))
   (clojure.core/let
    [v6081
     (:topic-arn m6080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6081 :com.palletops.awaze.client-builder/undef)
     (. bean6079 setTopicArn (clojure.core/str v6081))))
   bean6079))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m6083]
  (clojure.core/let
   [bean6082
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/let
    [v6084
     (:topic-arn m6083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6084 :com.palletops.awaze.client-builder/undef)
     (. bean6082 setTopicArn (clojure.core/str v6084))))
   (clojure.core/let
    [v6084 (:label m6083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6084 :com.palletops.awaze.client-builder/undef)
     (. bean6082 setLabel (clojure.core/str v6084))))
   bean6082))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m6086]
  (clojure.core/let
   [bean6085
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/let
    [v6087
     (:subscription-arn
      m6086
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6087 :com.palletops.awaze.client-builder/undef)
     (. bean6085 setSubscriptionArn (clojure.core/str v6087))))
   bean6085))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m6089]
  (clojure.core/let
   [bean6088
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/let
    [v6090
     (:platform-application-arn
      m6089
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6090 :com.palletops.awaze.client-builder/undef)
     (. bean6088 setPlatformApplicationArn (clojure.core/str v6090))))
   bean6088))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m6092]
  (clojure.core/let
   [bean6091
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/let
    [v6093
     (:endpoint-arn m6092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6093 :com.palletops.awaze.client-builder/undef)
     (. bean6091 setEndpointArn (clojure.core/str v6093))))
   bean6091))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m6095]
  (clojure.core/let
   [bean6094
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6096
     (:subscription-arn
      m6095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6096 :com.palletops.awaze.client-builder/undef)
     (. bean6094 setSubscriptionArn (clojure.core/str v6096))))
   bean6094))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m6098]
  (clojure.core/let
   [bean6097
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/let
    [v6099 (:name m6098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6099 :com.palletops.awaze.client-builder/undef)
     (. bean6097 setName (clojure.core/str v6099))))
   (clojure.core/let
    [v6099
     (:platform m6098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6099 :com.palletops.awaze.client-builder/undef)
     (. bean6097 setPlatform (clojure.core/str v6099))))
   (clojure.core/let
    [v6099
     (:attributes m6098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6099 :com.palletops.awaze.client-builder/undef)
     (.
      bean6097
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6151] (clojure.core/str arg6151))
  (clojure.core/keys v6099))
 (clojure.core/map
  (clojure.core/fn [arg6151] (clojure.core/str arg6151))
  (clojure.core/vals v6099))))))
   bean6097))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m6101]
  (clojure.core/let
   [bean6100
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6102
     (:attributes m6101 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6102 :com.palletops.awaze.client-builder/undef)
     (.
      bean6100
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6152] (clojure.core/str arg6152))
  (clojure.core/keys v6102))
 (clojure.core/map
  (clojure.core/fn [arg6152] (clojure.core/str arg6152))
  (clojure.core/vals v6102))))))
   (clojure.core/let
    [v6102
     (:platform-application-arn
      m6101
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6102 :com.palletops.awaze.client-builder/undef)
     (. bean6100 setPlatformApplicationArn (clojure.core/str v6102))))
   bean6100))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m6104]
  (clojure.core/let
   [bean6103
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/let
    [v6105
     (:topic-arn m6104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6105 :com.palletops.awaze.client-builder/undef)
     (. bean6103 setTopicArn (clojure.core/str v6105))))
   (clojure.core/let
    [v6105 (:token m6104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6105 :com.palletops.awaze.client-builder/undef)
     (. bean6103 setToken (clojure.core/str v6105))))
   (clojure.core/let
    [v6105
     (:authenticate-on-unsubscribe
      m6104
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6105 :com.palletops.awaze.client-builder/undef)
     (.
      bean6103
      setAuthenticateOnUnsubscribe
      (clojure.core/str v6105))))
   bean6103))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m6107]
  (clojure.core/let
   [bean6106
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/let
    [v6108 (:token m6107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6108 :com.palletops.awaze.client-builder/undef)
     (. bean6106 setToken (clojure.core/str v6108))))
   (clojure.core/let
    [v6108
     (:attributes m6107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6108 :com.palletops.awaze.client-builder/undef)
     (.
      bean6106
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6153] (clojure.core/str arg6153))
  (clojure.core/keys v6108))
 (clojure.core/map
  (clojure.core/fn [arg6153] (clojure.core/str arg6153))
  (clojure.core/vals v6108))))))
   (clojure.core/let
    [v6108
     (:platform-application-arn
      m6107
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6108 :com.palletops.awaze.client-builder/undef)
     (. bean6106 setPlatformApplicationArn (clojure.core/str v6108))))
   (clojure.core/let
    [v6108
     (:custom-user-data
      m6107
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6108 :com.palletops.awaze.client-builder/undef)
     (. bean6106 setCustomUserData (clojure.core/str v6108))))
   bean6106))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m6110]
  (clojure.core/let
   [bean6109
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/let
    [v6111
     (:next-token m6110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6111 :com.palletops.awaze.client-builder/undef)
     (. bean6109 setNextToken (clojure.core/str v6111))))
   bean6109))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m6113]
  (clojure.core/let
   [bean6112
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/let
    [v6114 (:name m6113 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6114 :com.palletops.awaze.client-builder/undef)
     (. bean6112 setName (clojure.core/str v6114))))
   bean6112))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m6116]
  (clojure.core/let
   [bean6115
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/let
    [v6117
     (:next-token m6116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6117 :com.palletops.awaze.client-builder/undef)
     (. bean6115 setNextToken (clojure.core/str v6117))))
   (clojure.core/let
    [v6117
     (:platform-application-arn
      m6116
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6117 :com.palletops.awaze.client-builder/undef)
     (. bean6115 setPlatformApplicationArn (clojure.core/str v6117))))
   bean6115))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m6119]
  (clojure.core/let
   [bean6118
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6120
     (:platform-application-arn
      m6119
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6120 :com.palletops.awaze.client-builder/undef)
     (. bean6118 setPlatformApplicationArn (clojure.core/str v6120))))
   bean6118))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m6122]
  (clojure.core/let
   [bean6121
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6123
     (:attribute-name m6122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6123 :com.palletops.awaze.client-builder/undef)
     (. bean6121 setAttributeName (clojure.core/str v6123))))
   (clojure.core/let
    [v6123
     (:attribute-value
      m6122
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6123 :com.palletops.awaze.client-builder/undef)
     (. bean6121 setAttributeValue (clojure.core/str v6123))))
   (clojure.core/let
    [v6123
     (:subscription-arn
      m6122
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6123 :com.palletops.awaze.client-builder/undef)
     (. bean6121 setSubscriptionArn (clojure.core/str v6123))))
   bean6121))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m6125]
  (clojure.core/let
   [bean6124
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/let
    [v6126
     (:topic-arn m6125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6126 :com.palletops.awaze.client-builder/undef)
     (. bean6124 setTopicArn (clojure.core/str v6126))))
   (clojure.core/let
    [v6126 (:label m6125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6126 :com.palletops.awaze.client-builder/undef)
     (. bean6124 setLabel (clojure.core/str v6126))))
   (clojure.core/let
    [v6126
     (:awsaccount-ids m6125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6126 :com.palletops.awaze.client-builder/undef)
     (.
      bean6124
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6186] (clojure.core/str arg6186))
 v6126))))
   (clojure.core/let
    [v6126
     (:action-names m6125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6126 :com.palletops.awaze.client-builder/undef)
     (.
      bean6124
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6187] (clojure.core/str arg6187))
 v6126))))
   bean6124))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m6128]
  (clojure.core/let
   [bean6127
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/let
    [v6129
     (:next-token m6128 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6129 :com.palletops.awaze.client-builder/undef)
     (. bean6127 setNextToken (clojure.core/str v6129))))
   bean6127))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m6131]
  (clojure.core/let
   [bean6130
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/let
    [v6132
     (:topic-arn m6131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6132 :com.palletops.awaze.client-builder/undef)
     (. bean6130 setTopicArn (clojure.core/str v6132))))
   bean6130))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m6134]
  (clojure.core/let
   [bean6133
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/let
    [v6135
     (:endpoint-arn m6134 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6135 :com.palletops.awaze.client-builder/undef)
     (. bean6133 setEndpointArn (clojure.core/str v6135))))
   bean6133))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m6137]
  (clojure.core/let
   [bean6136
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/let
    [v6138
     (:topic-arn m6137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6138 :com.palletops.awaze.client-builder/undef)
     (. bean6136 setTopicArn (clojure.core/str v6138))))
   bean6136))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m6140]
  (clojure.core/let
   [bean6139 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/let
    [v6141
     (:endpoint m6140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6141 :com.palletops.awaze.client-builder/undef)
     (. bean6139 setEndpoint (clojure.core/str v6141))))
   (clojure.core/let
    [v6141
     (:topic-arn m6140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6141 :com.palletops.awaze.client-builder/undef)
     (. bean6139 setTopicArn (clojure.core/str v6141))))
   (clojure.core/let
    [v6141
     (:protocol m6140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6141 :com.palletops.awaze.client-builder/undef)
     (. bean6139 setProtocol (clojure.core/str v6141))))
   bean6139))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m6143]
  (clojure.core/let
   [bean6142
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/let
    [v6144
     (:topic-arn m6143 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6144 :com.palletops.awaze.client-builder/undef)
     (. bean6142 setTopicArn (clojure.core/str v6144))))
   (clojure.core/let
    [v6144
     (:next-token m6143 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6144 :com.palletops.awaze.client-builder/undef)
     (. bean6142 setNextToken (clojure.core/str v6144))))
   bean6142))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m6146]
  (clojure.core/let
   [bean6145 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/let
    [v6147 (:subject m6146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6147 :com.palletops.awaze.client-builder/undef)
     (. bean6145 setSubject (clojure.core/str v6147))))
   (clojure.core/let
    [v6147
     (:topic-arn m6146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6147 :com.palletops.awaze.client-builder/undef)
     (. bean6145 setTopicArn (clojure.core/str v6147))))
   (clojure.core/let
    [v6147 (:message m6146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6147 :com.palletops.awaze.client-builder/undef)
     (. bean6145 setMessage (clojure.core/str v6147))))
   (clojure.core/let
    [v6147
     (:target-arn m6146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6147 :com.palletops.awaze.client-builder/undef)
     (. bean6145 setTargetArn (clojure.core/str v6147))))
   (clojure.core/let
    [v6147
     (:message-structure
      m6146
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6147 :com.palletops.awaze.client-builder/undef)
     (. bean6145 setMessageStructure (clojure.core/str v6147))))
   (clojure.core/let
    [v6147
     (:message-attributes
      m6146
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6147 :com.palletops.awaze.client-builder/undef)
     (.
      bean6145
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6188] (clojure.core/str arg6188))
  (clojure.core/keys v6147))
 (clojure.core/map
  (clojure.core/fn [arg6188] (sns/message-attribute-value arg6188))
  (clojure.core/vals v6147))))))
   bean6145))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m6149]
  (clojure.core/let
   [bean6148
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/let
    [v6150
     (:attributes m6149 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6150 :com.palletops.awaze.client-builder/undef)
     (.
      bean6148
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6189] (clojure.core/str arg6189))
  (clojure.core/keys v6150))
 (clojure.core/map
  (clojure.core/fn [arg6189] (clojure.core/str arg6189))
  (clojure.core/vals v6150))))))
   (clojure.core/let
    [v6150
     (:endpoint-arn m6149 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6150 :com.palletops.awaze.client-builder/undef)
     (. bean6148 setEndpointArn (clojure.core/str v6150))))
   bean6148))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m6154]
   (clojure.core/let
    [credentials6155 (:credentials m6154) args6156 (:args m6154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6157
      (com.palletops.awaze.common/aws-client :sns credentials6155)]
     (clojure.core/case
      (clojure.core/count args6156)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListTopicsRequest
           (clojure.core/nth args6156 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6157
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6156 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6157
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args6156}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6157
        listTopics))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0]
                [credentials]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-topics,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-topics,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0]
                [credentials]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials6159 & args6160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6161
     (com.palletops.awaze.common/aws-client :sns credentials6159)]
    (clojure.core/case
     (clojure.core/count args6160)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListTopicsRequest
          (clojure.core/nth args6160 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6161
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6160 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6161
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args6160}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6161
       listTopics))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m6162]
   (clojure.core/let
    [credentials6163 (:credentials m6162) args6164 (:args m6162)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6165
      (com.palletops.awaze.common/aws-client :sns credentials6163)]
     (clojure.core/case
      (clojure.core/count args6164)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6165
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args6164 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6165
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args6164 0))
        (clojure.core/str (clojure.core/nth args6164 1))
        (clojure.core/str (clojure.core/nth args6164 2))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-topic-attributes,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :set-topic-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials6167 & args6168]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6169
     (com.palletops.awaze.common/aws-client :sns credentials6167)]
    (clojure.core/case
     (clojure.core/count args6168)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6169
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args6168 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6169
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args6168 0))
       (clojure.core/str (clojure.core/nth args6168 1))
       (clojure.core/str (clojure.core/nth args6168 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m6170]
   (clojure.core/let
    [credentials6171 (:credentials m6170) args6172 (:args m6170)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6173
      (com.palletops.awaze.common/aws-client :sns credentials6171)]
     (clojure.core/case
      (clojure.core/count args6172)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6173
        removePermission
        (sns/remove-permission-request (clojure.core/nth args6172 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6173
        removePermission
        (clojure.core/str (clojure.core/nth args6172 0))
        (clojure.core/str (clojure.core/nth args6172 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials6175 & args6176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6177
     (com.palletops.awaze.common/aws-client :sns credentials6175)]
    (clojure.core/case
     (clojure.core/count args6176)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6177
       removePermission
       (sns/remove-permission-request (clojure.core/nth args6176 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6177
       removePermission
       (clojure.core/str (clojure.core/nth args6176 0))
       (clojure.core/str (clojure.core/nth args6176 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m6178]
   (clojure.core/let
    [credentials6179 (:credentials m6178) args6180 (:args m6178)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6181
      (com.palletops.awaze.common/aws-client :sns credentials6179)]
     (clojure.core/case
      (clojure.core/count args6180)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6180 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6181
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.UnsubscribeRequest
               (clojure.core/nth args6180 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6181
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args6180}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :unsubscribe,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials6183 & args6184]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6185
     (com.palletops.awaze.common/aws-client :sns credentials6183)]
    (clojure.core/case
     (clojure.core/count args6184)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6184 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6185
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.UnsubscribeRequest
              (clojure.core/nth args6184 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6185
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args6184}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m6190]
   (clojure.core/let
    [credentials6191 (:credentials m6190) args6192 (:args m6190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6193
      (com.palletops.awaze.common/aws-client :sns credentials6191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6193
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args6192 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-platform-application,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials6195 & args6196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6197
     (com.palletops.awaze.common/aws-client :sns credentials6195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6197
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args6196 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m6198]
   (clojure.core/let
    [credentials6199 (:credentials m6198) args6200 (:args m6198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6201
      (com.palletops.awaze.common/aws-client :sns credentials6199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6201
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args6200 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-endpoint,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEndpoint"}
   [credentials6203 & args6204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6205
     (com.palletops.awaze.common/aws-client :sns credentials6203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6205
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args6204 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m6206]
   (clojure.core/let
    [credentials6207 (:credentials m6206) args6208 (:args m6206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6209
      (com.palletops.awaze.common/aws-client :sns credentials6207)]
     (clojure.core/case
      (clojure.core/count args6208)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
           (clojure.core/nth args6208 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6209
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6208 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6209
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args6208}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-subscription-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials6211 & args6212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6213
     (com.palletops.awaze.common/aws-client :sns credentials6211)]
    (clojure.core/case
     (clojure.core/count args6212)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
          (clojure.core/nth args6212 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6213
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6212 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6213
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args6212}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m6214]
   (clojure.core/let
    [credentials6215 (:credentials m6214) args6216 (:args m6214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6217
      (com.palletops.awaze.common/aws-client :sns credentials6215)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6217
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args6216 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-platform-application,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Call createPlatformApplication"}
   [credentials6219 & args6220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6221
     (com.palletops.awaze.common/aws-client :sns credentials6219)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6221
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args6220 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m6222]
   (clojure.core/let
    [credentials6223 (:credentials m6222) args6224 (:args m6222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6225
      (com.palletops.awaze.common/aws-client :sns credentials6223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6225
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args6224 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-platform-application-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials6227 & args6228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6229
     (com.palletops.awaze.common/aws-client :sns credentials6227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6229
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args6228 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m6230]
   (clojure.core/let
    [credentials6231 (:credentials m6230) args6232 (:args m6230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6233
      (com.palletops.awaze.common/aws-client :sns credentials6231)]
     (clojure.core/case
      (clojure.core/count args6232)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6233
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6232 0))
        (clojure.core/str (clojure.core/nth args6232 1))
        (clojure.core/str (clojure.core/nth args6232 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6233
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args6232 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6233
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6232 0))
        (clojure.core/str (clojure.core/nth args6232 1))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :confirm-subscription,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :confirm-subscription,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :confirm-subscription,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials6235 & args6236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6237
     (com.palletops.awaze.common/aws-client :sns credentials6235)]
    (clojure.core/case
     (clojure.core/count args6236)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6237
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6236 0))
       (clojure.core/str (clojure.core/nth args6236 1))
       (clojure.core/str (clojure.core/nth args6236 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6237
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args6236 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6237
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6236 0))
       (clojure.core/str (clojure.core/nth args6236 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m6238]
   (clojure.core/let
    [credentials6239 (:credentials m6238) args6240 (:args m6238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6241
      (com.palletops.awaze.common/aws-client :sns credentials6239)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6241
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args6240 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-platform-endpoint,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials6243 & args6244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6245
     (com.palletops.awaze.common/aws-client :sns credentials6243)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6245
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args6244 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m6246]
   (clojure.core/let
    [credentials6247 (:credentials m6246) args6248 (:args m6246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6249
      (com.palletops.awaze.common/aws-client :sns credentials6247)]
     (clojure.core/case
      (clojure.core/count args6248)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6249
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args6248 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6249
        listPlatformApplications))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-platform-applications,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-platform-applications,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials6251 & args6252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6253
     (com.palletops.awaze.common/aws-client :sns credentials6251)]
    (clojure.core/case
     (clojure.core/count args6252)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6253
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args6252 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6253
       listPlatformApplications))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m6254]
   (clojure.core/let
    [credentials6255 (:credentials m6254) args6256 (:args m6254)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6257
      (com.palletops.awaze.common/aws-client :sns credentials6255)]
     (clojure.core/case
      (clojure.core/count args6256)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6256 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6257
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.CreateTopicRequest
               (clojure.core/nth args6256 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6257
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args6256}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-topic,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTopic, createTopic"}
   [credentials6259 & args6260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6261
     (com.palletops.awaze.common/aws-client :sns credentials6259)]
    (clojure.core/case
     (clojure.core/count args6260)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6260 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6261
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.CreateTopicRequest
              (clojure.core/nth args6260 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6261
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args6260}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m6262]
   (clojure.core/let
    [credentials6263 (:credentials m6262) args6264 (:args m6262)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6265
      (com.palletops.awaze.common/aws-client :sns credentials6263)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6265
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args6264 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials6267 & args6268]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6269
     (com.palletops.awaze.common/aws-client :sns credentials6267)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6269
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args6268 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m6270]
   (clojure.core/let
    [credentials6271 (:credentials m6270) args6272 (:args m6270)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6273
      (com.palletops.awaze.common/aws-client :sns credentials6271)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6273
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args6272 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-platform-application-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials6275 & args6276]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6277
     (com.palletops.awaze.common/aws-client :sns credentials6275)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6277
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args6276 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m6278]
   (clojure.core/let
    [credentials6279 (:credentials m6278) args6280 (:args m6278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6281
      (com.palletops.awaze.common/aws-client :sns credentials6279)]
     (clojure.core/case
      (clojure.core/count args6280)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6281
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args6280 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6281
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args6280 0))
        (clojure.core/str (clojure.core/nth args6280 1))
        (clojure.core/str (clojure.core/nth args6280 2))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-subscription-attributes,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :set-subscription-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials6283 & args6284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6285
     (com.palletops.awaze.common/aws-client :sns credentials6283)]
    (clojure.core/case
     (clojure.core/count args6284)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6285
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args6284 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6285
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args6284 0))
       (clojure.core/str (clojure.core/nth args6284 1))
       (clojure.core/str (clojure.core/nth args6284 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m6286]
   (clojure.core/let
    [credentials6287 (:credentials m6286) args6288 (:args m6286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6289
      (com.palletops.awaze.common/aws-client :sns credentials6287)]
     (clojure.core/case
      (clojure.core/count args6288)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6289
        addPermission
        (sns/add-permission-request (clojure.core/nth args6288 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6289
        addPermission
        (clojure.core/str (clojure.core/nth args6288 0))
        (clojure.core/str (clojure.core/nth args6288 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6318] (clojure.core/str arg6318))
 (clojure.core/nth args6288 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6319] (clojure.core/str arg6319))
 (clojure.core/nth args6288 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials6291 & args6292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6293
     (com.palletops.awaze.common/aws-client :sns credentials6291)]
    (clojure.core/case
     (clojure.core/count args6292)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6293
       addPermission
       (sns/add-permission-request (clojure.core/nth args6292 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6293
       addPermission
       (clojure.core/str (clojure.core/nth args6292 0))
       (clojure.core/str (clojure.core/nth args6292 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6320] (clojure.core/str arg6320))
 (clojure.core/nth args6292 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6321] (clojure.core/str arg6321))
 (clojure.core/nth args6292 3))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m6294]
   (clojure.core/let
    [credentials6295 (:credentials m6294) args6296 (:args m6294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6297
      (com.palletops.awaze.common/aws-client :sns credentials6295)]
     (clojure.core/case
      (clojure.core/count args6296)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6297
        listSubscriptions))
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6296 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6297
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsRequest
               (clojure.core/nth args6296 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6297
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args6296}))))))))))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-subscriptions,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-subscriptions,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials6299 & args6300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6301
     (com.palletops.awaze.common/aws-client :sns credentials6299)]
    (clojure.core/case
     (clojure.core/count args6300)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6301
       listSubscriptions))
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6300 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6301
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsRequest
              (clojure.core/nth args6300 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6301
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args6300}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m6302]
   (clojure.core/let
    [credentials6303 (:credentials m6302) args6304 (:args m6302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6305
      (com.palletops.awaze.common/aws-client :sns credentials6303)]
     (clojure.core/case
      (clojure.core/count args6304)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.GetTopicAttributesRequest
           (clojure.core/nth args6304 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6305
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6304 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6305
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args6304}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-topic-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials6307 & args6308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6309
     (com.palletops.awaze.common/aws-client :sns credentials6307)]
    (clojure.core/case
     (clojure.core/count args6308)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.GetTopicAttributesRequest
          (clojure.core/nth args6308 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6309
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6308 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6309
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args6308}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m6310]
   (clojure.core/let
    [credentials6311 (:credentials m6310) args6312 (:args m6310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6313
      (com.palletops.awaze.common/aws-client :sns credentials6311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6313
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args6312 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-endpoint-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials6315 & args6316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6317
     (com.palletops.awaze.common/aws-client :sns credentials6315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6317
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args6316 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m6322]
   (clojure.core/let
    [credentials6323 (:credentials m6322) args6324 (:args m6322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6325
      (com.palletops.awaze.common/aws-client :sns credentials6323)]
     (clojure.core/case
      (clojure.core/count args6324)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6324 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6325
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.DeleteTopicRequest
               (clojure.core/nth args6324 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6325
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args6324}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-topic,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials6327 & args6328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6329
     (com.palletops.awaze.common/aws-client :sns credentials6327)]
    (clojure.core/case
     (clojure.core/count args6328)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6328 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6329
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.DeleteTopicRequest
              (clojure.core/nth args6328 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6329
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args6328}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m6330]
   (clojure.core/let
    [credentials6331 (:credentials m6330) args6332 (:args m6330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6333
      (com.palletops.awaze.common/aws-client :sns credentials6331)]
     (clojure.core/case
      (clojure.core/count args6332)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6333
        subscribe
        (sns/subscribe-request (clojure.core/nth args6332 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6333
        subscribe
        (clojure.core/str (clojure.core/nth args6332 0))
        (clojure.core/str (clojure.core/nth args6332 1))
        (clojure.core/str (clojure.core/nth args6332 2))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :subscribe,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :subscribe,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call subscribe, subscribe"}
   [credentials6335 & args6336]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6337
     (com.palletops.awaze.common/aws-client :sns credentials6335)]
    (clojure.core/case
     (clojure.core/count args6336)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6337
       subscribe
       (sns/subscribe-request (clojure.core/nth args6336 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6337
       subscribe
       (clojure.core/str (clojure.core/nth args6336 0))
       (clojure.core/str (clojure.core/nth args6336 1))
       (clojure.core/str (clojure.core/nth args6336 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m6338]
   (clojure.core/let
    [credentials6339 (:credentials m6338) args6340 (:args m6338)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6341
      (com.palletops.awaze.common/aws-client :sns credentials6339)]
     (clojure.core/case
      (clojure.core/count args6340)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
           (clojure.core/nth args6340 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6341
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6340 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6341
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args6340}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6341
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args6340 0))
        (clojure.core/str (clojure.core/nth args6340 1))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials6343 & args6344]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6345
     (com.palletops.awaze.common/aws-client :sns credentials6343)]
    (clojure.core/case
     (clojure.core/count args6344)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
          (clojure.core/nth args6344 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6345
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6344 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6345
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args6344}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6345
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args6344 0))
       (clojure.core/str (clojure.core/nth args6344 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m6346]
   (clojure.core/let
    [credentials6347 (:credentials m6346) args6348 (:args m6346)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6349
      (com.palletops.awaze.common/aws-client :sns credentials6347)]
     (clojure.core/case
      (clojure.core/count args6348)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6349
        publish
        (clojure.core/str (clojure.core/nth args6348 0))
        (clojure.core/str (clojure.core/nth args6348 1))
        (clojure.core/str (clojure.core/nth args6348 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6349
        publish
        (clojure.core/str (clojure.core/nth args6348 0))
        (clojure.core/str (clojure.core/nth args6348 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6349
        publish
        (sns/publish-request (clojure.core/nth args6348 0))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :publish,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :publish,
     :credentials credentials__1784__auto__,
     :client :sns})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :publish,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]]),
    :doc "Call publish, publish, publish"}
   [credentials6351 & args6352]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6353
     (com.palletops.awaze.common/aws-client :sns credentials6351)]
    (clojure.core/case
     (clojure.core/count args6352)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6353
       publish
       (clojure.core/str (clojure.core/nth args6352 0))
       (clojure.core/str (clojure.core/nth args6352 1))
       (clojure.core/str (clojure.core/nth args6352 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6353
       publish
       (clojure.core/str (clojure.core/nth args6352 0))
       (clojure.core/str (clojure.core/nth args6352 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6353
       publish
       (sns/publish-request (clojure.core/nth args6352 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m6354]
   (clojure.core/let
    [credentials6355 (:credentials m6354) args6356 (:args m6354)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6357
      (com.palletops.awaze.common/aws-client :sns credentials6355)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6357
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args6356 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-endpoint-attributes,
     :credentials credentials__1784__auto__,
     :client :sns}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials6359 & args6360]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6361
     (com.palletops.awaze.common/aws-client :sns credentials6359)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6361
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args6360 0))))))))
