(ns
 com.palletops.awaze.simpleemail
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpleemail :as simpleemail]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopScope}
stop-scope
  [m5166]
  (.
   com.amazonaws.services.simpleemail.model.StopScope
   fromValue
   (clojure.core/name m5166)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ExtensionField}
extension-field
  [m5169]
  (clojure.core/let
   [bean5168
    (new com.amazonaws.services.simpleemail.model.ExtensionField)]
   (clojure.core/let
    [v5170 (:name m5169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5170 :com.palletops.awaze.client-builder/undef)
     (. bean5168 setName (clojure.core/str v5170))))
   (clojure.core/let
    [v5170 (:value m5169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5170 :com.palletops.awaze.client-builder/undef)
     (. bean5168 setValue (clojure.core/str v5170))))
   bean5168))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.S3Action}
s3action
  [m5172]
  (clojure.core/let
   [bean5171 (new com.amazonaws.services.simpleemail.model.S3Action)]
   (clojure.core/let
    [v5173
     (:topic-arn m5172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5173 :com.palletops.awaze.client-builder/undef)
     (. bean5171 setTopicArn (clojure.core/str v5173))))
   (clojure.core/let
    [v5173
     (:bucket-name m5172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5173 :com.palletops.awaze.client-builder/undef)
     (. bean5171 setBucketName (clojure.core/str v5173))))
   (clojure.core/let
    [v5173
     (:object-key-prefix
      m5172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5173 :com.palletops.awaze.client-builder/undef)
     (. bean5171 setObjectKeyPrefix (clojure.core/str v5173))))
   (clojure.core/let
    [v5173
     (:kms-key-arn m5172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5173 :com.palletops.awaze.client-builder/undef)
     (. bean5171 setKmsKeyArn (clojure.core/str v5173))))
   bean5171))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BounceAction}
bounce-action
  [m5175]
  (clojure.core/let
   [bean5174
    (new com.amazonaws.services.simpleemail.model.BounceAction)]
   (clojure.core/let
    [v5176
     (:topic-arn m5175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5176 :com.palletops.awaze.client-builder/undef)
     (. bean5174 setTopicArn (clojure.core/str v5176))))
   (clojure.core/let
    [v5176
     (:smtp-reply-code
      m5175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5176 :com.palletops.awaze.client-builder/undef)
     (. bean5174 setSmtpReplyCode (clojure.core/str v5176))))
   (clojure.core/let
    [v5176 (:sender m5175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5176 :com.palletops.awaze.client-builder/undef)
     (. bean5174 setSender (clojure.core/str v5176))))
   (clojure.core/let
    [v5176
     (:status-code m5175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5176 :com.palletops.awaze.client-builder/undef)
     (. bean5174 setStatusCode (clojure.core/str v5176))))
   (clojure.core/let
    [v5176 (:message m5175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5176 :com.palletops.awaze.client-builder/undef)
     (. bean5174 setMessage (clojure.core/str v5176))))
   bean5174))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.WorkmailAction}
workmail-action
  [m5178]
  (clojure.core/let
   [bean5177
    (new com.amazonaws.services.simpleemail.model.WorkmailAction)]
   (clojure.core/let
    [v5179
     (:topic-arn m5178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5179 :com.palletops.awaze.client-builder/undef)
     (. bean5177 setTopicArn (clojure.core/str v5179))))
   (clojure.core/let
    [v5179
     (:organization-arn
      m5178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5179 :com.palletops.awaze.client-builder/undef)
     (. bean5177 setOrganizationArn (clojure.core/str v5179))))
   bean5177))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.LambdaAction}
lambda-action
  [m5181]
  (clojure.core/let
   [bean5180
    (new com.amazonaws.services.simpleemail.model.LambdaAction)]
   (clojure.core/let
    [v5182
     (:topic-arn m5181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5182 :com.palletops.awaze.client-builder/undef)
     (. bean5180 setTopicArn (clojure.core/str v5182))))
   (clojure.core/let
    [v5182
     (:function-arn m5181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5182 :com.palletops.awaze.client-builder/undef)
     (. bean5180 setFunctionArn (clojure.core/str v5182))))
   (clojure.core/let
    [v5182
     (:invocation-type
      m5181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5182 :com.palletops.awaze.client-builder/undef)
     (. bean5180 setInvocationType (clojure.core/str v5182))))
   bean5180))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopAction}
stop-action
  [m5184]
  (clojure.core/let
   [bean5183
    (new com.amazonaws.services.simpleemail.model.StopAction)]
   (clojure.core/let
    [v5185
     (:topic-arn m5184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5185 :com.palletops.awaze.client-builder/undef)
     (. bean5183 setTopicArn (clojure.core/str v5185))))
   (clojure.core/let
    [v5185 (:scope m5184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5185 :com.palletops.awaze.client-builder/undef)
     (. bean5183 setScope (simpleemail/stop-scope v5185))))
   bean5183))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.AddHeaderAction}
add-header-action
  [m5187]
  (clojure.core/let
   [bean5186
    (new com.amazonaws.services.simpleemail.model.AddHeaderAction)]
   (clojure.core/let
    [v5188
     (:header-name m5187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5188 :com.palletops.awaze.client-builder/undef)
     (. bean5186 setHeaderName (clojure.core/str v5188))))
   (clojure.core/let
    [v5188
     (:header-value m5187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5188 :com.palletops.awaze.client-builder/undef)
     (. bean5186 setHeaderValue (clojure.core/str v5188))))
   bean5186))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SNSAction}
snsaction
  [m5190]
  (clojure.core/let
   [bean5189 (new com.amazonaws.services.simpleemail.model.SNSAction)]
   (clojure.core/let
    [v5191
     (:topic-arn m5190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5191 :com.palletops.awaze.client-builder/undef)
     (. bean5189 setTopicArn (clojure.core/str v5191))))
   (clojure.core/let
    [v5191
     (:encoding m5190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5191 :com.palletops.awaze.client-builder/undef)
     (. bean5189 setEncoding (clojure.core/str v5191))))
   bean5189))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Content}
content
  [m5193]
  (clojure.core/let
   [bean5192 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/let
    [v5194 (:charset m5193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5194 :com.palletops.awaze.client-builder/undef)
     (. bean5192 setCharset (clojure.core/str v5194))))
   (clojure.core/let
    [v5194 (:data m5193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5194 :com.palletops.awaze.client-builder/undef)
     (. bean5192 setData (clojure.core/str v5194))))
   bean5192))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptIpFilter}
receipt-ip-filter
  [m5196]
  (clojure.core/let
   [bean5195
    (new com.amazonaws.services.simpleemail.model.ReceiptIpFilter)]
   (clojure.core/let
    [v5197 (:cidr m5196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5197 :com.palletops.awaze.client-builder/undef)
     (. bean5195 setCidr (clojure.core/str v5197))))
   (clojure.core/let
    [v5197 (:policy m5196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5197 :com.palletops.awaze.client-builder/undef)
     (. bean5195 setPolicy (clojure.core/str v5197))))
   bean5195))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BounceType}
bounce-type
  [m5199]
  (.
   com.amazonaws.services.simpleemail.model.BounceType
   fromValue
   (clojure.core/name m5199)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RecipientDsnFields}
recipient-dsn-fields
  [m5202]
  (clojure.core/let
   [bean5201
    (new com.amazonaws.services.simpleemail.model.RecipientDsnFields)]
   (clojure.core/let
    [v5203
     (:extension-fields
      m5202
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (.
      bean5201
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5363] (simpleemail/extension-field arg5363))
 v5203))))
   (clojure.core/let
    [v5203
     (:final-recipient
      m5202
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (. bean5201 setFinalRecipient (clojure.core/str v5203))))
   (clojure.core/let
    [v5203 (:action m5202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (. bean5201 setAction (clojure.core/str v5203))))
   (clojure.core/let
    [v5203
     (:remote-mta m5202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (. bean5201 setRemoteMta (clojure.core/str v5203))))
   (clojure.core/let
    [v5203
     (:diagnostic-code
      m5202
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (. bean5201 setDiagnosticCode (clojure.core/str v5203))))
   (clojure.core/let
    [v5203
     (:last-attempt-date
      m5202
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (.
      bean5201
      setLastAttemptDate
      (com.palletops.awaze.common/to-date v5203))))
   (clojure.core/let
    [v5203 (:status m5202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5203 :com.palletops.awaze.client-builder/undef)
     (. bean5201 setStatus (clojure.core/str v5203))))
   bean5201))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.TlsPolicy}
tls-policy
  [m5205]
  (.
   com.amazonaws.services.simpleemail.model.TlsPolicy
   fromValue
   (clojure.core/name m5205)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptAction}
receipt-action
  [m5208]
  (clojure.core/let
   [bean5207
    (new com.amazonaws.services.simpleemail.model.ReceiptAction)]
   (clojure.core/let
    [v5209
     (:s3action m5208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (. bean5207 setS3Action (simpleemail/s3action v5209))))
   (clojure.core/let
    [v5209
     (:bounce-action m5208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (. bean5207 setBounceAction (simpleemail/bounce-action v5209))))
   (clojure.core/let
    [v5209
     (:workmail-action
      m5208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (.
      bean5207
      setWorkmailAction
      (simpleemail/workmail-action v5209))))
   (clojure.core/let
    [v5209
     (:lambda-action m5208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (. bean5207 setLambdaAction (simpleemail/lambda-action v5209))))
   (clojure.core/let
    [v5209
     (:stop-action m5208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (. bean5207 setStopAction (simpleemail/stop-action v5209))))
   (clojure.core/let
    [v5209
     (:add-header-action
      m5208
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (.
      bean5207
      setAddHeaderAction
      (simpleemail/add-header-action v5209))))
   (clojure.core/let
    [v5209
     (:snsaction m5208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5209 :com.palletops.awaze.client-builder/undef)
     (. bean5207 setSNSAction (simpleemail/snsaction v5209))))
   bean5207))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Body}
body
  [m5211]
  (clojure.core/let
   [bean5210 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/let
    [v5212 (:text m5211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5212 :com.palletops.awaze.client-builder/undef)
     (. bean5210 setText (simpleemail/content v5212))))
   (clojure.core/let
    [v5212 (:html m5211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5212 :com.palletops.awaze.client-builder/undef)
     (. bean5210 setHtml (simpleemail/content v5212))))
   bean5210))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.NotificationType}
notification-type
  [m5214]
  (.
   com.amazonaws.services.simpleemail.model.NotificationType
   fromValue
   (clojure.core/name m5214)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptFilter}
receipt-filter
  [m5217]
  (clojure.core/let
   [bean5216
    (new com.amazonaws.services.simpleemail.model.ReceiptFilter)]
   (clojure.core/let
    [v5218 (:name m5217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5218 :com.palletops.awaze.client-builder/undef)
     (. bean5216 setName (clojure.core/str v5218))))
   (clojure.core/let
    [v5218
     (:ip-filter m5217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5218 :com.palletops.awaze.client-builder/undef)
     (. bean5216 setIpFilter (simpleemail/receipt-ip-filter v5218))))
   bean5216))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.MessageDsn}
message-dsn
  [m5220]
  (clojure.core/let
   [bean5219
    (new com.amazonaws.services.simpleemail.model.MessageDsn)]
   (clojure.core/let
    [v5221
     (:reporting-mta m5220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5221 :com.palletops.awaze.client-builder/undef)
     (. bean5219 setReportingMta (clojure.core/str v5221))))
   (clojure.core/let
    [v5221
     (:arrival-date m5220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5221 :com.palletops.awaze.client-builder/undef)
     (.
      bean5219
      setArrivalDate
      (com.palletops.awaze.common/to-date v5221))))
   (clojure.core/let
    [v5221
     (:extension-fields
      m5220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5221 :com.palletops.awaze.client-builder/undef)
     (.
      bean5219
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5364] (simpleemail/extension-field arg5364))
 v5221))))
   bean5219))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BouncedRecipientInfo}
bounced-recipient-info
  [m5223]
  (clojure.core/let
   [bean5222
    (new
     com.amazonaws.services.simpleemail.model.BouncedRecipientInfo)]
   (clojure.core/let
    [v5224
     (:recipient m5223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5224 :com.palletops.awaze.client-builder/undef)
     (. bean5222 setRecipient (clojure.core/str v5224))))
   (clojure.core/let
    [v5224
     (:recipient-arn m5223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5224 :com.palletops.awaze.client-builder/undef)
     (. bean5222 setRecipientArn (clojure.core/str v5224))))
   (clojure.core/let
    [v5224
     (:bounce-type m5223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5224 :com.palletops.awaze.client-builder/undef)
     (. bean5222 setBounceType (simpleemail/bounce-type v5224))))
   (clojure.core/let
    [v5224
     (:recipient-dsn-fields
      m5223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5224 :com.palletops.awaze.client-builder/undef)
     (.
      bean5222
      setRecipientDsnFields
      (simpleemail/recipient-dsn-fields v5224))))
   bean5222))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptRule}
receipt-rule
  [m5226]
  (clojure.core/let
   [bean5225
    (new com.amazonaws.services.simpleemail.model.ReceiptRule)]
   (clojure.core/let
    [v5227 (:name m5226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5227 :com.palletops.awaze.client-builder/undef)
     (. bean5225 setName (clojure.core/str v5227))))
   (clojure.core/let
    [v5227
     (:tls-policy m5226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5227 :com.palletops.awaze.client-builder/undef)
     (. bean5225 setTlsPolicy (simpleemail/tls-policy v5227))))
   (clojure.core/let
    [v5227
     (:recipients m5226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5227 :com.palletops.awaze.client-builder/undef)
     (.
      bean5225
      setRecipients
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5365] (clojure.core/str arg5365))
 v5227))))
   (clojure.core/let
    [v5227 (:actions m5226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5227 :com.palletops.awaze.client-builder/undef)
     (.
      bean5225
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5366] (simpleemail/receipt-action arg5366))
 v5227))))
   (clojure.core/let
    [v5227
     (:scan-enabled m5226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5227 :com.palletops.awaze.client-builder/undef)
     (. bean5225 setScanEnabled (clojure.core/boolean v5227))))
   (clojure.core/let
    [v5227 (:enabled m5226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5227 :com.palletops.awaze.client-builder/undef)
     (. bean5225 setEnabled (clojure.core/boolean v5227))))
   bean5225))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Message}
message
  [m5229]
  (clojure.core/let
   [bean5228 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/let
    [v5230 (:body m5229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5230 :com.palletops.awaze.client-builder/undef)
     (. bean5228 setBody (simpleemail/body v5230))))
   (clojure.core/let
    [v5230 (:subject m5229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5230 :com.palletops.awaze.client-builder/undef)
     (. bean5228 setSubject (simpleemail/content v5230))))
   bean5228))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Destination}
destination
  [m5232]
  (clojure.core/let
   [bean5231
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/let
    [v5233
     (:to-addresses m5232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5233 :com.palletops.awaze.client-builder/undef)
     (.
      bean5231
      setToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5367] (clojure.core/str arg5367))
 v5233))))
   (clojure.core/let
    [v5233
     (:cc-addresses m5232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5233 :com.palletops.awaze.client-builder/undef)
     (.
      bean5231
      setCcAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5368] (clojure.core/str arg5368))
 v5233))))
   (clojure.core/let
    [v5233
     (:bcc-addresses m5232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5233 :com.palletops.awaze.client-builder/undef)
     (.
      bean5231
      setBccAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5369] (clojure.core/str arg5369))
 v5233))))
   bean5231))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RawMessage}
raw-message
  [m5235]
  (clojure.core/let
   [bean5234
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/let
    [v5236 (:data m5235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5236 :com.palletops.awaze.client-builder/undef)
     (. bean5234 setData (clojure.core/identity v5236))))
   bean5234))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.IdentityType}
identity-type
  [m5238]
  (.
   com.amazonaws.services.simpleemail.model.IdentityType
   fromValue
   (clojure.core/name m5238)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest}
list-receipt-rule-sets-request
  [m5241]
  (clojure.core/let
   [bean5240
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest)]
   (clojure.core/let
    [v5242
     (:next-token m5241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5242 :com.palletops.awaze.client-builder/undef)
     (. bean5240 setNextToken (clojure.core/str v5242))))
   bean5240))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest}
verify-email-address-request
  [m5244]
  (clojure.core/let
   [bean5243
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/let
    [v5245
     (:email-address m5244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5245 :com.palletops.awaze.client-builder/undef)
     (. bean5243 setEmailAddress (clojure.core/str v5245))))
   bean5243))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest}
describe-active-receipt-rule-set-request
  [m5247]
  (clojure.core/let
   [bean5246
    (new
     com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest)]
   bean5246))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest}
list-receipt-filters-request
  [m5250]
  (clojure.core/let
   [bean5249
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest)]
   bean5249))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityRequest}
delete-identity-request
  [m5253]
  (clojure.core/let
   [bean5252
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/let
    [v5254
     (:identity m5253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5254 :com.palletops.awaze.client-builder/undef)
     (. bean5252 setIdentity (clojure.core/str v5254))))
   bean5252))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest}
verify-email-identity-request
  [m5256]
  (clojure.core/let
   [bean5255
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/let
    [v5257
     (:email-address m5256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5257 :com.palletops.awaze.client-builder/undef)
     (. bean5255 setEmailAddress (clojure.core/str v5257))))
   bean5255))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest}
list-verified-email-addresses-request
  [m5259]
  (clojure.core/let
   [bean5258
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean5258))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest}
describe-receipt-rule-request
  [m5262]
  (clojure.core/let
   [bean5261
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest)]
   (clojure.core/let
    [v5263
     (:rule-name m5262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5263 :com.palletops.awaze.client-builder/undef)
     (. bean5261 setRuleName (clojure.core/str v5263))))
   (clojure.core/let
    [v5263
     (:rule-set-name m5262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5263 :com.palletops.awaze.client-builder/undef)
     (. bean5261 setRuleSetName (clojure.core/str v5263))))
   bean5261))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest}
delete-receipt-filter-request
  [m5265]
  (clojure.core/let
   [bean5264
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest)]
   (clojure.core/let
    [v5266
     (:filter-name m5265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5266 :com.palletops.awaze.client-builder/undef)
     (. bean5264 setFilterName (clojure.core/str v5266))))
   bean5264))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest}
get-identity-verification-attributes-request
  [m5268]
  (clojure.core/let
   [bean5267
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/let
    [v5269
     (:identities m5268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5269 :com.palletops.awaze.client-builder/undef)
     (.
      bean5267
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5370] (clojure.core/str arg5370))
 v5269))))
   bean5267))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendQuotaRequest}
get-send-quota-request
  [m5271]
  (clojure.core/let
   [bean5270
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean5270))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest}
create-receipt-rule-set-request
  [m5274]
  (clojure.core/let
   [bean5273
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest)]
   (clojure.core/let
    [v5275
     (:rule-set-name m5274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5275 :com.palletops.awaze.client-builder/undef)
     (. bean5273 setRuleSetName (clojure.core/str v5275))))
   bean5273))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest}
set-identity-notification-topic-request
  [m5277]
  (clojure.core/let
   [bean5276
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/let
    [v5278
     (:notification-type
      m5277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5278 :com.palletops.awaze.client-builder/undef)
     (.
      bean5276
      setNotificationType
      (simpleemail/notification-type v5278))))
   (clojure.core/let
    [v5278
     (:sns-topic m5277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5278 :com.palletops.awaze.client-builder/undef)
     (. bean5276 setSnsTopic (clojure.core/str v5278))))
   (clojure.core/let
    [v5278
     (:identity m5277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5278 :com.palletops.awaze.client-builder/undef)
     (. bean5276 setIdentity (clojure.core/str v5278))))
   bean5276))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest}
verify-domain-identity-request
  [m5280]
  (clojure.core/let
   [bean5279
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/let
    [v5281 (:domain m5280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5281 :com.palletops.awaze.client-builder/undef)
     (. bean5279 setDomain (clojure.core/str v5281))))
   bean5279))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest}
list-identity-policies-request
  [m5283]
  (clojure.core/let
   [bean5282
    (new
     com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest)]
   (clojure.core/let
    [v5284
     (:identity m5283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5284 :com.palletops.awaze.client-builder/undef)
     (. bean5282 setIdentity (clojure.core/str v5284))))
   bean5282))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest}
create-receipt-filter-request
  [m5286]
  (clojure.core/let
   [bean5285
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest)]
   (clojure.core/let
    [v5287 (:filter m5286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5287 :com.palletops.awaze.client-builder/undef)
     (. bean5285 setFilter (simpleemail/receipt-filter v5287))))
   bean5285))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest}
put-identity-policy-request
  [m5289]
  (clojure.core/let
   [bean5288
    (new
     com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest)]
   (clojure.core/let
    [v5290 (:policy m5289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5290 :com.palletops.awaze.client-builder/undef)
     (. bean5288 setPolicy (clojure.core/str v5290))))
   (clojure.core/let
    [v5290
     (:identity m5289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5290 :com.palletops.awaze.client-builder/undef)
     (. bean5288 setIdentity (clojure.core/str v5290))))
   (clojure.core/let
    [v5290
     (:policy-name m5289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5290 :com.palletops.awaze.client-builder/undef)
     (. bean5288 setPolicyName (clojure.core/str v5290))))
   bean5288))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest}
verify-domain-dkim-request
  [m5292]
  (clojure.core/let
   [bean5291
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/let
    [v5293 (:domain m5292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5293 :com.palletops.awaze.client-builder/undef)
     (. bean5291 setDomain (clojure.core/str v5293))))
   bean5291))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest}
set-identity-mail-from-domain-request
  [m5295]
  (clojure.core/let
   [bean5294
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest)]
   (clojure.core/let
    [v5296
     (:behavior-on-mxfailure
      m5295
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5296 :com.palletops.awaze.client-builder/undef)
     (. bean5294 setBehaviorOnMXFailure (clojure.core/str v5296))))
   (clojure.core/let
    [v5296
     (:mail-from-domain
      m5295
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5296 :com.palletops.awaze.client-builder/undef)
     (. bean5294 setMailFromDomain (clojure.core/str v5296))))
   (clojure.core/let
    [v5296
     (:identity m5295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5296 :com.palletops.awaze.client-builder/undef)
     (. bean5294 setIdentity (clojure.core/str v5296))))
   bean5294))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest}
get-identity-notification-attributes-request
  [m5298]
  (clojure.core/let
   [bean5297
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/let
    [v5299
     (:identities m5298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5299 :com.palletops.awaze.client-builder/undef)
     (.
      bean5297
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5371] (clojure.core/str arg5371))
 v5299))))
   bean5297))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest}
delete-receipt-rule-request
  [m5301]
  (clojure.core/let
   [bean5300
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest)]
   (clojure.core/let
    [v5302
     (:rule-name m5301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5302 :com.palletops.awaze.client-builder/undef)
     (. bean5300 setRuleName (clojure.core/str v5302))))
   (clojure.core/let
    [v5302
     (:rule-set-name m5301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5302 :com.palletops.awaze.client-builder/undef)
     (. bean5300 setRuleSetName (clojure.core/str v5302))))
   bean5300))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest}
reorder-receipt-rule-set-request
  [m5304]
  (clojure.core/let
   [bean5303
    (new
     com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest)]
   (clojure.core/let
    [v5305
     (:rule-set-name m5304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5305 :com.palletops.awaze.client-builder/undef)
     (. bean5303 setRuleSetName (clojure.core/str v5305))))
   (clojure.core/let
    [v5305
     (:rule-names m5304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5305 :com.palletops.awaze.client-builder/undef)
     (.
      bean5303
      setRuleNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5372] (clojure.core/str arg5372))
 v5305))))
   bean5303))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest}
delete-receipt-rule-set-request
  [m5307]
  (clojure.core/let
   [bean5306
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest)]
   (clojure.core/let
    [v5308
     (:rule-set-name m5307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5308 :com.palletops.awaze.client-builder/undef)
     (. bean5306 setRuleSetName (clojure.core/str v5308))))
   bean5306))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest}
clone-receipt-rule-set-request
  [m5310]
  (clojure.core/let
   [bean5309
    (new
     com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest)]
   (clojure.core/let
    [v5311
     (:original-rule-set-name
      m5310
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5311 :com.palletops.awaze.client-builder/undef)
     (. bean5309 setOriginalRuleSetName (clojure.core/str v5311))))
   (clojure.core/let
    [v5311
     (:rule-set-name m5310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5311 :com.palletops.awaze.client-builder/undef)
     (. bean5309 setRuleSetName (clojure.core/str v5311))))
   bean5309))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendBounceRequest}
send-bounce-request
  [m5313]
  (clojure.core/let
   [bean5312
    (new com.amazonaws.services.simpleemail.model.SendBounceRequest)]
   (clojure.core/let
    [v5314
     (:original-message-id
      m5313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5314 :com.palletops.awaze.client-builder/undef)
     (. bean5312 setOriginalMessageId (clojure.core/str v5314))))
   (clojure.core/let
    [v5314
     (:bounce-sender m5313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5314 :com.palletops.awaze.client-builder/undef)
     (. bean5312 setBounceSender (clojure.core/str v5314))))
   (clojure.core/let
    [v5314
     (:explanation m5313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5314 :com.palletops.awaze.client-builder/undef)
     (. bean5312 setExplanation (clojure.core/str v5314))))
   (clojure.core/let
    [v5314
     (:message-dsn m5313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5314 :com.palletops.awaze.client-builder/undef)
     (. bean5312 setMessageDsn (simpleemail/message-dsn v5314))))
   (clojure.core/let
    [v5314
     (:bounced-recipient-info-list
      m5313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5314 :com.palletops.awaze.client-builder/undef)
     (.
      bean5312
      setBouncedRecipientInfoList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg5373]
  (simpleemail/bounced-recipient-info arg5373))
 v5314))))
   (clojure.core/let
    [v5314
     (:bounce-sender-arn
      m5313
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5314 :com.palletops.awaze.client-builder/undef)
     (. bean5312 setBounceSenderArn (clojure.core/str v5314))))
   bean5312))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest}
delete-identity-policy-request
  [m5316]
  (clojure.core/let
   [bean5315
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest)]
   (clojure.core/let
    [v5317
     (:identity m5316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5317 :com.palletops.awaze.client-builder/undef)
     (. bean5315 setIdentity (clojure.core/str v5317))))
   (clojure.core/let
    [v5317
     (:policy-name m5316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5317 :com.palletops.awaze.client-builder/undef)
     (. bean5315 setPolicyName (clojure.core/str v5317))))
   bean5315))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest}
get-send-statistics-request
  [m5319]
  (clojure.core/let
   [bean5318
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean5318))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest}
get-identity-dkim-attributes-request
  [m5322]
  (clojure.core/let
   [bean5321
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/let
    [v5323
     (:identities m5322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5323 :com.palletops.awaze.client-builder/undef)
     (.
      bean5321
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5374] (clojure.core/str arg5374))
 v5323))))
   bean5321))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest}
get-identity-mail-from-domain-attributes-request
  [m5325]
  (clojure.core/let
   [bean5324
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest)]
   (clojure.core/let
    [v5326
     (:identities m5325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5326 :com.palletops.awaze.client-builder/undef)
     (.
      bean5324
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5375] (clojure.core/str arg5375))
 v5326))))
   bean5324))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest}
delete-verified-email-address-request
  [m5328]
  (clojure.core/let
   [bean5327
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/let
    [v5329
     (:email-address m5328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5329 :com.palletops.awaze.client-builder/undef)
     (. bean5327 setEmailAddress (clojure.core/str v5329))))
   bean5327))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest}
create-receipt-rule-request
  [m5331]
  (clojure.core/let
   [bean5330
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest)]
   (clojure.core/let
    [v5332 (:rule m5331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5332 :com.palletops.awaze.client-builder/undef)
     (. bean5330 setRule (simpleemail/receipt-rule v5332))))
   (clojure.core/let
    [v5332
     (:rule-set-name m5331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5332 :com.palletops.awaze.client-builder/undef)
     (. bean5330 setRuleSetName (clojure.core/str v5332))))
   (clojure.core/let
    [v5332 (:after m5331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5332 :com.palletops.awaze.client-builder/undef)
     (. bean5330 setAfter (clojure.core/str v5332))))
   bean5330))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest}
describe-receipt-rule-set-request
  [m5334]
  (clojure.core/let
   [bean5333
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest)]
   (clojure.core/let
    [v5335
     (:rule-set-name m5334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5335 :com.palletops.awaze.client-builder/undef)
     (. bean5333 setRuleSetName (clojure.core/str v5335))))
   bean5333))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest}
get-identity-policies-request
  [m5337]
  (clojure.core/let
   [bean5336
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest)]
   (clojure.core/let
    [v5338
     (:identity m5337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5338 :com.palletops.awaze.client-builder/undef)
     (. bean5336 setIdentity (clojure.core/str v5338))))
   (clojure.core/let
    [v5338
     (:policy-names m5337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5338 :com.palletops.awaze.client-builder/undef)
     (.
      bean5336
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5376] (clojure.core/str arg5376))
 v5338))))
   bean5336))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest}
update-receipt-rule-request
  [m5340]
  (clojure.core/let
   [bean5339
    (new
     com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest)]
   (clojure.core/let
    [v5341 (:rule m5340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5341 :com.palletops.awaze.client-builder/undef)
     (. bean5339 setRule (simpleemail/receipt-rule v5341))))
   (clojure.core/let
    [v5341
     (:rule-set-name m5340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5341 :com.palletops.awaze.client-builder/undef)
     (. bean5339 setRuleSetName (clojure.core/str v5341))))
   bean5339))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest}
set-receipt-rule-position-request
  [m5343]
  (clojure.core/let
   [bean5342
    (new
     com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest)]
   (clojure.core/let
    [v5344
     (:rule-name m5343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5344 :com.palletops.awaze.client-builder/undef)
     (. bean5342 setRuleName (clojure.core/str v5344))))
   (clojure.core/let
    [v5344
     (:rule-set-name m5343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5344 :com.palletops.awaze.client-builder/undef)
     (. bean5342 setRuleSetName (clojure.core/str v5344))))
   (clojure.core/let
    [v5344 (:after m5343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5344 :com.palletops.awaze.client-builder/undef)
     (. bean5342 setAfter (clojure.core/str v5344))))
   bean5342))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest}
set-identity-dkim-enabled-request
  [m5346]
  (clojure.core/let
   [bean5345
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/let
    [v5347
     (:dkim-enabled m5346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5347 :com.palletops.awaze.client-builder/undef)
     (. bean5345 setDkimEnabled (clojure.core/boolean v5347))))
   (clojure.core/let
    [v5347
     (:identity m5346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5347 :com.palletops.awaze.client-builder/undef)
     (. bean5345 setIdentity (clojure.core/str v5347))))
   bean5345))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendEmailRequest}
send-email-request
  [m5349]
  (clojure.core/let
   [bean5348
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/let
    [v5350 (:message m5349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (. bean5348 setMessage (simpleemail/message v5350))))
   (clojure.core/let
    [v5350 (:source m5349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (. bean5348 setSource (clojure.core/str v5350))))
   (clojure.core/let
    [v5350
     (:destination m5349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (. bean5348 setDestination (simpleemail/destination v5350))))
   (clojure.core/let
    [v5350
     (:reply-to-addresses
      m5349
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (.
      bean5348
      setReplyToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5377] (clojure.core/str arg5377))
 v5350))))
   (clojure.core/let
    [v5350
     (:return-path m5349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (. bean5348 setReturnPath (clojure.core/str v5350))))
   (clojure.core/let
    [v5350
     (:source-arn m5349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (. bean5348 setSourceArn (clojure.core/str v5350))))
   (clojure.core/let
    [v5350
     (:return-path-arn
      m5349
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5350 :com.palletops.awaze.client-builder/undef)
     (. bean5348 setReturnPathArn (clojure.core/str v5350))))
   bean5348))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest}
set-identity-feedback-forwarding-enabled-request
  [m5352]
  (clojure.core/let
   [bean5351
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/let
    [v5353
     (:forwarding-enabled
      m5352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5353 :com.palletops.awaze.client-builder/undef)
     (. bean5351 setForwardingEnabled (clojure.core/boolean v5353))))
   (clojure.core/let
    [v5353
     (:identity m5352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5353 :com.palletops.awaze.client-builder/undef)
     (. bean5351 setIdentity (clojure.core/str v5353))))
   bean5351))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendRawEmailRequest}
send-raw-email-request
  [m5355]
  (clojure.core/let
   [bean5354
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/let
    [v5356
     (:raw-message m5355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5356 :com.palletops.awaze.client-builder/undef)
     (. bean5354 setRawMessage (simpleemail/raw-message v5356))))
   (clojure.core/let
    [v5356
     (:destinations m5355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5356 :com.palletops.awaze.client-builder/undef)
     (.
      bean5354
      setDestinations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5474] (clojure.core/str arg5474))
 v5356))))
   (clojure.core/let
    [v5356
     (:from-arn m5355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5356 :com.palletops.awaze.client-builder/undef)
     (. bean5354 setFromArn (clojure.core/str v5356))))
   (clojure.core/let
    [v5356 (:source m5355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5356 :com.palletops.awaze.client-builder/undef)
     (. bean5354 setSource (clojure.core/str v5356))))
   (clojure.core/let
    [v5356
     (:source-arn m5355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5356 :com.palletops.awaze.client-builder/undef)
     (. bean5354 setSourceArn (clojure.core/str v5356))))
   (clojure.core/let
    [v5356
     (:return-path-arn
      m5355
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5356 :com.palletops.awaze.client-builder/undef)
     (. bean5354 setReturnPathArn (clojure.core/str v5356))))
   bean5354))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest}
set-active-receipt-rule-set-request
  [m5358]
  (clojure.core/let
   [bean5357
    (new
     com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest)]
   (clojure.core/let
    [v5359
     (:rule-set-name m5358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5359 :com.palletops.awaze.client-builder/undef)
     (. bean5357 setRuleSetName (clojure.core/str v5359))))
   bean5357))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentitiesRequest}
list-identities-request
  [m5361]
  (clojure.core/let
   [bean5360
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/let
    [v5362
     (:identity-type m5361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5362 :com.palletops.awaze.client-builder/undef)
     (. bean5360 setIdentityType (simpleemail/identity-type v5362))))
   (clojure.core/let
    [v5362
     (:max-items m5361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5362 :com.palletops.awaze.client-builder/undef)
     (. bean5360 setMaxItems (clojure.core/int v5362))))
   (clojure.core/let
    [v5362
     (:next-token m5361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5362 :com.palletops.awaze.client-builder/undef)
     (. bean5360 setNextToken (clojure.core/str v5362))))
   bean5360))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-rule-sets
   [m5378]
   (clojure.core/let
    [credentials5379 (:credentials m5378) args5380 (:args m5378)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5381
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5379)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5381
       listReceiptRuleSets
       (simpleemail/list-receipt-rule-sets-request
        (clojure.core/nth args5380 0)))))))
  (clojure.core/defn
   list-receipt-rule-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listReceiptRuleSets"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-receipt-rule-sets,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-rule-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listReceiptRuleSets"}
   [credentials5383 & args5384]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5385
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5383)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5385
      listReceiptRuleSets
      (simpleemail/list-receipt-rule-sets-request
       (clojure.core/nth args5384 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m5386]
   (clojure.core/let
    [credentials5387 (:credentials m5386) args5388 (:args m5386)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5389
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5387)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5389
       verifyEmailAddress
       (simpleemail/verify-email-address-request
        (clojure.core/nth args5388 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :verify-email-address,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials5391 & args5392]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5393
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5391)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5393
      verifyEmailAddress
      (simpleemail/verify-email-address-request
       (clojure.core/nth args5392 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-active-receipt-rule-set
   [m5394]
   (clojure.core/let
    [credentials5395 (:credentials m5394) args5396 (:args m5394)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5397
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5395)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5397
       describeActiveReceiptRuleSet
       (simpleemail/describe-active-receipt-rule-set-request
        (clojure.core/nth args5396 0)))))))
  (clojure.core/defn
   describe-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeActiveReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-active-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeActiveReceiptRuleSet"}
   [credentials5399 & args5400]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5401
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5399)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5401
      describeActiveReceiptRuleSet
      (simpleemail/describe-active-receipt-rule-set-request
       (clojure.core/nth args5400 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-filters
   [m5402]
   (clojure.core/let
    [credentials5403 (:credentials m5402) args5404 (:args m5402)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5405
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5403)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5405
       listReceiptFilters
       (simpleemail/list-receipt-filters-request
        (clojure.core/nth args5404 0)))))))
  (clojure.core/defn
   list-receipt-filters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listReceiptFilters"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-receipt-filters,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-filters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listReceiptFilters"}
   [credentials5407 & args5408]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5409
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5407)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5409
      listReceiptFilters
      (simpleemail/list-receipt-filters-request
       (clojure.core/nth args5408 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m5410]
   (clojure.core/let
    [credentials5411 (:credentials m5410) args5412 (:args m5410)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5413
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5411)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5413
       deleteIdentity
       (simpleemail/delete-identity-request
        (clojure.core/nth args5412 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-identity,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentity"}
   [credentials5415 & args5416]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5417
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5415)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5417
      deleteIdentity
      (simpleemail/delete-identity-request
       (clojure.core/nth args5416 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m5418]
   (clojure.core/let
    [credentials5419 (:credentials m5418) args5420 (:args m5418)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5421
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5419)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5421
       verifyEmailIdentity
       (simpleemail/verify-email-identity-request
        (clojure.core/nth args5420 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :verify-email-identity,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials5423 & args5424]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5425
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5423)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5425
      verifyEmailIdentity
      (simpleemail/verify-email-identity-request
       (clojure.core/nth args5424 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m5426]
   (clojure.core/let
    [credentials5427 (:credentials m5426) args5428 (:args m5426)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5429
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5427)]
     (clojure.core/case
      (clojure.core/count args5428)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5429
        listVerifiedEmailAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5429
        listVerifiedEmailAddresses
        (simpleemail/list-verified-email-addresses-request
         (clojure.core/nth args5428 0))))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-verified-email-addresses,
     :credentials credentials__1784__auto__,
     :client :simpleemail})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-verified-email-addresses,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials5431 & args5432]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5433
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5431)]
    (clojure.core/case
     (clojure.core/count args5432)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5433
       listVerifiedEmailAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5433
       listVerifiedEmailAddresses
       (simpleemail/list-verified-email-addresses-request
        (clojure.core/nth args5432 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule
   [m5434]
   (clojure.core/let
    [credentials5435 (:credentials m5434) args5436 (:args m5434)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5437
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5435)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5437
       describeReceiptRule
       (simpleemail/describe-receipt-rule-request
        (clojure.core/nth args5436 0)))))))
  (clojure.core/defn
   describe-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for describeReceiptRule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call describeReceiptRule"}
   [credentials5439 & args5440]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5441
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5439)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5441
      describeReceiptRule
      (simpleemail/describe-receipt-rule-request
       (clojure.core/nth args5440 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-filter
   [m5442]
   (clojure.core/let
    [credentials5443 (:credentials m5442) args5444 (:args m5442)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5445
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5443)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5445
       deleteReceiptFilter
       (simpleemail/delete-receipt-filter-request
        (clojure.core/nth args5444 0)))))))
  (clojure.core/defn
   delete-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptFilter"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-receipt-filter,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptFilter"}
   [credentials5447 & args5448]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5449
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5447)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5449
      deleteReceiptFilter
      (simpleemail/delete-receipt-filter-request
       (clojure.core/nth args5448 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m5450]
   (clojure.core/let
    [credentials5451 (:credentials m5450) args5452 (:args m5450)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5453
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5451)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5453
       getIdentityVerificationAttributes
       (simpleemail/get-identity-verification-attributes-request
        (clojure.core/nth args5452 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-identity-verification-attributes,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials5455 & args5456]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5457
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5455)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5457
      getIdentityVerificationAttributes
      (simpleemail/get-identity-verification-attributes-request
       (clojure.core/nth args5456 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m5458]
   (clojure.core/let
    [credentials5459 (:credentials m5458) args5460 (:args m5458)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5461
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5459)]
     (clojure.core/case
      (clojure.core/count args5460)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5461
        getSendQuota))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5461
        getSendQuota
        (simpleemail/get-send-quota-request
         (clojure.core/nth args5460 0))))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-send-quota,
     :credentials credentials__1784__auto__,
     :client :simpleemail})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-send-quota,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials5463 & args5464]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5465
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5463)]
    (clojure.core/case
     (clojure.core/count args5464)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5465
       getSendQuota))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5465
       getSendQuota
       (simpleemail/get-send-quota-request
        (clojure.core/nth args5464 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule-set
   [m5466]
   (clojure.core/let
    [credentials5467 (:credentials m5466) args5468 (:args m5466)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5469
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5467)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5469
       createReceiptRuleSet
       (simpleemail/create-receipt-rule-set-request
        (clojure.core/nth args5468 0)))))))
  (clojure.core/defn
   create-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRuleSet"}
   [credentials5471 & args5472]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5473
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5471)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5473
      createReceiptRuleSet
      (simpleemail/create-receipt-rule-set-request
       (clojure.core/nth args5472 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m5475]
   (clojure.core/let
    [credentials5476 (:credentials m5475) args5477 (:args m5475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5478
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5478
       setIdentityNotificationTopic
       (simpleemail/set-identity-notification-topic-request
        (clojure.core/nth args5477 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-identity-notification-topic,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials5480 & args5481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5482
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5482
      setIdentityNotificationTopic
      (simpleemail/set-identity-notification-topic-request
       (clojure.core/nth args5481 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m5483]
   (clojure.core/let
    [credentials5484 (:credentials m5483) args5485 (:args m5483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5486
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5486
       verifyDomainIdentity
       (simpleemail/verify-domain-identity-request
        (clojure.core/nth args5485 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :verify-domain-identity,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials5488 & args5489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5490
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5490
      verifyDomainIdentity
      (simpleemail/verify-domain-identity-request
       (clojure.core/nth args5489 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identity-policies
   [m5491]
   (clojure.core/let
    [credentials5492 (:credentials m5491) args5493 (:args m5491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5494
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5494
       listIdentityPolicies
       (simpleemail/list-identity-policies-request
        (clojure.core/nth args5493 0)))))))
  (clojure.core/defn
   list-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listIdentityPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-identity-policies,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listIdentityPolicies"}
   [credentials5496 & args5497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5498
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5498
      listIdentityPolicies
      (simpleemail/list-identity-policies-request
       (clojure.core/nth args5497 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-filter
   [m5499]
   (clojure.core/let
    [credentials5500 (:credentials m5499) args5501 (:args m5499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5502
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5500)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5502
       createReceiptFilter
       (simpleemail/create-receipt-filter-request
        (clojure.core/nth args5501 0)))))))
  (clojure.core/defn
   create-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptFilter"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-receipt-filter,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptFilter"}
   [credentials5504 & args5505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5506
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5506
      createReceiptFilter
      (simpleemail/create-receipt-filter-request
       (clojure.core/nth args5505 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :put-identity-policy
   [m5507]
   (clojure.core/let
    [credentials5508 (:credentials m5507) args5509 (:args m5507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5510
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5510
       putIdentityPolicy
       (simpleemail/put-identity-policy-request
        (clojure.core/nth args5509 0)))))))
  (clojure.core/defn
   put-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putIdentityPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-identity-policy,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   put-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putIdentityPolicy"}
   [credentials5512 & args5513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5514
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5514
      putIdentityPolicy
      (simpleemail/put-identity-policy-request
       (clojure.core/nth args5513 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m5515]
   (clojure.core/let
    [credentials5516 (:credentials m5515) args5517 (:args m5515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5518
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5518
       verifyDomainDkim
       (simpleemail/verify-domain-dkim-request
        (clojure.core/nth args5517 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :verify-domain-dkim,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials5520 & args5521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5522
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5522
      verifyDomainDkim
      (simpleemail/verify-domain-dkim-request
       (clojure.core/nth args5521 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-mail-from-domain
   [m5523]
   (clojure.core/let
    [credentials5524 (:credentials m5523) args5525 (:args m5523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5526
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5524)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5526
       setIdentityMailFromDomain
       (simpleemail/set-identity-mail-from-domain-request
        (clojure.core/nth args5525 0)))))))
  (clojure.core/defn
   set-identity-mail-from-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Generate map for setIdentityMailFromDomain"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-identity-mail-from-domain,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-mail-from-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Call setIdentityMailFromDomain"}
   [credentials5528 & args5529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5530
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5528)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5530
      setIdentityMailFromDomain
      (simpleemail/set-identity-mail-from-domain-request
       (clojure.core/nth args5529 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m5531]
   (clojure.core/let
    [credentials5532 (:credentials m5531) args5533 (:args m5531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5534
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5532)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5534
       getIdentityNotificationAttributes
       (simpleemail/get-identity-notification-attributes-request
        (clojure.core/nth args5533 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-identity-notification-attributes,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials5536 & args5537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5538
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5536)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5538
      getIdentityNotificationAttributes
      (simpleemail/get-identity-notification-attributes-request
       (clojure.core/nth args5537 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule
   [m5539]
   (clojure.core/let
    [credentials5540 (:credentials m5539) args5541 (:args m5539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5542
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5540)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5542
       deleteReceiptRule
       (simpleemail/delete-receipt-rule-request
        (clojure.core/nth args5541 0)))))))
  (clojure.core/defn
   delete-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for deleteReceiptRule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call deleteReceiptRule"}
   [credentials5544 & args5545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5546
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5544)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5546
      deleteReceiptRule
      (simpleemail/delete-receipt-rule-request
       (clojure.core/nth args5545 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :reorder-receipt-rule-set
   [m5547]
   (clojure.core/let
    [credentials5548 (:credentials m5547) args5549 (:args m5547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5550
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5550
       reorderReceiptRuleSet
       (simpleemail/reorder-receipt-rule-set-request
        (clojure.core/nth args5549 0)))))))
  (clojure.core/defn
   reorder-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reorderReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reorder-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   reorder-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reorderReceiptRuleSet"}
   [credentials5552 & args5553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5554
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5554
      reorderReceiptRuleSet
      (simpleemail/reorder-receipt-rule-set-request
       (clojure.core/nth args5553 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule-set
   [m5555]
   (clojure.core/let
    [credentials5556 (:credentials m5555) args5557 (:args m5555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5558
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5558
       deleteReceiptRuleSet
       (simpleemail/delete-receipt-rule-set-request
        (clojure.core/nth args5557 0)))))))
  (clojure.core/defn
   delete-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptRuleSet"}
   [credentials5560 & args5561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5562
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5562
      deleteReceiptRuleSet
      (simpleemail/delete-receipt-rule-set-request
       (clojure.core/nth args5561 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :clone-receipt-rule-set
   [m5563]
   (clojure.core/let
    [credentials5564 (:credentials m5563) args5565 (:args m5563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5566
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5566
       cloneReceiptRuleSet
       (simpleemail/clone-receipt-rule-set-request
        (clojure.core/nth args5565 0)))))))
  (clojure.core/defn
   clone-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cloneReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :clone-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   clone-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cloneReceiptRuleSet"}
   [credentials5568 & args5569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5570
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5570
      cloneReceiptRuleSet
      (simpleemail/clone-receipt-rule-set-request
       (clojure.core/nth args5569 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-bounce
   [m5571]
   (clojure.core/let
    [credentials5572 (:credentials m5571) args5573 (:args m5571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5574
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5574
       sendBounce
       (simpleemail/send-bounce-request (clojure.core/nth args5573 0)))))))
  (clojure.core/defn
   send-bounce-map
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Generate map for sendBounce"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :send-bounce,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-bounce
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Call sendBounce"}
   [credentials5576 & args5577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5578
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5578
      sendBounce
      (simpleemail/send-bounce-request (clojure.core/nth args5577 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity-policy
   [m5579]
   (clojure.core/let
    [credentials5580 (:credentials m5579) args5581 (:args m5579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5582
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5582
       deleteIdentityPolicy
       (simpleemail/delete-identity-policy-request
        (clojure.core/nth args5581 0)))))))
  (clojure.core/defn
   delete-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentityPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-identity-policy,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentityPolicy"}
   [credentials5584 & args5585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5586
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5586
      deleteIdentityPolicy
      (simpleemail/delete-identity-policy-request
       (clojure.core/nth args5585 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m5587]
   (clojure.core/let
    [credentials5588 (:credentials m5587) args5589 (:args m5587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5590
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5588)]
     (clojure.core/case
      (clojure.core/count args5589)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5590
        getSendStatistics
        (simpleemail/get-send-statistics-request
         (clojure.core/nth args5589 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5590
        getSendStatistics))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-send-statistics,
     :credentials credentials__1784__auto__,
     :client :simpleemail})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-send-statistics,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials5592 & args5593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5594
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5592)]
    (clojure.core/case
     (clojure.core/count args5593)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5594
       getSendStatistics
       (simpleemail/get-send-statistics-request
        (clojure.core/nth args5593 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5594
       getSendStatistics))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m5595]
   (clojure.core/let
    [credentials5596 (:credentials m5595) args5597 (:args m5595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5598
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5598
       getIdentityDkimAttributes
       (simpleemail/get-identity-dkim-attributes-request
        (clojure.core/nth args5597 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials5600 & args5601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5602
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5602
      getIdentityDkimAttributes
      (simpleemail/get-identity-dkim-attributes-request
       (clojure.core/nth args5601 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-mail-from-domain-attributes
   [m5603]
   (clojure.core/let
    [credentials5604 (:credentials m5603) args5605 (:args m5603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5606
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5606
       getIdentityMailFromDomainAttributes
       (simpleemail/get-identity-mail-from-domain-attributes-request
        (clojure.core/nth args5605 0)))))))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityMailFromDomainAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-identity-mail-from-domain-attributes,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityMailFromDomainAttributes"}
   [credentials5608 & args5609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5610
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5610
      getIdentityMailFromDomainAttributes
      (simpleemail/get-identity-mail-from-domain-attributes-request
       (clojure.core/nth args5609 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m5611]
   (clojure.core/let
    [credentials5612 (:credentials m5611) args5613 (:args m5611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5614
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5614
       deleteVerifiedEmailAddress
       (simpleemail/delete-verified-email-address-request
        (clojure.core/nth args5613 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-verified-email-address,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials5616 & args5617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5618
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5618
      deleteVerifiedEmailAddress
      (simpleemail/delete-verified-email-address-request
       (clojure.core/nth args5617 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule
   [m5619]
   (clojure.core/let
    [credentials5620 (:credentials m5619) args5621 (:args m5619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5622
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5622
       createReceiptRule
       (simpleemail/create-receipt-rule-request
        (clojure.core/nth args5621 0)))))))
  (clojure.core/defn
   create-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-receipt-rule,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRule"}
   [credentials5624 & args5625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5626
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5626
      createReceiptRule
      (simpleemail/create-receipt-rule-request
       (clojure.core/nth args5625 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule-set
   [m5627]
   (clojure.core/let
    [credentials5628 (:credentials m5627) args5629 (:args m5627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5630
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5630
       describeReceiptRuleSet
       (simpleemail/describe-receipt-rule-set-request
        (clojure.core/nth args5629 0)))))))
  (clojure.core/defn
   describe-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReceiptRuleSet"}
   [credentials5632 & args5633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5634
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5634
      describeReceiptRuleSet
      (simpleemail/describe-receipt-rule-set-request
       (clojure.core/nth args5633 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-policies
   [m5635]
   (clojure.core/let
    [credentials5636 (:credentials m5635) args5637 (:args m5635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5638
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5638
       getIdentityPolicies
       (simpleemail/get-identity-policies-request
        (clojure.core/nth args5637 0)))))))
  (clojure.core/defn
   get-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getIdentityPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-identity-policies,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getIdentityPolicies"}
   [credentials5640 & args5641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5642
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5642
      getIdentityPolicies
      (simpleemail/get-identity-policies-request
       (clojure.core/nth args5641 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :update-receipt-rule
   [m5643]
   (clojure.core/let
    [credentials5644 (:credentials m5643) args5645 (:args m5643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5646
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5646
       updateReceiptRule
       (simpleemail/update-receipt-rule-request
        (clojure.core/nth args5645 0)))))))
  (clojure.core/defn
   update-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateReceiptRule"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-receipt-rule,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   update-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateReceiptRule"}
   [credentials5648 & args5649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5650
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5650
      updateReceiptRule
      (simpleemail/update-receipt-rule-request
       (clojure.core/nth args5649 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-receipt-rule-position
   [m5651]
   (clojure.core/let
    [credentials5652 (:credentials m5651) args5653 (:args m5651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5654
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5654
       setReceiptRulePosition
       (simpleemail/set-receipt-rule-position-request
        (clojure.core/nth args5653 0)))))))
  (clojure.core/defn
   set-receipt-rule-position-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for setReceiptRulePosition"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-receipt-rule-position,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-receipt-rule-position
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call setReceiptRulePosition"}
   [credentials5656 & args5657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5658
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5658
      setReceiptRulePosition
      (simpleemail/set-receipt-rule-position-request
       (clojure.core/nth args5657 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m5659]
   (clojure.core/let
    [credentials5660 (:credentials m5659) args5661 (:args m5659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5662
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5662
       setIdentityDkimEnabled
       (simpleemail/set-identity-dkim-enabled-request
        (clojure.core/nth args5661 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials5664 & args5665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5666
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5666
      setIdentityDkimEnabled
      (simpleemail/set-identity-dkim-enabled-request
       (clojure.core/nth args5665 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m5667]
   (clojure.core/let
    [credentials5668 (:credentials m5667) args5669 (:args m5667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5670
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5670
       sendEmail
       (simpleemail/send-email-request (clojure.core/nth args5669 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :send-email,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Call sendEmail"}
   [credentials5672 & args5673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5674
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5674
      sendEmail
      (simpleemail/send-email-request (clojure.core/nth args5673 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m5675]
   (clojure.core/let
    [credentials5676 (:credentials m5675) args5677 (:args m5675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5678
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5678
       setIdentityFeedbackForwardingEnabled
       (simpleemail/set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args5677 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials5680 & args5681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5682
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5682
      setIdentityFeedbackForwardingEnabled
      (simpleemail/set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args5681 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m5683]
   (clojure.core/let
    [credentials5684 (:credentials m5683) args5685 (:args m5683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5686
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5686
       sendRawEmail
       (simpleemail/send-raw-email-request
        (clojure.core/nth args5685 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :send-raw-email,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Call sendRawEmail"}
   [credentials5688 & args5689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5690
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5690
      sendRawEmail
      (simpleemail/send-raw-email-request
       (clojure.core/nth args5689 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-active-receipt-rule-set
   [m5691]
   (clojure.core/let
    [credentials5692 (:credentials m5691) args5693 (:args m5691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5694
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5694
       setActiveReceiptRuleSet
       (simpleemail/set-active-receipt-rule-set-request
        (clojure.core/nth args5693 0)))))))
  (clojure.core/defn
   set-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setActiveReceiptRuleSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-active-receipt-rule-set,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setActiveReceiptRuleSet"}
   [credentials5696 & args5697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5698
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5698
      setActiveReceiptRuleSet
      (simpleemail/set-active-receipt-rule-set-request
       (clojure.core/nth args5697 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m5699]
   (clojure.core/let
    [credentials5700 (:credentials m5699) args5701 (:args m5699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5702
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5700)]
     (clojure.core/case
      (clojure.core/count args5701)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5702
        listIdentities
        (simpleemail/list-identities-request
         (clojure.core/nth args5701 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5702
        listIdentities))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-identities,
     :credentials credentials__1784__auto__,
     :client :simpleemail})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-identities,
     :credentials credentials__1784__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials5704 & args5705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5706
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5704)]
    (clojure.core/case
     (clojure.core/count args5705)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5706
       listIdentities
       (simpleemail/list-identities-request
        (clojure.core/nth args5705 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5706
       listIdentities)))))))
