(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m8667]
  (clojure.core/let
   [bean8666
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/let
    [v8668 (:name m8667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8668 :com.palletops.awaze.client-builder/undef)
     (. bean8666 setName (clojure.core/str v8668))))
   (clojure.core/let
    [v8668 (:value m8667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8668 :com.palletops.awaze.client-builder/undef)
     (. bean8666 setValue (clojure.core/str v8668))))
   (clojure.core/let
    [v8668 (:replace m8667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8668 :com.palletops.awaze.client-builder/undef)
     (. bean8666 setReplace (clojure.core/boolean v8668))))
   bean8666))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m8670]
  (clojure.core/let
   [bean8669 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/let
    [v8671 (:name m8670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8671 :com.palletops.awaze.client-builder/undef)
     (. bean8669 setName (clojure.core/str v8671))))
   (clojure.core/let
    [v8671 (:value m8670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8671 :com.palletops.awaze.client-builder/undef)
     (. bean8669 setValue (clojure.core/str v8671))))
   (clojure.core/let
    [v8671
     (:alternate-name-encoding
      m8670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8671 :com.palletops.awaze.client-builder/undef)
     (. bean8669 setAlternateNameEncoding (clojure.core/str v8671))))
   (clojure.core/let
    [v8671
     (:alternate-value-encoding
      m8670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8671 :com.palletops.awaze.client-builder/undef)
     (. bean8669 setAlternateValueEncoding (clojure.core/str v8671))))
   bean8669))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m8673]
  (clojure.core/let
   [bean8672
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/let
    [v8674 (:name m8673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8674 :com.palletops.awaze.client-builder/undef)
     (. bean8672 setName (clojure.core/str v8674))))
   (clojure.core/let
    [v8674
     (:attributes m8673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8674 :com.palletops.awaze.client-builder/undef)
     (.
      bean8672
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8711] (simpledb/replaceable-attribute arg8711))
 v8674))))
   bean8672))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m8676]
  (clojure.core/let
   [bean8675
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/let
    [v8677 (:name m8676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8677 :com.palletops.awaze.client-builder/undef)
     (. bean8675 setName (clojure.core/str v8677))))
   (clojure.core/let
    [v8677
     (:attributes m8676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8677 :com.palletops.awaze.client-builder/undef)
     (.
      bean8675
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8712] (simpledb/attribute arg8712))
 v8677))))
   bean8675))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m8679]
  (clojure.core/let
   [bean8678
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/let
    [v8680 (:name m8679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8680 :com.palletops.awaze.client-builder/undef)
     (. bean8678 setName (clojure.core/str v8680))))
   (clojure.core/let
    [v8680 (:value m8679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8680 :com.palletops.awaze.client-builder/undef)
     (. bean8678 setValue (clojure.core/str v8680))))
   (clojure.core/let
    [v8680 (:exists m8679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8680 :com.palletops.awaze.client-builder/undef)
     (. bean8678 setExists (clojure.core/boolean v8680))))
   bean8678))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m8682]
  (clojure.core/let
   [bean8681
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/let
    [v8683
     (:next-token m8682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8683 :com.palletops.awaze.client-builder/undef)
     (. bean8681 setNextToken (clojure.core/str v8683))))
   (clojure.core/let
    [v8683
     (:max-number-of-domains
      m8682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8683 :com.palletops.awaze.client-builder/undef)
     (. bean8681 setMaxNumberOfDomains (clojure.core/int v8683))))
   bean8681))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m8685]
  (clojure.core/let
   [bean8684
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/let
    [v8686
     (:domain-name m8685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8686 :com.palletops.awaze.client-builder/undef)
     (. bean8684 setDomainName (clojure.core/str v8686))))
   bean8684))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m8688]
  (clojure.core/let
   [bean8687
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/let
    [v8689
     (:domain-name m8688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8689 :com.palletops.awaze.client-builder/undef)
     (. bean8687 setDomainName (clojure.core/str v8689))))
   bean8687))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m8691]
  (clojure.core/let
   [bean8690
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/let
    [v8692
     (:domain-name m8691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8692 :com.palletops.awaze.client-builder/undef)
     (. bean8690 setDomainName (clojure.core/str v8692))))
   (clojure.core/let
    [v8692 (:items m8691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8692 :com.palletops.awaze.client-builder/undef)
     (.
      bean8690
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8713] (simpledb/replaceable-item arg8713))
 v8692))))
   bean8690))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m8694]
  (clojure.core/let
   [bean8693
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/let
    [v8695
     (:domain-name m8694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8695 :com.palletops.awaze.client-builder/undef)
     (. bean8693 setDomainName (clojure.core/str v8695))))
   (clojure.core/let
    [v8695 (:items m8694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8695 :com.palletops.awaze.client-builder/undef)
     (.
      bean8693
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8714] (simpledb/deletable-item arg8714))
 v8695))))
   bean8693))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m8697]
  (clojure.core/let
   [bean8696
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/let
    [v8698
     (:domain-name m8697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8698 :com.palletops.awaze.client-builder/undef)
     (. bean8696 setDomainName (clojure.core/str v8698))))
   (clojure.core/let
    [v8698
     (:attribute-names
      m8697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8698 :com.palletops.awaze.client-builder/undef)
     (.
      bean8696
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8715] (clojure.core/str arg8715))
 v8698))))
   (clojure.core/let
    [v8698
     (:item-name m8697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8698 :com.palletops.awaze.client-builder/undef)
     (. bean8696 setItemName (clojure.core/str v8698))))
   (clojure.core/let
    [v8698
     (:consistent-read
      m8697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8698 :com.palletops.awaze.client-builder/undef)
     (. bean8696 setConsistentRead (clojure.core/boolean v8698))))
   bean8696))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m8700]
  (clojure.core/let
   [bean8699
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/let
    [v8701
     (:domain-name m8700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8701 :com.palletops.awaze.client-builder/undef)
     (. bean8699 setDomainName (clojure.core/str v8701))))
   (clojure.core/let
    [v8701
     (:attributes m8700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8701 :com.palletops.awaze.client-builder/undef)
     (.
      bean8699
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8716] (simpledb/replaceable-attribute arg8716))
 v8701))))
   (clojure.core/let
    [v8701
     (:item-name m8700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8701 :com.palletops.awaze.client-builder/undef)
     (. bean8699 setItemName (clojure.core/str v8701))))
   (clojure.core/let
    [v8701
     (:expected m8700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8701 :com.palletops.awaze.client-builder/undef)
     (. bean8699 setExpected (simpledb/update-condition v8701))))
   bean8699))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m8703]
  (clojure.core/let
   [bean8702
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/let
    [v8704
     (:domain-name m8703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8704 :com.palletops.awaze.client-builder/undef)
     (. bean8702 setDomainName (clojure.core/str v8704))))
   (clojure.core/let
    [v8704
     (:attributes m8703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8704 :com.palletops.awaze.client-builder/undef)
     (.
      bean8702
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8717] (simpledb/attribute arg8717))
 v8704))))
   (clojure.core/let
    [v8704
     (:item-name m8703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8704 :com.palletops.awaze.client-builder/undef)
     (. bean8702 setItemName (clojure.core/str v8704))))
   (clojure.core/let
    [v8704
     (:expected m8703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8704 :com.palletops.awaze.client-builder/undef)
     (. bean8702 setExpected (simpledb/update-condition v8704))))
   bean8702))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m8706]
  (clojure.core/let
   [bean8705
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/let
    [v8707
     (:domain-name m8706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8707 :com.palletops.awaze.client-builder/undef)
     (. bean8705 setDomainName (clojure.core/str v8707))))
   bean8705))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m8709]
  (clojure.core/let
   [bean8708
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/let
    [v8710
     (:next-token m8709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8710 :com.palletops.awaze.client-builder/undef)
     (. bean8708 setNextToken (clojure.core/str v8710))))
   (clojure.core/let
    [v8710
     (:consistent-read
      m8709
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8710 :com.palletops.awaze.client-builder/undef)
     (. bean8708 setConsistentRead (clojure.core/boolean v8710))))
   (clojure.core/let
    [v8710
     (:select-expression
      m8709
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8710 :com.palletops.awaze.client-builder/undef)
     (. bean8708 setSelectExpression (clojure.core/str v8710))))
   bean8708))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m8718]
   (clojure.core/let
    [credentials8719 (:credentials m8718) args8720 (:args m8718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8721
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8719)]
     (clojure.core/case
      (clojure.core/count args8720)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8721
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args8720 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8721
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-domains,
     :credentials credentials__1784__auto__,
     :client :simpledb})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-domains,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials8723 & args8724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8725
     (com.palletops.awaze.common/aws-client :simpledb credentials8723)]
    (clojure.core/case
     (clojure.core/count args8724)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8725
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args8724 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8725
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m8726]
   (clojure.core/let
    [credentials8727 (:credentials m8726) args8728 (:args m8726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8729
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8727)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8729
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args8728 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8731 & args8732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8733
     (com.palletops.awaze.common/aws-client :simpledb credentials8731)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8733
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args8732 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m8734]
   (clojure.core/let
    [credentials8735 (:credentials m8734) args8736 (:args m8734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8737
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8735)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8737
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args8736 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :domain-metadata,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call domainMetadata"}
   [credentials8739 & args8740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8741
     (com.palletops.awaze.common/aws-client :simpledb credentials8739)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8741
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args8740 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m8742]
   (clojure.core/let
    [credentials8743 (:credentials m8742) args8744 (:args m8742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8745
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8743)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8745
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args8744 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :batch-put-attributes,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchPutAttributes"}
   [credentials8747 & args8748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8749
     (com.palletops.awaze.common/aws-client :simpledb credentials8747)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8749
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args8748 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m8750]
   (clojure.core/let
    [credentials8751 (:credentials m8750) args8752 (:args m8750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8753
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8753
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args8752 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :batch-delete-attributes,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials8755 & args8756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8757
     (com.palletops.awaze.common/aws-client :simpledb credentials8755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8757
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args8756 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m8758]
   (clojure.core/let
    [credentials8759 (:credentials m8758) args8760 (:args m8758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8761
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8761
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args8760 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-attributes,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAttributes"}
   [credentials8763 & args8764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8765
     (com.palletops.awaze.common/aws-client :simpledb credentials8763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8765
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args8764 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m8766]
   (clojure.core/let
    [credentials8767 (:credentials m8766) args8768 (:args m8766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8769
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8769
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args8768 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-attributes,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call putAttributes"}
   [credentials8771 & args8772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8773
     (com.palletops.awaze.common/aws-client :simpledb credentials8771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8773
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args8772 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m8774]
   (clojure.core/let
    [credentials8775 (:credentials m8774) args8776 (:args m8774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8777
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8775)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8777
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args8776 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-attributes,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call deleteAttributes"}
   [credentials8779 & args8780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8781
     (com.palletops.awaze.common/aws-client :simpledb credentials8779)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8781
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args8780 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m8782]
   (clojure.core/let
    [credentials8783 (:credentials m8782) args8784 (:args m8782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8785
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8783)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8785
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args8784 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8787 & args8788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8789
     (com.palletops.awaze.common/aws-client :simpledb credentials8787)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8789
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args8788 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m8790]
   (clojure.core/let
    [credentials8791 (:credentials m8790) args8792 (:args m8790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8793
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8791)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8793
       select
       (simpledb/select-request (clojure.core/nth args8792 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for select"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :select,
     :credentials credentials__1784__auto__,
     :client :simpledb}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call select"}
   [credentials8795 & args8796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8797
     (com.palletops.awaze.common/aws-client :simpledb credentials8795)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8797
      select
      (simpledb/select-request (clojure.core/nth args8796 0))))))))
