(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m8374]
  (clojure.core/let
   [bean8373
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/let
    [v8375 (:policy m8374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setPolicy (clojure.core/str v8375))))
   (clojure.core/let
    [v8375
     (:role-arn m8374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setRoleArn (clojure.core/str v8375))))
   (clojure.core/let
    [v8375
     (:role-session-name
      m8374
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setRoleSessionName (clojure.core/str v8375))))
   (clojure.core/let
    [v8375
     (:duration-seconds
      m8374
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setDurationSeconds (clojure.core/int v8375))))
   (clojure.core/let
    [v8375
     (:external-id m8374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setExternalId (clojure.core/str v8375))))
   (clojure.core/let
    [v8375
     (:serial-number m8374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setSerialNumber (clojure.core/str v8375))))
   (clojure.core/let
    [v8375
     (:token-code m8374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8375 :com.palletops.awaze.client-builder/undef)
     (. bean8373 setTokenCode (clojure.core/str v8375))))
   bean8373))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m8377]
  (clojure.core/let
   [bean8376
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/let
    [v8378 (:policy m8377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8378 :com.palletops.awaze.client-builder/undef)
     (. bean8376 setPolicy (clojure.core/str v8378))))
   (clojure.core/let
    [v8378
     (:role-arn m8377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8378 :com.palletops.awaze.client-builder/undef)
     (. bean8376 setRoleArn (clojure.core/str v8378))))
   (clojure.core/let
    [v8378
     (:duration-seconds
      m8377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8378 :com.palletops.awaze.client-builder/undef)
     (. bean8376 setDurationSeconds (clojure.core/int v8378))))
   (clojure.core/let
    [v8378
     (:principal-arn m8377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8378 :com.palletops.awaze.client-builder/undef)
     (. bean8376 setPrincipalArn (clojure.core/str v8378))))
   (clojure.core/let
    [v8378
     (:samlassertion m8377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8378 :com.palletops.awaze.client-builder/undef)
     (. bean8376 setSAMLAssertion (clojure.core/str v8378))))
   bean8376))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m8380]
  (clojure.core/let
   [bean8379
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/let
    [v8381 (:policy m8380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8381 :com.palletops.awaze.client-builder/undef)
     (. bean8379 setPolicy (clojure.core/str v8381))))
   (clojure.core/let
    [v8381
     (:role-arn m8380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8381 :com.palletops.awaze.client-builder/undef)
     (. bean8379 setRoleArn (clojure.core/str v8381))))
   (clojure.core/let
    [v8381
     (:role-session-name
      m8380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8381 :com.palletops.awaze.client-builder/undef)
     (. bean8379 setRoleSessionName (clojure.core/str v8381))))
   (clojure.core/let
    [v8381
     (:duration-seconds
      m8380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8381 :com.palletops.awaze.client-builder/undef)
     (. bean8379 setDurationSeconds (clojure.core/int v8381))))
   (clojure.core/let
    [v8381
     (:web-identity-token
      m8380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8381 :com.palletops.awaze.client-builder/undef)
     (. bean8379 setWebIdentityToken (clojure.core/str v8381))))
   (clojure.core/let
    [v8381
     (:provider-id m8380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8381 :com.palletops.awaze.client-builder/undef)
     (. bean8379 setProviderId (clojure.core/str v8381))))
   bean8379))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m8383]
  (clojure.core/let
   [bean8382
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/let
    [v8384
     (:encoded-message
      m8383
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8384 :com.palletops.awaze.client-builder/undef)
     (. bean8382 setEncodedMessage (clojure.core/str v8384))))
   bean8382))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m8386]
  (clojure.core/let
   [bean8385
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/let
    [v8387 (:name m8386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8387 :com.palletops.awaze.client-builder/undef)
     (. bean8385 setName (clojure.core/str v8387))))
   (clojure.core/let
    [v8387 (:policy m8386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8387 :com.palletops.awaze.client-builder/undef)
     (. bean8385 setPolicy (clojure.core/str v8387))))
   (clojure.core/let
    [v8387
     (:duration-seconds
      m8386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8387 :com.palletops.awaze.client-builder/undef)
     (. bean8385 setDurationSeconds (clojure.core/int v8387))))
   bean8385))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m8389]
  (clojure.core/let
   [bean8388
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/let
    [v8390
     (:duration-seconds
      m8389
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8390 :com.palletops.awaze.client-builder/undef)
     (. bean8388 setDurationSeconds (clojure.core/int v8390))))
   (clojure.core/let
    [v8390
     (:serial-number m8389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8390 :com.palletops.awaze.client-builder/undef)
     (. bean8388 setSerialNumber (clojure.core/str v8390))))
   (clojure.core/let
    [v8390
     (:token-code m8389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8390 :com.palletops.awaze.client-builder/undef)
     (. bean8388 setTokenCode (clojure.core/str v8390))))
   bean8388))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m8391]
   (clojure.core/let
    [credentials8392 (:credentials m8391) args8393 (:args m8391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8394
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8394
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args8393 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1784__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials8396 & args8397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8398
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8398
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args8397 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m8399]
   (clojure.core/let
    [credentials8400 (:credentials m8399) args8401 (:args m8399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8402
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8402
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args8401 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1784__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials8404 & args8405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8406
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8406
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args8405 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m8407]
   (clojure.core/let
    [credentials8408 (:credentials m8407) args8409 (:args m8407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8410
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8408)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8410
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args8409 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1784__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials8412 & args8413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8414
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8412)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8414
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args8413 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m8415]
   (clojure.core/let
    [credentials8416 (:credentials m8415) args8417 (:args m8415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8418
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8418
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args8417 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1784__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials8420 & args8421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8422
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8422
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args8421 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m8423]
   (clojure.core/let
    [credentials8424 (:credentials m8423) args8425 (:args m8423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8426
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8424)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8426
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args8425 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1784__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials8428 & args8429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8430
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8428)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8430
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args8429 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m8431]
   (clojure.core/let
    [credentials8432 (:credentials m8431) args8433 (:args m8431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8434
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8432)]
     (clojure.core/case
      (clojure.core/count args8433)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8434
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8434
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args8433 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1784__auto__,
     :client :securitytoken})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1784__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials8436 & args8437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8438
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8436)]
    (clojure.core/case
     (clojure.core/count args8437)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8438
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8438
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args8437 0)))))))))
