(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m13154]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m13154)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m13157]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m13157)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m13160]
  (clojure.core/let
   [bean13159
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/let
    [v13161 (:days m13160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13161 :com.palletops.awaze.client-builder/undef)
     (. bean13159 setDays (clojure.core/int v13161))))
   (clojure.core/let
    [v13161
     (:storage-class m13160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13161 :com.palletops.awaze.client-builder/undef)
     (. bean13159 setStorageClass (clojure.core/str v13161))))
   bean13159))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m13163]
  (clojure.core/let
   [bean13162
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/let
    [v13164 (:date m13163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13164 :com.palletops.awaze.client-builder/undef)
     (. bean13162 setDate (com.palletops.awaze.common/to-date v13164))))
   (clojure.core/let
    [v13164 (:days m13163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13164 :com.palletops.awaze.client-builder/undef)
     (. bean13162 setDays (clojure.core/int v13164))))
   (clojure.core/let
    [v13164
     (:storage-class m13163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13164 :com.palletops.awaze.client-builder/undef)
     (. bean13162 setStorageClass (s3/storage-class v13164))))
   bean13162))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload}
abort-incomplete-multipart-upload
  [m13166]
  (clojure.core/let
   [bean13165
    (new
     com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload)]
   (clojure.core/let
    [v13167
     (:days-after-initiation
      m13166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13167 :com.palletops.awaze.client-builder/undef)
     (. bean13165 setDaysAfterInitiation (clojure.core/int v13167))))
   bean13165))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m13169]
  (clojure.core/let
   [bean13168 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/let
    [v13170
     (:display-name m13169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13170 :com.palletops.awaze.client-builder/undef)
     (. bean13168 setDisplayName (clojure.core/str v13170))))
   (clojure.core/let
    [v13170 (:id m13169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13170 :com.palletops.awaze.client-builder/undef)
     (. bean13168 setId (clojure.core/str v13170))))
   bean13168))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationRuleStatus}
replication-rule-status
  [m13172]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.ReplicationRuleStatus
   (clojure.core/name m13172)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationDestinationConfig}
replication-destination-config
  [m13175]
  (clojure.core/let
   [bean13174
    (new com.amazonaws.services.s3.model.ReplicationDestinationConfig)]
   (clojure.core/let
    [v13176
     (:bucket-arn m13175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13176 :com.palletops.awaze.client-builder/undef)
     (. bean13174 setBucketARN (clojure.core/str v13176))))
   (clojure.core/let
    [v13176
     (:storage-class m13175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13176 :com.palletops.awaze.client-builder/undef)
     (. bean13174 setStorageClass (clojure.core/str v13176))))
   bean13174))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m13178]
  (clojure.core/let
   [bean13177
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/let
    [v13179
     (:key-prefix-equals
      m13178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13179 :com.palletops.awaze.client-builder/undef)
     (. bean13177 setKeyPrefixEquals (clojure.core/str v13179))))
   (clojure.core/let
    [v13179
     (:http-error-code-returned-equals
      m13178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13179 :com.palletops.awaze.client-builder/undef)
     (.
      bean13177
      setHttpErrorCodeReturnedEquals
      (clojure.core/str v13179))))
   bean13177))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m13181]
  (clojure.core/let
   [bean13180 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/let
    [v13182
     (:protocol m13181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13182 :com.palletops.awaze.client-builder/undef)
     (. bean13180 setProtocol (clojure.core/str v13182))))
   (clojure.core/let
    [v13182
     (:host-name m13181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13182 :com.palletops.awaze.client-builder/undef)
     (. bean13180 setHostName (clojure.core/str v13182))))
   (clojure.core/let
    [v13182
     (:replace-key-prefix-with
      m13181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13182 :com.palletops.awaze.client-builder/undef)
     (. bean13180 setReplaceKeyPrefixWith (clojure.core/str v13182))))
   (clojure.core/let
    [v13182
     (:replace-key-with
      m13181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13182 :com.palletops.awaze.client-builder/undef)
     (. bean13180 setReplaceKeyWith (clojure.core/str v13182))))
   (clojure.core/let
    [v13182
     (:http-redirect-code
      m13181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13182 :com.palletops.awaze.client-builder/undef)
     (. bean13180 setHttpRedirectCode (clojure.core/str v13182))))
   bean13180))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m13184]
  (clojure.core/let
   [bean13183 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/let
    [v13185 (:id m13184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13185 :com.palletops.awaze.client-builder/undef)
     (. bean13183 setId (clojure.core/str v13185))))
   (clojure.core/let
    [v13185
     (:allowed-methods
      m13184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13185 :com.palletops.awaze.client-builder/undef)
     (.
      bean13183
      setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13520] (s3/corsrule-allowed-methods arg13520))
 v13185))))
   (clojure.core/let
    [v13185
     (:allowed-origins
      m13184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13185 :com.palletops.awaze.client-builder/undef)
     (.
      bean13183
      setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13521] (clojure.core/str arg13521))
 v13185))))
   (clojure.core/let
    [v13185
     (:max-age-seconds
      m13184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13185 :com.palletops.awaze.client-builder/undef)
     (. bean13183 setMaxAgeSeconds (clojure.core/int v13185))))
   (clojure.core/let
    [v13185
     (:exposed-headers
      m13184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13185 :com.palletops.awaze.client-builder/undef)
     (.
      bean13183
      setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13522] (clojure.core/str arg13522))
 v13185))))
   (clojure.core/let
    [v13185
     (:allowed-headers
      m13184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13185 :com.palletops.awaze.client-builder/undef)
     (.
      bean13183
      setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13523] (clojure.core/str arg13523))
 v13185))))
   bean13183))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m13187]
  (clojure.core/let
   [bean13186
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/let
    [v13188
     (:prefix m13187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (. bean13186 setPrefix (clojure.core/str v13188))))
   (clojure.core/let
    [v13188
     (:noncurrent-version-transition
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setNoncurrentVersionTransition
      (s3/bucket-lifecycle-configuration-noncurrent-version-transition
       v13188))))
   (clojure.core/let
    [v13188
     (:transitions m13187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13524]
  (s3/bucket-lifecycle-configuration-transition arg13524))
 v13188))))
   (clojure.core/let
    [v13188
     (:abort-incomplete-multipart-upload
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setAbortIncompleteMultipartUpload
      (s3/abort-incomplete-multipart-upload v13188))))
   (clojure.core/let
    [v13188 (:id m13187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (. bean13186 setId (clojure.core/str v13188))))
   (clojure.core/let
    [v13188
     (:noncurrent-version-expiration-in-days
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setNoncurrentVersionExpirationInDays
      (clojure.core/int v13188))))
   (clojure.core/let
    [v13188
     (:expiration-in-days
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (. bean13186 setExpirationInDays (clojure.core/int v13188))))
   (clojure.core/let
    [v13188
     (:noncurrent-version-transitions
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setNoncurrentVersionTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13525]
  (s3/bucket-lifecycle-configuration-noncurrent-version-transition
   arg13525))
 v13188))))
   (clojure.core/let
    [v13188
     (:expiration-date
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setExpirationDate
      (com.palletops.awaze.common/to-date v13188))))
   (clojure.core/let
    [v13188
     (:expired-object-delete-marker
      m13187
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setExpiredObjectDeleteMarker
      (clojure.core/boolean v13188))))
   (clojure.core/let
    [v13188
     (:transition m13187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (.
      bean13186
      setTransition
      (s3/bucket-lifecycle-configuration-transition v13188))))
   (clojure.core/let
    [v13188
     (:status m13187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13188 :com.palletops.awaze.client-builder/undef)
     (. bean13186 setStatus (clojure.core/str v13188))))
   bean13186))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m13190]
  (clojure.core/let
   [arg13192
    nil
    arg13193
    nil
    bean13189
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg13192
     arg13193)]
   bean13189))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m13195]
  (clojure.core/let
   [bean13194 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/let
    [v13196
     (:bucket-name m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setBucketName (clojure.core/str v13196))))
   (clojure.core/let
    [v13196 (:owner m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setOwner (s3/owner v13196))))
   (clojure.core/let
    [v13196
     (:storage-class m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setStorageClass (clojure.core/str v13196))))
   (clojure.core/let
    [v13196
     (:is-latest m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setIsLatest (clojure.core/boolean v13196))))
   (clojure.core/let
    [v13196
     (:last-modified m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (.
      bean13194
      setLastModified
      (com.palletops.awaze.common/to-date v13196))))
   (clojure.core/let
    [v13196 (:key m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setKey (clojure.core/str v13196))))
   (clojure.core/let
    [v13196 (:etag m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setETag (clojure.core/str v13196))))
   (clojure.core/let
    [v13196 (:size m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setSize (clojure.core/long v13196))))
   (clojure.core/let
    [v13196
     (:version-id m13195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setVersionId (clojure.core/str v13196))))
   (clojure.core/let
    [v13196
     (:is-delete-marker
      m13195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13196 :com.palletops.awaze.client-builder/undef)
     (. bean13194 setIsDeleteMarker (clojure.core/boolean v13196))))
   bean13194))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationRule}
replication-rule
  [m13198]
  (clojure.core/let
   [bean13197 (new com.amazonaws.services.s3.model.ReplicationRule)]
   (clojure.core/let
    [v13199
     (:prefix m13198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13199 :com.palletops.awaze.client-builder/undef)
     (. bean13197 setPrefix (clojure.core/str v13199))))
   (clojure.core/let
    [v13199
     (:status m13198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13199 :com.palletops.awaze.client-builder/undef)
     (. bean13197 setStatus (s3/replication-rule-status v13199))))
   (clojure.core/let
    [v13199
     (:destination-config
      m13198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13199 :com.palletops.awaze.client-builder/undef)
     (.
      bean13197
      setDestinationConfig
      (s3/replication-destination-config v13199))))
   bean13197))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m13201]
  (clojure.core/let
   [bean13200 (new com.amazonaws.services.s3.model.TagSet)]
   bean13200))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m13204]
  (clojure.core/let
   [bean13203 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/let
    [v13205
     (:condition m13204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13205 :com.palletops.awaze.client-builder/undef)
     (. bean13203 setCondition (s3/routing-rule-condition v13205))))
   (clojure.core/let
    [v13205
     (:redirect m13204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13205 :com.palletops.awaze.client-builder/undef)
     (. bean13203 setRedirect (s3/redirect-rule v13205))))
   bean13203))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m13207]
  (clojure.core/let
   [^{:tag javax.crypto.SecretKey}
    arg13209
    nil
    bean13206
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag javax.crypto.SecretKey}
arg13209)]
   (clojure.core/let
    [v13208
     (:algorithm m13207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13208 :com.palletops.awaze.client-builder/undef)
     (. bean13206 setAlgorithm (clojure.core/str v13208))))
   (clojure.core/let
    [v13208 (:md5 m13207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13208 :com.palletops.awaze.client-builder/undef)
     (. bean13206 setMd5 (clojure.core/str v13208))))
   bean13206))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m13211]
  (clojure.core/let
   [bean13210
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/let
    [v13212 (:rules m13211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13212 :com.palletops.awaze.client-builder/undef)
     (.
      bean13210
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13526] (s3/corsrule arg13526))
 v13212))))
   bean13210))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m13214]
  (clojure.core/let
   [bean13213
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/let
    [v13215 (:rules m13214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13215 :com.palletops.awaze.client-builder/undef)
     (.
      bean13213
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13527]
  (s3/bucket-lifecycle-configuration-rule arg13527))
 v13215))))
   bean13213))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m13217]
  (clojure.core/let
   [bean13216
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/let
    [v13218
     (:configurations
      m13217
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13218 :com.palletops.awaze.client-builder/undef)
     (.
      bean13216
      setConfigurations
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13528] (clojure.core/str arg13528))
  (clojure.core/keys v13218))
 (clojure.core/map
  (clojure.core/fn [arg13528] arg13528)
  (clojure.core/vals v13218))))))
   (clojure.core/let
    [v13218
     (:topic-configurations
      m13217
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13218 :com.palletops.awaze.client-builder/undef)
     (.
      bean13216
      setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg13529]
  (s3/bucket-notification-configuration-topic-configuration arg13529))
 v13218))))
   bean13216))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m13220]
  (clojure.core/let
   [bean13219 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/let
    [v13221
     (:prefix m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setPrefix (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:next-version-id-marker
      m13220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setNextVersionIdMarker (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:version-summaries
      m13220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (.
      bean13219
      setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13530] (s3/s3version-summary arg13530))
 v13221))))
   (clojure.core/let
    [v13221
     (:bucket-name m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setBucketName (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:encoding-type m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setEncodingType (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:next-key-marker
      m13220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setNextKeyMarker (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:max-keys m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setMaxKeys (clojure.core/int v13221))))
   (clojure.core/let
    [v13221
     (:truncated m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setTruncated (clojure.core/boolean v13221))))
   (clojure.core/let
    [v13221
     (:version-id-marker
      m13220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setVersionIdMarker (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:common-prefixes
      m13220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (.
      bean13219
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13531] (clojure.core/str arg13531))
 v13221))))
   (clojure.core/let
    [v13221
     (:key-marker m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setKeyMarker (clojure.core/str v13221))))
   (clojure.core/let
    [v13221
     (:delimiter m13220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13221 :com.palletops.awaze.client-builder/undef)
     (. bean13219 setDelimiter (clojure.core/str v13221))))
   bean13219))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAlgorithm}
ssealgorithm
  [m13223]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.SSEAlgorithm
   (clojure.core/name m13223)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m13226]
  (clojure.core/let
   [bean13225
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/let
    [v13227
     (:content-type m13226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13227 :com.palletops.awaze.client-builder/undef)
     (. bean13225 setContentType (clojure.core/str v13227))))
   (clojure.core/let
    [v13227
     (:content-encoding
      m13226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13227 :com.palletops.awaze.client-builder/undef)
     (. bean13225 setContentEncoding (clojure.core/str v13227))))
   (clojure.core/let
    [v13227
     (:cache-control m13226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13227 :com.palletops.awaze.client-builder/undef)
     (. bean13225 setCacheControl (clojure.core/str v13227))))
   (clojure.core/let
    [v13227
     (:content-disposition
      m13226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13227 :com.palletops.awaze.client-builder/undef)
     (. bean13225 setContentDisposition (clojure.core/str v13227))))
   (clojure.core/let
    [v13227
     (:content-language
      m13226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13227 :com.palletops.awaze.client-builder/undef)
     (. bean13225 setContentLanguage (clojure.core/str v13227))))
   (clojure.core/let
    [v13227
     (:expires m13226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13227 :com.palletops.awaze.client-builder/undef)
     (. bean13225 setExpires (clojure.core/str v13227))))
   bean13225))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m13229]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m13229)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m13232]
  (clojure.core/let
   [bean13231 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/let
    [v13233 (:owner m13232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13233 :com.palletops.awaze.client-builder/undef)
     (. bean13231 setOwner (s3/owner v13233))))
   (clojure.core/let
    [v13233
     (:requester-charged
      m13232
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13233 :com.palletops.awaze.client-builder/undef)
     (. bean13231 setRequesterCharged (clojure.core/boolean v13233))))
   bean13231))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAwsKeyManagementParams}
sseaws-key-management-params
  [m13235]
  (clojure.core/let
   [bean13234
    (new com.amazonaws.services.s3.model.SSEAwsKeyManagementParams)]
   bean13234))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m13238]
  (clojure.core/let
   [bean13237 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/let
    [v13239
     (:content-encoding
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setContentEncoding (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:expiration-time-rule-id
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setExpirationTimeRuleId (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:cache-control m13238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setCacheControl (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:requester-charged
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setRequesterCharged (clojure.core/boolean v13239))))
   (clojure.core/let
    [v13239
     (:restore-expiration-time
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (.
      bean13237
      setRestoreExpirationTime
      (com.palletops.awaze.common/to-date v13239))))
   (clojure.core/let
    [v13239
     (:content-type m13238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setContentType (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:content-length
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setContentLength (clojure.core/long v13239))))
   (clojure.core/let
    [v13239
     (:ssecustomer-key-md5
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setSSECustomerKeyMd5 (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:ongoing-restore
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setOngoingRestore (clojure.core/boolean v13239))))
   (clojure.core/let
    [v13239
     (:expiration-time
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (.
      bean13237
      setExpirationTime
      (com.palletops.awaze.common/to-date v13239))))
   (clojure.core/let
    [v13239
     (:user-metadata m13238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (.
      bean13237
      setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13532] (clojure.core/str arg13532))
  (clojure.core/keys v13239))
 (clojure.core/map
  (clojure.core/fn [arg13532] (clojure.core/str arg13532))
  (clojure.core/vals v13239))))))
   (clojure.core/let
    [v13239
     (:last-modified m13238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (.
      bean13237
      setLastModified
      (com.palletops.awaze.common/to-date v13239))))
   (clojure.core/let
    [v13239
     (:content-md5 m13238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setContentMD5 (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:content-disposition
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setContentDisposition (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:server-side-encryption
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setServerSideEncryption (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:ssealgorithm m13238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setSSEAlgorithm (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:ssecustomer-algorithm
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (. bean13237 setSSECustomerAlgorithm (clojure.core/str v13239))))
   (clojure.core/let
    [v13239
     (:http-expires-date
      m13238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13239 :com.palletops.awaze.client-builder/undef)
     (.
      bean13237
      setHttpExpiresDate
      (com.palletops.awaze.common/to-date v13239))))
   bean13237))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m13241]
  (clojure.core/let
   [arg13243
    nil
    bean13240
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg13243)]
   bean13240))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m13245]
  (clojure.core/let
   [arg13247
    nil
    arg13248
    nil
    bean13244
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg13247
     arg13248)]
   (clojure.core/let
    [v13246 (:token m13245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setToken (clojure.core/str v13246))))
   (clojure.core/let
    [v13246
     (:device-serial-number
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setDeviceSerialNumber (clojure.core/str v13246))))
   bean13244))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m13250]
  (clojure.core/let
   [bean13249
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/let
    [v13251
     (:status m13250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13251 :com.palletops.awaze.client-builder/undef)
     (. bean13249 setStatus (clojure.core/str v13251))))
   (clojure.core/let
    [v13251
     (:mfa-delete-enabled
      m13250
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13251 :com.palletops.awaze.client-builder/undef)
     (. bean13249 setMfaDeleteEnabled (clojure.core/boolean v13251))))
   bean13249))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m13253]
  (clojure.core/let
   [bean13252
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/let
    [v13254
     (:log-file-prefix
      m13253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setLogFilePrefix (clojure.core/str v13254))))
   (clojure.core/let
    [v13254
     (:destination-bucket-name
      m13253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setDestinationBucketName (clojure.core/str v13254))))
   bean13252))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3ObjectId}
s3object-id
  [m13256]
  (clojure.core/let
   [arg13258
    nil
    arg13259
    nil
    bean13255
    (new com.amazonaws.services.s3.model.S3ObjectId arg13258 arg13259)]
   bean13255))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m13261]
  (clojure.core/let
   [arg13263
    0
    arg13264
    nil
    bean13260
    (new com.amazonaws.services.s3.model.PartETag arg13263 arg13264)]
   (clojure.core/let
    [v13262 (:etag m13261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13262 :com.palletops.awaze.client-builder/undef)
     (. bean13260 setETag (clojure.core/str v13262))))
   (clojure.core/let
    [v13262
     (:part-number m13261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13262 :com.palletops.awaze.client-builder/undef)
     (. bean13260 setPartNumber (clojure.core/int v13262))))
   bean13260))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketReplicationConfiguration}
bucket-replication-configuration
  [m13266]
  (clojure.core/let
   [bean13265
    (new
     com.amazonaws.services.s3.model.BucketReplicationConfiguration)]
   (clojure.core/let
    [v13267 (:rules m13266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13267 :com.palletops.awaze.client-builder/undef)
     (.
      bean13265
      setRules
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13533] (clojure.core/str arg13533))
  (clojure.core/keys v13267))
 (clojure.core/map
  (clojure.core/fn [arg13533] (s3/replication-rule arg13533))
  (clojure.core/vals v13267))))))
   (clojure.core/let
    [v13267
     (:role-arn m13266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13267 :com.palletops.awaze.client-builder/undef)
     (. bean13265 setRoleARN (clojure.core/str v13267))))
   bean13265))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m13269]
  (clojure.core/let
   [bean13268
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/let
    [v13270
     (:tag-sets m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (.
      bean13268
      setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg13534] (s3/tag-set arg13534))
 v13270))))
   bean13268))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m13272]
  (clojure.core/let
   [bean13271 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/let
    [v13273
     (:prefix m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setPrefix (clojure.core/str v13273))))
   (clojure.core/let
    [v13273
     (:bucket-name m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setBucketName (clojure.core/str v13273))))
   (clojure.core/let
    [v13273
     (:encoding-type m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setEncodingType (clojure.core/str v13273))))
   (clojure.core/let
    [v13273
     (:max-keys m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setMaxKeys (clojure.core/int v13273))))
   (clojure.core/let
    [v13273
     (:marker m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setMarker (clojure.core/str v13273))))
   (clojure.core/let
    [v13273
     (:next-marker m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setNextMarker (clojure.core/str v13273))))
   (clojure.core/let
    [v13273
     (:truncated m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setTruncated (clojure.core/boolean v13273))))
   (clojure.core/let
    [v13273
     (:common-prefixes
      m13272
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (.
      bean13271
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13535] (clojure.core/str arg13535))
 v13273))))
   (clojure.core/let
    [v13273
     (:delimiter m13272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setDelimiter (clojure.core/str v13273))))
   bean13271))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m13275]
  (clojure.core/let
   [bean13274
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/let
    [v13276
     (:index-document-suffix
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setIndexDocumentSuffix (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:error-document
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setErrorDocument (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:redirect-all-requests-to
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setRedirectAllRequestsTo (s3/redirect-rule v13276))))
   (clojure.core/let
    [v13276
     (:routing-rules m13275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (.
      bean13274
      setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13536] (s3/routing-rule arg13536))
 v13276))))
   bean13274))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m13278]
  (clojure.core/let
   [arg13280
    nil
    bean13277
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg13280)]
   bean13277))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetObjectAclRequest}
set-object-acl-request
  [m13282]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13284
    nil
^{:tag java.lang.String}
arg13285
    nil
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13286
    (canned-access-control-list {})
    bean13281
    (new
     com.amazonaws.services.s3.model.SetObjectAclRequest
^{:tag java.lang.String}
arg13284
^{:tag java.lang.String}
arg13285
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13286)]
   (clojure.core/let
    [v13283
     (:requester-pays
      m13282
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13283 :com.palletops.awaze.client-builder/undef)
     (. bean13281 setRequesterPays (clojure.core/boolean v13283))))
   bean13281))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
get-bucket-lifecycle-configuration-request
  [m13288]
  (clojure.core/let
   [arg13290
    nil
    bean13287
    (new
     com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
     arg13290)]
   bean13287))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m13292]
  (clojure.core/let
   [arg13294
    nil
    bean13291
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg13294)]
   (clojure.core/let
    [v13293
     (:bucket-name m13292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setBucketName (clojure.core/str v13293))))
   (clojure.core/let
    [v13293
     (:prefix m13292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setPrefix (clojure.core/str v13293))))
   (clojure.core/let
    [v13293
     (:upload-id-marker
      m13292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setUploadIdMarker (clojure.core/str v13293))))
   (clojure.core/let
    [v13293
     (:max-uploads m13292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setMaxUploads (clojure.core/int v13293))))
   (clojure.core/let
    [v13293
     (:delimiter m13292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setDelimiter (clojure.core/str v13293))))
   (clojure.core/let
    [v13293
     (:key-marker m13292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setKeyMarker (clojure.core/str v13293))))
   (clojure.core/let
    [v13293
     (:encoding-type m13292 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13293 :com.palletops.awaze.client-builder/undef)
     (. bean13291 setEncodingType (clojure.core/str v13293))))
   bean13291))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m13296]
  (clojure.core/let
   [arg13298
    nil
    arg13299
    nil
    bean13295
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg13298
     arg13299)]
   (clojure.core/let
    [v13297
     (:bucket-name m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setBucketName (clojure.core/str v13297))))
   (clojure.core/let
    [v13297 (:key m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setKey (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:version-id m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setVersionId (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:requester-pays
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setRequesterPays (clojure.core/boolean v13297))))
   (clojure.core/let
    [v13297
     (:ssecustomer-key
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setSSECustomerKey (s3/ssecustomer-key v13297))))
   bean13295))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m13301]
  (clojure.core/let
   [arg13303
    nil
    arg13304
    (bucket-cross-origin-configuration {})
    bean13300
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg13303
     arg13304)]
   (clojure.core/let
    [v13302
     (:bucket-name m13301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13302 :com.palletops.awaze.client-builder/undef)
     (. bean13300 setBucketName (clojure.core/str v13302))))
   (clojure.core/let
    [v13302
     (:cross-origin-configuration
      m13301
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13302 :com.palletops.awaze.client-builder/undef)
     (.
      bean13300
      setCrossOriginConfiguration
      (s3/bucket-cross-origin-configuration v13302))))
   bean13300))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
delete-bucket-replication-configuration-request
  [m13306]
  (clojure.core/let
   [arg13308
    nil
    bean13305
    (new
     com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
     arg13308)]
   bean13305))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m13310]
  (clojure.core/let
   [arg13312
    nil
    arg13313
    (bucket-lifecycle-configuration {})
    bean13309
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg13312
     arg13313)]
   (clojure.core/let
    [v13311
     (:bucket-name m13310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13311 :com.palletops.awaze.client-builder/undef)
     (. bean13309 setBucketName (clojure.core/str v13311))))
   (clojure.core/let
    [v13311
     (:lifecycle-configuration
      m13310
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13311 :com.palletops.awaze.client-builder/undef)
     (.
      bean13309
      setLifecycleConfiguration
      (s3/bucket-lifecycle-configuration v13311))))
   bean13309))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m13315]
  (clojure.core/let
   [^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
    arg13317
    (bucket-notification-configuration {})
^{:tag java.lang.String}
arg13318
    nil
    bean13314
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13317
^{:tag java.lang.String}
arg13318)]
   (clojure.core/let
    [v13316
     (:bucket-name m13315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13316 :com.palletops.awaze.client-builder/undef)
     (. bean13314 setBucketName (clojure.core/str v13316))))
   (clojure.core/let
    [v13316
     (:bucket m13315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13316 :com.palletops.awaze.client-builder/undef)
     (. bean13314 setBucket (clojure.core/str v13316))))
   (clojure.core/let
    [v13316
     (:bucket-notification-configuration
      m13315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13316 :com.palletops.awaze.client-builder/undef)
     (.
      bean13314
      setBucketNotificationConfiguration
      (s3/bucket-notification-configuration v13316))))
   (clojure.core/let
    [v13316
     (:notification-configuration
      m13315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13316 :com.palletops.awaze.client-builder/undef)
     (.
      bean13314
      setNotificationConfiguration
      (s3/bucket-notification-configuration v13316))))
   bean13314))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m13320]
  (clojure.core/let
   [arg13322
    nil
    bean13319
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg13322)]
   (clojure.core/let
    [v13321
     (:bucket-name m13320 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13321 :com.palletops.awaze.client-builder/undef)
     (. bean13319 setBucketName (clojure.core/str v13321))))
   bean13319))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.HeadBucketRequest}
head-bucket-request
  [m13324]
  (clojure.core/let
   [arg13326
    nil
    bean13323
    (new com.amazonaws.services.s3.model.HeadBucketRequest arg13326)]
   (clojure.core/let
    [v13325
     (:bucket-name m13324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (. bean13323 setBucketName (clojure.core/str v13325))))
   bean13323))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m13328]
  (clojure.core/let
   [bean13327 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/let
    [v13329
     (:path-style-access
      m13328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13329 :com.palletops.awaze.client-builder/undef)
     (. bean13327 setPathStyleAccess (clojure.core/boolean v13329))))
   (clojure.core/let
    [v13329
     (:chunked-encoding-disabled
      m13328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13329 :com.palletops.awaze.client-builder/undef)
     (.
      bean13327
      setChunkedEncodingDisabled
      (clojure.core/boolean v13329))))
   bean13327))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
get-bucket-notification-configuration-request
  [m13331]
  (clojure.core/let
   [arg13333
    nil
    bean13330
    (new
     com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
     arg13333)]
   bean13330))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m13335]
  (clojure.core/let
   [arg13337
    nil
    bean13334
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg13337)]
   bean13334))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m13339]
  (clojure.core/let
   [bean13338
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/let
    [v13340
     (:bucket-name m13339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13340 :com.palletops.awaze.client-builder/undef)
     (. bean13338 setBucketName (clojure.core/str v13340))))
   (clojure.core/let
    [v13340
     (:prefix m13339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13340 :com.palletops.awaze.client-builder/undef)
     (. bean13338 setPrefix (clojure.core/str v13340))))
   (clojure.core/let
    [v13340
     (:marker m13339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13340 :com.palletops.awaze.client-builder/undef)
     (. bean13338 setMarker (clojure.core/str v13340))))
   (clojure.core/let
    [v13340
     (:delimiter m13339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13340 :com.palletops.awaze.client-builder/undef)
     (. bean13338 setDelimiter (clojure.core/str v13340))))
   (clojure.core/let
    [v13340
     (:max-keys m13339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13340 :com.palletops.awaze.client-builder/undef)
     (. bean13338 setMaxKeys (clojure.core/int v13340))))
   (clojure.core/let
    [v13340
     (:encoding-type m13339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13340 :com.palletops.awaze.client-builder/undef)
     (. bean13338 setEncodingType (clojure.core/str v13340))))
   bean13338))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m13342]
  (clojure.core/let
   [arg13344
    nil
    arg13345
    nil
    arg13346
    nil
    bean13341
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg13344
     arg13345
     arg13346)]
   (clojure.core/let
    [v13343
     (:bucket-name m13342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13343 :com.palletops.awaze.client-builder/undef)
     (. bean13341 setBucketName (clojure.core/str v13343))))
   (clojure.core/let
    [v13343 (:key m13342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13343 :com.palletops.awaze.client-builder/undef)
     (. bean13341 setKey (clojure.core/str v13343))))
   (clojure.core/let
    [v13343
     (:upload-id m13342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13343 :com.palletops.awaze.client-builder/undef)
     (. bean13341 setUploadId (clojure.core/str v13343))))
   (clojure.core/let
    [v13343
     (:requester-pays
      m13342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13343 :com.palletops.awaze.client-builder/undef)
     (. bean13341 setRequesterPays (clojure.core/boolean v13343))))
   bean13341))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetS3AccountOwnerRequest}
get-s3account-owner-request
  [m13348]
  (clojure.core/let
   [bean13347
    (new com.amazonaws.services.s3.model.GetS3AccountOwnerRequest)]
   bean13347))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m13351]
  (clojure.core/let
   [bean13350
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean13350))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m13354]
  (clojure.core/let
   [arg13356
    nil
    bean13353
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg13356)]
   (clojure.core/let
    [v13355
     (:bucket-name m13354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13355 :com.palletops.awaze.client-builder/undef)
     (. bean13353 setBucketName (clojure.core/str v13355))))
   bean13353))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m13358]
  (clojure.core/let
   [arg13360
    nil
    arg13361
    nil
    arg13362
    nil
    bean13357
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg13360
     arg13361
     arg13362)]
   (clojure.core/let
    [v13359
     (:bucket-name m13358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setBucketName (clojure.core/str v13359))))
   (clojure.core/let
    [v13359 (:key m13358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setKey (clojure.core/str v13359))))
   (clojure.core/let
    [v13359
     (:upload-id m13358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setUploadId (clojure.core/str v13359))))
   (clojure.core/let
    [v13359
     (:max-parts m13358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setMaxParts (clojure.core/int v13359))))
   (clojure.core/let
    [v13359
     (:part-number-marker
      m13358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setPartNumberMarker (clojure.core/int v13359))))
   (clojure.core/let
    [v13359
     (:encoding-type m13358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setEncodingType (clojure.core/str v13359))))
   (clojure.core/let
    [v13359
     (:requester-pays
      m13358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setRequesterPays (clojure.core/boolean v13359))))
   bean13357))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m13364]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13366
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13367
    (access-control-list {})
    bean13363
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg13366
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13367)]
   bean13363))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m13369]
  (clojure.core/let
   [bean13368 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/let
    [v13370
     (:first-byte m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setFirstByte (clojure.core/long v13370))))
   (clojure.core/let
    [v13370
     (:source-version-id
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setSourceVersionId (clojure.core/str v13370))))
   (clojure.core/let
    [v13370
     (:source-bucket-name
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setSourceBucketName (clojure.core/str v13370))))
   (clojure.core/let
    [v13370
     (:last-byte m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setLastByte (clojure.core/long v13370))))
   (clojure.core/let
    [v13370
     (:unmodified-since-constraint
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (.
      bean13368
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13370))))
   (clojure.core/let
    [v13370
     (:modified-since-constraint
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (.
      bean13368
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13370))))
   (clojure.core/let
    [v13370
     (:destination-ssecustomer-key
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (.
      bean13368
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13370))))
   (clojure.core/let
    [v13370
     (:destination-bucket-name
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setDestinationBucketName (clojure.core/str v13370))))
   (clojure.core/let
    [v13370
     (:part-number m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setPartNumber (clojure.core/int v13370))))
   (clojure.core/let
    [v13370
     (:destination-key
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setDestinationKey (clojure.core/str v13370))))
   (clojure.core/let
    [v13370
     (:matching-etag-constraints
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (.
      bean13368
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13537] (clojure.core/str arg13537))
 v13370))))
   (clojure.core/let
    [v13370
     (:source-key m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setSourceKey (clojure.core/str v13370))))
   (clojure.core/let
    [v13370
     (:source-ssecustomer-key
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setSourceSSECustomerKey (s3/ssecustomer-key v13370))))
   (clojure.core/let
    [v13370
     (:nonmatching-etag-constraints
      m13369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (.
      bean13368
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13538] (clojure.core/str arg13538))
 v13370))))
   (clojure.core/let
    [v13370
     (:upload-id m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setUploadId (clojure.core/str v13370))))
   bean13368))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
get-bucket-replication-configuration-request
  [m13372]
  (clojure.core/let
   [arg13374
    nil
    bean13371
    (new
     com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
     arg13374)]
   bean13371))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
get-bucket-versioning-configuration-request
  [m13376]
  (clojure.core/let
   [arg13378
    nil
    bean13375
    (new
     com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
     arg13378)]
   bean13375))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
list-next-batch-of-versions-request
  [m13380]
  (clojure.core/let
   [arg13382
    (version-listing {})
    bean13379
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
     arg13382)]
   (clojure.core/let
    [v13381
     (:previous-version-listing
      m13380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13381 :com.palletops.awaze.client-builder/undef)
     (.
      bean13379
      setPreviousVersionListing
      (s3/version-listing v13381))))
   bean13379))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m13384]
  (clojure.core/let
   [arg13386
    nil
    bean13383
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg13386)]
   bean13383))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m13388]
  (clojure.core/let
   [arg13390
    nil
    arg13391
    nil
    bean13387
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg13390
     arg13391)]
   (clojure.core/let
    [v13389
     (:bucket-name m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setBucketName (clojure.core/str v13389))))
   (clojure.core/let
    [v13389 (:key m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setKey (clojure.core/str v13389))))
   (clojure.core/let
    [v13389
     (:requester-pays
      m13388
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setRequesterPays (clojure.core/boolean v13389))))
   bean13387))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m13393]
  (clojure.core/let
   [arg13395
    nil
    bean13392
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg13395)]
   bean13392))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
get-bucket-logging-configuration-request
  [m13397]
  (clojure.core/let
   [arg13399
    nil
    bean13396
    (new
     com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
     arg13399)]
   bean13396))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m13401]
  (clojure.core/let
   [arg13403
    nil
    arg13404
    nil
    bean13400
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg13403
     arg13404)]
   (clojure.core/let
    [v13402
     (:expiration m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (.
      bean13400
      setExpiration
      (com.palletops.awaze.common/to-date v13402))))
   (clojure.core/let
    [v13402
     (:kms-cmk-id m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setKmsCmkId (clojure.core/str v13402))))
   (clojure.core/let
    [v13402
     (:content-type m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setContentType (clojure.core/str v13402))))
   (clojure.core/let
    [v13402
     (:bucket-name m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setBucketName (clojure.core/str v13402))))
   (clojure.core/let
    [v13402
     (:ssecustomer-key
      m13401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setSSECustomerKey (s3/ssecustomer-key v13402))))
   (clojure.core/let
    [v13402
     (:method m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setMethod (root/http-method v13402))))
   (clojure.core/let
    [v13402
     (:ssecustomer-key-algorithm
      m13401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setSSECustomerKeyAlgorithm (s3/ssealgorithm v13402))))
   (clojure.core/let
    [v13402
     (:response-headers
      m13401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (.
      bean13400
      setResponseHeaders
      (s3/response-header-overrides v13402))))
   (clojure.core/let
    [v13402
     (:zero-byte-content
      m13401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setZeroByteContent (clojure.core/boolean v13402))))
   (clojure.core/let
    [v13402 (:key m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setKey (clojure.core/str v13402))))
   (clojure.core/let
    [v13402
     (:ssealgorithm m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setSSEAlgorithm (s3/ssealgorithm v13402))))
   (clojure.core/let
    [v13402
     (:content-md5 m13401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13402 :com.palletops.awaze.client-builder/undef)
     (. bean13400 setContentMd5 (clojure.core/str v13402))))
   bean13400))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m13406]
  (clojure.core/let
   [arg13408
    nil
    arg13409
    nil
    arg13410
    nil
    arg13411
    nil
    bean13405
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg13408
     arg13409
     arg13410
     arg13411)]
   (clojure.core/let
    [v13407
     (:canned-access-control-list
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setCannedAccessControlList
      (s3/canned-access-control-list v13407))))
   (clojure.core/let
    [v13407
     (:source-version-id
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setSourceVersionId (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:source-bucket-name
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setSourceBucketName (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:unmodified-since-constraint
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13407))))
   (clojure.core/let
    [v13407
     (:modified-since-constraint
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13407))))
   (clojure.core/let
    [v13407
     (:storage-class m13406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setStorageClass (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:destination-ssecustomer-key
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13407))))
   (clojure.core/let
    [v13407
     (:destination-bucket-name
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setDestinationBucketName (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:redirect-location
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setRedirectLocation (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:requester-pays
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setRequesterPays (clojure.core/boolean v13407))))
   (clojure.core/let
    [v13407
     (:access-control-list
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setAccessControlList
      (s3/access-control-list v13407))))
   (clojure.core/let
    [v13407
     (:sseaws-key-management-params
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13407))))
   (clojure.core/let
    [v13407
     (:destination-key
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setDestinationKey (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:matching-etag-constraints
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13539] (clojure.core/str arg13539))
 v13407))))
   (clojure.core/let
    [v13407
     (:source-key m13406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setSourceKey (clojure.core/str v13407))))
   (clojure.core/let
    [v13407
     (:source-ssecustomer-key
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setSourceSSECustomerKey (s3/ssecustomer-key v13407))))
   (clojure.core/let
    [v13407
     (:new-object-metadata
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (. bean13405 setNewObjectMetadata (s3/object-metadata v13407))))
   (clojure.core/let
    [v13407
     (:nonmatching-etag-constraints
      m13406
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13407 :com.palletops.awaze.client-builder/undef)
     (.
      bean13405
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13540] (clojure.core/str arg13540))
 v13407))))
   bean13405))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m13413]
  (clojure.core/let
   [arg13415
    nil
    bean13412
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg13415)]
   (clojure.core/let
    [v13414
     (:bucket-name m13413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (. bean13412 setBucketName (clojure.core/str v13414))))
   (clojure.core/let
    [v13414 (:keys m13413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (.
      bean13412
      setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13541]
  (s3/delete-objects-request-key-version arg13541))
 v13414))))
   (clojure.core/let
    [v13414 (:quiet m13413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (. bean13412 setQuiet (clojure.core/boolean v13414))))
   (clojure.core/let
    [v13414 (:mfa m13413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (. bean13412 setMfa (s3/multi-factor-authentication v13414))))
   (clojure.core/let
    [v13414
     (:requester-pays
      m13413
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (. bean13412 setRequesterPays (clojure.core/boolean v13414))))
   bean13412))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m13417]
  (clojure.core/let
   [arg13419
    nil
    arg13420
    (bucket-versioning-configuration {})
    bean13416
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg13419
     arg13420)]
   (clojure.core/let
    [v13418
     (:bucket-name m13417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13418 :com.palletops.awaze.client-builder/undef)
     (. bean13416 setBucketName (clojure.core/str v13418))))
   (clojure.core/let
    [v13418 (:mfa m13417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13418 :com.palletops.awaze.client-builder/undef)
     (. bean13416 setMfa (s3/multi-factor-authentication v13418))))
   (clojure.core/let
    [v13418
     (:versioning-configuration
      m13417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13418 :com.palletops.awaze.client-builder/undef)
     (.
      bean13416
      setVersioningConfiguration
      (s3/bucket-versioning-configuration v13418))))
   bean13416))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m13422]
  (clojure.core/let
   [arg13424
    nil
    arg13425
    (bucket-logging-configuration {})
    bean13421
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg13424
     arg13425)]
   (clojure.core/let
    [v13423
     (:bucket-name m13422 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13423 :com.palletops.awaze.client-builder/undef)
     (. bean13421 setBucketName (clojure.core/str v13423))))
   (clojure.core/let
    [v13423
     (:logging-configuration
      m13422
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13423 :com.palletops.awaze.client-builder/undef)
     (.
      bean13421
      setLoggingConfiguration
      (s3/bucket-logging-configuration v13423))))
   bean13421))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m13427]
  (clojure.core/let
   [arg13429
    nil
    arg13430
    nil
    bean13426
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg13429
     arg13430)]
   (clojure.core/let
    [v13428
     (:progress-listener
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setProgressListener v13428)))
   (clojure.core/let
    [v13428
     (:bucket-name m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setBucketName (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:ssecustomer-key
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setSSECustomerKey (s3/ssecustomer-key v13428))))
   (clojure.core/let
    [v13428
     (:unmodified-since-constraint
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13428))))
   (clojure.core/let
    [v13428
     (:modified-since-constraint
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13428))))
   (clojure.core/let
    [v13428 (:range m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setRange (clojure.core/long v13428))))
   (clojure.core/let
    [v13428
     (:s3object-id m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setS3ObjectId (s3/s3object-id v13428))))
   (clojure.core/let
    [v13428
     (:response-headers
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setResponseHeaders
      (s3/response-header-overrides v13428))))
   (clojure.core/let
    [v13428
     (:requester-pays
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setRequesterPays (clojure.core/boolean v13428))))
   (clojure.core/let
    [v13428 (:key m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setKey (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:matching-etag-constraints
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13542] (clojure.core/str arg13542))
 v13428))))
   (clojure.core/let
    [v13428
     (:version-id m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setVersionId (clojure.core/str v13428))))
   (clojure.core/let
    [v13428
     (:nonmatching-etag-constraints
      m13427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (.
      bean13426
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13543] (clojure.core/str arg13543))
 v13428))))
   bean13426))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m13432]
  (clojure.core/let
   [arg13434
    nil
    bean13431
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg13434)]
   bean13431))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m13436]
  (clojure.core/let
   [bean13435
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v13437
     (:bucket-name m13436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13437 :com.palletops.awaze.client-builder/undef)
     (. bean13435 setBucketName (clojure.core/str v13437))))
   (clojure.core/let
    [v13437 (:key m13436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13437 :com.palletops.awaze.client-builder/undef)
     (. bean13435 setKey (clojure.core/str v13437))))
   (clojure.core/let
    [v13437
     (:upload-id m13436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13437 :com.palletops.awaze.client-builder/undef)
     (. bean13435 setUploadId (clojure.core/str v13437))))
   (clojure.core/let
    [v13437
     (:part-etags m13436 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13437 :com.palletops.awaze.client-builder/undef)
     (.
      bean13435
      setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13544] (s3/part-etag arg13544))
 v13437))))
   (clojure.core/let
    [v13437
     (:requester-pays
      m13436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13437 :com.palletops.awaze.client-builder/undef)
     (. bean13435 setRequesterPays (clojure.core/boolean v13437))))
   bean13435))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m13439]
  (clojure.core/let
   [arg13441
    nil
    arg13442
    nil
    bean13438
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg13441
     arg13442)]
   (clojure.core/let
    [v13440
     (:bucket-name m13439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13440 :com.palletops.awaze.client-builder/undef)
     (. bean13438 setBucketName (clojure.core/str v13440))))
   (clojure.core/let
    [v13440 (:key m13439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13440 :com.palletops.awaze.client-builder/undef)
     (. bean13438 setKey (clojure.core/str v13440))))
   (clojure.core/let
    [v13440
     (:version-id m13439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13440 :com.palletops.awaze.client-builder/undef)
     (. bean13438 setVersionId (clojure.core/str v13440))))
   (clojure.core/let
    [v13440
     (:expiration-in-days
      m13439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13440 :com.palletops.awaze.client-builder/undef)
     (. bean13438 setExpirationInDays (clojure.core/int v13440))))
   (clojure.core/let
    [v13440
     (:requester-pays
      m13439
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13440 :com.palletops.awaze.client-builder/undef)
     (. bean13438 setRequesterPays (clojure.core/boolean v13440))))
   bean13438))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m13444]
  (clojure.core/let
   [arg13446
    nil
    bean13443
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg13446)]
   (clojure.core/let
    [v13445
     (:bucket-name m13444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13445 :com.palletops.awaze.client-builder/undef)
     (. bean13443 setBucketName (clojure.core/str v13445))))
   bean13443))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest}
set-bucket-replication-configuration-request
  [m13448]
  (clojure.core/let
   [bean13447
    (new
     com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest)]
   (clojure.core/let
    [v13449
     (:bucket-name m13448 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13449 :com.palletops.awaze.client-builder/undef)
     (. bean13447 setBucketName (clojure.core/str v13449))))
   (clojure.core/let
    [v13449
     (:replication-configuration
      m13448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13449 :com.palletops.awaze.client-builder/undef)
     (.
      bean13447
      setReplicationConfiguration
      (s3/bucket-replication-configuration v13449))))
   bean13447))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m13451]
  (clojure.core/let
   [arg13453
    nil
    bean13450
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg13453)]
   (clojure.core/let
    [v13452
     (:region m13451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13452 :com.palletops.awaze.client-builder/undef)
     (. bean13450 setRegion (clojure.core/str v13452))))
   (clojure.core/let
    [v13452
     (:bucket-name m13451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13452 :com.palletops.awaze.client-builder/undef)
     (. bean13450 setBucketName (clojure.core/str v13452))))
   (clojure.core/let
    [v13452
     (:canned-acl m13451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13452 :com.palletops.awaze.client-builder/undef)
     (. bean13450 setCannedAcl (s3/canned-access-control-list v13452))))
   (clojure.core/let
    [v13452
     (:access-control-list
      m13451
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13452 :com.palletops.awaze.client-builder/undef)
     (.
      bean13450
      setAccessControlList
      (s3/access-control-list v13452))))
   bean13450))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m13455]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m13455)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m13458]
  (clojure.core/let
   [arg13460
    nil
    arg13461
    nil
    arg13462
    nil
    bean13457
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg13460
     arg13461
     arg13462)]
   (clojure.core/let
    [v13459
     (:bucket-name m13458 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13459 :com.palletops.awaze.client-builder/undef)
     (. bean13457 setBucketName (clojure.core/str v13459))))
   (clojure.core/let
    [v13459 (:key m13458 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13459 :com.palletops.awaze.client-builder/undef)
     (. bean13457 setKey (clojure.core/str v13459))))
   (clojure.core/let
    [v13459
     (:version-id m13458 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13459 :com.palletops.awaze.client-builder/undef)
     (. bean13457 setVersionId (clojure.core/str v13459))))
   (clojure.core/let
    [v13459 (:mfa m13458 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13459 :com.palletops.awaze.client-builder/undef)
     (. bean13457 setMfa (s3/multi-factor-authentication v13459))))
   bean13457))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m13464]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13466
    nil
^{:tag java.lang.String}
arg13467
    nil
^{:tag java.lang.String}
arg13468
    nil
    bean13463
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg13466
^{:tag java.lang.String}
arg13467
^{:tag java.lang.String}
arg13468)]
   (clojure.core/let
    [v13465
     (:requester-pays
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setRequesterPays (clojure.core/boolean v13465))))
   bean13463))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m13470]
  (clojure.core/let
   [bean13469
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/let
    [v13471
     (:bucket-name m13470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setBucketName (clojure.core/str v13471))))
   (clojure.core/let
    [v13471
     (:prefix m13470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setPrefix (clojure.core/str v13471))))
   (clojure.core/let
    [v13471
     (:max-results m13470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setMaxResults (clojure.core/int v13471))))
   (clojure.core/let
    [v13471
     (:delimiter m13470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setDelimiter (clojure.core/str v13471))))
   (clojure.core/let
    [v13471
     (:key-marker m13470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setKeyMarker (clojure.core/str v13471))))
   (clojure.core/let
    [v13471
     (:version-id-marker
      m13470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setVersionIdMarker (clojure.core/str v13471))))
   (clojure.core/let
    [v13471
     (:encoding-type m13470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13471 :com.palletops.awaze.client-builder/undef)
     (. bean13469 setEncodingType (clojure.core/str v13471))))
   bean13469))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m13473]
  (clojure.core/let
   [arg13475
    nil
    arg13476
    (bucket-tagging-configuration {})
    bean13472
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg13475
     arg13476)]
   (clojure.core/let
    [v13474
     (:bucket-name m13473 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13474 :com.palletops.awaze.client-builder/undef)
     (. bean13472 setBucketName (clojure.core/str v13474))))
   (clojure.core/let
    [v13474
     (:tagging-configuration
      m13473
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13474 :com.palletops.awaze.client-builder/undef)
     (.
      bean13472
      setTaggingConfiguration
      (s3/bucket-tagging-configuration v13474))))
   bean13472))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
get-bucket-cross-origin-configuration-request
  [m13478]
  (clojure.core/let
   [arg13480
    nil
    bean13477
    (new
     com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
     arg13480)]
   bean13477))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m13482]
  (clojure.core/let
   [arg13484
    nil
    arg13485
    nil
    bean13481
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg13484
     arg13485)]
   (clojure.core/let
    [v13483
     (:bucket-name m13482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setBucketName (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:policy-text m13482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setPolicyText (clojure.core/str v13483))))
   bean13481))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
list-next-batch-of-objects-request
  [m13487]
  (clojure.core/let
   [arg13489
    (object-listing {})
    bean13486
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
     arg13489)]
   (clojure.core/let
    [v13488
     (:previous-object-listing
      m13487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13488 :com.palletops.awaze.client-builder/undef)
     (. bean13486 setPreviousObjectListing (s3/object-listing v13488))))
   bean13486))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m13491]
  (clojure.core/let
   [arg13493
    nil
    arg13494
    nil
    bean13490
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg13493
     arg13494)]
   (clojure.core/let
    [v13492
     (:bucket-name m13491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setBucketName (clojure.core/str v13492))))
   (clojure.core/let
    [v13492
     (:ssecustomer-key
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setSSECustomerKey (s3/ssecustomer-key v13492))))
   (clojure.core/let
    [v13492
     (:canned-acl m13491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setCannedACL (s3/canned-access-control-list v13492))))
   (clojure.core/let
    [v13492
     (:storage-class m13491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setStorageClass (s3/storage-class v13492))))
   (clojure.core/let
    [v13492
     (:redirect-location
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setRedirectLocation (clojure.core/str v13492))))
   (clojure.core/let
    [v13492
     (:requester-pays
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setRequesterPays (clojure.core/boolean v13492))))
   (clojure.core/let
    [v13492
     (:object-metadata
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setObjectMetadata (s3/object-metadata v13492))))
   (clojure.core/let
    [v13492
     (:access-control-list
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (.
      bean13490
      setAccessControlList
      (s3/access-control-list v13492))))
   (clojure.core/let
    [v13492 (:key m13491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setKey (clojure.core/str v13492))))
   (clojure.core/let
    [v13492
     (:sseaws-key-management-params
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (.
      bean13490
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13492))))
   bean13490))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m13496]
  (clojure.core/let
   [arg13498
    nil
    bean13495
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg13498)]
   (clojure.core/let
    [v13497
     (:bucket-name m13496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13497 :com.palletops.awaze.client-builder/undef)
     (. bean13495 setBucketName (clojure.core/str v13497))))
   bean13495))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
get-bucket-tagging-configuration-request
  [m13500]
  (clojure.core/let
   [arg13502
    nil
    bean13499
    (new
     com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
     arg13502)]
   bean13499))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m13504]
  (clojure.core/let
   [arg13506
    nil
    bean13503
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg13506)]
   (clojure.core/let
    [v13505
     (:bucket-name m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setBucketName (clojure.core/str v13505))))
   bean13503))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectAclRequest}
get-object-acl-request
  [m13508]
  (clojure.core/let
   [arg13510
    nil
    arg13511
    nil
    bean13507
    (new
     com.amazonaws.services.s3.model.GetObjectAclRequest
     arg13510
     arg13511)]
   (clojure.core/let
    [v13509
     (:bucket-name m13508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13509 :com.palletops.awaze.client-builder/undef)
     (. bean13507 setBucketName (clojure.core/str v13509))))
   (clojure.core/let
    [v13509 (:key m13508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13509 :com.palletops.awaze.client-builder/undef)
     (. bean13507 setKey (clojure.core/str v13509))))
   (clojure.core/let
    [v13509
     (:version-id m13508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13509 :com.palletops.awaze.client-builder/undef)
     (. bean13507 setVersionId (clojure.core/str v13509))))
   (clojure.core/let
    [v13509
     (:requester-pays
      m13508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13509 :com.palletops.awaze.client-builder/undef)
     (. bean13507 setRequesterPays (clojure.core/boolean v13509))))
   bean13507))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m13513]
  (clojure.core/let
   [bean13512 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/let
    [v13514
     (:file-offset m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setFileOffset (clojure.core/long v13514))))
   (clojure.core/let
    [v13514
     (:progress-listener
      m13513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setProgressListener v13514)))
   (clojure.core/let
    [v13514
     (:bucket-name m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setBucketName (clojure.core/str v13514))))
   (clojure.core/let
    [v13514
     (:ssecustomer-key
      m13513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setSSECustomerKey (s3/ssecustomer-key v13514))))
   (clojure.core/let
    [v13514
     (:input-stream m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (.
      bean13512
      setInputStream
      (clojure.java.io/input-stream v13514))))
   (clojure.core/let
    [v13514
     (:md5digest m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setMd5Digest (clojure.core/str v13514))))
   (clojure.core/let
    [v13514
     (:part-size m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setPartSize (clojure.core/long v13514))))
   (clojure.core/let
    [v13514
     (:requester-pays
      m13513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setRequesterPays (clojure.core/boolean v13514))))
   (clojure.core/let
    [v13514
     (:object-metadata
      m13513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setObjectMetadata (s3/object-metadata v13514))))
   (clojure.core/let
    [v13514 (:key m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setKey (clojure.core/str v13514))))
   (clojure.core/let
    [v13514
     (:part-number m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setPartNumber (clojure.core/int v13514))))
   (clojure.core/let
    [v13514 (:file m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setFile (clojure.java.io/file v13514))))
   (clojure.core/let
    [v13514
     (:last-part m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setLastPart (clojure.core/boolean v13514))))
   (clojure.core/let
    [v13514
     (:upload-id m13513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setUploadId (clojure.core/str v13514))))
   bean13512))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m13516]
  (clojure.core/let
   [arg13518
    nil
    arg13519
    (bucket-website-configuration {})
    bean13515
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg13518
     arg13519)]
   (clojure.core/let
    [v13517
     (:bucket-name m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setBucketName (clojure.core/str v13517))))
   (clojure.core/let
    [v13517
     (:configuration m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (.
      bean13515
      setConfiguration
      (s3/bucket-website-configuration v13517))))
   bean13515))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m13545]
   (clojure.core/let
    [credentials13546 (:credentials m13545) args13547 (:args m13545)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13548
      (com.palletops.awaze.common/aws-client :s3 credentials13546)]
     (clojure.core/case
      (clojure.core/count args13547)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
           (clojure.core/nth args13547 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13548
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13547 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13548
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args13547}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials13551 & args13552]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13554
     (com.palletops.awaze.common/aws-client :s3 credentials13551)]
    (clojure.core/case
     (clojure.core/count args13552)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
          (clojure.core/nth args13552 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13554
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13552 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13554
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args13552}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m13555]
   (clojure.core/let
    [credentials13556 (:credentials m13555) args13557 (:args m13555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13558
      (com.palletops.awaze.common/aws-client :s3 credentials13556)]
     (clojure.core/case
      (clojure.core/count args13557)
      3
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13557 2))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13557 2))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13557}))))))))))
      5
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13557 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13557 4))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13557 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13557 4))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13557}))))))))))
      4
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13557 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13557 3))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13557 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13557 3))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13557}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13558
        setObjectAcl
        (s3/set-object-acl-request (clojure.core/nth args13557 0))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :set-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c d]
    {:args [a b c d],
     :fn :set-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c d e]
    {:args [a b c d e],
     :fn :set-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials13566 & args13567]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13574
     (com.palletops.awaze.common/aws-client :s3 credentials13566)]
    (clojure.core/case
     (clojure.core/count args13567)
     3
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13567 2))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13567 2))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13567}))))))))))
     5
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13567 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13567 4))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13567 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13567 4))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13567}))))))))))
     4
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13567 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13567 3))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13567 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13567 3))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13567}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13574
       setObjectAcl
       (s3/set-object-acl-request (clojure.core/nth args13567 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m13575]
   (clojure.core/let
    [credentials13576 (:credentials m13575) args13577 (:args m13575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13578
      (com.palletops.awaze.common/aws-client :s3 credentials13576)]
     (clojure.core/case
      (clojure.core/count args13577)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
           (clojure.core/nth args13577 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13578
           getBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13577 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13578
               getBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLifecycleConfiguration")
                {:args args13577}))))))))))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   [credentials13581 & args13582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13584
     (com.palletops.awaze.common/aws-client :s3 credentials13581)]
    (clojure.core/case
     (clojure.core/count args13582)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
          (clojure.core/nth args13582 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13584
          getBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13582 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13584
              getBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLifecycleConfiguration")
               {:args args13582}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m13585]
   (clojure.core/let
    [credentials13586 (:credentials m13585) args13587 (:args m13585)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13588
      (com.palletops.awaze.common/aws-client :s3 credentials13586)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13588
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args13587 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listMultipartUploads"}
   [credentials13591 & args13592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13594
     (com.palletops.awaze.common/aws-client :s3 credentials13591)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13594
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args13592 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m13595]
   (clojure.core/let
    [credentials13596 (:credentials m13595) args13597 (:args m13595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13598
      (com.palletops.awaze.common/aws-client :s3 credentials13596)]
     (clojure.core/case
      (clojure.core/count args13597)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13598
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args13597 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13598
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args13597 0))
        (clojure.core/str (clojure.core/nth args13597 1))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-object-metadata,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :get-object-metadata,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials13602 & args13603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13606
     (com.palletops.awaze.common/aws-client :s3 credentials13602)]
    (clojure.core/case
     (clojure.core/count args13603)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13606
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args13603 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13606
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args13603 0))
       (clojure.core/str (clojure.core/nth args13603 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m13607]
   (clojure.core/let
    [credentials13608 (:credentials m13607) args13609 (:args m13607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13610
      (com.palletops.awaze.common/aws-client :s3 credentials13608)]
     (clojure.core/case
      (clojure.core/count args13609)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13610
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args13609 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args13609 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13610
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args13609 0))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials13614 & args13615]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13618
     (com.palletops.awaze.common/aws-client :s3 credentials13614)]
    (clojure.core/case
     (clojure.core/count args13615)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13618
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args13615 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args13615 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13618
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args13615 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-replication-configuration
   [m13619]
   (clojure.core/let
    [credentials13620 (:credentials m13619) args13621 (:args m13619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13622
      (com.palletops.awaze.common/aws-client :s3 credentials13620)]
     (clojure.core/case
      (clojure.core/count args13621)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13621 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13622
           deleteBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
               (clojure.core/nth args13621 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13622
               deleteBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketReplicationConfiguration")
                {:args args13621}))))))))))))))
  (clojure.core/defn
   delete-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket-replication-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   [credentials13625 & args13626]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13628
     (com.palletops.awaze.common/aws-client :s3 credentials13625)]
    (clojure.core/case
     (clojure.core/count args13626)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13626 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13628
          deleteBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
              (clojure.core/nth args13626 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13628
              deleteBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketReplicationConfiguration")
               {:args args13626}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m13629]
   (clojure.core/let
    [credentials13630 (:credentials m13629) args13631 (:args m13629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13632
      (com.palletops.awaze.common/aws-client :s3 credentials13630)]
     (clojure.core/case
      (clojure.core/count args13631)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args13631 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args13631 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13632
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args13631 0))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials13636 & args13637]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13640
     (com.palletops.awaze.common/aws-client :s3 credentials13636)]
    (clojure.core/case
     (clojure.core/count args13637)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13640
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args13637 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args13637 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13640
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args13637 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-object-exist
   [m13641]
   (clojure.core/let
    [credentials13642 (:credentials m13641) args13643 (:args m13641)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13644
      (com.palletops.awaze.common/aws-client :s3 credentials13642)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13644
       doesObjectExist
       (clojure.core/str (clojure.core/nth args13643 0))
       (clojure.core/str (clojure.core/nth args13643 1)))))))
  (clojure.core/defn
   does-object-exist-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for doesObjectExist"}
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :does-object-exist,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   does-object-exist
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call doesObjectExist"}
   [credentials13646 & args13647]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13648
     (com.palletops.awaze.common/aws-client :s3 credentials13646)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13648
      doesObjectExist
      (clojure.core/str (clojure.core/nth args13647 0))
      (clojure.core/str (clojure.core/nth args13647 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m13649]
   (clojure.core/let
    [credentials13650 (:credentials m13649) args13651 (:args m13649)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13652
      (com.palletops.awaze.common/aws-client :s3 credentials13650)]
     (clojure.core/case
      (clojure.core/count args13651)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13652
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args13651 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13652
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args13651 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args13651 1))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials13658 & args13659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13664
     (com.palletops.awaze.common/aws-client :s3 credentials13658)]
    (clojure.core/case
     (clojure.core/count args13659)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13664
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args13659 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13664
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args13659 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args13659 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m13665]
   (clojure.core/let
    [credentials13666 (:credentials m13665) args13667 (:args m13665)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13668
      (com.palletops.awaze.common/aws-client :s3 credentials13666)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13668
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args13667 0))
       (clojure.core/str (clojure.core/nth args13667 1))
       (clojure.core/str (clojure.core/nth args13667 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :set-object-redirect-location,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials13670 & args13671]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13672
     (com.palletops.awaze.common/aws-client :s3 credentials13670)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13672
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args13671 0))
      (clojure.core/str (clojure.core/nth args13671 1))
      (clojure.core/str (clojure.core/nth args13671 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m13673]
   (clojure.core/let
    [credentials13674 (:credentials m13673) args13675 (:args m13673)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13676
      (com.palletops.awaze.common/aws-client :s3 credentials13674)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13676
       getUrl
       (clojure.core/str (clojure.core/nth args13675 0))
       (clojure.core/str (clojure.core/nth args13675 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :get-url,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials13678 & args13679]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13680
     (com.palletops.awaze.common/aws-client :s3 credentials13678)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13680
      getUrl
      (clojure.core/str (clojure.core/nth args13679 0))
      (clojure.core/str (clojure.core/nth args13679 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m13681]
   (clojure.core/let
    [credentials13682 (:credentials m13681) args13683 (:args m13681)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13684
      (com.palletops.awaze.common/aws-client :s3 credentials13682)]
     (clojure.core/case
      (clojure.core/count args13683)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13683 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13684
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
               (clojure.core/nth args13683 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13684
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args13683}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket-policy,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials13687 & args13688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13690
     (com.palletops.awaze.common/aws-client :s3 credentials13687)]
    (clojure.core/case
     (clojure.core/count args13688)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13688 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13690
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
              (clojure.core/nth args13688 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13690
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args13688}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m13691]
   (clojure.core/let
    [credentials13692 (:credentials m13691) args13693 (:args m13691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13694
      (com.palletops.awaze.common/aws-client :s3 credentials13692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13694
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args13693 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-requester-pays,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials13696 & args13697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13698
     (com.palletops.awaze.common/aws-client :s3 credentials13696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13698
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args13697 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :head-bucket
   [m13699]
   (clojure.core/let
    [credentials13700 (:credentials m13699) args13701 (:args m13699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13702
      (com.palletops.awaze.common/aws-client :s3 credentials13700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13702
       headBucket
       (s3/head-bucket-request (clojure.core/nth args13701 0)))))))
  (clojure.core/defn
   head-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for headBucket"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :head-bucket,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   head-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call headBucket"}
   [credentials13705 & args13706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13708
     (com.palletops.awaze.common/aws-client :s3 credentials13705)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13708
      headBucket
      (s3/head-bucket-request (clojure.core/nth args13706 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m13709]
   (clojure.core/let
    [credentials13710 (:credentials m13709) args13711 (:args m13709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13712
      (com.palletops.awaze.common/aws-client :s3 credentials13710)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13712
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args13711 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-s3client-options,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials13714 & args13715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13716
     (com.palletops.awaze.common/aws-client :s3 credentials13714)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13716
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args13715 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m13717]
   (clojure.core/let
    [credentials13718 (:credentials m13717) args13719 (:args m13717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13720
      (com.palletops.awaze.common/aws-client :s3 credentials13718)]
     (clojure.core/case
      (clojure.core/count args13719)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
           (clojure.core/nth args13719 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13720
           getBucketNotificationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13719 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13720
               getBucketNotificationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketNotificationConfiguration")
                {:args args13719}))))))))))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   [credentials13723 & args13724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13726
     (com.palletops.awaze.common/aws-client :s3 credentials13723)]
    (clojure.core/case
     (clojure.core/count args13724)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
          (clojure.core/nth args13724 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13726
          getBucketNotificationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13724 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13726
              getBucketNotificationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketNotificationConfiguration")
               {:args args13724}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m13727]
   (clojure.core/let
    [credentials13728 (:credentials m13727) args13729 (:args m13727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13730
      (com.palletops.awaze.common/aws-client :s3 credentials13728)]
     (clojure.core/case
      (clojure.core/count args13729)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
           (clojure.core/nth args13729 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13730
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13729 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13730
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args13729}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials13733 & args13734]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13736
     (com.palletops.awaze.common/aws-client :s3 credentials13733)]
    (clojure.core/case
     (clojure.core/count args13734)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
          (clojure.core/nth args13734 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13736
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13734 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13736
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args13734}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m13737]
   (clojure.core/let
    [credentials13738 (:credentials m13737) args13739 (:args m13737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13740
      (com.palletops.awaze.common/aws-client :s3 credentials13738)]
     (clojure.core/case
      (clojure.core/count args13739)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ListObjectsRequest
           (clojure.core/nth args13739 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13740
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13739 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13740
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args13739}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13740
        listObjects
        (clojure.core/str (clojure.core/nth args13739 0))
        (clojure.core/str (clojure.core/nth args13739 1))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-objects,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :list-objects,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials13742 & args13743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13744
     (com.palletops.awaze.common/aws-client :s3 credentials13742)]
    (clojure.core/case
     (clojure.core/count args13743)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ListObjectsRequest
          (clojure.core/nth args13743 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13744
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13743 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13744
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args13743}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13744
       listObjects
       (clojure.core/str (clojure.core/nth args13743 0))
       (clojure.core/str (clojure.core/nth args13743 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m13745]
   (clojure.core/let
    [credentials13746 (:credentials m13745) args13747 (:args m13745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13748
      (com.palletops.awaze.common/aws-client :s3 credentials13746)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13748
       getResourceUrl
       (clojure.core/str (clojure.core/nth args13747 0))
       (clojure.core/str (clojure.core/nth args13747 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :get-resource-url,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials13750 & args13751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13752
     (com.palletops.awaze.common/aws-client :s3 credentials13750)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13752
      getResourceUrl
      (clojure.core/str (clojure.core/nth args13751 0))
      (clojure.core/str (clojure.core/nth args13751 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m13753]
   (clojure.core/let
    [credentials13754 (:credentials m13753) args13755 (:args m13753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13756
      (com.palletops.awaze.common/aws-client :s3 credentials13754)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13756
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args13755 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-requester-pays,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials13758 & args13759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13760
     (com.palletops.awaze.common/aws-client :s3 credentials13758)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13760
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args13759 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m13761]
   (clojure.core/let
    [credentials13762 (:credentials m13761) args13763 (:args m13761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13764
      (com.palletops.awaze.common/aws-client :s3 credentials13762)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13764
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args13763 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials13769 & args13770]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13774
     (com.palletops.awaze.common/aws-client :s3 credentials13769)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13774
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args13770 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m13775]
   (clojure.core/let
    [credentials13776 (:credentials m13775) args13777 (:args m13775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13778
      (com.palletops.awaze.common/aws-client :s3 credentials13776)]
     (clojure.core/case
      (clojure.core/count args13777)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13778
        getS3AccountOwner
        (s3/get-s3account-owner-request
         (clojure.core/nth args13777 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13778
        getS3AccountOwner))))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getS3AccountOwner, getS3AccountOwner"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-s3account-owner,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-s3account-owner,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getS3AccountOwner, getS3AccountOwner"}
   [credentials13780 & args13781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13782
     (com.palletops.awaze.common/aws-client :s3 credentials13780)]
    (clojure.core/case
     (clojure.core/count args13781)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13782
       getS3AccountOwner
       (s3/get-s3account-owner-request (clojure.core/nth args13781 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13782
       getS3AccountOwner))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m13783]
   (clojure.core/let
    [credentials13784 (:credentials m13783) args13785 (:args m13783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13786
      (com.palletops.awaze.common/aws-client :s3 credentials13784)]
     (clojure.core/case
      (clojure.core/count args13785)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13786
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args13785 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13786
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-buckets,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-buckets,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials13788 & args13789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13790
     (com.palletops.awaze.common/aws-client :s3 credentials13788)]
    (clojure.core/case
     (clojure.core/count args13789)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13790
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args13789 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13790
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m13791]
   (clojure.core/let
    [credentials13792 (:credentials m13791) args13793 (:args m13791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13794
      (com.palletops.awaze.common/aws-client :s3 credentials13792)]
     (clojure.core/case
      (clojure.core/count args13793)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13793 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13794
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
               (clojure.core/nth args13793 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13794
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args13793}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-website-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials13797 & args13798]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13800
     (com.palletops.awaze.common/aws-client :s3 credentials13797)]
    (clojure.core/case
     (clojure.core/count args13798)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13798 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13800
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
              (clojure.core/nth args13798 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13800
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args13798}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m13801]
   (clojure.core/let
    [credentials13802 (:credentials m13801) args13803 (:args m13801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13804
      (com.palletops.awaze.common/aws-client :s3 credentials13802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13804
       listParts
       (s3/list-parts-request (clojure.core/nth args13803 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Call listParts"}
   [credentials13809 & args13810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13814
     (com.palletops.awaze.common/aws-client :s3 credentials13809)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13814
      listParts
      (s3/list-parts-request (clojure.core/nth args13810 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m13815]
   (clojure.core/let
    [credentials13816 (:credentials m13815) args13817 (:args m13815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13818
      (com.palletops.awaze.common/aws-client :s3 credentials13816)]
     (clojure.core/case
      (clojure.core/count args13817)
      2
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13817 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13817 1))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13818
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13817 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13817 1))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13818
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13817}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13818
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args13817 0))))
      3
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13817 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13817 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13817 2))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13818
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13817 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13817 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13817 2))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13818
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13817}))))))))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials string-0 canned-access-control-list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :set-bucket-acl,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials string-0 canned-access-control-list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials13824 & args13825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13830
     (com.palletops.awaze.common/aws-client :s3 credentials13824)]
    (clojure.core/case
     (clojure.core/count args13825)
     2
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13825 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13825 1))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13830
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13825 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13825 1))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13830
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13825}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13830
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args13825 0))))
     3
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13825 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13825 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13825 2))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13830
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13825 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13825 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13825 2))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13830
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13825}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m13831]
   (clojure.core/let
    [credentials13832 (:credentials m13831) args13833 (:args m13831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13834
      (com.palletops.awaze.common/aws-client :s3 credentials13832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13834
       copyPart
       (s3/copy-part-request (clojure.core/nth args13833 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :copy-part,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Call copyPart"}
   [credentials13836 & args13837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13838
     (com.palletops.awaze.common/aws-client :s3 credentials13836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13838
      copyPart
      (s3/copy-part-request (clojure.core/nth args13837 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-replication-configuration
   [m13839]
   (clojure.core/let
    [credentials13840 (:credentials m13839) args13841 (:args m13839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13842
      (com.palletops.awaze.common/aws-client :s3 credentials13840)]
     (clojure.core/case
      (clojure.core/count args13841)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
           (clojure.core/nth args13841 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13842
           getBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13841 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13842
               getBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketReplicationConfiguration")
                {:args args13841}))))))))))))))
  (clojure.core/defn
   get-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-replication-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-replication-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   [credentials13845 & args13846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13848
     (com.palletops.awaze.common/aws-client :s3 credentials13845)]
    (clojure.core/case
     (clojure.core/count args13846)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
          (clojure.core/nth args13846 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13848
          getBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13846 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13848
              getBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketReplicationConfiguration")
               {:args args13846}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m13849]
   (clojure.core/let
    [credentials13850 (:credentials m13849) args13851 (:args m13849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13852
      (com.palletops.awaze.common/aws-client :s3 credentials13850)]
     (clojure.core/case
      (clojure.core/count args13851)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13851 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13852
           getBucketVersioningConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
               (clojure.core/nth args13851 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13852
               getBucketVersioningConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketVersioningConfiguration")
                {:args args13851}))))))))))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   [credentials13855 & args13856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13858
     (com.palletops.awaze.common/aws-client :s3 credentials13855)]
    (clojure.core/case
     (clojure.core/count args13856)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13856 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13858
          getBucketVersioningConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
              (clojure.core/nth args13856 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13858
              getBucketVersioningConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketVersioningConfiguration")
               {:args args13856}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m13859]
   (clojure.core/let
    [credentials13860 (:credentials m13859) args13861 (:args m13859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13862
      (com.palletops.awaze.common/aws-client :s3 credentials13860)]
     (clojure.core/case
      (clojure.core/count args13861)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.VersionListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.VersionListing
           (clojure.core/nth args13861 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13862
           listNextBatchOfVersions
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
               (clojure.core/nth args13861 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13862
               listNextBatchOfVersions
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfVersions")
                {:args args13861}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfVersions, listNextBatchOfVersions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-versions,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfVersions, listNextBatchOfVersions"}
   [credentials13865 & args13866]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13868
     (com.palletops.awaze.common/aws-client :s3 credentials13865)]
    (clojure.core/case
     (clojure.core/count args13866)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.VersionListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.VersionListing
          (clojure.core/nth args13866 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13868
          listNextBatchOfVersions
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
              (clojure.core/nth args13866 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13868
              listNextBatchOfVersions
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfVersions")
               {:args args13866}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m13869]
   (clojure.core/let
    [credentials13870 (:credentials m13869) args13871 (:args m13869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13872
      (com.palletops.awaze.common/aws-client :s3 credentials13870)]
     (clojure.core/case
      (clojure.core/count args13871)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13871 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13872
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketAclRequest
               (clojure.core/nth args13871 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13872
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args13871}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-acl,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials13875 & args13876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13878
     (com.palletops.awaze.common/aws-client :s3 credentials13875)]
    (clojure.core/case
     (clojure.core/count args13876)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13876 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13878
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketAclRequest
              (clojure.core/nth args13876 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13878
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args13876}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m13879]
   (clojure.core/let
    [credentials13880 (:credentials m13879) args13881 (:args m13879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13882
      (com.palletops.awaze.common/aws-client :s3 credentials13880)]
     (clojure.core/case
      (clojure.core/count args13881)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13882
        deleteObject
        (clojure.core/str (clojure.core/nth args13881 0))
        (clojure.core/str (clojure.core/nth args13881 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13882
        deleteObject
        (s3/delete-object-request (clojure.core/nth args13881 0))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-object,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :delete-object,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials13886 & args13887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13890
     (com.palletops.awaze.common/aws-client :s3 credentials13886)]
    (clojure.core/case
     (clojure.core/count args13887)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13890
       deleteObject
       (clojure.core/str (clojure.core/nth args13887 0))
       (clojure.core/str (clojure.core/nth args13887 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13890
       deleteObject
       (s3/delete-object-request (clojure.core/nth args13887 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m13891]
   (clojure.core/let
    [credentials13892 (:credentials m13891) args13893 (:args m13891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13894
      (com.palletops.awaze.common/aws-client :s3 credentials13892)]
     (clojure.core/case
      (clojure.core/count args13893)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13893 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
               (clojure.core/nth args13893 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args13893}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials13897 & args13898]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13900
     (com.palletops.awaze.common/aws-client :s3 credentials13897)]
    (clojure.core/case
     (clojure.core/count args13898)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13898 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13900
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
              (clojure.core/nth args13898 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13900
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args13898}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m13901]
   (clojure.core/let
    [credentials13902 (:credentials m13901) args13903 (:args m13901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13904
      (com.palletops.awaze.common/aws-client :s3 credentials13902)]
     (clojure.core/case
      (clojure.core/count args13903)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
           (clojure.core/nth args13903 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13904
           getBucketLoggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13903 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13904
               getBucketLoggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLoggingConfiguration")
                {:args args13903}))))))))))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   [credentials13907 & args13908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13910
     (com.palletops.awaze.common/aws-client :s3 credentials13907)]
    (clojure.core/case
     (clojure.core/count args13908)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
          (clojure.core/nth args13908 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13910
          getBucketLoggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13908 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13910
              getBucketLoggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLoggingConfiguration")
               {:args args13908}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m13911]
   (clojure.core/let
    [credentials13912 (:credentials m13911) args13913 (:args m13911)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13914
      (com.palletops.awaze.common/aws-client :s3 credentials13912)]
     (clojure.core/case
      (clojure.core/count args13913)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13914
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13913 0))
        (clojure.core/str (clojure.core/nth args13913 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13913 2))
        (root/http-method (clojure.core/nth args13913 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13914
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args13913 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13914
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13913 0))
        (clojure.core/str (clojure.core/nth args13913 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13913 2))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :generate-presigned-url,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :generate-presigned-url,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c d]
    {:args [a b c d],
     :fn :generate-presigned-url,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials13918 & args13919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13922
     (com.palletops.awaze.common/aws-client :s3 credentials13918)]
    (clojure.core/case
     (clojure.core/count args13919)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13922
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13919 0))
       (clojure.core/str (clojure.core/nth args13919 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13919 2))
       (root/http-method (clojure.core/nth args13919 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13922
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args13919 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13922
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13919 0))
       (clojure.core/str (clojure.core/nth args13919 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13919 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m13923]
   (clojure.core/let
    [credentials13924 (:credentials m13923) args13925 (:args m13923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13926
      (com.palletops.awaze.common/aws-client :s3 credentials13924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13926
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args13925 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :is-requester-pays-enabled,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials13928 & args13929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13930
     (com.palletops.awaze.common/aws-client :s3 credentials13928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13930
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args13929 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m13931]
   (clojure.core/let
    [credentials13932 (:credentials m13931) args13933 (:args m13931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13934
      (com.palletops.awaze.common/aws-client :s3 credentials13932)]
     (clojure.core/case
      (clojure.core/count args13933)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13934
        copyObject
        (s3/copy-object-request (clojure.core/nth args13933 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13934
        copyObject
        (clojure.core/str (clojure.core/nth args13933 0))
        (clojure.core/str (clojure.core/nth args13933 1))
        (clojure.core/str (clojure.core/nth args13933 2))
        (clojure.core/str (clojure.core/nth args13933 3))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]
                [credentials string-0 string-1 string-2 string-3]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :copy-object,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c d]
    {:args [a b c d],
     :fn :copy-object,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]
                [credentials string-0 string-1 string-2 string-3]]),
    :doc "Call copyObject, copyObject"}
   [credentials13940 & args13941]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13946
     (com.palletops.awaze.common/aws-client :s3 credentials13940)]
    (clojure.core/case
     (clojure.core/count args13941)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13946
       copyObject
       (s3/copy-object-request (clojure.core/nth args13941 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13946
       copyObject
       (clojure.core/str (clojure.core/nth args13941 0))
       (clojure.core/str (clojure.core/nth args13941 1))
       (clojure.core/str (clojure.core/nth args13941 2))
       (clojure.core/str (clojure.core/nth args13941 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m13947]
   (clojure.core/let
    [credentials13948 (:credentials m13947) args13949 (:args m13947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13950
      (com.palletops.awaze.common/aws-client :s3 credentials13948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13950
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args13949 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-objects,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call deleteObjects"}
   [credentials13953 & args13954]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13956
     (com.palletops.awaze.common/aws-client :s3 credentials13953)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13956
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args13954 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m13957]
   (clojure.core/let
    [credentials13958 (:credentials m13957) args13959 (:args m13957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13960
      (com.palletops.awaze.common/aws-client :s3 credentials13958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13960
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args13959 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials13964 & args13965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13968
     (com.palletops.awaze.common/aws-client :s3 credentials13964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13968
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args13965 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m13969]
   (clojure.core/let
    [credentials13970 (:credentials m13969) args13971 (:args m13969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13972
      (com.palletops.awaze.common/aws-client :s3 credentials13970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13972
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args13971 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials13976 & args13977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13980
     (com.palletops.awaze.common/aws-client :s3 credentials13976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13980
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args13977 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m13981]
   (clojure.core/let
    [credentials13982 (:credentials m13981) args13983 (:args m13981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13984
      (com.palletops.awaze.common/aws-client :s3 credentials13982)]
     (clojure.core/case
      (clojure.core/count args13983)
      2
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13983 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13983 1))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13984
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetObjectRequest
               (clojure.core/nth args13983 0))
^{:tag java.io.File}
b
              (com.palletops.awaze.common/coerce-value-form
               java.io.File
               (clojure.core/nth args13983 1))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13984
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args13983}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13984
        getObject
        (s3/get-object-request (clojure.core/nth args13983 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials {:keys []}]
                [credentials {:keys []} file-1]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-object,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :get-object,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials {:keys []}]
                [credentials {:keys []} file-1]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials13990 & args13991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13996
     (com.palletops.awaze.common/aws-client :s3 credentials13990)]
    (clojure.core/case
     (clojure.core/count args13991)
     2
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13991 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13991 1))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13996
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetObjectRequest
              (clojure.core/nth args13991 0))
^{:tag java.io.File}
b
             (com.palletops.awaze.common/coerce-value-form
              java.io.File
              (clojure.core/nth args13991 1))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13996
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args13991}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13996
       getObject
       (s3/get-object-request (clojure.core/nth args13991 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m13997]
   (clojure.core/let
    [credentials13998 (:credentials m13997) args13999 (:args m13997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14000
      (com.palletops.awaze.common/aws-client :s3 credentials13998)]
     (clojure.core/case
      (clojure.core/count args13999)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13999 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14000
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
               (clojure.core/nth args13999 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14000
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args13999}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials14003 & args14004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14006
     (com.palletops.awaze.common/aws-client :s3 credentials14003)]
    (clojure.core/case
     (clojure.core/count args14004)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14004 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14006
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14004 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14006
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args14004}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m14007]
   (clojure.core/let
    [credentials14008 (:credentials m14007) args14009 (:args m14007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14010
      (com.palletops.awaze.common/aws-client :s3 credentials14008)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14010
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args14009 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials14012 & args14013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14014
     (com.palletops.awaze.common/aws-client :s3 credentials14012)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14014
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args14013 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m14015]
   (clojure.core/let
    [credentials14016 (:credentials m14015) args14017 (:args m14015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14018
      (com.palletops.awaze.common/aws-client :s3 credentials14016)]
     (clojure.core/case
      (clojure.core/count args14017)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14018
        restoreObject
        (s3/restore-object-request (clojure.core/nth args14017 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14018
        restoreObject
        (clojure.core/str (clojure.core/nth args14017 0))
        (clojure.core/str (clojure.core/nth args14017 1))
        (clojure.core/int (clojure.core/nth args14017 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :restore-object,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :restore-object,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials14022 & args14023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14026
     (com.palletops.awaze.common/aws-client :s3 credentials14022)]
    (clojure.core/case
     (clojure.core/count args14023)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14026
       restoreObject
       (s3/restore-object-request (clojure.core/nth args14023 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14026
       restoreObject
       (clojure.core/str (clojure.core/nth args14023 0))
       (clojure.core/str (clojure.core/nth args14023 1))
       (clojure.core/int (clojure.core/nth args14023 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m14027]
   (clojure.core/let
    [credentials14028 (:credentials m14027) args14029 (:args m14027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14030
      (com.palletops.awaze.common/aws-client :s3 credentials14028)]
     (clojure.core/case
      (clojure.core/count args14029)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14029 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14030
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketPolicyRequest
               (clojure.core/nth args14029 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14030
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args14029}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-policy,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials14033 & args14034]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14036
     (com.palletops.awaze.common/aws-client :s3 credentials14033)]
    (clojure.core/case
     (clojure.core/count args14034)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14034 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14036
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketPolicyRequest
              (clojure.core/nth args14034 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14036
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args14034}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-replication-configuration
   [m14037]
   (clojure.core/let
    [credentials14038 (:credentials m14037) args14039 (:args m14037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14040
      (com.palletops.awaze.common/aws-client :s3 credentials14038)]
     (clojure.core/case
      (clojure.core/count args14039)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14040
        setBucketReplicationConfiguration
        (clojure.core/str (clojure.core/nth args14039 0))
        (s3/bucket-replication-configuration
         (clojure.core/nth args14039 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14040
        setBucketReplicationConfiguration
        (s3/set-bucket-replication-configuration-request
         (clojure.core/nth args14039 0))))))))
  (clojure.core/defn
   set-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [role-arn rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [role-arn rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   [credentials14042 & args14043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14044
     (com.palletops.awaze.common/aws-client :s3 credentials14042)]
    (clojure.core/case
     (clojure.core/count args14043)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14044
       setBucketReplicationConfiguration
       (clojure.core/str (clojure.core/nth args14043 0))
       (s3/bucket-replication-configuration
        (clojure.core/nth args14043 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14044
       setBucketReplicationConfiguration
       (s3/set-bucket-replication-configuration-request
        (clojure.core/nth args14043 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m14045]
   (clojure.core/let
    [credentials14046 (:credentials m14045) args14047 (:args m14045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14048
      (com.palletops.awaze.common/aws-client :s3 credentials14046)]
     (clojure.core/case
      (clojure.core/count args14047)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CreateBucketRequest
           (clojure.core/nth args14047 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14048
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14047 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14048
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14047}))))))))))
      2
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14047 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14047 1))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14048
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14047 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.Region
               (clojure.core/nth args14047 1))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14048
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14047}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0 string-1]
                [credentials string-0 region-1]
                [credentials string-0]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-bucket,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :create-bucket,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0 string-1]
                [credentials string-0 region-1]
                [credentials string-0]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials14051 & args14052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14054
     (com.palletops.awaze.common/aws-client :s3 credentials14051)]
    (clojure.core/case
     (clojure.core/count args14052)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CreateBucketRequest
          (clojure.core/nth args14052 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14052 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14052}))))))))))
     2
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14052 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14052 1))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14052 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.Region
              (clojure.core/nth args14052 1))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14054
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14052}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m14055]
   (clojure.core/let
    [credentials14056 (:credentials m14055) args14057 (:args m14055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14058
      (com.palletops.awaze.common/aws-client :s3 credentials14056)]
     (clojure.core/case
      (clojure.core/count args14057)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14058
        deleteVersion
        (clojure.core/str (clojure.core/nth args14057 0))
        (clojure.core/str (clojure.core/nth args14057 1))
        (clojure.core/str (clojure.core/nth args14057 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14058
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args14057 0))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-version,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :delete-version,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials14063 & args14064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14068
     (com.palletops.awaze.common/aws-client :s3 credentials14063)]
    (clojure.core/case
     (clojure.core/count args14064)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14068
       deleteVersion
       (clojure.core/str (clojure.core/nth args14064 0))
       (clojure.core/str (clojure.core/nth args14064 1))
       (clojure.core/str (clojure.core/nth args14064 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14068
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args14064 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m14069]
   (clojure.core/let
    [credentials14070 (:credentials m14069) args14071 (:args m14069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14072
      (com.palletops.awaze.common/aws-client :s3 credentials14070)]
     (clojure.core/case
      (clojure.core/count args14071)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
        putObject
        (clojure.core/str (clojure.core/nth args14071 0))
        (clojure.core/str (clojure.core/nth args14071 1))
        (clojure.java.io/input-stream (clojure.core/nth args14071 2))
        (s3/object-metadata (clojure.core/nth args14071 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
        putObject
        (s3/put-object-request (clojure.core/nth args14071 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
        putObject
        (clojure.core/str (clojure.core/nth args14071 0))
        (clojure.core/str (clojure.core/nth args14071 1))
        (clojure.java.io/file (clojure.core/nth args14071 2))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-object,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :put-object,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c d]
    {:args [a b c d],
     :fn :put-object,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials14080 & args14081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14088
     (com.palletops.awaze.common/aws-client :s3 credentials14080)]
    (clojure.core/case
     (clojure.core/count args14081)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14088
       putObject
       (clojure.core/str (clojure.core/nth args14081 0))
       (clojure.core/str (clojure.core/nth args14081 1))
       (clojure.java.io/input-stream (clojure.core/nth args14081 2))
       (s3/object-metadata (clojure.core/nth args14081 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14088
       putObject
       (s3/put-object-request (clojure.core/nth args14081 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14088
       putObject
       (clojure.core/str (clojure.core/nth args14081 0))
       (clojure.core/str (clojure.core/nth args14081 1))
       (clojure.java.io/file (clojure.core/nth args14081 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m14089]
   (clojure.core/let
    [credentials14090 (:credentials m14089) args14091 (:args m14089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14092
      (com.palletops.awaze.common/aws-client :s3 credentials14090)]
     (clojure.core/case
      (clojure.core/count args14091)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14092
        listVersions
        (clojure.core/str (clojure.core/nth args14091 0))
        (clojure.core/str (clojure.core/nth args14091 1))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14092
        listVersions
        (clojure.core/str (clojure.core/nth args14091 0))
        (clojure.core/str (clojure.core/nth args14091 1))
        (clojure.core/str (clojure.core/nth args14091 2))
        (clojure.core/str (clojure.core/nth args14091 3))
        (clojure.core/str (clojure.core/nth args14091 4))
        (clojure.core/int (clojure.core/nth args14091 5))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14092
        listVersions
        (s3/list-versions-request (clojure.core/nth args14091 0))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-versions,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :list-versions,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c d e f]
    {:args [a b c d e f],
     :fn :list-versions,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials14094 & args14095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14096
     (com.palletops.awaze.common/aws-client :s3 credentials14094)]
    (clojure.core/case
     (clojure.core/count args14095)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14096
       listVersions
       (clojure.core/str (clojure.core/nth args14095 0))
       (clojure.core/str (clojure.core/nth args14095 1))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14096
       listVersions
       (clojure.core/str (clojure.core/nth args14095 0))
       (clojure.core/str (clojure.core/nth args14095 1))
       (clojure.core/str (clojure.core/nth args14095 2))
       (clojure.core/str (clojure.core/nth args14095 3))
       (clojure.core/str (clojure.core/nth args14095 4))
       (clojure.core/int (clojure.core/nth args14095 5))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14096
       listVersions
       (s3/list-versions-request (clojure.core/nth args14095 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m14097]
   (clojure.core/let
    [credentials14098 (:credentials m14097) args14099 (:args m14097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14100
      (com.palletops.awaze.common/aws-client :s3 credentials14098)]
     (clojure.core/case
      (clojure.core/count args14099)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14100
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args14099 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args14099 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14100
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args14099 0))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials14104 & args14105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14108
     (com.palletops.awaze.common/aws-client :s3 credentials14104)]
    (clojure.core/case
     (clojure.core/count args14105)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14108
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args14105 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args14105 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14108
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args14105 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m14109]
   (clojure.core/let
    [credentials14110 (:credentials m14109) args14111 (:args m14109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14112
      (com.palletops.awaze.common/aws-client :s3 credentials14110)]
     (clojure.core/case
      (clojure.core/count args14111)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14111 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
           getBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
               (clojure.core/nth args14111 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
               getBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketCrossOriginConfiguration")
                {:args args14111}))))))))))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   [credentials14115 & args14116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14118
     (com.palletops.awaze.common/aws-client :s3 credentials14115)]
    (clojure.core/case
     (clojure.core/count args14116)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14116 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14118
          getBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14116 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14118
              getBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketCrossOriginConfiguration")
               {:args args14116}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m14119]
   (clojure.core/let
    [credentials14120 (:credentials m14119) args14121 (:args m14119)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14122
      (com.palletops.awaze.common/aws-client :s3 credentials14120)]
     (clojure.core/case
      (clojure.core/count args14121)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14122
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args14121 0))
        (clojure.core/str (clojure.core/nth args14121 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14122
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args14121 0))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-policy,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-policy,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials14126 & args14127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14130
     (com.palletops.awaze.common/aws-client :s3 credentials14126)]
    (clojure.core/case
     (clojure.core/count args14127)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args14127 0))
       (clojure.core/str (clojure.core/nth args14127 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args14127 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m14131]
   (clojure.core/let
    [credentials14132 (:credentials m14131) args14133 (:args m14131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14134
      (com.palletops.awaze.common/aws-client :s3 credentials14132)]
     (clojure.core/case
      (clojure.core/count args14133)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ObjectListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ObjectListing
           (clojure.core/nth args14133 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14134
           listNextBatchOfObjects
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
               (clojure.core/nth args14133 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14134
               listNextBatchOfObjects
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfObjects")
                {:args args14133}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfObjects, listNextBatchOfObjects"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-objects,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfObjects, listNextBatchOfObjects"}
   [credentials14137 & args14138]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14140
     (com.palletops.awaze.common/aws-client :s3 credentials14137)]
    (clojure.core/case
     (clojure.core/count args14138)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ObjectListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ObjectListing
          (clojure.core/nth args14138 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14140
          listNextBatchOfObjects
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
              (clojure.core/nth args14138 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14140
              listNextBatchOfObjects
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfObjects")
               {:args args14138}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m14141]
   (clojure.core/let
    [credentials14142 (:credentials m14141) args14143 (:args m14141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14144
      (com.palletops.awaze.common/aws-client :s3 credentials14142)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14144
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args14143 0))
       (clojure.core/str (clojure.core/nth args14143 1))
       (s3/storage-class (clojure.core/nth args14143 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :change-object-storage-class,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials14146 & args14147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14148
     (com.palletops.awaze.common/aws-client :s3 credentials14146)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14148
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args14147 0))
      (clojure.core/str (clojure.core/nth args14147 1))
      (s3/storage-class (clojure.core/nth args14147 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m14149]
   (clojure.core/let
    [credentials14150 (:credentials m14149) args14151 (:args m14149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14152
      (com.palletops.awaze.common/aws-client :s3 credentials14150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14152
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args14151 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials14156 & args14157]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14160
     (com.palletops.awaze.common/aws-client :s3 credentials14156)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14160
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args14157 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m14161]
   (clojure.core/let
    [credentials14162 (:credentials m14161) args14163 (:args m14161)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14164
      (com.palletops.awaze.common/aws-client :s3 credentials14162)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14164
       setRegion
       (regions/region (clojure.core/nth args14163 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-region,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials14166 & args14167]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14168
     (com.palletops.awaze.common/aws-client :s3 credentials14166)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14168
      setRegion
      (regions/region (clojure.core/nth args14167 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m14169]
   (clojure.core/let
    [credentials14170 (:credentials m14169) args14171 (:args m14169)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14172
      (com.palletops.awaze.common/aws-client :s3 credentials14170)]
     (clojure.core/case
      (clojure.core/count args14171)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14171 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14172
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketRequest
               (clojure.core/nth args14171 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14172
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args14171}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-bucket,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials14175 & args14176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14178
     (com.palletops.awaze.common/aws-client :s3 credentials14175)]
    (clojure.core/case
     (clojure.core/count args14176)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14176 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14178
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketRequest
              (clojure.core/nth args14176 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14178
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args14176}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m14179]
   (clojure.core/let
    [credentials14180 (:credentials m14179) args14181 (:args m14179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14182
      (com.palletops.awaze.common/aws-client :s3 credentials14180)]
     (clojure.core/case
      (clojure.core/count args14181)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
           (clojure.core/nth args14181 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14182
           getBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14181 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14182
               getBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketTaggingConfiguration")
                {:args args14181}))))))))))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   [credentials14185 & args14186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14188
     (com.palletops.awaze.common/aws-client :s3 credentials14185)]
    (clojure.core/case
     (clojure.core/count args14186)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
          (clojure.core/nth args14186 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14188
          getBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14186 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14188
              getBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketTaggingConfiguration")
               {:args args14186}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m14189]
   (clojure.core/let
    [credentials14190 (:credentials m14189) args14191 (:args m14189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14192
      (com.palletops.awaze.common/aws-client :s3 credentials14190)]
     (clojure.core/case
      (clojure.core/count args14191)
      1
      (clojure.core/let
       [a__1759__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLocationRequest
           (clojure.core/nth args14191 0))]
         (clojure.core/reset! a__1759__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14192
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1760__auto__
         (if
          (clojure.core/deref a__1759__auto__)
          (throw e__1760__auto__)
          (clojure.core/let
           [a__1759__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14191 0))]
             (clojure.core/reset! a__1759__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14192
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1760__auto__
             (if
              (clojure.core/deref a__1759__auto__)
              (throw e__1760__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args14191}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-bucket-location,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials14195 & args14196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14198
     (com.palletops.awaze.common/aws-client :s3 credentials14195)]
    (clojure.core/case
     (clojure.core/count args14196)
     1
     (clojure.core/let
      [a__1759__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLocationRequest
          (clojure.core/nth args14196 0))]
        (clojure.core/reset! a__1759__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14198
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1760__auto__
        (if
         (clojure.core/deref a__1759__auto__)
         (throw e__1760__auto__)
         (clojure.core/let
          [a__1759__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14196 0))]
            (clojure.core/reset! a__1759__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14198
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1760__auto__
            (if
             (clojure.core/deref a__1759__auto__)
             (throw e__1760__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args14196}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m14199]
   (clojure.core/let
    [credentials14200 (:credentials m14199) args14201 (:args m14199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14202
      (com.palletops.awaze.common/aws-client :s3 credentials14200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14202
       doesBucketExist
       (clojure.core/str (clojure.core/nth args14201 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :does-bucket-exist,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials14204 & args14205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14206
     (com.palletops.awaze.common/aws-client :s3 credentials14204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14206
      doesBucketExist
      (clojure.core/str (clojure.core/nth args14205 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m14207]
   (clojure.core/let
    [credentials14208 (:credentials m14207) args14209 (:args m14207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14210
      (com.palletops.awaze.common/aws-client :s3 credentials14208)]
     (clojure.core/case
      (clojure.core/count args14209)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14210
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14209 0))
        (clojure.core/str (clojure.core/nth args14209 1))
        (clojure.core/str (clojure.core/nth args14209 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14210
        getObjectAcl
        (s3/get-object-acl-request (clojure.core/nth args14209 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14210
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14209 0))
        (clojure.core/str (clojure.core/nth args14209 1))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectAcl, getObjectAcl, getObjectAcl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :get-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b c]
    {:args [a b c],
     :fn :get-object-acl,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObjectAcl, getObjectAcl, getObjectAcl"}
   [credentials14214 & args14215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14218
     (com.palletops.awaze.common/aws-client :s3 credentials14214)]
    (clojure.core/case
     (clojure.core/count args14215)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14218
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14215 0))
       (clojure.core/str (clojure.core/nth args14215 1))
       (clojure.core/str (clojure.core/nth args14215 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14218
       getObjectAcl
       (s3/get-object-acl-request (clojure.core/nth args14215 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14218
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14215 0))
       (clojure.core/str (clojure.core/nth args14215 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m14219]
   (clojure.core/let
    [credentials14220 (:credentials m14219) args14221 (:args m14219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14222
      (com.palletops.awaze.common/aws-client :s3 credentials14220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14222
       uploadPart
       (s3/upload-part-request (clojure.core/nth args14221 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :upload-part,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Call uploadPart"}
   [credentials14224 & args14225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14226
     (com.palletops.awaze.common/aws-client :s3 credentials14224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14226
      uploadPart
      (s3/upload-part-request (clojure.core/nth args14225 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m14227]
   (clojure.core/let
    [credentials14228 (:credentials m14227) args14229 (:args m14227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14230
      (com.palletops.awaze.common/aws-client :s3 credentials14228)]
     (clojure.core/case
      (clojure.core/count args14229)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14230
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args14229 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args14229 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14230
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args14229 0))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1784__auto__,
     :client :s3})
   ([credentials__1784__auto__ a b]
    {:args [a b],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials14234 & args14235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14238
     (com.palletops.awaze.common/aws-client :s3 credentials14234)]
    (clojure.core/case
     (clojure.core/count args14235)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14238
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args14235 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args14235 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14238
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args14235 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m14239]
   (clojure.core/let
    [credentials14240 (:credentials m14239) args14241 (:args m14239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14242
      (com.palletops.awaze.common/aws-client :s3 credentials14240)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14242
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-region,
     :credentials credentials__1784__auto__,
     :client :s3}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials14244 & args14245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14246
     (com.palletops.awaze.common/aws-client :s3 credentials14244)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14246
      getRegion))))))
