(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11084]
  (clojure.core/let
   [bean11083 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/let
    [v11085
     (:hosted-zone-id
      m11084
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11085 :com.palletops.awaze.client-builder/undef)
     (. bean11083 setHostedZoneId (clojure.core/str v11085))))
   (clojure.core/let
    [v11085
     (:dnsname m11084 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11085 :com.palletops.awaze.client-builder/undef)
     (. bean11083 setDNSName (clojure.core/str v11085))))
   (clojure.core/let
    [v11085
     (:evaluate-target-health
      m11084
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11085 :com.palletops.awaze.client-builder/undef)
     (.
      bean11083
      setEvaluateTargetHealth
      (clojure.core/boolean v11085))))
   bean11083))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetRegion}
resource-record-set-region
  [m11087]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetRegion
   fromValue
   (clojure.core/name m11087)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11090]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11090)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11093]
  (clojure.core/let
   [bean11092
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/let
    [v11094 (:value m11093 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11094 :com.palletops.awaze.client-builder/undef)
     (. bean11092 setValue (clojure.core/str v11094))))
   bean11092))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GeoLocation}
geo-location
  [m11096]
  (clojure.core/let
   [bean11095 (new com.amazonaws.services.route53.model.GeoLocation)]
   (clojure.core/let
    [v11097
     (:continent-code
      m11096
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11097 :com.palletops.awaze.client-builder/undef)
     (. bean11095 setContinentCode (clojure.core/str v11097))))
   (clojure.core/let
    [v11097
     (:country-code m11096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11097 :com.palletops.awaze.client-builder/undef)
     (. bean11095 setCountryCode (clojure.core/str v11097))))
   (clojure.core/let
    [v11097
     (:subdivision-code
      m11096
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11097 :com.palletops.awaze.client-builder/undef)
     (. bean11095 setSubdivisionCode (clojure.core/str v11097))))
   bean11095))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeAction}
change-action
  [m11099]
  (.
   com.amazonaws.services.route53.model.ChangeAction
   fromValue
   (clojure.core/name m11099)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11102]
  (clojure.core/let
   [bean11101
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/let
    [v11103
     (:alias-target m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setAliasTarget (route53/alias-target v11103))))
   (clojure.core/let
    [v11103
     (:region m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (.
      bean11101
      setRegion
      (route53/resource-record-set-region v11103))))
   (clojure.core/let
    [v11103
     (:failover m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setFailover (clojure.core/str v11103))))
   (clojure.core/let
    [v11103
     (:set-identifier
      m11102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setSetIdentifier (clojure.core/str v11103))))
   (clojure.core/let
    [v11103
     (:traffic-policy-instance-id
      m11102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (.
      bean11101
      setTrafficPolicyInstanceId
      (clojure.core/str v11103))))
   (clojure.core/let
    [v11103 (:type m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setType (route53/rrtype v11103))))
   (clojure.core/let
    [v11103 (:name m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setName (clojure.core/str v11103))))
   (clojure.core/let
    [v11103
     (:weight m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setWeight (clojure.core/long v11103))))
   (clojure.core/let
    [v11103 (:ttl m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setTTL (clojure.core/long v11103))))
   (clojure.core/let
    [v11103
     (:health-check-id
      m11102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setHealthCheckId (clojure.core/str v11103))))
   (clojure.core/let
    [v11103
     (:resource-records
      m11102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (.
      bean11101
      setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11272] (route53/resource-record arg11272))
 v11103))))
   (clojure.core/let
    [v11103
     (:geo-location m11102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11103 :com.palletops.awaze.client-builder/undef)
     (. bean11101 setGeoLocation (route53/geo-location v11103))))
   bean11101))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11105]
  (clojure.core/let
   [bean11104 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/let
    [v11106
     (:action m11105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11106 :com.palletops.awaze.client-builder/undef)
     (. bean11104 setAction (route53/change-action v11106))))
   (clojure.core/let
    [v11106
     (:resource-record-set
      m11105
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11106 :com.palletops.awaze.client-builder/undef)
     (.
      bean11104
      setResourceRecordSet
      (route53/resource-record-set v11106))))
   bean11104))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckType}
health-check-type
  [m11108]
  (.
   com.amazonaws.services.route53.model.HealthCheckType
   fromValue
   (clojure.core/name m11108)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11111]
  (clojure.core/let
   [bean11110 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/let
    [v11112
     (:comment m11111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11112 :com.palletops.awaze.client-builder/undef)
     (. bean11110 setComment (clojure.core/str v11112))))
   (clojure.core/let
    [v11112
     (:changes m11111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11112 :com.palletops.awaze.client-builder/undef)
     (.
      bean11110
      setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11273] (route53/change arg11273))
 v11112))))
   bean11110))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPC}
vpc
  [m11114]
  (clojure.core/let
   [bean11113 (new com.amazonaws.services.route53.model.VPC)]
   (clojure.core/let
    [v11115 (:vpcid m11114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11115 :com.palletops.awaze.client-builder/undef)
     (. bean11113 setVPCId (clojure.core/str v11115))))
   (clojure.core/let
    [v11115
     (:vpcregion m11114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11115 :com.palletops.awaze.client-builder/undef)
     (. bean11113 setVPCRegion (clojure.core/str v11115))))
   bean11113))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11117]
  (clojure.core/let
   [bean11116
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/let
    [v11118
     (:comment m11117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11118 :com.palletops.awaze.client-builder/undef)
     (. bean11116 setComment (clojure.core/str v11118))))
   (clojure.core/let
    [v11118
     (:private-zone m11117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11118 :com.palletops.awaze.client-builder/undef)
     (. bean11116 setPrivateZone (clojure.core/boolean v11118))))
   bean11116))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11120]
  (clojure.core/let
   [bean11119
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/let
    [v11121
     (:inverted m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setInverted (clojure.core/boolean v11121))))
   (clojure.core/let
    [v11121 (:type m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setType (route53/health-check-type v11121))))
   (clojure.core/let
    [v11121
     (:resource-path m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setResourcePath (clojure.core/str v11121))))
   (clojure.core/let
    [v11121
     (:search-string m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setSearchString (clojure.core/str v11121))))
   (clojure.core/let
    [v11121
     (:child-health-checks
      m11120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (.
      bean11119
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11274] (clojure.core/str arg11274))
 v11121))))
   (clojure.core/let
    [v11121 (:port m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setPort (clojure.core/int v11121))))
   (clojure.core/let
    [v11121
     (:health-threshold
      m11120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setHealthThreshold (clojure.core/int v11121))))
   (clojure.core/let
    [v11121
     (:request-interval
      m11120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setRequestInterval (clojure.core/int v11121))))
   (clojure.core/let
    [v11121
     (:ipaddress m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setIPAddress (clojure.core/str v11121))))
   (clojure.core/let
    [v11121
     (:fully-qualified-domain-name
      m11120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (.
      bean11119
      setFullyQualifiedDomainName
      (clojure.core/str v11121))))
   (clojure.core/let
    [v11121
     (:enable-sni m11120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setEnableSNI (clojure.core/boolean v11121))))
   (clojure.core/let
    [v11121
     (:measure-latency
      m11120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setMeasureLatency (clojure.core/boolean v11121))))
   (clojure.core/let
    [v11121
     (:failure-threshold
      m11120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11121 :com.palletops.awaze.client-builder/undef)
     (. bean11119 setFailureThreshold (clojure.core/int v11121))))
   bean11119))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Tag}
tag
  [m11123]
  (clojure.core/let
   [bean11122 (new com.amazonaws.services.route53.model.Tag)]
   (clojure.core/let
    [v11124 (:value m11123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11124 :com.palletops.awaze.client-builder/undef)
     (. bean11122 setValue (clojure.core/str v11124))))
   (clojure.core/let
    [v11124 (:key m11123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11124 :com.palletops.awaze.client-builder/undef)
     (. bean11122 setKey (clojure.core/str v11124))))
   bean11122))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.TagResourceType}
tag-resource-type
  [m11126]
  (.
   com.amazonaws.services.route53.model.TagResourceType
   fromValue
   (clojure.core/name m11126)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest}
create-traffic-policy-version-request
  [m11129]
  (clojure.core/let
   [bean11128
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest)]
   (clojure.core/let
    [v11130
     (:comment m11129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11130 :com.palletops.awaze.client-builder/undef)
     (. bean11128 setComment (clojure.core/str v11130))))
   (clojure.core/let
    [v11130 (:id m11129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11130 :com.palletops.awaze.client-builder/undef)
     (. bean11128 setId (clojure.core/str v11130))))
   (clojure.core/let
    [v11130
     (:document m11129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11130 :com.palletops.awaze.client-builder/undef)
     (. bean11128 setDocument (clojure.core/str v11130))))
   bean11128))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest}
delete-traffic-policy-request
  [m11132]
  (clojure.core/let
   [bean11131
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest)]
   (clojure.core/let
    [v11133
     (:version m11132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11133 :com.palletops.awaze.client-builder/undef)
     (. bean11131 setVersion (clojure.core/int v11133))))
   (clojure.core/let
    [v11133 (:id m11132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11133 :com.palletops.awaze.client-builder/undef)
     (. bean11131 setId (clojure.core/str v11133))))
   bean11131))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11135]
  (clojure.core/let
   [bean11134
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/let
    [v11136
     (:hosted-zone-id
      m11135
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11136 :com.palletops.awaze.client-builder/undef)
     (. bean11134 setHostedZoneId (clojure.core/str v11136))))
   (clojure.core/let
    [v11136
     (:change-batch m11135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11136 :com.palletops.awaze.client-builder/undef)
     (. bean11134 setChangeBatch (route53/change-batch v11136))))
   bean11134))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPoliciesRequest}
list-traffic-policies-request
  [m11138]
  (clojure.core/let
   [bean11137
    (new
     com.amazonaws.services.route53.model.ListTrafficPoliciesRequest)]
   (clojure.core/let
    [v11139
     (:max-items m11138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11139 :com.palletops.awaze.client-builder/undef)
     (. bean11137 setMaxItems (clojure.core/str v11139))))
   (clojure.core/let
    [v11139
     (:traffic-policy-id-marker
      m11138
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11139 :com.palletops.awaze.client-builder/undef)
     (. bean11137 setTrafficPolicyIdMarker (clojure.core/str v11139))))
   bean11137))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest}
list-traffic-policy-instances-by-policy-request
  [m11141]
  (clojure.core/let
   [bean11140
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest)]
   (clojure.core/let
    [v11142
     (:max-items m11141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11142 :com.palletops.awaze.client-builder/undef)
     (. bean11140 setMaxItems (clojure.core/str v11142))))
   (clojure.core/let
    [v11142
     (:hosted-zone-id-marker
      m11141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11142 :com.palletops.awaze.client-builder/undef)
     (. bean11140 setHostedZoneIdMarker (clojure.core/str v11142))))
   (clojure.core/let
    [v11142
     (:traffic-policy-instance-name-marker
      m11141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11142 :com.palletops.awaze.client-builder/undef)
     (.
      bean11140
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11142))))
   (clojure.core/let
    [v11142
     (:traffic-policy-instance-type-marker
      m11141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11142 :com.palletops.awaze.client-builder/undef)
     (.
      bean11140
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11142))))
   (clojure.core/let
    [v11142
     (:traffic-policy-version
      m11141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11142 :com.palletops.awaze.client-builder/undef)
     (. bean11140 setTrafficPolicyVersion (clojure.core/int v11142))))
   (clojure.core/let
    [v11142
     (:traffic-policy-id
      m11141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11142 :com.palletops.awaze.client-builder/undef)
     (. bean11140 setTrafficPolicyId (clojure.core/str v11142))))
   bean11140))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest}
list-traffic-policy-versions-request
  [m11144]
  (clojure.core/let
   [bean11143
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest)]
   (clojure.core/let
    [v11145
     (:max-items m11144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11145 :com.palletops.awaze.client-builder/undef)
     (. bean11143 setMaxItems (clojure.core/str v11145))))
   (clojure.core/let
    [v11145 (:id m11144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11145 :com.palletops.awaze.client-builder/undef)
     (. bean11143 setId (clojure.core/str v11145))))
   (clojure.core/let
    [v11145
     (:traffic-policy-version-marker
      m11144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11145 :com.palletops.awaze.client-builder/undef)
     (.
      bean11143
      setTrafficPolicyVersionMarker
      (clojure.core/str v11145))))
   bean11143))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest}
list-traffic-policy-instances-by-hosted-zone-request
  [m11147]
  (clojure.core/let
   [bean11146
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest)]
   (clojure.core/let
    [v11148
     (:hosted-zone-id
      m11147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11148 :com.palletops.awaze.client-builder/undef)
     (. bean11146 setHostedZoneId (clojure.core/str v11148))))
   (clojure.core/let
    [v11148
     (:max-items m11147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11148 :com.palletops.awaze.client-builder/undef)
     (. bean11146 setMaxItems (clojure.core/str v11148))))
   (clojure.core/let
    [v11148
     (:traffic-policy-instance-name-marker
      m11147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11148 :com.palletops.awaze.client-builder/undef)
     (.
      bean11146
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11148))))
   (clojure.core/let
    [v11148
     (:traffic-policy-instance-type-marker
      m11147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11148 :com.palletops.awaze.client-builder/undef)
     (.
      bean11146
      setTrafficPolicyInstanceTypeMarker
      (route53/rrtype v11148))))
   bean11146))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest}
delete-reusable-delegation-set-request
  [m11150]
  (clojure.core/let
   [bean11149
    (new
     com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest)]
   (clojure.core/let
    [v11151 (:id m11150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11151 :com.palletops.awaze.client-builder/undef)
     (. bean11149 setId (clojure.core/str v11151))))
   bean11149))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetReusableDelegationSetRequest}
get-reusable-delegation-set-request
  [m11153]
  (clojure.core/let
   [bean11152
    (new
     com.amazonaws.services.route53.model.GetReusableDelegationSetRequest)]
   (clojure.core/let
    [v11154 (:id m11153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11154 :com.palletops.awaze.client-builder/undef)
     (. bean11152 setId (clojure.core/str v11154))))
   bean11152))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11156]
  (clojure.core/let
   [bean11155
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/let
    [v11157 (:id m11156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11157 :com.palletops.awaze.client-builder/undef)
     (. bean11155 setId (clojure.core/str v11157))))
   bean11155))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest}
associate-vpcwith-hosted-zone-request
  [m11159]
  (clojure.core/let
   [bean11158
    (new
     com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest)]
   (clojure.core/let
    [v11160
     (:hosted-zone-id
      m11159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11160 :com.palletops.awaze.client-builder/undef)
     (. bean11158 setHostedZoneId (clojure.core/str v11160))))
   (clojure.core/let
    [v11160
     (:comment m11159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11160 :com.palletops.awaze.client-builder/undef)
     (. bean11158 setComment (clojure.core/str v11160))))
   (clojure.core/let
    [v11160 (:vpc m11159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11160 :com.palletops.awaze.client-builder/undef)
     (. bean11158 setVPC (route53/vpc v11160))))
   bean11158))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11162]
  (clojure.core/let
   [bean11161
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/let
    [v11163
     (:max-items m11162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11163 :com.palletops.awaze.client-builder/undef)
     (. bean11161 setMaxItems (clojure.core/str v11163))))
   (clojure.core/let
    [v11163
     (:marker m11162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11163 :com.palletops.awaze.client-builder/undef)
     (. bean11161 setMarker (clojure.core/str v11163))))
   (clojure.core/let
    [v11163
     (:delegation-set-id
      m11162
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11163 :com.palletops.awaze.client-builder/undef)
     (. bean11161 setDelegationSetId (clojure.core/str v11163))))
   bean11161))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest}
list-reusable-delegation-sets-request
  [m11165]
  (clojure.core/let
   [bean11164
    (new
     com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest)]
   (clojure.core/let
    [v11166
     (:max-items m11165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11166 :com.palletops.awaze.client-builder/undef)
     (. bean11164 setMaxItems (clojure.core/str v11166))))
   (clojure.core/let
    [v11166
     (:marker m11165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11166 :com.palletops.awaze.client-builder/undef)
     (. bean11164 setMarker (clojure.core/str v11166))))
   bean11164))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest}
delete-traffic-policy-instance-request
  [m11168]
  (clojure.core/let
   [bean11167
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11169 (:id m11168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11169 :com.palletops.awaze.client-builder/undef)
     (. bean11167 setId (clojure.core/str v11169))))
   bean11167))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11171]
  (clojure.core/let
   [bean11170
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/let
    [v11172
     (:health-check-id
      m11171
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11172 :com.palletops.awaze.client-builder/undef)
     (. bean11170 setHealthCheckId (clojure.core/str v11172))))
   bean11170))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourcesRequest}
list-tags-for-resources-request
  [m11174]
  (clojure.core/let
   [bean11173
    (new
     com.amazonaws.services.route53.model.ListTagsForResourcesRequest)]
   (clojure.core/let
    [v11175
     (:resource-ids m11174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11175 :com.palletops.awaze.client-builder/undef)
     (.
      bean11173
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11275] (clojure.core/str arg11275))
 v11175))))
   (clojure.core/let
    [v11175
     (:resource-type m11174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11175 :com.palletops.awaze.client-builder/undef)
     (. bean11173 setResourceType (clojure.core/str v11175))))
   bean11173))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetCheckerIpRangesRequest}
get-checker-ip-ranges-request
  [m11177]
  (clojure.core/let
   [bean11176
    (new
     com.amazonaws.services.route53.model.GetCheckerIpRangesRequest)]
   bean11176))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11180]
  (clojure.core/let
   [bean11179
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/let
    [v11181 (:name m11180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11181 :com.palletops.awaze.client-builder/undef)
     (. bean11179 setName (clojure.core/str v11181))))
   (clojure.core/let
    [v11181 (:vpc m11180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11181 :com.palletops.awaze.client-builder/undef)
     (. bean11179 setVPC (route53/vpc v11181))))
   (clojure.core/let
    [v11181
     (:caller-reference
      m11180
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11181 :com.palletops.awaze.client-builder/undef)
     (. bean11179 setCallerReference (clojure.core/str v11181))))
   (clojure.core/let
    [v11181
     (:hosted-zone-config
      m11180
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11181 :com.palletops.awaze.client-builder/undef)
     (.
      bean11179
      setHostedZoneConfig
      (route53/hosted-zone-config v11181))))
   (clojure.core/let
    [v11181
     (:delegation-set-id
      m11180
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11181 :com.palletops.awaze.client-builder/undef)
     (. bean11179 setDelegationSetId (clojure.core/str v11181))))
   bean11179))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest}
list-change-batches-by-hosted-zone-request
  [m11183]
  (clojure.core/let
   [bean11182
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest)]
   (clojure.core/let
    [v11184
     (:hosted-zone-id
      m11183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11184 :com.palletops.awaze.client-builder/undef)
     (. bean11182 setHostedZoneId (clojure.core/str v11184))))
   (clojure.core/let
    [v11184
     (:max-items m11183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11184 :com.palletops.awaze.client-builder/undef)
     (. bean11182 setMaxItems (clojure.core/str v11184))))
   (clojure.core/let
    [v11184
     (:marker m11183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11184 :com.palletops.awaze.client-builder/undef)
     (. bean11182 setMarker (clojure.core/str v11184))))
   (clojure.core/let
    [v11184
     (:start-date m11183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11184 :com.palletops.awaze.client-builder/undef)
     (. bean11182 setStartDate (clojure.core/str v11184))))
   (clojure.core/let
    [v11184
     (:end-date m11183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11184 :com.palletops.awaze.client-builder/undef)
     (. bean11182 setEndDate (clojure.core/str v11184))))
   bean11182))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHealthCheckRequest}
update-health-check-request
  [m11186]
  (clojure.core/let
   [bean11185
    (new
     com.amazonaws.services.route53.model.UpdateHealthCheckRequest)]
   (clojure.core/let
    [v11187
     (:inverted m11186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setInverted (clojure.core/boolean v11187))))
   (clojure.core/let
    [v11187
     (:resource-path m11186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setResourcePath (clojure.core/str v11187))))
   (clojure.core/let
    [v11187
     (:search-string m11186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setSearchString (clojure.core/str v11187))))
   (clojure.core/let
    [v11187
     (:health-check-id
      m11186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setHealthCheckId (clojure.core/str v11187))))
   (clojure.core/let
    [v11187
     (:child-health-checks
      m11186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (.
      bean11185
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11276] (clojure.core/str arg11276))
 v11187))))
   (clojure.core/let
    [v11187 (:port m11186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setPort (clojure.core/int v11187))))
   (clojure.core/let
    [v11187
     (:health-check-version
      m11186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setHealthCheckVersion (clojure.core/long v11187))))
   (clojure.core/let
    [v11187
     (:health-threshold
      m11186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setHealthThreshold (clojure.core/int v11187))))
   (clojure.core/let
    [v11187
     (:ipaddress m11186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setIPAddress (clojure.core/str v11187))))
   (clojure.core/let
    [v11187
     (:fully-qualified-domain-name
      m11186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (.
      bean11185
      setFullyQualifiedDomainName
      (clojure.core/str v11187))))
   (clojure.core/let
    [v11187
     (:enable-sni m11186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setEnableSNI (clojure.core/boolean v11187))))
   (clojure.core/let
    [v11187
     (:failure-threshold
      m11186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11187 :com.palletops.awaze.client-builder/undef)
     (. bean11185 setFailureThreshold (clojure.core/int v11187))))
   bean11185))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest}
get-health-check-last-failure-reason-request
  [m11189]
  (clojure.core/let
   [bean11188
    (new
     com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest)]
   (clojure.core/let
    [v11190
     (:health-check-id
      m11189
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11190 :com.palletops.awaze.client-builder/undef)
     (. bean11188 setHealthCheckId (clojure.core/str v11190))))
   bean11188))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11192]
  (clojure.core/let
   [bean11191
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/let
    [v11193
     (:caller-reference
      m11192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11193 :com.palletops.awaze.client-builder/undef)
     (. bean11191 setCallerReference (clojure.core/str v11193))))
   (clojure.core/let
    [v11193
     (:health-check-config
      m11192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11193 :com.palletops.awaze.client-builder/undef)
     (.
      bean11191
      setHealthCheckConfig
      (route53/health-check-config v11193))))
   bean11191))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest}
create-traffic-policy-instance-request
  [m11195]
  (clojure.core/let
   [bean11194
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11196 (:name m11195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11196 :com.palletops.awaze.client-builder/undef)
     (. bean11194 setName (clojure.core/str v11196))))
   (clojure.core/let
    [v11196
     (:hosted-zone-id
      m11195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11196 :com.palletops.awaze.client-builder/undef)
     (. bean11194 setHostedZoneId (clojure.core/str v11196))))
   (clojure.core/let
    [v11196 (:ttl m11195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11196 :com.palletops.awaze.client-builder/undef)
     (. bean11194 setTTL (clojure.core/long v11196))))
   (clojure.core/let
    [v11196
     (:traffic-policy-version
      m11195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11196 :com.palletops.awaze.client-builder/undef)
     (. bean11194 setTrafficPolicyVersion (clojure.core/int v11196))))
   (clojure.core/let
    [v11196
     (:traffic-policy-id
      m11195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11196 :com.palletops.awaze.client-builder/undef)
     (. bean11194 setTrafficPolicyId (clojure.core/str v11196))))
   bean11194))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeDetailsRequest}
get-change-details-request
  [m11198]
  (clojure.core/let
   [bean11197
    (new com.amazonaws.services.route53.model.GetChangeDetailsRequest)]
   (clojure.core/let
    [v11199 (:id m11198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11199 :com.palletops.awaze.client-builder/undef)
     (. bean11197 setId (clojure.core/str v11199))))
   bean11197))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyRequest}
create-traffic-policy-request
  [m11201]
  (clojure.core/let
   [bean11200
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyRequest)]
   (clojure.core/let
    [v11202 (:name m11201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11202 :com.palletops.awaze.client-builder/undef)
     (. bean11200 setName (clojure.core/str v11202))))
   (clojure.core/let
    [v11202
     (:comment m11201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11202 :com.palletops.awaze.client-builder/undef)
     (. bean11200 setComment (clojure.core/str v11202))))
   (clojure.core/let
    [v11202
     (:document m11201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11202 :com.palletops.awaze.client-builder/undef)
     (. bean11200 setDocument (clojure.core/str v11202))))
   bean11200))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeTagsForResourceRequest}
change-tags-for-resource-request
  [m11204]
  (clojure.core/let
   [bean11203
    (new
     com.amazonaws.services.route53.model.ChangeTagsForResourceRequest)]
   (clojure.core/let
    [v11205
     (:resource-type m11204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11205 :com.palletops.awaze.client-builder/undef)
     (. bean11203 setResourceType (clojure.core/str v11205))))
   (clojure.core/let
    [v11205
     (:resource-id m11204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11205 :com.palletops.awaze.client-builder/undef)
     (. bean11203 setResourceId (clojure.core/str v11205))))
   (clojure.core/let
    [v11205
     (:add-tags m11204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11205 :com.palletops.awaze.client-builder/undef)
     (.
      bean11203
      setAddTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11277] (route53/tag arg11277))
 v11205))))
   (clojure.core/let
    [v11205
     (:remove-tag-keys
      m11204
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11205 :com.palletops.awaze.client-builder/undef)
     (.
      bean11203
      setRemoveTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11278] (clojure.core/str arg11278))
 v11205))))
   bean11203))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest}
get-traffic-policy-instance-count-request
  [m11207]
  (clojure.core/let
   [bean11206
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest)]
   bean11206))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckStatusRequest}
get-health-check-status-request
  [m11210]
  (clojure.core/let
   [bean11209
    (new
     com.amazonaws.services.route53.model.GetHealthCheckStatusRequest)]
   (clojure.core/let
    [v11211
     (:health-check-id
      m11210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11211 :com.palletops.awaze.client-builder/undef)
     (. bean11209 setHealthCheckId (clojure.core/str v11211))))
   bean11209))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11213]
  (clojure.core/let
   [bean11212
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/let
    [v11214 (:id m11213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11214 :com.palletops.awaze.client-builder/undef)
     (. bean11212 setId (clojure.core/str v11214))))
   bean11212))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListGeoLocationsRequest}
list-geo-locations-request
  [m11216]
  (clojure.core/let
   [bean11215
    (new com.amazonaws.services.route53.model.ListGeoLocationsRequest)]
   (clojure.core/let
    [v11217
     (:max-items m11216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11217 :com.palletops.awaze.client-builder/undef)
     (. bean11215 setMaxItems (clojure.core/str v11217))))
   (clojure.core/let
    [v11217
     (:start-continent-code
      m11216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11217 :com.palletops.awaze.client-builder/undef)
     (. bean11215 setStartContinentCode (clojure.core/str v11217))))
   (clojure.core/let
    [v11217
     (:start-country-code
      m11216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11217 :com.palletops.awaze.client-builder/undef)
     (. bean11215 setStartCountryCode (clojure.core/str v11217))))
   (clojure.core/let
    [v11217
     (:start-subdivision-code
      m11216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11217 :com.palletops.awaze.client-builder/undef)
     (. bean11215 setStartSubdivisionCode (clojure.core/str v11217))))
   bean11215))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneCountRequest}
get-hosted-zone-count-request
  [m11219]
  (clojure.core/let
   [bean11218
    (new
     com.amazonaws.services.route53.model.GetHostedZoneCountRequest)]
   bean11218))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest}
update-hosted-zone-comment-request
  [m11222]
  (clojure.core/let
   [bean11221
    (new
     com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest)]
   (clojure.core/let
    [v11223
     (:comment m11222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11223 :com.palletops.awaze.client-builder/undef)
     (. bean11221 setComment (clojure.core/str v11223))))
   (clojure.core/let
    [v11223 (:id m11222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11223 :com.palletops.awaze.client-builder/undef)
     (. bean11221 setId (clojure.core/str v11223))))
   bean11221))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckCountRequest}
get-health-check-count-request
  [m11225]
  (clojure.core/let
   [bean11224
    (new
     com.amazonaws.services.route53.model.GetHealthCheckCountRequest)]
   bean11224))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11228]
  (clojure.core/let
   [bean11227
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/let
    [v11229 (:id m11228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11229 :com.palletops.awaze.client-builder/undef)
     (. bean11227 setId (clojure.core/str v11229))))
   bean11227))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest}
update-traffic-policy-comment-request
  [m11231]
  (clojure.core/let
   [bean11230
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest)]
   (clojure.core/let
    [v11232
     (:comment m11231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11232 :com.palletops.awaze.client-builder/undef)
     (. bean11230 setComment (clojure.core/str v11232))))
   (clojure.core/let
    [v11232
     (:version m11231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11232 :com.palletops.awaze.client-builder/undef)
     (. bean11230 setVersion (clojure.core/int v11232))))
   (clojure.core/let
    [v11232 (:id m11231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11232 :com.palletops.awaze.client-builder/undef)
     (. bean11230 setId (clojure.core/str v11232))))
   bean11230))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest}
get-traffic-policy-instance-request
  [m11234]
  (clojure.core/let
   [bean11233
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11235 (:id m11234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11235 :com.palletops.awaze.client-builder/undef)
     (. bean11233 setId (clojure.core/str v11235))))
   bean11233))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesByNameRequest}
list-hosted-zones-by-name-request
  [m11237]
  (clojure.core/let
   [bean11236
    (new
     com.amazonaws.services.route53.model.ListHostedZonesByNameRequest)]
   (clojure.core/let
    [v11238
     (:hosted-zone-id
      m11237
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11238 :com.palletops.awaze.client-builder/undef)
     (. bean11236 setHostedZoneId (clojure.core/str v11238))))
   (clojure.core/let
    [v11238
     (:max-items m11237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11238 :com.palletops.awaze.client-builder/undef)
     (. bean11236 setMaxItems (clojure.core/str v11238))))
   (clojure.core/let
    [v11238
     (:dnsname m11237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11238 :com.palletops.awaze.client-builder/undef)
     (. bean11236 setDNSName (clojure.core/str v11238))))
   bean11236))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetGeoLocationRequest}
get-geo-location-request
  [m11240]
  (clojure.core/let
   [bean11239
    (new com.amazonaws.services.route53.model.GetGeoLocationRequest)]
   (clojure.core/let
    [v11241
     (:continent-code
      m11240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11241 :com.palletops.awaze.client-builder/undef)
     (. bean11239 setContinentCode (clojure.core/str v11241))))
   (clojure.core/let
    [v11241
     (:country-code m11240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11241 :com.palletops.awaze.client-builder/undef)
     (. bean11239 setCountryCode (clojure.core/str v11241))))
   (clojure.core/let
    [v11241
     (:subdivision-code
      m11240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11241 :com.palletops.awaze.client-builder/undef)
     (. bean11239 setSubdivisionCode (clojure.core/str v11241))))
   bean11239))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m11243]
  (clojure.core/let
   [bean11242
    (new
     com.amazonaws.services.route53.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v11244
     (:resource-type m11243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11244 :com.palletops.awaze.client-builder/undef)
     (. bean11242 setResourceType (route53/tag-resource-type v11244))))
   (clojure.core/let
    [v11244
     (:resource-id m11243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11244 :com.palletops.awaze.client-builder/undef)
     (. bean11242 setResourceId (clojure.core/str v11244))))
   bean11242))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest}
create-reusable-delegation-set-request
  [m11246]
  (clojure.core/let
   [bean11245
    (new
     com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest)]
   (clojure.core/let
    [v11247
     (:hosted-zone-id
      m11246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11247 :com.palletops.awaze.client-builder/undef)
     (. bean11245 setHostedZoneId (clojure.core/str v11247))))
   (clojure.core/let
    [v11247
     (:caller-reference
      m11246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11247 :com.palletops.awaze.client-builder/undef)
     (. bean11245 setCallerReference (clojure.core/str v11247))))
   bean11245))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11249]
  (clojure.core/let
   [bean11248
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/let
    [v11250
     (:max-items m11249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11250 :com.palletops.awaze.client-builder/undef)
     (. bean11248 setMaxItems (clojure.core/str v11250))))
   (clojure.core/let
    [v11250
     (:marker m11249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11250 :com.palletops.awaze.client-builder/undef)
     (. bean11248 setMarker (clojure.core/str v11250))))
   bean11248))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest}
update-traffic-policy-instance-request
  [m11252]
  (clojure.core/let
   [bean11251
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11253 (:id m11252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11253 :com.palletops.awaze.client-builder/undef)
     (. bean11251 setId (clojure.core/str v11253))))
   (clojure.core/let
    [v11253 (:ttl m11252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11253 :com.palletops.awaze.client-builder/undef)
     (. bean11251 setTTL (clojure.core/long v11253))))
   (clojure.core/let
    [v11253
     (:traffic-policy-version
      m11252
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11253 :com.palletops.awaze.client-builder/undef)
     (. bean11251 setTrafficPolicyVersion (clojure.core/int v11253))))
   (clojure.core/let
    [v11253
     (:traffic-policy-id
      m11252
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11253 :com.palletops.awaze.client-builder/undef)
     (. bean11251 setTrafficPolicyId (clojure.core/str v11253))))
   bean11251))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11255]
  (clojure.core/let
   [bean11254
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/let
    [v11256
     (:health-check-id
      m11255
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11256 :com.palletops.awaze.client-builder/undef)
     (. bean11254 setHealthCheckId (clojure.core/str v11256))))
   bean11254))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyRequest}
get-traffic-policy-request
  [m11258]
  (clojure.core/let
   [bean11257
    (new com.amazonaws.services.route53.model.GetTrafficPolicyRequest)]
   (clojure.core/let
    [v11259
     (:version m11258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11259 :com.palletops.awaze.client-builder/undef)
     (. bean11257 setVersion (clojure.core/int v11259))))
   (clojure.core/let
    [v11259 (:id m11258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11259 :com.palletops.awaze.client-builder/undef)
     (. bean11257 setId (clojure.core/str v11259))))
   bean11257))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest}
list-change-batches-by-rrset-request
  [m11261]
  (clojure.core/let
   [bean11260
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest)]
   (clojure.core/let
    [v11262 (:name m11261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setName (clojure.core/str v11262))))
   (clojure.core/let
    [v11262
     (:hosted-zone-id
      m11261
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setHostedZoneId (clojure.core/str v11262))))
   (clojure.core/let
    [v11262
     (:max-items m11261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setMaxItems (clojure.core/str v11262))))
   (clojure.core/let
    [v11262 (:type m11261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setType (route53/rrtype v11262))))
   (clojure.core/let
    [v11262
     (:marker m11261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setMarker (clojure.core/str v11262))))
   (clojure.core/let
    [v11262
     (:start-date m11261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setStartDate (clojure.core/str v11262))))
   (clojure.core/let
    [v11262
     (:end-date m11261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setEndDate (clojure.core/str v11262))))
   (clojure.core/let
    [v11262
     (:set-identifier
      m11261
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11262 :com.palletops.awaze.client-builder/undef)
     (. bean11260 setSetIdentifier (clojure.core/str v11262))))
   bean11260))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11264]
  (clojure.core/let
   [bean11263
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/let
    [v11265
     (:hosted-zone-id
      m11264
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11265 :com.palletops.awaze.client-builder/undef)
     (. bean11263 setHostedZoneId (clojure.core/str v11265))))
   (clojure.core/let
    [v11265
     (:max-items m11264 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11265 :com.palletops.awaze.client-builder/undef)
     (. bean11263 setMaxItems (clojure.core/str v11265))))
   (clojure.core/let
    [v11265
     (:start-record-name
      m11264
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11265 :com.palletops.awaze.client-builder/undef)
     (. bean11263 setStartRecordName (clojure.core/str v11265))))
   (clojure.core/let
    [v11265
     (:start-record-type
      m11264
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11265 :com.palletops.awaze.client-builder/undef)
     (. bean11263 setStartRecordType (route53/rrtype v11265))))
   (clojure.core/let
    [v11265
     (:start-record-identifier
      m11264
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11265 :com.palletops.awaze.client-builder/undef)
     (. bean11263 setStartRecordIdentifier (clojure.core/str v11265))))
   bean11263))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest}
disassociate-vpcfrom-hosted-zone-request
  [m11267]
  (clojure.core/let
   [bean11266
    (new
     com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest)]
   (clojure.core/let
    [v11268
     (:hosted-zone-id
      m11267
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11268 :com.palletops.awaze.client-builder/undef)
     (. bean11266 setHostedZoneId (clojure.core/str v11268))))
   (clojure.core/let
    [v11268
     (:comment m11267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11268 :com.palletops.awaze.client-builder/undef)
     (. bean11266 setComment (clojure.core/str v11268))))
   (clojure.core/let
    [v11268 (:vpc m11267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11268 :com.palletops.awaze.client-builder/undef)
     (. bean11266 setVPC (route53/vpc v11268))))
   bean11266))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest}
list-traffic-policy-instances-request
  [m11270]
  (clojure.core/let
   [bean11269
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest)]
   (clojure.core/let
    [v11271
     (:max-items m11270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11271 :com.palletops.awaze.client-builder/undef)
     (. bean11269 setMaxItems (clojure.core/str v11271))))
   (clojure.core/let
    [v11271
     (:hosted-zone-id-marker
      m11270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11271 :com.palletops.awaze.client-builder/undef)
     (. bean11269 setHostedZoneIdMarker (clojure.core/str v11271))))
   (clojure.core/let
    [v11271
     (:traffic-policy-instance-name-marker
      m11270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11271 :com.palletops.awaze.client-builder/undef)
     (.
      bean11269
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11271))))
   (clojure.core/let
    [v11271
     (:traffic-policy-instance-type-marker
      m11270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11271 :com.palletops.awaze.client-builder/undef)
     (.
      bean11269
      setTrafficPolicyInstanceTypeMarker
      (route53/rrtype v11271))))
   bean11269))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-version
   [m11279]
   (clojure.core/let
    [credentials11280 (:credentials m11279) args11281 (:args m11279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11282
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11282
       createTrafficPolicyVersion
       (route53/create-traffic-policy-version-request
        (clojure.core/nth args11281 0)))))))
  (clojure.core/defn
   create-traffic-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicyVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-version,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicyVersion"}
   [credentials11284 & args11285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11286
     (com.palletops.awaze.common/aws-client :route53 credentials11284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11286
      createTrafficPolicyVersion
      (route53/create-traffic-policy-version-request
       (clojure.core/nth args11285 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy
   [m11287]
   (clojure.core/let
    [credentials11288 (:credentials m11287) args11289 (:args m11287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11290
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11288)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11290
       deleteTrafficPolicy
       (route53/delete-traffic-policy-request
        (clojure.core/nth args11289 0)))))))
  (clojure.core/defn
   delete-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicy"}
   [credentials11292 & args11293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11294
     (com.palletops.awaze.common/aws-client :route53 credentials11292)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11294
      deleteTrafficPolicy
      (route53/delete-traffic-policy-request
       (clojure.core/nth args11293 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11295]
   (clojure.core/let
    [credentials11296 (:credentials m11295) args11297 (:args m11295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11298
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11298
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11297 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :change-resource-record-sets,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11300 & args11301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11302
     (com.palletops.awaze.common/aws-client :route53 credentials11300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11302
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11301 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policies
   [m11303]
   (clojure.core/let
    [credentials11304 (:credentials m11303) args11305 (:args m11303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11306
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11304)]
     (clojure.core/case
      (clojure.core/count args11305)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11306
        listTrafficPolicies
        (route53/list-traffic-policies-request
         (clojure.core/nth args11305 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11306
        listTrafficPolicies))))))
  (clojure.core/defn
   list-traffic-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTrafficPolicies, listTrafficPolicies"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-traffic-policies,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-traffic-policies,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTrafficPolicies, listTrafficPolicies"}
   [credentials11308 & args11309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11310
     (com.palletops.awaze.common/aws-client :route53 credentials11308)]
    (clojure.core/case
     (clojure.core/count args11309)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11310
       listTrafficPolicies
       (route53/list-traffic-policies-request
        (clojure.core/nth args11309 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11310
       listTrafficPolicies))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-policy
   [m11311]
   (clojure.core/let
    [credentials11312 (:credentials m11311) args11313 (:args m11311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11314
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11312)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11314
       listTrafficPolicyInstancesByPolicy
       (route53/list-traffic-policy-instances-by-policy-request
        (clojure.core/nth args11313 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-policy,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstancesByPolicy"}
   [credentials11316 & args11317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11318
     (com.palletops.awaze.common/aws-client :route53 credentials11316)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11318
      listTrafficPolicyInstancesByPolicy
      (route53/list-traffic-policy-instances-by-policy-request
       (clojure.core/nth args11317 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-versions
   [m11319]
   (clojure.core/let
    [credentials11320 (:credentials m11319) args11321 (:args m11319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11322
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11320)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11322
       listTrafficPolicyVersions
       (route53/list-traffic-policy-versions-request
        (clojure.core/nth args11321 0)))))))
  (clojure.core/defn
   list-traffic-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyVersions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-versions,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyVersions"}
   [credentials11324 & args11325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11326
     (com.palletops.awaze.common/aws-client :route53 credentials11324)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11326
      listTrafficPolicyVersions
      (route53/list-traffic-policy-versions-request
       (clojure.core/nth args11325 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-hosted-zone
   [m11327]
   (clojure.core/let
    [credentials11328 (:credentials m11327) args11329 (:args m11327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11330
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11328)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11330
       listTrafficPolicyInstancesByHostedZone
       (route53/list-traffic-policy-instances-by-hosted-zone-request
        (clojure.core/nth args11329 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listTrafficPolicyInstancesByHostedZone"}
   [credentials11332 & args11333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11334
     (com.palletops.awaze.common/aws-client :route53 credentials11332)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11334
      listTrafficPolicyInstancesByHostedZone
      (route53/list-traffic-policy-instances-by-hosted-zone-request
       (clojure.core/nth args11333 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-reusable-delegation-set
   [m11335]
   (clojure.core/let
    [credentials11336 (:credentials m11335) args11337 (:args m11335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11338
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11336)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11338
       deleteReusableDelegationSet
       (route53/delete-reusable-delegation-set-request
        (clojure.core/nth args11337 0)))))))
  (clojure.core/defn
   delete-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReusableDelegationSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-reusable-delegation-set,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReusableDelegationSet"}
   [credentials11340 & args11341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11342
     (com.palletops.awaze.common/aws-client :route53 credentials11340)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11342
      deleteReusableDelegationSet
      (route53/delete-reusable-delegation-set-request
       (clojure.core/nth args11341 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-reusable-delegation-set
   [m11343]
   (clojure.core/let
    [credentials11344 (:credentials m11343) args11345 (:args m11343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11346
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11344)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11346
       getReusableDelegationSet
       (route53/get-reusable-delegation-set-request
        (clojure.core/nth args11345 0)))))))
  (clojure.core/defn
   get-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getReusableDelegationSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-reusable-delegation-set,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getReusableDelegationSet"}
   [credentials11348 & args11349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11350
     (com.palletops.awaze.common/aws-client :route53 credentials11348)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11350
      getReusableDelegationSet
      (route53/get-reusable-delegation-set-request
       (clojure.core/nth args11349 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11351]
   (clojure.core/let
    [credentials11352 (:credentials m11351) args11353 (:args m11351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11354
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11352)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11354
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11353 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11356 & args11357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11358
     (com.palletops.awaze.common/aws-client :route53 credentials11356)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11358
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11357 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :associate-vpcwith-hosted-zone
   [m11359]
   (clojure.core/let
    [credentials11360 (:credentials m11359) args11361 (:args m11359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11362
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11360)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11362
       associateVPCWithHostedZone
       (route53/associate-vpcwith-hosted-zone-request
        (clojure.core/nth args11361 0)))))))
  (clojure.core/defn
   associate-vpcwith-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for associateVPCWithHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :associate-vpcwith-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   associate-vpcwith-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call associateVPCWithHostedZone"}
   [credentials11364 & args11365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11366
     (com.palletops.awaze.common/aws-client :route53 credentials11364)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11366
      associateVPCWithHostedZone
      (route53/associate-vpcwith-hosted-zone-request
       (clojure.core/nth args11365 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11367]
   (clojure.core/let
    [credentials11368 (:credentials m11367) args11369 (:args m11367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11370
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11368)]
     (clojure.core/case
      (clojure.core/count args11369)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11370
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11369 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11370
        listHostedZones))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-hosted-zones,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-hosted-zones,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11372 & args11373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11374
     (com.palletops.awaze.common/aws-client :route53 credentials11372)]
    (clojure.core/case
     (clojure.core/count args11373)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11374
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11373 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11374
       listHostedZones))))))
 (do
  (clojure.core/defmethod
   route53
   :list-reusable-delegation-sets
   [m11375]
   (clojure.core/let
    [credentials11376 (:credentials m11375) args11377 (:args m11375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11378
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11376)]
     (clojure.core/case
      (clojure.core/count args11377)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11378
        listReusableDelegationSets
        (route53/list-reusable-delegation-sets-request
         (clojure.core/nth args11377 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11378
        listReusableDelegationSets))))))
  (clojure.core/defn
   list-reusable-delegation-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listReusableDelegationSets, listReusableDelegationSets"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-reusable-delegation-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listReusableDelegationSets, listReusableDelegationSets"}
   [credentials11380 & args11381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11382
     (com.palletops.awaze.common/aws-client :route53 credentials11380)]
    (clojure.core/case
     (clojure.core/count args11381)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11382
       listReusableDelegationSets
       (route53/list-reusable-delegation-sets-request
        (clojure.core/nth args11381 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11382
       listReusableDelegationSets))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy-instance
   [m11383]
   (clojure.core/let
    [credentials11384 (:credentials m11383) args11385 (:args m11383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11386
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11384)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11386
       deleteTrafficPolicyInstance
       (route53/delete-traffic-policy-instance-request
        (clojure.core/nth args11385 0)))))))
  (clojure.core/defn
   delete-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicyInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy-instance,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicyInstance"}
   [credentials11388 & args11389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11390
     (com.palletops.awaze.common/aws-client :route53 credentials11388)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11390
      deleteTrafficPolicyInstance
      (route53/delete-traffic-policy-instance-request
       (clojure.core/nth args11389 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11391]
   (clojure.core/let
    [credentials11392 (:credentials m11391) args11393 (:args m11391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11394
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11394
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11393 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-health-check,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheck"}
   [credentials11396 & args11397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11398
     (com.palletops.awaze.common/aws-client :route53 credentials11396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11398
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11397 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resources
   [m11399]
   (clojure.core/let
    [credentials11400 (:credentials m11399) args11401 (:args m11399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11402
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11402
       listTagsForResources
       (route53/list-tags-for-resources-request
        (clojure.core/nth args11401 0)))))))
  (clojure.core/defn
   list-tags-for-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResources"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-tags-for-resources,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResources"}
   [credentials11404 & args11405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11406
     (com.palletops.awaze.common/aws-client :route53 credentials11404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11406
      listTagsForResources
      (route53/list-tags-for-resources-request
       (clojure.core/nth args11405 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-checker-ip-ranges
   [m11407]
   (clojure.core/let
    [credentials11408 (:credentials m11407) args11409 (:args m11407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11410
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11408)]
     (clojure.core/case
      (clojure.core/count args11409)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11410
        getCheckerIpRanges
        (route53/get-checker-ip-ranges-request
         (clojure.core/nth args11409 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11410
        getCheckerIpRanges))))))
  (clojure.core/defn
   get-checker-ip-ranges-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getCheckerIpRanges, getCheckerIpRanges"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-checker-ip-ranges
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getCheckerIpRanges, getCheckerIpRanges"}
   [credentials11412 & args11413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11414
     (com.palletops.awaze.common/aws-client :route53 credentials11412)]
    (clojure.core/case
     (clojure.core/count args11413)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11414
       getCheckerIpRanges
       (route53/get-checker-ip-ranges-request
        (clojure.core/nth args11413 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11414
       getCheckerIpRanges))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11415]
   (clojure.core/let
    [credentials11416 (:credentials m11415) args11417 (:args m11415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11418
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11418
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11417 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHostedZone"}
   [credentials11420 & args11421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11422
     (com.palletops.awaze.common/aws-client :route53 credentials11420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11422
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11421 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-hosted-zone
   [m11423]
   (clojure.core/let
    [credentials11424 (:credentials m11423) args11425 (:args m11423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11426
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11424)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11426
       listChangeBatchesByHostedZone
       (route53/list-change-batches-by-hosted-zone-request
        (clojure.core/nth args11425 0)))))))
  (clojure.core/defn
   list-change-batches-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByHostedZone"}
   [credentials11428 & args11429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11430
     (com.palletops.awaze.common/aws-client :route53 credentials11428)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11430
      listChangeBatchesByHostedZone
      (route53/list-change-batches-by-hosted-zone-request
       (clojure.core/nth args11429 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-health-check
   [m11431]
   (clojure.core/let
    [credentials11432 (:credentials m11431) args11433 (:args m11431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11434
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11434
       updateHealthCheck
       (route53/update-health-check-request
        (clojure.core/nth args11433 0)))))))
  (clojure.core/defn
   update-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Generate map for updateHealthCheck"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-health-check,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   update-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Call updateHealthCheck"}
   [credentials11436 & args11437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11438
     (com.palletops.awaze.common/aws-client :route53 credentials11436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11438
      updateHealthCheck
      (route53/update-health-check-request
       (clojure.core/nth args11437 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-last-failure-reason
   [m11439]
   (clojure.core/let
    [credentials11440 (:credentials m11439) args11441 (:args m11439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11442
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11442
       getHealthCheckLastFailureReason
       (route53/get-health-check-last-failure-reason-request
        (clojure.core/nth args11441 0)))))))
  (clojure.core/defn
   get-health-check-last-failure-reason-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckLastFailureReason"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-health-check-last-failure-reason,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-last-failure-reason
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckLastFailureReason"}
   [credentials11444 & args11445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11446
     (com.palletops.awaze.common/aws-client :route53 credentials11444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11446
      getHealthCheckLastFailureReason
      (route53/get-health-check-last-failure-reason-request
       (clojure.core/nth args11445 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11447]
   (clojure.core/let
    [credentials11448 (:credentials m11447) args11449 (:args m11447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11450
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11448)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11450
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11449 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-health-check,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Call createHealthCheck"}
   [credentials11452 & args11453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11454
     (com.palletops.awaze.common/aws-client :route53 credentials11452)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11454
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11453 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-instance
   [m11455]
   (clojure.core/let
    [credentials11456 (:credentials m11455) args11457 (:args m11455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11458
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11456)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11458
       createTrafficPolicyInstance
       (route53/create-traffic-policy-instance-request
        (clojure.core/nth args11457 0)))))))
  (clojure.core/defn
   create-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createTrafficPolicyInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-instance,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createTrafficPolicyInstance"}
   [credentials11460 & args11461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11462
     (com.palletops.awaze.common/aws-client :route53 credentials11460)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11462
      createTrafficPolicyInstance
      (route53/create-traffic-policy-instance-request
       (clojure.core/nth args11461 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change-details
   [m11463]
   (clojure.core/let
    [credentials11464 (:credentials m11463) args11465 (:args m11463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11466
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11464)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11466
       getChangeDetails
       (route53/get-change-details-request
        (clojure.core/nth args11465 0)))))))
  (clojure.core/defn
   get-change-details-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChangeDetails"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-change-details,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change-details
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChangeDetails"}
   [credentials11468 & args11469]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11470
     (com.palletops.awaze.common/aws-client :route53 credentials11468)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11470
      getChangeDetails
      (route53/get-change-details-request
       (clojure.core/nth args11469 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy
   [m11471]
   (clojure.core/let
    [credentials11472 (:credentials m11471) args11473 (:args m11471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11474
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11474
       createTrafficPolicy
       (route53/create-traffic-policy-request
        (clojure.core/nth args11473 0)))))))
  (clojure.core/defn
   create-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-traffic-policy,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicy"}
   [credentials11476 & args11477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11478
     (com.palletops.awaze.common/aws-client :route53 credentials11476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11478
      createTrafficPolicy
      (route53/create-traffic-policy-request
       (clojure.core/nth args11477 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-tags-for-resource
   [m11479]
   (clojure.core/let
    [credentials11480 (:credentials m11479) args11481 (:args m11479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11482
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11480)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11482
       changeTagsForResource
       (route53/change-tags-for-resource-request
        (clojure.core/nth args11481 0)))))))
  (clojure.core/defn
   change-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for changeTagsForResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :change-tags-for-resource,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   change-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call changeTagsForResource"}
   [credentials11484 & args11485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11486
     (com.palletops.awaze.common/aws-client :route53 credentials11484)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11486
      changeTagsForResource
      (route53/change-tags-for-resource-request
       (clojure.core/nth args11485 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance-count
   [m11487]
   (clojure.core/let
    [credentials11488 (:credentials m11487) args11489 (:args m11487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11490
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11488)]
     (clojure.core/case
      (clojure.core/count args11489)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11490
        getTrafficPolicyInstanceCount
        (route53/get-traffic-policy-instance-count-request
         (clojure.core/nth args11489 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11490
        getTrafficPolicyInstanceCount))))))
  (clojure.core/defn
   get-traffic-policy-instance-count-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance-count
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   [credentials11492 & args11493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11494
     (com.palletops.awaze.common/aws-client :route53 credentials11492)]
    (clojure.core/case
     (clojure.core/count args11493)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11494
       getTrafficPolicyInstanceCount
       (route53/get-traffic-policy-instance-count-request
        (clojure.core/nth args11493 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11494
       getTrafficPolicyInstanceCount))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-status
   [m11495]
   (clojure.core/let
    [credentials11496 (:credentials m11495) args11497 (:args m11495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11498
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11496)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11498
       getHealthCheckStatus
       (route53/get-health-check-status-request
        (clojure.core/nth args11497 0)))))))
  (clojure.core/defn
   get-health-check-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckStatus"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-health-check-status,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckStatus"}
   [credentials11500 & args11501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11502
     (com.palletops.awaze.common/aws-client :route53 credentials11500)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11502
      getHealthCheckStatus
      (route53/get-health-check-status-request
       (clojure.core/nth args11501 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11503]
   (clojure.core/let
    [credentials11504 (:credentials m11503) args11505 (:args m11503)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11506
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11504)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11506
       getChange
       (route53/get-change-request (clojure.core/nth args11505 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-change,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChange"}
   [credentials11508 & args11509]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11510
     (com.palletops.awaze.common/aws-client :route53 credentials11508)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11510
      getChange
      (route53/get-change-request (clojure.core/nth args11509 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-geo-locations
   [m11511]
   (clojure.core/let
    [credentials11512 (:credentials m11511) args11513 (:args m11511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11514
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11512)]
     (clojure.core/case
      (clojure.core/count args11513)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11514
        listGeoLocations
        (route53/list-geo-locations-request
         (clojure.core/nth args11513 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11514
        listGeoLocations))))))
  (clojure.core/defn
   list-geo-locations-map
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGeoLocations, listGeoLocations"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-geo-locations,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-geo-locations,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-geo-locations
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGeoLocations, listGeoLocations"}
   [credentials11516 & args11517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11518
     (com.palletops.awaze.common/aws-client :route53 credentials11516)]
    (clojure.core/case
     (clojure.core/count args11517)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11518
       listGeoLocations
       (route53/list-geo-locations-request
        (clojure.core/nth args11517 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11518
       listGeoLocations))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone-count
   [m11519]
   (clojure.core/let
    [credentials11520 (:credentials m11519) args11521 (:args m11519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11522
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11520)]
     (clojure.core/case
      (clojure.core/count args11521)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11522
        getHostedZoneCount
        (route53/get-hosted-zone-count-request
         (clojure.core/nth args11521 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11522
        getHostedZoneCount))))))
  (clojure.core/defn
   get-hosted-zone-count-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getHostedZoneCount, getHostedZoneCount"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-hosted-zone-count,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-hosted-zone-count,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone-count
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getHostedZoneCount, getHostedZoneCount"}
   [credentials11524 & args11525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11526
     (com.palletops.awaze.common/aws-client :route53 credentials11524)]
    (clojure.core/case
     (clojure.core/count args11525)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11526
       getHostedZoneCount
       (route53/get-hosted-zone-count-request
        (clojure.core/nth args11525 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11526
       getHostedZoneCount))))))
 (do
  (clojure.core/defmethod
   route53
   :update-hosted-zone-comment
   [m11527]
   (clojure.core/let
    [credentials11528 (:credentials m11527) args11529 (:args m11527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11530
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11530
       updateHostedZoneComment
       (route53/update-hosted-zone-comment-request
        (clojure.core/nth args11529 0)))))))
  (clojure.core/defn
   update-hosted-zone-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateHostedZoneComment"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-hosted-zone-comment,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   update-hosted-zone-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateHostedZoneComment"}
   [credentials11532 & args11533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11534
     (com.palletops.awaze.common/aws-client :route53 credentials11532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11534
      updateHostedZoneComment
      (route53/update-hosted-zone-comment-request
       (clojure.core/nth args11533 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-count
   [m11535]
   (clojure.core/let
    [credentials11536 (:credentials m11535) args11537 (:args m11535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11538
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11536)]
     (clojure.core/case
      (clojure.core/count args11537)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11538
        getHealthCheckCount
        (route53/get-health-check-count-request
         (clojure.core/nth args11537 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11538
        getHealthCheckCount))))))
  (clojure.core/defn
   get-health-check-count-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getHealthCheckCount, getHealthCheckCount"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-health-check-count,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-health-check-count,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-count
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getHealthCheckCount, getHealthCheckCount"}
   [credentials11540 & args11541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11542
     (com.palletops.awaze.common/aws-client :route53 credentials11540)]
    (clojure.core/case
     (clojure.core/count args11541)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11542
       getHealthCheckCount
       (route53/get-health-check-count-request
        (clojure.core/nth args11541 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11542
       getHealthCheckCount))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11543]
   (clojure.core/let
    [credentials11544 (:credentials m11543) args11545 (:args m11543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11546
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11544)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11546
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11545 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZone"}
   [credentials11548 & args11549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11550
     (com.palletops.awaze.common/aws-client :route53 credentials11548)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11550
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11549 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-comment
   [m11551]
   (clojure.core/let
    [credentials11552 (:credentials m11551) args11553 (:args m11551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11554
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11552)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11554
       updateTrafficPolicyComment
       (route53/update-traffic-policy-comment-request
        (clojure.core/nth args11553 0)))))))
  (clojure.core/defn
   update-traffic-policy-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyComment"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-comment,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyComment"}
   [credentials11556 & args11557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11558
     (com.palletops.awaze.common/aws-client :route53 credentials11556)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11558
      updateTrafficPolicyComment
      (route53/update-traffic-policy-comment-request
       (clojure.core/nth args11557 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance
   [m11559]
   (clojure.core/let
    [credentials11560 (:credentials m11559) args11561 (:args m11559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11562
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11560)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11562
       getTrafficPolicyInstance
       (route53/get-traffic-policy-instance-request
        (clojure.core/nth args11561 0)))))))
  (clojure.core/defn
   get-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstance"}
   [credentials11564 & args11565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11566
     (com.palletops.awaze.common/aws-client :route53 credentials11564)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11566
      getTrafficPolicyInstance
      (route53/get-traffic-policy-instance-request
       (clojure.core/nth args11565 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones-by-name
   [m11567]
   (clojure.core/let
    [credentials11568 (:credentials m11567) args11569 (:args m11567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11570
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11568)]
     (clojure.core/case
      (clojure.core/count args11569)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11570
        listHostedZonesByName))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11570
        listHostedZonesByName
        (route53/list-hosted-zones-by-name-request
         (clojure.core/nth args11569 0))))))))
  (clojure.core/defn
   list-hosted-zones-by-name-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listHostedZonesByName, listHostedZonesByName"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones-by-name
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listHostedZonesByName, listHostedZonesByName"}
   [credentials11572 & args11573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11574
     (com.palletops.awaze.common/aws-client :route53 credentials11572)]
    (clojure.core/case
     (clojure.core/count args11573)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11574
       listHostedZonesByName))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11574
       listHostedZonesByName
       (route53/list-hosted-zones-by-name-request
        (clojure.core/nth args11573 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-geo-location
   [m11575]
   (clojure.core/let
    [credentials11576 (:credentials m11575) args11577 (:args m11575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11578
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11576)]
     (clojure.core/case
      (clojure.core/count args11577)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11578
        getGeoLocation))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11578
        getGeoLocation
        (route53/get-geo-location-request
         (clojure.core/nth args11577 0))))))))
  (clojure.core/defn
   get-geo-location-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]]),
    :doc "Generate map for getGeoLocation, getGeoLocation"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-geo-location,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-geo-location,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-geo-location
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]]),
    :doc "Call getGeoLocation, getGeoLocation"}
   [credentials11580 & args11581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11582
     (com.palletops.awaze.common/aws-client :route53 credentials11580)]
    (clojure.core/case
     (clojure.core/count args11581)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11582
       getGeoLocation))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11582
       getGeoLocation
       (route53/get-geo-location-request
        (clojure.core/nth args11581 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resource
   [m11583]
   (clojure.core/let
    [credentials11584 (:credentials m11583) args11585 (:args m11583)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11586
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11584)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11586
       listTagsForResource
       (route53/list-tags-for-resource-request
        (clojure.core/nth args11585 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials11588 & args11589]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11590
     (com.palletops.awaze.common/aws-client :route53 credentials11588)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11590
      listTagsForResource
      (route53/list-tags-for-resource-request
       (clojure.core/nth args11589 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-reusable-delegation-set
   [m11591]
   (clojure.core/let
    [credentials11592 (:credentials m11591) args11593 (:args m11591)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11594
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11592)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11594
       createReusableDelegationSet
       (route53/create-reusable-delegation-set-request
        (clojure.core/nth args11593 0)))))))
  (clojure.core/defn
   create-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createReusableDelegationSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-reusable-delegation-set,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   create-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createReusableDelegationSet"}
   [credentials11596 & args11597]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11598
     (com.palletops.awaze.common/aws-client :route53 credentials11596)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11598
      createReusableDelegationSet
      (route53/create-reusable-delegation-set-request
       (clojure.core/nth args11597 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11599]
   (clojure.core/let
    [credentials11600 (:credentials m11599) args11601 (:args m11599)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11602
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11600)]
     (clojure.core/case
      (clojure.core/count args11601)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11602
        listHealthChecks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11602
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11601 0))))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-health-checks,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-health-checks,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11604 & args11605]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11606
     (com.palletops.awaze.common/aws-client :route53 credentials11604)]
    (clojure.core/case
     (clojure.core/count args11605)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11606
       listHealthChecks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11606
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11605 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-instance
   [m11607]
   (clojure.core/let
    [credentials11608 (:credentials m11607) args11609 (:args m11607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11610
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11608)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11610
       updateTrafficPolicyInstance
       (route53/update-traffic-policy-instance-request
        (clojure.core/nth args11609 0)))))))
  (clojure.core/defn
   update-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-instance,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyInstance"}
   [credentials11612 & args11613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11614
     (com.palletops.awaze.common/aws-client :route53 credentials11612)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11614
      updateTrafficPolicyInstance
      (route53/update-traffic-policy-instance-request
       (clojure.core/nth args11613 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11615]
   (clojure.core/let
    [credentials11616 (:credentials m11615) args11617 (:args m11615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11618
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11616)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11618
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11617 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-health-check,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11620 & args11621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11622
     (com.palletops.awaze.common/aws-client :route53 credentials11620)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11622
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11621 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy
   [m11623]
   (clojure.core/let
    [credentials11624 (:credentials m11623) args11625 (:args m11623)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11626
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11624)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11626
       getTrafficPolicy
       (route53/get-traffic-policy-request
        (clojure.core/nth args11625 0)))))))
  (clojure.core/defn
   get-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-traffic-policy,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call getTrafficPolicy"}
   [credentials11628 & args11629]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11630
     (com.palletops.awaze.common/aws-client :route53 credentials11628)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11630
      getTrafficPolicy
      (route53/get-traffic-policy-request
       (clojure.core/nth args11629 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-rrset
   [m11631]
   (clojure.core/let
    [credentials11632 (:credentials m11631) args11633 (:args m11631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11634
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11632)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11634
       listChangeBatchesByRRSet
       (route53/list-change-batches-by-rrset-request
        (clojure.core/nth args11633 0)))))))
  (clojure.core/defn
   list-change-batches-by-rrset-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByRRSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-rrset,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-rrset
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByRRSet"}
   [credentials11636 & args11637]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11638
     (com.palletops.awaze.common/aws-client :route53 credentials11636)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11638
      listChangeBatchesByRRSet
      (route53/list-change-batches-by-rrset-request
       (clojure.core/nth args11637 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11639]
   (clojure.core/let
    [credentials11640 (:credentials m11639) args11641 (:args m11639)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11642
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11640)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11642
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11641 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-resource-record-sets,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11644 & args11645]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11646
     (com.palletops.awaze.common/aws-client :route53 credentials11644)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11646
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11645 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :disassociate-vpcfrom-hosted-zone
   [m11647]
   (clojure.core/let
    [credentials11648 (:credentials m11647) args11649 (:args m11647)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11650
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11648)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11650
       disassociateVPCFromHostedZone
       (route53/disassociate-vpcfrom-hosted-zone-request
        (clojure.core/nth args11649 0)))))))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for disassociateVPCFromHostedZone"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disassociate-vpcfrom-hosted-zone,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call disassociateVPCFromHostedZone"}
   [credentials11652 & args11653]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11654
     (com.palletops.awaze.common/aws-client :route53 credentials11652)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11654
      disassociateVPCFromHostedZone
      (route53/disassociate-vpcfrom-hosted-zone-request
       (clojure.core/nth args11653 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances
   [m11655]
   (clojure.core/let
    [credentials11656 (:credentials m11655) args11657 (:args m11655)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11658
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11656)]
     (clojure.core/case
      (clojure.core/count args11657)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11658
        listTrafficPolicyInstances
        (route53/list-traffic-policy-instances-request
         (clojure.core/nth args11657 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11658
        listTrafficPolicyInstances))))))
  (clojure.core/defn
   list-traffic-policy-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTrafficPolicyInstances, listTrafficPolicyInstances"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1784__auto__,
     :client :route53})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1784__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTrafficPolicyInstances, listTrafficPolicyInstances"}
   [credentials11660 & args11661]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11662
     (com.palletops.awaze.common/aws-client :route53 credentials11660)]
    (clojure.core/case
     (clojure.core/count args11661)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11662
       listTrafficPolicyInstances
       (route53/list-traffic-policy-instances-request
        (clojure.core/nth args11661 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11662
       listTrafficPolicyInstances)))))))
