(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Tag}
tag
  [m8799]
  (clojure.core/let
   [bean8798 (new com.amazonaws.services.redshift.model.Tag)]
   (clojure.core/let
    [v8800 (:value m8799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8800 :com.palletops.awaze.client-builder/undef)
     (. bean8798 setValue (clojure.core/str v8800))))
   (clojure.core/let
    [v8800 (:key m8799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8800 :com.palletops.awaze.client-builder/undef)
     (. bean8798 setKey (clojure.core/str v8800))))
   bean8798))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m8802]
  (clojure.core/let
   [bean8801 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/let
    [v8803
     (:description m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setDescription (clojure.core/str v8803))))
   (clojure.core/let
    [v8803
     (:data-type m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setDataType (clojure.core/str v8803))))
   (clojure.core/let
    [v8803
     (:parameter-value
      m8802
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setParameterValue (clojure.core/str v8803))))
   (clojure.core/let
    [v8803
     (:parameter-name m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setParameterName (clojure.core/str v8803))))
   (clojure.core/let
    [v8803
     (:is-modifiable m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setIsModifiable (clojure.core/boolean v8803))))
   (clojure.core/let
    [v8803
     (:minimum-engine-version
      m8802
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setMinimumEngineVersion (clojure.core/str v8803))))
   (clojure.core/let
    [v8803
     (:apply-type m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setApplyType (clojure.core/str v8803))))
   (clojure.core/let
    [v8803
     (:allowed-values m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setAllowedValues (clojure.core/str v8803))))
   (clojure.core/let
    [v8803 (:source m8802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8803 :com.palletops.awaze.client-builder/undef)
     (. bean8801 setSource (clojure.core/str v8803))))
   bean8801))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m8805]
  (clojure.core/let
   [bean8804
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/let
    [v8806
     (:cluster-identifier
      m8805
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8806 :com.palletops.awaze.client-builder/undef)
     (. bean8804 setClusterIdentifier (clojure.core/str v8806))))
   bean8804))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m8808]
  (clojure.core/let
   [bean8807
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/let
    [v8809
     (:cluster-identifier
      m8808
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (. bean8807 setClusterIdentifier (clojure.core/str v8809))))
   (clojure.core/let
    [v8809
     (:snapshot-type m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (. bean8807 setSnapshotType (clojure.core/str v8809))))
   (clojure.core/let
    [v8809 (:marker m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (. bean8807 setMarker (clojure.core/str v8809))))
   (clojure.core/let
    [v8809
     (:tag-values m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (.
      bean8807
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8990] (clojure.core/str arg8990))
 v8809))))
   (clojure.core/let
    [v8809
     (:start-time m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (.
      bean8807
      setStartTime
      (com.palletops.awaze.common/to-date v8809))))
   (clojure.core/let
    [v8809
     (:max-records m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (. bean8807 setMaxRecords (clojure.core/int v8809))))
   (clojure.core/let
    [v8809
     (:end-time m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (.
      bean8807
      setEndTime
      (com.palletops.awaze.common/to-date v8809))))
   (clojure.core/let
    [v8809
     (:snapshot-identifier
      m8808
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (. bean8807 setSnapshotIdentifier (clojure.core/str v8809))))
   (clojure.core/let
    [v8809
     (:owner-account m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (. bean8807 setOwnerAccount (clojure.core/str v8809))))
   (clojure.core/let
    [v8809
     (:tag-keys m8808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8809 :com.palletops.awaze.client-builder/undef)
     (.
      bean8807
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8991] (clojure.core/str arg8991))
 v8809))))
   bean8807))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m8811]
  (clojure.core/let
   [bean8810
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/let
    [v8812 (:marker m8811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8812 :com.palletops.awaze.client-builder/undef)
     (. bean8810 setMarker (clojure.core/str v8812))))
   (clojure.core/let
    [v8812
     (:max-records m8811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8812 :com.palletops.awaze.client-builder/undef)
     (. bean8810 setMaxRecords (clojure.core/int v8812))))
   (clojure.core/let
    [v8812
     (:parameter-group-family
      m8811
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8812 :com.palletops.awaze.client-builder/undef)
     (. bean8810 setParameterGroupFamily (clojure.core/str v8812))))
   bean8810))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m8814]
  (clojure.core/let
   [bean8813
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/let
    [v8815
     (:hsm-client-certificate-identifier
      m8814
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8815 :com.palletops.awaze.client-builder/undef)
     (.
      bean8813
      setHsmClientCertificateIdentifier
      (clojure.core/str v8815))))
   (clojure.core/let
    [v8815 (:tags m8814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8815 :com.palletops.awaze.client-builder/undef)
     (.
      bean8813
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8992] (redshift/tag arg8992))
 v8815))))
   bean8813))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m8817]
  (clojure.core/let
   [bean8816
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/let
    [v8818
     (:cluster-version
      m8817
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8818 :com.palletops.awaze.client-builder/undef)
     (. bean8816 setClusterVersion (clojure.core/str v8818))))
   (clojure.core/let
    [v8818 (:marker m8817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8818 :com.palletops.awaze.client-builder/undef)
     (. bean8816 setMarker (clojure.core/str v8818))))
   (clojure.core/let
    [v8818
     (:max-records m8817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8818 :com.palletops.awaze.client-builder/undef)
     (. bean8816 setMaxRecords (clojure.core/int v8818))))
   (clojure.core/let
    [v8818
     (:cluster-parameter-group-family
      m8817
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8818 :com.palletops.awaze.client-builder/undef)
     (.
      bean8816
      setClusterParameterGroupFamily
      (clojure.core/str v8818))))
   bean8816))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m8820]
  (clojure.core/let
   [bean8819
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/let
    [v8821
     (:cluster-identifier
      m8820
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8821 :com.palletops.awaze.client-builder/undef)
     (. bean8819 setClusterIdentifier (clojure.core/str v8821))))
   (clojure.core/let
    [v8821
     (:retention-period
      m8820
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8821 :com.palletops.awaze.client-builder/undef)
     (. bean8819 setRetentionPeriod (clojure.core/int v8821))))
   (clojure.core/let
    [v8821
     (:snapshot-copy-grant-name
      m8820
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8821 :com.palletops.awaze.client-builder/undef)
     (. bean8819 setSnapshotCopyGrantName (clojure.core/str v8821))))
   (clojure.core/let
    [v8821
     (:destination-region
      m8820
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8821 :com.palletops.awaze.client-builder/undef)
     (. bean8819 setDestinationRegion (clojure.core/str v8821))))
   bean8819))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest}
create-snapshot-copy-grant-request
  [m8823]
  (clojure.core/let
   [bean8822
    (new
     com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8824
     (:snapshot-copy-grant-name
      m8823
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8824 :com.palletops.awaze.client-builder/undef)
     (. bean8822 setSnapshotCopyGrantName (clojure.core/str v8824))))
   (clojure.core/let
    [v8824
     (:kms-key-id m8823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8824 :com.palletops.awaze.client-builder/undef)
     (. bean8822 setKmsKeyId (clojure.core/str v8824))))
   (clojure.core/let
    [v8824 (:tags m8823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8824 :com.palletops.awaze.client-builder/undef)
     (.
      bean8822
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8993] (redshift/tag arg8993))
 v8824))))
   bean8822))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m8826]
  (clojure.core/let
   [bean8825
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/let
    [v8827
     (:tag-keys m8826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8827 :com.palletops.awaze.client-builder/undef)
     (.
      bean8825
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8994] (clojure.core/str arg8994))
 v8827))))
   (clojure.core/let
    [v8827 (:marker m8826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8827 :com.palletops.awaze.client-builder/undef)
     (. bean8825 setMarker (clojure.core/str v8827))))
   (clojure.core/let
    [v8827
     (:max-records m8826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8827 :com.palletops.awaze.client-builder/undef)
     (. bean8825 setMaxRecords (clojure.core/int v8827))))
   (clojure.core/let
    [v8827
     (:parameter-group-name
      m8826
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8827 :com.palletops.awaze.client-builder/undef)
     (. bean8825 setParameterGroupName (clojure.core/str v8827))))
   (clojure.core/let
    [v8827
     (:tag-values m8826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8827 :com.palletops.awaze.client-builder/undef)
     (.
      bean8825
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8995] (clojure.core/str arg8995))
 v8827))))
   bean8825))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m8829]
  (clojure.core/let
   [bean8828
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/let
    [v8830
     (:parameter-group-name
      m8829
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8830 :com.palletops.awaze.client-builder/undef)
     (. bean8828 setParameterGroupName (clojure.core/str v8830))))
   bean8828))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m8832]
  (clojure.core/let
   [bean8831
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/let
    [v8833
     (:source-identifier
      m8832
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (. bean8831 setSourceIdentifier (clojure.core/str v8833))))
   (clojure.core/let
    [v8833
     (:source-type m8832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (. bean8831 setSourceType (clojure.core/str v8833))))
   (clojure.core/let
    [v8833
     (:duration m8832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (. bean8831 setDuration (clojure.core/int v8833))))
   (clojure.core/let
    [v8833
     (:start-time m8832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (.
      bean8831
      setStartTime
      (com.palletops.awaze.common/to-date v8833))))
   (clojure.core/let
    [v8833
     (:end-time m8832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (.
      bean8831
      setEndTime
      (com.palletops.awaze.common/to-date v8833))))
   (clojure.core/let
    [v8833 (:marker m8832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (. bean8831 setMarker (clojure.core/str v8833))))
   (clojure.core/let
    [v8833
     (:max-records m8832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8833 :com.palletops.awaze.client-builder/undef)
     (. bean8831 setMaxRecords (clojure.core/int v8833))))
   bean8831))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m8835]
  (clojure.core/let
   [bean8834
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/let
    [v8836 (:marker m8835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8836 :com.palletops.awaze.client-builder/undef)
     (. bean8834 setMarker (clojure.core/str v8836))))
   (clojure.core/let
    [v8836
     (:max-records m8835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8836 :com.palletops.awaze.client-builder/undef)
     (. bean8834 setMaxRecords (clojure.core/int v8836))))
   (clojure.core/let
    [v8836
     (:reserved-node-id
      m8835
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8836 :com.palletops.awaze.client-builder/undef)
     (. bean8834 setReservedNodeId (clojure.core/str v8836))))
   bean8834))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest}
modify-cluster-iam-roles-request
  [m8838]
  (clojure.core/let
   [bean8837
    (new
     com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest)]
   (clojure.core/let
    [v8839
     (:cluster-identifier
      m8838
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8839 :com.palletops.awaze.client-builder/undef)
     (. bean8837 setClusterIdentifier (clojure.core/str v8839))))
   (clojure.core/let
    [v8839
     (:add-iam-roles m8838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8839 :com.palletops.awaze.client-builder/undef)
     (.
      bean8837
      setAddIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8996] (clojure.core/str arg8996))
 v8839))))
   (clojure.core/let
    [v8839
     (:remove-iam-roles
      m8838
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8839 :com.palletops.awaze.client-builder/undef)
     (.
      bean8837
      setRemoveIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8997] (clojure.core/str arg8997))
 v8839))))
   bean8837))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m8841]
  (clojure.core/let
   [bean8840
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v8842
     (:subscription-name
      m8841
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8842 :com.palletops.awaze.client-builder/undef)
     (. bean8840 setSubscriptionName (clojure.core/str v8842))))
   bean8840))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m8844]
  (clojure.core/let
   [bean8843
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/let
    [v8845
     (:cluster-identifier
      m8844
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8845 :com.palletops.awaze.client-builder/undef)
     (. bean8843 setClusterIdentifier (clojure.core/str v8845))))
   bean8843))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m8847]
  (clojure.core/let
   [bean8846
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8848
     (:description m8847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8848 :com.palletops.awaze.client-builder/undef)
     (. bean8846 setDescription (clojure.core/str v8848))))
   (clojure.core/let
    [v8848 (:tags m8847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8848 :com.palletops.awaze.client-builder/undef)
     (.
      bean8846
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8998] (redshift/tag arg8998))
 v8848))))
   (clojure.core/let
    [v8848
     (:cluster-security-group-name
      m8847
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8848 :com.palletops.awaze.client-builder/undef)
     (. bean8846 setClusterSecurityGroupName (clojure.core/str v8848))))
   bean8846))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m8850]
  (clojure.core/let
   [bean8849
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/let
    [v8851
     (:parameters m8850 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8851 :com.palletops.awaze.client-builder/undef)
     (.
      bean8849
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8999] (redshift/parameter arg8999))
 v8851))))
   (clojure.core/let
    [v8851
     (:parameter-group-name
      m8850
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8851 :com.palletops.awaze.client-builder/undef)
     (. bean8849 setParameterGroupName (clojure.core/str v8851))))
   bean8849))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m8853]
  (clojure.core/let
   [bean8852
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/let
    [v8854
     (:cluster-identifier
      m8853
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8854 :com.palletops.awaze.client-builder/undef)
     (. bean8852 setClusterIdentifier (clojure.core/str v8854))))
   (clojure.core/let
    [v8854
     (:retention-period
      m8853
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8854 :com.palletops.awaze.client-builder/undef)
     (. bean8852 setRetentionPeriod (clojure.core/int v8854))))
   bean8852))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest}
delete-snapshot-copy-grant-request
  [m8856]
  (clojure.core/let
   [bean8855
    (new
     com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8857
     (:snapshot-copy-grant-name
      m8856
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8857 :com.palletops.awaze.client-builder/undef)
     (. bean8855 setSnapshotCopyGrantName (clojure.core/str v8857))))
   bean8855))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m8859]
  (clojure.core/let
   [bean8858
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/let
    [v8860
     (:snapshot-identifier
      m8859
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8860 :com.palletops.awaze.client-builder/undef)
     (. bean8858 setSnapshotIdentifier (clojure.core/str v8860))))
   (clojure.core/let
    [v8860
     (:snapshot-cluster-identifier
      m8859
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8860 :com.palletops.awaze.client-builder/undef)
     (.
      bean8858
      setSnapshotClusterIdentifier
      (clojure.core/str v8860))))
   (clojure.core/let
    [v8860
     (:account-with-restore-access
      m8859
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8860 :com.palletops.awaze.client-builder/undef)
     (. bean8858 setAccountWithRestoreAccess (clojure.core/str v8860))))
   bean8858))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m8862]
  (clojure.core/let
   [bean8861
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/let
    [v8863
     (:cluster-identifier
      m8862
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8863 :com.palletops.awaze.client-builder/undef)
     (. bean8861 setClusterIdentifier (clojure.core/str v8863))))
   bean8861))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m8865]
  (clojure.core/let
   [bean8864
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8866
     (:cluster-subnet-group-name
      m8865
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8866 :com.palletops.awaze.client-builder/undef)
     (. bean8864 setClusterSubnetGroupName (clojure.core/str v8866))))
   (clojure.core/let
    [v8866
     (:description m8865 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8866 :com.palletops.awaze.client-builder/undef)
     (. bean8864 setDescription (clojure.core/str v8866))))
   (clojure.core/let
    [v8866
     (:subnet-ids m8865 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8866 :com.palletops.awaze.client-builder/undef)
     (.
      bean8864
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9000] (clojure.core/str arg9000))
 v8866))))
   bean8864))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m8868]
  (clojure.core/let
   [bean8867
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/let
    [v8869
     (:cluster-version
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setClusterVersion (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:cluster-type m8868 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setClusterType (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:cluster-identifier
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setClusterIdentifier (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:elastic-ip m8868 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setElasticIp (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:allow-version-upgrade
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setAllowVersionUpgrade (clojure.core/boolean v8869))))
   (clojure.core/let
    [v8869
     (:hsm-client-certificate-identifier
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setHsmClientCertificateIdentifier
      (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:new-cluster-identifier
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setNewClusterIdentifier (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:automated-snapshot-retention-period
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8869))))
   (clojure.core/let
    [v8869
     (:master-user-password
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setMasterUserPassword (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:publicly-accessible
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setPubliclyAccessible (clojure.core/boolean v8869))))
   (clojure.core/let
    [v8869
     (:preferred-maintenance-window
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setPreferredMaintenanceWindow
      (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:node-type m8868 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setNodeType (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:hsm-configuration-identifier
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setHsmConfigurationIdentifier
      (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:cluster-security-groups
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9001] (clojure.core/str arg9001))
 v8869))))
   (clojure.core/let
    [v8869
     (:vpc-security-group-ids
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9002] (clojure.core/str arg9002))
 v8869))))
   (clojure.core/let
    [v8869
     (:cluster-parameter-group-name
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (.
      bean8867
      setClusterParameterGroupName
      (clojure.core/str v8869))))
   (clojure.core/let
    [v8869
     (:number-of-nodes
      m8868
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8869 :com.palletops.awaze.client-builder/undef)
     (. bean8867 setNumberOfNodes (clojure.core/int v8869))))
   bean8867))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m8871]
  (clojure.core/let
   [bean8870
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8872
     (:cluster-subnet-group-name
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setClusterSubnetGroupName (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:cluster-identifier
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setClusterIdentifier (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:elastic-ip m8871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setElasticIp (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:allow-version-upgrade
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setAllowVersionUpgrade (clojure.core/boolean v8872))))
   (clojure.core/let
    [v8872
     (:additional-info
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setAdditionalInfo (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:hsm-client-certificate-identifier
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setHsmClientCertificateIdentifier
      (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:availability-zone
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setAvailabilityZone (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:automated-snapshot-retention-period
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8872))))
   (clojure.core/let
    [v8872
     (:publicly-accessible
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setPubliclyAccessible (clojure.core/boolean v8872))))
   (clojure.core/let
    [v8872
     (:preferred-maintenance-window
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setPreferredMaintenanceWindow
      (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:snapshot-cluster-identifier
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setSnapshotClusterIdentifier
      (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:iam-roles m8871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9003] (clojure.core/str arg9003))
 v8872))))
   (clojure.core/let
    [v8872 (:port m8871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setPort (clojure.core/int v8872))))
   (clojure.core/let
    [v8872
     (:node-type m8871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setNodeType (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:hsm-configuration-identifier
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setHsmConfigurationIdentifier
      (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:cluster-security-groups
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9004] (clojure.core/str arg9004))
 v8872))))
   (clojure.core/let
    [v8872
     (:snapshot-identifier
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setSnapshotIdentifier (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:owner-account m8871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setOwnerAccount (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:vpc-security-group-ids
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9005] (clojure.core/str arg9005))
 v8872))))
   (clojure.core/let
    [v8872
     (:cluster-parameter-group-name
      m8871
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (.
      bean8870
      setClusterParameterGroupName
      (clojure.core/str v8872))))
   (clojure.core/let
    [v8872
     (:kms-key-id m8871 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8872 :com.palletops.awaze.client-builder/undef)
     (. bean8870 setKmsKeyId (clojure.core/str v8872))))
   bean8870))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m8874]
  (clojure.core/let
   [bean8873
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/let
    [v8875
     (:hsm-client-certificate-identifier
      m8874
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8875 :com.palletops.awaze.client-builder/undef)
     (.
      bean8873
      setHsmClientCertificateIdentifier
      (clojure.core/str v8875))))
   bean8873))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m8877]
  (clojure.core/let
   [bean8876
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/let
    [v8878
     (:cluster-version
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setClusterVersion (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:cluster-type m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setClusterType (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:cluster-subnet-group-name
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setClusterSubnetGroupName (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:cluster-identifier
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setClusterIdentifier (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:elastic-ip m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setElasticIp (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:allow-version-upgrade
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setAllowVersionUpgrade (clojure.core/boolean v8878))))
   (clojure.core/let
    [v8878
     (:additional-info
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setAdditionalInfo (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:hsm-client-certificate-identifier
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setHsmClientCertificateIdentifier
      (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:availability-zone
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setAvailabilityZone (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:automated-snapshot-retention-period
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8878))))
   (clojure.core/let
    [v8878
     (:master-user-password
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setMasterUserPassword (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:publicly-accessible
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setPubliclyAccessible (clojure.core/boolean v8878))))
   (clojure.core/let
    [v8878
     (:preferred-maintenance-window
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setPreferredMaintenanceWindow
      (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:iam-roles m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9006] (clojure.core/str arg9006))
 v8878))))
   (clojure.core/let
    [v8878 (:port m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setPort (clojure.core/int v8878))))
   (clojure.core/let
    [v8878 (:tags m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9007] (redshift/tag arg9007))
 v8878))))
   (clojure.core/let
    [v8878
     (:node-type m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setNodeType (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:hsm-configuration-identifier
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setHsmConfigurationIdentifier
      (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:cluster-security-groups
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9008] (clojure.core/str arg9008))
 v8878))))
   (clojure.core/let
    [v8878
     (:vpc-security-group-ids
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9009] (clojure.core/str arg9009))
 v8878))))
   (clojure.core/let
    [v8878
     (:cluster-parameter-group-name
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (.
      bean8876
      setClusterParameterGroupName
      (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:master-username
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setMasterUsername (clojure.core/str v8878))))
   (clojure.core/let
    [v8878 (:dbname m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setDBName (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:kms-key-id m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setKmsKeyId (clojure.core/str v8878))))
   (clojure.core/let
    [v8878
     (:encrypted m8877 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setEncrypted (clojure.core/boolean v8878))))
   (clojure.core/let
    [v8878
     (:number-of-nodes
      m8877
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8878 :com.palletops.awaze.client-builder/undef)
     (. bean8876 setNumberOfNodes (clojure.core/int v8878))))
   bean8876))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m8880]
  (clojure.core/let
   [bean8879
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/let
    [v8881
     (:cluster-identifier
      m8880
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8881 :com.palletops.awaze.client-builder/undef)
     (. bean8879 setClusterIdentifier (clojure.core/str v8881))))
   bean8879))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest}
describe-table-restore-status-request
  [m8883]
  (clojure.core/let
   [bean8882
    (new
     com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest)]
   (clojure.core/let
    [v8884
     (:cluster-identifier
      m8883
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8884 :com.palletops.awaze.client-builder/undef)
     (. bean8882 setClusterIdentifier (clojure.core/str v8884))))
   (clojure.core/let
    [v8884
     (:table-restore-request-id
      m8883
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8884 :com.palletops.awaze.client-builder/undef)
     (. bean8882 setTableRestoreRequestId (clojure.core/str v8884))))
   (clojure.core/let
    [v8884 (:marker m8883 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8884 :com.palletops.awaze.client-builder/undef)
     (. bean8882 setMarker (clojure.core/str v8884))))
   (clojure.core/let
    [v8884
     (:max-records m8883 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8884 :com.palletops.awaze.client-builder/undef)
     (. bean8882 setMaxRecords (clojure.core/int v8884))))
   bean8882))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m8886]
  (clojure.core/let
   [bean8885
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v8887
     (:source-type m8886 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8887 :com.palletops.awaze.client-builder/undef)
     (. bean8885 setSourceType (clojure.core/str v8887))))
   bean8885))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m8889]
  (clojure.core/let
   [bean8888
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/let
    [v8890 (:marker m8889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8890 :com.palletops.awaze.client-builder/undef)
     (. bean8888 setMarker (clojure.core/str v8890))))
   (clojure.core/let
    [v8890 (:source m8889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8890 :com.palletops.awaze.client-builder/undef)
     (. bean8888 setSource (clojure.core/str v8890))))
   (clojure.core/let
    [v8890
     (:max-records m8889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8890 :com.palletops.awaze.client-builder/undef)
     (. bean8888 setMaxRecords (clojure.core/int v8890))))
   (clojure.core/let
    [v8890
     (:parameter-group-name
      m8889
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8890 :com.palletops.awaze.client-builder/undef)
     (. bean8888 setParameterGroupName (clojure.core/str v8890))))
   bean8888))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m8892]
  (clojure.core/let
   [bean8891
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v8893 (:cidrip m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setCIDRIP (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:cluster-security-group-name
      m8892
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setClusterSecurityGroupName (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:ec2security-group-name
      m8892
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setEC2SecurityGroupName (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:ec2security-group-owner-id
      m8892
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setEC2SecurityGroupOwnerId (clojure.core/str v8893))))
   bean8891))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m8895]
  (clojure.core/let
   [bean8894
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/let
    [v8896
     (:tag-keys m8895 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8896 :com.palletops.awaze.client-builder/undef)
     (.
      bean8894
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9010] (clojure.core/str arg9010))
 v8896))))
   (clojure.core/let
    [v8896
     (:cluster-identifier
      m8895
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8896 :com.palletops.awaze.client-builder/undef)
     (. bean8894 setClusterIdentifier (clojure.core/str v8896))))
   (clojure.core/let
    [v8896 (:marker m8895 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8896 :com.palletops.awaze.client-builder/undef)
     (. bean8894 setMarker (clojure.core/str v8896))))
   (clojure.core/let
    [v8896
     (:max-records m8895 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8896 :com.palletops.awaze.client-builder/undef)
     (. bean8894 setMaxRecords (clojure.core/int v8896))))
   (clojure.core/let
    [v8896
     (:tag-values m8895 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8896 :com.palletops.awaze.client-builder/undef)
     (.
      bean8894
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9011] (clojure.core/str arg9011))
 v8896))))
   bean8894))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m8898]
  (clojure.core/let
   [bean8897
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8899
     (:cluster-subnet-group-name
      m8898
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setClusterSubnetGroupName (clojure.core/str v8899))))
   bean8897))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m8901]
  (clojure.core/let
   [bean8900
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/let
    [v8902
     (:tag-keys m8901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (.
      bean8900
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9012] (clojure.core/str arg9012))
 v8902))))
   (clojure.core/let
    [v8902 (:marker m8901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (. bean8900 setMarker (clojure.core/str v8902))))
   (clojure.core/let
    [v8902
     (:cluster-security-group-name
      m8901
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (. bean8900 setClusterSecurityGroupName (clojure.core/str v8902))))
   (clojure.core/let
    [v8902
     (:max-records m8901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (. bean8900 setMaxRecords (clojure.core/int v8902))))
   (clojure.core/let
    [v8902
     (:tag-values m8901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (.
      bean8900
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9013] (clojure.core/str arg9013))
 v8902))))
   bean8900))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTagsRequest}
describe-tags-request
  [m8904]
  (clojure.core/let
   [bean8903
    (new com.amazonaws.services.redshift.model.DescribeTagsRequest)]
   (clojure.core/let
    [v8905
     (:tag-keys m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (.
      bean8903
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9014] (clojure.core/str arg9014))
 v8905))))
   (clojure.core/let
    [v8905
     (:resource-type m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (. bean8903 setResourceType (clojure.core/str v8905))))
   (clojure.core/let
    [v8905 (:marker m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (. bean8903 setMarker (clojure.core/str v8905))))
   (clojure.core/let
    [v8905
     (:max-records m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (. bean8903 setMaxRecords (clojure.core/int v8905))))
   (clojure.core/let
    [v8905
     (:tag-values m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (.
      bean8903
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9015] (clojure.core/str arg9015))
 v8905))))
   (clojure.core/let
    [v8905
     (:resource-name m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (. bean8903 setResourceName (clojure.core/str v8905))))
   bean8903))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m8907]
  (clojure.core/let
   [bean8906
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/let
    [v8908
     (:cluster-identifier
      m8907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8908 :com.palletops.awaze.client-builder/undef)
     (. bean8906 setClusterIdentifier (clojure.core/str v8908))))
   bean8906))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteTagsRequest}
delete-tags-request
  [m8910]
  (clojure.core/let
   [bean8909
    (new com.amazonaws.services.redshift.model.DeleteTagsRequest)]
   (clojure.core/let
    [v8911
     (:tag-keys m8910 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8911 :com.palletops.awaze.client-builder/undef)
     (.
      bean8909
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9016] (clojure.core/str arg9016))
 v8911))))
   (clojure.core/let
    [v8911
     (:resource-name m8910 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8911 :com.palletops.awaze.client-builder/undef)
     (. bean8909 setResourceName (clojure.core/str v8911))))
   bean8909))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m8913]
  (clojure.core/let
   [bean8912
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/let
    [v8914
     (:reserved-node-offering-id
      m8913
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8914 :com.palletops.awaze.client-builder/undef)
     (. bean8912 setReservedNodeOfferingId (clojure.core/str v8914))))
   (clojure.core/let
    [v8914
     (:node-count m8913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8914 :com.palletops.awaze.client-builder/undef)
     (. bean8912 setNodeCount (clojure.core/int v8914))))
   bean8912))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m8916]
  (clojure.core/let
   [bean8915
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/let
    [v8917
     (:snapshot-identifier
      m8916
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (. bean8915 setSnapshotIdentifier (clojure.core/str v8917))))
   (clojure.core/let
    [v8917
     (:snapshot-cluster-identifier
      m8916
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (.
      bean8915
      setSnapshotClusterIdentifier
      (clojure.core/str v8917))))
   bean8915))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m8919]
  (clojure.core/let
   [bean8918
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/let
    [v8920
     (:description m8919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8920 :com.palletops.awaze.client-builder/undef)
     (. bean8918 setDescription (clojure.core/str v8920))))
   (clojure.core/let
    [v8920 (:tags m8919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8920 :com.palletops.awaze.client-builder/undef)
     (.
      bean8918
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9017] (redshift/tag arg9017))
 v8920))))
   (clojure.core/let
    [v8920
     (:parameter-group-family
      m8919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8920 :com.palletops.awaze.client-builder/undef)
     (. bean8918 setParameterGroupFamily (clojure.core/str v8920))))
   (clojure.core/let
    [v8920
     (:parameter-group-name
      m8919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8920 :com.palletops.awaze.client-builder/undef)
     (. bean8918 setParameterGroupName (clojure.core/str v8920))))
   bean8918))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m8922]
  (clojure.core/let
   [bean8921
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/let
    [v8923
     (:cluster-identifier
      m8922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (. bean8921 setClusterIdentifier (clojure.core/str v8923))))
   bean8921))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m8925]
  (clojure.core/let
   [bean8924
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/let
    [v8926
     (:tag-keys m8925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (.
      bean8924
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9018] (clojure.core/str arg9018))
 v8926))))
   (clojure.core/let
    [v8926
     (:hsm-client-certificate-identifier
      m8925
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (.
      bean8924
      setHsmClientCertificateIdentifier
      (clojure.core/str v8926))))
   (clojure.core/let
    [v8926 (:marker m8925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (. bean8924 setMarker (clojure.core/str v8926))))
   (clojure.core/let
    [v8926
     (:max-records m8925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (. bean8924 setMaxRecords (clojure.core/int v8926))))
   (clojure.core/let
    [v8926
     (:tag-values m8925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (.
      bean8924
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9019] (clojure.core/str arg9019))
 v8926))))
   bean8924))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest}
describe-snapshot-copy-grants-request
  [m8928]
  (clojure.core/let
   [bean8927
    (new
     com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest)]
   (clojure.core/let
    [v8929
     (:tag-keys m8928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (.
      bean8927
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9020] (clojure.core/str arg9020))
 v8929))))
   (clojure.core/let
    [v8929
     (:snapshot-copy-grant-name
      m8928
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (. bean8927 setSnapshotCopyGrantName (clojure.core/str v8929))))
   (clojure.core/let
    [v8929 (:marker m8928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (. bean8927 setMarker (clojure.core/str v8929))))
   (clojure.core/let
    [v8929
     (:max-records m8928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (. bean8927 setMaxRecords (clojure.core/int v8929))))
   (clojure.core/let
    [v8929
     (:tag-values m8928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (.
      bean8927
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9021] (clojure.core/str arg9021))
 v8929))))
   bean8927))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m8931]
  (clojure.core/let
   [bean8930
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/let
    [v8932
     (:parameters m8931 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8932 :com.palletops.awaze.client-builder/undef)
     (.
      bean8930
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9022] (redshift/parameter arg9022))
 v8932))))
   (clojure.core/let
    [v8932
     (:parameter-group-name
      m8931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8932 :com.palletops.awaze.client-builder/undef)
     (. bean8930 setParameterGroupName (clojure.core/str v8932))))
   (clojure.core/let
    [v8932
     (:reset-all-parameters
      m8931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8932 :com.palletops.awaze.client-builder/undef)
     (. bean8930 setResetAllParameters (clojure.core/boolean v8932))))
   bean8930))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m8934]
  (clojure.core/let
   [bean8933
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8935
     (:cluster-security-group-name
      m8934
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8935 :com.palletops.awaze.client-builder/undef)
     (. bean8933 setClusterSecurityGroupName (clojure.core/str v8935))))
   bean8933))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m8937]
  (clojure.core/let
   [bean8936
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/let
    [v8938
     (:source-snapshot-identifier
      m8937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8938 :com.palletops.awaze.client-builder/undef)
     (. bean8936 setSourceSnapshotIdentifier (clojure.core/str v8938))))
   (clojure.core/let
    [v8938
     (:source-snapshot-cluster-identifier
      m8937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8938 :com.palletops.awaze.client-builder/undef)
     (.
      bean8936
      setSourceSnapshotClusterIdentifier
      (clojure.core/str v8938))))
   (clojure.core/let
    [v8938
     (:target-snapshot-identifier
      m8937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8938 :com.palletops.awaze.client-builder/undef)
     (. bean8936 setTargetSnapshotIdentifier (clojure.core/str v8938))))
   bean8936))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest}
restore-table-from-cluster-snapshot-request
  [m8940]
  (clojure.core/let
   [bean8939
    (new
     com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8941
     (:snapshot-identifier
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setSnapshotIdentifier (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:cluster-identifier
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setClusterIdentifier (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:source-database-name
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setSourceDatabaseName (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:source-schema-name
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setSourceSchemaName (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:source-table-name
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setSourceTableName (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:target-database-name
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setTargetDatabaseName (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:target-schema-name
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setTargetSchemaName (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:new-table-name m8940 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setNewTableName (clojure.core/str v8941))))
   bean8939))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m8943]
  (clojure.core/let
   [bean8942
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v8944
     (:source-type m8943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setSourceType (clojure.core/str v8944))))
   (clojure.core/let
    [v8944 (:enabled m8943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setEnabled (clojure.core/boolean v8944))))
   (clojure.core/let
    [v8944
     (:subscription-name
      m8943
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setSubscriptionName (clojure.core/str v8944))))
   (clojure.core/let
    [v8944
     (:sns-topic-arn m8943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setSnsTopicArn (clojure.core/str v8944))))
   (clojure.core/let
    [v8944
     (:source-ids m8943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (.
      bean8942
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9023] (clojure.core/str arg9023))
 v8944))))
   (clojure.core/let
    [v8944
     (:event-categories
      m8943
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (.
      bean8942
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9024] (clojure.core/str arg9024))
 v8944))))
   (clojure.core/let
    [v8944
     (:severity m8943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setSeverity (clojure.core/str v8944))))
   bean8942))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m8946]
  (clojure.core/let
   [bean8945
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/let
    [v8947
     (:hsm-configuration-identifier
      m8946
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (.
      bean8945
      setHsmConfigurationIdentifier
      (clojure.core/str v8947))))
   (clojure.core/let
    [v8947
     (:description m8946 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (. bean8945 setDescription (clojure.core/str v8947))))
   (clojure.core/let
    [v8947 (:tags m8946 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (.
      bean8945
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9025] (redshift/tag arg9025))
 v8947))))
   (clojure.core/let
    [v8947
     (:hsm-ip-address m8946 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (. bean8945 setHsmIpAddress (clojure.core/str v8947))))
   (clojure.core/let
    [v8947
     (:hsm-partition-name
      m8946
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (. bean8945 setHsmPartitionName (clojure.core/str v8947))))
   (clojure.core/let
    [v8947
     (:hsm-partition-password
      m8946
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (. bean8945 setHsmPartitionPassword (clojure.core/str v8947))))
   (clojure.core/let
    [v8947
     (:hsm-server-public-certificate
      m8946
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (.
      bean8945
      setHsmServerPublicCertificate
      (clojure.core/str v8947))))
   bean8945))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m8949]
  (clojure.core/let
   [bean8948
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/let
    [v8950
     (:tag-keys m8949 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (.
      bean8948
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9026] (clojure.core/str arg9026))
 v8950))))
   (clojure.core/let
    [v8950
     (:hsm-configuration-identifier
      m8949
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (.
      bean8948
      setHsmConfigurationIdentifier
      (clojure.core/str v8950))))
   (clojure.core/let
    [v8950 (:marker m8949 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (. bean8948 setMarker (clojure.core/str v8950))))
   (clojure.core/let
    [v8950
     (:max-records m8949 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (. bean8948 setMaxRecords (clojure.core/int v8950))))
   (clojure.core/let
    [v8950
     (:tag-values m8949 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (.
      bean8948
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9027] (clojure.core/str arg9027))
 v8950))))
   bean8948))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m8952]
  (clojure.core/let
   [bean8951
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/let
    [v8953
     (:tag-keys m8952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8953 :com.palletops.awaze.client-builder/undef)
     (.
      bean8951
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9028] (clojure.core/str arg9028))
 v8953))))
   (clojure.core/let
    [v8953
     (:cluster-subnet-group-name
      m8952
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8953 :com.palletops.awaze.client-builder/undef)
     (. bean8951 setClusterSubnetGroupName (clojure.core/str v8953))))
   (clojure.core/let
    [v8953 (:marker m8952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8953 :com.palletops.awaze.client-builder/undef)
     (. bean8951 setMarker (clojure.core/str v8953))))
   (clojure.core/let
    [v8953
     (:max-records m8952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8953 :com.palletops.awaze.client-builder/undef)
     (. bean8951 setMaxRecords (clojure.core/int v8953))))
   (clojure.core/let
    [v8953
     (:tag-values m8952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8953 :com.palletops.awaze.client-builder/undef)
     (.
      bean8951
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9029] (clojure.core/str arg9029))
 v8953))))
   bean8951))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m8955]
  (clojure.core/let
   [bean8954
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/let
    [v8956
     (:cluster-identifier
      m8955
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8956 :com.palletops.awaze.client-builder/undef)
     (. bean8954 setClusterIdentifier (clojure.core/str v8956))))
   (clojure.core/let
    [v8956
     (:skip-final-cluster-snapshot
      m8955
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8956 :com.palletops.awaze.client-builder/undef)
     (.
      bean8954
      setSkipFinalClusterSnapshot
      (clojure.core/boolean v8956))))
   (clojure.core/let
    [v8956
     (:final-cluster-snapshot-identifier
      m8955
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8956 :com.palletops.awaze.client-builder/undef)
     (.
      bean8954
      setFinalClusterSnapshotIdentifier
      (clojure.core/str v8956))))
   bean8954))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m8958]
  (clojure.core/let
   [bean8957
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v8959 (:cidrip m8958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setCIDRIP (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:cluster-security-group-name
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setClusterSecurityGroupName (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:ec2security-group-name
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setEC2SecurityGroupName (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:ec2security-group-owner-id
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setEC2SecurityGroupOwnerId (clojure.core/str v8959))))
   bean8957))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m8961]
  (clojure.core/let
   [bean8960
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8962
     (:cluster-subnet-group-name
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setClusterSubnetGroupName (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:description m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setDescription (clojure.core/str v8962))))
   (clojure.core/let
    [v8962 (:tags m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9030] (redshift/tag arg9030))
 v8962))))
   (clojure.core/let
    [v8962
     (:subnet-ids m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9031] (clojure.core/str arg9031))
 v8962))))
   bean8960))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m8964]
  (clojure.core/let
   [bean8963
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/let
    [v8965
     (:snapshot-identifier
      m8964
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8965 :com.palletops.awaze.client-builder/undef)
     (. bean8963 setSnapshotIdentifier (clojure.core/str v8965))))
   (clojure.core/let
    [v8965
     (:cluster-identifier
      m8964
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8965 :com.palletops.awaze.client-builder/undef)
     (. bean8963 setClusterIdentifier (clojure.core/str v8965))))
   (clojure.core/let
    [v8965 (:tags m8964 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8965 :com.palletops.awaze.client-builder/undef)
     (.
      bean8963
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9032] (redshift/tag arg9032))
 v8965))))
   bean8963))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateTagsRequest}
create-tags-request
  [m8967]
  (clojure.core/let
   [bean8966
    (new com.amazonaws.services.redshift.model.CreateTagsRequest)]
   (clojure.core/let
    [v8968 (:tags m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9033] (redshift/tag arg9033))
 v8968))))
   (clojure.core/let
    [v8968
     (:resource-name m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setResourceName (clojure.core/str v8968))))
   bean8966))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m8970]
  (clojure.core/let
   [bean8969
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/let
    [v8971
     (:node-type m8970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8971 :com.palletops.awaze.client-builder/undef)
     (. bean8969 setNodeType (clojure.core/str v8971))))
   (clojure.core/let
    [v8971
     (:cluster-version
      m8970
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8971 :com.palletops.awaze.client-builder/undef)
     (. bean8969 setClusterVersion (clojure.core/str v8971))))
   (clojure.core/let
    [v8971 (:marker m8970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8971 :com.palletops.awaze.client-builder/undef)
     (. bean8969 setMarker (clojure.core/str v8971))))
   (clojure.core/let
    [v8971
     (:max-records m8970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8971 :com.palletops.awaze.client-builder/undef)
     (. bean8969 setMaxRecords (clojure.core/int v8971))))
   bean8969))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m8973]
  (clojure.core/let
   [bean8972
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/let
    [v8974
     (:bucket-name m8973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setBucketName (clojure.core/str v8974))))
   (clojure.core/let
    [v8974
     (:cluster-identifier
      m8973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setClusterIdentifier (clojure.core/str v8974))))
   (clojure.core/let
    [v8974
     (:s3key-prefix m8973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setS3KeyPrefix (clojure.core/str v8974))))
   bean8972))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m8976]
  (clojure.core/let
   [bean8975
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/let
    [v8977
     (:snapshot-identifier
      m8976
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8977 :com.palletops.awaze.client-builder/undef)
     (. bean8975 setSnapshotIdentifier (clojure.core/str v8977))))
   (clojure.core/let
    [v8977
     (:snapshot-cluster-identifier
      m8976
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8977 :com.palletops.awaze.client-builder/undef)
     (.
      bean8975
      setSnapshotClusterIdentifier
      (clojure.core/str v8977))))
   (clojure.core/let
    [v8977
     (:account-with-restore-access
      m8976
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8977 :com.palletops.awaze.client-builder/undef)
     (. bean8975 setAccountWithRestoreAccess (clojure.core/str v8977))))
   bean8975))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m8979]
  (clojure.core/let
   [bean8978
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v8980 (:marker m8979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setMarker (clojure.core/str v8980))))
   (clojure.core/let
    [v8980
     (:max-records m8979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setMaxRecords (clojure.core/int v8980))))
   (clojure.core/let
    [v8980
     (:subscription-name
      m8979
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setSubscriptionName (clojure.core/str v8980))))
   bean8978))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m8982]
  (clojure.core/let
   [bean8981
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/let
    [v8983
     (:reserved-node-offering-id
      m8982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setReservedNodeOfferingId (clojure.core/str v8983))))
   (clojure.core/let
    [v8983 (:marker m8982 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setMarker (clojure.core/str v8983))))
   (clojure.core/let
    [v8983
     (:max-records m8982 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setMaxRecords (clojure.core/int v8983))))
   bean8981))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m8985]
  (clojure.core/let
   [bean8984
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/let
    [v8986
     (:hsm-configuration-identifier
      m8985
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8986 :com.palletops.awaze.client-builder/undef)
     (.
      bean8984
      setHsmConfigurationIdentifier
      (clojure.core/str v8986))))
   bean8984))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m8988]
  (clojure.core/let
   [bean8987
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v8989
     (:source-type m8988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (. bean8987 setSourceType (clojure.core/str v8989))))
   (clojure.core/let
    [v8989 (:tags m8988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (.
      bean8987
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9146] (redshift/tag arg9146))
 v8989))))
   (clojure.core/let
    [v8989 (:enabled m8988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (. bean8987 setEnabled (clojure.core/boolean v8989))))
   (clojure.core/let
    [v8989
     (:subscription-name
      m8988
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (. bean8987 setSubscriptionName (clojure.core/str v8989))))
   (clojure.core/let
    [v8989
     (:sns-topic-arn m8988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (. bean8987 setSnsTopicArn (clojure.core/str v8989))))
   (clojure.core/let
    [v8989
     (:source-ids m8988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (.
      bean8987
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9147] (clojure.core/str arg9147))
 v8989))))
   (clojure.core/let
    [v8989
     (:event-categories
      m8988
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (.
      bean8987
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9148] (clojure.core/str arg9148))
 v8989))))
   (clojure.core/let
    [v8989
     (:severity m8988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (. bean8987 setSeverity (clojure.core/str v8989))))
   bean8987))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m9034]
   (clojure.core/let
    [credentials9035 (:credentials m9034) args9036 (:args m9034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9037
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9035)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9037
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args9036 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-resize,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeResize"}
   [credentials9039 & args9040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9041
     (com.palletops.awaze.common/aws-client :redshift credentials9039)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9041
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args9040 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m9042]
   (clojure.core/let
    [credentials9043 (:credentials m9042) args9044 (:args m9042)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9045
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9043)]
     (clojure.core/case
      (clojure.core/count args9044)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9045
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9045
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args9044 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials9047 & args9048]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9049
     (com.palletops.awaze.common/aws-client :redshift credentials9047)]
    (clojure.core/case
     (clojure.core/count args9048)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9049
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9049
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args9048 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m9050]
   (clojure.core/let
    [credentials9051 (:credentials m9050) args9052 (:args m9050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9053
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9051)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9053
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args9052 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials9055 & args9056]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9057
     (com.palletops.awaze.common/aws-client :redshift credentials9055)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9057
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args9056 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m9058]
   (clojure.core/let
    [credentials9059 (:credentials m9058) args9060 (:args m9058)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9061
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9059)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9061
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args9060 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-hsm-client-certificate,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials9063 & args9064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9065
     (com.palletops.awaze.common/aws-client :redshift credentials9063)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9065
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args9064 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m9066]
   (clojure.core/let
    [credentials9067 (:credentials m9066) args9068 (:args m9066)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9069
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9067)]
     (clojure.core/case
      (clojure.core/count args9068)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9069
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9069
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args9068 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cluster-versions,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster-versions,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials9071 & args9072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9073
     (com.palletops.awaze.common/aws-client :redshift credentials9071)]
    (clojure.core/case
     (clojure.core/count args9072)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9073
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9073
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args9072 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m9074]
   (clojure.core/let
    [credentials9075 (:credentials m9074) args9076 (:args m9074)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9077
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9075)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9077
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args9076 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-snapshot-copy,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials9079 & args9080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9081
     (com.palletops.awaze.common/aws-client :redshift credentials9079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9081
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args9080 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-snapshot-copy-grant
   [m9082]
   (clojure.core/let
    [credentials9083 (:credentials m9082) args9084 (:args m9082)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9085
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9083)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9085
       createSnapshotCopyGrant
       (redshift/create-snapshot-copy-grant-request
        (clojure.core/nth args9084 0)))))))
  (clojure.core/defn
   create-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for createSnapshotCopyGrant"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-snapshot-copy-grant,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call createSnapshotCopyGrant"}
   [credentials9087 & args9088]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9089
     (com.palletops.awaze.common/aws-client :redshift credentials9087)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9089
      createSnapshotCopyGrant
      (redshift/create-snapshot-copy-grant-request
       (clojure.core/nth args9088 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m9090]
   (clojure.core/let
    [credentials9091 (:credentials m9090) args9092 (:args m9090)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9093
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9091)]
     (clojure.core/case
      (clojure.core/count args9092)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9093
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9093
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args9092 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials9095 & args9096]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9097
     (com.palletops.awaze.common/aws-client :redshift credentials9095)]
    (clojure.core/case
     (clojure.core/count args9096)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9097
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9097
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args9096 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m9098]
   (clojure.core/let
    [credentials9099 (:credentials m9098) args9100 (:args m9098)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9101
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9099)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9101
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args9100 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials9103 & args9104]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9105
     (com.palletops.awaze.common/aws-client :redshift credentials9103)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9105
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args9104 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m9106]
   (clojure.core/let
    [credentials9107 (:credentials m9106) args9108 (:args m9106)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9109
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9107)]
     (clojure.core/case
      (clojure.core/count args9108)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9109
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args9108 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9109
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9111 & args9112]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9113
     (com.palletops.awaze.common/aws-client :redshift credentials9111)]
    (clojure.core/case
     (clojure.core/count args9112)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9113
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args9112 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9113
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m9114]
   (clojure.core/let
    [credentials9115 (:credentials m9114) args9116 (:args m9114)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9117
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9115)]
     (clojure.core/case
      (clojure.core/count args9116)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9117
        describeReservedNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9117
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args9116 0))))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-nodes,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-nodes,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials9119 & args9120]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9121
     (com.palletops.awaze.common/aws-client :redshift credentials9119)]
    (clojure.core/case
     (clojure.core/count args9120)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9121
       describeReservedNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9121
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args9120 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-iam-roles
   [m9122]
   (clojure.core/let
    [credentials9123 (:credentials m9122) args9124 (:args m9122)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9125
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9123)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9125
       modifyClusterIamRoles
       (redshift/modify-cluster-iam-roles-request
        (clojure.core/nth args9124 0)))))))
  (clojure.core/defn
   modify-cluster-iam-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyClusterIamRoles"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cluster-iam-roles,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-iam-roles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyClusterIamRoles"}
   [credentials9127 & args9128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9129
     (com.palletops.awaze.common/aws-client :redshift credentials9127)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9129
      modifyClusterIamRoles
      (redshift/modify-cluster-iam-roles-request
       (clojure.core/nth args9128 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m9130]
   (clojure.core/let
    [credentials9131 (:credentials m9130) args9132 (:args m9130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9133
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9131)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9133
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args9132 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-event-subscription,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials9135 & args9136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9137
     (com.palletops.awaze.common/aws-client :redshift credentials9135)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9137
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args9136 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m9138]
   (clojure.core/let
    [credentials9139 (:credentials m9138) args9140 (:args m9138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9141
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9139)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9141
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args9140 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reboot-cluster,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCluster"}
   [credentials9143 & args9144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9145
     (com.palletops.awaze.common/aws-client :redshift credentials9143)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9145
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args9144 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m9149]
   (clojure.core/let
    [credentials9150 (:credentials m9149) args9151 (:args m9149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9152
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9152
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args9151 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cluster-security-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials9154 & args9155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9156
     (com.palletops.awaze.common/aws-client :redshift credentials9154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9156
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args9155 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m9157]
   (clojure.core/let
    [credentials9158 (:credentials m9157) args9159 (:args m9157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9160
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9158)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9160
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args9159 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials9162 & args9163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9164
     (com.palletops.awaze.common/aws-client :redshift credentials9162)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9164
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args9163 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m9165]
   (clojure.core/let
    [credentials9166 (:credentials m9165) args9167 (:args m9165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9168
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9168
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args9167 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials9170 & args9171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9172
     (com.palletops.awaze.common/aws-client :redshift credentials9170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9172
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args9171 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-snapshot-copy-grant
   [m9173]
   (clojure.core/let
    [credentials9174 (:credentials m9173) args9175 (:args m9173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9176
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9174)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9176
       deleteSnapshotCopyGrant
       (redshift/delete-snapshot-copy-grant-request
        (clojure.core/nth args9175 0)))))))
  (clojure.core/defn
   delete-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotCopyGrant"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-snapshot-copy-grant,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call deleteSnapshotCopyGrant"}
   [credentials9178 & args9179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9180
     (com.palletops.awaze.common/aws-client :redshift credentials9178)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9180
      deleteSnapshotCopyGrant
      (redshift/delete-snapshot-copy-grant-request
       (clojure.core/nth args9179 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m9181]
   (clojure.core/let
    [credentials9182 (:credentials m9181) args9183 (:args m9181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9184
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9182)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9184
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args9183 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :authorize-snapshot-access,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials9186 & args9187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9188
     (com.palletops.awaze.common/aws-client :redshift credentials9186)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9188
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args9187 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m9189]
   (clojure.core/let
    [credentials9190 (:credentials m9189) args9191 (:args m9189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9192
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9192
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args9191 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-logging,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableLogging"}
   [credentials9194 & args9195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9196
     (com.palletops.awaze.common/aws-client :redshift credentials9194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9196
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args9195 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m9197]
   (clojure.core/let
    [credentials9198 (:credentials m9197) args9199 (:args m9197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9200
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9198)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9200
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args9199 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials9202 & args9203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9204
     (com.palletops.awaze.common/aws-client :redshift credentials9202)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9204
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args9203 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m9205]
   (clojure.core/let
    [credentials9206 (:credentials m9205) args9207 (:args m9205)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9208
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9206)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9208
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args9207 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cluster,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Call modifyCluster"}
   [credentials9210 & args9211]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9212
     (com.palletops.awaze.common/aws-client :redshift credentials9210)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9212
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args9211 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m9213]
   (clojure.core/let
    [credentials9214 (:credentials m9213) args9215 (:args m9213)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9216
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9214)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9216
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args9215 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials9218 & args9219]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9220
     (com.palletops.awaze.common/aws-client :redshift credentials9218)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9220
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args9219 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m9221]
   (clojure.core/let
    [credentials9222 (:credentials m9221) args9223 (:args m9221)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9224
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9222)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9224
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args9223 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials9226 & args9227]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9228
     (com.palletops.awaze.common/aws-client :redshift credentials9226)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9228
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args9227 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m9229]
   (clojure.core/let
    [credentials9230 (:credentials m9229) args9231 (:args m9229)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9232
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9230)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9232
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args9231 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cluster,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Call createCluster"}
   [credentials9234 & args9235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9236
     (com.palletops.awaze.common/aws-client :redshift credentials9234)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9236
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args9235 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m9237]
   (clojure.core/let
    [credentials9238 (:credentials m9237) args9239 (:args m9237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9240
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9238)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9240
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args9239 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-logging-status,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials9242 & args9243]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9244
     (com.palletops.awaze.common/aws-client :redshift credentials9242)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9244
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args9243 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-table-restore-status
   [m9245]
   (clojure.core/let
    [credentials9246 (:credentials m9245) args9247 (:args m9245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9248
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9246)]
     (clojure.core/case
      (clojure.core/count args9247)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9248
        describeTableRestoreStatus
        (redshift/describe-table-restore-status-request
         (clojure.core/nth args9247 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9248
        describeTableRestoreStatus))))))
  (clojure.core/defn
   describe-table-restore-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]
                [credentials]]),
    :doc "Generate map for describeTableRestoreStatus, describeTableRestoreStatus"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-table-restore-status,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-table-restore-status,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-table-restore-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]
                [credentials]]),
    :doc "Call describeTableRestoreStatus, describeTableRestoreStatus"}
   [credentials9250 & args9251]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9252
     (com.palletops.awaze.common/aws-client :redshift credentials9250)]
    (clojure.core/case
     (clojure.core/count args9251)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9252
       describeTableRestoreStatus
       (redshift/describe-table-restore-status-request
        (clojure.core/nth args9251 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9252
       describeTableRestoreStatus))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m9253]
   (clojure.core/let
    [credentials9254 (:credentials m9253) args9255 (:args m9253)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9256
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9254)]
     (clojure.core/case
      (clojure.core/count args9255)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9256
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9256
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args9255 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-event-categories,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-event-categories,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials9258 & args9259]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9260
     (com.palletops.awaze.common/aws-client :redshift credentials9258)]
    (clojure.core/case
     (clojure.core/count args9259)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9260
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9260
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args9259 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m9261]
   (clojure.core/let
    [credentials9262 (:credentials m9261) args9263 (:args m9261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9264
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9262)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9264
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args9263 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameters,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameters"}
   [credentials9266 & args9267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9268
     (com.palletops.awaze.common/aws-client :redshift credentials9266)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9268
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args9267 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m9269]
   (clojure.core/let
    [credentials9270 (:credentials m9269) args9271 (:args m9269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9272
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9270)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9272
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args9271 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials9274 & args9275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9276
     (com.palletops.awaze.common/aws-client :redshift credentials9274)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9276
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args9275 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m9277]
   (clojure.core/let
    [credentials9278 (:credentials m9277) args9279 (:args m9277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9280
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9278)]
     (clojure.core/case
      (clojure.core/count args9279)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9280
        describeClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9280
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args9279 0))))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-clusters,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-clusters,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials9282 & args9283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9284
     (com.palletops.awaze.common/aws-client :redshift credentials9282)]
    (clojure.core/case
     (clojure.core/count args9283)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9284
       describeClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9284
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args9283 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m9285]
   (clojure.core/let
    [credentials9286 (:credentials m9285) args9287 (:args m9285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9288
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9286)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9288
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args9287 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials9290 & args9291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9292
     (com.palletops.awaze.common/aws-client :redshift credentials9290)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9292
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args9291 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m9293]
   (clojure.core/let
    [credentials9294 (:credentials m9293) args9295 (:args m9293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9296
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9294)]
     (clojure.core/case
      (clojure.core/count args9295)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9296
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9296
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args9295 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials9298 & args9299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9300
     (com.palletops.awaze.common/aws-client :redshift credentials9298)]
    (clojure.core/case
     (clojure.core/count args9299)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9300
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9300
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args9299 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-tags
   [m9301]
   (clojure.core/let
    [credentials9302 (:credentials m9301) args9303 (:args m9301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9304
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9302)]
     (clojure.core/case
      (clojure.core/count args9303)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9304
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9304
        describeTags
        (redshift/describe-tags-request (clojure.core/nth args9303 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials9306 & args9307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9308
     (com.palletops.awaze.common/aws-client :redshift credentials9306)]
    (clojure.core/case
     (clojure.core/count args9307)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9308
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9308
       describeTags
       (redshift/describe-tags-request (clojure.core/nth args9307 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m9309]
   (clojure.core/let
    [credentials9310 (:credentials m9309) args9311 (:args m9309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9312
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9310)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9312
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args9311 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-snapshot-copy,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials9314 & args9315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9316
     (com.palletops.awaze.common/aws-client :redshift credentials9314)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9316
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args9315 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-tags
   [m9317]
   (clojure.core/let
    [credentials9318 (:credentials m9317) args9319 (:args m9317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9320
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9320
       deleteTags
       (redshift/delete-tags-request (clojure.core/nth args9319 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials9322 & args9323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9324
     (com.palletops.awaze.common/aws-client :redshift credentials9322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9324
      deleteTags
      (redshift/delete-tags-request (clojure.core/nth args9323 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m9325]
   (clojure.core/let
    [credentials9326 (:credentials m9325) args9327 (:args m9325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9328
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9328
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args9327 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials9330 & args9331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9332
     (com.palletops.awaze.common/aws-client :redshift credentials9330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9332
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args9331 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m9333]
   (clojure.core/let
    [credentials9334 (:credentials m9333) args9335 (:args m9333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9336
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9336
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args9335 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cluster-snapshot,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials9338 & args9339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9340
     (com.palletops.awaze.common/aws-client :redshift credentials9338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9340
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args9339 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m9341]
   (clojure.core/let
    [credentials9342 (:credentials m9341) args9343 (:args m9341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9344
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9344
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args9343 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cluster-parameter-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials9346 & args9347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9348
     (com.palletops.awaze.common/aws-client :redshift credentials9346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9348
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args9347 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m9349]
   (clojure.core/let
    [credentials9350 (:credentials m9349) args9351 (:args m9349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9352
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9352
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args9351 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :rotate-encryption-key,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials9354 & args9355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9356
     (com.palletops.awaze.common/aws-client :redshift credentials9354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9356
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args9355 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m9357]
   (clojure.core/let
    [credentials9358 (:credentials m9357) args9359 (:args m9357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9360
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9358)]
     (clojure.core/case
      (clojure.core/count args9359)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9360
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9360
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args9359 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials9362 & args9363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9364
     (com.palletops.awaze.common/aws-client :redshift credentials9362)]
    (clojure.core/case
     (clojure.core/count args9363)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9364
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9364
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args9363 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-snapshot-copy-grants
   [m9365]
   (clojure.core/let
    [credentials9366 (:credentials m9365) args9367 (:args m9365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9368
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9366)]
     (clojure.core/case
      (clojure.core/count args9367)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9368
        describeSnapshotCopyGrants
        (redshift/describe-snapshot-copy-grants-request
         (clojure.core/nth args9367 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9368
        describeSnapshotCopyGrants))))))
  (clojure.core/defn
   describe-snapshot-copy-grants-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-snapshot-copy-grants
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   [credentials9370 & args9371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9372
     (com.palletops.awaze.common/aws-client :redshift credentials9370)]
    (clojure.core/case
     (clojure.core/count args9371)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9372
       describeSnapshotCopyGrants
       (redshift/describe-snapshot-copy-grants-request
        (clojure.core/nth args9371 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9372
       describeSnapshotCopyGrants))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m9373]
   (clojure.core/let
    [credentials9374 (:credentials m9373) args9375 (:args m9373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9376
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9374)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9376
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args9375 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials9378 & args9379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9380
     (com.palletops.awaze.common/aws-client :redshift credentials9378)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9380
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args9379 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m9381]
   (clojure.core/let
    [credentials9382 (:credentials m9381) args9383 (:args m9381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9384
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9382)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9384
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args9383 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cluster-security-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials9386 & args9387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9388
     (com.palletops.awaze.common/aws-client :redshift credentials9386)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9388
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args9387 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m9389]
   (clojure.core/let
    [credentials9390 (:credentials m9389) args9391 (:args m9389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9392
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9390)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9392
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args9391 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :copy-cluster-snapshot,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials9394 & args9395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9396
     (com.palletops.awaze.common/aws-client :redshift credentials9394)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9396
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args9395 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-table-from-cluster-snapshot
   [m9397]
   (clojure.core/let
    [credentials9398 (:credentials m9397) args9399 (:args m9397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9400
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9398)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9400
       restoreTableFromClusterSnapshot
       (redshift/restore-table-from-cluster-snapshot-request
        (clojure.core/nth args9399 0)))))))
  (clojure.core/defn
   restore-table-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Generate map for restoreTableFromClusterSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :restore-table-from-cluster-snapshot,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-table-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Call restoreTableFromClusterSnapshot"}
   [credentials9402 & args9403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9404
     (com.palletops.awaze.common/aws-client :redshift credentials9402)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9404
      restoreTableFromClusterSnapshot
      (redshift/restore-table-from-cluster-snapshot-request
       (clojure.core/nth args9403 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m9405]
   (clojure.core/let
    [credentials9406 (:credentials m9405) args9407 (:args m9405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9408
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9406)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9408
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args9407 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-event-subscription,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials9410 & args9411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9412
     (com.palletops.awaze.common/aws-client :redshift credentials9410)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9412
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args9411 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m9413]
   (clojure.core/let
    [credentials9414 (:credentials m9413) args9415 (:args m9413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9416
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9414)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9416
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args9415 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-hsm-configuration,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials9418 & args9419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9420
     (com.palletops.awaze.common/aws-client :redshift credentials9418)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9420
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args9419 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m9421]
   (clojure.core/let
    [credentials9422 (:credentials m9421) args9423 (:args m9421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9424
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9422)]
     (clojure.core/case
      (clojure.core/count args9423)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9424
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args9423 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9424
        describeHsmConfigurations))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-hsm-configurations,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-hsm-configurations,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials9426 & args9427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9428
     (com.palletops.awaze.common/aws-client :redshift credentials9426)]
    (clojure.core/case
     (clojure.core/count args9427)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9428
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args9427 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9428
       describeHsmConfigurations))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m9429]
   (clojure.core/let
    [credentials9430 (:credentials m9429) args9431 (:args m9429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9432
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9430)]
     (clojure.core/case
      (clojure.core/count args9431)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9432
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args9431 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9432
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials9434 & args9435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9436
     (com.palletops.awaze.common/aws-client :redshift credentials9434)]
    (clojure.core/case
     (clojure.core/count args9435)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9436
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args9435 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9436
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m9437]
   (clojure.core/let
    [credentials9438 (:credentials m9437) args9439 (:args m9437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9440
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9440
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args9439 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cluster,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCluster"}
   [credentials9442 & args9443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9444
     (com.palletops.awaze.common/aws-client :redshift credentials9442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9444
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args9443 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m9445]
   (clojure.core/let
    [credentials9446 (:credentials m9445) args9447 (:args m9445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9448
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9446)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9448
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args9447 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials9450 & args9451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9452
     (com.palletops.awaze.common/aws-client :redshift credentials9450)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9452
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args9451 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m9453]
   (clojure.core/let
    [credentials9454 (:credentials m9453) args9455 (:args m9453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9456
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9454)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9456
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args9455 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cluster-subnet-group,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials9458 & args9459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9460
     (com.palletops.awaze.common/aws-client :redshift credentials9458)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9460
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args9459 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m9461]
   (clojure.core/let
    [credentials9462 (:credentials m9461) args9463 (:args m9461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9464
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9462)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9464
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args9463 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cluster-snapshot,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials9466 & args9467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9468
     (com.palletops.awaze.common/aws-client :redshift credentials9466)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9468
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args9467 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-tags
   [m9469]
   (clojure.core/let
    [credentials9470 (:credentials m9469) args9471 (:args m9469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9472
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9470)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9472
       createTags
       (redshift/create-tags-request (clojure.core/nth args9471 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials9474 & args9475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9476
     (com.palletops.awaze.common/aws-client :redshift credentials9474)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9476
      createTags
      (redshift/create-tags-request (clojure.core/nth args9475 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m9477]
   (clojure.core/let
    [credentials9478 (:credentials m9477) args9479 (:args m9477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9480
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9478)]
     (clojure.core/case
      (clojure.core/count args9479)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9480
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9480
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args9479 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials9482 & args9483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9484
     (com.palletops.awaze.common/aws-client :redshift credentials9482)]
    (clojure.core/case
     (clojure.core/count args9483)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9484
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9484
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args9483 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m9485]
   (clojure.core/let
    [credentials9486 (:credentials m9485) args9487 (:args m9485)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9488
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9486)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9488
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args9487 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-logging,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call enableLogging"}
   [credentials9490 & args9491]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9492
     (com.palletops.awaze.common/aws-client :redshift credentials9490)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9492
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args9491 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m9493]
   (clojure.core/let
    [credentials9494 (:credentials m9493) args9495 (:args m9493)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9496
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9494)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9496
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args9495 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :revoke-snapshot-access,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials9498 & args9499]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9500
     (com.palletops.awaze.common/aws-client :redshift credentials9498)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9500
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args9499 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m9501]
   (clojure.core/let
    [credentials9502 (:credentials m9501) args9503 (:args m9501)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9504
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9502)]
     (clojure.core/case
      (clojure.core/count args9503)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9504
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9504
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args9503 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-event-subscriptions,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-event-subscriptions,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials9506 & args9507]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9508
     (com.palletops.awaze.common/aws-client :redshift credentials9506)]
    (clojure.core/case
     (clojure.core/count args9507)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9508
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9508
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args9507 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m9509]
   (clojure.core/let
    [credentials9510 (:credentials m9509) args9511 (:args m9509)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9512
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9510)]
     (clojure.core/case
      (clojure.core/count args9511)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9512
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args9511 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9512
        describeReservedNodeOfferings))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1784__auto__,
     :client :redshift})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials9514 & args9515]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9516
     (com.palletops.awaze.common/aws-client :redshift credentials9514)]
    (clojure.core/case
     (clojure.core/count args9515)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9516
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args9515 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9516
       describeReservedNodeOfferings))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m9517]
   (clojure.core/let
    [credentials9518 (:credentials m9517) args9519 (:args m9517)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9520
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9518)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9520
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args9519 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-hsm-configuration,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials9522 & args9523]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9524
     (com.palletops.awaze.common/aws-client :redshift credentials9522)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9524
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args9523 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m9525]
   (clojure.core/let
    [credentials9526 (:credentials m9525) args9527 (:args m9525)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9528
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9526)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9528
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args9527 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-event-subscription,
     :credentials credentials__1784__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call createEventSubscription"}
   [credentials9530 & args9531]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9532
     (com.palletops.awaze.common/aws-client :redshift credentials9530)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9532
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args9531 0))))))))
