(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1734__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m12249]
   (clojure.core/let
    [credentials12250 (:credentials m12249) args12251 (:args m12249)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12252
      (com.palletops.awaze.common/aws-client :iam credentials12250)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12252
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args12251 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-groups-for-user,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupsForUser"}
   [credentials12254 & args12255]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12256
     (com.palletops.awaze.common/aws-client :iam credentials12254)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12256
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args12255 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m12257]
   (clojure.core/let
    [credentials12258 (:credentials m12257) args12259 (:args m12257)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12260
      (com.palletops.awaze.common/aws-client :iam credentials12258)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12260
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args12259 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-user,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createUser"}
   [credentials12262 & args12263]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12264
     (com.palletops.awaze.common/aws-client :iam credentials12262)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12264
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args12263 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-credential-report
   [m12265]
   (clojure.core/let
    [credentials12266 (:credentials m12265) args12267 (:args m12265)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12268
      (com.palletops.awaze.common/aws-client :iam credentials12266)]
     (clojure.core/case
      (clojure.core/count args12267)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12268
        getCredentialReport
        (identitymanagement/get-credential-report-request
         (clojure.core/nth args12267 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12268
        getCredentialReport))))))
  (clojure.core/defn
   get-credential-report-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getCredentialReport, getCredentialReport"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-credential-report,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-credential-report,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-credential-report
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getCredentialReport, getCredentialReport"}
   [credentials12270 & args12271]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12272
     (com.palletops.awaze.common/aws-client :iam credentials12270)]
    (clojure.core/case
     (clojure.core/count args12271)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12272
       getCredentialReport
       (identitymanagement/get-credential-report-request
        (clojure.core/nth args12271 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12272
       getCredentialReport))))))
 (do
  (clojure.core/defmethod
   iam
   :get-open-idconnect-provider
   [m12273]
   (clojure.core/let
    [credentials12274 (:credentials m12273) args12275 (:args m12273)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12276
      (com.palletops.awaze.common/aws-client :iam credentials12274)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12276
       getOpenIDConnectProvider
       (identitymanagement/get-open-idconnect-provider-request
        (clojure.core/nth args12275 0)))))))
  (clojure.core/defn
   get-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getOpenIDConnectProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-open-idconnect-provider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getOpenIDConnectProvider"}
   [credentials12278 & args12279]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12280
     (com.palletops.awaze.common/aws-client :iam credentials12278)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12280
      getOpenIDConnectProvider
      (identitymanagement/get-open-idconnect-provider-request
       (clojure.core/nth args12279 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m12281]
   (clojure.core/let
    [credentials12282 (:credentials m12281) args12283 (:args m12281)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12284
      (com.palletops.awaze.common/aws-client :iam credentials12282)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12284
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args12283 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-signing-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials12286 & args12287]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12288
     (com.palletops.awaze.common/aws-client :iam credentials12286)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12288
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args12287 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m12289]
   (clojure.core/let
    [credentials12290 (:credentials m12289) args12291 (:args m12289)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12292
      (com.palletops.awaze.common/aws-client :iam credentials12290)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12292
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args12291 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :change-password,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Call changePassword"}
   [credentials12294 & args12295]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12296
     (com.palletops.awaze.common/aws-client :iam credentials12294)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12296
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args12295 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m12297]
   (clojure.core/let
    [credentials12298 (:credentials m12297) args12299 (:args m12297)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12300
      (com.palletops.awaze.common/aws-client :iam credentials12298)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12300
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args12299 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials12302 & args12303]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12304
     (com.palletops.awaze.common/aws-client :iam credentials12302)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12304
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args12303 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m12305]
   (clojure.core/let
    [credentials12306 (:credentials m12305) args12307 (:args m12305)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12308
      (com.palletops.awaze.common/aws-client :iam credentials12306)]
     (clojure.core/case
      (clojure.core/count args12307)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12308
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args12307 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12308
        listInstanceProfiles))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-instance-profiles,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-instance-profiles,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials12310 & args12311]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12312
     (com.palletops.awaze.common/aws-client :iam credentials12310)]
    (clojure.core/case
     (clojure.core/count args12311)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12312
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args12311 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12312
       listInstanceProfiles))))))
 (do
  (clojure.core/defmethod
   iam
   :set-default-policy-version
   [m12313]
   (clojure.core/let
    [credentials12314 (:credentials m12313) args12315 (:args m12313)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12316
      (com.palletops.awaze.common/aws-client :iam credentials12314)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12316
       setDefaultPolicyVersion
       (identitymanagement/set-default-policy-version-request
        (clojure.core/nth args12315 0)))))))
  (clojure.core/defn
   set-default-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDefaultPolicyVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-default-policy-version,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   set-default-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call setDefaultPolicyVersion"}
   [credentials12318 & args12319]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12320
     (com.palletops.awaze.common/aws-client :iam credentials12318)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12320
      setDefaultPolicyVersion
      (identitymanagement/set-default-policy-version-request
       (clojure.core/nth args12319 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m12321]
   (clojure.core/let
    [credentials12322 (:credentials m12321) args12323 (:args m12321)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12324
      (com.palletops.awaze.common/aws-client :iam credentials12322)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12324
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args12323 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-user-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials12326 & args12327]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12328
     (com.palletops.awaze.common/aws-client :iam credentials12326)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12328
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args12327 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-access-key-last-used
   [m12329]
   (clojure.core/let
    [credentials12330 (:credentials m12329) args12331 (:args m12329)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12332
      (com.palletops.awaze.common/aws-client :iam credentials12330)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12332
       getAccessKeyLastUsed
       (identitymanagement/get-access-key-last-used-request
        (clojure.core/nth args12331 0)))))))
  (clojure.core/defn
   get-access-key-last-used-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for getAccessKeyLastUsed"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-access-key-last-used,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-access-key-last-used
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call getAccessKeyLastUsed"}
   [credentials12334 & args12335]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12336
     (com.palletops.awaze.common/aws-client :iam credentials12334)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12336
      getAccessKeyLastUsed
      (identitymanagement/get-access-key-last-used-request
       (clojure.core/nth args12335 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-group-policy
   [m12337]
   (clojure.core/let
    [credentials12338 (:credentials m12337) args12339 (:args m12337)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12340
      (com.palletops.awaze.common/aws-client :iam credentials12338)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12340
       attachGroupPolicy
       (identitymanagement/attach-group-policy-request
        (clojure.core/nth args12339 0)))))))
  (clojure.core/defn
   attach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachGroupPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-group-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachGroupPolicy"}
   [credentials12342 & args12343]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12344
     (com.palletops.awaze.common/aws-client :iam credentials12342)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12344
      attachGroupPolicy
      (identitymanagement/attach-group-policy-request
       (clojure.core/nth args12343 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m12345]
   (clojure.core/let
    [credentials12346 (:credentials m12345) args12347 (:args m12345)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12348
      (com.palletops.awaze.common/aws-client :iam credentials12346)]
     (clojure.core/case
      (clojure.core/count args12347)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12348
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args12347 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12348
        getUser))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-user,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-user,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getUser, getUser"}
   [credentials12350 & args12351]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12352
     (com.palletops.awaze.common/aws-client :iam credentials12350)]
    (clojure.core/case
     (clojure.core/count args12351)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12352
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args12351 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12352
       getUser))))))
 (do
  (clojure.core/defmethod
   iam
   :generate-credential-report
   [m12353]
   (clojure.core/let
    [credentials12354 (:credentials m12353) args12355 (:args m12353)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12356
      (com.palletops.awaze.common/aws-client :iam credentials12354)]
     (clojure.core/case
      (clojure.core/count args12355)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12356
        generateCredentialReport
        (identitymanagement/generate-credential-report-request
         (clojure.core/nth args12355 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12356
        generateCredentialReport))))))
  (clojure.core/defn
   generate-credential-report-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for generateCredentialReport, generateCredentialReport"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :generate-credential-report,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :generate-credential-report,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   generate-credential-report
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call generateCredentialReport, generateCredentialReport"}
   [credentials12358 & args12359]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12360
     (com.palletops.awaze.common/aws-client :iam credentials12358)]
    (clojure.core/case
     (clojure.core/count args12359)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12360
       generateCredentialReport
       (identitymanagement/generate-credential-report-request
        (clojure.core/nth args12359 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12360
       generateCredentialReport))))))
 (do
  (clojure.core/defmethod
   iam
   :get-sshpublic-key
   [m12361]
   (clojure.core/let
    [credentials12362 (:credentials m12361) args12363 (:args m12361)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12364
      (com.palletops.awaze.common/aws-client :iam credentials12362)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12364
       getSSHPublicKey
       (identitymanagement/get-sshpublic-key-request
        (clojure.core/nth args12363 0)))))))
  (clojure.core/defn
   get-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSSHPublicKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-sshpublic-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSSHPublicKey"}
   [credentials12366 & args12367]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12368
     (com.palletops.awaze.common/aws-client :iam credentials12366)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12368
      getSSHPublicKey
      (identitymanagement/get-sshpublic-key-request
       (clojure.core/nth args12367 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m12369]
   (clojure.core/let
    [credentials12370 (:credentials m12369) args12371 (:args m12369)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12372
      (com.palletops.awaze.common/aws-client :iam credentials12370)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12372
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args12371 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-account-alias,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call createAccountAlias"}
   [credentials12374 & args12375]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12376
     (com.palletops.awaze.common/aws-client :iam credentials12374)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12376
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args12375 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m12377]
   (clojure.core/let
    [credentials12378 (:credentials m12377) args12379 (:args m12377)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12380
      (com.palletops.awaze.common/aws-client :iam credentials12378)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12380
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args12379 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-samlprovider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSAMLProvider"}
   [credentials12382 & args12383]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12384
     (com.palletops.awaze.common/aws-client :iam credentials12382)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12384
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args12383 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy-version
   [m12385]
   (clojure.core/let
    [credentials12386 (:credentials m12385) args12387 (:args m12385)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12388
      (com.palletops.awaze.common/aws-client :iam credentials12386)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12388
       getPolicyVersion
       (identitymanagement/get-policy-version-request
        (clojure.core/nth args12387 0)))))))
  (clojure.core/defn
   get-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicyVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-policy-version,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicyVersion"}
   [credentials12390 & args12391]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12392
     (com.palletops.awaze.common/aws-client :iam credentials12390)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12392
      getPolicyVersion
      (identitymanagement/get-policy-version-request
       (clojure.core/nth args12391 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m12393]
   (clojure.core/let
    [credentials12394 (:credentials m12393) args12395 (:args m12393)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12396
      (com.palletops.awaze.common/aws-client :iam credentials12394)]
     (clojure.core/case
      (clojure.core/count args12395)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12396
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args12395 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12396
        listMFADevices))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-mfadevices,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-mfadevices,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials12398 & args12399]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12400
     (com.palletops.awaze.common/aws-client :iam credentials12398)]
    (clojure.core/case
     (clojure.core/count args12399)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12400
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args12399 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12400
       listMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m12401]
   (clojure.core/let
    [credentials12402 (:credentials m12401) args12403 (:args m12401)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12404
      (com.palletops.awaze.common/aws-client :iam credentials12402)]
     (clojure.core/case
      (clojure.core/count args12403)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12404
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args12403 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12404
        listServerCertificates))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-server-certificates,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-server-certificates,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials12406 & args12407]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12408
     (com.palletops.awaze.common/aws-client :iam credentials12406)]
    (clojure.core/case
     (clojure.core/count args12407)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12408
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args12407 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12408
       listServerCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m12409]
   (clojure.core/let
    [credentials12410 (:credentials m12409) args12411 (:args m12409)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12412
      (com.palletops.awaze.common/aws-client :iam credentials12410)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12412
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args12411 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-group-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putGroupPolicy"}
   [credentials12414 & args12415]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12416
     (com.palletops.awaze.common/aws-client :iam credentials12414)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12416
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args12415 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-authorization-details
   [m12417]
   (clojure.core/let
    [credentials12418 (:credentials m12417) args12419 (:args m12417)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12420
      (com.palletops.awaze.common/aws-client :iam credentials12418)]
     (clojure.core/case
      (clojure.core/count args12419)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12420
        getAccountAuthorizationDetails
        (identitymanagement/get-account-authorization-details-request
         (clojure.core/nth args12419 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12420
        getAccountAuthorizationDetails))))))
  (clojure.core/defn
   get-account-authorization-details-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-account-authorization-details,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-account-authorization-details,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-authorization-details
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   [credentials12422 & args12423]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12424
     (com.palletops.awaze.common/aws-client :iam credentials12422)]
    (clojure.core/case
     (clojure.core/count args12423)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12424
       getAccountAuthorizationDetails
       (identitymanagement/get-account-authorization-details-request
        (clojure.core/nth args12423 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12424
       getAccountAuthorizationDetails))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m12425]
   (clojure.core/let
    [credentials12426 (:credentials m12425) args12427 (:args m12425)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12428
      (com.palletops.awaze.common/aws-client :iam credentials12426)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12428
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args12427 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-group-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials12430 & args12431]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12432
     (com.palletops.awaze.common/aws-client :iam credentials12430)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12432
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args12431 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-open-idconnect-providers
   [m12433]
   (clojure.core/let
    [credentials12434 (:credentials m12433) args12435 (:args m12433)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12436
      (com.palletops.awaze.common/aws-client :iam credentials12434)]
     (clojure.core/case
      (clojure.core/count args12435)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12436
        listOpenIDConnectProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12436
        listOpenIDConnectProviders
        (identitymanagement/list-open-idconnect-providers-request
         (clojure.core/nth args12435 0))))))))
  (clojure.core/defn
   list-open-idconnect-providers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listOpenIDConnectProviders, listOpenIDConnectProviders"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-open-idconnect-providers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listOpenIDConnectProviders, listOpenIDConnectProviders"}
   [credentials12438 & args12439]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12440
     (com.palletops.awaze.common/aws-client :iam credentials12438)]
    (clojure.core/case
     (clojure.core/count args12439)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12440
       listOpenIDConnectProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12440
       listOpenIDConnectProviders
       (identitymanagement/list-open-idconnect-providers-request
        (clojure.core/nth args12439 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m12441]
   (clojure.core/let
    [credentials12442 (:credentials m12441) args12443 (:args m12441)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12444
      (com.palletops.awaze.common/aws-client :iam credentials12442)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12444
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args12443 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-role-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRolePolicies"}
   [credentials12446 & args12447]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12448
     (com.palletops.awaze.common/aws-client :iam credentials12446)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12448
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args12447 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m12449]
   (clojure.core/let
    [credentials12450 (:credentials m12449) args12451 (:args m12449)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12452
      (com.palletops.awaze.common/aws-client :iam credentials12450)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12452
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args12451 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-account-password-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials12454 & args12455]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12456
     (com.palletops.awaze.common/aws-client :iam credentials12454)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12456
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args12455 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m12457]
   (clojure.core/let
    [credentials12458 (:credentials m12457) args12459 (:args m12457)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12460
      (com.palletops.awaze.common/aws-client :iam credentials12458)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12460
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args12459 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-user-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putUserPolicy"}
   [credentials12462 & args12463]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12464
     (com.palletops.awaze.common/aws-client :iam credentials12462)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12464
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args12463 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m12465]
   (clojure.core/let
    [credentials12466 (:credentials m12465) args12467 (:args m12465)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12468
      (com.palletops.awaze.common/aws-client :iam credentials12466)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12468
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args12467 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-assume-role-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials12470 & args12471]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12472
     (com.palletops.awaze.common/aws-client :iam credentials12470)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12472
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args12471 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy
   [m12473]
   (clojure.core/let
    [credentials12474 (:credentials m12473) args12475 (:args m12473)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12476
      (com.palletops.awaze.common/aws-client :iam credentials12474)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12476
       getPolicy
       (identitymanagement/get-policy-request
        (clojure.core/nth args12475 0)))))))
  (clojure.core/defn
   get-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicy"}
   [credentials12478 & args12479]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12480
     (com.palletops.awaze.common/aws-client :iam credentials12478)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12480
      getPolicy
      (identitymanagement/get-policy-request
       (clojure.core/nth args12479 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m12481]
   (clojure.core/let
    [credentials12482 (:credentials m12481) args12483 (:args m12481)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12484
      (com.palletops.awaze.common/aws-client :iam credentials12482)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12484
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args12483 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-user,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateUser"}
   [credentials12486 & args12487]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12488
     (com.palletops.awaze.common/aws-client :iam credentials12486)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12488
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args12487 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m12489]
   (clojure.core/let
    [credentials12490 (:credentials m12489) args12491 (:args m12489)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12492
      (com.palletops.awaze.common/aws-client :iam credentials12490)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12492
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args12491 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-role-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRolePolicy"}
   [credentials12494 & args12495]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12496
     (com.palletops.awaze.common/aws-client :iam credentials12494)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12496
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args12495 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m12497]
   (clojure.core/let
    [credentials12498 (:credentials m12497) args12499 (:args m12497)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12500
      (com.palletops.awaze.common/aws-client :iam credentials12498)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12500
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args12499 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-group,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroup"}
   [credentials12502 & args12503]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12504
     (com.palletops.awaze.common/aws-client :iam credentials12502)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12504
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args12503 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m12505]
   (clojure.core/let
    [credentials12506 (:credentials m12505) args12507 (:args m12505)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12508
      (com.palletops.awaze.common/aws-client :iam credentials12506)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12508
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args12507 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-login-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getLoginProfile"}
   [credentials12510 & args12511]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12512
     (com.palletops.awaze.common/aws-client :iam credentials12510)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12512
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args12511 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m12513]
   (clojure.core/let
    [credentials12514 (:credentials m12513) args12515 (:args m12513)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12516
      (com.palletops.awaze.common/aws-client :iam credentials12514)]
     (clojure.core/case
      (clojure.core/count args12515)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12516
        listSAMLProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12516
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args12515 0))))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-samlproviders,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-samlproviders,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials12518 & args12519]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12520
     (com.palletops.awaze.common/aws-client :iam credentials12518)]
    (clojure.core/case
     (clojure.core/count args12519)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12520
       listSAMLProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12520
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args12519 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m12521]
   (clojure.core/let
    [credentials12522 (:credentials m12521) args12523 (:args m12521)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12524
      (com.palletops.awaze.common/aws-client :iam credentials12522)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12524
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args12523 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-role,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRole"}
   [credentials12526 & args12527]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12528
     (com.palletops.awaze.common/aws-client :iam credentials12526)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12528
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args12527 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-group-policies
   [m12529]
   (clojure.core/let
    [credentials12530 (:credentials m12529) args12531 (:args m12529)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12532
      (com.palletops.awaze.common/aws-client :iam credentials12530)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12532
       listAttachedGroupPolicies
       (identitymanagement/list-attached-group-policies-request
        (clojure.core/nth args12531 0)))))))
  (clojure.core/defn
   list-attached-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedGroupPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-attached-group-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedGroupPolicies"}
   [credentials12534 & args12535]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12536
     (com.palletops.awaze.common/aws-client :iam credentials12534)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12536
      listAttachedGroupPolicies
      (identitymanagement/list-attached-group-policies-request
       (clojure.core/nth args12535 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m12537]
   (clojure.core/let
    [credentials12538 (:credentials m12537) args12539 (:args m12537)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12540
      (com.palletops.awaze.common/aws-client :iam credentials12538)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12540
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args12539 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-access-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call deleteAccessKey"}
   [credentials12542 & args12543]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12544
     (com.palletops.awaze.common/aws-client :iam credentials12542)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12544
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args12543 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m12545]
   (clojure.core/let
    [credentials12546 (:credentials m12545) args12547 (:args m12545)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12548
      (com.palletops.awaze.common/aws-client :iam credentials12546)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12548
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args12547 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-group,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroup"}
   [credentials12550 & args12551]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12552
     (com.palletops.awaze.common/aws-client :iam credentials12550)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12552
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args12551 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m12553]
   (clojure.core/let
    [credentials12554 (:credentials m12553) args12555 (:args m12553)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12556
      (com.palletops.awaze.common/aws-client :iam credentials12554)]
     (clojure.core/case
      (clojure.core/count args12555)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12556
        deleteAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12556
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args12555 0))))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :delete-account-password-policy,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-account-password-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials12558 & args12559]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12560
     (com.palletops.awaze.common/aws-client :iam credentials12558)]
    (clojure.core/case
     (clojure.core/count args12559)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12560
       deleteAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12560
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args12559 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m12561]
   (clojure.core/let
    [credentials12562 (:credentials m12561) args12563 (:args m12561)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12564
      (com.palletops.awaze.common/aws-client :iam credentials12562)]
     (clojure.core/case
      (clojure.core/count args12563)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12564
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12564
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args12563 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-account-summary,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-account-summary,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials12566 & args12567]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12568
     (com.palletops.awaze.common/aws-client :iam credentials12566)]
    (clojure.core/case
     (clojure.core/count args12567)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12568
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12568
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args12567 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy
   [m12569]
   (clojure.core/let
    [credentials12570 (:credentials m12569) args12571 (:args m12569)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12572
      (com.palletops.awaze.common/aws-client :iam credentials12570)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12572
       deletePolicy
       (identitymanagement/delete-policy-request
        (clojure.core/nth args12571 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicy"}
   [credentials12574 & args12575]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12576
     (com.palletops.awaze.common/aws-client :iam credentials12574)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12576
      deletePolicy
      (identitymanagement/delete-policy-request
       (clojure.core/nth args12575 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m12577]
   (clojure.core/let
    [credentials12578 (:credentials m12577) args12579 (:args m12577)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12580
      (com.palletops.awaze.common/aws-client :iam credentials12578)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12580
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args12579 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-group,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createGroup"}
   [credentials12582 & args12583]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12584
     (com.palletops.awaze.common/aws-client :iam credentials12582)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12584
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args12583 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m12585]
   (clojure.core/let
    [credentials12586 (:credentials m12585) args12587 (:args m12585)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12588
      (com.palletops.awaze.common/aws-client :iam credentials12586)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12588
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args12587 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-role,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRole"}
   [credentials12590 & args12591]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12592
     (com.palletops.awaze.common/aws-client :iam credentials12590)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12592
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args12591 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policy-versions
   [m12593]
   (clojure.core/let
    [credentials12594 (:credentials m12593) args12595 (:args m12593)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12596
      (com.palletops.awaze.common/aws-client :iam credentials12594)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12596
       listPolicyVersions
       (identitymanagement/list-policy-versions-request
        (clojure.core/nth args12595 0)))))))
  (clojure.core/defn
   list-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicyVersions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-policy-versions,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicyVersions"}
   [credentials12598 & args12599]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12600
     (com.palletops.awaze.common/aws-client :iam credentials12598)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12600
      listPolicyVersions
      (identitymanagement/list-policy-versions-request
       (clojure.core/nth args12599 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m12601]
   (clojure.core/let
    [credentials12602 (:credentials m12601) args12603 (:args m12601)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12604
      (com.palletops.awaze.common/aws-client :iam credentials12602)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12604
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args12603 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-group-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupPolicies"}
   [credentials12606 & args12607]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12608
     (com.palletops.awaze.common/aws-client :iam credentials12606)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12608
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args12607 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m12609]
   (clojure.core/let
    [credentials12610 (:credentials m12609) args12611 (:args m12609)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12612
      (com.palletops.awaze.common/aws-client :iam credentials12610)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12612
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args12611 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-samlprovider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials12614 & args12615]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12616
     (com.palletops.awaze.common/aws-client :iam credentials12614)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12616
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args12615 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-role-policy
   [m12617]
   (clojure.core/let
    [credentials12618 (:credentials m12617) args12619 (:args m12617)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12620
      (com.palletops.awaze.common/aws-client :iam credentials12618)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12620
       detachRolePolicy
       (identitymanagement/detach-role-policy-request
        (clojure.core/nth args12619 0)))))))
  (clojure.core/defn
   detach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachRolePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-role-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachRolePolicy"}
   [credentials12622 & args12623]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12624
     (com.palletops.awaze.common/aws-client :iam credentials12622)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12624
      detachRolePolicy
      (identitymanagement/detach-role-policy-request
       (clojure.core/nth args12623 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m12625]
   (clojure.core/let
    [credentials12626 (:credentials m12625) args12627 (:args m12625)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12628
      (com.palletops.awaze.common/aws-client :iam credentials12626)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12628
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args12627 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-login-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateLoginProfile"}
   [credentials12630 & args12631]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12632
     (com.palletops.awaze.common/aws-client :iam credentials12630)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12632
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args12631 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-open-idconnect-provider-thumbprint
   [m12633]
   (clojure.core/let
    [credentials12634 (:credentials m12633) args12635 (:args m12633)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12636
      (com.palletops.awaze.common/aws-client :iam credentials12634)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12636
       updateOpenIDConnectProviderThumbprint
       (identitymanagement/update-open-idconnect-provider-thumbprint-request
        (clojure.core/nth args12635 0)))))))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateOpenIDConnectProviderThumbprint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-open-idconnect-provider-thumbprint,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateOpenIDConnectProviderThumbprint"}
   [credentials12638 & args12639]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12640
     (com.palletops.awaze.common/aws-client :iam credentials12638)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12640
      updateOpenIDConnectProviderThumbprint
      (identitymanagement/update-open-idconnect-provider-thumbprint-request
       (clojure.core/nth args12639 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-sshpublic-key
   [m12641]
   (clojure.core/let
    [credentials12642 (:credentials m12641) args12643 (:args m12641)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12644
      (com.palletops.awaze.common/aws-client :iam credentials12642)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12644
       updateSSHPublicKey
       (identitymanagement/update-sshpublic-key-request
        (clojure.core/nth args12643 0)))))))
  (clojure.core/defn
   update-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSSHPublicKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-sshpublic-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSSHPublicKey"}
   [credentials12646 & args12647]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12648
     (com.palletops.awaze.common/aws-client :iam credentials12646)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12648
      updateSSHPublicKey
      (identitymanagement/update-sshpublic-key-request
       (clojure.core/nth args12647 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m12649]
   (clojure.core/let
    [credentials12650 (:credentials m12649) args12651 (:args m12649)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12652
      (com.palletops.awaze.common/aws-client :iam credentials12650)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12652
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args12651 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-server-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials12654 & args12655]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12656
     (com.palletops.awaze.common/aws-client :iam credentials12654)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12656
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args12655 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m12657]
   (clojure.core/let
    [credentials12658 (:credentials m12657) args12659 (:args m12657)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12660
      (com.palletops.awaze.common/aws-client :iam credentials12658)]
     (clojure.core/case
      (clojure.core/count args12659)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12660
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args12659 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12660
        listVirtualMFADevices))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials12662 & args12663]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12664
     (com.palletops.awaze.common/aws-client :iam credentials12662)]
    (clojure.core/case
     (clojure.core/count args12663)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12664
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args12663 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12664
       listVirtualMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m12665]
   (clojure.core/let
    [credentials12666 (:credentials m12665) args12667 (:args m12665)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12668
      (com.palletops.awaze.common/aws-client :iam credentials12666)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12668
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args12667 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-server-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getServerCertificate"}
   [credentials12670 & args12671]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12672
     (com.palletops.awaze.common/aws-client :iam credentials12670)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12672
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args12671 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m12673]
   (clojure.core/let
    [credentials12674 (:credentials m12673) args12675 (:args m12673)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12676
      (com.palletops.awaze.common/aws-client :iam credentials12674)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12676
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args12675 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-role-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials12678 & args12679]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12680
     (com.palletops.awaze.common/aws-client :iam credentials12678)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12680
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args12679 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m12681]
   (clojure.core/let
    [credentials12682 (:credentials m12681) args12683 (:args m12681)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12684
      (com.palletops.awaze.common/aws-client :iam credentials12682)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12684
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args12683 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-instance-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials12686 & args12687]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12688
     (com.palletops.awaze.common/aws-client :iam credentials12686)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12688
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args12687 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m12689]
   (clojure.core/let
    [credentials12690 (:credentials m12689) args12691 (:args m12689)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12692
      (com.palletops.awaze.common/aws-client :iam credentials12690)]
     (clojure.core/case
      (clojure.core/count args12691)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12692
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args12691 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12692
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-account-aliases,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-account-aliases,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials12694 & args12695]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12696
     (com.palletops.awaze.common/aws-client :iam credentials12694)]
    (clojure.core/case
     (clojure.core/count args12695)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12696
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args12695 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12696
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m12697]
   (clojure.core/let
    [credentials12698 (:credentials m12697) args12699 (:args m12697)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12700
      (com.palletops.awaze.common/aws-client :iam credentials12698)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12700
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args12699 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-user-to-group,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addUserToGroup"}
   [credentials12702 & args12703]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12704
     (com.palletops.awaze.common/aws-client :iam credentials12702)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12704
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args12703 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-open-idconnect-provider
   [m12705]
   (clojure.core/let
    [credentials12706 (:credentials m12705) args12707 (:args m12705)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12708
      (com.palletops.awaze.common/aws-client :iam credentials12706)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12708
       deleteOpenIDConnectProvider
       (identitymanagement/delete-open-idconnect-provider-request
        (clojure.core/nth args12707 0)))))))
  (clojure.core/defn
   delete-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteOpenIDConnectProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-open-idconnect-provider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteOpenIDConnectProvider"}
   [credentials12710 & args12711]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12712
     (com.palletops.awaze.common/aws-client :iam credentials12710)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12712
      deleteOpenIDConnectProvider
      (identitymanagement/delete-open-idconnect-provider-request
       (clojure.core/nth args12711 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m12713]
   (clojure.core/let
    [credentials12714 (:credentials m12713) args12715 (:args m12713)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12716
      (com.palletops.awaze.common/aws-client :iam credentials12714)]
     (clojure.core/case
      (clojure.core/count args12715)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12716
        listUsers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12716
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args12715 0))))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-users,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-users,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUsers, listUsers"}
   [credentials12718 & args12719]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12720
     (com.palletops.awaze.common/aws-client :iam credentials12718)]
    (clojure.core/case
     (clojure.core/count args12719)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12720
       listUsers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12720
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args12719 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m12721]
   (clojure.core/let
    [credentials12722 (:credentials m12721) args12723 (:args m12721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12724
      (com.palletops.awaze.common/aws-client :iam credentials12722)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12724
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args12723 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-instance-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceProfile"}
   [credentials12726 & args12727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12728
     (com.palletops.awaze.common/aws-client :iam credentials12726)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12728
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args12727 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m12729]
   (clojure.core/let
    [credentials12730 (:credentials m12729) args12731 (:args m12729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12732
      (com.palletops.awaze.common/aws-client :iam credentials12730)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12732
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args12731 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-user-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUserPolicy"}
   [credentials12734 & args12735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12736
     (com.palletops.awaze.common/aws-client :iam credentials12734)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12736
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args12735 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m12737]
   (clojure.core/let
    [credentials12738 (:credentials m12737) args12739 (:args m12737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12740
      (com.palletops.awaze.common/aws-client :iam credentials12738)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12740
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args12739 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-login-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials12742 & args12743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12744
     (com.palletops.awaze.common/aws-client :iam credentials12742)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12744
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args12743 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-user-policy
   [m12745]
   (clojure.core/let
    [credentials12746 (:credentials m12745) args12747 (:args m12745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12748
      (com.palletops.awaze.common/aws-client :iam credentials12746)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12748
       attachUserPolicy
       (identitymanagement/attach-user-policy-request
        (clojure.core/nth args12747 0)))))))
  (clojure.core/defn
   attach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachUserPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-user-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachUserPolicy"}
   [credentials12750 & args12751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12752
     (com.palletops.awaze.common/aws-client :iam credentials12750)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12752
      attachUserPolicy
      (identitymanagement/attach-user-policy-request
       (clojure.core/nth args12751 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m12753]
   (clojure.core/let
    [credentials12754 (:credentials m12753) args12755 (:args m12753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12756
      (com.palletops.awaze.common/aws-client :iam credentials12754)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12756
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args12755 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-role-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putRolePolicy"}
   [credentials12758 & args12759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12760
     (com.palletops.awaze.common/aws-client :iam credentials12758)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12760
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args12759 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m12761]
   (clojure.core/let
    [credentials12762 (:credentials m12761) args12763 (:args m12761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12764
      (com.palletops.awaze.common/aws-client :iam credentials12762)]
     (clojure.core/case
      (clojure.core/count args12763)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12764
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args12763 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12764
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-access-keys,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-access-keys,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials12766 & args12767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12768
     (com.palletops.awaze.common/aws-client :iam credentials12766)]
    (clojure.core/case
     (clojure.core/count args12767)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12768
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args12767 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12768
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m12769]
   (clojure.core/let
    [credentials12770 (:credentials m12769) args12771 (:args m12769)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12772
      (com.palletops.awaze.common/aws-client :iam credentials12770)]
     (clojure.core/case
      (clojure.core/count args12771)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12772
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args12771 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12772
        listSigningCertificates))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-signing-certificates,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-signing-certificates,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials12774 & args12775]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12776
     (com.palletops.awaze.common/aws-client :iam credentials12774)]
    (clojure.core/case
     (clojure.core/count args12775)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12776
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args12775 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12776
       listSigningCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-group-policy
   [m12777]
   (clojure.core/let
    [credentials12778 (:credentials m12777) args12779 (:args m12777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12780
      (com.palletops.awaze.common/aws-client :iam credentials12778)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12780
       detachGroupPolicy
       (identitymanagement/detach-group-policy-request
        (clojure.core/nth args12779 0)))))))
  (clojure.core/defn
   detach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachGroupPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-group-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachGroupPolicy"}
   [credentials12782 & args12783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12784
     (com.palletops.awaze.common/aws-client :iam credentials12782)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12784
      detachGroupPolicy
      (identitymanagement/detach-group-policy-request
       (clojure.core/nth args12783 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m12785]
   (clojure.core/let
    [credentials12786 (:credentials m12785) args12787 (:args m12785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12788
      (com.palletops.awaze.common/aws-client :iam credentials12786)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12788
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args12787 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-access-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call updateAccessKey"}
   [credentials12790 & args12791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12792
     (com.palletops.awaze.common/aws-client :iam credentials12790)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12792
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args12791 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-sshpublic-key
   [m12793]
   (clojure.core/let
    [credentials12794 (:credentials m12793) args12795 (:args m12793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12796
      (com.palletops.awaze.common/aws-client :iam credentials12794)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12796
       uploadSSHPublicKey
       (identitymanagement/upload-sshpublic-key-request
        (clojure.core/nth args12795 0)))))))
  (clojure.core/defn
   upload-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSSHPublicKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :upload-sshpublic-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSSHPublicKey"}
   [credentials12798 & args12799]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12800
     (com.palletops.awaze.common/aws-client :iam credentials12798)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12800
      uploadSSHPublicKey
      (identitymanagement/upload-sshpublic-key-request
       (clojure.core/nth args12799 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m12801]
   (clojure.core/let
    [credentials12802 (:credentials m12801) args12803 (:args m12801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12804
      (com.palletops.awaze.common/aws-client :iam credentials12802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12804
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args12803 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :upload-server-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials12806 & args12807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12808
     (com.palletops.awaze.common/aws-client :iam credentials12806)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12808
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args12807 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m12809]
   (clojure.core/let
    [credentials12810 (:credentials m12809) args12811 (:args m12809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12812
      (com.palletops.awaze.common/aws-client :iam credentials12810)]
     (clojure.core/case
      (clojure.core/count args12811)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12812
        getAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12812
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args12811 0))))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-account-password-policy,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-account-password-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials12814 & args12815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12816
     (com.palletops.awaze.common/aws-client :iam credentials12814)]
    (clojure.core/case
     (clojure.core/count args12815)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12816
       getAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12816
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args12815 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m12817]
   (clojure.core/let
    [credentials12818 (:credentials m12817) args12819 (:args m12817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12820
      (com.palletops.awaze.common/aws-client :iam credentials12818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12820
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args12819 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-role,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRole"}
   [credentials12822 & args12823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12824
     (com.palletops.awaze.common/aws-client :iam credentials12822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12824
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args12823 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-client-idfrom-open-idconnect-provider
   [m12825]
   (clojure.core/let
    [credentials12826 (:credentials m12825) args12827 (:args m12825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12828
      (com.palletops.awaze.common/aws-client :iam credentials12826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12828
       removeClientIDFromOpenIDConnectProvider
       (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
        (clojure.core/nth args12827 0)))))))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeClientIDFromOpenIDConnectProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-client-idfrom-open-idconnect-provider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeClientIDFromOpenIDConnectProvider"}
   [credentials12830 & args12831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12832
     (com.palletops.awaze.common/aws-client :iam credentials12830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12832
      removeClientIDFromOpenIDConnectProvider
      (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
       (clojure.core/nth args12831 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m12833]
   (clojure.core/let
    [credentials12834 (:credentials m12833) args12835 (:args m12833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12836
      (com.palletops.awaze.common/aws-client :iam credentials12834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12836
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args12835 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-user-from-group,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials12838 & args12839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12840
     (com.palletops.awaze.common/aws-client :iam credentials12838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12840
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args12839 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m12841]
   (clojure.core/let
    [credentials12842 (:credentials m12841) args12843 (:args m12841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12844
      (com.palletops.awaze.common/aws-client :iam credentials12842)]
     (clojure.core/case
      (clojure.core/count args12843)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12844
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args12843 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12844
        listRoles))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-roles,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-roles,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listRoles, listRoles"}
   [credentials12846 & args12847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12848
     (com.palletops.awaze.common/aws-client :iam credentials12846)]
    (clojure.core/case
     (clojure.core/count args12847)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12848
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args12847 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12848
       listRoles))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-role-policies
   [m12849]
   (clojure.core/let
    [credentials12850 (:credentials m12849) args12851 (:args m12849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12852
      (com.palletops.awaze.common/aws-client :iam credentials12850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12852
       listAttachedRolePolicies
       (identitymanagement/list-attached-role-policies-request
        (clojure.core/nth args12851 0)))))))
  (clojure.core/defn
   list-attached-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedRolePolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-attached-role-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedRolePolicies"}
   [credentials12854 & args12855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12856
     (com.palletops.awaze.common/aws-client :iam credentials12854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12856
      listAttachedRolePolicies
      (identitymanagement/list-attached-role-policies-request
       (clojure.core/nth args12855 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m12857]
   (clojure.core/let
    [credentials12858 (:credentials m12857) args12859 (:args m12857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12860
      (com.palletops.awaze.common/aws-client :iam credentials12858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12860
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args12859 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials12862 & args12863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12864
     (com.palletops.awaze.common/aws-client :iam credentials12862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12864
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args12863 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy
   [m12865]
   (clojure.core/let
    [credentials12866 (:credentials m12865) args12867 (:args m12865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12868
      (com.palletops.awaze.common/aws-client :iam credentials12866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12868
       createPolicy
       (identitymanagement/create-policy-request
        (clojure.core/nth args12867 0)))))))
  (clojure.core/defn
   create-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPolicy"}
   [credentials12870 & args12871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12872
     (com.palletops.awaze.common/aws-client :iam credentials12870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12872
      createPolicy
      (identitymanagement/create-policy-request
       (clojure.core/nth args12871 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-client-idto-open-idconnect-provider
   [m12873]
   (clojure.core/let
    [credentials12874 (:credentials m12873) args12875 (:args m12873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12876
      (com.palletops.awaze.common/aws-client :iam credentials12874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12876
       addClientIDToOpenIDConnectProvider
       (identitymanagement/add-client-idto-open-idconnect-provider-request
        (clojure.core/nth args12875 0)))))))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addClientIDToOpenIDConnectProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-client-idto-open-idconnect-provider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addClientIDToOpenIDConnectProvider"}
   [credentials12878 & args12879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12880
     (com.palletops.awaze.common/aws-client :iam credentials12878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12880
      addClientIDToOpenIDConnectProvider
      (identitymanagement/add-client-idto-open-idconnect-provider-request
       (clojure.core/nth args12879 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m12881]
   (clojure.core/let
    [credentials12882 (:credentials m12881) args12883 (:args m12881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12884
      (com.palletops.awaze.common/aws-client :iam credentials12882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12884
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args12883 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-virtual-mfadevice,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials12886 & args12887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12888
     (com.palletops.awaze.common/aws-client :iam credentials12886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12888
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args12887 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m12889]
   (clojure.core/let
    [credentials12890 (:credentials m12889) args12891 (:args m12889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12892
      (com.palletops.awaze.common/aws-client :iam credentials12890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12892
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args12891 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-account-alias,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials12894 & args12895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12896
     (com.palletops.awaze.common/aws-client :iam credentials12894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12896
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args12895 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m12897]
   (clojure.core/let
    [credentials12898 (:credentials m12897) args12899 (:args m12897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12900
      (com.palletops.awaze.common/aws-client :iam credentials12898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12900
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args12899 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :upload-signing-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials12902 & args12903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12904
     (com.palletops.awaze.common/aws-client :iam credentials12902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12904
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args12903 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m12905]
   (clojure.core/let
    [credentials12906 (:credentials m12905) args12907 (:args m12905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12908
      (com.palletops.awaze.common/aws-client :iam credentials12906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12908
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args12907 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :deactivate-mfadevice,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials12910 & args12911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12912
     (com.palletops.awaze.common/aws-client :iam credentials12910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12912
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args12911 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m12913]
   (clojure.core/let
    [credentials12914 (:credentials m12913) args12915 (:args m12913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12916
      (com.palletops.awaze.common/aws-client :iam credentials12914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12916
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args12915 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :resync-mfadevice,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resyncMFADevice"}
   [credentials12918 & args12919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12920
     (com.palletops.awaze.common/aws-client :iam credentials12918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12920
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args12919 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-sshpublic-keys
   [m12921]
   (clojure.core/let
    [credentials12922 (:credentials m12921) args12923 (:args m12921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12924
      (com.palletops.awaze.common/aws-client :iam credentials12922)]
     (clojure.core/case
      (clojure.core/count args12923)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12924
        listSSHPublicKeys))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12924
        listSSHPublicKeys
        (identitymanagement/list-sshpublic-keys-request
         (clojure.core/nth args12923 0))))))))
  (clojure.core/defn
   list-sshpublic-keys-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSSHPublicKeys, listSSHPublicKeys"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-sshpublic-keys,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-sshpublic-keys,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-sshpublic-keys
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSSHPublicKeys, listSSHPublicKeys"}
   [credentials12926 & args12927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12928
     (com.palletops.awaze.common/aws-client :iam credentials12926)]
    (clojure.core/case
     (clojure.core/count args12927)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12928
       listSSHPublicKeys))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12928
       listSSHPublicKeys
       (identitymanagement/list-sshpublic-keys-request
        (clojure.core/nth args12927 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m12929]
   (clojure.core/let
    [credentials12930 (:credentials m12929) args12931 (:args m12929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12932
      (com.palletops.awaze.common/aws-client :iam credentials12930)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12932
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args12931 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-role-to-instance-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials12934 & args12935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12936
     (com.palletops.awaze.common/aws-client :iam credentials12934)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12936
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args12935 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m12937]
   (clojure.core/let
    [credentials12938 (:credentials m12937) args12939 (:args m12937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12940
      (com.palletops.awaze.common/aws-client :iam credentials12938)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12940
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args12939 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-mfadevice,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableMFADevice"}
   [credentials12942 & args12943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12944
     (com.palletops.awaze.common/aws-client :iam credentials12942)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12944
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args12943 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m12945]
   (clojure.core/let
    [credentials12946 (:credentials m12945) args12947 (:args m12945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12948
      (com.palletops.awaze.common/aws-client :iam credentials12946)]
     (clojure.core/case
      (clojure.core/count args12947)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12948
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12948
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args12947 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-groups,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-groups,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroups, listGroups"}
   [credentials12950 & args12951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12952
     (com.palletops.awaze.common/aws-client :iam credentials12950)]
    (clojure.core/case
     (clojure.core/count args12951)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12952
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12952
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args12951 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy-version
   [m12953]
   (clojure.core/let
    [credentials12954 (:credentials m12953) args12955 (:args m12953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12956
      (com.palletops.awaze.common/aws-client :iam credentials12954)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12956
       deletePolicyVersion
       (identitymanagement/delete-policy-version-request
        (clojure.core/nth args12955 0)))))))
  (clojure.core/defn
   delete-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicyVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-policy-version,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicyVersion"}
   [credentials12958 & args12959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12960
     (com.palletops.awaze.common/aws-client :iam credentials12958)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12960
      deletePolicyVersion
      (identitymanagement/delete-policy-version-request
       (clojure.core/nth args12959 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m12961]
   (clojure.core/let
    [credentials12962 (:credentials m12961) args12963 (:args m12961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12964
      (com.palletops.awaze.common/aws-client :iam credentials12962)]
     (clojure.core/case
      (clojure.core/count args12963)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12964
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12964
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args12963 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :create-access-key,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-access-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials12966 & args12967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12968
     (com.palletops.awaze.common/aws-client :iam credentials12966)]
    (clojure.core/case
     (clojure.core/count args12967)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12968
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12968
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args12967 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m12969]
   (clojure.core/let
    [credentials12970 (:credentials m12969) args12971 (:args m12969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12972
      (com.palletops.awaze.common/aws-client :iam credentials12970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12972
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args12971 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials12974 & args12975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12976
     (com.palletops.awaze.common/aws-client :iam credentials12974)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12976
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args12975 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m12977]
   (clojure.core/let
    [credentials12978 (:credentials m12977) args12979 (:args m12977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12980
      (com.palletops.awaze.common/aws-client :iam credentials12978)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12980
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args12979 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-instance-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInstanceProfile"}
   [credentials12982 & args12983]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12984
     (com.palletops.awaze.common/aws-client :iam credentials12982)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12984
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args12983 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m12985]
   (clojure.core/let
    [credentials12986 (:credentials m12985) args12987 (:args m12985)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12988
      (com.palletops.awaze.common/aws-client :iam credentials12986)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12988
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args12987 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-samlprovider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSAMLProvider"}
   [credentials12990 & args12991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12992
     (com.palletops.awaze.common/aws-client :iam credentials12990)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12992
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args12991 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m12993]
   (clojure.core/let
    [credentials12994 (:credentials m12993) args12995 (:args m12993)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12996
      (com.palletops.awaze.common/aws-client :iam credentials12994)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12996
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args12995 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-samlprovider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials12998 & args12999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13000
     (com.palletops.awaze.common/aws-client :iam credentials12998)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13000
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args12999 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-sshpublic-key
   [m13001]
   (clojure.core/let
    [credentials13002 (:credentials m13001) args13003 (:args m13001)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13004
      (com.palletops.awaze.common/aws-client :iam credentials13002)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13004
       deleteSSHPublicKey
       (identitymanagement/delete-sshpublic-key-request
        (clojure.core/nth args13003 0)))))))
  (clojure.core/defn
   delete-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSSHPublicKey"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-sshpublic-key,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSSHPublicKey"}
   [credentials13006 & args13007]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13008
     (com.palletops.awaze.common/aws-client :iam credentials13006)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13008
      deleteSSHPublicKey
      (identitymanagement/delete-sshpublic-key-request
       (clojure.core/nth args13007 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-custom-policy
   [m13009]
   (clojure.core/let
    [credentials13010 (:credentials m13009) args13011 (:args m13009)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13012
      (com.palletops.awaze.common/aws-client :iam credentials13010)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13012
       simulateCustomPolicy
       (identitymanagement/simulate-custom-policy-request
        (clojure.core/nth args13011 0)))))))
  (clojure.core/defn
   simulate-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulateCustomPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :simulate-custom-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulateCustomPolicy"}
   [credentials13014 & args13015]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13016
     (com.palletops.awaze.common/aws-client :iam credentials13014)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13016
      simulateCustomPolicy
      (identitymanagement/simulate-custom-policy-request
       (clojure.core/nth args13015 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-custom-policy
   [m13017]
   (clojure.core/let
    [credentials13018 (:credentials m13017) args13019 (:args m13017)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13020
      (com.palletops.awaze.common/aws-client :iam credentials13018)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13020
       getContextKeysForCustomPolicy
       (identitymanagement/get-context-keys-for-custom-policy-request
        (clojure.core/nth args13019 0)))))))
  (clojure.core/defn
   get-context-keys-for-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForCustomPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-custom-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForCustomPolicy"}
   [credentials13022 & args13023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13024
     (com.palletops.awaze.common/aws-client :iam credentials13022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13024
      getContextKeysForCustomPolicy
      (identitymanagement/get-context-keys-for-custom-policy-request
       (clojure.core/nth args13023 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m13025]
   (clojure.core/let
    [credentials13026 (:credentials m13025) args13027 (:args m13025)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13028
      (com.palletops.awaze.common/aws-client :iam credentials13026)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13028
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args13027 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-user-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUserPolicies"}
   [credentials13030 & args13031]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13032
     (com.palletops.awaze.common/aws-client :iam credentials13030)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13032
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args13031 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m13033]
   (clojure.core/let
    [credentials13034 (:credentials m13033) args13035 (:args m13033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13036
      (com.palletops.awaze.common/aws-client :iam credentials13034)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13036
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args13035 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-group,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Call updateGroup"}
   [credentials13038 & args13039]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13040
     (com.palletops.awaze.common/aws-client :iam credentials13038)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13040
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args13039 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-entities-for-policy
   [m13041]
   (clojure.core/let
    [credentials13042 (:credentials m13041) args13043 (:args m13041)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13044
      (com.palletops.awaze.common/aws-client :iam credentials13042)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13044
       listEntitiesForPolicy
       (identitymanagement/list-entities-for-policy-request
        (clojure.core/nth args13043 0)))))))
  (clojure.core/defn
   list-entities-for-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listEntitiesForPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-entities-for-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-entities-for-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listEntitiesForPolicy"}
   [credentials13046 & args13047]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13048
     (com.palletops.awaze.common/aws-client :iam credentials13046)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13048
      listEntitiesForPolicy
      (identitymanagement/list-entities-for-policy-request
       (clojure.core/nth args13047 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policies
   [m13049]
   (clojure.core/let
    [credentials13050 (:credentials m13049) args13051 (:args m13049)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13052
      (com.palletops.awaze.common/aws-client :iam credentials13050)]
     (clojure.core/case
      (clojure.core/count args13051)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13052
        listPolicies
        (identitymanagement/list-policies-request
         (clojure.core/nth args13051 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13052
        listPolicies))))))
  (clojure.core/defn
   list-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listPolicies, listPolicies"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-policies,
     :credentials credentials__1784__auto__,
     :client :iam})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listPolicies, listPolicies"}
   [credentials13054 & args13055]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13056
     (com.palletops.awaze.common/aws-client :iam credentials13054)]
    (clojure.core/case
     (clojure.core/count args13055)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13056
       listPolicies
       (identitymanagement/list-policies-request
        (clojure.core/nth args13055 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13056
       listPolicies))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m13057]
   (clojure.core/let
    [credentials13058 (:credentials m13057) args13059 (:args m13057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13060
      (com.palletops.awaze.common/aws-client :iam credentials13058)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13060
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args13059 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-user,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUser"}
   [credentials13062 & args13063]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13064
     (com.palletops.awaze.common/aws-client :iam credentials13062)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13064
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args13063 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m13065]
   (clojure.core/let
    [credentials13066 (:credentials m13065) args13067 (:args m13065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13068
      (com.palletops.awaze.common/aws-client :iam credentials13066)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13068
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args13067 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-signing-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials13070 & args13071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13072
     (com.palletops.awaze.common/aws-client :iam credentials13070)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13072
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args13071 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-principal-policy
   [m13073]
   (clojure.core/let
    [credentials13074 (:credentials m13073) args13075 (:args m13073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13076
      (com.palletops.awaze.common/aws-client :iam credentials13074)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13076
       getContextKeysForPrincipalPolicy
       (identitymanagement/get-context-keys-for-principal-policy-request
        (clojure.core/nth args13075 0)))))))
  (clojure.core/defn
   get-context-keys-for-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForPrincipalPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-principal-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForPrincipalPolicy"}
   [credentials13078 & args13079]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13080
     (com.palletops.awaze.common/aws-client :iam credentials13078)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13080
      getContextKeysForPrincipalPolicy
      (identitymanagement/get-context-keys-for-principal-policy-request
       (clojure.core/nth args13079 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m13081]
   (clojure.core/let
    [credentials13082 (:credentials m13081) args13083 (:args m13081)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13084
      (com.palletops.awaze.common/aws-client :iam credentials13082)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13084
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args13083 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-server-certificate,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServerCertificate"}
   [credentials13086 & args13087]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13088
     (com.palletops.awaze.common/aws-client :iam credentials13086)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13088
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args13087 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-user-policies
   [m13089]
   (clojure.core/let
    [credentials13090 (:credentials m13089) args13091 (:args m13089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13092
      (com.palletops.awaze.common/aws-client :iam credentials13090)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13092
       listAttachedUserPolicies
       (identitymanagement/list-attached-user-policies-request
        (clojure.core/nth args13091 0)))))))
  (clojure.core/defn
   list-attached-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedUserPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-attached-user-policies,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedUserPolicies"}
   [credentials13094 & args13095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13096
     (com.palletops.awaze.common/aws-client :iam credentials13094)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13096
      listAttachedUserPolicies
      (identitymanagement/list-attached-user-policies-request
       (clojure.core/nth args13095 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy-version
   [m13097]
   (clojure.core/let
    [credentials13098 (:credentials m13097) args13099 (:args m13097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13100
      (com.palletops.awaze.common/aws-client :iam credentials13098)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13100
       createPolicyVersion
       (identitymanagement/create-policy-version-request
        (clojure.core/nth args13099 0)))))))
  (clojure.core/defn
   create-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Generate map for createPolicyVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-policy-version,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Call createPolicyVersion"}
   [credentials13102 & args13103]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13104
     (com.palletops.awaze.common/aws-client :iam credentials13102)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13104
      createPolicyVersion
      (identitymanagement/create-policy-version-request
       (clojure.core/nth args13103 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m13105]
   (clojure.core/let
    [credentials13106 (:credentials m13105) args13107 (:args m13105)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13108
      (com.palletops.awaze.common/aws-client :iam credentials13106)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13108
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args13107 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-login-profile,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoginProfile"}
   [credentials13110 & args13111]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13112
     (com.palletops.awaze.common/aws-client :iam credentials13110)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13112
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args13111 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-principal-policy
   [m13113]
   (clojure.core/let
    [credentials13114 (:credentials m13113) args13115 (:args m13113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13116
      (com.palletops.awaze.common/aws-client :iam credentials13114)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13116
       simulatePrincipalPolicy
       (identitymanagement/simulate-principal-policy-request
        (clojure.core/nth args13115 0)))))))
  (clojure.core/defn
   simulate-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulatePrincipalPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :simulate-principal-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulatePrincipalPolicy"}
   [credentials13118 & args13119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13120
     (com.palletops.awaze.common/aws-client :iam credentials13118)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13120
      simulatePrincipalPolicy
      (identitymanagement/simulate-principal-policy-request
       (clojure.core/nth args13119 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-open-idconnect-provider
   [m13121]
   (clojure.core/let
    [credentials13122 (:credentials m13121) args13123 (:args m13121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13124
      (com.palletops.awaze.common/aws-client :iam credentials13122)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13124
       createOpenIDConnectProvider
       (identitymanagement/create-open-idconnect-provider-request
        (clojure.core/nth args13123 0)))))))
  (clojure.core/defn
   create-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOpenIDConnectProvider"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-open-idconnect-provider,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   create-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Call createOpenIDConnectProvider"}
   [credentials13126 & args13127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13128
     (com.palletops.awaze.common/aws-client :iam credentials13126)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13128
      createOpenIDConnectProvider
      (identitymanagement/create-open-idconnect-provider-request
       (clojure.core/nth args13127 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-role-policy
   [m13129]
   (clojure.core/let
    [credentials13130 (:credentials m13129) args13131 (:args m13129)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13132
      (com.palletops.awaze.common/aws-client :iam credentials13130)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13132
       attachRolePolicy
       (identitymanagement/attach-role-policy-request
        (clojure.core/nth args13131 0)))))))
  (clojure.core/defn
   attach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachRolePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-role-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachRolePolicy"}
   [credentials13134 & args13135]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13136
     (com.palletops.awaze.common/aws-client :iam credentials13134)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13136
      attachRolePolicy
      (identitymanagement/attach-role-policy-request
       (clojure.core/nth args13135 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m13137]
   (clojure.core/let
    [credentials13138 (:credentials m13137) args13139 (:args m13137)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13140
      (com.palletops.awaze.common/aws-client :iam credentials13138)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13140
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args13139 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-group-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroupPolicy"}
   [credentials13142 & args13143]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13144
     (com.palletops.awaze.common/aws-client :iam credentials13142)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13144
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args13143 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-user-policy
   [m13145]
   (clojure.core/let
    [credentials13146 (:credentials m13145) args13147 (:args m13145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13148
      (com.palletops.awaze.common/aws-client :iam credentials13146)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13148
       detachUserPolicy
       (identitymanagement/detach-user-policy-request
        (clojure.core/nth args13147 0)))))))
  (clojure.core/defn
   detach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachUserPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-user-policy,
     :credentials credentials__1784__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachUserPolicy"}
   [credentials13150 & args13151]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13152
     (com.palletops.awaze.common/aws-client :iam credentials13150)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13152
      detachUserPolicy
      (identitymanagement/detach-user-policy-request
       (clojure.core/nth args13151 0))))))))
