(ns
 com.palletops.awaze.glacier
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.glacier :as glacier]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :glacier
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.glacier.AmazonGlacierClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InventoryRetrievalJobInput}
inventory-retrieval-job-input
  [m5708]
  (clojure.core/let
   [bean5707
    (new
     com.amazonaws.services.glacier.model.InventoryRetrievalJobInput)]
   (clojure.core/let
    [v5709 (:marker m5708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5709 :com.palletops.awaze.client-builder/undef)
     (. bean5707 setMarker (clojure.core/str v5709))))
   (clojure.core/let
    [v5709 (:limit m5708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5709 :com.palletops.awaze.client-builder/undef)
     (. bean5707 setLimit (clojure.core/str v5709))))
   (clojure.core/let
    [v5709
     (:start-date m5708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5709 :com.palletops.awaze.client-builder/undef)
     (. bean5707 setStartDate (clojure.core/str v5709))))
   (clojure.core/let
    [v5709
     (:end-date m5708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5709 :com.palletops.awaze.client-builder/undef)
     (. bean5707 setEndDate (clojure.core/str v5709))))
   bean5707))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalRule}
data-retrieval-rule
  [m5711]
  (clojure.core/let
   [bean5710
    (new com.amazonaws.services.glacier.model.DataRetrievalRule)]
   (clojure.core/let
    [v5712
     (:strategy m5711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5712 :com.palletops.awaze.client-builder/undef)
     (. bean5710 setStrategy (clojure.core/str v5712))))
   (clojure.core/let
    [v5712
     (:bytes-per-hour m5711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5712 :com.palletops.awaze.client-builder/undef)
     (. bean5710 setBytesPerHour (clojure.core/long v5712))))
   bean5710))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.JobParameters}
job-parameters
  [m5714]
  (clojure.core/let
   [bean5713 (new com.amazonaws.services.glacier.model.JobParameters)]
   (clojure.core/let
    [v5715 (:type m5714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (. bean5713 setType (clojure.core/str v5715))))
   (clojure.core/let
    [v5715
     (:description m5714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (. bean5713 setDescription (clojure.core/str v5715))))
   (clojure.core/let
    [v5715 (:format m5714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (. bean5713 setFormat (clojure.core/str v5715))))
   (clojure.core/let
    [v5715
     (:archive-id m5714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (. bean5713 setArchiveId (clojure.core/str v5715))))
   (clojure.core/let
    [v5715
     (:snstopic m5714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (. bean5713 setSNSTopic (clojure.core/str v5715))))
   (clojure.core/let
    [v5715
     (:retrieval-byte-range
      m5714
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (. bean5713 setRetrievalByteRange (clojure.core/str v5715))))
   (clojure.core/let
    [v5715
     (:inventory-retrieval-parameters
      m5714
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5715 :com.palletops.awaze.client-builder/undef)
     (.
      bean5713
      setInventoryRetrievalParameters
      (glacier/inventory-retrieval-job-input v5715))))
   bean5713))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultNotificationConfig}
vault-notification-config
  [m5717]
  (clojure.core/let
   [bean5716
    (new com.amazonaws.services.glacier.model.VaultNotificationConfig)]
   (clojure.core/let
    [v5718
     (:snstopic m5717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5718 :com.palletops.awaze.client-builder/undef)
     (. bean5716 setSNSTopic (clojure.core/str v5718))))
   (clojure.core/let
    [v5718 (:events m5717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5718 :com.palletops.awaze.client-builder/undef)
     (.
      bean5716
      setEvents
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5821] (clojure.core/str arg5821))
 v5718))))
   bean5716))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultAccessPolicy}
vault-access-policy
  [m5720]
  (clojure.core/let
   [bean5719
    (new com.amazonaws.services.glacier.model.VaultAccessPolicy)]
   (clojure.core/let
    [v5721 (:policy m5720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5721 :com.palletops.awaze.client-builder/undef)
     (. bean5719 setPolicy (clojure.core/str v5721))))
   bean5719))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultLockPolicy}
vault-lock-policy
  [m5723]
  (clojure.core/let
   [bean5722
    (new com.amazonaws.services.glacier.model.VaultLockPolicy)]
   (clojure.core/let
    [v5724 (:policy m5723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5724 :com.palletops.awaze.client-builder/undef)
     (. bean5722 setPolicy (clojure.core/str v5724))))
   bean5722))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalPolicy}
data-retrieval-policy
  [m5726]
  (clojure.core/let
   [bean5725
    (new com.amazonaws.services.glacier.model.DataRetrievalPolicy)]
   (clojure.core/let
    [v5727 (:rules m5726 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5727 :com.palletops.awaze.client-builder/undef)
     (.
      bean5725
      setRules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5822] (glacier/data-retrieval-rule arg5822))
 v5727))))
   bean5725))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m5729]
  (clojure.core/let
   [bean5728
    (new
     com.amazonaws.services.glacier.model.ListMultipartUploadsRequest)]
   (clojure.core/let
    [v5730 (:limit m5729 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5730 :com.palletops.awaze.client-builder/undef)
     (. bean5728 setLimit (clojure.core/str v5730))))
   (clojure.core/let
    [v5730
     (:account-id m5729 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5730 :com.palletops.awaze.client-builder/undef)
     (. bean5728 setAccountId (clojure.core/str v5730))))
   (clojure.core/let
    [v5730
     (:vault-name m5729 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5730 :com.palletops.awaze.client-builder/undef)
     (. bean5728 setVaultName (clojure.core/str v5730))))
   (clojure.core/let
    [v5730
     (:upload-id-marker
      m5729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5730 :com.palletops.awaze.client-builder/undef)
     (. bean5728 setUploadIdMarker (clojure.core/str v5730))))
   bean5728))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultRequest}
delete-vault-request
  [m5732]
  (clojure.core/let
   [bean5731
    (new com.amazonaws.services.glacier.model.DeleteVaultRequest)]
   (clojure.core/let
    [v5733
     (:account-id m5732 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5733 :com.palletops.awaze.client-builder/undef)
     (. bean5731 setAccountId (clojure.core/str v5733))))
   (clojure.core/let
    [v5733
     (:vault-name m5732 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5733 :com.palletops.awaze.client-builder/undef)
     (. bean5731 setVaultName (clojure.core/str v5733))))
   bean5731))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteVaultLockRequest}
complete-vault-lock-request
  [m5735]
  (clojure.core/let
   [bean5734
    (new
     com.amazonaws.services.glacier.model.CompleteVaultLockRequest)]
   (clojure.core/let
    [v5736
     (:account-id m5735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5736 :com.palletops.awaze.client-builder/undef)
     (. bean5734 setAccountId (clojure.core/str v5736))))
   (clojure.core/let
    [v5736
     (:vault-name m5735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5736 :com.palletops.awaze.client-builder/undef)
     (. bean5734 setVaultName (clojure.core/str v5736))))
   (clojure.core/let
    [v5736 (:lock-id m5735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5736 :com.palletops.awaze.client-builder/undef)
     (. bean5734 setLockId (clojure.core/str v5736))))
   bean5734))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest}
delete-vault-notifications-request
  [m5738]
  (clojure.core/let
   [bean5737
    (new
     com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest)]
   (clojure.core/let
    [v5739
     (:account-id m5738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5739 :com.palletops.awaze.client-builder/undef)
     (. bean5737 setAccountId (clojure.core/str v5739))))
   (clojure.core/let
    [v5739
     (:vault-name m5738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5739 :com.palletops.awaze.client-builder/undef)
     (. bean5737 setVaultName (clojure.core/str v5739))))
   bean5737))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest}
delete-vault-access-policy-request
  [m5741]
  (clojure.core/let
   [bean5740
    (new
     com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5742
     (:account-id m5741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5742 :com.palletops.awaze.client-builder/undef)
     (. bean5740 setAccountId (clojure.core/str v5742))))
   (clojure.core/let
    [v5742
     (:vault-name m5741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5742 :com.palletops.awaze.client-builder/undef)
     (. bean5740 setVaultName (clojure.core/str v5742))))
   bean5740))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest}
remove-tags-from-vault-request
  [m5744]
  (clojure.core/let
   [bean5743
    (new
     com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest)]
   (clojure.core/let
    [v5745
     (:tag-keys m5744 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5745 :com.palletops.awaze.client-builder/undef)
     (.
      bean5743
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5823] (clojure.core/str arg5823))
 v5745))))
   (clojure.core/let
    [v5745
     (:account-id m5744 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5745 :com.palletops.awaze.client-builder/undef)
     (. bean5743 setAccountId (clojure.core/str v5745))))
   (clojure.core/let
    [v5745
     (:vault-name m5744 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5745 :com.palletops.awaze.client-builder/undef)
     (. bean5743 setVaultName (clojure.core/str v5745))))
   bean5743))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m5747]
  (clojure.core/let
   [bean5746
    (new
     com.amazonaws.services.glacier.model.AbortMultipartUploadRequest)]
   (clojure.core/let
    [v5748
     (:account-id m5747 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5748 :com.palletops.awaze.client-builder/undef)
     (. bean5746 setAccountId (clojure.core/str v5748))))
   (clojure.core/let
    [v5748
     (:vault-name m5747 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5748 :com.palletops.awaze.client-builder/undef)
     (. bean5746 setVaultName (clojure.core/str v5748))))
   (clojure.core/let
    [v5748
     (:upload-id m5747 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5748 :com.palletops.awaze.client-builder/undef)
     (. bean5746 setUploadId (clojure.core/str v5748))))
   bean5746))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadMultipartPartRequest}
upload-multipart-part-request
  [m5750]
  (clojure.core/let
   [bean5749
    (new
     com.amazonaws.services.glacier.model.UploadMultipartPartRequest)]
   (clojure.core/let
    [v5751 (:body m5750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5751 :com.palletops.awaze.client-builder/undef)
     (. bean5749 setBody (clojure.java.io/input-stream v5751))))
   (clojure.core/let
    [v5751
     (:account-id m5750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5751 :com.palletops.awaze.client-builder/undef)
     (. bean5749 setAccountId (clojure.core/str v5751))))
   (clojure.core/let
    [v5751
     (:vault-name m5750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5751 :com.palletops.awaze.client-builder/undef)
     (. bean5749 setVaultName (clojure.core/str v5751))))
   (clojure.core/let
    [v5751
     (:checksum m5750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5751 :com.palletops.awaze.client-builder/undef)
     (. bean5749 setChecksum (clojure.core/str v5751))))
   (clojure.core/let
    [v5751
     (:upload-id m5750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5751 :com.palletops.awaze.client-builder/undef)
     (. bean5749 setUploadId (clojure.core/str v5751))))
   (clojure.core/let
    [v5751 (:range m5750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5751 :com.palletops.awaze.client-builder/undef)
     (. bean5749 setRange (clojure.core/str v5751))))
   bean5749))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListVaultsRequest}
list-vaults-request
  [m5753]
  (clojure.core/let
   [bean5752
    (new com.amazonaws.services.glacier.model.ListVaultsRequest)]
   (clojure.core/let
    [v5754 (:marker m5753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5754 :com.palletops.awaze.client-builder/undef)
     (. bean5752 setMarker (clojure.core/str v5754))))
   (clojure.core/let
    [v5754 (:limit m5753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5754 :com.palletops.awaze.client-builder/undef)
     (. bean5752 setLimit (clojure.core/str v5754))))
   (clojure.core/let
    [v5754
     (:account-id m5753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5754 :com.palletops.awaze.client-builder/undef)
     (. bean5752 setAccountId (clojure.core/str v5754))))
   bean5752))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateJobRequest}
initiate-job-request
  [m5756]
  (clojure.core/let
   [bean5755
    (new com.amazonaws.services.glacier.model.InitiateJobRequest)]
   (clojure.core/let
    [v5757
     (:account-id m5756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5757 :com.palletops.awaze.client-builder/undef)
     (. bean5755 setAccountId (clojure.core/str v5757))))
   (clojure.core/let
    [v5757
     (:vault-name m5756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5757 :com.palletops.awaze.client-builder/undef)
     (. bean5755 setVaultName (clojure.core/str v5757))))
   (clojure.core/let
    [v5757
     (:job-parameters m5756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5757 :com.palletops.awaze.client-builder/undef)
     (. bean5755 setJobParameters (glacier/job-parameters v5757))))
   bean5755))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListPartsRequest}
list-parts-request
  [m5759]
  (clojure.core/let
   [bean5758
    (new com.amazonaws.services.glacier.model.ListPartsRequest)]
   (clojure.core/let
    [v5760 (:marker m5759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5760 :com.palletops.awaze.client-builder/undef)
     (. bean5758 setMarker (clojure.core/str v5760))))
   (clojure.core/let
    [v5760 (:limit m5759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5760 :com.palletops.awaze.client-builder/undef)
     (. bean5758 setLimit (clojure.core/str v5760))))
   (clojure.core/let
    [v5760
     (:account-id m5759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5760 :com.palletops.awaze.client-builder/undef)
     (. bean5758 setAccountId (clojure.core/str v5760))))
   (clojure.core/let
    [v5760
     (:vault-name m5759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5760 :com.palletops.awaze.client-builder/undef)
     (. bean5758 setVaultName (clojure.core/str v5760))))
   (clojure.core/let
    [v5760
     (:upload-id m5759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5760 :com.palletops.awaze.client-builder/undef)
     (. bean5758 setUploadId (clojure.core/str v5760))))
   bean5758))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultNotificationsRequest}
get-vault-notifications-request
  [m5762]
  (clojure.core/let
   [bean5761
    (new
     com.amazonaws.services.glacier.model.GetVaultNotificationsRequest)]
   (clojure.core/let
    [v5763
     (:account-id m5762 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5763 :com.palletops.awaze.client-builder/undef)
     (. bean5761 setAccountId (clojure.core/str v5763))))
   (clojure.core/let
    [v5763
     (:vault-name m5762 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5763 :com.palletops.awaze.client-builder/undef)
     (. bean5761 setVaultName (clojure.core/str v5763))))
   bean5761))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetJobOutputRequest}
get-job-output-request
  [m5765]
  (clojure.core/let
   [bean5764
    (new com.amazonaws.services.glacier.model.GetJobOutputRequest)]
   (clojure.core/let
    [v5766 (:job-id m5765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5766 :com.palletops.awaze.client-builder/undef)
     (. bean5764 setJobId (clojure.core/str v5766))))
   (clojure.core/let
    [v5766
     (:account-id m5765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5766 :com.palletops.awaze.client-builder/undef)
     (. bean5764 setAccountId (clojure.core/str v5766))))
   (clojure.core/let
    [v5766
     (:vault-name m5765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5766 :com.palletops.awaze.client-builder/undef)
     (. bean5764 setVaultName (clojure.core/str v5766))))
   (clojure.core/let
    [v5766 (:range m5765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5766 :com.palletops.awaze.client-builder/undef)
     (. bean5764 setRange (clojure.core/str v5766))))
   bean5764))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeJobRequest}
describe-job-request
  [m5768]
  (clojure.core/let
   [bean5767
    (new com.amazonaws.services.glacier.model.DescribeJobRequest)]
   (clojure.core/let
    [v5769 (:job-id m5768 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5769 :com.palletops.awaze.client-builder/undef)
     (. bean5767 setJobId (clojure.core/str v5769))))
   (clojure.core/let
    [v5769
     (:account-id m5768 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5769 :com.palletops.awaze.client-builder/undef)
     (. bean5767 setAccountId (clojure.core/str v5769))))
   (clojure.core/let
    [v5769
     (:vault-name m5768 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5769 :com.palletops.awaze.client-builder/undef)
     (. bean5767 setVaultName (clojure.core/str v5769))))
   bean5767))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultNotificationsRequest}
set-vault-notifications-request
  [m5771]
  (clojure.core/let
   [bean5770
    (new
     com.amazonaws.services.glacier.model.SetVaultNotificationsRequest)]
   (clojure.core/let
    [v5772
     (:account-id m5771 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5772 :com.palletops.awaze.client-builder/undef)
     (. bean5770 setAccountId (clojure.core/str v5772))))
   (clojure.core/let
    [v5772
     (:vault-name m5771 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5772 :com.palletops.awaze.client-builder/undef)
     (. bean5770 setVaultName (clojure.core/str v5772))))
   (clojure.core/let
    [v5772
     (:vault-notification-config
      m5771
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5772 :com.palletops.awaze.client-builder/undef)
     (.
      bean5770
      setVaultNotificationConfig
      (glacier/vault-notification-config v5772))))
   bean5770))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeVaultRequest}
describe-vault-request
  [m5774]
  (clojure.core/let
   [bean5773
    (new com.amazonaws.services.glacier.model.DescribeVaultRequest)]
   (clojure.core/let
    [v5775
     (:account-id m5774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5775 :com.palletops.awaze.client-builder/undef)
     (. bean5773 setAccountId (clojure.core/str v5775))))
   (clojure.core/let
    [v5775
     (:vault-name m5774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5775 :com.palletops.awaze.client-builder/undef)
     (. bean5773 setVaultName (clojure.core/str v5775))))
   bean5773))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortVaultLockRequest}
abort-vault-lock-request
  [m5777]
  (clojure.core/let
   [bean5776
    (new com.amazonaws.services.glacier.model.AbortVaultLockRequest)]
   (clojure.core/let
    [v5778
     (:account-id m5777 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5778 :com.palletops.awaze.client-builder/undef)
     (. bean5776 setAccountId (clojure.core/str v5778))))
   (clojure.core/let
    [v5778
     (:vault-name m5777 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5778 :com.palletops.awaze.client-builder/undef)
     (. bean5776 setVaultName (clojure.core/str v5778))))
   bean5776))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AddTagsToVaultRequest}
add-tags-to-vault-request
  [m5780]
  (clojure.core/let
   [bean5779
    (new com.amazonaws.services.glacier.model.AddTagsToVaultRequest)]
   (clojure.core/let
    [v5781 (:tags m5780 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5781 :com.palletops.awaze.client-builder/undef)
     (.
      bean5779
      setTags
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg5824] (clojure.core/str arg5824))
  (clojure.core/keys v5781))
 (clojure.core/map
  (clojure.core/fn [arg5824] (clojure.core/str arg5824))
  (clojure.core/vals v5781))))))
   (clojure.core/let
    [v5781
     (:account-id m5780 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5781 :com.palletops.awaze.client-builder/undef)
     (. bean5779 setAccountId (clojure.core/str v5781))))
   (clojure.core/let
    [v5781
     (:vault-name m5780 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5781 :com.palletops.awaze.client-builder/undef)
     (. bean5779 setVaultName (clojure.core/str v5781))))
   bean5779))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest}
set-vault-access-policy-request
  [m5783]
  (clojure.core/let
   [bean5782
    (new
     com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5784 (:policy m5783 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5784 :com.palletops.awaze.client-builder/undef)
     (. bean5782 setPolicy (glacier/vault-access-policy v5784))))
   (clojure.core/let
    [v5784
     (:account-id m5783 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5784 :com.palletops.awaze.client-builder/undef)
     (. bean5782 setAccountId (clojure.core/str v5784))))
   (clojure.core/let
    [v5784
     (:vault-name m5783 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5784 :com.palletops.awaze.client-builder/undef)
     (. bean5782 setVaultName (clojure.core/str v5784))))
   bean5782))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m5786]
  (clojure.core/let
   [bean5785
    (new
     com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v5787
     (:archive-size m5786 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5787 :com.palletops.awaze.client-builder/undef)
     (. bean5785 setArchiveSize (clojure.core/str v5787))))
   (clojure.core/let
    [v5787
     (:account-id m5786 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5787 :com.palletops.awaze.client-builder/undef)
     (. bean5785 setAccountId (clojure.core/str v5787))))
   (clojure.core/let
    [v5787
     (:vault-name m5786 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5787 :com.palletops.awaze.client-builder/undef)
     (. bean5785 setVaultName (clojure.core/str v5787))))
   (clojure.core/let
    [v5787
     (:checksum m5786 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5787 :com.palletops.awaze.client-builder/undef)
     (. bean5785 setChecksum (clojure.core/str v5787))))
   (clojure.core/let
    [v5787
     (:upload-id m5786 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5787 :com.palletops.awaze.client-builder/undef)
     (. bean5785 setUploadId (clojure.core/str v5787))))
   bean5785))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest}
get-data-retrieval-policy-request
  [m5789]
  (clojure.core/let
   [bean5788
    (new
     com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5790
     (:account-id m5789 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5790 :com.palletops.awaze.client-builder/undef)
     (. bean5788 setAccountId (clojure.core/str v5790))))
   bean5788))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateVaultLockRequest}
initiate-vault-lock-request
  [m5792]
  (clojure.core/let
   [bean5791
    (new
     com.amazonaws.services.glacier.model.InitiateVaultLockRequest)]
   (clojure.core/let
    [v5793 (:policy m5792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5793 :com.palletops.awaze.client-builder/undef)
     (. bean5791 setPolicy (glacier/vault-lock-policy v5793))))
   (clojure.core/let
    [v5793
     (:account-id m5792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5793 :com.palletops.awaze.client-builder/undef)
     (. bean5791 setAccountId (clojure.core/str v5793))))
   (clojure.core/let
    [v5793
     (:vault-name m5792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5793 :com.palletops.awaze.client-builder/undef)
     (. bean5791 setVaultName (clojure.core/str v5793))))
   bean5791))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteArchiveRequest}
delete-archive-request
  [m5795]
  (clojure.core/let
   [bean5794
    (new com.amazonaws.services.glacier.model.DeleteArchiveRequest)]
   (clojure.core/let
    [v5796
     (:account-id m5795 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5796 :com.palletops.awaze.client-builder/undef)
     (. bean5794 setAccountId (clojure.core/str v5796))))
   (clojure.core/let
    [v5796
     (:vault-name m5795 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5796 :com.palletops.awaze.client-builder/undef)
     (. bean5794 setVaultName (clojure.core/str v5796))))
   (clojure.core/let
    [v5796
     (:archive-id m5795 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5796 :com.palletops.awaze.client-builder/undef)
     (. bean5794 setArchiveId (clojure.core/str v5796))))
   bean5794))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest}
set-data-retrieval-policy-request
  [m5798]
  (clojure.core/let
   [bean5797
    (new
     com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5799 (:policy m5798 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5799 :com.palletops.awaze.client-builder/undef)
     (. bean5797 setPolicy (glacier/data-retrieval-policy v5799))))
   (clojure.core/let
    [v5799
     (:account-id m5798 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5799 :com.palletops.awaze.client-builder/undef)
     (. bean5797 setAccountId (clojure.core/str v5799))))
   bean5797))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultLockRequest}
get-vault-lock-request
  [m5801]
  (clojure.core/let
   [bean5800
    (new com.amazonaws.services.glacier.model.GetVaultLockRequest)]
   (clojure.core/let
    [v5802
     (:account-id m5801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5802 :com.palletops.awaze.client-builder/undef)
     (. bean5800 setAccountId (clojure.core/str v5802))))
   (clojure.core/let
    [v5802
     (:vault-name m5801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5802 :com.palletops.awaze.client-builder/undef)
     (. bean5800 setVaultName (clojure.core/str v5802))))
   bean5800))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListJobsRequest}
list-jobs-request
  [m5804]
  (clojure.core/let
   [bean5803
    (new com.amazonaws.services.glacier.model.ListJobsRequest)]
   (clojure.core/let
    [v5805 (:marker m5804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5805 :com.palletops.awaze.client-builder/undef)
     (. bean5803 setMarker (clojure.core/str v5805))))
   (clojure.core/let
    [v5805 (:limit m5804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5805 :com.palletops.awaze.client-builder/undef)
     (. bean5803 setLimit (clojure.core/str v5805))))
   (clojure.core/let
    [v5805
     (:account-id m5804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5805 :com.palletops.awaze.client-builder/undef)
     (. bean5803 setAccountId (clojure.core/str v5805))))
   (clojure.core/let
    [v5805
     (:vault-name m5804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5805 :com.palletops.awaze.client-builder/undef)
     (. bean5803 setVaultName (clojure.core/str v5805))))
   (clojure.core/let
    [v5805
     (:statuscode m5804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5805 :com.palletops.awaze.client-builder/undef)
     (. bean5803 setStatuscode (clojure.core/str v5805))))
   (clojure.core/let
    [v5805
     (:completed m5804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5805 :com.palletops.awaze.client-builder/undef)
     (. bean5803 setCompleted (clojure.core/str v5805))))
   bean5803))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m5807]
  (clojure.core/let
   [bean5806
    (new
     com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest)]
   (clojure.core/let
    [v5808
     (:account-id m5807 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5808 :com.palletops.awaze.client-builder/undef)
     (. bean5806 setAccountId (clojure.core/str v5808))))
   (clojure.core/let
    [v5808
     (:vault-name m5807 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5808 :com.palletops.awaze.client-builder/undef)
     (. bean5806 setVaultName (clojure.core/str v5808))))
   (clojure.core/let
    [v5808
     (:archive-description
      m5807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5808 :com.palletops.awaze.client-builder/undef)
     (. bean5806 setArchiveDescription (clojure.core/str v5808))))
   (clojure.core/let
    [v5808
     (:part-size m5807 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5808 :com.palletops.awaze.client-builder/undef)
     (. bean5806 setPartSize (clojure.core/str v5808))))
   bean5806))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListTagsForVaultRequest}
list-tags-for-vault-request
  [m5810]
  (clojure.core/let
   [bean5809
    (new com.amazonaws.services.glacier.model.ListTagsForVaultRequest)]
   (clojure.core/let
    [v5811
     (:account-id m5810 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5811 :com.palletops.awaze.client-builder/undef)
     (. bean5809 setAccountId (clojure.core/str v5811))))
   (clojure.core/let
    [v5811
     (:vault-name m5810 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5811 :com.palletops.awaze.client-builder/undef)
     (. bean5809 setVaultName (clojure.core/str v5811))))
   bean5809))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CreateVaultRequest}
create-vault-request
  [m5813]
  (clojure.core/let
   [bean5812
    (new com.amazonaws.services.glacier.model.CreateVaultRequest)]
   (clojure.core/let
    [v5814
     (:account-id m5813 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5814 :com.palletops.awaze.client-builder/undef)
     (. bean5812 setAccountId (clojure.core/str v5814))))
   (clojure.core/let
    [v5814
     (:vault-name m5813 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5814 :com.palletops.awaze.client-builder/undef)
     (. bean5812 setVaultName (clojure.core/str v5814))))
   bean5812))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest}
get-vault-access-policy-request
  [m5816]
  (clojure.core/let
   [bean5815
    (new
     com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5817
     (:account-id m5816 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5817 :com.palletops.awaze.client-builder/undef)
     (. bean5815 setAccountId (clojure.core/str v5817))))
   (clojure.core/let
    [v5817
     (:vault-name m5816 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5817 :com.palletops.awaze.client-builder/undef)
     (. bean5815 setVaultName (clojure.core/str v5817))))
   bean5815))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadArchiveRequest}
upload-archive-request
  [m5819]
  (clojure.core/let
   [bean5818
    (new com.amazonaws.services.glacier.model.UploadArchiveRequest)]
   (clojure.core/let
    [v5820 (:body m5819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5820 :com.palletops.awaze.client-builder/undef)
     (. bean5818 setBody (clojure.java.io/input-stream v5820))))
   (clojure.core/let
    [v5820
     (:content-length m5819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5820 :com.palletops.awaze.client-builder/undef)
     (. bean5818 setContentLength (clojure.core/long v5820))))
   (clojure.core/let
    [v5820
     (:account-id m5819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5820 :com.palletops.awaze.client-builder/undef)
     (. bean5818 setAccountId (clojure.core/str v5820))))
   (clojure.core/let
    [v5820
     (:vault-name m5819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5820 :com.palletops.awaze.client-builder/undef)
     (. bean5818 setVaultName (clojure.core/str v5820))))
   (clojure.core/let
    [v5820
     (:archive-description
      m5819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5820 :com.palletops.awaze.client-builder/undef)
     (. bean5818 setArchiveDescription (clojure.core/str v5820))))
   (clojure.core/let
    [v5820
     (:checksum m5819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5820 :com.palletops.awaze.client-builder/undef)
     (. bean5818 setChecksum (clojure.core/str v5820))))
   bean5818))
 (clojure.core/defmulti
  glacier
  (clojure.core/fn glacier [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   glacier
   :list-multipart-uploads
   [m5825]
   (clojure.core/let
    [credentials5826 (:credentials m5825) args5827 (:args m5825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5828
      (com.palletops.awaze.common/aws-client :glacier credentials5826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5828
       listMultipartUploads
       (glacier/list-multipart-uploads-request
        (clojure.core/nth args5827 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listMultipartUploads"}
   [credentials5830 & args5831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5832
     (com.palletops.awaze.common/aws-client :glacier credentials5830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5832
      listMultipartUploads
      (glacier/list-multipart-uploads-request
       (clojure.core/nth args5831 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault
   [m5833]
   (clojure.core/let
    [credentials5834 (:credentials m5833) args5835 (:args m5833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5836
      (com.palletops.awaze.common/aws-client :glacier credentials5834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5836
       deleteVault
       (glacier/delete-vault-request (clojure.core/nth args5835 0)))))))
  (clojure.core/defn
   delete-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVault"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vault,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVault"}
   [credentials5838 & args5839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5840
     (com.palletops.awaze.common/aws-client :glacier credentials5838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5840
      deleteVault
      (glacier/delete-vault-request (clojure.core/nth args5839 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-vault-lock
   [m5841]
   (clojure.core/let
    [credentials5842 (:credentials m5841) args5843 (:args m5841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5844
      (com.palletops.awaze.common/aws-client :glacier credentials5842)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5844
       completeVaultLock
       (glacier/complete-vault-lock-request
        (clojure.core/nth args5843 0)))))))
  (clojure.core/defn
   complete-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for completeVaultLock"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :complete-vault-lock,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call completeVaultLock"}
   [credentials5846 & args5847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5848
     (com.palletops.awaze.common/aws-client :glacier credentials5846)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5848
      completeVaultLock
      (glacier/complete-vault-lock-request
       (clojure.core/nth args5847 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-notifications
   [m5849]
   (clojure.core/let
    [credentials5850 (:credentials m5849) args5851 (:args m5849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5852
      (com.palletops.awaze.common/aws-client :glacier credentials5850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5852
       deleteVaultNotifications
       (glacier/delete-vault-notifications-request
        (clojure.core/nth args5851 0)))))))
  (clojure.core/defn
   delete-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultNotifications"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vault-notifications,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultNotifications"}
   [credentials5854 & args5855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5856
     (com.palletops.awaze.common/aws-client :glacier credentials5854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5856
      deleteVaultNotifications
      (glacier/delete-vault-notifications-request
       (clojure.core/nth args5855 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-access-policy
   [m5857]
   (clojure.core/let
    [credentials5858 (:credentials m5857) args5859 (:args m5857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5860
      (com.palletops.awaze.common/aws-client :glacier credentials5858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5860
       deleteVaultAccessPolicy
       (glacier/delete-vault-access-policy-request
        (clojure.core/nth args5859 0)))))))
  (clojure.core/defn
   delete-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultAccessPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vault-access-policy,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultAccessPolicy"}
   [credentials5862 & args5863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5864
     (com.palletops.awaze.common/aws-client :glacier credentials5862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5864
      deleteVaultAccessPolicy
      (glacier/delete-vault-access-policy-request
       (clojure.core/nth args5863 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :remove-tags-from-vault
   [m5865]
   (clojure.core/let
    [credentials5866 (:credentials m5865) args5867 (:args m5865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5868
      (com.palletops.awaze.common/aws-client :glacier credentials5866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5868
       removeTagsFromVault
       (glacier/remove-tags-from-vault-request
        (clojure.core/nth args5867 0)))))))
  (clojure.core/defn
   remove-tags-from-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromVault"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-tags-from-vault,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   remove-tags-from-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromVault"}
   [credentials5870 & args5871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5872
     (com.palletops.awaze.common/aws-client :glacier credentials5870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5872
      removeTagsFromVault
      (glacier/remove-tags-from-vault-request
       (clojure.core/nth args5871 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-multipart-upload
   [m5873]
   (clojure.core/let
    [credentials5874 (:credentials m5873) args5875 (:args m5873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5876
      (com.palletops.awaze.common/aws-client :glacier credentials5874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5876
       abortMultipartUpload
       (glacier/abort-multipart-upload-request
        (clojure.core/nth args5875 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials5878 & args5879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5880
     (com.palletops.awaze.common/aws-client :glacier credentials5878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5880
      abortMultipartUpload
      (glacier/abort-multipart-upload-request
       (clojure.core/nth args5879 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-multipart-part
   [m5881]
   (clojure.core/let
    [credentials5882 (:credentials m5881) args5883 (:args m5881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5884
      (com.palletops.awaze.common/aws-client :glacier credentials5882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5884
       uploadMultipartPart
       (glacier/upload-multipart-part-request
        (clojure.core/nth args5883 0)))))))
  (clojure.core/defn
   upload-multipart-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Generate map for uploadMultipartPart"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :upload-multipart-part,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-multipart-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Call uploadMultipartPart"}
   [credentials5886 & args5887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5888
     (com.palletops.awaze.common/aws-client :glacier credentials5886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5888
      uploadMultipartPart
      (glacier/upload-multipart-part-request
       (clojure.core/nth args5887 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-vaults
   [m5889]
   (clojure.core/let
    [credentials5890 (:credentials m5889) args5891 (:args m5889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5892
      (com.palletops.awaze.common/aws-client :glacier credentials5890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5892
       listVaults
       (glacier/list-vaults-request (clojure.core/nth args5891 0)))))))
  (clojure.core/defn
   list-vaults-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVaults"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-vaults,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-vaults
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVaults"}
   [credentials5894 & args5895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5896
     (com.palletops.awaze.common/aws-client :glacier credentials5894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5896
      listVaults
      (glacier/list-vaults-request (clojure.core/nth args5895 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-job
   [m5897]
   (clojure.core/let
    [credentials5898 (:credentials m5897) args5899 (:args m5897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5900
      (com.palletops.awaze.common/aws-client :glacier credentials5898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5900
       initiateJob
       (glacier/initiate-job-request (clojure.core/nth args5899 0)))))))
  (clojure.core/defn
   initiate-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Generate map for initiateJob"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :initiate-job,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Call initiateJob"}
   [credentials5902 & args5903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5904
     (com.palletops.awaze.common/aws-client :glacier credentials5902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5904
      initiateJob
      (glacier/initiate-job-request (clojure.core/nth args5903 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-parts
   [m5905]
   (clojure.core/let
    [credentials5906 (:credentials m5905) args5907 (:args m5905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5908
      (com.palletops.awaze.common/aws-client :glacier credentials5906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5908
       listParts
       (glacier/list-parts-request (clojure.core/nth args5907 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listParts"}
   [credentials5910 & args5911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5912
     (com.palletops.awaze.common/aws-client :glacier credentials5910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5912
      listParts
      (glacier/list-parts-request (clojure.core/nth args5911 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-notifications
   [m5913]
   (clojure.core/let
    [credentials5914 (:credentials m5913) args5915 (:args m5913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5916
      (com.palletops.awaze.common/aws-client :glacier credentials5914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5916
       getVaultNotifications
       (glacier/get-vault-notifications-request
        (clojure.core/nth args5915 0)))))))
  (clojure.core/defn
   get-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultNotifications"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-vault-notifications,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultNotifications"}
   [credentials5918 & args5919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5920
     (com.palletops.awaze.common/aws-client :glacier credentials5918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5920
      getVaultNotifications
      (glacier/get-vault-notifications-request
       (clojure.core/nth args5919 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-job-output
   [m5921]
   (clojure.core/let
    [credentials5922 (:credentials m5921) args5923 (:args m5921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5924
      (com.palletops.awaze.common/aws-client :glacier credentials5922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5924
       getJobOutput
       (glacier/get-job-output-request (clojure.core/nth args5923 0)))))))
  (clojure.core/defn
   get-job-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Generate map for getJobOutput"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-job-output,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-job-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Call getJobOutput"}
   [credentials5926 & args5927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5928
     (com.palletops.awaze.common/aws-client :glacier credentials5926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5928
      getJobOutput
      (glacier/get-job-output-request (clojure.core/nth args5927 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-job
   [m5929]
   (clojure.core/let
    [credentials5930 (:credentials m5929) args5931 (:args m5929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5932
      (com.palletops.awaze.common/aws-client :glacier credentials5930)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5932
       describeJob
       (glacier/describe-job-request (clojure.core/nth args5931 0)))))))
  (clojure.core/defn
   describe-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeJob"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-job,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeJob"}
   [credentials5934 & args5935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5936
     (com.palletops.awaze.common/aws-client :glacier credentials5934)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5936
      describeJob
      (glacier/describe-job-request (clojure.core/nth args5935 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-notifications
   [m5937]
   (clojure.core/let
    [credentials5938 (:credentials m5937) args5939 (:args m5937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5940
      (com.palletops.awaze.common/aws-client :glacier credentials5938)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5940
       setVaultNotifications
       (glacier/set-vault-notifications-request
        (clojure.core/nth args5939 0)))))))
  (clojure.core/defn
   set-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultNotifications"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-vault-notifications,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultNotifications"}
   [credentials5942 & args5943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5944
     (com.palletops.awaze.common/aws-client :glacier credentials5942)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5944
      setVaultNotifications
      (glacier/set-vault-notifications-request
       (clojure.core/nth args5943 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-vault
   [m5945]
   (clojure.core/let
    [credentials5946 (:credentials m5945) args5947 (:args m5945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5948
      (com.palletops.awaze.common/aws-client :glacier credentials5946)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5948
       describeVault
       (glacier/describe-vault-request (clojure.core/nth args5947 0)))))))
  (clojure.core/defn
   describe-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVault"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vault,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVault"}
   [credentials5950 & args5951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5952
     (com.palletops.awaze.common/aws-client :glacier credentials5950)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5952
      describeVault
      (glacier/describe-vault-request (clojure.core/nth args5951 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-vault-lock
   [m5953]
   (clojure.core/let
    [credentials5954 (:credentials m5953) args5955 (:args m5953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5956
      (com.palletops.awaze.common/aws-client :glacier credentials5954)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5956
       abortVaultLock
       (glacier/abort-vault-lock-request
        (clojure.core/nth args5955 0)))))))
  (clojure.core/defn
   abort-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortVaultLock"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :abort-vault-lock,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortVaultLock"}
   [credentials5958 & args5959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5960
     (com.palletops.awaze.common/aws-client :glacier credentials5958)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5960
      abortVaultLock
      (glacier/abort-vault-lock-request (clojure.core/nth args5959 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :add-tags-to-vault
   [m5961]
   (clojure.core/let
    [credentials5962 (:credentials m5961) args5963 (:args m5961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5964
      (com.palletops.awaze.common/aws-client :glacier credentials5962)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5964
       addTagsToVault
       (glacier/add-tags-to-vault-request
        (clojure.core/nth args5963 0)))))))
  (clojure.core/defn
   add-tags-to-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToVault"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-tags-to-vault,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   add-tags-to-vault
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToVault"}
   [credentials5966 & args5967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5968
     (com.palletops.awaze.common/aws-client :glacier credentials5966)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5968
      addTagsToVault
      (glacier/add-tags-to-vault-request
       (clojure.core/nth args5967 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-access-policy
   [m5969]
   (clojure.core/let
    [credentials5970 (:credentials m5969) args5971 (:args m5969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5972
      (com.palletops.awaze.common/aws-client :glacier credentials5970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5972
       setVaultAccessPolicy
       (glacier/set-vault-access-policy-request
        (clojure.core/nth args5971 0)))))))
  (clojure.core/defn
   set-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultAccessPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-vault-access-policy,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultAccessPolicy"}
   [credentials5974 & args5975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5976
     (com.palletops.awaze.common/aws-client :glacier credentials5974)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5976
      setVaultAccessPolicy
      (glacier/set-vault-access-policy-request
       (clojure.core/nth args5975 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-multipart-upload
   [m5977]
   (clojure.core/let
    [credentials5978 (:credentials m5977) args5979 (:args m5977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5980
      (com.palletops.awaze.common/aws-client :glacier credentials5978)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5980
       completeMultipartUpload
       (glacier/complete-multipart-upload-request
        (clojure.core/nth args5979 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials5982 & args5983]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5984
     (com.palletops.awaze.common/aws-client :glacier credentials5982)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5984
      completeMultipartUpload
      (glacier/complete-multipart-upload-request
       (clojure.core/nth args5983 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-data-retrieval-policy
   [m5985]
   (clojure.core/let
    [credentials5986 (:credentials m5985) args5987 (:args m5985)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5988
      (com.palletops.awaze.common/aws-client :glacier credentials5986)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5988
       getDataRetrievalPolicy
       (glacier/get-data-retrieval-policy-request
        (clojure.core/nth args5987 0)))))))
  (clojure.core/defn
   get-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDataRetrievalPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-data-retrieval-policy,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDataRetrievalPolicy"}
   [credentials5990 & args5991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5992
     (com.palletops.awaze.common/aws-client :glacier credentials5990)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5992
      getDataRetrievalPolicy
      (glacier/get-data-retrieval-policy-request
       (clojure.core/nth args5991 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-vault-lock
   [m5993]
   (clojure.core/let
    [credentials5994 (:credentials m5993) args5995 (:args m5993)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5996
      (com.palletops.awaze.common/aws-client :glacier credentials5994)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5996
       initiateVaultLock
       (glacier/initiate-vault-lock-request
        (clojure.core/nth args5995 0)))))))
  (clojure.core/defn
   initiate-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for initiateVaultLock"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :initiate-vault-lock,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call initiateVaultLock"}
   [credentials5998 & args5999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6000
     (com.palletops.awaze.common/aws-client :glacier credentials5998)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6000
      initiateVaultLock
      (glacier/initiate-vault-lock-request
       (clojure.core/nth args5999 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-archive
   [m6001]
   (clojure.core/let
    [credentials6002 (:credentials m6001) args6003 (:args m6001)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6004
      (com.palletops.awaze.common/aws-client :glacier credentials6002)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6004
       deleteArchive
       (glacier/delete-archive-request (clojure.core/nth args6003 0)))))))
  (clojure.core/defn
   delete-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteArchive"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-archive,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteArchive"}
   [credentials6006 & args6007]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6008
     (com.palletops.awaze.common/aws-client :glacier credentials6006)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6008
      deleteArchive
      (glacier/delete-archive-request (clojure.core/nth args6007 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-data-retrieval-policy
   [m6009]
   (clojure.core/let
    [credentials6010 (:credentials m6009) args6011 (:args m6009)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6012
      (com.palletops.awaze.common/aws-client :glacier credentials6010)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6012
       setDataRetrievalPolicy
       (glacier/set-data-retrieval-policy-request
        (clojure.core/nth args6011 0)))))))
  (clojure.core/defn
   set-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDataRetrievalPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-data-retrieval-policy,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setDataRetrievalPolicy"}
   [credentials6014 & args6015]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6016
     (com.palletops.awaze.common/aws-client :glacier credentials6014)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6016
      setDataRetrievalPolicy
      (glacier/set-data-retrieval-policy-request
       (clojure.core/nth args6015 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-lock
   [m6017]
   (clojure.core/let
    [credentials6018 (:credentials m6017) args6019 (:args m6017)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6020
      (com.palletops.awaze.common/aws-client :glacier credentials6018)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6020
       getVaultLock
       (glacier/get-vault-lock-request (clojure.core/nth args6019 0)))))))
  (clojure.core/defn
   get-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultLock"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-vault-lock,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultLock"}
   [credentials6022 & args6023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6024
     (com.palletops.awaze.common/aws-client :glacier credentials6022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6024
      getVaultLock
      (glacier/get-vault-lock-request (clojure.core/nth args6023 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-jobs
   [m6025]
   (clojure.core/let
    [credentials6026 (:credentials m6025) args6027 (:args m6025)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6028
      (com.palletops.awaze.common/aws-client :glacier credentials6026)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6028
       listJobs
       (glacier/list-jobs-request (clojure.core/nth args6027 0)))))))
  (clojure.core/defn
   list-jobs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listJobs"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-jobs,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-jobs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listJobs"}
   [credentials6030 & args6031]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6032
     (com.palletops.awaze.common/aws-client :glacier credentials6030)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6032
      listJobs
      (glacier/list-jobs-request (clojure.core/nth args6031 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-multipart-upload
   [m6033]
   (clojure.core/let
    [credentials6034 (:credentials m6033) args6035 (:args m6033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6036
      (com.palletops.awaze.common/aws-client :glacier credentials6034)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6036
       initiateMultipartUpload
       (glacier/initiate-multipart-upload-request
        (clojure.core/nth args6035 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials6038 & args6039]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6040
     (com.palletops.awaze.common/aws-client :glacier credentials6038)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6040
      initiateMultipartUpload
      (glacier/initiate-multipart-upload-request
       (clojure.core/nth args6039 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-tags-for-vault
   [m6041]
   (clojure.core/let
    [credentials6042 (:credentials m6041) args6043 (:args m6041)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6044
      (com.palletops.awaze.common/aws-client :glacier credentials6042)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6044
       listTagsForVault
       (glacier/list-tags-for-vault-request
        (clojure.core/nth args6043 0)))))))
  (clojure.core/defn
   list-tags-for-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForVault"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-tags-for-vault,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-tags-for-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForVault"}
   [credentials6046 & args6047]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6048
     (com.palletops.awaze.common/aws-client :glacier credentials6046)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6048
      listTagsForVault
      (glacier/list-tags-for-vault-request
       (clojure.core/nth args6047 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :create-vault
   [m6049]
   (clojure.core/let
    [credentials6050 (:credentials m6049) args6051 (:args m6049)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6052
      (com.palletops.awaze.common/aws-client :glacier credentials6050)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6052
       createVault
       (glacier/create-vault-request (clojure.core/nth args6051 0)))))))
  (clojure.core/defn
   create-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVault"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vault,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   create-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVault"}
   [credentials6054 & args6055]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6056
     (com.palletops.awaze.common/aws-client :glacier credentials6054)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6056
      createVault
      (glacier/create-vault-request (clojure.core/nth args6055 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-access-policy
   [m6057]
   (clojure.core/let
    [credentials6058 (:credentials m6057) args6059 (:args m6057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6060
      (com.palletops.awaze.common/aws-client :glacier credentials6058)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6060
       getVaultAccessPolicy
       (glacier/get-vault-access-policy-request
        (clojure.core/nth args6059 0)))))))
  (clojure.core/defn
   get-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultAccessPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-vault-access-policy,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultAccessPolicy"}
   [credentials6062 & args6063]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6064
     (com.palletops.awaze.common/aws-client :glacier credentials6062)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6064
      getVaultAccessPolicy
      (glacier/get-vault-access-policy-request
       (clojure.core/nth args6063 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-archive
   [m6065]
   (clojure.core/let
    [credentials6066 (:credentials m6065) args6067 (:args m6065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6068
      (com.palletops.awaze.common/aws-client :glacier credentials6066)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6068
       uploadArchive
       (glacier/upload-archive-request (clojure.core/nth args6067 0)))))))
  (clojure.core/defn
   upload-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Generate map for uploadArchive"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :upload-archive,
     :credentials credentials__1784__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Call uploadArchive"}
   [credentials6070 & args6071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6072
     (com.palletops.awaze.common/aws-client :glacier credentials6070)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6072
      uploadArchive
      (glacier/upload-archive-request (clojure.core/nth args6071 0))))))))
