(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Configuration}
configuration
  [m8104]
  (clojure.core/let
   [bean8103
    (new com.amazonaws.services.elasticmapreduce.model.Configuration)]
   (clojure.core/let
    [v8105
     (:properties m8104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8105 :com.palletops.awaze.client-builder/undef)
     (.
      bean8103
      setProperties
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8202] (clojure.core/str arg8202))
  (clojure.core/keys v8105))
 (clojure.core/map
  (clojure.core/fn [arg8202] (clojure.core/str arg8202))
  (clojure.core/vals v8105))))))
   (clojure.core/let
    [v8105
     (:configurations m8104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8105 :com.palletops.awaze.client-builder/undef)
     (.
      bean8103
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8203] (elasticmapreduce/configuration arg8203))
 v8105))))
   (clojure.core/let
    [v8105
     (:classification m8104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8105 :com.palletops.awaze.client-builder/undef)
     (. bean8103 setClassification (clojure.core/str v8105))))
   bean8103))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.VolumeSpecification}
volume-specification
  [m8107]
  (clojure.core/let
   [bean8106
    (new
     com.amazonaws.services.elasticmapreduce.model.VolumeSpecification)]
   (clojure.core/let
    [v8108
     (:volume-type m8107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8108 :com.palletops.awaze.client-builder/undef)
     (. bean8106 setVolumeType (clojure.core/str v8108))))
   (clojure.core/let
    [v8108 (:iops m8107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8108 :com.palletops.awaze.client-builder/undef)
     (. bean8106 setIops (clojure.core/int v8108))))
   (clojure.core/let
    [v8108
     (:size-in-gb m8107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8108 :com.palletops.awaze.client-builder/undef)
     (. bean8106 setSizeInGB (clojure.core/int v8108))))
   bean8106))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig}
ebs-block-device-config
  [m8110]
  (clojure.core/let
   [bean8109
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig)]
   (clojure.core/let
    [v8111
     (:volume-specification
      m8110
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8111 :com.palletops.awaze.client-builder/undef)
     (.
      bean8109
      setVolumeSpecification
      (elasticmapreduce/volume-specification v8111))))
   (clojure.core/let
    [v8111
     (:volumes-per-instance
      m8110
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8111 :com.palletops.awaze.client-builder/undef)
     (. bean8109 setVolumesPerInstance (clojure.core/int v8111))))
   bean8109))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsConfiguration}
ebs-configuration
  [m8113]
  (clojure.core/let
   [bean8112
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsConfiguration)]
   (clojure.core/let
    [v8114
     (:ebs-optimized m8113 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8114 :com.palletops.awaze.client-builder/undef)
     (. bean8112 setEbsOptimized (clojure.core/boolean v8114))))
   (clojure.core/let
    [v8114
     (:ebs-block-device-configs
      m8113
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8114 :com.palletops.awaze.client-builder/undef)
     (.
      bean8112
      setEbsBlockDeviceConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8204]
  (elasticmapreduce/ebs-block-device-config arg8204))
 v8114))))
   bean8112))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m8116]
  (clojure.core/let
   [bean8115
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/let
    [v8117 (:value m8116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8117 :com.palletops.awaze.client-builder/undef)
     (. bean8115 setValue (clojure.core/str v8117))))
   (clojure.core/let
    [v8117 (:key m8116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8117 :com.palletops.awaze.client-builder/undef)
     (. bean8115 setKey (clojure.core/str v8117))))
   bean8115))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m8119]
  (clojure.core/let
   [bean8118
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/let
    [v8120
     (:availability-zone
      m8119
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8120 :com.palletops.awaze.client-builder/undef)
     (. bean8118 setAvailabilityZone (clojure.core/str v8120))))
   bean8118))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m8122]
  (clojure.core/let
   [bean8121
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/let
    [v8123 (:name m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (. bean8121 setName (clojure.core/str v8123))))
   (clojure.core/let
    [v8123
     (:instance-type m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (. bean8121 setInstanceType (clojure.core/str v8123))))
   (clojure.core/let
    [v8123
     (:instance-count m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (. bean8121 setInstanceCount (clojure.core/int v8123))))
   (clojure.core/let
    [v8123
     (:configurations m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (.
      bean8121
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8205] (elasticmapreduce/configuration arg8205))
 v8123))))
   (clojure.core/let
    [v8123 (:market m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (. bean8121 setMarket (clojure.core/str v8123))))
   (clojure.core/let
    [v8123
     (:instance-role m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (. bean8121 setInstanceRole (clojure.core/str v8123))))
   (clojure.core/let
    [v8123
     (:bid-price m8122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (. bean8121 setBidPrice (clojure.core/str v8123))))
   (clojure.core/let
    [v8123
     (:ebs-configuration
      m8122
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8123 :com.palletops.awaze.client-builder/undef)
     (.
      bean8121
      setEbsConfiguration
      (elasticmapreduce/ebs-configuration v8123))))
   bean8121))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m8125]
  (clojure.core/let
   [bean8124
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/let
    [v8126
     (:properties m8125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8126 :com.palletops.awaze.client-builder/undef)
     (.
      bean8124
      setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8206] (elasticmapreduce/key-value arg8206))
 v8126))))
   (clojure.core/let
    [v8126 (:args m8125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8126 :com.palletops.awaze.client-builder/undef)
     (.
      bean8124
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8207] (clojure.core/str arg8207))
 v8126))))
   (clojure.core/let
    [v8126 (:jar m8125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8126 :com.palletops.awaze.client-builder/undef)
     (. bean8124 setJar (clojure.core/str v8126))))
   (clojure.core/let
    [v8126
     (:main-class m8125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8126 :com.palletops.awaze.client-builder/undef)
     (. bean8124 setMainClass (clojure.core/str v8126))))
   bean8124))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m8128]
  (clojure.core/let
   [bean8127
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/let
    [v8129 (:args m8128 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8129 :com.palletops.awaze.client-builder/undef)
     (.
      bean8127
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8208] (clojure.core/str arg8208))
 v8129))))
   (clojure.core/let
    [v8129 (:path m8128 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8129 :com.palletops.awaze.client-builder/undef)
     (. bean8127 setPath (clojure.core/str v8129))))
   bean8127))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m8131]
  (clojure.core/let
   [bean8130
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/let
    [v8132
     (:ec2instance-ids-to-terminate
      m8131
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8132 :com.palletops.awaze.client-builder/undef)
     (.
      bean8130
      setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8209] (clojure.core/str arg8209))
 v8132))))
   (clojure.core/let
    [v8132
     (:instance-count m8131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8132 :com.palletops.awaze.client-builder/undef)
     (. bean8130 setInstanceCount (clojure.core/int v8132))))
   (clojure.core/let
    [v8132
     (:instance-group-id
      m8131
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8132 :com.palletops.awaze.client-builder/undef)
     (. bean8130 setInstanceGroupId (clojure.core/str v8132))))
   bean8130))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m8134]
  (clojure.core/let
   [bean8133 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/let
    [v8135 (:value m8134 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8135 :com.palletops.awaze.client-builder/undef)
     (. bean8133 setValue (clojure.core/str v8135))))
   (clojure.core/let
    [v8135 (:key m8134 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8135 :com.palletops.awaze.client-builder/undef)
     (. bean8133 setKey (clojure.core/str v8135))))
   bean8133))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m8137]
  (clojure.core/let
   [bean8136
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/let
    [v8138
     (:additional-master-security-groups
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setAdditionalMasterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8210] (clojure.core/str arg8210))
 v8138))))
   (clojure.core/let
    [v8138
     (:keep-job-flow-alive-when-no-steps
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setKeepJobFlowAliveWhenNoSteps
      (clojure.core/boolean v8138))))
   (clojure.core/let
    [v8138
     (:placement m8137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setPlacement (elasticmapreduce/placement-type v8138))))
   (clojure.core/let
    [v8138
     (:hadoop-version m8137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setHadoopVersion (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:ec2subnet-id m8137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setEc2SubnetId (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:master-instance-type
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setMasterInstanceType (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:slave-instance-type
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setSlaveInstanceType (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:termination-protected
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setTerminationProtected (clojure.core/boolean v8138))))
   (clojure.core/let
    [v8138
     (:emr-managed-master-security-group
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setEmrManagedMasterSecurityGroup
      (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:additional-slave-security-groups
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setAdditionalSlaveSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8211] (clojure.core/str arg8211))
 v8138))))
   (clojure.core/let
    [v8138
     (:ec2key-name m8137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setEc2KeyName (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:instance-count m8137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (. bean8136 setInstanceCount (clojure.core/int v8138))))
   (clojure.core/let
    [v8138
     (:instance-groups
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8212]
  (elasticmapreduce/instance-group-config arg8212))
 v8138))))
   (clojure.core/let
    [v8138
     (:service-access-security-group
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setServiceAccessSecurityGroup
      (clojure.core/str v8138))))
   (clojure.core/let
    [v8138
     (:emr-managed-slave-security-group
      m8137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8138 :com.palletops.awaze.client-builder/undef)
     (.
      bean8136
      setEmrManagedSlaveSecurityGroup
      (clojure.core/str v8138))))
   bean8136))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Application}
application
  [m8140]
  (clojure.core/let
   [bean8139
    (new com.amazonaws.services.elasticmapreduce.model.Application)]
   (clojure.core/let
    [v8141 (:name m8140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8141 :com.palletops.awaze.client-builder/undef)
     (. bean8139 setName (clojure.core/str v8141))))
   (clojure.core/let
    [v8141
     (:additional-info
      m8140
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8141 :com.palletops.awaze.client-builder/undef)
     (.
      bean8139
      setAdditionalInfo
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8213] (clojure.core/str arg8213))
  (clojure.core/keys v8141))
 (clojure.core/map
  (clojure.core/fn [arg8213] (clojure.core/str arg8213))
  (clojure.core/vals v8141))))))
   (clojure.core/let
    [v8141 (:version m8140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8141 :com.palletops.awaze.client-builder/undef)
     (. bean8139 setVersion (clojure.core/str v8141))))
   (clojure.core/let
    [v8141 (:args m8140 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8141 :com.palletops.awaze.client-builder/undef)
     (.
      bean8139
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8214] (clojure.core/str arg8214))
 v8141))))
   bean8139))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m8143]
  (clojure.core/let
   [bean8142
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/let
    [v8144 (:name m8143 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8144 :com.palletops.awaze.client-builder/undef)
     (. bean8142 setName (clojure.core/str v8144))))
   (clojure.core/let
    [v8144
     (:action-on-failure
      m8143
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8144 :com.palletops.awaze.client-builder/undef)
     (. bean8142 setActionOnFailure (clojure.core/str v8144))))
   (clojure.core/let
    [v8144
     (:hadoop-jar-step
      m8143
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8144 :com.palletops.awaze.client-builder/undef)
     (.
      bean8142
      setHadoopJarStep
      (elasticmapreduce/hadoop-jar-step-config v8144))))
   bean8142))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m8146]
  (clojure.core/let
   [bean8145
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/let
    [v8147 (:name m8146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8147 :com.palletops.awaze.client-builder/undef)
     (. bean8145 setName (clojure.core/str v8147))))
   (clojure.core/let
    [v8147 (:args m8146 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8147 :com.palletops.awaze.client-builder/undef)
     (.
      bean8145
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8215] (clojure.core/str arg8215))
 v8147))))
   bean8145))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m8149]
  (clojure.core/let
   [bean8148
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/let
    [v8150 (:name m8149 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8150 :com.palletops.awaze.client-builder/undef)
     (. bean8148 setName (clojure.core/str v8150))))
   (clojure.core/let
    [v8150
     (:script-bootstrap-action
      m8149
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8150 :com.palletops.awaze.client-builder/undef)
     (.
      bean8148
      setScriptBootstrapAction
      (elasticmapreduce/script-bootstrap-action-config v8150))))
   bean8148))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m8152]
  (clojure.core/let
   [bean8151
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/let
    [v8153
     (:instance-groups
      m8152
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8153 :com.palletops.awaze.client-builder/undef)
     (.
      bean8151
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8216]
  (elasticmapreduce/instance-group-modify-config arg8216))
 v8153))))
   bean8151))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m8155]
  (clojure.core/let
   [bean8154
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/let
    [v8156 (:marker m8155 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8156 :com.palletops.awaze.client-builder/undef)
     (. bean8154 setMarker (clojure.core/str v8156))))
   (clojure.core/let
    [v8156
     (:cluster-id m8155 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8156 :com.palletops.awaze.client-builder/undef)
     (. bean8154 setClusterId (clojure.core/str v8156))))
   bean8154))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m8158]
  (clojure.core/let
   [bean8157
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/let
    [v8159 (:marker m8158 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8159 :com.palletops.awaze.client-builder/undef)
     (. bean8157 setMarker (clojure.core/str v8159))))
   (clojure.core/let
    [v8159
     (:created-after m8158 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8159 :com.palletops.awaze.client-builder/undef)
     (.
      bean8157
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8159))))
   (clojure.core/let
    [v8159
     (:created-before m8158 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8159 :com.palletops.awaze.client-builder/undef)
     (.
      bean8157
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8159))))
   (clojure.core/let
    [v8159
     (:cluster-states m8158 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8159 :com.palletops.awaze.client-builder/undef)
     (.
      bean8157
      setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8217] (clojure.core/str arg8217))
 v8159))))
   bean8157))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m8161]
  (clojure.core/let
   [bean8160
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/let
    [v8162
     (:tag-keys m8161 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8162 :com.palletops.awaze.client-builder/undef)
     (.
      bean8160
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8218] (clojure.core/str arg8218))
 v8162))))
   (clojure.core/let
    [v8162
     (:resource-id m8161 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8162 :com.palletops.awaze.client-builder/undef)
     (. bean8160 setResourceId (clojure.core/str v8162))))
   bean8160))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m8164]
  (clojure.core/let
   [bean8163
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/let
    [v8165 (:tags m8164 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8165 :com.palletops.awaze.client-builder/undef)
     (.
      bean8163
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8219] (elasticmapreduce/tag arg8219))
 v8165))))
   (clojure.core/let
    [v8165
     (:resource-id m8164 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8165 :com.palletops.awaze.client-builder/undef)
     (. bean8163 setResourceId (clojure.core/str v8165))))
   bean8163))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m8167]
  (clojure.core/let
   [bean8166
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/let
    [v8168
     (:visible-to-all-users
      m8167
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8168 :com.palletops.awaze.client-builder/undef)
     (. bean8166 setVisibleToAllUsers (clojure.core/boolean v8168))))
   (clojure.core/let
    [v8168
     (:job-flow-ids m8167 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8168 :com.palletops.awaze.client-builder/undef)
     (.
      bean8166
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8220] (clojure.core/str arg8220))
 v8168))))
   bean8166))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m8170]
  (clojure.core/let
   [bean8169
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/let
    [v8171 (:marker m8170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8171 :com.palletops.awaze.client-builder/undef)
     (. bean8169 setMarker (clojure.core/str v8171))))
   (clojure.core/let
    [v8171
     (:cluster-id m8170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8171 :com.palletops.awaze.client-builder/undef)
     (. bean8169 setClusterId (clojure.core/str v8171))))
   (clojure.core/let
    [v8171
     (:instance-group-id
      m8170
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8171 :com.palletops.awaze.client-builder/undef)
     (. bean8169 setInstanceGroupId (clojure.core/str v8171))))
   (clojure.core/let
    [v8171
     (:instance-group-types
      m8170
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8171 :com.palletops.awaze.client-builder/undef)
     (.
      bean8169
      setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8221] (clojure.core/str arg8221))
 v8171))))
   bean8169))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m8173]
  (clojure.core/let
   [bean8172
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/let
    [v8174
     (:cluster-id m8173 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8174 :com.palletops.awaze.client-builder/undef)
     (. bean8172 setClusterId (clojure.core/str v8174))))
   bean8172))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m8176]
  (clojure.core/let
   [bean8175
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/let
    [v8177 (:marker m8176 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8177 :com.palletops.awaze.client-builder/undef)
     (. bean8175 setMarker (clojure.core/str v8177))))
   (clojure.core/let
    [v8177
     (:cluster-id m8176 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8177 :com.palletops.awaze.client-builder/undef)
     (. bean8175 setClusterId (clojure.core/str v8177))))
   bean8175))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m8179]
  (clojure.core/let
   [bean8178
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/let
    [v8180
     (:job-flow-ids m8179 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8180 :com.palletops.awaze.client-builder/undef)
     (.
      bean8178
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8222] (clojure.core/str arg8222))
 v8180))))
   bean8178))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m8182]
  (clojure.core/let
   [bean8181
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/let
    [v8183
     (:created-after m8182 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8183 :com.palletops.awaze.client-builder/undef)
     (.
      bean8181
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8183))))
   (clojure.core/let
    [v8183
     (:created-before m8182 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8183 :com.palletops.awaze.client-builder/undef)
     (.
      bean8181
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8183))))
   (clojure.core/let
    [v8183
     (:job-flow-ids m8182 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8183 :com.palletops.awaze.client-builder/undef)
     (.
      bean8181
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8223] (clojure.core/str arg8223))
 v8183))))
   (clojure.core/let
    [v8183
     (:job-flow-states
      m8182
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8183 :com.palletops.awaze.client-builder/undef)
     (.
      bean8181
      setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8224] (clojure.core/str arg8224))
 v8183))))
   bean8181))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m8185]
  (clojure.core/let
   [bean8184
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/let
    [v8186
     (:job-flow-role m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setJobFlowRole (clojure.core/str v8186))))
   (clojure.core/let
    [v8186
     (:instances m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setInstances
      (elasticmapreduce/job-flow-instances-config v8186))))
   (clojure.core/let
    [v8186
     (:additional-info
      m8185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setAdditionalInfo (clojure.core/str v8186))))
   (clojure.core/let
    [v8186
     (:visible-to-all-users
      m8185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setVisibleToAllUsers (clojure.core/boolean v8186))))
   (clojure.core/let
    [v8186 (:name m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setName (clojure.core/str v8186))))
   (clojure.core/let
    [v8186
     (:applications m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setApplications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8225] (elasticmapreduce/application arg8225))
 v8186))))
   (clojure.core/let
    [v8186
     (:service-role m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setServiceRole (clojure.core/str v8186))))
   (clojure.core/let
    [v8186 (:steps m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8226] (elasticmapreduce/step-config arg8226))
 v8186))))
   (clojure.core/let
    [v8186
     (:supported-products
      m8185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8227] (clojure.core/str arg8227))
 v8186))))
   (clojure.core/let
    [v8186
     (:ami-version m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setAmiVersion (clojure.core/str v8186))))
   (clojure.core/let
    [v8186 (:tags m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8228] (elasticmapreduce/tag arg8228))
 v8186))))
   (clojure.core/let
    [v8186 (:log-uri m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setLogUri (clojure.core/str v8186))))
   (clojure.core/let
    [v8186
     (:configurations m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8229] (elasticmapreduce/configuration arg8229))
 v8186))))
   (clojure.core/let
    [v8186
     (:release-label m8185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (. bean8184 setReleaseLabel (clojure.core/str v8186))))
   (clojure.core/let
    [v8186
     (:new-supported-products
      m8185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8230]
  (elasticmapreduce/supported-product-config arg8230))
 v8186))))
   (clojure.core/let
    [v8186
     (:bootstrap-actions
      m8185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8186 :com.palletops.awaze.client-builder/undef)
     (.
      bean8184
      setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8231]
  (elasticmapreduce/bootstrap-action-config arg8231))
 v8186))))
   bean8184))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m8188]
  (clojure.core/let
   [bean8187
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/let
    [v8189
     (:instance-groups
      m8188
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8189 :com.palletops.awaze.client-builder/undef)
     (.
      bean8187
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8232]
  (elasticmapreduce/instance-group-config arg8232))
 v8189))))
   (clojure.core/let
    [v8189
     (:job-flow-id m8188 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8189 :com.palletops.awaze.client-builder/undef)
     (. bean8187 setJobFlowId (clojure.core/str v8189))))
   bean8187))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m8191]
  (clojure.core/let
   [bean8190
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/let
    [v8192 (:marker m8191 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8192 :com.palletops.awaze.client-builder/undef)
     (. bean8190 setMarker (clojure.core/str v8192))))
   (clojure.core/let
    [v8192
     (:cluster-id m8191 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8192 :com.palletops.awaze.client-builder/undef)
     (. bean8190 setClusterId (clojure.core/str v8192))))
   (clojure.core/let
    [v8192
     (:step-states m8191 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8192 :com.palletops.awaze.client-builder/undef)
     (.
      bean8190
      setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8233] (clojure.core/str arg8233))
 v8192))))
   (clojure.core/let
    [v8192
     (:step-ids m8191 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8192 :com.palletops.awaze.client-builder/undef)
     (.
      bean8190
      setStepIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8234] (clojure.core/str arg8234))
 v8192))))
   bean8190))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m8194]
  (clojure.core/let
   [bean8193
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/let
    [v8195 (:steps m8194 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8195 :com.palletops.awaze.client-builder/undef)
     (.
      bean8193
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8339] (elasticmapreduce/step-config arg8339))
 v8195))))
   (clojure.core/let
    [v8195
     (:job-flow-id m8194 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8195 :com.palletops.awaze.client-builder/undef)
     (. bean8193 setJobFlowId (clojure.core/str v8195))))
   bean8193))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m8197]
  (clojure.core/let
   [bean8196
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/let
    [v8198
     (:job-flow-ids m8197 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8198 :com.palletops.awaze.client-builder/undef)
     (.
      bean8196
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8340] (clojure.core/str arg8340))
 v8198))))
   (clojure.core/let
    [v8198
     (:termination-protected
      m8197
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8198 :com.palletops.awaze.client-builder/undef)
     (. bean8196 setTerminationProtected (clojure.core/boolean v8198))))
   bean8196))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m8200]
  (clojure.core/let
   [bean8199
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/let
    [v8201
     (:cluster-id m8200 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8201 :com.palletops.awaze.client-builder/undef)
     (. bean8199 setClusterId (clojure.core/str v8201))))
   (clojure.core/let
    [v8201 (:step-id m8200 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8201 :com.palletops.awaze.client-builder/undef)
     (. bean8199 setStepId (clojure.core/str v8201))))
   bean8199))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m8235]
   (clojure.core/let
    [credentials8236 (:credentials m8235) args8237 (:args m8235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8238
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8236)]
     (clojure.core/case
      (clojure.core/count args8237)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8238
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8238
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args8237 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :modify-instance-groups,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-instance-groups,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials8240 & args8241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8242
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8240)]
    (clojure.core/case
     (clojure.core/count args8241)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8242
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8242
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args8241 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m8243]
   (clojure.core/let
    [credentials8244 (:credentials m8243) args8245 (:args m8243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8246
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8246
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args8245 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-instance-groups,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceGroups"}
   [credentials8248 & args8249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8250
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8250
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args8249 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m8251]
   (clojure.core/let
    [credentials8252 (:credentials m8251) args8253 (:args m8251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8254
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8252)]
     (clojure.core/case
      (clojure.core/count args8253)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8254
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8254
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args8253 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-clusters,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-clusters,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Call listClusters, listClusters"}
   [credentials8256 & args8257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8258
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8256)]
    (clojure.core/case
     (clojure.core/count args8257)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8258
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8258
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args8257 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m8259]
   (clojure.core/let
    [credentials8260 (:credentials m8259) args8261 (:args m8259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8262
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8262
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args8261 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials8264 & args8265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8266
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8266
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args8265 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m8267]
   (clojure.core/let
    [credentials8268 (:credentials m8267) args8269 (:args m8267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8270
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8270
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args8269 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials8272 & args8273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8274
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8274
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args8273 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m8275]
   (clojure.core/let
    [credentials8276 (:credentials m8275) args8277 (:args m8275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8278
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8278
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args8277 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-visible-to-all-users,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials8280 & args8281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8282
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8282
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args8281 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m8283]
   (clojure.core/let
    [credentials8284 (:credentials m8283) args8285 (:args m8283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8286
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8286
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args8285 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-instances,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstances"}
   [credentials8288 & args8289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8290
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8290
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args8289 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m8291]
   (clojure.core/let
    [credentials8292 (:credentials m8291) args8293 (:args m8291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8294
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8294
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args8293 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cluster,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCluster"}
   [credentials8296 & args8297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8298
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8298
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args8297 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m8299]
   (clojure.core/let
    [credentials8300 (:credentials m8299) args8301 (:args m8299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8302
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8302
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args8301 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-bootstrap-actions,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listBootstrapActions"}
   [credentials8304 & args8305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8306
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8306
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args8305 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m8307]
   (clojure.core/let
    [credentials8308 (:credentials m8307) args8309 (:args m8307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8310
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8310
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args8309 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :terminate-job-flows,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateJobFlows"}
   [credentials8312 & args8313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8314
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8314
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args8313 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m8315]
   (clojure.core/let
    [credentials8316 (:credentials m8315) args8317 (:args m8315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8318
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8316)]
     (clojure.core/case
      (clojure.core/count args8317)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8318
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args8317 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8318
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-job-flows,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-job-flows,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials8320 & args8321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8322
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8320)]
    (clojure.core/case
     (clojure.core/count args8321)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8322
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args8321 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8322
       describeJobFlows))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m8323]
   (clojure.core/let
    [credentials8324 (:credentials m8323) args8325 (:args m8323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8326
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8326
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args8325 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :run-job-flow,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Call runJobFlow"}
   [credentials8328 & args8329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8330
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8330
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args8329 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m8331]
   (clojure.core/let
    [credentials8332 (:credentials m8331) args8333 (:args m8331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8334
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8334
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args8333 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-instance-groups,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addInstanceGroups"}
   [credentials8336 & args8337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8338
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8338
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args8337 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m8341]
   (clojure.core/let
    [credentials8342 (:credentials m8341) args8343 (:args m8341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8344
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8344
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args8343 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-steps,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Call listSteps"}
   [credentials8346 & args8347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8348
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8348
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args8347 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m8349]
   (clojure.core/let
    [credentials8350 (:credentials m8349) args8351 (:args m8349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8352
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8352
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args8351 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-job-flow-steps,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials8354 & args8355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8356
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8356
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args8355 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m8357]
   (clojure.core/let
    [credentials8358 (:credentials m8357) args8359 (:args m8357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8360
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8358)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8360
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args8359 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-termination-protection,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTerminationProtection"}
   [credentials8362 & args8363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8364
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8362)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8364
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args8363 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m8365]
   (clojure.core/let
    [credentials8366 (:credentials m8365) args8367 (:args m8365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8368
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8368
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args8367 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-step,
     :credentials credentials__1784__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Call describeStep"}
   [credentials8370 & args8371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8372
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8372
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args8371 0))))))))
