(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4504]
  (clojure.core/let
   [bean4503
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/let
    [v4505 (:enabled m4504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4505 :com.palletops.awaze.client-builder/undef)
     (. bean4503 setEnabled (clojure.core/boolean v4505))))
   bean4503))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4507]
  (clojure.core/let
   [bean4506
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/let
    [v4508
     (:s3bucket-name m4507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4508 :com.palletops.awaze.client-builder/undef)
     (. bean4506 setS3BucketName (clojure.core/str v4508))))
   (clojure.core/let
    [v4508
     (:emit-interval m4507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4508 :com.palletops.awaze.client-builder/undef)
     (. bean4506 setEmitInterval (clojure.core/int v4508))))
   (clojure.core/let
    [v4508
     (:s3bucket-prefix
      m4507
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4508 :com.palletops.awaze.client-builder/undef)
     (. bean4506 setS3BucketPrefix (clojure.core/str v4508))))
   (clojure.core/let
    [v4508 (:enabled m4507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4508 :com.palletops.awaze.client-builder/undef)
     (. bean4506 setEnabled (clojure.core/boolean v4508))))
   bean4506))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4510]
  (clojure.core/let
   [bean4509
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/let
    [v4511 (:enabled m4510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4511 :com.palletops.awaze.client-builder/undef)
     (. bean4509 setEnabled (clojure.core/boolean v4511))))
   (clojure.core/let
    [v4511 (:timeout m4510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4511 :com.palletops.awaze.client-builder/undef)
     (. bean4509 setTimeout (clojure.core/int v4511))))
   bean4509))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings}
connection-settings
  [m4513]
  (clojure.core/let
   [bean4512
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings)]
   (clojure.core/let
    [v4514
     (:idle-timeout m4513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4514 :com.palletops.awaze.client-builder/undef)
     (. bean4512 setIdleTimeout (clojure.core/int v4514))))
   bean4512))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute}
additional-attribute
  [m4516]
  (clojure.core/let
   [bean4515
    (new
     com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute)]
   (clojure.core/let
    [v4517 (:value m4516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4517 :com.palletops.awaze.client-builder/undef)
     (. bean4515 setValue (clojure.core/str v4517))))
   (clojure.core/let
    [v4517 (:key m4516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4517 :com.palletops.awaze.client-builder/undef)
     (. bean4515 setKey (clojure.core/str v4517))))
   bean4515))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Tag}
tag
  [m4519]
  (clojure.core/let
   [bean4518
    (new com.amazonaws.services.elasticloadbalancing.model.Tag)]
   (clojure.core/let
    [v4520 (:value m4519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4520 :com.palletops.awaze.client-builder/undef)
     (. bean4518 setValue (clojure.core/str v4520))))
   (clojure.core/let
    [v4520 (:key m4519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4520 :com.palletops.awaze.client-builder/undef)
     (. bean4518 setKey (clojure.core/str v4520))))
   bean4518))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4522]
  (clojure.core/let
   [bean4521
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/let
    [v4523
     (:instance-protocol
      m4522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4523 :com.palletops.awaze.client-builder/undef)
     (. bean4521 setInstanceProtocol (clojure.core/str v4523))))
   (clojure.core/let
    [v4523
     (:protocol m4522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4523 :com.palletops.awaze.client-builder/undef)
     (. bean4521 setProtocol (clojure.core/str v4523))))
   (clojure.core/let
    [v4523
     (:load-balancer-port
      m4522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4523 :com.palletops.awaze.client-builder/undef)
     (. bean4521 setLoadBalancerPort (clojure.core/int v4523))))
   (clojure.core/let
    [v4523
     (:sslcertificate-id
      m4522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4523 :com.palletops.awaze.client-builder/undef)
     (. bean4521 setSSLCertificateId (clojure.core/str v4523))))
   (clojure.core/let
    [v4523
     (:instance-port m4522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4523 :com.palletops.awaze.client-builder/undef)
     (. bean4521 setInstancePort (clojure.core/int v4523))))
   bean4521))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly}
tag-key-only
  [m4525]
  (clojure.core/let
   [bean4524
    (new com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly)]
   (clojure.core/let
    [v4526 (:key m4525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4526 :com.palletops.awaze.client-builder/undef)
     (. bean4524 setKey (clojure.core/str v4526))))
   bean4524))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4528]
  (clojure.core/let
   [bean4527
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/let
    [v4529
     (:attribute-name m4528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4529 :com.palletops.awaze.client-builder/undef)
     (. bean4527 setAttributeName (clojure.core/str v4529))))
   (clojure.core/let
    [v4529
     (:attribute-value
      m4528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4529 :com.palletops.awaze.client-builder/undef)
     (. bean4527 setAttributeValue (clojure.core/str v4529))))
   bean4527))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4531]
  (clojure.core/let
   [bean4530
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/let
    [v4532
     (:instance-id m4531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4532 :com.palletops.awaze.client-builder/undef)
     (. bean4530 setInstanceId (clojure.core/str v4532))))
   bean4530))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4534]
  (clojure.core/let
   [bean4533
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/let
    [v4535
     (:cross-zone-load-balancing
      m4534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4535 :com.palletops.awaze.client-builder/undef)
     (.
      bean4533
      setCrossZoneLoadBalancing
      (elasticloadbalancing/cross-zone-load-balancing v4535))))
   (clojure.core/let
    [v4535
     (:access-log m4534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4535 :com.palletops.awaze.client-builder/undef)
     (. bean4533 setAccessLog (elasticloadbalancing/access-log v4535))))
   (clojure.core/let
    [v4535
     (:connection-draining
      m4534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4535 :com.palletops.awaze.client-builder/undef)
     (.
      bean4533
      setConnectionDraining
      (elasticloadbalancing/connection-draining v4535))))
   (clojure.core/let
    [v4535
     (:connection-settings
      m4534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4535 :com.palletops.awaze.client-builder/undef)
     (.
      bean4533
      setConnectionSettings
      (elasticloadbalancing/connection-settings v4535))))
   (clojure.core/let
    [v4535
     (:additional-attributes
      m4534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4535 :com.palletops.awaze.client-builder/undef)
     (.
      bean4533
      setAdditionalAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4623]
  (elasticloadbalancing/additional-attribute arg4623))
 v4535))))
   bean4533))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4537]
  (clojure.core/let
   [bean4536
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/let
    [v4538 (:target m4537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4538 :com.palletops.awaze.client-builder/undef)
     (. bean4536 setTarget (clojure.core/str v4538))))
   (clojure.core/let
    [v4538
     (:interval m4537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4538 :com.palletops.awaze.client-builder/undef)
     (. bean4536 setInterval (clojure.core/int v4538))))
   (clojure.core/let
    [v4538 (:timeout m4537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4538 :com.palletops.awaze.client-builder/undef)
     (. bean4536 setTimeout (clojure.core/int v4538))))
   (clojure.core/let
    [v4538
     (:unhealthy-threshold
      m4537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4538 :com.palletops.awaze.client-builder/undef)
     (. bean4536 setUnhealthyThreshold (clojure.core/int v4538))))
   (clojure.core/let
    [v4538
     (:healthy-threshold
      m4537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4538 :com.palletops.awaze.client-builder/undef)
     (. bean4536 setHealthyThreshold (clojure.core/int v4538))))
   bean4536))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4540]
  (clojure.core/let
   [bean4539
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/let
    [v4541 (:tags m4540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (.
      bean4539
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4624] (elasticloadbalancing/tag arg4624))
 v4541))))
   (clojure.core/let
    [v4541
     (:security-groups
      m4540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (.
      bean4539
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4625] (clojure.core/str arg4625))
 v4541))))
   (clojure.core/let
    [v4541
     (:availability-zones
      m4540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (.
      bean4539
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4626] (clojure.core/str arg4626))
 v4541))))
   (clojure.core/let
    [v4541 (:subnets m4540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (.
      bean4539
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4627] (clojure.core/str arg4627))
 v4541))))
   (clojure.core/let
    [v4541
     (:load-balancer-name
      m4540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (. bean4539 setLoadBalancerName (clojure.core/str v4541))))
   (clojure.core/let
    [v4541
     (:listeners m4540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (.
      bean4539
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4628] (elasticloadbalancing/listener arg4628))
 v4541))))
   (clojure.core/let
    [v4541 (:scheme m4540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4541 :com.palletops.awaze.client-builder/undef)
     (. bean4539 setScheme (clojure.core/str v4541))))
   bean4539))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4543]
  (clojure.core/let
   [bean4542
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4544
     (:load-balancer-name
      m4543
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4544 :com.palletops.awaze.client-builder/undef)
     (. bean4542 setLoadBalancerName (clojure.core/str v4544))))
   (clojure.core/let
    [v4544
     (:load-balancer-ports
      m4543
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4544 :com.palletops.awaze.client-builder/undef)
     (.
      bean4542
      setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4629] (clojure.core/int arg4629))
 v4544))))
   bean4542))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4546]
  (clojure.core/let
   [bean4545
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4547
     (:availability-zones
      m4546
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4547 :com.palletops.awaze.client-builder/undef)
     (.
      bean4545
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4630] (clojure.core/str arg4630))
 v4547))))
   (clojure.core/let
    [v4547
     (:load-balancer-name
      m4546
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4547 :com.palletops.awaze.client-builder/undef)
     (. bean4545 setLoadBalancerName (clojure.core/str v4547))))
   bean4545))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4549]
  (clojure.core/let
   [bean4548
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v4550 (:marker m4549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4550 :com.palletops.awaze.client-builder/undef)
     (. bean4548 setMarker (clojure.core/str v4550))))
   (clojure.core/let
    [v4550
     (:load-balancer-names
      m4549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4550 :com.palletops.awaze.client-builder/undef)
     (.
      bean4548
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4631] (clojure.core/str arg4631))
 v4550))))
   (clojure.core/let
    [v4550
     (:page-size m4549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4550 :com.palletops.awaze.client-builder/undef)
     (. bean4548 setPageSize (clojure.core/int v4550))))
   bean4548))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4552]
  (clojure.core/let
   [bean4551
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4553
     (:load-balancer-name
      m4552
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4553 :com.palletops.awaze.client-builder/undef)
     (. bean4551 setLoadBalancerName (clojure.core/str v4553))))
   (clojure.core/let
    [v4553
     (:policy-name m4552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4553 :com.palletops.awaze.client-builder/undef)
     (. bean4551 setPolicyName (clojure.core/str v4553))))
   bean4551))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4555]
  (clojure.core/let
   [bean4554
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/let
    [v4556
     (:load-balancer-name
      m4555
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4556 :com.palletops.awaze.client-builder/undef)
     (. bean4554 setLoadBalancerName (clojure.core/str v4556))))
   (clojure.core/let
    [v4556
     (:policy-names m4555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4556 :com.palletops.awaze.client-builder/undef)
     (.
      bean4554
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4632] (clojure.core/str arg4632))
 v4556))))
   bean4554))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest}
remove-tags-request
  [m4558]
  (clojure.core/let
   [bean4557
    (new
     com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest)]
   (clojure.core/let
    [v4559 (:tags m4558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4559 :com.palletops.awaze.client-builder/undef)
     (.
      bean4557
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4633]
  (elasticloadbalancing/tag-key-only arg4633))
 v4559))))
   (clojure.core/let
    [v4559
     (:load-balancer-names
      m4558
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4559 :com.palletops.awaze.client-builder/undef)
     (.
      bean4557
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4634] (clojure.core/str arg4634))
 v4559))))
   bean4557))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4561]
  (clojure.core/let
   [bean4560
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4562
     (:load-balancer-name
      m4561
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4562 :com.palletops.awaze.client-builder/undef)
     (. bean4560 setLoadBalancerName (clojure.core/str v4562))))
   (clojure.core/let
    [v4562
     (:policy-name m4561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4562 :com.palletops.awaze.client-builder/undef)
     (. bean4560 setPolicyName (clojure.core/str v4562))))
   (clojure.core/let
    [v4562
     (:policy-type-name
      m4561
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4562 :com.palletops.awaze.client-builder/undef)
     (. bean4560 setPolicyTypeName (clojure.core/str v4562))))
   (clojure.core/let
    [v4562
     (:policy-attributes
      m4561
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4562 :com.palletops.awaze.client-builder/undef)
     (.
      bean4560
      setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4635]
  (elasticloadbalancing/policy-attribute arg4635))
 v4562))))
   bean4560))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4564]
  (clojure.core/let
   [bean4563
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4565
     (:load-balancer-name
      m4564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4565 :com.palletops.awaze.client-builder/undef)
     (. bean4563 setLoadBalancerName (clojure.core/str v4565))))
   (clojure.core/let
    [v4565
     (:listeners m4564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4565 :com.palletops.awaze.client-builder/undef)
     (.
      bean4563
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4636] (elasticloadbalancing/listener arg4636))
 v4565))))
   bean4563))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4567]
  (clojure.core/let
   [bean4566
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/let
    [v4568
     (:instance-port m4567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4568 :com.palletops.awaze.client-builder/undef)
     (. bean4566 setInstancePort (clojure.core/int v4568))))
   (clojure.core/let
    [v4568
     (:load-balancer-name
      m4567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4568 :com.palletops.awaze.client-builder/undef)
     (. bean4566 setLoadBalancerName (clojure.core/str v4568))))
   (clojure.core/let
    [v4568
     (:policy-names m4567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4568 :com.palletops.awaze.client-builder/undef)
     (.
      bean4566
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4637] (clojure.core/str arg4637))
 v4568))))
   bean4566))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4570]
  (clojure.core/let
   [bean4569
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/let
    [v4571
     (:instances m4570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4571 :com.palletops.awaze.client-builder/undef)
     (.
      bean4569
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4638] (elasticloadbalancing/instance arg4638))
 v4571))))
   (clojure.core/let
    [v4571
     (:load-balancer-name
      m4570
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4571 :com.palletops.awaze.client-builder/undef)
     (. bean4569 setLoadBalancerName (clojure.core/str v4571))))
   bean4569))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4573]
  (clojure.core/let
   [bean4572
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/let
    [v4574
     (:load-balancer-name
      m4573
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4574 :com.palletops.awaze.client-builder/undef)
     (. bean4572 setLoadBalancerName (clojure.core/str v4574))))
   bean4572))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4576]
  (clojure.core/let
   [bean4575
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/let
    [v4577 (:subnets m4576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4577 :com.palletops.awaze.client-builder/undef)
     (.
      bean4575
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4639] (clojure.core/str arg4639))
 v4577))))
   (clojure.core/let
    [v4577
     (:load-balancer-name
      m4576
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4577 :com.palletops.awaze.client-builder/undef)
     (. bean4575 setLoadBalancerName (clojure.core/str v4577))))
   bean4575))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4579]
  (clojure.core/let
   [bean4578
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4580
     (:availability-zones
      m4579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4580 :com.palletops.awaze.client-builder/undef)
     (.
      bean4578
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4640] (clojure.core/str arg4640))
 v4580))))
   (clojure.core/let
    [v4580
     (:load-balancer-name
      m4579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4580 :com.palletops.awaze.client-builder/undef)
     (. bean4578 setLoadBalancerName (clojure.core/str v4580))))
   bean4578))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4582]
  (clojure.core/let
   [bean4581
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/let
    [v4583
     (:load-balancer-port
      m4582
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4583 :com.palletops.awaze.client-builder/undef)
     (. bean4581 setLoadBalancerPort (clojure.core/int v4583))))
   (clojure.core/let
    [v4583
     (:load-balancer-name
      m4582
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4583 :com.palletops.awaze.client-builder/undef)
     (. bean4581 setLoadBalancerName (clojure.core/str v4583))))
   (clojure.core/let
    [v4583
     (:policy-names m4582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4583 :com.palletops.awaze.client-builder/undef)
     (.
      bean4581
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4641] (clojure.core/str arg4641))
 v4583))))
   bean4581))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest}
add-tags-request
  [m4585]
  (clojure.core/let
   [bean4584
    (new
     com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest)]
   (clojure.core/let
    [v4586 (:tags m4585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4586 :com.palletops.awaze.client-builder/undef)
     (.
      bean4584
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4642] (elasticloadbalancing/tag arg4642))
 v4586))))
   (clojure.core/let
    [v4586
     (:load-balancer-names
      m4585
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4586 :com.palletops.awaze.client-builder/undef)
     (.
      bean4584
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4643] (clojure.core/str arg4643))
 v4586))))
   bean4584))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4588]
  (clojure.core/let
   [bean4587
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/let
    [v4589
     (:instances m4588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4589 :com.palletops.awaze.client-builder/undef)
     (.
      bean4587
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4644] (elasticloadbalancing/instance arg4644))
 v4589))))
   (clojure.core/let
    [v4589
     (:load-balancer-name
      m4588
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4589 :com.palletops.awaze.client-builder/undef)
     (. bean4587 setLoadBalancerName (clojure.core/str v4589))))
   bean4587))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest}
describe-tags-request
  [m4591]
  (clojure.core/let
   [bean4590
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest)]
   (clojure.core/let
    [v4592
     (:load-balancer-names
      m4591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4592 :com.palletops.awaze.client-builder/undef)
     (.
      bean4590
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4645] (clojure.core/str arg4645))
 v4592))))
   bean4590))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4594]
  (clojure.core/let
   [bean4593
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4595
     (:load-balancer-name
      m4594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4595 :com.palletops.awaze.client-builder/undef)
     (. bean4593 setLoadBalancerName (clojure.core/str v4595))))
   (clojure.core/let
    [v4595
     (:policy-name m4594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4595 :com.palletops.awaze.client-builder/undef)
     (. bean4593 setPolicyName (clojure.core/str v4595))))
   (clojure.core/let
    [v4595
     (:cookie-name m4594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4595 :com.palletops.awaze.client-builder/undef)
     (. bean4593 setCookieName (clojure.core/str v4595))))
   bean4593))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4597]
  (clojure.core/let
   [bean4596
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4598
     (:load-balancer-attributes
      m4597
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4598 :com.palletops.awaze.client-builder/undef)
     (.
      bean4596
      setLoadBalancerAttributes
      (elasticloadbalancing/load-balancer-attributes v4598))))
   (clojure.core/let
    [v4598
     (:load-balancer-name
      m4597
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4598 :com.palletops.awaze.client-builder/undef)
     (. bean4596 setLoadBalancerName (clojure.core/str v4598))))
   bean4596))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4600]
  (clojure.core/let
   [bean4599
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/let
    [v4601
     (:load-balancer-port
      m4600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4601 :com.palletops.awaze.client-builder/undef)
     (. bean4599 setLoadBalancerPort (clojure.core/int v4601))))
   (clojure.core/let
    [v4601
     (:sslcertificate-id
      m4600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4601 :com.palletops.awaze.client-builder/undef)
     (. bean4599 setSSLCertificateId (clojure.core/str v4601))))
   (clojure.core/let
    [v4601
     (:load-balancer-name
      m4600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4601 :com.palletops.awaze.client-builder/undef)
     (. bean4599 setLoadBalancerName (clojure.core/str v4601))))
   bean4599))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4603]
  (clojure.core/let
   [bean4602
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4604
     (:load-balancer-name
      m4603
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4604 :com.palletops.awaze.client-builder/undef)
     (. bean4602 setLoadBalancerName (clojure.core/str v4604))))
   bean4602))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4606]
  (clojure.core/let
   [bean4605
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/let
    [v4607
     (:load-balancer-name
      m4606
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4607 :com.palletops.awaze.client-builder/undef)
     (. bean4605 setLoadBalancerName (clojure.core/str v4607))))
   (clojure.core/let
    [v4607
     (:health-check m4606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4607 :com.palletops.awaze.client-builder/undef)
     (.
      bean4605
      setHealthCheck
      (elasticloadbalancing/health-check v4607))))
   bean4605))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4609]
  (clojure.core/let
   [bean4608
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/let
    [v4610 (:subnets m4609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4610 :com.palletops.awaze.client-builder/undef)
     (.
      bean4608
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4694] (clojure.core/str arg4694))
 v4610))))
   (clojure.core/let
    [v4610
     (:load-balancer-name
      m4609
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4610 :com.palletops.awaze.client-builder/undef)
     (. bean4608 setLoadBalancerName (clojure.core/str v4610))))
   bean4608))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4612]
  (clojure.core/let
   [bean4611
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/let
    [v4613
     (:policy-type-names
      m4612
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4613 :com.palletops.awaze.client-builder/undef)
     (.
      bean4611
      setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4695] (clojure.core/str arg4695))
 v4613))))
   bean4611))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4615]
  (clojure.core/let
   [bean4614
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/let
    [v4616
     (:instances m4615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4616 :com.palletops.awaze.client-builder/undef)
     (.
      bean4614
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4696] (elasticloadbalancing/instance arg4696))
 v4616))))
   (clojure.core/let
    [v4616
     (:load-balancer-name
      m4615
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4616 :com.palletops.awaze.client-builder/undef)
     (. bean4614 setLoadBalancerName (clojure.core/str v4616))))
   bean4614))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4618]
  (clojure.core/let
   [bean4617
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/let
    [v4619
     (:security-groups
      m4618
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4619 :com.palletops.awaze.client-builder/undef)
     (.
      bean4617
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4697] (clojure.core/str arg4697))
 v4619))))
   (clojure.core/let
    [v4619
     (:load-balancer-name
      m4618
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4619 :com.palletops.awaze.client-builder/undef)
     (. bean4617 setLoadBalancerName (clojure.core/str v4619))))
   bean4617))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4621]
  (clojure.core/let
   [bean4620
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4622
     (:load-balancer-name
      m4621
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4622 :com.palletops.awaze.client-builder/undef)
     (. bean4620 setLoadBalancerName (clojure.core/str v4622))))
   (clojure.core/let
    [v4622
     (:policy-name m4621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4622 :com.palletops.awaze.client-builder/undef)
     (. bean4620 setPolicyName (clojure.core/str v4622))))
   (clojure.core/let
    [v4622
     (:cookie-expiration-period
      m4621
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4622 :com.palletops.awaze.client-builder/undef)
     (. bean4620 setCookieExpirationPeriod (clojure.core/long v4622))))
   bean4620))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4646]
   (clojure.core/let
    [credentials4647 (:credentials m4646) args4648 (:args m4646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4649
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4647)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4649
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4648 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4651 & args4652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4653
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4651)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4653
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4652 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4654]
   (clojure.core/let
    [credentials4655 (:credentials m4654) args4656 (:args m4654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4657
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4655)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4657
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4656 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4659 & args4660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4661
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4659)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4661
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4660 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4662]
   (clojure.core/let
    [credentials4663 (:credentials m4662) args4664 (:args m4662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4665
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4663)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4665
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4664 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4667 & args4668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4669
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4669
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4668 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4670]
   (clojure.core/let
    [credentials4671 (:credentials m4670) args4672 (:args m4670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4673
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4671)]
     (clojure.core/case
      (clojure.core/count args4672)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4673
        describeLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4673
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4672 0))))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-load-balancers,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4675 & args4676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4677
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4675)]
    (clojure.core/case
     (clojure.core/count args4676)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4677
       describeLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4677
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4676 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4678]
   (clojure.core/let
    [credentials4679 (:credentials m4678) args4680 (:args m4678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4681
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4679)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4681
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4680 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-policy,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4683 & args4684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4685
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4683)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4685
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4684 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4686]
   (clojure.core/let
    [credentials4687 (:credentials m4686) args4688 (:args m4686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4689
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4687)]
     (clojure.core/case
      (clojure.core/count args4688)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4689
        describeLoadBalancerPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4689
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4688 0))))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4691 & args4692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4693
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4691)]
    (clojure.core/case
     (clojure.core/count args4692)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4693
       describeLoadBalancerPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4693
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4692 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :remove-tags
   [m4698]
   (clojure.core/let
    [credentials4699 (:credentials m4698) args4700 (:args m4698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4701
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4699)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4701
       removeTags
       (elasticloadbalancing/remove-tags-request
        (clojure.core/nth args4700 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials4703 & args4704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4705
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4703)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4705
      removeTags
      (elasticloadbalancing/remove-tags-request
       (clojure.core/nth args4704 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4706]
   (clojure.core/let
    [credentials4707 (:credentials m4706) args4708 (:args m4706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4709
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4709
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4708 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-load-balancer-policy,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4711 & args4712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4713
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4713
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4712 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4714]
   (clojure.core/let
    [credentials4715 (:credentials m4714) args4716 (:args m4714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4717
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4717
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4716 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-load-balancer-listeners,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4719 & args4720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4721
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4721
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4720 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4722]
   (clojure.core/let
    [credentials4723 (:credentials m4722) args4724 (:args m4722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4725
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4725
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4724 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4727 & args4728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4729
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4729
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4728 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4730]
   (clojure.core/let
    [credentials4731 (:credentials m4730) args4732 (:args m4730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4733
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4733
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4732 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-instance-health,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4735 & args4736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4737
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4737
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4736 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4738]
   (clojure.core/let
    [credentials4739 (:credentials m4738) args4740 (:args m4738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4741
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4739)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4741
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4740 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4743 & args4744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4745
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4743)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4745
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4744 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4746]
   (clojure.core/let
    [credentials4747 (:credentials m4746) args4748 (:args m4746)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4749
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4747)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4749
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4748 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4751 & args4752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4753
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4751)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4753
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4752 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4754]
   (clojure.core/let
    [credentials4755 (:credentials m4754) args4756 (:args m4754)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4757
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4755)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4757
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4756 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4759 & args4760]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4761
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4759)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4761
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4760 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4762]
   (clojure.core/let
    [credentials4763 (:credentials m4762) args4764 (:args m4762)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4765
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4763)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4765
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4764 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4767 & args4768]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4769
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4767)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4769
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4768 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :add-tags
   [m4770]
   (clojure.core/let
    [credentials4771 (:credentials m4770) args4772 (:args m4770)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4773
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4771)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4773
       addTags
       (elasticloadbalancing/add-tags-request
        (clojure.core/nth args4772 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials4775 & args4776]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4777
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4775)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4777
      addTags
      (elasticloadbalancing/add-tags-request
       (clojure.core/nth args4776 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4778]
   (clojure.core/let
    [credentials4779 (:credentials m4778) args4780 (:args m4778)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4781
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4779)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4781
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4780 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4783 & args4784]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4785
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4783)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4785
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4784 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-tags
   [m4786]
   (clojure.core/let
    [credentials4787 (:credentials m4786) args4788 (:args m4786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4789
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4787)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4789
       describeTags
       (elasticloadbalancing/describe-tags-request
        (clojure.core/nth args4788 0)))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags"}
   [credentials4791 & args4792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4793
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4791)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4793
      describeTags
      (elasticloadbalancing/describe-tags-request
       (clojure.core/nth args4792 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4794]
   (clojure.core/let
    [credentials4795 (:credentials m4794) args4796 (:args m4794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4797
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4797
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4796 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4799 & args4800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4801
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4801
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4800 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4802]
   (clojure.core/let
    [credentials4803 (:credentials m4802) args4804 (:args m4802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4805
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4803)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4805
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4804 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4807 & args4808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4809
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4807)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4809
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4808 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4810]
   (clojure.core/let
    [credentials4811 (:credentials m4810) args4812 (:args m4810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4813
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4811)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4813
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4812 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4815 & args4816]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4817
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4815)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4817
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4816 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4818]
   (clojure.core/let
    [credentials4819 (:credentials m4818) args4820 (:args m4818)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4821
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4819)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4821
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4820 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4823 & args4824]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4825
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4823)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4825
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4824 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4826]
   (clojure.core/let
    [credentials4827 (:credentials m4826) args4828 (:args m4826)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4829
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4827)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4829
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4828 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :configure-health-check,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4831 & args4832]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4833
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4831)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4833
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4832 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4834]
   (clojure.core/let
    [credentials4835 (:credentials m4834) args4836 (:args m4834)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4837
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4835)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4837
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4836 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4839 & args4840]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4841
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4839)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4841
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4840 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4842]
   (clojure.core/let
    [credentials4843 (:credentials m4842) args4844 (:args m4842)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4845
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4843)]
     (clojure.core/case
      (clojure.core/count args4844)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4845
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4844 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4845
        describeLoadBalancerPolicyTypes))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4847 & args4848]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4849
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4847)]
    (clojure.core/case
     (clojure.core/count args4848)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4849
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4848 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4849
       describeLoadBalancerPolicyTypes))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4850]
   (clojure.core/let
    [credentials4851 (:credentials m4850) args4852 (:args m4850)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4853
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4851)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4853
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4852 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4855 & args4856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4857
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4855)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4857
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4856 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4858]
   (clojure.core/let
    [credentials4859 (:credentials m4858) args4860 (:args m4858)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4861
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4859)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4861
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4860 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4863 & args4864]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4865
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4863)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4865
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4864 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4866]
   (clojure.core/let
    [credentials4867 (:credentials m4866) args4868 (:args m4866)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4869
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4867)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4869
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4868 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1784__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4871 & args4872]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4873
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4871)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4873
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4872 0))))))))
