(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EventSeverity}
event-severity
  [m10635]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EventSeverity
   fromValue
   (clojure.core/name m10635)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m10638]
  (clojure.core/let
   [bean10637
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/let
    [v10639
     (:namespace m10638 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10639 :com.palletops.awaze.client-builder/undef)
     (. bean10637 setNamespace (clojure.core/str v10639))))
   (clojure.core/let
    [v10639
     (:resource-name m10638 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10639 :com.palletops.awaze.client-builder/undef)
     (. bean10637 setResourceName (clojure.core/str v10639))))
   (clojure.core/let
    [v10639
     (:option-name m10638 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10639 :com.palletops.awaze.client-builder/undef)
     (. bean10637 setOptionName (clojure.core/str v10639))))
   bean10637))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m10641]
  (clojure.core/let
   [bean10640
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/let
    [v10642
     (:application-name
      m10641
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10642 :com.palletops.awaze.client-builder/undef)
     (. bean10640 setApplicationName (clojure.core/str v10642))))
   (clojure.core/let
    [v10642
     (:template-name m10641 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10642 :com.palletops.awaze.client-builder/undef)
     (. bean10640 setTemplateName (clojure.core/str v10642))))
   bean10640))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m10644]
  (clojure.core/let
   [bean10643
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/let
    [v10645 (:value m10644 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10645 :com.palletops.awaze.client-builder/undef)
     (. bean10643 setValue (clojure.core/str v10645))))
   (clojure.core/let
    [v10645
     (:namespace m10644 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10645 :com.palletops.awaze.client-builder/undef)
     (. bean10643 setNamespace (clojure.core/str v10645))))
   (clojure.core/let
    [v10645
     (:resource-name m10644 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10645 :com.palletops.awaze.client-builder/undef)
     (. bean10643 setResourceName (clojure.core/str v10645))))
   (clojure.core/let
    [v10645
     (:option-name m10644 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10645 :com.palletops.awaze.client-builder/undef)
     (. bean10643 setOptionName (clojure.core/str v10645))))
   bean10643))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m10647]
  (clojure.core/let
   [bean10646
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/let
    [v10648 (:name m10647 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10648 :com.palletops.awaze.client-builder/undef)
     (. bean10646 setName (clojure.core/str v10648))))
   (clojure.core/let
    [v10648 (:type m10647 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10648 :com.palletops.awaze.client-builder/undef)
     (. bean10646 setType (clojure.core/str v10648))))
   (clojure.core/let
    [v10648
     (:version m10647 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10648 :com.palletops.awaze.client-builder/undef)
     (. bean10646 setVersion (clojure.core/str v10648))))
   bean10646))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m10650]
  (clojure.core/let
   [bean10649
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/let
    [v10651 (:s3key m10650 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10651 :com.palletops.awaze.client-builder/undef)
     (. bean10649 setS3Key (clojure.core/str v10651))))
   (clojure.core/let
    [v10651
     (:s3bucket m10650 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10651 :com.palletops.awaze.client-builder/undef)
     (. bean10649 setS3Bucket (clojure.core/str v10651))))
   bean10649))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m10653]
  (clojure.core/let
   [bean10652 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/let
    [v10654 (:value m10653 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10654 :com.palletops.awaze.client-builder/undef)
     (. bean10652 setValue (clojure.core/str v10654))))
   (clojure.core/let
    [v10654 (:key m10653 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10654 :com.palletops.awaze.client-builder/undef)
     (. bean10652 setKey (clojure.core/str v10654))))
   bean10652))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m10656]
  (clojure.core/let
   [bean10655
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/let
    [v10657
     (:application-name
      m10656
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10657 :com.palletops.awaze.client-builder/undef)
     (. bean10655 setApplicationName (clojure.core/str v10657))))
   (clojure.core/let
    [v10657
     (:version-labels
      m10656
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10657 :com.palletops.awaze.client-builder/undef)
     (.
      bean10655
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10754] (clojure.core/str arg10754))
 v10657))))
   bean10655))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest}
compose-environments-request
  [m10659]
  (clojure.core/let
   [bean10658
    (new
     com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest)]
   (clojure.core/let
    [v10660
     (:group-name m10659 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10660 :com.palletops.awaze.client-builder/undef)
     (. bean10658 setGroupName (clojure.core/str v10660))))
   (clojure.core/let
    [v10660
     (:application-name
      m10659
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10660 :com.palletops.awaze.client-builder/undef)
     (. bean10658 setApplicationName (clojure.core/str v10660))))
   (clojure.core/let
    [v10660
     (:version-labels
      m10659
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10660 :com.palletops.awaze.client-builder/undef)
     (.
      bean10658
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10755] (clojure.core/str arg10755))
 v10660))))
   bean10658))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m10662]
  (clojure.core/let
   [bean10661
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/let
    [v10663
     (:environment-id
      m10662
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10663 :com.palletops.awaze.client-builder/undef)
     (. bean10661 setEnvironmentId (clojure.core/str v10663))))
   (clojure.core/let
    [v10663
     (:environment-name
      m10662
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10663 :com.palletops.awaze.client-builder/undef)
     (. bean10661 setEnvironmentName (clojure.core/str v10663))))
   bean10661))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m10665]
  (clojure.core/let
   [bean10664
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/let
    [v10666
     (:description m10665 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10666 :com.palletops.awaze.client-builder/undef)
     (. bean10664 setDescription (clojure.core/str v10666))))
   (clojure.core/let
    [v10666
     (:application-name
      m10665
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10666 :com.palletops.awaze.client-builder/undef)
     (. bean10664 setApplicationName (clojure.core/str v10666))))
   (clojure.core/let
    [v10666
     (:version-label m10665 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10666 :com.palletops.awaze.client-builder/undef)
     (. bean10664 setVersionLabel (clojure.core/str v10666))))
   bean10664))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m10668]
  (clojure.core/let
   [bean10667
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/let
    [v10669
     (:application-name
      m10668
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10669 :com.palletops.awaze.client-builder/undef)
     (. bean10667 setApplicationName (clojure.core/str v10669))))
   (clojure.core/let
    [v10669
     (:environment-name
      m10668
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10669 :com.palletops.awaze.client-builder/undef)
     (. bean10667 setEnvironmentName (clojure.core/str v10669))))
   bean10667))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m10671]
  (clojure.core/let
   [bean10670
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/let
    [v10672
     (:start-time m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (.
      bean10670
      setStartTime
      (com.palletops.awaze.common/to-date v10672))))
   (clojure.core/let
    [v10672
     (:version-label m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setVersionLabel (clojure.core/str v10672))))
   (clojure.core/let
    [v10672
     (:template-name m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setTemplateName (clojure.core/str v10672))))
   (clojure.core/let
    [v10672
     (:environment-name
      m10671
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setEnvironmentName (clojure.core/str v10672))))
   (clojure.core/let
    [v10672
     (:max-records m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setMaxRecords (clojure.core/int v10672))))
   (clojure.core/let
    [v10672
     (:severity m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (.
      bean10670
      setSeverity
      (elasticbeanstalk/event-severity v10672))))
   (clojure.core/let
    [v10672
     (:end-time m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (.
      bean10670
      setEndTime
      (com.palletops.awaze.common/to-date v10672))))
   (clojure.core/let
    [v10672
     (:request-id m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setRequestId (clojure.core/str v10672))))
   (clojure.core/let
    [v10672
     (:environment-id
      m10671
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setEnvironmentId (clojure.core/str v10672))))
   (clojure.core/let
    [v10672
     (:next-token m10671 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setNextToken (clojure.core/str v10672))))
   (clojure.core/let
    [v10672
     (:application-name
      m10671
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10672 :com.palletops.awaze.client-builder/undef)
     (. bean10670 setApplicationName (clojure.core/str v10672))))
   bean10670))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m10674]
  (clojure.core/let
   [bean10673
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/let
    [v10675
     (:application-name
      m10674
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10675 :com.palletops.awaze.client-builder/undef)
     (. bean10673 setApplicationName (clojure.core/str v10675))))
   (clojure.core/let
    [v10675
     (:template-name m10674 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10675 :com.palletops.awaze.client-builder/undef)
     (. bean10673 setTemplateName (clojure.core/str v10675))))
   (clojure.core/let
    [v10675
     (:environment-name
      m10674
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10675 :com.palletops.awaze.client-builder/undef)
     (. bean10673 setEnvironmentName (clojure.core/str v10675))))
   bean10673))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m10677]
  (clojure.core/let
   [bean10676
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/let
    [v10678
     (:environment-id
      m10677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10678 :com.palletops.awaze.client-builder/undef)
     (. bean10676 setEnvironmentId (clojure.core/str v10678))))
   (clojure.core/let
    [v10678
     (:environment-name
      m10677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10678 :com.palletops.awaze.client-builder/undef)
     (. bean10676 setEnvironmentName (clojure.core/str v10678))))
   (clojure.core/let
    [v10678
     (:terminate-resources
      m10677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10678 :com.palletops.awaze.client-builder/undef)
     (. bean10676 setTerminateResources (clojure.core/boolean v10678))))
   (clojure.core/let
    [v10678
     (:force-terminate
      m10677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10678 :com.palletops.awaze.client-builder/undef)
     (. bean10676 setForceTerminate (clojure.core/boolean v10678))))
   bean10676))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m10680]
  (clojure.core/let
   [bean10679
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/let
    [v10681
     (:options m10680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10681 :com.palletops.awaze.client-builder/undef)
     (.
      bean10679
      setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10756]
  (elasticbeanstalk/option-specification arg10756))
 v10681))))
   (clojure.core/let
    [v10681
     (:application-name
      m10680
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10681 :com.palletops.awaze.client-builder/undef)
     (. bean10679 setApplicationName (clojure.core/str v10681))))
   (clojure.core/let
    [v10681
     (:template-name m10680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10681 :com.palletops.awaze.client-builder/undef)
     (. bean10679 setTemplateName (clojure.core/str v10681))))
   (clojure.core/let
    [v10681
     (:environment-name
      m10680
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10681 :com.palletops.awaze.client-builder/undef)
     (. bean10679 setEnvironmentName (clojure.core/str v10681))))
   (clojure.core/let
    [v10681
     (:solution-stack-name
      m10680
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10681 :com.palletops.awaze.client-builder/undef)
     (. bean10679 setSolutionStackName (clojure.core/str v10681))))
   bean10679))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m10683]
  (clojure.core/let
   [bean10682
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10684
     (:description m10683 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (. bean10682 setDescription (clojure.core/str v10684))))
   (clojure.core/let
    [v10684
     (:application-name
      m10683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (. bean10682 setApplicationName (clojure.core/str v10684))))
   (clojure.core/let
    [v10684
     (:template-name m10683 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (. bean10682 setTemplateName (clojure.core/str v10684))))
   (clojure.core/let
    [v10684
     (:environment-id
      m10683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (. bean10682 setEnvironmentId (clojure.core/str v10684))))
   (clojure.core/let
    [v10684
     (:solution-stack-name
      m10683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (. bean10682 setSolutionStackName (clojure.core/str v10684))))
   (clojure.core/let
    [v10684
     (:source-configuration
      m10683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (.
      bean10682
      setSourceConfiguration
      (elasticbeanstalk/source-configuration v10684))))
   (clojure.core/let
    [v10684
     (:option-settings
      m10683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10684 :com.palletops.awaze.client-builder/undef)
     (.
      bean10682
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10757]
  (elasticbeanstalk/configuration-option-setting arg10757))
 v10684))))
   bean10682))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m10686]
  (clojure.core/let
   [bean10685
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/let
    [v10687
     (:option-settings
      m10686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (.
      bean10685
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10758]
  (elasticbeanstalk/configuration-option-setting arg10758))
 v10687))))
   (clojure.core/let
    [v10687
     (:description m10686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setDescription (clojure.core/str v10687))))
   (clojure.core/let
    [v10687
     (:solution-stack-name
      m10686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setSolutionStackName (clojure.core/str v10687))))
   (clojure.core/let
    [v10687 (:tier m10686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setTier (elasticbeanstalk/environment-tier v10687))))
   (clojure.core/let
    [v10687
     (:version-label m10686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setVersionLabel (clojure.core/str v10687))))
   (clojure.core/let
    [v10687
     (:template-name m10686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setTemplateName (clojure.core/str v10687))))
   (clojure.core/let
    [v10687
     (:environment-name
      m10686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setEnvironmentName (clojure.core/str v10687))))
   (clojure.core/let
    [v10687
     (:options-to-remove
      m10686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (.
      bean10685
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10759]
  (elasticbeanstalk/option-specification arg10759))
 v10687))))
   (clojure.core/let
    [v10687
     (:group-name m10686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setGroupName (clojure.core/str v10687))))
   (clojure.core/let
    [v10687
     (:environment-id
      m10686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setEnvironmentId (clojure.core/str v10687))))
   (clojure.core/let
    [v10687
     (:application-name
      m10686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10687 :com.palletops.awaze.client-builder/undef)
     (. bean10685 setApplicationName (clojure.core/str v10687))))
   bean10685))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m10689]
  (clojure.core/let
   [bean10688
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/let
    [v10690
     (:application-names
      m10689
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10690 :com.palletops.awaze.client-builder/undef)
     (.
      bean10688
      setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10760] (clojure.core/str arg10760))
 v10690))))
   bean10688))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m10692]
  (clojure.core/let
   [bean10691
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean10691))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m10695]
  (clojure.core/let
   [bean10694
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/let
    [v10696
     (:environment-id
      m10695
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10696 :com.palletops.awaze.client-builder/undef)
     (. bean10694 setEnvironmentId (clojure.core/str v10696))))
   (clojure.core/let
    [v10696
     (:environment-name
      m10695
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10696 :com.palletops.awaze.client-builder/undef)
     (. bean10694 setEnvironmentName (clojure.core/str v10696))))
   bean10694))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m10698]
  (clojure.core/let
   [bean10697
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/let
    [v10699
     (:application-name
      m10698
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10699 :com.palletops.awaze.client-builder/undef)
     (. bean10697 setApplicationName (clojure.core/str v10699))))
   (clojure.core/let
    [v10699
     (:terminate-env-by-force
      m10698
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10699 :com.palletops.awaze.client-builder/undef)
     (.
      bean10697
      setTerminateEnvByForce
      (clojure.core/boolean v10699))))
   bean10697))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m10701]
  (clojure.core/let
   [bean10700
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/let
    [v10702
     (:description m10701 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10702 :com.palletops.awaze.client-builder/undef)
     (. bean10700 setDescription (clojure.core/str v10702))))
   (clojure.core/let
    [v10702
     (:application-name
      m10701
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10702 :com.palletops.awaze.client-builder/undef)
     (. bean10700 setApplicationName (clojure.core/str v10702))))
   bean10700))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m10704]
  (clojure.core/let
   [bean10703
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/let
    [v10705
     (:application-name
      m10704
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10705 :com.palletops.awaze.client-builder/undef)
     (. bean10703 setApplicationName (clojure.core/str v10705))))
   (clojure.core/let
    [v10705
     (:template-name m10704 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10705 :com.palletops.awaze.client-builder/undef)
     (. bean10703 setTemplateName (clojure.core/str v10705))))
   bean10703))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m10707]
  (clojure.core/let
   [bean10706
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/let
    [v10708
     (:source-environment-id
      m10707
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10708 :com.palletops.awaze.client-builder/undef)
     (. bean10706 setSourceEnvironmentId (clojure.core/str v10708))))
   (clojure.core/let
    [v10708
     (:source-environment-name
      m10707
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10708 :com.palletops.awaze.client-builder/undef)
     (. bean10706 setSourceEnvironmentName (clojure.core/str v10708))))
   (clojure.core/let
    [v10708
     (:destination-environment-id
      m10707
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10708 :com.palletops.awaze.client-builder/undef)
     (.
      bean10706
      setDestinationEnvironmentId
      (clojure.core/str v10708))))
   (clojure.core/let
    [v10708
     (:destination-environment-name
      m10707
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10708 :com.palletops.awaze.client-builder/undef)
     (.
      bean10706
      setDestinationEnvironmentName
      (clojure.core/str v10708))))
   bean10706))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest}
describe-environment-health-request
  [m10710]
  (clojure.core/let
   [bean10709
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest)]
   (clojure.core/let
    [v10711
     (:attribute-names
      m10710
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10711 :com.palletops.awaze.client-builder/undef)
     (.
      bean10709
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10761] (clojure.core/str arg10761))
 v10711))))
   (clojure.core/let
    [v10711
     (:environment-id
      m10710
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10711 :com.palletops.awaze.client-builder/undef)
     (. bean10709 setEnvironmentId (clojure.core/str v10711))))
   (clojure.core/let
    [v10711
     (:environment-name
      m10710
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10711 :com.palletops.awaze.client-builder/undef)
     (. bean10709 setEnvironmentName (clojure.core/str v10711))))
   bean10709))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest}
abort-environment-update-request
  [m10713]
  (clojure.core/let
   [bean10712
    (new
     com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest)]
   (clojure.core/let
    [v10714
     (:environment-id
      m10713
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10714 :com.palletops.awaze.client-builder/undef)
     (. bean10712 setEnvironmentId (clojure.core/str v10714))))
   (clojure.core/let
    [v10714
     (:environment-name
      m10713
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10714 :com.palletops.awaze.client-builder/undef)
     (. bean10712 setEnvironmentName (clojure.core/str v10714))))
   bean10712))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m10716]
  (clojure.core/let
   [bean10715
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/let
    [v10717
     (:cnameprefix m10716 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10717 :com.palletops.awaze.client-builder/undef)
     (. bean10715 setCNAMEPrefix (clojure.core/str v10717))))
   bean10715))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m10719]
  (clojure.core/let
   [bean10718
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/let
    [v10720
     (:info-type m10719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10720 :com.palletops.awaze.client-builder/undef)
     (. bean10718 setInfoType (clojure.core/str v10720))))
   (clojure.core/let
    [v10720
     (:environment-id
      m10719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10720 :com.palletops.awaze.client-builder/undef)
     (. bean10718 setEnvironmentId (clojure.core/str v10720))))
   (clojure.core/let
    [v10720
     (:environment-name
      m10719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10720 :com.palletops.awaze.client-builder/undef)
     (. bean10718 setEnvironmentName (clojure.core/str v10720))))
   bean10718))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m10722]
  (clojure.core/let
   [bean10721
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/let
    [v10723
     (:description m10722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10723 :com.palletops.awaze.client-builder/undef)
     (. bean10721 setDescription (clojure.core/str v10723))))
   (clojure.core/let
    [v10723
     (:application-name
      m10722
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10723 :com.palletops.awaze.client-builder/undef)
     (. bean10721 setApplicationName (clojure.core/str v10723))))
   (clojure.core/let
    [v10723
     (:version-label m10722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10723 :com.palletops.awaze.client-builder/undef)
     (. bean10721 setVersionLabel (clojure.core/str v10723))))
   (clojure.core/let
    [v10723
     (:source-bundle m10722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10723 :com.palletops.awaze.client-builder/undef)
     (.
      bean10721
      setSourceBundle
      (elasticbeanstalk/s3location v10723))))
   (clojure.core/let
    [v10723
     (:auto-create-application
      m10722
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10723 :com.palletops.awaze.client-builder/undef)
     (.
      bean10721
      setAutoCreateApplication
      (clojure.core/boolean v10723))))
   (clojure.core/let
    [v10723
     (:process m10722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10723 :com.palletops.awaze.client-builder/undef)
     (. bean10721 setProcess (clojure.core/boolean v10723))))
   bean10721))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m10725]
  (clojure.core/let
   [bean10724
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/let
    [v10726
     (:application-name
      m10725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10726 :com.palletops.awaze.client-builder/undef)
     (. bean10724 setApplicationName (clojure.core/str v10726))))
   (clojure.core/let
    [v10726
     (:version-label m10725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10726 :com.palletops.awaze.client-builder/undef)
     (. bean10724 setVersionLabel (clojure.core/str v10726))))
   (clojure.core/let
    [v10726
     (:environment-ids
      m10725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10726 :com.palletops.awaze.client-builder/undef)
     (.
      bean10724
      setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10810] (clojure.core/str arg10810))
 v10726))))
   (clojure.core/let
    [v10726
     (:environment-names
      m10725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10726 :com.palletops.awaze.client-builder/undef)
     (.
      bean10724
      setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10811] (clojure.core/str arg10811))
 v10726))))
   (clojure.core/let
    [v10726
     (:include-deleted
      m10725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10726 :com.palletops.awaze.client-builder/undef)
     (. bean10724 setIncludeDeleted (clojure.core/boolean v10726))))
   (clojure.core/let
    [v10726
     (:included-deleted-back-to
      m10725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10726 :com.palletops.awaze.client-builder/undef)
     (.
      bean10724
      setIncludedDeletedBackTo
      (com.palletops.awaze.common/to-date v10726))))
   bean10724))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m10728]
  (clojure.core/let
   [bean10727
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10729
     (:description m10728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10729 :com.palletops.awaze.client-builder/undef)
     (. bean10727 setDescription (clojure.core/str v10729))))
   (clojure.core/let
    [v10729
     (:options-to-remove
      m10728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10729 :com.palletops.awaze.client-builder/undef)
     (.
      bean10727
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10812]
  (elasticbeanstalk/option-specification arg10812))
 v10729))))
   (clojure.core/let
    [v10729
     (:application-name
      m10728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10729 :com.palletops.awaze.client-builder/undef)
     (. bean10727 setApplicationName (clojure.core/str v10729))))
   (clojure.core/let
    [v10729
     (:template-name m10728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10729 :com.palletops.awaze.client-builder/undef)
     (. bean10727 setTemplateName (clojure.core/str v10729))))
   (clojure.core/let
    [v10729
     (:option-settings
      m10728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10729 :com.palletops.awaze.client-builder/undef)
     (.
      bean10727
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10813]
  (elasticbeanstalk/configuration-option-setting arg10813))
 v10729))))
   bean10727))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m10731]
  (clojure.core/let
   [bean10730
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/let
    [v10732
     (:environment-id
      m10731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10732 :com.palletops.awaze.client-builder/undef)
     (. bean10730 setEnvironmentId (clojure.core/str v10732))))
   (clojure.core/let
    [v10732
     (:environment-name
      m10731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10732 :com.palletops.awaze.client-builder/undef)
     (. bean10730 setEnvironmentName (clojure.core/str v10732))))
   bean10730))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m10734]
  (clojure.core/let
   [bean10733
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean10733))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m10737]
  (clojure.core/let
   [bean10736
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/let
    [v10738
     (:application-name
      m10737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10738 :com.palletops.awaze.client-builder/undef)
     (. bean10736 setApplicationName (clojure.core/str v10738))))
   (clojure.core/let
    [v10738
     (:template-name m10737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10738 :com.palletops.awaze.client-builder/undef)
     (. bean10736 setTemplateName (clojure.core/str v10738))))
   (clojure.core/let
    [v10738
     (:environment-name
      m10737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10738 :com.palletops.awaze.client-builder/undef)
     (. bean10736 setEnvironmentName (clojure.core/str v10738))))
   (clojure.core/let
    [v10738
     (:option-settings
      m10737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10738 :com.palletops.awaze.client-builder/undef)
     (.
      bean10736
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10814]
  (elasticbeanstalk/configuration-option-setting arg10814))
 v10738))))
   bean10736))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest}
describe-instances-health-request
  [m10740]
  (clojure.core/let
   [bean10739
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest)]
   (clojure.core/let
    [v10741
     (:attribute-names
      m10740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (.
      bean10739
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10815] (clojure.core/str arg10815))
 v10741))))
   (clojure.core/let
    [v10741
     (:next-token m10740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (. bean10739 setNextToken (clojure.core/str v10741))))
   (clojure.core/let
    [v10741
     (:environment-id
      m10740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (. bean10739 setEnvironmentId (clojure.core/str v10741))))
   (clojure.core/let
    [v10741
     (:environment-name
      m10740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10741 :com.palletops.awaze.client-builder/undef)
     (. bean10739 setEnvironmentName (clojure.core/str v10741))))
   bean10739))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m10743]
  (clojure.core/let
   [bean10742
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/let
    [v10744
     (:description m10743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10744 :com.palletops.awaze.client-builder/undef)
     (. bean10742 setDescription (clojure.core/str v10744))))
   (clojure.core/let
    [v10744
     (:application-name
      m10743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10744 :com.palletops.awaze.client-builder/undef)
     (. bean10742 setApplicationName (clojure.core/str v10744))))
   bean10742))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m10746]
  (clojure.core/let
   [bean10745
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/let
    [v10747
     (:info-type m10746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10747 :com.palletops.awaze.client-builder/undef)
     (. bean10745 setInfoType (clojure.core/str v10747))))
   (clojure.core/let
    [v10747
     (:environment-id
      m10746
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10747 :com.palletops.awaze.client-builder/undef)
     (. bean10745 setEnvironmentId (clojure.core/str v10747))))
   (clojure.core/let
    [v10747
     (:environment-name
      m10746
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10747 :com.palletops.awaze.client-builder/undef)
     (. bean10745 setEnvironmentName (clojure.core/str v10747))))
   bean10745))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m10749]
  (clojure.core/let
   [bean10748
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/let
    [v10750
     (:option-settings
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (.
      bean10748
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10816]
  (elasticbeanstalk/configuration-option-setting arg10816))
 v10750))))
   (clojure.core/let
    [v10750
     (:description m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setDescription (clojure.core/str v10750))))
   (clojure.core/let
    [v10750
     (:cnameprefix m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setCNAMEPrefix (clojure.core/str v10750))))
   (clojure.core/let
    [v10750
     (:solution-stack-name
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setSolutionStackName (clojure.core/str v10750))))
   (clojure.core/let
    [v10750 (:tier m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setTier (elasticbeanstalk/environment-tier v10750))))
   (clojure.core/let
    [v10750
     (:version-label m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setVersionLabel (clojure.core/str v10750))))
   (clojure.core/let
    [v10750
     (:template-name m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setTemplateName (clojure.core/str v10750))))
   (clojure.core/let
    [v10750
     (:environment-name
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setEnvironmentName (clojure.core/str v10750))))
   (clojure.core/let
    [v10750 (:tags m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (.
      bean10748
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10817] (elasticbeanstalk/tag arg10817))
 v10750))))
   (clojure.core/let
    [v10750
     (:options-to-remove
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (.
      bean10748
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10818]
  (elasticbeanstalk/option-specification arg10818))
 v10750))))
   (clojure.core/let
    [v10750
     (:group-name m10749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setGroupName (clojure.core/str v10750))))
   (clojure.core/let
    [v10750
     (:application-name
      m10749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10750 :com.palletops.awaze.client-builder/undef)
     (. bean10748 setApplicationName (clojure.core/str v10750))))
   bean10748))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m10752]
  (clojure.core/let
   [bean10751
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/let
    [v10753
     (:application-name
      m10752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10753 :com.palletops.awaze.client-builder/undef)
     (. bean10751 setApplicationName (clojure.core/str v10753))))
   (clojure.core/let
    [v10753
     (:version-label m10752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10753 :com.palletops.awaze.client-builder/undef)
     (. bean10751 setVersionLabel (clojure.core/str v10753))))
   (clojure.core/let
    [v10753
     (:delete-source-bundle
      m10752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10753 :com.palletops.awaze.client-builder/undef)
     (. bean10751 setDeleteSourceBundle (clojure.core/boolean v10753))))
   bean10751))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m10762]
   (clojure.core/let
    [credentials10763 (:credentials m10762) args10764 (:args m10762)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10765
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10763)]
     (clojure.core/case
      (clojure.core/count args10764)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10765
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args10764 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10765
        describeApplicationVersions))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-application-versions,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-application-versions,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials10767 & args10768]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10769
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10767)]
    (clojure.core/case
     (clojure.core/count args10768)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10769
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args10768 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10769
       describeApplicationVersions))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :compose-environments
   [m10770]
   (clojure.core/let
    [credentials10771 (:credentials m10770) args10772 (:args m10770)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10773
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10771)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10773
       composeEnvironments
       (elasticbeanstalk/compose-environments-request
        (clojure.core/nth args10772 0)))))))
  (clojure.core/defn
   compose-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for composeEnvironments"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :compose-environments,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   compose-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call composeEnvironments"}
   [credentials10775 & args10776]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10777
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10775)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10777
      composeEnvironments
      (elasticbeanstalk/compose-environments-request
       (clojure.core/nth args10776 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m10778]
   (clojure.core/let
    [credentials10779 (:credentials m10778) args10780 (:args m10778)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10781
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10779)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10781
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args10780 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :rebuild-environment,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials10783 & args10784]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10785
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10783)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10785
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args10784 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m10786]
   (clojure.core/let
    [credentials10787 (:credentials m10786) args10788 (:args m10786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10789
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10787)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10789
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args10788 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-application-version,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials10791 & args10792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10793
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10791)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10793
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args10792 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m10794]
   (clojure.core/let
    [credentials10795 (:credentials m10794) args10796 (:args m10794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10797
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10797
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args10796 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-environment-configuration,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials10799 & args10800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10801
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10801
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args10800 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m10802]
   (clojure.core/let
    [credentials10803 (:credentials m10802) args10804 (:args m10802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10805
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10803)]
     (clojure.core/case
      (clojure.core/count args10804)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10805
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10805
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args10804 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials10807 & args10808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10809
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10807)]
    (clojure.core/case
     (clojure.core/count args10808)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10809
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10809
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args10808 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m10819]
   (clojure.core/let
    [credentials10820 (:credentials m10819) args10821 (:args m10819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10822
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10822
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args10821 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-configuration-settings,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials10824 & args10825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10826
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10826
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args10825 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m10827]
   (clojure.core/let
    [credentials10828 (:credentials m10827) args10829 (:args m10827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10830
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10830
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args10829 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :terminate-environment,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call terminateEnvironment"}
   [credentials10832 & args10833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10834
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10834
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args10833 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m10835]
   (clojure.core/let
    [credentials10836 (:credentials m10835) args10837 (:args m10835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10838
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10838
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args10837 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-configuration-options,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials10840 & args10841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10842
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10842
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args10841 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m10843]
   (clojure.core/let
    [credentials10844 (:credentials m10843) args10845 (:args m10843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10846
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10846
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args10845 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-configuration-template,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials10848 & args10849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10850
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10850
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args10849 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m10851]
   (clojure.core/let
    [credentials10852 (:credentials m10851) args10853 (:args m10851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10854
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10854
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args10853 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-environment,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call updateEnvironment"}
   [credentials10856 & args10857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10858
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10858
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args10857 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m10859]
   (clojure.core/let
    [credentials10860 (:credentials m10859) args10861 (:args m10859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10862
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10860)]
     (clojure.core/case
      (clojure.core/count args10861)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10862
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args10861 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10862
        describeApplications))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]
                [credentials]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-applications,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-applications,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]
                [credentials]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials10864 & args10865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10866
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10864)]
    (clojure.core/case
     (clojure.core/count args10865)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10866
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args10865 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10866
       describeApplications))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m10867]
   (clojure.core/let
    [credentials10868 (:credentials m10867) args10869 (:args m10867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10870
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10868)]
     (clojure.core/case
      (clojure.core/count args10869)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10870
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args10869 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10870
        createStorageLocation))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :create-storage-location,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-storage-location,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials10872 & args10873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10874
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10872)]
    (clojure.core/case
     (clojure.core/count args10873)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10874
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args10873 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10874
       createStorageLocation))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m10875]
   (clojure.core/let
    [credentials10876 (:credentials m10875) args10877 (:args m10875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10878
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10878
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args10877 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :restart-app-server,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call restartAppServer"}
   [credentials10880 & args10881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10882
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10882
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args10881 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m10883]
   (clojure.core/let
    [credentials10884 (:credentials m10883) args10885 (:args m10883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10886
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10886
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args10885 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-application,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplication"}
   [credentials10888 & args10889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10890
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10890
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args10889 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m10891]
   (clojure.core/let
    [credentials10892 (:credentials m10891) args10893 (:args m10891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10894
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10894
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args10893 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-application,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createApplication"}
   [credentials10896 & args10897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10898
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10898
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args10897 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m10899]
   (clojure.core/let
    [credentials10900 (:credentials m10899) args10901 (:args m10899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10902
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10902
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args10901 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-configuration-template,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials10904 & args10905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10906
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10906
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args10905 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m10907]
   (clojure.core/let
    [credentials10908 (:credentials m10907) args10909 (:args m10907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10910
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10908)]
     (clojure.core/case
      (clojure.core/count args10909)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10910
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args10909 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10910
        swapEnvironmentCNAMEs))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]
                [credentials]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :swap-environment-cnames,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :swap-environment-cnames,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]
                [credentials]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials10912 & args10913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10914
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10912)]
    (clojure.core/case
     (clojure.core/count args10913)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10914
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args10913 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10914
       swapEnvironmentCNAMEs))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-health
   [m10915]
   (clojure.core/let
    [credentials10916 (:credentials m10915) args10917 (:args m10915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10918
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10918
       describeEnvironmentHealth
       (elasticbeanstalk/describe-environment-health-request
        (clojure.core/nth args10917 0)))))))
  (clojure.core/defn
   describe-environment-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentHealth"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-environment-health,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentHealth"}
   [credentials10920 & args10921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10922
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10922
      describeEnvironmentHealth
      (elasticbeanstalk/describe-environment-health-request
       (clojure.core/nth args10921 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :abort-environment-update
   [m10923]
   (clojure.core/let
    [credentials10924 (:credentials m10923) args10925 (:args m10923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10926
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10924)]
     (clojure.core/case
      (clojure.core/count args10925)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10926
        abortEnvironmentUpdate
        (elasticbeanstalk/abort-environment-update-request
         (clojure.core/nth args10925 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10926
        abortEnvironmentUpdate))))))
  (clojure.core/defn
   abort-environment-update-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for abortEnvironmentUpdate, abortEnvironmentUpdate"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :abort-environment-update,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :abort-environment-update,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   abort-environment-update
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]
                [credentials]]),
    :doc "Call abortEnvironmentUpdate, abortEnvironmentUpdate"}
   [credentials10928 & args10929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10930
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10928)]
    (clojure.core/case
     (clojure.core/count args10929)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10930
       abortEnvironmentUpdate
       (elasticbeanstalk/abort-environment-update-request
        (clojure.core/nth args10929 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10930
       abortEnvironmentUpdate))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m10931]
   (clojure.core/let
    [credentials10932 (:credentials m10931) args10933 (:args m10931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10934
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10934
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args10933 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :check-dnsavailability,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials10936 & args10937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10938
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10938
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args10937 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m10939]
   (clojure.core/let
    [credentials10940 (:credentials m10939) args10941 (:args m10939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10942
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10942
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args10941 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :retrieve-environment-info,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials10944 & args10945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10946
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10946
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args10945 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m10947]
   (clojure.core/let
    [credentials10948 (:credentials m10947) args10949 (:args m10947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10950
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10950
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args10949 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-application-version,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Call createApplicationVersion"}
   [credentials10952 & args10953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10954
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10954
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args10953 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m10955]
   (clojure.core/let
    [credentials10956 (:credentials m10955) args10957 (:args m10955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10958
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10956)]
     (clojure.core/case
      (clojure.core/count args10957)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10958
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args10957 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10958
        describeEnvironments))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]
                [credentials]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-environments,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-environments,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]
                [credentials]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials10960 & args10961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10962
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10960)]
    (clojure.core/case
     (clojure.core/count args10961)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10962
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args10961 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10962
       describeEnvironments))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m10963]
   (clojure.core/let
    [credentials10964 (:credentials m10963) args10965 (:args m10963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10966
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10966
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args10965 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-configuration-template,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials10968 & args10969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10970
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10970
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args10969 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m10971]
   (clojure.core/let
    [credentials10972 (:credentials m10971) args10973 (:args m10971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10974
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10974
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args10973 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-environment-resources,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials10976 & args10977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10978
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10978
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args10977 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m10979]
   (clojure.core/let
    [credentials10980 (:credentials m10979) args10981 (:args m10979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10982
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10980)]
     (clojure.core/case
      (clojure.core/count args10981)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10982
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args10981 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10982
        listAvailableSolutionStacks))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-available-solution-stacks,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-available-solution-stacks,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials10984 & args10985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10986
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10984)]
    (clojure.core/case
     (clojure.core/count args10985)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10986
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args10985 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10986
       listAvailableSolutionStacks))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m10987]
   (clojure.core/let
    [credentials10988 (:credentials m10987) args10989 (:args m10987)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10990
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10988)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10990
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args10989 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :validate-configuration-settings,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials10992 & args10993]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10994
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10992)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10994
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args10993 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-instances-health
   [m10995]
   (clojure.core/let
    [credentials10996 (:credentials m10995) args10997 (:args m10995)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10998
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10996)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10998
       describeInstancesHealth
       (elasticbeanstalk/describe-instances-health-request
        (clojure.core/nth args10997 0)))))))
  (clojure.core/defn
   describe-instances-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstancesHealth"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-instances-health,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-instances-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstancesHealth"}
   [credentials11000 & args11001]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11002
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11000)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11002
      describeInstancesHealth
      (elasticbeanstalk/describe-instances-health-request
       (clojure.core/nth args11001 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m11003]
   (clojure.core/let
    [credentials11004 (:credentials m11003) args11005 (:args m11003)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11006
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11004)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11006
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args11005 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-application,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplication"}
   [credentials11008 & args11009]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11010
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11008)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11010
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args11009 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m11011]
   (clojure.core/let
    [credentials11012 (:credentials m11011) args11013 (:args m11011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11014
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11012)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11014
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args11013 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :request-environment-info,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials11016 & args11017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11018
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11016)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11018
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args11017 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m11019]
   (clojure.core/let
    [credentials11020 (:credentials m11019) args11021 (:args m11019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11022
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11022
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args11021 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-environment,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call createEnvironment"}
   [credentials11024 & args11025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11026
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11026
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args11025 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m11027]
   (clojure.core/let
    [credentials11028 (:credentials m11027) args11029 (:args m11027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11030
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11030
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args11029 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-application-version,
     :credentials credentials__1784__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials11032 & args11033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11034
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11032)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11034
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args11033 0))))))))
