(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m14248]
  (clojure.core/let
   [bean14247
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/let
    [v14249
     (:parameter-value
      m14248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14249 :com.palletops.awaze.client-builder/undef)
     (. bean14247 setParameterValue (clojure.core/str v14249))))
   (clojure.core/let
    [v14249
     (:parameter-name
      m14248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14249 :com.palletops.awaze.client-builder/undef)
     (. bean14247 setParameterName (clojure.core/str v14249))))
   bean14247))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.Tag}
tag
  [m14251]
  (clojure.core/let
   [bean14250 (new com.amazonaws.services.elasticache.model.Tag)]
   (clojure.core/let
    [v14252 (:value m14251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14252 :com.palletops.awaze.client-builder/undef)
     (. bean14250 setValue (clojure.core/str v14252))))
   (clojure.core/let
    [v14252 (:key m14251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14252 :com.palletops.awaze.client-builder/undef)
     (. bean14250 setKey (clojure.core/str v14252))))
   bean14250))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m14254]
  (clojure.core/let
   [bean14253
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/let
    [v14255
     (:parameter-name-values
      m14254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14255 :com.palletops.awaze.client-builder/undef)
     (.
      bean14253
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14367]
  (elasticache/parameter-name-value arg14367))
 v14255))))
   (clojure.core/let
    [v14255
     (:cache-parameter-group-name
      m14254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14255 :com.palletops.awaze.client-builder/undef)
     (.
      bean14253
      setCacheParameterGroupName
      (clojure.core/str v14255))))
   bean14253))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m14257]
  (clojure.core/let
   [bean14256
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/let
    [v14258
     (:marker m14257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14258 :com.palletops.awaze.client-builder/undef)
     (. bean14256 setMarker (clojure.core/str v14258))))
   (clojure.core/let
    [v14258
     (:max-records m14257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14258 :com.palletops.awaze.client-builder/undef)
     (. bean14256 setMaxRecords (clojure.core/int v14258))))
   (clojure.core/let
    [v14258
     (:replication-group-id
      m14257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14258 :com.palletops.awaze.client-builder/undef)
     (. bean14256 setReplicationGroupId (clojure.core/str v14258))))
   bean14256))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m14260]
  (clojure.core/let
   [bean14259
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/let
    [v14261
     (:engine m14260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setEngine (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:preferred-availability-zones
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setPreferredAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14368] (clojure.core/str arg14368))
 v14261))))
   (clojure.core/let
    [v14261
     (:cache-subnet-group-name
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setCacheSubnetGroupName (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:replication-group-id
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setReplicationGroupId (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:security-group-ids
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14369] (clojure.core/str arg14369))
 v14261))))
   (clojure.core/let
    [v14261
     (:snapshot-retention-limit
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setSnapshotRetentionLimit (clojure.core/int v14261))))
   (clojure.core/let
    [v14261
     (:preferred-maintenance-window
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setPreferredMaintenanceWindow
      (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:azmode m14260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setAZMode (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:notification-topic-arn
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setNotificationTopicArn (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:cache-security-group-names
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14370] (clojure.core/str arg14370))
 v14261))))
   (clojure.core/let
    [v14261
     (:snapshot-name m14260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setSnapshotName (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:preferred-availability-zone
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setPreferredAvailabilityZone
      (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:snapshot-arns m14260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14371] (clojure.core/str arg14371))
 v14261))))
   (clojure.core/let
    [v14261 (:port m14260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setPort (clojure.core/int v14261))))
   (clojure.core/let
    [v14261 (:tags m14260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14372] (elasticache/tag arg14372))
 v14261))))
   (clojure.core/let
    [v14261
     (:cache-parameter-group-name
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setCacheParameterGroupName
      (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:cache-cluster-id
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setCacheClusterId (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:num-cache-nodes
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setNumCacheNodes (clojure.core/int v14261))))
   (clojure.core/let
    [v14261
     (:auto-minor-version-upgrade
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (.
      bean14259
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14261))))
   (clojure.core/let
    [v14261
     (:snapshot-window
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setSnapshotWindow (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:engine-version
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setEngineVersion (clojure.core/str v14261))))
   (clojure.core/let
    [v14261
     (:cache-node-type
      m14260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14261 :com.palletops.awaze.client-builder/undef)
     (. bean14259 setCacheNodeType (clojure.core/str v14261))))
   bean14259))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m14263]
  (clojure.core/let
   [bean14262
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/let
    [v14264
     (:marker m14263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14264 :com.palletops.awaze.client-builder/undef)
     (. bean14262 setMarker (clojure.core/str v14264))))
   (clojure.core/let
    [v14264
     (:max-records m14263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14264 :com.palletops.awaze.client-builder/undef)
     (. bean14262 setMaxRecords (clojure.core/int v14264))))
   (clojure.core/let
    [v14264
     (:cache-parameter-group-name
      m14263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14264 :com.palletops.awaze.client-builder/undef)
     (.
      bean14262
      setCacheParameterGroupName
      (clojure.core/str v14264))))
   bean14262))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m14266]
  (clojure.core/let
   [bean14265
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/let
    [v14267
     (:cache-parameter-group-name
      m14266
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14267 :com.palletops.awaze.client-builder/undef)
     (.
      bean14265
      setCacheParameterGroupName
      (clojure.core/str v14267))))
   bean14265))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m14269]
  (clojure.core/let
   [bean14268
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14270
     (:description m14269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14270 :com.palletops.awaze.client-builder/undef)
     (. bean14268 setDescription (clojure.core/str v14270))))
   (clojure.core/let
    [v14270
     (:cache-security-group-name
      m14269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14270 :com.palletops.awaze.client-builder/undef)
     (. bean14268 setCacheSecurityGroupName (clojure.core/str v14270))))
   bean14268))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m14272]
  (clojure.core/let
   [bean14271
    (new
     com.amazonaws.services.elasticache.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v14273 (:tags m14272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14273 :com.palletops.awaze.client-builder/undef)
     (.
      bean14271
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14373] (elasticache/tag arg14373))
 v14273))))
   (clojure.core/let
    [v14273
     (:resource-name m14272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14273 :com.palletops.awaze.client-builder/undef)
     (. bean14271 setResourceName (clojure.core/str v14273))))
   bean14271))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m14275]
  (clojure.core/let
   [bean14274
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/let
    [v14276
     (:source-identifier
      m14275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (. bean14274 setSourceIdentifier (clojure.core/str v14276))))
   (clojure.core/let
    [v14276
     (:source-type m14275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (. bean14274 setSourceType (clojure.core/str v14276))))
   (clojure.core/let
    [v14276
     (:duration m14275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (. bean14274 setDuration (clojure.core/int v14276))))
   (clojure.core/let
    [v14276
     (:start-time m14275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (.
      bean14274
      setStartTime
      (com.palletops.awaze.common/to-date v14276))))
   (clojure.core/let
    [v14276
     (:end-time m14275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (.
      bean14274
      setEndTime
      (com.palletops.awaze.common/to-date v14276))))
   (clojure.core/let
    [v14276
     (:marker m14275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (. bean14274 setMarker (clojure.core/str v14276))))
   (clojure.core/let
    [v14276
     (:max-records m14275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14276 :com.palletops.awaze.client-builder/undef)
     (. bean14274 setMaxRecords (clojure.core/int v14276))))
   bean14274))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m14278]
  (clojure.core/let
   [bean14277
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14279
     (:subnet-ids m14278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14279 :com.palletops.awaze.client-builder/undef)
     (.
      bean14277
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14374] (clojure.core/str arg14374))
 v14279))))
   (clojure.core/let
    [v14279
     (:cache-subnet-group-name
      m14278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14279 :com.palletops.awaze.client-builder/undef)
     (. bean14277 setCacheSubnetGroupName (clojure.core/str v14279))))
   (clojure.core/let
    [v14279
     (:cache-subnet-group-description
      m14278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14279 :com.palletops.awaze.client-builder/undef)
     (.
      bean14277
      setCacheSubnetGroupDescription
      (clojure.core/str v14279))))
   bean14277))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m14281]
  (clojure.core/let
   [bean14280
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14282
     (:ec2security-group-name
      m14281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14282 :com.palletops.awaze.client-builder/undef)
     (. bean14280 setEC2SecurityGroupName (clojure.core/str v14282))))
   (clojure.core/let
    [v14282
     (:ec2security-group-owner-id
      m14281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14282 :com.palletops.awaze.client-builder/undef)
     (.
      bean14280
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14282))))
   (clojure.core/let
    [v14282
     (:cache-security-group-name
      m14281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14282 :com.palletops.awaze.client-builder/undef)
     (. bean14280 setCacheSecurityGroupName (clojure.core/str v14282))))
   bean14280))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m14284]
  (clojure.core/let
   [bean14283
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/let
    [v14285
     (:duration m14284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setDuration (clojure.core/str v14285))))
   (clojure.core/let
    [v14285
     (:offering-type m14284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setOfferingType (clojure.core/str v14285))))
   (clojure.core/let
    [v14285
     (:product-description
      m14284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setProductDescription (clojure.core/str v14285))))
   (clojure.core/let
    [v14285
     (:marker m14284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setMarker (clojure.core/str v14285))))
   (clojure.core/let
    [v14285
     (:max-records m14284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setMaxRecords (clojure.core/int v14285))))
   (clojure.core/let
    [v14285
     (:reserved-cache-node-id
      m14284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setReservedCacheNodeId (clojure.core/str v14285))))
   (clojure.core/let
    [v14285
     (:reserved-cache-nodes-offering-id
      m14284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (.
      bean14283
      setReservedCacheNodesOfferingId
      (clojure.core/str v14285))))
   (clojure.core/let
    [v14285
     (:cache-node-type
      m14284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14285 :com.palletops.awaze.client-builder/undef)
     (. bean14283 setCacheNodeType (clojure.core/str v14285))))
   bean14283))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m14287]
  (clojure.core/let
   [bean14286
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/let
    [v14288
     (:cache-node-ids-to-reboot
      m14287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14288 :com.palletops.awaze.client-builder/undef)
     (.
      bean14286
      setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14375] (clojure.core/str arg14375))
 v14288))))
   (clojure.core/let
    [v14288
     (:cache-cluster-id
      m14287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14288 :com.palletops.awaze.client-builder/undef)
     (. bean14286 setCacheClusterId (clojure.core/str v14288))))
   bean14286))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m14290]
  (clojure.core/let
   [bean14289
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/let
    [v14291
     (:marker m14290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14291 :com.palletops.awaze.client-builder/undef)
     (. bean14289 setMarker (clojure.core/str v14291))))
   (clojure.core/let
    [v14291
     (:show-cache-node-info
      m14290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14291 :com.palletops.awaze.client-builder/undef)
     (. bean14289 setShowCacheNodeInfo (clojure.core/boolean v14291))))
   (clojure.core/let
    [v14291
     (:max-records m14290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14291 :com.palletops.awaze.client-builder/undef)
     (. bean14289 setMaxRecords (clojure.core/int v14291))))
   (clojure.core/let
    [v14291
     (:cache-cluster-id
      m14290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14291 :com.palletops.awaze.client-builder/undef)
     (. bean14289 setCacheClusterId (clojure.core/str v14291))))
   bean14289))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m14293]
  (clojure.core/let
   [bean14292
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/let
    [v14294
     (:source-snapshot-name
      m14293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14294 :com.palletops.awaze.client-builder/undef)
     (. bean14292 setSourceSnapshotName (clojure.core/str v14294))))
   (clojure.core/let
    [v14294
     (:target-snapshot-name
      m14293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14294 :com.palletops.awaze.client-builder/undef)
     (. bean14292 setTargetSnapshotName (clojure.core/str v14294))))
   bean14292))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m14296]
  (clojure.core/let
   [bean14295
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v14297
     (:snapshot-name m14296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14297 :com.palletops.awaze.client-builder/undef)
     (. bean14295 setSnapshotName (clojure.core/str v14297))))
   bean14295))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m14299]
  (clojure.core/let
   [bean14298
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/let
    [v14300
     (:marker m14299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14300 :com.palletops.awaze.client-builder/undef)
     (. bean14298 setMarker (clojure.core/str v14300))))
   (clojure.core/let
    [v14300
     (:max-records m14299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14300 :com.palletops.awaze.client-builder/undef)
     (. bean14298 setMaxRecords (clojure.core/int v14300))))
   (clojure.core/let
    [v14300
     (:default-only m14299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14300 :com.palletops.awaze.client-builder/undef)
     (. bean14298 setDefaultOnly (clojure.core/boolean v14300))))
   (clojure.core/let
    [v14300
     (:engine m14299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14300 :com.palletops.awaze.client-builder/undef)
     (. bean14298 setEngine (clojure.core/str v14300))))
   (clojure.core/let
    [v14300
     (:engine-version
      m14299
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14300 :com.palletops.awaze.client-builder/undef)
     (. bean14298 setEngineVersion (clojure.core/str v14300))))
   (clojure.core/let
    [v14300
     (:cache-parameter-group-family
      m14299
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14300 :com.palletops.awaze.client-builder/undef)
     (.
      bean14298
      setCacheParameterGroupFamily
      (clojure.core/str v14300))))
   bean14298))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m14302]
  (clojure.core/let
   [bean14301
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v14303
     (:marker m14302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14303 :com.palletops.awaze.client-builder/undef)
     (. bean14301 setMarker (clojure.core/str v14303))))
   (clojure.core/let
    [v14303
     (:max-records m14302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14303 :com.palletops.awaze.client-builder/undef)
     (. bean14301 setMaxRecords (clojure.core/int v14303))))
   (clojure.core/let
    [v14303
     (:cache-parameter-group-family
      m14302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14303 :com.palletops.awaze.client-builder/undef)
     (.
      bean14301
      setCacheParameterGroupFamily
      (clojure.core/str v14303))))
   bean14301))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m14305]
  (clojure.core/let
   [bean14304
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/let
    [v14306
     (:final-snapshot-identifier
      m14305
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14306 :com.palletops.awaze.client-builder/undef)
     (.
      bean14304
      setFinalSnapshotIdentifier
      (clojure.core/str v14306))))
   (clojure.core/let
    [v14306
     (:replication-group-id
      m14305
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14306 :com.palletops.awaze.client-builder/undef)
     (. bean14304 setReplicationGroupId (clojure.core/str v14306))))
   (clojure.core/let
    [v14306
     (:retain-primary-cluster
      m14305
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14306 :com.palletops.awaze.client-builder/undef)
     (.
      bean14304
      setRetainPrimaryCluster
      (clojure.core/boolean v14306))))
   bean14304))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m14308]
  (clojure.core/let
   [bean14307
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14309
     (:subnet-ids m14308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14309 :com.palletops.awaze.client-builder/undef)
     (.
      bean14307
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14376] (clojure.core/str arg14376))
 v14309))))
   (clojure.core/let
    [v14309
     (:cache-subnet-group-name
      m14308
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14309 :com.palletops.awaze.client-builder/undef)
     (. bean14307 setCacheSubnetGroupName (clojure.core/str v14309))))
   (clojure.core/let
    [v14309
     (:cache-subnet-group-description
      m14308
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14309 :com.palletops.awaze.client-builder/undef)
     (.
      bean14307
      setCacheSubnetGroupDescription
      (clojure.core/str v14309))))
   bean14307))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m14311]
  (clojure.core/let
   [bean14310
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/let
    [v14312
     (:new-availability-zones
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setNewAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14377] (clojure.core/str arg14377))
 v14312))))
   (clojure.core/let
    [v14312
     (:security-group-ids
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14378] (clojure.core/str arg14378))
 v14312))))
   (clojure.core/let
    [v14312
     (:snapshot-retention-limit
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setSnapshotRetentionLimit (clojure.core/int v14312))))
   (clojure.core/let
    [v14312
     (:apply-immediately
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setApplyImmediately (clojure.core/boolean v14312))))
   (clojure.core/let
    [v14312
     (:preferred-maintenance-window
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setPreferredMaintenanceWindow
      (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:azmode m14311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setAZMode (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:notification-topic-arn
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setNotificationTopicArn (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:cache-security-group-names
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14379] (clojure.core/str arg14379))
 v14312))))
   (clojure.core/let
    [v14312
     (:cache-parameter-group-name
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setCacheParameterGroupName
      (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:cache-cluster-id
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setCacheClusterId (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:notification-topic-status
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setNotificationTopicStatus
      (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:num-cache-nodes
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setNumCacheNodes (clojure.core/int v14312))))
   (clojure.core/let
    [v14312
     (:cache-node-ids-to-remove
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14380] (clojure.core/str arg14380))
 v14312))))
   (clojure.core/let
    [v14312
     (:auto-minor-version-upgrade
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (.
      bean14310
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14312))))
   (clojure.core/let
    [v14312
     (:snapshot-window
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setSnapshotWindow (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:engine-version
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setEngineVersion (clojure.core/str v14312))))
   (clojure.core/let
    [v14312
     (:cache-node-type
      m14311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14312 :com.palletops.awaze.client-builder/undef)
     (. bean14310 setCacheNodeType (clojure.core/str v14312))))
   bean14310))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m14314]
  (clojure.core/let
   [bean14313
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14315
     (:ec2security-group-name
      m14314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14315 :com.palletops.awaze.client-builder/undef)
     (. bean14313 setEC2SecurityGroupName (clojure.core/str v14315))))
   (clojure.core/let
    [v14315
     (:ec2security-group-owner-id
      m14314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14315 :com.palletops.awaze.client-builder/undef)
     (.
      bean14313
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14315))))
   (clojure.core/let
    [v14315
     (:cache-security-group-name
      m14314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14315 :com.palletops.awaze.client-builder/undef)
     (. bean14313 setCacheSecurityGroupName (clojure.core/str v14315))))
   bean14313))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m14317]
  (clojure.core/let
   [bean14316
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/let
    [v14318
     (:marker m14317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14318 :com.palletops.awaze.client-builder/undef)
     (. bean14316 setMarker (clojure.core/str v14318))))
   (clojure.core/let
    [v14318
     (:source m14317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14318 :com.palletops.awaze.client-builder/undef)
     (. bean14316 setSource (clojure.core/str v14318))))
   (clojure.core/let
    [v14318
     (:max-records m14317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14318 :com.palletops.awaze.client-builder/undef)
     (. bean14316 setMaxRecords (clojure.core/int v14318))))
   (clojure.core/let
    [v14318
     (:cache-parameter-group-name
      m14317
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14318 :com.palletops.awaze.client-builder/undef)
     (.
      bean14316
      setCacheParameterGroupName
      (clojure.core/str v14318))))
   bean14316))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m14320]
  (clojure.core/let
   [bean14319
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/let
    [v14321
     (:cache-cluster-id
      m14320
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14321 :com.palletops.awaze.client-builder/undef)
     (. bean14319 setCacheClusterId (clojure.core/str v14321))))
   (clojure.core/let
    [v14321
     (:final-snapshot-identifier
      m14320
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14321 :com.palletops.awaze.client-builder/undef)
     (.
      bean14319
      setFinalSnapshotIdentifier
      (clojure.core/str v14321))))
   bean14319))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest}
list-allowed-node-type-modifications-request
  [m14323]
  (clojure.core/let
   [bean14322
    (new
     com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest)]
   (clojure.core/let
    [v14324
     (:cache-cluster-id
      m14323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14324 :com.palletops.awaze.client-builder/undef)
     (. bean14322 setCacheClusterId (clojure.core/str v14324))))
   (clojure.core/let
    [v14324
     (:replication-group-id
      m14323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14324 :com.palletops.awaze.client-builder/undef)
     (. bean14322 setReplicationGroupId (clojure.core/str v14324))))
   bean14322))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m14326]
  (clojure.core/let
   [bean14325
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/let
    [v14327
     (:description m14326 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14327 :com.palletops.awaze.client-builder/undef)
     (. bean14325 setDescription (clojure.core/str v14327))))
   (clojure.core/let
    [v14327
     (:cache-parameter-group-family
      m14326
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14327 :com.palletops.awaze.client-builder/undef)
     (.
      bean14325
      setCacheParameterGroupFamily
      (clojure.core/str v14327))))
   (clojure.core/let
    [v14327
     (:cache-parameter-group-name
      m14326
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14327 :com.palletops.awaze.client-builder/undef)
     (.
      bean14325
      setCacheParameterGroupName
      (clojure.core/str v14327))))
   bean14325))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m14329]
  (clojure.core/let
   [bean14328
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/let
    [v14330
     (:snapshotting-cluster-id
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setSnapshottingClusterId (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:replication-group-description
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setReplicationGroupDescription
      (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:replication-group-id
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setReplicationGroupId (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:security-group-ids
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14381] (clojure.core/str arg14381))
 v14330))))
   (clojure.core/let
    [v14330
     (:snapshot-retention-limit
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setSnapshotRetentionLimit (clojure.core/int v14330))))
   (clojure.core/let
    [v14330
     (:apply-immediately
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setApplyImmediately (clojure.core/boolean v14330))))
   (clojure.core/let
    [v14330
     (:primary-cluster-id
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setPrimaryClusterId (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:preferred-maintenance-window
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setPreferredMaintenanceWindow
      (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:notification-topic-arn
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setNotificationTopicArn (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:cache-security-group-names
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14382] (clojure.core/str arg14382))
 v14330))))
   (clojure.core/let
    [v14330
     (:cache-parameter-group-name
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setCacheParameterGroupName
      (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:notification-topic-status
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setNotificationTopicStatus
      (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:auto-minor-version-upgrade
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14330))))
   (clojure.core/let
    [v14330
     (:automatic-failover-enabled
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (.
      bean14328
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14330))))
   (clojure.core/let
    [v14330
     (:snapshot-window
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setSnapshotWindow (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:engine-version
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setEngineVersion (clojure.core/str v14330))))
   (clojure.core/let
    [v14330
     (:cache-node-type
      m14329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14330 :com.palletops.awaze.client-builder/undef)
     (. bean14328 setCacheNodeType (clojure.core/str v14330))))
   bean14328))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m14332]
  (clojure.core/let
   [bean14331
    (new
     com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v14333
     (:tag-keys m14332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14333 :com.palletops.awaze.client-builder/undef)
     (.
      bean14331
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14383] (clojure.core/str arg14383))
 v14333))))
   (clojure.core/let
    [v14333
     (:resource-name m14332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14333 :com.palletops.awaze.client-builder/undef)
     (. bean14331 setResourceName (clojure.core/str v14333))))
   bean14331))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m14335]
  (clojure.core/let
   [bean14334
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/let
    [v14336
     (:duration m14335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (. bean14334 setDuration (clojure.core/str v14336))))
   (clojure.core/let
    [v14336
     (:offering-type m14335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (. bean14334 setOfferingType (clojure.core/str v14336))))
   (clojure.core/let
    [v14336
     (:product-description
      m14335
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (. bean14334 setProductDescription (clojure.core/str v14336))))
   (clojure.core/let
    [v14336
     (:marker m14335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (. bean14334 setMarker (clojure.core/str v14336))))
   (clojure.core/let
    [v14336
     (:max-records m14335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (. bean14334 setMaxRecords (clojure.core/int v14336))))
   (clojure.core/let
    [v14336
     (:reserved-cache-nodes-offering-id
      m14335
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (.
      bean14334
      setReservedCacheNodesOfferingId
      (clojure.core/str v14336))))
   (clojure.core/let
    [v14336
     (:cache-node-type
      m14335
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14336 :com.palletops.awaze.client-builder/undef)
     (. bean14334 setCacheNodeType (clojure.core/str v14336))))
   bean14334))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m14338]
  (clojure.core/let
   [bean14337
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/let
    [v14339
     (:marker m14338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14339 :com.palletops.awaze.client-builder/undef)
     (. bean14337 setMarker (clojure.core/str v14339))))
   (clojure.core/let
    [v14339
     (:max-records m14338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14339 :com.palletops.awaze.client-builder/undef)
     (. bean14337 setMaxRecords (clojure.core/int v14339))))
   (clojure.core/let
    [v14339
     (:cache-security-group-name
      m14338
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14339 :com.palletops.awaze.client-builder/undef)
     (. bean14337 setCacheSecurityGroupName (clojure.core/str v14339))))
   bean14337))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m14341]
  (clojure.core/let
   [bean14340
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/let
    [v14342
     (:preferred-cache-cluster-azs
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setPreferredCacheClusterAZs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14432] (clojure.core/str arg14432))
 v14342))))
   (clojure.core/let
    [v14342
     (:engine m14341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setEngine (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:replication-group-description
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setReplicationGroupDescription
      (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:cache-subnet-group-name
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setCacheSubnetGroupName (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:replication-group-id
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setReplicationGroupId (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:security-group-ids
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14433] (clojure.core/str arg14433))
 v14342))))
   (clojure.core/let
    [v14342
     (:snapshot-retention-limit
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setSnapshotRetentionLimit (clojure.core/int v14342))))
   (clojure.core/let
    [v14342
     (:primary-cluster-id
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setPrimaryClusterId (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:preferred-maintenance-window
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setPreferredMaintenanceWindow
      (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:notification-topic-arn
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setNotificationTopicArn (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:cache-security-group-names
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14434] (clojure.core/str arg14434))
 v14342))))
   (clojure.core/let
    [v14342
     (:snapshot-name m14341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setSnapshotName (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:snapshot-arns m14341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14435] (clojure.core/str arg14435))
 v14342))))
   (clojure.core/let
    [v14342 (:port m14341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setPort (clojure.core/int v14342))))
   (clojure.core/let
    [v14342 (:tags m14341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14436] (elasticache/tag arg14436))
 v14342))))
   (clojure.core/let
    [v14342
     (:cache-parameter-group-name
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setCacheParameterGroupName
      (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:auto-minor-version-upgrade
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14342))))
   (clojure.core/let
    [v14342
     (:automatic-failover-enabled
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (.
      bean14340
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14342))))
   (clojure.core/let
    [v14342
     (:snapshot-window
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setSnapshotWindow (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:engine-version
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setEngineVersion (clojure.core/str v14342))))
   (clojure.core/let
    [v14342
     (:num-cache-clusters
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setNumCacheClusters (clojure.core/int v14342))))
   (clojure.core/let
    [v14342
     (:cache-node-type
      m14341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14342 :com.palletops.awaze.client-builder/undef)
     (. bean14340 setCacheNodeType (clojure.core/str v14342))))
   bean14340))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m14344]
  (clojure.core/let
   [bean14343
    (new
     com.amazonaws.services.elasticache.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v14345
     (:resource-name m14344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14345 :com.palletops.awaze.client-builder/undef)
     (. bean14343 setResourceName (clojure.core/str v14345))))
   bean14343))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m14347]
  (clojure.core/let
   [bean14346
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/let
    [v14348
     (:parameter-name-values
      m14347
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14348 :com.palletops.awaze.client-builder/undef)
     (.
      bean14346
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14437]
  (elasticache/parameter-name-value arg14437))
 v14348))))
   (clojure.core/let
    [v14348
     (:reset-all-parameters
      m14347
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14348 :com.palletops.awaze.client-builder/undef)
     (. bean14346 setResetAllParameters (clojure.core/boolean v14348))))
   (clojure.core/let
    [v14348
     (:cache-parameter-group-name
      m14347
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14348 :com.palletops.awaze.client-builder/undef)
     (.
      bean14346
      setCacheParameterGroupName
      (clojure.core/str v14348))))
   bean14346))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m14350]
  (clojure.core/let
   [bean14349
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v14351
     (:marker m14350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14351 :com.palletops.awaze.client-builder/undef)
     (. bean14349 setMarker (clojure.core/str v14351))))
   (clojure.core/let
    [v14351
     (:max-records m14350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14351 :com.palletops.awaze.client-builder/undef)
     (. bean14349 setMaxRecords (clojure.core/int v14351))))
   (clojure.core/let
    [v14351
     (:cache-cluster-id
      m14350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14351 :com.palletops.awaze.client-builder/undef)
     (. bean14349 setCacheClusterId (clojure.core/str v14351))))
   (clojure.core/let
    [v14351
     (:snapshot-name m14350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14351 :com.palletops.awaze.client-builder/undef)
     (. bean14349 setSnapshotName (clojure.core/str v14351))))
   (clojure.core/let
    [v14351
     (:snapshot-source
      m14350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14351 :com.palletops.awaze.client-builder/undef)
     (. bean14349 setSnapshotSource (clojure.core/str v14351))))
   bean14349))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m14353]
  (clojure.core/let
   [bean14352
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14354
     (:cache-subnet-group-name
      m14353
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14354 :com.palletops.awaze.client-builder/undef)
     (. bean14352 setCacheSubnetGroupName (clojure.core/str v14354))))
   bean14352))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m14356]
  (clojure.core/let
   [bean14355
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v14357
     (:cache-cluster-id
      m14356
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14357 :com.palletops.awaze.client-builder/undef)
     (. bean14355 setCacheClusterId (clojure.core/str v14357))))
   (clojure.core/let
    [v14357
     (:snapshot-name m14356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14357 :com.palletops.awaze.client-builder/undef)
     (. bean14355 setSnapshotName (clojure.core/str v14357))))
   bean14355))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m14359]
  (clojure.core/let
   [bean14358
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/let
    [v14360
     (:cache-node-count
      m14359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14360 :com.palletops.awaze.client-builder/undef)
     (. bean14358 setCacheNodeCount (clojure.core/int v14360))))
   (clojure.core/let
    [v14360
     (:reserved-cache-node-id
      m14359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14360 :com.palletops.awaze.client-builder/undef)
     (. bean14358 setReservedCacheNodeId (clojure.core/str v14360))))
   (clojure.core/let
    [v14360
     (:reserved-cache-nodes-offering-id
      m14359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14360 :com.palletops.awaze.client-builder/undef)
     (.
      bean14358
      setReservedCacheNodesOfferingId
      (clojure.core/str v14360))))
   bean14358))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m14362]
  (clojure.core/let
   [bean14361
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14363
     (:cache-security-group-name
      m14362
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14363 :com.palletops.awaze.client-builder/undef)
     (. bean14361 setCacheSecurityGroupName (clojure.core/str v14363))))
   bean14361))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m14365]
  (clojure.core/let
   [bean14364
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/let
    [v14366
     (:marker m14365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14366 :com.palletops.awaze.client-builder/undef)
     (. bean14364 setMarker (clojure.core/str v14366))))
   (clojure.core/let
    [v14366
     (:max-records m14365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14366 :com.palletops.awaze.client-builder/undef)
     (. bean14364 setMaxRecords (clojure.core/int v14366))))
   (clojure.core/let
    [v14366
     (:cache-subnet-group-name
      m14365
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14366 :com.palletops.awaze.client-builder/undef)
     (. bean14364 setCacheSubnetGroupName (clojure.core/str v14366))))
   bean14364))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m14384]
   (clojure.core/let
    [credentials14385 (:credentials m14384) args14386 (:args m14384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14387
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14385)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14387
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args14386 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cache-parameter-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials14389 & args14390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14391
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14389)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14391
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args14390 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m14392]
   (clojure.core/let
    [credentials14393 (:credentials m14392) args14394 (:args m14392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14395
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14393)]
     (clojure.core/case
      (clojure.core/count args14394)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14395
        describeReplicationGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14395
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args14394 0))))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-replication-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-replication-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials14397 & args14398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14399
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14397)]
    (clojure.core/case
     (clojure.core/count args14398)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14399
       describeReplicationGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14399
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args14398 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m14400]
   (clojure.core/let
    [credentials14401 (:credentials m14400) args14402 (:args m14400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14403
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14403
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args14402 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cache-cluster,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createCacheCluster"}
   [credentials14405 & args14406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14407
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14407
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args14406 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m14408]
   (clojure.core/let
    [credentials14409 (:credentials m14408) args14410 (:args m14408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14411
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14409)]
     (clojure.core/case
      (clojure.core/count args14410)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14411
        describeCacheParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14411
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args14410 0))))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials14413 & args14414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14415
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14413)]
    (clojure.core/case
     (clojure.core/count args14414)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14415
       describeCacheParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14415
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args14414 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m14416]
   (clojure.core/let
    [credentials14417 (:credentials m14416) args14418 (:args m14416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14419
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14417)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14419
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args14418 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cache-parameter-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials14421 & args14422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14423
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14421)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14423
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args14422 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m14424]
   (clojure.core/let
    [credentials14425 (:credentials m14424) args14426 (:args m14424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14427
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14425)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14427
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args14426 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cache-security-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials14429 & args14430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14431
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14429)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14431
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args14430 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :add-tags-to-resource
   [m14438]
   (clojure.core/let
    [credentials14439 (:credentials m14438) args14440 (:args m14438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14441
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14441
       addTagsToResource
       (elasticache/add-tags-to-resource-request
        (clojure.core/nth args14440 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials14443 & args14444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14445
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14445
      addTagsToResource
      (elasticache/add-tags-to-resource-request
       (clojure.core/nth args14444 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m14446]
   (clojure.core/let
    [credentials14447 (:credentials m14446) args14448 (:args m14446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14449
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14447)]
     (clojure.core/case
      (clojure.core/count args14448)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14449
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14449
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args14448 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials14451 & args14452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14453
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14451)]
    (clojure.core/case
     (clojure.core/count args14452)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14453
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14453
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args14452 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m14454]
   (clojure.core/let
    [credentials14455 (:credentials m14454) args14456 (:args m14454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14457
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14455)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14457
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args14456 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cache-subnet-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials14459 & args14460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14461
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14459)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14461
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args14460 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m14462]
   (clojure.core/let
    [credentials14463 (:credentials m14462) args14464 (:args m14462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14465
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14465
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args14464 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials14467 & args14468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14469
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14469
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args14468 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m14470]
   (clojure.core/let
    [credentials14471 (:credentials m14470) args14472 (:args m14470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14473
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14471)]
     (clojure.core/case
      (clojure.core/count args14472)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14473
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args14472 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14473
        describeReservedCacheNodes))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials14475 & args14476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14477
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14475)]
    (clojure.core/case
     (clojure.core/count args14476)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14477
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args14476 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14477
       describeReservedCacheNodes))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m14478]
   (clojure.core/let
    [credentials14479 (:credentials m14478) args14480 (:args m14478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14481
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14479)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14481
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args14480 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reboot-cache-cluster,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials14483 & args14484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14485
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14483)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14485
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args14484 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m14486]
   (clojure.core/let
    [credentials14487 (:credentials m14486) args14488 (:args m14486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14489
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14487)]
     (clojure.core/case
      (clojure.core/count args14488)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14489
        describeCacheClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14489
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args14488 0))))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cache-clusters,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache-clusters,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials14491 & args14492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14493
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14491)]
    (clojure.core/case
     (clojure.core/count args14492)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14493
       describeCacheClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14493
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args14492 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m14494]
   (clojure.core/let
    [credentials14495 (:credentials m14494) args14496 (:args m14494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14497
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14495)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14497
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args14496 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Call copySnapshot"}
   [credentials14499 & args14500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14501
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14499)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14501
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args14500 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m14502]
   (clojure.core/let
    [credentials14503 (:credentials m14502) args14504 (:args m14502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14505
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14505
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args14504 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials14507 & args14508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14509
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14509
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args14508 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m14510]
   (clojure.core/let
    [credentials14511 (:credentials m14510) args14512 (:args m14510)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14513
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14511)]
     (clojure.core/case
      (clojure.core/count args14512)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14513
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args14512 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14513
        describeCacheEngineVersions))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials14515 & args14516]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14517
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14515)]
    (clojure.core/case
     (clojure.core/count args14516)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14517
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args14516 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14517
       describeCacheEngineVersions))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m14518]
   (clojure.core/let
    [credentials14519 (:credentials m14518) args14520 (:args m14518)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14521
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14519)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14521
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args14520 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-engine-default-parameters,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials14523 & args14524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14525
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14523)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14525
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args14524 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m14526]
   (clojure.core/let
    [credentials14527 (:credentials m14526) args14528 (:args m14526)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14529
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14527)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14529
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args14528 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-replication-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials14531 & args14532]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14533
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14531)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14533
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args14532 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m14534]
   (clojure.core/let
    [credentials14535 (:credentials m14534) args14536 (:args m14534)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14537
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14535)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14537
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args14536 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cache-subnet-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials14539 & args14540]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14541
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14539)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14541
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args14540 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m14542]
   (clojure.core/let
    [credentials14543 (:credentials m14542) args14544 (:args m14542)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14545
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14543)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14545
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args14544 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-cache-cluster,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials14547 & args14548]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14549
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14547)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14549
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args14548 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m14550]
   (clojure.core/let
    [credentials14551 (:credentials m14550) args14552 (:args m14550)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14553
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14551)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14553
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args14552 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials14555 & args14556]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14557
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14555)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14557
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args14556 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m14558]
   (clojure.core/let
    [credentials14559 (:credentials m14558) args14560 (:args m14558)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14561
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14559)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14561
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args14560 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache-parameters,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameters"}
   [credentials14563 & args14564]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14565
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14563)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14565
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args14564 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m14566]
   (clojure.core/let
    [credentials14567 (:credentials m14566) args14568 (:args m14566)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14569
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14567)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14569
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args14568 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cache-cluster,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials14571 & args14572]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14573
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14571)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14573
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args14572 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-allowed-node-type-modifications
   [m14574]
   (clojure.core/let
    [credentials14575 (:credentials m14574) args14576 (:args m14574)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14577
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14575)]
     (clojure.core/case
      (clojure.core/count args14576)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14577
        listAllowedNodeTypeModifications
        (elasticache/list-allowed-node-type-modifications-request
         (clojure.core/nth args14576 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14577
        listAllowedNodeTypeModifications))))))
  (clojure.core/defn
   list-allowed-node-type-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-allowed-node-type-modifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   [credentials14579 & args14580]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14581
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14579)]
    (clojure.core/case
     (clojure.core/count args14580)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14581
       listAllowedNodeTypeModifications
       (elasticache/list-allowed-node-type-modifications-request
        (clojure.core/nth args14580 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14581
       listAllowedNodeTypeModifications))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m14582]
   (clojure.core/let
    [credentials14583 (:credentials m14582) args14584 (:args m14582)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14585
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14583)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14585
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args14584 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cache-parameter-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials14587 & args14588]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14589
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14587)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14589
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args14588 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m14590]
   (clojure.core/let
    [credentials14591 (:credentials m14590) args14592 (:args m14590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14593
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14591)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14593
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args14592 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-replication-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials14595 & args14596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14597
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14595)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14597
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args14596 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :remove-tags-from-resource
   [m14598]
   (clojure.core/let
    [credentials14599 (:credentials m14598) args14600 (:args m14598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14601
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14599)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14601
       removeTagsFromResource
       (elasticache/remove-tags-from-resource-request
        (clojure.core/nth args14600 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials14603 & args14604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14605
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14603)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14605
      removeTagsFromResource
      (elasticache/remove-tags-from-resource-request
       (clojure.core/nth args14604 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m14606]
   (clojure.core/let
    [credentials14607 (:credentials m14606) args14608 (:args m14606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14609
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14607)]
     (clojure.core/case
      (clojure.core/count args14608)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14609
        describeReservedCacheNodesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14609
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args14608 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials14611 & args14612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14613
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14611)]
    (clojure.core/case
     (clojure.core/count args14612)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14613
       describeReservedCacheNodesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14613
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args14612 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m14614]
   (clojure.core/let
    [credentials14615 (:credentials m14614) args14616 (:args m14614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14617
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14615)]
     (clojure.core/case
      (clojure.core/count args14616)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14617
        describeCacheSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14617
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args14616 0))))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cache-security-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache-security-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials14619 & args14620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14621
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14619)]
    (clojure.core/case
     (clojure.core/count args14620)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14621
       describeCacheSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14621
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args14620 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m14622]
   (clojure.core/let
    [credentials14623 (:credentials m14622) args14624 (:args m14622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14625
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14623)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14625
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args14624 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-replication-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createReplicationGroup"}
   [credentials14627 & args14628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14629
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14627)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14629
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args14628 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-tags-for-resource
   [m14630]
   (clojure.core/let
    [credentials14631 (:credentials m14630) args14632 (:args m14630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14633
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14631)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14633
       listTagsForResource
       (elasticache/list-tags-for-resource-request
        (clojure.core/nth args14632 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials14635 & args14636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14637
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14635)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14637
      listTagsForResource
      (elasticache/list-tags-for-resource-request
       (clojure.core/nth args14636 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m14638]
   (clojure.core/let
    [credentials14639 (:credentials m14638) args14640 (:args m14638)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14641
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14639)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14641
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args14640 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-cache-parameter-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials14643 & args14644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14645
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14643)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14645
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args14644 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m14646]
   (clojure.core/let
    [credentials14647 (:credentials m14646) args14648 (:args m14646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14649
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14647)]
     (clojure.core/case
      (clojure.core/count args14648)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14649
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args14648 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14649
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials14651 & args14652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14653
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14651)]
    (clojure.core/case
     (clojure.core/count args14652)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14653
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args14652 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14653
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m14654]
   (clojure.core/let
    [credentials14655 (:credentials m14654) args14656 (:args m14654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14657
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14655)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14657
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args14656 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cache-subnet-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials14659 & args14660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14661
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14659)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14661
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args14660 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m14662]
   (clojure.core/let
    [credentials14663 (:credentials m14662) args14664 (:args m14662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14665
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14663)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14665
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args14664 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials14667 & args14668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14669
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14669
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args14668 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m14670]
   (clojure.core/let
    [credentials14671 (:credentials m14670) args14672 (:args m14670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14673
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14671)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14673
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args14672 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials14675 & args14676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14677
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14675)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14677
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args14676 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m14678]
   (clojure.core/let
    [credentials14679 (:credentials m14678) args14680 (:args m14678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14681
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14679)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14681
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args14680 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cache-security-group,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials14683 & args14684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14685
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14683)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14685
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args14684 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m14686]
   (clojure.core/let
    [credentials14687 (:credentials m14686) args14688 (:args m14686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14689
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14687)]
     (clojure.core/case
      (clojure.core/count args14688)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14689
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args14688 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14689
        describeCacheSubnetGroups))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1784__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials14691 & args14692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14693
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14691)]
    (clojure.core/case
     (clojure.core/count args14692)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14693
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args14692 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14693
       describeCacheSubnetGroups)))))))
