(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m1889]
  (clojure.core/let
   [bean1888 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/let
    [v1890
     (:encrypted m1889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1890 :com.palletops.awaze.client-builder/undef)
     (. bean1888 setEncrypted (clojure.core/boolean v1890))))
   (clojure.core/let
    [v1890
     (:snapshot-id m1889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1890 :com.palletops.awaze.client-builder/undef)
     (. bean1888 setSnapshotId (clojure.core/str v1890))))
   (clojure.core/let
    [v1890
     (:volume-type m1889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1890 :com.palletops.awaze.client-builder/undef)
     (. bean1888 setVolumeType (clojure.core/str v1890))))
   (clojure.core/let
    [v1890 (:iops m1889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1890 :com.palletops.awaze.client-builder/undef)
     (. bean1888 setIops (clojure.core/int v1890))))
   (clojure.core/let
    [v1890
     (:delete-on-termination
      m1889
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1890 :com.palletops.awaze.client-builder/undef)
     (. bean1888 setDeleteOnTermination (clojure.core/boolean v1890))))
   (clojure.core/let
    [v1890
     (:volume-size m1889 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1890 :com.palletops.awaze.client-builder/undef)
     (. bean1888 setVolumeSize (clojure.core/int v1890))))
   bean1888))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m1892]
  (clojure.core/let
   [bean1891
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/let
    [v1893
     (:private-ip-address
      m1892
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1893 :com.palletops.awaze.client-builder/undef)
     (. bean1891 setPrivateIpAddress (clojure.core/str v1893))))
   (clojure.core/let
    [v1893 (:primary m1892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1893 :com.palletops.awaze.client-builder/undef)
     (. bean1891 setPrimary (clojure.core/boolean v1893))))
   bean1891))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tenancy}
tenancy
  [m1895]
  (.
   com.amazonaws.services.ec2.model.Tenancy
   fromValue
   (clojure.core/name m1895)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m1898]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m1898)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PermissionGroup}
permission-group
  [m1901]
  (.
   com.amazonaws.services.ec2.model.PermissionGroup
   fromValue
   (clojure.core/name m1901)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m1904]
  (clojure.core/let
   [bean1903
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/let
    [v1905 (:name m1904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1905 :com.palletops.awaze.client-builder/undef)
     (. bean1903 setName (clojure.core/str v1905))))
   (clojure.core/let
    [v1905 (:arn m1904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1905 :com.palletops.awaze.client-builder/undef)
     (. bean1903 setArn (clojure.core/str v1905))))
   bean1903))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m1907]
  (clojure.core/let
   [bean1906 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/let
    [v1908
     (:availability-zone
      m1907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1908 :com.palletops.awaze.client-builder/undef)
     (. bean1906 setAvailabilityZone (clojure.core/str v1908))))
   (clojure.core/let
    [v1908
     (:group-name m1907 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1908 :com.palletops.awaze.client-builder/undef)
     (. bean1906 setGroupName (clojure.core/str v1908))))
   bean1906))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetMonitoring}
spot-fleet-monitoring
  [m1910]
  (clojure.core/let
   [bean1909
    (new com.amazonaws.services.ec2.model.SpotFleetMonitoring)]
   (clojure.core/let
    [v1911 (:enabled m1910 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1911 :com.palletops.awaze.client-builder/undef)
     (. bean1909 setEnabled (clojure.core/boolean v1911))))
   bean1909))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m1913]
  (clojure.core/let
   [bean1912 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/let
    [v1914
     (:group-name m1913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1914 :com.palletops.awaze.client-builder/undef)
     (. bean1912 setGroupName (clojure.core/str v1914))))
   (clojure.core/let
    [v1914
     (:group-id m1913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1914 :com.palletops.awaze.client-builder/undef)
     (. bean1912 setGroupId (clojure.core/str v1914))))
   bean1912))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m1916]
  (clojure.core/let
   [bean1915
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/let
    [v1917
     (:device-name m1916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1917 :com.palletops.awaze.client-builder/undef)
     (. bean1915 setDeviceName (clojure.core/str v1917))))
   (clojure.core/let
    [v1917 (:ebs m1916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1917 :com.palletops.awaze.client-builder/undef)
     (. bean1915 setEbs (ec2/ebs-block-device v1917))))
   (clojure.core/let
    [v1917
     (:virtual-name m1916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1917 :com.palletops.awaze.client-builder/undef)
     (. bean1915 setVirtualName (clojure.core/str v1917))))
   (clojure.core/let
    [v1917
     (:no-device m1916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1917 :com.palletops.awaze.client-builder/undef)
     (. bean1915 setNoDevice (clojure.core/str v1917))))
   bean1915))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m1919]
  (clojure.core/let
   [bean1918
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/let
    [v1920
     (:description m1919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (. bean1918 setDescription (clojure.core/str v1920))))
   (clojure.core/let
    [v1920
     (:subnet-id m1919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (. bean1918 setSubnetId (clojure.core/str v1920))))
   (clojure.core/let
    [v1920
     (:secondary-private-ip-address-count
      m1919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (.
      bean1918
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v1920))))
   (clojure.core/let
    [v1920
     (:device-index m1919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (. bean1918 setDeviceIndex (clojure.core/int v1920))))
   (clojure.core/let
    [v1920
     (:private-ip-address
      m1919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (. bean1918 setPrivateIpAddress (clojure.core/str v1920))))
   (clojure.core/let
    [v1920 (:groups m1919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (.
      bean1918
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2728] (clojure.core/str arg2728))
 v1920))))
   (clojure.core/let
    [v1920
     (:network-interface-id
      m1919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (. bean1918 setNetworkInterfaceId (clojure.core/str v1920))))
   (clojure.core/let
    [v1920
     (:associate-public-ip-address
      m1919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (.
      bean1918
      setAssociatePublicIpAddress
      (clojure.core/boolean v1920))))
   (clojure.core/let
    [v1920
     (:private-ip-addresses
      m1919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (.
      bean1918
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2729]
  (ec2/private-ip-address-specification arg2729))
 v1920))))
   (clojure.core/let
    [v1920
     (:delete-on-termination
      m1919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1920 :com.palletops.awaze.client-builder/undef)
     (. bean1918 setDeleteOnTermination (clojure.core/boolean v1920))))
   bean1918))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesEbs}
scheduled-instances-ebs
  [m1922]
  (clojure.core/let
   [bean1921
    (new com.amazonaws.services.ec2.model.ScheduledInstancesEbs)]
   (clojure.core/let
    [v1923
     (:encrypted m1922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1923 :com.palletops.awaze.client-builder/undef)
     (. bean1921 setEncrypted (clojure.core/boolean v1923))))
   (clojure.core/let
    [v1923
     (:snapshot-id m1922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1923 :com.palletops.awaze.client-builder/undef)
     (. bean1921 setSnapshotId (clojure.core/str v1923))))
   (clojure.core/let
    [v1923
     (:volume-type m1922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1923 :com.palletops.awaze.client-builder/undef)
     (. bean1921 setVolumeType (clojure.core/str v1923))))
   (clojure.core/let
    [v1923 (:iops m1922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1923 :com.palletops.awaze.client-builder/undef)
     (. bean1921 setIops (clojure.core/int v1923))))
   (clojure.core/let
    [v1923
     (:delete-on-termination
      m1922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1923 :com.palletops.awaze.client-builder/undef)
     (. bean1921 setDeleteOnTermination (clojure.core/boolean v1923))))
   (clojure.core/let
    [v1923
     (:volume-size m1922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1923 :com.palletops.awaze.client-builder/undef)
     (. bean1921 setVolumeSize (clojure.core/int v1923))))
   bean1921))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig}
scheduled-instances-private-ip-address-config
  [m1925]
  (clojure.core/let
   [bean1924
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig)]
   (clojure.core/let
    [v1926
     (:private-ip-address
      m1925
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1926 :com.palletops.awaze.client-builder/undef)
     (. bean1924 setPrivateIpAddress (clojure.core/str v1926))))
   (clojure.core/let
    [v1926 (:primary m1925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1926 :com.palletops.awaze.client-builder/undef)
     (. bean1924 setPrimary (clojure.core/boolean v1926))))
   bean1924))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrefixListId}
prefix-list-id
  [m1928]
  (clojure.core/let
   [bean1927 (new com.amazonaws.services.ec2.model.PrefixListId)]
   (clojure.core/let
    [v1929
     (:prefix-list-id m1928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1929 :com.palletops.awaze.client-builder/undef)
     (. bean1927 setPrefixListId (clojure.core/str v1929))))
   bean1927))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m1931]
  (clojure.core/let
   [bean1930 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/let
    [v1932
     (:vpc-peering-connection-id
      m1931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1932 :com.palletops.awaze.client-builder/undef)
     (. bean1930 setVpcPeeringConnectionId (clojure.core/str v1932))))
   (clojure.core/let
    [v1932 (:vpc-id m1931 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1932 :com.palletops.awaze.client-builder/undef)
     (. bean1930 setVpcId (clojure.core/str v1932))))
   (clojure.core/let
    [v1932
     (:group-name m1931 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1932 :com.palletops.awaze.client-builder/undef)
     (. bean1930 setGroupName (clojure.core/str v1932))))
   (clojure.core/let
    [v1932
     (:group-id m1931 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1932 :com.palletops.awaze.client-builder/undef)
     (. bean1930 setGroupId (clojure.core/str v1932))))
   (clojure.core/let
    [v1932 (:user-id m1931 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1932 :com.palletops.awaze.client-builder/undef)
     (. bean1930 setUserId (clojure.core/str v1932))))
   (clojure.core/let
    [v1932
     (:peering-status m1931 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1932 :com.palletops.awaze.client-builder/undef)
     (. bean1930 setPeeringStatus (clojure.core/str v1932))))
   bean1930))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m1934]
  (clojure.core/let
   [bean1933
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/let
    [v1935
     (:volume-id m1934 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1935 :com.palletops.awaze.client-builder/undef)
     (. bean1933 setVolumeId (clojure.core/str v1935))))
   (clojure.core/let
    [v1935
     (:delete-on-termination
      m1934
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1935 :com.palletops.awaze.client-builder/undef)
     (. bean1933 setDeleteOnTermination (clojure.core/boolean v1935))))
   bean1933))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m1937]
  (clojure.core/let
   [bean1936 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/let
    [v1938
     (:availability-zone
      m1937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1938 :com.palletops.awaze.client-builder/undef)
     (. bean1936 setAvailabilityZone (clojure.core/str v1938))))
   (clojure.core/let
    [v1938
     (:group-name m1937 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1938 :com.palletops.awaze.client-builder/undef)
     (. bean1936 setGroupName (clojure.core/str v1938))))
   (clojure.core/let
    [v1938 (:tenancy m1937 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1938 :com.palletops.awaze.client-builder/undef)
     (. bean1936 setTenancy (ec2/tenancy v1938))))
   (clojure.core/let
    [v1938
     (:affinity m1937 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1938 :com.palletops.awaze.client-builder/undef)
     (. bean1936 setAffinity (clojure.core/str v1938))))
   (clojure.core/let
    [v1938 (:host-id m1937 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1938 :com.palletops.awaze.client-builder/undef)
     (. bean1936 setHostId (clojure.core/str v1938))))
   bean1936))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m1940]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m1940)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m1943]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m1943)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m1946]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m1946)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserData}
user-data
  [m1949]
  (clojure.core/let
   [bean1948 (new com.amazonaws.services.ec2.model.UserData)]
   (clojure.core/let
    [v1950 (:data m1949 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1950 :com.palletops.awaze.client-builder/undef)
     (. bean1948 setData (clojure.core/str v1950))))
   bean1948))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m1952]
  (clojure.core/let
   [bean1951 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/let
    [v1953 (:bytes m1952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1953 :com.palletops.awaze.client-builder/undef)
     (. bean1951 setBytes (clojure.core/long v1953))))
   (clojure.core/let
    [v1953
     (:import-manifest-url
      m1952
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1953 :com.palletops.awaze.client-builder/undef)
     (. bean1951 setImportManifestUrl (clojure.core/str v1953))))
   (clojure.core/let
    [v1953 (:format m1952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1953 :com.palletops.awaze.client-builder/undef)
     (. bean1951 setFormat (ec2/disk-image-format v1953))))
   bean1951))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m1955]
  (clojure.core/let
   [bean1954 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/let
    [v1956 (:size m1955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1956 :com.palletops.awaze.client-builder/undef)
     (. bean1954 setSize (clojure.core/long v1956))))
   bean1954))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m1958]
  (clojure.core/let
   [bean1957
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/let
    [v1959 (:group m1958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1959 :com.palletops.awaze.client-builder/undef)
     (. bean1957 setGroup (ec2/permission-group v1959))))
   (clojure.core/let
    [v1959 (:user-id m1958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1959 :com.palletops.awaze.client-builder/undef)
     (. bean1957 setUserId (clojure.core/str v1959))))
   bean1957))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification}
spot-fleet-launch-specification
  [m1961]
  (clojure.core/let
   [bean1960
    (new
     com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification)]
   (clojure.core/let
    [v1962
     (:spot-price m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setSpotPrice (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:iam-instance-profile
      m1961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (.
      bean1960
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v1962))))
   (clojure.core/let
    [v1962
     (:subnet-id m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setSubnetId (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:placement m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setPlacement (ec2/spot-placement v1962))))
   (clojure.core/let
    [v1962
     (:addressing-type
      m1961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setAddressingType (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:instance-type m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setInstanceType (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:ebs-optimized m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setEbsOptimized (clojure.core/boolean v1962))))
   (clojure.core/let
    [v1962
     (:ramdisk-id m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setRamdiskId (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:weighted-capacity
      m1961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setWeightedCapacity (clojure.core/double v1962))))
   (clojure.core/let
    [v1962
     (:image-id m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setImageId (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:key-name m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setKeyName (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:kernel-id m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setKernelId (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:monitoring m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setMonitoring (ec2/spot-fleet-monitoring v1962))))
   (clojure.core/let
    [v1962
     (:security-groups
      m1961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (.
      bean1960
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2730] (ec2/group-identifier arg2730))
 v1962))))
   (clojure.core/let
    [v1962
     (:block-device-mappings
      m1961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (.
      bean1960
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2731] (ec2/block-device-mapping arg2731))
 v1962))))
   (clojure.core/let
    [v1962
     (:user-data m1961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (. bean1960 setUserData (clojure.core/str v1962))))
   (clojure.core/let
    [v1962
     (:network-interfaces
      m1961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1962 :com.palletops.awaze.client-builder/undef)
     (.
      bean1960
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2732]
  (ec2/instance-network-interface-specification arg2732))
 v1962))))
   bean1960))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocationStrategy}
allocation-strategy
  [m1964]
  (.
   com.amazonaws.services.ec2.model.AllocationStrategy
   fromValue
   (clojure.core/name m1964)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CurrencyCodeValues}
currency-code-values
  [m1967]
  (.
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   fromValue
   (clojure.core/name m1967)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserBucket}
user-bucket
  [m1970]
  (clojure.core/let
   [bean1969 (new com.amazonaws.services.ec2.model.UserBucket)]
   (clojure.core/let
    [v1971 (:s3key m1970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1971 :com.palletops.awaze.client-builder/undef)
     (. bean1969 setS3Key (clojure.core/str v1971))))
   (clojure.core/let
    [v1971
     (:s3bucket m1970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1971 :com.palletops.awaze.client-builder/undef)
     (. bean1969 setS3Bucket (clojure.core/str v1971))))
   bean1969))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m1973]
  (clojure.core/let
   [bean1972 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/let
    [v1974 (:bucket m1973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1974 :com.palletops.awaze.client-builder/undef)
     (. bean1972 setBucket (clojure.core/str v1974))))
   (clojure.core/let
    [v1974 (:prefix m1973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1974 :com.palletops.awaze.client-builder/undef)
     (. bean1972 setPrefix (clojure.core/str v1974))))
   (clojure.core/let
    [v1974
     (:awsaccess-key-id
      m1973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1974 :com.palletops.awaze.client-builder/undef)
     (. bean1972 setAWSAccessKeyId (clojure.core/str v1974))))
   (clojure.core/let
    [v1974
     (:upload-policy m1973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1974 :com.palletops.awaze.client-builder/undef)
     (. bean1972 setUploadPolicy (clojure.core/str v1974))))
   (clojure.core/let
    [v1974
     (:upload-policy-signature
      m1973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1974 :com.palletops.awaze.client-builder/undef)
     (. bean1972 setUploadPolicySignature (clojure.core/str v1974))))
   bean1972))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m1976]
  (clojure.core/let
   [bean1975 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/let
    [v1977 (:group m1976 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1977 :com.palletops.awaze.client-builder/undef)
     (. bean1975 setGroup (ec2/permission-group v1977))))
   (clojure.core/let
    [v1977 (:user-id m1976 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1977 :com.palletops.awaze.client-builder/undef)
     (. bean1975 setUserId (clojure.core/str v1977))))
   bean1975))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile}
scheduled-instances-iam-instance-profile
  [m1979]
  (clojure.core/let
   [bean1978
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile)]
   (clojure.core/let
    [v1980 (:name m1979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1980 :com.palletops.awaze.client-builder/undef)
     (. bean1978 setName (clojure.core/str v1980))))
   (clojure.core/let
    [v1980 (:arn m1979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1980 :com.palletops.awaze.client-builder/undef)
     (. bean1978 setArn (clojure.core/str v1980))))
   bean1978))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPlacement}
scheduled-instances-placement
  [m1982]
  (clojure.core/let
   [bean1981
    (new com.amazonaws.services.ec2.model.ScheduledInstancesPlacement)]
   (clojure.core/let
    [v1983
     (:availability-zone
      m1982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1983 :com.palletops.awaze.client-builder/undef)
     (. bean1981 setAvailabilityZone (clojure.core/str v1983))))
   (clojure.core/let
    [v1983
     (:group-name m1982 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1983 :com.palletops.awaze.client-builder/undef)
     (. bean1981 setGroupName (clojure.core/str v1983))))
   bean1981))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring}
scheduled-instances-monitoring
  [m1985]
  (clojure.core/let
   [bean1984
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring)]
   (clojure.core/let
    [v1986 (:enabled m1985 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1986 :com.palletops.awaze.client-builder/undef)
     (. bean1984 setEnabled (clojure.core/boolean v1986))))
   bean1984))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping}
scheduled-instances-block-device-mapping
  [m1988]
  (clojure.core/let
   [bean1987
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping)]
   (clojure.core/let
    [v1989
     (:device-name m1988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1989 :com.palletops.awaze.client-builder/undef)
     (. bean1987 setDeviceName (clojure.core/str v1989))))
   (clojure.core/let
    [v1989 (:ebs m1988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1989 :com.palletops.awaze.client-builder/undef)
     (. bean1987 setEbs (ec2/scheduled-instances-ebs v1989))))
   (clojure.core/let
    [v1989
     (:virtual-name m1988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1989 :com.palletops.awaze.client-builder/undef)
     (. bean1987 setVirtualName (clojure.core/str v1989))))
   (clojure.core/let
    [v1989
     (:no-device m1988 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1989 :com.palletops.awaze.client-builder/undef)
     (. bean1987 setNoDevice (clojure.core/str v1989))))
   bean1987))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface}
scheduled-instances-network-interface
  [m1991]
  (clojure.core/let
   [bean1990
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface)]
   (clojure.core/let
    [v1992
     (:description m1991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (. bean1990 setDescription (clojure.core/str v1992))))
   (clojure.core/let
    [v1992
     (:subnet-id m1991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (. bean1990 setSubnetId (clojure.core/str v1992))))
   (clojure.core/let
    [v1992
     (:secondary-private-ip-address-count
      m1991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (.
      bean1990
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v1992))))
   (clojure.core/let
    [v1992
     (:device-index m1991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (. bean1990 setDeviceIndex (clojure.core/int v1992))))
   (clojure.core/let
    [v1992
     (:private-ip-address
      m1991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (. bean1990 setPrivateIpAddress (clojure.core/str v1992))))
   (clojure.core/let
    [v1992
     (:private-ip-address-configs
      m1991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (.
      bean1990
      setPrivateIpAddressConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2733]
  (ec2/scheduled-instances-private-ip-address-config arg2733))
 v1992))))
   (clojure.core/let
    [v1992 (:groups m1991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (.
      bean1990
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2734] (clojure.core/str arg2734))
 v1992))))
   (clojure.core/let
    [v1992
     (:network-interface-id
      m1991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (. bean1990 setNetworkInterfaceId (clojure.core/str v1992))))
   (clojure.core/let
    [v1992
     (:associate-public-ip-address
      m1991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (.
      bean1990
      setAssociatePublicIpAddress
      (clojure.core/boolean v1992))))
   (clojure.core/let
    [v1992
     (:delete-on-termination
      m1991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1992 :com.palletops.awaze.client-builder/undef)
     (. bean1990 setDeleteOnTermination (clojure.core/boolean v1992))))
   bean1990))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PlacementStrategy}
placement-strategy
  [m1994]
  (.
   com.amazonaws.services.ec2.model.PlacementStrategy
   fromValue
   (clojure.core/name m1994)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m1997]
  (clojure.core/let
   [bean1996
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/let
    [v1998 (:price m1997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1998 :com.palletops.awaze.client-builder/undef)
     (. bean1996 setPrice (clojure.core/double v1998))))
   (clojure.core/let
    [v1998 (:term m1997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1998 :com.palletops.awaze.client-builder/undef)
     (. bean1996 setTerm (clojure.core/long v1998))))
   (clojure.core/let
    [v1998
     (:currency-code m1997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1998 :com.palletops.awaze.client-builder/undef)
     (. bean1996 setCurrencyCode (clojure.core/str v1998))))
   bean1996))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m2000]
  (clojure.core/let
   [bean1999 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/let
    [v2001
     (:ip-protocol m2000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2001 :com.palletops.awaze.client-builder/undef)
     (. bean1999 setIpProtocol (clojure.core/str v2001))))
   (clojure.core/let
    [v2001
     (:from-port m2000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2001 :com.palletops.awaze.client-builder/undef)
     (. bean1999 setFromPort (clojure.core/int v2001))))
   (clojure.core/let
    [v2001 (:to-port m2000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2001 :com.palletops.awaze.client-builder/undef)
     (. bean1999 setToPort (clojure.core/int v2001))))
   (clojure.core/let
    [v2001
     (:prefix-list-ids
      m2000
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2001 :com.palletops.awaze.client-builder/undef)
     (.
      bean1999
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2735] (ec2/prefix-list-id arg2735))
 v2001))))
   (clojure.core/let
    [v2001
     (:user-id-group-pairs
      m2000
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2001 :com.palletops.awaze.client-builder/undef)
     (.
      bean1999
      setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2736] (ec2/user-id-group-pair arg2736))
 v2001))))
   (clojure.core/let
    [v2001
     (:ip-ranges m2000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2001 :com.palletops.awaze.client-builder/undef)
     (.
      bean1999
      setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2737] (clojure.core/str arg2737))
 v2001))))
   bean1999))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m2003]
  (clojure.core/let
   [bean2002
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/let
    [v2004
     (:device-name m2003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2004 :com.palletops.awaze.client-builder/undef)
     (. bean2002 setDeviceName (clojure.core/str v2004))))
   (clojure.core/let
    [v2004 (:ebs m2003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2004 :com.palletops.awaze.client-builder/undef)
     (.
      bean2002
      setEbs
      (ec2/ebs-instance-block-device-specification v2004))))
   (clojure.core/let
    [v2004
     (:virtual-name m2003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2004 :com.palletops.awaze.client-builder/undef)
     (. bean2002 setVirtualName (clojure.core/str v2004))))
   (clojure.core/let
    [v2004
     (:no-device m2003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2004 :com.palletops.awaze.client-builder/undef)
     (. bean2002 setNoDevice (clojure.core/str v2004))))
   bean2002))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m2006]
  (clojure.core/let
   [bean2005 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/let
    [v2007 (:name m2006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2007 :com.palletops.awaze.client-builder/undef)
     (. bean2005 setName (clojure.core/str v2007))))
   (clojure.core/let
    [v2007 (:values m2006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2007 :com.palletops.awaze.client-builder/undef)
     (.
      bean2005
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2738] (clojure.core/str arg2738))
 v2007))))
   bean2005))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AutoPlacement}
auto-placement
  [m2009]
  (.
   com.amazonaws.services.ec2.model.AutoPlacement
   fromValue
   (clojure.core/name m2009)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceAttributeName}
instance-attribute-name
  [m2012]
  (.
   com.amazonaws.services.ec2.model.InstanceAttributeName
   fromValue
   (clojure.core/name m2012)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest}
slot-start-time-range-request
  [m2015]
  (clojure.core/let
   [bean2014
    (new com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest)]
   (clojure.core/let
    [v2016
     (:earliest-time m2015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2016 :com.palletops.awaze.client-builder/undef)
     (.
      bean2014
      setEarliestTime
      (com.palletops.awaze.common/to-date v2016))))
   (clojure.core/let
    [v2016
     (:latest-time m2015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2016 :com.palletops.awaze.client-builder/undef)
     (.
      bean2014
      setLatestTime
      (com.palletops.awaze.common/to-date v2016))))
   bean2014))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RuleAction}
rule-action
  [m2018]
  (.
   com.amazonaws.services.ec2.model.RuleAction
   fromValue
   (clojure.core/name m2018)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m2021]
  (clojure.core/let
   [bean2020 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/let
    [v2022 (:type m2021 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2022 :com.palletops.awaze.client-builder/undef)
     (. bean2020 setType (clojure.core/int v2022))))
   (clojure.core/let
    [v2022 (:code m2021 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2022 :com.palletops.awaze.client-builder/undef)
     (. bean2020 setCode (clojure.core/int v2022))))
   bean2020))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m2024]
  (clojure.core/let
   [bean2023 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/let
    [v2025 (:from m2024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2025 :com.palletops.awaze.client-builder/undef)
     (. bean2023 setFrom (clojure.core/int v2025))))
   (clojure.core/let
    [v2025 (:to m2024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2025 :com.palletops.awaze.client-builder/undef)
     (. bean2023 setTo (clojure.core/int v2025))))
   bean2023))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotAttributeName}
snapshot-attribute-name
  [m2027]
  (.
   com.amazonaws.services.ec2.model.SnapshotAttributeName
   fromValue
   (clojure.core/name m2027)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeName}
reset-image-attribute-name
  [m2030]
  (.
   com.amazonaws.services.ec2.model.ResetImageAttributeName
   fromValue
   (clojure.core/name m2030)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PlatformValues}
platform-values
  [m2033]
  (.
   com.amazonaws.services.ec2.model.PlatformValues
   fromValue
   (clojure.core/name m2033)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m2036]
  (clojure.core/let
   [bean2035
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/let
    [v2037
     (:group-ids m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (.
      bean2035
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2739] (clojure.core/str arg2739))
 v2037))))
   (clojure.core/let
    [v2037
     (:subnet-id m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setSubnetId (clojure.core/str v2037))))
   (clojure.core/let
    [v2037
     (:additional-info
      m2036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setAdditionalInfo (clojure.core/str v2037))))
   (clojure.core/let
    [v2037
     (:placement m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setPlacement (ec2/placement v2037))))
   (clojure.core/let
    [v2037
     (:group-names m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (.
      bean2035
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2740] (clojure.core/str arg2740))
 v2037))))
   (clojure.core/let
    [v2037
     (:private-ip-address
      m2036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setPrivateIpAddress (clojure.core/str v2037))))
   (clojure.core/let
    [v2037
     (:instance-type m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setInstanceType (ec2/instance-type v2037))))
   (clojure.core/let
    [v2037
     (:instance-initiated-shutdown-behavior
      m2036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (.
      bean2035
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2037))))
   (clojure.core/let
    [v2037
     (:monitoring m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setMonitoring (clojure.core/boolean v2037))))
   (clojure.core/let
    [v2037
     (:architecture m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setArchitecture (ec2/architecture-values v2037))))
   (clojure.core/let
    [v2037
     (:user-data m2036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2037 :com.palletops.awaze.client-builder/undef)
     (. bean2035 setUserData (ec2/user-data v2037))))
   bean2035))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m2039]
  (clojure.core/let
   [bean2038 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/let
    [v2040
     (:description m2039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2040 :com.palletops.awaze.client-builder/undef)
     (. bean2038 setDescription (clojure.core/str v2040))))
   (clojure.core/let
    [v2040 (:image m2039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2040 :com.palletops.awaze.client-builder/undef)
     (. bean2038 setImage (ec2/disk-image-detail v2040))))
   (clojure.core/let
    [v2040 (:volume m2039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2040 :com.palletops.awaze.client-builder/undef)
     (. bean2038 setVolume (ec2/volume-detail v2040))))
   bean2038))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m2042]
  (clojure.core/let
   [bean2041
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/let
    [v2043 (:add m2042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2043 :com.palletops.awaze.client-builder/undef)
     (.
      bean2041
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2741] (ec2/create-volume-permission arg2741))
 v2043))))
   (clojure.core/let
    [v2043 (:remove m2042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2043 :com.palletops.awaze.client-builder/undef)
     (.
      bean2041
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2742] (ec2/create-volume-permission arg2742))
 v2043))))
   bean2041))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetRequestConfigData}
spot-fleet-request-config-data
  [m2045]
  (clojure.core/let
   [bean2044
    (new com.amazonaws.services.ec2.model.SpotFleetRequestConfigData)]
   (clojure.core/let
    [v2046
     (:iam-fleet-role m2045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (. bean2044 setIamFleetRole (clojure.core/str v2046))))
   (clojure.core/let
    [v2046
     (:spot-price m2045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (. bean2044 setSpotPrice (clojure.core/str v2046))))
   (clojure.core/let
    [v2046
     (:launch-specifications
      m2045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (.
      bean2044
      setLaunchSpecifications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2743]
  (ec2/spot-fleet-launch-specification arg2743))
 v2046))))
   (clojure.core/let
    [v2046
     (:valid-from m2045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (.
      bean2044
      setValidFrom
      (com.palletops.awaze.common/to-date v2046))))
   (clojure.core/let
    [v2046
     (:client-token m2045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (. bean2044 setClientToken (clojure.core/str v2046))))
   (clojure.core/let
    [v2046
     (:allocation-strategy
      m2045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (.
      bean2044
      setAllocationStrategy
      (ec2/allocation-strategy v2046))))
   (clojure.core/let
    [v2046
     (:terminate-instances-with-expiration
      m2045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (.
      bean2044
      setTerminateInstancesWithExpiration
      (clojure.core/boolean v2046))))
   (clojure.core/let
    [v2046
     (:target-capacity
      m2045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (. bean2044 setTargetCapacity (clojure.core/int v2046))))
   (clojure.core/let
    [v2046
     (:valid-until m2045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (.
      bean2044
      setValidUntil
      (com.palletops.awaze.common/to-date v2046))))
   (clojure.core/let
    [v2046
     (:excess-capacity-termination-policy
      m2045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2046 :com.palletops.awaze.client-builder/undef)
     (.
      bean2044
      setExcessCapacityTerminationPolicy
      (clojure.core/str v2046))))
   bean2044))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m2048]
  (clojure.core/let
   [bean2047
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/let
    [v2049
     (:disk-image-format
      m2048
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2049 :com.palletops.awaze.client-builder/undef)
     (. bean2047 setDiskImageFormat (ec2/disk-image-format v2049))))
   (clojure.core/let
    [v2049
     (:container-format
      m2048
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2049 :com.palletops.awaze.client-builder/undef)
     (. bean2047 setContainerFormat (clojure.core/str v2049))))
   (clojure.core/let
    [v2049
     (:s3bucket m2048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2049 :com.palletops.awaze.client-builder/undef)
     (. bean2047 setS3Bucket (clojure.core/str v2049))))
   (clojure.core/let
    [v2049
     (:s3prefix m2048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2049 :com.palletops.awaze.client-builder/undef)
     (. bean2047 setS3Prefix (clojure.core/str v2049))))
   bean2047))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageAttributeName}
image-attribute-name
  [m2051]
  (.
   com.amazonaws.services.ec2.model.ImageAttributeName
   fromValue
   (clojure.core/name m2051)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseRequest}
purchase-request
  [m2054]
  (clojure.core/let
   [bean2053 (new com.amazonaws.services.ec2.model.PurchaseRequest)]
   (clojure.core/let
    [v2055
     (:instance-count m2054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2055 :com.palletops.awaze.client-builder/undef)
     (. bean2053 setInstanceCount (clojure.core/int v2055))))
   (clojure.core/let
    [v2055
     (:purchase-token m2054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2055 :com.palletops.awaze.client-builder/undef)
     (. bean2053 setPurchaseToken (clojure.core/str v2055))))
   bean2053))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m2057]
  (clojure.core/let
   [bean2056
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/let
    [v2058 (:amount m2057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2058 :com.palletops.awaze.client-builder/undef)
     (. bean2056 setAmount (clojure.core/double v2058))))
   (clojure.core/let
    [v2058
     (:currency-code m2057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2058 :com.palletops.awaze.client-builder/undef)
     (. bean2056 setCurrencyCode (ec2/currency-code-values v2058))))
   bean2056))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m2060]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m2060)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m2063]
  (clojure.core/let
   [bean2062 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/let
    [v2064 (:values m2063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2064 :com.palletops.awaze.client-builder/undef)
     (.
      bean2062
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2744] (clojure.core/str arg2744))
 v2064))))
   (clojure.core/let
    [v2064 (:key m2063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2064 :com.palletops.awaze.client-builder/undef)
     (. bean2062 setKey (clojure.core/str v2064))))
   bean2062))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotInstanceType}
spot-instance-type
  [m2066]
  (.
   com.amazonaws.services.ec2.model.SpotInstanceType
   fromValue
   (clojure.core/name m2066)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m2069]
  (clojure.core/let
   [bean2068
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/let
    [v2070
     (:iam-instance-profile
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (.
      bean2068
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2070))))
   (clojure.core/let
    [v2070
     (:subnet-id m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setSubnetId (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:placement m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setPlacement (ec2/spot-placement v2070))))
   (clojure.core/let
    [v2070
     (:addressing-type
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setAddressingType (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:instance-type m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setInstanceType (ec2/instance-type v2070))))
   (clojure.core/let
    [v2070
     (:ebs-optimized m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setEbsOptimized (clojure.core/boolean v2070))))
   (clojure.core/let
    [v2070
     (:ramdisk-id m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setRamdiskId (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:all-security-groups
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (.
      bean2068
      setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2745] (ec2/group-identifier arg2745))
 v2070))))
   (clojure.core/let
    [v2070
     (:image-id m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setImageId (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:key-name m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setKeyName (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:monitoring-enabled
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setMonitoringEnabled (clojure.core/boolean v2070))))
   (clojure.core/let
    [v2070
     (:kernel-id m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setKernelId (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:security-groups
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (.
      bean2068
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2746] (clojure.core/str arg2746))
 v2070))))
   (clojure.core/let
    [v2070
     (:block-device-mappings
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (.
      bean2068
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2747] (ec2/block-device-mapping arg2747))
 v2070))))
   (clojure.core/let
    [v2070
     (:user-data m2069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (. bean2068 setUserData (clojure.core/str v2070))))
   (clojure.core/let
    [v2070
     (:network-interfaces
      m2069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2070 :com.palletops.awaze.client-builder/undef)
     (.
      bean2068
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2748]
  (ec2/instance-network-interface-specification arg2748))
 v2070))))
   bean2068))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ClientData}
client-data
  [m2072]
  (clojure.core/let
   [bean2071 (new com.amazonaws.services.ec2.model.ClientData)]
   (clojure.core/let
    [v2073
     (:upload-start m2072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2073 :com.palletops.awaze.client-builder/undef)
     (.
      bean2071
      setUploadStart
      (com.palletops.awaze.common/to-date v2073))))
   (clojure.core/let
    [v2073
     (:upload-end m2072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2073 :com.palletops.awaze.client-builder/undef)
     (.
      bean2071
      setUploadEnd
      (com.palletops.awaze.common/to-date v2073))))
   (clojure.core/let
    [v2073
     (:upload-size m2072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2073 :com.palletops.awaze.client-builder/undef)
     (. bean2071 setUploadSize (clojure.core/double v2073))))
   (clojure.core/let
    [v2073 (:comment m2072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2073 :com.palletops.awaze.client-builder/undef)
     (. bean2071 setComment (clojure.core/str v2073))))
   bean2071))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotDiskContainer}
snapshot-disk-container
  [m2075]
  (clojure.core/let
   [bean2074
    (new com.amazonaws.services.ec2.model.SnapshotDiskContainer)]
   (clojure.core/let
    [v2076
     (:description m2075 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2076 :com.palletops.awaze.client-builder/undef)
     (. bean2074 setDescription (clojure.core/str v2076))))
   (clojure.core/let
    [v2076 (:url m2075 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2076 :com.palletops.awaze.client-builder/undef)
     (. bean2074 setUrl (clojure.core/str v2076))))
   (clojure.core/let
    [v2076
     (:user-bucket m2075 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2076 :com.palletops.awaze.client-builder/undef)
     (. bean2074 setUserBucket (ec2/user-bucket v2076))))
   (clojure.core/let
    [v2076 (:format m2075 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2076 :com.palletops.awaze.client-builder/undef)
     (. bean2074 setFormat (clojure.core/str v2076))))
   bean2074))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m2078]
  (clojure.core/let
   [bean2077 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/let
    [v2079 (:value m2078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2079 :com.palletops.awaze.client-builder/undef)
     (. bean2077 setValue (clojure.core/str v2079))))
   (clojure.core/let
    [v2079 (:key m2078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2079 :com.palletops.awaze.client-builder/undef)
     (. bean2077 setKey (clojure.core/str v2079))))
   bean2077))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RIProductDescription}
riproduct-description
  [m2081]
  (.
   com.amazonaws.services.ec2.model.RIProductDescription
   fromValue
   (clojure.core/name m2081)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.FlowLogsResourceType}
flow-logs-resource-type
  [m2084]
  (.
   com.amazonaws.services.ec2.model.FlowLogsResourceType
   fromValue
   (clojure.core/name m2084)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TrafficType}
traffic-type
  [m2087]
  (.
   com.amazonaws.services.ec2.model.TrafficType
   fromValue
   (clojure.core/name m2087)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m2090]
  (clojure.core/let
   [bean2089 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/let
    [v2091 (:s3 m2090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2091 :com.palletops.awaze.client-builder/undef)
     (. bean2089 setS3 (ec2/s3storage v2091))))
   bean2089))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.HostTenancy}
host-tenancy
  [m2093]
  (.
   com.amazonaws.services.ec2.model.HostTenancy
   fromValue
   (clojure.core/name m2093)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OperationType}
operation-type
  [m2096]
  (.
   com.amazonaws.services.ec2.model.OperationType
   fromValue
   (clojure.core/name m2096)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m2099]
  (clojure.core/let
   [bean2098
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/let
    [v2100 (:add m2099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2100 :com.palletops.awaze.client-builder/undef)
     (.
      bean2098
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2749] (ec2/launch-permission arg2749))
 v2100))))
   (clojure.core/let
    [v2100 (:remove m2099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2100 :com.palletops.awaze.client-builder/undef)
     (.
      bean2098
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2750] (ec2/launch-permission arg2750))
 v2100))))
   bean2098))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m2102]
  (clojure.core/let
   [bean2101
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/let
    [v2103
     (:static-routes-only
      m2102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2103 :com.palletops.awaze.client-builder/undef)
     (. bean2101 setStaticRoutesOnly (clojure.core/boolean v2103))))
   bean2101))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest}
scheduled-instance-recurrence-request
  [m2105]
  (clojure.core/let
   [bean2104
    (new
     com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest)]
   (clojure.core/let
    [v2106
     (:frequency m2105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2106 :com.palletops.awaze.client-builder/undef)
     (. bean2104 setFrequency (clojure.core/str v2106))))
   (clojure.core/let
    [v2106
     (:interval m2105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2106 :com.palletops.awaze.client-builder/undef)
     (. bean2104 setInterval (clojure.core/int v2106))))
   (clojure.core/let
    [v2106
     (:occurrence-days
      m2105
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2106 :com.palletops.awaze.client-builder/undef)
     (.
      bean2104
      setOccurrenceDays
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2751] (clojure.core/int arg2751))
 v2106))))
   (clojure.core/let
    [v2106
     (:occurrence-relative-to-end
      m2105
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2106 :com.palletops.awaze.client-builder/undef)
     (.
      bean2104
      setOccurrenceRelativeToEnd
      (clojure.core/boolean v2106))))
   (clojure.core/let
    [v2106
     (:occurrence-unit
      m2105
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2106 :com.palletops.awaze.client-builder/undef)
     (. bean2104 setOccurrenceUnit (clojure.core/str v2106))))
   bean2104))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest}
slot-date-time-range-request
  [m2108]
  (clojure.core/let
   [bean2107
    (new com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest)]
   (clojure.core/let
    [v2109
     (:earliest-time m2108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2109 :com.palletops.awaze.client-builder/undef)
     (.
      bean2107
      setEarliestTime
      (com.palletops.awaze.common/to-date v2109))))
   (clojure.core/let
    [v2109
     (:latest-time m2108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2109 :com.palletops.awaze.client-builder/undef)
     (.
      bean2107
      setLatestTime
      (com.palletops.awaze.common/to-date v2109))))
   bean2107))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m2111]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m2111)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageDiskContainer}
image-disk-container
  [m2114]
  (clojure.core/let
   [bean2113
    (new com.amazonaws.services.ec2.model.ImageDiskContainer)]
   (clojure.core/let
    [v2115
     (:description m2114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2115 :com.palletops.awaze.client-builder/undef)
     (. bean2113 setDescription (clojure.core/str v2115))))
   (clojure.core/let
    [v2115
     (:snapshot-id m2114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2115 :com.palletops.awaze.client-builder/undef)
     (. bean2113 setSnapshotId (clojure.core/str v2115))))
   (clojure.core/let
    [v2115 (:url m2114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2115 :com.palletops.awaze.client-builder/undef)
     (. bean2113 setUrl (clojure.core/str v2115))))
   (clojure.core/let
    [v2115
     (:user-bucket m2114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2115 :com.palletops.awaze.client-builder/undef)
     (. bean2113 setUserBucket (ec2/user-bucket v2115))))
   (clojure.core/let
    [v2115 (:format m2114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2115 :com.palletops.awaze.client-builder/undef)
     (. bean2113 setFormat (clojure.core/str v2115))))
   (clojure.core/let
    [v2115
     (:device-name m2114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2115 :com.palletops.awaze.client-builder/undef)
     (. bean2113 setDeviceName (clojure.core/str v2115))))
   bean2113))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification}
scheduled-instances-launch-specification
  [m2117]
  (clojure.core/let
   [bean2116
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification)]
   (clojure.core/let
    [v2118
     (:iam-instance-profile
      m2117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (.
      bean2116
      setIamInstanceProfile
      (ec2/scheduled-instances-iam-instance-profile v2118))))
   (clojure.core/let
    [v2118
     (:subnet-id m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setSubnetId (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:security-group-ids
      m2117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (.
      bean2116
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2752] (clojure.core/str arg2752))
 v2118))))
   (clojure.core/let
    [v2118
     (:placement m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (.
      bean2116
      setPlacement
      (ec2/scheduled-instances-placement v2118))))
   (clojure.core/let
    [v2118
     (:instance-type m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setInstanceType (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:ebs-optimized m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setEbsOptimized (clojure.core/boolean v2118))))
   (clojure.core/let
    [v2118
     (:ramdisk-id m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setRamdiskId (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:image-id m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setImageId (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:key-name m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setKeyName (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:kernel-id m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setKernelId (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:monitoring m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (.
      bean2116
      setMonitoring
      (ec2/scheduled-instances-monitoring v2118))))
   (clojure.core/let
    [v2118
     (:block-device-mappings
      m2117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (.
      bean2116
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2753]
  (ec2/scheduled-instances-block-device-mapping arg2753))
 v2118))))
   (clojure.core/let
    [v2118
     (:user-data m2117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (. bean2116 setUserData (clojure.core/str v2118))))
   (clojure.core/let
    [v2118
     (:network-interfaces
      m2117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2118 :com.palletops.awaze.client-builder/undef)
     (.
      bean2116
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2754]
  (ec2/scheduled-instances-network-interface arg2754))
 v2118))))
   bean2116))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m2120]
  (clojure.core/let
   [bean2119
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/let
    [v2121
     (:instance-type m2120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2121 :com.palletops.awaze.client-builder/undef)
     (. bean2119 setInstanceType (clojure.core/str v2121))))
   (clojure.core/let
    [v2121
     (:availability-zone
      m2120
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2121 :com.palletops.awaze.client-builder/undef)
     (. bean2119 setAvailabilityZone (clojure.core/str v2121))))
   (clojure.core/let
    [v2121
     (:instance-count m2120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2121 :com.palletops.awaze.client-builder/undef)
     (. bean2119 setInstanceCount (clojure.core/int v2121))))
   (clojure.core/let
    [v2121
     (:platform m2120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2121 :com.palletops.awaze.client-builder/undef)
     (. bean2119 setPlatform (clojure.core/str v2121))))
   bean2119))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m2123]
  (clojure.core/let
   [bean2122
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/let
    [v2124
     (:attachment-id m2123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2124 :com.palletops.awaze.client-builder/undef)
     (. bean2122 setAttachmentId (clojure.core/str v2124))))
   (clojure.core/let
    [v2124
     (:delete-on-termination
      m2123
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2124 :com.palletops.awaze.client-builder/undef)
     (. bean2122 setDeleteOnTermination (clojure.core/boolean v2124))))
   bean2122))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy}
excess-capacity-termination-policy
  [m2126]
  (.
   com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy
   fromValue
   (clojure.core/name m2126)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest}
delete-vpc-endpoints-request
  [m2129]
  (clojure.core/let
   [bean2128
    (new com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest)]
   (clojure.core/let
    [v2130
     (:vpc-endpoint-ids
      m2129
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2130 :com.palletops.awaze.client-builder/undef)
     (.
      bean2128
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2755] (clojure.core/str arg2755))
 v2130))))
   bean2128))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNatGatewayRequest}
create-nat-gateway-request
  [m2132]
  (clojure.core/let
   [bean2131
    (new com.amazonaws.services.ec2.model.CreateNatGatewayRequest)]
   (clojure.core/let
    [v2133
     (:client-token m2132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2133 :com.palletops.awaze.client-builder/undef)
     (. bean2131 setClientToken (clojure.core/str v2133))))
   (clojure.core/let
    [v2133
     (:allocation-id m2132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2133 :com.palletops.awaze.client-builder/undef)
     (. bean2131 setAllocationId (clojure.core/str v2133))))
   (clojure.core/let
    [v2133
     (:subnet-id m2132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2133 :com.palletops.awaze.client-builder/undef)
     (. bean2131 setSubnetId (clojure.core/str v2133))))
   bean2131))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m2135]
  (clojure.core/let
   [bean2134
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/let
    [v2136
     (:instance-ids m2135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2136 :com.palletops.awaze.client-builder/undef)
     (.
      bean2134
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2756] (clojure.core/str arg2756))
 v2136))))
   (clojure.core/let
    [v2136 (:force m2135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2136 :com.palletops.awaze.client-builder/undef)
     (. bean2134 setForce (clojure.core/boolean v2136))))
   bean2134))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m2138]
  (clojure.core/let
   [bean2137
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/let
    [v2139
     (:group-name m2138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2139 :com.palletops.awaze.client-builder/undef)
     (. bean2137 setGroupName (clojure.core/str v2139))))
   (clojure.core/let
    [v2139
     (:strategy m2138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2139 :com.palletops.awaze.client-builder/undef)
     (. bean2137 setStrategy (ec2/placement-strategy v2139))))
   bean2137))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m2141]
  (clojure.core/let
   [bean2140
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/let
    [v2142
     (:client-token m2141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2142 :com.palletops.awaze.client-builder/undef)
     (. bean2140 setClientToken (clojure.core/str v2142))))
   (clojure.core/let
    [v2142
     (:reserved-instances-id
      m2141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2142 :com.palletops.awaze.client-builder/undef)
     (. bean2140 setReservedInstancesId (clojure.core/str v2142))))
   (clojure.core/let
    [v2142
     (:instance-count m2141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2142 :com.palletops.awaze.client-builder/undef)
     (. bean2140 setInstanceCount (clojure.core/int v2142))))
   (clojure.core/let
    [v2142
     (:price-schedules
      m2141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2142 :com.palletops.awaze.client-builder/undef)
     (.
      bean2140
      setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2757]
  (ec2/price-schedule-specification arg2757))
 v2142))))
   bean2140))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseHostsRequest}
release-hosts-request
  [m2144]
  (clojure.core/let
   [bean2143
    (new com.amazonaws.services.ec2.model.ReleaseHostsRequest)]
   (clojure.core/let
    [v2145
     (:host-ids m2144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2145 :com.palletops.awaze.client-builder/undef)
     (.
      bean2143
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2758] (clojure.core/str arg2758))
 v2145))))
   bean2143))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m2147]
  (clojure.core/let
   [bean2146
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2148 (:cidr-ip m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setCidrIp (clojure.core/str v2148))))
   (clojure.core/let
    [v2148
     (:group-id m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setGroupId (clojure.core/str v2148))))
   (clojure.core/let
    [v2148 (:to-port m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setToPort (clojure.core/int v2148))))
   (clojure.core/let
    [v2148
     (:source-security-group-owner-id
      m2147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (.
      bean2146
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2148))))
   (clojure.core/let
    [v2148
     (:ip-permissions m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (.
      bean2146
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2759] (ec2/ip-permission arg2759))
 v2148))))
   (clojure.core/let
    [v2148
     (:source-security-group-name
      m2147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setSourceSecurityGroupName (clojure.core/str v2148))))
   (clojure.core/let
    [v2148
     (:group-name m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setGroupName (clojure.core/str v2148))))
   (clojure.core/let
    [v2148
     (:ip-protocol m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setIpProtocol (clojure.core/str v2148))))
   (clojure.core/let
    [v2148
     (:from-port m2147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2148 :com.palletops.awaze.client-builder/undef)
     (. bean2146 setFromPort (clojure.core/int v2148))))
   bean2146))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest}
attach-classic-link-vpc-request
  [m2150]
  (clojure.core/let
   [bean2149
    (new com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2151 (:vpc-id m2150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2151 :com.palletops.awaze.client-builder/undef)
     (. bean2149 setVpcId (clojure.core/str v2151))))
   (clojure.core/let
    [v2151
     (:instance-id m2150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2151 :com.palletops.awaze.client-builder/undef)
     (. bean2149 setInstanceId (clojure.core/str v2151))))
   (clojure.core/let
    [v2151 (:groups m2150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2151 :com.palletops.awaze.client-builder/undef)
     (.
      bean2149
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2760] (clojure.core/str arg2760))
 v2151))))
   bean2149))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m2153]
  (clojure.core/let
   [bean2152
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/let
    [v2154
     (:network-acl-id m2153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2154 :com.palletops.awaze.client-builder/undef)
     (. bean2152 setNetworkAclId (clojure.core/str v2154))))
   (clojure.core/let
    [v2154
     (:association-id m2153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2154 :com.palletops.awaze.client-builder/undef)
     (. bean2152 setAssociationId (clojure.core/str v2154))))
   bean2152))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNatGatewayRequest}
delete-nat-gateway-request
  [m2156]
  (clojure.core/let
   [bean2155
    (new com.amazonaws.services.ec2.model.DeleteNatGatewayRequest)]
   (clojure.core/let
    [v2157
     (:nat-gateway-id m2156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2157 :com.palletops.awaze.client-builder/undef)
     (. bean2155 setNatGatewayId (clojure.core/str v2157))))
   bean2155))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m2159]
  (clojure.core/let
   [bean2158
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/let
    [v2160 (:kernel m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setKernel (clojure.core/str v2160))))
   (clojure.core/let
    [v2160
     (:instance-type m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setInstanceType (clojure.core/str v2160))))
   (clojure.core/let
    [v2160
     (:ebs-optimized m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setEbsOptimized (clojure.core/boolean v2160))))
   (clojure.core/let
    [v2160
     (:source-dest-check
      m2159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setSourceDestCheck (clojure.core/boolean v2160))))
   (clojure.core/let
    [v2160
     (:instance-id m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setInstanceId (clojure.core/str v2160))))
   (clojure.core/let
    [v2160
     (:instance-initiated-shutdown-behavior
      m2159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (.
      bean2158
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2160))))
   (clojure.core/let
    [v2160 (:groups m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (.
      bean2158
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2761] (clojure.core/str arg2761))
 v2160))))
   (clojure.core/let
    [v2160
     (:disable-api-termination
      m2159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (.
      bean2158
      setDisableApiTermination
      (clojure.core/boolean v2160))))
   (clojure.core/let
    [v2160
     (:attribute m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setAttribute (clojure.core/str v2160))))
   (clojure.core/let
    [v2160
     (:sriov-net-support
      m2159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setSriovNetSupport (clojure.core/str v2160))))
   (clojure.core/let
    [v2160 (:value m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setValue (clojure.core/str v2160))))
   (clojure.core/let
    [v2160
     (:block-device-mappings
      m2159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (.
      bean2158
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2762]
  (ec2/instance-block-device-mapping-specification arg2762))
 v2160))))
   (clojure.core/let
    [v2160 (:ramdisk m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setRamdisk (clojure.core/str v2160))))
   (clojure.core/let
    [v2160
     (:user-data m2159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2160 :com.palletops.awaze.client-builder/undef)
     (. bean2158 setUserData (clojure.core/str v2160))))
   bean2158))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m2162]
  (clojure.core/let
   [bean2161
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/let
    [v2163 (:filters m2162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2163 :com.palletops.awaze.client-builder/undef)
     (.
      bean2161
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2763] (ec2/filter arg2763))
 v2163))))
   (clojure.core/let
    [v2163
     (:network-acl-ids
      m2162
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2163 :com.palletops.awaze.client-builder/undef)
     (.
      bean2161
      setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2764] (clojure.core/str arg2764))
 v2163))))
   bean2161))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m2165]
  (clojure.core/let
   [bean2164
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/let
    [v2166
     (:description m2165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2166 :com.palletops.awaze.client-builder/undef)
     (. bean2164 setDescription (clojure.core/str v2166))))
   (clojure.core/let
    [v2166
     (:start-time m2165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2166 :com.palletops.awaze.client-builder/undef)
     (.
      bean2164
      setStartTime
      (com.palletops.awaze.common/to-date v2166))))
   (clojure.core/let
    [v2166
     (:end-time m2165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2166 :com.palletops.awaze.client-builder/undef)
     (.
      bean2164
      setEndTime
      (com.palletops.awaze.common/to-date v2166))))
   (clojure.core/let
    [v2166 (:status m2165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2166 :com.palletops.awaze.client-builder/undef)
     (. bean2164 setStatus (clojure.core/str v2166))))
   (clojure.core/let
    [v2166
     (:instances m2165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2166 :com.palletops.awaze.client-builder/undef)
     (.
      bean2164
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2765] (clojure.core/str arg2765))
 v2166))))
   (clojure.core/let
    [v2166
     (:reason-codes m2165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2166 :com.palletops.awaze.client-builder/undef)
     (.
      bean2164
      setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2766] (clojure.core/str arg2766))
 v2166))))
   bean2164))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m2168]
  (clojure.core/let
   [bean2167
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/let
    [v2169 (:filters m2168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2169 :com.palletops.awaze.client-builder/undef)
     (.
      bean2167
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2767] (ec2/filter arg2767))
 v2169))))
   (clojure.core/let
    [v2169
     (:image-ids m2168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2169 :com.palletops.awaze.client-builder/undef)
     (.
      bean2167
      setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2768] (clojure.core/str arg2768))
 v2169))))
   (clojure.core/let
    [v2169 (:owners m2168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2169 :com.palletops.awaze.client-builder/undef)
     (.
      bean2167
      setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2769] (clojure.core/str arg2769))
 v2169))))
   (clojure.core/let
    [v2169
     (:executable-users
      m2168
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2169 :com.palletops.awaze.client-builder/undef)
     (.
      bean2167
      setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2770] (clojure.core/str arg2770))
 v2169))))
   bean2167))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest}
describe-import-image-tasks-request
  [m2171]
  (clojure.core/let
   [bean2170
    (new
     com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest)]
   (clojure.core/let
    [v2172 (:filters m2171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2172 :com.palletops.awaze.client-builder/undef)
     (.
      bean2170
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2771] (ec2/filter arg2771))
 v2172))))
   (clojure.core/let
    [v2172
     (:next-token m2171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2172 :com.palletops.awaze.client-builder/undef)
     (. bean2170 setNextToken (clojure.core/str v2172))))
   (clojure.core/let
    [v2172
     (:max-results m2171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2172 :com.palletops.awaze.client-builder/undef)
     (. bean2170 setMaxResults (clojure.core/int v2172))))
   (clojure.core/let
    [v2172
     (:import-task-ids
      m2171
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2172 :com.palletops.awaze.client-builder/undef)
     (.
      bean2170
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2772] (clojure.core/str arg2772))
 v2172))))
   bean2170))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyHostsRequest}
modify-hosts-request
  [m2174]
  (clojure.core/let
   [bean2173
    (new com.amazonaws.services.ec2.model.ModifyHostsRequest)]
   (clojure.core/let
    [v2175
     (:auto-placement m2174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2175 :com.palletops.awaze.client-builder/undef)
     (. bean2173 setAutoPlacement (ec2/auto-placement v2175))))
   (clojure.core/let
    [v2175
     (:host-ids m2174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2175 :com.palletops.awaze.client-builder/undef)
     (.
      bean2173
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2773] (clojure.core/str arg2773))
 v2175))))
   bean2173))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m2177]
  (clojure.core/let
   [bean2176
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/let
    [v2178
     (:description m2177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setDescription (clojure.core/str v2178))))
   (clojure.core/let
    [v2178 (:name m2177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setName (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:root-device-name
      m2177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setRootDeviceName (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:ramdisk-id m2177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setRamdiskId (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:virtualization-type
      m2177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setVirtualizationType (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:sriov-net-support
      m2177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setSriovNetSupport (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:kernel-id m2177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setKernelId (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:image-location m2177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setImageLocation (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:architecture m2177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (. bean2176 setArchitecture (clojure.core/str v2178))))
   (clojure.core/let
    [v2178
     (:block-device-mappings
      m2177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2178 :com.palletops.awaze.client-builder/undef)
     (.
      bean2176
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2774] (ec2/block-device-mapping arg2774))
 v2178))))
   bean2176))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m2180]
  (clojure.core/let
   [bean2179
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/let
    [v2181 (:vpc-id m2180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2181 :com.palletops.awaze.client-builder/undef)
     (. bean2179 setVpcId (clojure.core/str v2181))))
   (clojure.core/let
    [v2181
     (:vpn-gateway-id m2180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2181 :com.palletops.awaze.client-builder/undef)
     (. bean2179 setVpnGatewayId (clojure.core/str v2181))))
   bean2179))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m2183]
  (clojure.core/let
   [bean2182
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v2184
     (:volume-id m2183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2184 :com.palletops.awaze.client-builder/undef)
     (. bean2182 setVolumeId (clojure.core/str v2184))))
   bean2182))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m2186]
  (clojure.core/let
   [bean2185
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/let
    [v2187
     (:internet-gateway-id
      m2186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2187 :com.palletops.awaze.client-builder/undef)
     (. bean2185 setInternetGatewayId (clojure.core/str v2187))))
   bean2185))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m2189]
  (clojure.core/let
   [bean2188
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/let
    [v2190
     (:subnet-id m2189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2190 :com.palletops.awaze.client-builder/undef)
     (. bean2188 setSubnetId (clojure.core/str v2190))))
   bean2188))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m2192]
  (clojure.core/let
   [bean2191
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/let
    [v2193
     (:instance-id m2192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2193 :com.palletops.awaze.client-builder/undef)
     (. bean2191 setInstanceId (clojure.core/str v2193))))
   (clojure.core/let
    [v2193
     (:attribute m2192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2193 :com.palletops.awaze.client-builder/undef)
     (. bean2191 setAttribute (ec2/instance-attribute-name v2193))))
   bean2191))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m2195]
  (clojure.core/let
   [bean2194
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/let
    [v2196
     (:instance-id m2195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2196 :com.palletops.awaze.client-builder/undef)
     (. bean2194 setInstanceId (clojure.core/str v2196))))
   (clojure.core/let
    [v2196
     (:volume-id m2195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2196 :com.palletops.awaze.client-builder/undef)
     (. bean2194 setVolumeId (clojure.core/str v2196))))
   (clojure.core/let
    [v2196 (:device m2195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2196 :com.palletops.awaze.client-builder/undef)
     (. bean2194 setDevice (clojure.core/str v2196))))
   (clojure.core/let
    [v2196 (:force m2195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2196 :com.palletops.awaze.client-builder/undef)
     (. bean2194 setForce (clojure.core/boolean v2196))))
   bean2194))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m2198]
  (clojure.core/let
   [bean2197
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/let
    [v2199
     (:export-task-ids
      m2198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2199 :com.palletops.awaze.client-builder/undef)
     (.
      bean2197
      setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2775] (clojure.core/str arg2775))
 v2199))))
   bean2197))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest}
describe-scheduled-instances-request
  [m2201]
  (clojure.core/let
   [bean2200
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest)]
   (clojure.core/let
    [v2202 (:filters m2201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2202 :com.palletops.awaze.client-builder/undef)
     (.
      bean2200
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2776] (ec2/filter arg2776))
 v2202))))
   (clojure.core/let
    [v2202
     (:next-token m2201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2202 :com.palletops.awaze.client-builder/undef)
     (. bean2200 setNextToken (clojure.core/str v2202))))
   (clojure.core/let
    [v2202
     (:max-results m2201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2202 :com.palletops.awaze.client-builder/undef)
     (. bean2200 setMaxResults (clojure.core/int v2202))))
   (clojure.core/let
    [v2202
     (:scheduled-instance-ids
      m2201
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2202 :com.palletops.awaze.client-builder/undef)
     (.
      bean2200
      setScheduledInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2777] (clojure.core/str arg2777))
 v2202))))
   (clojure.core/let
    [v2202
     (:slot-start-time-range
      m2201
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2202 :com.palletops.awaze.client-builder/undef)
     (.
      bean2200
      setSlotStartTimeRange
      (ec2/slot-start-time-range-request v2202))))
   bean2200))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteFlowLogsRequest}
delete-flow-logs-request
  [m2204]
  (clojure.core/let
   [bean2203
    (new com.amazonaws.services.ec2.model.DeleteFlowLogsRequest)]
   (clojure.core/let
    [v2205
     (:flow-log-ids m2204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2205 :com.palletops.awaze.client-builder/undef)
     (.
      bean2203
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2778] (clojure.core/str arg2778))
 v2205))))
   bean2203))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m2207]
  (clojure.core/let
   [bean2206 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/let
    [v2208
     (:cidr-block m2207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2208 :com.palletops.awaze.client-builder/undef)
     (. bean2206 setCidrBlock (clojure.core/str v2208))))
   (clojure.core/let
    [v2208
     (:instance-tenancy
      m2207
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2208 :com.palletops.awaze.client-builder/undef)
     (. bean2206 setInstanceTenancy (ec2/tenancy v2208))))
   bean2206))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m2210]
  (clojure.core/let
   [bean2209
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/let
    [v2211 (:bucket m2210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2211 :com.palletops.awaze.client-builder/undef)
     (. bean2209 setBucket (clojure.core/str v2211))))
   (clojure.core/let
    [v2211 (:prefix m2210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2211 :com.palletops.awaze.client-builder/undef)
     (. bean2209 setPrefix (clojure.core/str v2211))))
   bean2209))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest}
describe-vpc-classic-link-request
  [m2213]
  (clojure.core/let
   [bean2212
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest)]
   (clojure.core/let
    [v2214 (:filters m2213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2214 :com.palletops.awaze.client-builder/undef)
     (.
      bean2212
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2779] (ec2/filter arg2779))
 v2214))))
   (clojure.core/let
    [v2214 (:vpc-ids m2213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2214 :com.palletops.awaze.client-builder/undef)
     (.
      bean2212
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2780] (clojure.core/str arg2780))
 v2214))))
   bean2212))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m2216]
  (clojure.core/let
   [bean2215
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/let
    [v2217
     (:route-table-id m2216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2217 :com.palletops.awaze.client-builder/undef)
     (. bean2215 setRouteTableId (clojure.core/str v2217))))
   (clojure.core/let
    [v2217
     (:destination-cidr-block
      m2216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2217 :com.palletops.awaze.client-builder/undef)
     (. bean2215 setDestinationCidrBlock (clojure.core/str v2217))))
   bean2215))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeIdFormatRequest}
describe-id-format-request
  [m2219]
  (clojure.core/let
   [bean2218
    (new com.amazonaws.services.ec2.model.DescribeIdFormatRequest)]
   (clojure.core/let
    [v2220
     (:resource m2219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2220 :com.palletops.awaze.client-builder/undef)
     (. bean2218 setResource (clojure.core/str v2220))))
   bean2218))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m2222]
  (clojure.core/let
   [bean2221
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/let
    [v2223
     (:instance-id m2222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2223 :com.palletops.awaze.client-builder/undef)
     (. bean2221 setInstanceId (clojure.core/str v2223))))
   (clojure.core/let
    [v2223
     (:volume-id m2222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2223 :com.palletops.awaze.client-builder/undef)
     (. bean2221 setVolumeId (clojure.core/str v2223))))
   (clojure.core/let
    [v2223 (:device m2222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2223 :com.palletops.awaze.client-builder/undef)
     (. bean2221 setDevice (clojure.core/str v2223))))
   bean2221))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m2225]
  (clojure.core/let
   [bean2224
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/let
    [v2226
     (:volume-id m2225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2226 :com.palletops.awaze.client-builder/undef)
     (. bean2224 setVolumeId (clojure.core/str v2226))))
   bean2224))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m2228]
  (clojure.core/let
   [bean2227
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/let
    [v2229 (:vpc-id m2228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2229 :com.palletops.awaze.client-builder/undef)
     (. bean2227 setVpcId (clojure.core/str v2229))))
   (clojure.core/let
    [v2229
     (:vpn-gateway-id m2228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2229 :com.palletops.awaze.client-builder/undef)
     (. bean2227 setVpnGatewayId (clojure.core/str v2229))))
   bean2227))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m2231]
  (clojure.core/let
   [bean2230
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/let
    [v2232
     (:protocol m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setProtocol (clojure.core/str v2232))))
   (clojure.core/let
    [v2232
     (:network-acl-id m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setNetworkAclId (clojure.core/str v2232))))
   (clojure.core/let
    [v2232
     (:rule-number m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setRuleNumber (clojure.core/int v2232))))
   (clojure.core/let
    [v2232
     (:rule-action m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setRuleAction (ec2/rule-action v2232))))
   (clojure.core/let
    [v2232 (:egress m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setEgress (clojure.core/boolean v2232))))
   (clojure.core/let
    [v2232
     (:cidr-block m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setCidrBlock (clojure.core/str v2232))))
   (clojure.core/let
    [v2232
     (:icmp-type-code m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setIcmpTypeCode (ec2/icmp-type-code v2232))))
   (clojure.core/let
    [v2232
     (:port-range m2231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2232 :com.palletops.awaze.client-builder/undef)
     (. bean2230 setPortRange (ec2/port-range v2232))))
   bean2230))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m2234]
  (clojure.core/let
   [bean2233
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/let
    [v2235
     (:snapshot-id m2234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2235 :com.palletops.awaze.client-builder/undef)
     (. bean2233 setSnapshotId (clojure.core/str v2235))))
   (clojure.core/let
    [v2235
     (:attribute m2234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2235 :com.palletops.awaze.client-builder/undef)
     (. bean2233 setAttribute (ec2/snapshot-attribute-name v2235))))
   bean2233))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m2237]
  (clojure.core/let
   [bean2236
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/let
    [v2238
     (:instance-ids m2237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2238 :com.palletops.awaze.client-builder/undef)
     (.
      bean2236
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2781] (clojure.core/str arg2781))
 v2238))))
   bean2236))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m2240]
  (clojure.core/let
   [bean2239
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2241
     (:vpc-peering-connection-id
      m2240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2241 :com.palletops.awaze.client-builder/undef)
     (. bean2239 setVpcPeeringConnectionId (clojure.core/str v2241))))
   bean2239))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m2243]
  (clojure.core/let
   [bean2242
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/let
    [v2244 (:vpc-id m2243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2244 :com.palletops.awaze.client-builder/undef)
     (. bean2242 setVpcId (clojure.core/str v2244))))
   (clojure.core/let
    [v2244
     (:group-name m2243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2244 :com.palletops.awaze.client-builder/undef)
     (. bean2242 setGroupName (clojure.core/str v2244))))
   (clojure.core/let
    [v2244
     (:description m2243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2244 :com.palletops.awaze.client-builder/undef)
     (. bean2242 setDescription (clojure.core/str v2244))))
   bean2242))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m2246]
  (clojure.core/let
   [bean2245
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2247
     (:spot-instance-request-ids
      m2246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2247 :com.palletops.awaze.client-builder/undef)
     (.
      bean2245
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2782] (clojure.core/str arg2782))
 v2247))))
   (clojure.core/let
    [v2247 (:filters m2246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2247 :com.palletops.awaze.client-builder/undef)
     (.
      bean2245
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2783] (ec2/filter arg2783))
 v2247))))
   bean2245))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m2249]
  (clojure.core/let
   [bean2248
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean2248))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MoveAddressToVpcRequest}
move-address-to-vpc-request
  [m2252]
  (clojure.core/let
   [bean2251
    (new com.amazonaws.services.ec2.model.MoveAddressToVpcRequest)]
   (clojure.core/let
    [v2253
     (:public-ip m2252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2253 :com.palletops.awaze.client-builder/undef)
     (. bean2251 setPublicIp (clojure.core/str v2253))))
   bean2251))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest}
modify-vpc-endpoint-request
  [m2255]
  (clojure.core/let
   [bean2254
    (new com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest)]
   (clojure.core/let
    [v2256
     (:policy-document
      m2255
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2256 :com.palletops.awaze.client-builder/undef)
     (. bean2254 setPolicyDocument (clojure.core/str v2256))))
   (clojure.core/let
    [v2256
     (:vpc-endpoint-id
      m2255
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2256 :com.palletops.awaze.client-builder/undef)
     (. bean2254 setVpcEndpointId (clojure.core/str v2256))))
   (clojure.core/let
    [v2256
     (:reset-policy m2255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2256 :com.palletops.awaze.client-builder/undef)
     (. bean2254 setResetPolicy (clojure.core/boolean v2256))))
   (clojure.core/let
    [v2256
     (:add-route-table-ids
      m2255
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2256 :com.palletops.awaze.client-builder/undef)
     (.
      bean2254
      setAddRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2784] (clojure.core/str arg2784))
 v2256))))
   (clojure.core/let
    [v2256
     (:remove-route-table-ids
      m2255
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2256 :com.palletops.awaze.client-builder/undef)
     (.
      bean2254
      setRemoveRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2785] (clojure.core/str arg2785))
 v2256))))
   bean2254))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m2258]
  (clojure.core/let
   [bean2257
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2259
     (:network-interface-id
      m2258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2259 :com.palletops.awaze.client-builder/undef)
     (. bean2257 setNetworkInterfaceId (clojure.core/str v2259))))
   (clojure.core/let
    [v2259
     (:instance-id m2258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2259 :com.palletops.awaze.client-builder/undef)
     (. bean2257 setInstanceId (clojure.core/str v2259))))
   (clojure.core/let
    [v2259
     (:device-index m2258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2259 :com.palletops.awaze.client-builder/undef)
     (. bean2257 setDeviceIndex (clojure.core/int v2259))))
   bean2257))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m2261]
  (clojure.core/let
   [bean2260
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2262 (:force m2261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2262 :com.palletops.awaze.client-builder/undef)
     (. bean2260 setForce (clojure.core/boolean v2262))))
   (clojure.core/let
    [v2262
     (:attachment-id m2261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2262 :com.palletops.awaze.client-builder/undef)
     (. bean2260 setAttachmentId (clojure.core/str v2262))))
   bean2260))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m2264]
  (clojure.core/let
   [bean2263
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/let
    [v2265
     (:dhcp-options-id
      m2264
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2265 :com.palletops.awaze.client-builder/undef)
     (. bean2263 setDhcpOptionsId (clojure.core/str v2265))))
   bean2263))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest}
describe-vpc-endpoints-request
  [m2267]
  (clojure.core/let
   [bean2266
    (new com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest)]
   (clojure.core/let
    [v2268
     (:vpc-endpoint-ids
      m2267
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2268 :com.palletops.awaze.client-builder/undef)
     (.
      bean2266
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2786] (clojure.core/str arg2786))
 v2268))))
   (clojure.core/let
    [v2268 (:filters m2267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2268 :com.palletops.awaze.client-builder/undef)
     (.
      bean2266
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2787] (ec2/filter arg2787))
 v2268))))
   (clojure.core/let
    [v2268
     (:next-token m2267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2268 :com.palletops.awaze.client-builder/undef)
     (. bean2266 setNextToken (clojure.core/str v2268))))
   (clojure.core/let
    [v2268
     (:max-results m2267 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2268 :com.palletops.awaze.client-builder/undef)
     (. bean2266 setMaxResults (clojure.core/int v2268))))
   bean2266))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m2270]
  (clojure.core/let
   [bean2269
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/let
    [v2271
     (:instance-id m2270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2271 :com.palletops.awaze.client-builder/undef)
     (. bean2269 setInstanceId (clojure.core/str v2271))))
   (clojure.core/let
    [v2271
     (:product-code m2270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2271 :com.palletops.awaze.client-builder/undef)
     (. bean2269 setProductCode (clojure.core/str v2271))))
   bean2269))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m2273]
  (clojure.core/let
   [bean2272
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/let
    [v2274 (:domain m2273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2274 :com.palletops.awaze.client-builder/undef)
     (. bean2272 setDomain (clojure.core/str v2274))))
   bean2272))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcEndpointRequest}
create-vpc-endpoint-request
  [m2276]
  (clojure.core/let
   [bean2275
    (new com.amazonaws.services.ec2.model.CreateVpcEndpointRequest)]
   (clojure.core/let
    [v2277 (:vpc-id m2276 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2277 :com.palletops.awaze.client-builder/undef)
     (. bean2275 setVpcId (clojure.core/str v2277))))
   (clojure.core/let
    [v2277
     (:service-name m2276 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2277 :com.palletops.awaze.client-builder/undef)
     (. bean2275 setServiceName (clojure.core/str v2277))))
   (clojure.core/let
    [v2277
     (:client-token m2276 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2277 :com.palletops.awaze.client-builder/undef)
     (. bean2275 setClientToken (clojure.core/str v2277))))
   (clojure.core/let
    [v2277
     (:policy-document
      m2276
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2277 :com.palletops.awaze.client-builder/undef)
     (. bean2275 setPolicyDocument (clojure.core/str v2277))))
   (clojure.core/let
    [v2277
     (:route-table-ids
      m2276
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2277 :com.palletops.awaze.client-builder/undef)
     (.
      bean2275
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2788] (clojure.core/str arg2788))
 v2277))))
   bean2275))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m2279]
  (clojure.core/let
   [bean2278
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/let
    [v2280
     (:key-name m2279 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2280 :com.palletops.awaze.client-builder/undef)
     (. bean2278 setKeyName (clojure.core/str v2280))))
   (clojure.core/let
    [v2280
     (:public-key-material
      m2279
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2280 :com.palletops.awaze.client-builder/undef)
     (. bean2278 setPublicKeyMaterial (clojure.core/str v2280))))
   bean2278))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m2282]
  (clojure.core/let
   [bean2281
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/let
    [v2283
     (:source-region m2282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setSourceRegion (clojure.core/str v2283))))
   (clojure.core/let
    [v2283
     (:description m2282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setDescription (clojure.core/str v2283))))
   (clojure.core/let
    [v2283
     (:encrypted m2282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setEncrypted (clojure.core/boolean v2283))))
   (clojure.core/let
    [v2283
     (:kms-key-id m2282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setKmsKeyId (clojure.core/str v2283))))
   (clojure.core/let
    [v2283
     (:source-snapshot-id
      m2282
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setSourceSnapshotId (clojure.core/str v2283))))
   (clojure.core/let
    [v2283
     (:destination-region
      m2282
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setDestinationRegion (clojure.core/str v2283))))
   (clojure.core/let
    [v2283
     (:presigned-url m2282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2283 :com.palletops.awaze.client-builder/undef)
     (. bean2281 setPresignedUrl (clojure.core/str v2283))))
   bean2281))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m2285]
  (clojure.core/let
   [bean2284
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v2286
     (:snapshot-id m2285 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2286 :com.palletops.awaze.client-builder/undef)
     (. bean2284 setSnapshotId (clojure.core/str v2286))))
   bean2284))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m2288]
  (clojure.core/let
   [bean2287
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/let
    [v2289
     (:image-id m2288 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2289 :com.palletops.awaze.client-builder/undef)
     (. bean2287 setImageId (clojure.core/str v2289))))
   (clojure.core/let
    [v2289
     (:attribute m2288 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2289 :com.palletops.awaze.client-builder/undef)
     (. bean2287 setAttribute (ec2/reset-image-attribute-name v2289))))
   bean2287))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m2291]
  (clojure.core/let
   [bean2290
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean2290))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m2294]
  (clojure.core/let
   [bean2293
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/let
    [v2295
     (:instance-ids m2294 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2295 :com.palletops.awaze.client-builder/undef)
     (.
      bean2293
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2789] (clojure.core/str arg2789))
 v2295))))
   bean2293))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m2297]
  (clojure.core/let
   [bean2296
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2298
     (:group-id m2297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (. bean2296 setGroupId (clojure.core/str v2298))))
   (clojure.core/let
    [v2298
     (:source-security-group-name
      m2297
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (. bean2296 setSourceSecurityGroupName (clojure.core/str v2298))))
   (clojure.core/let
    [v2298
     (:source-security-group-owner-id
      m2297
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (.
      bean2296
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2298))))
   (clojure.core/let
    [v2298
     (:ip-protocol m2297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (. bean2296 setIpProtocol (clojure.core/str v2298))))
   (clojure.core/let
    [v2298
     (:from-port m2297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (. bean2296 setFromPort (clojure.core/int v2298))))
   (clojure.core/let
    [v2298 (:to-port m2297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (. bean2296 setToPort (clojure.core/int v2298))))
   (clojure.core/let
    [v2298 (:cidr-ip m2297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (. bean2296 setCidrIp (clojure.core/str v2298))))
   (clojure.core/let
    [v2298
     (:ip-permissions m2297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2298 :com.palletops.awaze.client-builder/undef)
     (.
      bean2296
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2790] (ec2/ip-permission arg2790))
 v2298))))
   bean2296))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m2300]
  (clojure.core/let
   [bean2299
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/let
    [v2301 (:filters m2300 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2301 :com.palletops.awaze.client-builder/undef)
     (.
      bean2299
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2791] (ec2/filter arg2791))
 v2301))))
   (clojure.core/let
    [v2301 (:vpc-ids m2300 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2301 :com.palletops.awaze.client-builder/undef)
     (.
      bean2299
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2792] (clojure.core/str arg2792))
 v2301))))
   bean2299))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m2303]
  (clojure.core/let
   [bean2302
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/let
    [v2304
     (:description m2303 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2304 :com.palletops.awaze.client-builder/undef)
     (. bean2302 setDescription (clojure.core/str v2304))))
   (clojure.core/let
    [v2304
     (:platform m2303 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2304 :com.palletops.awaze.client-builder/undef)
     (. bean2302 setPlatform (ec2/platform-values v2304))))
   (clojure.core/let
    [v2304
     (:launch-specification
      m2303
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2304 :com.palletops.awaze.client-builder/undef)
     (.
      bean2302
      setLaunchSpecification
      (ec2/import-instance-launch-specification v2304))))
   (clojure.core/let
    [v2304
     (:disk-images m2303 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2304 :com.palletops.awaze.client-builder/undef)
     (.
      bean2302
      setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2793] (ec2/disk-image arg2793))
 v2304))))
   bean2302))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m2306]
  (clojure.core/let
   [bean2305 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/let
    [v2307 (:name m2306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setName (clojure.core/str v2307))))
   (clojure.core/let
    [v2307
     (:client-token m2306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setClientToken (clojure.core/str v2307))))
   (clojure.core/let
    [v2307
     (:source-region m2306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setSourceRegion (clojure.core/str v2307))))
   (clojure.core/let
    [v2307
     (:source-image-id
      m2306
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setSourceImageId (clojure.core/str v2307))))
   (clojure.core/let
    [v2307
     (:description m2306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setDescription (clojure.core/str v2307))))
   (clojure.core/let
    [v2307
     (:encrypted m2306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setEncrypted (clojure.core/boolean v2307))))
   (clojure.core/let
    [v2307
     (:kms-key-id m2306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2307 :com.palletops.awaze.client-builder/undef)
     (. bean2305 setKmsKeyId (clojure.core/str v2307))))
   bean2305))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m2309]
  (clojure.core/let
   [bean2308
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/let
    [v2310
     (:instance-id m2309 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2310 :com.palletops.awaze.client-builder/undef)
     (. bean2308 setInstanceId (clojure.core/str v2310))))
   bean2308))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m2312]
  (clojure.core/let
   [bean2311
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/let
    [v2313
     (:snapshot-id m2312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2313 :com.palletops.awaze.client-builder/undef)
     (. bean2311 setSnapshotId (clojure.core/str v2313))))
   (clojure.core/let
    [v2313
     (:attribute m2312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2313 :com.palletops.awaze.client-builder/undef)
     (. bean2311 setAttribute (clojure.core/str v2313))))
   (clojure.core/let
    [v2313
     (:group-names m2312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2313 :com.palletops.awaze.client-builder/undef)
     (.
      bean2311
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2794] (clojure.core/str arg2794))
 v2313))))
   (clojure.core/let
    [v2313
     (:operation-type m2312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2313 :com.palletops.awaze.client-builder/undef)
     (. bean2311 setOperationType (clojure.core/str v2313))))
   (clojure.core/let
    [v2313
     (:user-ids m2312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2313 :com.palletops.awaze.client-builder/undef)
     (.
      bean2311
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2795] (clojure.core/str arg2795))
 v2313))))
   (clojure.core/let
    [v2313
     (:create-volume-permission
      m2312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2313 :com.palletops.awaze.client-builder/undef)
     (.
      bean2311
      setCreateVolumePermission
      (ec2/create-volume-permission-modifications v2313))))
   bean2311))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotFleetRequest}
request-spot-fleet-request
  [m2315]
  (clojure.core/let
   [bean2314
    (new com.amazonaws.services.ec2.model.RequestSpotFleetRequest)]
   (clojure.core/let
    [v2316
     (:spot-fleet-request-config
      m2315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2316 :com.palletops.awaze.client-builder/undef)
     (.
      bean2314
      setSpotFleetRequestConfig
      (ec2/spot-fleet-request-config-data v2316))))
   bean2314))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest}
restore-address-to-classic-request
  [m2318]
  (clojure.core/let
   [bean2317
    (new
     com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest)]
   (clojure.core/let
    [v2319
     (:public-ip m2318 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2319 :com.palletops.awaze.client-builder/undef)
     (. bean2317 setPublicIp (clojure.core/str v2319))))
   bean2317))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest}
modify-subnet-attribute-request
  [m2321]
  (clojure.core/let
   [bean2320
    (new
     com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest)]
   (clojure.core/let
    [v2322
     (:subnet-id m2321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2322 :com.palletops.awaze.client-builder/undef)
     (. bean2320 setSubnetId (clojure.core/str v2322))))
   (clojure.core/let
    [v2322
     (:map-public-ip-on-launch
      m2321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2322 :com.palletops.awaze.client-builder/undef)
     (. bean2320 setMapPublicIpOnLaunch (clojure.core/boolean v2322))))
   bean2320))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m2324]
  (clojure.core/let
   [bean2323
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/let
    [v2325 (:filters m2324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2325 :com.palletops.awaze.client-builder/undef)
     (.
      bean2323
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2796] (ec2/filter arg2796))
 v2325))))
   (clojure.core/let
    [v2325
     (:conversion-task-ids
      m2324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2325 :com.palletops.awaze.client-builder/undef)
     (.
      bean2323
      setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2797] (clojure.core/str arg2797))
 v2325))))
   bean2323))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m2327]
  (clojure.core/let
   [bean2326
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2328
     (:group-id m2327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (. bean2326 setGroupId (clojure.core/str v2328))))
   (clojure.core/let
    [v2328
     (:source-security-group-name
      m2327
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (. bean2326 setSourceSecurityGroupName (clojure.core/str v2328))))
   (clojure.core/let
    [v2328
     (:source-security-group-owner-id
      m2327
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (.
      bean2326
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2328))))
   (clojure.core/let
    [v2328
     (:ip-protocol m2327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (. bean2326 setIpProtocol (clojure.core/str v2328))))
   (clojure.core/let
    [v2328
     (:from-port m2327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (. bean2326 setFromPort (clojure.core/int v2328))))
   (clojure.core/let
    [v2328 (:to-port m2327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (. bean2326 setToPort (clojure.core/int v2328))))
   (clojure.core/let
    [v2328 (:cidr-ip m2327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (. bean2326 setCidrIp (clojure.core/str v2328))))
   (clojure.core/let
    [v2328
     (:ip-permissions m2327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2328 :com.palletops.awaze.client-builder/undef)
     (.
      bean2326
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2798] (ec2/ip-permission arg2798))
 v2328))))
   bean2326))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m2330]
  (clojure.core/let
   [bean2329
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2331 (:cidr-ip m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setCidrIp (clojure.core/str v2331))))
   (clojure.core/let
    [v2331
     (:group-id m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setGroupId (clojure.core/str v2331))))
   (clojure.core/let
    [v2331 (:to-port m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setToPort (clojure.core/int v2331))))
   (clojure.core/let
    [v2331
     (:source-security-group-owner-id
      m2330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (.
      bean2329
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2331))))
   (clojure.core/let
    [v2331
     (:ip-permissions m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (.
      bean2329
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2799] (ec2/ip-permission arg2799))
 v2331))))
   (clojure.core/let
    [v2331
     (:source-security-group-name
      m2330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setSourceSecurityGroupName (clojure.core/str v2331))))
   (clojure.core/let
    [v2331
     (:group-name m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setGroupName (clojure.core/str v2331))))
   (clojure.core/let
    [v2331
     (:ip-protocol m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setIpProtocol (clojure.core/str v2331))))
   (clojure.core/let
    [v2331
     (:from-port m2330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2331 :com.palletops.awaze.client-builder/undef)
     (. bean2329 setFromPort (clojure.core/int v2331))))
   bean2329))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m2333]
  (clojure.core/let
   [bean2332
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/let
    [v2334
     (:public-ips m2333 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2334 :com.palletops.awaze.client-builder/undef)
     (.
      bean2332
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2800] (clojure.core/str arg2800))
 v2334))))
   (clojure.core/let
    [v2334 (:filters m2333 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2334 :com.palletops.awaze.client-builder/undef)
     (.
      bean2332
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2801] (ec2/filter arg2801))
 v2334))))
   (clojure.core/let
    [v2334
     (:allocation-ids m2333 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2334 :com.palletops.awaze.client-builder/undef)
     (.
      bean2332
      setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2802] (clojure.core/str arg2802))
 v2334))))
   bean2332))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m2336]
  (clojure.core/let
   [bean2335
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2337
     (:destination-cidr-block
      m2336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2337 :com.palletops.awaze.client-builder/undef)
     (. bean2335 setDestinationCidrBlock (clojure.core/str v2337))))
   (clojure.core/let
    [v2337
     (:vpn-connection-id
      m2336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2337 :com.palletops.awaze.client-builder/undef)
     (. bean2335 setVpnConnectionId (clojure.core/str v2337))))
   bean2335))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m2339]
  (clojure.core/let
   [bean2338
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/let
    [v2340
     (:network-interface-id
      m2339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2340 :com.palletops.awaze.client-builder/undef)
     (. bean2338 setNetworkInterfaceId (clojure.core/str v2340))))
   (clojure.core/let
    [v2340
     (:instance-id m2339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2340 :com.palletops.awaze.client-builder/undef)
     (. bean2338 setInstanceId (clojure.core/str v2340))))
   (clojure.core/let
    [v2340
     (:public-ip m2339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2340 :com.palletops.awaze.client-builder/undef)
     (. bean2338 setPublicIp (clojure.core/str v2340))))
   (clojure.core/let
    [v2340
     (:allocation-id m2339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2340 :com.palletops.awaze.client-builder/undef)
     (. bean2338 setAllocationId (clojure.core/str v2340))))
   (clojure.core/let
    [v2340
     (:private-ip-address
      m2339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2340 :com.palletops.awaze.client-builder/undef)
     (. bean2338 setPrivateIpAddress (clojure.core/str v2340))))
   (clojure.core/let
    [v2340
     (:allow-reassociation
      m2339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2340 :com.palletops.awaze.client-builder/undef)
     (. bean2338 setAllowReassociation (clojure.core/boolean v2340))))
   bean2338))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m2342]
  (clojure.core/let
   [bean2341
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/let
    [v2343
     (:instance-id m2342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2343 :com.palletops.awaze.client-builder/undef)
     (. bean2341 setInstanceId (clojure.core/str v2343))))
   (clojure.core/let
    [v2343
     (:description m2342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2343 :com.palletops.awaze.client-builder/undef)
     (. bean2341 setDescription (clojure.core/str v2343))))
   (clojure.core/let
    [v2343
     (:target-environment
      m2342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2343 :com.palletops.awaze.client-builder/undef)
     (. bean2341 setTargetEnvironment (clojure.core/str v2343))))
   (clojure.core/let
    [v2343
     (:export-to-s3task
      m2342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2343 :com.palletops.awaze.client-builder/undef)
     (.
      bean2341
      setExportToS3Task
      (ec2/export-to-s3task-specification v2343))))
   bean2341))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m2345]
  (clojure.core/let
   [bean2344
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/let
    [v2346 (:filters m2345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2346 :com.palletops.awaze.client-builder/undef)
     (.
      bean2344
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2803] (ec2/filter arg2803))
 v2346))))
   (clojure.core/let
    [v2346
     (:key-names m2345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2346 :com.palletops.awaze.client-builder/undef)
     (.
      bean2344
      setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2804] (clojure.core/str arg2804))
 v2346))))
   bean2344))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest}
describe-spot-fleet-requests-request
  [m2348]
  (clojure.core/let
   [bean2347
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2349
     (:spot-fleet-request-ids
      m2348
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2349 :com.palletops.awaze.client-builder/undef)
     (.
      bean2347
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2805] (clojure.core/str arg2805))
 v2349))))
   (clojure.core/let
    [v2349
     (:next-token m2348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2349 :com.palletops.awaze.client-builder/undef)
     (. bean2347 setNextToken (clojure.core/str v2349))))
   (clojure.core/let
    [v2349
     (:max-results m2348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2349 :com.palletops.awaze.client-builder/undef)
     (. bean2347 setMaxResults (clojure.core/int v2349))))
   bean2347))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m2351]
  (clojure.core/let
   [bean2350
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/let
    [v2352
     (:image-id m2351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2352 :com.palletops.awaze.client-builder/undef)
     (. bean2350 setImageId (clojure.core/str v2352))))
   (clojure.core/let
    [v2352
     (:attribute m2351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2352 :com.palletops.awaze.client-builder/undef)
     (. bean2350 setAttribute (ec2/image-attribute-name v2352))))
   bean2350))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest}
describe-moving-addresses-request
  [m2354]
  (clojure.core/let
   [bean2353
    (new
     com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest)]
   (clojure.core/let
    [v2355
     (:public-ips m2354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2355 :com.palletops.awaze.client-builder/undef)
     (.
      bean2353
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2806] (clojure.core/str arg2806))
 v2355))))
   (clojure.core/let
    [v2355 (:filters m2354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2355 :com.palletops.awaze.client-builder/undef)
     (.
      bean2353
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2807] (ec2/filter arg2807))
 v2355))))
   (clojure.core/let
    [v2355
     (:next-token m2354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2355 :com.palletops.awaze.client-builder/undef)
     (. bean2353 setNextToken (clojure.core/str v2355))))
   (clojure.core/let
    [v2355
     (:max-results m2354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2355 :com.palletops.awaze.client-builder/undef)
     (. bean2353 setMaxResults (clojure.core/int v2355))))
   bean2353))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m2357]
  (clojure.core/let
   [bean2356
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/let
    [v2358
     (:network-acl-id m2357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2358 :com.palletops.awaze.client-builder/undef)
     (. bean2356 setNetworkAclId (clojure.core/str v2358))))
   bean2356))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m2360]
  (clojure.core/let
   [bean2359
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/let
    [v2361
     (:network-interface-id
      m2360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2361 :com.palletops.awaze.client-builder/undef)
     (. bean2359 setNetworkInterfaceId (clojure.core/str v2361))))
   bean2359))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m2363]
  (clojure.core/let
   [bean2362
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/let
    [v2364
     (:vpn-connection-id
      m2363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2364 :com.palletops.awaze.client-builder/undef)
     (. bean2362 setVpnConnectionId (clojure.core/str v2364))))
   bean2362))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest}
purchase-scheduled-instances-request
  [m2366]
  (clojure.core/let
   [bean2365
    (new
     com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest)]
   (clojure.core/let
    [v2367
     (:client-token m2366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2367 :com.palletops.awaze.client-builder/undef)
     (. bean2365 setClientToken (clojure.core/str v2367))))
   (clojure.core/let
    [v2367
     (:purchase-requests
      m2366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2367 :com.palletops.awaze.client-builder/undef)
     (.
      bean2365
      setPurchaseRequests
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2808] (ec2/purchase-request arg2808))
 v2367))))
   bean2365))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m2369]
  (clojure.core/let
   [bean2368
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/let
    [v2370 (:filters m2369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2370 :com.palletops.awaze.client-builder/undef)
     (.
      bean2368
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2809] (ec2/filter arg2809))
 v2370))))
   (clojure.core/let
    [v2370
     (:next-token m2369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2370 :com.palletops.awaze.client-builder/undef)
     (. bean2368 setNextToken (clojure.core/str v2370))))
   (clojure.core/let
    [v2370
     (:reserved-instances-modification-ids
      m2369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2370 :com.palletops.awaze.client-builder/undef)
     (.
      bean2368
      setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2810] (clojure.core/str arg2810))
 v2370))))
   bean2368))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest}
describe-classic-link-instances-request
  [m2372]
  (clojure.core/let
   [bean2371
    (new
     com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest)]
   (clojure.core/let
    [v2373 (:filters m2372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2373 :com.palletops.awaze.client-builder/undef)
     (.
      bean2371
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2811] (ec2/filter arg2811))
 v2373))))
   (clojure.core/let
    [v2373
     (:instance-ids m2372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2373 :com.palletops.awaze.client-builder/undef)
     (.
      bean2371
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2812] (clojure.core/str arg2812))
 v2373))))
   (clojure.core/let
    [v2373
     (:next-token m2372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2373 :com.palletops.awaze.client-builder/undef)
     (. bean2371 setNextToken (clojure.core/str v2373))))
   (clojure.core/let
    [v2373
     (:max-results m2372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2373 :com.palletops.awaze.client-builder/undef)
     (. bean2371 setMaxResults (clojure.core/int v2373))))
   bean2371))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m2375]
  (clojure.core/let
   [bean2374
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/let
    [v2376
     (:instance-count m2375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2376 :com.palletops.awaze.client-builder/undef)
     (. bean2374 setInstanceCount (clojure.core/int v2376))))
   (clojure.core/let
    [v2376
     (:limit-price m2375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2376 :com.palletops.awaze.client-builder/undef)
     (.
      bean2374
      setLimitPrice
      (ec2/reserved-instance-limit-price v2376))))
   (clojure.core/let
    [v2376
     (:reserved-instances-offering-id
      m2375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2376 :com.palletops.awaze.client-builder/undef)
     (.
      bean2374
      setReservedInstancesOfferingId
      (clojure.core/str v2376))))
   bean2374))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m2378]
  (clojure.core/let
   [bean2377
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/let
    [v2379
     (:instance-ids m2378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2379 :com.palletops.awaze.client-builder/undef)
     (.
      bean2377
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2813] (clojure.core/str arg2813))
 v2379))))
   (clojure.core/let
    [v2379
     (:additional-info
      m2378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2379 :com.palletops.awaze.client-builder/undef)
     (. bean2377 setAdditionalInfo (clojure.core/str v2379))))
   bean2377))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m2381]
  (clojure.core/let
   [bean2380
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/let
    [v2382
     (:instance-id m2381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2382 :com.palletops.awaze.client-builder/undef)
     (. bean2380 setInstanceId (clojure.core/str v2382))))
   (clojure.core/let
    [v2382
     (:attribute m2381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2382 :com.palletops.awaze.client-builder/undef)
     (. bean2380 setAttribute (ec2/instance-attribute-name v2382))))
   bean2380))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest}
cancel-spot-fleet-requests-request
  [m2384]
  (clojure.core/let
   [bean2383
    (new
     com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2385
     (:spot-fleet-request-ids
      m2384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2385 :com.palletops.awaze.client-builder/undef)
     (.
      bean2383
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2814] (clojure.core/str arg2814))
 v2385))))
   (clojure.core/let
    [v2385
     (:terminate-instances
      m2384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2385 :com.palletops.awaze.client-builder/undef)
     (. bean2383 setTerminateInstances (clojure.core/boolean v2385))))
   bean2383))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m2387]
  (clojure.core/let
   [bean2386
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/let
    [v2388 (:filters m2387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2388 :com.palletops.awaze.client-builder/undef)
     (.
      bean2386
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2815] (ec2/filter arg2815))
 v2388))))
   (clojure.core/let
    [v2388
     (:subnet-ids m2387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2388 :com.palletops.awaze.client-builder/undef)
     (.
      bean2386
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2816] (clojure.core/str arg2816))
 v2388))))
   bean2386))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m2390]
  (clojure.core/let
   [bean2389
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/let
    [v2391 (:size m2390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setSize (clojure.core/int v2391))))
   (clojure.core/let
    [v2391
     (:availability-zone
      m2390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setAvailabilityZone (clojure.core/str v2391))))
   (clojure.core/let
    [v2391
     (:encrypted m2390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setEncrypted (clojure.core/boolean v2391))))
   (clojure.core/let
    [v2391
     (:kms-key-id m2390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setKmsKeyId (clojure.core/str v2391))))
   (clojure.core/let
    [v2391
     (:snapshot-id m2390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setSnapshotId (clojure.core/str v2391))))
   (clojure.core/let
    [v2391
     (:volume-type m2390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setVolumeType (ec2/volume-type v2391))))
   (clojure.core/let
    [v2391 (:iops m2390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2391 :com.palletops.awaze.client-builder/undef)
     (. bean2389 setIops (clojure.core/int v2391))))
   bean2389))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m2393]
  (clojure.core/let
   [bean2392
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/let
    [v2394
     (:reserved-instances-listing-id
      m2393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2394 :com.palletops.awaze.client-builder/undef)
     (.
      bean2392
      setReservedInstancesListingId
      (clojure.core/str v2394))))
   (clojure.core/let
    [v2394
     (:reserved-instances-id
      m2393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2394 :com.palletops.awaze.client-builder/undef)
     (. bean2392 setReservedInstancesId (clojure.core/str v2394))))
   (clojure.core/let
    [v2394 (:filters m2393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2394 :com.palletops.awaze.client-builder/undef)
     (.
      bean2392
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2817] (ec2/filter arg2817))
 v2394))))
   bean2392))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m2396]
  (clojure.core/let
   [bean2395
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/let
    [v2397
     (:dhcp-configurations
      m2396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2397 :com.palletops.awaze.client-builder/undef)
     (.
      bean2395
      setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2818] (ec2/dhcp-configuration arg2818))
 v2397))))
   bean2395))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m2399]
  (clojure.core/let
   [bean2398
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/let
    [v2400 (:vpc-id m2399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2400 :com.palletops.awaze.client-builder/undef)
     (. bean2398 setVpcId (clojure.core/str v2400))))
   (clojure.core/let
    [v2400
     (:internet-gateway-id
      m2399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2400 :com.palletops.awaze.client-builder/undef)
     (. bean2398 setInternetGatewayId (clojure.core/str v2400))))
   bean2398))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m2402]
  (clojure.core/let
   [bean2401
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/let
    [v2403
     (:vpn-gateway-id m2402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2403 :com.palletops.awaze.client-builder/undef)
     (. bean2401 setVpnGatewayId (clojure.core/str v2403))))
   bean2401))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m2405]
  (clojure.core/let
   [bean2404
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/let
    [v2406
     (:spot-price m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setSpotPrice (clojure.core/str v2406))))
   (clojure.core/let
    [v2406
     (:valid-from m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (.
      bean2404
      setValidFrom
      (com.palletops.awaze.common/to-date v2406))))
   (clojure.core/let
    [v2406
     (:block-duration-minutes
      m2405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setBlockDurationMinutes (clojure.core/int v2406))))
   (clojure.core/let
    [v2406 (:type m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setType (ec2/spot-instance-type v2406))))
   (clojure.core/let
    [v2406
     (:client-token m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setClientToken (clojure.core/str v2406))))
   (clojure.core/let
    [v2406
     (:launch-group m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setLaunchGroup (clojure.core/str v2406))))
   (clojure.core/let
    [v2406
     (:instance-count m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setInstanceCount (clojure.core/int v2406))))
   (clojure.core/let
    [v2406
     (:launch-specification
      m2405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (.
      bean2404
      setLaunchSpecification
      (ec2/launch-specification v2406))))
   (clojure.core/let
    [v2406
     (:valid-until m2405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (.
      bean2404
      setValidUntil
      (com.palletops.awaze.common/to-date v2406))))
   (clojure.core/let
    [v2406
     (:availability-zone-group
      m2405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2406 :com.palletops.awaze.client-builder/undef)
     (. bean2404 setAvailabilityZoneGroup (clojure.core/str v2406))))
   bean2404))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m2408]
  (clojure.core/let
   [bean2407
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/let
    [v2409
     (:availability-zone
      m2408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2409 :com.palletops.awaze.client-builder/undef)
     (. bean2407 setAvailabilityZone (clojure.core/str v2409))))
   (clojure.core/let
    [v2409
     (:description m2408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2409 :com.palletops.awaze.client-builder/undef)
     (. bean2407 setDescription (clojure.core/str v2409))))
   (clojure.core/let
    [v2409 (:image m2408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2409 :com.palletops.awaze.client-builder/undef)
     (. bean2407 setImage (ec2/disk-image-detail v2409))))
   (clojure.core/let
    [v2409 (:volume m2408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2409 :com.palletops.awaze.client-builder/undef)
     (. bean2407 setVolume (ec2/volume-detail v2409))))
   bean2407))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportSnapshotRequest}
import-snapshot-request
  [m2411]
  (clojure.core/let
   [bean2410
    (new com.amazonaws.services.ec2.model.ImportSnapshotRequest)]
   (clojure.core/let
    [v2412
     (:client-token m2411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2412 :com.palletops.awaze.client-builder/undef)
     (. bean2410 setClientToken (clojure.core/str v2412))))
   (clojure.core/let
    [v2412
     (:description m2411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2412 :com.palletops.awaze.client-builder/undef)
     (. bean2410 setDescription (clojure.core/str v2412))))
   (clojure.core/let
    [v2412
     (:client-data m2411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2412 :com.palletops.awaze.client-builder/undef)
     (. bean2410 setClientData (ec2/client-data v2412))))
   (clojure.core/let
    [v2412
     (:role-name m2411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2412 :com.palletops.awaze.client-builder/undef)
     (. bean2410 setRoleName (clojure.core/str v2412))))
   (clojure.core/let
    [v2412
     (:disk-container m2411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2412 :com.palletops.awaze.client-builder/undef)
     (. bean2410 setDiskContainer (ec2/snapshot-disk-container v2412))))
   bean2410))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m2414]
  (clojure.core/let
   [bean2413
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/let
    [v2415 (:filters m2414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2415 :com.palletops.awaze.client-builder/undef)
     (.
      bean2413
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2819] (ec2/filter arg2819))
 v2415))))
   (clojure.core/let
    [v2415
     (:next-token m2414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2415 :com.palletops.awaze.client-builder/undef)
     (. bean2413 setNextToken (clojure.core/str v2415))))
   (clojure.core/let
    [v2415
     (:max-results m2414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2415 :com.palletops.awaze.client-builder/undef)
     (. bean2413 setMaxResults (clojure.core/int v2415))))
   bean2413))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m2417]
  (clojure.core/let
   [bean2416 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/let
    [v2418 (:tags m2417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2418 :com.palletops.awaze.client-builder/undef)
     (.
      bean2416
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2820] (ec2/tag arg2820)) v2418))))
   (clojure.core/let
    [v2418
     (:resources m2417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2418 :com.palletops.awaze.client-builder/undef)
     (.
      bean2416
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2821] (clojure.core/str arg2821))
 v2418))))
   bean2416))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest}
enable-vpc-classic-link-request
  [m2420]
  (clojure.core/let
   [bean2419
    (new com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2421 (:vpc-id m2420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2421 :com.palletops.awaze.client-builder/undef)
     (. bean2419 setVpcId (clojure.core/str v2421))))
   bean2419))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m2423]
  (clojure.core/let
   [bean2422
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/let
    [v2424
     (:include-marketplace
      m2423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setIncludeMarketplace (clojure.core/boolean v2424))))
   (clojure.core/let
    [v2424
     (:reserved-instances-offering-ids
      m2423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (.
      bean2422
      setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2822] (clojure.core/str arg2822))
 v2424))))
   (clojure.core/let
    [v2424
     (:product-description
      m2423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (.
      bean2422
      setProductDescription
      (ec2/riproduct-description v2424))))
   (clojure.core/let
    [v2424
     (:availability-zone
      m2423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setAvailabilityZone (clojure.core/str v2424))))
   (clojure.core/let
    [v2424
     (:min-duration m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setMinDuration (clojure.core/long v2424))))
   (clojure.core/let
    [v2424
     (:instance-type m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setInstanceType (ec2/instance-type v2424))))
   (clojure.core/let
    [v2424 (:filters m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (.
      bean2422
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2823] (ec2/filter arg2823))
 v2424))))
   (clojure.core/let
    [v2424
     (:offering-type m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setOfferingType (clojure.core/str v2424))))
   (clojure.core/let
    [v2424
     (:instance-tenancy
      m2423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setInstanceTenancy (ec2/tenancy v2424))))
   (clojure.core/let
    [v2424
     (:max-duration m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setMaxDuration (clojure.core/long v2424))))
   (clojure.core/let
    [v2424
     (:next-token m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setNextToken (clojure.core/str v2424))))
   (clojure.core/let
    [v2424
     (:max-results m2423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setMaxResults (clojure.core/int v2424))))
   (clojure.core/let
    [v2424
     (:max-instance-count
      m2423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2424 :com.palletops.awaze.client-builder/undef)
     (. bean2422 setMaxInstanceCount (clojure.core/int v2424))))
   bean2422))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m2426]
  (clojure.core/let
   [bean2425
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/let
    [v2427
     (:availability-zone
      m2426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2427 :com.palletops.awaze.client-builder/undef)
     (. bean2425 setAvailabilityZone (clojure.core/str v2427))))
   (clojure.core/let
    [v2427 (:type m2426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2427 :com.palletops.awaze.client-builder/undef)
     (. bean2425 setType (clojure.core/str v2427))))
   bean2425))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m2429]
  (clojure.core/let
   [bean2428
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/let
    [v2430
     (:route-table-ids
      m2429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2430 :com.palletops.awaze.client-builder/undef)
     (.
      bean2428
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2824] (clojure.core/str arg2824))
 v2430))))
   (clojure.core/let
    [v2430 (:filters m2429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2430 :com.palletops.awaze.client-builder/undef)
     (.
      bean2428
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2825] (ec2/filter arg2825))
 v2430))))
   bean2428))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m2432]
  (clojure.core/let
   [bean2431
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2433
     (:spot-instance-request-ids
      m2432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2433 :com.palletops.awaze.client-builder/undef)
     (.
      bean2431
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2826] (clojure.core/str arg2826))
 v2433))))
   bean2431))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m2435]
  (clojure.core/let
   [bean2434
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2436
     (:network-interface-id
      m2435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2436 :com.palletops.awaze.client-builder/undef)
     (. bean2434 setNetworkInterfaceId (clojure.core/str v2436))))
   (clojure.core/let
    [v2436
     (:private-ip-addresses
      m2435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2436 :com.palletops.awaze.client-builder/undef)
     (.
      bean2434
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2827] (clojure.core/str arg2827))
 v2436))))
   (clojure.core/let
    [v2436
     (:secondary-private-ip-address-count
      m2435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2436 :com.palletops.awaze.client-builder/undef)
     (.
      bean2434
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2436))))
   (clojure.core/let
    [v2436
     (:allow-reassignment
      m2435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2436 :com.palletops.awaze.client-builder/undef)
     (. bean2434 setAllowReassignment (clojure.core/boolean v2436))))
   bean2434))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest}
disable-vpc-classic-link-dns-support-request
  [m2438]
  (clojure.core/let
   [bean2437
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2439 (:vpc-id m2438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2439 :com.palletops.awaze.client-builder/undef)
     (. bean2437 setVpcId (clojure.core/str v2439))))
   bean2437))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m2441]
  (clojure.core/let
   [bean2440
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/let
    [v2442
     (:group-name m2441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2442 :com.palletops.awaze.client-builder/undef)
     (. bean2440 setGroupName (clojure.core/str v2442))))
   bean2440))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m2444]
  (clojure.core/let
   [bean2443
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/let
    [v2445 (:filters m2444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2445 :com.palletops.awaze.client-builder/undef)
     (.
      bean2443
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2828] (ec2/filter arg2828))
 v2445))))
   (clojure.core/let
    [v2445
     (:instance-ids m2444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2445 :com.palletops.awaze.client-builder/undef)
     (.
      bean2443
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2829] (clojure.core/str arg2829))
 v2445))))
   (clojure.core/let
    [v2445
     (:next-token m2444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2445 :com.palletops.awaze.client-builder/undef)
     (. bean2443 setNextToken (clojure.core/str v2445))))
   (clojure.core/let
    [v2445
     (:max-results m2444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2445 :com.palletops.awaze.client-builder/undef)
     (. bean2443 setMaxResults (clojure.core/int v2445))))
   bean2443))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m2447]
  (clojure.core/let
   [bean2446
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/let
    [v2448 (:filters m2447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2448 :com.palletops.awaze.client-builder/undef)
     (.
      bean2446
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2830] (ec2/filter arg2830))
 v2448))))
   (clojure.core/let
    [v2448
     (:next-token m2447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2448 :com.palletops.awaze.client-builder/undef)
     (. bean2446 setNextToken (clojure.core/str v2448))))
   (clojure.core/let
    [v2448
     (:max-results m2447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2448 :com.palletops.awaze.client-builder/undef)
     (. bean2446 setMaxResults (clojure.core/int v2448))))
   (clojure.core/let
    [v2448
     (:volume-ids m2447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2448 :com.palletops.awaze.client-builder/undef)
     (.
      bean2446
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2831] (clojure.core/str arg2831))
 v2448))))
   bean2446))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m2450]
  (clojure.core/let
   [bean2449
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/let
    [v2451 (:filters m2450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2451 :com.palletops.awaze.client-builder/undef)
     (.
      bean2449
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2832] (ec2/filter arg2832))
 v2451))))
   (clojure.core/let
    [v2451
     (:bundle-ids m2450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2451 :com.palletops.awaze.client-builder/undef)
     (.
      bean2449
      setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2833] (clojure.core/str arg2833))
 v2451))))
   bean2449))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m2453]
  (clojure.core/let
   [bean2452
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/let
    [v2454 (:vpc-id m2453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2454 :com.palletops.awaze.client-builder/undef)
     (. bean2452 setVpcId (clojure.core/str v2454))))
   (clojure.core/let
    [v2454
     (:dhcp-options-id
      m2453
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2454 :com.palletops.awaze.client-builder/undef)
     (. bean2452 setDhcpOptionsId (clojure.core/str v2454))))
   bean2452))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m2456]
  (clojure.core/let
   [bean2455
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/let
    [v2457 (:vpc-id m2456 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2457 :com.palletops.awaze.client-builder/undef)
     (. bean2455 setVpcId (clojure.core/str v2457))))
   (clojure.core/let
    [v2457
     (:enable-dns-support
      m2456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2457 :com.palletops.awaze.client-builder/undef)
     (. bean2455 setEnableDnsSupport (clojure.core/boolean v2457))))
   (clojure.core/let
    [v2457
     (:enable-dns-hostnames
      m2456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2457 :com.palletops.awaze.client-builder/undef)
     (. bean2455 setEnableDnsHostnames (clojure.core/boolean v2457))))
   bean2455))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateFlowLogsRequest}
create-flow-logs-request
  [m2459]
  (clojure.core/let
   [bean2458
    (new com.amazonaws.services.ec2.model.CreateFlowLogsRequest)]
   (clojure.core/let
    [v2460
     (:client-token m2459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2460 :com.palletops.awaze.client-builder/undef)
     (. bean2458 setClientToken (clojure.core/str v2460))))
   (clojure.core/let
    [v2460
     (:resource-ids m2459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2460 :com.palletops.awaze.client-builder/undef)
     (.
      bean2458
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2834] (clojure.core/str arg2834))
 v2460))))
   (clojure.core/let
    [v2460
     (:resource-type m2459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2460 :com.palletops.awaze.client-builder/undef)
     (. bean2458 setResourceType (ec2/flow-logs-resource-type v2460))))
   (clojure.core/let
    [v2460
     (:traffic-type m2459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2460 :com.palletops.awaze.client-builder/undef)
     (. bean2458 setTrafficType (ec2/traffic-type v2460))))
   (clojure.core/let
    [v2460
     (:log-group-name m2459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2460 :com.palletops.awaze.client-builder/undef)
     (. bean2458 setLogGroupName (clojure.core/str v2460))))
   (clojure.core/let
    [v2460
     (:deliver-logs-permission-arn
      m2459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2460 :com.palletops.awaze.client-builder/undef)
     (. bean2458 setDeliverLogsPermissionArn (clojure.core/str v2460))))
   bean2458))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m2462]
  (clojure.core/let
   [bean2461
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/let
    [v2463
     (:public-ip m2462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2463 :com.palletops.awaze.client-builder/undef)
     (. bean2461 setPublicIp (clojure.core/str v2463))))
   (clojure.core/let
    [v2463
     (:association-id m2462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2463 :com.palletops.awaze.client-builder/undef)
     (. bean2461 setAssociationId (clojure.core/str v2463))))
   bean2461))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m2465]
  (clojure.core/let
   [bean2464
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2466
     (:network-interface-id
      m2465
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2466 :com.palletops.awaze.client-builder/undef)
     (. bean2464 setNetworkInterfaceId (clojure.core/str v2466))))
   (clojure.core/let
    [v2466
     (:source-dest-check
      m2465
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2466 :com.palletops.awaze.client-builder/undef)
     (. bean2464 setSourceDestCheck (clojure.core/str v2466))))
   bean2464))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m2468]
  (clojure.core/let
   [bean2467
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/let
    [v2469 (:filters m2468 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2469 :com.palletops.awaze.client-builder/undef)
     (.
      bean2467
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2835] (ec2/filter arg2835))
 v2469))))
   (clojure.core/let
    [v2469
     (:group-names m2468 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2469 :com.palletops.awaze.client-builder/undef)
     (.
      bean2467
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2836] (clojure.core/str arg2836))
 v2469))))
   bean2467))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m2471]
  (clojure.core/let
   [bean2470
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/let
    [v2472
     (:snapshot-id m2471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2472 :com.palletops.awaze.client-builder/undef)
     (. bean2470 setSnapshotId (clojure.core/str v2472))))
   (clojure.core/let
    [v2472
     (:attribute m2471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2472 :com.palletops.awaze.client-builder/undef)
     (. bean2470 setAttribute (ec2/snapshot-attribute-name v2472))))
   bean2470))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m2474]
  (clojure.core/let
   [bean2473
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/let
    [v2475
     (:public-ip m2474 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2475 :com.palletops.awaze.client-builder/undef)
     (. bean2473 setPublicIp (clojure.core/str v2475))))
   (clojure.core/let
    [v2475
     (:allocation-id m2474 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2475 :com.palletops.awaze.client-builder/undef)
     (. bean2473 setAllocationId (clojure.core/str v2475))))
   bean2473))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m2477]
  (clojure.core/let
   [bean2476
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/let
    [v2478 (:filters m2477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2478 :com.palletops.awaze.client-builder/undef)
     (.
      bean2476
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2837] (ec2/filter arg2837))
 v2478))))
   (clojure.core/let
    [v2478
     (:next-token m2477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2478 :com.palletops.awaze.client-builder/undef)
     (. bean2476 setNextToken (clojure.core/str v2478))))
   (clojure.core/let
    [v2478
     (:max-results m2477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2478 :com.palletops.awaze.client-builder/undef)
     (. bean2476 setMaxResults (clojure.core/int v2478))))
   (clojure.core/let
    [v2478
     (:volume-ids m2477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2478 :com.palletops.awaze.client-builder/undef)
     (.
      bean2476
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2838] (clojure.core/str arg2838))
 v2478))))
   bean2476))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m2480]
  (clojure.core/let
   [bean2479
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/let
    [v2481
     (:instance-id m2480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2481 :com.palletops.awaze.client-builder/undef)
     (. bean2479 setInstanceId (clojure.core/str v2481))))
   (clojure.core/let
    [v2481 (:storage m2480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2481 :com.palletops.awaze.client-builder/undef)
     (. bean2479 setStorage (ec2/storage v2481))))
   bean2479))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m2483]
  (clojure.core/let
   [bean2482
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/let
    [v2484 (:filters m2483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2484 :com.palletops.awaze.client-builder/undef)
     (.
      bean2482
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2839] (ec2/filter arg2839))
 v2484))))
   (clojure.core/let
    [v2484
     (:vpn-connection-ids
      m2483
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2484 :com.palletops.awaze.client-builder/undef)
     (.
      bean2482
      setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2840] (clojure.core/str arg2840))
 v2484))))
   bean2482))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m2486]
  (clojure.core/let
   [bean2485
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/let
    [v2487
     (:vpc-peering-connection-id
      m2486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setVpcPeeringConnectionId (clojure.core/str v2487))))
   (clojure.core/let
    [v2487
     (:network-interface-id
      m2486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setNetworkInterfaceId (clojure.core/str v2487))))
   (clojure.core/let
    [v2487
     (:instance-id m2486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setInstanceId (clojure.core/str v2487))))
   (clojure.core/let
    [v2487
     (:route-table-id m2486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setRouteTableId (clojure.core/str v2487))))
   (clojure.core/let
    [v2487
     (:destination-cidr-block
      m2486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setDestinationCidrBlock (clojure.core/str v2487))))
   (clojure.core/let
    [v2487
     (:gateway-id m2486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setGatewayId (clojure.core/str v2487))))
   (clojure.core/let
    [v2487
     (:nat-gateway-id m2486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2487 :com.palletops.awaze.client-builder/undef)
     (. bean2485 setNatGatewayId (clojure.core/str v2487))))
   bean2485))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m2489]
  (clojure.core/let
   [bean2488
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/let
    [v2490
     (:availability-zone
      m2489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (. bean2488 setAvailabilityZone (clojure.core/str v2490))))
   (clojure.core/let
    [v2490 (:filters m2489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (.
      bean2488
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2841] (ec2/filter arg2841))
 v2490))))
   (clojure.core/let
    [v2490
     (:next-token m2489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (. bean2488 setNextToken (clojure.core/str v2490))))
   (clojure.core/let
    [v2490
     (:max-results m2489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (. bean2488 setMaxResults (clojure.core/int v2490))))
   (clojure.core/let
    [v2490
     (:start-time m2489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (.
      bean2488
      setStartTime
      (com.palletops.awaze.common/to-date v2490))))
   (clojure.core/let
    [v2490
     (:end-time m2489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (.
      bean2488
      setEndTime
      (com.palletops.awaze.common/to-date v2490))))
   (clojure.core/let
    [v2490
     (:instance-types m2489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (.
      bean2488
      setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2842] (clojure.core/str arg2842))
 v2490))))
   (clojure.core/let
    [v2490
     (:product-descriptions
      m2489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2490 :com.palletops.awaze.client-builder/undef)
     (.
      bean2488
      setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2843] (clojure.core/str arg2843))
 v2490))))
   bean2488))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m2492]
  (clojure.core/let
   [bean2491
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/let
    [v2493
     (:zone-names m2492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2493 :com.palletops.awaze.client-builder/undef)
     (.
      bean2491
      setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2844] (clojure.core/str arg2844))
 v2493))))
   (clojure.core/let
    [v2493 (:filters m2492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2493 :com.palletops.awaze.client-builder/undef)
     (.
      bean2491
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2845] (ec2/filter arg2845))
 v2493))))
   bean2491))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m2495]
  (clojure.core/let
   [bean2494
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2496 (:vpc-id m2495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2496 :com.palletops.awaze.client-builder/undef)
     (. bean2494 setVpcId (clojure.core/str v2496))))
   (clojure.core/let
    [v2496
     (:peer-vpc-id m2495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2496 :com.palletops.awaze.client-builder/undef)
     (. bean2494 setPeerVpcId (clojure.core/str v2496))))
   (clojure.core/let
    [v2496
     (:peer-owner-id m2495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2496 :com.palletops.awaze.client-builder/undef)
     (. bean2494 setPeerOwnerId (clojure.core/str v2496))))
   bean2494))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m2498]
  (clojure.core/let
   [bean2497
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/let
    [v2499 (:filters m2498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2499 :com.palletops.awaze.client-builder/undef)
     (.
      bean2497
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2846] (ec2/filter arg2846))
 v2499))))
   (clojure.core/let
    [v2499
     (:internet-gateway-ids
      m2498
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2499 :com.palletops.awaze.client-builder/undef)
     (.
      bean2497
      setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2847] (clojure.core/str arg2847))
 v2499))))
   bean2497))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m2501]
  (clojure.core/let
   [bean2500
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/let
    [v2502
     (:association-id m2501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2502 :com.palletops.awaze.client-builder/undef)
     (. bean2500 setAssociationId (clojure.core/str v2502))))
   bean2500))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m2504]
  (clojure.core/let
   [bean2503
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/let
    [v2505 (:filters m2504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2505 :com.palletops.awaze.client-builder/undef)
     (.
      bean2503
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2848] (ec2/filter arg2848))
 v2505))))
   (clojure.core/let
    [v2505
     (:region-names m2504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2505 :com.palletops.awaze.client-builder/undef)
     (.
      bean2503
      setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2849] (clojure.core/str arg2849))
 v2505))))
   bean2503))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest}
enable-vpc-classic-link-dns-support-request
  [m2507]
  (clojure.core/let
   [bean2506
    (new
     com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2508 (:vpc-id m2507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2508 :com.palletops.awaze.client-builder/undef)
     (. bean2506 setVpcId (clojure.core/str v2508))))
   bean2506))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m2510]
  (clojure.core/let
   [bean2509
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/let
    [v2511
     (:image-id m2510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2511 :com.palletops.awaze.client-builder/undef)
     (. bean2509 setImageId (clojure.core/str v2511))))
   bean2509))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m2513]
  (clojure.core/let
   [bean2512
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean2512))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m2516]
  (clojure.core/let
   [bean2515
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/let
    [v2517 (:filters m2516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2517 :com.palletops.awaze.client-builder/undef)
     (.
      bean2515
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2850] (ec2/filter arg2850))
 v2517))))
   (clojure.core/let
    [v2517
     (:customer-gateway-ids
      m2516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2517 :com.palletops.awaze.client-builder/undef)
     (.
      bean2515
      setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2851] (clojure.core/str arg2851))
 v2517))))
   bean2515))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest}
describe-spot-fleet-request-history-request
  [m2519]
  (clojure.core/let
   [bean2518
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest)]
   (clojure.core/let
    [v2520
     (:next-token m2519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2520 :com.palletops.awaze.client-builder/undef)
     (. bean2518 setNextToken (clojure.core/str v2520))))
   (clojure.core/let
    [v2520
     (:max-results m2519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2520 :com.palletops.awaze.client-builder/undef)
     (. bean2518 setMaxResults (clojure.core/int v2520))))
   (clojure.core/let
    [v2520
     (:spot-fleet-request-id
      m2519
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2520 :com.palletops.awaze.client-builder/undef)
     (. bean2518 setSpotFleetRequestId (clojure.core/str v2520))))
   (clojure.core/let
    [v2520
     (:event-type m2519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2520 :com.palletops.awaze.client-builder/undef)
     (. bean2518 setEventType (clojure.core/str v2520))))
   (clojure.core/let
    [v2520
     (:start-time m2519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2520 :com.palletops.awaze.client-builder/undef)
     (.
      bean2518
      setStartTime
      (com.palletops.awaze.common/to-date v2520))))
   bean2518))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m2522]
  (clojure.core/let
   [bean2521
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/let
    [v2523 (:vpc-id m2522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2523 :com.palletops.awaze.client-builder/undef)
     (. bean2521 setVpcId (clojure.core/str v2523))))
   (clojure.core/let
    [v2523
     (:availability-zone
      m2522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2523 :com.palletops.awaze.client-builder/undef)
     (. bean2521 setAvailabilityZone (clojure.core/str v2523))))
   (clojure.core/let
    [v2523
     (:cidr-block m2522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2523 :com.palletops.awaze.client-builder/undef)
     (. bean2521 setCidrBlock (clojure.core/str v2523))))
   bean2521))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m2525]
  (clojure.core/let
   [bean2524
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2526
     (:network-interface-id
      m2525
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2526 :com.palletops.awaze.client-builder/undef)
     (. bean2524 setNetworkInterfaceId (clojure.core/str v2526))))
   (clojure.core/let
    [v2526
     (:attribute m2525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2526 :com.palletops.awaze.client-builder/undef)
     (. bean2524 setAttribute (clojure.core/str v2526))))
   bean2524))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest}
modify-instance-placement-request
  [m2528]
  (clojure.core/let
   [bean2527
    (new
     com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest)]
   (clojure.core/let
    [v2529
     (:instance-id m2528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2529 :com.palletops.awaze.client-builder/undef)
     (. bean2527 setInstanceId (clojure.core/str v2529))))
   (clojure.core/let
    [v2529 (:tenancy m2528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2529 :com.palletops.awaze.client-builder/undef)
     (. bean2527 setTenancy (ec2/host-tenancy v2529))))
   (clojure.core/let
    [v2529
     (:affinity m2528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2529 :com.palletops.awaze.client-builder/undef)
     (. bean2527 setAffinity (clojure.core/str v2529))))
   (clojure.core/let
    [v2529 (:host-id m2528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2529 :com.palletops.awaze.client-builder/undef)
     (. bean2527 setHostId (clojure.core/str v2529))))
   bean2527))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest}
detach-classic-link-vpc-request
  [m2531]
  (clojure.core/let
   [bean2530
    (new com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2532 (:vpc-id m2531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2532 :com.palletops.awaze.client-builder/undef)
     (. bean2530 setVpcId (clojure.core/str v2532))))
   (clojure.core/let
    [v2532
     (:instance-id m2531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2532 :com.palletops.awaze.client-builder/undef)
     (. bean2530 setInstanceId (clojure.core/str v2532))))
   bean2530))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m2534]
  (clojure.core/let
   [bean2533
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/let
    [v2535
     (:conversion-task-id
      m2534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2535 :com.palletops.awaze.client-builder/undef)
     (. bean2533 setConversionTaskId (clojure.core/str v2535))))
   (clojure.core/let
    [v2535
     (:reason-message m2534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2535 :com.palletops.awaze.client-builder/undef)
     (. bean2533 setReasonMessage (clojure.core/str v2535))))
   bean2533))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m2537]
  (clojure.core/let
   [bean2536
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/let
    [v2538
     (:private-ip-addresses
      m2537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2538 :com.palletops.awaze.client-builder/undef)
     (.
      bean2536
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2852]
  (ec2/private-ip-address-specification arg2852))
 v2538))))
   (clojure.core/let
    [v2538
     (:secondary-private-ip-address-count
      m2537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2538 :com.palletops.awaze.client-builder/undef)
     (.
      bean2536
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2538))))
   (clojure.core/let
    [v2538
     (:private-ip-address
      m2537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2538 :com.palletops.awaze.client-builder/undef)
     (. bean2536 setPrivateIpAddress (clojure.core/str v2538))))
   (clojure.core/let
    [v2538
     (:subnet-id m2537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2538 :com.palletops.awaze.client-builder/undef)
     (. bean2536 setSubnetId (clojure.core/str v2538))))
   (clojure.core/let
    [v2538 (:groups m2537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2538 :com.palletops.awaze.client-builder/undef)
     (.
      bean2536
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2853] (clojure.core/str arg2853))
 v2538))))
   (clojure.core/let
    [v2538
     (:description m2537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2538 :com.palletops.awaze.client-builder/undef)
     (. bean2536 setDescription (clojure.core/str v2538))))
   bean2536))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m2540]
  (clojure.core/let
   [bean2539
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/let
    [v2541
     (:description m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (. bean2539 setDescription (clojure.core/str v2541))))
   (clojure.core/let
    [v2541
     (:operation-type m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (. bean2539 setOperationType (ec2/operation-type v2541))))
   (clojure.core/let
    [v2541
     (:product-codes m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (.
      bean2539
      setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2854] (clojure.core/str arg2854))
 v2541))))
   (clojure.core/let
    [v2541
     (:user-ids m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (.
      bean2539
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2855] (clojure.core/str arg2855))
 v2541))))
   (clojure.core/let
    [v2541
     (:attribute m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (. bean2539 setAttribute (clojure.core/str v2541))))
   (clojure.core/let
    [v2541
     (:image-id m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (. bean2539 setImageId (clojure.core/str v2541))))
   (clojure.core/let
    [v2541
     (:launch-permission
      m2540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (.
      bean2539
      setLaunchPermission
      (ec2/launch-permission-modifications v2541))))
   (clojure.core/let
    [v2541 (:value m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (. bean2539 setValue (clojure.core/str v2541))))
   (clojure.core/let
    [v2541
     (:user-groups m2540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2541 :com.palletops.awaze.client-builder/undef)
     (.
      bean2539
      setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2856] (clojure.core/str arg2856))
 v2541))))
   bean2539))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m2543]
  (clojure.core/let
   [bean2542
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/let
    [v2544
     (:route-table-id m2543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2544 :com.palletops.awaze.client-builder/undef)
     (. bean2542 setRouteTableId (clojure.core/str v2544))))
   bean2542))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m2546]
  (clojure.core/let
   [bean2545
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/let
    [v2547
     (:subnet-id m2546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2547 :com.palletops.awaze.client-builder/undef)
     (. bean2545 setSubnetId (clojure.core/str v2547))))
   (clojure.core/let
    [v2547
     (:route-table-id m2546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2547 :com.palletops.awaze.client-builder/undef)
     (. bean2545 setRouteTableId (clojure.core/str v2547))))
   bean2545))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m2549]
  (clojure.core/let
   [bean2548
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/let
    [v2550
     (:customer-gateway-id
      m2549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2550 :com.palletops.awaze.client-builder/undef)
     (. bean2548 setCustomerGatewayId (clojure.core/str v2550))))
   bean2548))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m2552]
  (clojure.core/let
   [bean2551
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/let
    [v2553
     (:route-table-id m2552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2553 :com.palletops.awaze.client-builder/undef)
     (. bean2551 setRouteTableId (clojure.core/str v2553))))
   (clojure.core/let
    [v2553
     (:association-id m2552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2553 :com.palletops.awaze.client-builder/undef)
     (. bean2551 setAssociationId (clojure.core/str v2553))))
   bean2551))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m2555]
  (clojure.core/let
   [bean2554 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/let
    [v2556 (:vpc-id m2555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2556 :com.palletops.awaze.client-builder/undef)
     (. bean2554 setVpcId (clojure.core/str v2556))))
   bean2554))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m2558]
  (clojure.core/let
   [bean2557
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/let
    [v2559
     (:key-name m2558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2559 :com.palletops.awaze.client-builder/undef)
     (. bean2557 setKeyName (clojure.core/str v2559))))
   bean2557))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateHostsRequest}
allocate-hosts-request
  [m2561]
  (clojure.core/let
   [bean2560
    (new com.amazonaws.services.ec2.model.AllocateHostsRequest)]
   (clojure.core/let
    [v2562
     (:auto-placement m2561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2562 :com.palletops.awaze.client-builder/undef)
     (. bean2560 setAutoPlacement (clojure.core/str v2562))))
   (clojure.core/let
    [v2562
     (:instance-type m2561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2562 :com.palletops.awaze.client-builder/undef)
     (. bean2560 setInstanceType (clojure.core/str v2562))))
   (clojure.core/let
    [v2562
     (:client-token m2561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2562 :com.palletops.awaze.client-builder/undef)
     (. bean2560 setClientToken (clojure.core/str v2562))))
   (clojure.core/let
    [v2562
     (:quantity m2561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2562 :com.palletops.awaze.client-builder/undef)
     (. bean2560 setQuantity (clojure.core/int v2562))))
   (clojure.core/let
    [v2562
     (:availability-zone
      m2561
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2562 :com.palletops.awaze.client-builder/undef)
     (. bean2560 setAvailabilityZone (clojure.core/str v2562))))
   bean2560))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m2564]
  (clojure.core/let
   [bean2563
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/let
    [v2565
     (:vpc-peering-connection-id
      m2564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setVpcPeeringConnectionId (clojure.core/str v2565))))
   (clojure.core/let
    [v2565
     (:network-interface-id
      m2564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setNetworkInterfaceId (clojure.core/str v2565))))
   (clojure.core/let
    [v2565
     (:instance-id m2564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setInstanceId (clojure.core/str v2565))))
   (clojure.core/let
    [v2565
     (:route-table-id m2564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setRouteTableId (clojure.core/str v2565))))
   (clojure.core/let
    [v2565
     (:destination-cidr-block
      m2564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setDestinationCidrBlock (clojure.core/str v2565))))
   (clojure.core/let
    [v2565
     (:gateway-id m2564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setGatewayId (clojure.core/str v2565))))
   (clojure.core/let
    [v2565
     (:nat-gateway-id m2564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2565 :com.palletops.awaze.client-builder/undef)
     (. bean2563 setNatGatewayId (clojure.core/str v2565))))
   bean2563))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m2567]
  (clojure.core/let
   [bean2566
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/let
    [v2568
     (:instance-ids m2567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2568 :com.palletops.awaze.client-builder/undef)
     (.
      bean2566
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2857] (clojure.core/str arg2857))
 v2568))))
   bean2566))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m2570]
  (clojure.core/let
   [bean2569
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v2571 (:filters m2570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2571 :com.palletops.awaze.client-builder/undef)
     (.
      bean2569
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2858] (ec2/filter arg2858))
 v2571))))
   (clojure.core/let
    [v2571
     (:next-token m2570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2571 :com.palletops.awaze.client-builder/undef)
     (. bean2569 setNextToken (clojure.core/str v2571))))
   (clojure.core/let
    [v2571
     (:max-results m2570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2571 :com.palletops.awaze.client-builder/undef)
     (. bean2569 setMaxResults (clojure.core/int v2571))))
   (clojure.core/let
    [v2571
     (:snapshot-ids m2570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2571 :com.palletops.awaze.client-builder/undef)
     (.
      bean2569
      setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2859] (clojure.core/str arg2859))
 v2571))))
   (clojure.core/let
    [v2571
     (:owner-ids m2570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2571 :com.palletops.awaze.client-builder/undef)
     (.
      bean2569
      setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2860] (clojure.core/str arg2860))
 v2571))))
   (clojure.core/let
    [v2571
     (:restorable-by-user-ids
      m2570
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2571 :com.palletops.awaze.client-builder/undef)
     (.
      bean2569
      setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2861] (clojure.core/str arg2861))
 v2571))))
   bean2569))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m2573]
  (clojure.core/let
   [bean2572
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/let
    [v2574 (:filters m2573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2574 :com.palletops.awaze.client-builder/undef)
     (.
      bean2572
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2862] (ec2/filter arg2862))
 v2574))))
   (clojure.core/let
    [v2574
     (:vpn-gateway-ids
      m2573
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2574 :com.palletops.awaze.client-builder/undef)
     (.
      bean2572
      setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2863] (clojure.core/str arg2863))
 v2574))))
   bean2572))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m2576]
  (clojure.core/let
   [bean2575
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/let
    [v2577
     (:instance-id m2576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2577 :com.palletops.awaze.client-builder/undef)
     (. bean2575 setInstanceId (clojure.core/str v2577))))
   bean2575))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m2579]
  (clojure.core/let
   [bean2578
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/let
    [v2580
     (:volume-id m2579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2580 :com.palletops.awaze.client-builder/undef)
     (. bean2578 setVolumeId (clojure.core/str v2580))))
   (clojure.core/let
    [v2580
     (:auto-enable-io m2579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2580 :com.palletops.awaze.client-builder/undef)
     (. bean2578 setAutoEnableIO (clojure.core/boolean v2580))))
   bean2578))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m2582]
  (clojure.core/let
   [bean2581
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2583
     (:route-table-id m2582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2583 :com.palletops.awaze.client-builder/undef)
     (. bean2581 setRouteTableId (clojure.core/str v2583))))
   (clojure.core/let
    [v2583
     (:gateway-id m2582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2583 :com.palletops.awaze.client-builder/undef)
     (. bean2581 setGatewayId (clojure.core/str v2583))))
   bean2581))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest}
describe-spot-fleet-instances-request
  [m2585]
  (clojure.core/let
   [bean2584
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest)]
   (clojure.core/let
    [v2586
     (:next-token m2585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2586 :com.palletops.awaze.client-builder/undef)
     (. bean2584 setNextToken (clojure.core/str v2586))))
   (clojure.core/let
    [v2586
     (:max-results m2585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2586 :com.palletops.awaze.client-builder/undef)
     (. bean2584 setMaxResults (clojure.core/int v2586))))
   (clojure.core/let
    [v2586
     (:spot-fleet-request-id
      m2585
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2586 :com.palletops.awaze.client-builder/undef)
     (. bean2584 setSpotFleetRequestId (clojure.core/str v2586))))
   bean2584))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePrefixListsRequest}
describe-prefix-lists-request
  [m2588]
  (clojure.core/let
   [bean2587
    (new com.amazonaws.services.ec2.model.DescribePrefixListsRequest)]
   (clojure.core/let
    [v2589 (:filters m2588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2589 :com.palletops.awaze.client-builder/undef)
     (.
      bean2587
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2864] (ec2/filter arg2864))
 v2589))))
   (clojure.core/let
    [v2589
     (:next-token m2588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2589 :com.palletops.awaze.client-builder/undef)
     (. bean2587 setNextToken (clojure.core/str v2589))))
   (clojure.core/let
    [v2589
     (:max-results m2588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2589 :com.palletops.awaze.client-builder/undef)
     (. bean2587 setMaxResults (clojure.core/int v2589))))
   (clojure.core/let
    [v2589
     (:prefix-list-ids
      m2588
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2589 :com.palletops.awaze.client-builder/undef)
     (.
      bean2587
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2865] (clojure.core/str arg2865))
 v2589))))
   bean2587))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m2591]
  (clojure.core/let
   [bean2590
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/let
    [v2592
     (:attribute-names
      m2591
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2592 :com.palletops.awaze.client-builder/undef)
     (.
      bean2590
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2866] (clojure.core/str arg2866))
 v2592))))
   bean2590))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m2594]
  (clojure.core/let
   [bean2593
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/let
    [v2595
     (:vpn-gateway-id m2594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2595 :com.palletops.awaze.client-builder/undef)
     (. bean2593 setVpnGatewayId (clojure.core/str v2595))))
   (clojure.core/let
    [v2595 (:type m2594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2595 :com.palletops.awaze.client-builder/undef)
     (. bean2593 setType (clojure.core/str v2595))))
   (clojure.core/let
    [v2595
     (:customer-gateway-id
      m2594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2595 :com.palletops.awaze.client-builder/undef)
     (. bean2593 setCustomerGatewayId (clojure.core/str v2595))))
   (clojure.core/let
    [v2595 (:options m2594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2595 :com.palletops.awaze.client-builder/undef)
     (.
      bean2593
      setOptions
      (ec2/vpn-connection-options-specification v2595))))
   bean2593))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m2597]
  (clojure.core/let
   [bean2596
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/let
    [v2598 (:filters m2597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2598 :com.palletops.awaze.client-builder/undef)
     (.
      bean2596
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2867] (ec2/filter arg2867))
 v2598))))
   (clojure.core/let
    [v2598
     (:vpc-peering-connection-ids
      m2597
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2598 :com.palletops.awaze.client-builder/undef)
     (.
      bean2596
      setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2868] (clojure.core/str arg2868))
 v2598))))
   bean2596))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest}
describe-scheduled-instance-availability-request
  [m2600]
  (clojure.core/let
   [bean2599
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)]
   (clojure.core/let
    [v2601 (:filters m2600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (.
      bean2599
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2869] (ec2/filter arg2869))
 v2601))))
   (clojure.core/let
    [v2601
     (:next-token m2600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (. bean2599 setNextToken (clojure.core/str v2601))))
   (clojure.core/let
    [v2601
     (:max-results m2600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (. bean2599 setMaxResults (clojure.core/int v2601))))
   (clojure.core/let
    [v2601
     (:recurrence m2600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (.
      bean2599
      setRecurrence
      (ec2/scheduled-instance-recurrence-request v2601))))
   (clojure.core/let
    [v2601
     (:first-slot-start-time-range
      m2600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (.
      bean2599
      setFirstSlotStartTimeRange
      (ec2/slot-date-time-range-request v2601))))
   (clojure.core/let
    [v2601
     (:min-slot-duration-in-hours
      m2600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (. bean2599 setMinSlotDurationInHours (clojure.core/int v2601))))
   (clojure.core/let
    [v2601
     (:max-slot-duration-in-hours
      m2600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2601 :com.palletops.awaze.client-builder/undef)
     (. bean2599 setMaxSlotDurationInHours (clojure.core/int v2601))))
   bean2599))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeFlowLogsRequest}
describe-flow-logs-request
  [m2603]
  (clojure.core/let
   [bean2602
    (new com.amazonaws.services.ec2.model.DescribeFlowLogsRequest)]
   (clojure.core/let
    [v2604
     (:flow-log-ids m2603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2604 :com.palletops.awaze.client-builder/undef)
     (.
      bean2602
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2870] (clojure.core/str arg2870))
 v2604))))
   (clojure.core/let
    [v2604
     (:next-token m2603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2604 :com.palletops.awaze.client-builder/undef)
     (. bean2602 setNextToken (clojure.core/str v2604))))
   (clojure.core/let
    [v2604
     (:max-results m2603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2604 :com.palletops.awaze.client-builder/undef)
     (. bean2602 setMaxResults (clojure.core/int v2604))))
   (clojure.core/let
    [v2604 (:filter m2603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2604 :com.palletops.awaze.client-builder/undef)
     (.
      bean2602
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2871] (ec2/filter arg2871))
 v2604))))
   bean2602))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m2606]
  (clojure.core/let
   [bean2605
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/let
    [v2607
     (:bundle-id m2606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2607 :com.palletops.awaze.client-builder/undef)
     (. bean2605 setBundleId (clojure.core/str v2607))))
   bean2605))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m2609]
  (clojure.core/let
   [bean2608
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/let
    [v2610 (:filters m2609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2610 :com.palletops.awaze.client-builder/undef)
     (.
      bean2608
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2872] (ec2/filter arg2872))
 v2610))))
   (clojure.core/let
    [v2610
     (:reserved-instances-ids
      m2609
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2610 :com.palletops.awaze.client-builder/undef)
     (.
      bean2608
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2873] (clojure.core/str arg2873))
 v2610))))
   (clojure.core/let
    [v2610
     (:offering-type m2609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2610 :com.palletops.awaze.client-builder/undef)
     (. bean2608 setOfferingType (ec2/offering-type-values v2610))))
   bean2608))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m2612]
  (clojure.core/let
   [bean2611
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/let
    [v2613
     (:instance-ids m2612 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2613 :com.palletops.awaze.client-builder/undef)
     (.
      bean2611
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2874] (clojure.core/str arg2874))
 v2613))))
   bean2611))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m2615]
  (clojure.core/let
   [bean2614
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/let
    [v2616
     (:group-name m2615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2616 :com.palletops.awaze.client-builder/undef)
     (. bean2614 setGroupName (clojure.core/str v2616))))
   (clojure.core/let
    [v2616
     (:group-id m2615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2616 :com.palletops.awaze.client-builder/undef)
     (. bean2614 setGroupId (clojure.core/str v2616))))
   bean2614))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m2618]
  (clojure.core/let
   [bean2617
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/let
    [v2619 (:vpc-id m2618 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2619 :com.palletops.awaze.client-builder/undef)
     (. bean2617 setVpcId (clojure.core/str v2619))))
   (clojure.core/let
    [v2619
     (:attribute m2618 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2619 :com.palletops.awaze.client-builder/undef)
     (. bean2617 setAttribute (clojure.core/str v2619))))
   bean2617))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m2621]
  (clojure.core/let
   [bean2620
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/let
    [v2622 (:vpc-id m2621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2622 :com.palletops.awaze.client-builder/undef)
     (. bean2620 setVpcId (clojure.core/str v2622))))
   bean2620))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelImportTaskRequest}
cancel-import-task-request
  [m2624]
  (clojure.core/let
   [bean2623
    (new com.amazonaws.services.ec2.model.CancelImportTaskRequest)]
   (clojure.core/let
    [v2625
     (:import-task-id m2624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2625 :com.palletops.awaze.client-builder/undef)
     (. bean2623 setImportTaskId (clojure.core/str v2625))))
   (clojure.core/let
    [v2625
     (:cancel-reason m2624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2625 :com.palletops.awaze.client-builder/undef)
     (. bean2623 setCancelReason (clojure.core/str v2625))))
   bean2623))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m2627]
  (clojure.core/let
   [bean2626
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2628
     (:vpc-peering-connection-id
      m2627
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2628 :com.palletops.awaze.client-builder/undef)
     (. bean2626 setVpcPeeringConnectionId (clojure.core/str v2628))))
   bean2626))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest}
describe-vpc-endpoint-services-request
  [m2630]
  (clojure.core/let
   [bean2629
    (new
     com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest)]
   (clojure.core/let
    [v2631
     (:next-token m2630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2631 :com.palletops.awaze.client-builder/undef)
     (. bean2629 setNextToken (clojure.core/str v2631))))
   (clojure.core/let
    [v2631
     (:max-results m2630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2631 :com.palletops.awaze.client-builder/undef)
     (. bean2629 setMaxResults (clojure.core/int v2631))))
   bean2629))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m2633]
  (clojure.core/let
   [bean2632
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2634
     (:vpc-peering-connection-id
      m2633
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2634 :com.palletops.awaze.client-builder/undef)
     (. bean2632 setVpcPeeringConnectionId (clojure.core/str v2634))))
   bean2632))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m2636]
  (clojure.core/let
   [bean2635
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/let
    [v2637
     (:iam-instance-profile
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2637))))
   (clojure.core/let
    [v2637
     (:max-count m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setMaxCount (clojure.core/int v2637))))
   (clojure.core/let
    [v2637
     (:subnet-id m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setSubnetId (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:additional-info
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setAdditionalInfo (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:security-group-ids
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2875] (clojure.core/str arg2875))
 v2637))))
   (clojure.core/let
    [v2637
     (:placement m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setPlacement (ec2/placement v2637))))
   (clojure.core/let
    [v2637
     (:private-ip-address
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setPrivateIpAddress (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:client-token m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setClientToken (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:instance-type m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setInstanceType (ec2/instance-type v2637))))
   (clojure.core/let
    [v2637
     (:ebs-optimized m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setEbsOptimized (clojure.core/boolean v2637))))
   (clojure.core/let
    [v2637
     (:ramdisk-id m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setRamdiskId (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:instance-initiated-shutdown-behavior
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:disable-api-termination
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setDisableApiTermination
      (clojure.core/boolean v2637))))
   (clojure.core/let
    [v2637
     (:image-id m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setImageId (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:key-name m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setKeyName (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:min-count m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setMinCount (clojure.core/int v2637))))
   (clojure.core/let
    [v2637
     (:kernel-id m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setKernelId (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:monitoring m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setMonitoring (clojure.core/boolean v2637))))
   (clojure.core/let
    [v2637
     (:security-groups
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2876] (clojure.core/str arg2876))
 v2637))))
   (clojure.core/let
    [v2637
     (:block-device-mappings
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2877] (ec2/block-device-mapping arg2877))
 v2637))))
   (clojure.core/let
    [v2637
     (:user-data m2636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (. bean2635 setUserData (clojure.core/str v2637))))
   (clojure.core/let
    [v2637
     (:network-interfaces
      m2636
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2637 :com.palletops.awaze.client-builder/undef)
     (.
      bean2635
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2878]
  (ec2/instance-network-interface-specification arg2878))
 v2637))))
   bean2635))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m2639]
  (clojure.core/let
   [bean2638
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/let
    [v2640 (:filters m2639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2640 :com.palletops.awaze.client-builder/undef)
     (.
      bean2638
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2879] (ec2/filter arg2879))
 v2640))))
   (clojure.core/let
    [v2640
     (:instance-ids m2639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2640 :com.palletops.awaze.client-builder/undef)
     (.
      bean2638
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2880] (clojure.core/str arg2880))
 v2640))))
   (clojure.core/let
    [v2640
     (:next-token m2639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2640 :com.palletops.awaze.client-builder/undef)
     (. bean2638 setNextToken (clojure.core/str v2640))))
   (clojure.core/let
    [v2640
     (:max-results m2639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2640 :com.palletops.awaze.client-builder/undef)
     (. bean2638 setMaxResults (clojure.core/int v2640))))
   (clojure.core/let
    [v2640
     (:include-all-instances
      m2639
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2640 :com.palletops.awaze.client-builder/undef)
     (. bean2638 setIncludeAllInstances (clojure.core/boolean v2640))))
   bean2638))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest}
describe-vpc-classic-link-dns-support-request
  [m2642]
  (clojure.core/let
   [bean2641
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2643
     (:next-token m2642 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2643 :com.palletops.awaze.client-builder/undef)
     (. bean2641 setNextToken (clojure.core/str v2643))))
   (clojure.core/let
    [v2643
     (:max-results m2642 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2643 :com.palletops.awaze.client-builder/undef)
     (. bean2641 setMaxResults (clojure.core/int v2643))))
   (clojure.core/let
    [v2643 (:vpc-ids m2642 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2643 :com.palletops.awaze.client-builder/undef)
     (.
      bean2641
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2881] (clojure.core/str arg2881))
 v2643))))
   bean2641))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m2645]
  (clojure.core/let
   [bean2644
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2646
     (:network-interface-id
      m2645
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2646 :com.palletops.awaze.client-builder/undef)
     (. bean2644 setNetworkInterfaceId (clojure.core/str v2646))))
   (clojure.core/let
    [v2646
     (:private-ip-addresses
      m2645
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2646 :com.palletops.awaze.client-builder/undef)
     (.
      bean2644
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2882] (clojure.core/str arg2882))
 v2646))))
   bean2644))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m2648]
  (clojure.core/let
   [bean2647
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/let
    [v2649 (:filters m2648 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2649 :com.palletops.awaze.client-builder/undef)
     (.
      bean2647
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2883] (ec2/filter arg2883))
 v2649))))
   (clojure.core/let
    [v2649
     (:group-names m2648 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2649 :com.palletops.awaze.client-builder/undef)
     (.
      bean2647
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2884] (clojure.core/str arg2884))
 v2649))))
   (clojure.core/let
    [v2649
     (:group-ids m2648 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2649 :com.palletops.awaze.client-builder/undef)
     (.
      bean2647
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2885] (clojure.core/str arg2885))
 v2649))))
   bean2647))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m2651]
  (clojure.core/let
   [bean2650
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/let
    [v2652 (:filters m2651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2652 :com.palletops.awaze.client-builder/undef)
     (.
      bean2650
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2886] (ec2/filter arg2886))
 v2652))))
   (clojure.core/let
    [v2652
     (:network-interface-ids
      m2651
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2652 :com.palletops.awaze.client-builder/undef)
     (.
      bean2650
      setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2887] (clojure.core/str arg2887))
 v2652))))
   bean2650))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m2654]
  (clojure.core/let
   [bean2653
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/let
    [v2655
     (:public-ip m2654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2655 :com.palletops.awaze.client-builder/undef)
     (. bean2653 setPublicIp (clojure.core/str v2655))))
   (clojure.core/let
    [v2655 (:type m2654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2655 :com.palletops.awaze.client-builder/undef)
     (. bean2653 setType (clojure.core/str v2655))))
   (clojure.core/let
    [v2655 (:bgp-asn m2654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2655 :com.palletops.awaze.client-builder/undef)
     (. bean2653 setBgpAsn (clojure.core/int v2655))))
   bean2653))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m2657]
  (clojure.core/let
   [bean2656
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/let
    [v2658 (:filters m2657 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2658 :com.palletops.awaze.client-builder/undef)
     (.
      bean2656
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2888] (ec2/filter arg2888))
 v2658))))
   (clojure.core/let
    [v2658
     (:dhcp-options-ids
      m2657
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2658 :com.palletops.awaze.client-builder/undef)
     (.
      bean2656
      setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2889] (clojure.core/str arg2889))
 v2658))))
   bean2656))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m2660]
  (clojure.core/let
   [bean2659 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/let
    [v2661 (:tags m2660 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2661 :com.palletops.awaze.client-builder/undef)
     (.
      bean2659
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2890] (ec2/tag arg2890)) v2661))))
   (clojure.core/let
    [v2661
     (:resources m2660 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2661 :com.palletops.awaze.client-builder/undef)
     (.
      bean2659
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2891] (clojure.core/str arg2891))
 v2661))))
   bean2659))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m2663]
  (clojure.core/let
   [bean2662
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v2664
     (:volume-id m2663 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2664 :com.palletops.awaze.client-builder/undef)
     (. bean2662 setVolumeId (clojure.core/str v2664))))
   (clojure.core/let
    [v2664
     (:description m2663 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2664 :com.palletops.awaze.client-builder/undef)
     (. bean2662 setDescription (clojure.core/str v2664))))
   bean2662))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportImageRequest}
import-image-request
  [m2666]
  (clojure.core/let
   [bean2665
    (new com.amazonaws.services.ec2.model.ImportImageRequest)]
   (clojure.core/let
    [v2667
     (:description m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setDescription (clojure.core/str v2667))))
   (clojure.core/let
    [v2667
     (:disk-containers
      m2666
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (.
      bean2665
      setDiskContainers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2892] (ec2/image-disk-container arg2892))
 v2667))))
   (clojure.core/let
    [v2667
     (:client-data m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setClientData (ec2/client-data v2667))))
   (clojure.core/let
    [v2667
     (:client-token m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setClientToken (clojure.core/str v2667))))
   (clojure.core/let
    [v2667
     (:role-name m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setRoleName (clojure.core/str v2667))))
   (clojure.core/let
    [v2667
     (:hypervisor m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setHypervisor (clojure.core/str v2667))))
   (clojure.core/let
    [v2667
     (:platform m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setPlatform (clojure.core/str v2667))))
   (clojure.core/let
    [v2667
     (:license-type m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setLicenseType (clojure.core/str v2667))))
   (clojure.core/let
    [v2667
     (:architecture m2666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2667 :com.palletops.awaze.client-builder/undef)
     (. bean2665 setArchitecture (clojure.core/str v2667))))
   bean2665))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m2669]
  (clojure.core/let
   [bean2668
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/let
    [v2670 (:vpc-id m2669 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2670 :com.palletops.awaze.client-builder/undef)
     (. bean2668 setVpcId (clojure.core/str v2670))))
   bean2668))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeHostsRequest}
describe-hosts-request
  [m2672]
  (clojure.core/let
   [bean2671
    (new com.amazonaws.services.ec2.model.DescribeHostsRequest)]
   (clojure.core/let
    [v2673
     (:next-token m2672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2673 :com.palletops.awaze.client-builder/undef)
     (. bean2671 setNextToken (clojure.core/str v2673))))
   (clojure.core/let
    [v2673
     (:max-results m2672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2673 :com.palletops.awaze.client-builder/undef)
     (. bean2671 setMaxResults (clojure.core/int v2673))))
   (clojure.core/let
    [v2673 (:filter m2672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2673 :com.palletops.awaze.client-builder/undef)
     (.
      bean2671
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2893] (ec2/filter arg2893))
 v2673))))
   (clojure.core/let
    [v2673
     (:host-ids m2672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2673 :com.palletops.awaze.client-builder/undef)
     (.
      bean2671
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2894] (clojure.core/str arg2894))
 v2673))))
   bean2671))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m2675]
  (clojure.core/let
   [bean2674
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/let
    [v2676
     (:volume-id m2675 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2676 :com.palletops.awaze.client-builder/undef)
     (. bean2674 setVolumeId (clojure.core/str v2676))))
   (clojure.core/let
    [v2676
     (:attribute m2675 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2676 :com.palletops.awaze.client-builder/undef)
     (. bean2674 setAttribute (clojure.core/str v2676))))
   bean2674))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyIdFormatRequest}
modify-id-format-request
  [m2678]
  (clojure.core/let
   [bean2677
    (new com.amazonaws.services.ec2.model.ModifyIdFormatRequest)]
   (clojure.core/let
    [v2679
     (:resource m2678 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2679 :com.palletops.awaze.client-builder/undef)
     (. bean2677 setResource (clojure.core/str v2679))))
   (clojure.core/let
    [v2679
     (:use-long-ids m2678 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2679 :com.palletops.awaze.client-builder/undef)
     (. bean2677 setUseLongIds (clojure.core/boolean v2679))))
   bean2677))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m2681]
  (clojure.core/let
   [bean2680
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/let
    [v2682
     (:protocol m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setProtocol (clojure.core/str v2682))))
   (clojure.core/let
    [v2682
     (:network-acl-id m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setNetworkAclId (clojure.core/str v2682))))
   (clojure.core/let
    [v2682
     (:rule-number m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setRuleNumber (clojure.core/int v2682))))
   (clojure.core/let
    [v2682
     (:rule-action m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setRuleAction (ec2/rule-action v2682))))
   (clojure.core/let
    [v2682 (:egress m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setEgress (clojure.core/boolean v2682))))
   (clojure.core/let
    [v2682
     (:cidr-block m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setCidrBlock (clojure.core/str v2682))))
   (clojure.core/let
    [v2682
     (:icmp-type-code m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setIcmpTypeCode (ec2/icmp-type-code v2682))))
   (clojure.core/let
    [v2682
     (:port-range m2681 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2682 :com.palletops.awaze.client-builder/undef)
     (. bean2680 setPortRange (ec2/port-range v2682))))
   bean2680))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest}
describe-nat-gateways-request
  [m2684]
  (clojure.core/let
   [bean2683
    (new com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest)]
   (clojure.core/let
    [v2685
     (:next-token m2684 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2685 :com.palletops.awaze.client-builder/undef)
     (. bean2683 setNextToken (clojure.core/str v2685))))
   (clojure.core/let
    [v2685
     (:max-results m2684 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2685 :com.palletops.awaze.client-builder/undef)
     (. bean2683 setMaxResults (clojure.core/int v2685))))
   (clojure.core/let
    [v2685 (:filter m2684 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2685 :com.palletops.awaze.client-builder/undef)
     (.
      bean2683
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2895] (ec2/filter arg2895))
 v2685))))
   (clojure.core/let
    [v2685
     (:nat-gateway-ids
      m2684
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2685 :com.palletops.awaze.client-builder/undef)
     (.
      bean2683
      setNatGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2896] (clojure.core/str arg2896))
 v2685))))
   bean2683))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m2687]
  (clojure.core/let
   [bean2686
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/let
    [v2688
     (:reserved-instances-listing-id
      m2687
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2688 :com.palletops.awaze.client-builder/undef)
     (.
      bean2686
      setReservedInstancesListingId
      (clojure.core/str v2688))))
   bean2686))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest}
disable-vpc-classic-link-request
  [m2690]
  (clojure.core/let
   [bean2689
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2691 (:vpc-id m2690 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2691 :com.palletops.awaze.client-builder/undef)
     (. bean2689 setVpcId (clojure.core/str v2691))))
   bean2689))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunScheduledInstancesRequest}
run-scheduled-instances-request
  [m2693]
  (clojure.core/let
   [bean2692
    (new
     com.amazonaws.services.ec2.model.RunScheduledInstancesRequest)]
   (clojure.core/let
    [v2694
     (:client-token m2693 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2694 :com.palletops.awaze.client-builder/undef)
     (. bean2692 setClientToken (clojure.core/str v2694))))
   (clojure.core/let
    [v2694
     (:instance-count m2693 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2694 :com.palletops.awaze.client-builder/undef)
     (. bean2692 setInstanceCount (clojure.core/int v2694))))
   (clojure.core/let
    [v2694
     (:launch-specification
      m2693
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2694 :com.palletops.awaze.client-builder/undef)
     (.
      bean2692
      setLaunchSpecification
      (ec2/scheduled-instances-launch-specification v2694))))
   (clojure.core/let
    [v2694
     (:scheduled-instance-id
      m2693
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2694 :com.palletops.awaze.client-builder/undef)
     (. bean2692 setScheduledInstanceId (clojure.core/str v2694))))
   bean2692))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m2696]
  (clojure.core/let
   [bean2695
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/let
    [v2697
     (:key-name m2696 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2697 :com.palletops.awaze.client-builder/undef)
     (. bean2695 setKeyName (clojure.core/str v2697))))
   bean2695))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m2699]
  (clojure.core/let
   [bean2698
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/let
    [v2700
     (:client-token m2699 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2700 :com.palletops.awaze.client-builder/undef)
     (. bean2698 setClientToken (clojure.core/str v2700))))
   (clojure.core/let
    [v2700
     (:reserved-instances-ids
      m2699
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2700 :com.palletops.awaze.client-builder/undef)
     (.
      bean2698
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2945] (clojure.core/str arg2945))
 v2700))))
   (clojure.core/let
    [v2700
     (:target-configurations
      m2699
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2700 :com.palletops.awaze.client-builder/undef)
     (.
      bean2698
      setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2946]
  (ec2/reserved-instances-configuration arg2946))
 v2700))))
   bean2698))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m2702]
  (clojure.core/let
   [bean2701
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2703
     (:destination-cidr-block
      m2702
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2703 :com.palletops.awaze.client-builder/undef)
     (. bean2701 setDestinationCidrBlock (clojure.core/str v2703))))
   (clojure.core/let
    [v2703
     (:vpn-connection-id
      m2702
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2703 :com.palletops.awaze.client-builder/undef)
     (. bean2701 setVpnConnectionId (clojure.core/str v2703))))
   bean2701))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m2705]
  (clojure.core/let
   [bean2704
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/let
    [v2706 (:vpc-id m2705 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2706 :com.palletops.awaze.client-builder/undef)
     (. bean2704 setVpcId (clojure.core/str v2706))))
   (clojure.core/let
    [v2706
     (:internet-gateway-id
      m2705
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2706 :com.palletops.awaze.client-builder/undef)
     (. bean2704 setInternetGatewayId (clojure.core/str v2706))))
   bean2704))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m2708]
  (clojure.core/let
   [bean2707
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2709
     (:network-interface-id
      m2708
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2709 :com.palletops.awaze.client-builder/undef)
     (. bean2707 setNetworkInterfaceId (clojure.core/str v2709))))
   (clojure.core/let
    [v2709 (:groups m2708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2709 :com.palletops.awaze.client-builder/undef)
     (.
      bean2707
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2947] (clojure.core/str arg2947))
 v2709))))
   (clojure.core/let
    [v2709
     (:description m2708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2709 :com.palletops.awaze.client-builder/undef)
     (. bean2707 setDescription (clojure.core/str v2709))))
   (clojure.core/let
    [v2709
     (:source-dest-check
      m2708
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2709 :com.palletops.awaze.client-builder/undef)
     (. bean2707 setSourceDestCheck (clojure.core/boolean v2709))))
   (clojure.core/let
    [v2709
     (:attachment m2708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2709 :com.palletops.awaze.client-builder/undef)
     (.
      bean2707
      setAttachment
      (ec2/network-interface-attachment-changes v2709))))
   bean2707))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m2711]
  (clojure.core/let
   [bean2710
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2712
     (:route-table-id m2711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2712 :com.palletops.awaze.client-builder/undef)
     (. bean2710 setRouteTableId (clojure.core/str v2712))))
   (clojure.core/let
    [v2712
     (:gateway-id m2711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2712 :com.palletops.awaze.client-builder/undef)
     (. bean2710 setGatewayId (clojure.core/str v2712))))
   bean2710))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m2714]
  (clojure.core/let
   [bean2713
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/let
    [v2715
     (:network-acl-id m2714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2715 :com.palletops.awaze.client-builder/undef)
     (. bean2713 setNetworkAclId (clojure.core/str v2715))))
   (clojure.core/let
    [v2715
     (:rule-number m2714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2715 :com.palletops.awaze.client-builder/undef)
     (. bean2713 setRuleNumber (clojure.core/int v2715))))
   (clojure.core/let
    [v2715 (:egress m2714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2715 :com.palletops.awaze.client-builder/undef)
     (. bean2713 setEgress (clojure.core/boolean v2715))))
   bean2713))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m2717]
  (clojure.core/let
   [bean2716
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/let
    [v2718
     (:export-task-id m2717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2718 :com.palletops.awaze.client-builder/undef)
     (. bean2716 setExportTaskId (clojure.core/str v2718))))
   bean2716))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m2720]
  (clojure.core/let
   [bean2719
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/let
    [v2721 (:name m2720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2721 :com.palletops.awaze.client-builder/undef)
     (. bean2719 setName (clojure.core/str v2721))))
   (clojure.core/let
    [v2721
     (:instance-id m2720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2721 :com.palletops.awaze.client-builder/undef)
     (. bean2719 setInstanceId (clojure.core/str v2721))))
   (clojure.core/let
    [v2721
     (:description m2720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2721 :com.palletops.awaze.client-builder/undef)
     (. bean2719 setDescription (clojure.core/str v2721))))
   (clojure.core/let
    [v2721
     (:no-reboot m2720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2721 :com.palletops.awaze.client-builder/undef)
     (. bean2719 setNoReboot (clojure.core/boolean v2721))))
   (clojure.core/let
    [v2721
     (:block-device-mappings
      m2720
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2721 :com.palletops.awaze.client-builder/undef)
     (.
      bean2719
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2948] (ec2/block-device-mapping arg2948))
 v2721))))
   bean2719))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest}
modify-spot-fleet-request-request
  [m2723]
  (clojure.core/let
   [bean2722
    (new
     com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest)]
   (clojure.core/let
    [v2724
     (:spot-fleet-request-id
      m2723
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2724 :com.palletops.awaze.client-builder/undef)
     (. bean2722 setSpotFleetRequestId (clojure.core/str v2724))))
   (clojure.core/let
    [v2724
     (:target-capacity
      m2723
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2724 :com.palletops.awaze.client-builder/undef)
     (. bean2722 setTargetCapacity (clojure.core/int v2724))))
   (clojure.core/let
    [v2724
     (:excess-capacity-termination-policy
      m2723
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2724 :com.palletops.awaze.client-builder/undef)
     (.
      bean2722
      setExcessCapacityTerminationPolicy
      (ec2/excess-capacity-termination-policy v2724))))
   bean2722))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest}
describe-import-snapshot-tasks-request
  [m2726]
  (clojure.core/let
   [bean2725
    (new
     com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest)]
   (clojure.core/let
    [v2727 (:filters m2726 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2727 :com.palletops.awaze.client-builder/undef)
     (.
      bean2725
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2949] (ec2/filter arg2949))
 v2727))))
   (clojure.core/let
    [v2727
     (:next-token m2726 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2727 :com.palletops.awaze.client-builder/undef)
     (. bean2725 setNextToken (clojure.core/str v2727))))
   (clojure.core/let
    [v2727
     (:max-results m2726 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2727 :com.palletops.awaze.client-builder/undef)
     (. bean2725 setMaxResults (clojure.core/int v2727))))
   (clojure.core/let
    [v2727
     (:import-task-ids
      m2726
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2727 :com.palletops.awaze.client-builder/undef)
     (.
      bean2725
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2950] (clojure.core/str arg2950))
 v2727))))
   bean2725))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-endpoints
   [m2897]
   (clojure.core/let
    [credentials2898 (:credentials m2897) args2899 (:args m2897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2900
      (com.palletops.awaze.common/aws-client :ec2 credentials2898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2900
       deleteVpcEndpoints
       (ec2/delete-vpc-endpoints-request
        (clojure.core/nth args2899 0)))))))
  (clojure.core/defn
   delete-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Generate map for deleteVpcEndpoints"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vpc-endpoints,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Call deleteVpcEndpoints"}
   [credentials2902 & args2903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2904
     (com.palletops.awaze.common/aws-client :ec2 credentials2902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2904
      deleteVpcEndpoints
      (ec2/delete-vpc-endpoints-request (clojure.core/nth args2903 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-nat-gateway
   [m2905]
   (clojure.core/let
    [credentials2906 (:credentials m2905) args2907 (:args m2905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2908
      (com.palletops.awaze.common/aws-client :ec2 credentials2906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2908
       createNatGateway
       (ec2/create-nat-gateway-request (clojure.core/nth args2907 0)))))))
  (clojure.core/defn
   create-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createNatGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-nat-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createNatGateway"}
   [credentials2910 & args2911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2912
     (com.palletops.awaze.common/aws-client :ec2 credentials2910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2912
      createNatGateway
      (ec2/create-nat-gateway-request (clojure.core/nth args2911 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m2913]
   (clojure.core/let
    [credentials2914 (:credentials m2913) args2915 (:args m2913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2916
      (com.palletops.awaze.common/aws-client :ec2 credentials2914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2916
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args2915 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :stop-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call stopInstances"}
   [credentials2918 & args2919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2920
     (com.palletops.awaze.common/aws-client :ec2 credentials2918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2920
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args2919 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m2921]
   (clojure.core/let
    [credentials2922 (:credentials m2921) args2923 (:args m2921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2924
      (com.palletops.awaze.common/aws-client :ec2 credentials2922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2924
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args2923 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-placement-group,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPlacementGroup"}
   [credentials2926 & args2927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2928
     (com.palletops.awaze.common/aws-client :ec2 credentials2926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2928
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args2927 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m2929]
   (clojure.core/let
    [credentials2930 (:credentials m2929) args2931 (:args m2929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2932
      (com.palletops.awaze.common/aws-client :ec2 credentials2930)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2932
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args2931 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-reserved-instances-listing,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials2934 & args2935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2936
     (com.palletops.awaze.common/aws-client :ec2 credentials2934)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2936
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args2935 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-hosts
   [m2937]
   (clojure.core/let
    [credentials2938 (:credentials m2937) args2939 (:args m2937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2940
      (com.palletops.awaze.common/aws-client :ec2 credentials2938)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2940
       releaseHosts
       (ec2/release-hosts-request (clojure.core/nth args2939 0)))))))
  (clojure.core/defn
   release-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for releaseHosts"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :release-hosts,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call releaseHosts"}
   [credentials2942 & args2943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2944
     (com.palletops.awaze.common/aws-client :ec2 credentials2942)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2944
      releaseHosts
      (ec2/release-hosts-request (clojure.core/nth args2943 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m2951]
   (clojure.core/let
    [credentials2952 (:credentials m2951) args2953 (:args m2951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2954
      (com.palletops.awaze.common/aws-client :ec2 credentials2952)]
     (clojure.core/case
      (clojure.core/count args2953)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2954
        revokeSecurityGroupIngress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2954
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args2953 0))))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials2956 & args2957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2958
     (com.palletops.awaze.common/aws-client :ec2 credentials2956)]
    (clojure.core/case
     (clojure.core/count args2957)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2958
       revokeSecurityGroupIngress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2958
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args2957 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-classic-link-vpc
   [m2959]
   (clojure.core/let
    [credentials2960 (:credentials m2959) args2961 (:args m2959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2962
      (com.palletops.awaze.common/aws-client :ec2 credentials2960)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2962
       attachClassicLinkVpc
       (ec2/attach-classic-link-vpc-request
        (clojure.core/nth args2961 0)))))))
  (clojure.core/defn
   attach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Generate map for attachClassicLinkVpc"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-classic-link-vpc,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Call attachClassicLinkVpc"}
   [credentials2964 & args2965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2966
     (com.palletops.awaze.common/aws-client :ec2 credentials2964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2966
      attachClassicLinkVpc
      (ec2/attach-classic-link-vpc-request
       (clojure.core/nth args2965 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m2967]
   (clojure.core/let
    [credentials2968 (:credentials m2967) args2969 (:args m2967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2970
      (com.palletops.awaze.common/aws-client :ec2 credentials2968)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2970
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args2969 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :replace-network-acl-association,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials2972 & args2973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2974
     (com.palletops.awaze.common/aws-client :ec2 credentials2972)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2974
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args2973 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-nat-gateway
   [m2975]
   (clojure.core/let
    [credentials2976 (:credentials m2975) args2977 (:args m2975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2978
      (com.palletops.awaze.common/aws-client :ec2 credentials2976)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2978
       deleteNatGateway
       (ec2/delete-nat-gateway-request (clojure.core/nth args2977 0)))))))
  (clojure.core/defn
   delete-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNatGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-nat-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNatGateway"}
   [credentials2980 & args2981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2982
     (com.palletops.awaze.common/aws-client :ec2 credentials2980)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2982
      deleteNatGateway
      (ec2/delete-nat-gateway-request (clojure.core/nth args2981 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m2983]
   (clojure.core/let
    [credentials2984 (:credentials m2983) args2985 (:args m2983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2986
      (com.palletops.awaze.common/aws-client :ec2 credentials2984)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2986
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args2985 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-instance-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials2988 & args2989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2990
     (com.palletops.awaze.common/aws-client :ec2 credentials2988)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2990
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args2989 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m2991]
   (clojure.core/let
    [credentials2992 (:credentials m2991) args2993 (:args m2991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2994
      (com.palletops.awaze.common/aws-client :ec2 credentials2992)]
     (clojure.core/case
      (clojure.core/count args2993)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2994
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args2993 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2994
        describeNetworkAcls))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-network-acls,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-network-acls,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials2996 & args2997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2998
     (com.palletops.awaze.common/aws-client :ec2 credentials2996)]
    (clojure.core/case
     (clojure.core/count args2997)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2998
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args2997 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2998
       describeNetworkAcls))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m2999]
   (clojure.core/let
    [credentials3000 (:credentials m2999) args3001 (:args m2999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3002
      (com.palletops.awaze.common/aws-client :ec2 credentials3000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3002
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args3001 0)))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportInstanceStatus"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :report-instance-status,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportInstanceStatus"}
   [credentials3004 & args3005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3006
     (com.palletops.awaze.common/aws-client :ec2 credentials3004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3006
      reportInstanceStatus
      (ec2/report-instance-status-request
       (clojure.core/nth args3005 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m3007]
   (clojure.core/let
    [credentials3008 (:credentials m3007) args3009 (:args m3007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3010
      (com.palletops.awaze.common/aws-client :ec2 credentials3008)]
     (clojure.core/case
      (clojure.core/count args3009)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3010
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3010
        describeImages
        (ec2/describe-images-request (clojure.core/nth args3009 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-images,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-images,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials3012 & args3013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3014
     (com.palletops.awaze.common/aws-client :ec2 credentials3012)]
    (clojure.core/case
     (clojure.core/count args3013)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3014
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3014
       describeImages
       (ec2/describe-images-request (clojure.core/nth args3013 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-image-tasks
   [m3015]
   (clojure.core/let
    [credentials3016 (:credentials m3015) args3017 (:args m3015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3018
      (com.palletops.awaze.common/aws-client :ec2 credentials3016)]
     (clojure.core/case
      (clojure.core/count args3017)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3018
        describeImportImageTasks
        (ec2/describe-import-image-tasks-request
         (clojure.core/nth args3017 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3018
        describeImportImageTasks))))))
  (clojure.core/defn
   describe-import-image-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeImportImageTasks, describeImportImageTasks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-import-image-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-import-image-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-image-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeImportImageTasks, describeImportImageTasks"}
   [credentials3020 & args3021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3022
     (com.palletops.awaze.common/aws-client :ec2 credentials3020)]
    (clojure.core/case
     (clojure.core/count args3021)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3022
       describeImportImageTasks
       (ec2/describe-import-image-tasks-request
        (clojure.core/nth args3021 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3022
       describeImportImageTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-hosts
   [m3023]
   (clojure.core/let
    [credentials3024 (:credentials m3023) args3025 (:args m3023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3026
      (com.palletops.awaze.common/aws-client :ec2 credentials3024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3026
       modifyHosts
       (ec2/modify-hosts-request (clojure.core/nth args3025 0)))))))
  (clojure.core/defn
   modify-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyHosts"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-hosts,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyHosts"}
   [credentials3028 & args3029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3030
     (com.palletops.awaze.common/aws-client :ec2 credentials3028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3030
      modifyHosts
      (ec2/modify-hosts-request (clojure.core/nth args3029 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m3031]
   (clojure.core/let
    [credentials3032 (:credentials m3031) args3033 (:args m3031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3034
      (com.palletops.awaze.common/aws-client :ec2 credentials3032)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3034
       registerImage
       (ec2/register-image-request (clojure.core/nth args3033 0)))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for registerImage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :register-image,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call registerImage"}
   [credentials3036 & args3037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3038
     (com.palletops.awaze.common/aws-client :ec2 credentials3036)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3038
      registerImage
      (ec2/register-image-request (clojure.core/nth args3037 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m3039]
   (clojure.core/let
    [credentials3040 (:credentials m3039) args3041 (:args m3039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3042
      (com.palletops.awaze.common/aws-client :ec2 credentials3040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3042
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args3041 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-vpn-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVpnGateway"}
   [credentials3044 & args3045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3046
     (com.palletops.awaze.common/aws-client :ec2 credentials3044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3046
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args3045 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m3047]
   (clojure.core/let
    [credentials3048 (:credentials m3047) args3049 (:args m3047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3050
      (com.palletops.awaze.common/aws-client :ec2 credentials3048)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3050
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args3049 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials3052 & args3053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3054
     (com.palletops.awaze.common/aws-client :ec2 credentials3052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3054
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args3053 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m3055]
   (clojure.core/let
    [credentials3056 (:credentials m3055) args3057 (:args m3055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3058
      (com.palletops.awaze.common/aws-client :ec2 credentials3056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3058
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args3057 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-internet-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials3060 & args3061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3062
     (com.palletops.awaze.common/aws-client :ec2 credentials3060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3062
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args3061 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m3063]
   (clojure.core/let
    [credentials3064 (:credentials m3063) args3065 (:args m3063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3066
      (com.palletops.awaze.common/aws-client :ec2 credentials3064)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3066
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args3065 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-subnet,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSubnet"}
   [credentials3068 & args3069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3070
     (com.palletops.awaze.common/aws-client :ec2 credentials3068)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3070
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args3069 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m3071]
   (clojure.core/let
    [credentials3072 (:credentials m3071) args3073 (:args m3071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3074
      (com.palletops.awaze.common/aws-client :ec2 credentials3072)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3074
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args3073 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-instance-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials3076 & args3077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3078
     (com.palletops.awaze.common/aws-client :ec2 credentials3076)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3078
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args3077 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m3079]
   (clojure.core/let
    [credentials3080 (:credentials m3079) args3081 (:args m3079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3082
      (com.palletops.awaze.common/aws-client :ec2 credentials3080)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3082
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args3081 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-volume,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVolume"}
   [credentials3084 & args3085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3086
     (com.palletops.awaze.common/aws-client :ec2 credentials3084)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3086
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args3085 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m3087]
   (clojure.core/let
    [credentials3088 (:credentials m3087) args3089 (:args m3087)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3090
      (com.palletops.awaze.common/aws-client :ec2 credentials3088)]
     (clojure.core/case
      (clojure.core/count args3089)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3090
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3090
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args3089 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-export-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-export-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials3092 & args3093]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3094
     (com.palletops.awaze.common/aws-client :ec2 credentials3092)]
    (clojure.core/case
     (clojure.core/count args3093)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3094
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3094
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args3093 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instances
   [m3095]
   (clojure.core/let
    [credentials3096 (:credentials m3095) args3097 (:args m3095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3098
      (com.palletops.awaze.common/aws-client :ec2 credentials3096)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3098
       describeScheduledInstances
       (ec2/describe-scheduled-instances-request
        (clojure.core/nth args3097 0)))))))
  (clojure.core/defn
   describe-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstances"}
   [credentials3100 & args3101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3102
     (com.palletops.awaze.common/aws-client :ec2 credentials3100)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3102
      describeScheduledInstances
      (ec2/describe-scheduled-instances-request
       (clojure.core/nth args3101 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-flow-logs
   [m3103]
   (clojure.core/let
    [credentials3104 (:credentials m3103) args3105 (:args m3103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3106
      (com.palletops.awaze.common/aws-client :ec2 credentials3104)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3106
       deleteFlowLogs
       (ec2/delete-flow-logs-request (clojure.core/nth args3105 0)))))))
  (clojure.core/defn
   delete-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteFlowLogs"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-flow-logs,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteFlowLogs"}
   [credentials3108 & args3109]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3110
     (com.palletops.awaze.common/aws-client :ec2 credentials3108)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3110
      deleteFlowLogs
      (ec2/delete-flow-logs-request (clojure.core/nth args3109 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m3111]
   (clojure.core/let
    [credentials3112 (:credentials m3111) args3113 (:args m3111)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3114
      (com.palletops.awaze.common/aws-client :ec2 credentials3112)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3114
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args3113 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vpc,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Call createVpc"}
   [credentials3116 & args3117]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3118
     (com.palletops.awaze.common/aws-client :ec2 credentials3116)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3118
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args3117 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m3119]
   (clojure.core/let
    [credentials3120 (:credentials m3119) args3121 (:args m3119)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3122
      (com.palletops.awaze.common/aws-client :ec2 credentials3120)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3122
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args3121 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials3124 & args3125]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3126
     (com.palletops.awaze.common/aws-client :ec2 credentials3124)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3126
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args3125 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link
   [m3127]
   (clojure.core/let
    [credentials3128 (:credentials m3127) args3129 (:args m3127)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3130
      (com.palletops.awaze.common/aws-client :ec2 credentials3128)]
     (clojure.core/case
      (clojure.core/count args3129)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3130
        describeVpcClassicLink
        (ec2/describe-vpc-classic-link-request
         (clojure.core/nth args3129 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3130
        describeVpcClassicLink))))))
  (clojure.core/defn
   describe-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcClassicLink, describeVpcClassicLink"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcClassicLink, describeVpcClassicLink"}
   [credentials3132 & args3133]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3134
     (com.palletops.awaze.common/aws-client :ec2 credentials3132)]
    (clojure.core/case
     (clojure.core/count args3133)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3134
       describeVpcClassicLink
       (ec2/describe-vpc-classic-link-request
        (clojure.core/nth args3133 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3134
       describeVpcClassicLink))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m3135]
   (clojure.core/let
    [credentials3136 (:credentials m3135) args3137 (:args m3135)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3138
      (com.palletops.awaze.common/aws-client :ec2 credentials3136)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3138
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args3137 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-route,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRoute"}
   [credentials3140 & args3141]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3142
     (com.palletops.awaze.common/aws-client :ec2 credentials3140)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3142
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args3141 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-id-format
   [m3143]
   (clojure.core/let
    [credentials3144 (:credentials m3143) args3145 (:args m3143)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3146
      (com.palletops.awaze.common/aws-client :ec2 credentials3144)]
     (clojure.core/case
      (clojure.core/count args3145)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3146
        describeIdFormat
        (ec2/describe-id-format-request (clojure.core/nth args3145 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3146
        describeIdFormat))))))
  (clojure.core/defn
   describe-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeIdFormat, describeIdFormat"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-id-format,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-id-format,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeIdFormat, describeIdFormat"}
   [credentials3148 & args3149]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3150
     (com.palletops.awaze.common/aws-client :ec2 credentials3148)]
    (clojure.core/case
     (clojure.core/count args3149)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3150
       describeIdFormat
       (ec2/describe-id-format-request (clojure.core/nth args3149 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3150
       describeIdFormat))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m3151]
   (clojure.core/let
    [credentials3152 (:credentials m3151) args3153 (:args m3151)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3154
      (com.palletops.awaze.common/aws-client :ec2 credentials3152)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3154
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args3153 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-volume,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVolume"}
   [credentials3156 & args3157]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3158
     (com.palletops.awaze.common/aws-client :ec2 credentials3156)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3158
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args3157 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m3159]
   (clojure.core/let
    [credentials3160 (:credentials m3159) args3161 (:args m3159)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3162
      (com.palletops.awaze.common/aws-client :ec2 credentials3160)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3162
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args3161 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-volume-io,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVolumeIO"}
   [credentials3164 & args3165]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3166
     (com.palletops.awaze.common/aws-client :ec2 credentials3164)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3166
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args3165 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m3167]
   (clojure.core/let
    [credentials3168 (:credentials m3167) args3169 (:args m3167)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3170
      (com.palletops.awaze.common/aws-client :ec2 credentials3168)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3170
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args3169 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-vpn-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVpnGateway"}
   [credentials3172 & args3173]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3174
     (com.palletops.awaze.common/aws-client :ec2 credentials3172)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3174
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args3173 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m3175]
   (clojure.core/let
    [credentials3176 (:credentials m3175) args3177 (:args m3175)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3178
      (com.palletops.awaze.common/aws-client :ec2 credentials3176)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3178
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args3177 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :replace-network-acl-entry,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials3180 & args3181]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3182
     (com.palletops.awaze.common/aws-client :ec2 credentials3180)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3182
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args3181 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m3183]
   (clojure.core/let
    [credentials3184 (:credentials m3183) args3185 (:args m3183)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3186
      (com.palletops.awaze.common/aws-client :ec2 credentials3184)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3186
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args3185 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-snapshot-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials3188 & args3189]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3190
     (com.palletops.awaze.common/aws-client :ec2 credentials3188)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3190
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args3189 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m3191]
   (clojure.core/let
    [credentials3192 (:credentials m3191) args3193 (:args m3191)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3194
      (com.palletops.awaze.common/aws-client :ec2 credentials3192)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3194
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args3193 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reboot-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootInstances"}
   [credentials3196 & args3197]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3198
     (com.palletops.awaze.common/aws-client :ec2 credentials3196)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3198
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args3197 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m3199]
   (clojure.core/let
    [credentials3200 (:credentials m3199) args3201 (:args m3199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3202
      (com.palletops.awaze.common/aws-client :ec2 credentials3200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3202
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args3201 0)))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rejectVpcPeeringConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rejectVpcPeeringConnection"}
   [credentials3204 & args3205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3206
     (com.palletops.awaze.common/aws-client :ec2 credentials3204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3206
      rejectVpcPeeringConnection
      (ec2/reject-vpc-peering-connection-request
       (clojure.core/nth args3205 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m3207]
   (clojure.core/let
    [credentials3208 (:credentials m3207) args3209 (:args m3207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3210
      (com.palletops.awaze.common/aws-client :ec2 credentials3208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3210
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args3209 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-security-group,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSecurityGroup"}
   [credentials3212 & args3213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3214
     (com.palletops.awaze.common/aws-client :ec2 credentials3212)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3214
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args3213 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m3215]
   (clojure.core/let
    [credentials3216 (:credentials m3215) args3217 (:args m3215)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3218
      (com.palletops.awaze.common/aws-client :ec2 credentials3216)]
     (clojure.core/case
      (clojure.core/count args3217)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3218
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3218
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args3217 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials3220 & args3221]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3222
     (com.palletops.awaze.common/aws-client :ec2 credentials3220)]
    (clojure.core/case
     (clojure.core/count args3221)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3222
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3222
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args3221 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m3223]
   (clojure.core/let
    [credentials3224 (:credentials m3223) args3225 (:args m3223)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3226
      (com.palletops.awaze.common/aws-client :ec2 credentials3224)]
     (clojure.core/case
      (clojure.core/count args3225)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3226
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args3225 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3226
        describeSpotDatafeedSubscription))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials3228 & args3229]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3230
     (com.palletops.awaze.common/aws-client :ec2 credentials3228)]
    (clojure.core/case
     (clojure.core/count args3229)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3230
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args3229 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3230
       describeSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :move-address-to-vpc
   [m3231]
   (clojure.core/let
    [credentials3232 (:credentials m3231) args3233 (:args m3231)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3234
      (com.palletops.awaze.common/aws-client :ec2 credentials3232)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3234
       moveAddressToVpc
       (ec2/move-address-to-vpc-request (clojure.core/nth args3233 0)))))))
  (clojure.core/defn
   move-address-to-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for moveAddressToVpc"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :move-address-to-vpc,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   move-address-to-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call moveAddressToVpc"}
   [credentials3236 & args3237]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3238
     (com.palletops.awaze.common/aws-client :ec2 credentials3236)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3238
      moveAddressToVpc
      (ec2/move-address-to-vpc-request (clojure.core/nth args3237 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-endpoint
   [m3239]
   (clojure.core/let
    [credentials3240 (:credentials m3239) args3241 (:args m3239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3242
      (com.palletops.awaze.common/aws-client :ec2 credentials3240)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3242
       modifyVpcEndpoint
       (ec2/modify-vpc-endpoint-request (clojure.core/nth args3241 0)))))))
  (clojure.core/defn
   modify-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Generate map for modifyVpcEndpoint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-vpc-endpoint,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Call modifyVpcEndpoint"}
   [credentials3244 & args3245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3246
     (com.palletops.awaze.common/aws-client :ec2 credentials3244)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3246
      modifyVpcEndpoint
      (ec2/modify-vpc-endpoint-request (clojure.core/nth args3245 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m3247]
   (clojure.core/let
    [credentials3248 (:credentials m3247) args3249 (:args m3247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3250
      (com.palletops.awaze.common/aws-client :ec2 credentials3248)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3250
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args3249 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-network-interface,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials3252 & args3253]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3254
     (com.palletops.awaze.common/aws-client :ec2 credentials3252)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3254
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args3253 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m3255]
   (clojure.core/let
    [credentials3256 (:credentials m3255) args3257 (:args m3255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3258
      (com.palletops.awaze.common/aws-client :ec2 credentials3256)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3258
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args3257 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-network-interface,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials3260 & args3261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3262
     (com.palletops.awaze.common/aws-client :ec2 credentials3260)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3262
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args3261 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m3263]
   (clojure.core/let
    [credentials3264 (:credentials m3263) args3265 (:args m3263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3266
      (com.palletops.awaze.common/aws-client :ec2 credentials3264)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3266
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args3265 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-dhcp-options,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials3268 & args3269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3270
     (com.palletops.awaze.common/aws-client :ec2 credentials3268)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3270
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args3269 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoints
   [m3271]
   (clojure.core/let
    [credentials3272 (:credentials m3271) args3273 (:args m3271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3274
      (com.palletops.awaze.common/aws-client :ec2 credentials3272)]
     (clojure.core/case
      (clojure.core/count args3273)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3274
        describeVpcEndpoints))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3274
        describeVpcEndpoints
        (ec2/describe-vpc-endpoints-request
         (clojure.core/nth args3273 0))))))))
  (clojure.core/defn
   describe-vpc-endpoints-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcEndpoints, describeVpcEndpoints"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoints
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcEndpoints, describeVpcEndpoints"}
   [credentials3276 & args3277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3278
     (com.palletops.awaze.common/aws-client :ec2 credentials3276)]
    (clojure.core/case
     (clojure.core/count args3277)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3278
       describeVpcEndpoints))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3278
       describeVpcEndpoints
       (ec2/describe-vpc-endpoints-request
        (clojure.core/nth args3277 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m3279]
   (clojure.core/let
    [credentials3280 (:credentials m3279) args3281 (:args m3279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3282
      (com.palletops.awaze.common/aws-client :ec2 credentials3280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3282
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args3281 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :confirm-product-instance,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmProductInstance"}
   [credentials3284 & args3285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3286
     (com.palletops.awaze.common/aws-client :ec2 credentials3284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3286
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args3285 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m3287]
   (clojure.core/let
    [credentials3288 (:credentials m3287) args3289 (:args m3287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3290
      (com.palletops.awaze.common/aws-client :ec2 credentials3288)]
     (clojure.core/case
      (clojure.core/count args3289)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3290
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args3289 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3290
        allocateAddress))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :allocate-address,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :allocate-address,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials3292 & args3293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3294
     (com.palletops.awaze.common/aws-client :ec2 credentials3292)]
    (clojure.core/case
     (clojure.core/count args3293)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3294
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args3293 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3294
       allocateAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-endpoint
   [m3295]
   (clojure.core/let
    [credentials3296 (:credentials m3295) args3297 (:args m3295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3298
      (com.palletops.awaze.common/aws-client :ec2 credentials3296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3298
       createVpcEndpoint
       (ec2/create-vpc-endpoint-request (clojure.core/nth args3297 0)))))))
  (clojure.core/defn
   create-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createVpcEndpoint"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vpc-endpoint,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createVpcEndpoint"}
   [credentials3300 & args3301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3302
     (com.palletops.awaze.common/aws-client :ec2 credentials3300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3302
      createVpcEndpoint
      (ec2/create-vpc-endpoint-request (clojure.core/nth args3301 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m3303]
   (clojure.core/let
    [credentials3304 (:credentials m3303) args3305 (:args m3303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3306
      (com.palletops.awaze.common/aws-client :ec2 credentials3304)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3306
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args3305 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :import-key-pair,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call importKeyPair"}
   [credentials3308 & args3309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3310
     (com.palletops.awaze.common/aws-client :ec2 credentials3308)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3310
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args3309 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m3311]
   (clojure.core/let
    [credentials3312 (:credentials m3311) args3313 (:args m3311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3314
      (com.palletops.awaze.common/aws-client :ec2 credentials3312)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3314
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args3313 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Call copySnapshot"}
   [credentials3316 & args3317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3318
     (com.palletops.awaze.common/aws-client :ec2 credentials3316)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3318
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args3317 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m3319]
   (clojure.core/let
    [credentials3320 (:credentials m3319) args3321 (:args m3319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3322
      (com.palletops.awaze.common/aws-client :ec2 credentials3320)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3322
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args3321 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials3324 & args3325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3326
     (com.palletops.awaze.common/aws-client :ec2 credentials3324)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3326
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args3325 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m3327]
   (clojure.core/let
    [credentials3328 (:credentials m3327) args3329 (:args m3327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3330
      (com.palletops.awaze.common/aws-client :ec2 credentials3328)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3330
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args3329 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-image-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetImageAttribute"}
   [credentials3332 & args3333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3334
     (com.palletops.awaze.common/aws-client :ec2 credentials3332)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3334
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args3333 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m3335]
   (clojure.core/let
    [credentials3336 (:credentials m3335) args3337 (:args m3335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3338
      (com.palletops.awaze.common/aws-client :ec2 credentials3336)]
     (clojure.core/case
      (clojure.core/count args3337)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3338
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3338
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args3337 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :create-internet-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-internet-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials3340 & args3341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3342
     (com.palletops.awaze.common/aws-client :ec2 credentials3340)]
    (clojure.core/case
     (clojure.core/count args3341)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3342
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3342
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args3341 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m3343]
   (clojure.core/let
    [credentials3344 (:credentials m3343) args3345 (:args m3343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3346
      (com.palletops.awaze.common/aws-client :ec2 credentials3344)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3346
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args3345 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :monitor-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call monitorInstances"}
   [credentials3348 & args3349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3350
     (com.palletops.awaze.common/aws-client :ec2 credentials3348)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3350
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args3349 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m3351]
   (clojure.core/let
    [credentials3352 (:credentials m3351) args3353 (:args m3351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3354
      (com.palletops.awaze.common/aws-client :ec2 credentials3352)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3354
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args3353 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :revoke-security-group-egress,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials3356 & args3357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3358
     (com.palletops.awaze.common/aws-client :ec2 credentials3356)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3358
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args3357 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m3359]
   (clojure.core/let
    [credentials3360 (:credentials m3359) args3361 (:args m3359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3362
      (com.palletops.awaze.common/aws-client :ec2 credentials3360)]
     (clojure.core/case
      (clojure.core/count args3361)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3362
        describeVpcs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3362
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args3361 0))))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpcs,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpcs,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials3364 & args3365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3366
     (com.palletops.awaze.common/aws-client :ec2 credentials3364)]
    (clojure.core/case
     (clojure.core/count args3365)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3366
       describeVpcs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3366
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args3365 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m3367]
   (clojure.core/let
    [credentials3368 (:credentials m3367) args3369 (:args m3367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3370
      (com.palletops.awaze.common/aws-client :ec2 credentials3368)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3370
       importInstance
       (ec2/import-instance-request (clojure.core/nth args3369 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :import-instance,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Call importInstance"}
   [credentials3372 & args3373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3374
     (com.palletops.awaze.common/aws-client :ec2 credentials3372)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3374
      importInstance
      (ec2/import-instance-request (clojure.core/nth args3373 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m3375]
   (clojure.core/let
    [credentials3376 (:credentials m3375) args3377 (:args m3375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3378
      (com.palletops.awaze.common/aws-client :ec2 credentials3376)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3378
       copyImage
       (ec2/copy-image-request (clojure.core/nth args3377 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :copy-image,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Call copyImage"}
   [credentials3380 & args3381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3382
     (com.palletops.awaze.common/aws-client :ec2 credentials3380)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3382
      copyImage
      (ec2/copy-image-request (clojure.core/nth args3381 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m3383]
   (clojure.core/let
    [credentials3384 (:credentials m3383) args3385 (:args m3383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3386
      (com.palletops.awaze.common/aws-client :ec2 credentials3384)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3386
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args3385 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-console-output,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getConsoleOutput"}
   [credentials3388 & args3389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3390
     (com.palletops.awaze.common/aws-client :ec2 credentials3388)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3390
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args3389 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m3391]
   (clojure.core/let
    [credentials3392 (:credentials m3391) args3393 (:args m3391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3394
      (com.palletops.awaze.common/aws-client :ec2 credentials3392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3394
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args3393 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-snapshot-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials3396 & args3397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3398
     (com.palletops.awaze.common/aws-client :ec2 credentials3396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3398
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args3397 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-fleet
   [m3399]
   (clojure.core/let
    [credentials3400 (:credentials m3399) args3401 (:args m3399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3402
      (com.palletops.awaze.common/aws-client :ec2 credentials3400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3402
       requestSpotFleet
       (ec2/request-spot-fleet-request (clojure.core/nth args3401 0)))))))
  (clojure.core/defn
   request-spot-fleet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for requestSpotFleet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :request-spot-fleet,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-fleet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call requestSpotFleet"}
   [credentials3404 & args3405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3406
     (com.palletops.awaze.common/aws-client :ec2 credentials3404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3406
      requestSpotFleet
      (ec2/request-spot-fleet-request (clojure.core/nth args3405 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :restore-address-to-classic
   [m3407]
   (clojure.core/let
    [credentials3408 (:credentials m3407) args3409 (:args m3407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3410
      (com.palletops.awaze.common/aws-client :ec2 credentials3408)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3410
       restoreAddressToClassic
       (ec2/restore-address-to-classic-request
        (clojure.core/nth args3409 0)))))))
  (clojure.core/defn
   restore-address-to-classic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for restoreAddressToClassic"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :restore-address-to-classic,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   restore-address-to-classic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call restoreAddressToClassic"}
   [credentials3412 & args3413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3414
     (com.palletops.awaze.common/aws-client :ec2 credentials3412)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3414
      restoreAddressToClassic
      (ec2/restore-address-to-classic-request
       (clojure.core/nth args3413 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-subnet-attribute
   [m3415]
   (clojure.core/let
    [credentials3416 (:credentials m3415) args3417 (:args m3415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3418
      (com.palletops.awaze.common/aws-client :ec2 credentials3416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3418
       modifySubnetAttribute
       (ec2/modify-subnet-attribute-request
        (clojure.core/nth args3417 0)))))))
  (clojure.core/defn
   modify-subnet-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySubnetAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-subnet-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-subnet-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySubnetAttribute"}
   [credentials3420 & args3421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3422
     (com.palletops.awaze.common/aws-client :ec2 credentials3420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3422
      modifySubnetAttribute
      (ec2/modify-subnet-attribute-request
       (clojure.core/nth args3421 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m3423]
   (clojure.core/let
    [credentials3424 (:credentials m3423) args3425 (:args m3423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3426
      (com.palletops.awaze.common/aws-client :ec2 credentials3424)]
     (clojure.core/case
      (clojure.core/count args3425)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3426
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args3425 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3426
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-conversion-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-conversion-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials3428 & args3429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3430
     (com.palletops.awaze.common/aws-client :ec2 credentials3428)]
    (clojure.core/case
     (clojure.core/count args3429)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3430
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args3429 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3430
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m3431]
   (clojure.core/let
    [credentials3432 (:credentials m3431) args3433 (:args m3431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3434
      (com.palletops.awaze.common/aws-client :ec2 credentials3432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3434
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args3433 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :authorize-security-group-egress,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials3436 & args3437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3438
     (com.palletops.awaze.common/aws-client :ec2 credentials3436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3438
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args3437 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m3439]
   (clojure.core/let
    [credentials3440 (:credentials m3439) args3441 (:args m3439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3442
      (com.palletops.awaze.common/aws-client :ec2 credentials3440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3442
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args3441 0)))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :authorize-security-group-ingress,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupIngress"}
   [credentials3444 & args3445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3446
     (com.palletops.awaze.common/aws-client :ec2 credentials3444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3446
      authorizeSecurityGroupIngress
      (ec2/authorize-security-group-ingress-request
       (clojure.core/nth args3445 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m3447]
   (clojure.core/let
    [credentials3448 (:credentials m3447) args3449 (:args m3447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3450
      (com.palletops.awaze.common/aws-client :ec2 credentials3448)]
     (clojure.core/case
      (clojure.core/count args3449)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3450
        describeAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3450
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args3449 0))))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-addresses,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-addresses,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials3452 & args3453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3454
     (com.palletops.awaze.common/aws-client :ec2 credentials3452)]
    (clojure.core/case
     (clojure.core/count args3453)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3454
       describeAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3454
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args3453 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m3455]
   (clojure.core/let
    [credentials3456 (:credentials m3455) args3457 (:args m3455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3458
      (com.palletops.awaze.common/aws-client :ec2 credentials3456)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3458
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args3457 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vpn-connection-route,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials3460 & args3461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3462
     (com.palletops.awaze.common/aws-client :ec2 credentials3460)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3462
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args3461 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m3463]
   (clojure.core/let
    [credentials3464 (:credentials m3463) args3465 (:args m3463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3466
      (com.palletops.awaze.common/aws-client :ec2 credentials3464)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3466
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args3465 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :associate-address,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call associateAddress"}
   [credentials3468 & args3469]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3470
     (com.palletops.awaze.common/aws-client :ec2 credentials3468)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3470
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args3469 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m3471]
   (clojure.core/let
    [credentials3472 (:credentials m3471) args3473 (:args m3471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3474
      (com.palletops.awaze.common/aws-client :ec2 credentials3472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3474
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args3473 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-instance-export-task,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials3476 & args3477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3478
     (com.palletops.awaze.common/aws-client :ec2 credentials3476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3478
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args3477 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m3479]
   (clojure.core/let
    [credentials3480 (:credentials m3479) args3481 (:args m3479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3482
      (com.palletops.awaze.common/aws-client :ec2 credentials3480)]
     (clojure.core/case
      (clojure.core/count args3481)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3482
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3482
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args3481 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-key-pairs,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-key-pairs,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials3484 & args3485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3486
     (com.palletops.awaze.common/aws-client :ec2 credentials3484)]
    (clojure.core/case
     (clojure.core/count args3485)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3486
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3486
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args3485 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-requests
   [m3487]
   (clojure.core/let
    [credentials3488 (:credentials m3487) args3489 (:args m3487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3490
      (com.palletops.awaze.common/aws-client :ec2 credentials3488)]
     (clojure.core/case
      (clojure.core/count args3489)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3490
        describeSpotFleetRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3490
        describeSpotFleetRequests
        (ec2/describe-spot-fleet-requests-request
         (clojure.core/nth args3489 0))))))))
  (clojure.core/defn
   describe-spot-fleet-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequests, describeSpotFleetRequests"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequests, describeSpotFleetRequests"}
   [credentials3492 & args3493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3494
     (com.palletops.awaze.common/aws-client :ec2 credentials3492)]
    (clojure.core/case
     (clojure.core/count args3493)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3494
       describeSpotFleetRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3494
       describeSpotFleetRequests
       (ec2/describe-spot-fleet-requests-request
        (clojure.core/nth args3493 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m3495]
   (clojure.core/let
    [credentials3496 (:credentials m3495) args3497 (:args m3495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3498
      (com.palletops.awaze.common/aws-client :ec2 credentials3496)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3498
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args3497 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-image-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImageAttribute"}
   [credentials3500 & args3501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3502
     (com.palletops.awaze.common/aws-client :ec2 credentials3500)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3502
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args3501 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-moving-addresses
   [m3503]
   (clojure.core/let
    [credentials3504 (:credentials m3503) args3505 (:args m3503)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3506
      (com.palletops.awaze.common/aws-client :ec2 credentials3504)]
     (clojure.core/case
      (clojure.core/count args3505)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3506
        describeMovingAddresses
        (ec2/describe-moving-addresses-request
         (clojure.core/nth args3505 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3506
        describeMovingAddresses))))))
  (clojure.core/defn
   describe-moving-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeMovingAddresses, describeMovingAddresses"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-moving-addresses,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-moving-addresses,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-moving-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeMovingAddresses, describeMovingAddresses"}
   [credentials3508 & args3509]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3510
     (com.palletops.awaze.common/aws-client :ec2 credentials3508)]
    (clojure.core/case
     (clojure.core/count args3509)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3510
       describeMovingAddresses
       (ec2/describe-moving-addresses-request
        (clojure.core/nth args3509 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3510
       describeMovingAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m3511]
   (clojure.core/let
    [credentials3512 (:credentials m3511) args3513 (:args m3511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3514
      (com.palletops.awaze.common/aws-client :ec2 credentials3512)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3514
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args3513 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-network-acl,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials3516 & args3517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3518
     (com.palletops.awaze.common/aws-client :ec2 credentials3516)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3518
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args3517 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m3519]
   (clojure.core/let
    [credentials3520 (:credentials m3519) args3521 (:args m3519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3522
      (com.palletops.awaze.common/aws-client :ec2 credentials3520)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3522
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args3521 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-network-interface,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials3524 & args3525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3526
     (com.palletops.awaze.common/aws-client :ec2 credentials3524)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3526
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args3525 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m3527]
   (clojure.core/let
    [credentials3528 (:credentials m3527) args3529 (:args m3527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3530
      (com.palletops.awaze.common/aws-client :ec2 credentials3528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3530
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args3529 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials3532 & args3533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3534
     (com.palletops.awaze.common/aws-client :ec2 credentials3532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3534
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args3533 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-scheduled-instances
   [m3535]
   (clojure.core/let
    [credentials3536 (:credentials m3535) args3537 (:args m3535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3538
      (com.palletops.awaze.common/aws-client :ec2 credentials3536)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3538
       purchaseScheduledInstances
       (ec2/purchase-scheduled-instances-request
        (clojure.core/nth args3537 0)))))))
  (clojure.core/defn
   purchase-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for purchaseScheduledInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :purchase-scheduled-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call purchaseScheduledInstances"}
   [credentials3540 & args3541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3542
     (com.palletops.awaze.common/aws-client :ec2 credentials3540)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3542
      purchaseScheduledInstances
      (ec2/purchase-scheduled-instances-request
       (clojure.core/nth args3541 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m3543]
   (clojure.core/let
    [credentials3544 (:credentials m3543) args3545 (:args m3543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3546
      (com.palletops.awaze.common/aws-client :ec2 credentials3544)]
     (clojure.core/case
      (clojure.core/count args3545)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3546
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args3545 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3546
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials3548 & args3549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3550
     (com.palletops.awaze.common/aws-client :ec2 credentials3548)]
    (clojure.core/case
     (clojure.core/count args3549)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3550
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args3549 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3550
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-classic-link-instances
   [m3551]
   (clojure.core/let
    [credentials3552 (:credentials m3551) args3553 (:args m3551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3554
      (com.palletops.awaze.common/aws-client :ec2 credentials3552)]
     (clojure.core/case
      (clojure.core/count args3553)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3554
        describeClassicLinkInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3554
        describeClassicLinkInstances
        (ec2/describe-classic-link-instances-request
         (clojure.core/nth args3553 0))))))))
  (clojure.core/defn
   describe-classic-link-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeClassicLinkInstances, describeClassicLinkInstances"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-classic-link-instances,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-classic-link-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-classic-link-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeClassicLinkInstances, describeClassicLinkInstances"}
   [credentials3556 & args3557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3558
     (com.palletops.awaze.common/aws-client :ec2 credentials3556)]
    (clojure.core/case
     (clojure.core/count args3557)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3558
       describeClassicLinkInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3558
       describeClassicLinkInstances
       (ec2/describe-classic-link-instances-request
        (clojure.core/nth args3557 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m3559]
   (clojure.core/let
    [credentials3560 (:credentials m3559) args3561 (:args m3559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3562
      (com.palletops.awaze.common/aws-client :ec2 credentials3560)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3562
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args3561 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials3564 & args3565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3566
     (com.palletops.awaze.common/aws-client :ec2 credentials3564)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3566
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args3565 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m3567]
   (clojure.core/let
    [credentials3568 (:credentials m3567) args3569 (:args m3567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3570
      (com.palletops.awaze.common/aws-client :ec2 credentials3568)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3570
       startInstances
       (ec2/start-instances-request (clojure.core/nth args3569 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :start-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call startInstances"}
   [credentials3572 & args3573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3574
     (com.palletops.awaze.common/aws-client :ec2 credentials3572)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3574
      startInstances
      (ec2/start-instances-request (clojure.core/nth args3573 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m3575]
   (clojure.core/let
    [credentials3576 (:credentials m3575) args3577 (:args m3575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3578
      (com.palletops.awaze.common/aws-client :ec2 credentials3576)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3578
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args3577 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-instance-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials3580 & args3581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3582
     (com.palletops.awaze.common/aws-client :ec2 credentials3580)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3582
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args3581 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-fleet-requests
   [m3583]
   (clojure.core/let
    [credentials3584 (:credentials m3583) args3585 (:args m3583)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3586
      (com.palletops.awaze.common/aws-client :ec2 credentials3584)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3586
       cancelSpotFleetRequests
       (ec2/cancel-spot-fleet-requests-request
        (clojure.core/nth args3585 0)))))))
  (clojure.core/defn
   cancel-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Generate map for cancelSpotFleetRequests"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-spot-fleet-requests,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Call cancelSpotFleetRequests"}
   [credentials3588 & args3589]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3590
     (com.palletops.awaze.common/aws-client :ec2 credentials3588)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3590
      cancelSpotFleetRequests
      (ec2/cancel-spot-fleet-requests-request
       (clojure.core/nth args3589 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m3591]
   (clojure.core/let
    [credentials3592 (:credentials m3591) args3593 (:args m3591)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3594
      (com.palletops.awaze.common/aws-client :ec2 credentials3592)]
     (clojure.core/case
      (clojure.core/count args3593)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3594
        describeSubnets))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3594
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args3593 0))))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-subnets,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-subnets,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials3596 & args3597]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3598
     (com.palletops.awaze.common/aws-client :ec2 credentials3596)]
    (clojure.core/case
     (clojure.core/count args3597)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3598
       describeSubnets))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3598
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args3597 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m3599]
   (clojure.core/let
    [credentials3600 (:credentials m3599) args3601 (:args m3599)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3602
      (com.palletops.awaze.common/aws-client :ec2 credentials3600)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3602
       createVolume
       (ec2/create-volume-request (clojure.core/nth args3601 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-volume,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Call createVolume"}
   [credentials3604 & args3605]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3606
     (com.palletops.awaze.common/aws-client :ec2 credentials3604)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3606
      createVolume
      (ec2/create-volume-request (clojure.core/nth args3605 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m3607]
   (clojure.core/let
    [credentials3608 (:credentials m3607) args3609 (:args m3607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3610
      (com.palletops.awaze.common/aws-client :ec2 credentials3608)]
     (clojure.core/case
      (clojure.core/count args3609)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3610
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3610
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args3609 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials3612 & args3613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3614
     (com.palletops.awaze.common/aws-client :ec2 credentials3612)]
    (clojure.core/case
     (clojure.core/count args3613)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3614
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3614
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args3613 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m3615]
   (clojure.core/let
    [credentials3616 (:credentials m3615) args3617 (:args m3615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3618
      (com.palletops.awaze.common/aws-client :ec2 credentials3616)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3618
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args3617 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-dhcp-options,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Call createDhcpOptions"}
   [credentials3620 & args3621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3622
     (com.palletops.awaze.common/aws-client :ec2 credentials3620)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3622
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args3621 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m3623]
   (clojure.core/let
    [credentials3624 (:credentials m3623) args3625 (:args m3623)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3626
      (com.palletops.awaze.common/aws-client :ec2 credentials3624)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3626
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args3625 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-internet-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call detachInternetGateway"}
   [credentials3628 & args3629]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3630
     (com.palletops.awaze.common/aws-client :ec2 credentials3628)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3630
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args3629 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m3631]
   (clojure.core/let
    [credentials3632 (:credentials m3631) args3633 (:args m3631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3634
      (com.palletops.awaze.common/aws-client :ec2 credentials3632)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3634
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args3633 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vpn-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials3636 & args3637]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3638
     (com.palletops.awaze.common/aws-client :ec2 credentials3636)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3638
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args3637 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m3639]
   (clojure.core/let
    [credentials3640 (:credentials m3639) args3641 (:args m3639)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3642
      (com.palletops.awaze.common/aws-client :ec2 credentials3640)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3642
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args3641 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :request-spot-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call requestSpotInstances"}
   [credentials3644 & args3645]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3646
     (com.palletops.awaze.common/aws-client :ec2 credentials3644)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3646
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args3645 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m3647]
   (clojure.core/let
    [credentials3648 (:credentials m3647) args3649 (:args m3647)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3650
      (com.palletops.awaze.common/aws-client :ec2 credentials3648)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3650
       importVolume
       (ec2/import-volume-request (clojure.core/nth args3649 0)))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importVolume"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :import-volume,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Call importVolume"}
   [credentials3652 & args3653]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3654
     (com.palletops.awaze.common/aws-client :ec2 credentials3652)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3654
      importVolume
      (ec2/import-volume-request (clojure.core/nth args3653 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-snapshot
   [m3655]
   (clojure.core/let
    [credentials3656 (:credentials m3655) args3657 (:args m3655)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3658
      (com.palletops.awaze.common/aws-client :ec2 credentials3656)]
     (clojure.core/case
      (clojure.core/count args3657)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3658
        importSnapshot))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3658
        importSnapshot
        (ec2/import-snapshot-request (clojure.core/nth args3657 0))))))))
  (clojure.core/defn
   import-snapshot-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]]),
    :doc "Generate map for importSnapshot, importSnapshot"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :import-snapshot,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :import-snapshot,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-snapshot
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]]),
    :doc "Call importSnapshot, importSnapshot"}
   [credentials3660 & args3661]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3662
     (com.palletops.awaze.common/aws-client :ec2 credentials3660)]
    (clojure.core/case
     (clojure.core/count args3661)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3662
       importSnapshot))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3662
       importSnapshot
       (ec2/import-snapshot-request (clojure.core/nth args3661 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m3663]
   (clojure.core/let
    [credentials3664 (:credentials m3663) args3665 (:args m3663)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3666
      (com.palletops.awaze.common/aws-client :ec2 credentials3664)]
     (clojure.core/case
      (clojure.core/count args3665)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3666
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args3665 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3666
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials3668 & args3669]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3670
     (com.palletops.awaze.common/aws-client :ec2 credentials3668)]
    (clojure.core/case
     (clojure.core/count args3669)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3670
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args3669 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3670
       describeTags))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m3671]
   (clojure.core/let
    [credentials3672 (:credentials m3671) args3673 (:args m3671)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3674
      (com.palletops.awaze.common/aws-client :ec2 credentials3672)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3674
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args3673 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials3676 & args3677]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3678
     (com.palletops.awaze.common/aws-client :ec2 credentials3676)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3678
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args3677 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link
   [m3679]
   (clojure.core/let
    [credentials3680 (:credentials m3679) args3681 (:args m3679)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3682
      (com.palletops.awaze.common/aws-client :ec2 credentials3680)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3682
       enableVpcClassicLink
       (ec2/enable-vpc-classic-link-request
        (clojure.core/nth args3681 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLink"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLink"}
   [credentials3684 & args3685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3686
     (com.palletops.awaze.common/aws-client :ec2 credentials3684)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3686
      enableVpcClassicLink
      (ec2/enable-vpc-classic-link-request
       (clojure.core/nth args3685 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m3687]
   (clojure.core/let
    [credentials3688 (:credentials m3687) args3689 (:args m3687)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3690
      (com.palletops.awaze.common/aws-client :ec2 credentials3688)]
     (clojure.core/case
      (clojure.core/count args3689)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3690
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3690
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args3689 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials3692 & args3693]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3694
     (com.palletops.awaze.common/aws-client :ec2 credentials3692)]
    (clojure.core/case
     (clojure.core/count args3693)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3694
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3694
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args3693 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m3695]
   (clojure.core/let
    [credentials3696 (:credentials m3695) args3697 (:args m3695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3698
      (com.palletops.awaze.common/aws-client :ec2 credentials3696)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3698
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args3697 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vpn-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnGateway"}
   [credentials3700 & args3701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3702
     (com.palletops.awaze.common/aws-client :ec2 credentials3700)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3702
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args3701 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m3703]
   (clojure.core/let
    [credentials3704 (:credentials m3703) args3705 (:args m3703)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3706
      (com.palletops.awaze.common/aws-client :ec2 credentials3704)]
     (clojure.core/case
      (clojure.core/count args3705)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3706
        describeRouteTables))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3706
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args3705 0))))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-route-tables,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-route-tables,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials3708 & args3709]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3710
     (com.palletops.awaze.common/aws-client :ec2 credentials3708)]
    (clojure.core/case
     (clojure.core/count args3709)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3710
       describeRouteTables))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3710
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args3709 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m3711]
   (clojure.core/let
    [credentials3712 (:credentials m3711) args3713 (:args m3711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3714
      (com.palletops.awaze.common/aws-client :ec2 credentials3712)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3714
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args3713 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials3716 & args3717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3718
     (com.palletops.awaze.common/aws-client :ec2 credentials3716)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3718
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args3717 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m3719]
   (clojure.core/let
    [credentials3720 (:credentials m3719) args3721 (:args m3719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3722
      (com.palletops.awaze.common/aws-client :ec2 credentials3720)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3722
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args3721 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :assign-private-ip-addresses,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials3724 & args3725]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3726
     (com.palletops.awaze.common/aws-client :ec2 credentials3724)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3726
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args3725 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link-dns-support
   [m3727]
   (clojure.core/let
    [credentials3728 (:credentials m3727) args3729 (:args m3727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3730
      (com.palletops.awaze.common/aws-client :ec2 credentials3728)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3730
       disableVpcClassicLinkDnsSupport
       (ec2/disable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3729 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLinkDnsSupport"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link-dns-support,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLinkDnsSupport"}
   [credentials3732 & args3733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3734
     (com.palletops.awaze.common/aws-client :ec2 credentials3732)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3734
      disableVpcClassicLinkDnsSupport
      (ec2/disable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3733 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m3735]
   (clojure.core/let
    [credentials3736 (:credentials m3735) args3737 (:args m3735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3738
      (com.palletops.awaze.common/aws-client :ec2 credentials3736)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3738
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args3737 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-placement-group,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials3740 & args3741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3742
     (com.palletops.awaze.common/aws-client :ec2 credentials3740)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3742
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args3741 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m3743]
   (clojure.core/let
    [credentials3744 (:credentials m3743) args3745 (:args m3743)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3746
      (com.palletops.awaze.common/aws-client :ec2 credentials3744)]
     (clojure.core/case
      (clojure.core/count args3745)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3746
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args3745 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3746
        describeInstances))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-instances,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials3748 & args3749]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3750
     (com.palletops.awaze.common/aws-client :ec2 credentials3748)]
    (clojure.core/case
     (clojure.core/count args3749)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3750
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args3749 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3750
       describeInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m3751]
   (clojure.core/let
    [credentials3752 (:credentials m3751) args3753 (:args m3751)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3754
      (com.palletops.awaze.common/aws-client :ec2 credentials3752)]
     (clojure.core/case
      (clojure.core/count args3753)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3754
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3754
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args3753 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-volumes,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-volumes,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials3756 & args3757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3758
     (com.palletops.awaze.common/aws-client :ec2 credentials3756)]
    (clojure.core/case
     (clojure.core/count args3757)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3758
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3758
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args3757 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m3759]
   (clojure.core/let
    [credentials3760 (:credentials m3759) args3761 (:args m3759)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3762
      (com.palletops.awaze.common/aws-client :ec2 credentials3760)]
     (clojure.core/case
      (clojure.core/count args3761)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3762
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args3761 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3762
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-bundle-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-bundle-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials3764 & args3765]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3766
     (com.palletops.awaze.common/aws-client :ec2 credentials3764)]
    (clojure.core/case
     (clojure.core/count args3765)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3766
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args3765 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3766
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m3767]
   (clojure.core/let
    [credentials3768 (:credentials m3767) args3769 (:args m3767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3770
      (com.palletops.awaze.common/aws-client :ec2 credentials3768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3770
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args3769 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :associate-dhcp-options,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials3772 & args3773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3774
     (com.palletops.awaze.common/aws-client :ec2 credentials3772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3774
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args3773 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m3775]
   (clojure.core/let
    [credentials3776 (:credentials m3775) args3777 (:args m3775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3778
      (com.palletops.awaze.common/aws-client :ec2 credentials3776)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3778
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args3777 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-vpc-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials3780 & args3781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3782
     (com.palletops.awaze.common/aws-client :ec2 credentials3780)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3782
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args3781 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-flow-logs
   [m3783]
   (clojure.core/let
    [credentials3784 (:credentials m3783) args3785 (:args m3783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3786
      (com.palletops.awaze.common/aws-client :ec2 credentials3784)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3786
       createFlowLogs
       (ec2/create-flow-logs-request (clojure.core/nth args3785 0)))))))
  (clojure.core/defn
   create-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createFlowLogs"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-flow-logs,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createFlowLogs"}
   [credentials3788 & args3789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3790
     (com.palletops.awaze.common/aws-client :ec2 credentials3788)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3790
      createFlowLogs
      (ec2/create-flow-logs-request (clojure.core/nth args3789 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m3791]
   (clojure.core/let
    [credentials3792 (:credentials m3791) args3793 (:args m3791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3794
      (com.palletops.awaze.common/aws-client :ec2 credentials3792)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3794
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args3793 0)))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for disassociateAddress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disassociate-address,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call disassociateAddress"}
   [credentials3796 & args3797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3798
     (com.palletops.awaze.common/aws-client :ec2 credentials3796)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3798
      disassociateAddress
      (ec2/disassociate-address-request (clojure.core/nth args3797 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m3799]
   (clojure.core/let
    [credentials3800 (:credentials m3799) args3801 (:args m3799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3802
      (com.palletops.awaze.common/aws-client :ec2 credentials3800)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3802
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args3801 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-network-interface-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials3804 & args3805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3806
     (com.palletops.awaze.common/aws-client :ec2 credentials3804)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3806
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args3805 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m3807]
   (clojure.core/let
    [credentials3808 (:credentials m3807) args3809 (:args m3807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3810
      (com.palletops.awaze.common/aws-client :ec2 credentials3808)]
     (clojure.core/case
      (clojure.core/count args3809)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3810
        describePlacementGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3810
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args3809 0))))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-placement-groups,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-placement-groups,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials3812 & args3813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3814
     (com.palletops.awaze.common/aws-client :ec2 credentials3812)]
    (clojure.core/case
     (clojure.core/count args3813)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3814
       describePlacementGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3814
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args3813 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m3815]
   (clojure.core/let
    [credentials3816 (:credentials m3815) args3817 (:args m3815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3818
      (com.palletops.awaze.common/aws-client :ec2 credentials3816)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3818
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args3817 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :reset-snapshot-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials3820 & args3821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3822
     (com.palletops.awaze.common/aws-client :ec2 credentials3820)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3822
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args3821 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m3823]
   (clojure.core/let
    [credentials3824 (:credentials m3823) args3825 (:args m3823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3826
      (com.palletops.awaze.common/aws-client :ec2 credentials3824)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3826
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args3825 0)))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for releaseAddress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :release-address,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call releaseAddress"}
   [credentials3828 & args3829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3830
     (com.palletops.awaze.common/aws-client :ec2 credentials3828)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3830
      releaseAddress
      (ec2/release-address-request (clojure.core/nth args3829 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m3831]
   (clojure.core/let
    [credentials3832 (:credentials m3831) args3833 (:args m3831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3834
      (com.palletops.awaze.common/aws-client :ec2 credentials3832)]
     (clojure.core/case
      (clojure.core/count args3833)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3834
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3834
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args3833 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-volume-status,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-volume-status,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials3836 & args3837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3838
     (com.palletops.awaze.common/aws-client :ec2 credentials3836)]
    (clojure.core/case
     (clojure.core/count args3837)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3838
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3838
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args3837 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m3839]
   (clojure.core/let
    [credentials3840 (:credentials m3839) args3841 (:args m3839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3842
      (com.palletops.awaze.common/aws-client :ec2 credentials3840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3842
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args3841 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :bundle-instance,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Call bundleInstance"}
   [credentials3844 & args3845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3846
     (com.palletops.awaze.common/aws-client :ec2 credentials3844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3846
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args3845 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m3847]
   (clojure.core/let
    [credentials3848 (:credentials m3847) args3849 (:args m3847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3850
      (com.palletops.awaze.common/aws-client :ec2 credentials3848)]
     (clojure.core/case
      (clojure.core/count args3849)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3850
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args3849 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3850
        describeVpnConnections))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpn-connections,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpn-connections,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials3852 & args3853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3854
     (com.palletops.awaze.common/aws-client :ec2 credentials3852)]
    (clojure.core/case
     (clojure.core/count args3853)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3854
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args3853 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3854
       describeVpnConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m3855]
   (clojure.core/let
    [credentials3856 (:credentials m3855) args3857 (:args m3855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3858
      (com.palletops.awaze.common/aws-client :ec2 credentials3856)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3858
       createRoute
       (ec2/create-route-request (clojure.core/nth args3857 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-route,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call createRoute"}
   [credentials3860 & args3861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3862
     (com.palletops.awaze.common/aws-client :ec2 credentials3860)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3862
      createRoute
      (ec2/create-route-request (clojure.core/nth args3861 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m3863]
   (clojure.core/let
    [credentials3864 (:credentials m3863) args3865 (:args m3863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3866
      (com.palletops.awaze.common/aws-client :ec2 credentials3864)]
     (clojure.core/case
      (clojure.core/count args3865)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3866
        describeSpotPriceHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3866
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args3865 0))))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-spot-price-history,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-spot-price-history,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials3868 & args3869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3870
     (com.palletops.awaze.common/aws-client :ec2 credentials3868)]
    (clojure.core/case
     (clojure.core/count args3869)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3870
       describeSpotPriceHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3870
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args3869 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m3871]
   (clojure.core/let
    [credentials3872 (:credentials m3871) args3873 (:args m3871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3874
      (com.palletops.awaze.common/aws-client :ec2 credentials3872)]
     (clojure.core/case
      (clojure.core/count args3873)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3874
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args3873 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3874
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-availability-zones,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-availability-zones,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials3876 & args3877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3878
     (com.palletops.awaze.common/aws-client :ec2 credentials3876)]
    (clojure.core/case
     (clojure.core/count args3877)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3878
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args3877 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3878
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m3879]
   (clojure.core/let
    [credentials3880 (:credentials m3879) args3881 (:args m3879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3882
      (com.palletops.awaze.common/aws-client :ec2 credentials3880)]
     (clojure.core/case
      (clojure.core/count args3881)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3882
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args3881 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3882
        createVpcPeeringConnection))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials3884 & args3885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3886
     (com.palletops.awaze.common/aws-client :ec2 credentials3884)]
    (clojure.core/case
     (clojure.core/count args3885)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3886
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args3885 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3886
       createVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m3887]
   (clojure.core/let
    [credentials3888 (:credentials m3887) args3889 (:args m3887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3890
      (com.palletops.awaze.common/aws-client :ec2 credentials3888)]
     (clojure.core/case
      (clojure.core/count args3889)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3890
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args3889 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3890
        describeInternetGateways))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-internet-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-internet-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials3892 & args3893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3894
     (com.palletops.awaze.common/aws-client :ec2 credentials3892)]
    (clojure.core/case
     (clojure.core/count args3893)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3894
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args3893 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3894
       describeInternetGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m3895]
   (clojure.core/let
    [credentials3896 (:credentials m3895) args3897 (:args m3895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3898
      (com.palletops.awaze.common/aws-client :ec2 credentials3896)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3898
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args3897 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disassociate-route-table,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials3900 & args3901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3902
     (com.palletops.awaze.common/aws-client :ec2 credentials3900)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3902
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args3901 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m3903]
   (clojure.core/let
    [credentials3904 (:credentials m3903) args3905 (:args m3903)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3906
      (com.palletops.awaze.common/aws-client :ec2 credentials3904)]
     (clojure.core/case
      (clojure.core/count args3905)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3906
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args3905 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3906
        describeRegions))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-regions,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-regions,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials3908 & args3909]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3910
     (com.palletops.awaze.common/aws-client :ec2 credentials3908)]
    (clojure.core/case
     (clojure.core/count args3909)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3910
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args3909 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3910
       describeRegions))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link-dns-support
   [m3911]
   (clojure.core/let
    [credentials3912 (:credentials m3911) args3913 (:args m3911)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3914
      (com.palletops.awaze.common/aws-client :ec2 credentials3912)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3914
       enableVpcClassicLinkDnsSupport
       (ec2/enable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3913 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLinkDnsSupport"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link-dns-support,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLinkDnsSupport"}
   [credentials3916 & args3917]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3918
     (com.palletops.awaze.common/aws-client :ec2 credentials3916)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3918
      enableVpcClassicLinkDnsSupport
      (ec2/enable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3917 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m3919]
   (clojure.core/let
    [credentials3920 (:credentials m3919) args3921 (:args m3919)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3922
      (com.palletops.awaze.common/aws-client :ec2 credentials3920)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3922
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args3921 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :deregister-image,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterImage"}
   [credentials3924 & args3925]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3926
     (com.palletops.awaze.common/aws-client :ec2 credentials3924)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3926
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args3925 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m3927]
   (clojure.core/let
    [credentials3928 (:credentials m3927) args3929 (:args m3927)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3930
      (com.palletops.awaze.common/aws-client :ec2 credentials3928)]
     (clojure.core/case
      (clojure.core/count args3929)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3930
        deleteSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3930
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args3929 0))))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials3932 & args3933]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3934
     (com.palletops.awaze.common/aws-client :ec2 credentials3932)]
    (clojure.core/case
     (clojure.core/count args3933)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3934
       deleteSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3934
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args3933 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m3935]
   (clojure.core/let
    [credentials3936 (:credentials m3935) args3937 (:args m3935)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3938
      (com.palletops.awaze.common/aws-client :ec2 credentials3936)]
     (clojure.core/case
      (clojure.core/count args3937)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3938
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args3937 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3938
        describeCustomerGateways))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-customer-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-customer-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials3940 & args3941]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3942
     (com.palletops.awaze.common/aws-client :ec2 credentials3940)]
    (clojure.core/case
     (clojure.core/count args3941)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3942
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args3941 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3942
       describeCustomerGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-request-history
   [m3943]
   (clojure.core/let
    [credentials3944 (:credentials m3943) args3945 (:args m3943)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3946
      (com.palletops.awaze.common/aws-client :ec2 credentials3944)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3946
       describeSpotFleetRequestHistory
       (ec2/describe-spot-fleet-request-history-request
        (clojure.core/nth args3945 0)))))))
  (clojure.core/defn
   describe-spot-fleet-request-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequestHistory"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-request-history,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-request-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequestHistory"}
   [credentials3948 & args3949]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3950
     (com.palletops.awaze.common/aws-client :ec2 credentials3948)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3950
      describeSpotFleetRequestHistory
      (ec2/describe-spot-fleet-request-history-request
       (clojure.core/nth args3949 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m3951]
   (clojure.core/let
    [credentials3952 (:credentials m3951) args3953 (:args m3951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3954
      (com.palletops.awaze.common/aws-client :ec2 credentials3952)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3954
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args3953 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-subnet,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createSubnet"}
   [credentials3956 & args3957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3958
     (com.palletops.awaze.common/aws-client :ec2 credentials3956)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3958
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args3957 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m3959]
   (clojure.core/let
    [credentials3960 (:credentials m3959) args3961 (:args m3959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3962
      (com.palletops.awaze.common/aws-client :ec2 credentials3960)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3962
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args3961 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-network-interface-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials3964 & args3965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3966
     (com.palletops.awaze.common/aws-client :ec2 credentials3964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3966
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args3965 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-placement
   [m3967]
   (clojure.core/let
    [credentials3968 (:credentials m3967) args3969 (:args m3967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3970
      (com.palletops.awaze.common/aws-client :ec2 credentials3968)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3970
       modifyInstancePlacement
       (ec2/modify-instance-placement-request
        (clojure.core/nth args3969 0)))))))
  (clojure.core/defn
   modify-instance-placement-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstancePlacement"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-instance-placement,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-placement
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstancePlacement"}
   [credentials3972 & args3973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3974
     (com.palletops.awaze.common/aws-client :ec2 credentials3972)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3974
      modifyInstancePlacement
      (ec2/modify-instance-placement-request
       (clojure.core/nth args3973 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-classic-link-vpc
   [m3975]
   (clojure.core/let
    [credentials3976 (:credentials m3975) args3977 (:args m3975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3978
      (com.palletops.awaze.common/aws-client :ec2 credentials3976)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3978
       detachClassicLinkVpc
       (ec2/detach-classic-link-vpc-request
        (clojure.core/nth args3977 0)))))))
  (clojure.core/defn
   detach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachClassicLinkVpc"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-classic-link-vpc,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachClassicLinkVpc"}
   [credentials3980 & args3981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3982
     (com.palletops.awaze.common/aws-client :ec2 credentials3980)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3982
      detachClassicLinkVpc
      (ec2/detach-classic-link-vpc-request
       (clojure.core/nth args3981 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m3983]
   (clojure.core/let
    [credentials3984 (:credentials m3983) args3985 (:args m3983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3986
      (com.palletops.awaze.common/aws-client :ec2 credentials3984)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3986
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args3985 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-conversion-task,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelConversionTask"}
   [credentials3988 & args3989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3990
     (com.palletops.awaze.common/aws-client :ec2 credentials3988)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3990
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args3989 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m3991]
   (clojure.core/let
    [credentials3992 (:credentials m3991) args3993 (:args m3991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3994
      (com.palletops.awaze.common/aws-client :ec2 credentials3992)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3994
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args3993 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-network-interface,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Call createNetworkInterface"}
   [credentials3996 & args3997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3998
     (com.palletops.awaze.common/aws-client :ec2 credentials3996)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3998
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args3997 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m3999]
   (clojure.core/let
    [credentials4000 (:credentials m3999) args4001 (:args m3999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4002
      (com.palletops.awaze.common/aws-client :ec2 credentials4000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4002
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args4001 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-image-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials4004 & args4005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4006
     (com.palletops.awaze.common/aws-client :ec2 credentials4004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4006
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args4005 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m4007]
   (clojure.core/let
    [credentials4008 (:credentials m4007) args4009 (:args m4007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4010
      (com.palletops.awaze.common/aws-client :ec2 credentials4008)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4010
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args4009 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-route-table,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRouteTable"}
   [credentials4012 & args4013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4014
     (com.palletops.awaze.common/aws-client :ec2 credentials4012)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4014
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args4013 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m4015]
   (clojure.core/let
    [credentials4016 (:credentials m4015) args4017 (:args m4015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4018
      (com.palletops.awaze.common/aws-client :ec2 credentials4016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4018
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args4017 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :associate-route-table,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call associateRouteTable"}
   [credentials4020 & args4021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4022
     (com.palletops.awaze.common/aws-client :ec2 credentials4020)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4022
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args4021 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m4023]
   (clojure.core/let
    [credentials4024 (:credentials m4023) args4025 (:args m4023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4026
      (com.palletops.awaze.common/aws-client :ec2 credentials4024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4026
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args4025 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-customer-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials4028 & args4029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4030
     (com.palletops.awaze.common/aws-client :ec2 credentials4028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4030
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args4029 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m4031]
   (clojure.core/let
    [credentials4032 (:credentials m4031) args4033 (:args m4031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4034
      (com.palletops.awaze.common/aws-client :ec2 credentials4032)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4034
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args4033 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :replace-route-table-association,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials4036 & args4037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4038
     (com.palletops.awaze.common/aws-client :ec2 credentials4036)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4038
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args4037 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m4039]
   (clojure.core/let
    [credentials4040 (:credentials m4039) args4041 (:args m4039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4042
      (com.palletops.awaze.common/aws-client :ec2 credentials4040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4042
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args4041 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vpc,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpc"}
   [credentials4044 & args4045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4046
     (com.palletops.awaze.common/aws-client :ec2 credentials4044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4046
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args4045 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m4047]
   (clojure.core/let
    [credentials4048 (:credentials m4047) args4049 (:args m4047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4050
      (com.palletops.awaze.common/aws-client :ec2 credentials4048)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4050
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args4049 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-key-pair,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createKeyPair"}
   [credentials4052 & args4053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4054
     (com.palletops.awaze.common/aws-client :ec2 credentials4052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4054
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args4053 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-hosts
   [m4055]
   (clojure.core/let
    [credentials4056 (:credentials m4055) args4057 (:args m4055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4058
      (com.palletops.awaze.common/aws-client :ec2 credentials4056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4058
       allocateHosts
       (ec2/allocate-hosts-request (clojure.core/nth args4057 0)))))))
  (clojure.core/defn
   allocate-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Generate map for allocateHosts"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :allocate-hosts,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Call allocateHosts"}
   [credentials4060 & args4061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4062
     (com.palletops.awaze.common/aws-client :ec2 credentials4060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4062
      allocateHosts
      (ec2/allocate-hosts-request (clojure.core/nth args4061 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m4063]
   (clojure.core/let
    [credentials4064 (:credentials m4063) args4065 (:args m4063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4066
      (com.palletops.awaze.common/aws-client :ec2 credentials4064)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4066
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args4065 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :replace-route,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRoute"}
   [credentials4068 & args4069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4070
     (com.palletops.awaze.common/aws-client :ec2 credentials4068)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4070
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args4069 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m4071]
   (clojure.core/let
    [credentials4072 (:credentials m4071) args4073 (:args m4071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4074
      (com.palletops.awaze.common/aws-client :ec2 credentials4072)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4074
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args4073 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :terminate-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstances"}
   [credentials4076 & args4077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4078
     (com.palletops.awaze.common/aws-client :ec2 credentials4076)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4078
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args4077 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m4079]
   (clojure.core/let
    [credentials4080 (:credentials m4079) args4081 (:args m4079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4082
      (com.palletops.awaze.common/aws-client :ec2 credentials4080)]
     (clojure.core/case
      (clojure.core/count args4081)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4082
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4082
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args4081 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials4084 & args4085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4086
     (com.palletops.awaze.common/aws-client :ec2 credentials4084)]
    (clojure.core/case
     (clojure.core/count args4085)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4086
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4086
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args4085 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m4087]
   (clojure.core/let
    [credentials4088 (:credentials m4087) args4089 (:args m4087)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4090
      (com.palletops.awaze.common/aws-client :ec2 credentials4088)]
     (clojure.core/case
      (clojure.core/count args4089)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4090
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args4089 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4090
        describeVpnGateways))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpn-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpn-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials4092 & args4093]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4094
     (com.palletops.awaze.common/aws-client :ec2 credentials4092)]
    (clojure.core/case
     (clojure.core/count args4093)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4094
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args4093 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4094
       describeVpnGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m4095]
   (clojure.core/let
    [credentials4096 (:credentials m4095) args4097 (:args m4095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4098
      (com.palletops.awaze.common/aws-client :ec2 credentials4096)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4098
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args4097 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-password-data,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPasswordData"}
   [credentials4100 & args4101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4102
     (com.palletops.awaze.common/aws-client :ec2 credentials4100)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4102
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args4101 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m4103]
   (clojure.core/let
    [credentials4104 (:credentials m4103) args4105 (:args m4103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4106
      (com.palletops.awaze.common/aws-client :ec2 credentials4104)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4106
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args4105 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-volume-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials4108 & args4109]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4110
     (com.palletops.awaze.common/aws-client :ec2 credentials4108)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4110
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args4109 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m4111]
   (clojure.core/let
    [credentials4112 (:credentials m4111) args4113 (:args m4111)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4114
      (com.palletops.awaze.common/aws-client :ec2 credentials4112)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4114
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args4113 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials4116 & args4117]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4118
     (com.palletops.awaze.common/aws-client :ec2 credentials4116)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4118
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args4117 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-instances
   [m4119]
   (clojure.core/let
    [credentials4120 (:credentials m4119) args4121 (:args m4119)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4122
      (com.palletops.awaze.common/aws-client :ec2 credentials4120)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4122
       describeSpotFleetInstances
       (ec2/describe-spot-fleet-instances-request
        (clojure.core/nth args4121 0)))))))
  (clojure.core/defn
   describe-spot-fleet-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetInstances"}
   [credentials4124 & args4125]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4126
     (com.palletops.awaze.common/aws-client :ec2 credentials4124)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4126
      describeSpotFleetInstances
      (ec2/describe-spot-fleet-instances-request
       (clojure.core/nth args4125 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-prefix-lists
   [m4127]
   (clojure.core/let
    [credentials4128 (:credentials m4127) args4129 (:args m4127)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4130
      (com.palletops.awaze.common/aws-client :ec2 credentials4128)]
     (clojure.core/case
      (clojure.core/count args4129)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4130
        describePrefixLists
        (ec2/describe-prefix-lists-request
         (clojure.core/nth args4129 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4130
        describePrefixLists))))))
  (clojure.core/defn
   describe-prefix-lists-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describePrefixLists, describePrefixLists"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-prefix-lists,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-prefix-lists,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-prefix-lists
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describePrefixLists, describePrefixLists"}
   [credentials4132 & args4133]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4134
     (com.palletops.awaze.common/aws-client :ec2 credentials4132)]
    (clojure.core/case
     (clojure.core/count args4133)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4134
       describePrefixLists
       (ec2/describe-prefix-lists-request
        (clojure.core/nth args4133 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4134
       describePrefixLists))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m4135]
   (clojure.core/let
    [credentials4136 (:credentials m4135) args4137 (:args m4135)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4138
      (com.palletops.awaze.common/aws-client :ec2 credentials4136)]
     (clojure.core/case
      (clojure.core/count args4137)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4138
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4138
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args4137 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-account-attributes,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-account-attributes,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials4140 & args4141]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4142
     (com.palletops.awaze.common/aws-client :ec2 credentials4140)]
    (clojure.core/case
     (clojure.core/count args4141)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4142
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4142
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args4141 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m4143]
   (clojure.core/let
    [credentials4144 (:credentials m4143) args4145 (:args m4143)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4146
      (com.palletops.awaze.common/aws-client :ec2 credentials4144)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4146
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args4145 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-vpn-connection,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnection"}
   [credentials4148 & args4149]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4150
     (com.palletops.awaze.common/aws-client :ec2 credentials4148)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4150
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args4149 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m4151]
   (clojure.core/let
    [credentials4152 (:credentials m4151) args4153 (:args m4151)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4154
      (com.palletops.awaze.common/aws-client :ec2 credentials4152)]
     (clojure.core/case
      (clojure.core/count args4153)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4154
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args4153 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4154
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials4156 & args4157]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4158
     (com.palletops.awaze.common/aws-client :ec2 credentials4156)]
    (clojure.core/case
     (clojure.core/count args4157)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4158
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args4157 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4158
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instance-availability
   [m4159]
   (clojure.core/let
    [credentials4160 (:credentials m4159) args4161 (:args m4159)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4162
      (com.palletops.awaze.common/aws-client :ec2 credentials4160)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4162
       describeScheduledInstanceAvailability
       (ec2/describe-scheduled-instance-availability-request
        (clojure.core/nth args4161 0)))))))
  (clojure.core/defn
   describe-scheduled-instance-availability-map
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstanceAvailability"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instance-availability,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instance-availability
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstanceAvailability"}
   [credentials4164 & args4165]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4166
     (com.palletops.awaze.common/aws-client :ec2 credentials4164)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4166
      describeScheduledInstanceAvailability
      (ec2/describe-scheduled-instance-availability-request
       (clojure.core/nth args4165 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-flow-logs
   [m4167]
   (clojure.core/let
    [credentials4168 (:credentials m4167) args4169 (:args m4167)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4170
      (com.palletops.awaze.common/aws-client :ec2 credentials4168)]
     (clojure.core/case
      (clojure.core/count args4169)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4170
        describeFlowLogs
        (ec2/describe-flow-logs-request (clojure.core/nth args4169 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4170
        describeFlowLogs))))))
  (clojure.core/defn
   describe-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeFlowLogs, describeFlowLogs"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-flow-logs,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-flow-logs,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeFlowLogs, describeFlowLogs"}
   [credentials4172 & args4173]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4174
     (com.palletops.awaze.common/aws-client :ec2 credentials4172)]
    (clojure.core/case
     (clojure.core/count args4173)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4174
       describeFlowLogs
       (ec2/describe-flow-logs-request (clojure.core/nth args4173 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4174
       describeFlowLogs))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m4175]
   (clojure.core/let
    [credentials4176 (:credentials m4175) args4177 (:args m4175)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4178
      (com.palletops.awaze.common/aws-client :ec2 credentials4176)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4178
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args4177 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-bundle-task,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelBundleTask"}
   [credentials4180 & args4181]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4182
     (com.palletops.awaze.common/aws-client :ec2 credentials4180)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4182
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args4181 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m4183]
   (clojure.core/let
    [credentials4184 (:credentials m4183) args4185 (:args m4183)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4186
      (com.palletops.awaze.common/aws-client :ec2 credentials4184)]
     (clojure.core/case
      (clojure.core/count args4185)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4186
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args4185 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4186
        describeReservedInstances))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-reserved-instances,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials4188 & args4189]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4190
     (com.palletops.awaze.common/aws-client :ec2 credentials4188)]
    (clojure.core/case
     (clojure.core/count args4189)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4190
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args4189 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4190
       describeReservedInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m4191]
   (clojure.core/let
    [credentials4192 (:credentials m4191) args4193 (:args m4191)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4194
      (com.palletops.awaze.common/aws-client :ec2 credentials4192)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4194
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args4193 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :unmonitor-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unmonitorInstances"}
   [credentials4196 & args4197]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4198
     (com.palletops.awaze.common/aws-client :ec2 credentials4196)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4198
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args4197 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m4199]
   (clojure.core/let
    [credentials4200 (:credentials m4199) args4201 (:args m4199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4202
      (com.palletops.awaze.common/aws-client :ec2 credentials4200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4202
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args4201 0)))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSecurityGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-security-group,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSecurityGroup"}
   [credentials4204 & args4205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4206
     (com.palletops.awaze.common/aws-client :ec2 credentials4204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4206
      deleteSecurityGroup
      (ec2/delete-security-group-request
       (clojure.core/nth args4205 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m4207]
   (clojure.core/let
    [credentials4208 (:credentials m4207) args4209 (:args m4207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4210
      (com.palletops.awaze.common/aws-client :ec2 credentials4208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4210
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args4209 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpc-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials4212 & args4213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4214
     (com.palletops.awaze.common/aws-client :ec2 credentials4212)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4214
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args4213 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m4215]
   (clojure.core/let
    [credentials4216 (:credentials m4215) args4217 (:args m4215)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4218
      (com.palletops.awaze.common/aws-client :ec2 credentials4216)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4218
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args4217 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-network-acl,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createNetworkAcl"}
   [credentials4220 & args4221]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4222
     (com.palletops.awaze.common/aws-client :ec2 credentials4220)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4222
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args4221 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-import-task
   [m4223]
   (clojure.core/let
    [credentials4224 (:credentials m4223) args4225 (:args m4223)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4226
      (com.palletops.awaze.common/aws-client :ec2 credentials4224)]
     (clojure.core/case
      (clojure.core/count args4225)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4226
        cancelImportTask))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4226
        cancelImportTask
        (ec2/cancel-import-task-request (clojure.core/nth args4225 0))))))))
  (clojure.core/defn
   cancel-import-task-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Generate map for cancelImportTask, cancelImportTask"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :cancel-import-task,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-import-task,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-import-task
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Call cancelImportTask, cancelImportTask"}
   [credentials4228 & args4229]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4230
     (com.palletops.awaze.common/aws-client :ec2 credentials4228)]
    (clojure.core/case
     (clojure.core/count args4229)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4230
       cancelImportTask))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4230
       cancelImportTask
       (ec2/cancel-import-task-request (clojure.core/nth args4229 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m4231]
   (clojure.core/let
    [credentials4232 (:credentials m4231) args4233 (:args m4231)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4234
      (com.palletops.awaze.common/aws-client :ec2 credentials4232)]
     (clojure.core/case
      (clojure.core/count args4233)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4234
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args4233 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4234
        acceptVpcPeeringConnection))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials4236 & args4237]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4238
     (com.palletops.awaze.common/aws-client :ec2 credentials4236)]
    (clojure.core/case
     (clojure.core/count args4237)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4238
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args4237 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4238
       acceptVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoint-services
   [m4239]
   (clojure.core/let
    [credentials4240 (:credentials m4239) args4241 (:args m4239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4242
      (com.palletops.awaze.common/aws-client :ec2 credentials4240)]
     (clojure.core/case
      (clojure.core/count args4241)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4242
        describeVpcEndpointServices
        (ec2/describe-vpc-endpoint-services-request
         (clojure.core/nth args4241 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4242
        describeVpcEndpointServices))))))
  (clojure.core/defn
   describe-vpc-endpoint-services-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeVpcEndpointServices, describeVpcEndpointServices"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoint-services
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeVpcEndpointServices, describeVpcEndpointServices"}
   [credentials4244 & args4245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4246
     (com.palletops.awaze.common/aws-client :ec2 credentials4244)]
    (clojure.core/case
     (clojure.core/count args4245)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4246
       describeVpcEndpointServices
       (ec2/describe-vpc-endpoint-services-request
        (clojure.core/nth args4245 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4246
       describeVpcEndpointServices))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m4247]
   (clojure.core/let
    [credentials4248 (:credentials m4247) args4249 (:args m4247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4250
      (com.palletops.awaze.common/aws-client :ec2 credentials4248)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4250
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args4249 0)))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpcPeeringConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpcPeeringConnection"}
   [credentials4252 & args4253]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4254
     (com.palletops.awaze.common/aws-client :ec2 credentials4252)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4254
      deleteVpcPeeringConnection
      (ec2/delete-vpc-peering-connection-request
       (clojure.core/nth args4253 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m4255]
   (clojure.core/let
    [credentials4256 (:credentials m4255) args4257 (:args m4255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4258
      (com.palletops.awaze.common/aws-client :ec2 credentials4256)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4258
       runInstances
       (ec2/run-instances-request (clojure.core/nth args4257 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :run-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call runInstances"}
   [credentials4260 & args4261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4262
     (com.palletops.awaze.common/aws-client :ec2 credentials4260)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4262
      runInstances
      (ec2/run-instances-request (clojure.core/nth args4261 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m4263]
   (clojure.core/let
    [credentials4264 (:credentials m4263) args4265 (:args m4263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4266
      (com.palletops.awaze.common/aws-client :ec2 credentials4264)]
     (clojure.core/case
      (clojure.core/count args4265)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4266
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4266
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args4265 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-instance-status,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-instance-status,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials4268 & args4269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4270
     (com.palletops.awaze.common/aws-client :ec2 credentials4268)]
    (clojure.core/case
     (clojure.core/count args4269)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4270
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4270
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args4269 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link-dns-support
   [m4271]
   (clojure.core/let
    [credentials4272 (:credentials m4271) args4273 (:args m4271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4274
      (com.palletops.awaze.common/aws-client :ec2 credentials4272)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4274
       describeVpcClassicLinkDnsSupport
       (ec2/describe-vpc-classic-link-dns-support-request
        (clojure.core/nth args4273 0)))))))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcClassicLinkDnsSupport"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link-dns-support,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcClassicLinkDnsSupport"}
   [credentials4276 & args4277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4278
     (com.palletops.awaze.common/aws-client :ec2 credentials4276)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4278
      describeVpcClassicLinkDnsSupport
      (ec2/describe-vpc-classic-link-dns-support-request
       (clojure.core/nth args4277 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m4279]
   (clojure.core/let
    [credentials4280 (:credentials m4279) args4281 (:args m4279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4282
      (com.palletops.awaze.common/aws-client :ec2 credentials4280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4282
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args4281 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials4284 & args4285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4286
     (com.palletops.awaze.common/aws-client :ec2 credentials4284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4286
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args4285 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m4287]
   (clojure.core/let
    [credentials4288 (:credentials m4287) args4289 (:args m4287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4290
      (com.palletops.awaze.common/aws-client :ec2 credentials4288)]
     (clojure.core/case
      (clojure.core/count args4289)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4290
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4290
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args4289 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-security-groups,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-security-groups,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials4292 & args4293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4294
     (com.palletops.awaze.common/aws-client :ec2 credentials4292)]
    (clojure.core/case
     (clojure.core/count args4293)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4294
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4294
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args4293 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m4295]
   (clojure.core/let
    [credentials4296 (:credentials m4295) args4297 (:args m4295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4298
      (com.palletops.awaze.common/aws-client :ec2 credentials4296)]
     (clojure.core/case
      (clojure.core/count args4297)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4298
        describeNetworkInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4298
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args4297 0))))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-network-interfaces,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-network-interfaces,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials4300 & args4301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4302
     (com.palletops.awaze.common/aws-client :ec2 credentials4300)]
    (clojure.core/case
     (clojure.core/count args4301)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4302
       describeNetworkInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4302
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args4301 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m4303]
   (clojure.core/let
    [credentials4304 (:credentials m4303) args4305 (:args m4303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4306
      (com.palletops.awaze.common/aws-client :ec2 credentials4304)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4306
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args4305 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-customer-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call createCustomerGateway"}
   [credentials4308 & args4309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4310
     (com.palletops.awaze.common/aws-client :ec2 credentials4308)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4310
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args4309 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m4311]
   (clojure.core/let
    [credentials4312 (:credentials m4311) args4313 (:args m4311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4314
      (com.palletops.awaze.common/aws-client :ec2 credentials4312)]
     (clojure.core/case
      (clojure.core/count args4313)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4314
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args4313 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4314
        describeDhcpOptions))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-dhcp-options,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-dhcp-options,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials4316 & args4317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4318
     (com.palletops.awaze.common/aws-client :ec2 credentials4316)]
    (clojure.core/case
     (clojure.core/count args4317)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4318
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args4317 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4318
       describeDhcpOptions))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m4319]
   (clojure.core/let
    [credentials4320 (:credentials m4319) args4321 (:args m4319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4322
      (com.palletops.awaze.common/aws-client :ec2 credentials4320)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4322
       createTags
       (ec2/create-tags-request (clojure.core/nth args4321 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials4324 & args4325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4326
     (com.palletops.awaze.common/aws-client :ec2 credentials4324)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4326
      createTags
      (ec2/create-tags-request (clojure.core/nth args4325 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m4327]
   (clojure.core/let
    [credentials4328 (:credentials m4327) args4329 (:args m4327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4330
      (com.palletops.awaze.common/aws-client :ec2 credentials4328)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4330
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args4329 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials4332 & args4333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4334
     (com.palletops.awaze.common/aws-client :ec2 credentials4332)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4334
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args4333 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-image
   [m4335]
   (clojure.core/let
    [credentials4336 (:credentials m4335) args4337 (:args m4335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4338
      (com.palletops.awaze.common/aws-client :ec2 credentials4336)]
     (clojure.core/case
      (clojure.core/count args4337)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4338
        importImage))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4338
        importImage
        (ec2/import-image-request (clojure.core/nth args4337 0))))))))
  (clojure.core/defn
   import-image-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Generate map for importImage, importImage"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :import-image,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :import-image,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-image
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]]),
    :doc "Call importImage, importImage"}
   [credentials4340 & args4341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4342
     (com.palletops.awaze.common/aws-client :ec2 credentials4340)]
    (clojure.core/case
     (clojure.core/count args4341)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4342
       importImage))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4342
       importImage
       (ec2/import-image-request (clojure.core/nth args4341 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m4343]
   (clojure.core/let
    [credentials4344 (:credentials m4343) args4345 (:args m4343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4346
      (com.palletops.awaze.common/aws-client :ec2 credentials4344)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4346
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args4345 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-route-table,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRouteTable"}
   [credentials4348 & args4349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4350
     (com.palletops.awaze.common/aws-client :ec2 credentials4348)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4350
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args4349 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-hosts
   [m4351]
   (clojure.core/let
    [credentials4352 (:credentials m4351) args4353 (:args m4351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4354
      (com.palletops.awaze.common/aws-client :ec2 credentials4352)]
     (clojure.core/case
      (clojure.core/count args4353)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4354
        describeHosts))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4354
        describeHosts
        (ec2/describe-hosts-request (clojure.core/nth args4353 0))))))))
  (clojure.core/defn
   describe-hosts-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeHosts, describeHosts"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-hosts,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-hosts,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-hosts
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeHosts, describeHosts"}
   [credentials4356 & args4357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4358
     (com.palletops.awaze.common/aws-client :ec2 credentials4356)]
    (clojure.core/case
     (clojure.core/count args4357)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4358
       describeHosts))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4358
       describeHosts
       (ec2/describe-hosts-request (clojure.core/nth args4357 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m4359]
   (clojure.core/let
    [credentials4360 (:credentials m4359) args4361 (:args m4359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4362
      (com.palletops.awaze.common/aws-client :ec2 credentials4360)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4362
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args4361 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-volume-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials4364 & args4365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4366
     (com.palletops.awaze.common/aws-client :ec2 credentials4364)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4366
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args4365 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-id-format
   [m4367]
   (clojure.core/let
    [credentials4368 (:credentials m4367) args4369 (:args m4367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4370
      (com.palletops.awaze.common/aws-client :ec2 credentials4368)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4370
       modifyIdFormat
       (ec2/modify-id-format-request (clojure.core/nth args4369 0)))))))
  (clojure.core/defn
   modify-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyIdFormat"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-id-format,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyIdFormat"}
   [credentials4372 & args4373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4374
     (com.palletops.awaze.common/aws-client :ec2 credentials4372)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4374
      modifyIdFormat
      (ec2/modify-id-format-request (clojure.core/nth args4373 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m4375]
   (clojure.core/let
    [credentials4376 (:credentials m4375) args4377 (:args m4375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4378
      (com.palletops.awaze.common/aws-client :ec2 credentials4376)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4378
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args4377 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-network-acl-entry,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials4380 & args4381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4382
     (com.palletops.awaze.common/aws-client :ec2 credentials4380)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4382
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args4381 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-nat-gateways
   [m4383]
   (clojure.core/let
    [credentials4384 (:credentials m4383) args4385 (:args m4383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4386
      (com.palletops.awaze.common/aws-client :ec2 credentials4384)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4386
       describeNatGateways
       (ec2/describe-nat-gateways-request
        (clojure.core/nth args4385 0)))))))
  (clojure.core/defn
   describe-nat-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeNatGateways"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-nat-gateways,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-nat-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeNatGateways"}
   [credentials4388 & args4389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4390
     (com.palletops.awaze.common/aws-client :ec2 credentials4388)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4390
      describeNatGateways
      (ec2/describe-nat-gateways-request
       (clojure.core/nth args4389 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m4391]
   (clojure.core/let
    [credentials4392 (:credentials m4391) args4393 (:args m4391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4394
      (com.palletops.awaze.common/aws-client :ec2 credentials4392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4394
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args4393 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials4396 & args4397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4398
     (com.palletops.awaze.common/aws-client :ec2 credentials4396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4398
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args4397 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link
   [m4399]
   (clojure.core/let
    [credentials4400 (:credentials m4399) args4401 (:args m4399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4402
      (com.palletops.awaze.common/aws-client :ec2 credentials4400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4402
       disableVpcClassicLink
       (ec2/disable-vpc-classic-link-request
        (clojure.core/nth args4401 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLink"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLink"}
   [credentials4404 & args4405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4406
     (com.palletops.awaze.common/aws-client :ec2 credentials4404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4406
      disableVpcClassicLink
      (ec2/disable-vpc-classic-link-request
       (clojure.core/nth args4405 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-scheduled-instances
   [m4407]
   (clojure.core/let
    [credentials4408 (:credentials m4407) args4409 (:args m4407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4410
      (com.palletops.awaze.common/aws-client :ec2 credentials4408)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4410
       runScheduledInstances
       (ec2/run-scheduled-instances-request
        (clojure.core/nth args4409 0)))))))
  (clojure.core/defn
   run-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for runScheduledInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :run-scheduled-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call runScheduledInstances"}
   [credentials4412 & args4413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4414
     (com.palletops.awaze.common/aws-client :ec2 credentials4412)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4414
      runScheduledInstances
      (ec2/run-scheduled-instances-request
       (clojure.core/nth args4413 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m4415]
   (clojure.core/let
    [credentials4416 (:credentials m4415) args4417 (:args m4415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4418
      (com.palletops.awaze.common/aws-client :ec2 credentials4416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4418
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args4417 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-key-pair,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteKeyPair"}
   [credentials4420 & args4421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4422
     (com.palletops.awaze.common/aws-client :ec2 credentials4420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4422
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args4421 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m4423]
   (clojure.core/let
    [credentials4424 (:credentials m4423) args4425 (:args m4423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4426
      (com.palletops.awaze.common/aws-client :ec2 credentials4424)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4426
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args4425 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-reserved-instances,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials4428 & args4429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4430
     (com.palletops.awaze.common/aws-client :ec2 credentials4428)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4430
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args4429 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m4431]
   (clojure.core/let
    [credentials4432 (:credentials m4431) args4433 (:args m4431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4434
      (com.palletops.awaze.common/aws-client :ec2 credentials4432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4434
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args4433 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection-route,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials4436 & args4437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4438
     (com.palletops.awaze.common/aws-client :ec2 credentials4436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4438
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args4437 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m4439]
   (clojure.core/let
    [credentials4440 (:credentials m4439) args4441 (:args m4439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4442
      (com.palletops.awaze.common/aws-client :ec2 credentials4440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4442
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args4441 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-internet-gateway,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call attachInternetGateway"}
   [credentials4444 & args4445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4446
     (com.palletops.awaze.common/aws-client :ec2 credentials4444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4446
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args4445 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m4447]
   (clojure.core/let
    [credentials4448 (:credentials m4447) args4449 (:args m4447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4450
      (com.palletops.awaze.common/aws-client :ec2 credentials4448)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4450
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args4449 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-network-interface-attribute,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials4452 & args4453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4454
     (com.palletops.awaze.common/aws-client :ec2 credentials4452)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4454
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args4453 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m4455]
   (clojure.core/let
    [credentials4456 (:credentials m4455) args4457 (:args m4455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4458
      (com.palletops.awaze.common/aws-client :ec2 credentials4456)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4458
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args4457 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials4460 & args4461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4462
     (com.palletops.awaze.common/aws-client :ec2 credentials4460)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4462
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args4461 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m4463]
   (clojure.core/let
    [credentials4464 (:credentials m4463) args4465 (:args m4463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4466
      (com.palletops.awaze.common/aws-client :ec2 credentials4464)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4466
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args4465 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-network-acl-entry,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials4468 & args4469]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4470
     (com.palletops.awaze.common/aws-client :ec2 credentials4468)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4470
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args4469 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m4471]
   (clojure.core/let
    [credentials4472 (:credentials m4471) args4473 (:args m4471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4474
      (com.palletops.awaze.common/aws-client :ec2 credentials4472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4474
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args4473 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-export-task,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelExportTask"}
   [credentials4476 & args4477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4478
     (com.palletops.awaze.common/aws-client :ec2 credentials4476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4478
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args4477 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m4479]
   (clojure.core/let
    [credentials4480 (:credentials m4479) args4481 (:args m4479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4482
      (com.palletops.awaze.common/aws-client :ec2 credentials4480)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4482
       createImage
       (ec2/create-image-request (clojure.core/nth args4481 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-image,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createImage"}
   [credentials4484 & args4485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4486
     (com.palletops.awaze.common/aws-client :ec2 credentials4484)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4486
      createImage
      (ec2/create-image-request (clojure.core/nth args4485 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-spot-fleet-request
   [m4487]
   (clojure.core/let
    [credentials4488 (:credentials m4487) args4489 (:args m4487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4490
      (com.palletops.awaze.common/aws-client :ec2 credentials4488)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4490
       modifySpotFleetRequest
       (ec2/modify-spot-fleet-request-request
        (clojure.core/nth args4489 0)))))))
  (clojure.core/defn
   modify-spot-fleet-request-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Generate map for modifySpotFleetRequest"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :modify-spot-fleet-request,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-spot-fleet-request
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Call modifySpotFleetRequest"}
   [credentials4492 & args4493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4494
     (com.palletops.awaze.common/aws-client :ec2 credentials4492)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4494
      modifySpotFleetRequest
      (ec2/modify-spot-fleet-request-request
       (clojure.core/nth args4493 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-snapshot-tasks
   [m4495]
   (clojure.core/let
    [credentials4496 (:credentials m4495) args4497 (:args m4495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4498
      (com.palletops.awaze.common/aws-client :ec2 credentials4496)]
     (clojure.core/case
      (clojure.core/count args4497)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4498
        describeImportSnapshotTasks
        (ec2/describe-import-snapshot-tasks-request
         (clojure.core/nth args4497 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4498
        describeImportSnapshotTasks))))))
  (clojure.core/defn
   describe-import-snapshot-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeImportSnapshotTasks, describeImportSnapshotTasks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1784__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-snapshot-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeImportSnapshotTasks, describeImportSnapshotTasks"}
   [credentials4500 & args4501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4502
     (com.palletops.awaze.common/aws-client :ec2 credentials4500)]
    (clojure.core/case
     (clojure.core/count args4501)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4502
       describeImportSnapshotTasks
       (ec2/describe-import-snapshot-tasks-request
        (clojure.core/nth args4501 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4502
       describeImportSnapshotTasks)))))))
