(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m11664]
  (clojure.core/let
   [bean11663
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/let
    [v11665 (:cidr m11664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11665 :com.palletops.awaze.client-builder/undef)
     (. bean11663 setCidr (clojure.core/str v11665))))
   bean11663))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m11667]
  (clojure.core/let
   [bean11666
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11668 (:vlan m11667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11668 :com.palletops.awaze.client-builder/undef)
     (. bean11666 setVlan (clojure.core/int v11668))))
   (clojure.core/let
    [v11668 (:asn m11667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11668 :com.palletops.awaze.client-builder/undef)
     (. bean11666 setAsn (clojure.core/int v11668))))
   (clojure.core/let
    [v11668
     (:virtual-interface-name
      m11667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11668 :com.palletops.awaze.client-builder/undef)
     (. bean11666 setVirtualInterfaceName (clojure.core/str v11668))))
   (clojure.core/let
    [v11668
     (:auth-key m11667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11668 :com.palletops.awaze.client-builder/undef)
     (. bean11666 setAuthKey (clojure.core/str v11668))))
   (clojure.core/let
    [v11668
     (:amazon-address
      m11667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11668 :com.palletops.awaze.client-builder/undef)
     (. bean11666 setAmazonAddress (clojure.core/str v11668))))
   (clojure.core/let
    [v11668
     (:customer-address
      m11667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11668 :com.palletops.awaze.client-builder/undef)
     (. bean11666 setCustomerAddress (clojure.core/str v11668))))
   bean11666))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m11670]
  (clojure.core/let
   [bean11669
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11671 (:vlan m11670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (. bean11669 setVlan (clojure.core/int v11671))))
   (clojure.core/let
    [v11671 (:asn m11670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (. bean11669 setAsn (clojure.core/int v11671))))
   (clojure.core/let
    [v11671
     (:virtual-interface-name
      m11670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (. bean11669 setVirtualInterfaceName (clojure.core/str v11671))))
   (clojure.core/let
    [v11671
     (:auth-key m11670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (. bean11669 setAuthKey (clojure.core/str v11671))))
   (clojure.core/let
    [v11671
     (:amazon-address
      m11670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (. bean11669 setAmazonAddress (clojure.core/str v11671))))
   (clojure.core/let
    [v11671
     (:customer-address
      m11670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (. bean11669 setCustomerAddress (clojure.core/str v11671))))
   (clojure.core/let
    [v11671
     (:route-filter-prefixes
      m11670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11671 :com.palletops.awaze.client-builder/undef)
     (.
      bean11669
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11735]
  (directconnect/route-filter-prefix arg11735))
 v11671))))
   bean11669))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m11673]
  (clojure.core/let
   [bean11672
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/let
    [v11674 (:vlan m11673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setVlan (clojure.core/int v11674))))
   (clojure.core/let
    [v11674 (:asn m11673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setAsn (clojure.core/int v11674))))
   (clojure.core/let
    [v11674
     (:virtual-gateway-id
      m11673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setVirtualGatewayId (clojure.core/str v11674))))
   (clojure.core/let
    [v11674
     (:virtual-interface-name
      m11673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setVirtualInterfaceName (clojure.core/str v11674))))
   (clojure.core/let
    [v11674
     (:auth-key m11673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setAuthKey (clojure.core/str v11674))))
   (clojure.core/let
    [v11674
     (:amazon-address
      m11673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setAmazonAddress (clojure.core/str v11674))))
   (clojure.core/let
    [v11674
     (:customer-address
      m11673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11674 :com.palletops.awaze.client-builder/undef)
     (. bean11672 setCustomerAddress (clojure.core/str v11674))))
   bean11672))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m11676]
  (clojure.core/let
   [bean11675
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/let
    [v11677 (:vlan m11676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (. bean11675 setVlan (clojure.core/int v11677))))
   (clojure.core/let
    [v11677 (:asn m11676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (. bean11675 setAsn (clojure.core/int v11677))))
   (clojure.core/let
    [v11677
     (:virtual-interface-name
      m11676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (. bean11675 setVirtualInterfaceName (clojure.core/str v11677))))
   (clojure.core/let
    [v11677
     (:auth-key m11676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (. bean11675 setAuthKey (clojure.core/str v11677))))
   (clojure.core/let
    [v11677
     (:amazon-address
      m11676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (. bean11675 setAmazonAddress (clojure.core/str v11677))))
   (clojure.core/let
    [v11677
     (:customer-address
      m11676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (. bean11675 setCustomerAddress (clojure.core/str v11677))))
   (clojure.core/let
    [v11677
     (:route-filter-prefixes
      m11676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11677 :com.palletops.awaze.client-builder/undef)
     (.
      bean11675
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11736]
  (directconnect/route-filter-prefix arg11736))
 v11677))))
   bean11675))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m11679]
  (clojure.core/let
   [bean11678
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/let
    [v11680
     (:interconnect-id
      m11679
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11680 :com.palletops.awaze.client-builder/undef)
     (. bean11678 setInterconnectId (clojure.core/str v11680))))
   bean11678))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m11682]
  (clojure.core/let
   [bean11681
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11683
     (:connection-id m11682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11683 :com.palletops.awaze.client-builder/undef)
     (. bean11681 setConnectionId (clojure.core/str v11683))))
   (clojure.core/let
    [v11683
     (:new-private-virtual-interface-allocation
      m11682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11683 :com.palletops.awaze.client-builder/undef)
     (.
      bean11681
      setNewPrivateVirtualInterfaceAllocation
      (directconnect/new-private-virtual-interface-allocation v11683))))
   (clojure.core/let
    [v11683
     (:owner-account m11682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11683 :com.palletops.awaze.client-builder/undef)
     (. bean11681 setOwnerAccount (clojure.core/str v11683))))
   bean11681))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m11685]
  (clojure.core/let
   [bean11684
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/let
    [v11686
     (:connection-id m11685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11686 :com.palletops.awaze.client-builder/undef)
     (. bean11684 setConnectionId (clojure.core/str v11686))))
   (clojure.core/let
    [v11686
     (:virtual-interface-id
      m11685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11686 :com.palletops.awaze.client-builder/undef)
     (. bean11684 setVirtualInterfaceId (clojure.core/str v11686))))
   bean11684))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m11688]
  (clojure.core/let
   [bean11687
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11689
     (:connection-id m11688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11689 :com.palletops.awaze.client-builder/undef)
     (. bean11687 setConnectionId (clojure.core/str v11689))))
   (clojure.core/let
    [v11689
     (:new-public-virtual-interface-allocation
      m11688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11689 :com.palletops.awaze.client-builder/undef)
     (.
      bean11687
      setNewPublicVirtualInterfaceAllocation
      (directconnect/new-public-virtual-interface-allocation v11689))))
   (clojure.core/let
    [v11689
     (:owner-account m11688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11689 :com.palletops.awaze.client-builder/undef)
     (. bean11687 setOwnerAccount (clojure.core/str v11689))))
   bean11687))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m11691]
  (clojure.core/let
   [bean11690
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/let
    [v11692
     (:interconnect-id
      m11691
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11692 :com.palletops.awaze.client-builder/undef)
     (. bean11690 setInterconnectId (clojure.core/str v11692))))
   bean11690))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m11694]
  (clojure.core/let
   [bean11693
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/let
    [v11695
     (:virtual-interface-id
      m11694
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11695 :com.palletops.awaze.client-builder/undef)
     (. bean11693 setVirtualInterfaceId (clojure.core/str v11695))))
   bean11693))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m11697]
  (clojure.core/let
   [bean11696
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean11696))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m11700]
  (clojure.core/let
   [bean11699
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/let
    [v11701 (:vlan m11700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11701 :com.palletops.awaze.client-builder/undef)
     (. bean11699 setVlan (clojure.core/int v11701))))
   (clojure.core/let
    [v11701
     (:bandwidth m11700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11701 :com.palletops.awaze.client-builder/undef)
     (. bean11699 setBandwidth (clojure.core/str v11701))))
   (clojure.core/let
    [v11701
     (:connection-name
      m11700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11701 :com.palletops.awaze.client-builder/undef)
     (. bean11699 setConnectionName (clojure.core/str v11701))))
   (clojure.core/let
    [v11701
     (:interconnect-id
      m11700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11701 :com.palletops.awaze.client-builder/undef)
     (. bean11699 setInterconnectId (clojure.core/str v11701))))
   (clojure.core/let
    [v11701
     (:owner-account m11700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11701 :com.palletops.awaze.client-builder/undef)
     (. bean11699 setOwnerAccount (clojure.core/str v11701))))
   bean11699))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m11703]
  (clojure.core/let
   [bean11702
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/let
    [v11704
     (:location m11703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11704 :com.palletops.awaze.client-builder/undef)
     (. bean11702 setLocation (clojure.core/str v11704))))
   (clojure.core/let
    [v11704
     (:bandwidth m11703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11704 :com.palletops.awaze.client-builder/undef)
     (. bean11702 setBandwidth (clojure.core/str v11704))))
   (clojure.core/let
    [v11704
     (:interconnect-name
      m11703
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11704 :com.palletops.awaze.client-builder/undef)
     (. bean11702 setInterconnectName (clojure.core/str v11704))))
   bean11702))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m11706]
  (clojure.core/let
   [bean11705
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/let
    [v11707
     (:connection-id m11706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11707 :com.palletops.awaze.client-builder/undef)
     (. bean11705 setConnectionId (clojure.core/str v11707))))
   bean11705))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m11709]
  (clojure.core/let
   [bean11708
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11710
     (:connection-id m11709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11710 :com.palletops.awaze.client-builder/undef)
     (. bean11708 setConnectionId (clojure.core/str v11710))))
   (clojure.core/let
    [v11710
     (:new-private-virtual-interface
      m11709
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11710 :com.palletops.awaze.client-builder/undef)
     (.
      bean11708
      setNewPrivateVirtualInterface
      (directconnect/new-private-virtual-interface v11710))))
   bean11708))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m11712]
  (clojure.core/let
   [bean11711
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/let
    [v11713
     (:interconnect-id
      m11712
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11713 :com.palletops.awaze.client-builder/undef)
     (. bean11711 setInterconnectId (clojure.core/str v11713))))
   bean11711))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m11715]
  (clojure.core/let
   [bean11714
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11716
     (:connection-id m11715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11716 :com.palletops.awaze.client-builder/undef)
     (. bean11714 setConnectionId (clojure.core/str v11716))))
   (clojure.core/let
    [v11716
     (:new-public-virtual-interface
      m11715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11716 :com.palletops.awaze.client-builder/undef)
     (.
      bean11714
      setNewPublicVirtualInterface
      (directconnect/new-public-virtual-interface v11716))))
   bean11714))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m11718]
  (clojure.core/let
   [bean11717
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/let
    [v11719
     (:location m11718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11719 :com.palletops.awaze.client-builder/undef)
     (. bean11717 setLocation (clojure.core/str v11719))))
   (clojure.core/let
    [v11719
     (:bandwidth m11718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11719 :com.palletops.awaze.client-builder/undef)
     (. bean11717 setBandwidth (clojure.core/str v11719))))
   (clojure.core/let
    [v11719
     (:connection-name
      m11718
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11719 :com.palletops.awaze.client-builder/undef)
     (. bean11717 setConnectionName (clojure.core/str v11719))))
   bean11717))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m11721]
  (clojure.core/let
   [bean11720
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/let
    [v11722
     (:connection-id m11721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11722 :com.palletops.awaze.client-builder/undef)
     (. bean11720 setConnectionId (clojure.core/str v11722))))
   bean11720))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m11724]
  (clojure.core/let
   [bean11723
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean11723))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m11727]
  (clojure.core/let
   [bean11726
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/let
    [v11728
     (:connection-id m11727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11728 :com.palletops.awaze.client-builder/undef)
     (. bean11726 setConnectionId (clojure.core/str v11728))))
   bean11726))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m11730]
  (clojure.core/let
   [bean11729
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11731
     (:virtual-interface-id
      m11730
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11731 :com.palletops.awaze.client-builder/undef)
     (. bean11729 setVirtualInterfaceId (clojure.core/str v11731))))
   bean11729))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m11733]
  (clojure.core/let
   [bean11732
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11734
     (:virtual-interface-id
      m11733
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11734 :com.palletops.awaze.client-builder/undef)
     (. bean11732 setVirtualInterfaceId (clojure.core/str v11734))))
   (clojure.core/let
    [v11734
     (:virtual-gateway-id
      m11733
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11734 :com.palletops.awaze.client-builder/undef)
     (. bean11732 setVirtualGatewayId (clojure.core/str v11734))))
   bean11732))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m11737]
   (clojure.core/let
    [credentials11738 (:credentials m11737) args11739 (:args m11737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11740
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11738)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11740
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args11739 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials11742 & args11743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11744
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11742)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11744
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args11743 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m11745]
   (clojure.core/let
    [credentials11746 (:credentials m11745) args11747 (:args m11745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11748
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11746)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11748
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args11747 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials11750 & args11751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11752
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11750)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11752
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args11751 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m11753]
   (clojure.core/let
    [credentials11754 (:credentials m11753) args11755 (:args m11753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11756
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11754)]
     (clojure.core/case
      (clojure.core/count args11755)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11756
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args11755 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11756
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1784__auto__,
     :client :directconnect})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials11758 & args11759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11760
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11758)]
    (clojure.core/case
     (clojure.core/count args11759)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11760
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args11759 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11760
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m11761]
   (clojure.core/let
    [credentials11762 (:credentials m11761) args11763 (:args m11761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11764
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11762)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11764
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args11763 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials11766 & args11767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11768
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11766)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11768
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args11767 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m11769]
   (clojure.core/let
    [credentials11770 (:credentials m11769) args11771 (:args m11769)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11772
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11770)]
     (clojure.core/case
      (clojure.core/count args11771)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11772
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11772
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args11771 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-interconnects,
     :credentials credentials__1784__auto__,
     :client :directconnect})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-interconnects,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials11774 & args11775]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11776
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11774)]
    (clojure.core/case
     (clojure.core/count args11775)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11776
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11776
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args11775 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m11777]
   (clojure.core/let
    [credentials11778 (:credentials m11777) args11779 (:args m11777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11780
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11778)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11780
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args11779 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials11782 & args11783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11784
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11782)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11784
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args11783 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m11785]
   (clojure.core/let
    [credentials11786 (:credentials m11785) args11787 (:args m11785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11788
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11786)]
     (clojure.core/case
      (clojure.core/count args11787)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11788
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11788
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args11787 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-locations,
     :credentials credentials__1784__auto__,
     :client :directconnect})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-locations,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials11790 & args11791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11792
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11790)]
    (clojure.core/case
     (clojure.core/count args11791)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11792
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11792
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args11791 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m11793]
   (clojure.core/let
    [credentials11794 (:credentials m11793) args11795 (:args m11793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11796
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11794)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11796
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args11795 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials11798 & args11799]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11800
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11798)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11800
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args11799 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m11801]
   (clojure.core/let
    [credentials11802 (:credentials m11801) args11803 (:args m11801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11804
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11804
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args11803 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-interconnect,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Call createInterconnect"}
   [credentials11806 & args11807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11808
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11806)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11808
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args11807 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m11809]
   (clojure.core/let
    [credentials11810 (:credentials m11809) args11811 (:args m11809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11812
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11810)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11812
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args11811 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-connection,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConnection"}
   [credentials11814 & args11815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11816
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11814)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11816
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args11815 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m11817]
   (clojure.core/let
    [credentials11818 (:credentials m11817) args11819 (:args m11817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11820
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11820
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args11819 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-private-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials11822 & args11823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11824
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11824
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args11823 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m11825]
   (clojure.core/let
    [credentials11826 (:credentials m11825) args11827 (:args m11825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11828
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11828
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args11827 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-interconnect,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInterconnect"}
   [credentials11830 & args11831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11832
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11832
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args11831 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m11833]
   (clojure.core/let
    [credentials11834 (:credentials m11833) args11835 (:args m11833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11836
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11836
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args11835 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-public-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials11838 & args11839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11840
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11840
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args11839 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m11841]
   (clojure.core/let
    [credentials11842 (:credentials m11841) args11843 (:args m11841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11844
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11842)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11844
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args11843 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-connection,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Call createConnection"}
   [credentials11846 & args11847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11848
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11846)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11848
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args11847 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m11849]
   (clojure.core/let
    [credentials11850 (:credentials m11849) args11851 (:args m11849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11852
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11852
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args11851 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :confirm-connection,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmConnection"}
   [credentials11854 & args11855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11856
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11856
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args11855 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m11857]
   (clojure.core/let
    [credentials11858 (:credentials m11857) args11859 (:args m11857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11860
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11858)]
     (clojure.core/case
      (clojure.core/count args11859)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11860
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11860
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args11859 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-virtual-gateways,
     :credentials credentials__1784__auto__,
     :client :directconnect})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-virtual-gateways,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials11862 & args11863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11864
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11862)]
    (clojure.core/case
     (clojure.core/count args11863)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11864
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11864
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args11863 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m11865]
   (clojure.core/let
    [credentials11866 (:credentials m11865) args11867 (:args m11865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11868
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11866)]
     (clojure.core/case
      (clojure.core/count args11867)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11868
        describeConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11868
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args11867 0))))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-connections,
     :credentials credentials__1784__auto__,
     :client :directconnect})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-connections,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials11870 & args11871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11872
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11870)]
    (clojure.core/case
     (clojure.core/count args11871)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11872
       describeConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11872
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args11871 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m11873]
   (clojure.core/let
    [credentials11874 (:credentials m11873) args11875 (:args m11873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11876
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11876
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args11875 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials11878 & args11879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11880
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11880
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args11879 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m11881]
   (clojure.core/let
    [credentials11882 (:credentials m11881) args11883 (:args m11881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11884
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11884
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args11883 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1784__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials11886 & args11887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11888
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11888
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args11887 0))))))))
