(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m7573]
  (clojure.core/let
   [bean7572 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/let
    [v7574 (:values m7573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7574 :com.palletops.awaze.client-builder/undef)
     (.
      bean7572
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7659] (clojure.core/str arg7659))
 v7574))))
   (clojure.core/let
    [v7574 (:type m7573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7574 :com.palletops.awaze.client-builder/undef)
     (. bean7572 setType (clojure.core/str v7574))))
   bean7572))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m7576]
  (clojure.core/let
   [bean7575 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/let
    [v7577 (:key m7576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7577 :com.palletops.awaze.client-builder/undef)
     (. bean7575 setKey (clojure.core/str v7577))))
   (clojure.core/let
    [v7577
     (:string-value m7576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7577 :com.palletops.awaze.client-builder/undef)
     (. bean7575 setStringValue (clojure.core/str v7577))))
   (clojure.core/let
    [v7577
     (:ref-value m7576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7577 :com.palletops.awaze.client-builder/undef)
     (. bean7575 setRefValue (clojure.core/str v7577))))
   bean7575))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterAttribute}
parameter-attribute
  [m7579]
  (clojure.core/let
   [bean7578
    (new com.amazonaws.services.datapipeline.model.ParameterAttribute)]
   (clojure.core/let
    [v7580 (:key m7579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7580 :com.palletops.awaze.client-builder/undef)
     (. bean7578 setKey (clojure.core/str v7580))))
   (clojure.core/let
    [v7580
     (:string-value m7579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7580 :com.palletops.awaze.client-builder/undef)
     (. bean7578 setStringValue (clojure.core/str v7580))))
   bean7578))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m7582]
  (clojure.core/let
   [bean7581 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/let
    [v7583
     (:field-name m7582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7583 :com.palletops.awaze.client-builder/undef)
     (. bean7581 setFieldName (clojure.core/str v7583))))
   (clojure.core/let
    [v7583
     (:operator m7582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7583 :com.palletops.awaze.client-builder/undef)
     (. bean7581 setOperator (datapipeline/operator v7583))))
   bean7581))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterValue}
parameter-value
  [m7585]
  (clojure.core/let
   [bean7584
    (new com.amazonaws.services.datapipeline.model.ParameterValue)]
   (clojure.core/let
    [v7586 (:id m7585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7586 :com.palletops.awaze.client-builder/undef)
     (. bean7584 setId (clojure.core/str v7586))))
   (clojure.core/let
    [v7586
     (:string-value m7585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7586 :com.palletops.awaze.client-builder/undef)
     (. bean7584 setStringValue (clojure.core/str v7586))))
   bean7584))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m7588]
  (clojure.core/let
   [bean7587
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/let
    [v7589 (:name m7588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7589 :com.palletops.awaze.client-builder/undef)
     (. bean7587 setName (clojure.core/str v7589))))
   (clojure.core/let
    [v7589 (:fields m7588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7589 :com.palletops.awaze.client-builder/undef)
     (.
      bean7587
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7660] (datapipeline/field arg7660))
 v7589))))
   (clojure.core/let
    [v7589 (:id m7588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7589 :com.palletops.awaze.client-builder/undef)
     (. bean7587 setId (clojure.core/str v7589))))
   bean7587))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterObject}
parameter-object
  [m7591]
  (clojure.core/let
   [bean7590
    (new com.amazonaws.services.datapipeline.model.ParameterObject)]
   (clojure.core/let
    [v7592
     (:attributes m7591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7592 :com.palletops.awaze.client-builder/undef)
     (.
      bean7590
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg7661]
  (datapipeline/parameter-attribute arg7661))
 v7592))))
   (clojure.core/let
    [v7592 (:id m7591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7592 :com.palletops.awaze.client-builder/undef)
     (. bean7590 setId (clojure.core/str v7592))))
   bean7590))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m7594]
  (clojure.core/let
   [bean7593
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/let
    [v7595
     (:signature m7594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7595 :com.palletops.awaze.client-builder/undef)
     (. bean7593 setSignature (clojure.core/str v7595))))
   (clojure.core/let
    [v7595
     (:document m7594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7595 :com.palletops.awaze.client-builder/undef)
     (. bean7593 setDocument (clojure.core/str v7595))))
   bean7593))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Tag}
tag
  [m7597]
  (clojure.core/let
   [bean7596 (new com.amazonaws.services.datapipeline.model.Tag)]
   (clojure.core/let
    [v7598 (:value m7597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7598 :com.palletops.awaze.client-builder/undef)
     (. bean7596 setValue (clojure.core/str v7598))))
   (clojure.core/let
    [v7598 (:key m7597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7598 :com.palletops.awaze.client-builder/undef)
     (. bean7596 setKey (clojure.core/str v7598))))
   bean7596))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m7600]
  (clojure.core/let
   [bean7599 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/let
    [v7601
     (:selectors m7600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7601 :com.palletops.awaze.client-builder/undef)
     (.
      bean7599
      setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7662] (datapipeline/selector arg7662))
 v7601))))
   bean7599))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m7603]
  (clojure.core/let
   [bean7602
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/let
    [v7604
     (:pipeline-id m7603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7604 :com.palletops.awaze.client-builder/undef)
     (. bean7602 setPipelineId (clojure.core/str v7604))))
   (clojure.core/let
    [v7604 (:version m7603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7604 :com.palletops.awaze.client-builder/undef)
     (. bean7602 setVersion (clojure.core/str v7604))))
   bean7602))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m7606]
  (clojure.core/let
   [bean7605
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/let
    [v7607
     (:pipeline-id m7606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7607 :com.palletops.awaze.client-builder/undef)
     (. bean7605 setPipelineId (clojure.core/str v7607))))
   (clojure.core/let
    [v7607
     (:parameter-values
      m7606
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7607 :com.palletops.awaze.client-builder/undef)
     (.
      bean7605
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7663] (datapipeline/parameter-value arg7663))
 v7607))))
   (clojure.core/let
    [v7607
     (:pipeline-objects
      m7606
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7607 :com.palletops.awaze.client-builder/undef)
     (.
      bean7605
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7664] (datapipeline/pipeline-object arg7664))
 v7607))))
   (clojure.core/let
    [v7607
     (:parameter-objects
      m7606
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7607 :com.palletops.awaze.client-builder/undef)
     (.
      bean7605
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7665] (datapipeline/parameter-object arg7665))
 v7607))))
   bean7605))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m7609]
  (clojure.core/let
   [bean7608
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/let
    [v7610 (:fields m7609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7610 :com.palletops.awaze.client-builder/undef)
     (.
      bean7608
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7666] (datapipeline/field arg7666))
 v7610))))
   (clojure.core/let
    [v7610 (:task-id m7609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7610 :com.palletops.awaze.client-builder/undef)
     (. bean7608 setTaskId (clojure.core/str v7610))))
   bean7608))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.RemoveTagsRequest}
remove-tags-request
  [m7612]
  (clojure.core/let
   [bean7611
    (new com.amazonaws.services.datapipeline.model.RemoveTagsRequest)]
   (clojure.core/let
    [v7613
     (:tag-keys m7612 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7613 :com.palletops.awaze.client-builder/undef)
     (.
      bean7611
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7667] (clojure.core/str arg7667))
 v7613))))
   (clojure.core/let
    [v7613
     (:pipeline-id m7612 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7613 :com.palletops.awaze.client-builder/undef)
     (. bean7611 setPipelineId (clojure.core/str v7613))))
   bean7611))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m7615]
  (clojure.core/let
   [bean7614
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/let
    [v7616
     (:pipeline-ids m7615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7616 :com.palletops.awaze.client-builder/undef)
     (.
      bean7614
      setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7676] (clojure.core/str arg7676))
 v7616))))
   bean7614))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m7618]
  (clojure.core/let
   [bean7617
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/let
    [v7619
     (:worker-group m7618 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7619 :com.palletops.awaze.client-builder/undef)
     (. bean7617 setWorkerGroup (clojure.core/str v7619))))
   (clojure.core/let
    [v7619
     (:hostname m7618 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7619 :com.palletops.awaze.client-builder/undef)
     (. bean7617 setHostname (clojure.core/str v7619))))
   (clojure.core/let
    [v7619
     (:instance-identity
      m7618
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7619 :com.palletops.awaze.client-builder/undef)
     (.
      bean7617
      setInstanceIdentity
      (datapipeline/instance-identity v7619))))
   bean7617))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.AddTagsRequest}
add-tags-request
  [m7621]
  (clojure.core/let
   [bean7620
    (new com.amazonaws.services.datapipeline.model.AddTagsRequest)]
   (clojure.core/let
    [v7622
     (:pipeline-id m7621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7622 :com.palletops.awaze.client-builder/undef)
     (. bean7620 setPipelineId (clojure.core/str v7622))))
   (clojure.core/let
    [v7622 (:tags m7621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7622 :com.palletops.awaze.client-builder/undef)
     (.
      bean7620
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7677] (datapipeline/tag arg7677))
 v7622))))
   bean7620))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m7624]
  (clojure.core/let
   [bean7623
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/let
    [v7625
     (:pipeline-id m7624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7625 :com.palletops.awaze.client-builder/undef)
     (. bean7623 setPipelineId (clojure.core/str v7625))))
   (clojure.core/let
    [v7625 (:query m7624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7625 :com.palletops.awaze.client-builder/undef)
     (. bean7623 setQuery (datapipeline/query v7625))))
   (clojure.core/let
    [v7625 (:sphere m7624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7625 :com.palletops.awaze.client-builder/undef)
     (. bean7623 setSphere (clojure.core/str v7625))))
   (clojure.core/let
    [v7625 (:marker m7624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7625 :com.palletops.awaze.client-builder/undef)
     (. bean7623 setMarker (clojure.core/str v7625))))
   (clojure.core/let
    [v7625 (:limit m7624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7625 :com.palletops.awaze.client-builder/undef)
     (. bean7623 setLimit (clojure.core/int v7625))))
   bean7623))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m7627]
  (clojure.core/let
   [bean7626
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/let
    [v7628 (:marker m7627 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7628 :com.palletops.awaze.client-builder/undef)
     (. bean7626 setMarker (clojure.core/str v7628))))
   bean7626))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m7630]
  (clojure.core/let
   [bean7629
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/let
    [v7631
     (:worker-group m7630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7631 :com.palletops.awaze.client-builder/undef)
     (. bean7629 setWorkerGroup (clojure.core/str v7631))))
   (clojure.core/let
    [v7631
     (:hostname m7630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7631 :com.palletops.awaze.client-builder/undef)
     (. bean7629 setHostname (clojure.core/str v7631))))
   (clojure.core/let
    [v7631
     (:taskrunner-id m7630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7631 :com.palletops.awaze.client-builder/undef)
     (. bean7629 setTaskrunnerId (clojure.core/str v7631))))
   bean7629))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m7633]
  (clojure.core/let
   [bean7632
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/let
    [v7634
     (:error-message m7633 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7634 :com.palletops.awaze.client-builder/undef)
     (. bean7632 setErrorMessage (clojure.core/str v7634))))
   (clojure.core/let
    [v7634
     (:task-status m7633 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7634 :com.palletops.awaze.client-builder/undef)
     (. bean7632 setTaskStatus (clojure.core/str v7634))))
   (clojure.core/let
    [v7634 (:task-id m7633 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7634 :com.palletops.awaze.client-builder/undef)
     (. bean7632 setTaskId (clojure.core/str v7634))))
   (clojure.core/let
    [v7634
     (:error-id m7633 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7634 :com.palletops.awaze.client-builder/undef)
     (. bean7632 setErrorId (clojure.core/str v7634))))
   (clojure.core/let
    [v7634
     (:error-stack-trace
      m7633
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7634 :com.palletops.awaze.client-builder/undef)
     (. bean7632 setErrorStackTrace (clojure.core/str v7634))))
   bean7632))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m7636]
  (clojure.core/let
   [bean7635
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/let
    [v7637 (:name m7636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7637 :com.palletops.awaze.client-builder/undef)
     (. bean7635 setName (clojure.core/str v7637))))
   (clojure.core/let
    [v7637
     (:description m7636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7637 :com.palletops.awaze.client-builder/undef)
     (. bean7635 setDescription (clojure.core/str v7637))))
   (clojure.core/let
    [v7637 (:tags m7636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7637 :com.palletops.awaze.client-builder/undef)
     (.
      bean7635
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7678] (datapipeline/tag arg7678))
 v7637))))
   (clojure.core/let
    [v7637
     (:unique-id m7636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7637 :com.palletops.awaze.client-builder/undef)
     (. bean7635 setUniqueId (clojure.core/str v7637))))
   bean7635))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m7639]
  (clojure.core/let
   [bean7638
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/let
    [v7640
     (:pipeline-id m7639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7640 :com.palletops.awaze.client-builder/undef)
     (. bean7638 setPipelineId (clojure.core/str v7640))))
   bean7638))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m7642]
  (clojure.core/let
   [bean7641
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/let
    [v7643
     (:pipeline-id m7642 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7643 :com.palletops.awaze.client-builder/undef)
     (. bean7641 setPipelineId (clojure.core/str v7643))))
   (clojure.core/let
    [v7643
     (:parameter-values
      m7642
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7643 :com.palletops.awaze.client-builder/undef)
     (.
      bean7641
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7679] (datapipeline/parameter-value arg7679))
 v7643))))
   (clojure.core/let
    [v7643
     (:pipeline-objects
      m7642
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7643 :com.palletops.awaze.client-builder/undef)
     (.
      bean7641
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7680] (datapipeline/pipeline-object arg7680))
 v7643))))
   (clojure.core/let
    [v7643
     (:parameter-objects
      m7642
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7643 :com.palletops.awaze.client-builder/undef)
     (.
      bean7641
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7681] (datapipeline/parameter-object arg7681))
 v7643))))
   bean7641))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest}
deactivate-pipeline-request
  [m7645]
  (clojure.core/let
   [bean7644
    (new
     com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest)]
   (clojure.core/let
    [v7646
     (:pipeline-id m7645 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7646 :com.palletops.awaze.client-builder/undef)
     (. bean7644 setPipelineId (clojure.core/str v7646))))
   (clojure.core/let
    [v7646
     (:cancel-active m7645 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7646 :com.palletops.awaze.client-builder/undef)
     (. bean7644 setCancelActive (clojure.core/boolean v7646))))
   bean7644))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m7648]
  (clojure.core/let
   [bean7647
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/let
    [v7649
     (:pipeline-id m7648 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7649 :com.palletops.awaze.client-builder/undef)
     (. bean7647 setPipelineId (clojure.core/str v7649))))
   (clojure.core/let
    [v7649
     (:object-ids m7648 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7649 :com.palletops.awaze.client-builder/undef)
     (.
      bean7647
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7682] (clojure.core/str arg7682))
 v7649))))
   (clojure.core/let
    [v7649 (:status m7648 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7649 :com.palletops.awaze.client-builder/undef)
     (. bean7647 setStatus (clojure.core/str v7649))))
   bean7647))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m7651]
  (clojure.core/let
   [bean7650
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/let
    [v7652
     (:expression m7651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7652 :com.palletops.awaze.client-builder/undef)
     (. bean7650 setExpression (clojure.core/str v7652))))
   (clojure.core/let
    [v7652
     (:pipeline-id m7651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7652 :com.palletops.awaze.client-builder/undef)
     (. bean7650 setPipelineId (clojure.core/str v7652))))
   (clojure.core/let
    [v7652
     (:object-id m7651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7652 :com.palletops.awaze.client-builder/undef)
     (. bean7650 setObjectId (clojure.core/str v7652))))
   bean7650))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m7654]
  (clojure.core/let
   [bean7653
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/let
    [v7655
     (:pipeline-id m7654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7655 :com.palletops.awaze.client-builder/undef)
     (. bean7653 setPipelineId (clojure.core/str v7655))))
   (clojure.core/let
    [v7655
     (:object-ids m7654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7655 :com.palletops.awaze.client-builder/undef)
     (.
      bean7653
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7683] (clojure.core/str arg7683))
 v7655))))
   (clojure.core/let
    [v7655
     (:evaluate-expressions
      m7654
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7655 :com.palletops.awaze.client-builder/undef)
     (. bean7653 setEvaluateExpressions (clojure.core/boolean v7655))))
   (clojure.core/let
    [v7655 (:marker m7654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7655 :com.palletops.awaze.client-builder/undef)
     (. bean7653 setMarker (clojure.core/str v7655))))
   bean7653))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m7657]
  (clojure.core/let
   [bean7656
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/let
    [v7658
     (:pipeline-id m7657 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7658 :com.palletops.awaze.client-builder/undef)
     (. bean7656 setPipelineId (clojure.core/str v7658))))
   (clojure.core/let
    [v7658
     (:parameter-values
      m7657
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7658 :com.palletops.awaze.client-builder/undef)
     (.
      bean7656
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7684] (datapipeline/parameter-value arg7684))
 v7658))))
   (clojure.core/let
    [v7658
     (:start-timestamp
      m7657
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7658 :com.palletops.awaze.client-builder/undef)
     (.
      bean7656
      setStartTimestamp
      (com.palletops.awaze.common/to-date v7658))))
   bean7656))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m7668]
   (clojure.core/let
    [credentials7669 (:credentials m7668) args7670 (:args m7668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7671
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7669)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7671
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args7670 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-pipeline-definition,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials7673 & args7674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7675
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7673)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7675
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args7674 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m7685]
   (clojure.core/let
    [credentials7686 (:credentials m7685) args7687 (:args m7685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7688
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7688
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args7687 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :validate-pipeline-definition,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials7690 & args7691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7692
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7692
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args7691 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m7693]
   (clojure.core/let
    [credentials7694 (:credentials m7693) args7695 (:args m7693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7696
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7694)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7696
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args7695 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :report-task-progress,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskProgress"}
   [credentials7698 & args7699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7700
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7698)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7700
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args7699 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :remove-tags
   [m7701]
   (clojure.core/let
    [credentials7702 (:credentials m7701) args7703 (:args m7701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7704
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7702)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7704
       removeTags
       (datapipeline/remove-tags-request
        (clojure.core/nth args7703 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials7706 & args7707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7708
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7706)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7708
      removeTags
      (datapipeline/remove-tags-request (clojure.core/nth args7707 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m7709]
   (clojure.core/let
    [credentials7710 (:credentials m7709) args7711 (:args m7709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7712
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7710)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7712
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args7711 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-pipelines,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Call describePipelines"}
   [credentials7714 & args7715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7716
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7714)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7716
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args7715 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m7717]
   (clojure.core/let
    [credentials7718 (:credentials m7717) args7719 (:args m7717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7720
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7718)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7720
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args7719 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :poll-for-task,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Call pollForTask"}
   [credentials7722 & args7723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7724
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7722)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7724
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args7723 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :add-tags
   [m7725]
   (clojure.core/let
    [credentials7726 (:credentials m7725) args7727 (:args m7725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7728
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7726)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7728
       addTags
       (datapipeline/add-tags-request (clojure.core/nth args7727 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials7730 & args7731]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7732
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7730)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7732
      addTags
      (datapipeline/add-tags-request (clojure.core/nth args7731 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m7733]
   (clojure.core/let
    [credentials7734 (:credentials m7733) args7735 (:args m7733)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7736
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7734)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7736
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args7735 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :query-objects,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Call queryObjects"}
   [credentials7738 & args7739]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7740
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7738)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7740
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args7739 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m7741]
   (clojure.core/let
    [credentials7742 (:credentials m7741) args7743 (:args m7741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7744
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7742)]
     (clojure.core/case
      (clojure.core/count args7743)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7744
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args7743 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7744
        listPipelines))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-pipelines,
     :credentials credentials__1784__auto__,
     :client :datapipeline})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-pipelines,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials7746 & args7747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7748
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7746)]
    (clojure.core/case
     (clojure.core/count args7747)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7748
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args7747 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7748
       listPipelines))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m7749]
   (clojure.core/let
    [credentials7750 (:credentials m7749) args7751 (:args m7749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7752
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7752
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args7751 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials7754 & args7755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7756
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7756
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args7755 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m7757]
   (clojure.core/let
    [credentials7758 (:credentials m7757) args7759 (:args m7757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7760
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7758)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7760
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args7759 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-task-status,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Call setTaskStatus"}
   [credentials7762 & args7763]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7764
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7762)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7764
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args7763 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m7765]
   (clojure.core/let
    [credentials7766 (:credentials m7765) args7767 (:args m7765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7768
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7766)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7768
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args7767 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-pipeline,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Call createPipeline"}
   [credentials7770 & args7771]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7772
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7770)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7772
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args7771 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m7773]
   (clojure.core/let
    [credentials7774 (:credentials m7773) args7775 (:args m7773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7776
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7774)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7776
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args7775 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-pipeline,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deletePipeline"}
   [credentials7778 & args7779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7780
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7778)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7780
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args7779 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m7781]
   (clojure.core/let
    [credentials7782 (:credentials m7781) args7783 (:args m7781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7784
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7782)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7784
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args7783 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-pipeline-definition,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials7786 & args7787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7788
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7786)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7788
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args7787 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :deactivate-pipeline
   [m7789]
   (clojure.core/let
    [credentials7790 (:credentials m7789) args7791 (:args m7789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7792
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7792
       deactivatePipeline
       (datapipeline/deactivate-pipeline-request
        (clojure.core/nth args7791 0)))))))
  (clojure.core/defn
   deactivate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deactivatePipeline"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :deactivate-pipeline,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   deactivate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deactivatePipeline"}
   [credentials7794 & args7795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7796
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7796
      deactivatePipeline
      (datapipeline/deactivate-pipeline-request
       (clojure.core/nth args7795 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m7797]
   (clojure.core/let
    [credentials7798 (:credentials m7797) args7799 (:args m7797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7800
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7800
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args7799 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-status,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call setStatus"}
   [credentials7802 & args7803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7804
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7804
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args7803 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m7805]
   (clojure.core/let
    [credentials7806 (:credentials m7805) args7807 (:args m7805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7808
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7806)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7808
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args7807 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :evaluate-expression,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call evaluateExpression"}
   [credentials7810 & args7811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7812
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7810)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7812
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args7811 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m7813]
   (clojure.core/let
    [credentials7814 (:credentials m7813) args7815 (:args m7813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7816
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7814)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7816
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args7815 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-objects,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Call describeObjects"}
   [credentials7818 & args7819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7820
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7820
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args7819 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m7821]
   (clojure.core/let
    [credentials7822 (:credentials m7821) args7823 (:args m7821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7824
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7824
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args7823 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :activate-pipeline,
     :credentials credentials__1784__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call activatePipeline"}
   [credentials7826 & args7827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7828
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7826)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7828
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args7827 0))))))))
