(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m10482]
  (clojure.core/let
   [bean10481
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/let
    [v10483
     (:sample-count m10482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10483 :com.palletops.awaze.client-builder/undef)
     (. bean10481 setSampleCount (clojure.core/double v10483))))
   (clojure.core/let
    [v10483 (:sum m10482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10483 :com.palletops.awaze.client-builder/undef)
     (. bean10481 setSum (clojure.core/double v10483))))
   (clojure.core/let
    [v10483
     (:minimum m10482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10483 :com.palletops.awaze.client-builder/undef)
     (. bean10481 setMinimum (clojure.core/double v10483))))
   (clojure.core/let
    [v10483
     (:maximum m10482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10483 :com.palletops.awaze.client-builder/undef)
     (. bean10481 setMaximum (clojure.core/double v10483))))
   bean10481))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m10485]
  (clojure.core/let
   [bean10484 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/let
    [v10486 (:name m10485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10486 :com.palletops.awaze.client-builder/undef)
     (. bean10484 setName (clojure.core/str v10486))))
   (clojure.core/let
    [v10486 (:value m10485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10486 :com.palletops.awaze.client-builder/undef)
     (. bean10484 setValue (clojure.core/str v10486))))
   bean10484))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m10488]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m10488)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m10491]
  (clojure.core/let
   [bean10490
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/let
    [v10492 (:value m10491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10492 :com.palletops.awaze.client-builder/undef)
     (. bean10490 setValue (clojure.core/double v10492))))
   (clojure.core/let
    [v10492
     (:timestamp m10491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10492 :com.palletops.awaze.client-builder/undef)
     (.
      bean10490
      setTimestamp
      (com.palletops.awaze.common/to-date v10492))))
   (clojure.core/let
    [v10492
     (:statistic-values
      m10491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10492 :com.palletops.awaze.client-builder/undef)
     (.
      bean10490
      setStatisticValues
      (cloudwatch/statistic-set v10492))))
   (clojure.core/let
    [v10492
     (:metric-name m10491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10492 :com.palletops.awaze.client-builder/undef)
     (. bean10490 setMetricName (clojure.core/str v10492))))
   (clojure.core/let
    [v10492 (:unit m10491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10492 :com.palletops.awaze.client-builder/undef)
     (. bean10490 setUnit (clojure.core/str v10492))))
   (clojure.core/let
    [v10492
     (:dimensions m10491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10492 :com.palletops.awaze.client-builder/undef)
     (.
      bean10490
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10532] (cloudwatch/dimension arg10532))
 v10492))))
   bean10490))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.HistoryItemType}
history-item-type
  [m10494]
  (.
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   fromValue
   (clojure.core/name m10494)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m10497]
  (clojure.core/let
   [bean10496
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/let
    [v10498 (:name m10497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10498 :com.palletops.awaze.client-builder/undef)
     (. bean10496 setName (clojure.core/str v10498))))
   (clojure.core/let
    [v10498 (:value m10497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10498 :com.palletops.awaze.client-builder/undef)
     (. bean10496 setValue (clojure.core/str v10498))))
   bean10496))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m10500]
  (clojure.core/let
   [bean10499
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/let
    [v10501
     (:alarm-names m10500 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10501 :com.palletops.awaze.client-builder/undef)
     (.
      bean10499
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10533] (clojure.core/str arg10533))
 v10501))))
   bean10499))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m10503]
  (clojure.core/let
   [bean10502
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/let
    [v10504
     (:alarm-names m10503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10504 :com.palletops.awaze.client-builder/undef)
     (.
      bean10502
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10534] (clojure.core/str arg10534))
 v10504))))
   bean10502))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m10506]
  (clojure.core/let
   [bean10505
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/let
    [v10507
     (:alarm-names m10506 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10507 :com.palletops.awaze.client-builder/undef)
     (.
      bean10505
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10535] (clojure.core/str arg10535))
 v10507))))
   bean10505))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m10509]
  (clojure.core/let
   [bean10508
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/let
    [v10510
     (:alarm-name m10509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10510 :com.palletops.awaze.client-builder/undef)
     (. bean10508 setAlarmName (clojure.core/str v10510))))
   (clojure.core/let
    [v10510
     (:state-value m10509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10510 :com.palletops.awaze.client-builder/undef)
     (. bean10508 setStateValue (clojure.core/str v10510))))
   (clojure.core/let
    [v10510
     (:state-reason m10509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10510 :com.palletops.awaze.client-builder/undef)
     (. bean10508 setStateReason (clojure.core/str v10510))))
   (clojure.core/let
    [v10510
     (:state-reason-data
      m10509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10510 :com.palletops.awaze.client-builder/undef)
     (. bean10508 setStateReasonData (clojure.core/str v10510))))
   bean10508))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m10512]
  (clojure.core/let
   [bean10511
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/let
    [v10513
     (:namespace m10512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10513 :com.palletops.awaze.client-builder/undef)
     (. bean10511 setNamespace (clojure.core/str v10513))))
   (clojure.core/let
    [v10513
     (:metric-name m10512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10513 :com.palletops.awaze.client-builder/undef)
     (. bean10511 setMetricName (clojure.core/str v10513))))
   (clojure.core/let
    [v10513 (:unit m10512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10513 :com.palletops.awaze.client-builder/undef)
     (. bean10511 setUnit (cloudwatch/standard-unit v10513))))
   (clojure.core/let
    [v10513
     (:statistic m10512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10513 :com.palletops.awaze.client-builder/undef)
     (. bean10511 setStatistic (clojure.core/str v10513))))
   (clojure.core/let
    [v10513
     (:dimensions m10512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10513 :com.palletops.awaze.client-builder/undef)
     (.
      bean10511
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10536] (cloudwatch/dimension arg10536))
 v10513))))
   (clojure.core/let
    [v10513
     (:period m10512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10513 :com.palletops.awaze.client-builder/undef)
     (. bean10511 setPeriod (clojure.core/int v10513))))
   bean10511))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m10515]
  (clojure.core/let
   [bean10514
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/let
    [v10516
     (:namespace m10515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10516 :com.palletops.awaze.client-builder/undef)
     (. bean10514 setNamespace (clojure.core/str v10516))))
   (clojure.core/let
    [v10516
     (:metric-data m10515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10516 :com.palletops.awaze.client-builder/undef)
     (.
      bean10514
      setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10537] (cloudwatch/metric-datum arg10537))
 v10516))))
   bean10514))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m10518]
  (clojure.core/let
   [bean10517
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/let
    [v10519
     (:next-token m10518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10519 :com.palletops.awaze.client-builder/undef)
     (. bean10517 setNextToken (clojure.core/str v10519))))
   (clojure.core/let
    [v10519
     (:max-records m10518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10519 :com.palletops.awaze.client-builder/undef)
     (. bean10517 setMaxRecords (clojure.core/int v10519))))
   (clojure.core/let
    [v10519
     (:alarm-names m10518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10519 :com.palletops.awaze.client-builder/undef)
     (.
      bean10517
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10538] (clojure.core/str arg10538))
 v10519))))
   (clojure.core/let
    [v10519
     (:alarm-name-prefix
      m10518
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10519 :com.palletops.awaze.client-builder/undef)
     (. bean10517 setAlarmNamePrefix (clojure.core/str v10519))))
   (clojure.core/let
    [v10519
     (:state-value m10518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10519 :com.palletops.awaze.client-builder/undef)
     (. bean10517 setStateValue (clojure.core/str v10519))))
   (clojure.core/let
    [v10519
     (:action-prefix m10518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10519 :com.palletops.awaze.client-builder/undef)
     (. bean10517 setActionPrefix (clojure.core/str v10519))))
   bean10517))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m10521]
  (clojure.core/let
   [bean10520
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/let
    [v10522
     (:next-token m10521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10522 :com.palletops.awaze.client-builder/undef)
     (. bean10520 setNextToken (clojure.core/str v10522))))
   (clojure.core/let
    [v10522
     (:max-records m10521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10522 :com.palletops.awaze.client-builder/undef)
     (. bean10520 setMaxRecords (clojure.core/int v10522))))
   (clojure.core/let
    [v10522
     (:start-date m10521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10522 :com.palletops.awaze.client-builder/undef)
     (.
      bean10520
      setStartDate
      (com.palletops.awaze.common/to-date v10522))))
   (clojure.core/let
    [v10522
     (:end-date m10521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10522 :com.palletops.awaze.client-builder/undef)
     (.
      bean10520
      setEndDate
      (com.palletops.awaze.common/to-date v10522))))
   (clojure.core/let
    [v10522
     (:history-item-type
      m10521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10522 :com.palletops.awaze.client-builder/undef)
     (.
      bean10520
      setHistoryItemType
      (cloudwatch/history-item-type v10522))))
   (clojure.core/let
    [v10522
     (:alarm-name m10521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10522 :com.palletops.awaze.client-builder/undef)
     (. bean10520 setAlarmName (clojure.core/str v10522))))
   bean10520))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m10524]
  (clojure.core/let
   [bean10523
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/let
    [v10525
     (:alarm-name m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setAlarmName (clojure.core/str v10525))))
   (clojure.core/let
    [v10525
     (:alarm-description
      m10524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setAlarmDescription (clojure.core/str v10525))))
   (clojure.core/let
    [v10525
     (:okactions m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (.
      bean10523
      setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10627] (clojure.core/str arg10627))
 v10525))))
   (clojure.core/let
    [v10525 (:unit m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setUnit (clojure.core/str v10525))))
   (clojure.core/let
    [v10525
     (:metric-name m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setMetricName (clojure.core/str v10525))))
   (clojure.core/let
    [v10525
     (:dimensions m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (.
      bean10523
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10628] (cloudwatch/dimension arg10628))
 v10525))))
   (clojure.core/let
    [v10525
     (:evaluation-periods
      m10524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setEvaluationPeriods (clojure.core/int v10525))))
   (clojure.core/let
    [v10525
     (:namespace m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setNamespace (clojure.core/str v10525))))
   (clojure.core/let
    [v10525
     (:period m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setPeriod (clojure.core/int v10525))))
   (clojure.core/let
    [v10525
     (:comparison-operator
      m10524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setComparisonOperator (clojure.core/str v10525))))
   (clojure.core/let
    [v10525
     (:actions-enabled
      m10524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setActionsEnabled (clojure.core/boolean v10525))))
   (clojure.core/let
    [v10525
     (:alarm-actions m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (.
      bean10523
      setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10629] (clojure.core/str arg10629))
 v10525))))
   (clojure.core/let
    [v10525
     (:insufficient-data-actions
      m10524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (.
      bean10523
      setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10630] (clojure.core/str arg10630))
 v10525))))
   (clojure.core/let
    [v10525
     (:threshold m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setThreshold (clojure.core/double v10525))))
   (clojure.core/let
    [v10525
     (:statistic m10524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10525 :com.palletops.awaze.client-builder/undef)
     (. bean10523 setStatistic (clojure.core/str v10525))))
   bean10523))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m10527]
  (clojure.core/let
   [bean10526
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/let
    [v10528
     (:start-time m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (.
      bean10526
      setStartTime
      (com.palletops.awaze.common/to-date v10528))))
   (clojure.core/let
    [v10528
     (:end-time m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (.
      bean10526
      setEndTime
      (com.palletops.awaze.common/to-date v10528))))
   (clojure.core/let
    [v10528
     (:namespace m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (. bean10526 setNamespace (clojure.core/str v10528))))
   (clojure.core/let
    [v10528
     (:metric-name m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (. bean10526 setMetricName (clojure.core/str v10528))))
   (clojure.core/let
    [v10528 (:unit m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (. bean10526 setUnit (clojure.core/str v10528))))
   (clojure.core/let
    [v10528
     (:dimensions m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (.
      bean10526
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10631] (cloudwatch/dimension arg10631))
 v10528))))
   (clojure.core/let
    [v10528
     (:period m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (. bean10526 setPeriod (clojure.core/int v10528))))
   (clojure.core/let
    [v10528
     (:statistics m10527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10528 :com.palletops.awaze.client-builder/undef)
     (.
      bean10526
      setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10632] (clojure.core/str arg10632))
 v10528))))
   bean10526))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m10530]
  (clojure.core/let
   [bean10529
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/let
    [v10531
     (:next-token m10530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10531 :com.palletops.awaze.client-builder/undef)
     (. bean10529 setNextToken (clojure.core/str v10531))))
   (clojure.core/let
    [v10531
     (:namespace m10530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10531 :com.palletops.awaze.client-builder/undef)
     (. bean10529 setNamespace (clojure.core/str v10531))))
   (clojure.core/let
    [v10531
     (:metric-name m10530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10531 :com.palletops.awaze.client-builder/undef)
     (. bean10529 setMetricName (clojure.core/str v10531))))
   (clojure.core/let
    [v10531
     (:dimensions m10530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10531 :com.palletops.awaze.client-builder/undef)
     (.
      bean10529
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10633] (cloudwatch/dimension-filter arg10633))
 v10531))))
   bean10529))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m10539]
   (clojure.core/let
    [credentials10540 (:credentials m10539) args10541 (:args m10539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10542
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10540)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10542
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args10541 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-alarms,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAlarms"}
   [credentials10544 & args10545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10546
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10544)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10546
      deleteAlarms
      (cloudwatch/delete-alarms-request
       (clojure.core/nth args10545 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m10547]
   (clojure.core/let
    [credentials10548 (:credentials m10547) args10549 (:args m10547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10550
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10550
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args10549 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-alarm-actions,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAlarmActions"}
   [credentials10552 & args10553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10554
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10554
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args10553 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m10555]
   (clojure.core/let
    [credentials10556 (:credentials m10555) args10557 (:args m10555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10558
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10558
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args10557 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-alarm-actions,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAlarmActions"}
   [credentials10560 & args10561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10562
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10562
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args10561 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m10563]
   (clojure.core/let
    [credentials10564 (:credentials m10563) args10565 (:args m10563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10566
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10566
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args10565 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-alarm-state,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Call setAlarmState"}
   [credentials10568 & args10569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10570
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10570
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args10569 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m10571]
   (clojure.core/let
    [credentials10572 (:credentials m10571) args10573 (:args m10571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10574
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10574
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args10573 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-alarms-for-metric,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials10576 & args10577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10578
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10578
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args10577 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m10579]
   (clojure.core/let
    [credentials10580 (:credentials m10579) args10581 (:args m10579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10582
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10582
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args10581 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-metric-data,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricData"}
   [credentials10584 & args10585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10586
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10586
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args10585 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m10587]
   (clojure.core/let
    [credentials10588 (:credentials m10587) args10589 (:args m10587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10590
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10588)]
     (clojure.core/case
      (clojure.core/count args10589)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10590
        describeAlarms))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10590
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args10589 0))))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-alarms,
     :credentials credentials__1784__auto__,
     :client :cloudwatch})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-alarms,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials10592 & args10593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10594
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10592)]
    (clojure.core/case
     (clojure.core/count args10593)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10594
       describeAlarms))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10594
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args10593 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m10595]
   (clojure.core/let
    [credentials10596 (:credentials m10595) args10597 (:args m10595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10598
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10596)]
     (clojure.core/case
      (clojure.core/count args10597)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10598
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args10597 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10598
        describeAlarmHistory))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-alarm-history,
     :credentials credentials__1784__auto__,
     :client :cloudwatch})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-alarm-history,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials10600 & args10601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10602
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10600)]
    (clojure.core/case
     (clojure.core/count args10601)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10602
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args10601 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10602
       describeAlarmHistory))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m10603]
   (clojure.core/let
    [credentials10604 (:credentials m10603) args10605 (:args m10603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10606
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10606
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args10605 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-metric-alarm,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricAlarm"}
   [credentials10608 & args10609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10610
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10610
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args10609 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m10611]
   (clojure.core/let
    [credentials10612 (:credentials m10611) args10613 (:args m10611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10614
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10614
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args10613 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-metric-statistics,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call getMetricStatistics"}
   [credentials10616 & args10617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10618
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10618
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args10617 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m10619]
   (clojure.core/let
    [credentials10620 (:credentials m10619) args10621 (:args m10619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10622
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10620)]
     (clojure.core/case
      (clojure.core/count args10621)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10622
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args10621 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10622
        listMetrics))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-metrics,
     :credentials credentials__1784__auto__,
     :client :cloudwatch})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-metrics,
     :credentials credentials__1784__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials10624 & args10625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10626
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10624)]
    (clojure.core/case
     (clojure.core/count args10625)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10626
       listMetrics
       (cloudwatch/list-metrics-request
        (clojure.core/nth args10625 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10626
       listMetrics)))))))
