(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m7830]
  (clojure.core/let
   [bean7829
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/let
    [v7831
     (:default-value m7830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7831 :com.palletops.awaze.client-builder/undef)
     (. bean7829 setDefaultValue (clojure.core/str v7831))))
   (clojure.core/let
    [v7831
     (:source-name m7830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7831 :com.palletops.awaze.client-builder/undef)
     (. bean7829 setSourceName (clojure.core/str v7831))))
   bean7829))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m7833]
  (clojure.core/let
   [bean7832
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/let
    [v7834
     (:default-value m7833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7834 :com.palletops.awaze.client-builder/undef)
     (. bean7832 setDefaultValue (clojure.core/str v7834))))
   (clojure.core/let
    [v7834
     (:language m7833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7834 :com.palletops.awaze.client-builder/undef)
     (. bean7832 setLanguage (clojure.core/str v7834))))
   (clojure.core/let
    [v7834
     (:source-name m7833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7834 :com.palletops.awaze.client-builder/undef)
     (. bean7832 setSourceName (clojure.core/str v7834))))
   (clojure.core/let
    [v7834
     (:separator m7833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7834 :com.palletops.awaze.client-builder/undef)
     (. bean7832 setSeparator (clojure.core/str v7834))))
   bean7832))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m7836]
  (clojure.core/let
   [bean7835
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/let
    [v7837
     (:default-value m7836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7837 :com.palletops.awaze.client-builder/undef)
     (. bean7835 setDefaultValue (clojure.core/str v7837))))
   (clojure.core/let
    [v7837 (:cases m7836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7837 :com.palletops.awaze.client-builder/undef)
     (.
      bean7835
      setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg7922] (clojure.core/str arg7922))
  (clojure.core/keys v7837))
 (clojure.core/map
  (clojure.core/fn [arg7922] (clojure.core/str arg7922))
  (clojure.core/vals v7837))))))
   (clojure.core/let
    [v7837
     (:source-name m7836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7837 :com.palletops.awaze.client-builder/undef)
     (. bean7835 setSourceName (clojure.core/str v7837))))
   bean7835))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m7839]
  (clojure.core/let
   [bean7838
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/let
    [v7840
     (:default-value m7839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7840 :com.palletops.awaze.client-builder/undef)
     (. bean7838 setDefaultValue (clojure.core/int v7840))))
   bean7838))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m7842]
  (clojure.core/let
   [bean7841
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/let
    [v7843
     (:default-value m7842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7843 :com.palletops.awaze.client-builder/undef)
     (. bean7841 setDefaultValue (clojure.core/str v7843))))
   (clojure.core/let
    [v7843
     (:search-enabled m7842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7843 :com.palletops.awaze.client-builder/undef)
     (. bean7841 setSearchEnabled (clojure.core/boolean v7843))))
   (clojure.core/let
    [v7843
     (:facet-enabled m7842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7843 :com.palletops.awaze.client-builder/undef)
     (. bean7841 setFacetEnabled (clojure.core/boolean v7843))))
   (clojure.core/let
    [v7843
     (:result-enabled m7842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7843 :com.palletops.awaze.client-builder/undef)
     (. bean7841 setResultEnabled (clojure.core/boolean v7843))))
   bean7841))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m7845]
  (clojure.core/let
   [bean7844
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/let
    [v7846
     (:default-value m7845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7846 :com.palletops.awaze.client-builder/undef)
     (. bean7844 setDefaultValue (clojure.core/str v7846))))
   (clojure.core/let
    [v7846
     (:facet-enabled m7845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7846 :com.palletops.awaze.client-builder/undef)
     (. bean7844 setFacetEnabled (clojure.core/boolean v7846))))
   (clojure.core/let
    [v7846
     (:result-enabled m7845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7846 :com.palletops.awaze.client-builder/undef)
     (. bean7844 setResultEnabled (clojure.core/boolean v7846))))
   (clojure.core/let
    [v7846
     (:text-processor m7845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7846 :com.palletops.awaze.client-builder/undef)
     (. bean7844 setTextProcessor (clojure.core/str v7846))))
   bean7844))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m7848]
  (clojure.core/let
   [bean7847
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/let
    [v7849
     (:source-data-function
      m7848
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7849 :com.palletops.awaze.client-builder/undef)
     (. bean7847 setSourceDataFunction (clojure.core/str v7849))))
   (clojure.core/let
    [v7849
     (:source-data-copy
      m7848
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7849 :com.palletops.awaze.client-builder/undef)
     (. bean7847 setSourceDataCopy (cloudsearch/source-data v7849))))
   (clojure.core/let
    [v7849
     (:source-data-trim-title
      m7848
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7849 :com.palletops.awaze.client-builder/undef)
     (.
      bean7847
      setSourceDataTrimTitle
      (cloudsearch/source-data-trim-title v7849))))
   (clojure.core/let
    [v7849
     (:source-data-map
      m7848
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7849 :com.palletops.awaze.client-builder/undef)
     (. bean7847 setSourceDataMap (cloudsearch/source-data-map v7849))))
   bean7847))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m7851]
  (clojure.core/let
   [bean7850
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/let
    [v7852
     (:rank-name m7851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7852 :com.palletops.awaze.client-builder/undef)
     (. bean7850 setRankName (clojure.core/str v7852))))
   (clojure.core/let
    [v7852
     (:rank-expression
      m7851
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7852 :com.palletops.awaze.client-builder/undef)
     (. bean7850 setRankExpression (clojure.core/str v7852))))
   bean7850))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m7854]
  (clojure.core/let
   [bean7853
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/let
    [v7855
     (:index-field-type
      m7854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7855 :com.palletops.awaze.client-builder/undef)
     (. bean7853 setIndexFieldType (clojure.core/str v7855))))
   (clojure.core/let
    [v7855
     (:uint-options m7854 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7855 :com.palletops.awaze.client-builder/undef)
     (. bean7853 setUIntOptions (cloudsearch/uint-options v7855))))
   (clojure.core/let
    [v7855
     (:literal-options
      m7854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7855 :com.palletops.awaze.client-builder/undef)
     (.
      bean7853
      setLiteralOptions
      (cloudsearch/literal-options v7855))))
   (clojure.core/let
    [v7855
     (:text-options m7854 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7855 :com.palletops.awaze.client-builder/undef)
     (. bean7853 setTextOptions (cloudsearch/text-options v7855))))
   (clojure.core/let
    [v7855
     (:source-attributes
      m7854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7855 :com.palletops.awaze.client-builder/undef)
     (.
      bean7853
      setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7923] (cloudsearch/source-attribute arg7923))
 v7855))))
   (clojure.core/let
    [v7855
     (:index-field-name
      m7854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7855 :com.palletops.awaze.client-builder/undef)
     (. bean7853 setIndexFieldName (clojure.core/str v7855))))
   bean7853))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m7857]
  (clojure.core/let
   [bean7856
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/let
    [v7858
     (:domain-name m7857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7858 :com.palletops.awaze.client-builder/undef)
     (. bean7856 setDomainName (clojure.core/str v7858))))
   (clojure.core/let
    [v7858 (:stems m7857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7858 :com.palletops.awaze.client-builder/undef)
     (. bean7856 setStems (clojure.core/str v7858))))
   bean7856))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m7860]
  (clojure.core/let
   [bean7859
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/let
    [v7861
     (:domain-name m7860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7861 :com.palletops.awaze.client-builder/undef)
     (. bean7859 setDomainName (clojure.core/str v7861))))
   (clojure.core/let
    [v7861
     (:synonyms m7860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7861 :com.palletops.awaze.client-builder/undef)
     (. bean7859 setSynonyms (clojure.core/str v7861))))
   bean7859))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m7863]
  (clojure.core/let
   [bean7862
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/let
    [v7864
     (:domain-name m7863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7864 :com.palletops.awaze.client-builder/undef)
     (. bean7862 setDomainName (clojure.core/str v7864))))
   bean7862))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m7866]
  (clojure.core/let
   [bean7865
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/let
    [v7867
     (:domain-name m7866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7867 :com.palletops.awaze.client-builder/undef)
     (. bean7865 setDomainName (clojure.core/str v7867))))
   (clojure.core/let
    [v7867
     (:rank-expression
      m7866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7867 :com.palletops.awaze.client-builder/undef)
     (.
      bean7865
      setRankExpression
      (cloudsearch/named-rank-expression v7867))))
   bean7865))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m7869]
  (clojure.core/let
   [bean7868
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/let
    [v7870
     (:domain-name m7869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7870 :com.palletops.awaze.client-builder/undef)
     (. bean7868 setDomainName (clojure.core/str v7870))))
   (clojure.core/let
    [v7870
     (:stopwords m7869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7870 :com.palletops.awaze.client-builder/undef)
     (. bean7868 setStopwords (clojure.core/str v7870))))
   bean7868))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m7872]
  (clojure.core/let
   [bean7871
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/let
    [v7873
     (:domain-names m7872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7873 :com.palletops.awaze.client-builder/undef)
     (.
      bean7871
      setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7924] (clojure.core/str arg7924))
 v7873))))
   bean7871))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m7875]
  (clojure.core/let
   [bean7874
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/let
    [v7876
     (:domain-name m7875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7876 :com.palletops.awaze.client-builder/undef)
     (. bean7874 setDomainName (clojure.core/str v7876))))
   (clojure.core/let
    [v7876
     (:rank-names m7875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7876 :com.palletops.awaze.client-builder/undef)
     (.
      bean7874
      setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7925] (clojure.core/str arg7925))
 v7876))))
   bean7874))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m7878]
  (clojure.core/let
   [bean7877
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/let
    [v7879
     (:domain-name m7878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7879 :com.palletops.awaze.client-builder/undef)
     (. bean7877 setDomainName (clojure.core/str v7879))))
   bean7877))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m7881]
  (clojure.core/let
   [bean7880
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/let
    [v7882
     (:domain-name m7881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7882 :com.palletops.awaze.client-builder/undef)
     (. bean7880 setDomainName (clojure.core/str v7882))))
   bean7880))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m7884]
  (clojure.core/let
   [bean7883
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/let
    [v7885
     (:domain-name m7884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7885 :com.palletops.awaze.client-builder/undef)
     (. bean7883 setDomainName (clojure.core/str v7885))))
   (clojure.core/let
    [v7885
     (:index-field m7884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7885 :com.palletops.awaze.client-builder/undef)
     (. bean7883 setIndexField (cloudsearch/index-field v7885))))
   bean7883))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m7887]
  (clojure.core/let
   [bean7886
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7888
     (:domain-name m7887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7888 :com.palletops.awaze.client-builder/undef)
     (. bean7886 setDomainName (clojure.core/str v7888))))
   bean7886))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m7890]
  (clojure.core/let
   [bean7889
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7891
     (:domain-name m7890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7891 :com.palletops.awaze.client-builder/undef)
     (. bean7889 setDomainName (clojure.core/str v7891))))
   (clojure.core/let
    [v7891
     (:default-search-field
      m7890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7891 :com.palletops.awaze.client-builder/undef)
     (. bean7889 setDefaultSearchField (clojure.core/str v7891))))
   bean7889))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m7893]
  (clojure.core/let
   [bean7892
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/let
    [v7894
     (:domain-name m7893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7894 :com.palletops.awaze.client-builder/undef)
     (. bean7892 setDomainName (clojure.core/str v7894))))
   (clojure.core/let
    [v7894
     (:field-names m7893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7894 :com.palletops.awaze.client-builder/undef)
     (.
      bean7892
      setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7926] (clojure.core/str arg7926))
 v7894))))
   bean7892))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m7896]
  (clojure.core/let
   [bean7895
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7897
     (:domain-name m7896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7897 :com.palletops.awaze.client-builder/undef)
     (. bean7895 setDomainName (clojure.core/str v7897))))
   (clojure.core/let
    [v7897
     (:multi-az m7896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7897 :com.palletops.awaze.client-builder/undef)
     (. bean7895 setMultiAZ (clojure.core/boolean v7897))))
   bean7895))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m7899]
  (clojure.core/let
   [bean7898
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7900
     (:domain-name m7899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7900 :com.palletops.awaze.client-builder/undef)
     (. bean7898 setDomainName (clojure.core/str v7900))))
   (clojure.core/let
    [v7900
     (:access-policies
      m7899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7900 :com.palletops.awaze.client-builder/undef)
     (. bean7898 setAccessPolicies (clojure.core/str v7900))))
   bean7898))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m7902]
  (clojure.core/let
   [bean7901
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7903
     (:domain-name m7902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7903 :com.palletops.awaze.client-builder/undef)
     (. bean7901 setDomainName (clojure.core/str v7903))))
   bean7901))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m7905]
  (clojure.core/let
   [bean7904
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/let
    [v7906
     (:domain-name m7905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7906 :com.palletops.awaze.client-builder/undef)
     (. bean7904 setDomainName (clojure.core/str v7906))))
   bean7904))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m7908]
  (clojure.core/let
   [bean7907
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/let
    [v7909
     (:domain-name m7908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7909 :com.palletops.awaze.client-builder/undef)
     (. bean7907 setDomainName (clojure.core/str v7909))))
   bean7907))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m7911]
  (clojure.core/let
   [bean7910
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/let
    [v7912
     (:domain-name m7911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7912 :com.palletops.awaze.client-builder/undef)
     (. bean7910 setDomainName (clojure.core/str v7912))))
   (clojure.core/let
    [v7912
     (:rank-name m7911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7912 :com.palletops.awaze.client-builder/undef)
     (. bean7910 setRankName (clojure.core/str v7912))))
   bean7910))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m7914]
  (clojure.core/let
   [bean7913
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/let
    [v7915
     (:index-field-name
      m7914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7915 :com.palletops.awaze.client-builder/undef)
     (. bean7913 setIndexFieldName (clojure.core/str v7915))))
   (clojure.core/let
    [v7915
     (:domain-name m7914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7915 :com.palletops.awaze.client-builder/undef)
     (. bean7913 setDomainName (clojure.core/str v7915))))
   bean7913))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m7917]
  (clojure.core/let
   [bean7916
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7918
     (:domain-name m7917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7918 :com.palletops.awaze.client-builder/undef)
     (. bean7916 setDomainName (clojure.core/str v7918))))
   bean7916))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m7920]
  (clojure.core/let
   [bean7919
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/let
    [v7921
     (:domain-name m7920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7921 :com.palletops.awaze.client-builder/undef)
     (. bean7919 setDomainName (clojure.core/str v7921))))
   bean7919))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m7927]
   (clojure.core/let
    [credentials7928 (:credentials m7927) args7929 (:args m7927)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7930
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7928)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7930
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args7929 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-stemming-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials7932 & args7933]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7934
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7932)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7934
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args7933 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m7935]
   (clojure.core/let
    [credentials7936 (:credentials m7935) args7937 (:args m7935)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7938
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7936)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7938
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args7937 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-synonym-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials7940 & args7941]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7942
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7940)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7942
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args7941 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m7943]
   (clojure.core/let
    [credentials7944 (:credentials m7943) args7945 (:args m7943)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7946
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7944)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7946
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args7945 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials7948 & args7949]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7950
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7948)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7950
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args7949 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m7951]
   (clojure.core/let
    [credentials7952 (:credentials m7951) args7953 (:args m7951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7954
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7952)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7954
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args7953 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :define-rank-expression,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineRankExpression"}
   [credentials7956 & args7957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7958
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7956)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7958
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args7957 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m7959]
   (clojure.core/let
    [credentials7960 (:credentials m7959) args7961 (:args m7959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7962
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7960)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7962
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args7961 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-stopword-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials7964 & args7965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7966
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7966
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args7965 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m7967]
   (clojure.core/let
    [credentials7968 (:credentials m7967) args7969 (:args m7967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7970
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7968)]
     (clojure.core/case
      (clojure.core/count args7969)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7970
        describeDomains))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7970
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args7969 0))))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-domains,
     :credentials credentials__1784__auto__,
     :client :cloudsearch})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-domains,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials7972 & args7973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7974
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7972)]
    (clojure.core/case
     (clojure.core/count args7973)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7974
       describeDomains))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7974
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args7973 0))))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m7975]
   (clojure.core/let
    [credentials7976 (:credentials m7975) args7977 (:args m7975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7978
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7976)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7978
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args7977 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-rank-expressions,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRankExpressions"}
   [credentials7980 & args7981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7982
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7980)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7982
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args7981 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m7983]
   (clojure.core/let
    [credentials7984 (:credentials m7983) args7985 (:args m7983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7986
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7984)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7986
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args7985 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :index-documents,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call indexDocuments"}
   [credentials7988 & args7989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7990
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7988)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7990
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args7989 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m7991]
   (clojure.core/let
    [credentials7992 (:credentials m7991) args7993 (:args m7991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7994
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7992)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7994
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args7993 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-stemming-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials7996 & args7997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7998
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7996)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7998
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args7997 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m7999]
   (clojure.core/let
    [credentials8000 (:credentials m7999) args8001 (:args m7999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8002
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8002
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args8001 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :define-index-field,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineIndexField"}
   [credentials8004 & args8005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8006
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8006
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args8005 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m8007]
   (clojure.core/let
    [credentials8008 (:credentials m8007) args8009 (:args m8007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8010
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8008)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8010
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args8009 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-default-search-field,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials8012 & args8013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8014
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8012)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8014
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args8013 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m8015]
   (clojure.core/let
    [credentials8016 (:credentials m8015) args8017 (:args m8015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8018
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8018
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args8017 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-default-search-field,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials8020 & args8021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8022
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8020)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8022
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args8021 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m8023]
   (clojure.core/let
    [credentials8024 (:credentials m8023) args8025 (:args m8023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8026
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8026
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args8025 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-index-fields,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeIndexFields"}
   [credentials8028 & args8029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8030
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8030
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args8029 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m8031]
   (clojure.core/let
    [credentials8032 (:credentials m8031) args8033 (:args m8031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8034
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8032)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8034
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args8033 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-availability-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials8036 & args8037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8038
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8036)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8038
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args8037 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m8039]
   (clojure.core/let
    [credentials8040 (:credentials m8039) args8041 (:args m8039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8042
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8042
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args8041 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-service-access-policies,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials8044 & args8045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8046
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8046
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args8045 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m8047]
   (clojure.core/let
    [credentials8048 (:credentials m8047) args8049 (:args m8047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8050
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8048)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8050
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args8049 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-service-access-policies,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials8052 & args8053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8054
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8054
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args8053 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m8055]
   (clojure.core/let
    [credentials8056 (:credentials m8055) args8057 (:args m8055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8058
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8058
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args8057 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-stopword-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials8060 & args8061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8062
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8062
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args8061 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m8063]
   (clojure.core/let
    [credentials8064 (:credentials m8063) args8065 (:args m8063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8066
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8064)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8066
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args8065 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-synonym-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials8068 & args8069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8070
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8068)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8070
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args8069 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m8071]
   (clojure.core/let
    [credentials8072 (:credentials m8071) args8073 (:args m8071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8074
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8072)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8074
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args8073 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-rank-expression,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRankExpression"}
   [credentials8076 & args8077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8078
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8076)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8078
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args8077 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m8079]
   (clojure.core/let
    [credentials8080 (:credentials m8079) args8081 (:args m8079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8082
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8080)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8082
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args8081 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-index-field,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIndexField"}
   [credentials8084 & args8085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8086
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8084)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8086
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args8085 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m8087]
   (clojure.core/let
    [credentials8088 (:credentials m8087) args8089 (:args m8087)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8090
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8088)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8090
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args8089 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-availability-options,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials8092 & args8093]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8094
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8092)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8094
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args8093 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m8095]
   (clojure.core/let
    [credentials8096 (:credentials m8095) args8097 (:args m8095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8098
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8096)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8098
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args8097 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1784__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8100 & args8101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8102
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8100)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8102
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args8101 0))))))))
