(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m11890]
  (clojure.core/let
   [bean11889
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/let
    [v11891
     (:quantity m11890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11891 :com.palletops.awaze.client-builder/undef)
     (. bean11889 setQuantity (clojure.core/int v11891))))
   (clojure.core/let
    [v11891 (:items m11890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11891 :com.palletops.awaze.client-builder/undef)
     (.
      bean11889
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12060] (clojure.core/str arg12060))
 v11891))))
   bean11889))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m11893]
  (clojure.core/let
   [bean11892 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/let
    [v11894
     (:quantity m11893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11894 :com.palletops.awaze.client-builder/undef)
     (. bean11892 setQuantity (clojure.core/int v11894))))
   (clojure.core/let
    [v11894 (:items m11893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11894 :com.palletops.awaze.client-builder/undef)
     (.
      bean11892
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12061] (clojure.core/str arg12061))
 v11894))))
   bean11892))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m11896]
  (clojure.core/let
   [bean11895
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/let
    [v11897
     (:forward m11896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11897 :com.palletops.awaze.client-builder/undef)
     (. bean11895 setForward (clojure.core/str v11897))))
   (clojure.core/let
    [v11897
     (:whitelisted-names
      m11896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11897 :com.palletops.awaze.client-builder/undef)
     (.
      bean11895
      setWhitelistedNames
      (cloudfront/cookie-names v11897))))
   bean11895))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CachedMethods}
cached-methods
  [m11899]
  (clojure.core/let
   [bean11898
    (new com.amazonaws.services.cloudfront.model.CachedMethods)]
   (clojure.core/let
    [v11900
     (:quantity m11899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11900 :com.palletops.awaze.client-builder/undef)
     (. bean11898 setQuantity (clojure.core/int v11900))))
   (clojure.core/let
    [v11900 (:items m11899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11900 :com.palletops.awaze.client-builder/undef)
     (.
      bean11898
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12062] (clojure.core/str arg12062))
 v11900))))
   bean11898))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginCustomHeader}
origin-custom-header
  [m11902]
  (clojure.core/let
   [bean11901
    (new com.amazonaws.services.cloudfront.model.OriginCustomHeader)]
   (clojure.core/let
    [v11903
     (:header-name m11902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11903 :com.palletops.awaze.client-builder/undef)
     (. bean11901 setHeaderName (clojure.core/str v11903))))
   (clojure.core/let
    [v11903
     (:header-value m11902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11903 :com.palletops.awaze.client-builder/undef)
     (. bean11901 setHeaderValue (clojure.core/str v11903))))
   bean11901))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginProtocolPolicy}
origin-protocol-policy
  [m11905]
  (.
   com.amazonaws.services.cloudfront.model.OriginProtocolPolicy
   fromValue
   (clojure.core/name m11905)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginSslProtocols}
origin-ssl-protocols
  [m11908]
  (clojure.core/let
   [bean11907
    (new com.amazonaws.services.cloudfront.model.OriginSslProtocols)]
   (clojure.core/let
    [v11909
     (:quantity m11908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11909 :com.palletops.awaze.client-builder/undef)
     (. bean11907 setQuantity (clojure.core/int v11909))))
   (clojure.core/let
    [v11909 (:items m11908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11909 :com.palletops.awaze.client-builder/undef)
     (.
      bean11907
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12063] (clojure.core/str arg12063))
 v11909))))
   bean11907))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m11911]
  (clojure.core/let
   [bean11910
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/let
    [v11912
     (:headers m11911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11912 :com.palletops.awaze.client-builder/undef)
     (. bean11910 setHeaders (cloudfront/headers v11912))))
   (clojure.core/let
    [v11912
     (:query-string m11911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11912 :com.palletops.awaze.client-builder/undef)
     (. bean11910 setQueryString (clojure.core/boolean v11912))))
   (clojure.core/let
    [v11912
     (:cookies m11911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11912 :com.palletops.awaze.client-builder/undef)
     (. bean11910 setCookies (cloudfront/cookie-preference v11912))))
   bean11910))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m11914]
  (clojure.core/let
   [bean11913
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/let
    [v11915
     (:quantity m11914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11915 :com.palletops.awaze.client-builder/undef)
     (. bean11913 setQuantity (clojure.core/int v11915))))
   (clojure.core/let
    [v11915
     (:enabled m11914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11915 :com.palletops.awaze.client-builder/undef)
     (. bean11913 setEnabled (clojure.core/boolean v11915))))
   (clojure.core/let
    [v11915 (:items m11914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11915 :com.palletops.awaze.client-builder/undef)
     (.
      bean11913
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12064] (clojure.core/str arg12064))
 v11915))))
   bean11913))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m11917]
  (clojure.core/let
   [bean11916
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/let
    [v11918
     (:quantity m11917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11918 :com.palletops.awaze.client-builder/undef)
     (. bean11916 setQuantity (clojure.core/int v11918))))
   (clojure.core/let
    [v11918
     (:cached-methods
      m11917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11918 :com.palletops.awaze.client-builder/undef)
     (. bean11916 setCachedMethods (cloudfront/cached-methods v11918))))
   (clojure.core/let
    [v11918 (:items m11917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11918 :com.palletops.awaze.client-builder/undef)
     (.
      bean11916
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12065] (clojure.core/str arg12065))
 v11918))))
   bean11916))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomHeaders}
custom-headers
  [m11920]
  (clojure.core/let
   [bean11919
    (new com.amazonaws.services.cloudfront.model.CustomHeaders)]
   (clojure.core/let
    [v11921
     (:quantity m11920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11921 :com.palletops.awaze.client-builder/undef)
     (. bean11919 setQuantity (clojure.core/int v11921))))
   (clojure.core/let
    [v11921 (:items m11920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11921 :com.palletops.awaze.client-builder/undef)
     (.
      bean11919
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12066]
  (cloudfront/origin-custom-header arg12066))
 v11921))))
   bean11919))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m11923]
  (clojure.core/let
   [bean11922
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/let
    [v11924
     (:origin-access-identity
      m11923
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11924 :com.palletops.awaze.client-builder/undef)
     (. bean11922 setOriginAccessIdentity (clojure.core/str v11924))))
   bean11922))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m11926]
  (clojure.core/let
   [bean11925
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/let
    [v11927
     (:httpport m11926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11927 :com.palletops.awaze.client-builder/undef)
     (. bean11925 setHTTPPort (clojure.core/int v11927))))
   (clojure.core/let
    [v11927
     (:httpsport m11926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11927 :com.palletops.awaze.client-builder/undef)
     (. bean11925 setHTTPSPort (clojure.core/int v11927))))
   (clojure.core/let
    [v11927
     (:origin-protocol-policy
      m11926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11927 :com.palletops.awaze.client-builder/undef)
     (.
      bean11925
      setOriginProtocolPolicy
      (cloudfront/origin-protocol-policy v11927))))
   (clojure.core/let
    [v11927
     (:origin-ssl-protocols
      m11926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11927 :com.palletops.awaze.client-builder/undef)
     (.
      bean11925
      setOriginSslProtocols
      (cloudfront/origin-ssl-protocols v11927))))
   bean11925))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m11929]
  (clojure.core/let
   [bean11928
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/let
    [v11930
     (:quantity m11929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11930 :com.palletops.awaze.client-builder/undef)
     (. bean11928 setQuantity (clojure.core/int v11930))))
   (clojure.core/let
    [v11930
     (:restriction-type
      m11929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11930 :com.palletops.awaze.client-builder/undef)
     (. bean11928 setRestrictionType (clojure.core/str v11930))))
   (clojure.core/let
    [v11930 (:items m11929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11930 :com.palletops.awaze.client-builder/undef)
     (.
      bean11928
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12067] (clojure.core/str arg12067))
 v11930))))
   bean11928))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy}
viewer-protocol-policy
  [m11932]
  (.
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   fromValue
   (clojure.core/name m11932)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m11935]
  (clojure.core/let
   [bean11934
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/let
    [v11936
     (:smooth-streaming
      m11935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setSmoothStreaming (clojure.core/boolean v11936))))
   (clojure.core/let
    [v11936
     (:path-pattern m11935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setPathPattern (clojure.core/str v11936))))
   (clojure.core/let
    [v11936
     (:forwarded-values
      m11935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (.
      bean11934
      setForwardedValues
      (cloudfront/forwarded-values v11936))))
   (clojure.core/let
    [v11936
     (:trusted-signers
      m11935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (.
      bean11934
      setTrustedSigners
      (cloudfront/trusted-signers v11936))))
   (clojure.core/let
    [v11936
     (:max-ttl m11935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setMaxTTL (clojure.core/long v11936))))
   (clojure.core/let
    [v11936
     (:viewer-protocol-policy
      m11935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setViewerProtocolPolicy (clojure.core/str v11936))))
   (clojure.core/let
    [v11936
     (:target-origin-id
      m11935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setTargetOriginId (clojure.core/str v11936))))
   (clojure.core/let
    [v11936
     (:default-ttl m11935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setDefaultTTL (clojure.core/long v11936))))
   (clojure.core/let
    [v11936
     (:compress m11935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setCompress (clojure.core/boolean v11936))))
   (clojure.core/let
    [v11936
     (:allowed-methods
      m11935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (.
      bean11934
      setAllowedMethods
      (cloudfront/allowed-methods v11936))))
   (clojure.core/let
    [v11936
     (:min-ttl m11935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11936 :com.palletops.awaze.client-builder/undef)
     (. bean11934 setMinTTL (clojure.core/long v11936))))
   bean11934))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.MinimumProtocolVersion}
minimum-protocol-version
  [m11938]
  (.
   com.amazonaws.services.cloudfront.model.MinimumProtocolVersion
   fromValue
   (clojure.core/name m11938)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m11941]
  (clojure.core/let
   [bean11940 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/let
    [v11942
     (:domain-name m11941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11942 :com.palletops.awaze.client-builder/undef)
     (. bean11940 setDomainName (clojure.core/str v11942))))
   (clojure.core/let
    [v11942 (:id m11941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11942 :com.palletops.awaze.client-builder/undef)
     (. bean11940 setId (clojure.core/str v11942))))
   (clojure.core/let
    [v11942
     (:origin-path m11941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11942 :com.palletops.awaze.client-builder/undef)
     (. bean11940 setOriginPath (clojure.core/str v11942))))
   (clojure.core/let
    [v11942
     (:custom-headers
      m11941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11942 :com.palletops.awaze.client-builder/undef)
     (. bean11940 setCustomHeaders (cloudfront/custom-headers v11942))))
   (clojure.core/let
    [v11942
     (:s3origin-config
      m11941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11942 :com.palletops.awaze.client-builder/undef)
     (.
      bean11940
      setS3OriginConfig
      (cloudfront/s3origin-config v11942))))
   (clojure.core/let
    [v11942
     (:custom-origin-config
      m11941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11942 :com.palletops.awaze.client-builder/undef)
     (.
      bean11940
      setCustomOriginConfig
      (cloudfront/custom-origin-config v11942))))
   bean11940))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m11944]
  (clojure.core/let
   [bean11943
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/let
    [v11945
     (:error-code m11944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11945 :com.palletops.awaze.client-builder/undef)
     (. bean11943 setErrorCode (clojure.core/int v11945))))
   (clojure.core/let
    [v11945
     (:response-page-path
      m11944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11945 :com.palletops.awaze.client-builder/undef)
     (. bean11943 setResponsePagePath (clojure.core/str v11945))))
   (clojure.core/let
    [v11945
     (:response-code m11944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11945 :com.palletops.awaze.client-builder/undef)
     (. bean11943 setResponseCode (clojure.core/str v11945))))
   (clojure.core/let
    [v11945
     (:error-caching-min-ttl
      m11944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11945 :com.palletops.awaze.client-builder/undef)
     (. bean11943 setErrorCachingMinTTL (clojure.core/long v11945))))
   bean11943))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m11947]
  (clojure.core/let
   [bean11946 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/let
    [v11948
     (:quantity m11947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11948 :com.palletops.awaze.client-builder/undef)
     (. bean11946 setQuantity (clojure.core/int v11948))))
   (clojure.core/let
    [v11948 (:items m11947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11948 :com.palletops.awaze.client-builder/undef)
     (.
      bean11946
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12068] (clojure.core/str arg12068))
 v11948))))
   bean11946))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m11950]
  (clojure.core/let
   [bean11949
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/let
    [v11951
     (:geo-restriction
      m11950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11951 :com.palletops.awaze.client-builder/undef)
     (.
      bean11949
      setGeoRestriction
      (cloudfront/geo-restriction v11951))))
   bean11949))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m11953]
  (clojure.core/let
   [bean11952
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/let
    [v11954
     (:smooth-streaming
      m11953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (. bean11952 setSmoothStreaming (clojure.core/boolean v11954))))
   (clojure.core/let
    [v11954
     (:forwarded-values
      m11953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (.
      bean11952
      setForwardedValues
      (cloudfront/forwarded-values v11954))))
   (clojure.core/let
    [v11954
     (:trusted-signers
      m11953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (.
      bean11952
      setTrustedSigners
      (cloudfront/trusted-signers v11954))))
   (clojure.core/let
    [v11954
     (:max-ttl m11953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (. bean11952 setMaxTTL (clojure.core/long v11954))))
   (clojure.core/let
    [v11954
     (:viewer-protocol-policy
      m11953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (.
      bean11952
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v11954))))
   (clojure.core/let
    [v11954
     (:target-origin-id
      m11953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (. bean11952 setTargetOriginId (clojure.core/str v11954))))
   (clojure.core/let
    [v11954
     (:default-ttl m11953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (. bean11952 setDefaultTTL (clojure.core/long v11954))))
   (clojure.core/let
    [v11954
     (:compress m11953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (. bean11952 setCompress (clojure.core/boolean v11954))))
   (clojure.core/let
    [v11954
     (:allowed-methods
      m11953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (.
      bean11952
      setAllowedMethods
      (cloudfront/allowed-methods v11954))))
   (clojure.core/let
    [v11954
     (:min-ttl m11953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11954 :com.palletops.awaze.client-builder/undef)
     (. bean11952 setMinTTL (clojure.core/long v11954))))
   bean11952))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m11956]
  (clojure.core/let
   [bean11955
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/let
    [v11957
     (:quantity m11956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11957 :com.palletops.awaze.client-builder/undef)
     (. bean11955 setQuantity (clojure.core/int v11957))))
   (clojure.core/let
    [v11957 (:items m11956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11957 :com.palletops.awaze.client-builder/undef)
     (.
      bean11955
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12069] (cloudfront/cache-behavior arg12069))
 v11957))))
   bean11955))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m11959]
  (clojure.core/let
   [bean11958
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/let
    [v11960
     (:cloud-front-default-certificate
      m11959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (.
      bean11958
      setCloudFrontDefaultCertificate
      (clojure.core/boolean v11960))))
   (clojure.core/let
    [v11960
     (:iamcertificate-id
      m11959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (. bean11958 setIAMCertificateId (clojure.core/str v11960))))
   (clojure.core/let
    [v11960
     (:acmcertificate-arn
      m11959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (. bean11958 setACMCertificateArn (clojure.core/str v11960))))
   (clojure.core/let
    [v11960
     (:sslsupport-method
      m11959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (. bean11958 setSSLSupportMethod (clojure.core/str v11960))))
   (clojure.core/let
    [v11960
     (:minimum-protocol-version
      m11959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (.
      bean11958
      setMinimumProtocolVersion
      (cloudfront/minimum-protocol-version v11960))))
   (clojure.core/let
    [v11960
     (:certificate m11959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (. bean11958 setCertificate (clojure.core/str v11960))))
   (clojure.core/let
    [v11960
     (:certificate-source
      m11959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11960 :com.palletops.awaze.client-builder/undef)
     (. bean11958 setCertificateSource (clojure.core/str v11960))))
   bean11958))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m11962]
  (clojure.core/let
   [bean11961 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/let
    [v11963
     (:quantity m11962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11963 :com.palletops.awaze.client-builder/undef)
     (. bean11961 setQuantity (clojure.core/int v11963))))
   (clojure.core/let
    [v11963 (:items m11962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11963 :com.palletops.awaze.client-builder/undef)
     (.
      bean11961
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12070] (clojure.core/str arg12070))
 v11963))))
   bean11961))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m11965]
  (clojure.core/let
   [bean11964 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/let
    [v11966
     (:quantity m11965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11966 :com.palletops.awaze.client-builder/undef)
     (. bean11964 setQuantity (clojure.core/int v11966))))
   (clojure.core/let
    [v11966 (:items m11965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11966 :com.palletops.awaze.client-builder/undef)
     (.
      bean11964
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12071] (cloudfront/origin arg12071))
 v11966))))
   bean11964))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m11968]
  (clojure.core/let
   [bean11967
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/let
    [v11969
     (:bucket m11968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11969 :com.palletops.awaze.client-builder/undef)
     (. bean11967 setBucket (clojure.core/str v11969))))
   (clojure.core/let
    [v11969
     (:prefix m11968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11969 :com.palletops.awaze.client-builder/undef)
     (. bean11967 setPrefix (clojure.core/str v11969))))
   (clojure.core/let
    [v11969
     (:enabled m11968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11969 :com.palletops.awaze.client-builder/undef)
     (. bean11967 setEnabled (clojure.core/boolean v11969))))
   (clojure.core/let
    [v11969
     (:include-cookies
      m11968
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11969 :com.palletops.awaze.client-builder/undef)
     (. bean11967 setIncludeCookies (clojure.core/boolean v11969))))
   bean11967))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m11971]
  (clojure.core/let
   [bean11970
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/let
    [v11972
     (:quantity m11971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11972 :com.palletops.awaze.client-builder/undef)
     (. bean11970 setQuantity (clojure.core/int v11972))))
   (clojure.core/let
    [v11972 (:items m11971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11972 :com.palletops.awaze.client-builder/undef)
     (.
      bean11970
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12072]
  (cloudfront/custom-error-response arg12072))
 v11972))))
   bean11970))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m11974]
  (clojure.core/let
   [bean11973
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/let
    [v11975
     (:bucket m11974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11975 :com.palletops.awaze.client-builder/undef)
     (. bean11973 setBucket (clojure.core/str v11975))))
   (clojure.core/let
    [v11975
     (:prefix m11974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11975 :com.palletops.awaze.client-builder/undef)
     (. bean11973 setPrefix (clojure.core/str v11975))))
   (clojure.core/let
    [v11975
     (:enabled m11974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11975 :com.palletops.awaze.client-builder/undef)
     (. bean11973 setEnabled (clojure.core/boolean v11975))))
   bean11973))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.PriceClass}
price-class
  [m11977]
  (.
   com.amazonaws.services.cloudfront.model.PriceClass
   fromValue
   (clojure.core/name m11977)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m11980]
  (clojure.core/let
   [bean11979 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/let
    [v11981
     (:domain-name m11980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11981 :com.palletops.awaze.client-builder/undef)
     (. bean11979 setDomainName (clojure.core/str v11981))))
   (clojure.core/let
    [v11981
     (:origin-access-identity
      m11980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11981 :com.palletops.awaze.client-builder/undef)
     (. bean11979 setOriginAccessIdentity (clojure.core/str v11981))))
   bean11979))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m11983]
  (clojure.core/let
   [bean11982
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/let
    [v11984 (:paths m11983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11984 :com.palletops.awaze.client-builder/undef)
     (. bean11982 setPaths (cloudfront/paths v11984))))
   (clojure.core/let
    [v11984
     (:caller-reference
      m11983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11984 :com.palletops.awaze.client-builder/undef)
     (. bean11982 setCallerReference (clojure.core/str v11984))))
   bean11982))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m11986]
  (clojure.core/let
   [bean11985
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/let
    [v11987
     (:restrictions m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setRestrictions (cloudfront/restrictions v11987))))
   (clojure.core/let
    [v11987
     (:default-root-object
      m11986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setDefaultRootObject (clojure.core/str v11987))))
   (clojure.core/let
    [v11987
     (:default-cache-behavior
      m11986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (.
      bean11985
      setDefaultCacheBehavior
      (cloudfront/default-cache-behavior v11987))))
   (clojure.core/let
    [v11987
     (:comment m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setComment (clojure.core/str v11987))))
   (clojure.core/let
    [v11987
     (:cache-behaviors
      m11986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (.
      bean11985
      setCacheBehaviors
      (cloudfront/cache-behaviors v11987))))
   (clojure.core/let
    [v11987
     (:viewer-certificate
      m11986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (.
      bean11985
      setViewerCertificate
      (cloudfront/viewer-certificate v11987))))
   (clojure.core/let
    [v11987
     (:aliases m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setAliases (cloudfront/aliases v11987))))
   (clojure.core/let
    [v11987
     (:enabled m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setEnabled (clojure.core/boolean v11987))))
   (clojure.core/let
    [v11987
     (:price-class m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setPriceClass (clojure.core/str v11987))))
   (clojure.core/let
    [v11987
     (:origins m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setOrigins (cloudfront/origins v11987))))
   (clojure.core/let
    [v11987
     (:caller-reference
      m11986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setCallerReference (clojure.core/str v11987))))
   (clojure.core/let
    [v11987
     (:logging m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setLogging (cloudfront/logging-config v11987))))
   (clojure.core/let
    [v11987
     (:web-aclid m11986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (. bean11985 setWebACLId (clojure.core/str v11987))))
   (clojure.core/let
    [v11987
     (:custom-error-responses
      m11986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11987 :com.palletops.awaze.client-builder/undef)
     (.
      bean11985
      setCustomErrorResponses
      (cloudfront/custom-error-responses v11987))))
   bean11985))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m11989]
  (clojure.core/let
   [bean11988
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/let
    [v11990
     (:comment m11989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11990 :com.palletops.awaze.client-builder/undef)
     (. bean11988 setComment (clojure.core/str v11990))))
   (clojure.core/let
    [v11990
     (:caller-reference
      m11989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11990 :com.palletops.awaze.client-builder/undef)
     (. bean11988 setCallerReference (clojure.core/str v11990))))
   bean11988))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m11992]
  (clojure.core/let
   [bean11991
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/let
    [v11993
     (:enabled m11992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (. bean11991 setEnabled (clojure.core/boolean v11993))))
   (clojure.core/let
    [v11993
     (:comment m11992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (. bean11991 setComment (clojure.core/str v11993))))
   (clojure.core/let
    [v11993
     (:aliases m11992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (. bean11991 setAliases (cloudfront/aliases v11993))))
   (clojure.core/let
    [v11993
     (:logging m11992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (.
      bean11991
      setLogging
      (cloudfront/streaming-logging-config v11993))))
   (clojure.core/let
    [v11993
     (:price-class m11992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (. bean11991 setPriceClass (cloudfront/price-class v11993))))
   (clojure.core/let
    [v11993
     (:s3origin m11992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (. bean11991 setS3Origin (cloudfront/s3origin v11993))))
   (clojure.core/let
    [v11993
     (:trusted-signers
      m11992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (.
      bean11991
      setTrustedSigners
      (cloudfront/trusted-signers v11993))))
   (clojure.core/let
    [v11993
     (:caller-reference
      m11992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11993 :com.palletops.awaze.client-builder/undef)
     (. bean11991 setCallerReference (clojure.core/str v11993))))
   bean11991))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m11995]
  (clojure.core/let
   [bean11994
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/let
    [v11996 (:id m11995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11996 :com.palletops.awaze.client-builder/undef)
     (. bean11994 setId (clojure.core/str v11996))))
   bean11994))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m11998]
  (clojure.core/let
   [bean11997
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/let
    [v11999
     (:distribution-id
      m11998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11999 :com.palletops.awaze.client-builder/undef)
     (. bean11997 setDistributionId (clojure.core/str v11999))))
   (clojure.core/let
    [v11999
     (:invalidation-batch
      m11998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11999 :com.palletops.awaze.client-builder/undef)
     (.
      bean11997
      setInvalidationBatch
      (cloudfront/invalidation-batch v11999))))
   bean11997))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m12001]
  (clojure.core/let
   [bean12000
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/let
    [v12002 (:id m12001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12002 :com.palletops.awaze.client-builder/undef)
     (. bean12000 setId (clojure.core/str v12002))))
   (clojure.core/let
    [v12002
     (:if-match m12001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12002 :com.palletops.awaze.client-builder/undef)
     (. bean12000 setIfMatch (clojure.core/str v12002))))
   bean12000))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m12004]
  (clojure.core/let
   [bean12003
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12005 (:id m12004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12005 :com.palletops.awaze.client-builder/undef)
     (. bean12003 setId (clojure.core/str v12005))))
   (clojure.core/let
    [v12005
     (:if-match m12004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12005 :com.palletops.awaze.client-builder/undef)
     (. bean12003 setIfMatch (clojure.core/str v12005))))
   bean12003))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m12007]
  (clojure.core/let
   [bean12006
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/let
    [v12008
     (:distribution-config
      m12007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12008 :com.palletops.awaze.client-builder/undef)
     (.
      bean12006
      setDistributionConfig
      (cloudfront/distribution-config v12008))))
   bean12006))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m12010]
  (clojure.core/let
   [bean12009
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/let
    [v12011
     (:max-items m12010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12011 :com.palletops.awaze.client-builder/undef)
     (. bean12009 setMaxItems (clojure.core/str v12011))))
   (clojure.core/let
    [v12011
     (:marker m12010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12011 :com.palletops.awaze.client-builder/undef)
     (. bean12009 setMarker (clojure.core/str v12011))))
   (clojure.core/let
    [v12011
     (:distribution-id
      m12010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12011 :com.palletops.awaze.client-builder/undef)
     (. bean12009 setDistributionId (clojure.core/str v12011))))
   bean12009))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m12013]
  (clojure.core/let
   [bean12012
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/let
    [v12014
     (:max-items m12013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12014 :com.palletops.awaze.client-builder/undef)
     (. bean12012 setMaxItems (clojure.core/str v12014))))
   (clojure.core/let
    [v12014
     (:marker m12013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12014 :com.palletops.awaze.client-builder/undef)
     (. bean12012 setMarker (clojure.core/str v12014))))
   bean12012))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m12016]
  (clojure.core/let
   [bean12015
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/let
    [v12017 (:id m12016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12017 :com.palletops.awaze.client-builder/undef)
     (. bean12015 setId (clojure.core/str v12017))))
   bean12015))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m12019]
  (clojure.core/let
   [bean12018
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/let
    [v12020
     (:max-items m12019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12020 :com.palletops.awaze.client-builder/undef)
     (. bean12018 setMaxItems (clojure.core/str v12020))))
   (clojure.core/let
    [v12020
     (:marker m12019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12020 :com.palletops.awaze.client-builder/undef)
     (. bean12018 setMarker (clojure.core/str v12020))))
   bean12018))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m12022]
  (clojure.core/let
   [bean12021
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12023
     (:cloud-front-origin-access-identity-config
      m12022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12023 :com.palletops.awaze.client-builder/undef)
     (.
      bean12021
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12023))))
   bean12021))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m12025]
  (clojure.core/let
   [bean12024
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/let
    [v12026 (:id m12025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12026 :com.palletops.awaze.client-builder/undef)
     (. bean12024 setId (clojure.core/str v12026))))
   (clojure.core/let
    [v12026
     (:if-match m12025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12026 :com.palletops.awaze.client-builder/undef)
     (. bean12024 setIfMatch (clojure.core/str v12026))))
   (clojure.core/let
    [v12026
     (:streaming-distribution-config
      m12025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12026 :com.palletops.awaze.client-builder/undef)
     (.
      bean12024
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12026))))
   bean12024))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest}
list-distributions-by-web-aclid-request
  [m12028]
  (clojure.core/let
   [bean12027
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest)]
   (clojure.core/let
    [v12029
     (:max-items m12028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12029 :com.palletops.awaze.client-builder/undef)
     (. bean12027 setMaxItems (clojure.core/str v12029))))
   (clojure.core/let
    [v12029
     (:marker m12028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12029 :com.palletops.awaze.client-builder/undef)
     (. bean12027 setMarker (clojure.core/str v12029))))
   (clojure.core/let
    [v12029
     (:web-aclid m12028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12029 :com.palletops.awaze.client-builder/undef)
     (. bean12027 setWebACLId (clojure.core/str v12029))))
   bean12027))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m12031]
  (clojure.core/let
   [bean12030
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/let
    [v12032
     (:max-items m12031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12032 :com.palletops.awaze.client-builder/undef)
     (. bean12030 setMaxItems (clojure.core/str v12032))))
   (clojure.core/let
    [v12032
     (:marker m12031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12032 :com.palletops.awaze.client-builder/undef)
     (. bean12030 setMarker (clojure.core/str v12032))))
   bean12030))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m12034]
  (clojure.core/let
   [bean12033
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/let
    [v12035 (:id m12034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12035 :com.palletops.awaze.client-builder/undef)
     (. bean12033 setId (clojure.core/str v12035))))
   bean12033))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m12037]
  (clojure.core/let
   [bean12036
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/let
    [v12038 (:id m12037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12038 :com.palletops.awaze.client-builder/undef)
     (. bean12036 setId (clojure.core/str v12038))))
   (clojure.core/let
    [v12038
     (:if-match m12037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12038 :com.palletops.awaze.client-builder/undef)
     (. bean12036 setIfMatch (clojure.core/str v12038))))
   bean12036))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m12040]
  (clojure.core/let
   [bean12039
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/let
    [v12041 (:id m12040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12041 :com.palletops.awaze.client-builder/undef)
     (. bean12039 setId (clojure.core/str v12041))))
   bean12039))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m12043]
  (clojure.core/let
   [bean12042
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/let
    [v12044 (:id m12043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12044 :com.palletops.awaze.client-builder/undef)
     (. bean12042 setId (clojure.core/str v12044))))
   (clojure.core/let
    [v12044
     (:distribution-config
      m12043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12044 :com.palletops.awaze.client-builder/undef)
     (.
      bean12042
      setDistributionConfig
      (cloudfront/distribution-config v12044))))
   (clojure.core/let
    [v12044
     (:if-match m12043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12044 :com.palletops.awaze.client-builder/undef)
     (. bean12042 setIfMatch (clojure.core/str v12044))))
   bean12042))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m12046]
  (clojure.core/let
   [bean12045
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12047 (:id m12046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12047 :com.palletops.awaze.client-builder/undef)
     (. bean12045 setId (clojure.core/str v12047))))
   bean12045))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m12049]
  (clojure.core/let
   [bean12048
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/let
    [v12050 (:id m12049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12050 :com.palletops.awaze.client-builder/undef)
     (. bean12048 setId (clojure.core/str v12050))))
   bean12048))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m12052]
  (clojure.core/let
   [bean12051
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12053 (:id m12052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12053 :com.palletops.awaze.client-builder/undef)
     (. bean12051 setId (clojure.core/str v12053))))
   (clojure.core/let
    [v12053
     (:cloud-front-origin-access-identity-config
      m12052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12053 :com.palletops.awaze.client-builder/undef)
     (.
      bean12051
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12053))))
   (clojure.core/let
    [v12053
     (:if-match m12052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12053 :com.palletops.awaze.client-builder/undef)
     (. bean12051 setIfMatch (clojure.core/str v12053))))
   bean12051))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m12055]
  (clojure.core/let
   [bean12054
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/let
    [v12056
     (:streaming-distribution-config
      m12055
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12056 :com.palletops.awaze.client-builder/undef)
     (.
      bean12054
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12056))))
   bean12054))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m12058]
  (clojure.core/let
   [bean12057
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/let
    [v12059 (:id m12058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12059 :com.palletops.awaze.client-builder/undef)
     (. bean12057 setId (clojure.core/str v12059))))
   (clojure.core/let
    [v12059
     (:distribution-id
      m12058
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12059 :com.palletops.awaze.client-builder/undef)
     (. bean12057 setDistributionId (clojure.core/str v12059))))
   bean12057))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1816__auto__] (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m12073]
   (clojure.core/let
    [credentials12074 (:credentials m12073) args12075 (:args m12073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12076
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12074)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12076
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args12075 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials12078 & args12079]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12080
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12078)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12080
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args12079 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m12081]
   (clojure.core/let
    [credentials12082 (:credentials m12081) args12083 (:args m12081)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12084
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12082)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12084
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args12083 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-invalidation,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInvalidation"}
   [credentials12086 & args12087]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12088
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12086)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12088
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args12087 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m12089]
   (clojure.core/let
    [credentials12090 (:credentials m12089) args12091 (:args m12089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12092
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12090)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12092
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args12091 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDistribution"}
   [credentials12094 & args12095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12096
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12094)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12096
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args12095 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m12097]
   (clojure.core/let
    [credentials12098 (:credentials m12097) args12099 (:args m12097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12100
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12098)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12100
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args12099 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials12102 & args12103]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12104
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12102)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12104
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args12103 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m12105]
   (clojure.core/let
    [credentials12106 (:credentials m12105) args12107 (:args m12105)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12108
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12106)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12108
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args12107 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDistribution"}
   [credentials12110 & args12111]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12112
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12110)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12112
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args12111 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m12113]
   (clojure.core/let
    [credentials12114 (:credentials m12113) args12115 (:args m12113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12116
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12114)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12116
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args12115 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-invalidations,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInvalidations"}
   [credentials12118 & args12119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12120
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12118)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12120
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args12119 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m12121]
   (clojure.core/let
    [credentials12122 (:credentials m12121) args12123 (:args m12121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12124
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12122)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12124
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args12123 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-streaming-distributions,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials12126 & args12127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12128
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12126)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12128
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args12127 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m12129]
   (clojure.core/let
    [credentials12130 (:credentials m12129) args12131 (:args m12129)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12132
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12130)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12132
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args12131 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials12134 & args12135]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12136
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12134)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12136
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args12135 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m12137]
   (clojure.core/let
    [credentials12138 (:credentials m12137) args12139 (:args m12137)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12140
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12138)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12140
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args12139 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-distributions,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributions"}
   [credentials12142 & args12143]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12144
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12142)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12144
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args12143 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m12145]
   (clojure.core/let
    [credentials12146 (:credentials m12145) args12147 (:args m12145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12148
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12146)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12148
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args12147 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials12150 & args12151]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12152
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12150)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12152
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args12151 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m12153]
   (clojure.core/let
    [credentials12154 (:credentials m12153) args12155 (:args m12153)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12156
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12154)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12156
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args12155 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-streaming-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials12158 & args12159]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12160
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12158)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12160
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args12159 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions-by-web-aclid
   [m12161]
   (clojure.core/let
    [credentials12162 (:credentials m12161) args12163 (:args m12161)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12164
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12162)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12164
       listDistributionsByWebACLId
       (cloudfront/list-distributions-by-web-aclid-request
        (clojure.core/nth args12163 0)))))))
  (clojure.core/defn
   list-distributions-by-web-aclid-map
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributionsByWebACLId"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-distributions-by-web-aclid,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions-by-web-aclid
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributionsByWebACLId"}
   [credentials12166 & args12167]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12168
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12166)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12168
      listDistributionsByWebACLId
      (cloudfront/list-distributions-by-web-aclid-request
       (clojure.core/nth args12167 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m12169]
   (clojure.core/let
    [credentials12170 (:credentials m12169) args12171 (:args m12169)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12172
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12170)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12172
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args12171 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials12174 & args12175]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12176
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12174)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12176
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args12175 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m12177]
   (clojure.core/let
    [credentials12178 (:credentials m12177) args12179 (:args m12177)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12180
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12178)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12180
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args12179 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistribution"}
   [credentials12182 & args12183]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12184
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12182)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12184
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args12183 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m12185]
   (clojure.core/let
    [credentials12186 (:credentials m12185) args12187 (:args m12185)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12188
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12186)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12188
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args12187 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-streaming-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials12190 & args12191]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12192
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12190)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12192
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args12191 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m12193]
   (clojure.core/let
    [credentials12194 (:credentials m12193) args12195 (:args m12193)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12196
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12194)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12196
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args12195 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-distribution-config,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistributionConfig"}
   [credentials12198 & args12199]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12200
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12198)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12200
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args12199 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m12201]
   (clojure.core/let
    [credentials12202 (:credentials m12201) args12203 (:args m12201)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12204
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12202)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12204
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args12203 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateDistribution"}
   [credentials12206 & args12207]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12208
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12206)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12208
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args12207 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m12209]
   (clojure.core/let
    [credentials12210 (:credentials m12209) args12211 (:args m12209)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12212
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12210)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12212
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args12211 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials12214 & args12215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12216
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12214)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12216
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args12215 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m12217]
   (clojure.core/let
    [credentials12218 (:credentials m12217) args12219 (:args m12217)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12220
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12218)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12220
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args12219 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution-config,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials12222 & args12223]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12224
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12222)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12224
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args12223 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m12225]
   (clojure.core/let
    [credentials12226 (:credentials m12225) args12227 (:args m12225)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12228
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12226)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12228
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args12227 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials12230 & args12231]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12232
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12230)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12232
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args12231 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m12233]
   (clojure.core/let
    [credentials12234 (:credentials m12233) args12235 (:args m12233)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12236
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12234)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12236
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args12235 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-streaming-distribution,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials12238 & args12239]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12240
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12238)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12240
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args12239 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m12241]
   (clojure.core/let
    [credentials12242 (:credentials m12241) args12243 (:args m12241)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12244
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12242)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12244
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args12243 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-invalidation,
     :credentials credentials__1784__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInvalidation"}
   [credentials12246 & args12247]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12248
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12246)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12248
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args12247 0))))))))
